// Copyright 2018 The Prometheus Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// +build dev

package asset

import (
	"go/build"
	"log"
	"net/http"
	"os"
	"strings"

	"github.com/shurcooL/httpfs/filter"
	"github.com/shurcooL/httpfs/union"
)

func importPathToDir(importPath string) string {
	p, err := build.Import(importPath, "", build.FindOnly)
	if err != nil {
		log.Fatalln(err)
	}
	return p.Dir
}

var static http.FileSystem = filter.Keep(
	http.Dir(importPathToDir("github.com/prometheus/alertmanager/ui/app")),
	func(path string, fi os.FileInfo) bool {
		return path == "/" ||
			path == "/script.js" ||
			path == "/index.html" ||
			path == "/favicon.ico" ||
			strings.HasPrefix(path, "/lib")
	},
)

var templates http.FileSystem = filter.Keep(
	http.Dir(importPathToDir("github.com/prometheus/alertmanager/template")),
	func(path string, fi os.FileInfo) bool {
		return path == "/" || path == "/default.tmpl"
	},
)

// Assets contains the project's assets.
var Assets http.FileSystem = union.New(map[string]http.FileSystem{
	"/templates": templates,
	"/static":    static,
})
