+++
title = "HTTP API"
description = "Grafana HTTP API"
keywords = ["grafana", "http", "documentation", "api", "overview"]
aliases = ["/http_api/overview"]
type = "docs"
[menu.docs]
name = "HTTP API"
identifier = "http_api"
weight = 9
+++


# HTTP API Reference

The Grafana backend exposes an HTTP API, the same API is used by the frontend to do everything from saving
dashboards, creating users and updating data sources.

## Supported HTTP APIs:


* [Authentication API]({{< relref "http_api/auth.md" >}})
* [Dashboard API]({{< relref "http_api/dashboard.md" >}})
* [Dashboard Versions API]({{< relref "http_api/dashboard_versions.md" >}})
* [Dashboard Permissions API]({{< relref "http_api/dashboard_permissions.md" >}})
* [Folder API]({{< relref "http_api/folder.md" >}})
* [Folder Permissions API]({{< relref "http_api/folder_permissions.md" >}})
* [Folder/dashboard search API]({{< relref "http_api/folder_dashboard_search.md" >}})
* [Data Source API]({{< relref "http_api/data_source.md" >}})
* [Organization API]({{< relref "http_api/org.md" >}})
* [Snapshot API]({{< relref "http_api/snapshot.md" >}})
* [Annotations API]({{< relref "http_api/annotations.md" >}})
* [Alerting API]({{< relref "http_api/alerting.md" >}})
* [Alert Notification Channels API]({{< relref "http_api/alerting_notification_channels.md" >}})
* [User API]({{< relref "http_api/user.md" >}})
* [Team API]({{< relref "http_api/team.md" >}})
* [Admin API]({{< relref "http_api/admin.md" >}})
* [Preferences API]({{< relref "http_api/preferences.md" >}})
* [Other API]({{< relref "http_api/other.md" >}})
