+++
title = "Grafana documentation"
description = "Guides, Installation & Feature Documentation"
keywords = ["grafana", "installation", "documentation"]
type = "docs"
aliases = ["/v1.1", "/guides/reference/admin", "/v3.1"]
+++

# Grafana Documentation

<h2>Installing Grafana</h2>
<div class="nav-cards">
    <a href="{{< relref "installation/debian.md" >}}" class="nav-cards__item nav-cards__item--install">
        <div class="nav-cards__icon fa fa-linux">
        </div>
        <h5>Installing on Linux</h5>
    </a>
    <a href="{{< relref "installation/mac.md" >}}" class="nav-cards__item nav-cards__item--install">
        <div class="nav-cards__icon fa fa-apple">
        </div>
        <h5>Installing on Mac OS X</h5>
    </a>
      <a href="{{< relref "installation/windows.md" >}}" class="nav-cards__item nav-cards__item--install">
        <div class="nav-cards__icon fa fa-windows">
        </div>
        <h5>Installing on Windows</h5>
    </a>
    <a href="https://grafana.com/cloud/grafana" class="nav-cards__item nav-cards__item--install">
        <div class="nav-cards__icon fa fa-cloud">
        </div>
        <h5>Grafana Cloud</h5>
    </a>
    <a href="https://grafana.com/grafana/download" class="nav-cards__item nav-cards__item--install">
        <div class="nav-cards__icon fa fa-moon-o">
        </div>
        <h5>Nightly Builds</h5>
    </a>
    <div class="nav-cards__item nav-cards__item--install">
        <h5>For other platforms Read the <a href="{{< relref "project/building_from_source.md" >}}">build from source</a>
        instructions for more information.</h5>
    </div>
</div>

<h2>Guides</h2>

<div class="nav-cards">
    <a href="https://grafana.com/grafana" class="nav-cards__item nav-cards__item--guide">
        <h4>What is Grafana?</h4>
        <p>Grafana feature highlights.</p>
    </a>
    <a href="{{< relref "installation/configuration.md" >}}" class="nav-cards__item nav-cards__item--guide">
        <h4>Configure Grafana</h4>
        <p>Article on all the Grafana configuration and setup options.</p>
    </a>
    <a href="{{< relref "guides/getting_started.md" >}}" class="nav-cards__item nav-cards__item--guide">
        <h4>Getting Started</h4>
        <p>A guide that walks you through the basics of using Grafana</p>
    </a>
    <a href="{{< relref "administration/provisioning.md" >}}" class="nav-cards__item nav-cards__item--guide">
        <h4>Provisioning</h4>
        <p>A guide to help you automate your Grafana setup & configuration.</p>
    </a>
    <a href="{{< relref "guides/whats-new-in-v6-3.md" >}}" class="nav-cards__item nav-cards__item--guide">
        <h4>What's new in v6.3</h4>
        <p>Article on all the new cool features and enhancements in v6.3</p>
    </a>
    <a href="{{< relref "tutorials/screencasts.md" >}}" class="nav-cards__item nav-cards__item--guide">
        <h4>Screencasts</h4>
        <p>Video tutorials & guides</p>
    </a>
</div>

<h2>Data Source Guides</h2>
<div class="nav-cards">
    <a href="{{< relref "features/datasources/graphite.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_graphite.svg" >
      <h5>Graphite</h5>
    </a>
    <a href="{{< relref "features/datasources/elasticsearch.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_elasticsearch.svg" >
      <h5>Elasticsearch</h5>
    </a>
    <a href="{{< relref "features/datasources/influxdb.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_influxdb.svg" >
      <h5>InfluxDB</h5>
    </a>
    <a href="{{< relref "features/datasources/prometheus.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_prometheus.svg" >
      <h5>Prometheus</h5>
    </a>
    <a href="{{< relref "features/datasources/stackdriver.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_stackdriver.svg">
      <h5>Google Stackdriver</h5>
    </a>
    <a href="{{< relref "features/datasources/cloudwatch.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_cloudwatch.svg">
      <h5>AWS CloudWatch</h5>
    </a>
    <a href="{{< relref "features/datasources/azuremonitor.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_azure_monitor.jpg">
      <h5>Azure Monitor</h5>
    </a>
    <a href="{{< relref "features/datasources/loki.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_loki.svg">
      <h5>Loki</h5>
    </a>
    <a href="{{< relref "features/datasources/mysql.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_mysql.png" >
      <h5>MySQL</h5>
    </a>
    <a href="{{< relref "features/datasources/postgres.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_postgres.svg" >
      <h5>Postgres</h5>
    </a>
    <a href="{{< relref "features/datasources/mssql.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/sql_server_logo.svg">
      <h5>Microsoft SQL Server</h5>
    </a>
    <a href="{{< relref "features/datasources/opentsdb.md" >}}" class="nav-cards__item nav-cards__item--ds">
      <img src="/img/docs/logos/icon_opentsdb.png" >
      <h5>OpenTSDB</h5>
    </a>
</div>
