// Code generated by "go run msg_generate.go"; DO NOT EDIT.

package dns

// pack*() functions

func (rr *A) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataA(rr.A, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *AAAA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataAAAA(rr.AAAA, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *AFSDB) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Subtype, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Hostname, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *ANY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *AVC) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringTxt(rr.Txt, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CAA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Flag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Tag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringOctet(rr.Value, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CDNSKEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Protocol, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CDS) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.DigestType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Digest, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CERT) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Type, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.Certificate, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CNAME) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Target, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *CSYNC) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Serial, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataNsec(rr.TypeBitMap, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *DHCID) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.Digest, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *DLV) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.DigestType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Digest, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *DNAME) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Target, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *DNSKEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Protocol, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *DS) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.DigestType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Digest, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *EID) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Endpoint, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *EUI48) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint48(rr.Address, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *EUI64) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint64(rr.Address, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *GID) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Gid, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *GPOS) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Longitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Latitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Altitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *HINFO) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Cpu, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Os, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *HIP) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.HitLength, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.PublicKeyAlgorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.PublicKeyLength, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Hit, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataDomainNames(rr.RendezvousServers, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *KEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Protocol, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *KX) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Exchanger, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *L32) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataA(rr.Locator32, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *L64) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint64(rr.Locator64, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *LOC) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Version, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Size, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.HorizPre, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.VertPre, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Latitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Longitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Altitude, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *LP) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Fqdn, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MB) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mb, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MD) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Md, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MF) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mf, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MG) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mg, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MINFO) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Rmail, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Email, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MR) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mr, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *MX) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mx, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NAPTR) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Order, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Service, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Regexp, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Replacement, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NID) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint64(rr.NodeID, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NIMLOC) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Locator, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NINFO) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringTxt(rr.ZSData, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NS) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Ns, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NSAPPTR) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Ptr, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NSEC) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.NextDomain, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataNsec(rr.TypeBitMap, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NSEC3) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Hash, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Iterations, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.SaltLength, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	// Only pack salt if value is not "-", i.e. empty
	if rr.Salt != "-" {
		off, err = packStringHex(rr.Salt, msg, off)
		if err != nil {
			return headerEnd, off, err
		}
	}
	off, err = packUint8(rr.HashLength, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase32(rr.NextDomain, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataNsec(rr.TypeBitMap, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *NSEC3PARAM) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Hash, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Iterations, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.SaltLength, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	// Only pack salt if value is not "-", i.e. empty
	if rr.Salt != "-" {
		off, err = packStringHex(rr.Salt, msg, off)
		if err != nil {
			return headerEnd, off, err
		}
	}
	return headerEnd, off, nil
}

func (rr *OPENPGPKEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *OPT) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packDataOpt(rr.Option, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *PTR) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Ptr, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *PX) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Map822, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mapx400, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *RFC3597) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Rdata, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *RKEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Flags, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Protocol, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.PublicKey, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *RP) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mbox, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Txt, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *RRSIG) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.TypeCovered, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Labels, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.OrigTtl, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Expiration, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Inception, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.SignerName, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.Signature, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *RT) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Preference, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Host, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SIG) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.TypeCovered, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Labels, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.OrigTtl, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Expiration, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Inception, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.SignerName, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringBase64(rr.Signature, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SMIMEA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Usage, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Selector, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.MatchingType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Certificate, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SOA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Ns, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Mbox, msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Serial, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Refresh, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Retry, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Expire, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Minttl, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SPF) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringTxt(rr.Txt, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SRV) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Priority, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Weight, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Port, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Target, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *SSHFP) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Type, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.FingerPrint, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeyTag, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Algorithm, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.DigestType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Digest, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TALINK) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.PreviousName, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.NextName, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TKEY) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Algorithm, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Inception, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Expiration, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Mode, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Error, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.KeySize, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Key, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.OtherLen, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.OtherData, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TLSA) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Usage, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.Selector, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint8(rr.MatchingType, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.Certificate, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TSIG) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, _, err = packDomainName(rr.Algorithm, msg, off, compression, false)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint48(rr.TimeSigned, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Fudge, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.MACSize, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.MAC, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.OrigId, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Error, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.OtherLen, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringHex(rr.OtherData, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *TXT) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringTxt(rr.Txt, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *UID) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint32(rr.Uid, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *UINFO) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.Uinfo, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *URI) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Priority, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packUint16(rr.Weight, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packStringOctet(rr.Target, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

func (rr *X25) pack(msg []byte, off int, compression compressionMap, compress bool) (int, int, error) {
	headerEnd, off, err := rr.Hdr.pack(msg, off, compression, compress)
	if err != nil {
		return headerEnd, off, err
	}
	off, err = packString(rr.PSDNAddress, msg, off)
	if err != nil {
		return headerEnd, off, err
	}
	return headerEnd, off, nil
}

// unpack*() functions

func unpackA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(A)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.A, off, err = unpackDataA(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackAAAA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(AAAA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.AAAA, off, err = unpackDataAAAA(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackAFSDB(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(AFSDB)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Subtype, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Hostname, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackANY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(ANY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	return rr, off, err
}

func unpackAVC(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(AVC)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Txt, off, err = unpackStringTxt(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCAA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CAA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Flag, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Tag, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Value, off, err = unpackStringOctet(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCDNSKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CDNSKEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Flags, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Protocol, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKey, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCDS(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CDS)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.DigestType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Digest, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCERT(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CERT)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Type, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Certificate, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCNAME(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CNAME)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Target, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackCSYNC(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(CSYNC)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Serial, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Flags, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.TypeBitMap, off, err = unpackDataNsec(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackDHCID(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(DHCID)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Digest, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackDLV(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(DLV)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.DigestType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Digest, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackDNAME(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(DNAME)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Target, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackDNSKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(DNSKEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Flags, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Protocol, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKey, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackDS(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(DS)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.DigestType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Digest, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackEID(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(EID)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Endpoint, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackEUI48(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(EUI48)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Address, off, err = unpackUint48(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackEUI64(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(EUI64)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Address, off, err = unpackUint64(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackGID(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(GID)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Gid, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackGPOS(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(GPOS)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Longitude, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Latitude, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Altitude, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackHINFO(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(HINFO)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Cpu, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Os, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackHIP(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(HIP)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.HitLength, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKeyAlgorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKeyLength, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Hit, off, err = unpackStringHex(msg, off, off+int(rr.HitLength))
	if err != nil {
		return rr, off, err
	}
	rr.PublicKey, off, err = unpackStringBase64(msg, off, off+int(rr.PublicKeyLength))
	if err != nil {
		return rr, off, err
	}
	rr.RendezvousServers, off, err = unpackDataDomainNames(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(KEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Flags, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Protocol, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKey, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackKX(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(KX)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Exchanger, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackL32(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(L32)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Locator32, off, err = unpackDataA(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackL64(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(L64)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Locator64, off, err = unpackUint64(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackLOC(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(LOC)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Version, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Size, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.HorizPre, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.VertPre, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Latitude, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Longitude, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Altitude, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackLP(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(LP)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Fqdn, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMB(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MB)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Mb, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMD(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MD)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Md, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMF(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MF)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Mf, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMG(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MG)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Mg, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMINFO(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MINFO)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Rmail, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Email, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMR(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MR)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Mr, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackMX(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(MX)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Mx, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNAPTR(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NAPTR)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Order, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Flags, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Service, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Regexp, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Replacement, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNID(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NID)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.NodeID, off, err = unpackUint64(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNIMLOC(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NIMLOC)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Locator, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNINFO(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NINFO)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.ZSData, off, err = unpackStringTxt(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNS(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NS)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Ns, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNSAPPTR(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NSAPPTR)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Ptr, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNSEC(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NSEC)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.NextDomain, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.TypeBitMap, off, err = unpackDataNsec(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNSEC3(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NSEC3)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Hash, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Flags, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Iterations, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.SaltLength, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Salt, off, err = unpackStringHex(msg, off, off+int(rr.SaltLength))
	if err != nil {
		return rr, off, err
	}
	rr.HashLength, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.NextDomain, off, err = unpackStringBase32(msg, off, off+int(rr.HashLength))
	if err != nil {
		return rr, off, err
	}
	rr.TypeBitMap, off, err = unpackDataNsec(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackNSEC3PARAM(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(NSEC3PARAM)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Hash, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Flags, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Iterations, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.SaltLength, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Salt, off, err = unpackStringHex(msg, off, off+int(rr.SaltLength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackOPENPGPKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(OPENPGPKEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.PublicKey, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackOPT(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(OPT)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Option, off, err = unpackDataOpt(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackPTR(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(PTR)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Ptr, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackPX(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(PX)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Map822, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Mapx400, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackRFC3597(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(RFC3597)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Rdata, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackRKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(RKEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Flags, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Protocol, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.PublicKey, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackRP(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(RP)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Mbox, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Txt, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackRRSIG(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(RRSIG)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.TypeCovered, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Labels, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.OrigTtl, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Expiration, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Inception, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.SignerName, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Signature, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackRT(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(RT)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Preference, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Host, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSIG(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SIG)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.TypeCovered, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Labels, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.OrigTtl, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Expiration, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Inception, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.SignerName, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Signature, off, err = unpackStringBase64(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSMIMEA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SMIMEA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Usage, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Selector, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.MatchingType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Certificate, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSOA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SOA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Ns, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Mbox, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Serial, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Refresh, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Retry, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Expire, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Minttl, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSPF(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SPF)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Txt, off, err = unpackStringTxt(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSRV(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SRV)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Priority, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Weight, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Port, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Target, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackSSHFP(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(SSHFP)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Type, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.FingerPrint, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.KeyTag, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Algorithm, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.DigestType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Digest, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTALINK(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TALINK)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.PreviousName, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.NextName, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTKEY(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TKEY)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Algorithm, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Inception, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Expiration, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Mode, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Error, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.KeySize, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Key, off, err = unpackStringHex(msg, off, off+int(rr.KeySize))
	if err != nil {
		return rr, off, err
	}
	rr.OtherLen, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.OtherData, off, err = unpackStringHex(msg, off, off+int(rr.OtherLen))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTLSA(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TLSA)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Usage, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Selector, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.MatchingType, off, err = unpackUint8(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Certificate, off, err = unpackStringHex(msg, off, rdStart+int(rr.Hdr.Rdlength))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTSIG(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TSIG)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Algorithm, off, err = UnpackDomainName(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.TimeSigned, off, err = unpackUint48(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Fudge, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.MACSize, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.MAC, off, err = unpackStringHex(msg, off, off+int(rr.MACSize))
	if err != nil {
		return rr, off, err
	}
	rr.OrigId, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Error, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.OtherLen, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.OtherData, off, err = unpackStringHex(msg, off, off+int(rr.OtherLen))
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackTXT(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(TXT)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Txt, off, err = unpackStringTxt(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackUID(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(UID)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Uid, off, err = unpackUint32(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackUINFO(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(UINFO)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Uinfo, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackURI(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(URI)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.Priority, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Weight, off, err = unpackUint16(msg, off)
	if err != nil {
		return rr, off, err
	}
	if off == len(msg) {
		return rr, off, nil
	}
	rr.Target, off, err = unpackStringOctet(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

func unpackX25(h RR_Header, msg []byte, off int) (RR, int, error) {
	rr := new(X25)
	rr.Hdr = h
	if noRdata(h) {
		return rr, off, nil
	}
	var err error
	rdStart := off
	_ = rdStart

	rr.PSDNAddress, off, err = unpackString(msg, off)
	if err != nil {
		return rr, off, err
	}
	return rr, off, err
}

var typeToUnpack = map[uint16]func(RR_Header, []byte, int) (RR, int, error){
	TypeA:          unpackA,
	TypeAAAA:       unpackAAAA,
	TypeAFSDB:      unpackAFSDB,
	TypeANY:        unpackANY,
	TypeAVC:        unpackAVC,
	TypeCAA:        unpackCAA,
	TypeCDNSKEY:    unpackCDNSKEY,
	TypeCDS:        unpackCDS,
	TypeCERT:       unpackCERT,
	TypeCNAME:      unpackCNAME,
	TypeCSYNC:      unpackCSYNC,
	TypeDHCID:      unpackDHCID,
	TypeDLV:        unpackDLV,
	TypeDNAME:      unpackDNAME,
	TypeDNSKEY:     unpackDNSKEY,
	TypeDS:         unpackDS,
	TypeEID:        unpackEID,
	TypeEUI48:      unpackEUI48,
	TypeEUI64:      unpackEUI64,
	TypeGID:        unpackGID,
	TypeGPOS:       unpackGPOS,
	TypeHINFO:      unpackHINFO,
	TypeHIP:        unpackHIP,
	TypeKEY:        unpackKEY,
	TypeKX:         unpackKX,
	TypeL32:        unpackL32,
	TypeL64:        unpackL64,
	TypeLOC:        unpackLOC,
	TypeLP:         unpackLP,
	TypeMB:         unpackMB,
	TypeMD:         unpackMD,
	TypeMF:         unpackMF,
	TypeMG:         unpackMG,
	TypeMINFO:      unpackMINFO,
	TypeMR:         unpackMR,
	TypeMX:         unpackMX,
	TypeNAPTR:      unpackNAPTR,
	TypeNID:        unpackNID,
	TypeNIMLOC:     unpackNIMLOC,
	TypeNINFO:      unpackNINFO,
	TypeNS:         unpackNS,
	TypeNSAPPTR:    unpackNSAPPTR,
	TypeNSEC:       unpackNSEC,
	TypeNSEC3:      unpackNSEC3,
	TypeNSEC3PARAM: unpackNSEC3PARAM,
	TypeOPENPGPKEY: unpackOPENPGPKEY,
	TypeOPT:        unpackOPT,
	TypePTR:        unpackPTR,
	TypePX:         unpackPX,
	TypeRKEY:       unpackRKEY,
	TypeRP:         unpackRP,
	TypeRRSIG:      unpackRRSIG,
	TypeRT:         unpackRT,
	TypeSIG:        unpackSIG,
	TypeSMIMEA:     unpackSMIMEA,
	TypeSOA:        unpackSOA,
	TypeSPF:        unpackSPF,
	TypeSRV:        unpackSRV,
	TypeSSHFP:      unpackSSHFP,
	TypeTA:         unpackTA,
	TypeTALINK:     unpackTALINK,
	TypeTKEY:       unpackTKEY,
	TypeTLSA:       unpackTLSA,
	TypeTSIG:       unpackTSIG,
	TypeTXT:        unpackTXT,
	TypeUID:        unpackUID,
	TypeUINFO:      unpackUINFO,
	TypeURI:        unpackURI,
	TypeX25:        unpackX25,
}
