# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#	http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

require 'spec_helper'

describe 'client.indices#get' do

  let(:expected_args) do
    [
        'GET',
        url,
        params,
        nil,
        nil
    ]
  end

  let(:params) do
    {}
  end

  let(:url) do
    'foo'
  end

  it 'performs the request' do
    expect(client_double.indices.get(index: 'foo')).to eq({})
  end

  context 'when parameters are specified' do

    let(:params) do
      { ignore_unavailable: 1 }
    end

    it 'performs the request' do
      expect(client_double.indices.get(index: 'foo', ignore_unavailable: 1)).to eq({})
    end
  end

  context 'when features are specified' do

    let(:url) do
      'foo/_settings'
    end

    it 'includes them in the URL' do
      expect(client_double.indices.get(index: 'foo', feature: '_settings')).to eq({})
    end
  end
end
