// Code generated by go-swagger; DO NOT EDIT.

package appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/operator-framework/go-appr/models"
)

// PullPackageReader is a Reader for the PullPackage structure.
type PullPackageReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *PullPackageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewPullPackageOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewPullPackageUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewPullPackageNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewPullPackageOK creates a PullPackageOK with default headers values
func NewPullPackageOK(writer io.Writer) *PullPackageOK {
	return &PullPackageOK{
		Payload: writer,
	}
}

/*PullPackageOK handles this case with default header values.

successful operation
*/
type PullPackageOK struct {
	Payload io.Writer
}

func (o *PullPackageOK) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull][%d] pullPackageOK  %+v", 200, o.Payload)
}

func (o *PullPackageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPullPackageUnauthorized creates a PullPackageUnauthorized with default headers values
func NewPullPackageUnauthorized() *PullPackageUnauthorized {
	return &PullPackageUnauthorized{}
}

/*PullPackageUnauthorized handles this case with default header values.

Not authorized to read the package
*/
type PullPackageUnauthorized struct {
	Payload *models.Error
}

func (o *PullPackageUnauthorized) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull][%d] pullPackageUnauthorized  %+v", 401, o.Payload)
}

func (o *PullPackageUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPullPackageNotFound creates a PullPackageNotFound with default headers values
func NewPullPackageNotFound() *PullPackageNotFound {
	return &PullPackageNotFound{}
}

/*PullPackageNotFound handles this case with default header values.

Package not found
*/
type PullPackageNotFound struct {
	Payload *models.Error
}

func (o *PullPackageNotFound) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/{release}/{media_type}/pull][%d] pullPackageNotFound  %+v", 404, o.Payload)
}

func (o *PullPackageNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
