// Code generated by protoc-gen-go. DO NOT EDIT.
// source: grafeas/v1/provenance.proto

package grafeas

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Specifies the hash algorithm.
type Hash_HashType int32

const (
	// Unknown.
	Hash_HASH_TYPE_UNSPECIFIED Hash_HashType = 0
	// A SHA-256 hash.
	Hash_SHA256 Hash_HashType = 1
)

var Hash_HashType_name = map[int32]string{
	0: "HASH_TYPE_UNSPECIFIED",
	1: "SHA256",
}

var Hash_HashType_value = map[string]int32{
	"HASH_TYPE_UNSPECIFIED": 0,
	"SHA256":                1,
}

func (x Hash_HashType) String() string {
	return proto.EnumName(Hash_HashType_name, int32(x))
}

func (Hash_HashType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{3, 0}
}

// The type of an alias.
type AliasContext_Kind int32

const (
	// Unknown.
	AliasContext_KIND_UNSPECIFIED AliasContext_Kind = 0
	// Git tag.
	AliasContext_FIXED AliasContext_Kind = 1
	// Git branch.
	AliasContext_MOVABLE AliasContext_Kind = 2
	// Used to specify non-standard aliases. For example, if a Git repo has a
	// ref named "refs/foo/bar".
	AliasContext_OTHER AliasContext_Kind = 4
)

var AliasContext_Kind_name = map[int32]string{
	0: "KIND_UNSPECIFIED",
	1: "FIXED",
	2: "MOVABLE",
	4: "OTHER",
}

var AliasContext_Kind_value = map[string]int32{
	"KIND_UNSPECIFIED": 0,
	"FIXED":            1,
	"MOVABLE":          2,
	"OTHER":            4,
}

func (x AliasContext_Kind) String() string {
	return proto.EnumName(AliasContext_Kind_name, int32(x))
}

func (AliasContext_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{7, 0}
}

// Provenance of a build. Contains all information needed to verify the full
// details about the build from source to completion.
type BuildProvenance struct {
	// Required. Unique identifier of the build.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the project.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Commands requested by the build.
	Commands []*Command `protobuf:"bytes,3,rep,name=commands,proto3" json:"commands,omitempty"`
	// Output of the build.
	BuiltArtifacts []*Artifact `protobuf:"bytes,4,rep,name=built_artifacts,json=builtArtifacts,proto3" json:"built_artifacts,omitempty"`
	// Time at which the build was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time at which execution of the build was started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time at which execution of the build was finished.
	EndTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// E-mail address of the user who initiated this build. Note that this was the
	// user's e-mail address at the time the build was initiated; this address may
	// not represent the same end-user for all time.
	Creator string `protobuf:"bytes,8,opt,name=creator,proto3" json:"creator,omitempty"`
	// URI where any logs for this provenance were written.
	LogsUri string `protobuf:"bytes,9,opt,name=logs_uri,json=logsUri,proto3" json:"logs_uri,omitempty"`
	// Details of the Source input to the build.
	SourceProvenance *Source `protobuf:"bytes,10,opt,name=source_provenance,json=sourceProvenance,proto3" json:"source_provenance,omitempty"`
	// Trigger identifier if the build was triggered automatically; empty if not.
	TriggerId string `protobuf:"bytes,11,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Special options applied to this build. This is a catch-all field where
	// build providers can enter any desired additional details.
	BuildOptions map[string]string `protobuf:"bytes,12,rep,name=build_options,json=buildOptions,proto3" json:"build_options,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Version string of the builder at the time this build was executed.
	BuilderVersion       string   `protobuf:"bytes,13,opt,name=builder_version,json=builderVersion,proto3" json:"builder_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildProvenance) Reset()         { *m = BuildProvenance{} }
func (m *BuildProvenance) String() string { return proto.CompactTextString(m) }
func (*BuildProvenance) ProtoMessage()    {}
func (*BuildProvenance) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{0}
}

func (m *BuildProvenance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildProvenance.Unmarshal(m, b)
}
func (m *BuildProvenance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildProvenance.Marshal(b, m, deterministic)
}
func (m *BuildProvenance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildProvenance.Merge(m, src)
}
func (m *BuildProvenance) XXX_Size() int {
	return xxx_messageInfo_BuildProvenance.Size(m)
}
func (m *BuildProvenance) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildProvenance.DiscardUnknown(m)
}

var xxx_messageInfo_BuildProvenance proto.InternalMessageInfo

func (m *BuildProvenance) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildProvenance) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BuildProvenance) GetCommands() []*Command {
	if m != nil {
		return m.Commands
	}
	return nil
}

func (m *BuildProvenance) GetBuiltArtifacts() []*Artifact {
	if m != nil {
		return m.BuiltArtifacts
	}
	return nil
}

func (m *BuildProvenance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BuildProvenance) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *BuildProvenance) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *BuildProvenance) GetCreator() string {
	if m != nil {
		return m.Creator
	}
	return ""
}

func (m *BuildProvenance) GetLogsUri() string {
	if m != nil {
		return m.LogsUri
	}
	return ""
}

func (m *BuildProvenance) GetSourceProvenance() *Source {
	if m != nil {
		return m.SourceProvenance
	}
	return nil
}

func (m *BuildProvenance) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *BuildProvenance) GetBuildOptions() map[string]string {
	if m != nil {
		return m.BuildOptions
	}
	return nil
}

func (m *BuildProvenance) GetBuilderVersion() string {
	if m != nil {
		return m.BuilderVersion
	}
	return ""
}

// Source describes the location of the source used for the build.
type Source struct {
	// If provided, the input binary artifacts for the build came from this
	// location.
	ArtifactStorageSourceUri string `protobuf:"bytes,1,opt,name=artifact_storage_source_uri,json=artifactStorageSourceUri,proto3" json:"artifact_storage_source_uri,omitempty"`
	// Hash(es) of the build source, which can be used to verify that the original
	// source integrity was maintained in the build.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (.tar.gz), the FileHash will be for the single path to that file.
	FileHashes map[string]*FileHashes `protobuf:"bytes,2,rep,name=file_hashes,json=fileHashes,proto3" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If provided, the source code used for the build came from this location.
	Context *SourceContext `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
	// If provided, some of the source code used for the build may be found in
	// these locations, in the case where the source repository had multiple
	// remotes or submodules. This list will not include the context specified in
	// the context field.
	AdditionalContexts   []*SourceContext `protobuf:"bytes,4,rep,name=additional_contexts,json=additionalContexts,proto3" json:"additional_contexts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Source) Reset()         { *m = Source{} }
func (m *Source) String() string { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()    {}
func (*Source) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{1}
}

func (m *Source) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Source.Unmarshal(m, b)
}
func (m *Source) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Source.Marshal(b, m, deterministic)
}
func (m *Source) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Source.Merge(m, src)
}
func (m *Source) XXX_Size() int {
	return xxx_messageInfo_Source.Size(m)
}
func (m *Source) XXX_DiscardUnknown() {
	xxx_messageInfo_Source.DiscardUnknown(m)
}

var xxx_messageInfo_Source proto.InternalMessageInfo

func (m *Source) GetArtifactStorageSourceUri() string {
	if m != nil {
		return m.ArtifactStorageSourceUri
	}
	return ""
}

func (m *Source) GetFileHashes() map[string]*FileHashes {
	if m != nil {
		return m.FileHashes
	}
	return nil
}

func (m *Source) GetContext() *SourceContext {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Source) GetAdditionalContexts() []*SourceContext {
	if m != nil {
		return m.AdditionalContexts
	}
	return nil
}

// Container message for hashes of byte content of files, used in source
// messages to verify integrity of source input to the build.
type FileHashes struct {
	// Required. Collection of file hashes.
	FileHash             []*Hash  `protobuf:"bytes,1,rep,name=file_hash,json=fileHash,proto3" json:"file_hash,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileHashes) Reset()         { *m = FileHashes{} }
func (m *FileHashes) String() string { return proto.CompactTextString(m) }
func (*FileHashes) ProtoMessage()    {}
func (*FileHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{2}
}

func (m *FileHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileHashes.Unmarshal(m, b)
}
func (m *FileHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileHashes.Marshal(b, m, deterministic)
}
func (m *FileHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileHashes.Merge(m, src)
}
func (m *FileHashes) XXX_Size() int {
	return xxx_messageInfo_FileHashes.Size(m)
}
func (m *FileHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_FileHashes.DiscardUnknown(m)
}

var xxx_messageInfo_FileHashes proto.InternalMessageInfo

func (m *FileHashes) GetFileHash() []*Hash {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	// Required. The type of hash that was performed.
	Type Hash_HashType `protobuf:"varint,1,opt,name=type,proto3,enum=grafeas.v1.Hash_HashType" json:"type,omitempty"`
	// Required. The hash value.
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Hash) Reset()         { *m = Hash{} }
func (m *Hash) String() string { return proto.CompactTextString(m) }
func (*Hash) ProtoMessage()    {}
func (*Hash) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{3}
}

func (m *Hash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hash.Unmarshal(m, b)
}
func (m *Hash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hash.Marshal(b, m, deterministic)
}
func (m *Hash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hash.Merge(m, src)
}
func (m *Hash) XXX_Size() int {
	return xxx_messageInfo_Hash.Size(m)
}
func (m *Hash) XXX_DiscardUnknown() {
	xxx_messageInfo_Hash.DiscardUnknown(m)
}

var xxx_messageInfo_Hash proto.InternalMessageInfo

func (m *Hash) GetType() Hash_HashType {
	if m != nil {
		return m.Type
	}
	return Hash_HASH_TYPE_UNSPECIFIED
}

func (m *Hash) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Command describes a step performed as part of the build pipeline.
type Command struct {
	// Required. Name of the command, as presented on the command line, or if the
	// command is packaged as a Docker container, as presented to `docker pull`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Environment variables set before running this command.
	Env []string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// Command-line arguments used when executing this command.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Working directory (relative to project source root) used when running this
	// command.
	Dir string `protobuf:"bytes,4,opt,name=dir,proto3" json:"dir,omitempty"`
	// Optional unique identifier for this command, used in wait_for to reference
	// this command as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// The ID(s) of the command(s) that this command depends on.
	WaitFor              []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor,proto3" json:"wait_for,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Command) Reset()         { *m = Command{} }
func (m *Command) String() string { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()    {}
func (*Command) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{4}
}

func (m *Command) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Command.Unmarshal(m, b)
}
func (m *Command) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Command.Marshal(b, m, deterministic)
}
func (m *Command) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Command.Merge(m, src)
}
func (m *Command) XXX_Size() int {
	return xxx_messageInfo_Command.Size(m)
}
func (m *Command) XXX_DiscardUnknown() {
	xxx_messageInfo_Command.DiscardUnknown(m)
}

var xxx_messageInfo_Command proto.InternalMessageInfo

func (m *Command) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Command) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *Command) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Command) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *Command) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Command) GetWaitFor() []string {
	if m != nil {
		return m.WaitFor
	}
	return nil
}

// Artifact describes a build product.
type Artifact struct {
	// Hash or checksum value of a binary, or Docker Registry 2.0 digest of a
	// container.
	Checksum string `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// Artifact ID, if any; for container images, this will be a URL by digest
	// like `gcr.io/projectID/imagename@sha256:123456`.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Related artifact names. This may be the path to a binary or jar file, or in
	// the case of a container build, the name used to push the container image to
	// Google Container Registry, as presented to `docker push`. Note that a
	// single Artifact ID can have multiple names, for example if two tags are
	// applied to one image.
	Names                []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Artifact) Reset()         { *m = Artifact{} }
func (m *Artifact) String() string { return proto.CompactTextString(m) }
func (*Artifact) ProtoMessage()    {}
func (*Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{5}
}

func (m *Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifact.Unmarshal(m, b)
}
func (m *Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifact.Marshal(b, m, deterministic)
}
func (m *Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifact.Merge(m, src)
}
func (m *Artifact) XXX_Size() int {
	return xxx_messageInfo_Artifact.Size(m)
}
func (m *Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_Artifact proto.InternalMessageInfo

func (m *Artifact) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

func (m *Artifact) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Artifact) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

// A SourceContext is a reference to a tree of files. A SourceContext together
// with a path point to a unique revision of a single file or directory.
type SourceContext struct {
	// A SourceContext can refer any one of the following types of repositories.
	//
	// Types that are valid to be assigned to Context:
	//	*SourceContext_CloudRepo
	//	*SourceContext_Gerrit
	//	*SourceContext_Git
	Context isSourceContext_Context `protobuf_oneof:"context"`
	// Labels with user defined metadata.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *SourceContext) Reset()         { *m = SourceContext{} }
func (m *SourceContext) String() string { return proto.CompactTextString(m) }
func (*SourceContext) ProtoMessage()    {}
func (*SourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{6}
}

func (m *SourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceContext.Unmarshal(m, b)
}
func (m *SourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceContext.Marshal(b, m, deterministic)
}
func (m *SourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceContext.Merge(m, src)
}
func (m *SourceContext) XXX_Size() int {
	return xxx_messageInfo_SourceContext.Size(m)
}
func (m *SourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_SourceContext proto.InternalMessageInfo

type isSourceContext_Context interface {
	isSourceContext_Context()
}

type SourceContext_CloudRepo struct {
	CloudRepo *CloudRepoSourceContext `protobuf:"bytes,1,opt,name=cloud_repo,json=cloudRepo,proto3,oneof"`
}

type SourceContext_Gerrit struct {
	Gerrit *GerritSourceContext `protobuf:"bytes,2,opt,name=gerrit,proto3,oneof"`
}

type SourceContext_Git struct {
	Git *GitSourceContext `protobuf:"bytes,3,opt,name=git,proto3,oneof"`
}

func (*SourceContext_CloudRepo) isSourceContext_Context() {}

func (*SourceContext_Gerrit) isSourceContext_Context() {}

func (*SourceContext_Git) isSourceContext_Context() {}

func (m *SourceContext) GetContext() isSourceContext_Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *SourceContext) GetCloudRepo() *CloudRepoSourceContext {
	if x, ok := m.GetContext().(*SourceContext_CloudRepo); ok {
		return x.CloudRepo
	}
	return nil
}

func (m *SourceContext) GetGerrit() *GerritSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Gerrit); ok {
		return x.Gerrit
	}
	return nil
}

func (m *SourceContext) GetGit() *GitSourceContext {
	if x, ok := m.GetContext().(*SourceContext_Git); ok {
		return x.Git
	}
	return nil
}

func (m *SourceContext) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SourceContext_CloudRepo)(nil),
		(*SourceContext_Gerrit)(nil),
		(*SourceContext_Git)(nil),
	}
}

// An alias to a repo revision.
type AliasContext struct {
	// The alias kind.
	Kind AliasContext_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=grafeas.v1.AliasContext_Kind" json:"kind,omitempty"`
	// The alias name.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AliasContext) Reset()         { *m = AliasContext{} }
func (m *AliasContext) String() string { return proto.CompactTextString(m) }
func (*AliasContext) ProtoMessage()    {}
func (*AliasContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{7}
}

func (m *AliasContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AliasContext.Unmarshal(m, b)
}
func (m *AliasContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AliasContext.Marshal(b, m, deterministic)
}
func (m *AliasContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AliasContext.Merge(m, src)
}
func (m *AliasContext) XXX_Size() int {
	return xxx_messageInfo_AliasContext.Size(m)
}
func (m *AliasContext) XXX_DiscardUnknown() {
	xxx_messageInfo_AliasContext.DiscardUnknown(m)
}

var xxx_messageInfo_AliasContext proto.InternalMessageInfo

func (m *AliasContext) GetKind() AliasContext_Kind {
	if m != nil {
		return m.Kind
	}
	return AliasContext_KIND_UNSPECIFIED
}

func (m *AliasContext) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A CloudRepoSourceContext denotes a particular revision in a Google Cloud
// Source Repo.
type CloudRepoSourceContext struct {
	// The ID of the repo.
	RepoId *RepoId `protobuf:"bytes,1,opt,name=repo_id,json=repoId,proto3" json:"repo_id,omitempty"`
	// A revision in a Cloud Repo can be identified by either its revision ID or
	// its alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*CloudRepoSourceContext_RevisionId
	//	*CloudRepoSourceContext_AliasContext
	Revision             isCloudRepoSourceContext_Revision `protobuf_oneof:"revision"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *CloudRepoSourceContext) Reset()         { *m = CloudRepoSourceContext{} }
func (m *CloudRepoSourceContext) String() string { return proto.CompactTextString(m) }
func (*CloudRepoSourceContext) ProtoMessage()    {}
func (*CloudRepoSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{8}
}

func (m *CloudRepoSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudRepoSourceContext.Unmarshal(m, b)
}
func (m *CloudRepoSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudRepoSourceContext.Marshal(b, m, deterministic)
}
func (m *CloudRepoSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudRepoSourceContext.Merge(m, src)
}
func (m *CloudRepoSourceContext) XXX_Size() int {
	return xxx_messageInfo_CloudRepoSourceContext.Size(m)
}
func (m *CloudRepoSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudRepoSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_CloudRepoSourceContext proto.InternalMessageInfo

func (m *CloudRepoSourceContext) GetRepoId() *RepoId {
	if m != nil {
		return m.RepoId
	}
	return nil
}

type isCloudRepoSourceContext_Revision interface {
	isCloudRepoSourceContext_Revision()
}

type CloudRepoSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3,oneof"`
}

type CloudRepoSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,3,opt,name=alias_context,json=aliasContext,proto3,oneof"`
}

func (*CloudRepoSourceContext_RevisionId) isCloudRepoSourceContext_Revision() {}

func (*CloudRepoSourceContext_AliasContext) isCloudRepoSourceContext_Revision() {}

func (m *CloudRepoSourceContext) GetRevision() isCloudRepoSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *CloudRepoSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *CloudRepoSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*CloudRepoSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CloudRepoSourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CloudRepoSourceContext_RevisionId)(nil),
		(*CloudRepoSourceContext_AliasContext)(nil),
	}
}

// A SourceContext referring to a Gerrit project.
type GerritSourceContext struct {
	// The URI of a running Gerrit instance.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// The full project name within the host. Projects may be nested, so
	// "project/subproject" is a valid project name. The "repo name" is the
	// hostURI/project.
	GerritProject string `protobuf:"bytes,2,opt,name=gerrit_project,json=gerritProject,proto3" json:"gerrit_project,omitempty"`
	// A revision in a Gerrit project can be identified by either its revision ID
	// or its alias.
	//
	// Types that are valid to be assigned to Revision:
	//	*GerritSourceContext_RevisionId
	//	*GerritSourceContext_AliasContext
	Revision             isGerritSourceContext_Revision `protobuf_oneof:"revision"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GerritSourceContext) Reset()         { *m = GerritSourceContext{} }
func (m *GerritSourceContext) String() string { return proto.CompactTextString(m) }
func (*GerritSourceContext) ProtoMessage()    {}
func (*GerritSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{9}
}

func (m *GerritSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GerritSourceContext.Unmarshal(m, b)
}
func (m *GerritSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GerritSourceContext.Marshal(b, m, deterministic)
}
func (m *GerritSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GerritSourceContext.Merge(m, src)
}
func (m *GerritSourceContext) XXX_Size() int {
	return xxx_messageInfo_GerritSourceContext.Size(m)
}
func (m *GerritSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_GerritSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_GerritSourceContext proto.InternalMessageInfo

func (m *GerritSourceContext) GetHostUri() string {
	if m != nil {
		return m.HostUri
	}
	return ""
}

func (m *GerritSourceContext) GetGerritProject() string {
	if m != nil {
		return m.GerritProject
	}
	return ""
}

type isGerritSourceContext_Revision interface {
	isGerritSourceContext_Revision()
}

type GerritSourceContext_RevisionId struct {
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3,oneof"`
}

type GerritSourceContext_AliasContext struct {
	AliasContext *AliasContext `protobuf:"bytes,4,opt,name=alias_context,json=aliasContext,proto3,oneof"`
}

func (*GerritSourceContext_RevisionId) isGerritSourceContext_Revision() {}

func (*GerritSourceContext_AliasContext) isGerritSourceContext_Revision() {}

func (m *GerritSourceContext) GetRevision() isGerritSourceContext_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *GerritSourceContext) GetRevisionId() string {
	if x, ok := m.GetRevision().(*GerritSourceContext_RevisionId); ok {
		return x.RevisionId
	}
	return ""
}

func (m *GerritSourceContext) GetAliasContext() *AliasContext {
	if x, ok := m.GetRevision().(*GerritSourceContext_AliasContext); ok {
		return x.AliasContext
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GerritSourceContext) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GerritSourceContext_RevisionId)(nil),
		(*GerritSourceContext_AliasContext)(nil),
	}
}

// A GitSourceContext denotes a particular revision in a third party Git
// repository (e.g., GitHub).
type GitSourceContext struct {
	// Git repository URL.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Git commit hash.
	RevisionId           string   `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GitSourceContext) Reset()         { *m = GitSourceContext{} }
func (m *GitSourceContext) String() string { return proto.CompactTextString(m) }
func (*GitSourceContext) ProtoMessage()    {}
func (*GitSourceContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{10}
}

func (m *GitSourceContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GitSourceContext.Unmarshal(m, b)
}
func (m *GitSourceContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GitSourceContext.Marshal(b, m, deterministic)
}
func (m *GitSourceContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitSourceContext.Merge(m, src)
}
func (m *GitSourceContext) XXX_Size() int {
	return xxx_messageInfo_GitSourceContext.Size(m)
}
func (m *GitSourceContext) XXX_DiscardUnknown() {
	xxx_messageInfo_GitSourceContext.DiscardUnknown(m)
}

var xxx_messageInfo_GitSourceContext proto.InternalMessageInfo

func (m *GitSourceContext) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *GitSourceContext) GetRevisionId() string {
	if m != nil {
		return m.RevisionId
	}
	return ""
}

// A unique identifier for a Cloud Repo.
type RepoId struct {
	// A cloud repo can be identified by either its project ID and repository name
	// combination, or its globally unique identifier.
	//
	// Types that are valid to be assigned to Id:
	//	*RepoId_ProjectRepoId
	//	*RepoId_Uid
	Id                   isRepoId_Id `protobuf_oneof:"id"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RepoId) Reset()         { *m = RepoId{} }
func (m *RepoId) String() string { return proto.CompactTextString(m) }
func (*RepoId) ProtoMessage()    {}
func (*RepoId) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{11}
}

func (m *RepoId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RepoId.Unmarshal(m, b)
}
func (m *RepoId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RepoId.Marshal(b, m, deterministic)
}
func (m *RepoId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepoId.Merge(m, src)
}
func (m *RepoId) XXX_Size() int {
	return xxx_messageInfo_RepoId.Size(m)
}
func (m *RepoId) XXX_DiscardUnknown() {
	xxx_messageInfo_RepoId.DiscardUnknown(m)
}

var xxx_messageInfo_RepoId proto.InternalMessageInfo

type isRepoId_Id interface {
	isRepoId_Id()
}

type RepoId_ProjectRepoId struct {
	ProjectRepoId *ProjectRepoId `protobuf:"bytes,1,opt,name=project_repo_id,json=projectRepoId,proto3,oneof"`
}

type RepoId_Uid struct {
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3,oneof"`
}

func (*RepoId_ProjectRepoId) isRepoId_Id() {}

func (*RepoId_Uid) isRepoId_Id() {}

func (m *RepoId) GetId() isRepoId_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *RepoId) GetProjectRepoId() *ProjectRepoId {
	if x, ok := m.GetId().(*RepoId_ProjectRepoId); ok {
		return x.ProjectRepoId
	}
	return nil
}

func (m *RepoId) GetUid() string {
	if x, ok := m.GetId().(*RepoId_Uid); ok {
		return x.Uid
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RepoId) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RepoId_ProjectRepoId)(nil),
		(*RepoId_Uid)(nil),
	}
}

// Selects a repo using a Google Cloud Platform project ID (e.g.,
// winged-cargo-31) and a repo name within that project.
type ProjectRepoId struct {
	// The ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The name of the repo. Leave empty for the default repo.
	RepoName             string   `protobuf:"bytes,2,opt,name=repo_name,json=repoName,proto3" json:"repo_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProjectRepoId) Reset()         { *m = ProjectRepoId{} }
func (m *ProjectRepoId) String() string { return proto.CompactTextString(m) }
func (*ProjectRepoId) ProtoMessage()    {}
func (*ProjectRepoId) Descriptor() ([]byte, []int) {
	return fileDescriptor_f3e893c2155395b5, []int{12}
}

func (m *ProjectRepoId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProjectRepoId.Unmarshal(m, b)
}
func (m *ProjectRepoId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProjectRepoId.Marshal(b, m, deterministic)
}
func (m *ProjectRepoId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProjectRepoId.Merge(m, src)
}
func (m *ProjectRepoId) XXX_Size() int {
	return xxx_messageInfo_ProjectRepoId.Size(m)
}
func (m *ProjectRepoId) XXX_DiscardUnknown() {
	xxx_messageInfo_ProjectRepoId.DiscardUnknown(m)
}

var xxx_messageInfo_ProjectRepoId proto.InternalMessageInfo

func (m *ProjectRepoId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ProjectRepoId) GetRepoName() string {
	if m != nil {
		return m.RepoName
	}
	return ""
}

func init() {
	proto.RegisterEnum("grafeas.v1.Hash_HashType", Hash_HashType_name, Hash_HashType_value)
	proto.RegisterEnum("grafeas.v1.AliasContext_Kind", AliasContext_Kind_name, AliasContext_Kind_value)
	proto.RegisterType((*BuildProvenance)(nil), "grafeas.v1.BuildProvenance")
	proto.RegisterMapType((map[string]string)(nil), "grafeas.v1.BuildProvenance.BuildOptionsEntry")
	proto.RegisterType((*Source)(nil), "grafeas.v1.Source")
	proto.RegisterMapType((map[string]*FileHashes)(nil), "grafeas.v1.Source.FileHashesEntry")
	proto.RegisterType((*FileHashes)(nil), "grafeas.v1.FileHashes")
	proto.RegisterType((*Hash)(nil), "grafeas.v1.Hash")
	proto.RegisterType((*Command)(nil), "grafeas.v1.Command")
	proto.RegisterType((*Artifact)(nil), "grafeas.v1.Artifact")
	proto.RegisterType((*SourceContext)(nil), "grafeas.v1.SourceContext")
	proto.RegisterMapType((map[string]string)(nil), "grafeas.v1.SourceContext.LabelsEntry")
	proto.RegisterType((*AliasContext)(nil), "grafeas.v1.AliasContext")
	proto.RegisterType((*CloudRepoSourceContext)(nil), "grafeas.v1.CloudRepoSourceContext")
	proto.RegisterType((*GerritSourceContext)(nil), "grafeas.v1.GerritSourceContext")
	proto.RegisterType((*GitSourceContext)(nil), "grafeas.v1.GitSourceContext")
	proto.RegisterType((*RepoId)(nil), "grafeas.v1.RepoId")
	proto.RegisterType((*ProjectRepoId)(nil), "grafeas.v1.ProjectRepoId")
}

func init() { proto.RegisterFile("grafeas/v1/provenance.proto", fileDescriptor_f3e893c2155395b5) }

var fileDescriptor_f3e893c2155395b5 = []byte{
	// 1178 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xef, 0x4e, 0xe3, 0x46,
	0x10, 0xc7, 0xf9, 0x9f, 0x09, 0x81, 0xdc, 0x42, 0x4f, 0x26, 0x14, 0x41, 0x2d, 0x9d, 0x8a, 0xd4,
	0x92, 0x14, 0x4e, 0x57, 0x1d, 0x45, 0x08, 0x25, 0x21, 0x5c, 0x52, 0x28, 0x50, 0x03, 0xa7, 0xb6,
	0x5f, 0xac, 0x25, 0xde, 0x98, 0x2d, 0x8e, 0x37, 0x5a, 0x3b, 0x69, 0xf9, 0x52, 0xf5, 0x29, 0xfa,
	0x00, 0x7d, 0x84, 0x4a, 0x7d, 0x85, 0xf6, 0x45, 0xfa, 0x20, 0xd5, 0xfe, 0x71, 0xe2, 0x04, 0xae,
	0xd7, 0xaa, 0x5f, 0x92, 0x9d, 0x99, 0xdf, 0x8c, 0xe7, 0xcf, 0xcf, 0xe3, 0x85, 0x75, 0x8f, 0xe3,
	0x3e, 0xc1, 0x61, 0x7d, 0xbc, 0x5b, 0x1f, 0x72, 0x36, 0x26, 0x01, 0x0e, 0x7a, 0xa4, 0x36, 0xe4,
	0x2c, 0x62, 0x08, 0xb4, 0xb1, 0x36, 0xde, 0xad, 0x6e, 0x7a, 0x8c, 0x79, 0x3e, 0xa9, 0x4b, 0xcb,
	0xed, 0xa8, 0x5f, 0x8f, 0xe8, 0x80, 0x84, 0x11, 0x1e, 0x0c, 0x15, 0xd8, 0xfa, 0x2d, 0x0b, 0xcb,
	0xcd, 0x11, 0xf5, 0xdd, 0xcb, 0x49, 0x18, 0xb4, 0x04, 0x29, 0xea, 0x9a, 0xc6, 0x96, 0xb1, 0x5d,
	0xb4, 0x53, 0xd4, 0x45, 0x1b, 0x00, 0x43, 0xce, 0xbe, 0x27, 0xbd, 0xc8, 0xa1, 0xae, 0x99, 0x92,
	0xfa, 0xa2, 0xd6, 0x74, 0x5d, 0x54, 0x87, 0x42, 0x8f, 0x0d, 0x06, 0x38, 0x70, 0x43, 0x33, 0xbd,
	0x95, 0xde, 0x2e, 0xed, 0xad, 0xd4, 0xa6, 0x29, 0xd4, 0x5a, 0xca, 0x66, 0x4f, 0x40, 0xe8, 0x10,
	0x96, 0x6f, 0x47, 0xd4, 0x8f, 0x1c, 0xcc, 0x23, 0xda, 0xc7, 0xbd, 0x28, 0x34, 0x33, 0xd2, 0x6f,
	0x35, 0xe9, 0xd7, 0xd0, 0x46, 0x7b, 0x49, 0x82, 0x63, 0x31, 0x44, 0x07, 0x50, 0xea, 0x71, 0x82,
	0x23, 0xe2, 0x88, 0x62, 0xcc, 0xec, 0x96, 0xb1, 0x5d, 0xda, 0xab, 0xd6, 0x54, 0xa5, 0xb5, 0xb8,
	0xd2, 0xda, 0x75, 0x5c, 0xa9, 0x0d, 0x0a, 0x2e, 0x14, 0x68, 0x1f, 0x20, 0x8c, 0x30, 0x8f, 0x94,
	0x6f, 0xee, 0xbd, 0xbe, 0x45, 0x89, 0x96, 0xae, 0xaf, 0xa0, 0x40, 0x02, 0x57, 0x39, 0xe6, 0xdf,
	0xeb, 0x98, 0x27, 0x81, 0x2b, 0xdd, 0x4c, 0xc8, 0xcb, 0xe7, 0x33, 0x6e, 0x16, 0x64, 0xeb, 0x62,
	0x11, 0xad, 0x41, 0xc1, 0x67, 0x5e, 0xe8, 0x8c, 0x38, 0x35, 0x8b, 0xca, 0x24, 0xe4, 0x1b, 0x4e,
	0xd1, 0x11, 0x3c, 0x0b, 0xd9, 0x88, 0xf7, 0x88, 0x33, 0x1d, 0xaf, 0x09, 0xf2, 0xa1, 0x28, 0xd9,
	0xa4, 0x2b, 0x09, 0xb2, 0x2b, 0x0a, 0x9c, 0x98, 0xe1, 0x06, 0x40, 0xc4, 0xa9, 0xe7, 0x11, 0x2e,
	0x66, 0x56, 0x52, 0x33, 0xd3, 0x9a, 0xae, 0x8b, 0x6c, 0x28, 0x8b, 0xae, 0xba, 0x0e, 0x1b, 0x46,
	0x94, 0x05, 0xa1, 0xb9, 0x28, 0x07, 0xb0, 0x93, 0x8c, 0x3d, 0x47, 0x0b, 0x25, 0x5f, 0x28, 0x7c,
	0x3b, 0x88, 0xf8, 0x83, 0xbd, 0x78, 0x9b, 0x50, 0xa1, 0x8f, 0xd5, 0x58, 0x5d, 0xc2, 0x9d, 0x31,
	0xe1, 0x21, 0x65, 0x81, 0x59, 0x96, 0xcf, 0x5d, 0xd2, 0xea, 0xb7, 0x4a, 0x5b, 0x3d, 0x82, 0x67,
	0x8f, 0x62, 0xa1, 0x0a, 0xa4, 0xef, 0xc9, 0x83, 0x66, 0x9d, 0x38, 0xa2, 0x55, 0xc8, 0x8e, 0xb1,
	0x3f, 0x22, 0x9a, 0x71, 0x4a, 0xf8, 0x22, 0xf5, 0xda, 0xb0, 0xfe, 0x4a, 0x41, 0x4e, 0x55, 0x8e,
	0x0e, 0x61, 0x3d, 0x66, 0x91, 0x13, 0x46, 0x8c, 0x63, 0x8f, 0x38, 0xba, 0x73, 0xa2, 0xad, 0x2a,
	0x9c, 0x19, 0x43, 0xae, 0x14, 0x42, 0xf9, 0x8a, 0x3e, 0xb7, 0xa0, 0xd4, 0xa7, 0x3e, 0x71, 0xee,
	0x70, 0x78, 0x47, 0x42, 0x33, 0x25, 0xbb, 0x60, 0x3d, 0xee, 0x70, 0xed, 0x84, 0xfa, 0xa4, 0x23,
	0x41, 0xaa, 0x74, 0xe8, 0x4f, 0x14, 0xe8, 0x25, 0xe4, 0x7b, 0x2c, 0x88, 0xc8, 0x8f, 0x91, 0x99,
	0x96, 0x23, 0x5a, 0x7b, 0x1c, 0xa0, 0xa5, 0x00, 0x76, 0x8c, 0x44, 0x5f, 0xc2, 0x0a, 0x76, 0x5d,
	0x2a, 0x3a, 0x80, 0x7d, 0x47, 0x6b, 0xe3, 0x17, 0xe1, 0x1f, 0x02, 0xa0, 0xa9, 0x97, 0x56, 0x85,
	0xd5, 0x1b, 0x58, 0x9e, 0xcb, 0xef, 0x89, 0x76, 0x7e, 0x9a, 0x6c, 0x67, 0x69, 0xef, 0x79, 0xf2,
	0x11, 0x53, 0xef, 0x64, 0x9b, 0x0f, 0x00, 0xa6, 0x06, 0xb4, 0x03, 0xc5, 0x49, 0xab, 0x4c, 0x43,
	0xa6, 0x59, 0x49, 0xc6, 0x10, 0x30, 0xbb, 0x10, 0xb7, 0xc5, 0xfa, 0x09, 0x32, 0xe2, 0x1f, 0xed,
	0x40, 0x26, 0x7a, 0x18, 0x12, 0x99, 0xc9, 0xd2, 0x6c, 0x61, 0xc2, 0x2e, 0x7f, 0xae, 0x1f, 0x86,
	0xc4, 0x96, 0xb0, 0xd9, 0xa1, 0x2f, 0xea, 0x6c, 0xac, 0x5d, 0x28, 0xc4, 0x38, 0xb4, 0x06, 0x1f,
	0x74, 0x1a, 0x57, 0x1d, 0xe7, 0xfa, 0xdb, 0xcb, 0xb6, 0x73, 0x73, 0x7e, 0x75, 0xd9, 0x6e, 0x75,
	0x4f, 0xba, 0xed, 0xe3, 0xca, 0x02, 0x02, 0xc8, 0x5d, 0x75, 0x1a, 0x7b, 0xaf, 0x3e, 0xaf, 0x18,
	0xd6, 0xcf, 0x06, 0xe4, 0xf5, 0xea, 0x41, 0x08, 0x32, 0x01, 0x1e, 0x10, 0xdd, 0x0d, 0x79, 0x16,
	0x0d, 0x22, 0xc1, 0x58, 0x4e, 0xbc, 0x68, 0x8b, 0xa3, 0x40, 0x61, 0xee, 0xa9, 0x1d, 0x56, 0xb4,
	0xe5, 0x59, 0xa0, 0x5c, 0xca, 0xcd, 0x8c, 0x6a, 0xa3, 0x4b, 0xb9, 0x5e, 0x8e, 0xd9, 0xc9, 0x72,
	0x5c, 0x83, 0xc2, 0x0f, 0x98, 0x46, 0x4e, 0x9f, 0x71, 0x33, 0x27, 0x3d, 0xf3, 0x42, 0x3e, 0x61,
	0xdc, 0x3a, 0x83, 0x42, 0xbc, 0xb5, 0x50, 0x15, 0x0a, 0xbd, 0x3b, 0xd2, 0xbb, 0x0f, 0x47, 0x03,
	0x9d, 0xc6, 0x44, 0xd6, 0x21, 0x53, 0x93, 0x90, 0xab, 0x90, 0x15, 0x29, 0xc6, 0x99, 0x28, 0xc1,
	0xfa, 0x23, 0x05, 0xe5, 0x19, 0x2a, 0xa0, 0x16, 0x40, 0xcf, 0x67, 0x23, 0xd7, 0xe1, 0x64, 0xc8,
	0x64, 0xd4, 0x39, 0xee, 0xb6, 0x84, 0xd5, 0x26, 0x43, 0x36, 0xe3, 0xd7, 0x59, 0xb0, 0x8b, 0xbd,
	0xd8, 0x82, 0xf6, 0x21, 0xe7, 0x11, 0xce, 0x69, 0xa4, 0x79, 0xb1, 0x99, 0x0c, 0xf0, 0x46, 0x5a,
	0xe6, 0xbd, 0xb5, 0x03, 0xfa, 0x0c, 0xd2, 0x1e, 0x8d, 0x39, 0xff, 0xe1, 0x8c, 0xdf, 0x63, 0x27,
	0x01, 0x45, 0x87, 0x90, 0xf3, 0xf1, 0x2d, 0xf1, 0x63, 0x9e, 0xbf, 0x78, 0x27, 0xcf, 0x6b, 0x67,
	0x12, 0xa7, 0x5e, 0x36, 0xed, 0x54, 0xdd, 0x87, 0x52, 0x42, 0xfd, 0x5f, 0x56, 0x46, 0xb3, 0x38,
	0x79, 0x47, 0xad, 0x5f, 0x0c, 0x58, 0x6c, 0xf8, 0x14, 0x87, 0x71, 0x1f, 0x77, 0x21, 0x73, 0x4f,
	0x03, 0x57, 0x53, 0x74, 0x63, 0xe6, 0x23, 0x94, 0xc0, 0xd5, 0x4e, 0x69, 0xe0, 0xda, 0x12, 0x3a,
	0x61, 0x54, 0x6a, 0xca, 0x28, 0xeb, 0x08, 0x32, 0x02, 0x81, 0x56, 0xa1, 0x72, 0xda, 0x3d, 0x3f,
	0x9e, 0xe3, 0x66, 0x11, 0xb2, 0x27, 0xdd, 0x6f, 0xda, 0xc7, 0x15, 0x03, 0x95, 0x20, 0xff, 0xd5,
	0xc5, 0xdb, 0x46, 0xf3, 0xac, 0x5d, 0x49, 0x09, 0xfd, 0xc5, 0x75, 0xa7, 0x6d, 0x57, 0x32, 0xd6,
	0xef, 0x06, 0x3c, 0x7f, 0x7a, 0x64, 0xe8, 0x13, 0xc8, 0x8b, 0x21, 0x3b, 0xfa, 0xbb, 0x3c, 0xf7,
	0x15, 0x10, 0xf8, 0xae, 0x6b, 0xe7, 0xb8, 0xfc, 0x47, 0x1f, 0x41, 0x89, 0x93, 0x31, 0x15, 0xbb,
	0x76, 0xf2, 0xc1, 0xee, 0x2c, 0xd8, 0x10, 0x2b, 0xbb, 0x2e, 0x3a, 0x82, 0x32, 0x16, 0xa5, 0x39,
	0xb3, 0x8b, 0xcb, 0x7c, 0x57, 0xed, 0x9d, 0x05, 0x7b, 0x11, 0x27, 0xe4, 0x26, 0x40, 0x21, 0x0e,
	0x67, 0xfd, 0x69, 0xc0, 0xca, 0x13, 0x4c, 0x11, 0xaf, 0xc6, 0x1d, 0x0b, 0xa3, 0xc4, 0x22, 0xce,
	0x0b, 0x59, 0xec, 0xdd, 0x17, 0xb0, 0xa4, 0x48, 0xe4, 0xe8, 0x7b, 0x84, 0xee, 0x64, 0x59, 0x69,
	0x2f, 0x95, 0x72, 0xbe, 0x92, 0xf4, 0xbf, 0xa9, 0x24, 0xf3, 0x3f, 0x2a, 0x69, 0x43, 0x65, 0x9e,
	0xba, 0x82, 0x65, 0x23, 0xee, 0xc7, 0x2c, 0x1b, 0x71, 0x1f, 0x6d, 0x3e, 0xd1, 0xdf, 0x64, 0x4e,
	0x96, 0x07, 0x39, 0x35, 0x12, 0xd4, 0x82, 0xe5, 0xf8, 0xea, 0x34, 0x3b, 0xbf, 0x99, 0x45, 0xa8,
	0xcb, 0x55, 0x3e, 0x9d, 0x05, 0xbb, 0x3c, 0x4c, 0x2a, 0x10, 0x82, 0xf4, 0x28, 0x31, 0x47, 0x21,
	0x34, 0x33, 0x62, 0x67, 0x58, 0xa7, 0x50, 0x9e, 0xf1, 0x9d, 0xbb, 0xaa, 0x19, 0xf3, 0x57, 0xb5,
	0x75, 0x28, 0xca, 0x34, 0x12, 0xdc, 0x2d, 0x08, 0xc5, 0x39, 0x1e, 0x90, 0xe6, 0xd7, 0x50, 0xa6,
	0x2c, 0x91, 0xd6, 0xa5, 0xf1, 0xdd, 0x6b, 0x7d, 0xbf, 0xf1, 0x98, 0x8f, 0x03, 0xaf, 0xc6, 0xb8,
	0x57, 0xf7, 0x48, 0x20, 0x6f, 0x3b, 0x75, 0x65, 0xc2, 0x43, 0x1a, 0xd6, 0xa7, 0xb7, 0xd1, 0x03,
	0x7d, 0xfc, 0x35, 0x95, 0x7e, 0x63, 0x37, 0x6e, 0x73, 0x12, 0xfa, 0xf2, 0xef, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xc2, 0xf5, 0x7f, 0x75, 0xb0, 0x0a, 0x00, 0x00,
}
