// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package datalabeling

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type DataType int32

const (
	DataType_DATA_TYPE_UNSPECIFIED DataType = 0
	DataType_IMAGE                 DataType = 1
	DataType_VIDEO                 DataType = 2
	DataType_TEXT                  DataType = 4
	DataType_AUDIO                 DataType = 5
)

var DataType_name = map[int32]string{
	0: "DATA_TYPE_UNSPECIFIED",
	1: "IMAGE",
	2: "VIDEO",
	4: "TEXT",
	5: "AUDIO",
}

var DataType_value = map[string]int32{
	"DATA_TYPE_UNSPECIFIED": 0,
	"IMAGE":                 1,
	"VIDEO":                 2,
	"TEXT":                  4,
	"AUDIO":                 5,
}

func (x DataType) String() string {
	return proto.EnumName(DataType_name, int32(x))
}

func (DataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{0}
}

// Dataset is the resource to hold your data. You can request multiple labeling
// tasks for a dataset while each one will generate an AnnotatedDataset.
type Dataset struct {
	// Output only.
	// Dataset resource name, format is:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the dataset. Maximum of 64 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-provided description of the annotation specification set.
	// The description can be up to 10000 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the dataset is created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. This is populated with the original input configs
	// where ImportData is called. It is available only after the clients
	// import data to this dataset.
	InputConfigs         []*InputConfig `protobuf:"bytes,5,rep,name=input_configs,json=inputConfigs,proto3" json:"input_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Dataset) Reset()         { *m = Dataset{} }
func (m *Dataset) String() string { return proto.CompactTextString(m) }
func (*Dataset) ProtoMessage()    {}
func (*Dataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{0}
}

func (m *Dataset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Dataset.Unmarshal(m, b)
}
func (m *Dataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Dataset.Marshal(b, m, deterministic)
}
func (m *Dataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dataset.Merge(m, src)
}
func (m *Dataset) XXX_Size() int {
	return xxx_messageInfo_Dataset.Size(m)
}
func (m *Dataset) XXX_DiscardUnknown() {
	xxx_messageInfo_Dataset.DiscardUnknown(m)
}

var xxx_messageInfo_Dataset proto.InternalMessageInfo

func (m *Dataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Dataset) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Dataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Dataset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Dataset) GetInputConfigs() []*InputConfig {
	if m != nil {
		return m.InputConfigs
	}
	return nil
}

// The configuration of input data, including data type, location, etc.
type InputConfig struct {
	// Required. Where the data is from.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source isInputConfig_Source `protobuf_oneof:"source"`
	// Required. Data type must be specifed when user tries to import data.
	DataType             DataType `protobuf:"varint,1,opt,name=data_type,json=dataType,proto3,enum=google.cloud.datalabeling.v1beta1.DataType" json:"data_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{1}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (m *InputConfig) GetDataType() DataType {
	if m != nil {
		return m.DataType
	}
	return DataType_DATA_TYPE_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

// Source of the GCS file to be imported. Only gcs path is allowed in
// input_uri.
type GcsSource struct {
	// Required. The input uri of source file.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Required. The format of the gcs source. Only "text/csv" is supported.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{2}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *GcsSource) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// The configuration of output data.
type OutputConfig struct {
	// Required. Location to output data to.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_GcsFolderDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{3}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_GcsFolderDestination struct {
	GcsFolderDestination *GcsFolderDestination `protobuf:"bytes,2,opt,name=gcs_folder_destination,json=gcsFolderDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_GcsFolderDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetGcsFolderDestination() *GcsFolderDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsFolderDestination); ok {
		return x.GcsFolderDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_GcsFolderDestination)(nil),
	}
}

// Export destination of the data.Only gcs path is allowed in
// output_uri.
type GcsDestination struct {
	// Required. The output uri of destination file.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Required. The format of the gcs destination. Only "text/csv" and
	// "application/json"
	// are supported.
	MimeType             string   `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{4}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *GcsDestination) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

// Export folder destination of the data.
type GcsFolderDestination struct {
	// Required. GCS folder to export data to.
	OutputFolderUri      string   `protobuf:"bytes,1,opt,name=output_folder_uri,json=outputFolderUri,proto3" json:"output_folder_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsFolderDestination) Reset()         { *m = GcsFolderDestination{} }
func (m *GcsFolderDestination) String() string { return proto.CompactTextString(m) }
func (*GcsFolderDestination) ProtoMessage()    {}
func (*GcsFolderDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{5}
}

func (m *GcsFolderDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsFolderDestination.Unmarshal(m, b)
}
func (m *GcsFolderDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsFolderDestination.Marshal(b, m, deterministic)
}
func (m *GcsFolderDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsFolderDestination.Merge(m, src)
}
func (m *GcsFolderDestination) XXX_Size() int {
	return xxx_messageInfo_GcsFolderDestination.Size(m)
}
func (m *GcsFolderDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsFolderDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsFolderDestination proto.InternalMessageInfo

func (m *GcsFolderDestination) GetOutputFolderUri() string {
	if m != nil {
		return m.OutputFolderUri
	}
	return ""
}

// DataItem is a piece of data, without annotation. For example, an image.
type DataItem struct {
	// Output only.
	//
	// Types that are valid to be assigned to Payload:
	//	*DataItem_ImagePayload
	//	*DataItem_TextPayload
	//	*DataItem_VideoPayload
	//	*DataItem_AudioPayload
	Payload isDataItem_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the data item, in format of:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataItem) Reset()         { *m = DataItem{} }
func (m *DataItem) String() string { return proto.CompactTextString(m) }
func (*DataItem) ProtoMessage()    {}
func (*DataItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{6}
}

func (m *DataItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataItem.Unmarshal(m, b)
}
func (m *DataItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataItem.Marshal(b, m, deterministic)
}
func (m *DataItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataItem.Merge(m, src)
}
func (m *DataItem) XXX_Size() int {
	return xxx_messageInfo_DataItem.Size(m)
}
func (m *DataItem) XXX_DiscardUnknown() {
	xxx_messageInfo_DataItem.DiscardUnknown(m)
}

var xxx_messageInfo_DataItem proto.InternalMessageInfo

type isDataItem_Payload interface {
	isDataItem_Payload()
}

type DataItem_ImagePayload struct {
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type DataItem_TextPayload struct {
	TextPayload *TextPayload `protobuf:"bytes,3,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type DataItem_VideoPayload struct {
	VideoPayload *VideoPayload `protobuf:"bytes,4,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

type DataItem_AudioPayload struct {
	AudioPayload *AudioPayload `protobuf:"bytes,5,opt,name=audio_payload,json=audioPayload,proto3,oneof"`
}

func (*DataItem_ImagePayload) isDataItem_Payload() {}

func (*DataItem_TextPayload) isDataItem_Payload() {}

func (*DataItem_VideoPayload) isDataItem_Payload() {}

func (*DataItem_AudioPayload) isDataItem_Payload() {}

func (m *DataItem) GetPayload() isDataItem_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *DataItem) GetImagePayload() *ImagePayload {
	if x, ok := m.GetPayload().(*DataItem_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (m *DataItem) GetTextPayload() *TextPayload {
	if x, ok := m.GetPayload().(*DataItem_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (m *DataItem) GetVideoPayload() *VideoPayload {
	if x, ok := m.GetPayload().(*DataItem_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (m *DataItem) GetAudioPayload() *AudioPayload {
	if x, ok := m.GetPayload().(*DataItem_AudioPayload); ok {
		return x.AudioPayload
	}
	return nil
}

func (m *DataItem) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DataItem) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DataItem_ImagePayload)(nil),
		(*DataItem_TextPayload)(nil),
		(*DataItem_VideoPayload)(nil),
		(*DataItem_AudioPayload)(nil),
	}
}

// AnnotatedDataset is a set holding annotations for data in a Dataset. Each
// labeling task will generate an AnnotatedDataset under the Dataset that the
// task is requested for.
type AnnotatedDataset struct {
	// Output only.
	// AnnotatedDataset resource name in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The display name of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 64
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The description of the AnnotatedDataset. It is specified in
	// HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
	// characters.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Source of the annotation.
	AnnotationSource AnnotationSource `protobuf:"varint,3,opt,name=annotation_source,json=annotationSource,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationSource" json:"annotation_source,omitempty"`
	// Output only. Type of the annotation. It is specified when starting labeling
	// task.
	AnnotationType AnnotationType `protobuf:"varint,8,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Output only. Number of examples in the annotated dataset.
	ExampleCount int64 `protobuf:"varint,4,opt,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty"`
	// Output only. Number of examples that have annotation in the annotated
	// dataset.
	CompletedExampleCount int64 `protobuf:"varint,5,opt,name=completed_example_count,json=completedExampleCount,proto3" json:"completed_example_count,omitempty"`
	// Output only. Per label statistics.
	LabelStats *LabelStats `protobuf:"bytes,6,opt,name=label_stats,json=labelStats,proto3" json:"label_stats,omitempty"`
	// Output only. Time the AnnotatedDataset was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Additional information about AnnotatedDataset.
	Metadata             *AnnotatedDatasetMetadata `protobuf:"bytes,10,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotatedDataset) Reset()         { *m = AnnotatedDataset{} }
func (m *AnnotatedDataset) String() string { return proto.CompactTextString(m) }
func (*AnnotatedDataset) ProtoMessage()    {}
func (*AnnotatedDataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{7}
}

func (m *AnnotatedDataset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotatedDataset.Unmarshal(m, b)
}
func (m *AnnotatedDataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotatedDataset.Marshal(b, m, deterministic)
}
func (m *AnnotatedDataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotatedDataset.Merge(m, src)
}
func (m *AnnotatedDataset) XXX_Size() int {
	return xxx_messageInfo_AnnotatedDataset.Size(m)
}
func (m *AnnotatedDataset) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotatedDataset.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotatedDataset proto.InternalMessageInfo

func (m *AnnotatedDataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AnnotatedDataset) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *AnnotatedDataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AnnotatedDataset) GetAnnotationSource() AnnotationSource {
	if m != nil {
		return m.AnnotationSource
	}
	return AnnotationSource_ANNOTATION_SOURCE_UNSPECIFIED
}

func (m *AnnotatedDataset) GetAnnotationType() AnnotationType {
	if m != nil {
		return m.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (m *AnnotatedDataset) GetExampleCount() int64 {
	if m != nil {
		return m.ExampleCount
	}
	return 0
}

func (m *AnnotatedDataset) GetCompletedExampleCount() int64 {
	if m != nil {
		return m.CompletedExampleCount
	}
	return 0
}

func (m *AnnotatedDataset) GetLabelStats() *LabelStats {
	if m != nil {
		return m.LabelStats
	}
	return nil
}

func (m *AnnotatedDataset) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *AnnotatedDataset) GetMetadata() *AnnotatedDatasetMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Metadata on AnnotatedDataset.
type AnnotatedDatasetMetadata struct {
	// HumanAnnotationConfig used when requesting the human labeling task for this
	// AnnotatedDataset.
	HumanAnnotationConfig *HumanAnnotationConfig `protobuf:"bytes,1,opt,name=human_annotation_config,json=humanAnnotationConfig,proto3" json:"human_annotation_config,omitempty"`
	// Specific request configuration used when requesting the labeling task.
	//
	// Types that are valid to be assigned to AnnotationRequestConfig:
	//	*AnnotatedDatasetMetadata_ImageClassificationConfig
	//	*AnnotatedDatasetMetadata_BoundingPolyConfig
	//	*AnnotatedDatasetMetadata_PolylineConfig
	//	*AnnotatedDatasetMetadata_SegmentationConfig
	//	*AnnotatedDatasetMetadata_VideoClassificationConfig
	//	*AnnotatedDatasetMetadata_ObjectDetectionConfig
	//	*AnnotatedDatasetMetadata_ObjectTrackingConfig
	//	*AnnotatedDatasetMetadata_EventConfig
	//	*AnnotatedDatasetMetadata_TextClassificationConfig
	//	*AnnotatedDatasetMetadata_TextEntityExtractionConfig
	AnnotationRequestConfig isAnnotatedDatasetMetadata_AnnotationRequestConfig `protobuf_oneof:"annotation_request_config"`
	XXX_NoUnkeyedLiteral    struct{}                                           `json:"-"`
	XXX_unrecognized        []byte                                             `json:"-"`
	XXX_sizecache           int32                                              `json:"-"`
}

func (m *AnnotatedDatasetMetadata) Reset()         { *m = AnnotatedDatasetMetadata{} }
func (m *AnnotatedDatasetMetadata) String() string { return proto.CompactTextString(m) }
func (*AnnotatedDatasetMetadata) ProtoMessage()    {}
func (*AnnotatedDatasetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{8}
}

func (m *AnnotatedDatasetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Unmarshal(m, b)
}
func (m *AnnotatedDatasetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Marshal(b, m, deterministic)
}
func (m *AnnotatedDatasetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotatedDatasetMetadata.Merge(m, src)
}
func (m *AnnotatedDatasetMetadata) XXX_Size() int {
	return xxx_messageInfo_AnnotatedDatasetMetadata.Size(m)
}
func (m *AnnotatedDatasetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotatedDatasetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotatedDatasetMetadata proto.InternalMessageInfo

func (m *AnnotatedDatasetMetadata) GetHumanAnnotationConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.HumanAnnotationConfig
	}
	return nil
}

type isAnnotatedDatasetMetadata_AnnotationRequestConfig interface {
	isAnnotatedDatasetMetadata_AnnotationRequestConfig()
}

type AnnotatedDatasetMetadata_ImageClassificationConfig struct {
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,2,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_BoundingPolyConfig struct {
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,3,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_PolylineConfig struct {
	PolylineConfig *PolylineConfig `protobuf:"bytes,4,opt,name=polyline_config,json=polylineConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_SegmentationConfig struct {
	SegmentationConfig *SegmentationConfig `protobuf:"bytes,5,opt,name=segmentation_config,json=segmentationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_VideoClassificationConfig struct {
	VideoClassificationConfig *VideoClassificationConfig `protobuf:"bytes,6,opt,name=video_classification_config,json=videoClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectDetectionConfig struct {
	ObjectDetectionConfig *ObjectDetectionConfig `protobuf:"bytes,7,opt,name=object_detection_config,json=objectDetectionConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_ObjectTrackingConfig struct {
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,8,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_EventConfig struct {
	EventConfig *EventConfig `protobuf:"bytes,9,opt,name=event_config,json=eventConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextClassificationConfig struct {
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,10,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

type AnnotatedDatasetMetadata_TextEntityExtractionConfig struct {
	TextEntityExtractionConfig *TextEntityExtractionConfig `protobuf:"bytes,11,opt,name=text_entity_extraction_config,json=textEntityExtractionConfig,proto3,oneof"`
}

func (*AnnotatedDatasetMetadata_ImageClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_BoundingPolyConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_PolylineConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {}

func (*AnnotatedDatasetMetadata_SegmentationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_VideoClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectDetectionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_ObjectTrackingConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_EventConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {}

func (*AnnotatedDatasetMetadata_TextClassificationConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (*AnnotatedDatasetMetadata_TextEntityExtractionConfig) isAnnotatedDatasetMetadata_AnnotationRequestConfig() {
}

func (m *AnnotatedDatasetMetadata) GetAnnotationRequestConfig() isAnnotatedDatasetMetadata_AnnotationRequestConfig {
	if m != nil {
		return m.AnnotationRequestConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetPolylineConfig() *PolylineConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_PolylineConfig); ok {
		return x.PolylineConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetSegmentationConfig() *SegmentationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_SegmentationConfig); ok {
		return x.SegmentationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetVideoClassificationConfig() *VideoClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_VideoClassificationConfig); ok {
		return x.VideoClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetObjectDetectionConfig() *ObjectDetectionConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectDetectionConfig); ok {
		return x.ObjectDetectionConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetEventConfig() *EventConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_EventConfig); ok {
		return x.EventConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (m *AnnotatedDatasetMetadata) GetTextEntityExtractionConfig() *TextEntityExtractionConfig {
	if x, ok := m.GetAnnotationRequestConfig().(*AnnotatedDatasetMetadata_TextEntityExtractionConfig); ok {
		return x.TextEntityExtractionConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AnnotatedDatasetMetadata) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AnnotatedDatasetMetadata_ImageClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_BoundingPolyConfig)(nil),
		(*AnnotatedDatasetMetadata_PolylineConfig)(nil),
		(*AnnotatedDatasetMetadata_SegmentationConfig)(nil),
		(*AnnotatedDatasetMetadata_VideoClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectDetectionConfig)(nil),
		(*AnnotatedDatasetMetadata_ObjectTrackingConfig)(nil),
		(*AnnotatedDatasetMetadata_EventConfig)(nil),
		(*AnnotatedDatasetMetadata_TextClassificationConfig)(nil),
		(*AnnotatedDatasetMetadata_TextEntityExtractionConfig)(nil),
	}
}

// Statistics about annotation specs.
type LabelStats struct {
	// Map of each annotation spec's example count. Key is the annotation spec
	// name and value is the number of examples for that annotation spec.
	ExampleCount         map[string]int64 `protobuf:"bytes,1,rep,name=example_count,json=exampleCount,proto3" json:"example_count,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *LabelStats) Reset()         { *m = LabelStats{} }
func (m *LabelStats) String() string { return proto.CompactTextString(m) }
func (*LabelStats) ProtoMessage()    {}
func (*LabelStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{9}
}

func (m *LabelStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelStats.Unmarshal(m, b)
}
func (m *LabelStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelStats.Marshal(b, m, deterministic)
}
func (m *LabelStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelStats.Merge(m, src)
}
func (m *LabelStats) XXX_Size() int {
	return xxx_messageInfo_LabelStats.Size(m)
}
func (m *LabelStats) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelStats.DiscardUnknown(m)
}

var xxx_messageInfo_LabelStats proto.InternalMessageInfo

func (m *LabelStats) GetExampleCount() map[string]int64 {
	if m != nil {
		return m.ExampleCount
	}
	return nil
}

// An Example is a piece of data and its annotation. For example, an image with
// label "house".
type Example struct {
	// Output only. The data part of Example.
	//
	// Types that are valid to be assigned to Payload:
	//	*Example_ImagePayload
	//	*Example_TextPayload
	//	*Example_VideoPayload
	//	*Example_AudioPayload
	Payload isExample_Payload `protobuf_oneof:"payload"`
	// Output only. Name of the example, in format of:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Annotations for the piece of data in Example.
	// One piece of data can have multiple annotations.
	Annotations          []*Annotation `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Example) Reset()         { *m = Example{} }
func (m *Example) String() string { return proto.CompactTextString(m) }
func (*Example) ProtoMessage()    {}
func (*Example) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{10}
}

func (m *Example) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Example.Unmarshal(m, b)
}
func (m *Example) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Example.Marshal(b, m, deterministic)
}
func (m *Example) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Example.Merge(m, src)
}
func (m *Example) XXX_Size() int {
	return xxx_messageInfo_Example.Size(m)
}
func (m *Example) XXX_DiscardUnknown() {
	xxx_messageInfo_Example.DiscardUnknown(m)
}

var xxx_messageInfo_Example proto.InternalMessageInfo

type isExample_Payload interface {
	isExample_Payload()
}

type Example_ImagePayload struct {
	ImagePayload *ImagePayload `protobuf:"bytes,2,opt,name=image_payload,json=imagePayload,proto3,oneof"`
}

type Example_TextPayload struct {
	TextPayload *TextPayload `protobuf:"bytes,6,opt,name=text_payload,json=textPayload,proto3,oneof"`
}

type Example_VideoPayload struct {
	VideoPayload *VideoPayload `protobuf:"bytes,7,opt,name=video_payload,json=videoPayload,proto3,oneof"`
}

type Example_AudioPayload struct {
	AudioPayload *AudioPayload `protobuf:"bytes,8,opt,name=audio_payload,json=audioPayload,proto3,oneof"`
}

func (*Example_ImagePayload) isExample_Payload() {}

func (*Example_TextPayload) isExample_Payload() {}

func (*Example_VideoPayload) isExample_Payload() {}

func (*Example_AudioPayload) isExample_Payload() {}

func (m *Example) GetPayload() isExample_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Example) GetImagePayload() *ImagePayload {
	if x, ok := m.GetPayload().(*Example_ImagePayload); ok {
		return x.ImagePayload
	}
	return nil
}

func (m *Example) GetTextPayload() *TextPayload {
	if x, ok := m.GetPayload().(*Example_TextPayload); ok {
		return x.TextPayload
	}
	return nil
}

func (m *Example) GetVideoPayload() *VideoPayload {
	if x, ok := m.GetPayload().(*Example_VideoPayload); ok {
		return x.VideoPayload
	}
	return nil
}

func (m *Example) GetAudioPayload() *AudioPayload {
	if x, ok := m.GetPayload().(*Example_AudioPayload); ok {
		return x.AudioPayload
	}
	return nil
}

func (m *Example) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Example) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Example) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Example_ImagePayload)(nil),
		(*Example_TextPayload)(nil),
		(*Example_VideoPayload)(nil),
		(*Example_AudioPayload)(nil),
	}
}

// Container of information about an image.
type ImagePayload struct {
	// Image format.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// A byte string of a full image.
	ImageThumbnail []byte `protobuf:"bytes,2,opt,name=image_thumbnail,json=imageThumbnail,proto3" json:"image_thumbnail,omitempty"`
	// Image uri from the user bucket.
	ImageUri             string   `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImagePayload) Reset()         { *m = ImagePayload{} }
func (m *ImagePayload) String() string { return proto.CompactTextString(m) }
func (*ImagePayload) ProtoMessage()    {}
func (*ImagePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{11}
}

func (m *ImagePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImagePayload.Unmarshal(m, b)
}
func (m *ImagePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImagePayload.Marshal(b, m, deterministic)
}
func (m *ImagePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImagePayload.Merge(m, src)
}
func (m *ImagePayload) XXX_Size() int {
	return xxx_messageInfo_ImagePayload.Size(m)
}
func (m *ImagePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ImagePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ImagePayload proto.InternalMessageInfo

func (m *ImagePayload) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *ImagePayload) GetImageThumbnail() []byte {
	if m != nil {
		return m.ImageThumbnail
	}
	return nil
}

func (m *ImagePayload) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

// Container of information about a piece of text.
type TextPayload struct {
	// Text content.
	TextContent          string   `protobuf:"bytes,1,opt,name=text_content,json=textContent,proto3" json:"text_content,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextPayload) Reset()         { *m = TextPayload{} }
func (m *TextPayload) String() string { return proto.CompactTextString(m) }
func (*TextPayload) ProtoMessage()    {}
func (*TextPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{12}
}

func (m *TextPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextPayload.Unmarshal(m, b)
}
func (m *TextPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextPayload.Marshal(b, m, deterministic)
}
func (m *TextPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextPayload.Merge(m, src)
}
func (m *TextPayload) XXX_Size() int {
	return xxx_messageInfo_TextPayload.Size(m)
}
func (m *TextPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_TextPayload.DiscardUnknown(m)
}

var xxx_messageInfo_TextPayload proto.InternalMessageInfo

func (m *TextPayload) GetTextContent() string {
	if m != nil {
		return m.TextContent
	}
	return ""
}

// Container of information of a video thumbnail.
type VideoThumbnail struct {
	// A byte string of the video frame.
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// Time offset relative to the beginning of the video, corresponding to the
	// video frame where the thumbnail has been extracted from.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoThumbnail) Reset()         { *m = VideoThumbnail{} }
func (m *VideoThumbnail) String() string { return proto.CompactTextString(m) }
func (*VideoThumbnail) ProtoMessage()    {}
func (*VideoThumbnail) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{13}
}

func (m *VideoThumbnail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoThumbnail.Unmarshal(m, b)
}
func (m *VideoThumbnail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoThumbnail.Marshal(b, m, deterministic)
}
func (m *VideoThumbnail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoThumbnail.Merge(m, src)
}
func (m *VideoThumbnail) XXX_Size() int {
	return xxx_messageInfo_VideoThumbnail.Size(m)
}
func (m *VideoThumbnail) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoThumbnail.DiscardUnknown(m)
}

var xxx_messageInfo_VideoThumbnail proto.InternalMessageInfo

func (m *VideoThumbnail) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *VideoThumbnail) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Container of information of a video.
type VideoPayload struct {
	// Video format.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Video uri from the user bucket.
	VideoUri string `protobuf:"bytes,2,opt,name=video_uri,json=videoUri,proto3" json:"video_uri,omitempty"`
	// The list of video thumbnails.
	VideoThumbnails []*VideoThumbnail `protobuf:"bytes,3,rep,name=video_thumbnails,json=videoThumbnails,proto3" json:"video_thumbnails,omitempty"`
	// FPS of the video.
	FrameRate            float32  `protobuf:"fixed32,4,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VideoPayload) Reset()         { *m = VideoPayload{} }
func (m *VideoPayload) String() string { return proto.CompactTextString(m) }
func (*VideoPayload) ProtoMessage()    {}
func (*VideoPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{14}
}

func (m *VideoPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoPayload.Unmarshal(m, b)
}
func (m *VideoPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoPayload.Marshal(b, m, deterministic)
}
func (m *VideoPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoPayload.Merge(m, src)
}
func (m *VideoPayload) XXX_Size() int {
	return xxx_messageInfo_VideoPayload.Size(m)
}
func (m *VideoPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoPayload.DiscardUnknown(m)
}

var xxx_messageInfo_VideoPayload proto.InternalMessageInfo

func (m *VideoPayload) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *VideoPayload) GetVideoUri() string {
	if m != nil {
		return m.VideoUri
	}
	return ""
}

func (m *VideoPayload) GetVideoThumbnails() []*VideoThumbnail {
	if m != nil {
		return m.VideoThumbnails
	}
	return nil
}

func (m *VideoPayload) GetFrameRate() float32 {
	if m != nil {
		return m.FrameRate
	}
	return 0
}

// Container of information of an audio.
type AudioPayload struct {
	// Audio uri in user bucket.
	AudioUri string `protobuf:"bytes,1,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
	// Sample rate in Hertz of the audio data sent in all
	// `RecognitionAudio` messages. This field is optional for `FLAC` and `WAV`
	// audio files and required for all other audio formats. For details,
	// see [AudioEncoding][google.cloud.datalabeling.v1beta1.AudioPayload.AudioEncoding].
	SampleRateHertz      int32    `protobuf:"varint,3,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AudioPayload) Reset()         { *m = AudioPayload{} }
func (m *AudioPayload) String() string { return proto.CompactTextString(m) }
func (*AudioPayload) ProtoMessage()    {}
func (*AudioPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_70a9435b8b2ad223, []int{15}
}

func (m *AudioPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AudioPayload.Unmarshal(m, b)
}
func (m *AudioPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AudioPayload.Marshal(b, m, deterministic)
}
func (m *AudioPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AudioPayload.Merge(m, src)
}
func (m *AudioPayload) XXX_Size() int {
	return xxx_messageInfo_AudioPayload.Size(m)
}
func (m *AudioPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_AudioPayload.DiscardUnknown(m)
}

var xxx_messageInfo_AudioPayload proto.InternalMessageInfo

func (m *AudioPayload) GetAudioUri() string {
	if m != nil {
		return m.AudioUri
	}
	return ""
}

func (m *AudioPayload) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.DataType", DataType_name, DataType_value)
	proto.RegisterType((*Dataset)(nil), "google.cloud.datalabeling.v1beta1.Dataset")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.datalabeling.v1beta1.InputConfig")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.datalabeling.v1beta1.GcsSource")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.datalabeling.v1beta1.OutputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.datalabeling.v1beta1.GcsDestination")
	proto.RegisterType((*GcsFolderDestination)(nil), "google.cloud.datalabeling.v1beta1.GcsFolderDestination")
	proto.RegisterType((*DataItem)(nil), "google.cloud.datalabeling.v1beta1.DataItem")
	proto.RegisterType((*AnnotatedDataset)(nil), "google.cloud.datalabeling.v1beta1.AnnotatedDataset")
	proto.RegisterType((*AnnotatedDatasetMetadata)(nil), "google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata")
	proto.RegisterType((*LabelStats)(nil), "google.cloud.datalabeling.v1beta1.LabelStats")
	proto.RegisterMapType((map[string]int64)(nil), "google.cloud.datalabeling.v1beta1.LabelStats.ExampleCountEntry")
	proto.RegisterType((*Example)(nil), "google.cloud.datalabeling.v1beta1.Example")
	proto.RegisterType((*ImagePayload)(nil), "google.cloud.datalabeling.v1beta1.ImagePayload")
	proto.RegisterType((*TextPayload)(nil), "google.cloud.datalabeling.v1beta1.TextPayload")
	proto.RegisterType((*VideoThumbnail)(nil), "google.cloud.datalabeling.v1beta1.VideoThumbnail")
	proto.RegisterType((*VideoPayload)(nil), "google.cloud.datalabeling.v1beta1.VideoPayload")
	proto.RegisterType((*AudioPayload)(nil), "google.cloud.datalabeling.v1beta1.AudioPayload")
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/dataset.proto", fileDescriptor_70a9435b8b2ad223)
}

var fileDescriptor_70a9435b8b2ad223 = []byte{
	// 1504 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0xef, 0x4e, 0x1b, 0x47,
	0x10, 0xe7, 0x30, 0x06, 0x7b, 0xce, 0x80, 0xd9, 0x42, 0x63, 0x20, 0x69, 0x89, 0xab, 0xaa, 0x51,
	0xda, 0x98, 0x42, 0xd4, 0x36, 0x4a, 0x5a, 0x45, 0x80, 0x9d, 0x80, 0x14, 0x02, 0x3a, 0x4c, 0xd2,
	0x46, 0x91, 0xae, 0xeb, 0xbb, 0xe5, 0xb8, 0xe4, 0xfe, 0xe5, 0x6e, 0xcf, 0xc2, 0xad, 0xd4, 0x0f,
	0xfd, 0xd0, 0x67, 0xe8, 0x63, 0x54, 0xea, 0x33, 0xf4, 0x15, 0xfa, 0x14, 0xf9, 0xd8, 0x07, 0xa8,
	0xf6, 0x8f, 0xef, 0x0f, 0xd8, 0xe1, 0x90, 0x9a, 0x7e, 0xbb, 0xfd, 0xcd, 0xce, 0x6f, 0x66, 0x76,
	0xd6, 0x33, 0xb3, 0x86, 0x75, 0xcb, 0xf7, 0x2d, 0x87, 0xac, 0x1b, 0x8e, 0x1f, 0x9b, 0xeb, 0x26,
	0xa6, 0xd8, 0xc1, 0x3d, 0xe2, 0xd8, 0x9e, 0xb5, 0xde, 0xdf, 0xe8, 0x11, 0x8a, 0x37, 0x38, 0x18,
	0x11, 0xda, 0x0a, 0x42, 0x9f, 0xfa, 0xe8, 0xa6, 0x50, 0x68, 0x71, 0x85, 0x56, 0x56, 0xa1, 0x25,
	0x15, 0x56, 0x36, 0x2f, 0xe7, 0xc4, 0x9e, 0xe7, 0x53, 0x4c, 0x6d, 0xdf, 0x13, 0xb4, 0x2b, 0x0f,
	0x2f, 0xd7, 0x39, 0x8d, 0x5d, 0xec, 0xe9, 0xa9, 0xa6, 0x6e, 0xf8, 0xde, 0x89, 0x6d, 0x49, 0x82,
	0x8f, 0x24, 0x01, 0x5f, 0xf5, 0xe2, 0x93, 0x75, 0x33, 0x0e, 0xb3, 0x06, 0xae, 0x9f, 0x97, 0x47,
	0x34, 0x8c, 0x0d, 0x19, 0xd5, 0xca, 0xc7, 0xe7, 0xa5, 0xd4, 0x76, 0x49, 0x44, 0xb1, 0x1b, 0x9c,
	0x53, 0xc7, 0x81, 0x9d, 0x71, 0x3e, 0x12, 0xd2, 0xe6, 0x3f, 0x0a, 0xcc, 0xb4, 0xc5, 0x31, 0x21,
	0x04, 0x53, 0x1e, 0x76, 0x49, 0x43, 0x59, 0x53, 0x6e, 0x55, 0x35, 0xfe, 0x8d, 0x6e, 0x42, 0xcd,
	0xb4, 0xa3, 0xc0, 0xc1, 0x03, 0x9d, 0xcb, 0x26, 0xb9, 0x4c, 0x95, 0xd8, 0x53, 0xb6, 0x65, 0x0d,
	0x54, 0x93, 0x44, 0x46, 0x68, 0x07, 0x8c, 0xb8, 0x51, 0x92, 0x3b, 0x52, 0x08, 0x3d, 0x00, 0xd5,
	0x08, 0x09, 0xa6, 0x44, 0x67, 0xce, 0x35, 0xa6, 0xd6, 0x94, 0x5b, 0xea, 0xe6, 0x4a, 0x4b, 0xe6,
	0x63, 0xe8, 0x79, 0xab, 0x3b, 0xf4, 0x5c, 0x03, 0xb1, 0x9d, 0x01, 0xe8, 0x08, 0x66, 0x6d, 0x2f,
	0x88, 0xa9, 0x3c, 0xb4, 0xa8, 0x51, 0x5e, 0x2b, 0xdd, 0x52, 0x37, 0x5b, 0xad, 0x4b, 0xd3, 0xd9,
	0xda, 0x63, 0x7a, 0x3b, 0x5c, 0x4d, 0xab, 0xd9, 0xe9, 0x22, 0x6a, 0xfe, 0xa1, 0x80, 0x9a, 0x91,
	0xa2, 0x7d, 0x00, 0xcb, 0x88, 0xf4, 0xc8, 0x8f, 0x43, 0x43, 0x04, 0xa9, 0x6e, 0x7e, 0x51, 0xc0,
	0xc2, 0x63, 0x23, 0x3a, 0xe2, 0x3a, 0xbb, 0x13, 0x5a, 0xd5, 0x1a, 0x2e, 0xd0, 0x2e, 0x54, 0xd9,
	0x76, 0x9d, 0x0e, 0x02, 0x71, 0x9c, 0x73, 0x9b, 0x9f, 0x17, 0x60, 0x63, 0x89, 0xe8, 0x0e, 0x02,
	0xa2, 0x55, 0x4c, 0xf9, 0xb5, 0x5d, 0x81, 0x69, 0xe1, 0x54, 0xb3, 0x03, 0xd5, 0xc4, 0x1a, 0x5a,
	0x85, 0xaa, 0x38, 0x94, 0x38, 0xb4, 0x65, 0xbe, 0x2a, 0x1c, 0x38, 0x0e, 0x6d, 0x26, 0x74, 0x6d,
	0x97, 0x08, 0xeb, 0x22, 0x61, 0x15, 0x06, 0x30, 0xc2, 0xe6, 0x5b, 0x05, 0x6a, 0x07, 0x31, 0x4d,
	0x43, 0x7f, 0x09, 0xf3, 0x2c, 0x74, 0x93, 0x44, 0xd4, 0xf6, 0xf8, 0xdd, 0xe0, 0x84, 0xea, 0xe6,
	0x46, 0xb1, 0xf8, 0xdb, 0xa9, 0xe2, 0xee, 0x84, 0x36, 0x67, 0xe5, 0x10, 0xe4, 0xc3, 0x87, 0x8c,
	0xfd, 0xc4, 0x77, 0x4c, 0x12, 0xe6, 0x8c, 0x88, 0x43, 0xfe, 0xa6, 0x98, 0x91, 0x47, 0x5c, 0x3f,
	0x6f, 0x6a, 0xd1, 0x1a, 0x81, 0x6f, 0xcf, 0xf2, 0xdb, 0x38, 0x5c, 0x36, 0x9f, 0xc0, 0x5c, 0xde,
	0x47, 0x74, 0x03, 0xc0, 0xe7, 0xf1, 0x67, 0xce, 0xae, 0x2a, 0x90, 0x4b, 0x0f, 0x6f, 0x1b, 0x16,
	0x47, 0x39, 0x83, 0x6e, 0xc3, 0x82, 0xe4, 0x94, 0x81, 0xa6, 0xd4, 0xf3, 0x42, 0x20, 0x74, 0x8e,
	0x43, 0xbb, 0xf9, 0x5b, 0x09, 0x2a, 0x2c, 0xd1, 0x7b, 0x94, 0xb8, 0xe8, 0x19, 0xcc, 0xda, 0x2e,
	0xb6, 0x88, 0x1e, 0xe0, 0x81, 0xe3, 0x63, 0x53, 0x9e, 0xca, 0x7a, 0x91, 0xcb, 0xcd, 0xf4, 0x0e,
	0x85, 0xda, 0xee, 0x84, 0x56, 0xb3, 0x33, 0x6b, 0x74, 0x04, 0x35, 0x4a, 0xce, 0x68, 0x42, 0x5b,
	0xe2, 0xb4, 0x45, 0x7e, 0x33, 0x5d, 0x72, 0x46, 0x53, 0x56, 0x95, 0xa6, 0x4b, 0xe6, 0x6c, 0xdf,
	0x36, 0x89, 0x9f, 0xb0, 0x4e, 0x15, 0x76, 0xf6, 0x19, 0xd3, 0xcb, 0x38, 0xdb, 0xcf, 0xac, 0x19,
	0x2f, 0x8e, 0x4d, 0x3b, 0xe5, 0x2d, 0x17, 0xe6, 0xdd, 0x62, 0x7a, 0x19, 0x5e, 0x9c, 0x59, 0x8f,
	0xaa, 0x67, 0xdb, 0x55, 0x98, 0x91, 0x56, 0x9a, 0x6f, 0xa7, 0xa0, 0xbe, 0x25, 0x0a, 0x22, 0x31,
	0xff, 0xdb, 0x1a, 0x58, 0xbd, 0x58, 0x03, 0x7f, 0x84, 0x85, 0x4c, 0x03, 0x90, 0x85, 0xa6, 0xc4,
	0x4b, 0xc3, 0xdd, 0x22, 0x81, 0x26, 0xba, 0xa2, 0x02, 0x68, 0x75, 0x7c, 0x0e, 0x41, 0x2f, 0x60,
	0x3e, 0x63, 0x81, 0xdf, 0xdf, 0x0a, 0xe7, 0xdf, 0xb8, 0x12, 0x3f, 0x2f, 0x40, 0x73, 0x38, 0xb7,
	0x46, 0x9f, 0xc0, 0x2c, 0x39, 0xc3, 0x6e, 0xe0, 0x10, 0xdd, 0xf0, 0x63, 0x8f, 0xf2, 0xd4, 0x97,
	0xb4, 0x9a, 0x04, 0x77, 0x18, 0x86, 0xbe, 0x86, 0x6b, 0x86, 0xcf, 0x96, 0x94, 0x98, 0x7a, 0x7e,
	0x7b, 0x99, 0x6f, 0x5f, 0x4a, 0xc4, 0x9d, 0xac, 0xde, 0x53, 0x50, 0xb9, 0x3f, 0x7a, 0x44, 0x31,
	0x8d, 0x1a, 0xd3, 0x3c, 0xfb, 0x77, 0x0a, 0x38, 0xfd, 0x84, 0x01, 0x47, 0x4c, 0x49, 0x03, 0x27,
	0xf9, 0x3e, 0xdf, 0x6e, 0x66, 0xae, 0xd4, 0x6e, 0x9e, 0x43, 0xc5, 0x25, 0x14, 0x33, 0x7b, 0x0d,
	0xe0, 0x9a, 0x0f, 0x8a, 0x1f, 0x5f, 0x72, 0x8f, 0xf6, 0x25, 0x85, 0x96, 0x90, 0x35, 0x7f, 0x07,
	0x68, 0x8c, 0xdb, 0x86, 0x02, 0xb8, 0x36, 0x66, 0x48, 0x90, 0xc5, 0xf8, 0x5e, 0x01, 0x27, 0x76,
	0x19, 0x43, 0x9a, 0x48, 0xd9, 0xf8, 0x96, 0x4e, 0x47, 0xc1, 0xe8, 0x17, 0x58, 0x15, 0x95, 0xc7,
	0x70, 0x70, 0x14, 0xd9, 0x27, 0xb6, 0x91, 0xb3, 0x2a, 0xea, 0xd0, 0xb7, 0x45, 0xeb, 0xd0, 0x4e,
	0x8e, 0x44, 0x98, 0xd8, 0x9d, 0xd0, 0x96, 0xed, 0x71, 0x42, 0x64, 0xc3, 0x62, 0xcf, 0x8f, 0x3d,
	0xd3, 0xf6, 0x2c, 0x3d, 0xf0, 0x9d, 0xc1, 0xd0, 0xb0, 0xa8, 0x54, 0x5f, 0x15, 0x30, 0xbc, 0x2d,
	0xd5, 0x0f, 0x7d, 0x67, 0x90, 0x58, 0x44, 0xbd, 0x0b, 0x28, 0xeb, 0x70, 0xcc, 0x82, 0x63, 0x7b,
	0x64, 0x68, 0x65, 0xaa, 0x70, 0x87, 0x3b, 0x94, 0x9a, 0x89, 0x85, 0xb9, 0x20, 0x87, 0xa0, 0x53,
	0xf8, 0x20, 0x22, 0x96, 0x4b, 0xbc, 0x7c, 0xda, 0xca, 0x85, 0xe3, 0x38, 0xca, 0x68, 0xa7, 0x71,
	0x44, 0x17, 0x50, 0x96, 0x32, 0x51, 0x7f, 0x47, 0xa7, 0x6c, 0xba, 0x70, 0xca, 0x78, 0x35, 0x1e,
	0x97, 0xb2, 0xfe, 0x38, 0x21, 0x0a, 0xe1, 0x9a, 0xdf, 0x7b, 0x45, 0x0c, 0xaa, 0x9b, 0x84, 0x12,
	0x23, 0x6b, 0x7b, 0xa6, 0xf0, 0x25, 0x3d, 0xe0, 0x0c, 0xed, 0x21, 0x41, 0x62, 0x77, 0xc9, 0x1f,
	0x25, 0x60, 0xf3, 0x83, 0xb4, 0x49, 0x43, 0x6c, 0xbc, 0x66, 0xb7, 0x45, 0x9a, 0xac, 0x14, 0x9e,
	0x1f, 0x84, 0xc9, 0xae, 0xd4, 0x4f, 0x2c, 0x2e, 0xfa, 0x23, 0x70, 0xd6, 0x39, 0x49, 0x9f, 0x78,
	0xc3, 0x71, 0x93, 0x97, 0xf2, 0x62, 0x9d, 0xb3, 0xc3, 0xd4, 0x12, 0x76, 0x95, 0xa4, 0x4b, 0xf4,
	0x33, 0xac, 0xf0, 0x76, 0x3c, 0x3a, 0x71, 0xc5, 0xcb, 0x0c, 0x6b, 0xce, 0x63, 0xf2, 0xd6, 0xa0,
	0x63, 0x64, 0xe8, 0x57, 0x05, 0x6e, 0x70, 0xeb, 0xc4, 0xa3, 0x36, 0x1d, 0xe8, 0xe4, 0x8c, 0x1d,
	0x65, 0xd6, 0x01, 0x95, 0x3b, 0xf0, 0x5d, 0x41, 0x07, 0x3a, 0x9c, 0xa6, 0x93, 0xb0, 0x24, 0x2e,
	0xf0, 0x18, 0x47, 0x4b, 0xb7, 0x57, 0x61, 0x39, 0x53, 0xda, 0x42, 0xf2, 0x26, 0x26, 0xd1, 0xf0,
	0x8c, 0x9b, 0x7f, 0x2a, 0x00, 0x69, 0x2d, 0x47, 0xe6, 0xf9, 0x66, 0xa3, 0xf0, 0x89, 0xff, 0xe1,
	0x95, 0x3a, 0x42, 0x2b, 0xdb, 0x62, 0x3a, 0x1e, 0x0d, 0x07, 0xf9, 0x6e, 0xb5, 0xf2, 0x10, 0x16,
	0x2e, 0x6c, 0x41, 0x75, 0x28, 0xbd, 0x26, 0x03, 0xd9, 0xfd, 0xd9, 0x27, 0x5a, 0x84, 0x72, 0x1f,
	0x3b, 0xb1, 0xe8, 0xfa, 0x25, 0x4d, 0x2c, 0xee, 0x4f, 0xde, 0x53, 0x9a, 0x7f, 0x97, 0x60, 0x46,
	0x32, 0xfc, 0x6f, 0x73, 0xdc, 0xf4, 0x7b, 0x99, 0xe3, 0x66, 0xde, 0xd3, 0x1c, 0x57, 0x79, 0x6f,
	0x73, 0x1c, 0x3a, 0x00, 0x35, 0xf3, 0x98, 0x95, 0x6f, 0xc2, 0x3b, 0x57, 0x1a, 0x74, 0xb4, 0x2c,
	0x43, 0x76, 0x30, 0x7c, 0x03, 0xb5, 0x6c, 0x52, 0xf2, 0x4f, 0x02, 0x25, 0xff, 0x24, 0x40, 0x9f,
	0xc1, 0xbc, 0xc8, 0x3c, 0x3d, 0x8d, 0xdd, 0x9e, 0x87, 0x6d, 0x87, 0xe7, 0xbe, 0xa6, 0xcd, 0x71,
	0xb8, 0x3b, 0x44, 0xf9, 0x93, 0x8d, 0x6f, 0x64, 0x6f, 0x83, 0x92, 0x7c, 0xb2, 0x31, 0x80, 0x3d,
	0x0a, 0xbe, 0x04, 0x35, 0x93, 0x30, 0x36, 0x71, 0x8a, 0x7a, 0xe1, 0x7b, 0x94, 0xf0, 0x1f, 0x00,
	0x9f, 0x27, 0xf9, 0x4f, 0x5c, 0x40, 0xcd, 0x57, 0x30, 0xc7, 0x93, 0x91, 0x1a, 0xb8, 0x0e, 0xd5,
	0xd4, 0x07, 0x85, 0xfb, 0x90, 0x02, 0xe8, 0x3e, 0xa8, 0x6c, 0x1a, 0xd2, 0xfd, 0x93, 0x93, 0x88,
	0x50, 0x79, 0x3f, 0x97, 0x2f, 0x0c, 0x45, 0x6d, 0xf9, 0xdf, 0x83, 0x06, 0x6c, 0xf7, 0x01, 0xdf,
	0xdc, 0xfc, 0x4b, 0x81, 0x5a, 0x36, 0xf3, 0xef, 0x3e, 0x91, 0x55, 0xa8, 0x8a, 0xeb, 0xc5, 0x02,
	0x95, 0x2f, 0x28, 0x0e, 0xb0, 0xe7, 0xd5, 0x4b, 0xa8, 0x0b, 0x61, 0xe2, 0x59, 0xd4, 0x28, 0xf1,
	0xe4, 0x6d, 0x14, 0xbd, 0x7e, 0x49, 0xc4, 0xda, 0x7c, 0x3f, 0xb7, 0x8e, 0xd8, 0xdb, 0xee, 0x24,
	0xc4, 0x2e, 0xd1, 0x43, 0x4c, 0xc5, 0xff, 0x0c, 0x93, 0x5a, 0x95, 0x23, 0x1a, 0xa6, 0xa4, 0xf9,
	0x1c, 0x6a, 0xd9, 0x8b, 0xc6, 0x3c, 0x15, 0x17, 0x36, 0xf3, 0x8a, 0xe6, 0x00, 0xf3, 0xf4, 0x36,
	0x2c, 0x44, 0xa2, 0x08, 0x31, 0x32, 0xfd, 0x94, 0x84, 0xf4, 0x27, 0x9e, 0xb7, 0xb2, 0x36, 0x2f,
	0x04, 0x8c, 0x73, 0x97, 0xc1, 0xb7, 0x0f, 0xc5, 0x93, 0x8e, 0x87, 0xbf, 0x0c, 0x4b, 0xed, 0xad,
	0xee, 0x96, 0xde, 0xfd, 0xe1, 0xb0, 0xa3, 0x1f, 0x3f, 0x3d, 0x3a, 0xec, 0xec, 0xec, 0x3d, 0xda,
	0xeb, 0xb4, 0xeb, 0x13, 0xa8, 0x0a, 0xe5, 0xbd, 0xfd, 0xad, 0xc7, 0x9d, 0xba, 0xc2, 0x3e, 0x9f,
	0xed, 0xb5, 0x3b, 0x07, 0xf5, 0x49, 0x54, 0x81, 0xa9, 0x6e, 0xe7, 0xfb, 0x6e, 0x7d, 0x8a, 0x81,
	0x5b, 0xc7, 0xed, 0xbd, 0x83, 0x7a, 0x79, 0xfb, 0x0c, 0x3e, 0x35, 0x7c, 0xf7, 0xf2, 0x23, 0x39,
	0x54, 0x5e, 0xec, 0xcb, 0x4d, 0x96, 0xef, 0x60, 0xcf, 0x6a, 0xf9, 0xa1, 0xb5, 0x6e, 0x11, 0x8f,
	0x67, 0x54, 0xfe, 0x47, 0x86, 0x03, 0x3b, 0x7a, 0xc7, 0xff, 0x53, 0x0f, 0xb2, 0x60, 0x6f, 0x9a,
	0x6b, 0xde, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x45, 0x58, 0x65, 0x41, 0x60, 0x13, 0x00, 0x00,
}
