// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/recommendation_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [RecommendationService.GetRecommendation][google.ads.googleads.v1.services.RecommendationService.GetRecommendation].
type GetRecommendationRequest struct {
	// The resource name of the recommendation to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{0}
}

func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(m, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v1.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationRequest struct {
	// The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to apply recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*ApplyRecommendationOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried
	// out as a transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationRequest) Reset()         { *m = ApplyRecommendationRequest{} }
func (m *ApplyRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationRequest) ProtoMessage()    {}
func (*ApplyRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{1}
}

func (m *ApplyRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationRequest.Unmarshal(m, b)
}
func (m *ApplyRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationRequest.Merge(m, src)
}
func (m *ApplyRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationRequest.Size(m)
}
func (m *ApplyRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationRequest proto.InternalMessageInfo

func (m *ApplyRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *ApplyRecommendationRequest) GetOperations() []*ApplyRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ApplyRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Information about the operation to apply a recommendation and any parameters
// to customize it.
type ApplyRecommendationOperation struct {
	// The resource name of the recommendation to apply.
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Parameters to use when applying the recommendation.
	//
	// Types that are valid to be assigned to ApplyParameters:
	//	*ApplyRecommendationOperation_CampaignBudget
	//	*ApplyRecommendationOperation_TextAd
	//	*ApplyRecommendationOperation_Keyword
	//	*ApplyRecommendationOperation_TargetCpaOptIn
	//	*ApplyRecommendationOperation_CalloutExtension
	//	*ApplyRecommendationOperation_CallExtension
	//	*ApplyRecommendationOperation_SitelinkExtension
	//	*ApplyRecommendationOperation_MoveUnusedBudget
	ApplyParameters      isApplyRecommendationOperation_ApplyParameters `protobuf_oneof:"apply_parameters"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *ApplyRecommendationOperation) Reset()         { *m = ApplyRecommendationOperation{} }
func (m *ApplyRecommendationOperation) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationOperation) ProtoMessage()    {}
func (*ApplyRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2}
}

func (m *ApplyRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation.Merge(m, src)
}
func (m *ApplyRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation.Size(m)
}
func (m *ApplyRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation proto.InternalMessageInfo

func (m *ApplyRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

type isApplyRecommendationOperation_ApplyParameters interface {
	isApplyRecommendationOperation_ApplyParameters()
}

type ApplyRecommendationOperation_CampaignBudget struct {
	CampaignBudget *ApplyRecommendationOperation_CampaignBudgetParameters `protobuf:"bytes,2,opt,name=campaign_budget,json=campaignBudget,proto3,oneof"`
}

type ApplyRecommendationOperation_TextAd struct {
	TextAd *ApplyRecommendationOperation_TextAdParameters `protobuf:"bytes,3,opt,name=text_ad,json=textAd,proto3,oneof"`
}

type ApplyRecommendationOperation_Keyword struct {
	Keyword *ApplyRecommendationOperation_KeywordParameters `protobuf:"bytes,4,opt,name=keyword,proto3,oneof"`
}

type ApplyRecommendationOperation_TargetCpaOptIn struct {
	TargetCpaOptIn *ApplyRecommendationOperation_TargetCpaOptInParameters `protobuf:"bytes,5,opt,name=target_cpa_opt_in,json=targetCpaOptIn,proto3,oneof"`
}

type ApplyRecommendationOperation_CalloutExtension struct {
	CalloutExtension *ApplyRecommendationOperation_CalloutExtensionParameters `protobuf:"bytes,6,opt,name=callout_extension,json=calloutExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_CallExtension struct {
	CallExtension *ApplyRecommendationOperation_CallExtensionParameters `protobuf:"bytes,7,opt,name=call_extension,json=callExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_SitelinkExtension struct {
	SitelinkExtension *ApplyRecommendationOperation_SitelinkExtensionParameters `protobuf:"bytes,8,opt,name=sitelink_extension,json=sitelinkExtension,proto3,oneof"`
}

type ApplyRecommendationOperation_MoveUnusedBudget struct {
	MoveUnusedBudget *ApplyRecommendationOperation_MoveUnusedBudgetParameters `protobuf:"bytes,9,opt,name=move_unused_budget,json=moveUnusedBudget,proto3,oneof"`
}

func (*ApplyRecommendationOperation_CampaignBudget) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TextAd) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_Keyword) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_TargetCpaOptIn) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_CalloutExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_CallExtension) isApplyRecommendationOperation_ApplyParameters() {}

func (*ApplyRecommendationOperation_SitelinkExtension) isApplyRecommendationOperation_ApplyParameters() {
}

func (*ApplyRecommendationOperation_MoveUnusedBudget) isApplyRecommendationOperation_ApplyParameters() {
}

func (m *ApplyRecommendationOperation) GetApplyParameters() isApplyRecommendationOperation_ApplyParameters {
	if m != nil {
		return m.ApplyParameters
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCampaignBudget() *ApplyRecommendationOperation_CampaignBudgetParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CampaignBudget); ok {
		return x.CampaignBudget
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTextAd() *ApplyRecommendationOperation_TextAdParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TextAd); ok {
		return x.TextAd
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetKeyword() *ApplyRecommendationOperation_KeywordParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetTargetCpaOptIn() *ApplyRecommendationOperation_TargetCpaOptInParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_TargetCpaOptIn); ok {
		return x.TargetCpaOptIn
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCalloutExtension() *ApplyRecommendationOperation_CalloutExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CalloutExtension); ok {
		return x.CalloutExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetCallExtension() *ApplyRecommendationOperation_CallExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_CallExtension); ok {
		return x.CallExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetSitelinkExtension() *ApplyRecommendationOperation_SitelinkExtensionParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_SitelinkExtension); ok {
		return x.SitelinkExtension
	}
	return nil
}

func (m *ApplyRecommendationOperation) GetMoveUnusedBudget() *ApplyRecommendationOperation_MoveUnusedBudgetParameters {
	if x, ok := m.GetApplyParameters().(*ApplyRecommendationOperation_MoveUnusedBudget); ok {
		return x.MoveUnusedBudget
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ApplyRecommendationOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ApplyRecommendationOperation_CampaignBudget)(nil),
		(*ApplyRecommendationOperation_TextAd)(nil),
		(*ApplyRecommendationOperation_Keyword)(nil),
		(*ApplyRecommendationOperation_TargetCpaOptIn)(nil),
		(*ApplyRecommendationOperation_CalloutExtension)(nil),
		(*ApplyRecommendationOperation_CallExtension)(nil),
		(*ApplyRecommendationOperation_SitelinkExtension)(nil),
		(*ApplyRecommendationOperation_MoveUnusedBudget)(nil),
	}
}

// Parameters to use when applying a campaign budget recommendation.
type ApplyRecommendationOperation_CampaignBudgetParameters struct {
	// New budget amount to set for target budget resource. This is a required
	// field.
	NewBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=new_budget_amount_micros,json=newBudgetAmountMicros,proto3" json:"new_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}             `json:"-"`
	XXX_unrecognized      []byte               `json:"-"`
	XXX_sizecache         int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) Reset() {
	*m = ApplyRecommendationOperation_CampaignBudgetParameters{}
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CampaignBudgetParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 0}
}

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CampaignBudgetParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CampaignBudgetParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CampaignBudgetParameters) GetNewBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying a text ad recommendation.
type ApplyRecommendationOperation_TextAdParameters struct {
	// New ad to add to recommended ad group. All necessary fields need to be
	// set in this message. This is a required field.
	Ad                   *resources.Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ApplyRecommendationOperation_TextAdParameters) Reset() {
	*m = ApplyRecommendationOperation_TextAdParameters{}
}
func (m *ApplyRecommendationOperation_TextAdParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TextAdParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TextAdParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 1}
}

func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TextAdParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TextAdParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TextAdParameters) GetAd() *resources.Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

// Parameters to use when applying keyword recommendation.
type ApplyRecommendationOperation_KeywordParameters struct {
	// The ad group resource to add keyword to. This is a required field.
	AdGroup *wrappers.StringValue `protobuf:"bytes,1,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The match type of the keyword. This is a required field.
	MatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=match_type,json=matchType,proto3,enum=google.ads.googleads.v1.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"match_type,omitempty"`
	// Optional, CPC bid to set for the keyword. If not set, keyword will use
	// bid based on bidding strategy used by target ad group.
	CpcBidMicros         *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_KeywordParameters) Reset() {
	*m = ApplyRecommendationOperation_KeywordParameters{}
}
func (m *ApplyRecommendationOperation_KeywordParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_KeywordParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_KeywordParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 2}
}

func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.Size(m)
}
func (m *ApplyRecommendationOperation_KeywordParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_KeywordParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_KeywordParameters) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.MatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

func (m *ApplyRecommendationOperation_KeywordParameters) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

// Parameters to use when applying Target CPA recommendation.
type ApplyRecommendationOperation_TargetCpaOptInParameters struct {
	// Average CPA to use for Target CPA bidding strategy. This is a required
	// field.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// Optional, budget amount to set for the campaign.
	NewCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=new_campaign_budget_amount_micros,json=newCampaignBudgetAmountMicros,proto3" json:"new_campaign_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) Reset() {
	*m = ApplyRecommendationOperation_TargetCpaOptInParameters{}
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_TargetCpaOptInParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 3}
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.Size(m)
}
func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_TargetCpaOptInParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *ApplyRecommendationOperation_TargetCpaOptInParameters) GetNewCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.NewCampaignBudgetAmountMicros
	}
	return nil
}

// Parameters to use when applying callout extension recommendation.
type ApplyRecommendationOperation_CalloutExtensionParameters struct {
	// Callout extensions to be added. This is a required field.
	CalloutExtensions    []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=callout_extensions,json=calloutExtensions,proto3" json:"callout_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_CalloutExtensionParameters{}
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CalloutExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CalloutExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 4}
}

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CalloutExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CalloutExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CalloutExtensionParameters) GetCalloutExtensions() []*common.CalloutFeedItem {
	if m != nil {
		return m.CalloutExtensions
	}
	return nil
}

// Parameters to use when applying call extension recommendation.
type ApplyRecommendationOperation_CallExtensionParameters struct {
	// Call extensions to be added. This is a required field.
	CallExtensions       []*common.CallFeedItem `protobuf:"bytes,1,rep,name=call_extensions,json=callExtensions,proto3" json:"call_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ApplyRecommendationOperation_CallExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_CallExtensionParameters{}
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_CallExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_CallExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 5}
}

func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_CallExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_CallExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_CallExtensionParameters) GetCallExtensions() []*common.CallFeedItem {
	if m != nil {
		return m.CallExtensions
	}
	return nil
}

// Parameters to use when applying call extension recommendation.
type ApplyRecommendationOperation_SitelinkExtensionParameters struct {
	// Sitelink extensions to be added. This is a required field.
	SitelinkExtensions   []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=sitelink_extensions,json=sitelinkExtensions,proto3" json:"sitelink_extensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) Reset() {
	*m = ApplyRecommendationOperation_SitelinkExtensionParameters{}
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_SitelinkExtensionParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_SitelinkExtensionParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 6}
}

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.Size(m)
}
func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_SitelinkExtensionParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_SitelinkExtensionParameters) GetSitelinkExtensions() []*common.SitelinkFeedItem {
	if m != nil {
		return m.SitelinkExtensions
	}
	return nil
}

// Parameters to use when applying move unused budget recommendation.
type ApplyRecommendationOperation_MoveUnusedBudgetParameters struct {
	// Budget amount to move from excess budget to constrained budget. This is
	// a required field.
	BudgetMicrosToMove   *wrappers.Int64Value `protobuf:"bytes,1,opt,name=budget_micros_to_move,json=budgetMicrosToMove,proto3" json:"budget_micros_to_move,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) Reset() {
	*m = ApplyRecommendationOperation_MoveUnusedBudgetParameters{}
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) String() string {
	return proto.CompactTextString(m)
}
func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) ProtoMessage() {}
func (*ApplyRecommendationOperation_MoveUnusedBudgetParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{2, 7}
}

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Unmarshal(m, b)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Merge(m, src)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.Size(m)
}
func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationOperation_MoveUnusedBudgetParameters proto.InternalMessageInfo

func (m *ApplyRecommendationOperation_MoveUnusedBudgetParameters) GetBudgetMicrosToMove() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicrosToMove
	}
	return nil
}

// Response message for [RecommendationService.ApplyRecommendation][google.ads.googleads.v1.services.RecommendationService.ApplyRecommendation].
type ApplyRecommendationResponse struct {
	// Results of operations to apply recommendations.
	Results []*ApplyRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ApplyRecommendationResponse) Reset()         { *m = ApplyRecommendationResponse{} }
func (m *ApplyRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResponse) ProtoMessage()    {}
func (*ApplyRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{3}
}

func (m *ApplyRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResponse.Unmarshal(m, b)
}
func (m *ApplyRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResponse.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResponse.Merge(m, src)
}
func (m *ApplyRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResponse.Size(m)
}
func (m *ApplyRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResponse proto.InternalMessageInfo

func (m *ApplyRecommendationResponse) GetResults() []*ApplyRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *ApplyRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of applying a recommendation.
type ApplyRecommendationResult struct {
	// Returned for successful applies.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplyRecommendationResult) Reset()         { *m = ApplyRecommendationResult{} }
func (m *ApplyRecommendationResult) String() string { return proto.CompactTextString(m) }
func (*ApplyRecommendationResult) ProtoMessage()    {}
func (*ApplyRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{4}
}

func (m *ApplyRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplyRecommendationResult.Unmarshal(m, b)
}
func (m *ApplyRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplyRecommendationResult.Marshal(b, m, deterministic)
}
func (m *ApplyRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplyRecommendationResult.Merge(m, src)
}
func (m *ApplyRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_ApplyRecommendationResult.Size(m)
}
func (m *ApplyRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplyRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_ApplyRecommendationResult proto.InternalMessageInfo

func (m *ApplyRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [RecommendationService.DismissRecommendation][google.ads.googleads.v1.services.RecommendationService.DismissRecommendation].
type DismissRecommendationRequest struct {
	// The ID of the customer with the recommendation.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to dismiss recommendations.
	// If partial_failure=false all recommendations should be of the same type
	// There is a limit of 100 operations per request.
	Operations []*DismissRecommendationRequest_DismissRecommendationOperation `protobuf:"bytes,3,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, operations will be carried in a
	// single transaction if and only if they are all valid.
	// Default is false.
	PartialFailure       bool     `protobuf:"varint,2,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest) Reset()         { *m = DismissRecommendationRequest{} }
func (m *DismissRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationRequest) ProtoMessage()    {}
func (*DismissRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{5}
}

func (m *DismissRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest.Merge(m, src)
}
func (m *DismissRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest.Size(m)
}
func (m *DismissRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest proto.InternalMessageInfo

func (m *DismissRecommendationRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *DismissRecommendationRequest) GetOperations() []*DismissRecommendationRequest_DismissRecommendationOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *DismissRecommendationRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

// Operation to dismiss a single recommendation identified by resource_name.
type DismissRecommendationRequest_DismissRecommendationOperation struct {
	// The resource name of the recommendation to dismiss.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationRequest_DismissRecommendationOperation) Reset() {
	*m = DismissRecommendationRequest_DismissRecommendationOperation{}
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationRequest_DismissRecommendationOperation) ProtoMessage() {}
func (*DismissRecommendationRequest_DismissRecommendationOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{5, 0}
}

func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Unmarshal(m, b)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Merge(m, src)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.Size(m)
}
func (m *DismissRecommendationRequest_DismissRecommendationOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationRequest_DismissRecommendationOperation proto.InternalMessageInfo

func (m *DismissRecommendationRequest_DismissRecommendationOperation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Response message for [RecommendationService.DismissRecommendation][google.ads.googleads.v1.services.RecommendationService.DismissRecommendation].
type DismissRecommendationResponse struct {
	// Results of operations to dismiss recommendations.
	Results []*DismissRecommendationResponse_DismissRecommendationResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors)
	// we return the RPC level error.
	PartialFailureError  *status.Status `protobuf:"bytes,2,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DismissRecommendationResponse) Reset()         { *m = DismissRecommendationResponse{} }
func (m *DismissRecommendationResponse) String() string { return proto.CompactTextString(m) }
func (*DismissRecommendationResponse) ProtoMessage()    {}
func (*DismissRecommendationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{6}
}

func (m *DismissRecommendationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse.Merge(m, src)
}
func (m *DismissRecommendationResponse) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse.Size(m)
}
func (m *DismissRecommendationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse proto.InternalMessageInfo

func (m *DismissRecommendationResponse) GetResults() []*DismissRecommendationResponse_DismissRecommendationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *DismissRecommendationResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

// The result of dismissing a recommendation.
type DismissRecommendationResponse_DismissRecommendationResult struct {
	// Returned for successful dismissals.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DismissRecommendationResponse_DismissRecommendationResult) Reset() {
	*m = DismissRecommendationResponse_DismissRecommendationResult{}
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) String() string {
	return proto.CompactTextString(m)
}
func (*DismissRecommendationResponse_DismissRecommendationResult) ProtoMessage() {}
func (*DismissRecommendationResponse_DismissRecommendationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a744af7243d0735a, []int{6, 0}
}

func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Unmarshal(m, b)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Marshal(b, m, deterministic)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Merge(m, src)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_Size() int {
	return xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.Size(m)
}
func (m *DismissRecommendationResponse_DismissRecommendationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult.DiscardUnknown(m)
}

var xxx_messageInfo_DismissRecommendationResponse_DismissRecommendationResult proto.InternalMessageInfo

func (m *DismissRecommendationResponse_DismissRecommendationResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.ads.googleads.v1.services.GetRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationRequest)(nil), "google.ads.googleads.v1.services.ApplyRecommendationRequest")
	proto.RegisterType((*ApplyRecommendationOperation)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation")
	proto.RegisterType((*ApplyRecommendationOperation_CampaignBudgetParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.CampaignBudgetParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TextAdParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.TextAdParameters")
	proto.RegisterType((*ApplyRecommendationOperation_KeywordParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.KeywordParameters")
	proto.RegisterType((*ApplyRecommendationOperation_TargetCpaOptInParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.TargetCpaOptInParameters")
	proto.RegisterType((*ApplyRecommendationOperation_CalloutExtensionParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.CalloutExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_CallExtensionParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.CallExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_SitelinkExtensionParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.SitelinkExtensionParameters")
	proto.RegisterType((*ApplyRecommendationOperation_MoveUnusedBudgetParameters)(nil), "google.ads.googleads.v1.services.ApplyRecommendationOperation.MoveUnusedBudgetParameters")
	proto.RegisterType((*ApplyRecommendationResponse)(nil), "google.ads.googleads.v1.services.ApplyRecommendationResponse")
	proto.RegisterType((*ApplyRecommendationResult)(nil), "google.ads.googleads.v1.services.ApplyRecommendationResult")
	proto.RegisterType((*DismissRecommendationRequest)(nil), "google.ads.googleads.v1.services.DismissRecommendationRequest")
	proto.RegisterType((*DismissRecommendationRequest_DismissRecommendationOperation)(nil), "google.ads.googleads.v1.services.DismissRecommendationRequest.DismissRecommendationOperation")
	proto.RegisterType((*DismissRecommendationResponse)(nil), "google.ads.googleads.v1.services.DismissRecommendationResponse")
	proto.RegisterType((*DismissRecommendationResponse_DismissRecommendationResult)(nil), "google.ads.googleads.v1.services.DismissRecommendationResponse.DismissRecommendationResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/recommendation_service.proto", fileDescriptor_a744af7243d0735a)
}

var fileDescriptor_a744af7243d0735a = []byte{
	// 1333 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xc1, 0x73, 0x14, 0x45,
	0x17, 0xff, 0x66, 0xf2, 0x41, 0xe0, 0x05, 0x42, 0xb6, 0xa9, 0x14, 0xfb, 0x4d, 0x02, 0x5f, 0x5c,
	0xb1, 0x4c, 0xa5, 0xac, 0x19, 0x37, 0x08, 0xea, 0x60, 0x80, 0x0d, 0x84, 0x90, 0xb2, 0x80, 0xd4,
	0x24, 0xc4, 0x12, 0x23, 0x53, 0x9d, 0x99, 0x66, 0x1d, 0xd9, 0x99, 0x1e, 0xbb, 0x7b, 0x12, 0x52,
	0x48, 0xa9, 0x94, 0x07, 0x29, 0x8f, 0xfe, 0x07, 0x1c, 0x3d, 0xf8, 0x17, 0xe8, 0x51, 0x0f, 0x1c,
	0xf5, 0xe6, 0xd9, 0x93, 0x67, 0xff, 0x00, 0x6b, 0x7a, 0xa6, 0x97, 0xcc, 0xee, 0x4e, 0x76, 0xcd,
	0xe2, 0xad, 0xb7, 0x5f, 0xbf, 0xdf, 0xef, 0xbd, 0xd7, 0xaf, 0x7f, 0xdd, 0xb3, 0xb0, 0xd0, 0xa4,
	0xb4, 0xd9, 0x22, 0x16, 0xf6, 0xb9, 0x95, 0x0d, 0xd3, 0xd1, 0x76, 0xdd, 0xe2, 0x84, 0x6d, 0x07,
	0x1e, 0xe1, 0x16, 0x23, 0x1e, 0x0d, 0x43, 0x12, 0xf9, 0x58, 0x04, 0x34, 0x72, 0xf3, 0x79, 0x33,
	0x66, 0x54, 0x50, 0x34, 0x93, 0xf9, 0x98, 0xd8, 0xe7, 0x66, 0xdb, 0xdd, 0xdc, 0xae, 0x9b, 0xca,
	0xdd, 0xb0, 0xca, 0x08, 0x52, 0x54, 0x1a, 0x59, 0xe4, 0xa1, 0x20, 0x11, 0x0f, 0x68, 0xc4, 0x33,
	0x48, 0xe3, 0x42, 0x99, 0x03, 0x89, 0x92, 0x90, 0x5b, 0x0f, 0xc8, 0xee, 0x0e, 0x65, 0xbe, 0x1b,
	0x62, 0xe1, 0x7d, 0xe2, 0x8a, 0xdd, 0x38, 0x0f, 0xc5, 0x98, 0x2b, 0xf3, 0x63, 0x84, 0xd3, 0x84,
	0xa5, 0xa9, 0x60, 0xbf, 0x1f, 0xc7, 0x8b, 0xb5, 0xc5, 0xb4, 0x73, 0xbf, 0x69, 0xe5, 0x17, 0x07,
	0x16, 0x8e, 0x22, 0x2a, 0xa4, 0x51, 0x45, 0x7e, 0x26, 0xb7, 0xca, 0x5f, 0x5b, 0xc9, 0x7d, 0x6b,
	0x87, 0xe1, 0x38, 0x26, 0x4c, 0xd9, 0x4f, 0xe5, 0x76, 0x16, 0x7b, 0x16, 0x17, 0x58, 0x24, 0xb9,
	0xa1, 0x76, 0x19, 0xaa, 0xcb, 0x44, 0x38, 0x05, 0x46, 0x87, 0x7c, 0x96, 0x10, 0x2e, 0xd0, 0xab,
	0x70, 0x5c, 0x05, 0xe5, 0x46, 0x38, 0x24, 0x55, 0x6d, 0x46, 0x9b, 0x3d, 0xea, 0x1c, 0x53, 0x93,
	0xb7, 0x70, 0x48, 0x6a, 0xbf, 0x68, 0x60, 0x34, 0xe2, 0xb8, 0xb5, 0xdb, 0x1b, 0xe3, 0xff, 0x30,
	0xe6, 0x25, 0x5c, 0xd0, 0x90, 0x30, 0x37, 0xf0, 0x73, 0x04, 0x50, 0x53, 0x2b, 0x3e, 0xba, 0x07,
	0x40, 0x63, 0xc2, 0xb2, 0x6c, 0xaa, 0xfa, 0xcc, 0xc8, 0xec, 0xd8, 0xfc, 0x25, 0xb3, 0xdf, 0xde,
	0x9a, 0x3d, 0x28, 0x6f, 0x2b, 0x18, 0x67, 0x0f, 0x22, 0x7a, 0x1d, 0x4e, 0xc4, 0x98, 0x89, 0x00,
	0xb7, 0xdc, 0xfb, 0x38, 0x68, 0x25, 0x8c, 0x54, 0x47, 0x66, 0xb4, 0xd9, 0x23, 0xce, 0x78, 0x3e,
	0x7d, 0x3d, 0x9b, 0xad, 0xfd, 0x5c, 0x81, 0xe9, 0xfd, 0x50, 0x07, 0x2a, 0x07, 0x7a, 0xa2, 0xc1,
	0x09, 0x0f, 0x87, 0x31, 0x0e, 0x9a, 0x91, 0xbb, 0x95, 0xf8, 0x4d, 0x22, 0xaa, 0xfa, 0x8c, 0x36,
	0x3b, 0x36, 0xff, 0xc1, 0x70, 0x49, 0x99, 0x57, 0x73, 0xd4, 0x45, 0x09, 0xba, 0x8a, 0x19, 0x0e,
	0x89, 0x20, 0x8c, 0xdf, 0xf8, 0x8f, 0x33, 0xee, 0x15, 0x6c, 0xe8, 0x53, 0x18, 0x15, 0xe4, 0xa1,
	0x70, 0xb1, 0x2f, 0x73, 0x1d, 0x9b, 0xbf, 0x3d, 0x24, 0xf7, 0x3a, 0x79, 0x28, 0x1a, 0x7e, 0x81,
	0xf3, 0xb0, 0x90, 0x73, 0xa8, 0x05, 0xa3, 0xf9, 0xb9, 0xa8, 0xfe, 0x57, 0x72, 0xad, 0x0e, 0xc9,
	0xf5, 0x7e, 0x86, 0x56, 0x20, 0x53, 0x14, 0xe8, 0x6b, 0x0d, 0x2a, 0x02, 0xb3, 0x26, 0x11, 0xae,
	0x17, 0x63, 0x97, 0xc6, 0xc2, 0x0d, 0xa2, 0xea, 0xa1, 0x97, 0x52, 0xe0, 0x75, 0x89, 0x7b, 0x35,
	0xc6, 0xb7, 0x63, 0xb1, 0x12, 0x15, 0x0b, 0x2c, 0x0a, 0x36, 0xf4, 0x8d, 0x06, 0x15, 0x0f, 0xb7,
	0x5a, 0x34, 0x11, 0x6e, 0x5b, 0x45, 0xaa, 0x87, 0x65, 0x18, 0x1f, 0x0e, 0xbd, 0xcf, 0x12, 0x77,
	0x49, 0xc1, 0x16, 0x02, 0x99, 0xf0, 0x3a, 0xac, 0xe8, 0x0b, 0x18, 0x4f, 0xe7, 0xf6, 0x84, 0x31,
	0x2a, 0xc3, 0xd8, 0x78, 0x09, 0x61, 0xf4, 0x8e, 0xe1, 0xb8, 0xb7, 0xd7, 0x84, 0xbe, 0xd5, 0x00,
	0xf1, 0x40, 0x90, 0x56, 0x10, 0x3d, 0xd8, 0x13, 0xc5, 0x11, 0x19, 0xc5, 0xdd, 0x21, 0xa3, 0x58,
	0xcb, 0x81, 0x7b, 0x47, 0x52, 0xe1, 0x9d, 0x66, 0xf4, 0x54, 0x03, 0x14, 0xd2, 0x6d, 0xe2, 0x26,
	0x51, 0xc2, 0x89, 0xaf, 0x8e, 0xe0, 0xd1, 0x97, 0xb2, 0x35, 0x37, 0xe9, 0x36, 0xb9, 0x23, 0x71,
	0x7b, 0x1c, 0xc2, 0x89, 0xb0, 0xc3, 0x6a, 0xc4, 0x50, 0x2d, 0x3b, 0xb4, 0x68, 0x1d, 0xaa, 0x11,
	0xd9, 0xc9, 0xc3, 0x73, 0x71, 0x48, 0x93, 0x48, 0xb8, 0x61, 0xe0, 0x31, 0xca, 0xa5, 0xae, 0x8c,
	0xcd, 0x4f, 0xa9, 0x60, 0x95, 0xa6, 0x9b, 0x2b, 0x91, 0xb8, 0xf0, 0xd6, 0x06, 0x6e, 0x25, 0xc4,
	0x99, 0x8c, 0xc8, 0x4e, 0x86, 0xd9, 0x90, 0xae, 0x37, 0xa5, 0xa7, 0xb1, 0x02, 0x13, 0x9d, 0x47,
	0x15, 0x9d, 0x07, 0x1d, 0xfb, 0x39, 0xe6, 0x6b, 0xa5, 0x05, 0x68, 0xdf, 0x3e, 0x66, 0xc3, 0x77,
	0x74, 0xec, 0x1b, 0x7f, 0x69, 0x50, 0xe9, 0x3a, 0x8a, 0xe8, 0x6d, 0x38, 0x82, 0x7d, 0xb7, 0xc9,
	0x68, 0x12, 0xe7, 0x90, 0xd3, 0x5d, 0x61, 0xae, 0x09, 0x16, 0x44, 0xcd, 0x2c, 0xce, 0x51, 0xec,
	0x2f, 0xa7, 0x8b, 0x91, 0x07, 0xf0, 0xe2, 0xda, 0x94, 0x8a, 0x38, 0x3e, 0x7f, 0xad, 0x34, 0x1a,
	0x79, 0xdf, 0x2a, 0x25, 0xb8, 0x99, 0xfa, 0xad, 0xef, 0xc6, 0x64, 0x29, 0x4a, 0xc2, 0xae, 0x49,
	0xe7, 0x68, 0xa8, 0x86, 0xa8, 0x01, 0xe3, 0x5e, 0xec, 0xb9, 0x5b, 0x81, 0xaf, 0x4a, 0x39, 0xd2,
	0xbf, 0x94, 0xc7, 0xbc, 0xd8, 0x5b, 0x0c, 0xfc, 0xbc, 0x82, 0xcf, 0x35, 0xa8, 0x96, 0x09, 0x01,
	0x5a, 0x2e, 0x88, 0xcf, 0xe0, 0xbb, 0x75, 0xa2, 0x2d, 0x1f, 0x19, 0x0b, 0x22, 0xf0, 0x4a, 0xba,
	0xfb, 0x1d, 0x17, 0x45, 0x47, 0x1b, 0xe8, 0xfd, 0x81, 0x4f, 0x47, 0x64, 0xa7, 0xd8, 0x62, 0x85,
	0x76, 0xf8, 0x1c, 0x8c, 0x72, 0x35, 0x41, 0xf7, 0x00, 0x75, 0x69, 0x58, 0x9a, 0x4e, 0x7a, 0x03,
	0x5b, 0xa5, 0x5b, 0x93, 0xbd, 0x9d, 0x94, 0x4a, 0x5d, 0x27, 0xc4, 0x5f, 0x11, 0x24, 0x74, 0x2a,
	0x9d, 0xc2, 0xc4, 0x8d, 0x18, 0x4e, 0x95, 0x88, 0x08, 0xba, 0x93, 0x5e, 0x92, 0x7b, 0x45, 0x4b,
	0xf1, 0xbe, 0x31, 0x08, 0x6f, 0x9b, 0x74, 0xbc, 0xa0, 0x44, 0xdc, 0xf8, 0x52, 0x83, 0xa9, 0x7d,
	0x14, 0x03, 0x61, 0x38, 0xd9, 0xad, 0x54, 0x8a, 0xfa, 0xcd, 0x7e, 0xd4, 0x0a, 0xb9, 0x4d, 0x8f,
	0xba, 0xe4, 0x87, 0x1b, 0x2d, 0x30, 0xca, 0x55, 0x02, 0xdd, 0x82, 0xc9, 0x7c, 0xab, 0xb3, 0x3d,
	0x76, 0x05, 0x75, 0x53, 0xd9, 0x18, 0xa4, 0x89, 0x50, 0xe6, 0x99, 0x6d, 0xed, 0x3a, 0x4d, 0x59,
	0x16, 0x11, 0x4c, 0xe0, 0x54, 0xb0, 0xdc, 0xb8, 0xcd, 0x51, 0xfb, 0x51, 0x83, 0xa9, 0x9e, 0x0f,
	0x32, 0x1e, 0xd3, 0x88, 0x13, 0x74, 0x07, 0x46, 0x19, 0xe1, 0x49, 0x4b, 0xa8, 0xc4, 0x2f, 0x1e,
	0x48, 0x15, 0x1d, 0x89, 0xe1, 0x28, 0x2c, 0x74, 0x1d, 0x26, 0x3b, 0xde, 0x59, 0x2e, 0x61, 0x8c,
	0xb2, 0xbc, 0x8d, 0x91, 0x22, 0x61, 0xb1, 0x67, 0xae, 0xc9, 0x17, 0xa8, 0x73, 0xb2, 0xf8, 0x02,
	0x5b, 0x4a, 0x97, 0xd7, 0xae, 0xc0, 0xff, 0x4a, 0xd9, 0x06, 0x7b, 0x91, 0xfe, 0xa0, 0xc3, 0xf4,
	0xb5, 0x80, 0x87, 0x01, 0xe7, 0x07, 0x7c, 0x93, 0x3e, 0x2e, 0xbc, 0x49, 0x47, 0x64, 0x95, 0x3e,
	0xee, 0x5f, 0xa5, 0xfd, 0x48, 0x7b, 0x1b, 0x07, 0x7e, 0xb2, 0xea, 0xbd, 0x9e, 0xac, 0xc6, 0x12,
	0x9c, 0xd9, 0x1f, 0x76, 0xb0, 0x82, 0x3d, 0xd3, 0xe1, 0x74, 0x49, 0xec, 0x79, 0xcf, 0x24, 0x9d,
	0x3d, 0xf3, 0xd1, 0x81, 0xab, 0x91, 0x21, 0x96, 0x5a, 0xff, 0x8d, 0x9e, 0x32, 0x16, 0x61, 0x6a,
	0x1f, 0xbe, 0x81, 0x8a, 0x34, 0xff, 0xf4, 0x10, 0x4c, 0x16, 0xbd, 0xd7, 0xb2, 0x4c, 0xd1, 0x4f,
	0x1a, 0x54, 0xba, 0xbe, 0xa1, 0x90, 0xdd, 0xbf, 0x42, 0x65, 0x1f, 0x5e, 0x46, 0x7d, 0x80, 0x6b,
	0xba, 0xe8, 0x59, 0x7b, 0xf7, 0xc9, 0x6f, 0x7f, 0x7c, 0xa7, 0x9f, 0x43, 0xf5, 0xf4, 0x53, 0xf2,
	0x51, 0x21, 0x9d, 0x05, 0xd5, 0xd9, 0xdc, 0x9a, 0xeb, 0xf8, 0xb6, 0xe4, 0xd6, 0xdc, 0x63, 0xf4,
	0xab, 0x06, 0x27, 0x7b, 0x1c, 0x39, 0xf4, 0xde, 0x01, 0x75, 0x21, 0xcb, 0x61, 0xe1, 0xa0, 0xaa,
	0x22, 0xfb, 0xa3, 0x76, 0x49, 0xe6, 0xf3, 0x4e, 0xed, 0x9c, 0xfc, 0x5e, 0x6f, 0x27, 0xf0, 0x68,
	0xcf, 0xc1, 0x5d, 0x98, 0x7b, 0xdc, 0x99, 0x8e, 0x2d, 0xd5, 0xd0, 0xd6, 0xe6, 0xd0, 0xef, 0x1a,
	0x4c, 0xf6, 0xdc, 0x73, 0x74, 0x69, 0xb8, 0x83, 0x6c, 0x5c, 0x1e, 0xb2, 0xf5, 0x6b, 0x57, 0x64,
	0x6a, 0x76, 0xed, 0xfc, 0x3f, 0x4b, 0xcd, 0xcf, 0x40, 0x6d, 0x6d, 0x6e, 0xf1, 0x2b, 0x1d, 0xce,
	0x7a, 0x34, 0xec, 0x1b, 0xc8, 0xa2, 0xd1, 0xb3, 0x63, 0x57, 0xd3, 0xdb, 0x65, 0x55, 0xbb, 0x7b,
	0x23, 0xf7, 0x6f, 0xd2, 0x16, 0x8e, 0x9a, 0x26, 0x65, 0x4d, 0xab, 0x49, 0x22, 0x79, 0xf7, 0xa8,
	0xbf, 0x26, 0xe2, 0x80, 0x97, 0xff, 0x3f, 0x73, 0x51, 0x0d, 0x9e, 0xe9, 0x23, 0xcb, 0x8d, 0xc6,
	0xf7, 0xfa, 0xcc, 0x72, 0x06, 0xd8, 0xf0, 0xb9, 0x99, 0x0d, 0xd3, 0xd1, 0x46, 0xdd, 0xcc, 0x89,
	0xf9, 0x73, 0xb5, 0x64, 0xb3, 0xe1, 0xf3, 0xcd, 0xf6, 0x92, 0xcd, 0x8d, 0xfa, 0xa6, 0x5a, 0xf2,
	0xa7, 0x7e, 0x36, 0x9b, 0xb7, 0xed, 0x86, 0xcf, 0x6d, 0xbb, 0xbd, 0xc8, 0xb6, 0x37, 0xea, 0xb6,
	0xad, 0x96, 0x6d, 0x1d, 0x96, 0x71, 0x9e, 0xfb, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xb3, 0x73, 0x91,
	0x69, 0x46, 0x12, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RecommendationServiceClient is the client API for RecommendationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommendationServiceClient interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error)
}

type recommendationServiceClient struct {
	cc *grpc.ClientConn
}

func NewRecommendationServiceClient(cc *grpc.ClientConn) RecommendationServiceClient {
	return &recommendationServiceClient{cc}
}

func (c *recommendationServiceClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*resources.Recommendation, error) {
	out := new(resources.Recommendation)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.RecommendationService/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) ApplyRecommendation(ctx context.Context, in *ApplyRecommendationRequest, opts ...grpc.CallOption) (*ApplyRecommendationResponse, error) {
	out := new(ApplyRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.RecommendationService/ApplyRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommendationServiceClient) DismissRecommendation(ctx context.Context, in *DismissRecommendationRequest, opts ...grpc.CallOption) (*DismissRecommendationResponse, error) {
	out := new(DismissRecommendationResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.RecommendationService/DismissRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommendationServiceServer is the server API for RecommendationService service.
type RecommendationServiceServer interface {
	// Returns the requested recommendation in full detail.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*resources.Recommendation, error)
	// Applies given recommendations with corresponding apply parameters.
	ApplyRecommendation(context.Context, *ApplyRecommendationRequest) (*ApplyRecommendationResponse, error)
	// Dismisses given recommendations.
	DismissRecommendation(context.Context, *DismissRecommendationRequest) (*DismissRecommendationResponse, error)
}

func RegisterRecommendationServiceServer(s *grpc.Server, srv RecommendationServiceServer) {
	s.RegisterService(&_RecommendationService_serviceDesc, srv)
}

func _RecommendationService_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.RecommendationService/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_ApplyRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.RecommendationService/ApplyRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).ApplyRecommendation(ctx, req.(*ApplyRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecommendationService_DismissRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DismissRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.RecommendationService/DismissRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommendationServiceServer).DismissRecommendation(ctx, req.(*DismissRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecommendationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.RecommendationService",
	HandlerType: (*RecommendationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRecommendation",
			Handler:    _RecommendationService_GetRecommendation_Handler,
		},
		{
			MethodName: "ApplyRecommendation",
			Handler:    _RecommendationService_ApplyRecommendation_Handler,
		},
		{
			MethodName: "DismissRecommendation",
			Handler:    _RecommendationService_DismissRecommendation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/recommendation_service.proto",
}
