// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/clouddebugger/v2/debugger.proto

package clouddebugger

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request to set a breakpoint
type SetBreakpointRequest struct {
	// ID of the debuggee where the breakpoint is to be set.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// Breakpoint specification to set.
	// The field 'location' of the breakpoint must be set.
	Breakpoint *Breakpoint `protobuf:"bytes,2,opt,name=breakpoint" json:"breakpoint,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *SetBreakpointRequest) Reset()                    { *m = SetBreakpointRequest{} }
func (m *SetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointRequest) ProtoMessage()               {}
func (*SetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *SetBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *SetBreakpointRequest) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

func (m *SetBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for setting a breakpoint.
type SetBreakpointResponse struct {
	// Breakpoint resource.
	// The field `id` is guaranteed to be set (in addition to the echoed fileds).
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *SetBreakpointResponse) Reset()                    { *m = SetBreakpointResponse{} }
func (m *SetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*SetBreakpointResponse) ProtoMessage()               {}
func (*SetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *SetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to get breakpoint information.
type GetBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to get.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to get.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *GetBreakpointRequest) Reset()                    { *m = GetBreakpointRequest{} }
func (m *GetBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointRequest) ProtoMessage()               {}
func (*GetBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *GetBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *GetBreakpointRequest) GetBreakpointId() string {
	if m != nil {
		return m.BreakpointId
	}
	return ""
}

func (m *GetBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for getting breakpoint information.
type GetBreakpointResponse struct {
	// Complete breakpoint state.
	// The fields `id` and `location` are guaranteed to be set.
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint" json:"breakpoint,omitempty"`
}

func (m *GetBreakpointResponse) Reset()                    { *m = GetBreakpointResponse{} }
func (m *GetBreakpointResponse) String() string            { return proto.CompactTextString(m) }
func (*GetBreakpointResponse) ProtoMessage()               {}
func (*GetBreakpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *GetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if m != nil {
		return m.Breakpoint
	}
	return nil
}

// Request to delete a breakpoint.
type DeleteBreakpointRequest struct {
	// ID of the debuggee whose breakpoint to delete.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// ID of the breakpoint to delete.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId" json:"breakpoint_id,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *DeleteBreakpointRequest) Reset()                    { *m = DeleteBreakpointRequest{} }
func (m *DeleteBreakpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBreakpointRequest) ProtoMessage()               {}
func (*DeleteBreakpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *DeleteBreakpointRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *DeleteBreakpointRequest) GetBreakpointId() string {
	if m != nil {
		return m.BreakpointId
	}
	return ""
}

func (m *DeleteBreakpointRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Request to list breakpoints.
type ListBreakpointsRequest struct {
	// ID of the debuggee whose breakpoints to list.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId" json:"debuggee_id,omitempty"`
	// When set to `true`, the response includes the list of breakpoints set by
	// any user. Otherwise, it includes only breakpoints set by the caller.
	IncludeAllUsers bool `protobuf:"varint,2,opt,name=include_all_users,json=includeAllUsers" json:"include_all_users,omitempty"`
	// When set to `true`, the response includes active and inactive
	// breakpoints. Otherwise, it includes only active breakpoints.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// When set, the response includes only breakpoints with the specified action.
	Action *ListBreakpointsRequest_BreakpointActionValue `protobuf:"bytes,4,opt,name=action" json:"action,omitempty"`
	// This field is deprecated. The following fields are always stripped out of
	// the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
	StripResults bool `protobuf:"varint,5,opt,name=strip_results,json=stripResults" json:"strip_results,omitempty"`
	// A wait token that, if specified, blocks the call until the breakpoints
	// list has changed, or a server selected timeout has expired.  The value
	// should be set from the last response. The error code
	// `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
	// should be called again with the same `wait_token`.
	WaitToken string `protobuf:"bytes,6,opt,name=wait_token,json=waitToken" json:"wait_token,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,8,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListBreakpointsRequest) Reset()                    { *m = ListBreakpointsRequest{} }
func (m *ListBreakpointsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsRequest) ProtoMessage()               {}
func (*ListBreakpointsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *ListBreakpointsRequest) GetDebuggeeId() string {
	if m != nil {
		return m.DebuggeeId
	}
	return ""
}

func (m *ListBreakpointsRequest) GetIncludeAllUsers() bool {
	if m != nil {
		return m.IncludeAllUsers
	}
	return false
}

func (m *ListBreakpointsRequest) GetIncludeInactive() bool {
	if m != nil {
		return m.IncludeInactive
	}
	return false
}

func (m *ListBreakpointsRequest) GetAction() *ListBreakpointsRequest_BreakpointActionValue {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ListBreakpointsRequest) GetStripResults() bool {
	if m != nil {
		return m.StripResults
	}
	return false
}

func (m *ListBreakpointsRequest) GetWaitToken() string {
	if m != nil {
		return m.WaitToken
	}
	return ""
}

func (m *ListBreakpointsRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Wrapper message for `Breakpoint.Action`. Defines a filter on the action
// field of breakpoints.
type ListBreakpointsRequest_BreakpointActionValue struct {
	// Only breakpoints with the specified action will pass the filter.
	Value Breakpoint_Action `protobuf:"varint,1,opt,name=value,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"value,omitempty"`
}

func (m *ListBreakpointsRequest_BreakpointActionValue) Reset() {
	*m = ListBreakpointsRequest_BreakpointActionValue{}
}
func (m *ListBreakpointsRequest_BreakpointActionValue) String() string {
	return proto.CompactTextString(m)
}
func (*ListBreakpointsRequest_BreakpointActionValue) ProtoMessage() {}
func (*ListBreakpointsRequest_BreakpointActionValue) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{5, 0}
}

func (m *ListBreakpointsRequest_BreakpointActionValue) GetValue() Breakpoint_Action {
	if m != nil {
		return m.Value
	}
	return Breakpoint_CAPTURE
}

// Response for listing breakpoints.
type ListBreakpointsResponse struct {
	// List of breakpoints matching the request.
	// The fields `id` and `location` are guaranteed to be set on each breakpoint.
	// The fields: `stack_frames`, `evaluated_expressions` and `variable_table`
	// are cleared on each breakpoint regardless of it's status.
	Breakpoints []*Breakpoint `protobuf:"bytes,1,rep,name=breakpoints" json:"breakpoints,omitempty"`
	// A wait token that can be used in the next call to `list` (REST) or
	// `ListBreakpoints` (RPC) to block until the list of breakpoints has changes.
	NextWaitToken string `protobuf:"bytes,2,opt,name=next_wait_token,json=nextWaitToken" json:"next_wait_token,omitempty"`
}

func (m *ListBreakpointsResponse) Reset()                    { *m = ListBreakpointsResponse{} }
func (m *ListBreakpointsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBreakpointsResponse) ProtoMessage()               {}
func (*ListBreakpointsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *ListBreakpointsResponse) GetBreakpoints() []*Breakpoint {
	if m != nil {
		return m.Breakpoints
	}
	return nil
}

func (m *ListBreakpointsResponse) GetNextWaitToken() string {
	if m != nil {
		return m.NextWaitToken
	}
	return ""
}

// Request to list debuggees.
type ListDebuggeesRequest struct {
	// Project number of a Google Cloud project whose debuggees to list.
	Project string `protobuf:"bytes,2,opt,name=project" json:"project,omitempty"`
	// When set to `true`, the result includes all debuggees. Otherwise, the
	// result includes only debuggees that are active.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive" json:"include_inactive,omitempty"`
	// The client version making the call.
	// Following: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion" json:"client_version,omitempty"`
}

func (m *ListDebuggeesRequest) Reset()                    { *m = ListDebuggeesRequest{} }
func (m *ListDebuggeesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesRequest) ProtoMessage()               {}
func (*ListDebuggeesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *ListDebuggeesRequest) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *ListDebuggeesRequest) GetIncludeInactive() bool {
	if m != nil {
		return m.IncludeInactive
	}
	return false
}

func (m *ListDebuggeesRequest) GetClientVersion() string {
	if m != nil {
		return m.ClientVersion
	}
	return ""
}

// Response for listing debuggees.
type ListDebuggeesResponse struct {
	// List of debuggees accessible to the calling user.
	// Note that the `description` field is the only human readable field
	// that should be displayed to the user.
	// The fields `debuggee.id` and  `description` fields are guaranteed to be
	// set on each debuggee.
	Debuggees []*Debuggee `protobuf:"bytes,1,rep,name=debuggees" json:"debuggees,omitempty"`
}

func (m *ListDebuggeesResponse) Reset()                    { *m = ListDebuggeesResponse{} }
func (m *ListDebuggeesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListDebuggeesResponse) ProtoMessage()               {}
func (*ListDebuggeesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *ListDebuggeesResponse) GetDebuggees() []*Debuggee {
	if m != nil {
		return m.Debuggees
	}
	return nil
}

func init() {
	proto.RegisterType((*SetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.SetBreakpointRequest")
	proto.RegisterType((*SetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.SetBreakpointResponse")
	proto.RegisterType((*GetBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.GetBreakpointRequest")
	proto.RegisterType((*GetBreakpointResponse)(nil), "google.devtools.clouddebugger.v2.GetBreakpointResponse")
	proto.RegisterType((*DeleteBreakpointRequest)(nil), "google.devtools.clouddebugger.v2.DeleteBreakpointRequest")
	proto.RegisterType((*ListBreakpointsRequest)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest")
	proto.RegisterType((*ListBreakpointsRequest_BreakpointActionValue)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue")
	proto.RegisterType((*ListBreakpointsResponse)(nil), "google.devtools.clouddebugger.v2.ListBreakpointsResponse")
	proto.RegisterType((*ListDebuggeesRequest)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesRequest")
	proto.RegisterType((*ListDebuggeesResponse)(nil), "google.devtools.clouddebugger.v2.ListDebuggeesResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Debugger2 service

type Debugger2Client interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user can set breakpoints to.
	ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error)
}

type debugger2Client struct {
	cc *grpc.ClientConn
}

func NewDebugger2Client(cc *grpc.ClientConn) Debugger2Client {
	return &debugger2Client{cc}
}

func (c *debugger2Client) SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error) {
	out := new(SetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error) {
	out := new(GetBreakpointResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error) {
	out := new(ListBreakpointsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error) {
	out := new(ListDebuggeesResponse)
	err := grpc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Debugger2 service

type Debugger2Server interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(context.Context, *SetBreakpointRequest) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(context.Context, *GetBreakpointRequest) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(context.Context, *DeleteBreakpointRequest) (*google_protobuf3.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(context.Context, *ListBreakpointsRequest) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user can set breakpoints to.
	ListDebuggees(context.Context, *ListDebuggeesRequest) (*ListDebuggeesResponse, error)
}

func RegisterDebugger2Server(s *grpc.Server, srv Debugger2Server) {
	s.RegisterService(&_Debugger2_serviceDesc, srv)
}

func _Debugger2_SetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).SetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).SetBreakpoint(ctx, req.(*SetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_GetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).GetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).GetBreakpoint(ctx, req.(*GetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_DeleteBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, req.(*DeleteBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListBreakpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBreakpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListBreakpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListBreakpoints(ctx, req.(*ListBreakpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListDebuggees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDebuggeesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListDebuggees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListDebuggees(ctx, req.(*ListDebuggeesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Debugger2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouddebugger.v2.Debugger2",
	HandlerType: (*Debugger2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetBreakpoint",
			Handler:    _Debugger2_SetBreakpoint_Handler,
		},
		{
			MethodName: "GetBreakpoint",
			Handler:    _Debugger2_GetBreakpoint_Handler,
		},
		{
			MethodName: "DeleteBreakpoint",
			Handler:    _Debugger2_DeleteBreakpoint_Handler,
		},
		{
			MethodName: "ListBreakpoints",
			Handler:    _Debugger2_ListBreakpoints_Handler,
		},
		{
			MethodName: "ListDebuggees",
			Handler:    _Debugger2_ListDebuggees_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouddebugger/v2/debugger.proto",
}

func init() { proto.RegisterFile("google/devtools/clouddebugger/v2/debugger.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 766 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcb, 0x6e, 0xd3, 0x4c,
	0x18, 0xd5, 0xb4, 0x7f, 0x2f, 0xf9, 0xd2, 0xb4, 0xfd, 0x47, 0xbd, 0x58, 0xe1, 0x16, 0x99, 0x8b,
	0x4a, 0x41, 0x36, 0x72, 0x11, 0xb4, 0xb0, 0xa1, 0x51, 0x51, 0x1a, 0xa9, 0x54, 0x55, 0x80, 0x22,
	0xb1, 0x89, 0x9c, 0x64, 0x6a, 0x99, 0xba, 0x1e, 0xe3, 0x19, 0x07, 0x50, 0xd5, 0x4d, 0x91, 0xba,
	0x47, 0xbc, 0x00, 0x0f, 0x80, 0xc4, 0x13, 0x20, 0xb1, 0x43, 0x62, 0xcb, 0x2b, 0xf0, 0x20, 0xc8,
	0xe3, 0x71, 0xe3, 0x04, 0x43, 0xe2, 0x54, 0xea, 0xce, 0x3e, 0x9e, 0xf3, 0xcd, 0x39, 0x67, 0xbe,
	0x99, 0x31, 0xe8, 0x16, 0xa5, 0x96, 0x43, 0xf4, 0x16, 0x69, 0x73, 0x4a, 0x1d, 0xa6, 0x37, 0x1d,
	0x1a, 0xb4, 0x5a, 0xa4, 0x11, 0x58, 0x16, 0xf1, 0xf5, 0xb6, 0xa1, 0xc7, 0xcf, 0x9a, 0xe7, 0x53,
	0x4e, 0x71, 0x29, 0x22, 0x68, 0x31, 0x41, 0xeb, 0x22, 0x68, 0x6d, 0xa3, 0x78, 0x51, 0x96, 0x34,
	0x3d, 0x5b, 0x37, 0x5d, 0x97, 0x72, 0x93, 0xdb, 0xd4, 0x65, 0x11, 0xbf, 0x78, 0xab, 0xff, 0x84,
	0x26, 0x37, 0xe5, 0xe0, 0x0b, 0x72, 0xb0, 0x78, 0x6b, 0x04, 0x7b, 0x3a, 0x39, 0xf0, 0xf8, 0xbb,
	0xe8, 0xa3, 0xfa, 0x19, 0xc1, 0xdc, 0x53, 0xc2, 0xcb, 0x3e, 0x31, 0xf7, 0x3d, 0x6a, 0xbb, 0xbc,
	0x46, 0x5e, 0x07, 0x84, 0x71, 0x7c, 0x05, 0xf2, 0xb2, 0x1e, 0xa9, 0xdb, 0x2d, 0x05, 0x95, 0xd0,
	0x52, 0xae, 0x06, 0x31, 0x54, 0x6d, 0xe1, 0x2d, 0x80, 0xc6, 0x29, 0x4b, 0x19, 0x29, 0xa1, 0xa5,
	0xbc, 0x71, 0x5b, 0xeb, 0x67, 0x4c, 0x4b, 0xcc, 0x94, 0xe0, 0xe3, 0xeb, 0x30, 0xdd, 0x74, 0x6c,
	0xe2, 0xf2, 0x7a, 0x9b, 0xf8, 0xcc, 0xa6, 0xae, 0xf2, 0x9f, 0x98, 0xb1, 0x10, 0xa1, 0xbb, 0x11,
	0xa8, 0x12, 0x98, 0xef, 0x51, 0xcb, 0x3c, 0xea, 0x32, 0xd2, 0xa3, 0x06, 0x9d, 0x4d, 0x8d, 0xfa,
	0x1e, 0xc1, 0x5c, 0x65, 0xa8, 0x54, 0xae, 0x42, 0xa1, 0x53, 0x27, 0x1c, 0x32, 0x22, 0x86, 0x4c,
	0x75, 0xc0, 0x6a, 0x2b, 0x83, 0xd9, 0xca, 0x39, 0x98, 0x3d, 0x41, 0xb0, 0xb8, 0x41, 0x1c, 0xc2,
	0xc9, 0xf9, 0xf9, 0x1d, 0x4d, 0xf3, 0xfb, 0x7d, 0x14, 0x16, 0xb6, 0x6c, 0x96, 0x70, 0xcc, 0x06,
	0xd6, 0xb1, 0x0c, 0xff, 0xdb, 0x6e, 0xd3, 0x09, 0x5a, 0xa4, 0x6e, 0x3a, 0x4e, 0x3d, 0x60, 0xc4,
	0x67, 0x42, 0xcb, 0x64, 0x6d, 0x46, 0x7e, 0x58, 0x77, 0x9c, 0xe7, 0x21, 0x8c, 0x6f, 0xc2, 0x6c,
	0x3c, 0xd6, 0x76, 0xcd, 0x26, 0xb7, 0xdb, 0x44, 0x08, 0xea, 0x0c, 0xad, 0x4a, 0x18, 0xef, 0xc1,
	0x78, 0xf8, 0x24, 0x57, 0x28, 0x6f, 0x6c, 0xf7, 0x4f, 0x39, 0xdd, 0x41, 0x22, 0xfc, 0x75, 0x51,
	0x70, 0xd7, 0x74, 0x02, 0x52, 0x93, 0xd5, 0xc3, 0x18, 0x19, 0xf7, 0x6d, 0xaf, 0xee, 0x13, 0x16,
	0x38, 0x9c, 0x29, 0x63, 0x42, 0xcf, 0x94, 0x00, 0x6b, 0x11, 0x86, 0x2f, 0x01, 0xbc, 0x31, 0x6d,
	0x5e, 0xe7, 0x74, 0x9f, 0xb8, 0xca, 0xb8, 0xc8, 0x20, 0x17, 0x22, 0xcf, 0x42, 0x20, 0x25, 0xe5,
	0xc9, 0x94, 0x94, 0x8b, 0x0d, 0x98, 0x4f, 0xd5, 0x82, 0xab, 0x30, 0xd6, 0x0e, 0x1f, 0x44, 0xba,
	0xd3, 0xc6, 0x4a, 0x96, 0x86, 0xd2, 0xa2, 0x42, 0xb5, 0xa8, 0x82, 0xfa, 0x01, 0xc1, 0xe2, 0x1f,
	0x39, 0xc8, 0xe6, 0xdd, 0x86, 0x7c, 0xa7, 0x39, 0x98, 0x82, 0x4a, 0xa3, 0x99, 0xbb, 0x37, 0x59,
	0x00, 0xdf, 0x80, 0x19, 0x97, 0xbc, 0xe5, 0xf5, 0x44, 0x34, 0x51, 0x0f, 0x16, 0x42, 0xf8, 0x45,
	0x1c, 0x8f, 0x7a, 0x8c, 0x60, 0x2e, 0xd4, 0xb4, 0x21, 0x9b, 0xe6, 0xb4, 0xb7, 0x14, 0x98, 0xf0,
	0x7c, 0xfa, 0x8a, 0x34, 0xb9, 0x24, 0xc6, 0xaf, 0x59, 0x1a, 0x65, 0xc0, 0x2d, 0x6d, 0xc2, 0x7c,
	0x8f, 0x06, 0x99, 0xca, 0x26, 0xe4, 0xe2, 0x6e, 0x8e, 0x33, 0x59, 0xee, 0x9f, 0x49, 0x5c, 0xa7,
	0xd6, 0x21, 0x1b, 0x5f, 0x27, 0x20, 0x27, 0x71, 0xdf, 0xc0, 0x3f, 0x10, 0x14, 0xba, 0x4e, 0x4c,
	0x7c, 0xaf, 0x7f, 0xd9, 0xb4, 0x0b, 0xa1, 0x78, 0x3f, 0x33, 0x2f, 0xb2, 0xa6, 0x6e, 0x1e, 0xff,
	0xfc, 0xf5, 0x71, 0xa4, 0xac, 0xde, 0x4d, 0x5e, 0x84, 0xfa, 0xa9, 0x60, 0xfd, 0x30, 0xb1, 0xb3,
	0x8f, 0xf4, 0xc4, 0xd2, 0xea, 0x8c, 0xf0, 0x07, 0xc9, 0x4b, 0x22, 0x34, 0x53, 0xc9, 0x6a, 0xa6,
	0x32, 0xa4, 0x99, 0xca, 0xbf, 0xcc, 0xe0, 0x47, 0x99, 0xcd, 0x1c, 0x76, 0x9d, 0x93, 0x47, 0xf8,
	0x0b, 0x82, 0xd9, 0xde, 0x63, 0x17, 0xaf, 0x0d, 0xb2, 0xe6, 0xa9, 0x47, 0x75, 0x71, 0x21, 0xa6,
	0xc6, 0xf7, 0xbc, 0xf6, 0x38, 0xbc, 0xe7, 0x63, 0xc5, 0xcb, 0x67, 0x57, 0xfc, 0x0d, 0xc1, 0x4c,
	0xcf, 0xae, 0xc6, 0xab, 0xc3, 0x1e, 0x88, 0xc5, 0xb5, 0x21, 0x98, 0x72, 0x11, 0x56, 0x85, 0x25,
	0x03, 0xdf, 0xc9, 0x6a, 0x09, 0x7f, 0x42, 0x50, 0xe8, 0xda, 0x80, 0x83, 0x74, 0x50, 0xda, 0xa9,
	0x31, 0x48, 0x07, 0xa5, 0xee, 0x74, 0xf5, 0xb2, 0x10, 0xaf, 0xe0, 0x85, 0x74, 0xf1, 0xe5, 0x13,
	0x04, 0xd7, 0x9a, 0xf4, 0xa0, 0x6f, 0xf9, 0x72, 0x21, 0xde, 0xe5, 0x3b, 0xe1, 0x82, 0xef, 0xa0,
	0x97, 0x4f, 0x24, 0xc5, 0xa2, 0x8e, 0xe9, 0x5a, 0x1a, 0xf5, 0x2d, 0xdd, 0x22, 0xae, 0x68, 0x07,
	0xf9, 0x87, 0x6a, 0x7a, 0x36, 0xfb, 0xfb, 0x4f, 0xe3, 0xc3, 0x2e, 0xa0, 0x31, 0x2e, 0x98, 0x2b,
	0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0x7f, 0x55, 0x66, 0x54, 0xde, 0x0a, 0x00, 0x00,
}
