// Generated by running
//  go generate github.com/gonum/matrix
// DO NOT EDIT.

// Copyright ©2015 The gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Package matrix provides common error handling mechanisms for matrix operations
// in mat64 and cmat128.
//
// Overview
//
// This section provides a quick overview of the matrix package. The following
// sections provide more in depth commentary.
//
// matrix provides:
//  - Error type definitions
//  - Error recovery mechanisms
//  - Common constants used by mat64 and cmat128
//
// Errors
//
// The mat64 and cmat128 matrix packages share a common set of errors
// provided by matrix via the matrix.Error type.
//
// Errors are either returned directly or used as the parameter of a panic
// depending on the class of error encountered. Returned errors indicate
// that a call was not able to complete successfully while panics generally
// indicate a programmer or unrecoverable error.
//
// Examples of each type are found in the mat64 Solve methods, which find
// x such that A*x = b.
//
// An error value is returned from the function or method when the operation
// can meaningfully fail. The Solve operation cannot complete if A is
// singular. However, determining the singularity of A is most easily
// discovered during the Solve procedure itself and is a valid result from
// the operation, so in this case an error is returned.
//
// A function will panic when the input parameters are inappropriate for
// the function. In Solve, for example, the number of rows of each input
// matrix must be equal because of the rules of matrix multiplication.
// Similarly, for solving A*x = b, a non-zero receiver must have the same
// number of rows as A has columns and must have the same number of columns
// as b. In all cases where a function will panic, conditions that would
// lead to a panic can easily be checked prior to a call.
//
// Error Recovery
//
// When a matrix.Error is the parameter of a panic, the panic can be
// recovered by a Maybe function, which will then return the error.
// Panics that are not of type matrix.Error are re-panicked by the
// Maybe functions.
//
// Invariants
//
// Matrix input arguments to functions are never directly modified. If an operation
// changes Matrix data, the mutated matrix will be the receiver of a function.
//
// For convenience, a matrix may be used as both a receiver and as an input, e.g.
//  a.Pow(a, 6)
//  v.SolveVec(a.T(), v)
// though in many cases this will cause an allocation (see Element Aliasing).
// An exception to this rule is Copy, which does not allow a.Copy(a.T()).
//
// Element Aliasing
//
// Most methods in the matrix packages modify receiver data. It is forbidden for the modified
// data region of the receiver to overlap the used data area of the input
// arguments. The exception to this rule is when the method receiver is equal to one
// of the input arguments, as in the a.Pow(a, 6) call above, or its implicit transpose.
//
// This prohibition is to help avoid subtle mistakes when the method needs to read
// from and write to the same data region. There are ways to make mistakes using the
// matrix API, and matrix functions will detect and complain about those.
// There are many ways to make mistakes by excursion from the matrix API via
// interaction with raw matrix values.
//
// If you need to read the rest of this section to understand the behavior of
// your program, you are being clever. Don't be clever. If you must be clever,
// blas64/cblas128 and lapack64/clapack128 may be used to call the behavior directly.
//
// The matrix packages will use the following rules to detect overlap between the receiver and one
// of the inputs:
//  - the input implements one of the Raw methods, and
//  - the Raw type matches that of the receiver or
//    one is a RawMatrixer and the other is a RawVectorer, and
//  - the address ranges of the backing data slices overlap, and
//  - the strides differ or there is an overlap in the used data elements.
// If such an overlap is detected, the method will panic.
//
// The following cases will not panic:
//  - the data slices do not overlap,
//  - there is pointer identity between the receiver and input values after
//    the value has been untransposed if necessary.
//
// The matrix packages will not attempt to detect element overlap if the input does not implement a
// Raw method, or if the Raw method differs from that of the receiver except when a
// conversion has occurred through a matrix API function. Method behavior is undefined
// if there is undetected overlap.
//
package matrix
