// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcknowledgeJob = "AcknowledgeJob"

// AcknowledgeJobRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeJob for more information on using the AcknowledgeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcknowledgeJobRequest method.
//    req, resp := client.AcknowledgeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob
func (c *CodePipeline) AcknowledgeJobRequest(input *AcknowledgeJobInput) (req *request.Request, output *AcknowledgeJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeJobInput{}
	}

	output = &AcknowledgeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcknowledgeJob API operation for AWS CodePipeline.
//
// Returns information about a specified job and whether that job has been received
// by the job worker. Only used for custom actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation AcknowledgeJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeInvalidNonceException "InvalidNonceException"
//   The specified nonce was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJob
func (c *CodePipeline) AcknowledgeJob(input *AcknowledgeJobInput) (*AcknowledgeJobOutput, error) {
	req, out := c.AcknowledgeJobRequest(input)
	return out, req.Send()
}

// AcknowledgeJobWithContext is the same as AcknowledgeJob with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) AcknowledgeJobWithContext(ctx aws.Context, input *AcknowledgeJobInput, opts ...request.Option) (*AcknowledgeJobOutput, error) {
	req, out := c.AcknowledgeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAcknowledgeThirdPartyJob = "AcknowledgeThirdPartyJob"

// AcknowledgeThirdPartyJobRequest generates a "aws/request.Request" representing the
// client's request for the AcknowledgeThirdPartyJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcknowledgeThirdPartyJob for more information on using the AcknowledgeThirdPartyJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcknowledgeThirdPartyJobRequest method.
//    req, resp := client.AcknowledgeThirdPartyJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob
func (c *CodePipeline) AcknowledgeThirdPartyJobRequest(input *AcknowledgeThirdPartyJobInput) (req *request.Request, output *AcknowledgeThirdPartyJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeThirdPartyJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeThirdPartyJobInput{}
	}

	output = &AcknowledgeThirdPartyJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcknowledgeThirdPartyJob API operation for AWS CodePipeline.
//
// Confirms a job worker has received the specified job. Only used for partner
// actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation AcknowledgeThirdPartyJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeInvalidNonceException "InvalidNonceException"
//   The specified nonce was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidClientTokenException "InvalidClientTokenException"
//   The client token was specified in an invalid format
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob
func (c *CodePipeline) AcknowledgeThirdPartyJob(input *AcknowledgeThirdPartyJobInput) (*AcknowledgeThirdPartyJobOutput, error) {
	req, out := c.AcknowledgeThirdPartyJobRequest(input)
	return out, req.Send()
}

// AcknowledgeThirdPartyJobWithContext is the same as AcknowledgeThirdPartyJob with the addition of
// the ability to pass a context and additional request options.
//
// See AcknowledgeThirdPartyJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) AcknowledgeThirdPartyJobWithContext(ctx aws.Context, input *AcknowledgeThirdPartyJobInput, opts ...request.Option) (*AcknowledgeThirdPartyJobOutput, error) {
	req, out := c.AcknowledgeThirdPartyJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomActionType = "CreateCustomActionType"

// CreateCustomActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomActionType operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomActionType for more information on using the CreateCustomActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCustomActionTypeRequest method.
//    req, resp := client.CreateCustomActionTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType
func (c *CodePipeline) CreateCustomActionTypeRequest(input *CreateCustomActionTypeInput) (req *request.Request, output *CreateCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opCreateCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomActionTypeInput{}
	}

	output = &CreateCustomActionTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomActionType API operation for AWS CodePipeline.
//
// Creates a new custom action that can be used in all pipelines associated
// with the AWS account. Only used for custom actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation CreateCustomActionType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of pipelines associated with the AWS account has exceeded the
//   limit allowed for the account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionType
func (c *CodePipeline) CreateCustomActionType(input *CreateCustomActionTypeInput) (*CreateCustomActionTypeOutput, error) {
	req, out := c.CreateCustomActionTypeRequest(input)
	return out, req.Send()
}

// CreateCustomActionTypeWithContext is the same as CreateCustomActionType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) CreateCustomActionTypeWithContext(ctx aws.Context, input *CreateCustomActionTypeInput, opts ...request.Option) (*CreateCustomActionTypeOutput, error) {
	req, out := c.CreateCustomActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipeline for more information on using the CreatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePipelineRequest method.
//    req, resp := client.CreatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline
func (c *CodePipeline) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for AWS CodePipeline.
//
// Creates a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNameInUseException "PipelineNameInUseException"
//   The specified pipeline name is already in use.
//
//   * ErrCodeInvalidStageDeclarationException "InvalidStageDeclarationException"
//   The specified stage declaration was specified in an invalid format.
//
//   * ErrCodeInvalidActionDeclarationException "InvalidActionDeclarationException"
//   The specified action declaration was specified in an invalid format.
//
//   * ErrCodeInvalidBlockerDeclarationException "InvalidBlockerDeclarationException"
//   Reserved for future use.
//
//   * ErrCodeInvalidStructureException "InvalidStructureException"
//   The specified structure was specified in an invalid format.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of pipelines associated with the AWS account has exceeded the
//   limit allowed for the account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipeline
func (c *CodePipeline) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	return out, req.Send()
}

// CreatePipelineWithContext is the same as CreatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) CreatePipelineWithContext(ctx aws.Context, input *CreatePipelineInput, opts ...request.Option) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomActionType = "DeleteCustomActionType"

// DeleteCustomActionTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomActionType operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomActionType for more information on using the DeleteCustomActionType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCustomActionTypeRequest method.
//    req, resp := client.DeleteCustomActionTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType
func (c *CodePipeline) DeleteCustomActionTypeRequest(input *DeleteCustomActionTypeInput) (req *request.Request, output *DeleteCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomActionTypeInput{}
	}

	output = &DeleteCustomActionTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomActionType API operation for AWS CodePipeline.
//
// Marks a custom action as deleted. PollForJobs for the custom action will
// fail after the action is marked for deletion. Only used for custom actions.
//
// You cannot recreate a custom action after it has been deleted unless you
// increase the version number of the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeleteCustomActionType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionType
func (c *CodePipeline) DeleteCustomActionType(input *DeleteCustomActionTypeInput) (*DeleteCustomActionTypeOutput, error) {
	req, out := c.DeleteCustomActionTypeRequest(input)
	return out, req.Send()
}

// DeleteCustomActionTypeWithContext is the same as DeleteCustomActionType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomActionType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeleteCustomActionTypeWithContext(ctx aws.Context, input *DeleteCustomActionTypeInput, opts ...request.Option) (*DeleteCustomActionTypeOutput, error) {
	req, out := c.DeleteCustomActionTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipeline for more information on using the DeletePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePipelineRequest method.
//    req, resp := client.DeletePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline
func (c *CodePipeline) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePipeline API operation for AWS CodePipeline.
//
// Deletes the specified pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipeline
func (c *CodePipeline) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	return out, req.Send()
}

// DeletePipelineWithContext is the same as DeletePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DeletePipelineWithContext(ctx aws.Context, input *DeletePipelineInput, opts ...request.Option) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableStageTransition = "DisableStageTransition"

// DisableStageTransitionRequest generates a "aws/request.Request" representing the
// client's request for the DisableStageTransition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableStageTransition for more information on using the DisableStageTransition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableStageTransitionRequest method.
//    req, resp := client.DisableStageTransitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition
func (c *CodePipeline) DisableStageTransitionRequest(input *DisableStageTransitionInput) (req *request.Request, output *DisableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opDisableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableStageTransitionInput{}
	}

	output = &DisableStageTransitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableStageTransition API operation for AWS CodePipeline.
//
// Prevents artifacts in a pipeline from transitioning to the next stage in
// the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation DisableStageTransition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotFoundException "StageNotFoundException"
//   The specified stage was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransition
func (c *CodePipeline) DisableStageTransition(input *DisableStageTransitionInput) (*DisableStageTransitionOutput, error) {
	req, out := c.DisableStageTransitionRequest(input)
	return out, req.Send()
}

// DisableStageTransitionWithContext is the same as DisableStageTransition with the addition of
// the ability to pass a context and additional request options.
//
// See DisableStageTransition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) DisableStageTransitionWithContext(ctx aws.Context, input *DisableStageTransitionInput, opts ...request.Option) (*DisableStageTransitionOutput, error) {
	req, out := c.DisableStageTransitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableStageTransition = "EnableStageTransition"

// EnableStageTransitionRequest generates a "aws/request.Request" representing the
// client's request for the EnableStageTransition operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableStageTransition for more information on using the EnableStageTransition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableStageTransitionRequest method.
//    req, resp := client.EnableStageTransitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition
func (c *CodePipeline) EnableStageTransitionRequest(input *EnableStageTransitionInput) (req *request.Request, output *EnableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opEnableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableStageTransitionInput{}
	}

	output = &EnableStageTransitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableStageTransition API operation for AWS CodePipeline.
//
// Enables artifacts in a pipeline to transition to a stage in a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation EnableStageTransition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotFoundException "StageNotFoundException"
//   The specified stage was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransition
func (c *CodePipeline) EnableStageTransition(input *EnableStageTransitionInput) (*EnableStageTransitionOutput, error) {
	req, out := c.EnableStageTransitionRequest(input)
	return out, req.Send()
}

// EnableStageTransitionWithContext is the same as EnableStageTransition with the addition of
// the ability to pass a context and additional request options.
//
// See EnableStageTransition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) EnableStageTransitionWithContext(ctx aws.Context, input *EnableStageTransitionInput, opts ...request.Option) (*EnableStageTransitionOutput, error) {
	req, out := c.EnableStageTransitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobDetails = "GetJobDetails"

// GetJobDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobDetails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobDetails for more information on using the GetJobDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobDetailsRequest method.
//    req, resp := client.GetJobDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails
func (c *CodePipeline) GetJobDetailsRequest(input *GetJobDetailsInput) (req *request.Request, output *GetJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobDetailsInput{}
	}

	output = &GetJobDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobDetails API operation for AWS CodePipeline.
//
// Returns information about a job. Only used for custom actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the Amazon S3 bucket used to store artifacts for the pipeline, if the action
// requires access to that Amazon S3 bucket for input or output artifacts. Additionally,
// this API returns any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetJobDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetails
func (c *CodePipeline) GetJobDetails(input *GetJobDetailsInput) (*GetJobDetailsOutput, error) {
	req, out := c.GetJobDetailsRequest(input)
	return out, req.Send()
}

// GetJobDetailsWithContext is the same as GetJobDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetJobDetailsWithContext(ctx aws.Context, input *GetJobDetailsInput, opts ...request.Option) (*GetJobDetailsOutput, error) {
	req, out := c.GetJobDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipeline = "GetPipeline"

// GetPipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetPipeline operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipeline for more information on using the GetPipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPipelineRequest method.
//    req, resp := client.GetPipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline
func (c *CodePipeline) GetPipelineRequest(input *GetPipelineInput) (req *request.Request, output *GetPipelineOutput) {
	op := &request.Operation{
		Name:       opGetPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineInput{}
	}

	output = &GetPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipeline API operation for AWS CodePipeline.
//
// Returns the metadata, structure, stages, and actions of a pipeline. Can be
// used to return the entire structure of a pipeline in JSON format, which can
// then be modified and used to update the pipeline structure with UpdatePipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodePipelineVersionNotFoundException "PipelineVersionNotFoundException"
//   The specified pipeline version was specified in an invalid format or cannot
//   be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipeline
func (c *CodePipeline) GetPipeline(input *GetPipelineInput) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	return out, req.Send()
}

// GetPipelineWithContext is the same as GetPipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineWithContext(ctx aws.Context, input *GetPipelineInput, opts ...request.Option) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineExecution = "GetPipelineExecution"

// GetPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineExecution for more information on using the GetPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPipelineExecutionRequest method.
//    req, resp := client.GetPipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution
func (c *CodePipeline) GetPipelineExecutionRequest(input *GetPipelineExecutionInput) (req *request.Request, output *GetPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opGetPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineExecutionInput{}
	}

	output = &GetPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineExecution API operation for AWS CodePipeline.
//
// Returns information about an execution of a pipeline, including details about
// artifacts, the pipeline execution ID, and the name, version, and status of
// the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipelineExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodePipelineExecutionNotFoundException "PipelineExecutionNotFoundException"
//   The pipeline execution was specified in an invalid format or cannot be found,
//   or an execution ID does not belong to the specified pipeline.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecution
func (c *CodePipeline) GetPipelineExecution(input *GetPipelineExecutionInput) (*GetPipelineExecutionOutput, error) {
	req, out := c.GetPipelineExecutionRequest(input)
	return out, req.Send()
}

// GetPipelineExecutionWithContext is the same as GetPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineExecutionWithContext(ctx aws.Context, input *GetPipelineExecutionInput, opts ...request.Option) (*GetPipelineExecutionOutput, error) {
	req, out := c.GetPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPipelineState = "GetPipelineState"

// GetPipelineStateRequest generates a "aws/request.Request" representing the
// client's request for the GetPipelineState operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPipelineState for more information on using the GetPipelineState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPipelineStateRequest method.
//    req, resp := client.GetPipelineStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState
func (c *CodePipeline) GetPipelineStateRequest(input *GetPipelineStateInput) (req *request.Request, output *GetPipelineStateOutput) {
	op := &request.Operation{
		Name:       opGetPipelineState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineStateInput{}
	}

	output = &GetPipelineStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPipelineState API operation for AWS CodePipeline.
//
// Returns information about the state of a pipeline, including the stages and
// actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetPipelineState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineState
func (c *CodePipeline) GetPipelineState(input *GetPipelineStateInput) (*GetPipelineStateOutput, error) {
	req, out := c.GetPipelineStateRequest(input)
	return out, req.Send()
}

// GetPipelineStateWithContext is the same as GetPipelineState with the addition of
// the ability to pass a context and additional request options.
//
// See GetPipelineState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetPipelineStateWithContext(ctx aws.Context, input *GetPipelineStateInput, opts ...request.Option) (*GetPipelineStateOutput, error) {
	req, out := c.GetPipelineStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThirdPartyJobDetails = "GetThirdPartyJobDetails"

// GetThirdPartyJobDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetThirdPartyJobDetails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThirdPartyJobDetails for more information on using the GetThirdPartyJobDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetThirdPartyJobDetailsRequest method.
//    req, resp := client.GetThirdPartyJobDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails
func (c *CodePipeline) GetThirdPartyJobDetailsRequest(input *GetThirdPartyJobDetailsInput) (req *request.Request, output *GetThirdPartyJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetThirdPartyJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetThirdPartyJobDetailsInput{}
	}

	output = &GetThirdPartyJobDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThirdPartyJobDetails API operation for AWS CodePipeline.
//
// Requests the details of a job for a third party action. Only used for partner
// actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the Amazon S3 bucket used to store artifacts for the pipeline, if the action
// requires access to that Amazon S3 bucket for input or output artifacts. Additionally,
// this API returns any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation GetThirdPartyJobDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeInvalidClientTokenException "InvalidClientTokenException"
//   The client token was specified in an invalid format
//
//   * ErrCodeInvalidJobException "InvalidJobException"
//   The specified job was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetails
func (c *CodePipeline) GetThirdPartyJobDetails(input *GetThirdPartyJobDetailsInput) (*GetThirdPartyJobDetailsOutput, error) {
	req, out := c.GetThirdPartyJobDetailsRequest(input)
	return out, req.Send()
}

// GetThirdPartyJobDetailsWithContext is the same as GetThirdPartyJobDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetThirdPartyJobDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) GetThirdPartyJobDetailsWithContext(ctx aws.Context, input *GetThirdPartyJobDetailsInput, opts ...request.Option) (*GetThirdPartyJobDetailsOutput, error) {
	req, out := c.GetThirdPartyJobDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActionTypes = "ListActionTypes"

// ListActionTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListActionTypes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActionTypes for more information on using the ListActionTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActionTypesRequest method.
//    req, resp := client.ListActionTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes
func (c *CodePipeline) ListActionTypesRequest(input *ListActionTypesInput) (req *request.Request, output *ListActionTypesOutput) {
	op := &request.Operation{
		Name:       opListActionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListActionTypesInput{}
	}

	output = &ListActionTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActionTypes API operation for AWS CodePipeline.
//
// Gets a summary of all AWS CodePipeline action types associated with your
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListActionTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format. Make sure that the next
//   token you provided is the token returned by a previous call.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypes
func (c *CodePipeline) ListActionTypes(input *ListActionTypesInput) (*ListActionTypesOutput, error) {
	req, out := c.ListActionTypesRequest(input)
	return out, req.Send()
}

// ListActionTypesWithContext is the same as ListActionTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListActionTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListActionTypesWithContext(ctx aws.Context, input *ListActionTypesInput, opts ...request.Option) (*ListActionTypesOutput, error) {
	req, out := c.ListActionTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPipelineExecutions = "ListPipelineExecutions"

// ListPipelineExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelineExecutions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelineExecutions for more information on using the ListPipelineExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelineExecutionsRequest method.
//    req, resp := client.ListPipelineExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions
func (c *CodePipeline) ListPipelineExecutionsRequest(input *ListPipelineExecutionsInput) (req *request.Request, output *ListPipelineExecutionsOutput) {
	op := &request.Operation{
		Name:       opListPipelineExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPipelineExecutionsInput{}
	}

	output = &ListPipelineExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelineExecutions API operation for AWS CodePipeline.
//
// Gets a summary of the most recent executions for a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListPipelineExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format. Make sure that the next
//   token you provided is the token returned by a previous call.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutions
func (c *CodePipeline) ListPipelineExecutions(input *ListPipelineExecutionsInput) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	return out, req.Send()
}

// ListPipelineExecutionsWithContext is the same as ListPipelineExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelineExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelineExecutionsWithContext(ctx aws.Context, input *ListPipelineExecutionsInput, opts ...request.Option) (*ListPipelineExecutionsOutput, error) {
	req, out := c.ListPipelineExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipelines for more information on using the ListPipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPipelinesRequest method.
//    req, resp := client.ListPipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines
func (c *CodePipeline) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for AWS CodePipeline.
//
// Gets a summary of all of the pipelines associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation ListPipelines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format. Make sure that the next
//   token you provided is the token returned by a previous call.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelines
func (c *CodePipeline) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	return out, req.Send()
}

// ListPipelinesWithContext is the same as ListPipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) ListPipelinesWithContext(ctx aws.Context, input *ListPipelinesInput, opts ...request.Option) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPollForJobs = "PollForJobs"

// PollForJobsRequest generates a "aws/request.Request" representing the
// client's request for the PollForJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForJobs for more information on using the PollForJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PollForJobsRequest method.
//    req, resp := client.PollForJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs
func (c *CodePipeline) PollForJobsRequest(input *PollForJobsInput) (req *request.Request, output *PollForJobsOutput) {
	op := &request.Operation{
		Name:       opPollForJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForJobsInput{}
	}

	output = &PollForJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForJobs API operation for AWS CodePipeline.
//
// Returns information about any jobs for AWS CodePipeline to act upon.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the Amazon S3 bucket used to store artifacts for the pipeline, if the action
// requires access to that Amazon S3 bucket for input or output artifacts. Additionally,
// this API returns any secret values defined for the action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PollForJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeActionTypeNotFoundException "ActionTypeNotFoundException"
//   The specified action type cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobs
func (c *CodePipeline) PollForJobs(input *PollForJobsInput) (*PollForJobsOutput, error) {
	req, out := c.PollForJobsRequest(input)
	return out, req.Send()
}

// PollForJobsWithContext is the same as PollForJobs with the addition of
// the ability to pass a context and additional request options.
//
// See PollForJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PollForJobsWithContext(ctx aws.Context, input *PollForJobsInput, opts ...request.Option) (*PollForJobsOutput, error) {
	req, out := c.PollForJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPollForThirdPartyJobs = "PollForThirdPartyJobs"

// PollForThirdPartyJobsRequest generates a "aws/request.Request" representing the
// client's request for the PollForThirdPartyJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForThirdPartyJobs for more information on using the PollForThirdPartyJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PollForThirdPartyJobsRequest method.
//    req, resp := client.PollForThirdPartyJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs
func (c *CodePipeline) PollForThirdPartyJobsRequest(input *PollForThirdPartyJobsInput) (req *request.Request, output *PollForThirdPartyJobsOutput) {
	op := &request.Operation{
		Name:       opPollForThirdPartyJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForThirdPartyJobsInput{}
	}

	output = &PollForThirdPartyJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForThirdPartyJobs API operation for AWS CodePipeline.
//
// Determines whether there are any third party jobs for a job worker to act
// on. Only used for partner actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials for
// the Amazon S3 bucket used to store artifacts for the pipeline, if the action
// requires access to that Amazon S3 bucket for input or output artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PollForThirdPartyJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeActionTypeNotFoundException "ActionTypeNotFoundException"
//   The specified action type cannot be found.
//
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobs
func (c *CodePipeline) PollForThirdPartyJobs(input *PollForThirdPartyJobsInput) (*PollForThirdPartyJobsOutput, error) {
	req, out := c.PollForThirdPartyJobsRequest(input)
	return out, req.Send()
}

// PollForThirdPartyJobsWithContext is the same as PollForThirdPartyJobs with the addition of
// the ability to pass a context and additional request options.
//
// See PollForThirdPartyJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PollForThirdPartyJobsWithContext(ctx aws.Context, input *PollForThirdPartyJobsInput, opts ...request.Option) (*PollForThirdPartyJobsOutput, error) {
	req, out := c.PollForThirdPartyJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutActionRevision = "PutActionRevision"

// PutActionRevisionRequest generates a "aws/request.Request" representing the
// client's request for the PutActionRevision operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutActionRevision for more information on using the PutActionRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutActionRevisionRequest method.
//    req, resp := client.PutActionRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision
func (c *CodePipeline) PutActionRevisionRequest(input *PutActionRevisionInput) (req *request.Request, output *PutActionRevisionOutput) {
	op := &request.Operation{
		Name:       opPutActionRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutActionRevisionInput{}
	}

	output = &PutActionRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutActionRevision API operation for AWS CodePipeline.
//
// Provides information to AWS CodePipeline about new revisions to a source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutActionRevision for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotFoundException "StageNotFoundException"
//   The specified stage was specified in an invalid format or cannot be found.
//
//   * ErrCodeActionNotFoundException "ActionNotFoundException"
//   The specified action cannot be found.
//
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevision
func (c *CodePipeline) PutActionRevision(input *PutActionRevisionInput) (*PutActionRevisionOutput, error) {
	req, out := c.PutActionRevisionRequest(input)
	return out, req.Send()
}

// PutActionRevisionWithContext is the same as PutActionRevision with the addition of
// the ability to pass a context and additional request options.
//
// See PutActionRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutActionRevisionWithContext(ctx aws.Context, input *PutActionRevisionInput, opts ...request.Option) (*PutActionRevisionOutput, error) {
	req, out := c.PutActionRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApprovalResult = "PutApprovalResult"

// PutApprovalResultRequest generates a "aws/request.Request" representing the
// client's request for the PutApprovalResult operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApprovalResult for more information on using the PutApprovalResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutApprovalResultRequest method.
//    req, resp := client.PutApprovalResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult
func (c *CodePipeline) PutApprovalResultRequest(input *PutApprovalResultInput) (req *request.Request, output *PutApprovalResultOutput) {
	op := &request.Operation{
		Name:       opPutApprovalResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApprovalResultInput{}
	}

	output = &PutApprovalResultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutApprovalResult API operation for AWS CodePipeline.
//
// Provides the response to a manual approval request to AWS CodePipeline. Valid
// responses include Approved and Rejected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutApprovalResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidApprovalTokenException "InvalidApprovalTokenException"
//   The approval request already received a response or has expired.
//
//   * ErrCodeApprovalAlreadyCompletedException "ApprovalAlreadyCompletedException"
//   The approval action has already been approved or rejected.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotFoundException "StageNotFoundException"
//   The specified stage was specified in an invalid format or cannot be found.
//
//   * ErrCodeActionNotFoundException "ActionNotFoundException"
//   The specified action cannot be found.
//
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResult
func (c *CodePipeline) PutApprovalResult(input *PutApprovalResultInput) (*PutApprovalResultOutput, error) {
	req, out := c.PutApprovalResultRequest(input)
	return out, req.Send()
}

// PutApprovalResultWithContext is the same as PutApprovalResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutApprovalResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutApprovalResultWithContext(ctx aws.Context, input *PutApprovalResultInput, opts ...request.Option) (*PutApprovalResultOutput, error) {
	req, out := c.PutApprovalResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobFailureResult = "PutJobFailureResult"

// PutJobFailureResultRequest generates a "aws/request.Request" representing the
// client's request for the PutJobFailureResult operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobFailureResult for more information on using the PutJobFailureResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutJobFailureResultRequest method.
//    req, resp := client.PutJobFailureResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult
func (c *CodePipeline) PutJobFailureResultRequest(input *PutJobFailureResultInput) (req *request.Request, output *PutJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobFailureResultInput{}
	}

	output = &PutJobFailureResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutJobFailureResult API operation for AWS CodePipeline.
//
// Represents the failure of a job as returned to the pipeline by a job worker.
// Only used for custom actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutJobFailureResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidJobStateException "InvalidJobStateException"
//   The specified job state was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResult
func (c *CodePipeline) PutJobFailureResult(input *PutJobFailureResultInput) (*PutJobFailureResultOutput, error) {
	req, out := c.PutJobFailureResultRequest(input)
	return out, req.Send()
}

// PutJobFailureResultWithContext is the same as PutJobFailureResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobFailureResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutJobFailureResultWithContext(ctx aws.Context, input *PutJobFailureResultInput, opts ...request.Option) (*PutJobFailureResultOutput, error) {
	req, out := c.PutJobFailureResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutJobSuccessResult = "PutJobSuccessResult"

// PutJobSuccessResultRequest generates a "aws/request.Request" representing the
// client's request for the PutJobSuccessResult operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutJobSuccessResult for more information on using the PutJobSuccessResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutJobSuccessResultRequest method.
//    req, resp := client.PutJobSuccessResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult
func (c *CodePipeline) PutJobSuccessResultRequest(input *PutJobSuccessResultInput) (req *request.Request, output *PutJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobSuccessResultInput{}
	}

	output = &PutJobSuccessResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutJobSuccessResult API operation for AWS CodePipeline.
//
// Represents the success of a job as returned to the pipeline by a job worker.
// Only used for custom actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutJobSuccessResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidJobStateException "InvalidJobStateException"
//   The specified job state was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResult
func (c *CodePipeline) PutJobSuccessResult(input *PutJobSuccessResultInput) (*PutJobSuccessResultOutput, error) {
	req, out := c.PutJobSuccessResultRequest(input)
	return out, req.Send()
}

// PutJobSuccessResultWithContext is the same as PutJobSuccessResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutJobSuccessResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutJobSuccessResultWithContext(ctx aws.Context, input *PutJobSuccessResultInput, opts ...request.Option) (*PutJobSuccessResultOutput, error) {
	req, out := c.PutJobSuccessResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutThirdPartyJobFailureResult = "PutThirdPartyJobFailureResult"

// PutThirdPartyJobFailureResultRequest generates a "aws/request.Request" representing the
// client's request for the PutThirdPartyJobFailureResult operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutThirdPartyJobFailureResult for more information on using the PutThirdPartyJobFailureResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutThirdPartyJobFailureResultRequest method.
//    req, resp := client.PutThirdPartyJobFailureResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult
func (c *CodePipeline) PutThirdPartyJobFailureResultRequest(input *PutThirdPartyJobFailureResultInput) (req *request.Request, output *PutThirdPartyJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobFailureResultInput{}
	}

	output = &PutThirdPartyJobFailureResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutThirdPartyJobFailureResult API operation for AWS CodePipeline.
//
// Represents the failure of a third party job as returned to the pipeline by
// a job worker. Only used for partner actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutThirdPartyJobFailureResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidJobStateException "InvalidJobStateException"
//   The specified job state was specified in an invalid format.
//
//   * ErrCodeInvalidClientTokenException "InvalidClientTokenException"
//   The client token was specified in an invalid format
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResult
func (c *CodePipeline) PutThirdPartyJobFailureResult(input *PutThirdPartyJobFailureResultInput) (*PutThirdPartyJobFailureResultOutput, error) {
	req, out := c.PutThirdPartyJobFailureResultRequest(input)
	return out, req.Send()
}

// PutThirdPartyJobFailureResultWithContext is the same as PutThirdPartyJobFailureResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutThirdPartyJobFailureResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutThirdPartyJobFailureResultWithContext(ctx aws.Context, input *PutThirdPartyJobFailureResultInput, opts ...request.Option) (*PutThirdPartyJobFailureResultOutput, error) {
	req, out := c.PutThirdPartyJobFailureResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutThirdPartyJobSuccessResult = "PutThirdPartyJobSuccessResult"

// PutThirdPartyJobSuccessResultRequest generates a "aws/request.Request" representing the
// client's request for the PutThirdPartyJobSuccessResult operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutThirdPartyJobSuccessResult for more information on using the PutThirdPartyJobSuccessResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutThirdPartyJobSuccessResultRequest method.
//    req, resp := client.PutThirdPartyJobSuccessResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult
func (c *CodePipeline) PutThirdPartyJobSuccessResultRequest(input *PutThirdPartyJobSuccessResultInput) (req *request.Request, output *PutThirdPartyJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobSuccessResultInput{}
	}

	output = &PutThirdPartyJobSuccessResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutThirdPartyJobSuccessResult API operation for AWS CodePipeline.
//
// Represents the success of a third party job as returned to the pipeline by
// a job worker. Only used for partner actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation PutThirdPartyJobSuccessResult for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeJobNotFoundException "JobNotFoundException"
//   The specified job was specified in an invalid format or cannot be found.
//
//   * ErrCodeInvalidJobStateException "InvalidJobStateException"
//   The specified job state was specified in an invalid format.
//
//   * ErrCodeInvalidClientTokenException "InvalidClientTokenException"
//   The client token was specified in an invalid format
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResult
func (c *CodePipeline) PutThirdPartyJobSuccessResult(input *PutThirdPartyJobSuccessResultInput) (*PutThirdPartyJobSuccessResultOutput, error) {
	req, out := c.PutThirdPartyJobSuccessResultRequest(input)
	return out, req.Send()
}

// PutThirdPartyJobSuccessResultWithContext is the same as PutThirdPartyJobSuccessResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutThirdPartyJobSuccessResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) PutThirdPartyJobSuccessResultWithContext(ctx aws.Context, input *PutThirdPartyJobSuccessResultInput, opts ...request.Option) (*PutThirdPartyJobSuccessResultOutput, error) {
	req, out := c.PutThirdPartyJobSuccessResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetryStageExecution = "RetryStageExecution"

// RetryStageExecutionRequest generates a "aws/request.Request" representing the
// client's request for the RetryStageExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RetryStageExecution for more information on using the RetryStageExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RetryStageExecutionRequest method.
//    req, resp := client.RetryStageExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution
func (c *CodePipeline) RetryStageExecutionRequest(input *RetryStageExecutionInput) (req *request.Request, output *RetryStageExecutionOutput) {
	op := &request.Operation{
		Name:       opRetryStageExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetryStageExecutionInput{}
	}

	output = &RetryStageExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetryStageExecution API operation for AWS CodePipeline.
//
// Resumes the pipeline execution by retrying the last failed actions in a stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation RetryStageExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotFoundException "StageNotFoundException"
//   The specified stage was specified in an invalid format or cannot be found.
//
//   * ErrCodeStageNotRetryableException "StageNotRetryableException"
//   The specified stage can't be retried because the pipeline structure or stage
//   state changed after the stage was not completed; the stage contains no failed
//   actions; one or more actions are still in progress; or another retry attempt
//   is already in progress.
//
//   * ErrCodeNotLatestPipelineExecutionException "NotLatestPipelineExecutionException"
//   The stage has failed in a later run of the pipeline and the pipelineExecutionId
//   associated with the request is out of date.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecution
func (c *CodePipeline) RetryStageExecution(input *RetryStageExecutionInput) (*RetryStageExecutionOutput, error) {
	req, out := c.RetryStageExecutionRequest(input)
	return out, req.Send()
}

// RetryStageExecutionWithContext is the same as RetryStageExecution with the addition of
// the ability to pass a context and additional request options.
//
// See RetryStageExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) RetryStageExecutionWithContext(ctx aws.Context, input *RetryStageExecutionInput, opts ...request.Option) (*RetryStageExecutionOutput, error) {
	req, out := c.RetryStageExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipelineExecution = "StartPipelineExecution"

// StartPipelineExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartPipelineExecution operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipelineExecution for more information on using the StartPipelineExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPipelineExecutionRequest method.
//    req, resp := client.StartPipelineExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution
func (c *CodePipeline) StartPipelineExecutionRequest(input *StartPipelineExecutionInput) (req *request.Request, output *StartPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStartPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPipelineExecutionInput{}
	}

	output = &StartPipelineExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipelineExecution API operation for AWS CodePipeline.
//
// Starts the specified pipeline. Specifically, it begins processing the latest
// commit to the source location specified as part of the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation StartPipelineExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodePipelineNotFoundException "PipelineNotFoundException"
//   The specified pipeline was specified in an invalid format or cannot be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecution
func (c *CodePipeline) StartPipelineExecution(input *StartPipelineExecutionInput) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	return out, req.Send()
}

// StartPipelineExecutionWithContext is the same as StartPipelineExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipelineExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) StartPipelineExecutionWithContext(ctx aws.Context, input *StartPipelineExecutionInput, opts ...request.Option) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipeline for more information on using the UpdatePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePipelineRequest method.
//    req, resp := client.UpdatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline
func (c *CodePipeline) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipeline API operation for AWS CodePipeline.
//
// Updates a specified pipeline with edits or changes to its structure. Use
// a JSON file with the pipeline structure in conjunction with UpdatePipeline
// to provide the full structure of the pipeline. Updating the pipeline increases
// the version number of the pipeline by 1.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodePipeline's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The validation was specified in an invalid format.
//
//   * ErrCodeInvalidStageDeclarationException "InvalidStageDeclarationException"
//   The specified stage declaration was specified in an invalid format.
//
//   * ErrCodeInvalidActionDeclarationException "InvalidActionDeclarationException"
//   The specified action declaration was specified in an invalid format.
//
//   * ErrCodeInvalidBlockerDeclarationException "InvalidBlockerDeclarationException"
//   Reserved for future use.
//
//   * ErrCodeInvalidStructureException "InvalidStructureException"
//   The specified structure was specified in an invalid format.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipeline
func (c *CodePipeline) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	return out, req.Send()
}

// UpdatePipelineWithContext is the same as UpdatePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodePipeline) UpdatePipelineWithContext(ctx aws.Context, input *UpdatePipelineInput, opts ...request.Option) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an AWS session credentials object. These credentials are temporary
// credentials that are issued by AWS Secure Token Service (STS). They can be
// used to access input and output artifacts in the Amazon S3 bucket used to
// store artifact for the pipeline in AWS CodePipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AWSSessionCredentials
type AWSSessionCredentials struct {
	_ struct{} `type:"structure"`

	// The access key for the session.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true"`

	// The secret access key for the session.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true"`

	// The token for the session.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`
}

// String returns the string representation
func (s AWSSessionCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSSessionCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AWSSessionCredentials) SetAccessKeyId(v string) *AWSSessionCredentials {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AWSSessionCredentials) SetSecretAccessKey(v string) *AWSSessionCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AWSSessionCredentials) SetSessionToken(v string) *AWSSessionCredentials {
	s.SessionToken = &v
	return s
}

// Represents the input of an AcknowledgeJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJobInput
type AcknowledgeJobInput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the job for which you want to confirm receipt.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Get this number from the
	// response of the PollForJobs request that returned this job.
	//
	// Nonce is a required field
	Nonce *string `locationName:"nonce" type:"string" required:"true"`
}

// String returns the string representation
func (s AcknowledgeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.Nonce == nil {
		invalidParams.Add(request.NewErrParamRequired("Nonce"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *AcknowledgeJobInput) SetJobId(v string) *AcknowledgeJobInput {
	s.JobId = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *AcknowledgeJobInput) SetNonce(v string) *AcknowledgeJobInput {
	s.Nonce = &v
	return s
}

// Represents the output of an AcknowledgeJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeJobOutput
type AcknowledgeJobOutput struct {
	_ struct{} `type:"structure"`

	// Whether the job worker has received the specified job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s AcknowledgeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AcknowledgeJobOutput) SetStatus(v string) *AcknowledgeJobOutput {
	s.Status = &v
	return s
}

// Represents the input of an AcknowledgeThirdPartyJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJobInput
type AcknowledgeThirdPartyJobInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// The unique system-generated ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Get this number from the
	// response to a GetThirdPartyJobDetails request.
	//
	// Nonce is a required field
	Nonce *string `locationName:"nonce" type:"string" required:"true"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeThirdPartyJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeThirdPartyJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcknowledgeThirdPartyJobInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.Nonce == nil {
		invalidParams.Add(request.NewErrParamRequired("Nonce"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *AcknowledgeThirdPartyJobInput) SetClientToken(v string) *AcknowledgeThirdPartyJobInput {
	s.ClientToken = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AcknowledgeThirdPartyJobInput) SetJobId(v string) *AcknowledgeThirdPartyJobInput {
	s.JobId = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *AcknowledgeThirdPartyJobInput) SetNonce(v string) *AcknowledgeThirdPartyJobInput {
	s.Nonce = &v
	return s
}

// Represents the output of an AcknowledgeThirdPartyJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJobOutput
type AcknowledgeThirdPartyJobOutput struct {
	_ struct{} `type:"structure"`

	// The status information for the third party job, if any.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeThirdPartyJobOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AcknowledgeThirdPartyJobOutput) SetStatus(v string) *AcknowledgeThirdPartyJobOutput {
	s.Status = &v
	return s
}

// Represents information about an action configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionConfiguration
type ActionConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration data for the action.
	Configuration map[string]*string `locationName:"configuration" type:"map"`
}

// String returns the string representation
func (s ActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionConfiguration) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionConfiguration) SetConfiguration(v map[string]*string) *ActionConfiguration {
	s.Configuration = v
	return s
}

// Represents information about an action configuration property.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionConfigurationProperty
type ActionConfigurationProperty struct {
	_ struct{} `type:"structure"`

	// The description of the action configuration property that will be displayed
	// to users.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the configuration property is a key.
	//
	// Key is a required field
	Key *bool `locationName:"key" type:"boolean" required:"true"`

	// The name of the action configuration property.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Indicates that the property will be used in conjunction with PollForJobs.
	// When creating a custom action, an action can have up to one queryable property.
	// If it has one, that property must be both required and not secret.
	//
	// If you create a pipeline with a custom action type, and that custom action
	// contains a queryable property, the value for that configuration property
	// is subject to additional restrictions. The value must be less than or equal
	// to twenty (20) characters. The value can contain only alphanumeric characters,
	// underscores, and hyphens.
	Queryable *bool `locationName:"queryable" type:"boolean"`

	// Whether the configuration property is a required value.
	//
	// Required is a required field
	Required *bool `locationName:"required" type:"boolean" required:"true"`

	// Whether the configuration property is secret. Secrets are hidden from all
	// calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and
	// PollForThirdPartyJobs.
	//
	// When updating a pipeline, passing * * * * * without changing any other values
	// of the action will preserve the prior value of the secret.
	//
	// Secret is a required field
	Secret *bool `locationName:"secret" type:"boolean" required:"true"`

	// The type of the configuration property.
	Type *string `locationName:"type" type:"string" enum:"ActionConfigurationPropertyType"`
}

// String returns the string representation
func (s ActionConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionConfigurationProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionConfigurationProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionConfigurationProperty"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Required == nil {
		invalidParams.Add(request.NewErrParamRequired("Required"))
	}
	if s.Secret == nil {
		invalidParams.Add(request.NewErrParamRequired("Secret"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ActionConfigurationProperty) SetDescription(v string) *ActionConfigurationProperty {
	s.Description = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ActionConfigurationProperty) SetKey(v bool) *ActionConfigurationProperty {
	s.Key = &v
	return s
}

// SetName sets the Name field's value.
func (s *ActionConfigurationProperty) SetName(v string) *ActionConfigurationProperty {
	s.Name = &v
	return s
}

// SetQueryable sets the Queryable field's value.
func (s *ActionConfigurationProperty) SetQueryable(v bool) *ActionConfigurationProperty {
	s.Queryable = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ActionConfigurationProperty) SetRequired(v bool) *ActionConfigurationProperty {
	s.Required = &v
	return s
}

// SetSecret sets the Secret field's value.
func (s *ActionConfigurationProperty) SetSecret(v bool) *ActionConfigurationProperty {
	s.Secret = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActionConfigurationProperty) SetType(v string) *ActionConfigurationProperty {
	s.Type = &v
	return s
}

// Represents the context of an action within the stage of a pipeline to a job
// worker.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionContext
type ActionContext struct {
	_ struct{} `type:"structure"`

	// The name of the action within the context of a job.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionContext) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ActionContext) SetName(v string) *ActionContext {
	s.Name = &v
	return s
}

// Represents information about an action declaration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionDeclaration
type ActionDeclaration struct {
	_ struct{} `type:"structure"`

	// The configuration information for the action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The action declaration's configuration.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// The name or ID of the artifact consumed by the action, such as a test or
	// build artifact.
	InputArtifacts []*InputArtifact `locationName:"inputArtifacts" type:"list"`

	// The action declaration's name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ID of the result of the action declaration, such as a test or
	// build artifact.
	OutputArtifacts []*OutputArtifact `locationName:"outputArtifacts" type:"list"`

	// The ARN of the IAM service role that will perform the declared action. This
	// is assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The order in which actions are run.
	RunOrder *int64 `locationName:"runOrder" min:"1" type:"integer"`
}

// String returns the string representation
func (s ActionDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionDeclaration"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RunOrder != nil && *s.RunOrder < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RunOrder", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}
	if s.InputArtifacts != nil {
		for i, v := range s.InputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputArtifacts != nil {
		for i, v := range s.OutputArtifacts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputArtifacts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *ActionDeclaration) SetActionTypeId(v *ActionTypeId) *ActionDeclaration {
	s.ActionTypeId = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ActionDeclaration) SetConfiguration(v map[string]*string) *ActionDeclaration {
	s.Configuration = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *ActionDeclaration) SetInputArtifacts(v []*InputArtifact) *ActionDeclaration {
	s.InputArtifacts = v
	return s
}

// SetName sets the Name field's value.
func (s *ActionDeclaration) SetName(v string) *ActionDeclaration {
	s.Name = &v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *ActionDeclaration) SetOutputArtifacts(v []*OutputArtifact) *ActionDeclaration {
	s.OutputArtifacts = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ActionDeclaration) SetRoleArn(v string) *ActionDeclaration {
	s.RoleArn = &v
	return s
}

// SetRunOrder sets the RunOrder field's value.
func (s *ActionDeclaration) SetRunOrder(v int64) *ActionDeclaration {
	s.RunOrder = &v
	return s
}

// Represents information about the run of an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionExecution
type ActionExecution struct {
	_ struct{} `type:"structure"`

	// The details of an error returned by a URL external to AWS.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The external ID of the run of the action.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The URL of a resource external to AWS that will be used when running the
	// action, for example an external repository URL.
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`

	// The last status change of the action.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp" timestampFormat:"unix"`

	// The ARN of the user who last changed the pipeline.
	LastUpdatedBy *string `locationName:"lastUpdatedBy" type:"string"`

	// A percentage of completeness of the action as it runs.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The status of the action, or for a completed action, the last status of the
	// action.
	Status *string `locationName:"status" type:"string" enum:"ActionExecutionStatus"`

	// A summary of the run of the action.
	Summary *string `locationName:"summary" type:"string"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// command and is used to validate that the approval request corresponding to
	// this token is still valid.
	Token *string `locationName:"token" type:"string"`
}

// String returns the string representation
func (s ActionExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionExecution) GoString() string {
	return s.String()
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *ActionExecution) SetErrorDetails(v *ErrorDetails) *ActionExecution {
	s.ErrorDetails = v
	return s
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *ActionExecution) SetExternalExecutionId(v string) *ActionExecution {
	s.ExternalExecutionId = &v
	return s
}

// SetExternalExecutionUrl sets the ExternalExecutionUrl field's value.
func (s *ActionExecution) SetExternalExecutionUrl(v string) *ActionExecution {
	s.ExternalExecutionUrl = &v
	return s
}

// SetLastStatusChange sets the LastStatusChange field's value.
func (s *ActionExecution) SetLastStatusChange(v time.Time) *ActionExecution {
	s.LastStatusChange = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *ActionExecution) SetLastUpdatedBy(v string) *ActionExecution {
	s.LastUpdatedBy = &v
	return s
}

// SetPercentComplete sets the PercentComplete field's value.
func (s *ActionExecution) SetPercentComplete(v int64) *ActionExecution {
	s.PercentComplete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActionExecution) SetStatus(v string) *ActionExecution {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ActionExecution) SetSummary(v string) *ActionExecution {
	s.Summary = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ActionExecution) SetToken(v string) *ActionExecution {
	s.Token = &v
	return s
}

// Represents information about the version (or revision) of an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionRevision
type ActionRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent version of the action was created,
	// in timestamp format.
	//
	// Created is a required field
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The unique identifier of the change that set the state to this revision,
	// for example a deployment ID or timestamp.
	//
	// RevisionChangeId is a required field
	RevisionChangeId *string `locationName:"revisionChangeId" min:"1" type:"string" required:"true"`

	// The system-generated unique ID that identifies the revision number of the
	// action.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActionRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionRevision) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionRevision) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionRevision"}
	if s.Created == nil {
		invalidParams.Add(request.NewErrParamRequired("Created"))
	}
	if s.RevisionChangeId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionChangeId"))
	}
	if s.RevisionChangeId != nil && len(*s.RevisionChangeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionChangeId", 1))
	}
	if s.RevisionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RevisionId"))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreated sets the Created field's value.
func (s *ActionRevision) SetCreated(v time.Time) *ActionRevision {
	s.Created = &v
	return s
}

// SetRevisionChangeId sets the RevisionChangeId field's value.
func (s *ActionRevision) SetRevisionChangeId(v string) *ActionRevision {
	s.RevisionChangeId = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ActionRevision) SetRevisionId(v string) *ActionRevision {
	s.RevisionId = &v
	return s
}

// Represents information about the state of an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionState
type ActionState struct {
	_ struct{} `type:"structure"`

	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Represents information about the version (or revision) of an action.
	CurrentRevision *ActionRevision `locationName:"currentRevision" type:"structure"`

	// A URL link for more information about the state of the action, such as a
	// deployment group details page.
	EntityUrl *string `locationName:"entityUrl" min:"1" type:"string"`

	// Represents information about the run of an action.
	LatestExecution *ActionExecution `locationName:"latestExecution" type:"structure"`

	// A URL link for more information about the revision, such as a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionState) GoString() string {
	return s.String()
}

// SetActionName sets the ActionName field's value.
func (s *ActionState) SetActionName(v string) *ActionState {
	s.ActionName = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *ActionState) SetCurrentRevision(v *ActionRevision) *ActionState {
	s.CurrentRevision = v
	return s
}

// SetEntityUrl sets the EntityUrl field's value.
func (s *ActionState) SetEntityUrl(v string) *ActionState {
	s.EntityUrl = &v
	return s
}

// SetLatestExecution sets the LatestExecution field's value.
func (s *ActionState) SetLatestExecution(v *ActionExecution) *ActionState {
	s.LatestExecution = v
	return s
}

// SetRevisionUrl sets the RevisionUrl field's value.
func (s *ActionState) SetRevisionUrl(v string) *ActionState {
	s.RevisionUrl = &v
	return s
}

// Returns information about the details of an action type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionType
type ActionType struct {
	_ struct{} `type:"structure"`

	// The configuration properties for the action type.
	ActionConfigurationProperties []*ActionConfigurationProperty `locationName:"actionConfigurationProperties" type:"list"`

	// Represents information about an action type.
	//
	// Id is a required field
	Id *ActionTypeId `locationName:"id" type:"structure" required:"true"`

	// The details of the input artifact for the action, such as its commit ID.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The settings for the action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`
}

// String returns the string representation
func (s ActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionType) GoString() string {
	return s.String()
}

// SetActionConfigurationProperties sets the ActionConfigurationProperties field's value.
func (s *ActionType) SetActionConfigurationProperties(v []*ActionConfigurationProperty) *ActionType {
	s.ActionConfigurationProperties = v
	return s
}

// SetId sets the Id field's value.
func (s *ActionType) SetId(v *ActionTypeId) *ActionType {
	s.Id = v
	return s
}

// SetInputArtifactDetails sets the InputArtifactDetails field's value.
func (s *ActionType) SetInputArtifactDetails(v *ArtifactDetails) *ActionType {
	s.InputArtifactDetails = v
	return s
}

// SetOutputArtifactDetails sets the OutputArtifactDetails field's value.
func (s *ActionType) SetOutputArtifactDetails(v *ArtifactDetails) *ActionType {
	s.OutputArtifactDetails = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *ActionType) SetSettings(v *ActionTypeSettings) *ActionType {
	s.Settings = v
	return s
}

// Represents information about an action type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionTypeId
type ActionTypeId struct {
	_ struct{} `type:"structure"`

	// A category defines what kind of action can be taken in the stage, and constrains
	// the provider type for the action. Valid categories are limited to one of
	// the values below.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The creator of the action being called.
	//
	// Owner is a required field
	Owner *string `locationName:"owner" type:"string" required:"true" enum:"ActionOwner"`

	// The provider of the service being called by the action. Valid providers are
	// determined by the action category. For example, an action in the Deploy category
	// type might have a provider of AWS CodeDeploy, which would be specified as
	// CodeDeploy.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that identifies the action type.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActionTypeId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTypeId) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeId) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeId"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *ActionTypeId) SetCategory(v string) *ActionTypeId {
	s.Category = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ActionTypeId) SetOwner(v string) *ActionTypeId {
	s.Owner = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *ActionTypeId) SetProvider(v string) *ActionTypeId {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ActionTypeId) SetVersion(v string) *ActionTypeId {
	s.Version = &v
	return s
}

// Returns information about the settings for an action type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ActionTypeSettings
type ActionTypeSettings struct {
	_ struct{} `type:"structure"`

	// The URL returned to the AWS CodePipeline console that provides a deep link
	// to the resources of the external system, such as the configuration page for
	// an AWS CodeDeploy deployment group. This link is provided as part of the
	// action display within the pipeline.
	EntityUrlTemplate *string `locationName:"entityUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the top-level landing page for the external system, such as console page
	// for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS
	// CodePipeline console and provides a link to the execution entity of the external
	// action.
	ExecutionUrlTemplate *string `locationName:"executionUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string `locationName:"revisionUrlTemplate" min:"1" type:"string"`

	// The URL of a sign-up page where users can sign up for an external service
	// and perform initial configuration of the action provided by that service.
	ThirdPartyConfigurationUrl *string `locationName:"thirdPartyConfigurationUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ActionTypeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTypeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActionTypeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActionTypeSettings"}
	if s.EntityUrlTemplate != nil && len(*s.EntityUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntityUrlTemplate", 1))
	}
	if s.ExecutionUrlTemplate != nil && len(*s.ExecutionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionUrlTemplate", 1))
	}
	if s.RevisionUrlTemplate != nil && len(*s.RevisionUrlTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionUrlTemplate", 1))
	}
	if s.ThirdPartyConfigurationUrl != nil && len(*s.ThirdPartyConfigurationUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThirdPartyConfigurationUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityUrlTemplate sets the EntityUrlTemplate field's value.
func (s *ActionTypeSettings) SetEntityUrlTemplate(v string) *ActionTypeSettings {
	s.EntityUrlTemplate = &v
	return s
}

// SetExecutionUrlTemplate sets the ExecutionUrlTemplate field's value.
func (s *ActionTypeSettings) SetExecutionUrlTemplate(v string) *ActionTypeSettings {
	s.ExecutionUrlTemplate = &v
	return s
}

// SetRevisionUrlTemplate sets the RevisionUrlTemplate field's value.
func (s *ActionTypeSettings) SetRevisionUrlTemplate(v string) *ActionTypeSettings {
	s.RevisionUrlTemplate = &v
	return s
}

// SetThirdPartyConfigurationUrl sets the ThirdPartyConfigurationUrl field's value.
func (s *ActionTypeSettings) SetThirdPartyConfigurationUrl(v string) *ActionTypeSettings {
	s.ThirdPartyConfigurationUrl = &v
	return s
}

// Represents information about the result of an approval request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ApprovalResult
type ApprovalResult struct {
	_ struct{} `type:"structure"`

	// The response submitted by a reviewer assigned to an approval action request.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ApprovalStatus"`

	// The summary of the current status of the approval request.
	//
	// Summary is a required field
	Summary *string `locationName:"summary" type:"string" required:"true"`
}

// String returns the string representation
func (s ApprovalResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApprovalResult) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApprovalResult) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApprovalResult"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Summary == nil {
		invalidParams.Add(request.NewErrParamRequired("Summary"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *ApprovalResult) SetStatus(v string) *ApprovalResult {
	s.Status = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ApprovalResult) SetSummary(v string) *ApprovalResult {
	s.Summary = &v
	return s
}

// Represents information about an artifact that will be worked upon by actions
// in the pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/Artifact
type Artifact struct {
	_ struct{} `type:"structure"`

	// The location of an artifact.
	Location *ArtifactLocation `locationName:"location" type:"structure"`

	// The artifact's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The artifact's revision ID. Depending on the type of object, this could be
	// a commit ID (GitHub) or a revision ID (Amazon S3).
	Revision *string `locationName:"revision" min:"1" type:"string"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Artifact) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *Artifact) SetLocation(v *ArtifactLocation) *Artifact {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Artifact) SetName(v string) *Artifact {
	s.Name = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *Artifact) SetRevision(v string) *Artifact {
	s.Revision = &v
	return s
}

// Returns information about the details of an artifact.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ArtifactDetails
type ArtifactDetails struct {
	_ struct{} `type:"structure"`

	// The maximum number of artifacts allowed for the action type.
	//
	// MaximumCount is a required field
	MaximumCount *int64 `locationName:"maximumCount" type:"integer" required:"true"`

	// The minimum number of artifacts allowed for the action type.
	//
	// MinimumCount is a required field
	MinimumCount *int64 `locationName:"minimumCount" type:"integer" required:"true"`
}

// String returns the string representation
func (s ArtifactDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactDetails"}
	if s.MaximumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumCount"))
	}
	if s.MinimumCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumCount sets the MaximumCount field's value.
func (s *ArtifactDetails) SetMaximumCount(v int64) *ArtifactDetails {
	s.MaximumCount = &v
	return s
}

// SetMinimumCount sets the MinimumCount field's value.
func (s *ArtifactDetails) SetMinimumCount(v int64) *ArtifactDetails {
	s.MinimumCount = &v
	return s
}

// Represents information about the location of an artifact.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ArtifactLocation
type ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the artifact.
	S3Location *S3ArtifactLocation `locationName:"s3Location" type:"structure"`

	// The type of artifact in the location.
	Type *string `locationName:"type" type:"string" enum:"ArtifactLocationType"`
}

// String returns the string representation
func (s ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactLocation) GoString() string {
	return s.String()
}

// SetS3Location sets the S3Location field's value.
func (s *ArtifactLocation) SetS3Location(v *S3ArtifactLocation) *ArtifactLocation {
	s.S3Location = v
	return s
}

// SetType sets the Type field's value.
func (s *ArtifactLocation) SetType(v string) *ArtifactLocation {
	s.Type = &v
	return s
}

// Represents revision details of an artifact.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ArtifactRevision
type ArtifactRevision struct {
	_ struct{} `type:"structure"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The name of an artifact. This name might be system-generated, such as "MyApp",
	// or might be defined by the user when an action is created.
	Name *string `locationName:"name" min:"1" type:"string"`

	// An additional identifier for a revision, such as a commit date or, for artifacts
	// stored in Amazon S3 buckets, the ETag value.
	RevisionChangeIdentifier *string `locationName:"revisionChangeIdentifier" min:"1" type:"string"`

	// The revision ID of the artifact.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Summary information about the most recent revision of the artifact. For GitHub
	// and AWS CodeCommit repositories, the commit message. For Amazon S3 buckets
	// or actions, the user-provided content of a codepipeline-artifact-revision-summary
	// key specified in the object metadata.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`

	// The commit ID for the artifact revision. For artifacts stored in GitHub or
	// AWS CodeCommit repositories, the commit ID is linked to a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ArtifactRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactRevision) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *ArtifactRevision) SetCreated(v time.Time) *ArtifactRevision {
	s.Created = &v
	return s
}

// SetName sets the Name field's value.
func (s *ArtifactRevision) SetName(v string) *ArtifactRevision {
	s.Name = &v
	return s
}

// SetRevisionChangeIdentifier sets the RevisionChangeIdentifier field's value.
func (s *ArtifactRevision) SetRevisionChangeIdentifier(v string) *ArtifactRevision {
	s.RevisionChangeIdentifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ArtifactRevision) SetRevisionId(v string) *ArtifactRevision {
	s.RevisionId = &v
	return s
}

// SetRevisionSummary sets the RevisionSummary field's value.
func (s *ArtifactRevision) SetRevisionSummary(v string) *ArtifactRevision {
	s.RevisionSummary = &v
	return s
}

// SetRevisionUrl sets the RevisionUrl field's value.
func (s *ArtifactRevision) SetRevisionUrl(v string) *ArtifactRevision {
	s.RevisionUrl = &v
	return s
}

// The Amazon S3 bucket where artifacts are stored for the pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ArtifactStore
type ArtifactStore struct {
	_ struct{} `type:"structure"`

	// The encryption key used to encrypt the data in the artifact store, such as
	// an AWS Key Management Service (AWS KMS) key. If this is undefined, the default
	// key for Amazon S3 is used.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The Amazon S3 bucket used for storing the artifacts for a pipeline. You can
	// specify the name of an S3 bucket but not a folder within the bucket. A folder
	// to contain the pipeline artifacts is created for you based on the name of
	// the pipeline. You can use any Amazon S3 bucket in the same AWS Region as
	// the pipeline to store your pipeline artifacts.
	//
	// Location is a required field
	Location *string `locationName:"location" min:"3" type:"string" required:"true"`

	// The type of the artifact store, such as S3.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactStoreType"`
}

// String returns the string representation
func (s ArtifactStore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactStore) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactStore) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactStore"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.EncryptionKey != nil {
		if err := s.EncryptionKey.Validate(); err != nil {
			invalidParams.AddNested("EncryptionKey", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ArtifactStore) SetEncryptionKey(v *EncryptionKey) *ArtifactStore {
	s.EncryptionKey = v
	return s
}

// SetLocation sets the Location field's value.
func (s *ArtifactStore) SetLocation(v string) *ArtifactStore {
	s.Location = &v
	return s
}

// SetType sets the Type field's value.
func (s *ArtifactStore) SetType(v string) *ArtifactStore {
	s.Type = &v
	return s
}

// Reserved for future use.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/BlockerDeclaration
type BlockerDeclaration struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Reserved for future use.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BlockerType"`
}

// String returns the string representation
func (s BlockerDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockerDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockerDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockerDeclaration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *BlockerDeclaration) SetName(v string) *BlockerDeclaration {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *BlockerDeclaration) SetType(v string) *BlockerDeclaration {
	s.Type = &v
	return s
}

// Represents the input of a CreateCustomActionType operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionTypeInput
type CreateCustomActionTypeInput struct {
	_ struct{} `type:"structure"`

	// The category of the custom action, such as a build action or a test action.
	//
	// Although Source and Approval are listed as valid values, they are not currently
	// functional. These values are reserved for future use.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The configuration properties for the custom action.
	//
	// You can refer to a name in the configuration properties of the custom action
	// within the URL templates by following the format of {Config:name}, as long
	// as the configuration property is both required and not secret. For more information,
	// see Create a Custom Action for a Pipeline (http://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html).
	ConfigurationProperties []*ActionConfigurationProperty `locationName:"configurationProperties" type:"list"`

	// The details of the input artifact for the action, such as its commit ID.
	//
	// InputArtifactDetails is a required field
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	//
	// OutputArtifactDetails is a required field
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The provider of the service used in the custom action, such as AWS CodeDeploy.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// Returns information about the settings for an action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`

	// The version identifier of the custom action.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomActionTypeInput"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.InputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("InputArtifactDetails"))
	}
	if s.OutputArtifactDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArtifactDetails"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.ConfigurationProperties != nil {
		for i, v := range s.ConfigurationProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ConfigurationProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.InputArtifactDetails != nil {
		if err := s.InputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("InputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputArtifactDetails != nil {
		if err := s.OutputArtifactDetails.Validate(); err != nil {
			invalidParams.AddNested("OutputArtifactDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *CreateCustomActionTypeInput) SetCategory(v string) *CreateCustomActionTypeInput {
	s.Category = &v
	return s
}

// SetConfigurationProperties sets the ConfigurationProperties field's value.
func (s *CreateCustomActionTypeInput) SetConfigurationProperties(v []*ActionConfigurationProperty) *CreateCustomActionTypeInput {
	s.ConfigurationProperties = v
	return s
}

// SetInputArtifactDetails sets the InputArtifactDetails field's value.
func (s *CreateCustomActionTypeInput) SetInputArtifactDetails(v *ArtifactDetails) *CreateCustomActionTypeInput {
	s.InputArtifactDetails = v
	return s
}

// SetOutputArtifactDetails sets the OutputArtifactDetails field's value.
func (s *CreateCustomActionTypeInput) SetOutputArtifactDetails(v *ArtifactDetails) *CreateCustomActionTypeInput {
	s.OutputArtifactDetails = v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateCustomActionTypeInput) SetProvider(v string) *CreateCustomActionTypeInput {
	s.Provider = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateCustomActionTypeInput) SetSettings(v *ActionTypeSettings) *CreateCustomActionTypeInput {
	s.Settings = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateCustomActionTypeInput) SetVersion(v string) *CreateCustomActionTypeInput {
	s.Version = &v
	return s
}

// Represents the output of a CreateCustomActionType operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreateCustomActionTypeOutput
type CreateCustomActionTypeOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the details of an action type.
	//
	// ActionType is a required field
	ActionType *ActionType `locationName:"actionType" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomActionTypeOutput) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *CreateCustomActionTypeOutput) SetActionType(v *ActionType) *CreateCustomActionTypeOutput {
	s.ActionType = v
	return s
}

// Represents the input of a CreatePipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipelineInput
type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	//
	// Pipeline is a required field
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.Pipeline == nil {
		invalidParams.Add(request.NewErrParamRequired("Pipeline"))
	}
	if s.Pipeline != nil {
		if err := s.Pipeline.Validate(); err != nil {
			invalidParams.AddNested("Pipeline", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineInput) SetPipeline(v *PipelineDeclaration) *CreatePipelineInput {
	s.Pipeline = v
	return s
}

// Represents the output of a CreatePipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CreatePipelineOutput
type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineOutput) SetPipeline(v *PipelineDeclaration) *CreatePipelineOutput {
	s.Pipeline = v
	return s
}

// Represents information about a current revision.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/CurrentRevision
type CurrentRevision struct {
	_ struct{} `type:"structure"`

	// The change identifier for the current revision.
	//
	// ChangeIdentifier is a required field
	ChangeIdentifier *string `locationName:"changeIdentifier" min:"1" type:"string" required:"true"`

	// The date and time when the most recent revision of the artifact was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The revision ID of the current version of an artifact.
	//
	// Revision is a required field
	Revision *string `locationName:"revision" min:"1" type:"string" required:"true"`

	// The summary of the most recent revision of the artifact.
	RevisionSummary *string `locationName:"revisionSummary" min:"1" type:"string"`
}

// String returns the string representation
func (s CurrentRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentRevision) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CurrentRevision) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CurrentRevision"}
	if s.ChangeIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeIdentifier"))
	}
	if s.ChangeIdentifier != nil && len(*s.ChangeIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeIdentifier", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}
	if s.Revision != nil && len(*s.Revision) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Revision", 1))
	}
	if s.RevisionSummary != nil && len(*s.RevisionSummary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionSummary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeIdentifier sets the ChangeIdentifier field's value.
func (s *CurrentRevision) SetChangeIdentifier(v string) *CurrentRevision {
	s.ChangeIdentifier = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *CurrentRevision) SetCreated(v time.Time) *CurrentRevision {
	s.Created = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CurrentRevision) SetRevision(v string) *CurrentRevision {
	s.Revision = &v
	return s
}

// SetRevisionSummary sets the RevisionSummary field's value.
func (s *CurrentRevision) SetRevisionSummary(v string) *CurrentRevision {
	s.RevisionSummary = &v
	return s
}

// Represents the input of a DeleteCustomActionType operation. The custom action
// will be marked as deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionTypeInput
type DeleteCustomActionTypeInput struct {
	_ struct{} `type:"structure"`

	// The category of the custom action that you want to delete, such as source
	// or deploy.
	//
	// Category is a required field
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The provider of the service used in the custom action, such as AWS CodeDeploy.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// The version of the custom action to delete.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomActionTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomActionTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomActionTypeInput"}
	if s.Category == nil {
		invalidParams.Add(request.NewErrParamRequired("Category"))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Provider != nil && len(*s.Provider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Provider", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategory sets the Category field's value.
func (s *DeleteCustomActionTypeInput) SetCategory(v string) *DeleteCustomActionTypeInput {
	s.Category = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *DeleteCustomActionTypeInput) SetProvider(v string) *DeleteCustomActionTypeInput {
	s.Provider = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteCustomActionTypeInput) SetVersion(v string) *DeleteCustomActionTypeInput {
	s.Version = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeleteCustomActionTypeOutput
type DeleteCustomActionTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomActionTypeOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeletePipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipelineInput
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to be deleted.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletePipelineInput) SetName(v string) *DeletePipelineInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DeletePipelineOutput
type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

// Represents the input of a DisableStageTransition action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransitionInput
type DisableStageTransitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline in which you want to disable the flow of artifacts
	// from one stage to another.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The reason given to the user why a stage is disabled, such as waiting for
	// manual approval or manual tests. This message is displayed in the pipeline
	// console UI.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to disable the inbound or outbound transition
	// of artifacts.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts will be prevented from transitioning into the
	// stage and being processed by the actions in that stage (inbound), or prevented
	// from transitioning from the stage after they have been processed by the actions
	// in that stage (outbound).
	//
	// TransitionType is a required field
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`
}

// String returns the string representation
func (s DisableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableStageTransitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableStageTransitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableStageTransitionInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.Reason != nil && len(*s.Reason) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Reason", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.TransitionType == nil {
		invalidParams.Add(request.NewErrParamRequired("TransitionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *DisableStageTransitionInput) SetPipelineName(v string) *DisableStageTransitionInput {
	s.PipelineName = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisableStageTransitionInput) SetReason(v string) *DisableStageTransitionInput {
	s.Reason = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DisableStageTransitionInput) SetStageName(v string) *DisableStageTransitionInput {
	s.StageName = &v
	return s
}

// SetTransitionType sets the TransitionType field's value.
func (s *DisableStageTransitionInput) SetTransitionType(v string) *DisableStageTransitionInput {
	s.TransitionType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/DisableStageTransitionOutput
type DisableStageTransitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableStageTransitionOutput) GoString() string {
	return s.String()
}

// Represents the input of an EnableStageTransition action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransitionInput
type EnableStageTransitionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline in which you want to enable the flow of artifacts
	// from one stage to another.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to enable the transition of artifacts,
	// either into the stage (inbound) or from that stage to the next stage (outbound).
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts will be allowed to enter the stage and be processed
	// by the actions in that stage (inbound) or whether already-processed artifacts
	// will be allowed to transition to the next stage (outbound).
	//
	// TransitionType is a required field
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`
}

// String returns the string representation
func (s EnableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableStageTransitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableStageTransitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableStageTransitionInput"}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.TransitionType == nil {
		invalidParams.Add(request.NewErrParamRequired("TransitionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineName sets the PipelineName field's value.
func (s *EnableStageTransitionInput) SetPipelineName(v string) *EnableStageTransitionInput {
	s.PipelineName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *EnableStageTransitionInput) SetStageName(v string) *EnableStageTransitionInput {
	s.StageName = &v
	return s
}

// SetTransitionType sets the TransitionType field's value.
func (s *EnableStageTransitionInput) SetTransitionType(v string) *EnableStageTransitionInput {
	s.TransitionType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EnableStageTransitionOutput
type EnableStageTransitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableStageTransitionOutput) GoString() string {
	return s.String()
}

// Represents information about the key used to encrypt data in the artifact
// store, such as an AWS Key Management Service (AWS KMS) key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/EncryptionKey
type EncryptionKey struct {
	_ struct{} `type:"structure"`

	// The ID used to identify the key. For an AWS KMS key, this is the key ID or
	// key ARN.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The type of encryption key, such as an AWS Key Management Service (AWS KMS)
	// key. When creating or updating a pipeline, the value must be set to 'KMS'.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EncryptionKeyType"`
}

// String returns the string representation
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionKey"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *EncryptionKey) SetId(v string) *EncryptionKey {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionKey) SetType(v string) *EncryptionKey {
	s.Type = &v
	return s
}

// Represents information about an error in AWS CodePipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ErrorDetails
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The system ID or error number code of the error.
	Code *string `locationName:"code" type:"string"`

	// The text of the error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetails) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorDetails) SetCode(v string) *ErrorDetails {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorDetails) SetMessage(v string) *ErrorDetails {
	s.Message = &v
	return s
}

// The details of the actions taken and results produced on an artifact as it
// passes through stages in the pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ExecutionDetails
type ExecutionDetails struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID of this action used to identify this job worker
	// in any external systems, such as AWS CodeDeploy.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The percentage of work completed on the action, represented on a scale of
	// zero to one hundred percent.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The summary of the current status of the actions.
	Summary *string `locationName:"summary" type:"string"`
}

// String returns the string representation
func (s ExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalExecutionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *ExecutionDetails) SetExternalExecutionId(v string) *ExecutionDetails {
	s.ExternalExecutionId = &v
	return s
}

// SetPercentComplete sets the PercentComplete field's value.
func (s *ExecutionDetails) SetPercentComplete(v int64) *ExecutionDetails {
	s.PercentComplete = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *ExecutionDetails) SetSummary(v string) *ExecutionDetails {
	s.Summary = &v
	return s
}

// Represents information about failure details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/FailureDetails
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The external ID of the run of the action that failed.
	ExternalExecutionId *string `locationName:"externalExecutionId" min:"1" type:"string"`

	// The message about the failure.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The type of the failure.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FailureType"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailureDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailureDetails"}
	if s.ExternalExecutionId != nil && len(*s.ExternalExecutionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalExecutionId", 1))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalExecutionId sets the ExternalExecutionId field's value.
func (s *FailureDetails) SetExternalExecutionId(v string) *FailureDetails {
	s.ExternalExecutionId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *FailureDetails) SetMessage(v string) *FailureDetails {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *FailureDetails) SetType(v string) *FailureDetails {
	s.Type = &v
	return s
}

// Represents the input of a GetJobDetails action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetailsInput
type GetJobDetailsInput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobDetailsInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobDetailsInput) SetJobId(v string) *GetJobDetailsInput {
	s.JobId = &v
	return s
}

// Represents the output of a GetJobDetails action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetJobDetailsOutput
type GetJobDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the job.
	//
	// If AWSSessionCredentials is used, a long-running job can call GetJobDetails
	// again to obtain new credentials.
	JobDetails *JobDetails `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation
func (s GetJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDetailsOutput) GoString() string {
	return s.String()
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetJobDetailsOutput) SetJobDetails(v *JobDetails) *GetJobDetailsOutput {
	s.JobDetails = v
	return s
}

// Represents the input of a GetPipelineExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecutionInput
type GetPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution about which you want to get execution details.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline about which you want to get execution details.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineExecutionInput"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *GetPipelineExecutionInput) SetPipelineExecutionId(v string) *GetPipelineExecutionInput {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineExecutionInput) SetPipelineName(v string) *GetPipelineExecutionInput {
	s.PipelineName = &v
	return s
}

// Represents the output of a GetPipelineExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineExecutionOutput
type GetPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// Represents information about the execution of a pipeline.
	PipelineExecution *PipelineExecution `locationName:"pipelineExecution" type:"structure"`
}

// String returns the string representation
func (s GetPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecution sets the PipelineExecution field's value.
func (s *GetPipelineExecutionOutput) SetPipelineExecution(v *PipelineExecution) *GetPipelineExecutionOutput {
	s.PipelineExecution = v
	return s
}

// Represents the input of a GetPipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineInput
type GetPipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline for which you want to get information. Pipeline
	// names must be unique under an Amazon Web Services (AWS) user account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version number of the pipeline. If you do not specify a version, defaults
	// to the most current version.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation
func (s GetPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPipelineInput) SetName(v string) *GetPipelineInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetPipelineInput) SetVersion(v int64) *GetPipelineInput {
	s.Version = &v
	return s
}

// Represents the output of a GetPipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineOutput
type GetPipelineOutput struct {
	_ struct{} `type:"structure"`

	// Represents the pipeline metadata information returned as part of the output
	// of a GetPipeline action.
	Metadata *PipelineMetadata `locationName:"metadata" type:"structure"`

	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`
}

// String returns the string representation
func (s GetPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetPipelineOutput) SetMetadata(v *PipelineMetadata) *GetPipelineOutput {
	s.Metadata = v
	return s
}

// SetPipeline sets the Pipeline field's value.
func (s *GetPipelineOutput) SetPipeline(v *PipelineDeclaration) *GetPipelineOutput {
	s.Pipeline = v
	return s
}

// Represents the input of a GetPipelineState action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineStateInput
type GetPipelineStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline about which you want to get information.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPipelineStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPipelineStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPipelineStateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetPipelineStateInput) SetName(v string) *GetPipelineStateInput {
	s.Name = &v
	return s
}

// Represents the output of a GetPipelineState action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetPipelineStateOutput
type GetPipelineStateOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The name of the pipeline for which you want to get the state.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline.
	//
	// A newly-created pipeline is always assigned a version number of 1.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// A list of the pipeline stage output information, including stage name, state,
	// most recent run details, whether the stage is disabled, and other data.
	StageStates []*StageState `locationName:"stageStates" type:"list"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GetPipelineStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineStateOutput) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *GetPipelineStateOutput) SetCreated(v time.Time) *GetPipelineStateOutput {
	s.Created = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *GetPipelineStateOutput) SetPipelineName(v string) *GetPipelineStateOutput {
	s.PipelineName = &v
	return s
}

// SetPipelineVersion sets the PipelineVersion field's value.
func (s *GetPipelineStateOutput) SetPipelineVersion(v int64) *GetPipelineStateOutput {
	s.PipelineVersion = &v
	return s
}

// SetStageStates sets the StageStates field's value.
func (s *GetPipelineStateOutput) SetStageStates(v []*StageState) *GetPipelineStateOutput {
	s.StageStates = v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *GetPipelineStateOutput) SetUpdated(v time.Time) *GetPipelineStateOutput {
	s.Updated = &v
	return s
}

// Represents the input of a GetThirdPartyJobDetails action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetailsInput
type GetThirdPartyJobDetailsInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// The unique system-generated ID used for identifying the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetThirdPartyJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThirdPartyJobDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThirdPartyJobDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThirdPartyJobDetailsInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *GetThirdPartyJobDetailsInput) SetClientToken(v string) *GetThirdPartyJobDetailsInput {
	s.ClientToken = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetThirdPartyJobDetailsInput) SetJobId(v string) *GetThirdPartyJobDetailsInput {
	s.JobId = &v
	return s
}

// Represents the output of a GetThirdPartyJobDetails action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/GetThirdPartyJobDetailsOutput
type GetThirdPartyJobDetailsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the job, including any protected values defined for the job.
	JobDetails *ThirdPartyJobDetails `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation
func (s GetThirdPartyJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThirdPartyJobDetailsOutput) GoString() string {
	return s.String()
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetThirdPartyJobDetailsOutput) SetJobDetails(v *ThirdPartyJobDetails) *GetThirdPartyJobDetailsOutput {
	s.JobDetails = v
	return s
}

// Represents information about an artifact to be worked on, such as a test
// or build artifact.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/InputArtifact
type InputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the artifact to be worked on, for example, "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputArtifact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputArtifact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputArtifact"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *InputArtifact) SetName(v string) *InputArtifact {
	s.Name = &v
	return s
}

// Represents information about a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/Job
type Job struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account to use when performing the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Additional data about a job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Use this number in an
	// AcknowledgeJob request.
	Nonce *string `locationName:"nonce" type:"string"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Job) SetAccountId(v string) *Job {
	s.AccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *Job) SetData(v *JobData) *Job {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *Job) SetId(v string) *Job {
	s.Id = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *Job) SetNonce(v string) *Job {
	s.Nonce = &v
	return s
}

// Represents additional information about a job required for a job worker to
// complete the job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/JobData
type JobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the Amazon S3 bucket used to
	// store artifact for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job requires in order to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// Represents information about the key used to encrypt data in the artifact
	// store, such as an AWS Key Management Service (AWS KMS) key.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The artifact supplied to the job.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The output of the job.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation
func (s JobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobData) GoString() string {
	return s.String()
}

// SetActionConfiguration sets the ActionConfiguration field's value.
func (s *JobData) SetActionConfiguration(v *ActionConfiguration) *JobData {
	s.ActionConfiguration = v
	return s
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *JobData) SetActionTypeId(v *ActionTypeId) *JobData {
	s.ActionTypeId = v
	return s
}

// SetArtifactCredentials sets the ArtifactCredentials field's value.
func (s *JobData) SetArtifactCredentials(v *AWSSessionCredentials) *JobData {
	s.ArtifactCredentials = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *JobData) SetContinuationToken(v string) *JobData {
	s.ContinuationToken = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *JobData) SetEncryptionKey(v *EncryptionKey) *JobData {
	s.EncryptionKey = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *JobData) SetInputArtifacts(v []*Artifact) *JobData {
	s.InputArtifacts = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *JobData) SetOutputArtifacts(v []*Artifact) *JobData {
	s.OutputArtifacts = v
	return s
}

// SetPipelineContext sets the PipelineContext field's value.
func (s *JobData) SetPipelineContext(v *PipelineContext) *JobData {
	s.PipelineContext = v
	return s
}

// Represents information about the details of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/JobDetails
type JobDetails struct {
	_ struct{} `type:"structure"`

	// The AWS account ID associated with the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Represents additional information about a job required for a job worker to
	// complete the job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDetails) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *JobDetails) SetAccountId(v string) *JobDetails {
	s.AccountId = &v
	return s
}

// SetData sets the Data field's value.
func (s *JobDetails) SetData(v *JobData) *JobDetails {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *JobDetails) SetId(v string) *JobDetails {
	s.Id = &v
	return s
}

// Represents the input of a ListActionTypes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypesInput
type ListActionTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of action types to those created by a specified entity.
	ActionOwnerFilter *string `locationName:"actionOwnerFilter" type:"string" enum:"ActionOwner"`

	// An identifier that was returned from the previous list action types call,
	// which can be used to return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActionTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActionTypesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionOwnerFilter sets the ActionOwnerFilter field's value.
func (s *ListActionTypesInput) SetActionOwnerFilter(v string) *ListActionTypesInput {
	s.ActionOwnerFilter = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionTypesInput) SetNextToken(v string) *ListActionTypesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListActionTypes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListActionTypesOutput
type ListActionTypesOutput struct {
	_ struct{} `type:"structure"`

	// Provides details of the action types.
	//
	// ActionTypes is a required field
	ActionTypes []*ActionType `locationName:"actionTypes" type:"list" required:"true"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned which can be used in a subsequent list action types call
	// to return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListActionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionTypesOutput) GoString() string {
	return s.String()
}

// SetActionTypes sets the ActionTypes field's value.
func (s *ListActionTypesOutput) SetActionTypes(v []*ActionType) *ListActionTypesOutput {
	s.ActionTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListActionTypesOutput) SetNextToken(v string) *ListActionTypesOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListPipelineExecutions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutionsInput
type ListPipelineExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. The
	// available pipeline execution history is limited to the most recent 12 months,
	// based on pipeline execution start times. Default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that was returned from the previous ListPipelineExecutions call,
	// which can be used to return the next set of pipeline executions in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The name of the pipeline for which you want to get execution summary information.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPipelineExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelineExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelineExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelineExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPipelineExecutionsInput) SetMaxResults(v int64) *ListPipelineExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelineExecutionsInput) SetNextToken(v string) *ListPipelineExecutionsInput {
	s.NextToken = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *ListPipelineExecutionsInput) SetPipelineName(v string) *ListPipelineExecutionsInput {
	s.PipelineName = &v
	return s
}

// Represents the output of a ListPipelineExecutions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelineExecutionsOutput
type ListPipelineExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that can be used in the next ListPipelineExecutions call. To view
	// all items in the list, continue to call this operation with each subsequent
	// token until no more nextToken values are returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of executions in the history of a pipeline.
	PipelineExecutionSummaries []*PipelineExecutionSummary `locationName:"pipelineExecutionSummaries" type:"list"`
}

// String returns the string representation
func (s ListPipelineExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelineExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelineExecutionsOutput) SetNextToken(v string) *ListPipelineExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetPipelineExecutionSummaries sets the PipelineExecutionSummaries field's value.
func (s *ListPipelineExecutionsOutput) SetPipelineExecutionSummaries(v []*PipelineExecutionSummary) *ListPipelineExecutionsOutput {
	s.PipelineExecutionSummaries = v
	return s
}

// Represents the input of a ListPipelines action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelinesInput
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous list pipelines call, which
	// can be used to return the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipelinesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesInput) SetNextToken(v string) *ListPipelinesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListPipelines action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListPipelinesOutput
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned which can be used in a subsequent list pipelines call to
	// return the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The list of pipelines.
	Pipelines []*PipelineSummary `locationName:"pipelines" type:"list"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipelinesOutput) SetNextToken(v string) *ListPipelinesOutput {
	s.NextToken = &v
	return s
}

// SetPipelines sets the Pipelines field's value.
func (s *ListPipelinesOutput) SetPipelines(v []*PipelineSummary) *ListPipelinesOutput {
	s.Pipelines = v
	return s
}

// Represents information about the output of an action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/OutputArtifact
type OutputArtifact struct {
	_ struct{} `type:"structure"`

	// The name of the output of an artifact, such as "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Output artifact names must be unique within a pipeline.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputArtifact) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputArtifact) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputArtifact"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *OutputArtifact) SetName(v string) *OutputArtifact {
	s.Name = &v
	return s
}

// Represents information about a pipeline to a job worker.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineContext
type PipelineContext struct {
	_ struct{} `type:"structure"`

	// The context of an action to a job worker within the stage of a pipeline.
	Action *ActionContext `locationName:"action" type:"structure"`

	// The name of the pipeline. This is a user-specified value. Pipeline names
	// must be unique across all pipeline names under an Amazon Web Services account.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The stage of the pipeline.
	Stage *StageContext `locationName:"stage" type:"structure"`
}

// String returns the string representation
func (s PipelineContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineContext) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PipelineContext) SetAction(v *ActionContext) *PipelineContext {
	s.Action = v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineContext) SetPipelineName(v string) *PipelineContext {
	s.PipelineName = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *PipelineContext) SetStage(v *StageContext) *PipelineContext {
	s.Stage = v
	return s
}

// Represents the structure of actions and stages to be performed in the pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineDeclaration
type PipelineDeclaration struct {
	_ struct{} `type:"structure"`

	// Represents information about the Amazon S3 bucket where artifacts are stored
	// for the pipeline.
	//
	// ArtifactStore is a required field
	ArtifactStore *ArtifactStore `locationName:"artifactStore" type:"structure" required:"true"`

	// The name of the action to be performed.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform
	// actions with no actionRoleArn, or to use to assume roles for actions with
	// an actionRoleArn.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The stage in which to perform the action.
	//
	// Stages is a required field
	Stages []*StageDeclaration `locationName:"stages" type:"list" required:"true"`

	// The version number of the pipeline. A new pipeline always has a version number
	// of 1. This number is automatically incremented when a pipeline is updated.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation
func (s PipelineDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineDeclaration"}
	if s.ArtifactStore == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactStore"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Stages == nil {
		invalidParams.Add(request.NewErrParamRequired("Stages"))
	}
	if s.Version != nil && *s.Version < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Version", 1))
	}
	if s.ArtifactStore != nil {
		if err := s.ArtifactStore.Validate(); err != nil {
			invalidParams.AddNested("ArtifactStore", err.(request.ErrInvalidParams))
		}
	}
	if s.Stages != nil {
		for i, v := range s.Stages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Stages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactStore sets the ArtifactStore field's value.
func (s *PipelineDeclaration) SetArtifactStore(v *ArtifactStore) *PipelineDeclaration {
	s.ArtifactStore = v
	return s
}

// SetName sets the Name field's value.
func (s *PipelineDeclaration) SetName(v string) *PipelineDeclaration {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PipelineDeclaration) SetRoleArn(v string) *PipelineDeclaration {
	s.RoleArn = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *PipelineDeclaration) SetStages(v []*StageDeclaration) *PipelineDeclaration {
	s.Stages = v
	return s
}

// SetVersion sets the Version field's value.
func (s *PipelineDeclaration) SetVersion(v int64) *PipelineDeclaration {
	s.Version = &v
	return s
}

// Represents information about an execution of a pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineExecution
type PipelineExecution struct {
	_ struct{} `type:"structure"`

	// A list of ArtifactRevision objects included in a pipeline execution.
	ArtifactRevisions []*ArtifactRevision `locationName:"artifactRevisions" type:"list"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The name of the pipeline that was executed.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline that was executed.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// The status of the pipeline execution.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead.
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status *string `locationName:"status" type:"string" enum:"PipelineExecutionStatus"`
}

// String returns the string representation
func (s PipelineExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineExecution) GoString() string {
	return s.String()
}

// SetArtifactRevisions sets the ArtifactRevisions field's value.
func (s *PipelineExecution) SetArtifactRevisions(v []*ArtifactRevision) *PipelineExecution {
	s.ArtifactRevisions = v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PipelineExecution) SetPipelineExecutionId(v string) *PipelineExecution {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PipelineExecution) SetPipelineName(v string) *PipelineExecution {
	s.PipelineName = &v
	return s
}

// SetPipelineVersion sets the PipelineVersion field's value.
func (s *PipelineExecution) SetPipelineVersion(v int64) *PipelineExecution {
	s.PipelineVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PipelineExecution) SetStatus(v string) *PipelineExecution {
	s.Status = &v
	return s
}

// Summary information about a pipeline execution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineExecutionSummary
type PipelineExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time of the last change to the pipeline execution, in timestamp
	// format.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"unix"`

	// The ID of the pipeline execution.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	// The date and time when the pipeline execution began, in timestamp format.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The status of the pipeline execution.
	//
	//    * InProgress: The pipeline execution is currently running.
	//
	//    * Succeeded: The pipeline execution was completed successfully.
	//
	//    * Superseded: While this pipeline execution was waiting for the next stage
	//    to be completed, a newer pipeline execution advanced and continued through
	//    the pipeline instead.
	//
	//    * Failed: The pipeline execution was not completed successfully.
	Status *string `locationName:"status" type:"string" enum:"PipelineExecutionStatus"`
}

// String returns the string representation
func (s PipelineExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineExecutionSummary) GoString() string {
	return s.String()
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *PipelineExecutionSummary) SetLastUpdateTime(v time.Time) *PipelineExecutionSummary {
	s.LastUpdateTime = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PipelineExecutionSummary) SetPipelineExecutionId(v string) *PipelineExecutionSummary {
	s.PipelineExecutionId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PipelineExecutionSummary) SetStartTime(v time.Time) *PipelineExecutionSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PipelineExecutionSummary) SetStatus(v string) *PipelineExecutionSummary {
	s.Status = &v
	return s
}

// Information about a pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineMetadata
type PipelineMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string `locationName:"pipelineArn" type:"string"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PipelineMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineMetadata) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *PipelineMetadata) SetCreated(v time.Time) *PipelineMetadata {
	s.Created = &v
	return s
}

// SetPipelineArn sets the PipelineArn field's value.
func (s *PipelineMetadata) SetPipelineArn(v string) *PipelineMetadata {
	s.PipelineArn = &v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *PipelineMetadata) SetUpdated(v time.Time) *PipelineMetadata {
	s.Updated = &v
	return s
}

// Returns a summary of a pipeline.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PipelineSummary
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The date and time of the last update to the pipeline, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp" timestampFormat:"unix"`

	// The version number of the pipeline.
	Version *int64 `locationName:"version" min:"1" type:"integer"`
}

// String returns the string representation
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineSummary) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *PipelineSummary) SetCreated(v time.Time) *PipelineSummary {
	s.Created = &v
	return s
}

// SetName sets the Name field's value.
func (s *PipelineSummary) SetName(v string) *PipelineSummary {
	s.Name = &v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *PipelineSummary) SetUpdated(v time.Time) *PipelineSummary {
	s.Updated = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PipelineSummary) SetVersion(v int64) *PipelineSummary {
	s.Version = &v
	return s
}

// Represents the input of a PollForJobs action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobsInput
type PollForJobsInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with
	// a queryable property, you must supply that property as a key in the map.
	// Only jobs whose action configuration matches the mapped value will be returned.
	QueryParam map[string]*string `locationName:"queryParam" type:"map"`
}

// String returns the string representation
func (s PollForJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForJobsInput"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.MaxBatchSize != nil && *s.MaxBatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBatchSize", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *PollForJobsInput) SetActionTypeId(v *ActionTypeId) *PollForJobsInput {
	s.ActionTypeId = v
	return s
}

// SetMaxBatchSize sets the MaxBatchSize field's value.
func (s *PollForJobsInput) SetMaxBatchSize(v int64) *PollForJobsInput {
	s.MaxBatchSize = &v
	return s
}

// SetQueryParam sets the QueryParam field's value.
func (s *PollForJobsInput) SetQueryParam(v map[string]*string) *PollForJobsInput {
	s.QueryParam = v
	return s
}

// Represents the output of a PollForJobs action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForJobsOutput
type PollForJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs to take action on.
	Jobs []*Job `locationName:"jobs" type:"list"`
}

// String returns the string representation
func (s PollForJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *PollForJobsOutput) SetJobs(v []*Job) *PollForJobsOutput {
	s.Jobs = v
	return s
}

// Represents the input of a PollForThirdPartyJobs action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobsInput
type PollForThirdPartyJobsInput struct {
	_ struct{} `type:"structure"`

	// Represents information about an action type.
	//
	// ActionTypeId is a required field
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s PollForThirdPartyJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForThirdPartyJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForThirdPartyJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForThirdPartyJobsInput"}
	if s.ActionTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionTypeId"))
	}
	if s.MaxBatchSize != nil && *s.MaxBatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxBatchSize", 1))
	}
	if s.ActionTypeId != nil {
		if err := s.ActionTypeId.Validate(); err != nil {
			invalidParams.AddNested("ActionTypeId", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *PollForThirdPartyJobsInput) SetActionTypeId(v *ActionTypeId) *PollForThirdPartyJobsInput {
	s.ActionTypeId = v
	return s
}

// SetMaxBatchSize sets the MaxBatchSize field's value.
func (s *PollForThirdPartyJobsInput) SetMaxBatchSize(v int64) *PollForThirdPartyJobsInput {
	s.MaxBatchSize = &v
	return s
}

// Represents the output of a PollForThirdPartyJobs action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PollForThirdPartyJobsOutput
type PollForThirdPartyJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs to take action on.
	Jobs []*ThirdPartyJob `locationName:"jobs" type:"list"`
}

// String returns the string representation
func (s PollForThirdPartyJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForThirdPartyJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *PollForThirdPartyJobsOutput) SetJobs(v []*ThirdPartyJob) *PollForThirdPartyJobsOutput {
	s.Jobs = v
	return s
}

// Represents the input of a PutActionRevision action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevisionInput
type PutActionRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of the action that will process the revision.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// Represents information about the version (or revision) of an action.
	//
	// ActionRevision is a required field
	ActionRevision *ActionRevision `locationName:"actionRevision" type:"structure" required:"true"`

	// The name of the pipeline that will start processing the revision to the source.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage that contains the action that will act upon the revision.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutActionRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutActionRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutActionRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutActionRevisionInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.ActionRevision == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionRevision"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.ActionRevision != nil {
		if err := s.ActionRevision.Validate(); err != nil {
			invalidParams.AddNested("ActionRevision", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *PutActionRevisionInput) SetActionName(v string) *PutActionRevisionInput {
	s.ActionName = &v
	return s
}

// SetActionRevision sets the ActionRevision field's value.
func (s *PutActionRevisionInput) SetActionRevision(v *ActionRevision) *PutActionRevisionInput {
	s.ActionRevision = v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PutActionRevisionInput) SetPipelineName(v string) *PutActionRevisionInput {
	s.PipelineName = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *PutActionRevisionInput) SetStageName(v string) *PutActionRevisionInput {
	s.StageName = &v
	return s
}

// Represents the output of a PutActionRevision action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutActionRevisionOutput
type PutActionRevisionOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the artifact revision was previously used in an execution
	// of the specified pipeline.
	NewRevision *bool `locationName:"newRevision" type:"boolean"`

	// The ID of the current workflow state of the pipeline.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s PutActionRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutActionRevisionOutput) GoString() string {
	return s.String()
}

// SetNewRevision sets the NewRevision field's value.
func (s *PutActionRevisionOutput) SetNewRevision(v bool) *PutActionRevisionOutput {
	s.NewRevision = &v
	return s
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *PutActionRevisionOutput) SetPipelineExecutionId(v string) *PutActionRevisionOutput {
	s.PipelineExecutionId = &v
	return s
}

// Represents the input of a PutApprovalResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResultInput
type PutApprovalResultInput struct {
	_ struct{} `type:"structure"`

	// The name of the action for which approval is requested.
	//
	// ActionName is a required field
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// The name of the pipeline that contains the action.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// Represents information about the result of the approval request.
	//
	// Result is a required field
	Result *ApprovalResult `locationName:"result" type:"structure" required:"true"`

	// The name of the stage that contains the action.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// The system-generated token used to identify a unique approval request. The
	// token for each open approval request can be obtained using the GetPipelineState
	// action and is used to validate that the approval request corresponding to
	// this token is still valid.
	//
	// Token is a required field
	Token *string `locationName:"token" type:"string" required:"true"`
}

// String returns the string representation
func (s PutApprovalResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutApprovalResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApprovalResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApprovalResultInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionName", 1))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.Result == nil {
		invalidParams.Add(request.NewErrParamRequired("Result"))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.Result != nil {
		if err := s.Result.Validate(); err != nil {
			invalidParams.AddNested("Result", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *PutApprovalResultInput) SetActionName(v string) *PutApprovalResultInput {
	s.ActionName = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *PutApprovalResultInput) SetPipelineName(v string) *PutApprovalResultInput {
	s.PipelineName = &v
	return s
}

// SetResult sets the Result field's value.
func (s *PutApprovalResultInput) SetResult(v *ApprovalResult) *PutApprovalResultInput {
	s.Result = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *PutApprovalResultInput) SetStageName(v string) *PutApprovalResultInput {
	s.StageName = &v
	return s
}

// SetToken sets the Token field's value.
func (s *PutApprovalResultInput) SetToken(v string) *PutApprovalResultInput {
	s.Token = &v
	return s
}

// Represents the output of a PutApprovalResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutApprovalResultOutput
type PutApprovalResultOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp showing when the approval or rejection was submitted.
	ApprovedAt *time.Time `locationName:"approvedAt" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PutApprovalResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutApprovalResultOutput) GoString() string {
	return s.String()
}

// SetApprovedAt sets the ApprovedAt field's value.
func (s *PutApprovalResultOutput) SetApprovedAt(v time.Time) *PutApprovalResultOutput {
	s.ApprovedAt = &v
	return s
}

// Represents the input of a PutJobFailureResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResultInput
type PutJobFailureResultInput struct {
	_ struct{} `type:"structure"`

	// The details about the failure of a job.
	//
	// FailureDetails is a required field
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The unique system-generated ID of the job that failed. This is the same ID
	// returned from PollForJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobFailureResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobFailureResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobFailureResultInput"}
	if s.FailureDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureDetails"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.FailureDetails != nil {
		if err := s.FailureDetails.Validate(); err != nil {
			invalidParams.AddNested("FailureDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *PutJobFailureResultInput) SetFailureDetails(v *FailureDetails) *PutJobFailureResultInput {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobFailureResultInput) SetJobId(v string) *PutJobFailureResultInput {
	s.JobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobFailureResultOutput
type PutJobFailureResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutJobSuccessResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResultInput
type PutJobSuccessResultInput struct {
	_ struct{} `type:"structure"`

	// A token generated by a job worker, such as an AWS CodeDeploy deployment ID,
	// that a successful job provides to identify a custom action in progress. Future
	// jobs will use this token in order to identify the running instance of the
	// action. It can be reused to return additional information about the progress
	// of the custom action. When the action is complete, no continuation token
	// should be supplied.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// The ID of the current revision of the artifact successfully worked upon by
	// the job.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The execution details of the successful job, such as the actions taken by
	// the job worker.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The unique system-generated ID of the job that succeeded. This is the same
	// ID returned from PollForJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobSuccessResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutJobSuccessResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutJobSuccessResultInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.CurrentRevision != nil {
		if err := s.CurrentRevision.Validate(); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionDetails != nil {
		if err := s.ExecutionDetails.Validate(); err != nil {
			invalidParams.AddNested("ExecutionDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *PutJobSuccessResultInput) SetContinuationToken(v string) *PutJobSuccessResultInput {
	s.ContinuationToken = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *PutJobSuccessResultInput) SetCurrentRevision(v *CurrentRevision) *PutJobSuccessResultInput {
	s.CurrentRevision = v
	return s
}

// SetExecutionDetails sets the ExecutionDetails field's value.
func (s *PutJobSuccessResultInput) SetExecutionDetails(v *ExecutionDetails) *PutJobSuccessResultInput {
	s.ExecutionDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutJobSuccessResultInput) SetJobId(v string) *PutJobSuccessResultInput {
	s.JobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutJobSuccessResultOutput
type PutJobSuccessResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobSuccessResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutThirdPartyJobFailureResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResultInput
type PutThirdPartyJobFailureResultInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// Represents information about failure details.
	//
	// FailureDetails is a required field
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The ID of the job that failed. This is the same ID returned from PollForThirdPartyJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutThirdPartyJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobFailureResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutThirdPartyJobFailureResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutThirdPartyJobFailureResultInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FailureDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("FailureDetails"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.FailureDetails != nil {
		if err := s.FailureDetails.Validate(); err != nil {
			invalidParams.AddNested("FailureDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutThirdPartyJobFailureResultInput) SetClientToken(v string) *PutThirdPartyJobFailureResultInput {
	s.ClientToken = &v
	return s
}

// SetFailureDetails sets the FailureDetails field's value.
func (s *PutThirdPartyJobFailureResultInput) SetFailureDetails(v *FailureDetails) *PutThirdPartyJobFailureResultInput {
	s.FailureDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutThirdPartyJobFailureResultInput) SetJobId(v string) *PutThirdPartyJobFailureResultInput {
	s.JobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobFailureResultOutput
type PutThirdPartyJobFailureResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a PutThirdPartyJobSuccessResult action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResultInput
type PutThirdPartyJobSuccessResultInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// A token generated by a job worker, such as an AWS CodeDeploy deployment ID,
	// that a successful job provides to identify a partner action in progress.
	// Future jobs will use this token in order to identify the running instance
	// of the action. It can be reused to return additional information about the
	// progress of the partner action. When the action is complete, no continuation
	// token should be supplied.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// Represents information about a current revision.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The details of the actions taken and results produced on an artifact as it
	// passes through stages in the pipeline.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The ID of the job that successfully completed. This is the same ID returned
	// from PollForThirdPartyJobs.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutThirdPartyJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobSuccessResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutThirdPartyJobSuccessResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutThirdPartyJobSuccessResultInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.CurrentRevision != nil {
		if err := s.CurrentRevision.Validate(); err != nil {
			invalidParams.AddNested("CurrentRevision", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionDetails != nil {
		if err := s.ExecutionDetails.Validate(); err != nil {
			invalidParams.AddNested("ExecutionDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetClientToken(v string) *PutThirdPartyJobSuccessResultInput {
	s.ClientToken = &v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetContinuationToken(v string) *PutThirdPartyJobSuccessResultInput {
	s.ContinuationToken = &v
	return s
}

// SetCurrentRevision sets the CurrentRevision field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetCurrentRevision(v *CurrentRevision) *PutThirdPartyJobSuccessResultInput {
	s.CurrentRevision = v
	return s
}

// SetExecutionDetails sets the ExecutionDetails field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetExecutionDetails(v *ExecutionDetails) *PutThirdPartyJobSuccessResultInput {
	s.ExecutionDetails = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PutThirdPartyJobSuccessResultInput) SetJobId(v string) *PutThirdPartyJobSuccessResultInput {
	s.JobId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/PutThirdPartyJobSuccessResultOutput
type PutThirdPartyJobSuccessResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobSuccessResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a RetryStageExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecutionInput
type RetryStageExecutionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution in the failed stage to be retried. Use the
	// GetPipelineState action to retrieve the current pipelineExecutionId of the
	// failed stage
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The name of the pipeline that contains the failed stage.
	//
	// PipelineName is a required field
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The scope of the retry attempt. Currently, the only supported value is FAILED_ACTIONS.
	//
	// RetryMode is a required field
	RetryMode *string `locationName:"retryMode" type:"string" required:"true" enum:"StageRetryMode"`

	// The name of the failed stage to be retried.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RetryStageExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetryStageExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetryStageExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetryStageExecutionInput"}
	if s.PipelineExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineExecutionId"))
	}
	if s.PipelineName == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PipelineName", 1))
	}
	if s.RetryMode == nil {
		invalidParams.Add(request.NewErrParamRequired("RetryMode"))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *RetryStageExecutionInput) SetPipelineExecutionId(v string) *RetryStageExecutionInput {
	s.PipelineExecutionId = &v
	return s
}

// SetPipelineName sets the PipelineName field's value.
func (s *RetryStageExecutionInput) SetPipelineName(v string) *RetryStageExecutionInput {
	s.PipelineName = &v
	return s
}

// SetRetryMode sets the RetryMode field's value.
func (s *RetryStageExecutionInput) SetRetryMode(v string) *RetryStageExecutionInput {
	s.RetryMode = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *RetryStageExecutionInput) SetStageName(v string) *RetryStageExecutionInput {
	s.StageName = &v
	return s
}

// Represents the output of a RetryStageExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RetryStageExecutionOutput
type RetryStageExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the current workflow execution in the failed stage.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s RetryStageExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetryStageExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *RetryStageExecutionOutput) SetPipelineExecutionId(v string) *RetryStageExecutionOutput {
	s.PipelineExecutionId = &v
	return s
}

// The location of the Amazon S3 bucket that contains a revision.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/S3ArtifactLocation
type S3ArtifactLocation struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key of the object in the Amazon S3 bucket, which uniquely identifies
	// the object in the bucket.
	//
	// ObjectKey is a required field
	ObjectKey *string `locationName:"objectKey" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ArtifactLocation) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3ArtifactLocation) SetBucketName(v string) *S3ArtifactLocation {
	s.BucketName = &v
	return s
}

// SetObjectKey sets the ObjectKey field's value.
func (s *S3ArtifactLocation) SetObjectKey(v string) *S3ArtifactLocation {
	s.ObjectKey = &v
	return s
}

// Represents information about a stage to a job worker.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StageContext
type StageContext struct {
	_ struct{} `type:"structure"`

	// The name of the stage.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s StageContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageContext) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StageContext) SetName(v string) *StageContext {
	s.Name = &v
	return s
}

// Represents information about a stage and its definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StageDeclaration
type StageDeclaration struct {
	_ struct{} `type:"structure"`

	// The actions included in a stage.
	//
	// Actions is a required field
	Actions []*ActionDeclaration `locationName:"actions" type:"list" required:"true"`

	// Reserved for future use.
	Blockers []*BlockerDeclaration `locationName:"blockers" type:"list"`

	// The name of the stage.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StageDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageDeclaration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StageDeclaration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StageDeclaration"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Blockers != nil {
		for i, v := range s.Blockers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Blockers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *StageDeclaration) SetActions(v []*ActionDeclaration) *StageDeclaration {
	s.Actions = v
	return s
}

// SetBlockers sets the Blockers field's value.
func (s *StageDeclaration) SetBlockers(v []*BlockerDeclaration) *StageDeclaration {
	s.Blockers = v
	return s
}

// SetName sets the Name field's value.
func (s *StageDeclaration) SetName(v string) *StageDeclaration {
	s.Name = &v
	return s
}

// Represents information about the run of a stage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StageExecution
type StageExecution struct {
	_ struct{} `type:"structure"`

	// The ID of the pipeline execution associated with the stage.
	//
	// PipelineExecutionId is a required field
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string" required:"true"`

	// The status of the stage, or for a completed stage, the last status of the
	// stage.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"StageExecutionStatus"`
}

// String returns the string representation
func (s StageExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageExecution) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StageExecution) SetPipelineExecutionId(v string) *StageExecution {
	s.PipelineExecutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StageExecution) SetStatus(v string) *StageExecution {
	s.Status = &v
	return s
}

// Represents information about the state of the stage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StageState
type StageState struct {
	_ struct{} `type:"structure"`

	// The state of the stage.
	ActionStates []*ActionState `locationName:"actionStates" type:"list"`

	// The state of the inbound transition, which is either enabled or disabled.
	InboundTransitionState *TransitionState `locationName:"inboundTransitionState" type:"structure"`

	// Information about the latest execution in the stage, including its ID and
	// status.
	LatestExecution *StageExecution `locationName:"latestExecution" type:"structure"`

	// The name of the stage.
	StageName *string `locationName:"stageName" min:"1" type:"string"`
}

// String returns the string representation
func (s StageState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageState) GoString() string {
	return s.String()
}

// SetActionStates sets the ActionStates field's value.
func (s *StageState) SetActionStates(v []*ActionState) *StageState {
	s.ActionStates = v
	return s
}

// SetInboundTransitionState sets the InboundTransitionState field's value.
func (s *StageState) SetInboundTransitionState(v *TransitionState) *StageState {
	s.InboundTransitionState = v
	return s
}

// SetLatestExecution sets the LatestExecution field's value.
func (s *StageState) SetLatestExecution(v *StageExecution) *StageState {
	s.LatestExecution = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *StageState) SetStageName(v string) *StageState {
	s.StageName = &v
	return s
}

// Represents the input of a StartPipelineExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecutionInput
type StartPipelineExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to start.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipelineExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPipelineExecutionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartPipelineExecutionInput) SetName(v string) *StartPipelineExecutionInput {
	s.Name = &v
	return s
}

// Represents the output of a StartPipelineExecution action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/StartPipelineExecutionOutput
type StartPipelineExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The unique system-generated ID of the pipeline execution that was started.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`
}

// String returns the string representation
func (s StartPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineExecutionOutput) GoString() string {
	return s.String()
}

// SetPipelineExecutionId sets the PipelineExecutionId field's value.
func (s *StartPipelineExecutionOutput) SetPipelineExecutionId(v string) *StartPipelineExecutionOutput {
	s.PipelineExecutionId = &v
	return s
}

// A response to a PollForThirdPartyJobs request returned by AWS CodePipeline
// when there is a job to be worked upon by a partner action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ThirdPartyJob
type ThirdPartyJob struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientId *string `locationName:"clientId" type:"string"`

	// The identifier used to identify the job in AWS CodePipeline.
	JobId *string `locationName:"jobId" type:"string"`
}

// String returns the string representation
func (s ThirdPartyJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJob) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *ThirdPartyJob) SetClientId(v string) *ThirdPartyJob {
	s.ClientId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ThirdPartyJob) SetJobId(v string) *ThirdPartyJob {
	s.JobId = &v
	return s
}

// Represents information about the job data for a partner action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ThirdPartyJobData
type ThirdPartyJobData struct {
	_ struct{} `type:"structure"`

	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the Amazon S3 bucket used to
	// store artifact for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job requires in order to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// The encryption key used to encrypt and decrypt data in the artifact store
	// for the pipeline, such as an AWS Key Management Service (AWS KMS) key. This
	// is optional and might not be present.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The name of the artifact that will be worked upon by the action, if any.
	// This name might be system-generated, such as "MyApp", or might be defined
	// by the user when the action is created. The input artifact name must match
	// the name of an output artifact generated by an action in an earlier action
	// or stage of the pipeline.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The name of the artifact that will be the result of the action, if any. This
	// name might be system-generated, such as "MyBuiltApp", or might be defined
	// by the user when the action is created.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`
}

// String returns the string representation
func (s ThirdPartyJobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJobData) GoString() string {
	return s.String()
}

// SetActionConfiguration sets the ActionConfiguration field's value.
func (s *ThirdPartyJobData) SetActionConfiguration(v *ActionConfiguration) *ThirdPartyJobData {
	s.ActionConfiguration = v
	return s
}

// SetActionTypeId sets the ActionTypeId field's value.
func (s *ThirdPartyJobData) SetActionTypeId(v *ActionTypeId) *ThirdPartyJobData {
	s.ActionTypeId = v
	return s
}

// SetArtifactCredentials sets the ArtifactCredentials field's value.
func (s *ThirdPartyJobData) SetArtifactCredentials(v *AWSSessionCredentials) *ThirdPartyJobData {
	s.ArtifactCredentials = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ThirdPartyJobData) SetContinuationToken(v string) *ThirdPartyJobData {
	s.ContinuationToken = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ThirdPartyJobData) SetEncryptionKey(v *EncryptionKey) *ThirdPartyJobData {
	s.EncryptionKey = v
	return s
}

// SetInputArtifacts sets the InputArtifacts field's value.
func (s *ThirdPartyJobData) SetInputArtifacts(v []*Artifact) *ThirdPartyJobData {
	s.InputArtifacts = v
	return s
}

// SetOutputArtifacts sets the OutputArtifacts field's value.
func (s *ThirdPartyJobData) SetOutputArtifacts(v []*Artifact) *ThirdPartyJobData {
	s.OutputArtifacts = v
	return s
}

// SetPipelineContext sets the PipelineContext field's value.
func (s *ThirdPartyJobData) SetPipelineContext(v *PipelineContext) *ThirdPartyJobData {
	s.PipelineContext = v
	return s
}

// The details of a job sent in response to a GetThirdPartyJobDetails request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ThirdPartyJobDetails
type ThirdPartyJobDetails struct {
	_ struct{} `type:"structure"`

	// The data to be returned by the third party job worker.
	Data *ThirdPartyJobData `locationName:"data" type:"structure"`

	// The identifier used to identify the job details in AWS CodePipeline.
	Id *string `locationName:"id" min:"1" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Use this number in an
	// AcknowledgeThirdPartyJob request.
	Nonce *string `locationName:"nonce" type:"string"`
}

// String returns the string representation
func (s ThirdPartyJobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJobDetails) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ThirdPartyJobDetails) SetData(v *ThirdPartyJobData) *ThirdPartyJobDetails {
	s.Data = v
	return s
}

// SetId sets the Id field's value.
func (s *ThirdPartyJobDetails) SetId(v string) *ThirdPartyJobDetails {
	s.Id = &v
	return s
}

// SetNonce sets the Nonce field's value.
func (s *ThirdPartyJobDetails) SetNonce(v string) *ThirdPartyJobDetails {
	s.Nonce = &v
	return s
}

// Represents information about the state of transitions between one stage and
// another stage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/TransitionState
type TransitionState struct {
	_ struct{} `type:"structure"`

	// The user-specified reason why the transition between two stages of a pipeline
	// was disabled.
	DisabledReason *string `locationName:"disabledReason" min:"1" type:"string"`

	// Whether the transition between stages is enabled (true) or disabled (false).
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The timestamp when the transition state was last changed.
	LastChangedAt *time.Time `locationName:"lastChangedAt" type:"timestamp" timestampFormat:"unix"`

	// The ID of the user who last changed the transition state.
	LastChangedBy *string `locationName:"lastChangedBy" type:"string"`
}

// String returns the string representation
func (s TransitionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransitionState) GoString() string {
	return s.String()
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *TransitionState) SetDisabledReason(v string) *TransitionState {
	s.DisabledReason = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *TransitionState) SetEnabled(v bool) *TransitionState {
	s.Enabled = &v
	return s
}

// SetLastChangedAt sets the LastChangedAt field's value.
func (s *TransitionState) SetLastChangedAt(v time.Time) *TransitionState {
	s.LastChangedAt = &v
	return s
}

// SetLastChangedBy sets the LastChangedBy field's value.
func (s *TransitionState) SetLastChangedBy(v string) *TransitionState {
	s.LastChangedBy = &v
	return s
}

// Represents the input of an UpdatePipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipelineInput
type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to be updated.
	//
	// Pipeline is a required field
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineInput"}
	if s.Pipeline == nil {
		invalidParams.Add(request.NewErrParamRequired("Pipeline"))
	}
	if s.Pipeline != nil {
		if err := s.Pipeline.Validate(); err != nil {
			invalidParams.AddNested("Pipeline", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineInput) SetPipeline(v *PipelineDeclaration) *UpdatePipelineInput {
	s.Pipeline = v
	return s
}

// Represents the output of an UpdatePipeline action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/UpdatePipelineOutput
type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The structure of the updated pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineOutput) SetPipeline(v *PipelineDeclaration) *UpdatePipelineOutput {
	s.Pipeline = v
	return s
}

const (
	// ActionCategorySource is a ActionCategory enum value
	ActionCategorySource = "Source"

	// ActionCategoryBuild is a ActionCategory enum value
	ActionCategoryBuild = "Build"

	// ActionCategoryDeploy is a ActionCategory enum value
	ActionCategoryDeploy = "Deploy"

	// ActionCategoryTest is a ActionCategory enum value
	ActionCategoryTest = "Test"

	// ActionCategoryInvoke is a ActionCategory enum value
	ActionCategoryInvoke = "Invoke"

	// ActionCategoryApproval is a ActionCategory enum value
	ActionCategoryApproval = "Approval"
)

const (
	// ActionConfigurationPropertyTypeString is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeString = "String"

	// ActionConfigurationPropertyTypeNumber is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeNumber = "Number"

	// ActionConfigurationPropertyTypeBoolean is a ActionConfigurationPropertyType enum value
	ActionConfigurationPropertyTypeBoolean = "Boolean"
)

const (
	// ActionExecutionStatusInProgress is a ActionExecutionStatus enum value
	ActionExecutionStatusInProgress = "InProgress"

	// ActionExecutionStatusSucceeded is a ActionExecutionStatus enum value
	ActionExecutionStatusSucceeded = "Succeeded"

	// ActionExecutionStatusFailed is a ActionExecutionStatus enum value
	ActionExecutionStatusFailed = "Failed"
)

const (
	// ActionOwnerAws is a ActionOwner enum value
	ActionOwnerAws = "AWS"

	// ActionOwnerThirdParty is a ActionOwner enum value
	ActionOwnerThirdParty = "ThirdParty"

	// ActionOwnerCustom is a ActionOwner enum value
	ActionOwnerCustom = "Custom"
)

const (
	// ApprovalStatusApproved is a ApprovalStatus enum value
	ApprovalStatusApproved = "Approved"

	// ApprovalStatusRejected is a ApprovalStatus enum value
	ApprovalStatusRejected = "Rejected"
)

const (
	// ArtifactLocationTypeS3 is a ArtifactLocationType enum value
	ArtifactLocationTypeS3 = "S3"
)

const (
	// ArtifactStoreTypeS3 is a ArtifactStoreType enum value
	ArtifactStoreTypeS3 = "S3"
)

const (
	// BlockerTypeSchedule is a BlockerType enum value
	BlockerTypeSchedule = "Schedule"
)

const (
	// EncryptionKeyTypeKms is a EncryptionKeyType enum value
	EncryptionKeyTypeKms = "KMS"
)

const (
	// FailureTypeJobFailed is a FailureType enum value
	FailureTypeJobFailed = "JobFailed"

	// FailureTypeConfigurationError is a FailureType enum value
	FailureTypeConfigurationError = "ConfigurationError"

	// FailureTypePermissionError is a FailureType enum value
	FailureTypePermissionError = "PermissionError"

	// FailureTypeRevisionOutOfSync is a FailureType enum value
	FailureTypeRevisionOutOfSync = "RevisionOutOfSync"

	// FailureTypeRevisionUnavailable is a FailureType enum value
	FailureTypeRevisionUnavailable = "RevisionUnavailable"

	// FailureTypeSystemUnavailable is a FailureType enum value
	FailureTypeSystemUnavailable = "SystemUnavailable"
)

const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "Created"

	// JobStatusQueued is a JobStatus enum value
	JobStatusQueued = "Queued"

	// JobStatusDispatched is a JobStatus enum value
	JobStatusDispatched = "Dispatched"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "InProgress"

	// JobStatusTimedOut is a JobStatus enum value
	JobStatusTimedOut = "TimedOut"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "Succeeded"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "Failed"
)

const (
	// PipelineExecutionStatusInProgress is a PipelineExecutionStatus enum value
	PipelineExecutionStatusInProgress = "InProgress"

	// PipelineExecutionStatusSucceeded is a PipelineExecutionStatus enum value
	PipelineExecutionStatusSucceeded = "Succeeded"

	// PipelineExecutionStatusSuperseded is a PipelineExecutionStatus enum value
	PipelineExecutionStatusSuperseded = "Superseded"

	// PipelineExecutionStatusFailed is a PipelineExecutionStatus enum value
	PipelineExecutionStatusFailed = "Failed"
)

const (
	// StageExecutionStatusInProgress is a StageExecutionStatus enum value
	StageExecutionStatusInProgress = "InProgress"

	// StageExecutionStatusFailed is a StageExecutionStatus enum value
	StageExecutionStatusFailed = "Failed"

	// StageExecutionStatusSucceeded is a StageExecutionStatus enum value
	StageExecutionStatusSucceeded = "Succeeded"
)

const (
	// StageRetryModeFailedActions is a StageRetryMode enum value
	StageRetryModeFailedActions = "FAILED_ACTIONS"
)

const (
	// StageTransitionTypeInbound is a StageTransitionType enum value
	StageTransitionTypeInbound = "Inbound"

	// StageTransitionTypeOutbound is a StageTransitionType enum value
	StageTransitionTypeOutbound = "Outbound"
)
