import * as React from 'react';
import { navFactory } from '@console/internal/components/utils';
import { DetailsPage } from '@console/internal/components/factory';
import { K8sResourceKindReference } from '@console/internal/module/k8s';
import { TemplateModel } from '@console/internal/models';
import { VMDisksFirehose } from '../vm-disks';
import { VMNics } from '../vm-nics';
import { VM_TEMPLATE_LABEL_PLURAL } from '../../constants/vm-templates';
import { menuActions } from './menu-actions';
import { VMTemplateDetailsConnected } from './vm-template-details';

export const VMTemplateDetailsPage: React.FC<VMTemplateDetailsPageProps> = (props) => {
  const nicsPage = {
    href: 'nics',
    name: 'Network Interfaces',
    component: VMNics,
  };

  const disksPage = {
    href: 'disks',
    name: 'Disks',
    component: VMDisksFirehose,
  };

  const pages = [
    navFactory.details(VMTemplateDetailsConnected),
    navFactory.editYaml(),
    nicsPage,
    disksPage,
  ];

  const breadcrumbsForVMTemplatePage = (match: any) => () => [
    { name: VM_TEMPLATE_LABEL_PLURAL, path: `/k8s/ns/${match.params.ns || 'default'}/vmtemplates` },
    { name: `${match.params.name} Details`, path: `${match.url}` },
  ];

  return (
    <DetailsPage
      {...props}
      kind={TemplateModel.kind}
      kindObj={TemplateModel}
      name={props.match.params.name}
      namespace={props.match.params.ns}
      menuActions={menuActions}
      pages={pages}
      breadcrumbsFor={breadcrumbsForVMTemplatePage(props.match)}
    />
  );
};

type VMTemplateDetailsPageProps = {
  name: string;
  namespace: string;
  kind: K8sResourceKindReference;
  match: any;
};
