import { Graph, Layout, LayoutFactory } from '@console/topology';
import TopologyColaLayout from './TopologyColaLayout';

const COLA_LAYOUT = 'Cola';
const COLA_FORCE_LAYOUT = 'ColaForce';

const layoutFactory: LayoutFactory = (type: string, graph: Graph): Layout | undefined => {
  switch (type) {
    case COLA_FORCE_LAYOUT:
      return new TopologyColaLayout(graph, {
        linkDistance: 60,
        nodeDistance: 35,
        groupDistance: 35,
      });
    case COLA_LAYOUT:
      return new TopologyColaLayout(graph, {
        linkDistance: 60,
        nodeDistance: 35,
        groupDistance: 35,
        layoutOnDrag: false,
      });
    default:
      return undefined;
  }
};

export { layoutFactory, COLA_LAYOUT, COLA_FORCE_LAYOUT };
