import { PodKind } from '@console/internal/module/k8s';

export const mockPods: PodKind[] = [
  {
    metadata: {
      name: 'dotnet-7b49587c68-jr528',
      uid: 'c8f9e846-4f3f-4f37-8564-eb3ef94c16fd',
      namespace: 'jeff-project',
    },
    spec: {
      containers: [
        {
          name: 'dotnet',
        },
      ],
    },
    status: {
      phase: 'Running',
    },
  },
  {
    metadata: {
      name: 'dotnet-7b49587c68-ntp75',
      uid: '64e5a291-c7a3-4f71-a271-156741f65717',
      namespace: 'jeff-project',
    },
    spec: {
      containers: [
        {
          name: 'dotnet',
        },
      ],
    },
    status: {
      phase: 'Running',
    },
  },
];

export const mockPodEvents = {
  '64e5a291-c7a3-4f71-a271-156741f65717': {
    data: [
      {
        lastTimestamp: null,
        reportingInstance: 'default-scheduler-ip-10-0-155-63',
        reason: 'Scheduled',
        firstTimestamp: null,
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '64e5a291-c7a3-4f71-a271-156741f65717',
          apiVersion: 'v1',
          resourceVersion: '324649',
        },
        message:
          'Successfully assigned jeff-project/dotnet-7b49587c68-6lmp2 to ip-10-0-139-46.ec2.internal',
        eventTime: '2020-03-09T15:53:16.209039Z',
        reportingComponent: 'default-scheduler',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb15a3f19d0',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb15a3f19d0',
          uid: '51530dae-67e2-4c6f-8127-8a00a946debe',
          resourceVersion: '324654',
          creationTimestamp: '2020-03-09T15:53:16Z',
        },
        action: 'Binding',
        type: 'Normal',
        source: { component: 'default-scheduler' },
      },
      {
        lastTimestamp: '2020-03-09T15:53:18Z',
        reportingInstance: '',
        reason: 'Pulling',
        firstTimestamp: '2020-03-09T15:53:18Z',
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '64e5a291-c7a3-4f71-a271-156741f65717',
          apiVersion: 'v1',
          resourceVersion: '324652',
          fieldPath: 'spec.containers{dotnet}',
        },
        message:
          'Pulling image "image-registry.openshift-image-registry.svc:5000/jeff-project/dotnet@sha256:fda193576e102139a4c837208d2a20f8ed3f3d7d423d6840441016a9c7d77282"',
        eventTime: null,
        count: 1,
        reportingComponent: '',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb1cf84a063',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb1cf84a063',
          uid: '8e05d361-e780-4c16-8b8b-2baf72d264d9',
          resourceVersion: '324693',
          creationTimestamp: '2020-03-09T15:53:18Z',
        },
        type: 'Normal',
        source: { component: 'kubelet', host: 'ip-10-0-139-46.ec2.internal' },
      },
    ],
    filters: {},
    loadError: '',
    loaded: true,
    selected: null,
  },
  'c8f9e846-4f3f-4f37-8564-eb3ef94c16fd': {
    data: [
      {
        lastTimestamp: null,
        reportingInstance: 'default-scheduler-ip-10-0-155-63',
        reason: 'Scheduled',
        firstTimestamp: null,
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '6561c07d-38a5-448f-98e9-3fe14bfcc7a8',
          apiVersion: 'v1',
          resourceVersion: '324649',
        },
        message:
          'Successfully assigned jeff-project/dotnet-7b49587c68-6lmp2 to ip-10-0-139-46.ec2.internal',
        eventTime: '2020-03-09T15:53:16.209039Z',
        reportingComponent: 'default-scheduler',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb15a3f19d0',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb15a3f19d0',
          uid: '51530dae-67e2-4c6f-8127-8a00a946debe',
          resourceVersion: '324654',
          creationTimestamp: '2020-03-09T15:53:16Z',
        },
        action: 'Binding',
        type: 'Warning',
        source: { component: 'default-scheduler' },
      },
      {
        lastTimestamp: '2020-03-09T15:53:18Z',
        reportingInstance: '',
        reason: 'Pulling',
        firstTimestamp: '2020-03-09T15:53:18Z',
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '6561c07d-38a5-448f-98e9-3fe14bfcc7a8',
          apiVersion: 'v1',
          resourceVersion: '324652',
          fieldPath: 'spec.containers{dotnet}',
        },
        message:
          'Pulling image "image-registry.openshift-image-registry.svc:5000/jeff-project/dotnet@sha256:fda193576e102139a4c837208d2a20f8ed3f3d7d423d6840441016a9c7d77282"',
        eventTime: null,
        count: 1,
        reportingComponent: '',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb1cf84a063',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb1cf84a063',
          uid: '8e05d361-e780-4c16-8b8b-2baf72d264d9',
          resourceVersion: '324693',
          creationTimestamp: '2020-03-09T15:53:18Z',
        },
        type: 'Warning',
        source: { component: 'kubelet', host: 'ip-10-0-139-46.ec2.internal' },
      },
      {
        lastTimestamp: '2020-03-09T15:53:44Z',
        reportingInstance: '',
        reason: 'Pulled',
        firstTimestamp: '2020-03-09T15:53:44Z',
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '6561c07d-38a5-448f-98e9-3fe14bfcc7a8',
          apiVersion: 'v1',
          resourceVersion: '324652',
          fieldPath: 'spec.containers{dotnet}',
        },
        message:
          'Successfully pulled image "image-registry.openshift-image-registry.svc:5000/jeff-project/dotnet@sha256:fda193576e102139a4c837208d2a20f8ed3f3d7d423d6840441016a9c7d77282"',
        eventTime: null,
        count: 1,
        reportingComponent: '',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb80ac3a336',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb80ac3a336',
          uid: 'a49cc309-5f6d-498d-a128-d0b51bff6c77',
          resourceVersion: '325018',
          creationTimestamp: '2020-03-09T15:53:44Z',
        },
        kind: 'Event',
        type: 'Normal',
        source: { component: 'kubelet', host: 'ip-10-0-139-46.ec2.internal' },
        apiVersion: 'v1',
      },
      {
        lastTimestamp: '2020-03-09T15:53:45Z',
        reportingInstance: '',
        reason: 'Created',
        firstTimestamp: '2020-03-09T15:53:45Z',
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '6561c07d-38a5-448f-98e9-3fe14bfcc7a8',
          apiVersion: 'v1',
          resourceVersion: '324652',
          fieldPath: 'spec.containers{dotnet}',
        },
        message: 'Created container dotnet',
        eventTime: null,
        count: 1,
        reportingComponent: '',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb82da5529e',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb82da5529e',
          uid: '3c682033-506b-46de-b263-5f20bcf03737',
          resourceVersion: '325030',
          creationTimestamp: '2020-03-09T15:53:45Z',
        },
        kind: 'Event',
        type: 'Normal',
        source: { component: 'kubelet', host: 'ip-10-0-139-46.ec2.internal' },
        apiVersion: 'v1',
      },
      {
        lastTimestamp: '2020-03-09T15:53:45Z',
        reportingInstance: '',
        reason: 'Started',
        firstTimestamp: '2020-03-09T15:53:45Z',
        involvedObject: {
          kind: 'Pod',
          namespace: 'jeff-project',
          name: 'dotnet-7b49587c68-6lmp2',
          uid: '6561c07d-38a5-448f-98e9-3fe14bfcc7a8',
          apiVersion: 'v1',
          resourceVersion: '324652',
          fieldPath: 'spec.containers{dotnet}',
        },
        message: 'Started container dotnet',
        eventTime: null,
        count: 1,
        reportingComponent: '',
        metadata: {
          name: 'dotnet-7b49587c68-6lmp2.15faadb82f9fb72c',
          namespace: 'jeff-project',
          selfLink:
            '/api/v1/namespaces/jeff-project/events/dotnet-7b49587c68-6lmp2.15faadb82f9fb72c',
          uid: 'a95efb56-e3de-4f91-a9af-e3d1a5df3636',
          resourceVersion: '325031',
          creationTimestamp: '2020-03-09T15:53:45Z',
        },
        kind: 'Event',
        type: 'Normal',
        source: { component: 'kubelet', host: 'ip-10-0-139-46.ec2.internal' },
        apiVersion: 'v1',
      },
    ],
    filters: {},
    loadError: '',
    loaded: true,
    selected: null,
  },
};

export const mockResourceEvents = {
  data: [
    {
      lastTimestamp: '2020-03-11T10:51:56Z',
      reportingInstance: '',
      reason: 'SuccessfulCreate',
      firstTimestamp: '2020-03-11T10:51:56Z',
      involvedObject: {
        kind: 'StatefulSet',
        namespace: 'jeff-project',
        name: 'cassandra',
        uid: 'f59d885d-c205-448e-9790-b928a6535f4a',
        apiVersion: 'apps/v1',
        resourceVersion: '123720',
      },
      message: 'create Claim data-cassandra-0 Pod cassandra-0 in StatefulSet cassandra success',
      eventTime: null,
      count: 1,
      reportingComponent: '',
      metadata: {
        name: 'cassandra.15fb3a6908d6a3bb',
        namespace: 'jeff-project',
        selfLink: '/api/v1/namespaces/jeff-project/events/cassandra.15fb3a6908d6a3bb',
        uid: 'd95d5d5b-05bb-4045-8e3e-5521c610b01a',
        resourceVersion: '123723',
        creationTimestamp: '2020-03-11T10:51:56Z',
      },
      type: 'Normal',
      source: { component: 'statefulset-controller' },
    },
    {
      lastTimestamp: '2020-03-11T10:51:56Z',
      reportingInstance: '',
      reason: 'SuccessfulCreate',
      firstTimestamp: '2020-03-11T10:51:56Z',
      involvedObject: {
        kind: 'StatefulSet',
        namespace: 'jeff-project',
        name: 'cassandra',
        uid: 'f59d885d-c205-448e-9790-b928a6535f4a',
        apiVersion: 'apps/v1',
        resourceVersion: '123720',
      },
      message: 'create Pod cassandra-0 in StatefulSet cassandra successful',
      eventTime: null,
      count: 1,
      reportingComponent: '',
      metadata: {
        name: 'cassandra.15fb3a690b2def3f',
        namespace: 'jeff-project',
        selfLink: '/api/v1/namespaces/jeff-project/events/cassandra.15fb3a690b2def3f',
        uid: '5f637ab1-73bc-4542-ae57-c6b4ffa9b406',
        resourceVersion: '123729',
        creationTimestamp: '2020-03-11T10:51:56Z',
      },
      type: 'Normal',
      source: { component: 'statefulset-controller' },
    },
  ],
  filters: {},
  loadError: '',
  loaded: true,
  selected: null,
};
