// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/clusters.proto

/*
Package dataproc is a generated protocol buffer package.

It is generated from these files:
	google/cloud/dataproc/v1/clusters.proto
	google/cloud/dataproc/v1/jobs.proto
	google/cloud/dataproc/v1/operations.proto

It has these top-level messages:
	Cluster
	ClusterConfig
	GceClusterConfig
	InstanceGroupConfig
	ManagedGroupConfig
	DiskConfig
	NodeInitializationAction
	ClusterStatus
	SoftwareConfig
	CreateClusterRequest
	UpdateClusterRequest
	DeleteClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DiagnoseClusterRequest
	DiagnoseClusterResults
	LoggingConfig
	HadoopJob
	SparkJob
	PySparkJob
	QueryList
	HiveJob
	SparkSqlJob
	PigJob
	JobPlacement
	JobStatus
	JobReference
	Job
	SubmitJobRequest
	GetJobRequest
	ListJobsRequest
	ListJobsResponse
	CancelJobRequest
	DeleteJobRequest
	ClusterOperationStatus
	ClusterOperationMetadata
*/
package dataproc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf4 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf5 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
)

var ClusterStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "DELETING",
	5: "UPDATING",
}
var ClusterStatus_State_value = map[string]int32{
	"UNKNOWN":  0,
	"CREATING": 1,
	"RUNNING":  2,
	"ERROR":    3,
	"DELETING": 4,
	"UPDATING": 5,
}

func (x ClusterStatus_State) String() string {
	return proto.EnumName(ClusterStatus_State_name, int32(x))
}
func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Describes the identifying information, config, and status of
// a cluster of Google Compute Engine instances.
type Cluster struct {
	// [Required] The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The cluster name. Cluster names within a project must be
	// unique. Names of deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Required] The cluster config. Note that Cloud Dataproc may set
	// default values, and values may change when clusters are updated.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	// [Output-only] Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	// [Output-only] The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// [Output-only] A cluster UUID (Unique Universal Identifier). Cloud Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Cluster) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Cluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetStatus() *ClusterStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Cluster) GetStatusHistory() []*ClusterStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Cluster) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

// The cluster config.
type ClusterConfig struct {
	// [Optional] A Google Cloud Storage staging bucket used for sharing generated
	// SSH keys and config. If you do not specify a staging bucket, Cloud
	// Dataproc will determine an appropriate Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the Google
	// Compute Engine zone where your cluster is deployed, and then it will create
	// and manage this project-level, per-location bucket for you.
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket" json:"config_bucket,omitempty"`
	// [Required] The shared Google Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig" json:"gce_cluster_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// the master instance in a cluster.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig" json:"master_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// worker instances in a cluster.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig" json:"worker_config,omitempty"`
	// [Optional] The Google Compute Engine config settings for
	// additional worker instances in a cluster.
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig" json:"secondary_worker_config,omitempty"`
	// [Optional] The config settings for software inside the cluster.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig" json:"software_config,omitempty"`
	// [Optional] Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's <code>role</code> metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use `wget`):
	//
	//     ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role)
	//     if [[ "${ROLE}" == 'Master' ]]; then
	//       ... master specific actions ...
	//     else
	//       ... worker specific actions ...
	//     fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions" json:"initialization_actions,omitempty"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ClusterConfig) GetConfigBucket() string {
	if m != nil {
		return m.ConfigBucket
	}
	return ""
}

func (m *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if m != nil {
		return m.GceClusterConfig
	}
	return nil
}

func (m *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if m != nil {
		return m.MasterConfig
	}
	return nil
}

func (m *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if m != nil {
		return m.SoftwareConfig
	}
	return nil
}

func (m *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if m != nil {
		return m.InitializationActions
	}
	return nil
}

// Common config settings for resources of Google Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// [Required] The zone where the Google Compute Engine cluster will be located.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`.
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri" json:"zone_uri,omitempty"`
	// [Optional] The Google Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](/compute/docs/subnetworks) for more information).
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default`.
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri" json:"network_uri,omitempty"`
	// [Optional] The Google Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/sub0`.
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri" json:"subnetwork_uri,omitempty"`
	// [Optional] If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP addresses,
	// and will have ephemeral external IP addresses assigned to each instance.
	// This `internal_ip_only` restriction can only be enabled for subnetwork
	// enabled networks, and all off-cluster dependencies must be configured to be
	// accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly" json:"internal_ip_only,omitempty"`
	// [Optional] The URIs of service account scopes to be included in Google
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes" json:"service_account_scopes,omitempty"`
	// The Google Compute Engine tags to add to all instances (see
	// [Labeling instances](/compute/docs/label-or-tag-resources#labeling_instances)).
	Tags []string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty"`
	// The Google Compute Engine metadata entries to add to all instances (see
	// [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GceClusterConfig) Reset()                    { *m = GceClusterConfig{} }
func (m *GceClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*GceClusterConfig) ProtoMessage()               {}
func (*GceClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GceClusterConfig) GetZoneUri() string {
	if m != nil {
		return m.ZoneUri
	}
	return ""
}

func (m *GceClusterConfig) GetNetworkUri() string {
	if m != nil {
		return m.NetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetSubnetworkUri() string {
	if m != nil {
		return m.SubnetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetInternalIpOnly() bool {
	if m != nil {
		return m.InternalIpOnly
	}
	return false
}

func (m *GceClusterConfig) GetServiceAccountScopes() []string {
	if m != nil {
		return m.ServiceAccountScopes
	}
	return nil
}

func (m *GceClusterConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *GceClusterConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// [Optional] The config settings for Google Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// [Required] The number of VM instances in the instance group.
	// For master instance groups, must be set to 1.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances" json:"num_instances,omitempty"`
	// [Optional] The list of instance names. Cloud Dataproc derives the names from
	// `cluster_name`, `num_instances`, and the instance group if not set by user
	// (recommended practice is to let Cloud Dataproc derive the name).
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames" json:"instance_names,omitempty"`
	// [Output-only] The Google Compute Engine image resource used for cluster
	// instances. Inferred from `SoftwareConfig.image_version`.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// [Required] The Google Compute Engine machine type used for cluster instances.
	// Example: `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`.
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri" json:"machine_type_uri,omitempty"`
	// [Optional] Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig" json:"disk_config,omitempty"`
	// [Optional] Specifies that this instance group contains preemptible instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible" json:"is_preemptible,omitempty"`
	// [Output-only] The config for Google Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig" json:"managed_group_config,omitempty"`
}

func (m *InstanceGroupConfig) Reset()                    { *m = InstanceGroupConfig{} }
func (m *InstanceGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*InstanceGroupConfig) ProtoMessage()               {}
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InstanceGroupConfig) GetNumInstances() int32 {
	if m != nil {
		return m.NumInstances
	}
	return 0
}

func (m *InstanceGroupConfig) GetInstanceNames() []string {
	if m != nil {
		return m.InstanceNames
	}
	return nil
}

func (m *InstanceGroupConfig) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetMachineTypeUri() string {
	if m != nil {
		return m.MachineTypeUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if m != nil {
		return m.DiskConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetIsPreemptible() bool {
	if m != nil {
		return m.IsPreemptible
	}
	return false
}

func (m *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if m != nil {
		return m.ManagedGroupConfig
	}
	return nil
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	// [Output-only] The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName" json:"instance_template_name,omitempty"`
	// [Output-only] The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName" json:"instance_group_manager_name,omitempty"`
}

func (m *ManagedGroupConfig) Reset()                    { *m = ManagedGroupConfig{} }
func (m *ManagedGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*ManagedGroupConfig) ProtoMessage()               {}
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ManagedGroupConfig) GetInstanceTemplateName() string {
	if m != nil {
		return m.InstanceTemplateName
	}
	return ""
}

func (m *ManagedGroupConfig) GetInstanceGroupManagerName() string {
	if m != nil {
		return m.InstanceGroupManagerName
	}
	return ""
}

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	// [Optional] Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
	// [Optional] Number of attached SSDs, from 0 to 4 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	NumLocalSsds int32 `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds" json:"num_local_ssds,omitempty"`
}

func (m *DiskConfig) Reset()                    { *m = DiskConfig{} }
func (m *DiskConfig) String() string            { return proto.CompactTextString(m) }
func (*DiskConfig) ProtoMessage()               {}
func (*DiskConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *DiskConfig) GetBootDiskSizeGb() int32 {
	if m != nil {
		return m.BootDiskSizeGb
	}
	return 0
}

func (m *DiskConfig) GetNumLocalSsds() int32 {
	if m != nil {
		return m.NumLocalSsds
	}
	return 0
}

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	// [Required] Google Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile" json:"executable_file,omitempty"`
	// [Optional] Amount of time executable has to complete. Default is
	// 10 minutes. Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout *google_protobuf4.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout" json:"execution_timeout,omitempty"`
}

func (m *NodeInitializationAction) Reset()                    { *m = NodeInitializationAction{} }
func (m *NodeInitializationAction) String() string            { return proto.CompactTextString(m) }
func (*NodeInitializationAction) ProtoMessage()               {}
func (*NodeInitializationAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *NodeInitializationAction) GetExecutableFile() string {
	if m != nil {
		return m.ExecutableFile
	}
	return ""
}

func (m *NodeInitializationAction) GetExecutionTimeout() *google_protobuf4.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	// [Output-only] The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1.ClusterStatus_State" json:"state,omitempty"`
	// [Output-only] Optional details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
	// [Output-only] Time when this state was entered.
	StateStartTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
}

func (m *ClusterStatus) Reset()                    { *m = ClusterStatus{} }
func (m *ClusterStatus) String() string            { return proto.CompactTextString(m) }
func (*ClusterStatus) ProtoMessage()               {}
func (*ClusterStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ClusterStatus) GetState() ClusterStatus_State {
	if m != nil {
		return m.State
	}
	return ClusterStatus_UNKNOWN
}

func (m *ClusterStatus) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *ClusterStatus) GetStateStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	// [Optional] The version of software inside the cluster. It must match the
	// regular expression `[0-9]+\.[0-9]+`. If unspecified, it defaults to the
	// latest version (see [Cloud Dataproc Versioning](/dataproc/versioning)).
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion" json:"image_version,omitempty"`
	// [Optional] The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, such as
	// `core:fs.defaultFS`. The following are supported prefixes
	// and their mappings:
	//
	// * core:   `core-site.xml`
	// * hdfs:   `hdfs-site.xml`
	// * mapred: `mapred-site.xml`
	// * yarn:   `yarn-site.xml`
	// * hive:   `hive-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SoftwareConfig) Reset()                    { *m = SoftwareConfig{} }
func (m *SoftwareConfig) String() string            { return proto.CompactTextString(m) }
func (*SoftwareConfig) ProtoMessage()               {}
func (*SoftwareConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SoftwareConfig) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *SoftwareConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// [Required] The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
	// [Required] Specifies the path, relative to <code>Cluster</code>, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the <code>update_mask</code> parameter would be
	// specified as <code>config.worker_config.num_instances</code>,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//     {
	//       "config":{
	//         "workerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// Similarly, to change the number of preemptible workers in a cluster to 5, the
	// <code>update_mask</code> parameter would be <code>config.secondary_worker_config.num_instances</code>,
	// and the `PATCH` request body would be set as follows:
	//
	//     {
	//       "config":{
	//         "secondaryWorkerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// <strong>Note:</strong> Currently, <code>config.worker_config.num_instances</code>
	// and <code>config.secondary_worker_config.num_instances</code> are the only
	// fields that can be updated.
	UpdateMask *google_protobuf5.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *UpdateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *UpdateClusterRequest) GetUpdateMask() *google_protobuf5.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// A request to list the clusters in a project.
type ListClustersRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// [Optional] The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// [Optional] The standard List page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The list of all clusters in a project.
type ListClustersResponse struct {
	// [Output-only] The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// [Output-only] This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListClustersRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// [Required] The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// [Required] The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// [Required] The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DiagnoseClusterRequest) Reset()                    { *m = DiagnoseClusterRequest{} }
func (m *DiagnoseClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterRequest) ProtoMessage()               {}
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *DiagnoseClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	// [Output-only] The Google Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
}

func (m *DiagnoseClusterResults) Reset()                    { *m = DiagnoseClusterResults{} }
func (m *DiagnoseClusterResults) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterResults) ProtoMessage()               {}
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *DiagnoseClusterResults) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "google.cloud.dataproc.v1.Cluster")
	proto.RegisterType((*ClusterConfig)(nil), "google.cloud.dataproc.v1.ClusterConfig")
	proto.RegisterType((*GceClusterConfig)(nil), "google.cloud.dataproc.v1.GceClusterConfig")
	proto.RegisterType((*InstanceGroupConfig)(nil), "google.cloud.dataproc.v1.InstanceGroupConfig")
	proto.RegisterType((*ManagedGroupConfig)(nil), "google.cloud.dataproc.v1.ManagedGroupConfig")
	proto.RegisterType((*DiskConfig)(nil), "google.cloud.dataproc.v1.DiskConfig")
	proto.RegisterType((*NodeInitializationAction)(nil), "google.cloud.dataproc.v1.NodeInitializationAction")
	proto.RegisterType((*ClusterStatus)(nil), "google.cloud.dataproc.v1.ClusterStatus")
	proto.RegisterType((*SoftwareConfig)(nil), "google.cloud.dataproc.v1.SoftwareConfig")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.cloud.dataproc.v1.CreateClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.cloud.dataproc.v1.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.cloud.dataproc.v1.DeleteClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.cloud.dataproc.v1.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.cloud.dataproc.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.cloud.dataproc.v1.ListClustersResponse")
	proto.RegisterType((*DiagnoseClusterRequest)(nil), "google.cloud.dataproc.v1.DiagnoseClusterRequest")
	proto.RegisterType((*DiagnoseClusterResults)(nil), "google.cloud.dataproc.v1.DiagnoseClusterResults")
	proto.RegisterEnum("google.cloud.dataproc.v1.ClusterStatus_State", ClusterStatus_State_name, ClusterStatus_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterController service

type ClusterControllerClient interface {
	// Creates a cluster in a project.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type clusterControllerClient struct {
	cc *grpc.ClientConn
}

func NewClusterControllerClient(cc *grpc.ClientConn) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterController service

type ClusterControllerServer interface {
	// Creates a cluster in a project.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*google_longrunning.Operation, error)
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/clusters.proto",
}

func init() { proto.RegisterFile("google/cloud/dataproc/v1/clusters.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1667 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4f, 0x73, 0x23, 0x47,
	0x15, 0x67, 0x64, 0xcb, 0x96, 0x9f, 0x2c, 0x59, 0xdb, 0x51, 0x8c, 0xa2, 0x4d, 0x88, 0x33, 0x09,
	0xac, 0xb3, 0x80, 0x44, 0x1c, 0x28, 0x52, 0xeb, 0x0a, 0xb0, 0x6b, 0x79, 0x8d, 0xc9, 0xae, 0xd6,
	0x8c, 0xed, 0x4d, 0x8a, 0x2a, 0x98, 0x6a, 0xcd, 0xb4, 0x27, 0x8d, 0x66, 0xa6, 0x27, 0xd3, 0x3d,
	0x4e, 0xbc, 0x5b, 0x7b, 0xe1, 0x04, 0xe1, 0xc8, 0x57, 0xe0, 0x40, 0xe5, 0x08, 0x37, 0x4e, 0x7c,
	0x02, 0x2e, 0x1c, 0xb9, 0x72, 0xe2, 0x03, 0x70, 0xe2, 0x40, 0xf5, 0x9f, 0x91, 0x34, 0xb6, 0x24,
	0x7b, 0x17, 0xd7, 0x9e, 0xd4, 0xfd, 0xde, 0xef, 0xfd, 0xe9, 0xd7, 0xef, 0xbd, 0x7e, 0x23, 0xb8,
	0x15, 0x30, 0x16, 0x84, 0xa4, 0xeb, 0x85, 0x2c, 0xf3, 0xbb, 0x3e, 0x16, 0x38, 0x49, 0x99, 0xd7,
	0x3d, 0x7d, 0xaf, 0xeb, 0x85, 0x19, 0x17, 0x24, 0xe5, 0x9d, 0x24, 0x65, 0x82, 0xa1, 0x96, 0x06,
	0x76, 0x14, 0xb0, 0x93, 0x03, 0x3b, 0xa7, 0xef, 0xb5, 0x5f, 0x37, 0x2a, 0x70, 0x42, 0xbb, 0x38,
	0x8e, 0x99, 0xc0, 0x82, 0xb2, 0xd8, 0xc8, 0xb5, 0xdf, 0x9d, 0x69, 0x80, 0x25, 0x24, 0x2d, 0x40,
	0xdf, 0x36, 0xd0, 0x90, 0xc5, 0x41, 0x9a, 0xc5, 0x31, 0x8d, 0x83, 0x8b, 0xa0, 0x6f, 0x18, 0x90,
	0xda, 0x0d, 0xb2, 0x93, 0xae, 0x9f, 0x69, 0x80, 0xe1, 0x6f, 0x9c, 0xe7, 0x9f, 0x50, 0x12, 0xfa,
	0x6e, 0x84, 0xf9, 0xd0, 0x20, 0xde, 0x3c, 0x8f, 0x10, 0x34, 0x22, 0x5c, 0xe0, 0x28, 0xd1, 0x00,
	0xfb, 0x6f, 0x25, 0x58, 0xde, 0xd1, 0xa7, 0x47, 0x6f, 0x00, 0x24, 0x29, 0xfb, 0x35, 0xf1, 0x84,
	0x4b, 0xfd, 0x96, 0xb5, 0x61, 0x6d, 0xae, 0x38, 0x2b, 0x86, 0xb2, 0xef, 0xa3, 0xb7, 0x60, 0xd5,
	0xc4, 0xc9, 0x8d, 0x71, 0x44, 0x5a, 0x25, 0x05, 0xa8, 0x1a, 0x5a, 0x1f, 0x47, 0x04, 0xfd, 0x18,
	0x96, 0x3c, 0x16, 0x9f, 0xd0, 0xa0, 0xb5, 0xb0, 0x61, 0x6d, 0x56, 0xb7, 0x6e, 0x75, 0x66, 0x45,
	0xb2, 0x63, 0x8c, 0xee, 0x28, 0xb8, 0x63, 0xc4, 0xa4, 0x02, 0x2e, 0xb0, 0xc8, 0x78, 0x6b, 0xf1,
	0x8a, 0x0a, 0x0e, 0x15, 0xdc, 0x31, 0x62, 0xa8, 0x0f, 0x75, 0xbd, 0x72, 0x3f, 0xa5, 0x5c, 0xb0,
	0xf4, 0xac, 0xb5, 0xbc, 0xb1, 0xf0, 0x3c, 0x8a, 0x6a, 0x5a, 0xfc, 0xa7, 0x5a, 0x7a, 0xf2, 0xd0,
	0x59, 0x46, 0xfd, 0xd6, 0x52, 0xe1, 0xd0, 0xc7, 0x19, 0xf5, 0xed, 0x7f, 0x2e, 0x42, 0xad, 0x70,
	0x1a, 0xf4, 0x36, 0xd4, 0xf4, 0x79, 0xdc, 0x41, 0xe6, 0x0d, 0x89, 0x30, 0xb1, 0x5c, 0xd5, 0xc4,
	0x7b, 0x8a, 0x86, 0x3e, 0x01, 0x14, 0x78, 0xc4, 0xcd, 0xb5, 0x9b, 0xb8, 0x55, 0xd4, 0xb1, 0x6f,
	0xcf, 0xf6, 0x76, 0xcf, 0x23, 0xc5, 0xd0, 0x35, 0x82, 0x73, 0x14, 0xe4, 0x40, 0x2d, 0xc2, 0x93,
	0x4a, 0x57, 0x94, 0xd2, 0xef, 0xce, 0x56, 0xba, 0x1f, 0x73, 0x81, 0x63, 0x8f, 0xec, 0xa5, 0x2c,
	0x4b, 0x8c, 0xde, 0x55, 0xad, 0x63, 0xac, 0xf3, 0x73, 0x96, 0x0e, 0xc7, 0x3a, 0xe1, 0x85, 0x74,
	0x6a, 0x1d, 0x46, 0x27, 0x81, 0xaf, 0x73, 0xe2, 0xb1, 0xd8, 0xc7, 0xe9, 0x99, 0x5b, 0xd4, 0xbe,
	0xfa, 0x22, 0xda, 0x5f, 0x1d, 0x69, 0xfb, 0x78, 0xd2, 0xcc, 0xcf, 0x61, 0x8d, 0xb3, 0x13, 0xf1,
	0x39, 0x4e, 0x49, 0xae, 0xbe, 0xa6, 0xd4, 0x6f, 0xce, 0x56, 0x7f, 0x68, 0x04, 0x8c, 0xe6, 0x3a,
	0x2f, 0xec, 0x11, 0x85, 0x75, 0x1a, 0x53, 0x41, 0x71, 0x48, 0x9f, 0xa8, 0x82, 0x74, 0xb1, 0xa7,
	0x0a, 0xb7, 0x55, 0x55, 0xd9, 0xb6, 0x35, 0x5b, 0x73, 0x9f, 0xf9, 0x64, 0xbf, 0x20, 0x7b, 0x57,
	0x89, 0x3a, 0xaf, 0xd2, 0x29, 0x54, 0x6e, 0xff, 0xb7, 0x04, 0x8d, 0xf3, 0x77, 0x8e, 0x5e, 0x83,
	0xca, 0x13, 0x16, 0x13, 0x37, 0x4b, 0xa9, 0xc9, 0xad, 0x65, 0xb9, 0x3f, 0x4e, 0x29, 0x7a, 0x13,
	0xaa, 0x31, 0x11, 0x32, 0x9a, 0x8a, 0xab, 0x8b, 0x14, 0x0c, 0x49, 0x02, 0xbe, 0x09, 0x75, 0x9e,
	0x0d, 0x26, 0x31, 0x3a, 0xa7, 0x6b, 0x63, 0xaa, 0x84, 0x6d, 0x42, 0x83, 0xc6, 0x82, 0xa4, 0x31,
	0x0e, 0x5d, 0x9a, 0xb8, 0x2c, 0x0e, 0x65, 0x29, 0x59, 0x9b, 0x15, 0xa7, 0x9e, 0xd3, 0xf7, 0x93,
	0x47, 0x71, 0x78, 0x86, 0xbe, 0x0f, 0xeb, 0x9c, 0xa4, 0xa7, 0xd4, 0x23, 0x2e, 0xf6, 0x3c, 0x96,
	0xc5, 0xc2, 0xe5, 0x1e, 0x4b, 0x08, 0x6f, 0x2d, 0x6c, 0x2c, 0x6c, 0xae, 0x38, 0x4d, 0xc3, 0xbd,
	0xab, 0x99, 0x87, 0x8a, 0x87, 0x10, 0x2c, 0x0a, 0x1c, 0xc8, 0x3a, 0x97, 0x18, 0xb5, 0x46, 0x47,
	0x50, 0x89, 0x88, 0xc0, 0x32, 0x5c, 0xad, 0xb2, 0x0a, 0xe4, 0x07, 0x57, 0x2f, 0x84, 0xce, 0x43,
	0x23, 0xba, 0x1b, 0x8b, 0xf4, 0xcc, 0x19, 0x69, 0x6a, 0x6f, 0x43, 0xad, 0xc0, 0x42, 0x0d, 0x58,
	0x18, 0x92, 0x33, 0x13, 0x38, 0xb9, 0x44, 0x4d, 0x28, 0x9f, 0xe2, 0x30, 0xcb, 0x7b, 0x9a, 0xde,
	0xdc, 0x29, 0x7d, 0x60, 0xd9, 0xff, 0x29, 0xc1, 0x2b, 0x53, 0x72, 0x4d, 0x96, 0x78, 0x9c, 0x45,
	0x2e, 0x35, 0x2c, 0xae, 0xb4, 0x95, 0x9d, 0xd5, 0x38, 0x8b, 0x72, 0x38, 0x97, 0xa1, 0xce, 0x01,
	0xaa, 0x65, 0xf2, 0x56, 0x49, 0x9d, 0xb6, 0x96, 0x53, 0x65, 0xd3, 0xe4, 0xe8, 0x26, 0xac, 0xd0,
	0x08, 0x07, 0xfa, 0x3a, 0x17, 0x94, 0x07, 0x15, 0x45, 0x30, 0xf7, 0x10, 0x61, 0xef, 0x53, 0x1a,
	0x13, 0x57, 0x9c, 0x25, 0x1a, 0xb3, 0xa8, 0x30, 0x75, 0x43, 0x3f, 0x3a, 0x4b, 0x14, 0x72, 0x17,
	0xaa, 0x3e, 0xe5, 0xc3, 0x3c, 0xc7, 0xcb, 0x2a, 0xc7, 0xdf, 0x99, 0x1d, 0xc0, 0x1e, 0xe5, 0x43,
	0x93, 0xdf, 0xe0, 0x8f, 0xd6, 0xca, 0x69, 0xee, 0x26, 0x29, 0x21, 0x51, 0x22, 0xe8, 0x20, 0x24,
	0x2a, 0x3f, 0x2a, 0x4e, 0x8d, 0xf2, 0x83, 0x31, 0x11, 0xfd, 0x0a, 0x9a, 0x11, 0x8e, 0x71, 0x40,
	0x7c, 0x37, 0x90, 0x71, 0xc9, 0xcd, 0x2e, 0x2b, 0xb3, 0xdf, 0x99, 0x6d, 0xf6, 0xa1, 0x96, 0x9a,
	0x2c, 0x5c, 0x14, 0x5d, 0xa0, 0xd9, 0xbf, 0xb3, 0x00, 0x5d, 0x84, 0xca, 0x64, 0x1b, 0x85, 0x54,
	0x90, 0x28, 0x09, 0xb1, 0xd0, 0xb1, 0x35, 0xd7, 0xd9, 0xcc, 0xb9, 0x47, 0x86, 0xa9, 0xde, 0xa5,
	0x0f, 0xe1, 0xe6, 0x48, 0x4a, 0x7b, 0xab, 0x2d, 0x16, 0x5e, 0xb2, 0x16, 0x9d, 0xbc, 0x67, 0x6d,
	0x5b, 0x3d, 0x6b, 0xf6, 0x2f, 0x01, 0xc6, 0xc1, 0x42, 0xef, 0xc2, 0x8d, 0x01, 0x63, 0xc2, 0x55,
	0xc1, 0xe6, 0xf4, 0x09, 0x71, 0x83, 0x81, 0xb9, 0xfe, 0xba, 0x64, 0x48, 0xe8, 0x21, 0x7d, 0x42,
	0xf6, 0x06, 0xe8, 0x1d, 0xa8, 0xcb, 0x2c, 0x09, 0x99, 0x87, 0x43, 0x97, 0x73, 0x9f, 0x2b, 0x53,
	0x3a, 0x4d, 0x1e, 0x48, 0xe2, 0x21, 0xf7, 0xb9, 0xfd, 0x7b, 0x0b, 0x5a, 0xb3, 0xda, 0x02, 0xba,
	0x05, 0x6b, 0xe4, 0x0b, 0xe2, 0x65, 0x02, 0x0f, 0x42, 0xe2, 0x9e, 0xd0, 0x30, 0x3f, 0x69, 0x7d,
	0x4c, 0xbe, 0x4f, 0x43, 0x82, 0xee, 0xc3, 0x0d, 0x4d, 0x91, 0xed, 0x48, 0x3e, 0xf3, 0x2c, 0x13,
	0xca, 0x5c, 0x75, 0xeb, 0xb5, 0xfc, 0x36, 0xf2, 0x31, 0xa0, 0xd3, 0x33, 0x83, 0x84, 0xd3, 0x18,
	0xc9, 0x1c, 0x69, 0x11, 0xfb, 0xcb, 0xd2, 0xe8, 0x39, 0xd3, 0x4f, 0x22, 0xda, 0x81, 0xb2, 0x7c,
	0x14, 0xb5, 0xe1, 0xfa, 0xbc, 0xae, 0x5c, 0x90, 0xeb, 0xc8, 0x1f, 0xe2, 0x68, 0x59, 0xb4, 0x0e,
	0x4b, 0x3e, 0x11, 0x98, 0x86, 0x26, 0xda, 0x66, 0x87, 0x7a, 0xd0, 0x50, 0x00, 0x97, 0x0b, 0x9c,
	0x0a, 0xe5, 0xb8, 0x19, 0x1e, 0xda, 0x17, 0xbc, 0x3e, 0xca, 0x87, 0x17, 0x47, 0x3d, 0xf2, 0xe4,
	0x50, 0x8a, 0x48, 0xa2, 0xfd, 0x18, 0xca, 0xca, 0x1a, 0xaa, 0xc2, 0xf2, 0x71, 0xff, 0xa3, 0xfe,
	0xa3, 0x8f, 0xfb, 0x8d, 0xaf, 0xa1, 0x55, 0xa8, 0xec, 0x38, 0xbb, 0x77, 0x8f, 0xf6, 0xfb, 0x7b,
	0x0d, 0x4b, 0xb2, 0x9c, 0xe3, 0x7e, 0x5f, 0x6e, 0x4a, 0x68, 0x05, 0xca, 0xbb, 0x8e, 0xf3, 0xc8,
	0x69, 0x2c, 0x48, 0x54, 0x6f, 0xf7, 0xc1, 0xae, 0x42, 0x2d, 0xca, 0xdd, 0xf1, 0x41, 0x4f, 0xcb,
	0x94, 0xed, 0xbf, 0x5b, 0x50, 0x2f, 0xbe, 0x05, 0xb2, 0xf2, 0x75, 0xb5, 0x9e, 0x92, 0x94, 0x53,
	0x16, 0xe7, 0x8f, 0xbb, 0x22, 0x3e, 0xd6, 0x34, 0xf4, 0x89, 0x1a, 0xa5, 0x12, 0x92, 0x0a, 0x6a,
	0xaa, 0x7e, 0x6e, 0x2f, 0x2b, 0x9a, 0xe8, 0x1c, 0x8c, 0x44, 0x75, 0x2f, 0x9b, 0xd0, 0xd5, 0xfe,
	0x10, 0xd6, 0xce, 0xb1, 0x9f, 0xab, 0x9f, 0x7d, 0x69, 0x41, 0x73, 0x27, 0x25, 0x58, 0xe4, 0xcd,
	0xd3, 0x21, 0x9f, 0x65, 0x84, 0x8b, 0xcb, 0x86, 0xbf, 0x75, 0x58, 0x4a, 0x49, 0x20, 0x8f, 0xab,
	0x1b, 0x94, 0xd9, 0xa1, 0x6d, 0x58, 0x36, 0x13, 0x8c, 0xc9, 0xb5, 0xb7, 0x2e, 0xcd, 0x0e, 0x27,
	0x97, 0xb0, 0xff, 0x6d, 0x41, 0xf3, 0x38, 0xf1, 0xff, 0x0f, 0x67, 0xca, 0x05, 0x67, 0xae, 0x30,
	0xa1, 0x4e, 0xf8, 0xbb, 0xf0, 0xbc, 0xfe, 0xa2, 0x6d, 0xa8, 0x66, 0xca, 0x5d, 0x35, 0x62, 0x9b,
	0x11, 0xf5, 0x62, 0x9a, 0xde, 0x97, 0x53, 0xf8, 0x43, 0xcc, 0x87, 0x0e, 0x68, 0xb8, 0x5c, 0xdb,
	0x09, 0x34, 0x7b, 0x24, 0x24, 0xd7, 0x15, 0xf8, 0xcb, 0xcf, 0x6a, 0x47, 0x70, 0x63, 0x8f, 0x88,
	0x97, 0x66, 0xee, 0xb7, 0x16, 0xbc, 0xf2, 0x80, 0xf2, 0xdc, 0x20, 0x7f, 0x6e, 0x8b, 0x8b, 0x05,
	0x8b, 0x37, 0x61, 0x25, 0x91, 0x65, 0x26, 0x3b, 0xac, 0x69, 0x9b, 0x15, 0x49, 0x90, 0xad, 0x55,
	0xe9, 0x94, 0x4c, 0xc1, 0x86, 0x24, 0x77, 0x55, 0xc1, 0x8f, 0x24, 0xc1, 0x7e, 0x06, 0xcd, 0xa2,
	0x27, 0x3c, 0x61, 0x31, 0x97, 0xef, 0x40, 0x25, 0xff, 0xd4, 0x6b, 0x59, 0xaa, 0x28, 0xaf, 0x70,
	0xfd, 0x23, 0x11, 0xf4, 0x2d, 0x58, 0x8b, 0xc9, 0x17, 0xc2, 0x9d, 0x30, 0xad, 0xe3, 0x50, 0x93,
	0xe4, 0x83, 0x91, 0xf9, 0x14, 0xd6, 0x7b, 0x14, 0x07, 0x31, 0xe3, 0x2f, 0xef, 0xb2, 0x7f, 0x38,
	0xc5, 0x26, 0xcf, 0x42, 0xc1, 0xa5, 0x4d, 0x96, 0x89, 0x24, 0x13, 0x13, 0xe3, 0xe2, 0x8a, 0xa6,
	0x1c, 0xa7, 0x74, 0xeb, 0xcf, 0x15, 0xb8, 0x31, 0x1e, 0xa4, 0x44, 0xca, 0xc2, 0x90, 0xa4, 0xe8,
	0x8f, 0x16, 0xd4, 0x0a, 0x7d, 0x02, 0x75, 0xe6, 0x44, 0x6a, 0x4a, 0x43, 0x69, 0xbf, 0x91, 0xe3,
	0x27, 0x3e, 0x71, 0x3b, 0x8f, 0xf2, 0x4f, 0x5c, 0xbb, 0xf7, 0x9b, 0x7f, 0xfc, 0xeb, 0x0f, 0xa5,
	0x1f, 0xd9, 0xef, 0xcb, 0xcf, 0x63, 0x13, 0x01, 0xde, 0x7d, 0x3a, 0x8e, 0xce, 0xb3, 0xae, 0x3e,
	0x3c, 0xef, 0x3e, 0xd5, 0x8b, 0x67, 0xa3, 0xcf, 0xf4, 0x3b, 0xa3, 0x8a, 0xfc, 0x8b, 0x05, 0xb5,
	0x42, 0x07, 0x99, 0xe7, 0xe6, 0xb4, 0x56, 0x73, 0x99, 0x9b, 0x87, 0xca, 0xcd, 0x87, 0x5b, 0xf7,
	0x5e, 0xc0, 0xcd, 0xee, 0xd3, 0xc9, 0x4b, 0x7b, 0x36, 0xf6, 0xfa, 0x2b, 0x0b, 0x6a, 0x85, 0x5e,
	0x30, 0xcf, 0xeb, 0x69, 0x4d, 0xe3, 0x32, 0xaf, 0x7f, 0xa6, 0xbc, 0xee, 0xdd, 0xbe, 0x06, 0xaf,
	0xd1, 0x9f, 0x2c, 0x80, 0x71, 0x1b, 0x41, 0xdf, 0x9e, 0x33, 0x91, 0x9f, 0x6f, 0x36, 0xed, 0xcb,
	0xab, 0x2b, 0x77, 0x15, 0x5d, 0x87, 0xab, 0x5f, 0x59, 0xb0, 0x3a, 0x59, 0xf7, 0x68, 0xce, 0xa8,
	0x32, 0xa5, 0x53, 0xb5, 0x3b, 0x57, 0x85, 0xeb, 0x76, 0x62, 0x6f, 0x2b, 0xdf, 0x7f, 0x80, 0x5e,
	0x24, 0x87, 0xd1, 0x5f, 0x2d, 0x58, 0x3b, 0x57, 0xb1, 0xe8, 0x7b, 0xf3, 0xa6, 0xf5, 0x69, 0x0d,
	0xe5, 0xb2, 0x44, 0x78, 0xac, 0x3c, 0x3c, 0xb0, 0x3f, 0xba, 0x86, 0xf4, 0xf5, 0x8d, 0x07, 0x77,
	0xac, 0xdb, 0xf7, 0x3e, 0x83, 0xd7, 0x3d, 0x16, 0xcd, 0xf4, 0xf6, 0x5e, 0x3e, 0x41, 0xf2, 0x03,
	0xf9, 0x28, 0x1e, 0x58, 0xbf, 0xf8, 0x89, 0x81, 0x06, 0x2c, 0xc4, 0x71, 0xd0, 0x61, 0x69, 0xd0,
	0x0d, 0x48, 0xac, 0x9e, 0xcc, 0xae, 0x66, 0xe1, 0x84, 0xf2, 0x8b, 0xff, 0x9c, 0x6d, 0xe7, 0xeb,
	0xc1, 0x92, 0x02, 0xbf, 0xff, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x58, 0xab, 0x60, 0x26, 0xc6,
	0x13, 0x00, 0x00,
}
