// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/console/v1"
	scheme "github.com/openshift/client-go/console/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ConsoleYAMLSamplesGetter has a method to return a ConsoleYAMLSampleInterface.
// A group's client should implement this interface.
type ConsoleYAMLSamplesGetter interface {
	ConsoleYAMLSamples() ConsoleYAMLSampleInterface
}

// ConsoleYAMLSampleInterface has methods to work with ConsoleYAMLSample resources.
type ConsoleYAMLSampleInterface interface {
	Create(*v1.ConsoleYAMLSample) (*v1.ConsoleYAMLSample, error)
	Update(*v1.ConsoleYAMLSample) (*v1.ConsoleYAMLSample, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ConsoleYAMLSample, error)
	List(opts metav1.ListOptions) (*v1.ConsoleYAMLSampleList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ConsoleYAMLSample, err error)
	ConsoleYAMLSampleExpansion
}

// consoleYAMLSamples implements ConsoleYAMLSampleInterface
type consoleYAMLSamples struct {
	client rest.Interface
}

// newConsoleYAMLSamples returns a ConsoleYAMLSamples
func newConsoleYAMLSamples(c *ConsoleV1Client) *consoleYAMLSamples {
	return &consoleYAMLSamples{
		client: c.RESTClient(),
	}
}

// Get takes name of the consoleYAMLSample, and returns the corresponding consoleYAMLSample object, and an error if there is any.
func (c *consoleYAMLSamples) Get(name string, options metav1.GetOptions) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Get().
		Resource("consoleyamlsamples").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConsoleYAMLSamples that match those selectors.
func (c *consoleYAMLSamples) List(opts metav1.ListOptions) (result *v1.ConsoleYAMLSampleList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ConsoleYAMLSampleList{}
	err = c.client.Get().
		Resource("consoleyamlsamples").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested consoleYAMLSamples.
func (c *consoleYAMLSamples) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("consoleyamlsamples").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a consoleYAMLSample and creates it.  Returns the server's representation of the consoleYAMLSample, and an error, if there is any.
func (c *consoleYAMLSamples) Create(consoleYAMLSample *v1.ConsoleYAMLSample) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Post().
		Resource("consoleyamlsamples").
		Body(consoleYAMLSample).
		Do().
		Into(result)
	return
}

// Update takes the representation of a consoleYAMLSample and updates it. Returns the server's representation of the consoleYAMLSample, and an error, if there is any.
func (c *consoleYAMLSamples) Update(consoleYAMLSample *v1.ConsoleYAMLSample) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Put().
		Resource("consoleyamlsamples").
		Name(consoleYAMLSample.Name).
		Body(consoleYAMLSample).
		Do().
		Into(result)
	return
}

// Delete takes name of the consoleYAMLSample and deletes it. Returns an error if one occurs.
func (c *consoleYAMLSamples) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("consoleyamlsamples").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *consoleYAMLSamples) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("consoleyamlsamples").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched consoleYAMLSample.
func (c *consoleYAMLSamples) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ConsoleYAMLSample, err error) {
	result = &v1.ConsoleYAMLSample{}
	err = c.client.Patch(pt).
		Resource("consoleyamlsamples").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
