// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceCAsGetter has a method to return a ServiceCAInterface.
// A group's client should implement this interface.
type ServiceCAsGetter interface {
	ServiceCAs() ServiceCAInterface
}

// ServiceCAInterface has methods to work with ServiceCA resources.
type ServiceCAInterface interface {
	Create(*v1.ServiceCA) (*v1.ServiceCA, error)
	Update(*v1.ServiceCA) (*v1.ServiceCA, error)
	UpdateStatus(*v1.ServiceCA) (*v1.ServiceCA, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ServiceCA, error)
	List(opts metav1.ListOptions) (*v1.ServiceCAList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCA, err error)
	ServiceCAExpansion
}

// serviceCAs implements ServiceCAInterface
type serviceCAs struct {
	client rest.Interface
}

// newServiceCAs returns a ServiceCAs
func newServiceCAs(c *OperatorV1Client) *serviceCAs {
	return &serviceCAs{
		client: c.RESTClient(),
	}
}

// Get takes name of the serviceCA, and returns the corresponding serviceCA object, and an error if there is any.
func (c *serviceCAs) Get(name string, options metav1.GetOptions) (result *v1.ServiceCA, err error) {
	result = &v1.ServiceCA{}
	err = c.client.Get().
		Resource("servicecas").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceCAs that match those selectors.
func (c *serviceCAs) List(opts metav1.ListOptions) (result *v1.ServiceCAList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ServiceCAList{}
	err = c.client.Get().
		Resource("servicecas").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceCAs.
func (c *serviceCAs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("servicecas").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a serviceCA and creates it.  Returns the server's representation of the serviceCA, and an error, if there is any.
func (c *serviceCAs) Create(serviceCA *v1.ServiceCA) (result *v1.ServiceCA, err error) {
	result = &v1.ServiceCA{}
	err = c.client.Post().
		Resource("servicecas").
		Body(serviceCA).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceCA and updates it. Returns the server's representation of the serviceCA, and an error, if there is any.
func (c *serviceCAs) Update(serviceCA *v1.ServiceCA) (result *v1.ServiceCA, err error) {
	result = &v1.ServiceCA{}
	err = c.client.Put().
		Resource("servicecas").
		Name(serviceCA.Name).
		Body(serviceCA).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceCAs) UpdateStatus(serviceCA *v1.ServiceCA) (result *v1.ServiceCA, err error) {
	result = &v1.ServiceCA{}
	err = c.client.Put().
		Resource("servicecas").
		Name(serviceCA.Name).
		SubResource("status").
		Body(serviceCA).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceCA and deletes it. Returns an error if one occurs.
func (c *serviceCAs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("servicecas").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceCAs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("servicecas").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceCA.
func (c *serviceCAs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCA, err error) {
	result = &v1.ServiceCA{}
	err = c.client.Patch(pt).
		Resource("servicecas").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
