// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package main

import (
	"golang.org/x/text/language"
	"golang.org/x/text/message"
	"golang.org/x/text/message/catalog"
)

type dictionary struct {
	index []uint32
	data  string
}

func (d *dictionary) Lookup(key string) (data string, ok bool) {
	p := messageKeyToIndex[key]
	start, end := d.index[p], d.index[p+1]
	if start == end {
		return "", false
	}
	return d.data[start:end], true
}

func init() {
	dict := map[string]catalog.Dictionary{
		"en": &dictionary{index: enIndex, data: enData},
		"zh": &dictionary{index: zhIndex, data: zhData},
	}
	fallback := language.MustParse("en")
	cat, err := catalog.NewFromMap(dict, catalog.Fallback(fallback))
	if err != nil {
		panic(err)
	}
	message.DefaultCatalog = cat
}

var messageKeyToIndex = map[string]int{
	"Do you like your browser (%s)?\n": 1,
	"Hello %s!\n":                      0,
}

var enIndex = []uint32{ // 3 elements
	0x00000000, 0x00000012, 0x00000039,
} // Size: 36 bytes

const enData string = "" + // Size: 57 bytes
	"\x04\x00\x01\x0a\x0d\x02Hello %[1]s!\x04\x00\x01\x0a\x22\x02Do you like " +
	"your browser (%[1]s)?"

var zhIndex = []uint32{ // 3 elements
	0x00000000, 0x00000000, 0x00000000,
} // Size: 36 bytes

const zhData string = ""

// Total table size 129 bytes (0KiB); checksum: 9C146C82
