// generated by go run maketables.go; DO NOT EDIT

// Package korean provides Korean encodings such as EUC-KR.
package korean // import "golang.org/x/text/encoding/korean"

// decode is the decoding table from EUC-KR code to Unicode.
// It is defined at http://encoding.spec.whatwg.org/index-euc-kr.txt
var decode = [...]uint16{
	0:     0xAC02,
	1:     0xAC03,
	2:     0xAC05,
	3:     0xAC06,
	4:     0xAC0B,
	5:     0xAC0C,
	6:     0xAC0D,
	7:     0xAC0E,
	8:     0xAC0F,
	9:     0xAC18,
	10:    0xAC1E,
	11:    0xAC1F,
	12:    0xAC21,
	13:    0xAC22,
	14:    0xAC23,
	15:    0xAC25,
	16:    0xAC26,
	17:    0xAC27,
	18:    0xAC28,
	19:    0xAC29,
	20:    0xAC2A,
	21:    0xAC2B,
	22:    0xAC2E,
	23:    0xAC32,
	24:    0xAC33,
	25:    0xAC34,
	26:    0xAC35,
	27:    0xAC36,
	28:    0xAC37,
	29:    0xAC3A,
	30:    0xAC3B,
	31:    0xAC3D,
	32:    0xAC3E,
	33:    0xAC3F,
	34:    0xAC41,
	35:    0xAC42,
	36:    0xAC43,
	37:    0xAC44,
	38:    0xAC45,
	39:    0xAC46,
	40:    0xAC47,
	41:    0xAC48,
	42:    0xAC49,
	43:    0xAC4A,
	44:    0xAC4C,
	45:    0xAC4E,
	46:    0xAC4F,
	47:    0xAC50,
	48:    0xAC51,
	49:    0xAC52,
	50:    0xAC53,
	51:    0xAC55,
	52:    0xAC56,
	53:    0xAC57,
	54:    0xAC59,
	55:    0xAC5A,
	56:    0xAC5B,
	57:    0xAC5D,
	58:    0xAC5E,
	59:    0xAC5F,
	60:    0xAC60,
	61:    0xAC61,
	62:    0xAC62,
	63:    0xAC63,
	64:    0xAC64,
	65:    0xAC65,
	66:    0xAC66,
	67:    0xAC67,
	68:    0xAC68,
	69:    0xAC69,
	70:    0xAC6A,
	71:    0xAC6B,
	72:    0xAC6C,
	73:    0xAC6D,
	74:    0xAC6E,
	75:    0xAC6F,
	76:    0xAC72,
	77:    0xAC73,
	78:    0xAC75,
	79:    0xAC76,
	80:    0xAC79,
	81:    0xAC7B,
	82:    0xAC7C,
	83:    0xAC7D,
	84:    0xAC7E,
	85:    0xAC7F,
	86:    0xAC82,
	87:    0xAC87,
	88:    0xAC88,
	89:    0xAC8D,
	90:    0xAC8E,
	91:    0xAC8F,
	92:    0xAC91,
	93:    0xAC92,
	94:    0xAC93,
	95:    0xAC95,
	96:    0xAC96,
	97:    0xAC97,
	98:    0xAC98,
	99:    0xAC99,
	100:   0xAC9A,
	101:   0xAC9B,
	102:   0xAC9E,
	103:   0xACA2,
	104:   0xACA3,
	105:   0xACA4,
	106:   0xACA5,
	107:   0xACA6,
	108:   0xACA7,
	109:   0xACAB,
	110:   0xACAD,
	111:   0xACAE,
	112:   0xACB1,
	113:   0xACB2,
	114:   0xACB3,
	115:   0xACB4,
	116:   0xACB5,
	117:   0xACB6,
	118:   0xACB7,
	119:   0xACBA,
	120:   0xACBE,
	121:   0xACBF,
	122:   0xACC0,
	123:   0xACC2,
	124:   0xACC3,
	125:   0xACC5,
	126:   0xACC6,
	127:   0xACC7,
	128:   0xACC9,
	129:   0xACCA,
	130:   0xACCB,
	131:   0xACCD,
	132:   0xACCE,
	133:   0xACCF,
	134:   0xACD0,
	135:   0xACD1,
	136:   0xACD2,
	137:   0xACD3,
	138:   0xACD4,
	139:   0xACD6,
	140:   0xACD8,
	141:   0xACD9,
	142:   0xACDA,
	143:   0xACDB,
	144:   0xACDC,
	145:   0xACDD,
	146:   0xACDE,
	147:   0xACDF,
	148:   0xACE2,
	149:   0xACE3,
	150:   0xACE5,
	151:   0xACE6,
	152:   0xACE9,
	153:   0xACEB,
	154:   0xACED,
	155:   0xACEE,
	156:   0xACF2,
	157:   0xACF4,
	158:   0xACF7,
	159:   0xACF8,
	160:   0xACF9,
	161:   0xACFA,
	162:   0xACFB,
	163:   0xACFE,
	164:   0xACFF,
	165:   0xAD01,
	166:   0xAD02,
	167:   0xAD03,
	168:   0xAD05,
	169:   0xAD07,
	170:   0xAD08,
	171:   0xAD09,
	172:   0xAD0A,
	173:   0xAD0B,
	174:   0xAD0E,
	175:   0xAD10,
	176:   0xAD12,
	177:   0xAD13,
	178:   0xAD14,
	179:   0xAD15,
	180:   0xAD16,
	181:   0xAD17,
	182:   0xAD19,
	183:   0xAD1A,
	184:   0xAD1B,
	185:   0xAD1D,
	186:   0xAD1E,
	187:   0xAD1F,
	188:   0xAD21,
	189:   0xAD22,
	190:   0xAD23,
	191:   0xAD24,
	192:   0xAD25,
	193:   0xAD26,
	194:   0xAD27,
	195:   0xAD28,
	196:   0xAD2A,
	197:   0xAD2B,
	198:   0xAD2E,
	199:   0xAD2F,
	200:   0xAD30,
	201:   0xAD31,
	202:   0xAD32,
	203:   0xAD33,
	204:   0xAD36,
	205:   0xAD37,
	206:   0xAD39,
	207:   0xAD3A,
	208:   0xAD3B,
	209:   0xAD3D,
	210:   0xAD3E,
	211:   0xAD3F,
	212:   0xAD40,
	213:   0xAD41,
	214:   0xAD42,
	215:   0xAD43,
	216:   0xAD46,
	217:   0xAD48,
	218:   0xAD4A,
	219:   0xAD4B,
	220:   0xAD4C,
	221:   0xAD4D,
	222:   0xAD4E,
	223:   0xAD4F,
	224:   0xAD51,
	225:   0xAD52,
	226:   0xAD53,
	227:   0xAD55,
	228:   0xAD56,
	229:   0xAD57,
	230:   0xAD59,
	231:   0xAD5A,
	232:   0xAD5B,
	233:   0xAD5C,
	234:   0xAD5D,
	235:   0xAD5E,
	236:   0xAD5F,
	237:   0xAD60,
	238:   0xAD62,
	239:   0xAD64,
	240:   0xAD65,
	241:   0xAD66,
	242:   0xAD67,
	243:   0xAD68,
	244:   0xAD69,
	245:   0xAD6A,
	246:   0xAD6B,
	247:   0xAD6E,
	248:   0xAD6F,
	249:   0xAD71,
	250:   0xAD72,
	251:   0xAD77,
	252:   0xAD78,
	253:   0xAD79,
	254:   0xAD7A,
	255:   0xAD7E,
	256:   0xAD80,
	257:   0xAD83,
	258:   0xAD84,
	259:   0xAD85,
	260:   0xAD86,
	261:   0xAD87,
	262:   0xAD8A,
	263:   0xAD8B,
	264:   0xAD8D,
	265:   0xAD8E,
	266:   0xAD8F,
	267:   0xAD91,
	268:   0xAD92,
	269:   0xAD93,
	270:   0xAD94,
	271:   0xAD95,
	272:   0xAD96,
	273:   0xAD97,
	274:   0xAD98,
	275:   0xAD99,
	276:   0xAD9A,
	277:   0xAD9B,
	278:   0xAD9E,
	279:   0xAD9F,
	280:   0xADA0,
	281:   0xADA1,
	282:   0xADA2,
	283:   0xADA3,
	284:   0xADA5,
	285:   0xADA6,
	286:   0xADA7,
	287:   0xADA8,
	288:   0xADA9,
	289:   0xADAA,
	290:   0xADAB,
	291:   0xADAC,
	292:   0xADAD,
	293:   0xADAE,
	294:   0xADAF,
	295:   0xADB0,
	296:   0xADB1,
	297:   0xADB2,
	298:   0xADB3,
	299:   0xADB4,
	300:   0xADB5,
	301:   0xADB6,
	302:   0xADB8,
	303:   0xADB9,
	304:   0xADBA,
	305:   0xADBB,
	306:   0xADBC,
	307:   0xADBD,
	308:   0xADBE,
	309:   0xADBF,
	310:   0xADC2,
	311:   0xADC3,
	312:   0xADC5,
	313:   0xADC6,
	314:   0xADC7,
	315:   0xADC9,
	316:   0xADCA,
	317:   0xADCB,
	318:   0xADCC,
	319:   0xADCD,
	320:   0xADCE,
	321:   0xADCF,
	322:   0xADD2,
	323:   0xADD4,
	324:   0xADD5,
	325:   0xADD6,
	326:   0xADD7,
	327:   0xADD8,
	328:   0xADD9,
	329:   0xADDA,
	330:   0xADDB,
	331:   0xADDD,
	332:   0xADDE,
	333:   0xADDF,
	334:   0xADE1,
	335:   0xADE2,
	336:   0xADE3,
	337:   0xADE5,
	338:   0xADE6,
	339:   0xADE7,
	340:   0xADE8,
	341:   0xADE9,
	342:   0xADEA,
	343:   0xADEB,
	344:   0xADEC,
	345:   0xADED,
	346:   0xADEE,
	347:   0xADEF,
	348:   0xADF0,
	349:   0xADF1,
	350:   0xADF2,
	351:   0xADF3,
	352:   0xADF4,
	353:   0xADF5,
	354:   0xADF6,
	355:   0xADF7,
	356:   0xADFA,
	357:   0xADFB,
	358:   0xADFD,
	359:   0xADFE,
	360:   0xAE02,
	361:   0xAE03,
	362:   0xAE04,
	363:   0xAE05,
	364:   0xAE06,
	365:   0xAE07,
	366:   0xAE0A,
	367:   0xAE0C,
	368:   0xAE0E,
	369:   0xAE0F,
	370:   0xAE10,
	371:   0xAE11,
	372:   0xAE12,
	373:   0xAE13,
	374:   0xAE15,
	375:   0xAE16,
	376:   0xAE17,
	377:   0xAE18,
	378:   0xAE19,
	379:   0xAE1A,
	380:   0xAE1B,
	381:   0xAE1C,
	382:   0xAE1D,
	383:   0xAE1E,
	384:   0xAE1F,
	385:   0xAE20,
	386:   0xAE21,
	387:   0xAE22,
	388:   0xAE23,
	389:   0xAE24,
	390:   0xAE25,
	391:   0xAE26,
	392:   0xAE27,
	393:   0xAE28,
	394:   0xAE29,
	395:   0xAE2A,
	396:   0xAE2B,
	397:   0xAE2C,
	398:   0xAE2D,
	399:   0xAE2E,
	400:   0xAE2F,
	401:   0xAE32,
	402:   0xAE33,
	403:   0xAE35,
	404:   0xAE36,
	405:   0xAE39,
	406:   0xAE3B,
	407:   0xAE3C,
	408:   0xAE3D,
	409:   0xAE3E,
	410:   0xAE3F,
	411:   0xAE42,
	412:   0xAE44,
	413:   0xAE47,
	414:   0xAE48,
	415:   0xAE49,
	416:   0xAE4B,
	417:   0xAE4F,
	418:   0xAE51,
	419:   0xAE52,
	420:   0xAE53,
	421:   0xAE55,
	422:   0xAE57,
	423:   0xAE58,
	424:   0xAE59,
	425:   0xAE5A,
	426:   0xAE5B,
	427:   0xAE5E,
	428:   0xAE62,
	429:   0xAE63,
	430:   0xAE64,
	431:   0xAE66,
	432:   0xAE67,
	433:   0xAE6A,
	434:   0xAE6B,
	435:   0xAE6D,
	436:   0xAE6E,
	437:   0xAE6F,
	438:   0xAE71,
	439:   0xAE72,
	440:   0xAE73,
	441:   0xAE74,
	442:   0xAE75,
	443:   0xAE76,
	444:   0xAE77,
	445:   0xAE7A,
	446:   0xAE7E,
	447:   0xAE7F,
	448:   0xAE80,
	449:   0xAE81,
	450:   0xAE82,
	451:   0xAE83,
	452:   0xAE86,
	453:   0xAE87,
	454:   0xAE88,
	455:   0xAE89,
	456:   0xAE8A,
	457:   0xAE8B,
	458:   0xAE8D,
	459:   0xAE8E,
	460:   0xAE8F,
	461:   0xAE90,
	462:   0xAE91,
	463:   0xAE92,
	464:   0xAE93,
	465:   0xAE94,
	466:   0xAE95,
	467:   0xAE96,
	468:   0xAE97,
	469:   0xAE98,
	470:   0xAE99,
	471:   0xAE9A,
	472:   0xAE9B,
	473:   0xAE9C,
	474:   0xAE9D,
	475:   0xAE9E,
	476:   0xAE9F,
	477:   0xAEA0,
	478:   0xAEA1,
	479:   0xAEA2,
	480:   0xAEA3,
	481:   0xAEA4,
	482:   0xAEA5,
	483:   0xAEA6,
	484:   0xAEA7,
	485:   0xAEA8,
	486:   0xAEA9,
	487:   0xAEAA,
	488:   0xAEAB,
	489:   0xAEAC,
	490:   0xAEAD,
	491:   0xAEAE,
	492:   0xAEAF,
	493:   0xAEB0,
	494:   0xAEB1,
	495:   0xAEB2,
	496:   0xAEB3,
	497:   0xAEB4,
	498:   0xAEB5,
	499:   0xAEB6,
	500:   0xAEB7,
	501:   0xAEB8,
	502:   0xAEB9,
	503:   0xAEBA,
	504:   0xAEBB,
	505:   0xAEBF,
	506:   0xAEC1,
	507:   0xAEC2,
	508:   0xAEC3,
	509:   0xAEC5,
	510:   0xAEC6,
	511:   0xAEC7,
	512:   0xAEC8,
	513:   0xAEC9,
	514:   0xAECA,
	515:   0xAECB,
	516:   0xAECE,
	517:   0xAED2,
	518:   0xAED3,
	519:   0xAED4,
	520:   0xAED5,
	521:   0xAED6,
	522:   0xAED7,
	523:   0xAEDA,
	524:   0xAEDB,
	525:   0xAEDD,
	526:   0xAEDE,
	527:   0xAEDF,
	528:   0xAEE0,
	529:   0xAEE1,
	530:   0xAEE2,
	531:   0xAEE3,
	532:   0xAEE4,
	533:   0xAEE5,
	534:   0xAEE6,
	535:   0xAEE7,
	536:   0xAEE9,
	537:   0xAEEA,
	538:   0xAEEC,
	539:   0xAEEE,
	540:   0xAEEF,
	541:   0xAEF0,
	542:   0xAEF1,
	543:   0xAEF2,
	544:   0xAEF3,
	545:   0xAEF5,
	546:   0xAEF6,
	547:   0xAEF7,
	548:   0xAEF9,
	549:   0xAEFA,
	550:   0xAEFB,
	551:   0xAEFD,
	552:   0xAEFE,
	553:   0xAEFF,
	554:   0xAF00,
	555:   0xAF01,
	556:   0xAF02,
	557:   0xAF03,
	558:   0xAF04,
	559:   0xAF05,
	560:   0xAF06,
	561:   0xAF09,
	562:   0xAF0A,
	563:   0xAF0B,
	564:   0xAF0C,
	565:   0xAF0E,
	566:   0xAF0F,
	567:   0xAF11,
	568:   0xAF12,
	569:   0xAF13,
	570:   0xAF14,
	571:   0xAF15,
	572:   0xAF16,
	573:   0xAF17,
	574:   0xAF18,
	575:   0xAF19,
	576:   0xAF1A,
	577:   0xAF1B,
	578:   0xAF1C,
	579:   0xAF1D,
	580:   0xAF1E,
	581:   0xAF1F,
	582:   0xAF20,
	583:   0xAF21,
	584:   0xAF22,
	585:   0xAF23,
	586:   0xAF24,
	587:   0xAF25,
	588:   0xAF26,
	589:   0xAF27,
	590:   0xAF28,
	591:   0xAF29,
	592:   0xAF2A,
	593:   0xAF2B,
	594:   0xAF2E,
	595:   0xAF2F,
	596:   0xAF31,
	597:   0xAF33,
	598:   0xAF35,
	599:   0xAF36,
	600:   0xAF37,
	601:   0xAF38,
	602:   0xAF39,
	603:   0xAF3A,
	604:   0xAF3B,
	605:   0xAF3E,
	606:   0xAF40,
	607:   0xAF44,
	608:   0xAF45,
	609:   0xAF46,
	610:   0xAF47,
	611:   0xAF4A,
	612:   0xAF4B,
	613:   0xAF4C,
	614:   0xAF4D,
	615:   0xAF4E,
	616:   0xAF4F,
	617:   0xAF51,
	618:   0xAF52,
	619:   0xAF53,
	620:   0xAF54,
	621:   0xAF55,
	622:   0xAF56,
	623:   0xAF57,
	624:   0xAF58,
	625:   0xAF59,
	626:   0xAF5A,
	627:   0xAF5B,
	628:   0xAF5E,
	629:   0xAF5F,
	630:   0xAF60,
	631:   0xAF61,
	632:   0xAF62,
	633:   0xAF63,
	634:   0xAF66,
	635:   0xAF67,
	636:   0xAF68,
	637:   0xAF69,
	638:   0xAF6A,
	639:   0xAF6B,
	640:   0xAF6C,
	641:   0xAF6D,
	642:   0xAF6E,
	643:   0xAF6F,
	644:   0xAF70,
	645:   0xAF71,
	646:   0xAF72,
	647:   0xAF73,
	648:   0xAF74,
	649:   0xAF75,
	650:   0xAF76,
	651:   0xAF77,
	652:   0xAF78,
	653:   0xAF7A,
	654:   0xAF7B,
	655:   0xAF7C,
	656:   0xAF7D,
	657:   0xAF7E,
	658:   0xAF7F,
	659:   0xAF81,
	660:   0xAF82,
	661:   0xAF83,
	662:   0xAF85,
	663:   0xAF86,
	664:   0xAF87,
	665:   0xAF89,
	666:   0xAF8A,
	667:   0xAF8B,
	668:   0xAF8C,
	669:   0xAF8D,
	670:   0xAF8E,
	671:   0xAF8F,
	672:   0xAF92,
	673:   0xAF93,
	674:   0xAF94,
	675:   0xAF96,
	676:   0xAF97,
	677:   0xAF98,
	678:   0xAF99,
	679:   0xAF9A,
	680:   0xAF9B,
	681:   0xAF9D,
	682:   0xAF9E,
	683:   0xAF9F,
	684:   0xAFA0,
	685:   0xAFA1,
	686:   0xAFA2,
	687:   0xAFA3,
	688:   0xAFA4,
	689:   0xAFA5,
	690:   0xAFA6,
	691:   0xAFA7,
	692:   0xAFA8,
	693:   0xAFA9,
	694:   0xAFAA,
	695:   0xAFAB,
	696:   0xAFAC,
	697:   0xAFAD,
	698:   0xAFAE,
	699:   0xAFAF,
	700:   0xAFB0,
	701:   0xAFB1,
	702:   0xAFB2,
	703:   0xAFB3,
	704:   0xAFB4,
	705:   0xAFB5,
	706:   0xAFB6,
	707:   0xAFB7,
	708:   0xAFBA,
	709:   0xAFBB,
	710:   0xAFBD,
	711:   0xAFBE,
	712:   0xAFBF,
	713:   0xAFC1,
	714:   0xAFC2,
	715:   0xAFC3,
	716:   0xAFC4,
	717:   0xAFC5,
	718:   0xAFC6,
	719:   0xAFCA,
	720:   0xAFCC,
	721:   0xAFCF,
	722:   0xAFD0,
	723:   0xAFD1,
	724:   0xAFD2,
	725:   0xAFD3,
	726:   0xAFD5,
	727:   0xAFD6,
	728:   0xAFD7,
	729:   0xAFD8,
	730:   0xAFD9,
	731:   0xAFDA,
	732:   0xAFDB,
	733:   0xAFDD,
	734:   0xAFDE,
	735:   0xAFDF,
	736:   0xAFE0,
	737:   0xAFE1,
	738:   0xAFE2,
	739:   0xAFE3,
	740:   0xAFE4,
	741:   0xAFE5,
	742:   0xAFE6,
	743:   0xAFE7,
	744:   0xAFEA,
	745:   0xAFEB,
	746:   0xAFEC,
	747:   0xAFED,
	748:   0xAFEE,
	749:   0xAFEF,
	750:   0xAFF2,
	751:   0xAFF3,
	752:   0xAFF5,
	753:   0xAFF6,
	754:   0xAFF7,
	755:   0xAFF9,
	756:   0xAFFA,
	757:   0xAFFB,
	758:   0xAFFC,
	759:   0xAFFD,
	760:   0xAFFE,
	761:   0xAFFF,
	762:   0xB002,
	763:   0xB003,
	764:   0xB005,
	765:   0xB006,
	766:   0xB007,
	767:   0xB008,
	768:   0xB009,
	769:   0xB00A,
	770:   0xB00B,
	771:   0xB00D,
	772:   0xB00E,
	773:   0xB00F,
	774:   0xB011,
	775:   0xB012,
	776:   0xB013,
	777:   0xB015,
	778:   0xB016,
	779:   0xB017,
	780:   0xB018,
	781:   0xB019,
	782:   0xB01A,
	783:   0xB01B,
	784:   0xB01E,
	785:   0xB01F,
	786:   0xB020,
	787:   0xB021,
	788:   0xB022,
	789:   0xB023,
	790:   0xB024,
	791:   0xB025,
	792:   0xB026,
	793:   0xB027,
	794:   0xB029,
	795:   0xB02A,
	796:   0xB02B,
	797:   0xB02C,
	798:   0xB02D,
	799:   0xB02E,
	800:   0xB02F,
	801:   0xB030,
	802:   0xB031,
	803:   0xB032,
	804:   0xB033,
	805:   0xB034,
	806:   0xB035,
	807:   0xB036,
	808:   0xB037,
	809:   0xB038,
	810:   0xB039,
	811:   0xB03A,
	812:   0xB03B,
	813:   0xB03C,
	814:   0xB03D,
	815:   0xB03E,
	816:   0xB03F,
	817:   0xB040,
	818:   0xB041,
	819:   0xB042,
	820:   0xB043,
	821:   0xB046,
	822:   0xB047,
	823:   0xB049,
	824:   0xB04B,
	825:   0xB04D,
	826:   0xB04F,
	827:   0xB050,
	828:   0xB051,
	829:   0xB052,
	830:   0xB056,
	831:   0xB058,
	832:   0xB05A,
	833:   0xB05B,
	834:   0xB05C,
	835:   0xB05E,
	836:   0xB05F,
	837:   0xB060,
	838:   0xB061,
	839:   0xB062,
	840:   0xB063,
	841:   0xB064,
	842:   0xB065,
	843:   0xB066,
	844:   0xB067,
	845:   0xB068,
	846:   0xB069,
	847:   0xB06A,
	848:   0xB06B,
	849:   0xB06C,
	850:   0xB06D,
	851:   0xB06E,
	852:   0xB06F,
	853:   0xB070,
	854:   0xB071,
	855:   0xB072,
	856:   0xB073,
	857:   0xB074,
	858:   0xB075,
	859:   0xB076,
	860:   0xB077,
	861:   0xB078,
	862:   0xB079,
	863:   0xB07A,
	864:   0xB07B,
	865:   0xB07E,
	866:   0xB07F,
	867:   0xB081,
	868:   0xB082,
	869:   0xB083,
	870:   0xB085,
	871:   0xB086,
	872:   0xB087,
	873:   0xB088,
	874:   0xB089,
	875:   0xB08A,
	876:   0xB08B,
	877:   0xB08E,
	878:   0xB090,
	879:   0xB092,
	880:   0xB093,
	881:   0xB094,
	882:   0xB095,
	883:   0xB096,
	884:   0xB097,
	885:   0xB09B,
	886:   0xB09D,
	887:   0xB09E,
	888:   0xB0A3,
	889:   0xB0A4,
	890:   0xB0A5,
	891:   0xB0A6,
	892:   0xB0A7,
	893:   0xB0AA,
	894:   0xB0B0,
	895:   0xB0B2,
	896:   0xB0B6,
	897:   0xB0B7,
	898:   0xB0B9,
	899:   0xB0BA,
	900:   0xB0BB,
	901:   0xB0BD,
	902:   0xB0BE,
	903:   0xB0BF,
	904:   0xB0C0,
	905:   0xB0C1,
	906:   0xB0C2,
	907:   0xB0C3,
	908:   0xB0C6,
	909:   0xB0CA,
	910:   0xB0CB,
	911:   0xB0CC,
	912:   0xB0CD,
	913:   0xB0CE,
	914:   0xB0CF,
	915:   0xB0D2,
	916:   0xB0D3,
	917:   0xB0D5,
	918:   0xB0D6,
	919:   0xB0D7,
	920:   0xB0D9,
	921:   0xB0DA,
	922:   0xB0DB,
	923:   0xB0DC,
	924:   0xB0DD,
	925:   0xB0DE,
	926:   0xB0DF,
	927:   0xB0E1,
	928:   0xB0E2,
	929:   0xB0E3,
	930:   0xB0E4,
	931:   0xB0E6,
	932:   0xB0E7,
	933:   0xB0E8,
	934:   0xB0E9,
	935:   0xB0EA,
	936:   0xB0EB,
	937:   0xB0EC,
	938:   0xB0ED,
	939:   0xB0EE,
	940:   0xB0EF,
	941:   0xB0F0,
	942:   0xB0F1,
	943:   0xB0F2,
	944:   0xB0F3,
	945:   0xB0F4,
	946:   0xB0F5,
	947:   0xB0F6,
	948:   0xB0F7,
	949:   0xB0F8,
	950:   0xB0F9,
	951:   0xB0FA,
	952:   0xB0FB,
	953:   0xB0FC,
	954:   0xB0FD,
	955:   0xB0FE,
	956:   0xB0FF,
	957:   0xB100,
	958:   0xB101,
	959:   0xB102,
	960:   0xB103,
	961:   0xB104,
	962:   0xB105,
	963:   0xB106,
	964:   0xB107,
	965:   0xB10A,
	966:   0xB10D,
	967:   0xB10E,
	968:   0xB10F,
	969:   0xB111,
	970:   0xB114,
	971:   0xB115,
	972:   0xB116,
	973:   0xB117,
	974:   0xB11A,
	975:   0xB11E,
	976:   0xB11F,
	977:   0xB120,
	978:   0xB121,
	979:   0xB122,
	980:   0xB126,
	981:   0xB127,
	982:   0xB129,
	983:   0xB12A,
	984:   0xB12B,
	985:   0xB12D,
	986:   0xB12E,
	987:   0xB12F,
	988:   0xB130,
	989:   0xB131,
	990:   0xB132,
	991:   0xB133,
	992:   0xB136,
	993:   0xB13A,
	994:   0xB13B,
	995:   0xB13C,
	996:   0xB13D,
	997:   0xB13E,
	998:   0xB13F,
	999:   0xB142,
	1000:  0xB143,
	1001:  0xB145,
	1002:  0xB146,
	1003:  0xB147,
	1004:  0xB149,
	1005:  0xB14A,
	1006:  0xB14B,
	1007:  0xB14C,
	1008:  0xB14D,
	1009:  0xB14E,
	1010:  0xB14F,
	1011:  0xB152,
	1012:  0xB153,
	1013:  0xB156,
	1014:  0xB157,
	1015:  0xB159,
	1016:  0xB15A,
	1017:  0xB15B,
	1018:  0xB15D,
	1019:  0xB15E,
	1020:  0xB15F,
	1021:  0xB161,
	1022:  0xB162,
	1023:  0xB163,
	1024:  0xB164,
	1025:  0xB165,
	1026:  0xB166,
	1027:  0xB167,
	1028:  0xB168,
	1029:  0xB169,
	1030:  0xB16A,
	1031:  0xB16B,
	1032:  0xB16C,
	1033:  0xB16D,
	1034:  0xB16E,
	1035:  0xB16F,
	1036:  0xB170,
	1037:  0xB171,
	1038:  0xB172,
	1039:  0xB173,
	1040:  0xB174,
	1041:  0xB175,
	1042:  0xB176,
	1043:  0xB177,
	1044:  0xB17A,
	1045:  0xB17B,
	1046:  0xB17D,
	1047:  0xB17E,
	1048:  0xB17F,
	1049:  0xB181,
	1050:  0xB183,
	1051:  0xB184,
	1052:  0xB185,
	1053:  0xB186,
	1054:  0xB187,
	1055:  0xB18A,
	1056:  0xB18C,
	1057:  0xB18E,
	1058:  0xB18F,
	1059:  0xB190,
	1060:  0xB191,
	1061:  0xB195,
	1062:  0xB196,
	1063:  0xB197,
	1064:  0xB199,
	1065:  0xB19A,
	1066:  0xB19B,
	1067:  0xB19D,
	1068:  0xB19E,
	1069:  0xB19F,
	1070:  0xB1A0,
	1071:  0xB1A1,
	1072:  0xB1A2,
	1073:  0xB1A3,
	1074:  0xB1A4,
	1075:  0xB1A5,
	1076:  0xB1A6,
	1077:  0xB1A7,
	1078:  0xB1A9,
	1079:  0xB1AA,
	1080:  0xB1AB,
	1081:  0xB1AC,
	1082:  0xB1AD,
	1083:  0xB1AE,
	1084:  0xB1AF,
	1085:  0xB1B0,
	1086:  0xB1B1,
	1087:  0xB1B2,
	1088:  0xB1B3,
	1089:  0xB1B4,
	1090:  0xB1B5,
	1091:  0xB1B6,
	1092:  0xB1B7,
	1093:  0xB1B8,
	1094:  0xB1B9,
	1095:  0xB1BA,
	1096:  0xB1BB,
	1097:  0xB1BC,
	1098:  0xB1BD,
	1099:  0xB1BE,
	1100:  0xB1BF,
	1101:  0xB1C0,
	1102:  0xB1C1,
	1103:  0xB1C2,
	1104:  0xB1C3,
	1105:  0xB1C4,
	1106:  0xB1C5,
	1107:  0xB1C6,
	1108:  0xB1C7,
	1109:  0xB1C8,
	1110:  0xB1C9,
	1111:  0xB1CA,
	1112:  0xB1CB,
	1113:  0xB1CD,
	1114:  0xB1CE,
	1115:  0xB1CF,
	1116:  0xB1D1,
	1117:  0xB1D2,
	1118:  0xB1D3,
	1119:  0xB1D5,
	1120:  0xB1D6,
	1121:  0xB1D7,
	1122:  0xB1D8,
	1123:  0xB1D9,
	1124:  0xB1DA,
	1125:  0xB1DB,
	1126:  0xB1DE,
	1127:  0xB1E0,
	1128:  0xB1E1,
	1129:  0xB1E2,
	1130:  0xB1E3,
	1131:  0xB1E4,
	1132:  0xB1E5,
	1133:  0xB1E6,
	1134:  0xB1E7,
	1135:  0xB1EA,
	1136:  0xB1EB,
	1137:  0xB1ED,
	1138:  0xB1EE,
	1139:  0xB1EF,
	1140:  0xB1F1,
	1141:  0xB1F2,
	1142:  0xB1F3,
	1143:  0xB1F4,
	1144:  0xB1F5,
	1145:  0xB1F6,
	1146:  0xB1F7,
	1147:  0xB1F8,
	1148:  0xB1FA,
	1149:  0xB1FC,
	1150:  0xB1FE,
	1151:  0xB1FF,
	1152:  0xB200,
	1153:  0xB201,
	1154:  0xB202,
	1155:  0xB203,
	1156:  0xB206,
	1157:  0xB207,
	1158:  0xB209,
	1159:  0xB20A,
	1160:  0xB20D,
	1161:  0xB20E,
	1162:  0xB20F,
	1163:  0xB210,
	1164:  0xB211,
	1165:  0xB212,
	1166:  0xB213,
	1167:  0xB216,
	1168:  0xB218,
	1169:  0xB21A,
	1170:  0xB21B,
	1171:  0xB21C,
	1172:  0xB21D,
	1173:  0xB21E,
	1174:  0xB21F,
	1175:  0xB221,
	1176:  0xB222,
	1177:  0xB223,
	1178:  0xB224,
	1179:  0xB225,
	1180:  0xB226,
	1181:  0xB227,
	1182:  0xB228,
	1183:  0xB229,
	1184:  0xB22A,
	1185:  0xB22B,
	1186:  0xB22C,
	1187:  0xB22D,
	1188:  0xB22E,
	1189:  0xB22F,
	1190:  0xB230,
	1191:  0xB231,
	1192:  0xB232,
	1193:  0xB233,
	1194:  0xB235,
	1195:  0xB236,
	1196:  0xB237,
	1197:  0xB238,
	1198:  0xB239,
	1199:  0xB23A,
	1200:  0xB23B,
	1201:  0xB23D,
	1202:  0xB23E,
	1203:  0xB23F,
	1204:  0xB240,
	1205:  0xB241,
	1206:  0xB242,
	1207:  0xB243,
	1208:  0xB244,
	1209:  0xB245,
	1210:  0xB246,
	1211:  0xB247,
	1212:  0xB248,
	1213:  0xB249,
	1214:  0xB24A,
	1215:  0xB24B,
	1216:  0xB24C,
	1217:  0xB24D,
	1218:  0xB24E,
	1219:  0xB24F,
	1220:  0xB250,
	1221:  0xB251,
	1222:  0xB252,
	1223:  0xB253,
	1224:  0xB254,
	1225:  0xB255,
	1226:  0xB256,
	1227:  0xB257,
	1228:  0xB259,
	1229:  0xB25A,
	1230:  0xB25B,
	1231:  0xB25D,
	1232:  0xB25E,
	1233:  0xB25F,
	1234:  0xB261,
	1235:  0xB262,
	1236:  0xB263,
	1237:  0xB264,
	1238:  0xB265,
	1239:  0xB266,
	1240:  0xB267,
	1241:  0xB26A,
	1242:  0xB26B,
	1243:  0xB26C,
	1244:  0xB26D,
	1245:  0xB26E,
	1246:  0xB26F,
	1247:  0xB270,
	1248:  0xB271,
	1249:  0xB272,
	1250:  0xB273,
	1251:  0xB276,
	1252:  0xB277,
	1253:  0xB278,
	1254:  0xB279,
	1255:  0xB27A,
	1256:  0xB27B,
	1257:  0xB27D,
	1258:  0xB27E,
	1259:  0xB27F,
	1260:  0xB280,
	1261:  0xB281,
	1262:  0xB282,
	1263:  0xB283,
	1264:  0xB286,
	1265:  0xB287,
	1266:  0xB288,
	1267:  0xB28A,
	1268:  0xB28B,
	1269:  0xB28C,
	1270:  0xB28D,
	1271:  0xB28E,
	1272:  0xB28F,
	1273:  0xB292,
	1274:  0xB293,
	1275:  0xB295,
	1276:  0xB296,
	1277:  0xB297,
	1278:  0xB29B,
	1279:  0xB29C,
	1280:  0xB29D,
	1281:  0xB29E,
	1282:  0xB29F,
	1283:  0xB2A2,
	1284:  0xB2A4,
	1285:  0xB2A7,
	1286:  0xB2A8,
	1287:  0xB2A9,
	1288:  0xB2AB,
	1289:  0xB2AD,
	1290:  0xB2AE,
	1291:  0xB2AF,
	1292:  0xB2B1,
	1293:  0xB2B2,
	1294:  0xB2B3,
	1295:  0xB2B5,
	1296:  0xB2B6,
	1297:  0xB2B7,
	1298:  0xB2B8,
	1299:  0xB2B9,
	1300:  0xB2BA,
	1301:  0xB2BB,
	1302:  0xB2BC,
	1303:  0xB2BD,
	1304:  0xB2BE,
	1305:  0xB2BF,
	1306:  0xB2C0,
	1307:  0xB2C1,
	1308:  0xB2C2,
	1309:  0xB2C3,
	1310:  0xB2C4,
	1311:  0xB2C5,
	1312:  0xB2C6,
	1313:  0xB2C7,
	1314:  0xB2CA,
	1315:  0xB2CB,
	1316:  0xB2CD,
	1317:  0xB2CE,
	1318:  0xB2CF,
	1319:  0xB2D1,
	1320:  0xB2D3,
	1321:  0xB2D4,
	1322:  0xB2D5,
	1323:  0xB2D6,
	1324:  0xB2D7,
	1325:  0xB2DA,
	1326:  0xB2DC,
	1327:  0xB2DE,
	1328:  0xB2DF,
	1329:  0xB2E0,
	1330:  0xB2E1,
	1331:  0xB2E3,
	1332:  0xB2E7,
	1333:  0xB2E9,
	1334:  0xB2EA,
	1335:  0xB2F0,
	1336:  0xB2F1,
	1337:  0xB2F2,
	1338:  0xB2F6,
	1339:  0xB2FC,
	1340:  0xB2FD,
	1341:  0xB2FE,
	1342:  0xB302,
	1343:  0xB303,
	1344:  0xB305,
	1345:  0xB306,
	1346:  0xB307,
	1347:  0xB309,
	1348:  0xB30A,
	1349:  0xB30B,
	1350:  0xB30C,
	1351:  0xB30D,
	1352:  0xB30E,
	1353:  0xB30F,
	1354:  0xB312,
	1355:  0xB316,
	1356:  0xB317,
	1357:  0xB318,
	1358:  0xB319,
	1359:  0xB31A,
	1360:  0xB31B,
	1361:  0xB31D,
	1362:  0xB31E,
	1363:  0xB31F,
	1364:  0xB320,
	1365:  0xB321,
	1366:  0xB322,
	1367:  0xB323,
	1368:  0xB324,
	1369:  0xB325,
	1370:  0xB326,
	1371:  0xB327,
	1372:  0xB328,
	1373:  0xB329,
	1374:  0xB32A,
	1375:  0xB32B,
	1376:  0xB32C,
	1377:  0xB32D,
	1378:  0xB32E,
	1379:  0xB32F,
	1380:  0xB330,
	1381:  0xB331,
	1382:  0xB332,
	1383:  0xB333,
	1384:  0xB334,
	1385:  0xB335,
	1386:  0xB336,
	1387:  0xB337,
	1388:  0xB338,
	1389:  0xB339,
	1390:  0xB33A,
	1391:  0xB33B,
	1392:  0xB33C,
	1393:  0xB33D,
	1394:  0xB33E,
	1395:  0xB33F,
	1396:  0xB340,
	1397:  0xB341,
	1398:  0xB342,
	1399:  0xB343,
	1400:  0xB344,
	1401:  0xB345,
	1402:  0xB346,
	1403:  0xB347,
	1404:  0xB348,
	1405:  0xB349,
	1406:  0xB34A,
	1407:  0xB34B,
	1408:  0xB34C,
	1409:  0xB34D,
	1410:  0xB34E,
	1411:  0xB34F,
	1412:  0xB350,
	1413:  0xB351,
	1414:  0xB352,
	1415:  0xB353,
	1416:  0xB357,
	1417:  0xB359,
	1418:  0xB35A,
	1419:  0xB35D,
	1420:  0xB360,
	1421:  0xB361,
	1422:  0xB362,
	1423:  0xB363,
	1424:  0xB366,
	1425:  0xB368,
	1426:  0xB36A,
	1427:  0xB36C,
	1428:  0xB36D,
	1429:  0xB36F,
	1430:  0xB372,
	1431:  0xB373,
	1432:  0xB375,
	1433:  0xB376,
	1434:  0xB377,
	1435:  0xB379,
	1436:  0xB37A,
	1437:  0xB37B,
	1438:  0xB37C,
	1439:  0xB37D,
	1440:  0xB37E,
	1441:  0xB37F,
	1442:  0xB382,
	1443:  0xB386,
	1444:  0xB387,
	1445:  0xB388,
	1446:  0xB389,
	1447:  0xB38A,
	1448:  0xB38B,
	1449:  0xB38D,
	1450:  0xB38E,
	1451:  0xB38F,
	1452:  0xB391,
	1453:  0xB392,
	1454:  0xB393,
	1455:  0xB395,
	1456:  0xB396,
	1457:  0xB397,
	1458:  0xB398,
	1459:  0xB399,
	1460:  0xB39A,
	1461:  0xB39B,
	1462:  0xB39C,
	1463:  0xB39D,
	1464:  0xB39E,
	1465:  0xB39F,
	1466:  0xB3A2,
	1467:  0xB3A3,
	1468:  0xB3A4,
	1469:  0xB3A5,
	1470:  0xB3A6,
	1471:  0xB3A7,
	1472:  0xB3A9,
	1473:  0xB3AA,
	1474:  0xB3AB,
	1475:  0xB3AD,
	1476:  0xB3AE,
	1477:  0xB3AF,
	1478:  0xB3B0,
	1479:  0xB3B1,
	1480:  0xB3B2,
	1481:  0xB3B3,
	1482:  0xB3B4,
	1483:  0xB3B5,
	1484:  0xB3B6,
	1485:  0xB3B7,
	1486:  0xB3B8,
	1487:  0xB3B9,
	1488:  0xB3BA,
	1489:  0xB3BB,
	1490:  0xB3BC,
	1491:  0xB3BD,
	1492:  0xB3BE,
	1493:  0xB3BF,
	1494:  0xB3C0,
	1495:  0xB3C1,
	1496:  0xB3C2,
	1497:  0xB3C3,
	1498:  0xB3C6,
	1499:  0xB3C7,
	1500:  0xB3C9,
	1501:  0xB3CA,
	1502:  0xB3CD,
	1503:  0xB3CF,
	1504:  0xB3D1,
	1505:  0xB3D2,
	1506:  0xB3D3,
	1507:  0xB3D6,
	1508:  0xB3D8,
	1509:  0xB3DA,
	1510:  0xB3DC,
	1511:  0xB3DE,
	1512:  0xB3DF,
	1513:  0xB3E1,
	1514:  0xB3E2,
	1515:  0xB3E3,
	1516:  0xB3E5,
	1517:  0xB3E6,
	1518:  0xB3E7,
	1519:  0xB3E9,
	1520:  0xB3EA,
	1521:  0xB3EB,
	1522:  0xB3EC,
	1523:  0xB3ED,
	1524:  0xB3EE,
	1525:  0xB3EF,
	1526:  0xB3F0,
	1527:  0xB3F1,
	1528:  0xB3F2,
	1529:  0xB3F3,
	1530:  0xB3F4,
	1531:  0xB3F5,
	1532:  0xB3F6,
	1533:  0xB3F7,
	1534:  0xB3F8,
	1535:  0xB3F9,
	1536:  0xB3FA,
	1537:  0xB3FB,
	1538:  0xB3FD,
	1539:  0xB3FE,
	1540:  0xB3FF,
	1541:  0xB400,
	1542:  0xB401,
	1543:  0xB402,
	1544:  0xB403,
	1545:  0xB404,
	1546:  0xB405,
	1547:  0xB406,
	1548:  0xB407,
	1549:  0xB408,
	1550:  0xB409,
	1551:  0xB40A,
	1552:  0xB40B,
	1553:  0xB40C,
	1554:  0xB40D,
	1555:  0xB40E,
	1556:  0xB40F,
	1557:  0xB411,
	1558:  0xB412,
	1559:  0xB413,
	1560:  0xB414,
	1561:  0xB415,
	1562:  0xB416,
	1563:  0xB417,
	1564:  0xB419,
	1565:  0xB41A,
	1566:  0xB41B,
	1567:  0xB41D,
	1568:  0xB41E,
	1569:  0xB41F,
	1570:  0xB421,
	1571:  0xB422,
	1572:  0xB423,
	1573:  0xB424,
	1574:  0xB425,
	1575:  0xB426,
	1576:  0xB427,
	1577:  0xB42A,
	1578:  0xB42C,
	1579:  0xB42D,
	1580:  0xB42E,
	1581:  0xB42F,
	1582:  0xB430,
	1583:  0xB431,
	1584:  0xB432,
	1585:  0xB433,
	1586:  0xB435,
	1587:  0xB436,
	1588:  0xB437,
	1589:  0xB438,
	1590:  0xB439,
	1591:  0xB43A,
	1592:  0xB43B,
	1593:  0xB43C,
	1594:  0xB43D,
	1595:  0xB43E,
	1596:  0xB43F,
	1597:  0xB440,
	1598:  0xB441,
	1599:  0xB442,
	1600:  0xB443,
	1601:  0xB444,
	1602:  0xB445,
	1603:  0xB446,
	1604:  0xB447,
	1605:  0xB448,
	1606:  0xB449,
	1607:  0xB44A,
	1608:  0xB44B,
	1609:  0xB44C,
	1610:  0xB44D,
	1611:  0xB44E,
	1612:  0xB44F,
	1613:  0xB452,
	1614:  0xB453,
	1615:  0xB455,
	1616:  0xB456,
	1617:  0xB457,
	1618:  0xB459,
	1619:  0xB45A,
	1620:  0xB45B,
	1621:  0xB45C,
	1622:  0xB45D,
	1623:  0xB45E,
	1624:  0xB45F,
	1625:  0xB462,
	1626:  0xB464,
	1627:  0xB466,
	1628:  0xB467,
	1629:  0xB468,
	1630:  0xB469,
	1631:  0xB46A,
	1632:  0xB46B,
	1633:  0xB46D,
	1634:  0xB46E,
	1635:  0xB46F,
	1636:  0xB470,
	1637:  0xB471,
	1638:  0xB472,
	1639:  0xB473,
	1640:  0xB474,
	1641:  0xB475,
	1642:  0xB476,
	1643:  0xB477,
	1644:  0xB478,
	1645:  0xB479,
	1646:  0xB47A,
	1647:  0xB47B,
	1648:  0xB47C,
	1649:  0xB47D,
	1650:  0xB47E,
	1651:  0xB47F,
	1652:  0xB481,
	1653:  0xB482,
	1654:  0xB483,
	1655:  0xB484,
	1656:  0xB485,
	1657:  0xB486,
	1658:  0xB487,
	1659:  0xB489,
	1660:  0xB48A,
	1661:  0xB48B,
	1662:  0xB48C,
	1663:  0xB48D,
	1664:  0xB48E,
	1665:  0xB48F,
	1666:  0xB490,
	1667:  0xB491,
	1668:  0xB492,
	1669:  0xB493,
	1670:  0xB494,
	1671:  0xB495,
	1672:  0xB496,
	1673:  0xB497,
	1674:  0xB498,
	1675:  0xB499,
	1676:  0xB49A,
	1677:  0xB49B,
	1678:  0xB49C,
	1679:  0xB49E,
	1680:  0xB49F,
	1681:  0xB4A0,
	1682:  0xB4A1,
	1683:  0xB4A2,
	1684:  0xB4A3,
	1685:  0xB4A5,
	1686:  0xB4A6,
	1687:  0xB4A7,
	1688:  0xB4A9,
	1689:  0xB4AA,
	1690:  0xB4AB,
	1691:  0xB4AD,
	1692:  0xB4AE,
	1693:  0xB4AF,
	1694:  0xB4B0,
	1695:  0xB4B1,
	1696:  0xB4B2,
	1697:  0xB4B3,
	1698:  0xB4B4,
	1699:  0xB4B6,
	1700:  0xB4B8,
	1701:  0xB4BA,
	1702:  0xB4BB,
	1703:  0xB4BC,
	1704:  0xB4BD,
	1705:  0xB4BE,
	1706:  0xB4BF,
	1707:  0xB4C1,
	1708:  0xB4C2,
	1709:  0xB4C3,
	1710:  0xB4C5,
	1711:  0xB4C6,
	1712:  0xB4C7,
	1713:  0xB4C9,
	1714:  0xB4CA,
	1715:  0xB4CB,
	1716:  0xB4CC,
	1717:  0xB4CD,
	1718:  0xB4CE,
	1719:  0xB4CF,
	1720:  0xB4D1,
	1721:  0xB4D2,
	1722:  0xB4D3,
	1723:  0xB4D4,
	1724:  0xB4D6,
	1725:  0xB4D7,
	1726:  0xB4D8,
	1727:  0xB4D9,
	1728:  0xB4DA,
	1729:  0xB4DB,
	1730:  0xB4DE,
	1731:  0xB4DF,
	1732:  0xB4E1,
	1733:  0xB4E2,
	1734:  0xB4E5,
	1735:  0xB4E7,
	1736:  0xB4E8,
	1737:  0xB4E9,
	1738:  0xB4EA,
	1739:  0xB4EB,
	1740:  0xB4EE,
	1741:  0xB4F0,
	1742:  0xB4F2,
	1743:  0xB4F3,
	1744:  0xB4F4,
	1745:  0xB4F5,
	1746:  0xB4F6,
	1747:  0xB4F7,
	1748:  0xB4F9,
	1749:  0xB4FA,
	1750:  0xB4FB,
	1751:  0xB4FC,
	1752:  0xB4FD,
	1753:  0xB4FE,
	1754:  0xB4FF,
	1755:  0xB500,
	1756:  0xB501,
	1757:  0xB502,
	1758:  0xB503,
	1759:  0xB504,
	1760:  0xB505,
	1761:  0xB506,
	1762:  0xB507,
	1763:  0xB508,
	1764:  0xB509,
	1765:  0xB50A,
	1766:  0xB50B,
	1767:  0xB50C,
	1768:  0xB50D,
	1769:  0xB50E,
	1770:  0xB50F,
	1771:  0xB510,
	1772:  0xB511,
	1773:  0xB512,
	1774:  0xB513,
	1775:  0xB516,
	1776:  0xB517,
	1777:  0xB519,
	1778:  0xB51A,
	1779:  0xB51D,
	1780:  0xB51E,
	1781:  0xB51F,
	1782:  0xB520,
	1783:  0xB521,
	1784:  0xB522,
	1785:  0xB523,
	1786:  0xB526,
	1787:  0xB52B,
	1788:  0xB52C,
	1789:  0xB52D,
	1790:  0xB52E,
	1791:  0xB52F,
	1792:  0xB532,
	1793:  0xB533,
	1794:  0xB535,
	1795:  0xB536,
	1796:  0xB537,
	1797:  0xB539,
	1798:  0xB53A,
	1799:  0xB53B,
	1800:  0xB53C,
	1801:  0xB53D,
	1802:  0xB53E,
	1803:  0xB53F,
	1804:  0xB542,
	1805:  0xB546,
	1806:  0xB547,
	1807:  0xB548,
	1808:  0xB549,
	1809:  0xB54A,
	1810:  0xB54E,
	1811:  0xB54F,
	1812:  0xB551,
	1813:  0xB552,
	1814:  0xB553,
	1815:  0xB555,
	1816:  0xB556,
	1817:  0xB557,
	1818:  0xB558,
	1819:  0xB559,
	1820:  0xB55A,
	1821:  0xB55B,
	1822:  0xB55E,
	1823:  0xB562,
	1824:  0xB563,
	1825:  0xB564,
	1826:  0xB565,
	1827:  0xB566,
	1828:  0xB567,
	1829:  0xB568,
	1830:  0xB569,
	1831:  0xB56A,
	1832:  0xB56B,
	1833:  0xB56C,
	1834:  0xB56D,
	1835:  0xB56E,
	1836:  0xB56F,
	1837:  0xB570,
	1838:  0xB571,
	1839:  0xB572,
	1840:  0xB573,
	1841:  0xB574,
	1842:  0xB575,
	1843:  0xB576,
	1844:  0xB577,
	1845:  0xB578,
	1846:  0xB579,
	1847:  0xB57A,
	1848:  0xB57B,
	1849:  0xB57C,
	1850:  0xB57D,
	1851:  0xB57E,
	1852:  0xB57F,
	1853:  0xB580,
	1854:  0xB581,
	1855:  0xB582,
	1856:  0xB583,
	1857:  0xB584,
	1858:  0xB585,
	1859:  0xB586,
	1860:  0xB587,
	1861:  0xB588,
	1862:  0xB589,
	1863:  0xB58A,
	1864:  0xB58B,
	1865:  0xB58C,
	1866:  0xB58D,
	1867:  0xB58E,
	1868:  0xB58F,
	1869:  0xB590,
	1870:  0xB591,
	1871:  0xB592,
	1872:  0xB593,
	1873:  0xB594,
	1874:  0xB595,
	1875:  0xB596,
	1876:  0xB597,
	1877:  0xB598,
	1878:  0xB599,
	1879:  0xB59A,
	1880:  0xB59B,
	1881:  0xB59C,
	1882:  0xB59D,
	1883:  0xB59E,
	1884:  0xB59F,
	1885:  0xB5A2,
	1886:  0xB5A3,
	1887:  0xB5A5,
	1888:  0xB5A6,
	1889:  0xB5A7,
	1890:  0xB5A9,
	1891:  0xB5AC,
	1892:  0xB5AD,
	1893:  0xB5AE,
	1894:  0xB5AF,
	1895:  0xB5B2,
	1896:  0xB5B6,
	1897:  0xB5B7,
	1898:  0xB5B8,
	1899:  0xB5B9,
	1900:  0xB5BA,
	1901:  0xB5BE,
	1902:  0xB5BF,
	1903:  0xB5C1,
	1904:  0xB5C2,
	1905:  0xB5C3,
	1906:  0xB5C5,
	1907:  0xB5C6,
	1908:  0xB5C7,
	1909:  0xB5C8,
	1910:  0xB5C9,
	1911:  0xB5CA,
	1912:  0xB5CB,
	1913:  0xB5CE,
	1914:  0xB5D2,
	1915:  0xB5D3,
	1916:  0xB5D4,
	1917:  0xB5D5,
	1918:  0xB5D6,
	1919:  0xB5D7,
	1920:  0xB5D9,
	1921:  0xB5DA,
	1922:  0xB5DB,
	1923:  0xB5DC,
	1924:  0xB5DD,
	1925:  0xB5DE,
	1926:  0xB5DF,
	1927:  0xB5E0,
	1928:  0xB5E1,
	1929:  0xB5E2,
	1930:  0xB5E3,
	1931:  0xB5E4,
	1932:  0xB5E5,
	1933:  0xB5E6,
	1934:  0xB5E7,
	1935:  0xB5E8,
	1936:  0xB5E9,
	1937:  0xB5EA,
	1938:  0xB5EB,
	1939:  0xB5ED,
	1940:  0xB5EE,
	1941:  0xB5EF,
	1942:  0xB5F0,
	1943:  0xB5F1,
	1944:  0xB5F2,
	1945:  0xB5F3,
	1946:  0xB5F4,
	1947:  0xB5F5,
	1948:  0xB5F6,
	1949:  0xB5F7,
	1950:  0xB5F8,
	1951:  0xB5F9,
	1952:  0xB5FA,
	1953:  0xB5FB,
	1954:  0xB5FC,
	1955:  0xB5FD,
	1956:  0xB5FE,
	1957:  0xB5FF,
	1958:  0xB600,
	1959:  0xB601,
	1960:  0xB602,
	1961:  0xB603,
	1962:  0xB604,
	1963:  0xB605,
	1964:  0xB606,
	1965:  0xB607,
	1966:  0xB608,
	1967:  0xB609,
	1968:  0xB60A,
	1969:  0xB60B,
	1970:  0xB60C,
	1971:  0xB60D,
	1972:  0xB60E,
	1973:  0xB60F,
	1974:  0xB612,
	1975:  0xB613,
	1976:  0xB615,
	1977:  0xB616,
	1978:  0xB617,
	1979:  0xB619,
	1980:  0xB61A,
	1981:  0xB61B,
	1982:  0xB61C,
	1983:  0xB61D,
	1984:  0xB61E,
	1985:  0xB61F,
	1986:  0xB620,
	1987:  0xB621,
	1988:  0xB622,
	1989:  0xB623,
	1990:  0xB624,
	1991:  0xB626,
	1992:  0xB627,
	1993:  0xB628,
	1994:  0xB629,
	1995:  0xB62A,
	1996:  0xB62B,
	1997:  0xB62D,
	1998:  0xB62E,
	1999:  0xB62F,
	2000:  0xB630,
	2001:  0xB631,
	2002:  0xB632,
	2003:  0xB633,
	2004:  0xB635,
	2005:  0xB636,
	2006:  0xB637,
	2007:  0xB638,
	2008:  0xB639,
	2009:  0xB63A,
	2010:  0xB63B,
	2011:  0xB63C,
	2012:  0xB63D,
	2013:  0xB63E,
	2014:  0xB63F,
	2015:  0xB640,
	2016:  0xB641,
	2017:  0xB642,
	2018:  0xB643,
	2019:  0xB644,
	2020:  0xB645,
	2021:  0xB646,
	2022:  0xB647,
	2023:  0xB649,
	2024:  0xB64A,
	2025:  0xB64B,
	2026:  0xB64C,
	2027:  0xB64D,
	2028:  0xB64E,
	2029:  0xB64F,
	2030:  0xB650,
	2031:  0xB651,
	2032:  0xB652,
	2033:  0xB653,
	2034:  0xB654,
	2035:  0xB655,
	2036:  0xB656,
	2037:  0xB657,
	2038:  0xB658,
	2039:  0xB659,
	2040:  0xB65A,
	2041:  0xB65B,
	2042:  0xB65C,
	2043:  0xB65D,
	2044:  0xB65E,
	2045:  0xB65F,
	2046:  0xB660,
	2047:  0xB661,
	2048:  0xB662,
	2049:  0xB663,
	2050:  0xB665,
	2051:  0xB666,
	2052:  0xB667,
	2053:  0xB669,
	2054:  0xB66A,
	2055:  0xB66B,
	2056:  0xB66C,
	2057:  0xB66D,
	2058:  0xB66E,
	2059:  0xB66F,
	2060:  0xB670,
	2061:  0xB671,
	2062:  0xB672,
	2063:  0xB673,
	2064:  0xB674,
	2065:  0xB675,
	2066:  0xB676,
	2067:  0xB677,
	2068:  0xB678,
	2069:  0xB679,
	2070:  0xB67A,
	2071:  0xB67B,
	2072:  0xB67C,
	2073:  0xB67D,
	2074:  0xB67E,
	2075:  0xB67F,
	2076:  0xB680,
	2077:  0xB681,
	2078:  0xB682,
	2079:  0xB683,
	2080:  0xB684,
	2081:  0xB685,
	2082:  0xB686,
	2083:  0xB687,
	2084:  0xB688,
	2085:  0xB689,
	2086:  0xB68A,
	2087:  0xB68B,
	2088:  0xB68C,
	2089:  0xB68D,
	2090:  0xB68E,
	2091:  0xB68F,
	2092:  0xB690,
	2093:  0xB691,
	2094:  0xB692,
	2095:  0xB693,
	2096:  0xB694,
	2097:  0xB695,
	2098:  0xB696,
	2099:  0xB697,
	2100:  0xB698,
	2101:  0xB699,
	2102:  0xB69A,
	2103:  0xB69B,
	2104:  0xB69E,
	2105:  0xB69F,
	2106:  0xB6A1,
	2107:  0xB6A2,
	2108:  0xB6A3,
	2109:  0xB6A5,
	2110:  0xB6A6,
	2111:  0xB6A7,
	2112:  0xB6A8,
	2113:  0xB6A9,
	2114:  0xB6AA,
	2115:  0xB6AD,
	2116:  0xB6AE,
	2117:  0xB6AF,
	2118:  0xB6B0,
	2119:  0xB6B2,
	2120:  0xB6B3,
	2121:  0xB6B4,
	2122:  0xB6B5,
	2123:  0xB6B6,
	2124:  0xB6B7,
	2125:  0xB6B8,
	2126:  0xB6B9,
	2127:  0xB6BA,
	2128:  0xB6BB,
	2129:  0xB6BC,
	2130:  0xB6BD,
	2131:  0xB6BE,
	2132:  0xB6BF,
	2133:  0xB6C0,
	2134:  0xB6C1,
	2135:  0xB6C2,
	2136:  0xB6C3,
	2137:  0xB6C4,
	2138:  0xB6C5,
	2139:  0xB6C6,
	2140:  0xB6C7,
	2141:  0xB6C8,
	2142:  0xB6C9,
	2143:  0xB6CA,
	2144:  0xB6CB,
	2145:  0xB6CC,
	2146:  0xB6CD,
	2147:  0xB6CE,
	2148:  0xB6CF,
	2149:  0xB6D0,
	2150:  0xB6D1,
	2151:  0xB6D2,
	2152:  0xB6D3,
	2153:  0xB6D5,
	2154:  0xB6D6,
	2155:  0xB6D7,
	2156:  0xB6D8,
	2157:  0xB6D9,
	2158:  0xB6DA,
	2159:  0xB6DB,
	2160:  0xB6DC,
	2161:  0xB6DD,
	2162:  0xB6DE,
	2163:  0xB6DF,
	2164:  0xB6E0,
	2165:  0xB6E1,
	2166:  0xB6E2,
	2167:  0xB6E3,
	2168:  0xB6E4,
	2169:  0xB6E5,
	2170:  0xB6E6,
	2171:  0xB6E7,
	2172:  0xB6E8,
	2173:  0xB6E9,
	2174:  0xB6EA,
	2175:  0xB6EB,
	2176:  0xB6EC,
	2177:  0xB6ED,
	2178:  0xB6EE,
	2179:  0xB6EF,
	2180:  0xB6F1,
	2181:  0xB6F2,
	2182:  0xB6F3,
	2183:  0xB6F5,
	2184:  0xB6F6,
	2185:  0xB6F7,
	2186:  0xB6F9,
	2187:  0xB6FA,
	2188:  0xB6FB,
	2189:  0xB6FC,
	2190:  0xB6FD,
	2191:  0xB6FE,
	2192:  0xB6FF,
	2193:  0xB702,
	2194:  0xB703,
	2195:  0xB704,
	2196:  0xB706,
	2197:  0xB707,
	2198:  0xB708,
	2199:  0xB709,
	2200:  0xB70A,
	2201:  0xB70B,
	2202:  0xB70C,
	2203:  0xB70D,
	2204:  0xB70E,
	2205:  0xB70F,
	2206:  0xB710,
	2207:  0xB711,
	2208:  0xB712,
	2209:  0xB713,
	2210:  0xB714,
	2211:  0xB715,
	2212:  0xB716,
	2213:  0xB717,
	2214:  0xB718,
	2215:  0xB719,
	2216:  0xB71A,
	2217:  0xB71B,
	2218:  0xB71C,
	2219:  0xB71D,
	2220:  0xB71E,
	2221:  0xB71F,
	2222:  0xB720,
	2223:  0xB721,
	2224:  0xB722,
	2225:  0xB723,
	2226:  0xB724,
	2227:  0xB725,
	2228:  0xB726,
	2229:  0xB727,
	2230:  0xB72A,
	2231:  0xB72B,
	2232:  0xB72D,
	2233:  0xB72E,
	2234:  0xB731,
	2235:  0xB732,
	2236:  0xB733,
	2237:  0xB734,
	2238:  0xB735,
	2239:  0xB736,
	2240:  0xB737,
	2241:  0xB73A,
	2242:  0xB73C,
	2243:  0xB73D,
	2244:  0xB73E,
	2245:  0xB73F,
	2246:  0xB740,
	2247:  0xB741,
	2248:  0xB742,
	2249:  0xB743,
	2250:  0xB745,
	2251:  0xB746,
	2252:  0xB747,
	2253:  0xB749,
	2254:  0xB74A,
	2255:  0xB74B,
	2256:  0xB74D,
	2257:  0xB74E,
	2258:  0xB74F,
	2259:  0xB750,
	2260:  0xB751,
	2261:  0xB752,
	2262:  0xB753,
	2263:  0xB756,
	2264:  0xB757,
	2265:  0xB758,
	2266:  0xB759,
	2267:  0xB75A,
	2268:  0xB75B,
	2269:  0xB75C,
	2270:  0xB75D,
	2271:  0xB75E,
	2272:  0xB75F,
	2273:  0xB761,
	2274:  0xB762,
	2275:  0xB763,
	2276:  0xB765,
	2277:  0xB766,
	2278:  0xB767,
	2279:  0xB769,
	2280:  0xB76A,
	2281:  0xB76B,
	2282:  0xB76C,
	2283:  0xB76D,
	2284:  0xB76E,
	2285:  0xB76F,
	2286:  0xB772,
	2287:  0xB774,
	2288:  0xB776,
	2289:  0xB777,
	2290:  0xB778,
	2291:  0xB779,
	2292:  0xB77A,
	2293:  0xB77B,
	2294:  0xB77E,
	2295:  0xB77F,
	2296:  0xB781,
	2297:  0xB782,
	2298:  0xB783,
	2299:  0xB785,
	2300:  0xB786,
	2301:  0xB787,
	2302:  0xB788,
	2303:  0xB789,
	2304:  0xB78A,
	2305:  0xB78B,
	2306:  0xB78E,
	2307:  0xB793,
	2308:  0xB794,
	2309:  0xB795,
	2310:  0xB79A,
	2311:  0xB79B,
	2312:  0xB79D,
	2313:  0xB79E,
	2314:  0xB79F,
	2315:  0xB7A1,
	2316:  0xB7A2,
	2317:  0xB7A3,
	2318:  0xB7A4,
	2319:  0xB7A5,
	2320:  0xB7A6,
	2321:  0xB7A7,
	2322:  0xB7AA,
	2323:  0xB7AE,
	2324:  0xB7AF,
	2325:  0xB7B0,
	2326:  0xB7B1,
	2327:  0xB7B2,
	2328:  0xB7B3,
	2329:  0xB7B6,
	2330:  0xB7B7,
	2331:  0xB7B9,
	2332:  0xB7BA,
	2333:  0xB7BB,
	2334:  0xB7BC,
	2335:  0xB7BD,
	2336:  0xB7BE,
	2337:  0xB7BF,
	2338:  0xB7C0,
	2339:  0xB7C1,
	2340:  0xB7C2,
	2341:  0xB7C3,
	2342:  0xB7C4,
	2343:  0xB7C5,
	2344:  0xB7C6,
	2345:  0xB7C8,
	2346:  0xB7CA,
	2347:  0xB7CB,
	2348:  0xB7CC,
	2349:  0xB7CD,
	2350:  0xB7CE,
	2351:  0xB7CF,
	2352:  0xB7D0,
	2353:  0xB7D1,
	2354:  0xB7D2,
	2355:  0xB7D3,
	2356:  0xB7D4,
	2357:  0xB7D5,
	2358:  0xB7D6,
	2359:  0xB7D7,
	2360:  0xB7D8,
	2361:  0xB7D9,
	2362:  0xB7DA,
	2363:  0xB7DB,
	2364:  0xB7DC,
	2365:  0xB7DD,
	2366:  0xB7DE,
	2367:  0xB7DF,
	2368:  0xB7E0,
	2369:  0xB7E1,
	2370:  0xB7E2,
	2371:  0xB7E3,
	2372:  0xB7E4,
	2373:  0xB7E5,
	2374:  0xB7E6,
	2375:  0xB7E7,
	2376:  0xB7E8,
	2377:  0xB7E9,
	2378:  0xB7EA,
	2379:  0xB7EB,
	2380:  0xB7EE,
	2381:  0xB7EF,
	2382:  0xB7F1,
	2383:  0xB7F2,
	2384:  0xB7F3,
	2385:  0xB7F5,
	2386:  0xB7F6,
	2387:  0xB7F7,
	2388:  0xB7F8,
	2389:  0xB7F9,
	2390:  0xB7FA,
	2391:  0xB7FB,
	2392:  0xB7FE,
	2393:  0xB802,
	2394:  0xB803,
	2395:  0xB804,
	2396:  0xB805,
	2397:  0xB806,
	2398:  0xB80A,
	2399:  0xB80B,
	2400:  0xB80D,
	2401:  0xB80E,
	2402:  0xB80F,
	2403:  0xB811,
	2404:  0xB812,
	2405:  0xB813,
	2406:  0xB814,
	2407:  0xB815,
	2408:  0xB816,
	2409:  0xB817,
	2410:  0xB81A,
	2411:  0xB81C,
	2412:  0xB81E,
	2413:  0xB81F,
	2414:  0xB820,
	2415:  0xB821,
	2416:  0xB822,
	2417:  0xB823,
	2418:  0xB826,
	2419:  0xB827,
	2420:  0xB829,
	2421:  0xB82A,
	2422:  0xB82B,
	2423:  0xB82D,
	2424:  0xB82E,
	2425:  0xB82F,
	2426:  0xB830,
	2427:  0xB831,
	2428:  0xB832,
	2429:  0xB833,
	2430:  0xB836,
	2431:  0xB83A,
	2432:  0xB83B,
	2433:  0xB83C,
	2434:  0xB83D,
	2435:  0xB83E,
	2436:  0xB83F,
	2437:  0xB841,
	2438:  0xB842,
	2439:  0xB843,
	2440:  0xB845,
	2441:  0xB846,
	2442:  0xB847,
	2443:  0xB848,
	2444:  0xB849,
	2445:  0xB84A,
	2446:  0xB84B,
	2447:  0xB84C,
	2448:  0xB84D,
	2449:  0xB84E,
	2450:  0xB84F,
	2451:  0xB850,
	2452:  0xB852,
	2453:  0xB854,
	2454:  0xB855,
	2455:  0xB856,
	2456:  0xB857,
	2457:  0xB858,
	2458:  0xB859,
	2459:  0xB85A,
	2460:  0xB85B,
	2461:  0xB85E,
	2462:  0xB85F,
	2463:  0xB861,
	2464:  0xB862,
	2465:  0xB863,
	2466:  0xB865,
	2467:  0xB866,
	2468:  0xB867,
	2469:  0xB868,
	2470:  0xB869,
	2471:  0xB86A,
	2472:  0xB86B,
	2473:  0xB86E,
	2474:  0xB870,
	2475:  0xB872,
	2476:  0xB873,
	2477:  0xB874,
	2478:  0xB875,
	2479:  0xB876,
	2480:  0xB877,
	2481:  0xB879,
	2482:  0xB87A,
	2483:  0xB87B,
	2484:  0xB87D,
	2485:  0xB87E,
	2486:  0xB87F,
	2487:  0xB880,
	2488:  0xB881,
	2489:  0xB882,
	2490:  0xB883,
	2491:  0xB884,
	2492:  0xB885,
	2493:  0xB886,
	2494:  0xB887,
	2495:  0xB888,
	2496:  0xB889,
	2497:  0xB88A,
	2498:  0xB88B,
	2499:  0xB88C,
	2500:  0xB88E,
	2501:  0xB88F,
	2502:  0xB890,
	2503:  0xB891,
	2504:  0xB892,
	2505:  0xB893,
	2506:  0xB894,
	2507:  0xB895,
	2508:  0xB896,
	2509:  0xB897,
	2510:  0xB898,
	2511:  0xB899,
	2512:  0xB89A,
	2513:  0xB89B,
	2514:  0xB89C,
	2515:  0xB89D,
	2516:  0xB89E,
	2517:  0xB89F,
	2518:  0xB8A0,
	2519:  0xB8A1,
	2520:  0xB8A2,
	2521:  0xB8A3,
	2522:  0xB8A4,
	2523:  0xB8A5,
	2524:  0xB8A6,
	2525:  0xB8A7,
	2526:  0xB8A9,
	2527:  0xB8AA,
	2528:  0xB8AB,
	2529:  0xB8AC,
	2530:  0xB8AD,
	2531:  0xB8AE,
	2532:  0xB8AF,
	2533:  0xB8B1,
	2534:  0xB8B2,
	2535:  0xB8B3,
	2536:  0xB8B5,
	2537:  0xB8B6,
	2538:  0xB8B7,
	2539:  0xB8B9,
	2540:  0xB8BA,
	2541:  0xB8BB,
	2542:  0xB8BC,
	2543:  0xB8BD,
	2544:  0xB8BE,
	2545:  0xB8BF,
	2546:  0xB8C2,
	2547:  0xB8C4,
	2548:  0xB8C6,
	2549:  0xB8C7,
	2550:  0xB8C8,
	2551:  0xB8C9,
	2552:  0xB8CA,
	2553:  0xB8CB,
	2554:  0xB8CD,
	2555:  0xB8CE,
	2556:  0xB8CF,
	2557:  0xB8D1,
	2558:  0xB8D2,
	2559:  0xB8D3,
	2560:  0xB8D5,
	2561:  0xB8D6,
	2562:  0xB8D7,
	2563:  0xB8D8,
	2564:  0xB8D9,
	2565:  0xB8DA,
	2566:  0xB8DB,
	2567:  0xB8DC,
	2568:  0xB8DE,
	2569:  0xB8E0,
	2570:  0xB8E2,
	2571:  0xB8E3,
	2572:  0xB8E4,
	2573:  0xB8E5,
	2574:  0xB8E6,
	2575:  0xB8E7,
	2576:  0xB8EA,
	2577:  0xB8EB,
	2578:  0xB8ED,
	2579:  0xB8EE,
	2580:  0xB8EF,
	2581:  0xB8F1,
	2582:  0xB8F2,
	2583:  0xB8F3,
	2584:  0xB8F4,
	2585:  0xB8F5,
	2586:  0xB8F6,
	2587:  0xB8F7,
	2588:  0xB8FA,
	2589:  0xB8FC,
	2590:  0xB8FE,
	2591:  0xB8FF,
	2592:  0xB900,
	2593:  0xB901,
	2594:  0xB902,
	2595:  0xB903,
	2596:  0xB905,
	2597:  0xB906,
	2598:  0xB907,
	2599:  0xB908,
	2600:  0xB909,
	2601:  0xB90A,
	2602:  0xB90B,
	2603:  0xB90C,
	2604:  0xB90D,
	2605:  0xB90E,
	2606:  0xB90F,
	2607:  0xB910,
	2608:  0xB911,
	2609:  0xB912,
	2610:  0xB913,
	2611:  0xB914,
	2612:  0xB915,
	2613:  0xB916,
	2614:  0xB917,
	2615:  0xB919,
	2616:  0xB91A,
	2617:  0xB91B,
	2618:  0xB91C,
	2619:  0xB91D,
	2620:  0xB91E,
	2621:  0xB91F,
	2622:  0xB921,
	2623:  0xB922,
	2624:  0xB923,
	2625:  0xB924,
	2626:  0xB925,
	2627:  0xB926,
	2628:  0xB927,
	2629:  0xB928,
	2630:  0xB929,
	2631:  0xB92A,
	2632:  0xB92B,
	2633:  0xB92C,
	2634:  0xB92D,
	2635:  0xB92E,
	2636:  0xB92F,
	2637:  0xB930,
	2638:  0xB931,
	2639:  0xB932,
	2640:  0xB933,
	2641:  0xB934,
	2642:  0xB935,
	2643:  0xB936,
	2644:  0xB937,
	2645:  0xB938,
	2646:  0xB939,
	2647:  0xB93A,
	2648:  0xB93B,
	2649:  0xB93E,
	2650:  0xB93F,
	2651:  0xB941,
	2652:  0xB942,
	2653:  0xB943,
	2654:  0xB945,
	2655:  0xB946,
	2656:  0xB947,
	2657:  0xB948,
	2658:  0xB949,
	2659:  0xB94A,
	2660:  0xB94B,
	2661:  0xB94D,
	2662:  0xB94E,
	2663:  0xB950,
	2664:  0xB952,
	2665:  0xB953,
	2666:  0xB954,
	2667:  0xB955,
	2668:  0xB956,
	2669:  0xB957,
	2670:  0xB95A,
	2671:  0xB95B,
	2672:  0xB95D,
	2673:  0xB95E,
	2674:  0xB95F,
	2675:  0xB961,
	2676:  0xB962,
	2677:  0xB963,
	2678:  0xB964,
	2679:  0xB965,
	2680:  0xB966,
	2681:  0xB967,
	2682:  0xB96A,
	2683:  0xB96C,
	2684:  0xB96E,
	2685:  0xB96F,
	2686:  0xB970,
	2687:  0xB971,
	2688:  0xB972,
	2689:  0xB973,
	2690:  0xB976,
	2691:  0xB977,
	2692:  0xB979,
	2693:  0xB97A,
	2694:  0xB97B,
	2695:  0xB97D,
	2696:  0xB97E,
	2697:  0xB97F,
	2698:  0xB980,
	2699:  0xB981,
	2700:  0xB982,
	2701:  0xB983,
	2702:  0xB986,
	2703:  0xB988,
	2704:  0xB98B,
	2705:  0xB98C,
	2706:  0xB98F,
	2707:  0xB990,
	2708:  0xB991,
	2709:  0xB992,
	2710:  0xB993,
	2711:  0xB994,
	2712:  0xB995,
	2713:  0xB996,
	2714:  0xB997,
	2715:  0xB998,
	2716:  0xB999,
	2717:  0xB99A,
	2718:  0xB99B,
	2719:  0xB99C,
	2720:  0xB99D,
	2721:  0xB99E,
	2722:  0xB99F,
	2723:  0xB9A0,
	2724:  0xB9A1,
	2725:  0xB9A2,
	2726:  0xB9A3,
	2727:  0xB9A4,
	2728:  0xB9A5,
	2729:  0xB9A6,
	2730:  0xB9A7,
	2731:  0xB9A8,
	2732:  0xB9A9,
	2733:  0xB9AA,
	2734:  0xB9AB,
	2735:  0xB9AE,
	2736:  0xB9AF,
	2737:  0xB9B1,
	2738:  0xB9B2,
	2739:  0xB9B3,
	2740:  0xB9B5,
	2741:  0xB9B6,
	2742:  0xB9B7,
	2743:  0xB9B8,
	2744:  0xB9B9,
	2745:  0xB9BA,
	2746:  0xB9BB,
	2747:  0xB9BE,
	2748:  0xB9C0,
	2749:  0xB9C2,
	2750:  0xB9C3,
	2751:  0xB9C4,
	2752:  0xB9C5,
	2753:  0xB9C6,
	2754:  0xB9C7,
	2755:  0xB9CA,
	2756:  0xB9CB,
	2757:  0xB9CD,
	2758:  0xB9D3,
	2759:  0xB9D4,
	2760:  0xB9D5,
	2761:  0xB9D6,
	2762:  0xB9D7,
	2763:  0xB9DA,
	2764:  0xB9DC,
	2765:  0xB9DF,
	2766:  0xB9E0,
	2767:  0xB9E2,
	2768:  0xB9E6,
	2769:  0xB9E7,
	2770:  0xB9E9,
	2771:  0xB9EA,
	2772:  0xB9EB,
	2773:  0xB9ED,
	2774:  0xB9EE,
	2775:  0xB9EF,
	2776:  0xB9F0,
	2777:  0xB9F1,
	2778:  0xB9F2,
	2779:  0xB9F3,
	2780:  0xB9F6,
	2781:  0xB9FB,
	2782:  0xB9FC,
	2783:  0xB9FD,
	2784:  0xB9FE,
	2785:  0xB9FF,
	2786:  0xBA02,
	2787:  0xBA03,
	2788:  0xBA04,
	2789:  0xBA05,
	2790:  0xBA06,
	2791:  0xBA07,
	2792:  0xBA09,
	2793:  0xBA0A,
	2794:  0xBA0B,
	2795:  0xBA0C,
	2796:  0xBA0D,
	2797:  0xBA0E,
	2798:  0xBA0F,
	2799:  0xBA10,
	2800:  0xBA11,
	2801:  0xBA12,
	2802:  0xBA13,
	2803:  0xBA14,
	2804:  0xBA16,
	2805:  0xBA17,
	2806:  0xBA18,
	2807:  0xBA19,
	2808:  0xBA1A,
	2809:  0xBA1B,
	2810:  0xBA1C,
	2811:  0xBA1D,
	2812:  0xBA1E,
	2813:  0xBA1F,
	2814:  0xBA20,
	2815:  0xBA21,
	2816:  0xBA22,
	2817:  0xBA23,
	2818:  0xBA24,
	2819:  0xBA25,
	2820:  0xBA26,
	2821:  0xBA27,
	2822:  0xBA28,
	2823:  0xBA29,
	2824:  0xBA2A,
	2825:  0xBA2B,
	2826:  0xBA2C,
	2827:  0xBA2D,
	2828:  0xBA2E,
	2829:  0xBA2F,
	2830:  0xBA30,
	2831:  0xBA31,
	2832:  0xBA32,
	2833:  0xBA33,
	2834:  0xBA34,
	2835:  0xBA35,
	2836:  0xBA36,
	2837:  0xBA37,
	2838:  0xBA3A,
	2839:  0xBA3B,
	2840:  0xBA3D,
	2841:  0xBA3E,
	2842:  0xBA3F,
	2843:  0xBA41,
	2844:  0xBA43,
	2845:  0xBA44,
	2846:  0xBA45,
	2847:  0xBA46,
	2848:  0xBA47,
	2849:  0xBA4A,
	2850:  0xBA4C,
	2851:  0xBA4F,
	2852:  0xBA50,
	2853:  0xBA51,
	2854:  0xBA52,
	2855:  0xBA56,
	2856:  0xBA57,
	2857:  0xBA59,
	2858:  0xBA5A,
	2859:  0xBA5B,
	2860:  0xBA5D,
	2861:  0xBA5E,
	2862:  0xBA5F,
	2863:  0xBA60,
	2864:  0xBA61,
	2865:  0xBA62,
	2866:  0xBA63,
	2867:  0xBA66,
	2868:  0xBA6A,
	2869:  0xBA6B,
	2870:  0xBA6C,
	2871:  0xBA6D,
	2872:  0xBA6E,
	2873:  0xBA6F,
	2874:  0xBA72,
	2875:  0xBA73,
	2876:  0xBA75,
	2877:  0xBA76,
	2878:  0xBA77,
	2879:  0xBA79,
	2880:  0xBA7A,
	2881:  0xBA7B,
	2882:  0xBA7C,
	2883:  0xBA7D,
	2884:  0xBA7E,
	2885:  0xBA7F,
	2886:  0xBA80,
	2887:  0xBA81,
	2888:  0xBA82,
	2889:  0xBA86,
	2890:  0xBA88,
	2891:  0xBA89,
	2892:  0xBA8A,
	2893:  0xBA8B,
	2894:  0xBA8D,
	2895:  0xBA8E,
	2896:  0xBA8F,
	2897:  0xBA90,
	2898:  0xBA91,
	2899:  0xBA92,
	2900:  0xBA93,
	2901:  0xBA94,
	2902:  0xBA95,
	2903:  0xBA96,
	2904:  0xBA97,
	2905:  0xBA98,
	2906:  0xBA99,
	2907:  0xBA9A,
	2908:  0xBA9B,
	2909:  0xBA9C,
	2910:  0xBA9D,
	2911:  0xBA9E,
	2912:  0xBA9F,
	2913:  0xBAA0,
	2914:  0xBAA1,
	2915:  0xBAA2,
	2916:  0xBAA3,
	2917:  0xBAA4,
	2918:  0xBAA5,
	2919:  0xBAA6,
	2920:  0xBAA7,
	2921:  0xBAAA,
	2922:  0xBAAD,
	2923:  0xBAAE,
	2924:  0xBAAF,
	2925:  0xBAB1,
	2926:  0xBAB3,
	2927:  0xBAB4,
	2928:  0xBAB5,
	2929:  0xBAB6,
	2930:  0xBAB7,
	2931:  0xBABA,
	2932:  0xBABC,
	2933:  0xBABE,
	2934:  0xBABF,
	2935:  0xBAC0,
	2936:  0xBAC1,
	2937:  0xBAC2,
	2938:  0xBAC3,
	2939:  0xBAC5,
	2940:  0xBAC6,
	2941:  0xBAC7,
	2942:  0xBAC9,
	2943:  0xBACA,
	2944:  0xBACB,
	2945:  0xBACC,
	2946:  0xBACD,
	2947:  0xBACE,
	2948:  0xBACF,
	2949:  0xBAD0,
	2950:  0xBAD1,
	2951:  0xBAD2,
	2952:  0xBAD3,
	2953:  0xBAD4,
	2954:  0xBAD5,
	2955:  0xBAD6,
	2956:  0xBAD7,
	2957:  0xBADA,
	2958:  0xBADB,
	2959:  0xBADC,
	2960:  0xBADD,
	2961:  0xBADE,
	2962:  0xBADF,
	2963:  0xBAE0,
	2964:  0xBAE1,
	2965:  0xBAE2,
	2966:  0xBAE3,
	2967:  0xBAE4,
	2968:  0xBAE5,
	2969:  0xBAE6,
	2970:  0xBAE7,
	2971:  0xBAE8,
	2972:  0xBAE9,
	2973:  0xBAEA,
	2974:  0xBAEB,
	2975:  0xBAEC,
	2976:  0xBAED,
	2977:  0xBAEE,
	2978:  0xBAEF,
	2979:  0xBAF0,
	2980:  0xBAF1,
	2981:  0xBAF2,
	2982:  0xBAF3,
	2983:  0xBAF4,
	2984:  0xBAF5,
	2985:  0xBAF6,
	2986:  0xBAF7,
	2987:  0xBAF8,
	2988:  0xBAF9,
	2989:  0xBAFA,
	2990:  0xBAFB,
	2991:  0xBAFD,
	2992:  0xBAFE,
	2993:  0xBAFF,
	2994:  0xBB01,
	2995:  0xBB02,
	2996:  0xBB03,
	2997:  0xBB05,
	2998:  0xBB06,
	2999:  0xBB07,
	3000:  0xBB08,
	3001:  0xBB09,
	3002:  0xBB0A,
	3003:  0xBB0B,
	3004:  0xBB0C,
	3005:  0xBB0E,
	3006:  0xBB10,
	3007:  0xBB12,
	3008:  0xBB13,
	3009:  0xBB14,
	3010:  0xBB15,
	3011:  0xBB16,
	3012:  0xBB17,
	3013:  0xBB19,
	3014:  0xBB1A,
	3015:  0xBB1B,
	3016:  0xBB1D,
	3017:  0xBB1E,
	3018:  0xBB1F,
	3019:  0xBB21,
	3020:  0xBB22,
	3021:  0xBB23,
	3022:  0xBB24,
	3023:  0xBB25,
	3024:  0xBB26,
	3025:  0xBB27,
	3026:  0xBB28,
	3027:  0xBB2A,
	3028:  0xBB2C,
	3029:  0xBB2D,
	3030:  0xBB2E,
	3031:  0xBB2F,
	3032:  0xBB30,
	3033:  0xBB31,
	3034:  0xBB32,
	3035:  0xBB33,
	3036:  0xBB37,
	3037:  0xBB39,
	3038:  0xBB3A,
	3039:  0xBB3F,
	3040:  0xBB40,
	3041:  0xBB41,
	3042:  0xBB42,
	3043:  0xBB43,
	3044:  0xBB46,
	3045:  0xBB48,
	3046:  0xBB4A,
	3047:  0xBB4B,
	3048:  0xBB4C,
	3049:  0xBB4E,
	3050:  0xBB51,
	3051:  0xBB52,
	3052:  0xBB53,
	3053:  0xBB55,
	3054:  0xBB56,
	3055:  0xBB57,
	3056:  0xBB59,
	3057:  0xBB5A,
	3058:  0xBB5B,
	3059:  0xBB5C,
	3060:  0xBB5D,
	3061:  0xBB5E,
	3062:  0xBB5F,
	3063:  0xBB60,
	3064:  0xBB62,
	3065:  0xBB64,
	3066:  0xBB65,
	3067:  0xBB66,
	3068:  0xBB67,
	3069:  0xBB68,
	3070:  0xBB69,
	3071:  0xBB6A,
	3072:  0xBB6B,
	3073:  0xBB6D,
	3074:  0xBB6E,
	3075:  0xBB6F,
	3076:  0xBB70,
	3077:  0xBB71,
	3078:  0xBB72,
	3079:  0xBB73,
	3080:  0xBB74,
	3081:  0xBB75,
	3082:  0xBB76,
	3083:  0xBB77,
	3084:  0xBB78,
	3085:  0xBB79,
	3086:  0xBB7A,
	3087:  0xBB7B,
	3088:  0xBB7C,
	3089:  0xBB7D,
	3090:  0xBB7E,
	3091:  0xBB7F,
	3092:  0xBB80,
	3093:  0xBB81,
	3094:  0xBB82,
	3095:  0xBB83,
	3096:  0xBB84,
	3097:  0xBB85,
	3098:  0xBB86,
	3099:  0xBB87,
	3100:  0xBB89,
	3101:  0xBB8A,
	3102:  0xBB8B,
	3103:  0xBB8D,
	3104:  0xBB8E,
	3105:  0xBB8F,
	3106:  0xBB91,
	3107:  0xBB92,
	3108:  0xBB93,
	3109:  0xBB94,
	3110:  0xBB95,
	3111:  0xBB96,
	3112:  0xBB97,
	3113:  0xBB98,
	3114:  0xBB99,
	3115:  0xBB9A,
	3116:  0xBB9B,
	3117:  0xBB9C,
	3118:  0xBB9D,
	3119:  0xBB9E,
	3120:  0xBB9F,
	3121:  0xBBA0,
	3122:  0xBBA1,
	3123:  0xBBA2,
	3124:  0xBBA3,
	3125:  0xBBA5,
	3126:  0xBBA6,
	3127:  0xBBA7,
	3128:  0xBBA9,
	3129:  0xBBAA,
	3130:  0xBBAB,
	3131:  0xBBAD,
	3132:  0xBBAE,
	3133:  0xBBAF,
	3134:  0xBBB0,
	3135:  0xBBB1,
	3136:  0xBBB2,
	3137:  0xBBB3,
	3138:  0xBBB5,
	3139:  0xBBB6,
	3140:  0xBBB8,
	3141:  0xBBB9,
	3142:  0xBBBA,
	3143:  0xBBBB,
	3144:  0xBBBC,
	3145:  0xBBBD,
	3146:  0xBBBE,
	3147:  0xBBBF,
	3148:  0xBBC1,
	3149:  0xBBC2,
	3150:  0xBBC3,
	3151:  0xBBC5,
	3152:  0xBBC6,
	3153:  0xBBC7,
	3154:  0xBBC9,
	3155:  0xBBCA,
	3156:  0xBBCB,
	3157:  0xBBCC,
	3158:  0xBBCD,
	3159:  0xBBCE,
	3160:  0xBBCF,
	3161:  0xBBD1,
	3162:  0xBBD2,
	3163:  0xBBD4,
	3164:  0xBBD5,
	3165:  0xBBD6,
	3166:  0xBBD7,
	3167:  0xBBD8,
	3168:  0xBBD9,
	3169:  0xBBDA,
	3170:  0xBBDB,
	3171:  0xBBDC,
	3172:  0xBBDD,
	3173:  0xBBDE,
	3174:  0xBBDF,
	3175:  0xBBE0,
	3176:  0xBBE1,
	3177:  0xBBE2,
	3178:  0xBBE3,
	3179:  0xBBE4,
	3180:  0xBBE5,
	3181:  0xBBE6,
	3182:  0xBBE7,
	3183:  0xBBE8,
	3184:  0xBBE9,
	3185:  0xBBEA,
	3186:  0xBBEB,
	3187:  0xBBEC,
	3188:  0xBBED,
	3189:  0xBBEE,
	3190:  0xBBEF,
	3191:  0xBBF0,
	3192:  0xBBF1,
	3193:  0xBBF2,
	3194:  0xBBF3,
	3195:  0xBBF4,
	3196:  0xBBF5,
	3197:  0xBBF6,
	3198:  0xBBF7,
	3199:  0xBBFA,
	3200:  0xBBFB,
	3201:  0xBBFD,
	3202:  0xBBFE,
	3203:  0xBC01,
	3204:  0xBC03,
	3205:  0xBC04,
	3206:  0xBC05,
	3207:  0xBC06,
	3208:  0xBC07,
	3209:  0xBC0A,
	3210:  0xBC0E,
	3211:  0xBC10,
	3212:  0xBC12,
	3213:  0xBC13,
	3214:  0xBC19,
	3215:  0xBC1A,
	3216:  0xBC20,
	3217:  0xBC21,
	3218:  0xBC22,
	3219:  0xBC23,
	3220:  0xBC26,
	3221:  0xBC28,
	3222:  0xBC2A,
	3223:  0xBC2B,
	3224:  0xBC2C,
	3225:  0xBC2E,
	3226:  0xBC2F,
	3227:  0xBC32,
	3228:  0xBC33,
	3229:  0xBC35,
	3230:  0xBC36,
	3231:  0xBC37,
	3232:  0xBC39,
	3233:  0xBC3A,
	3234:  0xBC3B,
	3235:  0xBC3C,
	3236:  0xBC3D,
	3237:  0xBC3E,
	3238:  0xBC3F,
	3239:  0xBC42,
	3240:  0xBC46,
	3241:  0xBC47,
	3242:  0xBC48,
	3243:  0xBC4A,
	3244:  0xBC4B,
	3245:  0xBC4E,
	3246:  0xBC4F,
	3247:  0xBC51,
	3248:  0xBC52,
	3249:  0xBC53,
	3250:  0xBC54,
	3251:  0xBC55,
	3252:  0xBC56,
	3253:  0xBC57,
	3254:  0xBC58,
	3255:  0xBC59,
	3256:  0xBC5A,
	3257:  0xBC5B,
	3258:  0xBC5C,
	3259:  0xBC5E,
	3260:  0xBC5F,
	3261:  0xBC60,
	3262:  0xBC61,
	3263:  0xBC62,
	3264:  0xBC63,
	3265:  0xBC64,
	3266:  0xBC65,
	3267:  0xBC66,
	3268:  0xBC67,
	3269:  0xBC68,
	3270:  0xBC69,
	3271:  0xBC6A,
	3272:  0xBC6B,
	3273:  0xBC6C,
	3274:  0xBC6D,
	3275:  0xBC6E,
	3276:  0xBC6F,
	3277:  0xBC70,
	3278:  0xBC71,
	3279:  0xBC72,
	3280:  0xBC73,
	3281:  0xBC74,
	3282:  0xBC75,
	3283:  0xBC76,
	3284:  0xBC77,
	3285:  0xBC78,
	3286:  0xBC79,
	3287:  0xBC7A,
	3288:  0xBC7B,
	3289:  0xBC7C,
	3290:  0xBC7D,
	3291:  0xBC7E,
	3292:  0xBC7F,
	3293:  0xBC80,
	3294:  0xBC81,
	3295:  0xBC82,
	3296:  0xBC83,
	3297:  0xBC86,
	3298:  0xBC87,
	3299:  0xBC89,
	3300:  0xBC8A,
	3301:  0xBC8D,
	3302:  0xBC8F,
	3303:  0xBC90,
	3304:  0xBC91,
	3305:  0xBC92,
	3306:  0xBC93,
	3307:  0xBC96,
	3308:  0xBC98,
	3309:  0xBC9B,
	3310:  0xBC9C,
	3311:  0xBC9D,
	3312:  0xBC9E,
	3313:  0xBC9F,
	3314:  0xBCA2,
	3315:  0xBCA3,
	3316:  0xBCA5,
	3317:  0xBCA6,
	3318:  0xBCA9,
	3319:  0xBCAA,
	3320:  0xBCAB,
	3321:  0xBCAC,
	3322:  0xBCAD,
	3323:  0xBCAE,
	3324:  0xBCAF,
	3325:  0xBCB2,
	3326:  0xBCB6,
	3327:  0xBCB7,
	3328:  0xBCB8,
	3329:  0xBCB9,
	3330:  0xBCBA,
	3331:  0xBCBB,
	3332:  0xBCBE,
	3333:  0xBCBF,
	3334:  0xBCC1,
	3335:  0xBCC2,
	3336:  0xBCC3,
	3337:  0xBCC5,
	3338:  0xBCC6,
	3339:  0xBCC7,
	3340:  0xBCC8,
	3341:  0xBCC9,
	3342:  0xBCCA,
	3343:  0xBCCB,
	3344:  0xBCCC,
	3345:  0xBCCE,
	3346:  0xBCD2,
	3347:  0xBCD3,
	3348:  0xBCD4,
	3349:  0xBCD6,
	3350:  0xBCD7,
	3351:  0xBCD9,
	3352:  0xBCDA,
	3353:  0xBCDB,
	3354:  0xBCDD,
	3355:  0xBCDE,
	3356:  0xBCDF,
	3357:  0xBCE0,
	3358:  0xBCE1,
	3359:  0xBCE2,
	3360:  0xBCE3,
	3361:  0xBCE4,
	3362:  0xBCE5,
	3363:  0xBCE6,
	3364:  0xBCE7,
	3365:  0xBCE8,
	3366:  0xBCE9,
	3367:  0xBCEA,
	3368:  0xBCEB,
	3369:  0xBCEC,
	3370:  0xBCED,
	3371:  0xBCEE,
	3372:  0xBCEF,
	3373:  0xBCF0,
	3374:  0xBCF1,
	3375:  0xBCF2,
	3376:  0xBCF3,
	3377:  0xBCF7,
	3378:  0xBCF9,
	3379:  0xBCFA,
	3380:  0xBCFB,
	3381:  0xBCFD,
	3382:  0xBCFE,
	3383:  0xBCFF,
	3384:  0xBD00,
	3385:  0xBD01,
	3386:  0xBD02,
	3387:  0xBD03,
	3388:  0xBD06,
	3389:  0xBD08,
	3390:  0xBD0A,
	3391:  0xBD0B,
	3392:  0xBD0C,
	3393:  0xBD0D,
	3394:  0xBD0E,
	3395:  0xBD0F,
	3396:  0xBD11,
	3397:  0xBD12,
	3398:  0xBD13,
	3399:  0xBD15,
	3400:  0xBD16,
	3401:  0xBD17,
	3402:  0xBD18,
	3403:  0xBD19,
	3404:  0xBD1A,
	3405:  0xBD1B,
	3406:  0xBD1C,
	3407:  0xBD1D,
	3408:  0xBD1E,
	3409:  0xBD1F,
	3410:  0xBD20,
	3411:  0xBD21,
	3412:  0xBD22,
	3413:  0xBD23,
	3414:  0xBD25,
	3415:  0xBD26,
	3416:  0xBD27,
	3417:  0xBD28,
	3418:  0xBD29,
	3419:  0xBD2A,
	3420:  0xBD2B,
	3421:  0xBD2D,
	3422:  0xBD2E,
	3423:  0xBD2F,
	3424:  0xBD30,
	3425:  0xBD31,
	3426:  0xBD32,
	3427:  0xBD33,
	3428:  0xBD34,
	3429:  0xBD35,
	3430:  0xBD36,
	3431:  0xBD37,
	3432:  0xBD38,
	3433:  0xBD39,
	3434:  0xBD3A,
	3435:  0xBD3B,
	3436:  0xBD3C,
	3437:  0xBD3D,
	3438:  0xBD3E,
	3439:  0xBD3F,
	3440:  0xBD41,
	3441:  0xBD42,
	3442:  0xBD43,
	3443:  0xBD44,
	3444:  0xBD45,
	3445:  0xBD46,
	3446:  0xBD47,
	3447:  0xBD4A,
	3448:  0xBD4B,
	3449:  0xBD4D,
	3450:  0xBD4E,
	3451:  0xBD4F,
	3452:  0xBD51,
	3453:  0xBD52,
	3454:  0xBD53,
	3455:  0xBD54,
	3456:  0xBD55,
	3457:  0xBD56,
	3458:  0xBD57,
	3459:  0xBD5A,
	3460:  0xBD5B,
	3461:  0xBD5C,
	3462:  0xBD5D,
	3463:  0xBD5E,
	3464:  0xBD5F,
	3465:  0xBD60,
	3466:  0xBD61,
	3467:  0xBD62,
	3468:  0xBD63,
	3469:  0xBD65,
	3470:  0xBD66,
	3471:  0xBD67,
	3472:  0xBD69,
	3473:  0xBD6A,
	3474:  0xBD6B,
	3475:  0xBD6C,
	3476:  0xBD6D,
	3477:  0xBD6E,
	3478:  0xBD6F,
	3479:  0xBD70,
	3480:  0xBD71,
	3481:  0xBD72,
	3482:  0xBD73,
	3483:  0xBD74,
	3484:  0xBD75,
	3485:  0xBD76,
	3486:  0xBD77,
	3487:  0xBD78,
	3488:  0xBD79,
	3489:  0xBD7A,
	3490:  0xBD7B,
	3491:  0xBD7C,
	3492:  0xBD7D,
	3493:  0xBD7E,
	3494:  0xBD7F,
	3495:  0xBD82,
	3496:  0xBD83,
	3497:  0xBD85,
	3498:  0xBD86,
	3499:  0xBD8B,
	3500:  0xBD8C,
	3501:  0xBD8D,
	3502:  0xBD8E,
	3503:  0xBD8F,
	3504:  0xBD92,
	3505:  0xBD94,
	3506:  0xBD96,
	3507:  0xBD97,
	3508:  0xBD98,
	3509:  0xBD9B,
	3510:  0xBD9D,
	3511:  0xBD9E,
	3512:  0xBD9F,
	3513:  0xBDA0,
	3514:  0xBDA1,
	3515:  0xBDA2,
	3516:  0xBDA3,
	3517:  0xBDA5,
	3518:  0xBDA6,
	3519:  0xBDA7,
	3520:  0xBDA8,
	3521:  0xBDA9,
	3522:  0xBDAA,
	3523:  0xBDAB,
	3524:  0xBDAC,
	3525:  0xBDAD,
	3526:  0xBDAE,
	3527:  0xBDAF,
	3528:  0xBDB1,
	3529:  0xBDB2,
	3530:  0xBDB3,
	3531:  0xBDB4,
	3532:  0xBDB5,
	3533:  0xBDB6,
	3534:  0xBDB7,
	3535:  0xBDB9,
	3536:  0xBDBA,
	3537:  0xBDBB,
	3538:  0xBDBC,
	3539:  0xBDBD,
	3540:  0xBDBE,
	3541:  0xBDBF,
	3542:  0xBDC0,
	3543:  0xBDC1,
	3544:  0xBDC2,
	3545:  0xBDC3,
	3546:  0xBDC4,
	3547:  0xBDC5,
	3548:  0xBDC6,
	3549:  0xBDC7,
	3550:  0xBDC8,
	3551:  0xBDC9,
	3552:  0xBDCA,
	3553:  0xBDCB,
	3554:  0xBDCC,
	3555:  0xBDCD,
	3556:  0xBDCE,
	3557:  0xBDCF,
	3558:  0xBDD0,
	3559:  0xBDD1,
	3560:  0xBDD2,
	3561:  0xBDD3,
	3562:  0xBDD6,
	3563:  0xBDD7,
	3564:  0xBDD9,
	3565:  0xBDDA,
	3566:  0xBDDB,
	3567:  0xBDDD,
	3568:  0xBDDE,
	3569:  0xBDDF,
	3570:  0xBDE0,
	3571:  0xBDE1,
	3572:  0xBDE2,
	3573:  0xBDE3,
	3574:  0xBDE4,
	3575:  0xBDE5,
	3576:  0xBDE6,
	3577:  0xBDE7,
	3578:  0xBDE8,
	3579:  0xBDEA,
	3580:  0xBDEB,
	3581:  0xBDEC,
	3582:  0xBDED,
	3583:  0xBDEE,
	3584:  0xBDEF,
	3585:  0xBDF1,
	3586:  0xBDF2,
	3587:  0xBDF3,
	3588:  0xBDF5,
	3589:  0xBDF6,
	3590:  0xBDF7,
	3591:  0xBDF9,
	3592:  0xBDFA,
	3593:  0xBDFB,
	3594:  0xBDFC,
	3595:  0xBDFD,
	3596:  0xBDFE,
	3597:  0xBDFF,
	3598:  0xBE01,
	3599:  0xBE02,
	3600:  0xBE04,
	3601:  0xBE06,
	3602:  0xBE07,
	3603:  0xBE08,
	3604:  0xBE09,
	3605:  0xBE0A,
	3606:  0xBE0B,
	3607:  0xBE0E,
	3608:  0xBE0F,
	3609:  0xBE11,
	3610:  0xBE12,
	3611:  0xBE13,
	3612:  0xBE15,
	3613:  0xBE16,
	3614:  0xBE17,
	3615:  0xBE18,
	3616:  0xBE19,
	3617:  0xBE1A,
	3618:  0xBE1B,
	3619:  0xBE1E,
	3620:  0xBE20,
	3621:  0xBE21,
	3622:  0xBE22,
	3623:  0xBE23,
	3624:  0xBE24,
	3625:  0xBE25,
	3626:  0xBE26,
	3627:  0xBE27,
	3628:  0xBE28,
	3629:  0xBE29,
	3630:  0xBE2A,
	3631:  0xBE2B,
	3632:  0xBE2C,
	3633:  0xBE2D,
	3634:  0xBE2E,
	3635:  0xBE2F,
	3636:  0xBE30,
	3637:  0xBE31,
	3638:  0xBE32,
	3639:  0xBE33,
	3640:  0xBE34,
	3641:  0xBE35,
	3642:  0xBE36,
	3643:  0xBE37,
	3644:  0xBE38,
	3645:  0xBE39,
	3646:  0xBE3A,
	3647:  0xBE3B,
	3648:  0xBE3C,
	3649:  0xBE3D,
	3650:  0xBE3E,
	3651:  0xBE3F,
	3652:  0xBE40,
	3653:  0xBE41,
	3654:  0xBE42,
	3655:  0xBE43,
	3656:  0xBE46,
	3657:  0xBE47,
	3658:  0xBE49,
	3659:  0xBE4A,
	3660:  0xBE4B,
	3661:  0xBE4D,
	3662:  0xBE4F,
	3663:  0xBE50,
	3664:  0xBE51,
	3665:  0xBE52,
	3666:  0xBE53,
	3667:  0xBE56,
	3668:  0xBE58,
	3669:  0xBE5C,
	3670:  0xBE5D,
	3671:  0xBE5E,
	3672:  0xBE5F,
	3673:  0xBE62,
	3674:  0xBE63,
	3675:  0xBE65,
	3676:  0xBE66,
	3677:  0xBE67,
	3678:  0xBE69,
	3679:  0xBE6B,
	3680:  0xBE6C,
	3681:  0xBE6D,
	3682:  0xBE6E,
	3683:  0xBE6F,
	3684:  0xBE72,
	3685:  0xBE76,
	3686:  0xBE77,
	3687:  0xBE78,
	3688:  0xBE79,
	3689:  0xBE7A,
	3690:  0xBE7E,
	3691:  0xBE7F,
	3692:  0xBE81,
	3693:  0xBE82,
	3694:  0xBE83,
	3695:  0xBE85,
	3696:  0xBE86,
	3697:  0xBE87,
	3698:  0xBE88,
	3699:  0xBE89,
	3700:  0xBE8A,
	3701:  0xBE8B,
	3702:  0xBE8E,
	3703:  0xBE92,
	3704:  0xBE93,
	3705:  0xBE94,
	3706:  0xBE95,
	3707:  0xBE96,
	3708:  0xBE97,
	3709:  0xBE9A,
	3710:  0xBE9B,
	3711:  0xBE9C,
	3712:  0xBE9D,
	3713:  0xBE9E,
	3714:  0xBE9F,
	3715:  0xBEA0,
	3716:  0xBEA1,
	3717:  0xBEA2,
	3718:  0xBEA3,
	3719:  0xBEA4,
	3720:  0xBEA5,
	3721:  0xBEA6,
	3722:  0xBEA7,
	3723:  0xBEA9,
	3724:  0xBEAA,
	3725:  0xBEAB,
	3726:  0xBEAC,
	3727:  0xBEAD,
	3728:  0xBEAE,
	3729:  0xBEAF,
	3730:  0xBEB0,
	3731:  0xBEB1,
	3732:  0xBEB2,
	3733:  0xBEB3,
	3734:  0xBEB4,
	3735:  0xBEB5,
	3736:  0xBEB6,
	3737:  0xBEB7,
	3738:  0xBEB8,
	3739:  0xBEB9,
	3740:  0xBEBA,
	3741:  0xBEBB,
	3742:  0xBEBC,
	3743:  0xBEBD,
	3744:  0xBEBE,
	3745:  0xBEBF,
	3746:  0xBEC0,
	3747:  0xBEC1,
	3748:  0xBEC2,
	3749:  0xBEC3,
	3750:  0xBEC4,
	3751:  0xBEC5,
	3752:  0xBEC6,
	3753:  0xBEC7,
	3754:  0xBEC8,
	3755:  0xBEC9,
	3756:  0xBECA,
	3757:  0xBECB,
	3758:  0xBECC,
	3759:  0xBECD,
	3760:  0xBECE,
	3761:  0xBECF,
	3762:  0xBED2,
	3763:  0xBED3,
	3764:  0xBED5,
	3765:  0xBED6,
	3766:  0xBED9,
	3767:  0xBEDA,
	3768:  0xBEDB,
	3769:  0xBEDC,
	3770:  0xBEDD,
	3771:  0xBEDE,
	3772:  0xBEDF,
	3773:  0xBEE1,
	3774:  0xBEE2,
	3775:  0xBEE6,
	3776:  0xBEE7,
	3777:  0xBEE8,
	3778:  0xBEE9,
	3779:  0xBEEA,
	3780:  0xBEEB,
	3781:  0xBEED,
	3782:  0xBEEE,
	3783:  0xBEEF,
	3784:  0xBEF0,
	3785:  0xBEF1,
	3786:  0xBEF2,
	3787:  0xBEF3,
	3788:  0xBEF4,
	3789:  0xBEF5,
	3790:  0xBEF6,
	3791:  0xBEF7,
	3792:  0xBEF8,
	3793:  0xBEF9,
	3794:  0xBEFA,
	3795:  0xBEFB,
	3796:  0xBEFC,
	3797:  0xBEFD,
	3798:  0xBEFE,
	3799:  0xBEFF,
	3800:  0xBF00,
	3801:  0xBF02,
	3802:  0xBF03,
	3803:  0xBF04,
	3804:  0xBF05,
	3805:  0xBF06,
	3806:  0xBF07,
	3807:  0xBF0A,
	3808:  0xBF0B,
	3809:  0xBF0C,
	3810:  0xBF0D,
	3811:  0xBF0E,
	3812:  0xBF0F,
	3813:  0xBF10,
	3814:  0xBF11,
	3815:  0xBF12,
	3816:  0xBF13,
	3817:  0xBF14,
	3818:  0xBF15,
	3819:  0xBF16,
	3820:  0xBF17,
	3821:  0xBF1A,
	3822:  0xBF1E,
	3823:  0xBF1F,
	3824:  0xBF20,
	3825:  0xBF21,
	3826:  0xBF22,
	3827:  0xBF23,
	3828:  0xBF24,
	3829:  0xBF25,
	3830:  0xBF26,
	3831:  0xBF27,
	3832:  0xBF28,
	3833:  0xBF29,
	3834:  0xBF2A,
	3835:  0xBF2B,
	3836:  0xBF2C,
	3837:  0xBF2D,
	3838:  0xBF2E,
	3839:  0xBF2F,
	3840:  0xBF30,
	3841:  0xBF31,
	3842:  0xBF32,
	3843:  0xBF33,
	3844:  0xBF34,
	3845:  0xBF35,
	3846:  0xBF36,
	3847:  0xBF37,
	3848:  0xBF38,
	3849:  0xBF39,
	3850:  0xBF3A,
	3851:  0xBF3B,
	3852:  0xBF3C,
	3853:  0xBF3D,
	3854:  0xBF3E,
	3855:  0xBF3F,
	3856:  0xBF42,
	3857:  0xBF43,
	3858:  0xBF45,
	3859:  0xBF46,
	3860:  0xBF47,
	3861:  0xBF49,
	3862:  0xBF4A,
	3863:  0xBF4B,
	3864:  0xBF4C,
	3865:  0xBF4D,
	3866:  0xBF4E,
	3867:  0xBF4F,
	3868:  0xBF52,
	3869:  0xBF53,
	3870:  0xBF54,
	3871:  0xBF56,
	3872:  0xBF57,
	3873:  0xBF58,
	3874:  0xBF59,
	3875:  0xBF5A,
	3876:  0xBF5B,
	3877:  0xBF5C,
	3878:  0xBF5D,
	3879:  0xBF5E,
	3880:  0xBF5F,
	3881:  0xBF60,
	3882:  0xBF61,
	3883:  0xBF62,
	3884:  0xBF63,
	3885:  0xBF64,
	3886:  0xBF65,
	3887:  0xBF66,
	3888:  0xBF67,
	3889:  0xBF68,
	3890:  0xBF69,
	3891:  0xBF6A,
	3892:  0xBF6B,
	3893:  0xBF6C,
	3894:  0xBF6D,
	3895:  0xBF6E,
	3896:  0xBF6F,
	3897:  0xBF70,
	3898:  0xBF71,
	3899:  0xBF72,
	3900:  0xBF73,
	3901:  0xBF74,
	3902:  0xBF75,
	3903:  0xBF76,
	3904:  0xBF77,
	3905:  0xBF78,
	3906:  0xBF79,
	3907:  0xBF7A,
	3908:  0xBF7B,
	3909:  0xBF7C,
	3910:  0xBF7D,
	3911:  0xBF7E,
	3912:  0xBF7F,
	3913:  0xBF80,
	3914:  0xBF81,
	3915:  0xBF82,
	3916:  0xBF83,
	3917:  0xBF84,
	3918:  0xBF85,
	3919:  0xBF86,
	3920:  0xBF87,
	3921:  0xBF88,
	3922:  0xBF89,
	3923:  0xBF8A,
	3924:  0xBF8B,
	3925:  0xBF8C,
	3926:  0xBF8D,
	3927:  0xBF8E,
	3928:  0xBF8F,
	3929:  0xBF90,
	3930:  0xBF91,
	3931:  0xBF92,
	3932:  0xBF93,
	3933:  0xBF95,
	3934:  0xBF96,
	3935:  0xBF97,
	3936:  0xBF98,
	3937:  0xBF99,
	3938:  0xBF9A,
	3939:  0xBF9B,
	3940:  0xBF9C,
	3941:  0xBF9D,
	3942:  0xBF9E,
	3943:  0xBF9F,
	3944:  0xBFA0,
	3945:  0xBFA1,
	3946:  0xBFA2,
	3947:  0xBFA3,
	3948:  0xBFA4,
	3949:  0xBFA5,
	3950:  0xBFA6,
	3951:  0xBFA7,
	3952:  0xBFA8,
	3953:  0xBFA9,
	3954:  0xBFAA,
	3955:  0xBFAB,
	3956:  0xBFAC,
	3957:  0xBFAD,
	3958:  0xBFAE,
	3959:  0xBFAF,
	3960:  0xBFB1,
	3961:  0xBFB2,
	3962:  0xBFB3,
	3963:  0xBFB4,
	3964:  0xBFB5,
	3965:  0xBFB6,
	3966:  0xBFB7,
	3967:  0xBFB8,
	3968:  0xBFB9,
	3969:  0xBFBA,
	3970:  0xBFBB,
	3971:  0xBFBC,
	3972:  0xBFBD,
	3973:  0xBFBE,
	3974:  0xBFBF,
	3975:  0xBFC0,
	3976:  0xBFC1,
	3977:  0xBFC2,
	3978:  0xBFC3,
	3979:  0xBFC4,
	3980:  0xBFC6,
	3981:  0xBFC7,
	3982:  0xBFC8,
	3983:  0xBFC9,
	3984:  0xBFCA,
	3985:  0xBFCB,
	3986:  0xBFCE,
	3987:  0xBFCF,
	3988:  0xBFD1,
	3989:  0xBFD2,
	3990:  0xBFD3,
	3991:  0xBFD5,
	3992:  0xBFD6,
	3993:  0xBFD7,
	3994:  0xBFD8,
	3995:  0xBFD9,
	3996:  0xBFDA,
	3997:  0xBFDB,
	3998:  0xBFDD,
	3999:  0xBFDE,
	4000:  0xBFE0,
	4001:  0xBFE2,
	4002:  0xBFE3,
	4003:  0xBFE4,
	4004:  0xBFE5,
	4005:  0xBFE6,
	4006:  0xBFE7,
	4007:  0xBFE8,
	4008:  0xBFE9,
	4009:  0xBFEA,
	4010:  0xBFEB,
	4011:  0xBFEC,
	4012:  0xBFED,
	4013:  0xBFEE,
	4014:  0xBFEF,
	4015:  0xBFF0,
	4016:  0xBFF1,
	4017:  0xBFF2,
	4018:  0xBFF3,
	4019:  0xBFF4,
	4020:  0xBFF5,
	4021:  0xBFF6,
	4022:  0xBFF7,
	4023:  0xBFF8,
	4024:  0xBFF9,
	4025:  0xBFFA,
	4026:  0xBFFB,
	4027:  0xBFFC,
	4028:  0xBFFD,
	4029:  0xBFFE,
	4030:  0xBFFF,
	4031:  0xC000,
	4032:  0xC001,
	4033:  0xC002,
	4034:  0xC003,
	4035:  0xC004,
	4036:  0xC005,
	4037:  0xC006,
	4038:  0xC007,
	4039:  0xC008,
	4040:  0xC009,
	4041:  0xC00A,
	4042:  0xC00B,
	4043:  0xC00C,
	4044:  0xC00D,
	4045:  0xC00E,
	4046:  0xC00F,
	4047:  0xC010,
	4048:  0xC011,
	4049:  0xC012,
	4050:  0xC013,
	4051:  0xC014,
	4052:  0xC015,
	4053:  0xC016,
	4054:  0xC017,
	4055:  0xC018,
	4056:  0xC019,
	4057:  0xC01A,
	4058:  0xC01B,
	4059:  0xC01C,
	4060:  0xC01D,
	4061:  0xC01E,
	4062:  0xC01F,
	4063:  0xC020,
	4064:  0xC021,
	4065:  0xC022,
	4066:  0xC023,
	4067:  0xC024,
	4068:  0xC025,
	4069:  0xC026,
	4070:  0xC027,
	4071:  0xC028,
	4072:  0xC029,
	4073:  0xC02A,
	4074:  0xC02B,
	4075:  0xC02C,
	4076:  0xC02D,
	4077:  0xC02E,
	4078:  0xC02F,
	4079:  0xC030,
	4080:  0xC031,
	4081:  0xC032,
	4082:  0xC033,
	4083:  0xC034,
	4084:  0xC035,
	4085:  0xC036,
	4086:  0xC037,
	4087:  0xC038,
	4088:  0xC039,
	4089:  0xC03A,
	4090:  0xC03B,
	4091:  0xC03D,
	4092:  0xC03E,
	4093:  0xC03F,
	4094:  0xC040,
	4095:  0xC041,
	4096:  0xC042,
	4097:  0xC043,
	4098:  0xC044,
	4099:  0xC045,
	4100:  0xC046,
	4101:  0xC047,
	4102:  0xC048,
	4103:  0xC049,
	4104:  0xC04A,
	4105:  0xC04B,
	4106:  0xC04C,
	4107:  0xC04D,
	4108:  0xC04E,
	4109:  0xC04F,
	4110:  0xC050,
	4111:  0xC052,
	4112:  0xC053,
	4113:  0xC054,
	4114:  0xC055,
	4115:  0xC056,
	4116:  0xC057,
	4117:  0xC059,
	4118:  0xC05A,
	4119:  0xC05B,
	4120:  0xC05D,
	4121:  0xC05E,
	4122:  0xC05F,
	4123:  0xC061,
	4124:  0xC062,
	4125:  0xC063,
	4126:  0xC064,
	4127:  0xC065,
	4128:  0xC066,
	4129:  0xC067,
	4130:  0xC06A,
	4131:  0xC06B,
	4132:  0xC06C,
	4133:  0xC06D,
	4134:  0xC06E,
	4135:  0xC06F,
	4136:  0xC070,
	4137:  0xC071,
	4138:  0xC072,
	4139:  0xC073,
	4140:  0xC074,
	4141:  0xC075,
	4142:  0xC076,
	4143:  0xC077,
	4144:  0xC078,
	4145:  0xC079,
	4146:  0xC07A,
	4147:  0xC07B,
	4148:  0xC07C,
	4149:  0xC07D,
	4150:  0xC07E,
	4151:  0xC07F,
	4152:  0xC080,
	4153:  0xC081,
	4154:  0xC082,
	4155:  0xC083,
	4156:  0xC084,
	4157:  0xC085,
	4158:  0xC086,
	4159:  0xC087,
	4160:  0xC088,
	4161:  0xC089,
	4162:  0xC08A,
	4163:  0xC08B,
	4164:  0xC08C,
	4165:  0xC08D,
	4166:  0xC08E,
	4167:  0xC08F,
	4168:  0xC092,
	4169:  0xC093,
	4170:  0xC095,
	4171:  0xC096,
	4172:  0xC097,
	4173:  0xC099,
	4174:  0xC09A,
	4175:  0xC09B,
	4176:  0xC09C,
	4177:  0xC09D,
	4178:  0xC09E,
	4179:  0xC09F,
	4180:  0xC0A2,
	4181:  0xC0A4,
	4182:  0xC0A6,
	4183:  0xC0A7,
	4184:  0xC0A8,
	4185:  0xC0A9,
	4186:  0xC0AA,
	4187:  0xC0AB,
	4188:  0xC0AE,
	4189:  0xC0B1,
	4190:  0xC0B2,
	4191:  0xC0B7,
	4192:  0xC0B8,
	4193:  0xC0B9,
	4194:  0xC0BA,
	4195:  0xC0BB,
	4196:  0xC0BE,
	4197:  0xC0C2,
	4198:  0xC0C3,
	4199:  0xC0C4,
	4200:  0xC0C6,
	4201:  0xC0C7,
	4202:  0xC0CA,
	4203:  0xC0CB,
	4204:  0xC0CD,
	4205:  0xC0CE,
	4206:  0xC0CF,
	4207:  0xC0D1,
	4208:  0xC0D2,
	4209:  0xC0D3,
	4210:  0xC0D4,
	4211:  0xC0D5,
	4212:  0xC0D6,
	4213:  0xC0D7,
	4214:  0xC0DA,
	4215:  0xC0DE,
	4216:  0xC0DF,
	4217:  0xC0E0,
	4218:  0xC0E1,
	4219:  0xC0E2,
	4220:  0xC0E3,
	4221:  0xC0E6,
	4222:  0xC0E7,
	4223:  0xC0E9,
	4224:  0xC0EA,
	4225:  0xC0EB,
	4226:  0xC0ED,
	4227:  0xC0EE,
	4228:  0xC0EF,
	4229:  0xC0F0,
	4230:  0xC0F1,
	4231:  0xC0F2,
	4232:  0xC0F3,
	4233:  0xC0F6,
	4234:  0xC0F8,
	4235:  0xC0FA,
	4236:  0xC0FB,
	4237:  0xC0FC,
	4238:  0xC0FD,
	4239:  0xC0FE,
	4240:  0xC0FF,
	4241:  0xC101,
	4242:  0xC102,
	4243:  0xC103,
	4244:  0xC105,
	4245:  0xC106,
	4246:  0xC107,
	4247:  0xC109,
	4248:  0xC10A,
	4249:  0xC10B,
	4250:  0xC10C,
	4251:  0xC10D,
	4252:  0xC10E,
	4253:  0xC10F,
	4254:  0xC111,
	4255:  0xC112,
	4256:  0xC113,
	4257:  0xC114,
	4258:  0xC116,
	4259:  0xC117,
	4260:  0xC118,
	4261:  0xC119,
	4262:  0xC11A,
	4263:  0xC11B,
	4264:  0xC121,
	4265:  0xC122,
	4266:  0xC125,
	4267:  0xC128,
	4268:  0xC129,
	4269:  0xC12A,
	4270:  0xC12B,
	4271:  0xC12E,
	4272:  0xC132,
	4273:  0xC133,
	4274:  0xC134,
	4275:  0xC135,
	4276:  0xC137,
	4277:  0xC13A,
	4278:  0xC13B,
	4279:  0xC13D,
	4280:  0xC13E,
	4281:  0xC13F,
	4282:  0xC141,
	4283:  0xC142,
	4284:  0xC143,
	4285:  0xC144,
	4286:  0xC145,
	4287:  0xC146,
	4288:  0xC147,
	4289:  0xC14A,
	4290:  0xC14E,
	4291:  0xC14F,
	4292:  0xC150,
	4293:  0xC151,
	4294:  0xC152,
	4295:  0xC153,
	4296:  0xC156,
	4297:  0xC157,
	4298:  0xC159,
	4299:  0xC15A,
	4300:  0xC15B,
	4301:  0xC15D,
	4302:  0xC15E,
	4303:  0xC15F,
	4304:  0xC160,
	4305:  0xC161,
	4306:  0xC162,
	4307:  0xC163,
	4308:  0xC166,
	4309:  0xC16A,
	4310:  0xC16B,
	4311:  0xC16C,
	4312:  0xC16D,
	4313:  0xC16E,
	4314:  0xC16F,
	4315:  0xC171,
	4316:  0xC172,
	4317:  0xC173,
	4318:  0xC175,
	4319:  0xC176,
	4320:  0xC177,
	4321:  0xC179,
	4322:  0xC17A,
	4323:  0xC17B,
	4324:  0xC17C,
	4325:  0xC17D,
	4326:  0xC17E,
	4327:  0xC17F,
	4328:  0xC180,
	4329:  0xC181,
	4330:  0xC182,
	4331:  0xC183,
	4332:  0xC184,
	4333:  0xC186,
	4334:  0xC187,
	4335:  0xC188,
	4336:  0xC189,
	4337:  0xC18A,
	4338:  0xC18B,
	4339:  0xC18F,
	4340:  0xC191,
	4341:  0xC192,
	4342:  0xC193,
	4343:  0xC195,
	4344:  0xC197,
	4345:  0xC198,
	4346:  0xC199,
	4347:  0xC19A,
	4348:  0xC19B,
	4349:  0xC19E,
	4350:  0xC1A0,
	4351:  0xC1A2,
	4352:  0xC1A3,
	4353:  0xC1A4,
	4354:  0xC1A6,
	4355:  0xC1A7,
	4356:  0xC1AA,
	4357:  0xC1AB,
	4358:  0xC1AD,
	4359:  0xC1AE,
	4360:  0xC1AF,
	4361:  0xC1B1,
	4362:  0xC1B2,
	4363:  0xC1B3,
	4364:  0xC1B4,
	4365:  0xC1B5,
	4366:  0xC1B6,
	4367:  0xC1B7,
	4368:  0xC1B8,
	4369:  0xC1B9,
	4370:  0xC1BA,
	4371:  0xC1BB,
	4372:  0xC1BC,
	4373:  0xC1BE,
	4374:  0xC1BF,
	4375:  0xC1C0,
	4376:  0xC1C1,
	4377:  0xC1C2,
	4378:  0xC1C3,
	4379:  0xC1C5,
	4380:  0xC1C6,
	4381:  0xC1C7,
	4382:  0xC1C9,
	4383:  0xC1CA,
	4384:  0xC1CB,
	4385:  0xC1CD,
	4386:  0xC1CE,
	4387:  0xC1CF,
	4388:  0xC1D0,
	4389:  0xC1D1,
	4390:  0xC1D2,
	4391:  0xC1D3,
	4392:  0xC1D5,
	4393:  0xC1D6,
	4394:  0xC1D9,
	4395:  0xC1DA,
	4396:  0xC1DB,
	4397:  0xC1DC,
	4398:  0xC1DD,
	4399:  0xC1DE,
	4400:  0xC1DF,
	4401:  0xC1E1,
	4402:  0xC1E2,
	4403:  0xC1E3,
	4404:  0xC1E5,
	4405:  0xC1E6,
	4406:  0xC1E7,
	4407:  0xC1E9,
	4408:  0xC1EA,
	4409:  0xC1EB,
	4410:  0xC1EC,
	4411:  0xC1ED,
	4412:  0xC1EE,
	4413:  0xC1EF,
	4414:  0xC1F2,
	4415:  0xC1F4,
	4416:  0xC1F5,
	4417:  0xC1F6,
	4418:  0xC1F7,
	4419:  0xC1F8,
	4420:  0xC1F9,
	4421:  0xC1FA,
	4422:  0xC1FB,
	4423:  0xC1FE,
	4424:  0xC1FF,
	4425:  0xC201,
	4426:  0xC202,
	4427:  0xC203,
	4428:  0xC205,
	4429:  0xC206,
	4430:  0xC207,
	4431:  0xC208,
	4432:  0xC209,
	4433:  0xC20A,
	4434:  0xC20B,
	4435:  0xC20E,
	4436:  0xC210,
	4437:  0xC212,
	4438:  0xC213,
	4439:  0xC214,
	4440:  0xC215,
	4441:  0xC216,
	4442:  0xC217,
	4443:  0xC21A,
	4444:  0xC21B,
	4445:  0xC21D,
	4446:  0xC21E,
	4447:  0xC221,
	4448:  0xC222,
	4449:  0xC223,
	4450:  0xC224,
	4451:  0xC225,
	4452:  0xC226,
	4453:  0xC227,
	4454:  0xC22A,
	4455:  0xC22C,
	4456:  0xC22E,
	4457:  0xC230,
	4458:  0xC233,
	4459:  0xC235,
	4460:  0xC236,
	4461:  0xC237,
	4462:  0xC238,
	4463:  0xC239,
	4464:  0xC23A,
	4465:  0xC23B,
	4466:  0xC23C,
	4467:  0xC23D,
	4468:  0xC23E,
	4469:  0xC23F,
	4470:  0xC240,
	4471:  0xC241,
	4472:  0xC242,
	4473:  0xC243,
	4474:  0xC244,
	4475:  0xC245,
	4476:  0xC246,
	4477:  0xC247,
	4478:  0xC249,
	4479:  0xC24A,
	4480:  0xC24B,
	4481:  0xC24C,
	4482:  0xC24D,
	4483:  0xC24E,
	4484:  0xC24F,
	4485:  0xC252,
	4486:  0xC253,
	4487:  0xC255,
	4488:  0xC256,
	4489:  0xC257,
	4490:  0xC259,
	4491:  0xC25A,
	4492:  0xC25B,
	4493:  0xC25C,
	4494:  0xC25D,
	4495:  0xC25E,
	4496:  0xC25F,
	4497:  0xC261,
	4498:  0xC262,
	4499:  0xC263,
	4500:  0xC264,
	4501:  0xC266,
	4502:  0xC267,
	4503:  0xC268,
	4504:  0xC269,
	4505:  0xC26A,
	4506:  0xC26B,
	4507:  0xC26E,
	4508:  0xC26F,
	4509:  0xC271,
	4510:  0xC272,
	4511:  0xC273,
	4512:  0xC275,
	4513:  0xC276,
	4514:  0xC277,
	4515:  0xC278,
	4516:  0xC279,
	4517:  0xC27A,
	4518:  0xC27B,
	4519:  0xC27E,
	4520:  0xC280,
	4521:  0xC282,
	4522:  0xC283,
	4523:  0xC284,
	4524:  0xC285,
	4525:  0xC286,
	4526:  0xC287,
	4527:  0xC28A,
	4528:  0xC28B,
	4529:  0xC28C,
	4530:  0xC28D,
	4531:  0xC28E,
	4532:  0xC28F,
	4533:  0xC291,
	4534:  0xC292,
	4535:  0xC293,
	4536:  0xC294,
	4537:  0xC295,
	4538:  0xC296,
	4539:  0xC297,
	4540:  0xC299,
	4541:  0xC29A,
	4542:  0xC29C,
	4543:  0xC29E,
	4544:  0xC29F,
	4545:  0xC2A0,
	4546:  0xC2A1,
	4547:  0xC2A2,
	4548:  0xC2A3,
	4549:  0xC2A6,
	4550:  0xC2A7,
	4551:  0xC2A9,
	4552:  0xC2AA,
	4553:  0xC2AB,
	4554:  0xC2AE,
	4555:  0xC2AF,
	4556:  0xC2B0,
	4557:  0xC2B1,
	4558:  0xC2B2,
	4559:  0xC2B3,
	4560:  0xC2B6,
	4561:  0xC2B8,
	4562:  0xC2BA,
	4563:  0xC2BB,
	4564:  0xC2BC,
	4565:  0xC2BD,
	4566:  0xC2BE,
	4567:  0xC2BF,
	4568:  0xC2C0,
	4569:  0xC2C1,
	4570:  0xC2C2,
	4571:  0xC2C3,
	4572:  0xC2C4,
	4573:  0xC2C5,
	4574:  0xC2C6,
	4575:  0xC2C7,
	4576:  0xC2C8,
	4577:  0xC2C9,
	4578:  0xC2CA,
	4579:  0xC2CB,
	4580:  0xC2CC,
	4581:  0xC2CD,
	4582:  0xC2CE,
	4583:  0xC2CF,
	4584:  0xC2D0,
	4585:  0xC2D1,
	4586:  0xC2D2,
	4587:  0xC2D3,
	4588:  0xC2D4,
	4589:  0xC2D5,
	4590:  0xC2D6,
	4591:  0xC2D7,
	4592:  0xC2D8,
	4593:  0xC2D9,
	4594:  0xC2DA,
	4595:  0xC2DB,
	4596:  0xC2DE,
	4597:  0xC2DF,
	4598:  0xC2E1,
	4599:  0xC2E2,
	4600:  0xC2E5,
	4601:  0xC2E6,
	4602:  0xC2E7,
	4603:  0xC2E8,
	4604:  0xC2E9,
	4605:  0xC2EA,
	4606:  0xC2EE,
	4607:  0xC2F0,
	4608:  0xC2F2,
	4609:  0xC2F3,
	4610:  0xC2F4,
	4611:  0xC2F5,
	4612:  0xC2F7,
	4613:  0xC2FA,
	4614:  0xC2FD,
	4615:  0xC2FE,
	4616:  0xC2FF,
	4617:  0xC301,
	4618:  0xC302,
	4619:  0xC303,
	4620:  0xC304,
	4621:  0xC305,
	4622:  0xC306,
	4623:  0xC307,
	4624:  0xC30A,
	4625:  0xC30B,
	4626:  0xC30E,
	4627:  0xC30F,
	4628:  0xC310,
	4629:  0xC311,
	4630:  0xC312,
	4631:  0xC316,
	4632:  0xC317,
	4633:  0xC319,
	4634:  0xC31A,
	4635:  0xC31B,
	4636:  0xC31D,
	4637:  0xC31E,
	4638:  0xC31F,
	4639:  0xC320,
	4640:  0xC321,
	4641:  0xC322,
	4642:  0xC323,
	4643:  0xC326,
	4644:  0xC327,
	4645:  0xC32A,
	4646:  0xC32B,
	4647:  0xC32C,
	4648:  0xC32D,
	4649:  0xC32E,
	4650:  0xC32F,
	4651:  0xC330,
	4652:  0xC331,
	4653:  0xC332,
	4654:  0xC333,
	4655:  0xC334,
	4656:  0xC335,
	4657:  0xC336,
	4658:  0xC337,
	4659:  0xC338,
	4660:  0xC339,
	4661:  0xC33A,
	4662:  0xC33B,
	4663:  0xC33C,
	4664:  0xC33D,
	4665:  0xC33E,
	4666:  0xC33F,
	4667:  0xC340,
	4668:  0xC341,
	4669:  0xC342,
	4670:  0xC343,
	4671:  0xC344,
	4672:  0xC346,
	4673:  0xC347,
	4674:  0xC348,
	4675:  0xC349,
	4676:  0xC34A,
	4677:  0xC34B,
	4678:  0xC34C,
	4679:  0xC34D,
	4680:  0xC34E,
	4681:  0xC34F,
	4682:  0xC350,
	4683:  0xC351,
	4684:  0xC352,
	4685:  0xC353,
	4686:  0xC354,
	4687:  0xC355,
	4688:  0xC356,
	4689:  0xC357,
	4690:  0xC358,
	4691:  0xC359,
	4692:  0xC35A,
	4693:  0xC35B,
	4694:  0xC35C,
	4695:  0xC35D,
	4696:  0xC35E,
	4697:  0xC35F,
	4698:  0xC360,
	4699:  0xC361,
	4700:  0xC362,
	4701:  0xC363,
	4702:  0xC364,
	4703:  0xC365,
	4704:  0xC366,
	4705:  0xC367,
	4706:  0xC36A,
	4707:  0xC36B,
	4708:  0xC36D,
	4709:  0xC36E,
	4710:  0xC36F,
	4711:  0xC371,
	4712:  0xC373,
	4713:  0xC374,
	4714:  0xC375,
	4715:  0xC376,
	4716:  0xC377,
	4717:  0xC37A,
	4718:  0xC37B,
	4719:  0xC37E,
	4720:  0xC37F,
	4721:  0xC380,
	4722:  0xC381,
	4723:  0xC382,
	4724:  0xC383,
	4725:  0xC385,
	4726:  0xC386,
	4727:  0xC387,
	4728:  0xC389,
	4729:  0xC38A,
	4730:  0xC38B,
	4731:  0xC38D,
	4732:  0xC38E,
	4733:  0xC38F,
	4734:  0xC390,
	4735:  0xC391,
	4736:  0xC392,
	4737:  0xC393,
	4738:  0xC394,
	4739:  0xC395,
	4740:  0xC396,
	4741:  0xC397,
	4742:  0xC398,
	4743:  0xC399,
	4744:  0xC39A,
	4745:  0xC39B,
	4746:  0xC39C,
	4747:  0xC39D,
	4748:  0xC39E,
	4749:  0xC39F,
	4750:  0xC3A0,
	4751:  0xC3A1,
	4752:  0xC3A2,
	4753:  0xC3A3,
	4754:  0xC3A4,
	4755:  0xC3A5,
	4756:  0xC3A6,
	4757:  0xC3A7,
	4758:  0xC3A8,
	4759:  0xC3A9,
	4760:  0xC3AA,
	4761:  0xC3AB,
	4762:  0xC3AC,
	4763:  0xC3AD,
	4764:  0xC3AE,
	4765:  0xC3AF,
	4766:  0xC3B0,
	4767:  0xC3B1,
	4768:  0xC3B2,
	4769:  0xC3B3,
	4770:  0xC3B4,
	4771:  0xC3B5,
	4772:  0xC3B6,
	4773:  0xC3B7,
	4774:  0xC3B8,
	4775:  0xC3B9,
	4776:  0xC3BA,
	4777:  0xC3BB,
	4778:  0xC3BC,
	4779:  0xC3BD,
	4780:  0xC3BE,
	4781:  0xC3BF,
	4782:  0xC3C1,
	4783:  0xC3C2,
	4784:  0xC3C3,
	4785:  0xC3C4,
	4786:  0xC3C5,
	4787:  0xC3C6,
	4788:  0xC3C7,
	4789:  0xC3C8,
	4790:  0xC3C9,
	4791:  0xC3CA,
	4792:  0xC3CB,
	4793:  0xC3CC,
	4794:  0xC3CD,
	4795:  0xC3CE,
	4796:  0xC3CF,
	4797:  0xC3D0,
	4798:  0xC3D1,
	4799:  0xC3D2,
	4800:  0xC3D3,
	4801:  0xC3D4,
	4802:  0xC3D5,
	4803:  0xC3D6,
	4804:  0xC3D7,
	4805:  0xC3DA,
	4806:  0xC3DB,
	4807:  0xC3DD,
	4808:  0xC3DE,
	4809:  0xC3E1,
	4810:  0xC3E3,
	4811:  0xC3E4,
	4812:  0xC3E5,
	4813:  0xC3E6,
	4814:  0xC3E7,
	4815:  0xC3EA,
	4816:  0xC3EB,
	4817:  0xC3EC,
	4818:  0xC3EE,
	4819:  0xC3EF,
	4820:  0xC3F0,
	4821:  0xC3F1,
	4822:  0xC3F2,
	4823:  0xC3F3,
	4824:  0xC3F6,
	4825:  0xC3F7,
	4826:  0xC3F9,
	4827:  0xC3FA,
	4828:  0xC3FB,
	4829:  0xC3FC,
	4830:  0xC3FD,
	4831:  0xC3FE,
	4832:  0xC3FF,
	4833:  0xC400,
	4834:  0xC401,
	4835:  0xC402,
	4836:  0xC403,
	4837:  0xC404,
	4838:  0xC405,
	4839:  0xC406,
	4840:  0xC407,
	4841:  0xC409,
	4842:  0xC40A,
	4843:  0xC40B,
	4844:  0xC40C,
	4845:  0xC40D,
	4846:  0xC40E,
	4847:  0xC40F,
	4848:  0xC411,
	4849:  0xC412,
	4850:  0xC413,
	4851:  0xC414,
	4852:  0xC415,
	4853:  0xC416,
	4854:  0xC417,
	4855:  0xC418,
	4856:  0xC419,
	4857:  0xC41A,
	4858:  0xC41B,
	4859:  0xC41C,
	4860:  0xC41D,
	4861:  0xC41E,
	4862:  0xC41F,
	4863:  0xC420,
	4864:  0xC421,
	4865:  0xC422,
	4866:  0xC423,
	4867:  0xC425,
	4868:  0xC426,
	4869:  0xC427,
	4870:  0xC428,
	4871:  0xC429,
	4872:  0xC42A,
	4873:  0xC42B,
	4874:  0xC42D,
	4875:  0xC42E,
	4876:  0xC42F,
	4877:  0xC431,
	4878:  0xC432,
	4879:  0xC433,
	4880:  0xC435,
	4881:  0xC436,
	4882:  0xC437,
	4883:  0xC438,
	4884:  0xC439,
	4885:  0xC43A,
	4886:  0xC43B,
	4887:  0xC43E,
	4888:  0xC43F,
	4889:  0xC440,
	4890:  0xC441,
	4891:  0xC442,
	4892:  0xC443,
	4893:  0xC444,
	4894:  0xC445,
	4895:  0xC446,
	4896:  0xC447,
	4897:  0xC449,
	4898:  0xC44A,
	4899:  0xC44B,
	4900:  0xC44C,
	4901:  0xC44D,
	4902:  0xC44E,
	4903:  0xC44F,
	4904:  0xC450,
	4905:  0xC451,
	4906:  0xC452,
	4907:  0xC453,
	4908:  0xC454,
	4909:  0xC455,
	4910:  0xC456,
	4911:  0xC457,
	4912:  0xC458,
	4913:  0xC459,
	4914:  0xC45A,
	4915:  0xC45B,
	4916:  0xC45C,
	4917:  0xC45D,
	4918:  0xC45E,
	4919:  0xC45F,
	4920:  0xC460,
	4921:  0xC461,
	4922:  0xC462,
	4923:  0xC463,
	4924:  0xC466,
	4925:  0xC467,
	4926:  0xC469,
	4927:  0xC46A,
	4928:  0xC46B,
	4929:  0xC46D,
	4930:  0xC46E,
	4931:  0xC46F,
	4932:  0xC470,
	4933:  0xC471,
	4934:  0xC472,
	4935:  0xC473,
	4936:  0xC476,
	4937:  0xC477,
	4938:  0xC478,
	4939:  0xC47A,
	4940:  0xC47B,
	4941:  0xC47C,
	4942:  0xC47D,
	4943:  0xC47E,
	4944:  0xC47F,
	4945:  0xC481,
	4946:  0xC482,
	4947:  0xC483,
	4948:  0xC484,
	4949:  0xC485,
	4950:  0xC486,
	4951:  0xC487,
	4952:  0xC488,
	4953:  0xC489,
	4954:  0xC48A,
	4955:  0xC48B,
	4956:  0xC48C,
	4957:  0xC48D,
	4958:  0xC48E,
	4959:  0xC48F,
	4960:  0xC490,
	4961:  0xC491,
	4962:  0xC492,
	4963:  0xC493,
	4964:  0xC495,
	4965:  0xC496,
	4966:  0xC497,
	4967:  0xC498,
	4968:  0xC499,
	4969:  0xC49A,
	4970:  0xC49B,
	4971:  0xC49D,
	4972:  0xC49E,
	4973:  0xC49F,
	4974:  0xC4A0,
	4975:  0xC4A1,
	4976:  0xC4A2,
	4977:  0xC4A3,
	4978:  0xC4A4,
	4979:  0xC4A5,
	4980:  0xC4A6,
	4981:  0xC4A7,
	4982:  0xC4A8,
	4983:  0xC4A9,
	4984:  0xC4AA,
	4985:  0xC4AB,
	4986:  0xC4AC,
	4987:  0xC4AD,
	4988:  0xC4AE,
	4989:  0xC4AF,
	4990:  0xC4B0,
	4991:  0xC4B1,
	4992:  0xC4B2,
	4993:  0xC4B3,
	4994:  0xC4B4,
	4995:  0xC4B5,
	4996:  0xC4B6,
	4997:  0xC4B7,
	4998:  0xC4B9,
	4999:  0xC4BA,
	5000:  0xC4BB,
	5001:  0xC4BD,
	5002:  0xC4BE,
	5003:  0xC4BF,
	5004:  0xC4C0,
	5005:  0xC4C1,
	5006:  0xC4C2,
	5007:  0xC4C3,
	5008:  0xC4C4,
	5009:  0xC4C5,
	5010:  0xC4C6,
	5011:  0xC4C7,
	5012:  0xC4C8,
	5013:  0xC4C9,
	5014:  0xC4CA,
	5015:  0xC4CB,
	5016:  0xC4CC,
	5017:  0xC4CD,
	5018:  0xC4CE,
	5019:  0xC4CF,
	5020:  0xC4D0,
	5021:  0xC4D1,
	5022:  0xC4D2,
	5023:  0xC4D3,
	5024:  0xC4D4,
	5025:  0xC4D5,
	5026:  0xC4D6,
	5027:  0xC4D7,
	5028:  0xC4D8,
	5029:  0xC4D9,
	5030:  0xC4DA,
	5031:  0xC4DB,
	5032:  0xC4DC,
	5033:  0xC4DD,
	5034:  0xC4DE,
	5035:  0xC4DF,
	5036:  0xC4E0,
	5037:  0xC4E1,
	5038:  0xC4E2,
	5039:  0xC4E3,
	5040:  0xC4E4,
	5041:  0xC4E5,
	5042:  0xC4E6,
	5043:  0xC4E7,
	5044:  0xC4E8,
	5045:  0xC4EA,
	5046:  0xC4EB,
	5047:  0xC4EC,
	5048:  0xC4ED,
	5049:  0xC4EE,
	5050:  0xC4EF,
	5051:  0xC4F2,
	5052:  0xC4F3,
	5053:  0xC4F5,
	5054:  0xC4F6,
	5055:  0xC4F7,
	5056:  0xC4F9,
	5057:  0xC4FB,
	5058:  0xC4FC,
	5059:  0xC4FD,
	5060:  0xC4FE,
	5061:  0xC502,
	5062:  0xC503,
	5063:  0xC504,
	5064:  0xC505,
	5065:  0xC506,
	5066:  0xC507,
	5067:  0xC508,
	5068:  0xC509,
	5069:  0xC50A,
	5070:  0xC50B,
	5071:  0xC50D,
	5072:  0xC50E,
	5073:  0xC50F,
	5074:  0xC511,
	5075:  0xC512,
	5076:  0xC513,
	5077:  0xC515,
	5078:  0xC516,
	5079:  0xC517,
	5080:  0xC518,
	5081:  0xC519,
	5082:  0xC51A,
	5083:  0xC51B,
	5084:  0xC51D,
	5085:  0xC51E,
	5086:  0xC51F,
	5087:  0xC520,
	5088:  0xC521,
	5089:  0xC522,
	5090:  0xC523,
	5091:  0xC524,
	5092:  0xC525,
	5093:  0xC526,
	5094:  0xC527,
	5095:  0xC52A,
	5096:  0xC52B,
	5097:  0xC52D,
	5098:  0xC52E,
	5099:  0xC52F,
	5100:  0xC531,
	5101:  0xC532,
	5102:  0xC533,
	5103:  0xC534,
	5104:  0xC535,
	5105:  0xC536,
	5106:  0xC537,
	5107:  0xC53A,
	5108:  0xC53C,
	5109:  0xC53E,
	5110:  0xC53F,
	5111:  0xC540,
	5112:  0xC541,
	5113:  0xC542,
	5114:  0xC543,
	5115:  0xC546,
	5116:  0xC547,
	5117:  0xC54B,
	5118:  0xC54F,
	5119:  0xC550,
	5120:  0xC551,
	5121:  0xC552,
	5122:  0xC556,
	5123:  0xC55A,
	5124:  0xC55B,
	5125:  0xC55C,
	5126:  0xC55F,
	5127:  0xC562,
	5128:  0xC563,
	5129:  0xC565,
	5130:  0xC566,
	5131:  0xC567,
	5132:  0xC569,
	5133:  0xC56A,
	5134:  0xC56B,
	5135:  0xC56C,
	5136:  0xC56D,
	5137:  0xC56E,
	5138:  0xC56F,
	5139:  0xC572,
	5140:  0xC576,
	5141:  0xC577,
	5142:  0xC578,
	5143:  0xC579,
	5144:  0xC57A,
	5145:  0xC57B,
	5146:  0xC57E,
	5147:  0xC57F,
	5148:  0xC581,
	5149:  0xC582,
	5150:  0xC583,
	5151:  0xC585,
	5152:  0xC586,
	5153:  0xC588,
	5154:  0xC589,
	5155:  0xC58A,
	5156:  0xC58B,
	5157:  0xC58E,
	5158:  0xC590,
	5159:  0xC592,
	5160:  0xC593,
	5161:  0xC594,
	5162:  0xC596,
	5163:  0xC599,
	5164:  0xC59A,
	5165:  0xC59B,
	5166:  0xC59D,
	5167:  0xC59E,
	5168:  0xC59F,
	5169:  0xC5A1,
	5170:  0xC5A2,
	5171:  0xC5A3,
	5172:  0xC5A4,
	5173:  0xC5A5,
	5174:  0xC5A6,
	5175:  0xC5A7,
	5176:  0xC5A8,
	5177:  0xC5AA,
	5178:  0xC5AB,
	5179:  0xC5AC,
	5180:  0xC5AD,
	5181:  0xC5AE,
	5182:  0xC5AF,
	5183:  0xC5B0,
	5184:  0xC5B1,
	5185:  0xC5B2,
	5186:  0xC5B3,
	5187:  0xC5B6,
	5188:  0xC5B7,
	5189:  0xC5BA,
	5190:  0xC5BF,
	5191:  0xC5C0,
	5192:  0xC5C1,
	5193:  0xC5C2,
	5194:  0xC5C3,
	5195:  0xC5CB,
	5196:  0xC5CD,
	5197:  0xC5CF,
	5198:  0xC5D2,
	5199:  0xC5D3,
	5200:  0xC5D5,
	5201:  0xC5D6,
	5202:  0xC5D7,
	5203:  0xC5D9,
	5204:  0xC5DA,
	5205:  0xC5DB,
	5206:  0xC5DC,
	5207:  0xC5DD,
	5208:  0xC5DE,
	5209:  0xC5DF,
	5210:  0xC5E2,
	5211:  0xC5E4,
	5212:  0xC5E6,
	5213:  0xC5E7,
	5214:  0xC5E8,
	5215:  0xC5E9,
	5216:  0xC5EA,
	5217:  0xC5EB,
	5218:  0xC5EF,
	5219:  0xC5F1,
	5220:  0xC5F2,
	5221:  0xC5F3,
	5222:  0xC5F5,
	5223:  0xC5F8,
	5224:  0xC5F9,
	5225:  0xC5FA,
	5226:  0xC5FB,
	5227:  0xC602,
	5228:  0xC603,
	5229:  0xC604,
	5230:  0xC609,
	5231:  0xC60A,
	5232:  0xC60B,
	5233:  0xC60D,
	5234:  0xC60E,
	5235:  0xC60F,
	5236:  0xC611,
	5237:  0xC612,
	5238:  0xC613,
	5239:  0xC614,
	5240:  0xC615,
	5241:  0xC616,
	5242:  0xC617,
	5243:  0xC61A,
	5244:  0xC61D,
	5245:  0xC61E,
	5246:  0xC61F,
	5247:  0xC620,
	5248:  0xC621,
	5249:  0xC622,
	5250:  0xC623,
	5251:  0xC626,
	5252:  0xC627,
	5253:  0xC629,
	5254:  0xC62A,
	5255:  0xC62B,
	5256:  0xC62F,
	5257:  0xC631,
	5258:  0xC632,
	5259:  0xC636,
	5260:  0xC638,
	5261:  0xC63A,
	5262:  0xC63C,
	5263:  0xC63D,
	5264:  0xC63E,
	5265:  0xC63F,
	5266:  0xC642,
	5267:  0xC643,
	5268:  0xC645,
	5269:  0xC646,
	5270:  0xC647,
	5271:  0xC649,
	5272:  0xC64A,
	5273:  0xC64B,
	5274:  0xC64C,
	5275:  0xC64D,
	5276:  0xC64E,
	5277:  0xC64F,
	5278:  0xC652,
	5279:  0xC656,
	5280:  0xC657,
	5281:  0xC658,
	5282:  0xC659,
	5283:  0xC65A,
	5284:  0xC65B,
	5285:  0xC65E,
	5286:  0xC65F,
	5287:  0xC661,
	5288:  0xC662,
	5289:  0xC663,
	5290:  0xC664,
	5291:  0xC665,
	5292:  0xC666,
	5293:  0xC667,
	5294:  0xC668,
	5295:  0xC669,
	5296:  0xC66A,
	5297:  0xC66B,
	5298:  0xC66D,
	5299:  0xC66E,
	5300:  0xC670,
	5301:  0xC672,
	5302:  0xC673,
	5303:  0xC674,
	5304:  0xC675,
	5305:  0xC676,
	5306:  0xC677,
	5307:  0xC67A,
	5308:  0xC67B,
	5309:  0xC67D,
	5310:  0xC67E,
	5311:  0xC67F,
	5312:  0xC681,
	5313:  0xC682,
	5314:  0xC683,
	5315:  0xC684,
	5316:  0xC685,
	5317:  0xC686,
	5318:  0xC687,
	5319:  0xC68A,
	5320:  0xC68C,
	5321:  0xC68E,
	5322:  0xC68F,
	5323:  0xC690,
	5324:  0xC691,
	5325:  0xC692,
	5326:  0xC693,
	5327:  0xC696,
	5328:  0xC697,
	5329:  0xC699,
	5330:  0xC69A,
	5331:  0xC69B,
	5332:  0xC69D,
	5333:  0xC69E,
	5334:  0xC69F,
	5335:  0xC6A0,
	5336:  0xC6A1,
	5337:  0xC6A2,
	5338:  0xC6A3,
	5339:  0xC6A6,
	5340:  0xC6A8,
	5341:  0xC6AA,
	5342:  0xC6AB,
	5343:  0xC6AC,
	5344:  0xC6AD,
	5345:  0xC6AE,
	5346:  0xC6AF,
	5347:  0xC6B2,
	5348:  0xC6B3,
	5349:  0xC6B5,
	5350:  0xC6B6,
	5351:  0xC6B7,
	5352:  0xC6BB,
	5353:  0xC6BC,
	5354:  0xC6BD,
	5355:  0xC6BE,
	5356:  0xC6BF,
	5357:  0xC6C2,
	5358:  0xC6C4,
	5359:  0xC6C6,
	5360:  0xC6C7,
	5361:  0xC6C8,
	5362:  0xC6C9,
	5363:  0xC6CA,
	5364:  0xC6CB,
	5365:  0xC6CE,
	5366:  0xC6CF,
	5367:  0xC6D1,
	5368:  0xC6D2,
	5369:  0xC6D3,
	5370:  0xC6D5,
	5371:  0xC6D6,
	5372:  0xC6D7,
	5373:  0xC6D8,
	5374:  0xC6D9,
	5375:  0xC6DA,
	5376:  0xC6DB,
	5377:  0xC6DE,
	5378:  0xC6DF,
	5379:  0xC6E2,
	5380:  0xC6E3,
	5381:  0xC6E4,
	5382:  0xC6E5,
	5383:  0xC6E6,
	5384:  0xC6E7,
	5385:  0xC6EA,
	5386:  0xC6EB,
	5387:  0xC6ED,
	5388:  0xC6EE,
	5389:  0xC6EF,
	5390:  0xC6F1,
	5391:  0xC6F2,
	5392:  0xC6F3,
	5393:  0xC6F4,
	5394:  0xC6F5,
	5395:  0xC6F6,
	5396:  0xC6F7,
	5397:  0xC6FA,
	5398:  0xC6FB,
	5399:  0xC6FC,
	5400:  0xC6FE,
	5401:  0xC6FF,
	5402:  0xC700,
	5403:  0xC701,
	5404:  0xC702,
	5405:  0xC703,
	5406:  0xC706,
	5407:  0xC707,
	5408:  0xC709,
	5409:  0xC70A,
	5410:  0xC70B,
	5411:  0xC70D,
	5412:  0xC70E,
	5413:  0xC70F,
	5414:  0xC710,
	5415:  0xC711,
	5416:  0xC712,
	5417:  0xC713,
	5418:  0xC716,
	5419:  0xC718,
	5420:  0xC71A,
	5421:  0xC71B,
	5422:  0xC71C,
	5423:  0xC71D,
	5424:  0xC71E,
	5425:  0xC71F,
	5426:  0xC722,
	5427:  0xC723,
	5428:  0xC725,
	5429:  0xC726,
	5430:  0xC727,
	5431:  0xC729,
	5432:  0xC72A,
	5433:  0xC72B,
	5434:  0xC72C,
	5435:  0xC72D,
	5436:  0xC72E,
	5437:  0xC72F,
	5438:  0xC732,
	5439:  0xC734,
	5440:  0xC736,
	5441:  0xC738,
	5442:  0xC739,
	5443:  0xC73A,
	5444:  0xC73B,
	5445:  0xC73E,
	5446:  0xC73F,
	5447:  0xC741,
	5448:  0xC742,
	5449:  0xC743,
	5450:  0xC745,
	5451:  0xC746,
	5452:  0xC747,
	5453:  0xC748,
	5454:  0xC749,
	5455:  0xC74B,
	5456:  0xC74E,
	5457:  0xC750,
	5458:  0xC759,
	5459:  0xC75A,
	5460:  0xC75B,
	5461:  0xC75D,
	5462:  0xC75E,
	5463:  0xC75F,
	5464:  0xC761,
	5465:  0xC762,
	5466:  0xC763,
	5467:  0xC764,
	5468:  0xC765,
	5469:  0xC766,
	5470:  0xC767,
	5471:  0xC769,
	5472:  0xC76A,
	5473:  0xC76C,
	5474:  0xC76D,
	5475:  0xC76E,
	5476:  0xC76F,
	5477:  0xC770,
	5478:  0xC771,
	5479:  0xC772,
	5480:  0xC773,
	5481:  0xC776,
	5482:  0xC777,
	5483:  0xC779,
	5484:  0xC77A,
	5485:  0xC77B,
	5486:  0xC77F,
	5487:  0xC780,
	5488:  0xC781,
	5489:  0xC782,
	5490:  0xC786,
	5491:  0xC78B,
	5492:  0xC78C,
	5493:  0xC78D,
	5494:  0xC78F,
	5495:  0xC792,
	5496:  0xC793,
	5497:  0xC795,
	5498:  0xC799,
	5499:  0xC79B,
	5500:  0xC79C,
	5501:  0xC79D,
	5502:  0xC79E,
	5503:  0xC79F,
	5504:  0xC7A2,
	5505:  0xC7A7,
	5506:  0xC7A8,
	5507:  0xC7A9,
	5508:  0xC7AA,
	5509:  0xC7AB,
	5510:  0xC7AE,
	5511:  0xC7AF,
	5512:  0xC7B1,
	5513:  0xC7B2,
	5514:  0xC7B3,
	5515:  0xC7B5,
	5516:  0xC7B6,
	5517:  0xC7B7,
	5518:  0xC7B8,
	5519:  0xC7B9,
	5520:  0xC7BA,
	5521:  0xC7BB,
	5522:  0xC7BE,
	5523:  0xC7C2,
	5524:  0xC7C3,
	5525:  0xC7C4,
	5526:  0xC7C5,
	5527:  0xC7C6,
	5528:  0xC7C7,
	5529:  0xC7CA,
	5530:  0xC7CB,
	5531:  0xC7CD,
	5532:  0xC7CF,
	5533:  0xC7D1,
	5534:  0xC7D2,
	5535:  0xC7D3,
	5536:  0xC7D4,
	5537:  0xC7D5,
	5538:  0xC7D6,
	5539:  0xC7D7,
	5540:  0xC7D9,
	5541:  0xC7DA,
	5542:  0xC7DB,
	5543:  0xC7DC,
	5544:  0xC7DE,
	5545:  0xC7DF,
	5546:  0xC7E0,
	5547:  0xC7E1,
	5548:  0xC7E2,
	5549:  0xC7E3,
	5550:  0xC7E5,
	5551:  0xC7E6,
	5552:  0xC7E7,
	5553:  0xC7E9,
	5554:  0xC7EA,
	5555:  0xC7EB,
	5556:  0xC7ED,
	5557:  0xC7EE,
	5558:  0xC7EF,
	5559:  0xC7F0,
	5560:  0xC7F1,
	5561:  0xC7F2,
	5562:  0xC7F3,
	5563:  0xC7F4,
	5564:  0xC7F5,
	5565:  0xC7F6,
	5566:  0xC7F7,
	5567:  0xC7F8,
	5568:  0xC7F9,
	5569:  0xC7FA,
	5570:  0xC7FB,
	5571:  0xC7FC,
	5572:  0xC7FD,
	5573:  0xC7FE,
	5574:  0xC7FF,
	5575:  0xC802,
	5576:  0xC803,
	5577:  0xC805,
	5578:  0xC806,
	5579:  0xC807,
	5580:  0xC809,
	5581:  0xC80B,
	5582:  0xC80C,
	5583:  0xC80D,
	5584:  0xC80E,
	5585:  0xC80F,
	5586:  0xC812,
	5587:  0xC814,
	5588:  0xC817,
	5589:  0xC818,
	5590:  0xC819,
	5591:  0xC81A,
	5592:  0xC81B,
	5593:  0xC81E,
	5594:  0xC81F,
	5595:  0xC821,
	5596:  0xC822,
	5597:  0xC823,
	5598:  0xC825,
	5599:  0xC826,
	5600:  0xC827,
	5601:  0xC828,
	5602:  0xC829,
	5603:  0xC82A,
	5604:  0xC82B,
	5605:  0xC82E,
	5606:  0xC830,
	5607:  0xC832,
	5608:  0xC833,
	5609:  0xC834,
	5610:  0xC835,
	5611:  0xC836,
	5612:  0xC837,
	5613:  0xC839,
	5614:  0xC83A,
	5615:  0xC83B,
	5616:  0xC83D,
	5617:  0xC83E,
	5618:  0xC83F,
	5619:  0xC841,
	5620:  0xC842,
	5621:  0xC843,
	5622:  0xC844,
	5623:  0xC845,
	5624:  0xC846,
	5625:  0xC847,
	5626:  0xC84A,
	5627:  0xC84B,
	5628:  0xC84E,
	5629:  0xC84F,
	5630:  0xC850,
	5631:  0xC851,
	5632:  0xC852,
	5633:  0xC853,
	5634:  0xC855,
	5635:  0xC856,
	5636:  0xC857,
	5637:  0xC858,
	5638:  0xC859,
	5639:  0xC85A,
	5640:  0xC85B,
	5641:  0xC85C,
	5642:  0xC85D,
	5643:  0xC85E,
	5644:  0xC85F,
	5645:  0xC860,
	5646:  0xC861,
	5647:  0xC862,
	5648:  0xC863,
	5649:  0xC864,
	5650:  0xC865,
	5651:  0xC866,
	5652:  0xC867,
	5653:  0xC868,
	5654:  0xC869,
	5655:  0xC86A,
	5656:  0xC86B,
	5657:  0xC86C,
	5658:  0xC86D,
	5659:  0xC86E,
	5660:  0xC86F,
	5661:  0xC872,
	5662:  0xC873,
	5663:  0xC875,
	5664:  0xC876,
	5665:  0xC877,
	5666:  0xC879,
	5667:  0xC87B,
	5668:  0xC87C,
	5669:  0xC87D,
	5670:  0xC87E,
	5671:  0xC87F,
	5672:  0xC882,
	5673:  0xC884,
	5674:  0xC888,
	5675:  0xC889,
	5676:  0xC88A,
	5677:  0xC88E,
	5678:  0xC88F,
	5679:  0xC890,
	5680:  0xC891,
	5681:  0xC892,
	5682:  0xC893,
	5683:  0xC895,
	5684:  0xC896,
	5685:  0xC897,
	5686:  0xC898,
	5687:  0xC899,
	5688:  0xC89A,
	5689:  0xC89B,
	5690:  0xC89C,
	5691:  0xC89E,
	5692:  0xC8A0,
	5693:  0xC8A2,
	5694:  0xC8A3,
	5695:  0xC8A4,
	5696:  0xC8A5,
	5697:  0xC8A6,
	5698:  0xC8A7,
	5699:  0xC8A9,
	5700:  0xC8AA,
	5701:  0xC8AB,
	5702:  0xC8AC,
	5703:  0xC8AD,
	5704:  0xC8AE,
	5705:  0xC8AF,
	5706:  0xC8B0,
	5707:  0xC8B1,
	5708:  0xC8B2,
	5709:  0xC8B3,
	5710:  0xC8B4,
	5711:  0xC8B5,
	5712:  0xC8B6,
	5713:  0xC8B7,
	5714:  0xC8B8,
	5715:  0xC8B9,
	5716:  0xC8BA,
	5717:  0xC8BB,
	5718:  0xC8BE,
	5719:  0xC8BF,
	5720:  0xC8C0,
	5721:  0xC8C1,
	5722:  0xC8C2,
	5723:  0xC8C3,
	5724:  0xC8C5,
	5725:  0xC8C6,
	5726:  0xC8C7,
	5727:  0xC8C9,
	5728:  0xC8CA,
	5729:  0xC8CB,
	5730:  0xC8CD,
	5731:  0xC8CE,
	5732:  0xC8CF,
	5733:  0xC8D0,
	5734:  0xC8D1,
	5735:  0xC8D2,
	5736:  0xC8D3,
	5737:  0xC8D6,
	5738:  0xC8D8,
	5739:  0xC8DA,
	5740:  0xC8DB,
	5741:  0xC8DC,
	5742:  0xC8DD,
	5743:  0xC8DE,
	5744:  0xC8DF,
	5745:  0xC8E2,
	5746:  0xC8E3,
	5747:  0xC8E5,
	5748:  0xC8E6,
	5749:  0xC8E7,
	5750:  0xC8E8,
	5751:  0xC8E9,
	5752:  0xC8EA,
	5753:  0xC8EB,
	5754:  0xC8EC,
	5755:  0xC8ED,
	5756:  0xC8EE,
	5757:  0xC8EF,
	5758:  0xC8F0,
	5759:  0xC8F1,
	5760:  0xC8F2,
	5761:  0xC8F3,
	5762:  0xC8F4,
	5763:  0xC8F6,
	5764:  0xC8F7,
	5765:  0xC8F8,
	5766:  0xC8F9,
	5767:  0xC8FA,
	5768:  0xC8FB,
	5769:  0xC8FE,
	5770:  0xC8FF,
	5771:  0xC901,
	5772:  0xC902,
	5773:  0xC903,
	5774:  0xC907,
	5775:  0xC908,
	5776:  0xC909,
	5777:  0xC90A,
	5778:  0xC90B,
	5779:  0xC90E,
	5780:  0x3000,
	5781:  0x3001,
	5782:  0x3002,
	5783:  0x00B7,
	5784:  0x2025,
	5785:  0x2026,
	5786:  0x00A8,
	5787:  0x3003,
	5788:  0x00AD,
	5789:  0x2015,
	5790:  0x2225,
	5791:  0xFF3C,
	5792:  0x223C,
	5793:  0x2018,
	5794:  0x2019,
	5795:  0x201C,
	5796:  0x201D,
	5797:  0x3014,
	5798:  0x3015,
	5799:  0x3008,
	5800:  0x3009,
	5801:  0x300A,
	5802:  0x300B,
	5803:  0x300C,
	5804:  0x300D,
	5805:  0x300E,
	5806:  0x300F,
	5807:  0x3010,
	5808:  0x3011,
	5809:  0x00B1,
	5810:  0x00D7,
	5811:  0x00F7,
	5812:  0x2260,
	5813:  0x2264,
	5814:  0x2265,
	5815:  0x221E,
	5816:  0x2234,
	5817:  0x00B0,
	5818:  0x2032,
	5819:  0x2033,
	5820:  0x2103,
	5821:  0x212B,
	5822:  0xFFE0,
	5823:  0xFFE1,
	5824:  0xFFE5,
	5825:  0x2642,
	5826:  0x2640,
	5827:  0x2220,
	5828:  0x22A5,
	5829:  0x2312,
	5830:  0x2202,
	5831:  0x2207,
	5832:  0x2261,
	5833:  0x2252,
	5834:  0x00A7,
	5835:  0x203B,
	5836:  0x2606,
	5837:  0x2605,
	5838:  0x25CB,
	5839:  0x25CF,
	5840:  0x25CE,
	5841:  0x25C7,
	5842:  0x25C6,
	5843:  0x25A1,
	5844:  0x25A0,
	5845:  0x25B3,
	5846:  0x25B2,
	5847:  0x25BD,
	5848:  0x25BC,
	5849:  0x2192,
	5850:  0x2190,
	5851:  0x2191,
	5852:  0x2193,
	5853:  0x2194,
	5854:  0x3013,
	5855:  0x226A,
	5856:  0x226B,
	5857:  0x221A,
	5858:  0x223D,
	5859:  0x221D,
	5860:  0x2235,
	5861:  0x222B,
	5862:  0x222C,
	5863:  0x2208,
	5864:  0x220B,
	5865:  0x2286,
	5866:  0x2287,
	5867:  0x2282,
	5868:  0x2283,
	5869:  0x222A,
	5870:  0x2229,
	5871:  0x2227,
	5872:  0x2228,
	5873:  0xFFE2,
	5874:  0xC910,
	5875:  0xC912,
	5876:  0xC913,
	5877:  0xC914,
	5878:  0xC915,
	5879:  0xC916,
	5880:  0xC917,
	5881:  0xC919,
	5882:  0xC91A,
	5883:  0xC91B,
	5884:  0xC91C,
	5885:  0xC91D,
	5886:  0xC91E,
	5887:  0xC91F,
	5888:  0xC920,
	5889:  0xC921,
	5890:  0xC922,
	5891:  0xC923,
	5892:  0xC924,
	5893:  0xC925,
	5894:  0xC926,
	5895:  0xC927,
	5896:  0xC928,
	5897:  0xC929,
	5898:  0xC92A,
	5899:  0xC92B,
	5900:  0xC92D,
	5901:  0xC92E,
	5902:  0xC92F,
	5903:  0xC930,
	5904:  0xC931,
	5905:  0xC932,
	5906:  0xC933,
	5907:  0xC935,
	5908:  0xC936,
	5909:  0xC937,
	5910:  0xC938,
	5911:  0xC939,
	5912:  0xC93A,
	5913:  0xC93B,
	5914:  0xC93C,
	5915:  0xC93D,
	5916:  0xC93E,
	5917:  0xC93F,
	5918:  0xC940,
	5919:  0xC941,
	5920:  0xC942,
	5921:  0xC943,
	5922:  0xC944,
	5923:  0xC945,
	5924:  0xC946,
	5925:  0xC947,
	5926:  0xC948,
	5927:  0xC949,
	5928:  0xC94A,
	5929:  0xC94B,
	5930:  0xC94C,
	5931:  0xC94D,
	5932:  0xC94E,
	5933:  0xC94F,
	5934:  0xC952,
	5935:  0xC953,
	5936:  0xC955,
	5937:  0xC956,
	5938:  0xC957,
	5939:  0xC959,
	5940:  0xC95A,
	5941:  0xC95B,
	5942:  0xC95C,
	5943:  0xC95D,
	5944:  0xC95E,
	5945:  0xC95F,
	5946:  0xC962,
	5947:  0xC964,
	5948:  0xC965,
	5949:  0xC966,
	5950:  0xC967,
	5951:  0xC968,
	5952:  0xC969,
	5953:  0xC96A,
	5954:  0xC96B,
	5955:  0xC96D,
	5956:  0xC96E,
	5957:  0xC96F,
	5958:  0x21D2,
	5959:  0x21D4,
	5960:  0x2200,
	5961:  0x2203,
	5962:  0x00B4,
	5963:  0xFF5E,
	5964:  0x02C7,
	5965:  0x02D8,
	5966:  0x02DD,
	5967:  0x02DA,
	5968:  0x02D9,
	5969:  0x00B8,
	5970:  0x02DB,
	5971:  0x00A1,
	5972:  0x00BF,
	5973:  0x02D0,
	5974:  0x222E,
	5975:  0x2211,
	5976:  0x220F,
	5977:  0x00A4,
	5978:  0x2109,
	5979:  0x2030,
	5980:  0x25C1,
	5981:  0x25C0,
	5982:  0x25B7,
	5983:  0x25B6,
	5984:  0x2664,
	5985:  0x2660,
	5986:  0x2661,
	5987:  0x2665,
	5988:  0x2667,
	5989:  0x2663,
	5990:  0x2299,
	5991:  0x25C8,
	5992:  0x25A3,
	5993:  0x25D0,
	5994:  0x25D1,
	5995:  0x2592,
	5996:  0x25A4,
	5997:  0x25A5,
	5998:  0x25A8,
	5999:  0x25A7,
	6000:  0x25A6,
	6001:  0x25A9,
	6002:  0x2668,
	6003:  0x260F,
	6004:  0x260E,
	6005:  0x261C,
	6006:  0x261E,
	6007:  0x00B6,
	6008:  0x2020,
	6009:  0x2021,
	6010:  0x2195,
	6011:  0x2197,
	6012:  0x2199,
	6013:  0x2196,
	6014:  0x2198,
	6015:  0x266D,
	6016:  0x2669,
	6017:  0x266A,
	6018:  0x266C,
	6019:  0x327F,
	6020:  0x321C,
	6021:  0x2116,
	6022:  0x33C7,
	6023:  0x2122,
	6024:  0x33C2,
	6025:  0x33D8,
	6026:  0x2121,
	6027:  0x20AC,
	6028:  0x00AE,
	6052:  0xC971,
	6053:  0xC972,
	6054:  0xC973,
	6055:  0xC975,
	6056:  0xC976,
	6057:  0xC977,
	6058:  0xC978,
	6059:  0xC979,
	6060:  0xC97A,
	6061:  0xC97B,
	6062:  0xC97D,
	6063:  0xC97E,
	6064:  0xC97F,
	6065:  0xC980,
	6066:  0xC981,
	6067:  0xC982,
	6068:  0xC983,
	6069:  0xC984,
	6070:  0xC985,
	6071:  0xC986,
	6072:  0xC987,
	6073:  0xC98A,
	6074:  0xC98B,
	6075:  0xC98D,
	6076:  0xC98E,
	6077:  0xC98F,
	6078:  0xC991,
	6079:  0xC992,
	6080:  0xC993,
	6081:  0xC994,
	6082:  0xC995,
	6083:  0xC996,
	6084:  0xC997,
	6085:  0xC99A,
	6086:  0xC99C,
	6087:  0xC99E,
	6088:  0xC99F,
	6089:  0xC9A0,
	6090:  0xC9A1,
	6091:  0xC9A2,
	6092:  0xC9A3,
	6093:  0xC9A4,
	6094:  0xC9A5,
	6095:  0xC9A6,
	6096:  0xC9A7,
	6097:  0xC9A8,
	6098:  0xC9A9,
	6099:  0xC9AA,
	6100:  0xC9AB,
	6101:  0xC9AC,
	6102:  0xC9AD,
	6103:  0xC9AE,
	6104:  0xC9AF,
	6105:  0xC9B0,
	6106:  0xC9B1,
	6107:  0xC9B2,
	6108:  0xC9B3,
	6109:  0xC9B4,
	6110:  0xC9B5,
	6111:  0xC9B6,
	6112:  0xC9B7,
	6113:  0xC9B8,
	6114:  0xC9B9,
	6115:  0xC9BA,
	6116:  0xC9BB,
	6117:  0xC9BC,
	6118:  0xC9BD,
	6119:  0xC9BE,
	6120:  0xC9BF,
	6121:  0xC9C2,
	6122:  0xC9C3,
	6123:  0xC9C5,
	6124:  0xC9C6,
	6125:  0xC9C9,
	6126:  0xC9CB,
	6127:  0xC9CC,
	6128:  0xC9CD,
	6129:  0xC9CE,
	6130:  0xC9CF,
	6131:  0xC9D2,
	6132:  0xC9D4,
	6133:  0xC9D7,
	6134:  0xC9D8,
	6135:  0xC9DB,
	6136:  0xFF01,
	6137:  0xFF02,
	6138:  0xFF03,
	6139:  0xFF04,
	6140:  0xFF05,
	6141:  0xFF06,
	6142:  0xFF07,
	6143:  0xFF08,
	6144:  0xFF09,
	6145:  0xFF0A,
	6146:  0xFF0B,
	6147:  0xFF0C,
	6148:  0xFF0D,
	6149:  0xFF0E,
	6150:  0xFF0F,
	6151:  0xFF10,
	6152:  0xFF11,
	6153:  0xFF12,
	6154:  0xFF13,
	6155:  0xFF14,
	6156:  0xFF15,
	6157:  0xFF16,
	6158:  0xFF17,
	6159:  0xFF18,
	6160:  0xFF19,
	6161:  0xFF1A,
	6162:  0xFF1B,
	6163:  0xFF1C,
	6164:  0xFF1D,
	6165:  0xFF1E,
	6166:  0xFF1F,
	6167:  0xFF20,
	6168:  0xFF21,
	6169:  0xFF22,
	6170:  0xFF23,
	6171:  0xFF24,
	6172:  0xFF25,
	6173:  0xFF26,
	6174:  0xFF27,
	6175:  0xFF28,
	6176:  0xFF29,
	6177:  0xFF2A,
	6178:  0xFF2B,
	6179:  0xFF2C,
	6180:  0xFF2D,
	6181:  0xFF2E,
	6182:  0xFF2F,
	6183:  0xFF30,
	6184:  0xFF31,
	6185:  0xFF32,
	6186:  0xFF33,
	6187:  0xFF34,
	6188:  0xFF35,
	6189:  0xFF36,
	6190:  0xFF37,
	6191:  0xFF38,
	6192:  0xFF39,
	6193:  0xFF3A,
	6194:  0xFF3B,
	6195:  0xFFE6,
	6196:  0xFF3D,
	6197:  0xFF3E,
	6198:  0xFF3F,
	6199:  0xFF40,
	6200:  0xFF41,
	6201:  0xFF42,
	6202:  0xFF43,
	6203:  0xFF44,
	6204:  0xFF45,
	6205:  0xFF46,
	6206:  0xFF47,
	6207:  0xFF48,
	6208:  0xFF49,
	6209:  0xFF4A,
	6210:  0xFF4B,
	6211:  0xFF4C,
	6212:  0xFF4D,
	6213:  0xFF4E,
	6214:  0xFF4F,
	6215:  0xFF50,
	6216:  0xFF51,
	6217:  0xFF52,
	6218:  0xFF53,
	6219:  0xFF54,
	6220:  0xFF55,
	6221:  0xFF56,
	6222:  0xFF57,
	6223:  0xFF58,
	6224:  0xFF59,
	6225:  0xFF5A,
	6226:  0xFF5B,
	6227:  0xFF5C,
	6228:  0xFF5D,
	6229:  0xFFE3,
	6230:  0xC9DE,
	6231:  0xC9DF,
	6232:  0xC9E1,
	6233:  0xC9E3,
	6234:  0xC9E5,
	6235:  0xC9E6,
	6236:  0xC9E8,
	6237:  0xC9E9,
	6238:  0xC9EA,
	6239:  0xC9EB,
	6240:  0xC9EE,
	6241:  0xC9F2,
	6242:  0xC9F3,
	6243:  0xC9F4,
	6244:  0xC9F5,
	6245:  0xC9F6,
	6246:  0xC9F7,
	6247:  0xC9FA,
	6248:  0xC9FB,
	6249:  0xC9FD,
	6250:  0xC9FE,
	6251:  0xC9FF,
	6252:  0xCA01,
	6253:  0xCA02,
	6254:  0xCA03,
	6255:  0xCA04,
	6256:  0xCA05,
	6257:  0xCA06,
	6258:  0xCA07,
	6259:  0xCA0A,
	6260:  0xCA0E,
	6261:  0xCA0F,
	6262:  0xCA10,
	6263:  0xCA11,
	6264:  0xCA12,
	6265:  0xCA13,
	6266:  0xCA15,
	6267:  0xCA16,
	6268:  0xCA17,
	6269:  0xCA19,
	6270:  0xCA1A,
	6271:  0xCA1B,
	6272:  0xCA1C,
	6273:  0xCA1D,
	6274:  0xCA1E,
	6275:  0xCA1F,
	6276:  0xCA20,
	6277:  0xCA21,
	6278:  0xCA22,
	6279:  0xCA23,
	6280:  0xCA24,
	6281:  0xCA25,
	6282:  0xCA26,
	6283:  0xCA27,
	6284:  0xCA28,
	6285:  0xCA2A,
	6286:  0xCA2B,
	6287:  0xCA2C,
	6288:  0xCA2D,
	6289:  0xCA2E,
	6290:  0xCA2F,
	6291:  0xCA30,
	6292:  0xCA31,
	6293:  0xCA32,
	6294:  0xCA33,
	6295:  0xCA34,
	6296:  0xCA35,
	6297:  0xCA36,
	6298:  0xCA37,
	6299:  0xCA38,
	6300:  0xCA39,
	6301:  0xCA3A,
	6302:  0xCA3B,
	6303:  0xCA3C,
	6304:  0xCA3D,
	6305:  0xCA3E,
	6306:  0xCA3F,
	6307:  0xCA40,
	6308:  0xCA41,
	6309:  0xCA42,
	6310:  0xCA43,
	6311:  0xCA44,
	6312:  0xCA45,
	6313:  0xCA46,
	6314:  0x3131,
	6315:  0x3132,
	6316:  0x3133,
	6317:  0x3134,
	6318:  0x3135,
	6319:  0x3136,
	6320:  0x3137,
	6321:  0x3138,
	6322:  0x3139,
	6323:  0x313A,
	6324:  0x313B,
	6325:  0x313C,
	6326:  0x313D,
	6327:  0x313E,
	6328:  0x313F,
	6329:  0x3140,
	6330:  0x3141,
	6331:  0x3142,
	6332:  0x3143,
	6333:  0x3144,
	6334:  0x3145,
	6335:  0x3146,
	6336:  0x3147,
	6337:  0x3148,
	6338:  0x3149,
	6339:  0x314A,
	6340:  0x314B,
	6341:  0x314C,
	6342:  0x314D,
	6343:  0x314E,
	6344:  0x314F,
	6345:  0x3150,
	6346:  0x3151,
	6347:  0x3152,
	6348:  0x3153,
	6349:  0x3154,
	6350:  0x3155,
	6351:  0x3156,
	6352:  0x3157,
	6353:  0x3158,
	6354:  0x3159,
	6355:  0x315A,
	6356:  0x315B,
	6357:  0x315C,
	6358:  0x315D,
	6359:  0x315E,
	6360:  0x315F,
	6361:  0x3160,
	6362:  0x3161,
	6363:  0x3162,
	6364:  0x3163,
	6365:  0x3164,
	6366:  0x3165,
	6367:  0x3166,
	6368:  0x3167,
	6369:  0x3168,
	6370:  0x3169,
	6371:  0x316A,
	6372:  0x316B,
	6373:  0x316C,
	6374:  0x316D,
	6375:  0x316E,
	6376:  0x316F,
	6377:  0x3170,
	6378:  0x3171,
	6379:  0x3172,
	6380:  0x3173,
	6381:  0x3174,
	6382:  0x3175,
	6383:  0x3176,
	6384:  0x3177,
	6385:  0x3178,
	6386:  0x3179,
	6387:  0x317A,
	6388:  0x317B,
	6389:  0x317C,
	6390:  0x317D,
	6391:  0x317E,
	6392:  0x317F,
	6393:  0x3180,
	6394:  0x3181,
	6395:  0x3182,
	6396:  0x3183,
	6397:  0x3184,
	6398:  0x3185,
	6399:  0x3186,
	6400:  0x3187,
	6401:  0x3188,
	6402:  0x3189,
	6403:  0x318A,
	6404:  0x318B,
	6405:  0x318C,
	6406:  0x318D,
	6407:  0x318E,
	6408:  0xCA47,
	6409:  0xCA48,
	6410:  0xCA49,
	6411:  0xCA4A,
	6412:  0xCA4B,
	6413:  0xCA4E,
	6414:  0xCA4F,
	6415:  0xCA51,
	6416:  0xCA52,
	6417:  0xCA53,
	6418:  0xCA55,
	6419:  0xCA56,
	6420:  0xCA57,
	6421:  0xCA58,
	6422:  0xCA59,
	6423:  0xCA5A,
	6424:  0xCA5B,
	6425:  0xCA5E,
	6426:  0xCA62,
	6427:  0xCA63,
	6428:  0xCA64,
	6429:  0xCA65,
	6430:  0xCA66,
	6431:  0xCA67,
	6432:  0xCA69,
	6433:  0xCA6A,
	6434:  0xCA6B,
	6435:  0xCA6C,
	6436:  0xCA6D,
	6437:  0xCA6E,
	6438:  0xCA6F,
	6439:  0xCA70,
	6440:  0xCA71,
	6441:  0xCA72,
	6442:  0xCA73,
	6443:  0xCA74,
	6444:  0xCA75,
	6445:  0xCA76,
	6446:  0xCA77,
	6447:  0xCA78,
	6448:  0xCA79,
	6449:  0xCA7A,
	6450:  0xCA7B,
	6451:  0xCA7C,
	6452:  0xCA7E,
	6453:  0xCA7F,
	6454:  0xCA80,
	6455:  0xCA81,
	6456:  0xCA82,
	6457:  0xCA83,
	6458:  0xCA85,
	6459:  0xCA86,
	6460:  0xCA87,
	6461:  0xCA88,
	6462:  0xCA89,
	6463:  0xCA8A,
	6464:  0xCA8B,
	6465:  0xCA8C,
	6466:  0xCA8D,
	6467:  0xCA8E,
	6468:  0xCA8F,
	6469:  0xCA90,
	6470:  0xCA91,
	6471:  0xCA92,
	6472:  0xCA93,
	6473:  0xCA94,
	6474:  0xCA95,
	6475:  0xCA96,
	6476:  0xCA97,
	6477:  0xCA99,
	6478:  0xCA9A,
	6479:  0xCA9B,
	6480:  0xCA9C,
	6481:  0xCA9D,
	6482:  0xCA9E,
	6483:  0xCA9F,
	6484:  0xCAA0,
	6485:  0xCAA1,
	6486:  0xCAA2,
	6487:  0xCAA3,
	6488:  0xCAA4,
	6489:  0xCAA5,
	6490:  0xCAA6,
	6491:  0xCAA7,
	6492:  0x2170,
	6493:  0x2171,
	6494:  0x2172,
	6495:  0x2173,
	6496:  0x2174,
	6497:  0x2175,
	6498:  0x2176,
	6499:  0x2177,
	6500:  0x2178,
	6501:  0x2179,
	6507:  0x2160,
	6508:  0x2161,
	6509:  0x2162,
	6510:  0x2163,
	6511:  0x2164,
	6512:  0x2165,
	6513:  0x2166,
	6514:  0x2167,
	6515:  0x2168,
	6516:  0x2169,
	6524:  0x0391,
	6525:  0x0392,
	6526:  0x0393,
	6527:  0x0394,
	6528:  0x0395,
	6529:  0x0396,
	6530:  0x0397,
	6531:  0x0398,
	6532:  0x0399,
	6533:  0x039A,
	6534:  0x039B,
	6535:  0x039C,
	6536:  0x039D,
	6537:  0x039E,
	6538:  0x039F,
	6539:  0x03A0,
	6540:  0x03A1,
	6541:  0x03A3,
	6542:  0x03A4,
	6543:  0x03A5,
	6544:  0x03A6,
	6545:  0x03A7,
	6546:  0x03A8,
	6547:  0x03A9,
	6556:  0x03B1,
	6557:  0x03B2,
	6558:  0x03B3,
	6559:  0x03B4,
	6560:  0x03B5,
	6561:  0x03B6,
	6562:  0x03B7,
	6563:  0x03B8,
	6564:  0x03B9,
	6565:  0x03BA,
	6566:  0x03BB,
	6567:  0x03BC,
	6568:  0x03BD,
	6569:  0x03BE,
	6570:  0x03BF,
	6571:  0x03C0,
	6572:  0x03C1,
	6573:  0x03C3,
	6574:  0x03C4,
	6575:  0x03C5,
	6576:  0x03C6,
	6577:  0x03C7,
	6578:  0x03C8,
	6579:  0x03C9,
	6586:  0xCAA8,
	6587:  0xCAA9,
	6588:  0xCAAA,
	6589:  0xCAAB,
	6590:  0xCAAC,
	6591:  0xCAAD,
	6592:  0xCAAE,
	6593:  0xCAAF,
	6594:  0xCAB0,
	6595:  0xCAB1,
	6596:  0xCAB2,
	6597:  0xCAB3,
	6598:  0xCAB4,
	6599:  0xCAB5,
	6600:  0xCAB6,
	6601:  0xCAB7,
	6602:  0xCAB8,
	6603:  0xCAB9,
	6604:  0xCABA,
	6605:  0xCABB,
	6606:  0xCABE,
	6607:  0xCABF,
	6608:  0xCAC1,
	6609:  0xCAC2,
	6610:  0xCAC3,
	6611:  0xCAC5,
	6612:  0xCAC6,
	6613:  0xCAC7,
	6614:  0xCAC8,
	6615:  0xCAC9,
	6616:  0xCACA,
	6617:  0xCACB,
	6618:  0xCACE,
	6619:  0xCAD0,
	6620:  0xCAD2,
	6621:  0xCAD4,
	6622:  0xCAD5,
	6623:  0xCAD6,
	6624:  0xCAD7,
	6625:  0xCADA,
	6626:  0xCADB,
	6627:  0xCADC,
	6628:  0xCADD,
	6629:  0xCADE,
	6630:  0xCADF,
	6631:  0xCAE1,
	6632:  0xCAE2,
	6633:  0xCAE3,
	6634:  0xCAE4,
	6635:  0xCAE5,
	6636:  0xCAE6,
	6637:  0xCAE7,
	6638:  0xCAE8,
	6639:  0xCAE9,
	6640:  0xCAEA,
	6641:  0xCAEB,
	6642:  0xCAED,
	6643:  0xCAEE,
	6644:  0xCAEF,
	6645:  0xCAF0,
	6646:  0xCAF1,
	6647:  0xCAF2,
	6648:  0xCAF3,
	6649:  0xCAF5,
	6650:  0xCAF6,
	6651:  0xCAF7,
	6652:  0xCAF8,
	6653:  0xCAF9,
	6654:  0xCAFA,
	6655:  0xCAFB,
	6656:  0xCAFC,
	6657:  0xCAFD,
	6658:  0xCAFE,
	6659:  0xCAFF,
	6660:  0xCB00,
	6661:  0xCB01,
	6662:  0xCB02,
	6663:  0xCB03,
	6664:  0xCB04,
	6665:  0xCB05,
	6666:  0xCB06,
	6667:  0xCB07,
	6668:  0xCB09,
	6669:  0xCB0A,
	6670:  0x2500,
	6671:  0x2502,
	6672:  0x250C,
	6673:  0x2510,
	6674:  0x2518,
	6675:  0x2514,
	6676:  0x251C,
	6677:  0x252C,
	6678:  0x2524,
	6679:  0x2534,
	6680:  0x253C,
	6681:  0x2501,
	6682:  0x2503,
	6683:  0x250F,
	6684:  0x2513,
	6685:  0x251B,
	6686:  0x2517,
	6687:  0x2523,
	6688:  0x2533,
	6689:  0x252B,
	6690:  0x253B,
	6691:  0x254B,
	6692:  0x2520,
	6693:  0x252F,
	6694:  0x2528,
	6695:  0x2537,
	6696:  0x253F,
	6697:  0x251D,
	6698:  0x2530,
	6699:  0x2525,
	6700:  0x2538,
	6701:  0x2542,
	6702:  0x2512,
	6703:  0x2511,
	6704:  0x251A,
	6705:  0x2519,
	6706:  0x2516,
	6707:  0x2515,
	6708:  0x250E,
	6709:  0x250D,
	6710:  0x251E,
	6711:  0x251F,
	6712:  0x2521,
	6713:  0x2522,
	6714:  0x2526,
	6715:  0x2527,
	6716:  0x2529,
	6717:  0x252A,
	6718:  0x252D,
	6719:  0x252E,
	6720:  0x2531,
	6721:  0x2532,
	6722:  0x2535,
	6723:  0x2536,
	6724:  0x2539,
	6725:  0x253A,
	6726:  0x253D,
	6727:  0x253E,
	6728:  0x2540,
	6729:  0x2541,
	6730:  0x2543,
	6731:  0x2544,
	6732:  0x2545,
	6733:  0x2546,
	6734:  0x2547,
	6735:  0x2548,
	6736:  0x2549,
	6737:  0x254A,
	6764:  0xCB0B,
	6765:  0xCB0C,
	6766:  0xCB0D,
	6767:  0xCB0E,
	6768:  0xCB0F,
	6769:  0xCB11,
	6770:  0xCB12,
	6771:  0xCB13,
	6772:  0xCB15,
	6773:  0xCB16,
	6774:  0xCB17,
	6775:  0xCB19,
	6776:  0xCB1A,
	6777:  0xCB1B,
	6778:  0xCB1C,
	6779:  0xCB1D,
	6780:  0xCB1E,
	6781:  0xCB1F,
	6782:  0xCB22,
	6783:  0xCB23,
	6784:  0xCB24,
	6785:  0xCB25,
	6786:  0xCB26,
	6787:  0xCB27,
	6788:  0xCB28,
	6789:  0xCB29,
	6790:  0xCB2A,
	6791:  0xCB2B,
	6792:  0xCB2C,
	6793:  0xCB2D,
	6794:  0xCB2E,
	6795:  0xCB2F,
	6796:  0xCB30,
	6797:  0xCB31,
	6798:  0xCB32,
	6799:  0xCB33,
	6800:  0xCB34,
	6801:  0xCB35,
	6802:  0xCB36,
	6803:  0xCB37,
	6804:  0xCB38,
	6805:  0xCB39,
	6806:  0xCB3A,
	6807:  0xCB3B,
	6808:  0xCB3C,
	6809:  0xCB3D,
	6810:  0xCB3E,
	6811:  0xCB3F,
	6812:  0xCB40,
	6813:  0xCB42,
	6814:  0xCB43,
	6815:  0xCB44,
	6816:  0xCB45,
	6817:  0xCB46,
	6818:  0xCB47,
	6819:  0xCB4A,
	6820:  0xCB4B,
	6821:  0xCB4D,
	6822:  0xCB4E,
	6823:  0xCB4F,
	6824:  0xCB51,
	6825:  0xCB52,
	6826:  0xCB53,
	6827:  0xCB54,
	6828:  0xCB55,
	6829:  0xCB56,
	6830:  0xCB57,
	6831:  0xCB5A,
	6832:  0xCB5B,
	6833:  0xCB5C,
	6834:  0xCB5E,
	6835:  0xCB5F,
	6836:  0xCB60,
	6837:  0xCB61,
	6838:  0xCB62,
	6839:  0xCB63,
	6840:  0xCB65,
	6841:  0xCB66,
	6842:  0xCB67,
	6843:  0xCB68,
	6844:  0xCB69,
	6845:  0xCB6A,
	6846:  0xCB6B,
	6847:  0xCB6C,
	6848:  0x3395,
	6849:  0x3396,
	6850:  0x3397,
	6851:  0x2113,
	6852:  0x3398,
	6853:  0x33C4,
	6854:  0x33A3,
	6855:  0x33A4,
	6856:  0x33A5,
	6857:  0x33A6,
	6858:  0x3399,
	6859:  0x339A,
	6860:  0x339B,
	6861:  0x339C,
	6862:  0x339D,
	6863:  0x339E,
	6864:  0x339F,
	6865:  0x33A0,
	6866:  0x33A1,
	6867:  0x33A2,
	6868:  0x33CA,
	6869:  0x338D,
	6870:  0x338E,
	6871:  0x338F,
	6872:  0x33CF,
	6873:  0x3388,
	6874:  0x3389,
	6875:  0x33C8,
	6876:  0x33A7,
	6877:  0x33A8,
	6878:  0x33B0,
	6879:  0x33B1,
	6880:  0x33B2,
	6881:  0x33B3,
	6882:  0x33B4,
	6883:  0x33B5,
	6884:  0x33B6,
	6885:  0x33B7,
	6886:  0x33B8,
	6887:  0x33B9,
	6888:  0x3380,
	6889:  0x3381,
	6890:  0x3382,
	6891:  0x3383,
	6892:  0x3384,
	6893:  0x33BA,
	6894:  0x33BB,
	6895:  0x33BC,
	6896:  0x33BD,
	6897:  0x33BE,
	6898:  0x33BF,
	6899:  0x3390,
	6900:  0x3391,
	6901:  0x3392,
	6902:  0x3393,
	6903:  0x3394,
	6904:  0x2126,
	6905:  0x33C0,
	6906:  0x33C1,
	6907:  0x338A,
	6908:  0x338B,
	6909:  0x338C,
	6910:  0x33D6,
	6911:  0x33C5,
	6912:  0x33AD,
	6913:  0x33AE,
	6914:  0x33AF,
	6915:  0x33DB,
	6916:  0x33A9,
	6917:  0x33AA,
	6918:  0x33AB,
	6919:  0x33AC,
	6920:  0x33DD,
	6921:  0x33D0,
	6922:  0x33D3,
	6923:  0x33C3,
	6924:  0x33C9,
	6925:  0x33DC,
	6926:  0x33C6,
	6942:  0xCB6D,
	6943:  0xCB6E,
	6944:  0xCB6F,
	6945:  0xCB70,
	6946:  0xCB71,
	6947:  0xCB72,
	6948:  0xCB73,
	6949:  0xCB74,
	6950:  0xCB75,
	6951:  0xCB76,
	6952:  0xCB77,
	6953:  0xCB7A,
	6954:  0xCB7B,
	6955:  0xCB7C,
	6956:  0xCB7D,
	6957:  0xCB7E,
	6958:  0xCB7F,
	6959:  0xCB80,
	6960:  0xCB81,
	6961:  0xCB82,
	6962:  0xCB83,
	6963:  0xCB84,
	6964:  0xCB85,
	6965:  0xCB86,
	6966:  0xCB87,
	6967:  0xCB88,
	6968:  0xCB89,
	6969:  0xCB8A,
	6970:  0xCB8B,
	6971:  0xCB8C,
	6972:  0xCB8D,
	6973:  0xCB8E,
	6974:  0xCB8F,
	6975:  0xCB90,
	6976:  0xCB91,
	6977:  0xCB92,
	6978:  0xCB93,
	6979:  0xCB94,
	6980:  0xCB95,
	6981:  0xCB96,
	6982:  0xCB97,
	6983:  0xCB98,
	6984:  0xCB99,
	6985:  0xCB9A,
	6986:  0xCB9B,
	6987:  0xCB9D,
	6988:  0xCB9E,
	6989:  0xCB9F,
	6990:  0xCBA0,
	6991:  0xCBA1,
	6992:  0xCBA2,
	6993:  0xCBA3,
	6994:  0xCBA4,
	6995:  0xCBA5,
	6996:  0xCBA6,
	6997:  0xCBA7,
	6998:  0xCBA8,
	6999:  0xCBA9,
	7000:  0xCBAA,
	7001:  0xCBAB,
	7002:  0xCBAC,
	7003:  0xCBAD,
	7004:  0xCBAE,
	7005:  0xCBAF,
	7006:  0xCBB0,
	7007:  0xCBB1,
	7008:  0xCBB2,
	7009:  0xCBB3,
	7010:  0xCBB4,
	7011:  0xCBB5,
	7012:  0xCBB6,
	7013:  0xCBB7,
	7014:  0xCBB9,
	7015:  0xCBBA,
	7016:  0xCBBB,
	7017:  0xCBBC,
	7018:  0xCBBD,
	7019:  0xCBBE,
	7020:  0xCBBF,
	7021:  0xCBC0,
	7022:  0xCBC1,
	7023:  0xCBC2,
	7024:  0xCBC3,
	7025:  0xCBC4,
	7026:  0x00C6,
	7027:  0x00D0,
	7028:  0x00AA,
	7029:  0x0126,
	7031:  0x0132,
	7033:  0x013F,
	7034:  0x0141,
	7035:  0x00D8,
	7036:  0x0152,
	7037:  0x00BA,
	7038:  0x00DE,
	7039:  0x0166,
	7040:  0x014A,
	7042:  0x3260,
	7043:  0x3261,
	7044:  0x3262,
	7045:  0x3263,
	7046:  0x3264,
	7047:  0x3265,
	7048:  0x3266,
	7049:  0x3267,
	7050:  0x3268,
	7051:  0x3269,
	7052:  0x326A,
	7053:  0x326B,
	7054:  0x326C,
	7055:  0x326D,
	7056:  0x326E,
	7057:  0x326F,
	7058:  0x3270,
	7059:  0x3271,
	7060:  0x3272,
	7061:  0x3273,
	7062:  0x3274,
	7063:  0x3275,
	7064:  0x3276,
	7065:  0x3277,
	7066:  0x3278,
	7067:  0x3279,
	7068:  0x327A,
	7069:  0x327B,
	7070:  0x24D0,
	7071:  0x24D1,
	7072:  0x24D2,
	7073:  0x24D3,
	7074:  0x24D4,
	7075:  0x24D5,
	7076:  0x24D6,
	7077:  0x24D7,
	7078:  0x24D8,
	7079:  0x24D9,
	7080:  0x24DA,
	7081:  0x24DB,
	7082:  0x24DC,
	7083:  0x24DD,
	7084:  0x24DE,
	7085:  0x24DF,
	7086:  0x24E0,
	7087:  0x24E1,
	7088:  0x24E2,
	7089:  0x24E3,
	7090:  0x24E4,
	7091:  0x24E5,
	7092:  0x24E6,
	7093:  0x24E7,
	7094:  0x24E8,
	7095:  0x24E9,
	7096:  0x2460,
	7097:  0x2461,
	7098:  0x2462,
	7099:  0x2463,
	7100:  0x2464,
	7101:  0x2465,
	7102:  0x2466,
	7103:  0x2467,
	7104:  0x2468,
	7105:  0x2469,
	7106:  0x246A,
	7107:  0x246B,
	7108:  0x246C,
	7109:  0x246D,
	7110:  0x246E,
	7111:  0x00BD,
	7112:  0x2153,
	7113:  0x2154,
	7114:  0x00BC,
	7115:  0x00BE,
	7116:  0x215B,
	7117:  0x215C,
	7118:  0x215D,
	7119:  0x215E,
	7120:  0xCBC5,
	7121:  0xCBC6,
	7122:  0xCBC7,
	7123:  0xCBC8,
	7124:  0xCBC9,
	7125:  0xCBCA,
	7126:  0xCBCB,
	7127:  0xCBCC,
	7128:  0xCBCD,
	7129:  0xCBCE,
	7130:  0xCBCF,
	7131:  0xCBD0,
	7132:  0xCBD1,
	7133:  0xCBD2,
	7134:  0xCBD3,
	7135:  0xCBD5,
	7136:  0xCBD6,
	7137:  0xCBD7,
	7138:  0xCBD8,
	7139:  0xCBD9,
	7140:  0xCBDA,
	7141:  0xCBDB,
	7142:  0xCBDC,
	7143:  0xCBDD,
	7144:  0xCBDE,
	7145:  0xCBDF,
	7146:  0xCBE0,
	7147:  0xCBE1,
	7148:  0xCBE2,
	7149:  0xCBE3,
	7150:  0xCBE5,
	7151:  0xCBE6,
	7152:  0xCBE8,
	7153:  0xCBEA,
	7154:  0xCBEB,
	7155:  0xCBEC,
	7156:  0xCBED,
	7157:  0xCBEE,
	7158:  0xCBEF,
	7159:  0xCBF0,
	7160:  0xCBF1,
	7161:  0xCBF2,
	7162:  0xCBF3,
	7163:  0xCBF4,
	7164:  0xCBF5,
	7165:  0xCBF6,
	7166:  0xCBF7,
	7167:  0xCBF8,
	7168:  0xCBF9,
	7169:  0xCBFA,
	7170:  0xCBFB,
	7171:  0xCBFC,
	7172:  0xCBFD,
	7173:  0xCBFE,
	7174:  0xCBFF,
	7175:  0xCC00,
	7176:  0xCC01,
	7177:  0xCC02,
	7178:  0xCC03,
	7179:  0xCC04,
	7180:  0xCC05,
	7181:  0xCC06,
	7182:  0xCC07,
	7183:  0xCC08,
	7184:  0xCC09,
	7185:  0xCC0A,
	7186:  0xCC0B,
	7187:  0xCC0E,
	7188:  0xCC0F,
	7189:  0xCC11,
	7190:  0xCC12,
	7191:  0xCC13,
	7192:  0xCC15,
	7193:  0xCC16,
	7194:  0xCC17,
	7195:  0xCC18,
	7196:  0xCC19,
	7197:  0xCC1A,
	7198:  0xCC1B,
	7199:  0xCC1E,
	7200:  0xCC1F,
	7201:  0xCC20,
	7202:  0xCC23,
	7203:  0xCC24,
	7204:  0x00E6,
	7205:  0x0111,
	7206:  0x00F0,
	7207:  0x0127,
	7208:  0x0131,
	7209:  0x0133,
	7210:  0x0138,
	7211:  0x0140,
	7212:  0x0142,
	7213:  0x00F8,
	7214:  0x0153,
	7215:  0x00DF,
	7216:  0x00FE,
	7217:  0x0167,
	7218:  0x014B,
	7219:  0x0149,
	7220:  0x3200,
	7221:  0x3201,
	7222:  0x3202,
	7223:  0x3203,
	7224:  0x3204,
	7225:  0x3205,
	7226:  0x3206,
	7227:  0x3207,
	7228:  0x3208,
	7229:  0x3209,
	7230:  0x320A,
	7231:  0x320B,
	7232:  0x320C,
	7233:  0x320D,
	7234:  0x320E,
	7235:  0x320F,
	7236:  0x3210,
	7237:  0x3211,
	7238:  0x3212,
	7239:  0x3213,
	7240:  0x3214,
	7241:  0x3215,
	7242:  0x3216,
	7243:  0x3217,
	7244:  0x3218,
	7245:  0x3219,
	7246:  0x321A,
	7247:  0x321B,
	7248:  0x249C,
	7249:  0x249D,
	7250:  0x249E,
	7251:  0x249F,
	7252:  0x24A0,
	7253:  0x24A1,
	7254:  0x24A2,
	7255:  0x24A3,
	7256:  0x24A4,
	7257:  0x24A5,
	7258:  0x24A6,
	7259:  0x24A7,
	7260:  0x24A8,
	7261:  0x24A9,
	7262:  0x24AA,
	7263:  0x24AB,
	7264:  0x24AC,
	7265:  0x24AD,
	7266:  0x24AE,
	7267:  0x24AF,
	7268:  0x24B0,
	7269:  0x24B1,
	7270:  0x24B2,
	7271:  0x24B3,
	7272:  0x24B4,
	7273:  0x24B5,
	7274:  0x2474,
	7275:  0x2475,
	7276:  0x2476,
	7277:  0x2477,
	7278:  0x2478,
	7279:  0x2479,
	7280:  0x247A,
	7281:  0x247B,
	7282:  0x247C,
	7283:  0x247D,
	7284:  0x247E,
	7285:  0x247F,
	7286:  0x2480,
	7287:  0x2481,
	7288:  0x2482,
	7289:  0x00B9,
	7290:  0x00B2,
	7291:  0x00B3,
	7292:  0x2074,
	7293:  0x207F,
	7294:  0x2081,
	7295:  0x2082,
	7296:  0x2083,
	7297:  0x2084,
	7298:  0xCC25,
	7299:  0xCC26,
	7300:  0xCC2A,
	7301:  0xCC2B,
	7302:  0xCC2D,
	7303:  0xCC2F,
	7304:  0xCC31,
	7305:  0xCC32,
	7306:  0xCC33,
	7307:  0xCC34,
	7308:  0xCC35,
	7309:  0xCC36,
	7310:  0xCC37,
	7311:  0xCC3A,
	7312:  0xCC3F,
	7313:  0xCC40,
	7314:  0xCC41,
	7315:  0xCC42,
	7316:  0xCC43,
	7317:  0xCC46,
	7318:  0xCC47,
	7319:  0xCC49,
	7320:  0xCC4A,
	7321:  0xCC4B,
	7322:  0xCC4D,
	7323:  0xCC4E,
	7324:  0xCC4F,
	7325:  0xCC50,
	7326:  0xCC51,
	7327:  0xCC52,
	7328:  0xCC53,
	7329:  0xCC56,
	7330:  0xCC5A,
	7331:  0xCC5B,
	7332:  0xCC5C,
	7333:  0xCC5D,
	7334:  0xCC5E,
	7335:  0xCC5F,
	7336:  0xCC61,
	7337:  0xCC62,
	7338:  0xCC63,
	7339:  0xCC65,
	7340:  0xCC67,
	7341:  0xCC69,
	7342:  0xCC6A,
	7343:  0xCC6B,
	7344:  0xCC6C,
	7345:  0xCC6D,
	7346:  0xCC6E,
	7347:  0xCC6F,
	7348:  0xCC71,
	7349:  0xCC72,
	7350:  0xCC73,
	7351:  0xCC74,
	7352:  0xCC76,
	7353:  0xCC77,
	7354:  0xCC78,
	7355:  0xCC79,
	7356:  0xCC7A,
	7357:  0xCC7B,
	7358:  0xCC7C,
	7359:  0xCC7D,
	7360:  0xCC7E,
	7361:  0xCC7F,
	7362:  0xCC80,
	7363:  0xCC81,
	7364:  0xCC82,
	7365:  0xCC83,
	7366:  0xCC84,
	7367:  0xCC85,
	7368:  0xCC86,
	7369:  0xCC87,
	7370:  0xCC88,
	7371:  0xCC89,
	7372:  0xCC8A,
	7373:  0xCC8B,
	7374:  0xCC8C,
	7375:  0xCC8D,
	7376:  0xCC8E,
	7377:  0xCC8F,
	7378:  0xCC90,
	7379:  0xCC91,
	7380:  0xCC92,
	7381:  0xCC93,
	7382:  0x3041,
	7383:  0x3042,
	7384:  0x3043,
	7385:  0x3044,
	7386:  0x3045,
	7387:  0x3046,
	7388:  0x3047,
	7389:  0x3048,
	7390:  0x3049,
	7391:  0x304A,
	7392:  0x304B,
	7393:  0x304C,
	7394:  0x304D,
	7395:  0x304E,
	7396:  0x304F,
	7397:  0x3050,
	7398:  0x3051,
	7399:  0x3052,
	7400:  0x3053,
	7401:  0x3054,
	7402:  0x3055,
	7403:  0x3056,
	7404:  0x3057,
	7405:  0x3058,
	7406:  0x3059,
	7407:  0x305A,
	7408:  0x305B,
	7409:  0x305C,
	7410:  0x305D,
	7411:  0x305E,
	7412:  0x305F,
	7413:  0x3060,
	7414:  0x3061,
	7415:  0x3062,
	7416:  0x3063,
	7417:  0x3064,
	7418:  0x3065,
	7419:  0x3066,
	7420:  0x3067,
	7421:  0x3068,
	7422:  0x3069,
	7423:  0x306A,
	7424:  0x306B,
	7425:  0x306C,
	7426:  0x306D,
	7427:  0x306E,
	7428:  0x306F,
	7429:  0x3070,
	7430:  0x3071,
	7431:  0x3072,
	7432:  0x3073,
	7433:  0x3074,
	7434:  0x3075,
	7435:  0x3076,
	7436:  0x3077,
	7437:  0x3078,
	7438:  0x3079,
	7439:  0x307A,
	7440:  0x307B,
	7441:  0x307C,
	7442:  0x307D,
	7443:  0x307E,
	7444:  0x307F,
	7445:  0x3080,
	7446:  0x3081,
	7447:  0x3082,
	7448:  0x3083,
	7449:  0x3084,
	7450:  0x3085,
	7451:  0x3086,
	7452:  0x3087,
	7453:  0x3088,
	7454:  0x3089,
	7455:  0x308A,
	7456:  0x308B,
	7457:  0x308C,
	7458:  0x308D,
	7459:  0x308E,
	7460:  0x308F,
	7461:  0x3090,
	7462:  0x3091,
	7463:  0x3092,
	7464:  0x3093,
	7476:  0xCC94,
	7477:  0xCC95,
	7478:  0xCC96,
	7479:  0xCC97,
	7480:  0xCC9A,
	7481:  0xCC9B,
	7482:  0xCC9D,
	7483:  0xCC9E,
	7484:  0xCC9F,
	7485:  0xCCA1,
	7486:  0xCCA2,
	7487:  0xCCA3,
	7488:  0xCCA4,
	7489:  0xCCA5,
	7490:  0xCCA6,
	7491:  0xCCA7,
	7492:  0xCCAA,
	7493:  0xCCAE,
	7494:  0xCCAF,
	7495:  0xCCB0,
	7496:  0xCCB1,
	7497:  0xCCB2,
	7498:  0xCCB3,
	7499:  0xCCB6,
	7500:  0xCCB7,
	7501:  0xCCB9,
	7502:  0xCCBA,
	7503:  0xCCBB,
	7504:  0xCCBD,
	7505:  0xCCBE,
	7506:  0xCCBF,
	7507:  0xCCC0,
	7508:  0xCCC1,
	7509:  0xCCC2,
	7510:  0xCCC3,
	7511:  0xCCC6,
	7512:  0xCCC8,
	7513:  0xCCCA,
	7514:  0xCCCB,
	7515:  0xCCCC,
	7516:  0xCCCD,
	7517:  0xCCCE,
	7518:  0xCCCF,
	7519:  0xCCD1,
	7520:  0xCCD2,
	7521:  0xCCD3,
	7522:  0xCCD5,
	7523:  0xCCD6,
	7524:  0xCCD7,
	7525:  0xCCD8,
	7526:  0xCCD9,
	7527:  0xCCDA,
	7528:  0xCCDB,
	7529:  0xCCDC,
	7530:  0xCCDD,
	7531:  0xCCDE,
	7532:  0xCCDF,
	7533:  0xCCE0,
	7534:  0xCCE1,
	7535:  0xCCE2,
	7536:  0xCCE3,
	7537:  0xCCE5,
	7538:  0xCCE6,
	7539:  0xCCE7,
	7540:  0xCCE8,
	7541:  0xCCE9,
	7542:  0xCCEA,
	7543:  0xCCEB,
	7544:  0xCCED,
	7545:  0xCCEE,
	7546:  0xCCEF,
	7547:  0xCCF1,
	7548:  0xCCF2,
	7549:  0xCCF3,
	7550:  0xCCF4,
	7551:  0xCCF5,
	7552:  0xCCF6,
	7553:  0xCCF7,
	7554:  0xCCF8,
	7555:  0xCCF9,
	7556:  0xCCFA,
	7557:  0xCCFB,
	7558:  0xCCFC,
	7559:  0xCCFD,
	7560:  0x30A1,
	7561:  0x30A2,
	7562:  0x30A3,
	7563:  0x30A4,
	7564:  0x30A5,
	7565:  0x30A6,
	7566:  0x30A7,
	7567:  0x30A8,
	7568:  0x30A9,
	7569:  0x30AA,
	7570:  0x30AB,
	7571:  0x30AC,
	7572:  0x30AD,
	7573:  0x30AE,
	7574:  0x30AF,
	7575:  0x30B0,
	7576:  0x30B1,
	7577:  0x30B2,
	7578:  0x30B3,
	7579:  0x30B4,
	7580:  0x30B5,
	7581:  0x30B6,
	7582:  0x30B7,
	7583:  0x30B8,
	7584:  0x30B9,
	7585:  0x30BA,
	7586:  0x30BB,
	7587:  0x30BC,
	7588:  0x30BD,
	7589:  0x30BE,
	7590:  0x30BF,
	7591:  0x30C0,
	7592:  0x30C1,
	7593:  0x30C2,
	7594:  0x30C3,
	7595:  0x30C4,
	7596:  0x30C5,
	7597:  0x30C6,
	7598:  0x30C7,
	7599:  0x30C8,
	7600:  0x30C9,
	7601:  0x30CA,
	7602:  0x30CB,
	7603:  0x30CC,
	7604:  0x30CD,
	7605:  0x30CE,
	7606:  0x30CF,
	7607:  0x30D0,
	7608:  0x30D1,
	7609:  0x30D2,
	7610:  0x30D3,
	7611:  0x30D4,
	7612:  0x30D5,
	7613:  0x30D6,
	7614:  0x30D7,
	7615:  0x30D8,
	7616:  0x30D9,
	7617:  0x30DA,
	7618:  0x30DB,
	7619:  0x30DC,
	7620:  0x30DD,
	7621:  0x30DE,
	7622:  0x30DF,
	7623:  0x30E0,
	7624:  0x30E1,
	7625:  0x30E2,
	7626:  0x30E3,
	7627:  0x30E4,
	7628:  0x30E5,
	7629:  0x30E6,
	7630:  0x30E7,
	7631:  0x30E8,
	7632:  0x30E9,
	7633:  0x30EA,
	7634:  0x30EB,
	7635:  0x30EC,
	7636:  0x30ED,
	7637:  0x30EE,
	7638:  0x30EF,
	7639:  0x30F0,
	7640:  0x30F1,
	7641:  0x30F2,
	7642:  0x30F3,
	7643:  0x30F4,
	7644:  0x30F5,
	7645:  0x30F6,
	7654:  0xCCFE,
	7655:  0xCCFF,
	7656:  0xCD00,
	7657:  0xCD02,
	7658:  0xCD03,
	7659:  0xCD04,
	7660:  0xCD05,
	7661:  0xCD06,
	7662:  0xCD07,
	7663:  0xCD0A,
	7664:  0xCD0B,
	7665:  0xCD0D,
	7666:  0xCD0E,
	7667:  0xCD0F,
	7668:  0xCD11,
	7669:  0xCD12,
	7670:  0xCD13,
	7671:  0xCD14,
	7672:  0xCD15,
	7673:  0xCD16,
	7674:  0xCD17,
	7675:  0xCD1A,
	7676:  0xCD1C,
	7677:  0xCD1E,
	7678:  0xCD1F,
	7679:  0xCD20,
	7680:  0xCD21,
	7681:  0xCD22,
	7682:  0xCD23,
	7683:  0xCD25,
	7684:  0xCD26,
	7685:  0xCD27,
	7686:  0xCD29,
	7687:  0xCD2A,
	7688:  0xCD2B,
	7689:  0xCD2D,
	7690:  0xCD2E,
	7691:  0xCD2F,
	7692:  0xCD30,
	7693:  0xCD31,
	7694:  0xCD32,
	7695:  0xCD33,
	7696:  0xCD34,
	7697:  0xCD35,
	7698:  0xCD36,
	7699:  0xCD37,
	7700:  0xCD38,
	7701:  0xCD3A,
	7702:  0xCD3B,
	7703:  0xCD3C,
	7704:  0xCD3D,
	7705:  0xCD3E,
	7706:  0xCD3F,
	7707:  0xCD40,
	7708:  0xCD41,
	7709:  0xCD42,
	7710:  0xCD43,
	7711:  0xCD44,
	7712:  0xCD45,
	7713:  0xCD46,
	7714:  0xCD47,
	7715:  0xCD48,
	7716:  0xCD49,
	7717:  0xCD4A,
	7718:  0xCD4B,
	7719:  0xCD4C,
	7720:  0xCD4D,
	7721:  0xCD4E,
	7722:  0xCD4F,
	7723:  0xCD50,
	7724:  0xCD51,
	7725:  0xCD52,
	7726:  0xCD53,
	7727:  0xCD54,
	7728:  0xCD55,
	7729:  0xCD56,
	7730:  0xCD57,
	7731:  0xCD58,
	7732:  0xCD59,
	7733:  0xCD5A,
	7734:  0xCD5B,
	7735:  0xCD5D,
	7736:  0xCD5E,
	7737:  0xCD5F,
	7738:  0x0410,
	7739:  0x0411,
	7740:  0x0412,
	7741:  0x0413,
	7742:  0x0414,
	7743:  0x0415,
	7744:  0x0401,
	7745:  0x0416,
	7746:  0x0417,
	7747:  0x0418,
	7748:  0x0419,
	7749:  0x041A,
	7750:  0x041B,
	7751:  0x041C,
	7752:  0x041D,
	7753:  0x041E,
	7754:  0x041F,
	7755:  0x0420,
	7756:  0x0421,
	7757:  0x0422,
	7758:  0x0423,
	7759:  0x0424,
	7760:  0x0425,
	7761:  0x0426,
	7762:  0x0427,
	7763:  0x0428,
	7764:  0x0429,
	7765:  0x042A,
	7766:  0x042B,
	7767:  0x042C,
	7768:  0x042D,
	7769:  0x042E,
	7770:  0x042F,
	7786:  0x0430,
	7787:  0x0431,
	7788:  0x0432,
	7789:  0x0433,
	7790:  0x0434,
	7791:  0x0435,
	7792:  0x0451,
	7793:  0x0436,
	7794:  0x0437,
	7795:  0x0438,
	7796:  0x0439,
	7797:  0x043A,
	7798:  0x043B,
	7799:  0x043C,
	7800:  0x043D,
	7801:  0x043E,
	7802:  0x043F,
	7803:  0x0440,
	7804:  0x0441,
	7805:  0x0442,
	7806:  0x0443,
	7807:  0x0444,
	7808:  0x0445,
	7809:  0x0446,
	7810:  0x0447,
	7811:  0x0448,
	7812:  0x0449,
	7813:  0x044A,
	7814:  0x044B,
	7815:  0x044C,
	7816:  0x044D,
	7817:  0x044E,
	7818:  0x044F,
	7832:  0xCD61,
	7833:  0xCD62,
	7834:  0xCD63,
	7835:  0xCD65,
	7836:  0xCD66,
	7837:  0xCD67,
	7838:  0xCD68,
	7839:  0xCD69,
	7840:  0xCD6A,
	7841:  0xCD6B,
	7842:  0xCD6E,
	7843:  0xCD70,
	7844:  0xCD72,
	7845:  0xCD73,
	7846:  0xCD74,
	7847:  0xCD75,
	7848:  0xCD76,
	7849:  0xCD77,
	7850:  0xCD79,
	7851:  0xCD7A,
	7852:  0xCD7B,
	7853:  0xCD7C,
	7854:  0xCD7D,
	7855:  0xCD7E,
	7856:  0xCD7F,
	7857:  0xCD80,
	7858:  0xCD81,
	7859:  0xCD82,
	7860:  0xCD83,
	7861:  0xCD84,
	7862:  0xCD85,
	7863:  0xCD86,
	7864:  0xCD87,
	7865:  0xCD89,
	7866:  0xCD8A,
	7867:  0xCD8B,
	7868:  0xCD8C,
	7869:  0xCD8D,
	7870:  0xCD8E,
	7871:  0xCD8F,
	7872:  0xCD90,
	7873:  0xCD91,
	7874:  0xCD92,
	7875:  0xCD93,
	7876:  0xCD96,
	7877:  0xCD97,
	7878:  0xCD99,
	7879:  0xCD9A,
	7880:  0xCD9B,
	7881:  0xCD9D,
	7882:  0xCD9E,
	7883:  0xCD9F,
	7884:  0xCDA0,
	7885:  0xCDA1,
	7886:  0xCDA2,
	7887:  0xCDA3,
	7888:  0xCDA6,
	7889:  0xCDA8,
	7890:  0xCDAA,
	7891:  0xCDAB,
	7892:  0xCDAC,
	7893:  0xCDAD,
	7894:  0xCDAE,
	7895:  0xCDAF,
	7896:  0xCDB1,
	7897:  0xCDB2,
	7898:  0xCDB3,
	7899:  0xCDB4,
	7900:  0xCDB5,
	7901:  0xCDB6,
	7902:  0xCDB7,
	7903:  0xCDB8,
	7904:  0xCDB9,
	7905:  0xCDBA,
	7906:  0xCDBB,
	7907:  0xCDBC,
	7908:  0xCDBD,
	7909:  0xCDBE,
	7910:  0xCDBF,
	7911:  0xCDC0,
	7912:  0xCDC1,
	7913:  0xCDC2,
	7914:  0xCDC3,
	7915:  0xCDC5,
	8010:  0xCDC6,
	8011:  0xCDC7,
	8012:  0xCDC8,
	8013:  0xCDC9,
	8014:  0xCDCA,
	8015:  0xCDCB,
	8016:  0xCDCD,
	8017:  0xCDCE,
	8018:  0xCDCF,
	8019:  0xCDD1,
	8020:  0xCDD2,
	8021:  0xCDD3,
	8022:  0xCDD4,
	8023:  0xCDD5,
	8024:  0xCDD6,
	8025:  0xCDD7,
	8026:  0xCDD8,
	8027:  0xCDD9,
	8028:  0xCDDA,
	8029:  0xCDDB,
	8030:  0xCDDC,
	8031:  0xCDDD,
	8032:  0xCDDE,
	8033:  0xCDDF,
	8034:  0xCDE0,
	8035:  0xCDE1,
	8036:  0xCDE2,
	8037:  0xCDE3,
	8038:  0xCDE4,
	8039:  0xCDE5,
	8040:  0xCDE6,
	8041:  0xCDE7,
	8042:  0xCDE9,
	8043:  0xCDEA,
	8044:  0xCDEB,
	8045:  0xCDED,
	8046:  0xCDEE,
	8047:  0xCDEF,
	8048:  0xCDF1,
	8049:  0xCDF2,
	8050:  0xCDF3,
	8051:  0xCDF4,
	8052:  0xCDF5,
	8053:  0xCDF6,
	8054:  0xCDF7,
	8055:  0xCDFA,
	8056:  0xCDFC,
	8057:  0xCDFE,
	8058:  0xCDFF,
	8059:  0xCE00,
	8060:  0xCE01,
	8061:  0xCE02,
	8062:  0xCE03,
	8063:  0xCE05,
	8064:  0xCE06,
	8065:  0xCE07,
	8066:  0xCE09,
	8067:  0xCE0A,
	8068:  0xCE0B,
	8069:  0xCE0D,
	8070:  0xCE0E,
	8071:  0xCE0F,
	8072:  0xCE10,
	8073:  0xCE11,
	8074:  0xCE12,
	8075:  0xCE13,
	8076:  0xCE15,
	8077:  0xCE16,
	8078:  0xCE17,
	8079:  0xCE18,
	8080:  0xCE1A,
	8081:  0xCE1B,
	8082:  0xCE1C,
	8083:  0xCE1D,
	8084:  0xCE1E,
	8085:  0xCE1F,
	8086:  0xCE22,
	8087:  0xCE23,
	8088:  0xCE25,
	8089:  0xCE26,
	8090:  0xCE27,
	8091:  0xCE29,
	8092:  0xCE2A,
	8093:  0xCE2B,
	8188:  0xCE2C,
	8189:  0xCE2D,
	8190:  0xCE2E,
	8191:  0xCE2F,
	8192:  0xCE32,
	8193:  0xCE34,
	8194:  0xCE36,
	8195:  0xCE37,
	8196:  0xCE38,
	8197:  0xCE39,
	8198:  0xCE3A,
	8199:  0xCE3B,
	8200:  0xCE3C,
	8201:  0xCE3D,
	8202:  0xCE3E,
	8203:  0xCE3F,
	8204:  0xCE40,
	8205:  0xCE41,
	8206:  0xCE42,
	8207:  0xCE43,
	8208:  0xCE44,
	8209:  0xCE45,
	8210:  0xCE46,
	8211:  0xCE47,
	8212:  0xCE48,
	8213:  0xCE49,
	8214:  0xCE4A,
	8215:  0xCE4B,
	8216:  0xCE4C,
	8217:  0xCE4D,
	8218:  0xCE4E,
	8219:  0xCE4F,
	8220:  0xCE50,
	8221:  0xCE51,
	8222:  0xCE52,
	8223:  0xCE53,
	8224:  0xCE54,
	8225:  0xCE55,
	8226:  0xCE56,
	8227:  0xCE57,
	8228:  0xCE5A,
	8229:  0xCE5B,
	8230:  0xCE5D,
	8231:  0xCE5E,
	8232:  0xCE62,
	8233:  0xCE63,
	8234:  0xCE64,
	8235:  0xCE65,
	8236:  0xCE66,
	8237:  0xCE67,
	8238:  0xCE6A,
	8239:  0xCE6C,
	8240:  0xCE6E,
	8241:  0xCE6F,
	8242:  0xCE70,
	8243:  0xCE71,
	8244:  0xCE72,
	8245:  0xCE73,
	8246:  0xCE76,
	8247:  0xCE77,
	8248:  0xCE79,
	8249:  0xCE7A,
	8250:  0xCE7B,
	8251:  0xCE7D,
	8252:  0xCE7E,
	8253:  0xCE7F,
	8254:  0xCE80,
	8255:  0xCE81,
	8256:  0xCE82,
	8257:  0xCE83,
	8258:  0xCE86,
	8259:  0xCE88,
	8260:  0xCE8A,
	8261:  0xCE8B,
	8262:  0xCE8C,
	8263:  0xCE8D,
	8264:  0xCE8E,
	8265:  0xCE8F,
	8266:  0xCE92,
	8267:  0xCE93,
	8268:  0xCE95,
	8269:  0xCE96,
	8270:  0xCE97,
	8271:  0xCE99,
	8366:  0xCE9A,
	8367:  0xCE9B,
	8368:  0xCE9C,
	8369:  0xCE9D,
	8370:  0xCE9E,
	8371:  0xCE9F,
	8372:  0xCEA2,
	8373:  0xCEA6,
	8374:  0xCEA7,
	8375:  0xCEA8,
	8376:  0xCEA9,
	8377:  0xCEAA,
	8378:  0xCEAB,
	8379:  0xCEAE,
	8380:  0xCEAF,
	8381:  0xCEB0,
	8382:  0xCEB1,
	8383:  0xCEB2,
	8384:  0xCEB3,
	8385:  0xCEB4,
	8386:  0xCEB5,
	8387:  0xCEB6,
	8388:  0xCEB7,
	8389:  0xCEB8,
	8390:  0xCEB9,
	8391:  0xCEBA,
	8392:  0xCEBB,
	8393:  0xCEBC,
	8394:  0xCEBD,
	8395:  0xCEBE,
	8396:  0xCEBF,
	8397:  0xCEC0,
	8398:  0xCEC2,
	8399:  0xCEC3,
	8400:  0xCEC4,
	8401:  0xCEC5,
	8402:  0xCEC6,
	8403:  0xCEC7,
	8404:  0xCEC8,
	8405:  0xCEC9,
	8406:  0xCECA,
	8407:  0xCECB,
	8408:  0xCECC,
	8409:  0xCECD,
	8410:  0xCECE,
	8411:  0xCECF,
	8412:  0xCED0,
	8413:  0xCED1,
	8414:  0xCED2,
	8415:  0xCED3,
	8416:  0xCED4,
	8417:  0xCED5,
	8418:  0xCED6,
	8419:  0xCED7,
	8420:  0xCED8,
	8421:  0xCED9,
	8422:  0xCEDA,
	8423:  0xCEDB,
	8424:  0xCEDC,
	8425:  0xCEDD,
	8426:  0xCEDE,
	8427:  0xCEDF,
	8428:  0xCEE0,
	8429:  0xCEE1,
	8430:  0xCEE2,
	8431:  0xCEE3,
	8432:  0xCEE6,
	8433:  0xCEE7,
	8434:  0xCEE9,
	8435:  0xCEEA,
	8436:  0xCEED,
	8437:  0xCEEE,
	8438:  0xCEEF,
	8439:  0xCEF0,
	8440:  0xCEF1,
	8441:  0xCEF2,
	8442:  0xCEF3,
	8443:  0xCEF6,
	8444:  0xCEFA,
	8445:  0xCEFB,
	8446:  0xCEFC,
	8447:  0xCEFD,
	8448:  0xCEFE,
	8449:  0xCEFF,
	8450:  0xAC00,
	8451:  0xAC01,
	8452:  0xAC04,
	8453:  0xAC07,
	8454:  0xAC08,
	8455:  0xAC09,
	8456:  0xAC0A,
	8457:  0xAC10,
	8458:  0xAC11,
	8459:  0xAC12,
	8460:  0xAC13,
	8461:  0xAC14,
	8462:  0xAC15,
	8463:  0xAC16,
	8464:  0xAC17,
	8465:  0xAC19,
	8466:  0xAC1A,
	8467:  0xAC1B,
	8468:  0xAC1C,
	8469:  0xAC1D,
	8470:  0xAC20,
	8471:  0xAC24,
	8472:  0xAC2C,
	8473:  0xAC2D,
	8474:  0xAC2F,
	8475:  0xAC30,
	8476:  0xAC31,
	8477:  0xAC38,
	8478:  0xAC39,
	8479:  0xAC3C,
	8480:  0xAC40,
	8481:  0xAC4B,
	8482:  0xAC4D,
	8483:  0xAC54,
	8484:  0xAC58,
	8485:  0xAC5C,
	8486:  0xAC70,
	8487:  0xAC71,
	8488:  0xAC74,
	8489:  0xAC77,
	8490:  0xAC78,
	8491:  0xAC7A,
	8492:  0xAC80,
	8493:  0xAC81,
	8494:  0xAC83,
	8495:  0xAC84,
	8496:  0xAC85,
	8497:  0xAC86,
	8498:  0xAC89,
	8499:  0xAC8A,
	8500:  0xAC8B,
	8501:  0xAC8C,
	8502:  0xAC90,
	8503:  0xAC94,
	8504:  0xAC9C,
	8505:  0xAC9D,
	8506:  0xAC9F,
	8507:  0xACA0,
	8508:  0xACA1,
	8509:  0xACA8,
	8510:  0xACA9,
	8511:  0xACAA,
	8512:  0xACAC,
	8513:  0xACAF,
	8514:  0xACB0,
	8515:  0xACB8,
	8516:  0xACB9,
	8517:  0xACBB,
	8518:  0xACBC,
	8519:  0xACBD,
	8520:  0xACC1,
	8521:  0xACC4,
	8522:  0xACC8,
	8523:  0xACCC,
	8524:  0xACD5,
	8525:  0xACD7,
	8526:  0xACE0,
	8527:  0xACE1,
	8528:  0xACE4,
	8529:  0xACE7,
	8530:  0xACE8,
	8531:  0xACEA,
	8532:  0xACEC,
	8533:  0xACEF,
	8534:  0xACF0,
	8535:  0xACF1,
	8536:  0xACF3,
	8537:  0xACF5,
	8538:  0xACF6,
	8539:  0xACFC,
	8540:  0xACFD,
	8541:  0xAD00,
	8542:  0xAD04,
	8543:  0xAD06,
	8544:  0xCF02,
	8545:  0xCF03,
	8546:  0xCF05,
	8547:  0xCF06,
	8548:  0xCF07,
	8549:  0xCF09,
	8550:  0xCF0A,
	8551:  0xCF0B,
	8552:  0xCF0C,
	8553:  0xCF0D,
	8554:  0xCF0E,
	8555:  0xCF0F,
	8556:  0xCF12,
	8557:  0xCF14,
	8558:  0xCF16,
	8559:  0xCF17,
	8560:  0xCF18,
	8561:  0xCF19,
	8562:  0xCF1A,
	8563:  0xCF1B,
	8564:  0xCF1D,
	8565:  0xCF1E,
	8566:  0xCF1F,
	8567:  0xCF21,
	8568:  0xCF22,
	8569:  0xCF23,
	8570:  0xCF25,
	8571:  0xCF26,
	8572:  0xCF27,
	8573:  0xCF28,
	8574:  0xCF29,
	8575:  0xCF2A,
	8576:  0xCF2B,
	8577:  0xCF2E,
	8578:  0xCF32,
	8579:  0xCF33,
	8580:  0xCF34,
	8581:  0xCF35,
	8582:  0xCF36,
	8583:  0xCF37,
	8584:  0xCF39,
	8585:  0xCF3A,
	8586:  0xCF3B,
	8587:  0xCF3C,
	8588:  0xCF3D,
	8589:  0xCF3E,
	8590:  0xCF3F,
	8591:  0xCF40,
	8592:  0xCF41,
	8593:  0xCF42,
	8594:  0xCF43,
	8595:  0xCF44,
	8596:  0xCF45,
	8597:  0xCF46,
	8598:  0xCF47,
	8599:  0xCF48,
	8600:  0xCF49,
	8601:  0xCF4A,
	8602:  0xCF4B,
	8603:  0xCF4C,
	8604:  0xCF4D,
	8605:  0xCF4E,
	8606:  0xCF4F,
	8607:  0xCF50,
	8608:  0xCF51,
	8609:  0xCF52,
	8610:  0xCF53,
	8611:  0xCF56,
	8612:  0xCF57,
	8613:  0xCF59,
	8614:  0xCF5A,
	8615:  0xCF5B,
	8616:  0xCF5D,
	8617:  0xCF5E,
	8618:  0xCF5F,
	8619:  0xCF60,
	8620:  0xCF61,
	8621:  0xCF62,
	8622:  0xCF63,
	8623:  0xCF66,
	8624:  0xCF68,
	8625:  0xCF6A,
	8626:  0xCF6B,
	8627:  0xCF6C,
	8628:  0xAD0C,
	8629:  0xAD0D,
	8630:  0xAD0F,
	8631:  0xAD11,
	8632:  0xAD18,
	8633:  0xAD1C,
	8634:  0xAD20,
	8635:  0xAD29,
	8636:  0xAD2C,
	8637:  0xAD2D,
	8638:  0xAD34,
	8639:  0xAD35,
	8640:  0xAD38,
	8641:  0xAD3C,
	8642:  0xAD44,
	8643:  0xAD45,
	8644:  0xAD47,
	8645:  0xAD49,
	8646:  0xAD50,
	8647:  0xAD54,
	8648:  0xAD58,
	8649:  0xAD61,
	8650:  0xAD63,
	8651:  0xAD6C,
	8652:  0xAD6D,
	8653:  0xAD70,
	8654:  0xAD73,
	8655:  0xAD74,
	8656:  0xAD75,
	8657:  0xAD76,
	8658:  0xAD7B,
	8659:  0xAD7C,
	8660:  0xAD7D,
	8661:  0xAD7F,
	8662:  0xAD81,
	8663:  0xAD82,
	8664:  0xAD88,
	8665:  0xAD89,
	8666:  0xAD8C,
	8667:  0xAD90,
	8668:  0xAD9C,
	8669:  0xAD9D,
	8670:  0xADA4,
	8671:  0xADB7,
	8672:  0xADC0,
	8673:  0xADC1,
	8674:  0xADC4,
	8675:  0xADC8,
	8676:  0xADD0,
	8677:  0xADD1,
	8678:  0xADD3,
	8679:  0xADDC,
	8680:  0xADE0,
	8681:  0xADE4,
	8682:  0xADF8,
	8683:  0xADF9,
	8684:  0xADFC,
	8685:  0xADFF,
	8686:  0xAE00,
	8687:  0xAE01,
	8688:  0xAE08,
	8689:  0xAE09,
	8690:  0xAE0B,
	8691:  0xAE0D,
	8692:  0xAE14,
	8693:  0xAE30,
	8694:  0xAE31,
	8695:  0xAE34,
	8696:  0xAE37,
	8697:  0xAE38,
	8698:  0xAE3A,
	8699:  0xAE40,
	8700:  0xAE41,
	8701:  0xAE43,
	8702:  0xAE45,
	8703:  0xAE46,
	8704:  0xAE4A,
	8705:  0xAE4C,
	8706:  0xAE4D,
	8707:  0xAE4E,
	8708:  0xAE50,
	8709:  0xAE54,
	8710:  0xAE56,
	8711:  0xAE5C,
	8712:  0xAE5D,
	8713:  0xAE5F,
	8714:  0xAE60,
	8715:  0xAE61,
	8716:  0xAE65,
	8717:  0xAE68,
	8718:  0xAE69,
	8719:  0xAE6C,
	8720:  0xAE70,
	8721:  0xAE78,
	8722:  0xCF6D,
	8723:  0xCF6E,
	8724:  0xCF6F,
	8725:  0xCF72,
	8726:  0xCF73,
	8727:  0xCF75,
	8728:  0xCF76,
	8729:  0xCF77,
	8730:  0xCF79,
	8731:  0xCF7A,
	8732:  0xCF7B,
	8733:  0xCF7C,
	8734:  0xCF7D,
	8735:  0xCF7E,
	8736:  0xCF7F,
	8737:  0xCF81,
	8738:  0xCF82,
	8739:  0xCF83,
	8740:  0xCF84,
	8741:  0xCF86,
	8742:  0xCF87,
	8743:  0xCF88,
	8744:  0xCF89,
	8745:  0xCF8A,
	8746:  0xCF8B,
	8747:  0xCF8D,
	8748:  0xCF8E,
	8749:  0xCF8F,
	8750:  0xCF90,
	8751:  0xCF91,
	8752:  0xCF92,
	8753:  0xCF93,
	8754:  0xCF94,
	8755:  0xCF95,
	8756:  0xCF96,
	8757:  0xCF97,
	8758:  0xCF98,
	8759:  0xCF99,
	8760:  0xCF9A,
	8761:  0xCF9B,
	8762:  0xCF9C,
	8763:  0xCF9D,
	8764:  0xCF9E,
	8765:  0xCF9F,
	8766:  0xCFA0,
	8767:  0xCFA2,
	8768:  0xCFA3,
	8769:  0xCFA4,
	8770:  0xCFA5,
	8771:  0xCFA6,
	8772:  0xCFA7,
	8773:  0xCFA9,
	8774:  0xCFAA,
	8775:  0xCFAB,
	8776:  0xCFAC,
	8777:  0xCFAD,
	8778:  0xCFAE,
	8779:  0xCFAF,
	8780:  0xCFB1,
	8781:  0xCFB2,
	8782:  0xCFB3,
	8783:  0xCFB4,
	8784:  0xCFB5,
	8785:  0xCFB6,
	8786:  0xCFB7,
	8787:  0xCFB8,
	8788:  0xCFB9,
	8789:  0xCFBA,
	8790:  0xCFBB,
	8791:  0xCFBC,
	8792:  0xCFBD,
	8793:  0xCFBE,
	8794:  0xCFBF,
	8795:  0xCFC0,
	8796:  0xCFC1,
	8797:  0xCFC2,
	8798:  0xCFC3,
	8799:  0xCFC5,
	8800:  0xCFC6,
	8801:  0xCFC7,
	8802:  0xCFC8,
	8803:  0xCFC9,
	8804:  0xCFCA,
	8805:  0xCFCB,
	8806:  0xAE79,
	8807:  0xAE7B,
	8808:  0xAE7C,
	8809:  0xAE7D,
	8810:  0xAE84,
	8811:  0xAE85,
	8812:  0xAE8C,
	8813:  0xAEBC,
	8814:  0xAEBD,
	8815:  0xAEBE,
	8816:  0xAEC0,
	8817:  0xAEC4,
	8818:  0xAECC,
	8819:  0xAECD,
	8820:  0xAECF,
	8821:  0xAED0,
	8822:  0xAED1,
	8823:  0xAED8,
	8824:  0xAED9,
	8825:  0xAEDC,
	8826:  0xAEE8,
	8827:  0xAEEB,
	8828:  0xAEED,
	8829:  0xAEF4,
	8830:  0xAEF8,
	8831:  0xAEFC,
	8832:  0xAF07,
	8833:  0xAF08,
	8834:  0xAF0D,
	8835:  0xAF10,
	8836:  0xAF2C,
	8837:  0xAF2D,
	8838:  0xAF30,
	8839:  0xAF32,
	8840:  0xAF34,
	8841:  0xAF3C,
	8842:  0xAF3D,
	8843:  0xAF3F,
	8844:  0xAF41,
	8845:  0xAF42,
	8846:  0xAF43,
	8847:  0xAF48,
	8848:  0xAF49,
	8849:  0xAF50,
	8850:  0xAF5C,
	8851:  0xAF5D,
	8852:  0xAF64,
	8853:  0xAF65,
	8854:  0xAF79,
	8855:  0xAF80,
	8856:  0xAF84,
	8857:  0xAF88,
	8858:  0xAF90,
	8859:  0xAF91,
	8860:  0xAF95,
	8861:  0xAF9C,
	8862:  0xAFB8,
	8863:  0xAFB9,
	8864:  0xAFBC,
	8865:  0xAFC0,
	8866:  0xAFC7,
	8867:  0xAFC8,
	8868:  0xAFC9,
	8869:  0xAFCB,
	8870:  0xAFCD,
	8871:  0xAFCE,
	8872:  0xAFD4,
	8873:  0xAFDC,
	8874:  0xAFE8,
	8875:  0xAFE9,
	8876:  0xAFF0,
	8877:  0xAFF1,
	8878:  0xAFF4,
	8879:  0xAFF8,
	8880:  0xB000,
	8881:  0xB001,
	8882:  0xB004,
	8883:  0xB00C,
	8884:  0xB010,
	8885:  0xB014,
	8886:  0xB01C,
	8887:  0xB01D,
	8888:  0xB028,
	8889:  0xB044,
	8890:  0xB045,
	8891:  0xB048,
	8892:  0xB04A,
	8893:  0xB04C,
	8894:  0xB04E,
	8895:  0xB053,
	8896:  0xB054,
	8897:  0xB055,
	8898:  0xB057,
	8899:  0xB059,
	8900:  0xCFCC,
	8901:  0xCFCD,
	8902:  0xCFCE,
	8903:  0xCFCF,
	8904:  0xCFD0,
	8905:  0xCFD1,
	8906:  0xCFD2,
	8907:  0xCFD3,
	8908:  0xCFD4,
	8909:  0xCFD5,
	8910:  0xCFD6,
	8911:  0xCFD7,
	8912:  0xCFD8,
	8913:  0xCFD9,
	8914:  0xCFDA,
	8915:  0xCFDB,
	8916:  0xCFDC,
	8917:  0xCFDD,
	8918:  0xCFDE,
	8919:  0xCFDF,
	8920:  0xCFE2,
	8921:  0xCFE3,
	8922:  0xCFE5,
	8923:  0xCFE6,
	8924:  0xCFE7,
	8925:  0xCFE9,
	8926:  0xCFEA,
	8927:  0xCFEB,
	8928:  0xCFEC,
	8929:  0xCFED,
	8930:  0xCFEE,
	8931:  0xCFEF,
	8932:  0xCFF2,
	8933:  0xCFF4,
	8934:  0xCFF6,
	8935:  0xCFF7,
	8936:  0xCFF8,
	8937:  0xCFF9,
	8938:  0xCFFA,
	8939:  0xCFFB,
	8940:  0xCFFD,
	8941:  0xCFFE,
	8942:  0xCFFF,
	8943:  0xD001,
	8944:  0xD002,
	8945:  0xD003,
	8946:  0xD005,
	8947:  0xD006,
	8948:  0xD007,
	8949:  0xD008,
	8950:  0xD009,
	8951:  0xD00A,
	8952:  0xD00B,
	8953:  0xD00C,
	8954:  0xD00D,
	8955:  0xD00E,
	8956:  0xD00F,
	8957:  0xD010,
	8958:  0xD012,
	8959:  0xD013,
	8960:  0xD014,
	8961:  0xD015,
	8962:  0xD016,
	8963:  0xD017,
	8964:  0xD019,
	8965:  0xD01A,
	8966:  0xD01B,
	8967:  0xD01C,
	8968:  0xD01D,
	8969:  0xD01E,
	8970:  0xD01F,
	8971:  0xD020,
	8972:  0xD021,
	8973:  0xD022,
	8974:  0xD023,
	8975:  0xD024,
	8976:  0xD025,
	8977:  0xD026,
	8978:  0xD027,
	8979:  0xD028,
	8980:  0xD029,
	8981:  0xD02A,
	8982:  0xD02B,
	8983:  0xD02C,
	8984:  0xB05D,
	8985:  0xB07C,
	8986:  0xB07D,
	8987:  0xB080,
	8988:  0xB084,
	8989:  0xB08C,
	8990:  0xB08D,
	8991:  0xB08F,
	8992:  0xB091,
	8993:  0xB098,
	8994:  0xB099,
	8995:  0xB09A,
	8996:  0xB09C,
	8997:  0xB09F,
	8998:  0xB0A0,
	8999:  0xB0A1,
	9000:  0xB0A2,
	9001:  0xB0A8,
	9002:  0xB0A9,
	9003:  0xB0AB,
	9004:  0xB0AC,
	9005:  0xB0AD,
	9006:  0xB0AE,
	9007:  0xB0AF,
	9008:  0xB0B1,
	9009:  0xB0B3,
	9010:  0xB0B4,
	9011:  0xB0B5,
	9012:  0xB0B8,
	9013:  0xB0BC,
	9014:  0xB0C4,
	9015:  0xB0C5,
	9016:  0xB0C7,
	9017:  0xB0C8,
	9018:  0xB0C9,
	9019:  0xB0D0,
	9020:  0xB0D1,
	9021:  0xB0D4,
	9022:  0xB0D8,
	9023:  0xB0E0,
	9024:  0xB0E5,
	9025:  0xB108,
	9026:  0xB109,
	9027:  0xB10B,
	9028:  0xB10C,
	9029:  0xB110,
	9030:  0xB112,
	9031:  0xB113,
	9032:  0xB118,
	9033:  0xB119,
	9034:  0xB11B,
	9035:  0xB11C,
	9036:  0xB11D,
	9037:  0xB123,
	9038:  0xB124,
	9039:  0xB125,
	9040:  0xB128,
	9041:  0xB12C,
	9042:  0xB134,
	9043:  0xB135,
	9044:  0xB137,
	9045:  0xB138,
	9046:  0xB139,
	9047:  0xB140,
	9048:  0xB141,
	9049:  0xB144,
	9050:  0xB148,
	9051:  0xB150,
	9052:  0xB151,
	9053:  0xB154,
	9054:  0xB155,
	9055:  0xB158,
	9056:  0xB15C,
	9057:  0xB160,
	9058:  0xB178,
	9059:  0xB179,
	9060:  0xB17C,
	9061:  0xB180,
	9062:  0xB182,
	9063:  0xB188,
	9064:  0xB189,
	9065:  0xB18B,
	9066:  0xB18D,
	9067:  0xB192,
	9068:  0xB193,
	9069:  0xB194,
	9070:  0xB198,
	9071:  0xB19C,
	9072:  0xB1A8,
	9073:  0xB1CC,
	9074:  0xB1D0,
	9075:  0xB1D4,
	9076:  0xB1DC,
	9077:  0xB1DD,
	9078:  0xD02E,
	9079:  0xD02F,
	9080:  0xD030,
	9081:  0xD031,
	9082:  0xD032,
	9083:  0xD033,
	9084:  0xD036,
	9085:  0xD037,
	9086:  0xD039,
	9087:  0xD03A,
	9088:  0xD03B,
	9089:  0xD03D,
	9090:  0xD03E,
	9091:  0xD03F,
	9092:  0xD040,
	9093:  0xD041,
	9094:  0xD042,
	9095:  0xD043,
	9096:  0xD046,
	9097:  0xD048,
	9098:  0xD04A,
	9099:  0xD04B,
	9100:  0xD04C,
	9101:  0xD04D,
	9102:  0xD04E,
	9103:  0xD04F,
	9104:  0xD051,
	9105:  0xD052,
	9106:  0xD053,
	9107:  0xD055,
	9108:  0xD056,
	9109:  0xD057,
	9110:  0xD059,
	9111:  0xD05A,
	9112:  0xD05B,
	9113:  0xD05C,
	9114:  0xD05D,
	9115:  0xD05E,
	9116:  0xD05F,
	9117:  0xD061,
	9118:  0xD062,
	9119:  0xD063,
	9120:  0xD064,
	9121:  0xD065,
	9122:  0xD066,
	9123:  0xD067,
	9124:  0xD068,
	9125:  0xD069,
	9126:  0xD06A,
	9127:  0xD06B,
	9128:  0xD06E,
	9129:  0xD06F,
	9130:  0xD071,
	9131:  0xD072,
	9132:  0xD073,
	9133:  0xD075,
	9134:  0xD076,
	9135:  0xD077,
	9136:  0xD078,
	9137:  0xD079,
	9138:  0xD07A,
	9139:  0xD07B,
	9140:  0xD07E,
	9141:  0xD07F,
	9142:  0xD080,
	9143:  0xD082,
	9144:  0xD083,
	9145:  0xD084,
	9146:  0xD085,
	9147:  0xD086,
	9148:  0xD087,
	9149:  0xD088,
	9150:  0xD089,
	9151:  0xD08A,
	9152:  0xD08B,
	9153:  0xD08C,
	9154:  0xD08D,
	9155:  0xD08E,
	9156:  0xD08F,
	9157:  0xD090,
	9158:  0xD091,
	9159:  0xD092,
	9160:  0xD093,
	9161:  0xD094,
	9162:  0xB1DF,
	9163:  0xB1E8,
	9164:  0xB1E9,
	9165:  0xB1EC,
	9166:  0xB1F0,
	9167:  0xB1F9,
	9168:  0xB1FB,
	9169:  0xB1FD,
	9170:  0xB204,
	9171:  0xB205,
	9172:  0xB208,
	9173:  0xB20B,
	9174:  0xB20C,
	9175:  0xB214,
	9176:  0xB215,
	9177:  0xB217,
	9178:  0xB219,
	9179:  0xB220,
	9180:  0xB234,
	9181:  0xB23C,
	9182:  0xB258,
	9183:  0xB25C,
	9184:  0xB260,
	9185:  0xB268,
	9186:  0xB269,
	9187:  0xB274,
	9188:  0xB275,
	9189:  0xB27C,
	9190:  0xB284,
	9191:  0xB285,
	9192:  0xB289,
	9193:  0xB290,
	9194:  0xB291,
	9195:  0xB294,
	9196:  0xB298,
	9197:  0xB299,
	9198:  0xB29A,
	9199:  0xB2A0,
	9200:  0xB2A1,
	9201:  0xB2A3,
	9202:  0xB2A5,
	9203:  0xB2A6,
	9204:  0xB2AA,
	9205:  0xB2AC,
	9206:  0xB2B0,
	9207:  0xB2B4,
	9208:  0xB2C8,
	9209:  0xB2C9,
	9210:  0xB2CC,
	9211:  0xB2D0,
	9212:  0xB2D2,
	9213:  0xB2D8,
	9214:  0xB2D9,
	9215:  0xB2DB,
	9216:  0xB2DD,
	9217:  0xB2E2,
	9218:  0xB2E4,
	9219:  0xB2E5,
	9220:  0xB2E6,
	9221:  0xB2E8,
	9222:  0xB2EB,
	9223:  0xB2EC,
	9224:  0xB2ED,
	9225:  0xB2EE,
	9226:  0xB2EF,
	9227:  0xB2F3,
	9228:  0xB2F4,
	9229:  0xB2F5,
	9230:  0xB2F7,
	9231:  0xB2F8,
	9232:  0xB2F9,
	9233:  0xB2FA,
	9234:  0xB2FB,
	9235:  0xB2FF,
	9236:  0xB300,
	9237:  0xB301,
	9238:  0xB304,
	9239:  0xB308,
	9240:  0xB310,
	9241:  0xB311,
	9242:  0xB313,
	9243:  0xB314,
	9244:  0xB315,
	9245:  0xB31C,
	9246:  0xB354,
	9247:  0xB355,
	9248:  0xB356,
	9249:  0xB358,
	9250:  0xB35B,
	9251:  0xB35C,
	9252:  0xB35E,
	9253:  0xB35F,
	9254:  0xB364,
	9255:  0xB365,
	9256:  0xD095,
	9257:  0xD096,
	9258:  0xD097,
	9259:  0xD098,
	9260:  0xD099,
	9261:  0xD09A,
	9262:  0xD09B,
	9263:  0xD09C,
	9264:  0xD09D,
	9265:  0xD09E,
	9266:  0xD09F,
	9267:  0xD0A0,
	9268:  0xD0A1,
	9269:  0xD0A2,
	9270:  0xD0A3,
	9271:  0xD0A6,
	9272:  0xD0A7,
	9273:  0xD0A9,
	9274:  0xD0AA,
	9275:  0xD0AB,
	9276:  0xD0AD,
	9277:  0xD0AE,
	9278:  0xD0AF,
	9279:  0xD0B0,
	9280:  0xD0B1,
	9281:  0xD0B2,
	9282:  0xD0B3,
	9283:  0xD0B6,
	9284:  0xD0B8,
	9285:  0xD0BA,
	9286:  0xD0BB,
	9287:  0xD0BC,
	9288:  0xD0BD,
	9289:  0xD0BE,
	9290:  0xD0BF,
	9291:  0xD0C2,
	9292:  0xD0C3,
	9293:  0xD0C5,
	9294:  0xD0C6,
	9295:  0xD0C7,
	9296:  0xD0CA,
	9297:  0xD0CB,
	9298:  0xD0CC,
	9299:  0xD0CD,
	9300:  0xD0CE,
	9301:  0xD0CF,
	9302:  0xD0D2,
	9303:  0xD0D6,
	9304:  0xD0D7,
	9305:  0xD0D8,
	9306:  0xD0D9,
	9307:  0xD0DA,
	9308:  0xD0DB,
	9309:  0xD0DE,
	9310:  0xD0DF,
	9311:  0xD0E1,
	9312:  0xD0E2,
	9313:  0xD0E3,
	9314:  0xD0E5,
	9315:  0xD0E6,
	9316:  0xD0E7,
	9317:  0xD0E8,
	9318:  0xD0E9,
	9319:  0xD0EA,
	9320:  0xD0EB,
	9321:  0xD0EE,
	9322:  0xD0F2,
	9323:  0xD0F3,
	9324:  0xD0F4,
	9325:  0xD0F5,
	9326:  0xD0F6,
	9327:  0xD0F7,
	9328:  0xD0F9,
	9329:  0xD0FA,
	9330:  0xD0FB,
	9331:  0xD0FC,
	9332:  0xD0FD,
	9333:  0xD0FE,
	9334:  0xD0FF,
	9335:  0xD100,
	9336:  0xD101,
	9337:  0xD102,
	9338:  0xD103,
	9339:  0xD104,
	9340:  0xB367,
	9341:  0xB369,
	9342:  0xB36B,
	9343:  0xB36E,
	9344:  0xB370,
	9345:  0xB371,
	9346:  0xB374,
	9347:  0xB378,
	9348:  0xB380,
	9349:  0xB381,
	9350:  0xB383,
	9351:  0xB384,
	9352:  0xB385,
	9353:  0xB38C,
	9354:  0xB390,
	9355:  0xB394,
	9356:  0xB3A0,
	9357:  0xB3A1,
	9358:  0xB3A8,
	9359:  0xB3AC,
	9360:  0xB3C4,
	9361:  0xB3C5,
	9362:  0xB3C8,
	9363:  0xB3CB,
	9364:  0xB3CC,
	9365:  0xB3CE,
	9366:  0xB3D0,
	9367:  0xB3D4,
	9368:  0xB3D5,
	9369:  0xB3D7,
	9370:  0xB3D9,
	9371:  0xB3DB,
	9372:  0xB3DD,
	9373:  0xB3E0,
	9374:  0xB3E4,
	9375:  0xB3E8,
	9376:  0xB3FC,
	9377:  0xB410,
	9378:  0xB418,
	9379:  0xB41C,
	9380:  0xB420,
	9381:  0xB428,
	9382:  0xB429,
	9383:  0xB42B,
	9384:  0xB434,
	9385:  0xB450,
	9386:  0xB451,
	9387:  0xB454,
	9388:  0xB458,
	9389:  0xB460,
	9390:  0xB461,
	9391:  0xB463,
	9392:  0xB465,
	9393:  0xB46C,
	9394:  0xB480,
	9395:  0xB488,
	9396:  0xB49D,
	9397:  0xB4A4,
	9398:  0xB4A8,
	9399:  0xB4AC,
	9400:  0xB4B5,
	9401:  0xB4B7,
	9402:  0xB4B9,
	9403:  0xB4C0,
	9404:  0xB4C4,
	9405:  0xB4C8,
	9406:  0xB4D0,
	9407:  0xB4D5,
	9408:  0xB4DC,
	9409:  0xB4DD,
	9410:  0xB4E0,
	9411:  0xB4E3,
	9412:  0xB4E4,
	9413:  0xB4E6,
	9414:  0xB4EC,
	9415:  0xB4ED,
	9416:  0xB4EF,
	9417:  0xB4F1,
	9418:  0xB4F8,
	9419:  0xB514,
	9420:  0xB515,
	9421:  0xB518,
	9422:  0xB51B,
	9423:  0xB51C,
	9424:  0xB524,
	9425:  0xB525,
	9426:  0xB527,
	9427:  0xB528,
	9428:  0xB529,
	9429:  0xB52A,
	9430:  0xB530,
	9431:  0xB531,
	9432:  0xB534,
	9433:  0xB538,
	9434:  0xD105,
	9435:  0xD106,
	9436:  0xD107,
	9437:  0xD108,
	9438:  0xD109,
	9439:  0xD10A,
	9440:  0xD10B,
	9441:  0xD10C,
	9442:  0xD10E,
	9443:  0xD10F,
	9444:  0xD110,
	9445:  0xD111,
	9446:  0xD112,
	9447:  0xD113,
	9448:  0xD114,
	9449:  0xD115,
	9450:  0xD116,
	9451:  0xD117,
	9452:  0xD118,
	9453:  0xD119,
	9454:  0xD11A,
	9455:  0xD11B,
	9456:  0xD11C,
	9457:  0xD11D,
	9458:  0xD11E,
	9459:  0xD11F,
	9460:  0xD120,
	9461:  0xD121,
	9462:  0xD122,
	9463:  0xD123,
	9464:  0xD124,
	9465:  0xD125,
	9466:  0xD126,
	9467:  0xD127,
	9468:  0xD128,
	9469:  0xD129,
	9470:  0xD12A,
	9471:  0xD12B,
	9472:  0xD12C,
	9473:  0xD12D,
	9474:  0xD12E,
	9475:  0xD12F,
	9476:  0xD132,
	9477:  0xD133,
	9478:  0xD135,
	9479:  0xD136,
	9480:  0xD137,
	9481:  0xD139,
	9482:  0xD13B,
	9483:  0xD13C,
	9484:  0xD13D,
	9485:  0xD13E,
	9486:  0xD13F,
	9487:  0xD142,
	9488:  0xD146,
	9489:  0xD147,
	9490:  0xD148,
	9491:  0xD149,
	9492:  0xD14A,
	9493:  0xD14B,
	9494:  0xD14E,
	9495:  0xD14F,
	9496:  0xD151,
	9497:  0xD152,
	9498:  0xD153,
	9499:  0xD155,
	9500:  0xD156,
	9501:  0xD157,
	9502:  0xD158,
	9503:  0xD159,
	9504:  0xD15A,
	9505:  0xD15B,
	9506:  0xD15E,
	9507:  0xD160,
	9508:  0xD162,
	9509:  0xD163,
	9510:  0xD164,
	9511:  0xD165,
	9512:  0xD166,
	9513:  0xD167,
	9514:  0xD169,
	9515:  0xD16A,
	9516:  0xD16B,
	9517:  0xD16D,
	9518:  0xB540,
	9519:  0xB541,
	9520:  0xB543,
	9521:  0xB544,
	9522:  0xB545,
	9523:  0xB54B,
	9524:  0xB54C,
	9525:  0xB54D,
	9526:  0xB550,
	9527:  0xB554,
	9528:  0xB55C,
	9529:  0xB55D,
	9530:  0xB55F,
	9531:  0xB560,
	9532:  0xB561,
	9533:  0xB5A0,
	9534:  0xB5A1,
	9535:  0xB5A4,
	9536:  0xB5A8,
	9537:  0xB5AA,
	9538:  0xB5AB,
	9539:  0xB5B0,
	9540:  0xB5B1,
	9541:  0xB5B3,
	9542:  0xB5B4,
	9543:  0xB5B5,
	9544:  0xB5BB,
	9545:  0xB5BC,
	9546:  0xB5BD,
	9547:  0xB5C0,
	9548:  0xB5C4,
	9549:  0xB5CC,
	9550:  0xB5CD,
	9551:  0xB5CF,
	9552:  0xB5D0,
	9553:  0xB5D1,
	9554:  0xB5D8,
	9555:  0xB5EC,
	9556:  0xB610,
	9557:  0xB611,
	9558:  0xB614,
	9559:  0xB618,
	9560:  0xB625,
	9561:  0xB62C,
	9562:  0xB634,
	9563:  0xB648,
	9564:  0xB664,
	9565:  0xB668,
	9566:  0xB69C,
	9567:  0xB69D,
	9568:  0xB6A0,
	9569:  0xB6A4,
	9570:  0xB6AB,
	9571:  0xB6AC,
	9572:  0xB6B1,
	9573:  0xB6D4,
	9574:  0xB6F0,
	9575:  0xB6F4,
	9576:  0xB6F8,
	9577:  0xB700,
	9578:  0xB701,
	9579:  0xB705,
	9580:  0xB728,
	9581:  0xB729,
	9582:  0xB72C,
	9583:  0xB72F,
	9584:  0xB730,
	9585:  0xB738,
	9586:  0xB739,
	9587:  0xB73B,
	9588:  0xB744,
	9589:  0xB748,
	9590:  0xB74C,
	9591:  0xB754,
	9592:  0xB755,
	9593:  0xB760,
	9594:  0xB764,
	9595:  0xB768,
	9596:  0xB770,
	9597:  0xB771,
	9598:  0xB773,
	9599:  0xB775,
	9600:  0xB77C,
	9601:  0xB77D,
	9602:  0xB780,
	9603:  0xB784,
	9604:  0xB78C,
	9605:  0xB78D,
	9606:  0xB78F,
	9607:  0xB790,
	9608:  0xB791,
	9609:  0xB792,
	9610:  0xB796,
	9611:  0xB797,
	9612:  0xD16E,
	9613:  0xD16F,
	9614:  0xD170,
	9615:  0xD171,
	9616:  0xD172,
	9617:  0xD173,
	9618:  0xD174,
	9619:  0xD175,
	9620:  0xD176,
	9621:  0xD177,
	9622:  0xD178,
	9623:  0xD179,
	9624:  0xD17A,
	9625:  0xD17B,
	9626:  0xD17D,
	9627:  0xD17E,
	9628:  0xD17F,
	9629:  0xD180,
	9630:  0xD181,
	9631:  0xD182,
	9632:  0xD183,
	9633:  0xD185,
	9634:  0xD186,
	9635:  0xD187,
	9636:  0xD189,
	9637:  0xD18A,
	9638:  0xD18B,
	9639:  0xD18C,
	9640:  0xD18D,
	9641:  0xD18E,
	9642:  0xD18F,
	9643:  0xD190,
	9644:  0xD191,
	9645:  0xD192,
	9646:  0xD193,
	9647:  0xD194,
	9648:  0xD195,
	9649:  0xD196,
	9650:  0xD197,
	9651:  0xD198,
	9652:  0xD199,
	9653:  0xD19A,
	9654:  0xD19B,
	9655:  0xD19C,
	9656:  0xD19D,
	9657:  0xD19E,
	9658:  0xD19F,
	9659:  0xD1A2,
	9660:  0xD1A3,
	9661:  0xD1A5,
	9662:  0xD1A6,
	9663:  0xD1A7,
	9664:  0xD1A9,
	9665:  0xD1AA,
	9666:  0xD1AB,
	9667:  0xD1AC,
	9668:  0xD1AD,
	9669:  0xD1AE,
	9670:  0xD1AF,
	9671:  0xD1B2,
	9672:  0xD1B4,
	9673:  0xD1B6,
	9674:  0xD1B7,
	9675:  0xD1B8,
	9676:  0xD1B9,
	9677:  0xD1BB,
	9678:  0xD1BD,
	9679:  0xD1BE,
	9680:  0xD1BF,
	9681:  0xD1C1,
	9682:  0xD1C2,
	9683:  0xD1C3,
	9684:  0xD1C4,
	9685:  0xD1C5,
	9686:  0xD1C6,
	9687:  0xD1C7,
	9688:  0xD1C8,
	9689:  0xD1C9,
	9690:  0xD1CA,
	9691:  0xD1CB,
	9692:  0xD1CC,
	9693:  0xD1CD,
	9694:  0xD1CE,
	9695:  0xD1CF,
	9696:  0xB798,
	9697:  0xB799,
	9698:  0xB79C,
	9699:  0xB7A0,
	9700:  0xB7A8,
	9701:  0xB7A9,
	9702:  0xB7AB,
	9703:  0xB7AC,
	9704:  0xB7AD,
	9705:  0xB7B4,
	9706:  0xB7B5,
	9707:  0xB7B8,
	9708:  0xB7C7,
	9709:  0xB7C9,
	9710:  0xB7EC,
	9711:  0xB7ED,
	9712:  0xB7F0,
	9713:  0xB7F4,
	9714:  0xB7FC,
	9715:  0xB7FD,
	9716:  0xB7FF,
	9717:  0xB800,
	9718:  0xB801,
	9719:  0xB807,
	9720:  0xB808,
	9721:  0xB809,
	9722:  0xB80C,
	9723:  0xB810,
	9724:  0xB818,
	9725:  0xB819,
	9726:  0xB81B,
	9727:  0xB81D,
	9728:  0xB824,
	9729:  0xB825,
	9730:  0xB828,
	9731:  0xB82C,
	9732:  0xB834,
	9733:  0xB835,
	9734:  0xB837,
	9735:  0xB838,
	9736:  0xB839,
	9737:  0xB840,
	9738:  0xB844,
	9739:  0xB851,
	9740:  0xB853,
	9741:  0xB85C,
	9742:  0xB85D,
	9743:  0xB860,
	9744:  0xB864,
	9745:  0xB86C,
	9746:  0xB86D,
	9747:  0xB86F,
	9748:  0xB871,
	9749:  0xB878,
	9750:  0xB87C,
	9751:  0xB88D,
	9752:  0xB8A8,
	9753:  0xB8B0,
	9754:  0xB8B4,
	9755:  0xB8B8,
	9756:  0xB8C0,
	9757:  0xB8C1,
	9758:  0xB8C3,
	9759:  0xB8C5,
	9760:  0xB8CC,
	9761:  0xB8D0,
	9762:  0xB8D4,
	9763:  0xB8DD,
	9764:  0xB8DF,
	9765:  0xB8E1,
	9766:  0xB8E8,
	9767:  0xB8E9,
	9768:  0xB8EC,
	9769:  0xB8F0,
	9770:  0xB8F8,
	9771:  0xB8F9,
	9772:  0xB8FB,
	9773:  0xB8FD,
	9774:  0xB904,
	9775:  0xB918,
	9776:  0xB920,
	9777:  0xB93C,
	9778:  0xB93D,
	9779:  0xB940,
	9780:  0xB944,
	9781:  0xB94C,
	9782:  0xB94F,
	9783:  0xB951,
	9784:  0xB958,
	9785:  0xB959,
	9786:  0xB95C,
	9787:  0xB960,
	9788:  0xB968,
	9789:  0xB969,
	9790:  0xD1D0,
	9791:  0xD1D1,
	9792:  0xD1D2,
	9793:  0xD1D3,
	9794:  0xD1D4,
	9795:  0xD1D5,
	9796:  0xD1D6,
	9797:  0xD1D7,
	9798:  0xD1D9,
	9799:  0xD1DA,
	9800:  0xD1DB,
	9801:  0xD1DC,
	9802:  0xD1DD,
	9803:  0xD1DE,
	9804:  0xD1DF,
	9805:  0xD1E0,
	9806:  0xD1E1,
	9807:  0xD1E2,
	9808:  0xD1E3,
	9809:  0xD1E4,
	9810:  0xD1E5,
	9811:  0xD1E6,
	9812:  0xD1E7,
	9813:  0xD1E8,
	9814:  0xD1E9,
	9815:  0xD1EA,
	9816:  0xD1EB,
	9817:  0xD1EC,
	9818:  0xD1ED,
	9819:  0xD1EE,
	9820:  0xD1EF,
	9821:  0xD1F0,
	9822:  0xD1F1,
	9823:  0xD1F2,
	9824:  0xD1F3,
	9825:  0xD1F5,
	9826:  0xD1F6,
	9827:  0xD1F7,
	9828:  0xD1F9,
	9829:  0xD1FA,
	9830:  0xD1FB,
	9831:  0xD1FC,
	9832:  0xD1FD,
	9833:  0xD1FE,
	9834:  0xD1FF,
	9835:  0xD200,
	9836:  0xD201,
	9837:  0xD202,
	9838:  0xD203,
	9839:  0xD204,
	9840:  0xD205,
	9841:  0xD206,
	9842:  0xD208,
	9843:  0xD20A,
	9844:  0xD20B,
	9845:  0xD20C,
	9846:  0xD20D,
	9847:  0xD20E,
	9848:  0xD20F,
	9849:  0xD211,
	9850:  0xD212,
	9851:  0xD213,
	9852:  0xD214,
	9853:  0xD215,
	9854:  0xD216,
	9855:  0xD217,
	9856:  0xD218,
	9857:  0xD219,
	9858:  0xD21A,
	9859:  0xD21B,
	9860:  0xD21C,
	9861:  0xD21D,
	9862:  0xD21E,
	9863:  0xD21F,
	9864:  0xD220,
	9865:  0xD221,
	9866:  0xD222,
	9867:  0xD223,
	9868:  0xD224,
	9869:  0xD225,
	9870:  0xD226,
	9871:  0xD227,
	9872:  0xD228,
	9873:  0xD229,
	9874:  0xB96B,
	9875:  0xB96D,
	9876:  0xB974,
	9877:  0xB975,
	9878:  0xB978,
	9879:  0xB97C,
	9880:  0xB984,
	9881:  0xB985,
	9882:  0xB987,
	9883:  0xB989,
	9884:  0xB98A,
	9885:  0xB98D,
	9886:  0xB98E,
	9887:  0xB9AC,
	9888:  0xB9AD,
	9889:  0xB9B0,
	9890:  0xB9B4,
	9891:  0xB9BC,
	9892:  0xB9BD,
	9893:  0xB9BF,
	9894:  0xB9C1,
	9895:  0xB9C8,
	9896:  0xB9C9,
	9897:  0xB9CC,
	9898:  0xB9CE,
	9899:  0xB9CF,
	9900:  0xB9D0,
	9901:  0xB9D1,
	9902:  0xB9D2,
	9903:  0xB9D8,
	9904:  0xB9D9,
	9905:  0xB9DB,
	9906:  0xB9DD,
	9907:  0xB9DE,
	9908:  0xB9E1,
	9909:  0xB9E3,
	9910:  0xB9E4,
	9911:  0xB9E5,
	9912:  0xB9E8,
	9913:  0xB9EC,
	9914:  0xB9F4,
	9915:  0xB9F5,
	9916:  0xB9F7,
	9917:  0xB9F8,
	9918:  0xB9F9,
	9919:  0xB9FA,
	9920:  0xBA00,
	9921:  0xBA01,
	9922:  0xBA08,
	9923:  0xBA15,
	9924:  0xBA38,
	9925:  0xBA39,
	9926:  0xBA3C,
	9927:  0xBA40,
	9928:  0xBA42,
	9929:  0xBA48,
	9930:  0xBA49,
	9931:  0xBA4B,
	9932:  0xBA4D,
	9933:  0xBA4E,
	9934:  0xBA53,
	9935:  0xBA54,
	9936:  0xBA55,
	9937:  0xBA58,
	9938:  0xBA5C,
	9939:  0xBA64,
	9940:  0xBA65,
	9941:  0xBA67,
	9942:  0xBA68,
	9943:  0xBA69,
	9944:  0xBA70,
	9945:  0xBA71,
	9946:  0xBA74,
	9947:  0xBA78,
	9948:  0xBA83,
	9949:  0xBA84,
	9950:  0xBA85,
	9951:  0xBA87,
	9952:  0xBA8C,
	9953:  0xBAA8,
	9954:  0xBAA9,
	9955:  0xBAAB,
	9956:  0xBAAC,
	9957:  0xBAB0,
	9958:  0xBAB2,
	9959:  0xBAB8,
	9960:  0xBAB9,
	9961:  0xBABB,
	9962:  0xBABD,
	9963:  0xBAC4,
	9964:  0xBAC8,
	9965:  0xBAD8,
	9966:  0xBAD9,
	9967:  0xBAFC,
	9968:  0xD22A,
	9969:  0xD22B,
	9970:  0xD22E,
	9971:  0xD22F,
	9972:  0xD231,
	9973:  0xD232,
	9974:  0xD233,
	9975:  0xD235,
	9976:  0xD236,
	9977:  0xD237,
	9978:  0xD238,
	9979:  0xD239,
	9980:  0xD23A,
	9981:  0xD23B,
	9982:  0xD23E,
	9983:  0xD240,
	9984:  0xD242,
	9985:  0xD243,
	9986:  0xD244,
	9987:  0xD245,
	9988:  0xD246,
	9989:  0xD247,
	9990:  0xD249,
	9991:  0xD24A,
	9992:  0xD24B,
	9993:  0xD24C,
	9994:  0xD24D,
	9995:  0xD24E,
	9996:  0xD24F,
	9997:  0xD250,
	9998:  0xD251,
	9999:  0xD252,
	10000: 0xD253,
	10001: 0xD254,
	10002: 0xD255,
	10003: 0xD256,
	10004: 0xD257,
	10005: 0xD258,
	10006: 0xD259,
	10007: 0xD25A,
	10008: 0xD25B,
	10009: 0xD25D,
	10010: 0xD25E,
	10011: 0xD25F,
	10012: 0xD260,
	10013: 0xD261,
	10014: 0xD262,
	10015: 0xD263,
	10016: 0xD265,
	10017: 0xD266,
	10018: 0xD267,
	10019: 0xD268,
	10020: 0xD269,
	10021: 0xD26A,
	10022: 0xD26B,
	10023: 0xD26C,
	10024: 0xD26D,
	10025: 0xD26E,
	10026: 0xD26F,
	10027: 0xD270,
	10028: 0xD271,
	10029: 0xD272,
	10030: 0xD273,
	10031: 0xD274,
	10032: 0xD275,
	10033: 0xD276,
	10034: 0xD277,
	10035: 0xD278,
	10036: 0xD279,
	10037: 0xD27A,
	10038: 0xD27B,
	10039: 0xD27C,
	10040: 0xD27D,
	10041: 0xD27E,
	10042: 0xD27F,
	10043: 0xD282,
	10044: 0xD283,
	10045: 0xD285,
	10046: 0xD286,
	10047: 0xD287,
	10048: 0xD289,
	10049: 0xD28A,
	10050: 0xD28B,
	10051: 0xD28C,
	10052: 0xBB00,
	10053: 0xBB04,
	10054: 0xBB0D,
	10055: 0xBB0F,
	10056: 0xBB11,
	10057: 0xBB18,
	10058: 0xBB1C,
	10059: 0xBB20,
	10060: 0xBB29,
	10061: 0xBB2B,
	10062: 0xBB34,
	10063: 0xBB35,
	10064: 0xBB36,
	10065: 0xBB38,
	10066: 0xBB3B,
	10067: 0xBB3C,
	10068: 0xBB3D,
	10069: 0xBB3E,
	10070: 0xBB44,
	10071: 0xBB45,
	10072: 0xBB47,
	10073: 0xBB49,
	10074: 0xBB4D,
	10075: 0xBB4F,
	10076: 0xBB50,
	10077: 0xBB54,
	10078: 0xBB58,
	10079: 0xBB61,
	10080: 0xBB63,
	10081: 0xBB6C,
	10082: 0xBB88,
	10083: 0xBB8C,
	10084: 0xBB90,
	10085: 0xBBA4,
	10086: 0xBBA8,
	10087: 0xBBAC,
	10088: 0xBBB4,
	10089: 0xBBB7,
	10090: 0xBBC0,
	10091: 0xBBC4,
	10092: 0xBBC8,
	10093: 0xBBD0,
	10094: 0xBBD3,
	10095: 0xBBF8,
	10096: 0xBBF9,
	10097: 0xBBFC,
	10098: 0xBBFF,
	10099: 0xBC00,
	10100: 0xBC02,
	10101: 0xBC08,
	10102: 0xBC09,
	10103: 0xBC0B,
	10104: 0xBC0C,
	10105: 0xBC0D,
	10106: 0xBC0F,
	10107: 0xBC11,
	10108: 0xBC14,
	10109: 0xBC15,
	10110: 0xBC16,
	10111: 0xBC17,
	10112: 0xBC18,
	10113: 0xBC1B,
	10114: 0xBC1C,
	10115: 0xBC1D,
	10116: 0xBC1E,
	10117: 0xBC1F,
	10118: 0xBC24,
	10119: 0xBC25,
	10120: 0xBC27,
	10121: 0xBC29,
	10122: 0xBC2D,
	10123: 0xBC30,
	10124: 0xBC31,
	10125: 0xBC34,
	10126: 0xBC38,
	10127: 0xBC40,
	10128: 0xBC41,
	10129: 0xBC43,
	10130: 0xBC44,
	10131: 0xBC45,
	10132: 0xBC49,
	10133: 0xBC4C,
	10134: 0xBC4D,
	10135: 0xBC50,
	10136: 0xBC5D,
	10137: 0xBC84,
	10138: 0xBC85,
	10139: 0xBC88,
	10140: 0xBC8B,
	10141: 0xBC8C,
	10142: 0xBC8E,
	10143: 0xBC94,
	10144: 0xBC95,
	10145: 0xBC97,
	10146: 0xD28D,
	10147: 0xD28E,
	10148: 0xD28F,
	10149: 0xD292,
	10150: 0xD293,
	10151: 0xD294,
	10152: 0xD296,
	10153: 0xD297,
	10154: 0xD298,
	10155: 0xD299,
	10156: 0xD29A,
	10157: 0xD29B,
	10158: 0xD29D,
	10159: 0xD29E,
	10160: 0xD29F,
	10161: 0xD2A1,
	10162: 0xD2A2,
	10163: 0xD2A3,
	10164: 0xD2A5,
	10165: 0xD2A6,
	10166: 0xD2A7,
	10167: 0xD2A8,
	10168: 0xD2A9,
	10169: 0xD2AA,
	10170: 0xD2AB,
	10171: 0xD2AD,
	10172: 0xD2AE,
	10173: 0xD2AF,
	10174: 0xD2B0,
	10175: 0xD2B2,
	10176: 0xD2B3,
	10177: 0xD2B4,
	10178: 0xD2B5,
	10179: 0xD2B6,
	10180: 0xD2B7,
	10181: 0xD2BA,
	10182: 0xD2BB,
	10183: 0xD2BD,
	10184: 0xD2BE,
	10185: 0xD2C1,
	10186: 0xD2C3,
	10187: 0xD2C4,
	10188: 0xD2C5,
	10189: 0xD2C6,
	10190: 0xD2C7,
	10191: 0xD2CA,
	10192: 0xD2CC,
	10193: 0xD2CD,
	10194: 0xD2CE,
	10195: 0xD2CF,
	10196: 0xD2D0,
	10197: 0xD2D1,
	10198: 0xD2D2,
	10199: 0xD2D3,
	10200: 0xD2D5,
	10201: 0xD2D6,
	10202: 0xD2D7,
	10203: 0xD2D9,
	10204: 0xD2DA,
	10205: 0xD2DB,
	10206: 0xD2DD,
	10207: 0xD2DE,
	10208: 0xD2DF,
	10209: 0xD2E0,
	10210: 0xD2E1,
	10211: 0xD2E2,
	10212: 0xD2E3,
	10213: 0xD2E6,
	10214: 0xD2E7,
	10215: 0xD2E8,
	10216: 0xD2E9,
	10217: 0xD2EA,
	10218: 0xD2EB,
	10219: 0xD2EC,
	10220: 0xD2ED,
	10221: 0xD2EE,
	10222: 0xD2EF,
	10223: 0xD2F2,
	10224: 0xD2F3,
	10225: 0xD2F5,
	10226: 0xD2F6,
	10227: 0xD2F7,
	10228: 0xD2F9,
	10229: 0xD2FA,
	10230: 0xBC99,
	10231: 0xBC9A,
	10232: 0xBCA0,
	10233: 0xBCA1,
	10234: 0xBCA4,
	10235: 0xBCA7,
	10236: 0xBCA8,
	10237: 0xBCB0,
	10238: 0xBCB1,
	10239: 0xBCB3,
	10240: 0xBCB4,
	10241: 0xBCB5,
	10242: 0xBCBC,
	10243: 0xBCBD,
	10244: 0xBCC0,
	10245: 0xBCC4,
	10246: 0xBCCD,
	10247: 0xBCCF,
	10248: 0xBCD0,
	10249: 0xBCD1,
	10250: 0xBCD5,
	10251: 0xBCD8,
	10252: 0xBCDC,
	10253: 0xBCF4,
	10254: 0xBCF5,
	10255: 0xBCF6,
	10256: 0xBCF8,
	10257: 0xBCFC,
	10258: 0xBD04,
	10259: 0xBD05,
	10260: 0xBD07,
	10261: 0xBD09,
	10262: 0xBD10,
	10263: 0xBD14,
	10264: 0xBD24,
	10265: 0xBD2C,
	10266: 0xBD40,
	10267: 0xBD48,
	10268: 0xBD49,
	10269: 0xBD4C,
	10270: 0xBD50,
	10271: 0xBD58,
	10272: 0xBD59,
	10273: 0xBD64,
	10274: 0xBD68,
	10275: 0xBD80,
	10276: 0xBD81,
	10277: 0xBD84,
	10278: 0xBD87,
	10279: 0xBD88,
	10280: 0xBD89,
	10281: 0xBD8A,
	10282: 0xBD90,
	10283: 0xBD91,
	10284: 0xBD93,
	10285: 0xBD95,
	10286: 0xBD99,
	10287: 0xBD9A,
	10288: 0xBD9C,
	10289: 0xBDA4,
	10290: 0xBDB0,
	10291: 0xBDB8,
	10292: 0xBDD4,
	10293: 0xBDD5,
	10294: 0xBDD8,
	10295: 0xBDDC,
	10296: 0xBDE9,
	10297: 0xBDF0,
	10298: 0xBDF4,
	10299: 0xBDF8,
	10300: 0xBE00,
	10301: 0xBE03,
	10302: 0xBE05,
	10303: 0xBE0C,
	10304: 0xBE0D,
	10305: 0xBE10,
	10306: 0xBE14,
	10307: 0xBE1C,
	10308: 0xBE1D,
	10309: 0xBE1F,
	10310: 0xBE44,
	10311: 0xBE45,
	10312: 0xBE48,
	10313: 0xBE4C,
	10314: 0xBE4E,
	10315: 0xBE54,
	10316: 0xBE55,
	10317: 0xBE57,
	10318: 0xBE59,
	10319: 0xBE5A,
	10320: 0xBE5B,
	10321: 0xBE60,
	10322: 0xBE61,
	10323: 0xBE64,
	10324: 0xD2FB,
	10325: 0xD2FC,
	10326: 0xD2FD,
	10327: 0xD2FE,
	10328: 0xD2FF,
	10329: 0xD302,
	10330: 0xD304,
	10331: 0xD306,
	10332: 0xD307,
	10333: 0xD308,
	10334: 0xD309,
	10335: 0xD30A,
	10336: 0xD30B,
	10337: 0xD30F,
	10338: 0xD311,
	10339: 0xD312,
	10340: 0xD313,
	10341: 0xD315,
	10342: 0xD317,
	10343: 0xD318,
	10344: 0xD319,
	10345: 0xD31A,
	10346: 0xD31B,
	10347: 0xD31E,
	10348: 0xD322,
	10349: 0xD323,
	10350: 0xD324,
	10351: 0xD326,
	10352: 0xD327,
	10353: 0xD32A,
	10354: 0xD32B,
	10355: 0xD32D,
	10356: 0xD32E,
	10357: 0xD32F,
	10358: 0xD331,
	10359: 0xD332,
	10360: 0xD333,
	10361: 0xD334,
	10362: 0xD335,
	10363: 0xD336,
	10364: 0xD337,
	10365: 0xD33A,
	10366: 0xD33E,
	10367: 0xD33F,
	10368: 0xD340,
	10369: 0xD341,
	10370: 0xD342,
	10371: 0xD343,
	10372: 0xD346,
	10373: 0xD347,
	10374: 0xD348,
	10375: 0xD349,
	10376: 0xD34A,
	10377: 0xD34B,
	10378: 0xD34C,
	10379: 0xD34D,
	10380: 0xD34E,
	10381: 0xD34F,
	10382: 0xD350,
	10383: 0xD351,
	10384: 0xD352,
	10385: 0xD353,
	10386: 0xD354,
	10387: 0xD355,
	10388: 0xD356,
	10389: 0xD357,
	10390: 0xD358,
	10391: 0xD359,
	10392: 0xD35A,
	10393: 0xD35B,
	10394: 0xD35C,
	10395: 0xD35D,
	10396: 0xD35E,
	10397: 0xD35F,
	10398: 0xD360,
	10399: 0xD361,
	10400: 0xD362,
	10401: 0xD363,
	10402: 0xD364,
	10403: 0xD365,
	10404: 0xD366,
	10405: 0xD367,
	10406: 0xD368,
	10407: 0xD369,
	10408: 0xBE68,
	10409: 0xBE6A,
	10410: 0xBE70,
	10411: 0xBE71,
	10412: 0xBE73,
	10413: 0xBE74,
	10414: 0xBE75,
	10415: 0xBE7B,
	10416: 0xBE7C,
	10417: 0xBE7D,
	10418: 0xBE80,
	10419: 0xBE84,
	10420: 0xBE8C,
	10421: 0xBE8D,
	10422: 0xBE8F,
	10423: 0xBE90,
	10424: 0xBE91,
	10425: 0xBE98,
	10426: 0xBE99,
	10427: 0xBEA8,
	10428: 0xBED0,
	10429: 0xBED1,
	10430: 0xBED4,
	10431: 0xBED7,
	10432: 0xBED8,
	10433: 0xBEE0,
	10434: 0xBEE3,
	10435: 0xBEE4,
	10436: 0xBEE5,
	10437: 0xBEEC,
	10438: 0xBF01,
	10439: 0xBF08,
	10440: 0xBF09,
	10441: 0xBF18,
	10442: 0xBF19,
	10443: 0xBF1B,
	10444: 0xBF1C,
	10445: 0xBF1D,
	10446: 0xBF40,
	10447: 0xBF41,
	10448: 0xBF44,
	10449: 0xBF48,
	10450: 0xBF50,
	10451: 0xBF51,
	10452: 0xBF55,
	10453: 0xBF94,
	10454: 0xBFB0,
	10455: 0xBFC5,
	10456: 0xBFCC,
	10457: 0xBFCD,
	10458: 0xBFD0,
	10459: 0xBFD4,
	10460: 0xBFDC,
	10461: 0xBFDF,
	10462: 0xBFE1,
	10463: 0xC03C,
	10464: 0xC051,
	10465: 0xC058,
	10466: 0xC05C,
	10467: 0xC060,
	10468: 0xC068,
	10469: 0xC069,
	10470: 0xC090,
	10471: 0xC091,
	10472: 0xC094,
	10473: 0xC098,
	10474: 0xC0A0,
	10475: 0xC0A1,
	10476: 0xC0A3,
	10477: 0xC0A5,
	10478: 0xC0AC,
	10479: 0xC0AD,
	10480: 0xC0AF,
	10481: 0xC0B0,
	10482: 0xC0B3,
	10483: 0xC0B4,
	10484: 0xC0B5,
	10485: 0xC0B6,
	10486: 0xC0BC,
	10487: 0xC0BD,
	10488: 0xC0BF,
	10489: 0xC0C0,
	10490: 0xC0C1,
	10491: 0xC0C5,
	10492: 0xC0C8,
	10493: 0xC0C9,
	10494: 0xC0CC,
	10495: 0xC0D0,
	10496: 0xC0D8,
	10497: 0xC0D9,
	10498: 0xC0DB,
	10499: 0xC0DC,
	10500: 0xC0DD,
	10501: 0xC0E4,
	10502: 0xD36A,
	10503: 0xD36B,
	10504: 0xD36C,
	10505: 0xD36D,
	10506: 0xD36E,
	10507: 0xD36F,
	10508: 0xD370,
	10509: 0xD371,
	10510: 0xD372,
	10511: 0xD373,
	10512: 0xD374,
	10513: 0xD375,
	10514: 0xD376,
	10515: 0xD377,
	10516: 0xD378,
	10517: 0xD379,
	10518: 0xD37A,
	10519: 0xD37B,
	10520: 0xD37E,
	10521: 0xD37F,
	10522: 0xD381,
	10523: 0xD382,
	10524: 0xD383,
	10525: 0xD385,
	10526: 0xD386,
	10527: 0xD387,
	10528: 0xD388,
	10529: 0xD389,
	10530: 0xD38A,
	10531: 0xD38B,
	10532: 0xD38E,
	10533: 0xD392,
	10534: 0xD393,
	10535: 0xD394,
	10536: 0xD395,
	10537: 0xD396,
	10538: 0xD397,
	10539: 0xD39A,
	10540: 0xD39B,
	10541: 0xD39D,
	10542: 0xD39E,
	10543: 0xD39F,
	10544: 0xD3A1,
	10545: 0xD3A2,
	10546: 0xD3A3,
	10547: 0xD3A4,
	10548: 0xD3A5,
	10549: 0xD3A6,
	10550: 0xD3A7,
	10551: 0xD3AA,
	10552: 0xD3AC,
	10553: 0xD3AE,
	10554: 0xD3AF,
	10555: 0xD3B0,
	10556: 0xD3B1,
	10557: 0xD3B2,
	10558: 0xD3B3,
	10559: 0xD3B5,
	10560: 0xD3B6,
	10561: 0xD3B7,
	10562: 0xD3B9,
	10563: 0xD3BA,
	10564: 0xD3BB,
	10565: 0xD3BD,
	10566: 0xD3BE,
	10567: 0xD3BF,
	10568: 0xD3C0,
	10569: 0xD3C1,
	10570: 0xD3C2,
	10571: 0xD3C3,
	10572: 0xD3C6,
	10573: 0xD3C7,
	10574: 0xD3CA,
	10575: 0xD3CB,
	10576: 0xD3CC,
	10577: 0xD3CD,
	10578: 0xD3CE,
	10579: 0xD3CF,
	10580: 0xD3D1,
	10581: 0xD3D2,
	10582: 0xD3D3,
	10583: 0xD3D4,
	10584: 0xD3D5,
	10585: 0xD3D6,
	10586: 0xC0E5,
	10587: 0xC0E8,
	10588: 0xC0EC,
	10589: 0xC0F4,
	10590: 0xC0F5,
	10591: 0xC0F7,
	10592: 0xC0F9,
	10593: 0xC100,
	10594: 0xC104,
	10595: 0xC108,
	10596: 0xC110,
	10597: 0xC115,
	10598: 0xC11C,
	10599: 0xC11D,
	10600: 0xC11E,
	10601: 0xC11F,
	10602: 0xC120,
	10603: 0xC123,
	10604: 0xC124,
	10605: 0xC126,
	10606: 0xC127,
	10607: 0xC12C,
	10608: 0xC12D,
	10609: 0xC12F,
	10610: 0xC130,
	10611: 0xC131,
	10612: 0xC136,
	10613: 0xC138,
	10614: 0xC139,
	10615: 0xC13C,
	10616: 0xC140,
	10617: 0xC148,
	10618: 0xC149,
	10619: 0xC14B,
	10620: 0xC14C,
	10621: 0xC14D,
	10622: 0xC154,
	10623: 0xC155,
	10624: 0xC158,
	10625: 0xC15C,
	10626: 0xC164,
	10627: 0xC165,
	10628: 0xC167,
	10629: 0xC168,
	10630: 0xC169,
	10631: 0xC170,
	10632: 0xC174,
	10633: 0xC178,
	10634: 0xC185,
	10635: 0xC18C,
	10636: 0xC18D,
	10637: 0xC18E,
	10638: 0xC190,
	10639: 0xC194,
	10640: 0xC196,
	10641: 0xC19C,
	10642: 0xC19D,
	10643: 0xC19F,
	10644: 0xC1A1,
	10645: 0xC1A5,
	10646: 0xC1A8,
	10647: 0xC1A9,
	10648: 0xC1AC,
	10649: 0xC1B0,
	10650: 0xC1BD,
	10651: 0xC1C4,
	10652: 0xC1C8,
	10653: 0xC1CC,
	10654: 0xC1D4,
	10655: 0xC1D7,
	10656: 0xC1D8,
	10657: 0xC1E0,
	10658: 0xC1E4,
	10659: 0xC1E8,
	10660: 0xC1F0,
	10661: 0xC1F1,
	10662: 0xC1F3,
	10663: 0xC1FC,
	10664: 0xC1FD,
	10665: 0xC200,
	10666: 0xC204,
	10667: 0xC20C,
	10668: 0xC20D,
	10669: 0xC20F,
	10670: 0xC211,
	10671: 0xC218,
	10672: 0xC219,
	10673: 0xC21C,
	10674: 0xC21F,
	10675: 0xC220,
	10676: 0xC228,
	10677: 0xC229,
	10678: 0xC22B,
	10679: 0xC22D,
	10680: 0xD3D7,
	10681: 0xD3D9,
	10682: 0xD3DA,
	10683: 0xD3DB,
	10684: 0xD3DC,
	10685: 0xD3DD,
	10686: 0xD3DE,
	10687: 0xD3DF,
	10688: 0xD3E0,
	10689: 0xD3E2,
	10690: 0xD3E4,
	10691: 0xD3E5,
	10692: 0xD3E6,
	10693: 0xD3E7,
	10694: 0xD3E8,
	10695: 0xD3E9,
	10696: 0xD3EA,
	10697: 0xD3EB,
	10698: 0xD3EE,
	10699: 0xD3EF,
	10700: 0xD3F1,
	10701: 0xD3F2,
	10702: 0xD3F3,
	10703: 0xD3F5,
	10704: 0xD3F6,
	10705: 0xD3F7,
	10706: 0xD3F8,
	10707: 0xD3F9,
	10708: 0xD3FA,
	10709: 0xD3FB,
	10710: 0xD3FE,
	10711: 0xD400,
	10712: 0xD402,
	10713: 0xD403,
	10714: 0xD404,
	10715: 0xD405,
	10716: 0xD406,
	10717: 0xD407,
	10718: 0xD409,
	10719: 0xD40A,
	10720: 0xD40B,
	10721: 0xD40C,
	10722: 0xD40D,
	10723: 0xD40E,
	10724: 0xD40F,
	10725: 0xD410,
	10726: 0xD411,
	10727: 0xD412,
	10728: 0xD413,
	10729: 0xD414,
	10730: 0xD415,
	10731: 0xD416,
	10732: 0xD417,
	10733: 0xD418,
	10734: 0xD419,
	10735: 0xD41A,
	10736: 0xD41B,
	10737: 0xD41C,
	10738: 0xD41E,
	10739: 0xD41F,
	10740: 0xD420,
	10741: 0xD421,
	10742: 0xD422,
	10743: 0xD423,
	10744: 0xD424,
	10745: 0xD425,
	10746: 0xD426,
	10747: 0xD427,
	10748: 0xD428,
	10749: 0xD429,
	10750: 0xD42A,
	10751: 0xD42B,
	10752: 0xD42C,
	10753: 0xD42D,
	10754: 0xD42E,
	10755: 0xD42F,
	10756: 0xD430,
	10757: 0xD431,
	10758: 0xD432,
	10759: 0xD433,
	10760: 0xD434,
	10761: 0xD435,
	10762: 0xD436,
	10763: 0xD437,
	10764: 0xC22F,
	10765: 0xC231,
	10766: 0xC232,
	10767: 0xC234,
	10768: 0xC248,
	10769: 0xC250,
	10770: 0xC251,
	10771: 0xC254,
	10772: 0xC258,
	10773: 0xC260,
	10774: 0xC265,
	10775: 0xC26C,
	10776: 0xC26D,
	10777: 0xC270,
	10778: 0xC274,
	10779: 0xC27C,
	10780: 0xC27D,
	10781: 0xC27F,
	10782: 0xC281,
	10783: 0xC288,
	10784: 0xC289,
	10785: 0xC290,
	10786: 0xC298,
	10787: 0xC29B,
	10788: 0xC29D,
	10789: 0xC2A4,
	10790: 0xC2A5,
	10791: 0xC2A8,
	10792: 0xC2AC,
	10793: 0xC2AD,
	10794: 0xC2B4,
	10795: 0xC2B5,
	10796: 0xC2B7,
	10797: 0xC2B9,
	10798: 0xC2DC,
	10799: 0xC2DD,
	10800: 0xC2E0,
	10801: 0xC2E3,
	10802: 0xC2E4,
	10803: 0xC2EB,
	10804: 0xC2EC,
	10805: 0xC2ED,
	10806: 0xC2EF,
	10807: 0xC2F1,
	10808: 0xC2F6,
	10809: 0xC2F8,
	10810: 0xC2F9,
	10811: 0xC2FB,
	10812: 0xC2FC,
	10813: 0xC300,
	10814: 0xC308,
	10815: 0xC309,
	10816: 0xC30C,
	10817: 0xC30D,
	10818: 0xC313,
	10819: 0xC314,
	10820: 0xC315,
	10821: 0xC318,
	10822: 0xC31C,
	10823: 0xC324,
	10824: 0xC325,
	10825: 0xC328,
	10826: 0xC329,
	10827: 0xC345,
	10828: 0xC368,
	10829: 0xC369,
	10830: 0xC36C,
	10831: 0xC370,
	10832: 0xC372,
	10833: 0xC378,
	10834: 0xC379,
	10835: 0xC37C,
	10836: 0xC37D,
	10837: 0xC384,
	10838: 0xC388,
	10839: 0xC38C,
	10840: 0xC3C0,
	10841: 0xC3D8,
	10842: 0xC3D9,
	10843: 0xC3DC,
	10844: 0xC3DF,
	10845: 0xC3E0,
	10846: 0xC3E2,
	10847: 0xC3E8,
	10848: 0xC3E9,
	10849: 0xC3ED,
	10850: 0xC3F4,
	10851: 0xC3F5,
	10852: 0xC3F8,
	10853: 0xC408,
	10854: 0xC410,
	10855: 0xC424,
	10856: 0xC42C,
	10857: 0xC430,
	10858: 0xD438,
	10859: 0xD439,
	10860: 0xD43A,
	10861: 0xD43B,
	10862: 0xD43C,
	10863: 0xD43D,
	10864: 0xD43E,
	10865: 0xD43F,
	10866: 0xD441,
	10867: 0xD442,
	10868: 0xD443,
	10869: 0xD445,
	10870: 0xD446,
	10871: 0xD447,
	10872: 0xD448,
	10873: 0xD449,
	10874: 0xD44A,
	10875: 0xD44B,
	10876: 0xD44C,
	10877: 0xD44D,
	10878: 0xD44E,
	10879: 0xD44F,
	10880: 0xD450,
	10881: 0xD451,
	10882: 0xD452,
	10883: 0xD453,
	10884: 0xD454,
	10885: 0xD455,
	10886: 0xD456,
	10887: 0xD457,
	10888: 0xD458,
	10889: 0xD459,
	10890: 0xD45A,
	10891: 0xD45B,
	10892: 0xD45D,
	10893: 0xD45E,
	10894: 0xD45F,
	10895: 0xD461,
	10896: 0xD462,
	10897: 0xD463,
	10898: 0xD465,
	10899: 0xD466,
	10900: 0xD467,
	10901: 0xD468,
	10902: 0xD469,
	10903: 0xD46A,
	10904: 0xD46B,
	10905: 0xD46C,
	10906: 0xD46E,
	10907: 0xD470,
	10908: 0xD471,
	10909: 0xD472,
	10910: 0xD473,
	10911: 0xD474,
	10912: 0xD475,
	10913: 0xD476,
	10914: 0xD477,
	10915: 0xD47A,
	10916: 0xD47B,
	10917: 0xD47D,
	10918: 0xD47E,
	10919: 0xD481,
	10920: 0xD483,
	10921: 0xD484,
	10922: 0xD485,
	10923: 0xD486,
	10924: 0xD487,
	10925: 0xD48A,
	10926: 0xD48C,
	10927: 0xD48E,
	10928: 0xD48F,
	10929: 0xD490,
	10930: 0xD491,
	10931: 0xD492,
	10932: 0xD493,
	10933: 0xD495,
	10934: 0xD496,
	10935: 0xD497,
	10936: 0xD498,
	10937: 0xD499,
	10938: 0xD49A,
	10939: 0xD49B,
	10940: 0xD49C,
	10941: 0xD49D,
	10942: 0xC434,
	10943: 0xC43C,
	10944: 0xC43D,
	10945: 0xC448,
	10946: 0xC464,
	10947: 0xC465,
	10948: 0xC468,
	10949: 0xC46C,
	10950: 0xC474,
	10951: 0xC475,
	10952: 0xC479,
	10953: 0xC480,
	10954: 0xC494,
	10955: 0xC49C,
	10956: 0xC4B8,
	10957: 0xC4BC,
	10958: 0xC4E9,
	10959: 0xC4F0,
	10960: 0xC4F1,
	10961: 0xC4F4,
	10962: 0xC4F8,
	10963: 0xC4FA,
	10964: 0xC4FF,
	10965: 0xC500,
	10966: 0xC501,
	10967: 0xC50C,
	10968: 0xC510,
	10969: 0xC514,
	10970: 0xC51C,
	10971: 0xC528,
	10972: 0xC529,
	10973: 0xC52C,
	10974: 0xC530,
	10975: 0xC538,
	10976: 0xC539,
	10977: 0xC53B,
	10978: 0xC53D,
	10979: 0xC544,
	10980: 0xC545,
	10981: 0xC548,
	10982: 0xC549,
	10983: 0xC54A,
	10984: 0xC54C,
	10985: 0xC54D,
	10986: 0xC54E,
	10987: 0xC553,
	10988: 0xC554,
	10989: 0xC555,
	10990: 0xC557,
	10991: 0xC558,
	10992: 0xC559,
	10993: 0xC55D,
	10994: 0xC55E,
	10995: 0xC560,
	10996: 0xC561,
	10997: 0xC564,
	10998: 0xC568,
	10999: 0xC570,
	11000: 0xC571,
	11001: 0xC573,
	11002: 0xC574,
	11003: 0xC575,
	11004: 0xC57C,
	11005: 0xC57D,
	11006: 0xC580,
	11007: 0xC584,
	11008: 0xC587,
	11009: 0xC58C,
	11010: 0xC58D,
	11011: 0xC58F,
	11012: 0xC591,
	11013: 0xC595,
	11014: 0xC597,
	11015: 0xC598,
	11016: 0xC59C,
	11017: 0xC5A0,
	11018: 0xC5A9,
	11019: 0xC5B4,
	11020: 0xC5B5,
	11021: 0xC5B8,
	11022: 0xC5B9,
	11023: 0xC5BB,
	11024: 0xC5BC,
	11025: 0xC5BD,
	11026: 0xC5BE,
	11027: 0xC5C4,
	11028: 0xC5C5,
	11029: 0xC5C6,
	11030: 0xC5C7,
	11031: 0xC5C8,
	11032: 0xC5C9,
	11033: 0xC5CA,
	11034: 0xC5CC,
	11035: 0xC5CE,
	11036: 0xD49E,
	11037: 0xD49F,
	11038: 0xD4A0,
	11039: 0xD4A1,
	11040: 0xD4A2,
	11041: 0xD4A3,
	11042: 0xD4A4,
	11043: 0xD4A5,
	11044: 0xD4A6,
	11045: 0xD4A7,
	11046: 0xD4A8,
	11047: 0xD4AA,
	11048: 0xD4AB,
	11049: 0xD4AC,
	11050: 0xD4AD,
	11051: 0xD4AE,
	11052: 0xD4AF,
	11053: 0xD4B0,
	11054: 0xD4B1,
	11055: 0xD4B2,
	11056: 0xD4B3,
	11057: 0xD4B4,
	11058: 0xD4B5,
	11059: 0xD4B6,
	11060: 0xD4B7,
	11061: 0xD4B8,
	11062: 0xD4B9,
	11063: 0xD4BA,
	11064: 0xD4BB,
	11065: 0xD4BC,
	11066: 0xD4BD,
	11067: 0xD4BE,
	11068: 0xD4BF,
	11069: 0xD4C0,
	11070: 0xD4C1,
	11071: 0xD4C2,
	11072: 0xD4C3,
	11073: 0xD4C4,
	11074: 0xD4C5,
	11075: 0xD4C6,
	11076: 0xD4C7,
	11077: 0xD4C8,
	11078: 0xD4C9,
	11079: 0xD4CA,
	11080: 0xD4CB,
	11081: 0xD4CD,
	11082: 0xD4CE,
	11083: 0xD4CF,
	11084: 0xD4D1,
	11085: 0xD4D2,
	11086: 0xD4D3,
	11087: 0xD4D5,
	11088: 0xD4D6,
	11089: 0xD4D7,
	11090: 0xD4D8,
	11091: 0xD4D9,
	11092: 0xD4DA,
	11093: 0xD4DB,
	11094: 0xD4DD,
	11095: 0xD4DE,
	11096: 0xD4E0,
	11097: 0xD4E1,
	11098: 0xD4E2,
	11099: 0xD4E3,
	11100: 0xD4E4,
	11101: 0xD4E5,
	11102: 0xD4E6,
	11103: 0xD4E7,
	11104: 0xD4E9,
	11105: 0xD4EA,
	11106: 0xD4EB,
	11107: 0xD4ED,
	11108: 0xD4EE,
	11109: 0xD4EF,
	11110: 0xD4F1,
	11111: 0xD4F2,
	11112: 0xD4F3,
	11113: 0xD4F4,
	11114: 0xD4F5,
	11115: 0xD4F6,
	11116: 0xD4F7,
	11117: 0xD4F9,
	11118: 0xD4FA,
	11119: 0xD4FC,
	11120: 0xC5D0,
	11121: 0xC5D1,
	11122: 0xC5D4,
	11123: 0xC5D8,
	11124: 0xC5E0,
	11125: 0xC5E1,
	11126: 0xC5E3,
	11127: 0xC5E5,
	11128: 0xC5EC,
	11129: 0xC5ED,
	11130: 0xC5EE,
	11131: 0xC5F0,
	11132: 0xC5F4,
	11133: 0xC5F6,
	11134: 0xC5F7,
	11135: 0xC5FC,
	11136: 0xC5FD,
	11137: 0xC5FE,
	11138: 0xC5FF,
	11139: 0xC600,
	11140: 0xC601,
	11141: 0xC605,
	11142: 0xC606,
	11143: 0xC607,
	11144: 0xC608,
	11145: 0xC60C,
	11146: 0xC610,
	11147: 0xC618,
	11148: 0xC619,
	11149: 0xC61B,
	11150: 0xC61C,
	11151: 0xC624,
	11152: 0xC625,
	11153: 0xC628,
	11154: 0xC62C,
	11155: 0xC62D,
	11156: 0xC62E,
	11157: 0xC630,
	11158: 0xC633,
	11159: 0xC634,
	11160: 0xC635,
	11161: 0xC637,
	11162: 0xC639,
	11163: 0xC63B,
	11164: 0xC640,
	11165: 0xC641,
	11166: 0xC644,
	11167: 0xC648,
	11168: 0xC650,
	11169: 0xC651,
	11170: 0xC653,
	11171: 0xC654,
	11172: 0xC655,
	11173: 0xC65C,
	11174: 0xC65D,
	11175: 0xC660,
	11176: 0xC66C,
	11177: 0xC66F,
	11178: 0xC671,
	11179: 0xC678,
	11180: 0xC679,
	11181: 0xC67C,
	11182: 0xC680,
	11183: 0xC688,
	11184: 0xC689,
	11185: 0xC68B,
	11186: 0xC68D,
	11187: 0xC694,
	11188: 0xC695,
	11189: 0xC698,
	11190: 0xC69C,
	11191: 0xC6A4,
	11192: 0xC6A5,
	11193: 0xC6A7,
	11194: 0xC6A9,
	11195: 0xC6B0,
	11196: 0xC6B1,
	11197: 0xC6B4,
	11198: 0xC6B8,
	11199: 0xC6B9,
	11200: 0xC6BA,
	11201: 0xC6C0,
	11202: 0xC6C1,
	11203: 0xC6C3,
	11204: 0xC6C5,
	11205: 0xC6CC,
	11206: 0xC6CD,
	11207: 0xC6D0,
	11208: 0xC6D4,
	11209: 0xC6DC,
	11210: 0xC6DD,
	11211: 0xC6E0,
	11212: 0xC6E1,
	11213: 0xC6E8,
	11214: 0xD4FE,
	11215: 0xD4FF,
	11216: 0xD500,
	11217: 0xD501,
	11218: 0xD502,
	11219: 0xD503,
	11220: 0xD505,
	11221: 0xD506,
	11222: 0xD507,
	11223: 0xD509,
	11224: 0xD50A,
	11225: 0xD50B,
	11226: 0xD50D,
	11227: 0xD50E,
	11228: 0xD50F,
	11229: 0xD510,
	11230: 0xD511,
	11231: 0xD512,
	11232: 0xD513,
	11233: 0xD516,
	11234: 0xD518,
	11235: 0xD519,
	11236: 0xD51A,
	11237: 0xD51B,
	11238: 0xD51C,
	11239: 0xD51D,
	11240: 0xD51E,
	11241: 0xD51F,
	11242: 0xD520,
	11243: 0xD521,
	11244: 0xD522,
	11245: 0xD523,
	11246: 0xD524,
	11247: 0xD525,
	11248: 0xD526,
	11249: 0xD527,
	11250: 0xD528,
	11251: 0xD529,
	11252: 0xD52A,
	11253: 0xD52B,
	11254: 0xD52C,
	11255: 0xD52D,
	11256: 0xD52E,
	11257: 0xD52F,
	11258: 0xD530,
	11259: 0xD531,
	11260: 0xD532,
	11261: 0xD533,
	11262: 0xD534,
	11263: 0xD535,
	11264: 0xD536,
	11265: 0xD537,
	11266: 0xD538,
	11267: 0xD539,
	11268: 0xD53A,
	11269: 0xD53B,
	11270: 0xD53E,
	11271: 0xD53F,
	11272: 0xD541,
	11273: 0xD542,
	11274: 0xD543,
	11275: 0xD545,
	11276: 0xD546,
	11277: 0xD547,
	11278: 0xD548,
	11279: 0xD549,
	11280: 0xD54A,
	11281: 0xD54B,
	11282: 0xD54E,
	11283: 0xD550,
	11284: 0xD552,
	11285: 0xD553,
	11286: 0xD554,
	11287: 0xD555,
	11288: 0xD556,
	11289: 0xD557,
	11290: 0xD55A,
	11291: 0xD55B,
	11292: 0xD55D,
	11293: 0xD55E,
	11294: 0xD55F,
	11295: 0xD561,
	11296: 0xD562,
	11297: 0xD563,
	11298: 0xC6E9,
	11299: 0xC6EC,
	11300: 0xC6F0,
	11301: 0xC6F8,
	11302: 0xC6F9,
	11303: 0xC6FD,
	11304: 0xC704,
	11305: 0xC705,
	11306: 0xC708,
	11307: 0xC70C,
	11308: 0xC714,
	11309: 0xC715,
	11310: 0xC717,
	11311: 0xC719,
	11312: 0xC720,
	11313: 0xC721,
	11314: 0xC724,
	11315: 0xC728,
	11316: 0xC730,
	11317: 0xC731,
	11318: 0xC733,
	11319: 0xC735,
	11320: 0xC737,
	11321: 0xC73C,
	11322: 0xC73D,
	11323: 0xC740,
	11324: 0xC744,
	11325: 0xC74A,
	11326: 0xC74C,
	11327: 0xC74D,
	11328: 0xC74F,
	11329: 0xC751,
	11330: 0xC752,
	11331: 0xC753,
	11332: 0xC754,
	11333: 0xC755,
	11334: 0xC756,
	11335: 0xC757,
	11336: 0xC758,
	11337: 0xC75C,
	11338: 0xC760,
	11339: 0xC768,
	11340: 0xC76B,
	11341: 0xC774,
	11342: 0xC775,
	11343: 0xC778,
	11344: 0xC77C,
	11345: 0xC77D,
	11346: 0xC77E,
	11347: 0xC783,
	11348: 0xC784,
	11349: 0xC785,
	11350: 0xC787,
	11351: 0xC788,
	11352: 0xC789,
	11353: 0xC78A,
	11354: 0xC78E,
	11355: 0xC790,
	11356: 0xC791,
	11357: 0xC794,
	11358: 0xC796,
	11359: 0xC797,
	11360: 0xC798,
	11361: 0xC79A,
	11362: 0xC7A0,
	11363: 0xC7A1,
	11364: 0xC7A3,
	11365: 0xC7A4,
	11366: 0xC7A5,
	11367: 0xC7A6,
	11368: 0xC7AC,
	11369: 0xC7AD,
	11370: 0xC7B0,
	11371: 0xC7B4,
	11372: 0xC7BC,
	11373: 0xC7BD,
	11374: 0xC7BF,
	11375: 0xC7C0,
	11376: 0xC7C1,
	11377: 0xC7C8,
	11378: 0xC7C9,
	11379: 0xC7CC,
	11380: 0xC7CE,
	11381: 0xC7D0,
	11382: 0xC7D8,
	11383: 0xC7DD,
	11384: 0xC7E4,
	11385: 0xC7E8,
	11386: 0xC7EC,
	11387: 0xC800,
	11388: 0xC801,
	11389: 0xC804,
	11390: 0xC808,
	11391: 0xC80A,
	11392: 0xD564,
	11393: 0xD566,
	11394: 0xD567,
	11395: 0xD56A,
	11396: 0xD56C,
	11397: 0xD56E,
	11398: 0xD56F,
	11399: 0xD570,
	11400: 0xD571,
	11401: 0xD572,
	11402: 0xD573,
	11403: 0xD576,
	11404: 0xD577,
	11405: 0xD579,
	11406: 0xD57A,
	11407: 0xD57B,
	11408: 0xD57D,
	11409: 0xD57E,
	11410: 0xD57F,
	11411: 0xD580,
	11412: 0xD581,
	11413: 0xD582,
	11414: 0xD583,
	11415: 0xD586,
	11416: 0xD58A,
	11417: 0xD58B,
	11418: 0xD58C,
	11419: 0xD58D,
	11420: 0xD58E,
	11421: 0xD58F,
	11422: 0xD591,
	11423: 0xD592,
	11424: 0xD593,
	11425: 0xD594,
	11426: 0xD595,
	11427: 0xD596,
	11428: 0xD597,
	11429: 0xD598,
	11430: 0xD599,
	11431: 0xD59A,
	11432: 0xD59B,
	11433: 0xD59C,
	11434: 0xD59D,
	11435: 0xD59E,
	11436: 0xD59F,
	11437: 0xD5A0,
	11438: 0xD5A1,
	11439: 0xD5A2,
	11440: 0xD5A3,
	11441: 0xD5A4,
	11442: 0xD5A6,
	11443: 0xD5A7,
	11444: 0xD5A8,
	11445: 0xD5A9,
	11446: 0xD5AA,
	11447: 0xD5AB,
	11448: 0xD5AC,
	11449: 0xD5AD,
	11450: 0xD5AE,
	11451: 0xD5AF,
	11452: 0xD5B0,
	11453: 0xD5B1,
	11454: 0xD5B2,
	11455: 0xD5B3,
	11456: 0xD5B4,
	11457: 0xD5B5,
	11458: 0xD5B6,
	11459: 0xD5B7,
	11460: 0xD5B8,
	11461: 0xD5B9,
	11462: 0xD5BA,
	11463: 0xD5BB,
	11464: 0xD5BC,
	11465: 0xD5BD,
	11466: 0xD5BE,
	11467: 0xD5BF,
	11468: 0xD5C0,
	11469: 0xD5C1,
	11470: 0xD5C2,
	11471: 0xD5C3,
	11472: 0xD5C4,
	11473: 0xD5C5,
	11474: 0xD5C6,
	11475: 0xD5C7,
	11476: 0xC810,
	11477: 0xC811,
	11478: 0xC813,
	11479: 0xC815,
	11480: 0xC816,
	11481: 0xC81C,
	11482: 0xC81D,
	11483: 0xC820,
	11484: 0xC824,
	11485: 0xC82C,
	11486: 0xC82D,
	11487: 0xC82F,
	11488: 0xC831,
	11489: 0xC838,
	11490: 0xC83C,
	11491: 0xC840,
	11492: 0xC848,
	11493: 0xC849,
	11494: 0xC84C,
	11495: 0xC84D,
	11496: 0xC854,
	11497: 0xC870,
	11498: 0xC871,
	11499: 0xC874,
	11500: 0xC878,
	11501: 0xC87A,
	11502: 0xC880,
	11503: 0xC881,
	11504: 0xC883,
	11505: 0xC885,
	11506: 0xC886,
	11507: 0xC887,
	11508: 0xC88B,
	11509: 0xC88C,
	11510: 0xC88D,
	11511: 0xC894,
	11512: 0xC89D,
	11513: 0xC89F,
	11514: 0xC8A1,
	11515: 0xC8A8,
	11516: 0xC8BC,
	11517: 0xC8BD,
	11518: 0xC8C4,
	11519: 0xC8C8,
	11520: 0xC8CC,
	11521: 0xC8D4,
	11522: 0xC8D5,
	11523: 0xC8D7,
	11524: 0xC8D9,
	11525: 0xC8E0,
	11526: 0xC8E1,
	11527: 0xC8E4,
	11528: 0xC8F5,
	11529: 0xC8FC,
	11530: 0xC8FD,
	11531: 0xC900,
	11532: 0xC904,
	11533: 0xC905,
	11534: 0xC906,
	11535: 0xC90C,
	11536: 0xC90D,
	11537: 0xC90F,
	11538: 0xC911,
	11539: 0xC918,
	11540: 0xC92C,
	11541: 0xC934,
	11542: 0xC950,
	11543: 0xC951,
	11544: 0xC954,
	11545: 0xC958,
	11546: 0xC960,
	11547: 0xC961,
	11548: 0xC963,
	11549: 0xC96C,
	11550: 0xC970,
	11551: 0xC974,
	11552: 0xC97C,
	11553: 0xC988,
	11554: 0xC989,
	11555: 0xC98C,
	11556: 0xC990,
	11557: 0xC998,
	11558: 0xC999,
	11559: 0xC99B,
	11560: 0xC99D,
	11561: 0xC9C0,
	11562: 0xC9C1,
	11563: 0xC9C4,
	11564: 0xC9C7,
	11565: 0xC9C8,
	11566: 0xC9CA,
	11567: 0xC9D0,
	11568: 0xC9D1,
	11569: 0xC9D3,
	11570: 0xD5CA,
	11571: 0xD5CB,
	11572: 0xD5CD,
	11573: 0xD5CE,
	11574: 0xD5CF,
	11575: 0xD5D1,
	11576: 0xD5D3,
	11577: 0xD5D4,
	11578: 0xD5D5,
	11579: 0xD5D6,
	11580: 0xD5D7,
	11581: 0xD5DA,
	11582: 0xD5DC,
	11583: 0xD5DE,
	11584: 0xD5DF,
	11585: 0xD5E0,
	11586: 0xD5E1,
	11587: 0xD5E2,
	11588: 0xD5E3,
	11589: 0xD5E6,
	11590: 0xD5E7,
	11591: 0xD5E9,
	11592: 0xD5EA,
	11593: 0xD5EB,
	11594: 0xD5ED,
	11595: 0xD5EE,
	11596: 0xD5EF,
	11597: 0xD5F0,
	11598: 0xD5F1,
	11599: 0xD5F2,
	11600: 0xD5F3,
	11601: 0xD5F6,
	11602: 0xD5F8,
	11603: 0xD5FA,
	11604: 0xD5FB,
	11605: 0xD5FC,
	11606: 0xD5FD,
	11607: 0xD5FE,
	11608: 0xD5FF,
	11609: 0xD602,
	11610: 0xD603,
	11611: 0xD605,
	11612: 0xD606,
	11613: 0xD607,
	11614: 0xD609,
	11615: 0xD60A,
	11616: 0xD60B,
	11617: 0xD60C,
	11618: 0xD60D,
	11619: 0xD60E,
	11620: 0xD60F,
	11621: 0xD612,
	11622: 0xD616,
	11623: 0xD617,
	11624: 0xD618,
	11625: 0xD619,
	11626: 0xD61A,
	11627: 0xD61B,
	11628: 0xD61D,
	11629: 0xD61E,
	11630: 0xD61F,
	11631: 0xD621,
	11632: 0xD622,
	11633: 0xD623,
	11634: 0xD625,
	11635: 0xD626,
	11636: 0xD627,
	11637: 0xD628,
	11638: 0xD629,
	11639: 0xD62A,
	11640: 0xD62B,
	11641: 0xD62C,
	11642: 0xD62E,
	11643: 0xD62F,
	11644: 0xD630,
	11645: 0xD631,
	11646: 0xD632,
	11647: 0xD633,
	11648: 0xD634,
	11649: 0xD635,
	11650: 0xD636,
	11651: 0xD637,
	11652: 0xD63A,
	11653: 0xD63B,
	11654: 0xC9D5,
	11655: 0xC9D6,
	11656: 0xC9D9,
	11657: 0xC9DA,
	11658: 0xC9DC,
	11659: 0xC9DD,
	11660: 0xC9E0,
	11661: 0xC9E2,
	11662: 0xC9E4,
	11663: 0xC9E7,
	11664: 0xC9EC,
	11665: 0xC9ED,
	11666: 0xC9EF,
	11667: 0xC9F0,
	11668: 0xC9F1,
	11669: 0xC9F8,
	11670: 0xC9F9,
	11671: 0xC9FC,
	11672: 0xCA00,
	11673: 0xCA08,
	11674: 0xCA09,
	11675: 0xCA0B,
	11676: 0xCA0C,
	11677: 0xCA0D,
	11678: 0xCA14,
	11679: 0xCA18,
	11680: 0xCA29,
	11681: 0xCA4C,
	11682: 0xCA4D,
	11683: 0xCA50,
	11684: 0xCA54,
	11685: 0xCA5C,
	11686: 0xCA5D,
	11687: 0xCA5F,
	11688: 0xCA60,
	11689: 0xCA61,
	11690: 0xCA68,
	11691: 0xCA7D,
	11692: 0xCA84,
	11693: 0xCA98,
	11694: 0xCABC,
	11695: 0xCABD,
	11696: 0xCAC0,
	11697: 0xCAC4,
	11698: 0xCACC,
	11699: 0xCACD,
	11700: 0xCACF,
	11701: 0xCAD1,
	11702: 0xCAD3,
	11703: 0xCAD8,
	11704: 0xCAD9,
	11705: 0xCAE0,
	11706: 0xCAEC,
	11707: 0xCAF4,
	11708: 0xCB08,
	11709: 0xCB10,
	11710: 0xCB14,
	11711: 0xCB18,
	11712: 0xCB20,
	11713: 0xCB21,
	11714: 0xCB41,
	11715: 0xCB48,
	11716: 0xCB49,
	11717: 0xCB4C,
	11718: 0xCB50,
	11719: 0xCB58,
	11720: 0xCB59,
	11721: 0xCB5D,
	11722: 0xCB64,
	11723: 0xCB78,
	11724: 0xCB79,
	11725: 0xCB9C,
	11726: 0xCBB8,
	11727: 0xCBD4,
	11728: 0xCBE4,
	11729: 0xCBE7,
	11730: 0xCBE9,
	11731: 0xCC0C,
	11732: 0xCC0D,
	11733: 0xCC10,
	11734: 0xCC14,
	11735: 0xCC1C,
	11736: 0xCC1D,
	11737: 0xCC21,
	11738: 0xCC22,
	11739: 0xCC27,
	11740: 0xCC28,
	11741: 0xCC29,
	11742: 0xCC2C,
	11743: 0xCC2E,
	11744: 0xCC30,
	11745: 0xCC38,
	11746: 0xCC39,
	11747: 0xCC3B,
	11748: 0xD63D,
	11749: 0xD63E,
	11750: 0xD63F,
	11751: 0xD641,
	11752: 0xD642,
	11753: 0xD643,
	11754: 0xD644,
	11755: 0xD646,
	11756: 0xD647,
	11757: 0xD64A,
	11758: 0xD64C,
	11759: 0xD64E,
	11760: 0xD64F,
	11761: 0xD650,
	11762: 0xD652,
	11763: 0xD653,
	11764: 0xD656,
	11765: 0xD657,
	11766: 0xD659,
	11767: 0xD65A,
	11768: 0xD65B,
	11769: 0xD65D,
	11770: 0xD65E,
	11771: 0xD65F,
	11772: 0xD660,
	11773: 0xD661,
	11774: 0xD662,
	11775: 0xD663,
	11776: 0xD664,
	11777: 0xD665,
	11778: 0xD666,
	11779: 0xD668,
	11780: 0xD66A,
	11781: 0xD66B,
	11782: 0xD66C,
	11783: 0xD66D,
	11784: 0xD66E,
	11785: 0xD66F,
	11786: 0xD672,
	11787: 0xD673,
	11788: 0xD675,
	11789: 0xD676,
	11790: 0xD677,
	11791: 0xD678,
	11792: 0xD679,
	11793: 0xD67A,
	11794: 0xD67B,
	11795: 0xD67C,
	11796: 0xD67D,
	11797: 0xD67E,
	11798: 0xD67F,
	11799: 0xD680,
	11800: 0xD681,
	11801: 0xD682,
	11802: 0xD684,
	11803: 0xD686,
	11804: 0xD687,
	11805: 0xD688,
	11806: 0xD689,
	11807: 0xD68A,
	11808: 0xD68B,
	11809: 0xD68E,
	11810: 0xD68F,
	11811: 0xD691,
	11812: 0xD692,
	11813: 0xD693,
	11814: 0xD695,
	11815: 0xD696,
	11816: 0xD697,
	11817: 0xD698,
	11818: 0xD699,
	11819: 0xD69A,
	11820: 0xD69B,
	11821: 0xD69C,
	11822: 0xD69E,
	11823: 0xD6A0,
	11824: 0xD6A2,
	11825: 0xD6A3,
	11826: 0xD6A4,
	11827: 0xD6A5,
	11828: 0xD6A6,
	11829: 0xD6A7,
	11830: 0xD6A9,
	11831: 0xD6AA,
	11832: 0xCC3C,
	11833: 0xCC3D,
	11834: 0xCC3E,
	11835: 0xCC44,
	11836: 0xCC45,
	11837: 0xCC48,
	11838: 0xCC4C,
	11839: 0xCC54,
	11840: 0xCC55,
	11841: 0xCC57,
	11842: 0xCC58,
	11843: 0xCC59,
	11844: 0xCC60,
	11845: 0xCC64,
	11846: 0xCC66,
	11847: 0xCC68,
	11848: 0xCC70,
	11849: 0xCC75,
	11850: 0xCC98,
	11851: 0xCC99,
	11852: 0xCC9C,
	11853: 0xCCA0,
	11854: 0xCCA8,
	11855: 0xCCA9,
	11856: 0xCCAB,
	11857: 0xCCAC,
	11858: 0xCCAD,
	11859: 0xCCB4,
	11860: 0xCCB5,
	11861: 0xCCB8,
	11862: 0xCCBC,
	11863: 0xCCC4,
	11864: 0xCCC5,
	11865: 0xCCC7,
	11866: 0xCCC9,
	11867: 0xCCD0,
	11868: 0xCCD4,
	11869: 0xCCE4,
	11870: 0xCCEC,
	11871: 0xCCF0,
	11872: 0xCD01,
	11873: 0xCD08,
	11874: 0xCD09,
	11875: 0xCD0C,
	11876: 0xCD10,
	11877: 0xCD18,
	11878: 0xCD19,
	11879: 0xCD1B,
	11880: 0xCD1D,
	11881: 0xCD24,
	11882: 0xCD28,
	11883: 0xCD2C,
	11884: 0xCD39,
	11885: 0xCD5C,
	11886: 0xCD60,
	11887: 0xCD64,
	11888: 0xCD6C,
	11889: 0xCD6D,
	11890: 0xCD6F,
	11891: 0xCD71,
	11892: 0xCD78,
	11893: 0xCD88,
	11894: 0xCD94,
	11895: 0xCD95,
	11896: 0xCD98,
	11897: 0xCD9C,
	11898: 0xCDA4,
	11899: 0xCDA5,
	11900: 0xCDA7,
	11901: 0xCDA9,
	11902: 0xCDB0,
	11903: 0xCDC4,
	11904: 0xCDCC,
	11905: 0xCDD0,
	11906: 0xCDE8,
	11907: 0xCDEC,
	11908: 0xCDF0,
	11909: 0xCDF8,
	11910: 0xCDF9,
	11911: 0xCDFB,
	11912: 0xCDFD,
	11913: 0xCE04,
	11914: 0xCE08,
	11915: 0xCE0C,
	11916: 0xCE14,
	11917: 0xCE19,
	11918: 0xCE20,
	11919: 0xCE21,
	11920: 0xCE24,
	11921: 0xCE28,
	11922: 0xCE30,
	11923: 0xCE31,
	11924: 0xCE33,
	11925: 0xCE35,
	11926: 0xD6AB,
	11927: 0xD6AD,
	11928: 0xD6AE,
	11929: 0xD6AF,
	11930: 0xD6B1,
	11931: 0xD6B2,
	11932: 0xD6B3,
	11933: 0xD6B4,
	11934: 0xD6B5,
	11935: 0xD6B6,
	11936: 0xD6B7,
	11937: 0xD6B8,
	11938: 0xD6BA,
	11939: 0xD6BC,
	11940: 0xD6BD,
	11941: 0xD6BE,
	11942: 0xD6BF,
	11943: 0xD6C0,
	11944: 0xD6C1,
	11945: 0xD6C2,
	11946: 0xD6C3,
	11947: 0xD6C6,
	11948: 0xD6C7,
	11949: 0xD6C9,
	11950: 0xD6CA,
	11951: 0xD6CB,
	11952: 0xD6CD,
	11953: 0xD6CE,
	11954: 0xD6CF,
	11955: 0xD6D0,
	11956: 0xD6D2,
	11957: 0xD6D3,
	11958: 0xD6D5,
	11959: 0xD6D6,
	11960: 0xD6D8,
	11961: 0xD6DA,
	11962: 0xD6DB,
	11963: 0xD6DC,
	11964: 0xD6DD,
	11965: 0xD6DE,
	11966: 0xD6DF,
	11967: 0xD6E1,
	11968: 0xD6E2,
	11969: 0xD6E3,
	11970: 0xD6E5,
	11971: 0xD6E6,
	11972: 0xD6E7,
	11973: 0xD6E9,
	11974: 0xD6EA,
	11975: 0xD6EB,
	11976: 0xD6EC,
	11977: 0xD6ED,
	11978: 0xD6EE,
	11979: 0xD6EF,
	11980: 0xD6F1,
	11981: 0xD6F2,
	11982: 0xD6F3,
	11983: 0xD6F4,
	11984: 0xD6F6,
	11985: 0xD6F7,
	11986: 0xD6F8,
	11987: 0xD6F9,
	11988: 0xD6FA,
	11989: 0xD6FB,
	11990: 0xD6FE,
	11991: 0xD6FF,
	11992: 0xD701,
	11993: 0xD702,
	11994: 0xD703,
	11995: 0xD705,
	11996: 0xD706,
	11997: 0xD707,
	11998: 0xD708,
	11999: 0xD709,
	12000: 0xD70A,
	12001: 0xD70B,
	12002: 0xD70C,
	12003: 0xD70D,
	12004: 0xD70E,
	12005: 0xD70F,
	12006: 0xD710,
	12007: 0xD712,
	12008: 0xD713,
	12009: 0xD714,
	12010: 0xCE58,
	12011: 0xCE59,
	12012: 0xCE5C,
	12013: 0xCE5F,
	12014: 0xCE60,
	12015: 0xCE61,
	12016: 0xCE68,
	12017: 0xCE69,
	12018: 0xCE6B,
	12019: 0xCE6D,
	12020: 0xCE74,
	12021: 0xCE75,
	12022: 0xCE78,
	12023: 0xCE7C,
	12024: 0xCE84,
	12025: 0xCE85,
	12026: 0xCE87,
	12027: 0xCE89,
	12028: 0xCE90,
	12029: 0xCE91,
	12030: 0xCE94,
	12031: 0xCE98,
	12032: 0xCEA0,
	12033: 0xCEA1,
	12034: 0xCEA3,
	12035: 0xCEA4,
	12036: 0xCEA5,
	12037: 0xCEAC,
	12038: 0xCEAD,
	12039: 0xCEC1,
	12040: 0xCEE4,
	12041: 0xCEE5,
	12042: 0xCEE8,
	12043: 0xCEEB,
	12044: 0xCEEC,
	12045: 0xCEF4,
	12046: 0xCEF5,
	12047: 0xCEF7,
	12048: 0xCEF8,
	12049: 0xCEF9,
	12050: 0xCF00,
	12051: 0xCF01,
	12052: 0xCF04,
	12053: 0xCF08,
	12054: 0xCF10,
	12055: 0xCF11,
	12056: 0xCF13,
	12057: 0xCF15,
	12058: 0xCF1C,
	12059: 0xCF20,
	12060: 0xCF24,
	12061: 0xCF2C,
	12062: 0xCF2D,
	12063: 0xCF2F,
	12064: 0xCF30,
	12065: 0xCF31,
	12066: 0xCF38,
	12067: 0xCF54,
	12068: 0xCF55,
	12069: 0xCF58,
	12070: 0xCF5C,
	12071: 0xCF64,
	12072: 0xCF65,
	12073: 0xCF67,
	12074: 0xCF69,
	12075: 0xCF70,
	12076: 0xCF71,
	12077: 0xCF74,
	12078: 0xCF78,
	12079: 0xCF80,
	12080: 0xCF85,
	12081: 0xCF8C,
	12082: 0xCFA1,
	12083: 0xCFA8,
	12084: 0xCFB0,
	12085: 0xCFC4,
	12086: 0xCFE0,
	12087: 0xCFE1,
	12088: 0xCFE4,
	12089: 0xCFE8,
	12090: 0xCFF0,
	12091: 0xCFF1,
	12092: 0xCFF3,
	12093: 0xCFF5,
	12094: 0xCFFC,
	12095: 0xD000,
	12096: 0xD004,
	12097: 0xD011,
	12098: 0xD018,
	12099: 0xD02D,
	12100: 0xD034,
	12101: 0xD035,
	12102: 0xD038,
	12103: 0xD03C,
	12104: 0xD715,
	12105: 0xD716,
	12106: 0xD717,
	12107: 0xD71A,
	12108: 0xD71B,
	12109: 0xD71D,
	12110: 0xD71E,
	12111: 0xD71F,
	12112: 0xD721,
	12113: 0xD722,
	12114: 0xD723,
	12115: 0xD724,
	12116: 0xD725,
	12117: 0xD726,
	12118: 0xD727,
	12119: 0xD72A,
	12120: 0xD72C,
	12121: 0xD72E,
	12122: 0xD72F,
	12123: 0xD730,
	12124: 0xD731,
	12125: 0xD732,
	12126: 0xD733,
	12127: 0xD736,
	12128: 0xD737,
	12129: 0xD739,
	12130: 0xD73A,
	12131: 0xD73B,
	12132: 0xD73D,
	12133: 0xD73E,
	12134: 0xD73F,
	12135: 0xD740,
	12136: 0xD741,
	12137: 0xD742,
	12138: 0xD743,
	12139: 0xD745,
	12140: 0xD746,
	12141: 0xD748,
	12142: 0xD74A,
	12143: 0xD74B,
	12144: 0xD74C,
	12145: 0xD74D,
	12146: 0xD74E,
	12147: 0xD74F,
	12148: 0xD752,
	12149: 0xD753,
	12150: 0xD755,
	12151: 0xD75A,
	12152: 0xD75B,
	12153: 0xD75C,
	12154: 0xD75D,
	12155: 0xD75E,
	12156: 0xD75F,
	12157: 0xD762,
	12158: 0xD764,
	12159: 0xD766,
	12160: 0xD767,
	12161: 0xD768,
	12162: 0xD76A,
	12163: 0xD76B,
	12164: 0xD76D,
	12165: 0xD76E,
	12166: 0xD76F,
	12167: 0xD771,
	12168: 0xD772,
	12169: 0xD773,
	12170: 0xD775,
	12171: 0xD776,
	12172: 0xD777,
	12173: 0xD778,
	12174: 0xD779,
	12175: 0xD77A,
	12176: 0xD77B,
	12177: 0xD77E,
	12178: 0xD77F,
	12179: 0xD780,
	12180: 0xD782,
	12181: 0xD783,
	12182: 0xD784,
	12183: 0xD785,
	12184: 0xD786,
	12185: 0xD787,
	12186: 0xD78A,
	12187: 0xD78B,
	12188: 0xD044,
	12189: 0xD045,
	12190: 0xD047,
	12191: 0xD049,
	12192: 0xD050,
	12193: 0xD054,
	12194: 0xD058,
	12195: 0xD060,
	12196: 0xD06C,
	12197: 0xD06D,
	12198: 0xD070,
	12199: 0xD074,
	12200: 0xD07C,
	12201: 0xD07D,
	12202: 0xD081,
	12203: 0xD0A4,
	12204: 0xD0A5,
	12205: 0xD0A8,
	12206: 0xD0AC,
	12207: 0xD0B4,
	12208: 0xD0B5,
	12209: 0xD0B7,
	12210: 0xD0B9,
	12211: 0xD0C0,
	12212: 0xD0C1,
	12213: 0xD0C4,
	12214: 0xD0C8,
	12215: 0xD0C9,
	12216: 0xD0D0,
	12217: 0xD0D1,
	12218: 0xD0D3,
	12219: 0xD0D4,
	12220: 0xD0D5,
	12221: 0xD0DC,
	12222: 0xD0DD,
	12223: 0xD0E0,
	12224: 0xD0E4,
	12225: 0xD0EC,
	12226: 0xD0ED,
	12227: 0xD0EF,
	12228: 0xD0F0,
	12229: 0xD0F1,
	12230: 0xD0F8,
	12231: 0xD10D,
	12232: 0xD130,
	12233: 0xD131,
	12234: 0xD134,
	12235: 0xD138,
	12236: 0xD13A,
	12237: 0xD140,
	12238: 0xD141,
	12239: 0xD143,
	12240: 0xD144,
	12241: 0xD145,
	12242: 0xD14C,
	12243: 0xD14D,
	12244: 0xD150,
	12245: 0xD154,
	12246: 0xD15C,
	12247: 0xD15D,
	12248: 0xD15F,
	12249: 0xD161,
	12250: 0xD168,
	12251: 0xD16C,
	12252: 0xD17C,
	12253: 0xD184,
	12254: 0xD188,
	12255: 0xD1A0,
	12256: 0xD1A1,
	12257: 0xD1A4,
	12258: 0xD1A8,
	12259: 0xD1B0,
	12260: 0xD1B1,
	12261: 0xD1B3,
	12262: 0xD1B5,
	12263: 0xD1BA,
	12264: 0xD1BC,
	12265: 0xD1C0,
	12266: 0xD1D8,
	12267: 0xD1F4,
	12268: 0xD1F8,
	12269: 0xD207,
	12270: 0xD209,
	12271: 0xD210,
	12272: 0xD22C,
	12273: 0xD22D,
	12274: 0xD230,
	12275: 0xD234,
	12276: 0xD23C,
	12277: 0xD23D,
	12278: 0xD23F,
	12279: 0xD241,
	12280: 0xD248,
	12281: 0xD25C,
	12282: 0xD78D,
	12283: 0xD78E,
	12284: 0xD78F,
	12285: 0xD791,
	12286: 0xD792,
	12287: 0xD793,
	12288: 0xD794,
	12289: 0xD795,
	12290: 0xD796,
	12291: 0xD797,
	12292: 0xD79A,
	12293: 0xD79C,
	12294: 0xD79E,
	12295: 0xD79F,
	12296: 0xD7A0,
	12297: 0xD7A1,
	12298: 0xD7A2,
	12299: 0xD7A3,
	12366: 0xD264,
	12367: 0xD280,
	12368: 0xD281,
	12369: 0xD284,
	12370: 0xD288,
	12371: 0xD290,
	12372: 0xD291,
	12373: 0xD295,
	12374: 0xD29C,
	12375: 0xD2A0,
	12376: 0xD2A4,
	12377: 0xD2AC,
	12378: 0xD2B1,
	12379: 0xD2B8,
	12380: 0xD2B9,
	12381: 0xD2BC,
	12382: 0xD2BF,
	12383: 0xD2C0,
	12384: 0xD2C2,
	12385: 0xD2C8,
	12386: 0xD2C9,
	12387: 0xD2CB,
	12388: 0xD2D4,
	12389: 0xD2D8,
	12390: 0xD2DC,
	12391: 0xD2E4,
	12392: 0xD2E5,
	12393: 0xD2F0,
	12394: 0xD2F1,
	12395: 0xD2F4,
	12396: 0xD2F8,
	12397: 0xD300,
	12398: 0xD301,
	12399: 0xD303,
	12400: 0xD305,
	12401: 0xD30C,
	12402: 0xD30D,
	12403: 0xD30E,
	12404: 0xD310,
	12405: 0xD314,
	12406: 0xD316,
	12407: 0xD31C,
	12408: 0xD31D,
	12409: 0xD31F,
	12410: 0xD320,
	12411: 0xD321,
	12412: 0xD325,
	12413: 0xD328,
	12414: 0xD329,
	12415: 0xD32C,
	12416: 0xD330,
	12417: 0xD338,
	12418: 0xD339,
	12419: 0xD33B,
	12420: 0xD33C,
	12421: 0xD33D,
	12422: 0xD344,
	12423: 0xD345,
	12424: 0xD37C,
	12425: 0xD37D,
	12426: 0xD380,
	12427: 0xD384,
	12428: 0xD38C,
	12429: 0xD38D,
	12430: 0xD38F,
	12431: 0xD390,
	12432: 0xD391,
	12433: 0xD398,
	12434: 0xD399,
	12435: 0xD39C,
	12436: 0xD3A0,
	12437: 0xD3A8,
	12438: 0xD3A9,
	12439: 0xD3AB,
	12440: 0xD3AD,
	12441: 0xD3B4,
	12442: 0xD3B8,
	12443: 0xD3BC,
	12444: 0xD3C4,
	12445: 0xD3C5,
	12446: 0xD3C8,
	12447: 0xD3C9,
	12448: 0xD3D0,
	12449: 0xD3D8,
	12450: 0xD3E1,
	12451: 0xD3E3,
	12452: 0xD3EC,
	12453: 0xD3ED,
	12454: 0xD3F0,
	12455: 0xD3F4,
	12456: 0xD3FC,
	12457: 0xD3FD,
	12458: 0xD3FF,
	12459: 0xD401,
	12460: 0xD408,
	12461: 0xD41D,
	12462: 0xD440,
	12463: 0xD444,
	12464: 0xD45C,
	12465: 0xD460,
	12466: 0xD464,
	12467: 0xD46D,
	12468: 0xD46F,
	12469: 0xD478,
	12470: 0xD479,
	12471: 0xD47C,
	12472: 0xD47F,
	12473: 0xD480,
	12474: 0xD482,
	12475: 0xD488,
	12476: 0xD489,
	12477: 0xD48B,
	12478: 0xD48D,
	12479: 0xD494,
	12480: 0xD4A9,
	12481: 0xD4CC,
	12482: 0xD4D0,
	12483: 0xD4D4,
	12484: 0xD4DC,
	12485: 0xD4DF,
	12486: 0xD4E8,
	12487: 0xD4EC,
	12488: 0xD4F0,
	12489: 0xD4F8,
	12490: 0xD4FB,
	12491: 0xD4FD,
	12492: 0xD504,
	12493: 0xD508,
	12494: 0xD50C,
	12495: 0xD514,
	12496: 0xD515,
	12497: 0xD517,
	12498: 0xD53C,
	12499: 0xD53D,
	12500: 0xD540,
	12501: 0xD544,
	12502: 0xD54C,
	12503: 0xD54D,
	12504: 0xD54F,
	12505: 0xD551,
	12506: 0xD558,
	12507: 0xD559,
	12508: 0xD55C,
	12509: 0xD560,
	12510: 0xD565,
	12511: 0xD568,
	12512: 0xD569,
	12513: 0xD56B,
	12514: 0xD56D,
	12515: 0xD574,
	12516: 0xD575,
	12517: 0xD578,
	12518: 0xD57C,
	12519: 0xD584,
	12520: 0xD585,
	12521: 0xD587,
	12522: 0xD588,
	12523: 0xD589,
	12524: 0xD590,
	12525: 0xD5A5,
	12526: 0xD5C8,
	12527: 0xD5C9,
	12528: 0xD5CC,
	12529: 0xD5D0,
	12530: 0xD5D2,
	12531: 0xD5D8,
	12532: 0xD5D9,
	12533: 0xD5DB,
	12534: 0xD5DD,
	12535: 0xD5E4,
	12536: 0xD5E5,
	12537: 0xD5E8,
	12538: 0xD5EC,
	12539: 0xD5F4,
	12540: 0xD5F5,
	12541: 0xD5F7,
	12542: 0xD5F9,
	12543: 0xD600,
	12544: 0xD601,
	12545: 0xD604,
	12546: 0xD608,
	12547: 0xD610,
	12548: 0xD611,
	12549: 0xD613,
	12550: 0xD614,
	12551: 0xD615,
	12552: 0xD61C,
	12553: 0xD620,
	12554: 0xD624,
	12555: 0xD62D,
	12556: 0xD638,
	12557: 0xD639,
	12558: 0xD63C,
	12559: 0xD640,
	12560: 0xD645,
	12561: 0xD648,
	12562: 0xD649,
	12563: 0xD64B,
	12564: 0xD64D,
	12565: 0xD651,
	12566: 0xD654,
	12567: 0xD655,
	12568: 0xD658,
	12569: 0xD65C,
	12570: 0xD667,
	12571: 0xD669,
	12572: 0xD670,
	12573: 0xD671,
	12574: 0xD674,
	12575: 0xD683,
	12576: 0xD685,
	12577: 0xD68C,
	12578: 0xD68D,
	12579: 0xD690,
	12580: 0xD694,
	12581: 0xD69D,
	12582: 0xD69F,
	12583: 0xD6A1,
	12584: 0xD6A8,
	12585: 0xD6AC,
	12586: 0xD6B0,
	12587: 0xD6B9,
	12588: 0xD6BB,
	12589: 0xD6C4,
	12590: 0xD6C5,
	12591: 0xD6C8,
	12592: 0xD6CC,
	12593: 0xD6D1,
	12594: 0xD6D4,
	12595: 0xD6D7,
	12596: 0xD6D9,
	12597: 0xD6E0,
	12598: 0xD6E4,
	12599: 0xD6E8,
	12600: 0xD6F0,
	12601: 0xD6F5,
	12602: 0xD6FC,
	12603: 0xD6FD,
	12604: 0xD700,
	12605: 0xD704,
	12606: 0xD711,
	12607: 0xD718,
	12608: 0xD719,
	12609: 0xD71C,
	12610: 0xD720,
	12611: 0xD728,
	12612: 0xD729,
	12613: 0xD72B,
	12614: 0xD72D,
	12615: 0xD734,
	12616: 0xD735,
	12617: 0xD738,
	12618: 0xD73C,
	12619: 0xD744,
	12620: 0xD747,
	12621: 0xD749,
	12622: 0xD750,
	12623: 0xD751,
	12624: 0xD754,
	12625: 0xD756,
	12626: 0xD757,
	12627: 0xD758,
	12628: 0xD759,
	12629: 0xD760,
	12630: 0xD761,
	12631: 0xD763,
	12632: 0xD765,
	12633: 0xD769,
	12634: 0xD76C,
	12635: 0xD770,
	12636: 0xD774,
	12637: 0xD77C,
	12638: 0xD77D,
	12639: 0xD781,
	12640: 0xD788,
	12641: 0xD789,
	12642: 0xD78C,
	12643: 0xD790,
	12644: 0xD798,
	12645: 0xD799,
	12646: 0xD79B,
	12647: 0xD79D,
	12742: 0x4F3D,
	12743: 0x4F73,
	12744: 0x5047,
	12745: 0x50F9,
	12746: 0x52A0,
	12747: 0x53EF,
	12748: 0x5475,
	12749: 0x54E5,
	12750: 0x5609,
	12751: 0x5AC1,
	12752: 0x5BB6,
	12753: 0x6687,
	12754: 0x67B6,
	12755: 0x67B7,
	12756: 0x67EF,
	12757: 0x6B4C,
	12758: 0x73C2,
	12759: 0x75C2,
	12760: 0x7A3C,
	12761: 0x82DB,
	12762: 0x8304,
	12763: 0x8857,
	12764: 0x8888,
	12765: 0x8A36,
	12766: 0x8CC8,
	12767: 0x8DCF,
	12768: 0x8EFB,
	12769: 0x8FE6,
	12770: 0x99D5,
	12771: 0x523B,
	12772: 0x5374,
	12773: 0x5404,
	12774: 0x606A,
	12775: 0x6164,
	12776: 0x6BBC,
	12777: 0x73CF,
	12778: 0x811A,
	12779: 0x89BA,
	12780: 0x89D2,
	12781: 0x95A3,
	12782: 0x4F83,
	12783: 0x520A,
	12784: 0x58BE,
	12785: 0x5978,
	12786: 0x59E6,
	12787: 0x5E72,
	12788: 0x5E79,
	12789: 0x61C7,
	12790: 0x63C0,
	12791: 0x6746,
	12792: 0x67EC,
	12793: 0x687F,
	12794: 0x6F97,
	12795: 0x764E,
	12796: 0x770B,
	12797: 0x78F5,
	12798: 0x7A08,
	12799: 0x7AFF,
	12800: 0x7C21,
	12801: 0x809D,
	12802: 0x826E,
	12803: 0x8271,
	12804: 0x8AEB,
	12805: 0x9593,
	12806: 0x4E6B,
	12807: 0x559D,
	12808: 0x66F7,
	12809: 0x6E34,
	12810: 0x78A3,
	12811: 0x7AED,
	12812: 0x845B,
	12813: 0x8910,
	12814: 0x874E,
	12815: 0x97A8,
	12816: 0x52D8,
	12817: 0x574E,
	12818: 0x582A,
	12819: 0x5D4C,
	12820: 0x611F,
	12821: 0x61BE,
	12822: 0x6221,
	12823: 0x6562,
	12824: 0x67D1,
	12825: 0x6A44,
	12826: 0x6E1B,
	12827: 0x7518,
	12828: 0x75B3,
	12829: 0x76E3,
	12830: 0x77B0,
	12831: 0x7D3A,
	12832: 0x90AF,
	12833: 0x9451,
	12834: 0x9452,
	12835: 0x9F95,
	12836: 0x5323,
	12837: 0x5CAC,
	12838: 0x7532,
	12839: 0x80DB,
	12840: 0x9240,
	12841: 0x9598,
	12842: 0x525B,
	12843: 0x5808,
	12844: 0x59DC,
	12845: 0x5CA1,
	12846: 0x5D17,
	12847: 0x5EB7,
	12848: 0x5F3A,
	12849: 0x5F4A,
	12850: 0x6177,
	12851: 0x6C5F,
	12852: 0x757A,
	12853: 0x7586,
	12854: 0x7CE0,
	12855: 0x7D73,
	12856: 0x7DB1,
	12857: 0x7F8C,
	12858: 0x8154,
	12859: 0x8221,
	12860: 0x8591,
	12861: 0x8941,
	12862: 0x8B1B,
	12863: 0x92FC,
	12864: 0x964D,
	12865: 0x9C47,
	12866: 0x4ECB,
	12867: 0x4EF7,
	12868: 0x500B,
	12869: 0x51F1,
	12870: 0x584F,
	12871: 0x6137,
	12872: 0x613E,
	12873: 0x6168,
	12874: 0x6539,
	12875: 0x69EA,
	12876: 0x6F11,
	12877: 0x75A5,
	12878: 0x7686,
	12879: 0x76D6,
	12880: 0x7B87,
	12881: 0x82A5,
	12882: 0x84CB,
	12883: 0xF900,
	12884: 0x93A7,
	12885: 0x958B,
	12886: 0x5580,
	12887: 0x5BA2,
	12888: 0x5751,
	12889: 0xF901,
	12890: 0x7CB3,
	12891: 0x7FB9,
	12892: 0x91B5,
	12893: 0x5028,
	12894: 0x53BB,
	12895: 0x5C45,
	12896: 0x5DE8,
	12897: 0x62D2,
	12898: 0x636E,
	12899: 0x64DA,
	12900: 0x64E7,
	12901: 0x6E20,
	12902: 0x70AC,
	12903: 0x795B,
	12904: 0x8DDD,
	12905: 0x8E1E,
	12906: 0xF902,
	12907: 0x907D,
	12908: 0x9245,
	12909: 0x92F8,
	12910: 0x4E7E,
	12911: 0x4EF6,
	12912: 0x5065,
	12913: 0x5DFE,
	12914: 0x5EFA,
	12915: 0x6106,
	12916: 0x6957,
	12917: 0x8171,
	12918: 0x8654,
	12919: 0x8E47,
	12920: 0x9375,
	12921: 0x9A2B,
	12922: 0x4E5E,
	12923: 0x5091,
	12924: 0x6770,
	12925: 0x6840,
	12926: 0x5109,
	12927: 0x528D,
	12928: 0x5292,
	12929: 0x6AA2,
	12930: 0x77BC,
	12931: 0x9210,
	12932: 0x9ED4,
	12933: 0x52AB,
	12934: 0x602F,
	12935: 0x8FF2,
	12936: 0x5048,
	12937: 0x61A9,
	12938: 0x63ED,
	12939: 0x64CA,
	12940: 0x683C,
	12941: 0x6A84,
	12942: 0x6FC0,
	12943: 0x8188,
	12944: 0x89A1,
	12945: 0x9694,
	12946: 0x5805,
	12947: 0x727D,
	12948: 0x72AC,
	12949: 0x7504,
	12950: 0x7D79,
	12951: 0x7E6D,
	12952: 0x80A9,
	12953: 0x898B,
	12954: 0x8B74,
	12955: 0x9063,
	12956: 0x9D51,
	12957: 0x6289,
	12958: 0x6C7A,
	12959: 0x6F54,
	12960: 0x7D50,
	12961: 0x7F3A,
	12962: 0x8A23,
	12963: 0x517C,
	12964: 0x614A,
	12965: 0x7B9D,
	12966: 0x8B19,
	12967: 0x9257,
	12968: 0x938C,
	12969: 0x4EAC,
	12970: 0x4FD3,
	12971: 0x501E,
	12972: 0x50BE,
	12973: 0x5106,
	12974: 0x52C1,
	12975: 0x52CD,
	12976: 0x537F,
	12977: 0x5770,
	12978: 0x5883,
	12979: 0x5E9A,
	12980: 0x5F91,
	12981: 0x6176,
	12982: 0x61AC,
	12983: 0x64CE,
	12984: 0x656C,
	12985: 0x666F,
	12986: 0x66BB,
	12987: 0x66F4,
	12988: 0x6897,
	12989: 0x6D87,
	12990: 0x7085,
	12991: 0x70F1,
	12992: 0x749F,
	12993: 0x74A5,
	12994: 0x74CA,
	12995: 0x75D9,
	12996: 0x786C,
	12997: 0x78EC,
	12998: 0x7ADF,
	12999: 0x7AF6,
	13000: 0x7D45,
	13001: 0x7D93,
	13002: 0x8015,
	13003: 0x803F,
	13004: 0x811B,
	13005: 0x8396,
	13006: 0x8B66,
	13007: 0x8F15,
	13008: 0x9015,
	13009: 0x93E1,
	13010: 0x9803,
	13011: 0x9838,
	13012: 0x9A5A,
	13013: 0x9BE8,
	13014: 0x4FC2,
	13015: 0x5553,
	13016: 0x583A,
	13017: 0x5951,
	13018: 0x5B63,
	13019: 0x5C46,
	13020: 0x60B8,
	13021: 0x6212,
	13022: 0x6842,
	13023: 0x68B0,
	13024: 0x68E8,
	13025: 0x6EAA,
	13026: 0x754C,
	13027: 0x7678,
	13028: 0x78CE,
	13029: 0x7A3D,
	13030: 0x7CFB,
	13031: 0x7E6B,
	13032: 0x7E7C,
	13033: 0x8A08,
	13034: 0x8AA1,
	13035: 0x8C3F,
	13036: 0x968E,
	13037: 0x9DC4,
	13038: 0x53E4,
	13039: 0x53E9,
	13040: 0x544A,
	13041: 0x5471,
	13042: 0x56FA,
	13043: 0x59D1,
	13044: 0x5B64,
	13045: 0x5C3B,
	13046: 0x5EAB,
	13047: 0x62F7,
	13048: 0x6537,
	13049: 0x6545,
	13050: 0x6572,
	13051: 0x66A0,
	13052: 0x67AF,
	13053: 0x69C1,
	13054: 0x6CBD,
	13055: 0x75FC,
	13056: 0x7690,
	13057: 0x777E,
	13058: 0x7A3F,
	13059: 0x7F94,
	13060: 0x8003,
	13061: 0x80A1,
	13062: 0x818F,
	13063: 0x82E6,
	13064: 0x82FD,
	13065: 0x83F0,
	13066: 0x85C1,
	13067: 0x8831,
	13068: 0x88B4,
	13069: 0x8AA5,
	13070: 0xF903,
	13071: 0x8F9C,
	13072: 0x932E,
	13073: 0x96C7,
	13074: 0x9867,
	13075: 0x9AD8,
	13076: 0x9F13,
	13077: 0x54ED,
	13078: 0x659B,
	13079: 0x66F2,
	13080: 0x688F,
	13081: 0x7A40,
	13082: 0x8C37,
	13083: 0x9D60,
	13084: 0x56F0,
	13085: 0x5764,
	13086: 0x5D11,
	13087: 0x6606,
	13088: 0x68B1,
	13089: 0x68CD,
	13090: 0x6EFE,
	13091: 0x7428,
	13092: 0x889E,
	13093: 0x9BE4,
	13094: 0x6C68,
	13095: 0xF904,
	13096: 0x9AA8,
	13097: 0x4F9B,
	13098: 0x516C,
	13099: 0x5171,
	13100: 0x529F,
	13101: 0x5B54,
	13102: 0x5DE5,
	13103: 0x6050,
	13104: 0x606D,
	13105: 0x62F1,
	13106: 0x63A7,
	13107: 0x653B,
	13108: 0x73D9,
	13109: 0x7A7A,
	13110: 0x86A3,
	13111: 0x8CA2,
	13112: 0x978F,
	13113: 0x4E32,
	13114: 0x5BE1,
	13115: 0x6208,
	13116: 0x679C,
	13117: 0x74DC,
	13118: 0x79D1,
	13119: 0x83D3,
	13120: 0x8A87,
	13121: 0x8AB2,
	13122: 0x8DE8,
	13123: 0x904E,
	13124: 0x934B,
	13125: 0x9846,
	13126: 0x5ED3,
	13127: 0x69E8,
	13128: 0x85FF,
	13129: 0x90ED,
	13130: 0xF905,
	13131: 0x51A0,
	13132: 0x5B98,
	13133: 0x5BEC,
	13134: 0x6163,
	13135: 0x68FA,
	13136: 0x6B3E,
	13137: 0x704C,
	13138: 0x742F,
	13139: 0x74D8,
	13140: 0x7BA1,
	13141: 0x7F50,
	13142: 0x83C5,
	13143: 0x89C0,
	13144: 0x8CAB,
	13145: 0x95DC,
	13146: 0x9928,
	13147: 0x522E,
	13148: 0x605D,
	13149: 0x62EC,
	13150: 0x9002,
	13151: 0x4F8A,
	13152: 0x5149,
	13153: 0x5321,
	13154: 0x58D9,
	13155: 0x5EE3,
	13156: 0x66E0,
	13157: 0x6D38,
	13158: 0x709A,
	13159: 0x72C2,
	13160: 0x73D6,
	13161: 0x7B50,
	13162: 0x80F1,
	13163: 0x945B,
	13164: 0x5366,
	13165: 0x639B,
	13166: 0x7F6B,
	13167: 0x4E56,
	13168: 0x5080,
	13169: 0x584A,
	13170: 0x58DE,
	13171: 0x602A,
	13172: 0x6127,
	13173: 0x62D0,
	13174: 0x69D0,
	13175: 0x9B41,
	13176: 0x5B8F,
	13177: 0x7D18,
	13178: 0x80B1,
	13179: 0x8F5F,
	13180: 0x4EA4,
	13181: 0x50D1,
	13182: 0x54AC,
	13183: 0x55AC,
	13184: 0x5B0C,
	13185: 0x5DA0,
	13186: 0x5DE7,
	13187: 0x652A,
	13188: 0x654E,
	13189: 0x6821,
	13190: 0x6A4B,
	13191: 0x72E1,
	13192: 0x768E,
	13193: 0x77EF,
	13194: 0x7D5E,
	13195: 0x7FF9,
	13196: 0x81A0,
	13197: 0x854E,
	13198: 0x86DF,
	13199: 0x8F03,
	13200: 0x8F4E,
	13201: 0x90CA,
	13202: 0x9903,
	13203: 0x9A55,
	13204: 0x9BAB,
	13205: 0x4E18,
	13206: 0x4E45,
	13207: 0x4E5D,
	13208: 0x4EC7,
	13209: 0x4FF1,
	13210: 0x5177,
	13211: 0x52FE,
	13212: 0x5340,
	13213: 0x53E3,
	13214: 0x53E5,
	13215: 0x548E,
	13216: 0x5614,
	13217: 0x5775,
	13218: 0x57A2,
	13219: 0x5BC7,
	13220: 0x5D87,
	13221: 0x5ED0,
	13222: 0x61FC,
	13223: 0x62D8,
	13224: 0x6551,
	13225: 0x67B8,
	13226: 0x67E9,
	13227: 0x69CB,
	13228: 0x6B50,
	13229: 0x6BC6,
	13230: 0x6BEC,
	13231: 0x6C42,
	13232: 0x6E9D,
	13233: 0x7078,
	13234: 0x72D7,
	13235: 0x7396,
	13236: 0x7403,
	13237: 0x77BF,
	13238: 0x77E9,
	13239: 0x7A76,
	13240: 0x7D7F,
	13241: 0x8009,
	13242: 0x81FC,
	13243: 0x8205,
	13244: 0x820A,
	13245: 0x82DF,
	13246: 0x8862,
	13247: 0x8B33,
	13248: 0x8CFC,
	13249: 0x8EC0,
	13250: 0x9011,
	13251: 0x90B1,
	13252: 0x9264,
	13253: 0x92B6,
	13254: 0x99D2,
	13255: 0x9A45,
	13256: 0x9CE9,
	13257: 0x9DD7,
	13258: 0x9F9C,
	13259: 0x570B,
	13260: 0x5C40,
	13261: 0x83CA,
	13262: 0x97A0,
	13263: 0x97AB,
	13264: 0x9EB4,
	13265: 0x541B,
	13266: 0x7A98,
	13267: 0x7FA4,
	13268: 0x88D9,
	13269: 0x8ECD,
	13270: 0x90E1,
	13271: 0x5800,
	13272: 0x5C48,
	13273: 0x6398,
	13274: 0x7A9F,
	13275: 0x5BAE,
	13276: 0x5F13,
	13277: 0x7A79,
	13278: 0x7AAE,
	13279: 0x828E,
	13280: 0x8EAC,
	13281: 0x5026,
	13282: 0x5238,
	13283: 0x52F8,
	13284: 0x5377,
	13285: 0x5708,
	13286: 0x62F3,
	13287: 0x6372,
	13288: 0x6B0A,
	13289: 0x6DC3,
	13290: 0x7737,
	13291: 0x53A5,
	13292: 0x7357,
	13293: 0x8568,
	13294: 0x8E76,
	13295: 0x95D5,
	13296: 0x673A,
	13297: 0x6AC3,
	13298: 0x6F70,
	13299: 0x8A6D,
	13300: 0x8ECC,
	13301: 0x994B,
	13302: 0xF906,
	13303: 0x6677,
	13304: 0x6B78,
	13305: 0x8CB4,
	13306: 0x9B3C,
	13307: 0xF907,
	13308: 0x53EB,
	13309: 0x572D,
	13310: 0x594E,
	13311: 0x63C6,
	13312: 0x69FB,
	13313: 0x73EA,
	13314: 0x7845,
	13315: 0x7ABA,
	13316: 0x7AC5,
	13317: 0x7CFE,
	13318: 0x8475,
	13319: 0x898F,
	13320: 0x8D73,
	13321: 0x9035,
	13322: 0x95A8,
	13323: 0x52FB,
	13324: 0x5747,
	13325: 0x7547,
	13326: 0x7B60,
	13327: 0x83CC,
	13328: 0x921E,
	13329: 0xF908,
	13330: 0x6A58,
	13331: 0x514B,
	13332: 0x524B,
	13333: 0x5287,
	13334: 0x621F,
	13335: 0x68D8,
	13336: 0x6975,
	13337: 0x9699,
	13338: 0x50C5,
	13339: 0x52A4,
	13340: 0x52E4,
	13341: 0x61C3,
	13342: 0x65A4,
	13343: 0x6839,
	13344: 0x69FF,
	13345: 0x747E,
	13346: 0x7B4B,
	13347: 0x82B9,
	13348: 0x83EB,
	13349: 0x89B2,
	13350: 0x8B39,
	13351: 0x8FD1,
	13352: 0x9949,
	13353: 0xF909,
	13354: 0x4ECA,
	13355: 0x5997,
	13356: 0x64D2,
	13357: 0x6611,
	13358: 0x6A8E,
	13359: 0x7434,
	13360: 0x7981,
	13361: 0x79BD,
	13362: 0x82A9,
	13363: 0x887E,
	13364: 0x887F,
	13365: 0x895F,
	13366: 0xF90A,
	13367: 0x9326,
	13368: 0x4F0B,
	13369: 0x53CA,
	13370: 0x6025,
	13371: 0x6271,
	13372: 0x6C72,
	13373: 0x7D1A,
	13374: 0x7D66,
	13375: 0x4E98,
	13376: 0x5162,
	13377: 0x77DC,
	13378: 0x80AF,
	13379: 0x4F01,
	13380: 0x4F0E,
	13381: 0x5176,
	13382: 0x5180,
	13383: 0x55DC,
	13384: 0x5668,
	13385: 0x573B,
	13386: 0x57FA,
	13387: 0x57FC,
	13388: 0x5914,
	13389: 0x5947,
	13390: 0x5993,
	13391: 0x5BC4,
	13392: 0x5C90,
	13393: 0x5D0E,
	13394: 0x5DF1,
	13395: 0x5E7E,
	13396: 0x5FCC,
	13397: 0x6280,
	13398: 0x65D7,
	13399: 0x65E3,
	13400: 0x671E,
	13401: 0x671F,
	13402: 0x675E,
	13403: 0x68CB,
	13404: 0x68C4,
	13405: 0x6A5F,
	13406: 0x6B3A,
	13407: 0x6C23,
	13408: 0x6C7D,
	13409: 0x6C82,
	13410: 0x6DC7,
	13411: 0x7398,
	13412: 0x7426,
	13413: 0x742A,
	13414: 0x7482,
	13415: 0x74A3,
	13416: 0x7578,
	13417: 0x757F,
	13418: 0x7881,
	13419: 0x78EF,
	13420: 0x7941,
	13421: 0x7947,
	13422: 0x7948,
	13423: 0x797A,
	13424: 0x7B95,
	13425: 0x7D00,
	13426: 0x7DBA,
	13427: 0x7F88,
	13428: 0x8006,
	13429: 0x802D,
	13430: 0x808C,
	13431: 0x8A18,
	13432: 0x8B4F,
	13433: 0x8C48,
	13434: 0x8D77,
	13435: 0x9321,
	13436: 0x9324,
	13437: 0x98E2,
	13438: 0x9951,
	13439: 0x9A0E,
	13440: 0x9A0F,
	13441: 0x9A65,
	13442: 0x9E92,
	13443: 0x7DCA,
	13444: 0x4F76,
	13445: 0x5409,
	13446: 0x62EE,
	13447: 0x6854,
	13448: 0x91D1,
	13449: 0x55AB,
	13450: 0x513A,
	13451: 0xF90B,
	13452: 0xF90C,
	13453: 0x5A1C,
	13454: 0x61E6,
	13455: 0xF90D,
	13456: 0x62CF,
	13457: 0x62FF,
	13458: 0xF90E,
	13459: 0xF90F,
	13460: 0xF910,
	13461: 0xF911,
	13462: 0xF912,
	13463: 0xF913,
	13464: 0x90A3,
	13465: 0xF914,
	13466: 0xF915,
	13467: 0xF916,
	13468: 0xF917,
	13469: 0xF918,
	13470: 0x8AFE,
	13471: 0xF919,
	13472: 0xF91A,
	13473: 0xF91B,
	13474: 0xF91C,
	13475: 0x6696,
	13476: 0xF91D,
	13477: 0x7156,
	13478: 0xF91E,
	13479: 0xF91F,
	13480: 0x96E3,
	13481: 0xF920,
	13482: 0x634F,
	13483: 0x637A,
	13484: 0x5357,
	13485: 0xF921,
	13486: 0x678F,
	13487: 0x6960,
	13488: 0x6E73,
	13489: 0xF922,
	13490: 0x7537,
	13491: 0xF923,
	13492: 0xF924,
	13493: 0xF925,
	13494: 0x7D0D,
	13495: 0xF926,
	13496: 0xF927,
	13497: 0x8872,
	13498: 0x56CA,
	13499: 0x5A18,
	13500: 0xF928,
	13501: 0xF929,
	13502: 0xF92A,
	13503: 0xF92B,
	13504: 0xF92C,
	13505: 0x4E43,
	13506: 0xF92D,
	13507: 0x5167,
	13508: 0x5948,
	13509: 0x67F0,
	13510: 0x8010,
	13511: 0xF92E,
	13512: 0x5973,
	13513: 0x5E74,
	13514: 0x649A,
	13515: 0x79CA,
	13516: 0x5FF5,
	13517: 0x606C,
	13518: 0x62C8,
	13519: 0x637B,
	13520: 0x5BE7,
	13521: 0x5BD7,
	13522: 0x52AA,
	13523: 0xF92F,
	13524: 0x5974,
	13525: 0x5F29,
	13526: 0x6012,
	13527: 0xF930,
	13528: 0xF931,
	13529: 0xF932,
	13530: 0x7459,
	13531: 0xF933,
	13532: 0xF934,
	13533: 0xF935,
	13534: 0xF936,
	13535: 0xF937,
	13536: 0xF938,
	13537: 0x99D1,
	13538: 0xF939,
	13539: 0xF93A,
	13540: 0xF93B,
	13541: 0xF93C,
	13542: 0xF93D,
	13543: 0xF93E,
	13544: 0xF93F,
	13545: 0xF940,
	13546: 0xF941,
	13547: 0xF942,
	13548: 0xF943,
	13549: 0x6FC3,
	13550: 0xF944,
	13551: 0xF945,
	13552: 0x81BF,
	13553: 0x8FB2,
	13554: 0x60F1,
	13555: 0xF946,
	13556: 0xF947,
	13557: 0x8166,
	13558: 0xF948,
	13559: 0xF949,
	13560: 0x5C3F,
	13561: 0xF94A,
	13562: 0xF94B,
	13563: 0xF94C,
	13564: 0xF94D,
	13565: 0xF94E,
	13566: 0xF94F,
	13567: 0xF950,
	13568: 0xF951,
	13569: 0x5AE9,
	13570: 0x8A25,
	13571: 0x677B,
	13572: 0x7D10,
	13573: 0xF952,
	13574: 0xF953,
	13575: 0xF954,
	13576: 0xF955,
	13577: 0xF956,
	13578: 0xF957,
	13579: 0x80FD,
	13580: 0xF958,
	13581: 0xF959,
	13582: 0x5C3C,
	13583: 0x6CE5,
	13584: 0x533F,
	13585: 0x6EBA,
	13586: 0x591A,
	13587: 0x8336,
	13588: 0x4E39,
	13589: 0x4EB6,
	13590: 0x4F46,
	13591: 0x55AE,
	13592: 0x5718,
	13593: 0x58C7,
	13594: 0x5F56,
	13595: 0x65B7,
	13596: 0x65E6,
	13597: 0x6A80,
	13598: 0x6BB5,
	13599: 0x6E4D,
	13600: 0x77ED,
	13601: 0x7AEF,
	13602: 0x7C1E,
	13603: 0x7DDE,
	13604: 0x86CB,
	13605: 0x8892,
	13606: 0x9132,
	13607: 0x935B,
	13608: 0x64BB,
	13609: 0x6FBE,
	13610: 0x737A,
	13611: 0x75B8,
	13612: 0x9054,
	13613: 0x5556,
	13614: 0x574D,
	13615: 0x61BA,
	13616: 0x64D4,
	13617: 0x66C7,
	13618: 0x6DE1,
	13619: 0x6E5B,
	13620: 0x6F6D,
	13621: 0x6FB9,
	13622: 0x75F0,
	13623: 0x8043,
	13624: 0x81BD,
	13625: 0x8541,
	13626: 0x8983,
	13627: 0x8AC7,
	13628: 0x8B5A,
	13629: 0x931F,
	13630: 0x6C93,
	13631: 0x7553,
	13632: 0x7B54,
	13633: 0x8E0F,
	13634: 0x905D,
	13635: 0x5510,
	13636: 0x5802,
	13637: 0x5858,
	13638: 0x5E62,
	13639: 0x6207,
	13640: 0x649E,
	13641: 0x68E0,
	13642: 0x7576,
	13643: 0x7CD6,
	13644: 0x87B3,
	13645: 0x9EE8,
	13646: 0x4EE3,
	13647: 0x5788,
	13648: 0x576E,
	13649: 0x5927,
	13650: 0x5C0D,
	13651: 0x5CB1,
	13652: 0x5E36,
	13653: 0x5F85,
	13654: 0x6234,
	13655: 0x64E1,
	13656: 0x73B3,
	13657: 0x81FA,
	13658: 0x888B,
	13659: 0x8CB8,
	13660: 0x968A,
	13661: 0x9EDB,
	13662: 0x5B85,
	13663: 0x5FB7,
	13664: 0x60B3,
	13665: 0x5012,
	13666: 0x5200,
	13667: 0x5230,
	13668: 0x5716,
	13669: 0x5835,
	13670: 0x5857,
	13671: 0x5C0E,
	13672: 0x5C60,
	13673: 0x5CF6,
	13674: 0x5D8B,
	13675: 0x5EA6,
	13676: 0x5F92,
	13677: 0x60BC,
	13678: 0x6311,
	13679: 0x6389,
	13680: 0x6417,
	13681: 0x6843,
	13682: 0x68F9,
	13683: 0x6AC2,
	13684: 0x6DD8,
	13685: 0x6E21,
	13686: 0x6ED4,
	13687: 0x6FE4,
	13688: 0x71FE,
	13689: 0x76DC,
	13690: 0x7779,
	13691: 0x79B1,
	13692: 0x7A3B,
	13693: 0x8404,
	13694: 0x89A9,
	13695: 0x8CED,
	13696: 0x8DF3,
	13697: 0x8E48,
	13698: 0x9003,
	13699: 0x9014,
	13700: 0x9053,
	13701: 0x90FD,
	13702: 0x934D,
	13703: 0x9676,
	13704: 0x97DC,
	13705: 0x6BD2,
	13706: 0x7006,
	13707: 0x7258,
	13708: 0x72A2,
	13709: 0x7368,
	13710: 0x7763,
	13711: 0x79BF,
	13712: 0x7BE4,
	13713: 0x7E9B,
	13714: 0x8B80,
	13715: 0x58A9,
	13716: 0x60C7,
	13717: 0x6566,
	13718: 0x65FD,
	13719: 0x66BE,
	13720: 0x6C8C,
	13721: 0x711E,
	13722: 0x71C9,
	13723: 0x8C5A,
	13724: 0x9813,
	13725: 0x4E6D,
	13726: 0x7A81,
	13727: 0x4EDD,
	13728: 0x51AC,
	13729: 0x51CD,
	13730: 0x52D5,
	13731: 0x540C,
	13732: 0x61A7,
	13733: 0x6771,
	13734: 0x6850,
	13735: 0x68DF,
	13736: 0x6D1E,
	13737: 0x6F7C,
	13738: 0x75BC,
	13739: 0x77B3,
	13740: 0x7AE5,
	13741: 0x80F4,
	13742: 0x8463,
	13743: 0x9285,
	13744: 0x515C,
	13745: 0x6597,
	13746: 0x675C,
	13747: 0x6793,
	13748: 0x75D8,
	13749: 0x7AC7,
	13750: 0x8373,
	13751: 0xF95A,
	13752: 0x8C46,
	13753: 0x9017,
	13754: 0x982D,
	13755: 0x5C6F,
	13756: 0x81C0,
	13757: 0x829A,
	13758: 0x9041,
	13759: 0x906F,
	13760: 0x920D,
	13761: 0x5F97,
	13762: 0x5D9D,
	13763: 0x6A59,
	13764: 0x71C8,
	13765: 0x767B,
	13766: 0x7B49,
	13767: 0x85E4,
	13768: 0x8B04,
	13769: 0x9127,
	13770: 0x9A30,
	13771: 0x5587,
	13772: 0x61F6,
	13773: 0xF95B,
	13774: 0x7669,
	13775: 0x7F85,
	13776: 0x863F,
	13777: 0x87BA,
	13778: 0x88F8,
	13779: 0x908F,
	13780: 0xF95C,
	13781: 0x6D1B,
	13782: 0x70D9,
	13783: 0x73DE,
	13784: 0x7D61,
	13785: 0x843D,
	13786: 0xF95D,
	13787: 0x916A,
	13788: 0x99F1,
	13789: 0xF95E,
	13790: 0x4E82,
	13791: 0x5375,
	13792: 0x6B04,
	13793: 0x6B12,
	13794: 0x703E,
	13795: 0x721B,
	13796: 0x862D,
	13797: 0x9E1E,
	13798: 0x524C,
	13799: 0x8FA3,
	13800: 0x5D50,
	13801: 0x64E5,
	13802: 0x652C,
	13803: 0x6B16,
	13804: 0x6FEB,
	13805: 0x7C43,
	13806: 0x7E9C,
	13807: 0x85CD,
	13808: 0x8964,
	13809: 0x89BD,
	13810: 0x62C9,
	13811: 0x81D8,
	13812: 0x881F,
	13813: 0x5ECA,
	13814: 0x6717,
	13815: 0x6D6A,
	13816: 0x72FC,
	13817: 0x7405,
	13818: 0x746F,
	13819: 0x8782,
	13820: 0x90DE,
	13821: 0x4F86,
	13822: 0x5D0D,
	13823: 0x5FA0,
	13824: 0x840A,
	13825: 0x51B7,
	13826: 0x63A0,
	13827: 0x7565,
	13828: 0x4EAE,
	13829: 0x5006,
	13830: 0x5169,
	13831: 0x51C9,
	13832: 0x6881,
	13833: 0x6A11,
	13834: 0x7CAE,
	13835: 0x7CB1,
	13836: 0x7CE7,
	13837: 0x826F,
	13838: 0x8AD2,
	13839: 0x8F1B,
	13840: 0x91CF,
	13841: 0x4FB6,
	13842: 0x5137,
	13843: 0x52F5,
	13844: 0x5442,
	13845: 0x5EEC,
	13846: 0x616E,
	13847: 0x623E,
	13848: 0x65C5,
	13849: 0x6ADA,
	13850: 0x6FFE,
	13851: 0x792A,
	13852: 0x85DC,
	13853: 0x8823,
	13854: 0x95AD,
	13855: 0x9A62,
	13856: 0x9A6A,
	13857: 0x9E97,
	13858: 0x9ECE,
	13859: 0x529B,
	13860: 0x66C6,
	13861: 0x6B77,
	13862: 0x701D,
	13863: 0x792B,
	13864: 0x8F62,
	13865: 0x9742,
	13866: 0x6190,
	13867: 0x6200,
	13868: 0x6523,
	13869: 0x6F23,
	13870: 0x7149,
	13871: 0x7489,
	13872: 0x7DF4,
	13873: 0x806F,
	13874: 0x84EE,
	13875: 0x8F26,
	13876: 0x9023,
	13877: 0x934A,
	13878: 0x51BD,
	13879: 0x5217,
	13880: 0x52A3,
	13881: 0x6D0C,
	13882: 0x70C8,
	13883: 0x88C2,
	13884: 0x5EC9,
	13885: 0x6582,
	13886: 0x6BAE,
	13887: 0x6FC2,
	13888: 0x7C3E,
	13889: 0x7375,
	13890: 0x4EE4,
	13891: 0x4F36,
	13892: 0x56F9,
	13893: 0xF95F,
	13894: 0x5CBA,
	13895: 0x5DBA,
	13896: 0x601C,
	13897: 0x73B2,
	13898: 0x7B2D,
	13899: 0x7F9A,
	13900: 0x7FCE,
	13901: 0x8046,
	13902: 0x901E,
	13903: 0x9234,
	13904: 0x96F6,
	13905: 0x9748,
	13906: 0x9818,
	13907: 0x9F61,
	13908: 0x4F8B,
	13909: 0x6FA7,
	13910: 0x79AE,
	13911: 0x91B4,
	13912: 0x96B7,
	13913: 0x52DE,
	13914: 0xF960,
	13915: 0x6488,
	13916: 0x64C4,
	13917: 0x6AD3,
	13918: 0x6F5E,
	13919: 0x7018,
	13920: 0x7210,
	13921: 0x76E7,
	13922: 0x8001,
	13923: 0x8606,
	13924: 0x865C,
	13925: 0x8DEF,
	13926: 0x8F05,
	13927: 0x9732,
	13928: 0x9B6F,
	13929: 0x9DFA,
	13930: 0x9E75,
	13931: 0x788C,
	13932: 0x797F,
	13933: 0x7DA0,
	13934: 0x83C9,
	13935: 0x9304,
	13936: 0x9E7F,
	13937: 0x9E93,
	13938: 0x8AD6,
	13939: 0x58DF,
	13940: 0x5F04,
	13941: 0x6727,
	13942: 0x7027,
	13943: 0x74CF,
	13944: 0x7C60,
	13945: 0x807E,
	13946: 0x5121,
	13947: 0x7028,
	13948: 0x7262,
	13949: 0x78CA,
	13950: 0x8CC2,
	13951: 0x8CDA,
	13952: 0x8CF4,
	13953: 0x96F7,
	13954: 0x4E86,
	13955: 0x50DA,
	13956: 0x5BEE,
	13957: 0x5ED6,
	13958: 0x6599,
	13959: 0x71CE,
	13960: 0x7642,
	13961: 0x77AD,
	13962: 0x804A,
	13963: 0x84FC,
	13964: 0x907C,
	13965: 0x9B27,
	13966: 0x9F8D,
	13967: 0x58D8,
	13968: 0x5A41,
	13969: 0x5C62,
	13970: 0x6A13,
	13971: 0x6DDA,
	13972: 0x6F0F,
	13973: 0x763B,
	13974: 0x7D2F,
	13975: 0x7E37,
	13976: 0x851E,
	13977: 0x8938,
	13978: 0x93E4,
	13979: 0x964B,
	13980: 0x5289,
	13981: 0x65D2,
	13982: 0x67F3,
	13983: 0x69B4,
	13984: 0x6D41,
	13985: 0x6E9C,
	13986: 0x700F,
	13987: 0x7409,
	13988: 0x7460,
	13989: 0x7559,
	13990: 0x7624,
	13991: 0x786B,
	13992: 0x8B2C,
	13993: 0x985E,
	13994: 0x516D,
	13995: 0x622E,
	13996: 0x9678,
	13997: 0x4F96,
	13998: 0x502B,
	13999: 0x5D19,
	14000: 0x6DEA,
	14001: 0x7DB8,
	14002: 0x8F2A,
	14003: 0x5F8B,
	14004: 0x6144,
	14005: 0x6817,
	14006: 0xF961,
	14007: 0x9686,
	14008: 0x52D2,
	14009: 0x808B,
	14010: 0x51DC,
	14011: 0x51CC,
	14012: 0x695E,
	14013: 0x7A1C,
	14014: 0x7DBE,
	14015: 0x83F1,
	14016: 0x9675,
	14017: 0x4FDA,
	14018: 0x5229,
	14019: 0x5398,
	14020: 0x540F,
	14021: 0x550E,
	14022: 0x5C65,
	14023: 0x60A7,
	14024: 0x674E,
	14025: 0x68A8,
	14026: 0x6D6C,
	14027: 0x7281,
	14028: 0x72F8,
	14029: 0x7406,
	14030: 0x7483,
	14031: 0xF962,
	14032: 0x75E2,
	14033: 0x7C6C,
	14034: 0x7F79,
	14035: 0x7FB8,
	14036: 0x8389,
	14037: 0x88CF,
	14038: 0x88E1,
	14039: 0x91CC,
	14040: 0x91D0,
	14041: 0x96E2,
	14042: 0x9BC9,
	14043: 0x541D,
	14044: 0x6F7E,
	14045: 0x71D0,
	14046: 0x7498,
	14047: 0x85FA,
	14048: 0x8EAA,
	14049: 0x96A3,
	14050: 0x9C57,
	14051: 0x9E9F,
	14052: 0x6797,
	14053: 0x6DCB,
	14054: 0x7433,
	14055: 0x81E8,
	14056: 0x9716,
	14057: 0x782C,
	14058: 0x7ACB,
	14059: 0x7B20,
	14060: 0x7C92,
	14061: 0x6469,
	14062: 0x746A,
	14063: 0x75F2,
	14064: 0x78BC,
	14065: 0x78E8,
	14066: 0x99AC,
	14067: 0x9B54,
	14068: 0x9EBB,
	14069: 0x5BDE,
	14070: 0x5E55,
	14071: 0x6F20,
	14072: 0x819C,
	14073: 0x83AB,
	14074: 0x9088,
	14075: 0x4E07,
	14076: 0x534D,
	14077: 0x5A29,
	14078: 0x5DD2,
	14079: 0x5F4E,
	14080: 0x6162,
	14081: 0x633D,
	14082: 0x6669,
	14083: 0x66FC,
	14084: 0x6EFF,
	14085: 0x6F2B,
	14086: 0x7063,
	14087: 0x779E,
	14088: 0x842C,
	14089: 0x8513,
	14090: 0x883B,
	14091: 0x8F13,
	14092: 0x9945,
	14093: 0x9C3B,
	14094: 0x551C,
	14095: 0x62B9,
	14096: 0x672B,
	14097: 0x6CAB,
	14098: 0x8309,
	14099: 0x896A,
	14100: 0x977A,
	14101: 0x4EA1,
	14102: 0x5984,
	14103: 0x5FD8,
	14104: 0x5FD9,
	14105: 0x671B,
	14106: 0x7DB2,
	14107: 0x7F54,
	14108: 0x8292,
	14109: 0x832B,
	14110: 0x83BD,
	14111: 0x8F1E,
	14112: 0x9099,
	14113: 0x57CB,
	14114: 0x59B9,
	14115: 0x5A92,
	14116: 0x5BD0,
	14117: 0x6627,
	14118: 0x679A,
	14119: 0x6885,
	14120: 0x6BCF,
	14121: 0x7164,
	14122: 0x7F75,
	14123: 0x8CB7,
	14124: 0x8CE3,
	14125: 0x9081,
	14126: 0x9B45,
	14127: 0x8108,
	14128: 0x8C8A,
	14129: 0x964C,
	14130: 0x9A40,
	14131: 0x9EA5,
	14132: 0x5B5F,
	14133: 0x6C13,
	14134: 0x731B,
	14135: 0x76F2,
	14136: 0x76DF,
	14137: 0x840C,
	14138: 0x51AA,
	14139: 0x8993,
	14140: 0x514D,
	14141: 0x5195,
	14142: 0x52C9,
	14143: 0x68C9,
	14144: 0x6C94,
	14145: 0x7704,
	14146: 0x7720,
	14147: 0x7DBF,
	14148: 0x7DEC,
	14149: 0x9762,
	14150: 0x9EB5,
	14151: 0x6EC5,
	14152: 0x8511,
	14153: 0x51A5,
	14154: 0x540D,
	14155: 0x547D,
	14156: 0x660E,
	14157: 0x669D,
	14158: 0x6927,
	14159: 0x6E9F,
	14160: 0x76BF,
	14161: 0x7791,
	14162: 0x8317,
	14163: 0x84C2,
	14164: 0x879F,
	14165: 0x9169,
	14166: 0x9298,
	14167: 0x9CF4,
	14168: 0x8882,
	14169: 0x4FAE,
	14170: 0x5192,
	14171: 0x52DF,
	14172: 0x59C6,
	14173: 0x5E3D,
	14174: 0x6155,
	14175: 0x6478,
	14176: 0x6479,
	14177: 0x66AE,
	14178: 0x67D0,
	14179: 0x6A21,
	14180: 0x6BCD,
	14181: 0x6BDB,
	14182: 0x725F,
	14183: 0x7261,
	14184: 0x7441,
	14185: 0x7738,
	14186: 0x77DB,
	14187: 0x8017,
	14188: 0x82BC,
	14189: 0x8305,
	14190: 0x8B00,
	14191: 0x8B28,
	14192: 0x8C8C,
	14193: 0x6728,
	14194: 0x6C90,
	14195: 0x7267,
	14196: 0x76EE,
	14197: 0x7766,
	14198: 0x7A46,
	14199: 0x9DA9,
	14200: 0x6B7F,
	14201: 0x6C92,
	14202: 0x5922,
	14203: 0x6726,
	14204: 0x8499,
	14205: 0x536F,
	14206: 0x5893,
	14207: 0x5999,
	14208: 0x5EDF,
	14209: 0x63CF,
	14210: 0x6634,
	14211: 0x6773,
	14212: 0x6E3A,
	14213: 0x732B,
	14214: 0x7AD7,
	14215: 0x82D7,
	14216: 0x9328,
	14217: 0x52D9,
	14218: 0x5DEB,
	14219: 0x61AE,
	14220: 0x61CB,
	14221: 0x620A,
	14222: 0x62C7,
	14223: 0x64AB,
	14224: 0x65E0,
	14225: 0x6959,
	14226: 0x6B66,
	14227: 0x6BCB,
	14228: 0x7121,
	14229: 0x73F7,
	14230: 0x755D,
	14231: 0x7E46,
	14232: 0x821E,
	14233: 0x8302,
	14234: 0x856A,
	14235: 0x8AA3,
	14236: 0x8CBF,
	14237: 0x9727,
	14238: 0x9D61,
	14239: 0x58A8,
	14240: 0x9ED8,
	14241: 0x5011,
	14242: 0x520E,
	14243: 0x543B,
	14244: 0x554F,
	14245: 0x6587,
	14246: 0x6C76,
	14247: 0x7D0A,
	14248: 0x7D0B,
	14249: 0x805E,
	14250: 0x868A,
	14251: 0x9580,
	14252: 0x96EF,
	14253: 0x52FF,
	14254: 0x6C95,
	14255: 0x7269,
	14256: 0x5473,
	14257: 0x5A9A,
	14258: 0x5C3E,
	14259: 0x5D4B,
	14260: 0x5F4C,
	14261: 0x5FAE,
	14262: 0x672A,
	14263: 0x68B6,
	14264: 0x6963,
	14265: 0x6E3C,
	14266: 0x6E44,
	14267: 0x7709,
	14268: 0x7C73,
	14269: 0x7F8E,
	14270: 0x8587,
	14271: 0x8B0E,
	14272: 0x8FF7,
	14273: 0x9761,
	14274: 0x9EF4,
	14275: 0x5CB7,
	14276: 0x60B6,
	14277: 0x610D,
	14278: 0x61AB,
	14279: 0x654F,
	14280: 0x65FB,
	14281: 0x65FC,
	14282: 0x6C11,
	14283: 0x6CEF,
	14284: 0x739F,
	14285: 0x73C9,
	14286: 0x7DE1,
	14287: 0x9594,
	14288: 0x5BC6,
	14289: 0x871C,
	14290: 0x8B10,
	14291: 0x525D,
	14292: 0x535A,
	14293: 0x62CD,
	14294: 0x640F,
	14295: 0x64B2,
	14296: 0x6734,
	14297: 0x6A38,
	14298: 0x6CCA,
	14299: 0x73C0,
	14300: 0x749E,
	14301: 0x7B94,
	14302: 0x7C95,
	14303: 0x7E1B,
	14304: 0x818A,
	14305: 0x8236,
	14306: 0x8584,
	14307: 0x8FEB,
	14308: 0x96F9,
	14309: 0x99C1,
	14310: 0x4F34,
	14311: 0x534A,
	14312: 0x53CD,
	14313: 0x53DB,
	14314: 0x62CC,
	14315: 0x642C,
	14316: 0x6500,
	14317: 0x6591,
	14318: 0x69C3,
	14319: 0x6CEE,
	14320: 0x6F58,
	14321: 0x73ED,
	14322: 0x7554,
	14323: 0x7622,
	14324: 0x76E4,
	14325: 0x76FC,
	14326: 0x78D0,
	14327: 0x78FB,
	14328: 0x792C,
	14329: 0x7D46,
	14330: 0x822C,
	14331: 0x87E0,
	14332: 0x8FD4,
	14333: 0x9812,
	14334: 0x98EF,
	14335: 0x52C3,
	14336: 0x62D4,
	14337: 0x64A5,
	14338: 0x6E24,
	14339: 0x6F51,
	14340: 0x767C,
	14341: 0x8DCB,
	14342: 0x91B1,
	14343: 0x9262,
	14344: 0x9AEE,
	14345: 0x9B43,
	14346: 0x5023,
	14347: 0x508D,
	14348: 0x574A,
	14349: 0x59A8,
	14350: 0x5C28,
	14351: 0x5E47,
	14352: 0x5F77,
	14353: 0x623F,
	14354: 0x653E,
	14355: 0x65B9,
	14356: 0x65C1,
	14357: 0x6609,
	14358: 0x678B,
	14359: 0x699C,
	14360: 0x6EC2,
	14361: 0x78C5,
	14362: 0x7D21,
	14363: 0x80AA,
	14364: 0x8180,
	14365: 0x822B,
	14366: 0x82B3,
	14367: 0x84A1,
	14368: 0x868C,
	14369: 0x8A2A,
	14370: 0x8B17,
	14371: 0x90A6,
	14372: 0x9632,
	14373: 0x9F90,
	14374: 0x500D,
	14375: 0x4FF3,
	14376: 0xF963,
	14377: 0x57F9,
	14378: 0x5F98,
	14379: 0x62DC,
	14380: 0x6392,
	14381: 0x676F,
	14382: 0x6E43,
	14383: 0x7119,
	14384: 0x76C3,
	14385: 0x80CC,
	14386: 0x80DA,
	14387: 0x88F4,
	14388: 0x88F5,
	14389: 0x8919,
	14390: 0x8CE0,
	14391: 0x8F29,
	14392: 0x914D,
	14393: 0x966A,
	14394: 0x4F2F,
	14395: 0x4F70,
	14396: 0x5E1B,
	14397: 0x67CF,
	14398: 0x6822,
	14399: 0x767D,
	14400: 0x767E,
	14401: 0x9B44,
	14402: 0x5E61,
	14403: 0x6A0A,
	14404: 0x7169,
	14405: 0x71D4,
	14406: 0x756A,
	14407: 0xF964,
	14408: 0x7E41,
	14409: 0x8543,
	14410: 0x85E9,
	14411: 0x98DC,
	14412: 0x4F10,
	14413: 0x7B4F,
	14414: 0x7F70,
	14415: 0x95A5,
	14416: 0x51E1,
	14417: 0x5E06,
	14418: 0x68B5,
	14419: 0x6C3E,
	14420: 0x6C4E,
	14421: 0x6CDB,
	14422: 0x72AF,
	14423: 0x7BC4,
	14424: 0x8303,
	14425: 0x6CD5,
	14426: 0x743A,
	14427: 0x50FB,
	14428: 0x5288,
	14429: 0x58C1,
	14430: 0x64D8,
	14431: 0x6A97,
	14432: 0x74A7,
	14433: 0x7656,
	14434: 0x78A7,
	14435: 0x8617,
	14436: 0x95E2,
	14437: 0x9739,
	14438: 0xF965,
	14439: 0x535E,
	14440: 0x5F01,
	14441: 0x8B8A,
	14442: 0x8FA8,
	14443: 0x8FAF,
	14444: 0x908A,
	14445: 0x5225,
	14446: 0x77A5,
	14447: 0x9C49,
	14448: 0x9F08,
	14449: 0x4E19,
	14450: 0x5002,
	14451: 0x5175,
	14452: 0x5C5B,
	14453: 0x5E77,
	14454: 0x661E,
	14455: 0x663A,
	14456: 0x67C4,
	14457: 0x68C5,
	14458: 0x70B3,
	14459: 0x7501,
	14460: 0x75C5,
	14461: 0x79C9,
	14462: 0x7ADD,
	14463: 0x8F27,
	14464: 0x9920,
	14465: 0x9A08,
	14466: 0x4FDD,
	14467: 0x5821,
	14468: 0x5831,
	14469: 0x5BF6,
	14470: 0x666E,
	14471: 0x6B65,
	14472: 0x6D11,
	14473: 0x6E7A,
	14474: 0x6F7D,
	14475: 0x73E4,
	14476: 0x752B,
	14477: 0x83E9,
	14478: 0x88DC,
	14479: 0x8913,
	14480: 0x8B5C,
	14481: 0x8F14,
	14482: 0x4F0F,
	14483: 0x50D5,
	14484: 0x5310,
	14485: 0x535C,
	14486: 0x5B93,
	14487: 0x5FA9,
	14488: 0x670D,
	14489: 0x798F,
	14490: 0x8179,
	14491: 0x832F,
	14492: 0x8514,
	14493: 0x8907,
	14494: 0x8986,
	14495: 0x8F39,
	14496: 0x8F3B,
	14497: 0x99A5,
	14498: 0x9C12,
	14499: 0x672C,
	14500: 0x4E76,
	14501: 0x4FF8,
	14502: 0x5949,
	14503: 0x5C01,
	14504: 0x5CEF,
	14505: 0x5CF0,
	14506: 0x6367,
	14507: 0x68D2,
	14508: 0x70FD,
	14509: 0x71A2,
	14510: 0x742B,
	14511: 0x7E2B,
	14512: 0x84EC,
	14513: 0x8702,
	14514: 0x9022,
	14515: 0x92D2,
	14516: 0x9CF3,
	14517: 0x4E0D,
	14518: 0x4ED8,
	14519: 0x4FEF,
	14520: 0x5085,
	14521: 0x5256,
	14522: 0x526F,
	14523: 0x5426,
	14524: 0x5490,
	14525: 0x57E0,
	14526: 0x592B,
	14527: 0x5A66,
	14528: 0x5B5A,
	14529: 0x5B75,
	14530: 0x5BCC,
	14531: 0x5E9C,
	14532: 0xF966,
	14533: 0x6276,
	14534: 0x6577,
	14535: 0x65A7,
	14536: 0x6D6E,
	14537: 0x6EA5,
	14538: 0x7236,
	14539: 0x7B26,
	14540: 0x7C3F,
	14541: 0x7F36,
	14542: 0x8150,
	14543: 0x8151,
	14544: 0x819A,
	14545: 0x8240,
	14546: 0x8299,
	14547: 0x83A9,
	14548: 0x8A03,
	14549: 0x8CA0,
	14550: 0x8CE6,
	14551: 0x8CFB,
	14552: 0x8D74,
	14553: 0x8DBA,
	14554: 0x90E8,
	14555: 0x91DC,
	14556: 0x961C,
	14557: 0x9644,
	14558: 0x99D9,
	14559: 0x9CE7,
	14560: 0x5317,
	14561: 0x5206,
	14562: 0x5429,
	14563: 0x5674,
	14564: 0x58B3,
	14565: 0x5954,
	14566: 0x596E,
	14567: 0x5FFF,
	14568: 0x61A4,
	14569: 0x626E,
	14570: 0x6610,
	14571: 0x6C7E,
	14572: 0x711A,
	14573: 0x76C6,
	14574: 0x7C89,
	14575: 0x7CDE,
	14576: 0x7D1B,
	14577: 0x82AC,
	14578: 0x8CC1,
	14579: 0x96F0,
	14580: 0xF967,
	14581: 0x4F5B,
	14582: 0x5F17,
	14583: 0x5F7F,
	14584: 0x62C2,
	14585: 0x5D29,
	14586: 0x670B,
	14587: 0x68DA,
	14588: 0x787C,
	14589: 0x7E43,
	14590: 0x9D6C,
	14591: 0x4E15,
	14592: 0x5099,
	14593: 0x5315,
	14594: 0x532A,
	14595: 0x5351,
	14596: 0x5983,
	14597: 0x5A62,
	14598: 0x5E87,
	14599: 0x60B2,
	14600: 0x618A,
	14601: 0x6249,
	14602: 0x6279,
	14603: 0x6590,
	14604: 0x6787,
	14605: 0x69A7,
	14606: 0x6BD4,
	14607: 0x6BD6,
	14608: 0x6BD7,
	14609: 0x6BD8,
	14610: 0x6CB8,
	14611: 0xF968,
	14612: 0x7435,
	14613: 0x75FA,
	14614: 0x7812,
	14615: 0x7891,
	14616: 0x79D5,
	14617: 0x79D8,
	14618: 0x7C83,
	14619: 0x7DCB,
	14620: 0x7FE1,
	14621: 0x80A5,
	14622: 0x813E,
	14623: 0x81C2,
	14624: 0x83F2,
	14625: 0x871A,
	14626: 0x88E8,
	14627: 0x8AB9,
	14628: 0x8B6C,
	14629: 0x8CBB,
	14630: 0x9119,
	14631: 0x975E,
	14632: 0x98DB,
	14633: 0x9F3B,
	14634: 0x56AC,
	14635: 0x5B2A,
	14636: 0x5F6C,
	14637: 0x658C,
	14638: 0x6AB3,
	14639: 0x6BAF,
	14640: 0x6D5C,
	14641: 0x6FF1,
	14642: 0x7015,
	14643: 0x725D,
	14644: 0x73AD,
	14645: 0x8CA7,
	14646: 0x8CD3,
	14647: 0x983B,
	14648: 0x6191,
	14649: 0x6C37,
	14650: 0x8058,
	14651: 0x9A01,
	14652: 0x4E4D,
	14653: 0x4E8B,
	14654: 0x4E9B,
	14655: 0x4ED5,
	14656: 0x4F3A,
	14657: 0x4F3C,
	14658: 0x4F7F,
	14659: 0x4FDF,
	14660: 0x50FF,
	14661: 0x53F2,
	14662: 0x53F8,
	14663: 0x5506,
	14664: 0x55E3,
	14665: 0x56DB,
	14666: 0x58EB,
	14667: 0x5962,
	14668: 0x5A11,
	14669: 0x5BEB,
	14670: 0x5BFA,
	14671: 0x5C04,
	14672: 0x5DF3,
	14673: 0x5E2B,
	14674: 0x5F99,
	14675: 0x601D,
	14676: 0x6368,
	14677: 0x659C,
	14678: 0x65AF,
	14679: 0x67F6,
	14680: 0x67FB,
	14681: 0x68AD,
	14682: 0x6B7B,
	14683: 0x6C99,
	14684: 0x6CD7,
	14685: 0x6E23,
	14686: 0x7009,
	14687: 0x7345,
	14688: 0x7802,
	14689: 0x793E,
	14690: 0x7940,
	14691: 0x7960,
	14692: 0x79C1,
	14693: 0x7BE9,
	14694: 0x7D17,
	14695: 0x7D72,
	14696: 0x8086,
	14697: 0x820D,
	14698: 0x838E,
	14699: 0x84D1,
	14700: 0x86C7,
	14701: 0x88DF,
	14702: 0x8A50,
	14703: 0x8A5E,
	14704: 0x8B1D,
	14705: 0x8CDC,
	14706: 0x8D66,
	14707: 0x8FAD,
	14708: 0x90AA,
	14709: 0x98FC,
	14710: 0x99DF,
	14711: 0x9E9D,
	14712: 0x524A,
	14713: 0xF969,
	14714: 0x6714,
	14715: 0xF96A,
	14716: 0x5098,
	14717: 0x522A,
	14718: 0x5C71,
	14719: 0x6563,
	14720: 0x6C55,
	14721: 0x73CA,
	14722: 0x7523,
	14723: 0x759D,
	14724: 0x7B97,
	14725: 0x849C,
	14726: 0x9178,
	14727: 0x9730,
	14728: 0x4E77,
	14729: 0x6492,
	14730: 0x6BBA,
	14731: 0x715E,
	14732: 0x85A9,
	14733: 0x4E09,
	14734: 0xF96B,
	14735: 0x6749,
	14736: 0x68EE,
	14737: 0x6E17,
	14738: 0x829F,
	14739: 0x8518,
	14740: 0x886B,
	14741: 0x63F7,
	14742: 0x6F81,
	14743: 0x9212,
	14744: 0x98AF,
	14745: 0x4E0A,
	14746: 0x50B7,
	14747: 0x50CF,
	14748: 0x511F,
	14749: 0x5546,
	14750: 0x55AA,
	14751: 0x5617,
	14752: 0x5B40,
	14753: 0x5C19,
	14754: 0x5CE0,
	14755: 0x5E38,
	14756: 0x5E8A,
	14757: 0x5EA0,
	14758: 0x5EC2,
	14759: 0x60F3,
	14760: 0x6851,
	14761: 0x6A61,
	14762: 0x6E58,
	14763: 0x723D,
	14764: 0x7240,
	14765: 0x72C0,
	14766: 0x76F8,
	14767: 0x7965,
	14768: 0x7BB1,
	14769: 0x7FD4,
	14770: 0x88F3,
	14771: 0x89F4,
	14772: 0x8A73,
	14773: 0x8C61,
	14774: 0x8CDE,
	14775: 0x971C,
	14776: 0x585E,
	14777: 0x74BD,
	14778: 0x8CFD,
	14779: 0x55C7,
	14780: 0xF96C,
	14781: 0x7A61,
	14782: 0x7D22,
	14783: 0x8272,
	14784: 0x7272,
	14785: 0x751F,
	14786: 0x7525,
	14787: 0xF96D,
	14788: 0x7B19,
	14789: 0x5885,
	14790: 0x58FB,
	14791: 0x5DBC,
	14792: 0x5E8F,
	14793: 0x5EB6,
	14794: 0x5F90,
	14795: 0x6055,
	14796: 0x6292,
	14797: 0x637F,
	14798: 0x654D,
	14799: 0x6691,
	14800: 0x66D9,
	14801: 0x66F8,
	14802: 0x6816,
	14803: 0x68F2,
	14804: 0x7280,
	14805: 0x745E,
	14806: 0x7B6E,
	14807: 0x7D6E,
	14808: 0x7DD6,
	14809: 0x7F72,
	14810: 0x80E5,
	14811: 0x8212,
	14812: 0x85AF,
	14813: 0x897F,
	14814: 0x8A93,
	14815: 0x901D,
	14816: 0x92E4,
	14817: 0x9ECD,
	14818: 0x9F20,
	14819: 0x5915,
	14820: 0x596D,
	14821: 0x5E2D,
	14822: 0x60DC,
	14823: 0x6614,
	14824: 0x6673,
	14825: 0x6790,
	14826: 0x6C50,
	14827: 0x6DC5,
	14828: 0x6F5F,
	14829: 0x77F3,
	14830: 0x78A9,
	14831: 0x84C6,
	14832: 0x91CB,
	14833: 0x932B,
	14834: 0x4ED9,
	14835: 0x50CA,
	14836: 0x5148,
	14837: 0x5584,
	14838: 0x5B0B,
	14839: 0x5BA3,
	14840: 0x6247,
	14841: 0x657E,
	14842: 0x65CB,
	14843: 0x6E32,
	14844: 0x717D,
	14845: 0x7401,
	14846: 0x7444,
	14847: 0x7487,
	14848: 0x74BF,
	14849: 0x766C,
	14850: 0x79AA,
	14851: 0x7DDA,
	14852: 0x7E55,
	14853: 0x7FA8,
	14854: 0x817A,
	14855: 0x81B3,
	14856: 0x8239,
	14857: 0x861A,
	14858: 0x87EC,
	14859: 0x8A75,
	14860: 0x8DE3,
	14861: 0x9078,
	14862: 0x9291,
	14863: 0x9425,
	14864: 0x994D,
	14865: 0x9BAE,
	14866: 0x5368,
	14867: 0x5C51,
	14868: 0x6954,
	14869: 0x6CC4,
	14870: 0x6D29,
	14871: 0x6E2B,
	14872: 0x820C,
	14873: 0x859B,
	14874: 0x893B,
	14875: 0x8A2D,
	14876: 0x8AAA,
	14877: 0x96EA,
	14878: 0x9F67,
	14879: 0x5261,
	14880: 0x66B9,
	14881: 0x6BB2,
	14882: 0x7E96,
	14883: 0x87FE,
	14884: 0x8D0D,
	14885: 0x9583,
	14886: 0x965D,
	14887: 0x651D,
	14888: 0x6D89,
	14889: 0x71EE,
	14890: 0xF96E,
	14891: 0x57CE,
	14892: 0x59D3,
	14893: 0x5BAC,
	14894: 0x6027,
	14895: 0x60FA,
	14896: 0x6210,
	14897: 0x661F,
	14898: 0x665F,
	14899: 0x7329,
	14900: 0x73F9,
	14901: 0x76DB,
	14902: 0x7701,
	14903: 0x7B6C,
	14904: 0x8056,
	14905: 0x8072,
	14906: 0x8165,
	14907: 0x8AA0,
	14908: 0x9192,
	14909: 0x4E16,
	14910: 0x52E2,
	14911: 0x6B72,
	14912: 0x6D17,
	14913: 0x7A05,
	14914: 0x7B39,
	14915: 0x7D30,
	14916: 0xF96F,
	14917: 0x8CB0,
	14918: 0x53EC,
	14919: 0x562F,
	14920: 0x5851,
	14921: 0x5BB5,
	14922: 0x5C0F,
	14923: 0x5C11,
	14924: 0x5DE2,
	14925: 0x6240,
	14926: 0x6383,
	14927: 0x6414,
	14928: 0x662D,
	14929: 0x68B3,
	14930: 0x6CBC,
	14931: 0x6D88,
	14932: 0x6EAF,
	14933: 0x701F,
	14934: 0x70A4,
	14935: 0x71D2,
	14936: 0x7526,
	14937: 0x758F,
	14938: 0x758E,
	14939: 0x7619,
	14940: 0x7B11,
	14941: 0x7BE0,
	14942: 0x7C2B,
	14943: 0x7D20,
	14944: 0x7D39,
	14945: 0x852C,
	14946: 0x856D,
	14947: 0x8607,
	14948: 0x8A34,
	14949: 0x900D,
	14950: 0x9061,
	14951: 0x90B5,
	14952: 0x92B7,
	14953: 0x97F6,
	14954: 0x9A37,
	14955: 0x4FD7,
	14956: 0x5C6C,
	14957: 0x675F,
	14958: 0x6D91,
	14959: 0x7C9F,
	14960: 0x7E8C,
	14961: 0x8B16,
	14962: 0x8D16,
	14963: 0x901F,
	14964: 0x5B6B,
	14965: 0x5DFD,
	14966: 0x640D,
	14967: 0x84C0,
	14968: 0x905C,
	14969: 0x98E1,
	14970: 0x7387,
	14971: 0x5B8B,
	14972: 0x609A,
	14973: 0x677E,
	14974: 0x6DDE,
	14975: 0x8A1F,
	14976: 0x8AA6,
	14977: 0x9001,
	14978: 0x980C,
	14979: 0x5237,
	14980: 0xF970,
	14981: 0x7051,
	14982: 0x788E,
	14983: 0x9396,
	14984: 0x8870,
	14985: 0x91D7,
	14986: 0x4FEE,
	14987: 0x53D7,
	14988: 0x55FD,
	14989: 0x56DA,
	14990: 0x5782,
	14991: 0x58FD,
	14992: 0x5AC2,
	14993: 0x5B88,
	14994: 0x5CAB,
	14995: 0x5CC0,
	14996: 0x5E25,
	14997: 0x6101,
	14998: 0x620D,
	14999: 0x624B,
	15000: 0x6388,
	15001: 0x641C,
	15002: 0x6536,
	15003: 0x6578,
	15004: 0x6A39,
	15005: 0x6B8A,
	15006: 0x6C34,
	15007: 0x6D19,
	15008: 0x6F31,
	15009: 0x71E7,
	15010: 0x72E9,
	15011: 0x7378,
	15012: 0x7407,
	15013: 0x74B2,
	15014: 0x7626,
	15015: 0x7761,
	15016: 0x79C0,
	15017: 0x7A57,
	15018: 0x7AEA,
	15019: 0x7CB9,
	15020: 0x7D8F,
	15021: 0x7DAC,
	15022: 0x7E61,
	15023: 0x7F9E,
	15024: 0x8129,
	15025: 0x8331,
	15026: 0x8490,
	15027: 0x84DA,
	15028: 0x85EA,
	15029: 0x8896,
	15030: 0x8AB0,
	15031: 0x8B90,
	15032: 0x8F38,
	15033: 0x9042,
	15034: 0x9083,
	15035: 0x916C,
	15036: 0x9296,
	15037: 0x92B9,
	15038: 0x968B,
	15039: 0x96A7,
	15040: 0x96A8,
	15041: 0x96D6,
	15042: 0x9700,
	15043: 0x9808,
	15044: 0x9996,
	15045: 0x9AD3,
	15046: 0x9B1A,
	15047: 0x53D4,
	15048: 0x587E,
	15049: 0x5919,
	15050: 0x5B70,
	15051: 0x5BBF,
	15052: 0x6DD1,
	15053: 0x6F5A,
	15054: 0x719F,
	15055: 0x7421,
	15056: 0x74B9,
	15057: 0x8085,
	15058: 0x83FD,
	15059: 0x5DE1,
	15060: 0x5F87,
	15061: 0x5FAA,
	15062: 0x6042,
	15063: 0x65EC,
	15064: 0x6812,
	15065: 0x696F,
	15066: 0x6A53,
	15067: 0x6B89,
	15068: 0x6D35,
	15069: 0x6DF3,
	15070: 0x73E3,
	15071: 0x76FE,
	15072: 0x77AC,
	15073: 0x7B4D,
	15074: 0x7D14,
	15075: 0x8123,
	15076: 0x821C,
	15077: 0x8340,
	15078: 0x84F4,
	15079: 0x8563,
	15080: 0x8A62,
	15081: 0x8AC4,
	15082: 0x9187,
	15083: 0x931E,
	15084: 0x9806,
	15085: 0x99B4,
	15086: 0x620C,
	15087: 0x8853,
	15088: 0x8FF0,
	15089: 0x9265,
	15090: 0x5D07,
	15091: 0x5D27,
	15092: 0x5D69,
	15093: 0x745F,
	15094: 0x819D,
	15095: 0x8768,
	15096: 0x6FD5,
	15097: 0x62FE,
	15098: 0x7FD2,
	15099: 0x8936,
	15100: 0x8972,
	15101: 0x4E1E,
	15102: 0x4E58,
	15103: 0x50E7,
	15104: 0x52DD,
	15105: 0x5347,
	15106: 0x627F,
	15107: 0x6607,
	15108: 0x7E69,
	15109: 0x8805,
	15110: 0x965E,
	15111: 0x4F8D,
	15112: 0x5319,
	15113: 0x5636,
	15114: 0x59CB,
	15115: 0x5AA4,
	15116: 0x5C38,
	15117: 0x5C4E,
	15118: 0x5C4D,
	15119: 0x5E02,
	15120: 0x5F11,
	15121: 0x6043,
	15122: 0x65BD,
	15123: 0x662F,
	15124: 0x6642,
	15125: 0x67BE,
	15126: 0x67F4,
	15127: 0x731C,
	15128: 0x77E2,
	15129: 0x793A,
	15130: 0x7FC5,
	15131: 0x8494,
	15132: 0x84CD,
	15133: 0x8996,
	15134: 0x8A66,
	15135: 0x8A69,
	15136: 0x8AE1,
	15137: 0x8C55,
	15138: 0x8C7A,
	15139: 0x57F4,
	15140: 0x5BD4,
	15141: 0x5F0F,
	15142: 0x606F,
	15143: 0x62ED,
	15144: 0x690D,
	15145: 0x6B96,
	15146: 0x6E5C,
	15147: 0x7184,
	15148: 0x7BD2,
	15149: 0x8755,
	15150: 0x8B58,
	15151: 0x8EFE,
	15152: 0x98DF,
	15153: 0x98FE,
	15154: 0x4F38,
	15155: 0x4F81,
	15156: 0x4FE1,
	15157: 0x547B,
	15158: 0x5A20,
	15159: 0x5BB8,
	15160: 0x613C,
	15161: 0x65B0,
	15162: 0x6668,
	15163: 0x71FC,
	15164: 0x7533,
	15165: 0x795E,
	15166: 0x7D33,
	15167: 0x814E,
	15168: 0x81E3,
	15169: 0x8398,
	15170: 0x85AA,
	15171: 0x85CE,
	15172: 0x8703,
	15173: 0x8A0A,
	15174: 0x8EAB,
	15175: 0x8F9B,
	15176: 0xF971,
	15177: 0x8FC5,
	15178: 0x5931,
	15179: 0x5BA4,
	15180: 0x5BE6,
	15181: 0x6089,
	15182: 0x5BE9,
	15183: 0x5C0B,
	15184: 0x5FC3,
	15185: 0x6C81,
	15186: 0xF972,
	15187: 0x6DF1,
	15188: 0x700B,
	15189: 0x751A,
	15190: 0x82AF,
	15191: 0x8AF6,
	15192: 0x4EC0,
	15193: 0x5341,
	15194: 0xF973,
	15195: 0x96D9,
	15196: 0x6C0F,
	15197: 0x4E9E,
	15198: 0x4FC4,
	15199: 0x5152,
	15200: 0x555E,
	15201: 0x5A25,
	15202: 0x5CE8,
	15203: 0x6211,
	15204: 0x7259,
	15205: 0x82BD,
	15206: 0x83AA,
	15207: 0x86FE,
	15208: 0x8859,
	15209: 0x8A1D,
	15210: 0x963F,
	15211: 0x96C5,
	15212: 0x9913,
	15213: 0x9D09,
	15214: 0x9D5D,
	15215: 0x580A,
	15216: 0x5CB3,
	15217: 0x5DBD,
	15218: 0x5E44,
	15219: 0x60E1,
	15220: 0x6115,
	15221: 0x63E1,
	15222: 0x6A02,
	15223: 0x6E25,
	15224: 0x9102,
	15225: 0x9354,
	15226: 0x984E,
	15227: 0x9C10,
	15228: 0x9F77,
	15229: 0x5B89,
	15230: 0x5CB8,
	15231: 0x6309,
	15232: 0x664F,
	15233: 0x6848,
	15234: 0x773C,
	15235: 0x96C1,
	15236: 0x978D,
	15237: 0x9854,
	15238: 0x9B9F,
	15239: 0x65A1,
	15240: 0x8B01,
	15241: 0x8ECB,
	15242: 0x95BC,
	15243: 0x5535,
	15244: 0x5CA9,
	15245: 0x5DD6,
	15246: 0x5EB5,
	15247: 0x6697,
	15248: 0x764C,
	15249: 0x83F4,
	15250: 0x95C7,
	15251: 0x58D3,
	15252: 0x62BC,
	15253: 0x72CE,
	15254: 0x9D28,
	15255: 0x4EF0,
	15256: 0x592E,
	15257: 0x600F,
	15258: 0x663B,
	15259: 0x6B83,
	15260: 0x79E7,
	15261: 0x9D26,
	15262: 0x5393,
	15263: 0x54C0,
	15264: 0x57C3,
	15265: 0x5D16,
	15266: 0x611B,
	15267: 0x66D6,
	15268: 0x6DAF,
	15269: 0x788D,
	15270: 0x827E,
	15271: 0x9698,
	15272: 0x9744,
	15273: 0x5384,
	15274: 0x627C,
	15275: 0x6396,
	15276: 0x6DB2,
	15277: 0x7E0A,
	15278: 0x814B,
	15279: 0x984D,
	15280: 0x6AFB,
	15281: 0x7F4C,
	15282: 0x9DAF,
	15283: 0x9E1A,
	15284: 0x4E5F,
	15285: 0x503B,
	15286: 0x51B6,
	15287: 0x591C,
	15288: 0x60F9,
	15289: 0x63F6,
	15290: 0x6930,
	15291: 0x723A,
	15292: 0x8036,
	15293: 0xF974,
	15294: 0x91CE,
	15295: 0x5F31,
	15296: 0xF975,
	15297: 0xF976,
	15298: 0x7D04,
	15299: 0x82E5,
	15300: 0x846F,
	15301: 0x84BB,
	15302: 0x85E5,
	15303: 0x8E8D,
	15304: 0xF977,
	15305: 0x4F6F,
	15306: 0xF978,
	15307: 0xF979,
	15308: 0x58E4,
	15309: 0x5B43,
	15310: 0x6059,
	15311: 0x63DA,
	15312: 0x6518,
	15313: 0x656D,
	15314: 0x6698,
	15315: 0xF97A,
	15316: 0x694A,
	15317: 0x6A23,
	15318: 0x6D0B,
	15319: 0x7001,
	15320: 0x716C,
	15321: 0x75D2,
	15322: 0x760D,
	15323: 0x79B3,
	15324: 0x7A70,
	15325: 0xF97B,
	15326: 0x7F8A,
	15327: 0xF97C,
	15328: 0x8944,
	15329: 0xF97D,
	15330: 0x8B93,
	15331: 0x91C0,
	15332: 0x967D,
	15333: 0xF97E,
	15334: 0x990A,
	15335: 0x5704,
	15336: 0x5FA1,
	15337: 0x65BC,
	15338: 0x6F01,
	15339: 0x7600,
	15340: 0x79A6,
	15341: 0x8A9E,
	15342: 0x99AD,
	15343: 0x9B5A,
	15344: 0x9F6C,
	15345: 0x5104,
	15346: 0x61B6,
	15347: 0x6291,
	15348: 0x6A8D,
	15349: 0x81C6,
	15350: 0x5043,
	15351: 0x5830,
	15352: 0x5F66,
	15353: 0x7109,
	15354: 0x8A00,
	15355: 0x8AFA,
	15356: 0x5B7C,
	15357: 0x8616,
	15358: 0x4FFA,
	15359: 0x513C,
	15360: 0x56B4,
	15361: 0x5944,
	15362: 0x63A9,
	15363: 0x6DF9,
	15364: 0x5DAA,
	15365: 0x696D,
	15366: 0x5186,
	15367: 0x4E88,
	15368: 0x4F59,
	15369: 0xF97F,
	15370: 0xF980,
	15371: 0xF981,
	15372: 0x5982,
	15373: 0xF982,
	15374: 0xF983,
	15375: 0x6B5F,
	15376: 0x6C5D,
	15377: 0xF984,
	15378: 0x74B5,
	15379: 0x7916,
	15380: 0xF985,
	15381: 0x8207,
	15382: 0x8245,
	15383: 0x8339,
	15384: 0x8F3F,
	15385: 0x8F5D,
	15386: 0xF986,
	15387: 0x9918,
	15388: 0xF987,
	15389: 0xF988,
	15390: 0xF989,
	15391: 0x4EA6,
	15392: 0xF98A,
	15393: 0x57DF,
	15394: 0x5F79,
	15395: 0x6613,
	15396: 0xF98B,
	15397: 0xF98C,
	15398: 0x75AB,
	15399: 0x7E79,
	15400: 0x8B6F,
	15401: 0xF98D,
	15402: 0x9006,
	15403: 0x9A5B,
	15404: 0x56A5,
	15405: 0x5827,
	15406: 0x59F8,
	15407: 0x5A1F,
	15408: 0x5BB4,
	15409: 0xF98E,
	15410: 0x5EF6,
	15411: 0xF98F,
	15412: 0xF990,
	15413: 0x6350,
	15414: 0x633B,
	15415: 0xF991,
	15416: 0x693D,
	15417: 0x6C87,
	15418: 0x6CBF,
	15419: 0x6D8E,
	15420: 0x6D93,
	15421: 0x6DF5,
	15422: 0x6F14,
	15423: 0xF992,
	15424: 0x70DF,
	15425: 0x7136,
	15426: 0x7159,
	15427: 0xF993,
	15428: 0x71C3,
	15429: 0x71D5,
	15430: 0xF994,
	15431: 0x784F,
	15432: 0x786F,
	15433: 0xF995,
	15434: 0x7B75,
	15435: 0x7DE3,
	15436: 0xF996,
	15437: 0x7E2F,
	15438: 0xF997,
	15439: 0x884D,
	15440: 0x8EDF,
	15441: 0xF998,
	15442: 0xF999,
	15443: 0xF99A,
	15444: 0x925B,
	15445: 0xF99B,
	15446: 0x9CF6,
	15447: 0xF99C,
	15448: 0xF99D,
	15449: 0xF99E,
	15450: 0x6085,
	15451: 0x6D85,
	15452: 0xF99F,
	15453: 0x71B1,
	15454: 0xF9A0,
	15455: 0xF9A1,
	15456: 0x95B1,
	15457: 0x53AD,
	15458: 0xF9A2,
	15459: 0xF9A3,
	15460: 0xF9A4,
	15461: 0x67D3,
	15462: 0xF9A5,
	15463: 0x708E,
	15464: 0x7130,
	15465: 0x7430,
	15466: 0x8276,
	15467: 0x82D2,
	15468: 0xF9A6,
	15469: 0x95BB,
	15470: 0x9AE5,
	15471: 0x9E7D,
	15472: 0x66C4,
	15473: 0xF9A7,
	15474: 0x71C1,
	15475: 0x8449,
	15476: 0xF9A8,
	15477: 0xF9A9,
	15478: 0x584B,
	15479: 0xF9AA,
	15480: 0xF9AB,
	15481: 0x5DB8,
	15482: 0x5F71,
	15483: 0xF9AC,
	15484: 0x6620,
	15485: 0x668E,
	15486: 0x6979,
	15487: 0x69AE,
	15488: 0x6C38,
	15489: 0x6CF3,
	15490: 0x6E36,
	15491: 0x6F41,
	15492: 0x6FDA,
	15493: 0x701B,
	15494: 0x702F,
	15495: 0x7150,
	15496: 0x71DF,
	15497: 0x7370,
	15498: 0xF9AD,
	15499: 0x745B,
	15500: 0xF9AE,
	15501: 0x74D4,
	15502: 0x76C8,
	15503: 0x7A4E,
	15504: 0x7E93,
	15505: 0xF9AF,
	15506: 0xF9B0,
	15507: 0x82F1,
	15508: 0x8A60,
	15509: 0x8FCE,
	15510: 0xF9B1,
	15511: 0x9348,
	15512: 0xF9B2,
	15513: 0x9719,
	15514: 0xF9B3,
	15515: 0xF9B4,
	15516: 0x4E42,
	15517: 0x502A,
	15518: 0xF9B5,
	15519: 0x5208,
	15520: 0x53E1,
	15521: 0x66F3,
	15522: 0x6C6D,
	15523: 0x6FCA,
	15524: 0x730A,
	15525: 0x777F,
	15526: 0x7A62,
	15527: 0x82AE,
	15528: 0x85DD,
	15529: 0x8602,
	15530: 0xF9B6,
	15531: 0x88D4,
	15532: 0x8A63,
	15533: 0x8B7D,
	15534: 0x8C6B,
	15535: 0xF9B7,
	15536: 0x92B3,
	15537: 0xF9B8,
	15538: 0x9713,
	15539: 0x9810,
	15540: 0x4E94,
	15541: 0x4F0D,
	15542: 0x4FC9,
	15543: 0x50B2,
	15544: 0x5348,
	15545: 0x543E,
	15546: 0x5433,
	15547: 0x55DA,
	15548: 0x5862,
	15549: 0x58BA,
	15550: 0x5967,
	15551: 0x5A1B,
	15552: 0x5BE4,
	15553: 0x609F,
	15554: 0xF9B9,
	15555: 0x61CA,
	15556: 0x6556,
	15557: 0x65FF,
	15558: 0x6664,
	15559: 0x68A7,
	15560: 0x6C5A,
	15561: 0x6FB3,
	15562: 0x70CF,
	15563: 0x71AC,
	15564: 0x7352,
	15565: 0x7B7D,
	15566: 0x8708,
	15567: 0x8AA4,
	15568: 0x9C32,
	15569: 0x9F07,
	15570: 0x5C4B,
	15571: 0x6C83,
	15572: 0x7344,
	15573: 0x7389,
	15574: 0x923A,
	15575: 0x6EAB,
	15576: 0x7465,
	15577: 0x761F,
	15578: 0x7A69,
	15579: 0x7E15,
	15580: 0x860A,
	15581: 0x5140,
	15582: 0x58C5,
	15583: 0x64C1,
	15584: 0x74EE,
	15585: 0x7515,
	15586: 0x7670,
	15587: 0x7FC1,
	15588: 0x9095,
	15589: 0x96CD,
	15590: 0x9954,
	15591: 0x6E26,
	15592: 0x74E6,
	15593: 0x7AA9,
	15594: 0x7AAA,
	15595: 0x81E5,
	15596: 0x86D9,
	15597: 0x8778,
	15598: 0x8A1B,
	15599: 0x5A49,
	15600: 0x5B8C,
	15601: 0x5B9B,
	15602: 0x68A1,
	15603: 0x6900,
	15604: 0x6D63,
	15605: 0x73A9,
	15606: 0x7413,
	15607: 0x742C,
	15608: 0x7897,
	15609: 0x7DE9,
	15610: 0x7FEB,
	15611: 0x8118,
	15612: 0x8155,
	15613: 0x839E,
	15614: 0x8C4C,
	15615: 0x962E,
	15616: 0x9811,
	15617: 0x66F0,
	15618: 0x5F80,
	15619: 0x65FA,
	15620: 0x6789,
	15621: 0x6C6A,
	15622: 0x738B,
	15623: 0x502D,
	15624: 0x5A03,
	15625: 0x6B6A,
	15626: 0x77EE,
	15627: 0x5916,
	15628: 0x5D6C,
	15629: 0x5DCD,
	15630: 0x7325,
	15631: 0x754F,
	15632: 0xF9BA,
	15633: 0xF9BB,
	15634: 0x50E5,
	15635: 0x51F9,
	15636: 0x582F,
	15637: 0x592D,
	15638: 0x5996,
	15639: 0x59DA,
	15640: 0x5BE5,
	15641: 0xF9BC,
	15642: 0xF9BD,
	15643: 0x5DA2,
	15644: 0x62D7,
	15645: 0x6416,
	15646: 0x6493,
	15647: 0x64FE,
	15648: 0xF9BE,
	15649: 0x66DC,
	15650: 0xF9BF,
	15651: 0x6A48,
	15652: 0xF9C0,
	15653: 0x71FF,
	15654: 0x7464,
	15655: 0xF9C1,
	15656: 0x7A88,
	15657: 0x7AAF,
	15658: 0x7E47,
	15659: 0x7E5E,
	15660: 0x8000,
	15661: 0x8170,
	15662: 0xF9C2,
	15663: 0x87EF,
	15664: 0x8981,
	15665: 0x8B20,
	15666: 0x9059,
	15667: 0xF9C3,
	15668: 0x9080,
	15669: 0x9952,
	15670: 0x617E,
	15671: 0x6B32,
	15672: 0x6D74,
	15673: 0x7E1F,
	15674: 0x8925,
	15675: 0x8FB1,
	15676: 0x4FD1,
	15677: 0x50AD,
	15678: 0x5197,
	15679: 0x52C7,
	15680: 0x57C7,
	15681: 0x5889,
	15682: 0x5BB9,
	15683: 0x5EB8,
	15684: 0x6142,
	15685: 0x6995,
	15686: 0x6D8C,
	15687: 0x6E67,
	15688: 0x6EB6,
	15689: 0x7194,
	15690: 0x7462,
	15691: 0x7528,
	15692: 0x752C,
	15693: 0x8073,
	15694: 0x8338,
	15695: 0x84C9,
	15696: 0x8E0A,
	15697: 0x9394,
	15698: 0x93DE,
	15699: 0xF9C4,
	15700: 0x4E8E,
	15701: 0x4F51,
	15702: 0x5076,
	15703: 0x512A,
	15704: 0x53C8,
	15705: 0x53CB,
	15706: 0x53F3,
	15707: 0x5B87,
	15708: 0x5BD3,
	15709: 0x5C24,
	15710: 0x611A,
	15711: 0x6182,
	15712: 0x65F4,
	15713: 0x725B,
	15714: 0x7397,
	15715: 0x7440,
	15716: 0x76C2,
	15717: 0x7950,
	15718: 0x7991,
	15719: 0x79B9,
	15720: 0x7D06,
	15721: 0x7FBD,
	15722: 0x828B,
	15723: 0x85D5,
	15724: 0x865E,
	15725: 0x8FC2,
	15726: 0x9047,
	15727: 0x90F5,
	15728: 0x91EA,
	15729: 0x9685,
	15730: 0x96E8,
	15731: 0x96E9,
	15732: 0x52D6,
	15733: 0x5F67,
	15734: 0x65ED,
	15735: 0x6631,
	15736: 0x682F,
	15737: 0x715C,
	15738: 0x7A36,
	15739: 0x90C1,
	15740: 0x980A,
	15741: 0x4E91,
	15742: 0xF9C5,
	15743: 0x6A52,
	15744: 0x6B9E,
	15745: 0x6F90,
	15746: 0x7189,
	15747: 0x8018,
	15748: 0x82B8,
	15749: 0x8553,
	15750: 0x904B,
	15751: 0x9695,
	15752: 0x96F2,
	15753: 0x97FB,
	15754: 0x851A,
	15755: 0x9B31,
	15756: 0x4E90,
	15757: 0x718A,
	15758: 0x96C4,
	15759: 0x5143,
	15760: 0x539F,
	15761: 0x54E1,
	15762: 0x5713,
	15763: 0x5712,
	15764: 0x57A3,
	15765: 0x5A9B,
	15766: 0x5AC4,
	15767: 0x5BC3,
	15768: 0x6028,
	15769: 0x613F,
	15770: 0x63F4,
	15771: 0x6C85,
	15772: 0x6D39,
	15773: 0x6E72,
	15774: 0x6E90,
	15775: 0x7230,
	15776: 0x733F,
	15777: 0x7457,
	15778: 0x82D1,
	15779: 0x8881,
	15780: 0x8F45,
	15781: 0x9060,
	15782: 0xF9C6,
	15783: 0x9662,
	15784: 0x9858,
	15785: 0x9D1B,
	15786: 0x6708,
	15787: 0x8D8A,
	15788: 0x925E,
	15789: 0x4F4D,
	15790: 0x5049,
	15791: 0x50DE,
	15792: 0x5371,
	15793: 0x570D,
	15794: 0x59D4,
	15795: 0x5A01,
	15796: 0x5C09,
	15797: 0x6170,
	15798: 0x6690,
	15799: 0x6E2D,
	15800: 0x7232,
	15801: 0x744B,
	15802: 0x7DEF,
	15803: 0x80C3,
	15804: 0x840E,
	15805: 0x8466,
	15806: 0x853F,
	15807: 0x875F,
	15808: 0x885B,
	15809: 0x8918,
	15810: 0x8B02,
	15811: 0x9055,
	15812: 0x97CB,
	15813: 0x9B4F,
	15814: 0x4E73,
	15815: 0x4F91,
	15816: 0x5112,
	15817: 0x516A,
	15818: 0xF9C7,
	15819: 0x552F,
	15820: 0x55A9,
	15821: 0x5B7A,
	15822: 0x5BA5,
	15823: 0x5E7C,
	15824: 0x5E7D,
	15825: 0x5EBE,
	15826: 0x60A0,
	15827: 0x60DF,
	15828: 0x6108,
	15829: 0x6109,
	15830: 0x63C4,
	15831: 0x6538,
	15832: 0x6709,
	15833: 0xF9C8,
	15834: 0x67D4,
	15835: 0x67DA,
	15836: 0xF9C9,
	15837: 0x6961,
	15838: 0x6962,
	15839: 0x6CB9,
	15840: 0x6D27,
	15841: 0xF9CA,
	15842: 0x6E38,
	15843: 0xF9CB,
	15844: 0x6FE1,
	15845: 0x7336,
	15846: 0x7337,
	15847: 0xF9CC,
	15848: 0x745C,
	15849: 0x7531,
	15850: 0xF9CD,
	15851: 0x7652,
	15852: 0xF9CE,
	15853: 0xF9CF,
	15854: 0x7DAD,
	15855: 0x81FE,
	15856: 0x8438,
	15857: 0x88D5,
	15858: 0x8A98,
	15859: 0x8ADB,
	15860: 0x8AED,
	15861: 0x8E30,
	15862: 0x8E42,
	15863: 0x904A,
	15864: 0x903E,
	15865: 0x907A,
	15866: 0x9149,
	15867: 0x91C9,
	15868: 0x936E,
	15869: 0xF9D0,
	15870: 0xF9D1,
	15871: 0x5809,
	15872: 0xF9D2,
	15873: 0x6BD3,
	15874: 0x8089,
	15875: 0x80B2,
	15876: 0xF9D3,
	15877: 0xF9D4,
	15878: 0x5141,
	15879: 0x596B,
	15880: 0x5C39,
	15881: 0xF9D5,
	15882: 0xF9D6,
	15883: 0x6F64,
	15884: 0x73A7,
	15885: 0x80E4,
	15886: 0x8D07,
	15887: 0xF9D7,
	15888: 0x9217,
	15889: 0x958F,
	15890: 0xF9D8,
	15891: 0xF9D9,
	15892: 0xF9DA,
	15893: 0xF9DB,
	15894: 0x807F,
	15895: 0x620E,
	15896: 0x701C,
	15897: 0x7D68,
	15898: 0x878D,
	15899: 0xF9DC,
	15900: 0x57A0,
	15901: 0x6069,
	15902: 0x6147,
	15903: 0x6BB7,
	15904: 0x8ABE,
	15905: 0x9280,
	15906: 0x96B1,
	15907: 0x4E59,
	15908: 0x541F,
	15909: 0x6DEB,
	15910: 0x852D,
	15911: 0x9670,
	15912: 0x97F3,
	15913: 0x98EE,
	15914: 0x63D6,
	15915: 0x6CE3,
	15916: 0x9091,
	15917: 0x51DD,
	15918: 0x61C9,
	15919: 0x81BA,
	15920: 0x9DF9,
	15921: 0x4F9D,
	15922: 0x501A,
	15923: 0x5100,
	15924: 0x5B9C,
	15925: 0x610F,
	15926: 0x61FF,
	15927: 0x64EC,
	15928: 0x6905,
	15929: 0x6BC5,
	15930: 0x7591,
	15931: 0x77E3,
	15932: 0x7FA9,
	15933: 0x8264,
	15934: 0x858F,
	15935: 0x87FB,
	15936: 0x8863,
	15937: 0x8ABC,
	15938: 0x8B70,
	15939: 0x91AB,
	15940: 0x4E8C,
	15941: 0x4EE5,
	15942: 0x4F0A,
	15943: 0xF9DD,
	15944: 0xF9DE,
	15945: 0x5937,
	15946: 0x59E8,
	15947: 0xF9DF,
	15948: 0x5DF2,
	15949: 0x5F1B,
	15950: 0x5F5B,
	15951: 0x6021,
	15952: 0xF9E0,
	15953: 0xF9E1,
	15954: 0xF9E2,
	15955: 0xF9E3,
	15956: 0x723E,
	15957: 0x73E5,
	15958: 0xF9E4,
	15959: 0x7570,
	15960: 0x75CD,
	15961: 0xF9E5,
	15962: 0x79FB,
	15963: 0xF9E6,
	15964: 0x800C,
	15965: 0x8033,
	15966: 0x8084,
	15967: 0x82E1,
	15968: 0x8351,
	15969: 0xF9E7,
	15970: 0xF9E8,
	15971: 0x8CBD,
	15972: 0x8CB3,
	15973: 0x9087,
	15974: 0xF9E9,
	15975: 0xF9EA,
	15976: 0x98F4,
	15977: 0x990C,
	15978: 0xF9EB,
	15979: 0xF9EC,
	15980: 0x7037,
	15981: 0x76CA,
	15982: 0x7FCA,
	15983: 0x7FCC,
	15984: 0x7FFC,
	15985: 0x8B1A,
	15986: 0x4EBA,
	15987: 0x4EC1,
	15988: 0x5203,
	15989: 0x5370,
	15990: 0xF9ED,
	15991: 0x54BD,
	15992: 0x56E0,
	15993: 0x59FB,
	15994: 0x5BC5,
	15995: 0x5F15,
	15996: 0x5FCD,
	15997: 0x6E6E,
	15998: 0xF9EE,
	15999: 0xF9EF,
	16000: 0x7D6A,
	16001: 0x8335,
	16002: 0xF9F0,
	16003: 0x8693,
	16004: 0x8A8D,
	16005: 0xF9F1,
	16006: 0x976D,
	16007: 0x9777,
	16008: 0xF9F2,
	16009: 0xF9F3,
	16010: 0x4E00,
	16011: 0x4F5A,
	16012: 0x4F7E,
	16013: 0x58F9,
	16014: 0x65E5,
	16015: 0x6EA2,
	16016: 0x9038,
	16017: 0x93B0,
	16018: 0x99B9,
	16019: 0x4EFB,
	16020: 0x58EC,
	16021: 0x598A,
	16022: 0x59D9,
	16023: 0x6041,
	16024: 0xF9F4,
	16025: 0xF9F5,
	16026: 0x7A14,
	16027: 0xF9F6,
	16028: 0x834F,
	16029: 0x8CC3,
	16030: 0x5165,
	16031: 0x5344,
	16032: 0xF9F7,
	16033: 0xF9F8,
	16034: 0xF9F9,
	16035: 0x4ECD,
	16036: 0x5269,
	16037: 0x5B55,
	16038: 0x82BF,
	16039: 0x4ED4,
	16040: 0x523A,
	16041: 0x54A8,
	16042: 0x59C9,
	16043: 0x59FF,
	16044: 0x5B50,
	16045: 0x5B57,
	16046: 0x5B5C,
	16047: 0x6063,
	16048: 0x6148,
	16049: 0x6ECB,
	16050: 0x7099,
	16051: 0x716E,
	16052: 0x7386,
	16053: 0x74F7,
	16054: 0x75B5,
	16055: 0x78C1,
	16056: 0x7D2B,
	16057: 0x8005,
	16058: 0x81EA,
	16059: 0x8328,
	16060: 0x8517,
	16061: 0x85C9,
	16062: 0x8AEE,
	16063: 0x8CC7,
	16064: 0x96CC,
	16065: 0x4F5C,
	16066: 0x52FA,
	16067: 0x56BC,
	16068: 0x65AB,
	16069: 0x6628,
	16070: 0x707C,
	16071: 0x70B8,
	16072: 0x7235,
	16073: 0x7DBD,
	16074: 0x828D,
	16075: 0x914C,
	16076: 0x96C0,
	16077: 0x9D72,
	16078: 0x5B71,
	16079: 0x68E7,
	16080: 0x6B98,
	16081: 0x6F7A,
	16082: 0x76DE,
	16083: 0x5C91,
	16084: 0x66AB,
	16085: 0x6F5B,
	16086: 0x7BB4,
	16087: 0x7C2A,
	16088: 0x8836,
	16089: 0x96DC,
	16090: 0x4E08,
	16091: 0x4ED7,
	16092: 0x5320,
	16093: 0x5834,
	16094: 0x58BB,
	16095: 0x58EF,
	16096: 0x596C,
	16097: 0x5C07,
	16098: 0x5E33,
	16099: 0x5E84,
	16100: 0x5F35,
	16101: 0x638C,
	16102: 0x66B2,
	16103: 0x6756,
	16104: 0x6A1F,
	16105: 0x6AA3,
	16106: 0x6B0C,
	16107: 0x6F3F,
	16108: 0x7246,
	16109: 0xF9FA,
	16110: 0x7350,
	16111: 0x748B,
	16112: 0x7AE0,
	16113: 0x7CA7,
	16114: 0x8178,
	16115: 0x81DF,
	16116: 0x81E7,
	16117: 0x838A,
	16118: 0x846C,
	16119: 0x8523,
	16120: 0x8594,
	16121: 0x85CF,
	16122: 0x88DD,
	16123: 0x8D13,
	16124: 0x91AC,
	16125: 0x9577,
	16126: 0x969C,
	16127: 0x518D,
	16128: 0x54C9,
	16129: 0x5728,
	16130: 0x5BB0,
	16131: 0x624D,
	16132: 0x6750,
	16133: 0x683D,
	16134: 0x6893,
	16135: 0x6E3D,
	16136: 0x6ED3,
	16137: 0x707D,
	16138: 0x7E21,
	16139: 0x88C1,
	16140: 0x8CA1,
	16141: 0x8F09,
	16142: 0x9F4B,
	16143: 0x9F4E,
	16144: 0x722D,
	16145: 0x7B8F,
	16146: 0x8ACD,
	16147: 0x931A,
	16148: 0x4F47,
	16149: 0x4F4E,
	16150: 0x5132,
	16151: 0x5480,
	16152: 0x59D0,
	16153: 0x5E95,
	16154: 0x62B5,
	16155: 0x6775,
	16156: 0x696E,
	16157: 0x6A17,
	16158: 0x6CAE,
	16159: 0x6E1A,
	16160: 0x72D9,
	16161: 0x732A,
	16162: 0x75BD,
	16163: 0x7BB8,
	16164: 0x7D35,
	16165: 0x82E7,
	16166: 0x83F9,
	16167: 0x8457,
	16168: 0x85F7,
	16169: 0x8A5B,
	16170: 0x8CAF,
	16171: 0x8E87,
	16172: 0x9019,
	16173: 0x90B8,
	16174: 0x96CE,
	16175: 0x9F5F,
	16176: 0x52E3,
	16177: 0x540A,
	16178: 0x5AE1,
	16179: 0x5BC2,
	16180: 0x6458,
	16181: 0x6575,
	16182: 0x6EF4,
	16183: 0x72C4,
	16184: 0xF9FB,
	16185: 0x7684,
	16186: 0x7A4D,
	16187: 0x7B1B,
	16188: 0x7C4D,
	16189: 0x7E3E,
	16190: 0x7FDF,
	16191: 0x837B,
	16192: 0x8B2B,
	16193: 0x8CCA,
	16194: 0x8D64,
	16195: 0x8DE1,
	16196: 0x8E5F,
	16197: 0x8FEA,
	16198: 0x8FF9,
	16199: 0x9069,
	16200: 0x93D1,
	16201: 0x4F43,
	16202: 0x4F7A,
	16203: 0x50B3,
	16204: 0x5168,
	16205: 0x5178,
	16206: 0x524D,
	16207: 0x526A,
	16208: 0x5861,
	16209: 0x587C,
	16210: 0x5960,
	16211: 0x5C08,
	16212: 0x5C55,
	16213: 0x5EDB,
	16214: 0x609B,
	16215: 0x6230,
	16216: 0x6813,
	16217: 0x6BBF,
	16218: 0x6C08,
	16219: 0x6FB1,
	16220: 0x714E,
	16221: 0x7420,
	16222: 0x7530,
	16223: 0x7538,
	16224: 0x7551,
	16225: 0x7672,
	16226: 0x7B4C,
	16227: 0x7B8B,
	16228: 0x7BAD,
	16229: 0x7BC6,
	16230: 0x7E8F,
	16231: 0x8A6E,
	16232: 0x8F3E,
	16233: 0x8F49,
	16234: 0x923F,
	16235: 0x9293,
	16236: 0x9322,
	16237: 0x942B,
	16238: 0x96FB,
	16239: 0x985A,
	16240: 0x986B,
	16241: 0x991E,
	16242: 0x5207,
	16243: 0x622A,
	16244: 0x6298,
	16245: 0x6D59,
	16246: 0x7664,
	16247: 0x7ACA,
	16248: 0x7BC0,
	16249: 0x7D76,
	16250: 0x5360,
	16251: 0x5CBE,
	16252: 0x5E97,
	16253: 0x6F38,
	16254: 0x70B9,
	16255: 0x7C98,
	16256: 0x9711,
	16257: 0x9B8E,
	16258: 0x9EDE,
	16259: 0x63A5,
	16260: 0x647A,
	16261: 0x8776,
	16262: 0x4E01,
	16263: 0x4E95,
	16264: 0x4EAD,
	16265: 0x505C,
	16266: 0x5075,
	16267: 0x5448,
	16268: 0x59C3,
	16269: 0x5B9A,
	16270: 0x5E40,
	16271: 0x5EAD,
	16272: 0x5EF7,
	16273: 0x5F81,
	16274: 0x60C5,
	16275: 0x633A,
	16276: 0x653F,
	16277: 0x6574,
	16278: 0x65CC,
	16279: 0x6676,
	16280: 0x6678,
	16281: 0x67FE,
	16282: 0x6968,
	16283: 0x6A89,
	16284: 0x6B63,
	16285: 0x6C40,
	16286: 0x6DC0,
	16287: 0x6DE8,
	16288: 0x6E1F,
	16289: 0x6E5E,
	16290: 0x701E,
	16291: 0x70A1,
	16292: 0x738E,
	16293: 0x73FD,
	16294: 0x753A,
	16295: 0x775B,
	16296: 0x7887,
	16297: 0x798E,
	16298: 0x7A0B,
	16299: 0x7A7D,
	16300: 0x7CBE,
	16301: 0x7D8E,
	16302: 0x8247,
	16303: 0x8A02,
	16304: 0x8AEA,
	16305: 0x8C9E,
	16306: 0x912D,
	16307: 0x914A,
	16308: 0x91D8,
	16309: 0x9266,
	16310: 0x92CC,
	16311: 0x9320,
	16312: 0x9706,
	16313: 0x9756,
	16314: 0x975C,
	16315: 0x9802,
	16316: 0x9F0E,
	16317: 0x5236,
	16318: 0x5291,
	16319: 0x557C,
	16320: 0x5824,
	16321: 0x5E1D,
	16322: 0x5F1F,
	16323: 0x608C,
	16324: 0x63D0,
	16325: 0x68AF,
	16326: 0x6FDF,
	16327: 0x796D,
	16328: 0x7B2C,
	16329: 0x81CD,
	16330: 0x85BA,
	16331: 0x88FD,
	16332: 0x8AF8,
	16333: 0x8E44,
	16334: 0x918D,
	16335: 0x9664,
	16336: 0x969B,
	16337: 0x973D,
	16338: 0x984C,
	16339: 0x9F4A,
	16340: 0x4FCE,
	16341: 0x5146,
	16342: 0x51CB,
	16343: 0x52A9,
	16344: 0x5632,
	16345: 0x5F14,
	16346: 0x5F6B,
	16347: 0x63AA,
	16348: 0x64CD,
	16349: 0x65E9,
	16350: 0x6641,
	16351: 0x66FA,
	16352: 0x66F9,
	16353: 0x671D,
	16354: 0x689D,
	16355: 0x68D7,
	16356: 0x69FD,
	16357: 0x6F15,
	16358: 0x6F6E,
	16359: 0x7167,
	16360: 0x71E5,
	16361: 0x722A,
	16362: 0x74AA,
	16363: 0x773A,
	16364: 0x7956,
	16365: 0x795A,
	16366: 0x79DF,
	16367: 0x7A20,
	16368: 0x7A95,
	16369: 0x7C97,
	16370: 0x7CDF,
	16371: 0x7D44,
	16372: 0x7E70,
	16373: 0x8087,
	16374: 0x85FB,
	16375: 0x86A4,
	16376: 0x8A54,
	16377: 0x8ABF,
	16378: 0x8D99,
	16379: 0x8E81,
	16380: 0x9020,
	16381: 0x906D,
	16382: 0x91E3,
	16383: 0x963B,
	16384: 0x96D5,
	16385: 0x9CE5,
	16386: 0x65CF,
	16387: 0x7C07,
	16388: 0x8DB3,
	16389: 0x93C3,
	16390: 0x5B58,
	16391: 0x5C0A,
	16392: 0x5352,
	16393: 0x62D9,
	16394: 0x731D,
	16395: 0x5027,
	16396: 0x5B97,
	16397: 0x5F9E,
	16398: 0x60B0,
	16399: 0x616B,
	16400: 0x68D5,
	16401: 0x6DD9,
	16402: 0x742E,
	16403: 0x7A2E,
	16404: 0x7D42,
	16405: 0x7D9C,
	16406: 0x7E31,
	16407: 0x816B,
	16408: 0x8E2A,
	16409: 0x8E35,
	16410: 0x937E,
	16411: 0x9418,
	16412: 0x4F50,
	16413: 0x5750,
	16414: 0x5DE6,
	16415: 0x5EA7,
	16416: 0x632B,
	16417: 0x7F6A,
	16418: 0x4E3B,
	16419: 0x4F4F,
	16420: 0x4F8F,
	16421: 0x505A,
	16422: 0x59DD,
	16423: 0x80C4,
	16424: 0x546A,
	16425: 0x5468,
	16426: 0x55FE,
	16427: 0x594F,
	16428: 0x5B99,
	16429: 0x5DDE,
	16430: 0x5EDA,
	16431: 0x665D,
	16432: 0x6731,
	16433: 0x67F1,
	16434: 0x682A,
	16435: 0x6CE8,
	16436: 0x6D32,
	16437: 0x6E4A,
	16438: 0x6F8D,
	16439: 0x70B7,
	16440: 0x73E0,
	16441: 0x7587,
	16442: 0x7C4C,
	16443: 0x7D02,
	16444: 0x7D2C,
	16445: 0x7DA2,
	16446: 0x821F,
	16447: 0x86DB,
	16448: 0x8A3B,
	16449: 0x8A85,
	16450: 0x8D70,
	16451: 0x8E8A,
	16452: 0x8F33,
	16453: 0x9031,
	16454: 0x914E,
	16455: 0x9152,
	16456: 0x9444,
	16457: 0x99D0,
	16458: 0x7AF9,
	16459: 0x7CA5,
	16460: 0x4FCA,
	16461: 0x5101,
	16462: 0x51C6,
	16463: 0x57C8,
	16464: 0x5BEF,
	16465: 0x5CFB,
	16466: 0x6659,
	16467: 0x6A3D,
	16468: 0x6D5A,
	16469: 0x6E96,
	16470: 0x6FEC,
	16471: 0x710C,
	16472: 0x756F,
	16473: 0x7AE3,
	16474: 0x8822,
	16475: 0x9021,
	16476: 0x9075,
	16477: 0x96CB,
	16478: 0x99FF,
	16479: 0x8301,
	16480: 0x4E2D,
	16481: 0x4EF2,
	16482: 0x8846,
	16483: 0x91CD,
	16484: 0x537D,
	16485: 0x6ADB,
	16486: 0x696B,
	16487: 0x6C41,
	16488: 0x847A,
	16489: 0x589E,
	16490: 0x618E,
	16491: 0x66FE,
	16492: 0x62EF,
	16493: 0x70DD,
	16494: 0x7511,
	16495: 0x75C7,
	16496: 0x7E52,
	16497: 0x84B8,
	16498: 0x8B49,
	16499: 0x8D08,
	16500: 0x4E4B,
	16501: 0x53EA,
	16502: 0x54AB,
	16503: 0x5730,
	16504: 0x5740,
	16505: 0x5FD7,
	16506: 0x6301,
	16507: 0x6307,
	16508: 0x646F,
	16509: 0x652F,
	16510: 0x65E8,
	16511: 0x667A,
	16512: 0x679D,
	16513: 0x67B3,
	16514: 0x6B62,
	16515: 0x6C60,
	16516: 0x6C9A,
	16517: 0x6F2C,
	16518: 0x77E5,
	16519: 0x7825,
	16520: 0x7949,
	16521: 0x7957,
	16522: 0x7D19,
	16523: 0x80A2,
	16524: 0x8102,
	16525: 0x81F3,
	16526: 0x829D,
	16527: 0x82B7,
	16528: 0x8718,
	16529: 0x8A8C,
	16530: 0xF9FC,
	16531: 0x8D04,
	16532: 0x8DBE,
	16533: 0x9072,
	16534: 0x76F4,
	16535: 0x7A19,
	16536: 0x7A37,
	16537: 0x7E54,
	16538: 0x8077,
	16539: 0x5507,
	16540: 0x55D4,
	16541: 0x5875,
	16542: 0x632F,
	16543: 0x6422,
	16544: 0x6649,
	16545: 0x664B,
	16546: 0x686D,
	16547: 0x699B,
	16548: 0x6B84,
	16549: 0x6D25,
	16550: 0x6EB1,
	16551: 0x73CD,
	16552: 0x7468,
	16553: 0x74A1,
	16554: 0x755B,
	16555: 0x75B9,
	16556: 0x76E1,
	16557: 0x771E,
	16558: 0x778B,
	16559: 0x79E6,
	16560: 0x7E09,
	16561: 0x7E1D,
	16562: 0x81FB,
	16563: 0x852F,
	16564: 0x8897,
	16565: 0x8A3A,
	16566: 0x8CD1,
	16567: 0x8EEB,
	16568: 0x8FB0,
	16569: 0x9032,
	16570: 0x93AD,
	16571: 0x9663,
	16572: 0x9673,
	16573: 0x9707,
	16574: 0x4F84,
	16575: 0x53F1,
	16576: 0x59EA,
	16577: 0x5AC9,
	16578: 0x5E19,
	16579: 0x684E,
	16580: 0x74C6,
	16581: 0x75BE,
	16582: 0x79E9,
	16583: 0x7A92,
	16584: 0x81A3,
	16585: 0x86ED,
	16586: 0x8CEA,
	16587: 0x8DCC,
	16588: 0x8FED,
	16589: 0x659F,
	16590: 0x6715,
	16591: 0xF9FD,
	16592: 0x57F7,
	16593: 0x6F57,
	16594: 0x7DDD,
	16595: 0x8F2F,
	16596: 0x93F6,
	16597: 0x96C6,
	16598: 0x5FB5,
	16599: 0x61F2,
	16600: 0x6F84,
	16601: 0x4E14,
	16602: 0x4F98,
	16603: 0x501F,
	16604: 0x53C9,
	16605: 0x55DF,
	16606: 0x5D6F,
	16607: 0x5DEE,
	16608: 0x6B21,
	16609: 0x6B64,
	16610: 0x78CB,
	16611: 0x7B9A,
	16612: 0xF9FE,
	16613: 0x8E49,
	16614: 0x8ECA,
	16615: 0x906E,
	16616: 0x6349,
	16617: 0x643E,
	16618: 0x7740,
	16619: 0x7A84,
	16620: 0x932F,
	16621: 0x947F,
	16622: 0x9F6A,
	16623: 0x64B0,
	16624: 0x6FAF,
	16625: 0x71E6,
	16626: 0x74A8,
	16627: 0x74DA,
	16628: 0x7AC4,
	16629: 0x7C12,
	16630: 0x7E82,
	16631: 0x7CB2,
	16632: 0x7E98,
	16633: 0x8B9A,
	16634: 0x8D0A,
	16635: 0x947D,
	16636: 0x9910,
	16637: 0x994C,
	16638: 0x5239,
	16639: 0x5BDF,
	16640: 0x64E6,
	16641: 0x672D,
	16642: 0x7D2E,
	16643: 0x50ED,
	16644: 0x53C3,
	16645: 0x5879,
	16646: 0x6158,
	16647: 0x6159,
	16648: 0x61FA,
	16649: 0x65AC,
	16650: 0x7AD9,
	16651: 0x8B92,
	16652: 0x8B96,
	16653: 0x5009,
	16654: 0x5021,
	16655: 0x5275,
	16656: 0x5531,
	16657: 0x5A3C,
	16658: 0x5EE0,
	16659: 0x5F70,
	16660: 0x6134,
	16661: 0x655E,
	16662: 0x660C,
	16663: 0x6636,
	16664: 0x66A2,
	16665: 0x69CD,
	16666: 0x6EC4,
	16667: 0x6F32,
	16668: 0x7316,
	16669: 0x7621,
	16670: 0x7A93,
	16671: 0x8139,
	16672: 0x8259,
	16673: 0x83D6,
	16674: 0x84BC,
	16675: 0x50B5,
	16676: 0x57F0,
	16677: 0x5BC0,
	16678: 0x5BE8,
	16679: 0x5F69,
	16680: 0x63A1,
	16681: 0x7826,
	16682: 0x7DB5,
	16683: 0x83DC,
	16684: 0x8521,
	16685: 0x91C7,
	16686: 0x91F5,
	16687: 0x518A,
	16688: 0x67F5,
	16689: 0x7B56,
	16690: 0x8CAC,
	16691: 0x51C4,
	16692: 0x59BB,
	16693: 0x60BD,
	16694: 0x8655,
	16695: 0x501C,
	16696: 0xF9FF,
	16697: 0x5254,
	16698: 0x5C3A,
	16699: 0x617D,
	16700: 0x621A,
	16701: 0x62D3,
	16702: 0x64F2,
	16703: 0x65A5,
	16704: 0x6ECC,
	16705: 0x7620,
	16706: 0x810A,
	16707: 0x8E60,
	16708: 0x965F,
	16709: 0x96BB,
	16710: 0x4EDF,
	16711: 0x5343,
	16712: 0x5598,
	16713: 0x5929,
	16714: 0x5DDD,
	16715: 0x64C5,
	16716: 0x6CC9,
	16717: 0x6DFA,
	16718: 0x7394,
	16719: 0x7A7F,
	16720: 0x821B,
	16721: 0x85A6,
	16722: 0x8CE4,
	16723: 0x8E10,
	16724: 0x9077,
	16725: 0x91E7,
	16726: 0x95E1,
	16727: 0x9621,
	16728: 0x97C6,
	16729: 0x51F8,
	16730: 0x54F2,
	16731: 0x5586,
	16732: 0x5FB9,
	16733: 0x64A4,
	16734: 0x6F88,
	16735: 0x7DB4,
	16736: 0x8F1F,
	16737: 0x8F4D,
	16738: 0x9435,
	16739: 0x50C9,
	16740: 0x5C16,
	16741: 0x6CBE,
	16742: 0x6DFB,
	16743: 0x751B,
	16744: 0x77BB,
	16745: 0x7C3D,
	16746: 0x7C64,
	16747: 0x8A79,
	16748: 0x8AC2,
	16749: 0x581E,
	16750: 0x59BE,
	16751: 0x5E16,
	16752: 0x6377,
	16753: 0x7252,
	16754: 0x758A,
	16755: 0x776B,
	16756: 0x8ADC,
	16757: 0x8CBC,
	16758: 0x8F12,
	16759: 0x5EF3,
	16760: 0x6674,
	16761: 0x6DF8,
	16762: 0x807D,
	16763: 0x83C1,
	16764: 0x8ACB,
	16765: 0x9751,
	16766: 0x9BD6,
	16767: 0xFA00,
	16768: 0x5243,
	16769: 0x66FF,
	16770: 0x6D95,
	16771: 0x6EEF,
	16772: 0x7DE0,
	16773: 0x8AE6,
	16774: 0x902E,
	16775: 0x905E,
	16776: 0x9AD4,
	16777: 0x521D,
	16778: 0x527F,
	16779: 0x54E8,
	16780: 0x6194,
	16781: 0x6284,
	16782: 0x62DB,
	16783: 0x68A2,
	16784: 0x6912,
	16785: 0x695A,
	16786: 0x6A35,
	16787: 0x7092,
	16788: 0x7126,
	16789: 0x785D,
	16790: 0x7901,
	16791: 0x790E,
	16792: 0x79D2,
	16793: 0x7A0D,
	16794: 0x8096,
	16795: 0x8278,
	16796: 0x82D5,
	16797: 0x8349,
	16798: 0x8549,
	16799: 0x8C82,
	16800: 0x8D85,
	16801: 0x9162,
	16802: 0x918B,
	16803: 0x91AE,
	16804: 0x4FC3,
	16805: 0x56D1,
	16806: 0x71ED,
	16807: 0x77D7,
	16808: 0x8700,
	16809: 0x89F8,
	16810: 0x5BF8,
	16811: 0x5FD6,
	16812: 0x6751,
	16813: 0x90A8,
	16814: 0x53E2,
	16815: 0x585A,
	16816: 0x5BF5,
	16817: 0x60A4,
	16818: 0x6181,
	16819: 0x6460,
	16820: 0x7E3D,
	16821: 0x8070,
	16822: 0x8525,
	16823: 0x9283,
	16824: 0x64AE,
	16825: 0x50AC,
	16826: 0x5D14,
	16827: 0x6700,
	16828: 0x589C,
	16829: 0x62BD,
	16830: 0x63A8,
	16831: 0x690E,
	16832: 0x6978,
	16833: 0x6A1E,
	16834: 0x6E6B,
	16835: 0x76BA,
	16836: 0x79CB,
	16837: 0x82BB,
	16838: 0x8429,
	16839: 0x8ACF,
	16840: 0x8DA8,
	16841: 0x8FFD,
	16842: 0x9112,
	16843: 0x914B,
	16844: 0x919C,
	16845: 0x9310,
	16846: 0x9318,
	16847: 0x939A,
	16848: 0x96DB,
	16849: 0x9A36,
	16850: 0x9C0D,
	16851: 0x4E11,
	16852: 0x755C,
	16853: 0x795D,
	16854: 0x7AFA,
	16855: 0x7B51,
	16856: 0x7BC9,
	16857: 0x7E2E,
	16858: 0x84C4,
	16859: 0x8E59,
	16860: 0x8E74,
	16861: 0x8EF8,
	16862: 0x9010,
	16863: 0x6625,
	16864: 0x693F,
	16865: 0x7443,
	16866: 0x51FA,
	16867: 0x672E,
	16868: 0x9EDC,
	16869: 0x5145,
	16870: 0x5FE0,
	16871: 0x6C96,
	16872: 0x87F2,
	16873: 0x885D,
	16874: 0x8877,
	16875: 0x60B4,
	16876: 0x81B5,
	16877: 0x8403,
	16878: 0x8D05,
	16879: 0x53D6,
	16880: 0x5439,
	16881: 0x5634,
	16882: 0x5A36,
	16883: 0x5C31,
	16884: 0x708A,
	16885: 0x7FE0,
	16886: 0x805A,
	16887: 0x8106,
	16888: 0x81ED,
	16889: 0x8DA3,
	16890: 0x9189,
	16891: 0x9A5F,
	16892: 0x9DF2,
	16893: 0x5074,
	16894: 0x4EC4,
	16895: 0x53A0,
	16896: 0x60FB,
	16897: 0x6E2C,
	16898: 0x5C64,
	16899: 0x4F88,
	16900: 0x5024,
	16901: 0x55E4,
	16902: 0x5CD9,
	16903: 0x5E5F,
	16904: 0x6065,
	16905: 0x6894,
	16906: 0x6CBB,
	16907: 0x6DC4,
	16908: 0x71BE,
	16909: 0x75D4,
	16910: 0x75F4,
	16911: 0x7661,
	16912: 0x7A1A,
	16913: 0x7A49,
	16914: 0x7DC7,
	16915: 0x7DFB,
	16916: 0x7F6E,
	16917: 0x81F4,
	16918: 0x86A9,
	16919: 0x8F1C,
	16920: 0x96C9,
	16921: 0x99B3,
	16922: 0x9F52,
	16923: 0x5247,
	16924: 0x52C5,
	16925: 0x98ED,
	16926: 0x89AA,
	16927: 0x4E03,
	16928: 0x67D2,
	16929: 0x6F06,
	16930: 0x4FB5,
	16931: 0x5BE2,
	16932: 0x6795,
	16933: 0x6C88,
	16934: 0x6D78,
	16935: 0x741B,
	16936: 0x7827,
	16937: 0x91DD,
	16938: 0x937C,
	16939: 0x87C4,
	16940: 0x79E4,
	16941: 0x7A31,
	16942: 0x5FEB,
	16943: 0x4ED6,
	16944: 0x54A4,
	16945: 0x553E,
	16946: 0x58AE,
	16947: 0x59A5,
	16948: 0x60F0,
	16949: 0x6253,
	16950: 0x62D6,
	16951: 0x6736,
	16952: 0x6955,
	16953: 0x8235,
	16954: 0x9640,
	16955: 0x99B1,
	16956: 0x99DD,
	16957: 0x502C,
	16958: 0x5353,
	16959: 0x5544,
	16960: 0x577C,
	16961: 0xFA01,
	16962: 0x6258,
	16963: 0xFA02,
	16964: 0x64E2,
	16965: 0x666B,
	16966: 0x67DD,
	16967: 0x6FC1,
	16968: 0x6FEF,
	16969: 0x7422,
	16970: 0x7438,
	16971: 0x8A17,
	16972: 0x9438,
	16973: 0x5451,
	16974: 0x5606,
	16975: 0x5766,
	16976: 0x5F48,
	16977: 0x619A,
	16978: 0x6B4E,
	16979: 0x7058,
	16980: 0x70AD,
	16981: 0x7DBB,
	16982: 0x8A95,
	16983: 0x596A,
	16984: 0x812B,
	16985: 0x63A2,
	16986: 0x7708,
	16987: 0x803D,
	16988: 0x8CAA,
	16989: 0x5854,
	16990: 0x642D,
	16991: 0x69BB,
	16992: 0x5B95,
	16993: 0x5E11,
	16994: 0x6E6F,
	16995: 0xFA03,
	16996: 0x8569,
	16997: 0x514C,
	16998: 0x53F0,
	16999: 0x592A,
	17000: 0x6020,
	17001: 0x614B,
	17002: 0x6B86,
	17003: 0x6C70,
	17004: 0x6CF0,
	17005: 0x7B1E,
	17006: 0x80CE,
	17007: 0x82D4,
	17008: 0x8DC6,
	17009: 0x90B0,
	17010: 0x98B1,
	17011: 0xFA04,
	17012: 0x64C7,
	17013: 0x6FA4,
	17014: 0x6491,
	17015: 0x6504,
	17016: 0x514E,
	17017: 0x5410,
	17018: 0x571F,
	17019: 0x8A0E,
	17020: 0x615F,
	17021: 0x6876,
	17022: 0xFA05,
	17023: 0x75DB,
	17024: 0x7B52,
	17025: 0x7D71,
	17026: 0x901A,
	17027: 0x5806,
	17028: 0x69CC,
	17029: 0x817F,
	17030: 0x892A,
	17031: 0x9000,
	17032: 0x9839,
	17033: 0x5078,
	17034: 0x5957,
	17035: 0x59AC,
	17036: 0x6295,
	17037: 0x900F,
	17038: 0x9B2A,
	17039: 0x615D,
	17040: 0x7279,
	17041: 0x95D6,
	17042: 0x5761,
	17043: 0x5A46,
	17044: 0x5DF4,
	17045: 0x628A,
	17046: 0x64AD,
	17047: 0x64FA,
	17048: 0x6777,
	17049: 0x6CE2,
	17050: 0x6D3E,
	17051: 0x722C,
	17052: 0x7436,
	17053: 0x7834,
	17054: 0x7F77,
	17055: 0x82AD,
	17056: 0x8DDB,
	17057: 0x9817,
	17058: 0x5224,
	17059: 0x5742,
	17060: 0x677F,
	17061: 0x7248,
	17062: 0x74E3,
	17063: 0x8CA9,
	17064: 0x8FA6,
	17065: 0x9211,
	17066: 0x962A,
	17067: 0x516B,
	17068: 0x53ED,
	17069: 0x634C,
	17070: 0x4F69,
	17071: 0x5504,
	17072: 0x6096,
	17073: 0x6557,
	17074: 0x6C9B,
	17075: 0x6D7F,
	17076: 0x724C,
	17077: 0x72FD,
	17078: 0x7A17,
	17079: 0x8987,
	17080: 0x8C9D,
	17081: 0x5F6D,
	17082: 0x6F8E,
	17083: 0x70F9,
	17084: 0x81A8,
	17085: 0x610E,
	17086: 0x4FBF,
	17087: 0x504F,
	17088: 0x6241,
	17089: 0x7247,
	17090: 0x7BC7,
	17091: 0x7DE8,
	17092: 0x7FE9,
	17093: 0x904D,
	17094: 0x97AD,
	17095: 0x9A19,
	17096: 0x8CB6,
	17097: 0x576A,
	17098: 0x5E73,
	17099: 0x67B0,
	17100: 0x840D,
	17101: 0x8A55,
	17102: 0x5420,
	17103: 0x5B16,
	17104: 0x5E63,
	17105: 0x5EE2,
	17106: 0x5F0A,
	17107: 0x6583,
	17108: 0x80BA,
	17109: 0x853D,
	17110: 0x9589,
	17111: 0x965B,
	17112: 0x4F48,
	17113: 0x5305,
	17114: 0x530D,
	17115: 0x530F,
	17116: 0x5486,
	17117: 0x54FA,
	17118: 0x5703,
	17119: 0x5E03,
	17120: 0x6016,
	17121: 0x629B,
	17122: 0x62B1,
	17123: 0x6355,
	17124: 0xFA06,
	17125: 0x6CE1,
	17126: 0x6D66,
	17127: 0x75B1,
	17128: 0x7832,
	17129: 0x80DE,
	17130: 0x812F,
	17131: 0x82DE,
	17132: 0x8461,
	17133: 0x84B2,
	17134: 0x888D,
	17135: 0x8912,
	17136: 0x900B,
	17137: 0x92EA,
	17138: 0x98FD,
	17139: 0x9B91,
	17140: 0x5E45,
	17141: 0x66B4,
	17142: 0x66DD,
	17143: 0x7011,
	17144: 0x7206,
	17145: 0xFA07,
	17146: 0x4FF5,
	17147: 0x527D,
	17148: 0x5F6A,
	17149: 0x6153,
	17150: 0x6753,
	17151: 0x6A19,
	17152: 0x6F02,
	17153: 0x74E2,
	17154: 0x7968,
	17155: 0x8868,
	17156: 0x8C79,
	17157: 0x98C7,
	17158: 0x98C4,
	17159: 0x9A43,
	17160: 0x54C1,
	17161: 0x7A1F,
	17162: 0x6953,
	17163: 0x8AF7,
	17164: 0x8C4A,
	17165: 0x98A8,
	17166: 0x99AE,
	17167: 0x5F7C,
	17168: 0x62AB,
	17169: 0x75B2,
	17170: 0x76AE,
	17171: 0x88AB,
	17172: 0x907F,
	17173: 0x9642,
	17174: 0x5339,
	17175: 0x5F3C,
	17176: 0x5FC5,
	17177: 0x6CCC,
	17178: 0x73CC,
	17179: 0x7562,
	17180: 0x758B,
	17181: 0x7B46,
	17182: 0x82FE,
	17183: 0x999D,
	17184: 0x4E4F,
	17185: 0x903C,
	17186: 0x4E0B,
	17187: 0x4F55,
	17188: 0x53A6,
	17189: 0x590F,
	17190: 0x5EC8,
	17191: 0x6630,
	17192: 0x6CB3,
	17193: 0x7455,
	17194: 0x8377,
	17195: 0x8766,
	17196: 0x8CC0,
	17197: 0x9050,
	17198: 0x971E,
	17199: 0x9C15,
	17200: 0x58D1,
	17201: 0x5B78,
	17202: 0x8650,
	17203: 0x8B14,
	17204: 0x9DB4,
	17205: 0x5BD2,
	17206: 0x6068,
	17207: 0x608D,
	17208: 0x65F1,
	17209: 0x6C57,
	17210: 0x6F22,
	17211: 0x6FA3,
	17212: 0x701A,
	17213: 0x7F55,
	17214: 0x7FF0,
	17215: 0x9591,
	17216: 0x9592,
	17217: 0x9650,
	17218: 0x97D3,
	17219: 0x5272,
	17220: 0x8F44,
	17221: 0x51FD,
	17222: 0x542B,
	17223: 0x54B8,
	17224: 0x5563,
	17225: 0x558A,
	17226: 0x6ABB,
	17227: 0x6DB5,
	17228: 0x7DD8,
	17229: 0x8266,
	17230: 0x929C,
	17231: 0x9677,
	17232: 0x9E79,
	17233: 0x5408,
	17234: 0x54C8,
	17235: 0x76D2,
	17236: 0x86E4,
	17237: 0x95A4,
	17238: 0x95D4,
	17239: 0x965C,
	17240: 0x4EA2,
	17241: 0x4F09,
	17242: 0x59EE,
	17243: 0x5AE6,
	17244: 0x5DF7,
	17245: 0x6052,
	17246: 0x6297,
	17247: 0x676D,
	17248: 0x6841,
	17249: 0x6C86,
	17250: 0x6E2F,
	17251: 0x7F38,
	17252: 0x809B,
	17253: 0x822A,
	17254: 0xFA08,
	17255: 0xFA09,
	17256: 0x9805,
	17257: 0x4EA5,
	17258: 0x5055,
	17259: 0x54B3,
	17260: 0x5793,
	17261: 0x595A,
	17262: 0x5B69,
	17263: 0x5BB3,
	17264: 0x61C8,
	17265: 0x6977,
	17266: 0x6D77,
	17267: 0x7023,
	17268: 0x87F9,
	17269: 0x89E3,
	17270: 0x8A72,
	17271: 0x8AE7,
	17272: 0x9082,
	17273: 0x99ED,
	17274: 0x9AB8,
	17275: 0x52BE,
	17276: 0x6838,
	17277: 0x5016,
	17278: 0x5E78,
	17279: 0x674F,
	17280: 0x8347,
	17281: 0x884C,
	17282: 0x4EAB,
	17283: 0x5411,
	17284: 0x56AE,
	17285: 0x73E6,
	17286: 0x9115,
	17287: 0x97FF,
	17288: 0x9909,
	17289: 0x9957,
	17290: 0x9999,
	17291: 0x5653,
	17292: 0x589F,
	17293: 0x865B,
	17294: 0x8A31,
	17295: 0x61B2,
	17296: 0x6AF6,
	17297: 0x737B,
	17298: 0x8ED2,
	17299: 0x6B47,
	17300: 0x96AA,
	17301: 0x9A57,
	17302: 0x5955,
	17303: 0x7200,
	17304: 0x8D6B,
	17305: 0x9769,
	17306: 0x4FD4,
	17307: 0x5CF4,
	17308: 0x5F26,
	17309: 0x61F8,
	17310: 0x665B,
	17311: 0x6CEB,
	17312: 0x70AB,
	17313: 0x7384,
	17314: 0x73B9,
	17315: 0x73FE,
	17316: 0x7729,
	17317: 0x774D,
	17318: 0x7D43,
	17319: 0x7D62,
	17320: 0x7E23,
	17321: 0x8237,
	17322: 0x8852,
	17323: 0xFA0A,
	17324: 0x8CE2,
	17325: 0x9249,
	17326: 0x986F,
	17327: 0x5B51,
	17328: 0x7A74,
	17329: 0x8840,
	17330: 0x9801,
	17331: 0x5ACC,
	17332: 0x4FE0,
	17333: 0x5354,
	17334: 0x593E,
	17335: 0x5CFD,
	17336: 0x633E,
	17337: 0x6D79,
	17338: 0x72F9,
	17339: 0x8105,
	17340: 0x8107,
	17341: 0x83A2,
	17342: 0x92CF,
	17343: 0x9830,
	17344: 0x4EA8,
	17345: 0x5144,
	17346: 0x5211,
	17347: 0x578B,
	17348: 0x5F62,
	17349: 0x6CC2,
	17350: 0x6ECE,
	17351: 0x7005,
	17352: 0x7050,
	17353: 0x70AF,
	17354: 0x7192,
	17355: 0x73E9,
	17356: 0x7469,
	17357: 0x834A,
	17358: 0x87A2,
	17359: 0x8861,
	17360: 0x9008,
	17361: 0x90A2,
	17362: 0x93A3,
	17363: 0x99A8,
	17364: 0x516E,
	17365: 0x5F57,
	17366: 0x60E0,
	17367: 0x6167,
	17368: 0x66B3,
	17369: 0x8559,
	17370: 0x8E4A,
	17371: 0x91AF,
	17372: 0x978B,
	17373: 0x4E4E,
	17374: 0x4E92,
	17375: 0x547C,
	17376: 0x58D5,
	17377: 0x58FA,
	17378: 0x597D,
	17379: 0x5CB5,
	17380: 0x5F27,
	17381: 0x6236,
	17382: 0x6248,
	17383: 0x660A,
	17384: 0x6667,
	17385: 0x6BEB,
	17386: 0x6D69,
	17387: 0x6DCF,
	17388: 0x6E56,
	17389: 0x6EF8,
	17390: 0x6F94,
	17391: 0x6FE0,
	17392: 0x6FE9,
	17393: 0x705D,
	17394: 0x72D0,
	17395: 0x7425,
	17396: 0x745A,
	17397: 0x74E0,
	17398: 0x7693,
	17399: 0x795C,
	17400: 0x7CCA,
	17401: 0x7E1E,
	17402: 0x80E1,
	17403: 0x82A6,
	17404: 0x846B,
	17405: 0x84BF,
	17406: 0x864E,
	17407: 0x865F,
	17408: 0x8774,
	17409: 0x8B77,
	17410: 0x8C6A,
	17411: 0x93AC,
	17412: 0x9800,
	17413: 0x9865,
	17414: 0x60D1,
	17415: 0x6216,
	17416: 0x9177,
	17417: 0x5A5A,
	17418: 0x660F,
	17419: 0x6DF7,
	17420: 0x6E3E,
	17421: 0x743F,
	17422: 0x9B42,
	17423: 0x5FFD,
	17424: 0x60DA,
	17425: 0x7B0F,
	17426: 0x54C4,
	17427: 0x5F18,
	17428: 0x6C5E,
	17429: 0x6CD3,
	17430: 0x6D2A,
	17431: 0x70D8,
	17432: 0x7D05,
	17433: 0x8679,
	17434: 0x8A0C,
	17435: 0x9D3B,
	17436: 0x5316,
	17437: 0x548C,
	17438: 0x5B05,
	17439: 0x6A3A,
	17440: 0x706B,
	17441: 0x7575,
	17442: 0x798D,
	17443: 0x79BE,
	17444: 0x82B1,
	17445: 0x83EF,
	17446: 0x8A71,
	17447: 0x8B41,
	17448: 0x8CA8,
	17449: 0x9774,
	17450: 0xFA0B,
	17451: 0x64F4,
	17452: 0x652B,
	17453: 0x78BA,
	17454: 0x78BB,
	17455: 0x7A6B,
	17456: 0x4E38,
	17457: 0x559A,
	17458: 0x5950,
	17459: 0x5BA6,
	17460: 0x5E7B,
	17461: 0x60A3,
	17462: 0x63DB,
	17463: 0x6B61,
	17464: 0x6665,
	17465: 0x6853,
	17466: 0x6E19,
	17467: 0x7165,
	17468: 0x74B0,
	17469: 0x7D08,
	17470: 0x9084,
	17471: 0x9A69,
	17472: 0x9C25,
	17473: 0x6D3B,
	17474: 0x6ED1,
	17475: 0x733E,
	17476: 0x8C41,
	17477: 0x95CA,
	17478: 0x51F0,
	17479: 0x5E4C,
	17480: 0x5FA8,
	17481: 0x604D,
	17482: 0x60F6,
	17483: 0x6130,
	17484: 0x614C,
	17485: 0x6643,
	17486: 0x6644,
	17487: 0x69A5,
	17488: 0x6CC1,
	17489: 0x6E5F,
	17490: 0x6EC9,
	17491: 0x6F62,
	17492: 0x714C,
	17493: 0x749C,
	17494: 0x7687,
	17495: 0x7BC1,
	17496: 0x7C27,
	17497: 0x8352,
	17498: 0x8757,
	17499: 0x9051,
	17500: 0x968D,
	17501: 0x9EC3,
	17502: 0x532F,
	17503: 0x56DE,
	17504: 0x5EFB,
	17505: 0x5F8A,
	17506: 0x6062,
	17507: 0x6094,
	17508: 0x61F7,
	17509: 0x6666,
	17510: 0x6703,
	17511: 0x6A9C,
	17512: 0x6DEE,
	17513: 0x6FAE,
	17514: 0x7070,
	17515: 0x736A,
	17516: 0x7E6A,
	17517: 0x81BE,
	17518: 0x8334,
	17519: 0x86D4,
	17520: 0x8AA8,
	17521: 0x8CC4,
	17522: 0x5283,
	17523: 0x7372,
	17524: 0x5B96,
	17525: 0x6A6B,
	17526: 0x9404,
	17527: 0x54EE,
	17528: 0x5686,
	17529: 0x5B5D,
	17530: 0x6548,
	17531: 0x6585,
	17532: 0x66C9,
	17533: 0x689F,
	17534: 0x6D8D,
	17535: 0x6DC6,
	17536: 0x723B,
	17537: 0x80B4,
	17538: 0x9175,
	17539: 0x9A4D,
	17540: 0x4FAF,
	17541: 0x5019,
	17542: 0x539A,
	17543: 0x540E,
	17544: 0x543C,
	17545: 0x5589,
	17546: 0x55C5,
	17547: 0x5E3F,
	17548: 0x5F8C,
	17549: 0x673D,
	17550: 0x7166,
	17551: 0x73DD,
	17552: 0x9005,
	17553: 0x52DB,
	17554: 0x52F3,
	17555: 0x5864,
	17556: 0x58CE,
	17557: 0x7104,
	17558: 0x718F,
	17559: 0x71FB,
	17560: 0x85B0,
	17561: 0x8A13,
	17562: 0x6688,
	17563: 0x85A8,
	17564: 0x55A7,
	17565: 0x6684,
	17566: 0x714A,
	17567: 0x8431,
	17568: 0x5349,
	17569: 0x5599,
	17570: 0x6BC1,
	17571: 0x5F59,
	17572: 0x5FBD,
	17573: 0x63EE,
	17574: 0x6689,
	17575: 0x7147,
	17576: 0x8AF1,
	17577: 0x8F1D,
	17578: 0x9EBE,
	17579: 0x4F11,
	17580: 0x643A,
	17581: 0x70CB,
	17582: 0x7566,
	17583: 0x8667,
	17584: 0x6064,
	17585: 0x8B4E,
	17586: 0x9DF8,
	17587: 0x5147,
	17588: 0x51F6,
	17589: 0x5308,
	17590: 0x6D36,
	17591: 0x80F8,
	17592: 0x9ED1,
	17593: 0x6615,
	17594: 0x6B23,
	17595: 0x7098,
	17596: 0x75D5,
	17597: 0x5403,
	17598: 0x5C79,
	17599: 0x7D07,
	17600: 0x8A16,
	17601: 0x6B20,
	17602: 0x6B3D,
	17603: 0x6B46,
	17604: 0x5438,
	17605: 0x6070,
	17606: 0x6D3D,
	17607: 0x7FD5,
	17608: 0x8208,
	17609: 0x50D6,
	17610: 0x51DE,
	17611: 0x559C,
	17612: 0x566B,
	17613: 0x56CD,
	17614: 0x59EC,
	17615: 0x5B09,
	17616: 0x5E0C,
	17617: 0x6199,
	17618: 0x6198,
	17619: 0x6231,
	17620: 0x665E,
	17621: 0x66E6,
	17622: 0x7199,
	17623: 0x71B9,
	17624: 0x71BA,
	17625: 0x72A7,
	17626: 0x79A7,
	17627: 0x7A00,
	17628: 0x7FB2,
	17629: 0x8A70,
}

const numEncodeTables = 7

// encodeX are the encoding tables from Unicode to EUC-KR code,
// sorted by decreasing length.
// encode0: 20893 entries for runes in [19968, 40861).
// encode1: 11172 entries for runes in [44032, 55204).
// encode2:  1625 entries for runes in [ 8213,  9838).
// encode3:   990 entries for runes in [12288, 13278).
// encode4:   945 entries for runes in [  161,  1106).
// encode5:   268 entries for runes in [63744, 64012).
// encode6:   230 entries for runes in [65281, 65511).

const encode0Low, encode0High = 19968, 40861

var encode0 = [...]uint16{
	19968 - 19968: 0xECE9,
	19969 - 19968: 0xEFCB,
	19971 - 19968: 0xF6D2,
	19975 - 19968: 0xD8B2,
	19976 - 19968: 0xEDDB,
	19977 - 19968: 0xDFB2,
	19978 - 19968: 0xDFBE,
	19979 - 19968: 0xF9BB,
	19981 - 19968: 0xDCF4,
	19985 - 19968: 0xF5E4,
	19988 - 19968: 0xF3A6,
	19989 - 19968: 0xDDE0,
	19990 - 19968: 0xE1A6,
	19992 - 19968: 0xCEF8,
	19993 - 19968: 0xDCB0,
	19998 - 19968: 0xE3AA,
	20013 - 19968: 0xF1E9,
	20018 - 19968: 0xCDFA,
	20024 - 19968: 0xFCAF,
	20025 - 19968: 0xD3A1,
	20027 - 19968: 0xF1AB,
	20034 - 19968: 0xE7D1,
	20035 - 19968: 0xD2AC,
	20037 - 19968: 0xCEF9,
	20043 - 19968: 0xF1FD,
	20045 - 19968: 0xDEBF,
	20046 - 19968: 0xFBBA,
	20047 - 19968: 0xF9B9,
	20054 - 19968: 0xCED2,
	20056 - 19968: 0xE3AB,
	20057 - 19968: 0xEBE0,
	20061 - 19968: 0xCEFA,
	20062 - 19968: 0xCBF7,
	20063 - 19968: 0xE5A5,
	20075 - 19968: 0xCAE1,
	20077 - 19968: 0xD4CC,
	20083 - 19968: 0xEAE1,
	20086 - 19968: 0xDCE3,
	20087 - 19968: 0xDFAD,
	20094 - 19968: 0xCBEB,
	20098 - 19968: 0xD5AF,
	20102 - 19968: 0xD6F5,
	20104 - 19968: 0xE5F8,
	20107 - 19968: 0xDEC0,
	20108 - 19968: 0xECA3,
	20110 - 19968: 0xE9CD,
	20112 - 19968: 0xEAA7,
	20113 - 19968: 0xE9F6,
	20114 - 19968: 0xFBBB,
	20116 - 19968: 0xE7E9,
	20117 - 19968: 0xEFCC,
	20120 - 19968: 0xD0E6,
	20123 - 19968: 0xDEC1,
	20126 - 19968: 0xE4AC,
	20129 - 19968: 0xD8CC,
	20130 - 19968: 0xF9F1,
	20132 - 19968: 0xCEDF,
	20133 - 19968: 0xFAA4,
	20134 - 19968: 0xE6B2,
	20136 - 19968: 0xFAFB,
	20139 - 19968: 0xFABD,
	20140 - 19968: 0xCCC8,
	20141 - 19968: 0xEFCD,
	20142 - 19968: 0xD5D5,
	20150 - 19968: 0xD3A2,
	20154 - 19968: 0xECD1,
	20160 - 19968: 0xE4A7,
	20161 - 19968: 0xECD2,
	20164 - 19968: 0xF6B1,
	20167 - 19968: 0xCEFB,
	20170 - 19968: 0xD0D1,
	20171 - 19968: 0xCBBF,
	20173 - 19968: 0xEDA4,
	20180 - 19968: 0xEDA8,
	20181 - 19968: 0xDEC2,
	20182 - 19968: 0xF6E2,
	20183 - 19968: 0xEDDC,
	20184 - 19968: 0xDCF5,
	20185 - 19968: 0xE0B9,
	20189 - 19968: 0xD4CE,
	20191 - 19968: 0xF4B5,
	20195 - 19968: 0xD3DB,
	20196 - 19968: 0xD6B5,
	20197 - 19968: 0xECA4,
	20208 - 19968: 0xE4E6,
	20210 - 19968: 0xF1EA,
	20214 - 19968: 0xCBEC,
	20215 - 19968: 0xCBC0,
	20219 - 19968: 0xECF2,
	20225 - 19968: 0xD0EA,
	20233 - 19968: 0xF9F2,
	20234 - 19968: 0xECA5,
	20235 - 19968: 0xD0DF,
	20237 - 19968: 0xE7EA,
	20238 - 19968: 0xD0EB,
	20239 - 19968: 0xDCD1,
	20240 - 19968: 0xDBE9,
	20241 - 19968: 0xFDCC,
	20271 - 19968: 0xDBD7,
	20276 - 19968: 0xDAE1,
	20278 - 19968: 0xD6B6,
	20280 - 19968: 0xE3DF,
	20282 - 19968: 0xDEC3,
	20284 - 19968: 0xDEC4,
	20285 - 19968: 0xCAA1,
	20291 - 19968: 0xEEEC,
	20294 - 19968: 0xD3A3,
	20295 - 19968: 0xEEB7,
	20296 - 19968: 0xF8CF,
	20301 - 19968: 0xEAC8,
	20302 - 19968: 0xEEB8,
	20303 - 19968: 0xF1AC,
	20304 - 19968: 0xF1A5,
	20305 - 19968: 0xE9CE,
	20309 - 19968: 0xF9BC,
	20313 - 19968: 0xE5F9,
	20314 - 19968: 0xECEA,
	20315 - 19968: 0xDDD6,
	20316 - 19968: 0xEDC2,
	20329 - 19968: 0xF8A5,
	20335 - 19968: 0xE5BA,
	20336 - 19968: 0xDBD8,
	20339 - 19968: 0xCAA2,
	20342 - 19968: 0xD1CD,
	20346 - 19968: 0xEEED,
	20350 - 19968: 0xECEB,
	20351 - 19968: 0xDEC5,
	20353 - 19968: 0xE3E0,
	20355 - 19968: 0xCAC9,
	20356 - 19968: 0xF2E9,
	20358 - 19968: 0xD5CE,
	20360 - 19968: 0xF6B6,
	20362 - 19968: 0xCEC2,
	20363 - 19968: 0xD6C7,
	20365 - 19968: 0xE3B4,
	20367 - 19968: 0xF1AD,
	20369 - 19968: 0xEAE2,
	20374 - 19968: 0xD7C2,
	20376 - 19968: 0xF3A7,
	20379 - 19968: 0xCDEA,
	20381 - 19968: 0xEBEE,
	20398 - 19968: 0xD9B2,
	20399 - 19968: 0xFDA5,
	20405 - 19968: 0xF6D5,
	20406 - 19968: 0xD5E2,
	20415 - 19968: 0xF8B5,
	20418 - 19968: 0xCCF5,
	20419 - 19968: 0xF5B5,
	20420 - 19968: 0xE4AD,
	20425 - 19968: 0xE7EB,
	20426 - 19968: 0xF1D5,
	20430 - 19968: 0xF0BB,
	20433 - 19968: 0xE9B5,
	20435 - 19968: 0xCCC9,
	20436 - 19968: 0xFAD5,
	20439 - 19968: 0xE1D4,
	20442 - 19968: 0xD7D6,
	20445 - 19968: 0xDCC1,
	20447 - 19968: 0xDEC6,
	20448 - 19968: 0xFAEF,
	20449 - 19968: 0xE3E1,
	20462 - 19968: 0xE1F3,
	20463 - 19968: 0xDCF6,
	20465 - 19968: 0xCEFC,
	20467 - 19968: 0xDBC4,
	20469 - 19968: 0xF8F1,
	20472 - 19968: 0xDCE4,
	20474 - 19968: 0xE5EF,
	20482 - 19968: 0xDCB1,
	20486 - 19968: 0xD5D6,
	20489 - 19968: 0xF3DA,
	20491 - 19968: 0xCBC1,
	20493 - 19968: 0xDBC3,
	20497 - 19968: 0xD9FA,
	20498 - 19968: 0xD3EE,
	20502 - 19968: 0xFAB8,
	20505 - 19968: 0xFDA6,
	20506 - 19968: 0xEBEF,
	20508 - 19968: 0xF4A6,
	20510 - 19968: 0xCCCA,
	20511 - 19968: 0xF3A8,
	20513 - 19968: 0xF3DB,
	20515 - 19968: 0xDBA7,
	20516 - 19968: 0xF6B7,
	20518 - 19968: 0xCFE6,
	20519 - 19968: 0xF0F2,
	20520 - 19968: 0xCBDA,
	20522 - 19968: 0xE7D2,
	20523 - 19968: 0xD7C3,
	20524 - 19968: 0xF6F0,
	20525 - 19968: 0xE8DE,
	20539 - 19968: 0xE5A6,
	20547 - 19968: 0xE5E7,
	20551 - 19968: 0xCAA3,
	20552 - 19968: 0xCCA7,
	20553 - 19968: 0xEAC9,
	20559 - 19968: 0xF8B6,
	20565 - 19968: 0xFAA5,
	20570 - 19968: 0xF1AE,
	20572 - 19968: 0xEFCE,
	20581 - 19968: 0xCBED,
	20596 - 19968: 0xF6B0,
	20597 - 19968: 0xEFCF,
	20598 - 19968: 0xE9CF,
	20600 - 19968: 0xF7DE,
	20608 - 19968: 0xCED3,
	20613 - 19968: 0xDCF7,
	20621 - 19968: 0xDBA8,
	20625 - 19968: 0xCBF8,
	20632 - 19968: 0xDFA1,
	20633 - 19968: 0xDDE1,
	20652 - 19968: 0xF5CA,
	20653 - 19968: 0xE9B6,
	20658 - 19968: 0xE7EC,
	20659 - 19968: 0xEEEE,
	20661 - 19968: 0xF3F0,
	20663 - 19968: 0xDFBF,
	20670 - 19968: 0xCCCB,
	20677 - 19968: 0xD0C1,
	20681 - 19968: 0xF4D2,
	20682 - 19968: 0xE0BA,
	20687 - 19968: 0xDFC0,
	20689 - 19968: 0xCEE0,
	20693 - 19968: 0xDCD2,
	20694 - 19968: 0xFDEA,
	20698 - 19968: 0xD6F6,
	20702 - 19968: 0xEACA,
	20709 - 19968: 0xE8E9,
	20711 - 19968: 0xE3AC,
	20717 - 19968: 0xF3D0,
	20729 - 19968: 0xCAA4,
	20731 - 19968: 0xDBF8,
	20735 - 19968: 0xDEC7,
	20736 - 19968: 0xEBF0,
	20737 - 19968: 0xF1D6,
	20740 - 19968: 0xE5E2,
	20742 - 19968: 0xCCCC,
	20745 - 19968: 0xCBFB,
	20754 - 19968: 0xEAE3,
	20767 - 19968: 0xDFC1,
	20769 - 19968: 0xD6ED,
	20778 - 19968: 0xE9D0,
	20786 - 19968: 0xEEB9,
	20791 - 19968: 0xD5E3,
	20794 - 19968: 0xD1D3,
	20796 - 19968: 0xE5F0,
	20800 - 19968: 0xE8B4,
	20801 - 19968: 0xEBC3,
	20803 - 19968: 0xEAAA,
	20804 - 19968: 0xFAFC,
	20805 - 19968: 0xF5F6,
	20806 - 19968: 0xF0BC,
	20807 - 19968: 0xFDD4,
	20808 - 19968: 0xE0BB,
	20809 - 19968: 0xCEC3,
	20811 - 19968: 0xD0BA,
	20812 - 19968: 0xF7BA,
	20813 - 19968: 0xD8F3,
	20814 - 19968: 0xF7CD,
	20818 - 19968: 0xE4AE,
	20828 - 19968: 0xD4DF,
	20834 - 19968: 0xD0E7,
	20837 - 19968: 0xECFD,
	20839 - 19968: 0xD2AE,
	20840 - 19968: 0xEEEF,
	20841 - 19968: 0xD5D7,
	20842 - 19968: 0xEAE4,
	20843 - 19968: 0xF8A2,
	20844 - 19968: 0xCDEB,
	20845 - 19968: 0xD7BF,
	20846 - 19968: 0xFBB1,
	20849 - 19968: 0xCDEC,
	20853 - 19968: 0xDCB2,
	20854 - 19968: 0xD0EC,
	20855 - 19968: 0xCEFD,
	20856 - 19968: 0xEEF0,
	20860 - 19968: 0xCCC2,
	20864 - 19968: 0xD0ED,
	20870 - 19968: 0xE5F7,
	20874 - 19968: 0xF3FC,
	20877 - 19968: 0xEEA2,
	20882 - 19968: 0xD9B3,
	20885 - 19968: 0xD8F4,
	20887 - 19968: 0xE9B7,
	20896 - 19968: 0xCEAE,
	20901 - 19968: 0xD9A2,
	20906 - 19968: 0xD8F1,
	20908 - 19968: 0xD4CF,
	20918 - 19968: 0xE5A7,
	20919 - 19968: 0xD5D2,
	20925 - 19968: 0xD6A9,
	20932 - 19968: 0xF4A2,
	20934 - 19968: 0xF1D7,
	20937 - 19968: 0xD5D8,
	20939 - 19968: 0xF0BD,
	20940 - 19968: 0xD7D0,
	20941 - 19968: 0xD4D0,
	20956 - 19968: 0xD7CF,
	20957 - 19968: 0xEBEA,
	20958 - 19968: 0xFDEB,
	20961 - 19968: 0xDBED,
	20976 - 19968: 0xFCC5,
	20977 - 19968: 0xCBC2,
	20982 - 19968: 0xFDD5,
	20984 - 19968: 0xF4C8,
	20985 - 19968: 0xE8EA,
	20986 - 19968: 0xF5F3,
	20989 - 19968: 0xF9DE,
	20992 - 19968: 0xD3EF,
	20995 - 19968: 0xECD3,
	20998 - 19968: 0xDDC2,
	20999 - 19968: 0xEFB7,
	21000 - 19968: 0xE7D4,
	21002 - 19968: 0xCACA,
	21006 - 19968: 0xD9FB,
	21009 - 19968: 0xFAFD,
	21015 - 19968: 0xD6AA,
	21021 - 19968: 0xF4F8,
	21028 - 19968: 0xF7F7,
	21029 - 19968: 0xDCAC,
	21033 - 19968: 0xD7D7,
	21034 - 19968: 0xDFA2,
	21038 - 19968: 0xCEBE,
	21040 - 19968: 0xD3F0,
	21046 - 19968: 0xF0A4,
	21047 - 19968: 0xE1EC,
	21048 - 19968: 0xCFE7,
	21049 - 19968: 0xF3CB,
	21050 - 19968: 0xEDA9,
	21051 - 19968: 0xCABE,
	21059 - 19968: 0xF4EF,
	21063 - 19968: 0xF6CE,
	21066 - 19968: 0xDEFB,
	21067 - 19968: 0xD0BB,
	21068 - 19968: 0xD5B7,
	21069 - 19968: 0xEEF1,
	21076 - 19968: 0xF4A8,
	21078 - 19968: 0xDCF8,
	21083 - 19968: 0xCBA7,
	21085 - 19968: 0xDACE,
	21089 - 19968: 0xE0E6,
	21097 - 19968: 0xEDA5,
	21098 - 19968: 0xEEF2,
	21103 - 19968: 0xDCF9,
	21106 - 19968: 0xF9DC,
	21109 - 19968: 0xF3DC,
	21117 - 19968: 0xF8F2,
	21119 - 19968: 0xF4F9,
	21123 - 19968: 0xFCF1,
	21127 - 19968: 0xD0BC,
	21128 - 19968: 0xDBF9,
	21129 - 19968: 0xD7B1,
	21133 - 19968: 0xCBFC,
	21137 - 19968: 0xF0A5,
	21138 - 19968: 0xCBFD,
	21147 - 19968: 0xD5F4,
	21151 - 19968: 0xCDED,
	21152 - 19968: 0xCAA5,
	21155 - 19968: 0xD6AB,
	21156 - 19968: 0xD0C2,
	21161 - 19968: 0xF0BE,
	21162 - 19968: 0xD2BD,
	21163 - 19968: 0xCCA4,
	21182 - 19968: 0xFAB6,
	21185 - 19968: 0xCCCD,
	21187 - 19968: 0xDAFA,
	21189 - 19968: 0xF6CF,
	21191 - 19968: 0xE9B8,
	21193 - 19968: 0xD8F5,
	21197 - 19968: 0xCCCE,
	21202 - 19968: 0xD7CD,
	21205 - 19968: 0xD4D1,
	21206 - 19968: 0xE9ED,
	21208 - 19968: 0xCAEB,
	21209 - 19968: 0xD9E2,
	21211 - 19968: 0xFDB2,
	21213 - 19968: 0xE3AD,
	21214 - 19968: 0xD6CC,
	21215 - 19968: 0xD9B4,
	21218 - 19968: 0xE1A7,
	21219 - 19968: 0xEED3,
	21220 - 19968: 0xD0C3,
	21235 - 19968: 0xFDB3,
	21237 - 19968: 0xD5E4,
	21240 - 19968: 0xCFE8,
	21242 - 19968: 0xEDC3,
	21243 - 19968: 0xD0B2,
	21246 - 19968: 0xCEFE,
	21247 - 19968: 0xDAA8,
	21253 - 19968: 0xF8D0,
	21256 - 19968: 0xFDD6,
	21261 - 19968: 0xF8D1,
	21263 - 19968: 0xF8D2,
	21264 - 19968: 0xDCD3,
	21269 - 19968: 0xDDE2,
	21270 - 19968: 0xFBF9,
	21271 - 19968: 0xDDC1,
	21273 - 19968: 0xE3B5,
	21280 - 19968: 0xEDDD,
	21281 - 19968: 0xCEC4,
	21283 - 19968: 0xCBA1,
	21290 - 19968: 0xDDE3,
	21295 - 19968: 0xFCDD,
	21305 - 19968: 0xF9AF,
	21311 - 19968: 0xD2FB,
	21312 - 19968: 0xCFA1,
	21313 - 19968: 0xE4A8,
	21315 - 19968: 0xF4B6,
	21316 - 19968: 0xECFE,
	21319 - 19968: 0xE3AE,
	21320 - 19968: 0xE7ED,
	21321 - 19968: 0xFDC1,
	21322 - 19968: 0xDAE2,
	21325 - 19968: 0xD8B3,
	21329 - 19968: 0xDDE4,
	21330 - 19968: 0xF0EF,
	21331 - 19968: 0xF6F1,
	21332 - 19968: 0xFAF0,
	21335 - 19968: 0xD1F5,
	21338 - 19968: 0xDACF,
	21340 - 19968: 0xDCD4,
	21342 - 19968: 0xDCA6,
	21344 - 19968: 0xEFBF,
	21350 - 19968: 0xCECF,
	21352 - 19968: 0xE0D9,
	21359 - 19968: 0xD9D6,
	21360 - 19968: 0xECD4,
	21361 - 19968: 0xEACB,
	21364 - 19968: 0xCABF,
	21365 - 19968: 0xD5B0,
	21367 - 19968: 0xCFE9,
	21373 - 19968: 0xF1ED,
	21375 - 19968: 0xCCCF,
	21380 - 19968: 0xE4F8,
	21395 - 19968: 0xE4ED,
	21400 - 19968: 0xD7D8,
	21402 - 19968: 0xFDA7,
	21407 - 19968: 0xEAAB,
	21408 - 19968: 0xF6B2,
	21413 - 19968: 0xCFF0,
	21414 - 19968: 0xF9BD,
	21421 - 19968: 0xE6F4,
	21435 - 19968: 0xCBDB,
	21443 - 19968: 0xF3D1,
	21448 - 19968: 0xE9D1,
	21449 - 19968: 0xF3A9,
	21450 - 19968: 0xD0E0,
	21451 - 19968: 0xE9D2,
	21453 - 19968: 0xDAE3,
	21460 - 19968: 0xE2D2,
	21462 - 19968: 0xF6A2,
	21463 - 19968: 0xE1F4,
	21467 - 19968: 0xDAE4,
	21473 - 19968: 0xE7D5,
	21474 - 19968: 0xF5BF,
	21475 - 19968: 0xCFA2,
	21476 - 19968: 0xCDAF,
	21477 - 19968: 0xCFA3,
	21481 - 19968: 0xCDB0,
	21482 - 19968: 0xF1FE,
	21483 - 19968: 0xD0A3,
	21484 - 19968: 0xE1AF,
	21485 - 19968: 0xF8A3,
	21487 - 19968: 0xCAA6,
	21488 - 19968: 0xF7BB,
	21489 - 19968: 0xF2EA,
	21490 - 19968: 0xDEC8,
	21491 - 19968: 0xE9D3,
	21496 - 19968: 0xDEC9,
	21507 - 19968: 0xFDDE,
	21508 - 19968: 0xCAC0,
	21512 - 19968: 0xF9EA,
	21513 - 19968: 0xD1CE,
	21514 - 19968: 0xEED4,
	21516 - 19968: 0xD4D2,
	21517 - 19968: 0xD9A3,
	21518 - 19968: 0xFDA8,
	21519 - 19968: 0xD7D9,
	21520 - 19968: 0xF7CE,
	21521 - 19968: 0xFABE,
	21531 - 19968: 0xCFD6,
	21533 - 19968: 0xD7F0,
	21535 - 19968: 0xEBE1,
	21536 - 19968: 0xF8C5,
	21542 - 19968: 0xDCFA,
	21545 - 19968: 0xDDC3,
	21547 - 19968: 0xF9DF,
	21555 - 19968: 0xE7EF,
	21560 - 19968: 0xFDE5,
	21561 - 19968: 0xF6A3,
	21563 - 19968: 0xD9FC,
	21564 - 19968: 0xFDA9,
	21566 - 19968: 0xE7EE,
	21570 - 19968: 0xD5E5,
	21576 - 19968: 0xEFD0,
	21578 - 19968: 0xCDB1,
	21585 - 19968: 0xF7A2,
	21608 - 19968: 0xF1B2,
	21610 - 19968: 0xF1B1,
	21617 - 19968: 0xCDB2,
	21619 - 19968: 0xDAAB,
	21621 - 19968: 0xCAA7,
	21627 - 19968: 0xE3E2,
	21628 - 19968: 0xFBBC,
	21629 - 19968: 0xD9A4,
	21632 - 19968: 0xEEBA,
	21638 - 19968: 0xF8D3,
	21644 - 19968: 0xFBFA,
	21646 - 19968: 0xCFA4,
	21648 - 19968: 0xDCFB,
	21668 - 19968: 0xF6E3,
	21672 - 19968: 0xEDAA,
	21675 - 19968: 0xF2A1,
	21676 - 19968: 0xCEE1,
	21683 - 19968: 0xFAA6,
	21688 - 19968: 0xF9E0,
	21693 - 19968: 0xECD6,
	21696 - 19968: 0xE4EE,
	21697 - 19968: 0xF9A1,
	21700 - 19968: 0xFBEF,
	21704 - 19968: 0xF9EB,
	21705 - 19968: 0xEEA3,
	21729 - 19968: 0xEAAC,
	21733 - 19968: 0xCAA8,
	21736 - 19968: 0xF4FA,
	21741 - 19968: 0xCDD6,
	21742 - 19968: 0xFCF6,
	21746 - 19968: 0xF4C9,
	21754 - 19968: 0xF8D4,
	21764 - 19968: 0xF8A6,
	21766 - 19968: 0xDECA,
	21767 - 19968: 0xF2C6,
	21774 - 19968: 0xD7DA,
	21776 - 19968: 0xD3D0,
	21788 - 19968: 0xD8C5,
	21807 - 19968: 0xEAE6,
	21809 - 19968: 0xF3DD,
	21813 - 19968: 0xE4DA,
	21822 - 19968: 0xF6E4,
	21828 - 19968: 0xF6F2,
	21830 - 19968: 0xDFC2,
	21839 - 19968: 0xD9FD,
	21843 - 19968: 0xCCF6,
	21846 - 19968: 0xD3BA,
	21854 - 19968: 0xE4AF,
	21859 - 19968: 0xF9E1,
	21884 - 19968: 0xF0A6,
	21888 - 19968: 0xCBD3,
	21892 - 19968: 0xE0BC,
	21894 - 19968: 0xF4CA,
	21895 - 19968: 0xD4FA,
	21897 - 19968: 0xFDAA,
	21898 - 19968: 0xF9E2,
	21912 - 19968: 0xF4B7,
	21913 - 19968: 0xFDC2,
	21914 - 19968: 0xFCB0,
	21916 - 19968: 0xFDEC,
	21917 - 19968: 0xCAE2,
	21927 - 19968: 0xFDBD,
	21929 - 19968: 0xEAE7,
	21930 - 19968: 0xDFC3,
	21931 - 19968: 0xD1D2,
	21932 - 19968: 0xCEE2,
	21934 - 19968: 0xD3A4,
	21957 - 19968: 0xFDAB,
	21959 - 19968: 0xDFE0,
	21972 - 19968: 0xF2C7,
	21978 - 19968: 0xE7F0,
	21980 - 19968: 0xD0EE,
	21983 - 19968: 0xF3AA,
	21987 - 19968: 0xDECB,
	21988 - 19968: 0xF6B8,
	22013 - 19968: 0xE1F5,
	22014 - 19968: 0xF1B3,
	22022 - 19968: 0xF7A3,
	22025 - 19968: 0xCAA9,
	22036 - 19968: 0xCFA5,
	22039 - 19968: 0xDFC4,
	22063 - 19968: 0xE1B0,
	22066 - 19968: 0xF0BF,
	22068 - 19968: 0xF6A4,
	22070 - 19968: 0xE3B6,
	22099 - 19968: 0xFAC6,
	22120 - 19968: 0xD0EF,
	22123 - 19968: 0xFDED,
	22132 - 19968: 0xDDC4,
	22150 - 19968: 0xFCF7,
	22181 - 19968: 0xE6BF,
	22188 - 19968: 0xDEAD,
	22190 - 19968: 0xFABF,
	22196 - 19968: 0xE5F1,
	22204 - 19968: 0xEDC4,
	22218 - 19968: 0xD2A5,
	22221 - 19968: 0xFDEE,
	22225 - 19968: 0xF5B6,
	22234 - 19968: 0xE1F6,
	22235 - 19968: 0xDECC,
	22238 - 19968: 0xFCDE,
	22240 - 19968: 0xECD7,
	22256 - 19968: 0xCDDD,
	22265 - 19968: 0xD6B7,
	22266 - 19968: 0xCDB3,
	22275 - 19968: 0xF8D5,
	22276 - 19968: 0xE5D8,
	22280 - 19968: 0xCFEA,
	22283 - 19968: 0xCFD0,
	22285 - 19968: 0xEACC,
	22290 - 19968: 0xEAAE,
	22291 - 19968: 0xEAAD,
	22294 - 19968: 0xD3F1,
	22296 - 19968: 0xD3A5,
	22303 - 19968: 0xF7CF,
	22312 - 19968: 0xEEA4,
	22317 - 19968: 0xD0A4,
	22320 - 19968: 0xF2A2,
	22331 - 19968: 0xD0F0,
	22336 - 19968: 0xF2A3,
	22338 - 19968: 0xF7F8,
	22343 - 19968: 0xD0B3,
	22346 - 19968: 0xDBA9,
	22349 - 19968: 0xD3BB,
	22350 - 19968: 0xCAEC,
	22352 - 19968: 0xF1A6,
	22353 - 19968: 0xCBD5,
	22369 - 19968: 0xF7E7,
	22372 - 19968: 0xCDDE,
	22374 - 19968: 0xF7A4,
	22378 - 19968: 0xF8C0,
	22382 - 19968: 0xD3DD,
	22384 - 19968: 0xCCD0,
	22389 - 19968: 0xCFA6,
	22396 - 19968: 0xF6F3,
	22402 - 19968: 0xE1F7,
	22408 - 19968: 0xD3DC,
	22411 - 19968: 0xFAFE,
	22419 - 19968: 0xFAA7,
	22432 - 19968: 0xEBD9,
	22434 - 19968: 0xCFA7,
	22435 - 19968: 0xEAAF,
	22467 - 19968: 0xE4EF,
	22471 - 19968: 0xE9B9,
	22472 - 19968: 0xF1D8,
	22475 - 19968: 0xD8D8,
	22478 - 19968: 0xE0F2,
	22495 - 19968: 0xE6B4,
	22496 - 19968: 0xDCFC,
	22512 - 19968: 0xF3F1,
	22516 - 19968: 0xE3D0,
	22519 - 19968: 0xF2FB,
	22521 - 19968: 0xDBC6,
	22522 - 19968: 0xD0F1,
	22524 - 19968: 0xD0F2,
	22528 - 19968: 0xCFDC,
	22530 - 19968: 0xD3D1,
	22533 - 19968: 0xCCB1,
	22534 - 19968: 0xF7D8,
	22536 - 19968: 0xCBA8,
	22537 - 19968: 0xEBBC,
	22538 - 19968: 0xE4BE,
	22558 - 19968: 0xF4DC,
	22561 - 19968: 0xDCC2,
	22564 - 19968: 0xF0A7,
	22567 - 19968: 0xE6C0,
	22570 - 19968: 0xCAED,
	22575 - 19968: 0xE8EB,
	22576 - 19968: 0xE5E8,
	22577 - 19968: 0xDCC3,
	22580 - 19968: 0xEDDE,
	22581 - 19968: 0xD3F2,
	22586 - 19968: 0xCCF7,
	22602 - 19968: 0xCED4,
	22603 - 19968: 0xE7AB,
	22607 - 19968: 0xCBC3,
	22609 - 19968: 0xE1B1,
	22612 - 19968: 0xF7B2,
	22615 - 19968: 0xD3F3,
	22616 - 19968: 0xD3D2,
	22618 - 19968: 0xF5C0,
	22622 - 19968: 0xDFDD,
	22625 - 19968: 0xEEF3,
	22626 - 19968: 0xE7F1,
	22628 - 19968: 0xFDB4,
	22645 - 19968: 0xF2C8,
	22649 - 19968: 0xF3D2,
	22652 - 19968: 0xEEF4,
	22654 - 19968: 0xE2D3,
	22659 - 19968: 0xCCD1,
	22661 - 19968: 0xDFEA,
	22665 - 19968: 0xE9BA,
	22675 - 19968: 0xD9D7,
	22684 - 19968: 0xF5CD,
	22686 - 19968: 0xF1F2,
	22687 - 19968: 0xFAC7,
	22696 - 19968: 0xD9F8,
	22697 - 19968: 0xD4C2,
	22702 - 19968: 0xF6E5,
	22707 - 19968: 0xDDC5,
	22714 - 19968: 0xE7F2,
	22715 - 19968: 0xEDDF,
	22718 - 19968: 0xCACB,
	22721 - 19968: 0xDBFA,
	22725 - 19968: 0xE8B5,
	22727 - 19968: 0xD3A6,
	22734 - 19968: 0xFDB5,
	22737 - 19968: 0xF9C9,
	22739 - 19968: 0xE4E2,
	22741 - 19968: 0xFBBD,
	22744 - 19968: 0xD7A4,
	22745 - 19968: 0xCEC5,
	22750 - 19968: 0xCED5,
	22751 - 19968: 0xD6E6,
	22756 - 19968: 0xE5BD,
	22763 - 19968: 0xDECD,
	22764 - 19968: 0xECF3,
	22767 - 19968: 0xEDE0,
	22777 - 19968: 0xECEC,
	22778 - 19968: 0xFBBE,
	22779 - 19968: 0xDFEB,
	22781 - 19968: 0xE1F8,
	22799 - 19968: 0xF9BE,
	22804 - 19968: 0xD0F3,
	22805 - 19968: 0xE0AA,
	22806 - 19968: 0xE8E2,
	22809 - 19968: 0xE2D4,
	22810 - 19968: 0xD2FD,
	22812 - 19968: 0xE5A8,
	22818 - 19968: 0xD9D3,
	22823 - 19968: 0xD3DE,
	22825 - 19968: 0xF4B8,
	22826 - 19968: 0xF7BC,
	22827 - 19968: 0xDCFD,
	22829 - 19968: 0xE8EC,
	22830 - 19968: 0xE4E7,
	22833 - 19968: 0xE3F7,
	22839 - 19968: 0xECA8,
	22846 - 19968: 0xFAF1,
	22852 - 19968: 0xE5F2,
	22855 - 19968: 0xD0F4,
	22856 - 19968: 0xD2AF,
	22857 - 19968: 0xDCE5,
	22862 - 19968: 0xD0A5,
	22863 - 19968: 0xF1B4,
	22864 - 19968: 0xFCB1,
	22865 - 19968: 0xCCF8,
	22868 - 19968: 0xDDC6,
	22869 - 19968: 0xFAD1,
	22871 - 19968: 0xF7DF,
	22874 - 19968: 0xFAA8,
	22880 - 19968: 0xEEF5,
	22882 - 19968: 0xDECE,
	22887 - 19968: 0xE7F3,
	22890 - 19968: 0xF7AC,
	22891 - 19968: 0xEBC4,
	22892 - 19968: 0xEDE1,
	22893 - 19968: 0xE0AB,
	22894 - 19968: 0xDDC7,
	22899 - 19968: 0xD2B3,
	22900 - 19968: 0xD2BF,
	22904 - 19968: 0xCACC,
	22909 - 19968: 0xFBBF,
	22914 - 19968: 0xE5FD,
	22915 - 19968: 0xDDE5,
	22916 - 19968: 0xD8CD,
	22922 - 19968: 0xECF4,
	22931 - 19968: 0xD0F5,
	22934 - 19968: 0xE8ED,
	22935 - 19968: 0xD0D2,
	22937 - 19968: 0xD9D8,
	22949 - 19968: 0xF6E6,
	22952 - 19968: 0xDBAA,
	22956 - 19968: 0xF7E0,
	22969 - 19968: 0xD8D9,
	22971 - 19968: 0xF4A3,
	22974 - 19968: 0xF4DD,
	22979 - 19968: 0xEFD1,
	22982 - 19968: 0xD9B5,
	22985 - 19968: 0xEDAB,
	22987 - 19968: 0xE3B7,
	22992 - 19968: 0xEEBB,
	22993 - 19968: 0xCDB4,
	22995 - 19968: 0xE0F3,
	22996 - 19968: 0xEACD,
	23001 - 19968: 0xECF5,
	23002 - 19968: 0xE8EE,
	23004 - 19968: 0xCBA9,
	23005 - 19968: 0xF1AF,
	23014 - 19968: 0xCACD,
	23016 - 19968: 0xECA9,
	23018 - 19968: 0xF2EB,
	23020 - 19968: 0xFDEF,
	23022 - 19968: 0xF9F3,
	23032 - 19968: 0xE6C1,
	23035 - 19968: 0xECD8,
	23039 - 19968: 0xEDAC,
	23041 - 19968: 0xEACE,
	23043 - 19968: 0xE8DF,
	23057 - 19968: 0xDECF,
	23064 - 19968: 0xD2A6,
	23067 - 19968: 0xE7F4,
	23068 - 19968: 0xD1D6,
	23071 - 19968: 0xE6C2,
	23072 - 19968: 0xE3E3,
	23077 - 19968: 0xE4B0,
	23081 - 19968: 0xD8B4,
	23094 - 19968: 0xF6A5,
	23100 - 19968: 0xF3DE,
	23105 - 19968: 0xD7A5,
	23110 - 19968: 0xF7E8,
	23113 - 19968: 0xE8C6,
	23130 - 19968: 0xFBE6,
	23138 - 19968: 0xDDE6,
	23142 - 19968: 0xDCFE,
	23186 - 19968: 0xD8DA,
	23194 - 19968: 0xDAAC,
	23195 - 19968: 0xEAB0,
	23204 - 19968: 0xE3B8,
	23233 - 19968: 0xCAAA,
	23234 - 19968: 0xE1F9,
	23236 - 19968: 0xEAB1,
	23241 - 19968: 0xF2EC,
	23244 - 19968: 0xFAEE,
	23265 - 19968: 0xEED5,
	23270 - 19968: 0xF9F4,
	23273 - 19968: 0xD2EC,
	23301 - 19968: 0xFBFB,
	23305 - 19968: 0xFDF0,
	23307 - 19968: 0xE0BD,
	23308 - 19968: 0xCEE3,
	23318 - 19968: 0xF8C6,
	23338 - 19968: 0xDEAE,
	23360 - 19968: 0xDFC5,
	23363 - 19968: 0xE5BE,
	23376 - 19968: 0xEDAD,
	23377 - 19968: 0xFAEA,
	23380 - 19968: 0xCDEE,
	23381 - 19968: 0xEDA6,
	23383 - 19968: 0xEDAE,
	23384 - 19968: 0xF0ED,
	23386 - 19968: 0xDDA1,
	23388 - 19968: 0xEDAF,
	23389 - 19968: 0xFCF8,
	23391 - 19968: 0xD8EB,
	23395 - 19968: 0xCCF9,
	23396 - 19968: 0xCDB5,
	23401 - 19968: 0xFAA9,
	23403 - 19968: 0xE1DD,
	23408 - 19968: 0xE2D5,
	23409 - 19968: 0xEDCF,
	23413 - 19968: 0xDDA2,
	23416 - 19968: 0xF9CA,
	23418 - 19968: 0xEAE8,
	23420 - 19968: 0xE5ED,
	23429 - 19968: 0xD3EB,
	23431 - 19968: 0xE9D4,
	23432 - 19968: 0xE1FA,
	23433 - 19968: 0xE4CC,
	23435 - 19968: 0xE1E4,
	23436 - 19968: 0xE8C7,
	23439 - 19968: 0xCEDB,
	23443 - 19968: 0xDCD5,
	23445 - 19968: 0xF7B5,
	23446 - 19968: 0xFCF3,
	23447 - 19968: 0xF0F3,
	23448 - 19968: 0xCEAF,
	23449 - 19968: 0xF1B5,
	23450 - 19968: 0xEFD2,
	23451 - 19968: 0xE8C8,
	23452 - 19968: 0xEBF1,
	23458 - 19968: 0xCBD4,
	23459 - 19968: 0xE0BE,
	23460 - 19968: 0xE3F8,
	23461 - 19968: 0xEAE9,
	23462 - 19968: 0xFCB2,
	23468 - 19968: 0xE0F4,
	23470 - 19968: 0xCFE0,
	23472 - 19968: 0xEEA5,
	23475 - 19968: 0xFAAA,
	23476 - 19968: 0xE6C3,
	23477 - 19968: 0xE1B2,
	23478 - 19968: 0xCAAB,
	23480 - 19968: 0xE3E4,
	23481 - 19968: 0xE9BB,
	23487 - 19968: 0xE2D6,
	23488 - 19968: 0xF3F2,
	23490 - 19968: 0xEED6,
	23491 - 19968: 0xEAB2,
	23492 - 19968: 0xD0F6,
	23493 - 19968: 0xECD9,
	23494 - 19968: 0xDACB,
	23495 - 19968: 0xCFA8,
	23500 - 19968: 0xDDA3,
	23504 - 19968: 0xD8DB,
	23506 - 19968: 0xF9CE,
	23507 - 19968: 0xE9D5,
	23508 - 19968: 0xE3D1,
	23511 - 19968: 0xD2BC,
	23518 - 19968: 0xD8AC,
	23519 - 19968: 0xF3CC,
	23521 - 19968: 0xCDFB,
	23522 - 19968: 0xF6D6,
	23524 - 19968: 0xE7F5,
	23525 - 19968: 0xE8EF,
	23526 - 19968: 0xE3F9,
	23527 - 19968: 0xD2BB,
	23528 - 19968: 0xF3F3,
	23529 - 19968: 0xE3FB,
	23531 - 19968: 0xDED0,
	23532 - 19968: 0xCEB0,
	23534 - 19968: 0xD6F7,
	23535 - 19968: 0xF1D9,
	23541 - 19968: 0xF5C1,
	23542 - 19968: 0xDCC4,
	23544 - 19968: 0xF5BB,
	23546 - 19968: 0xDED1,
	23553 - 19968: 0xDCE6,
	23556 - 19968: 0xDED2,
	23559 - 19968: 0xEDE2,
	23560 - 19968: 0xEEF6,
	23561 - 19968: 0xEACF,
	23562 - 19968: 0xF0EE,
	23563 - 19968: 0xE3FC,
	23565 - 19968: 0xD3DF,
	23566 - 19968: 0xD3F4,
	23567 - 19968: 0xE1B3,
	23569 - 19968: 0xE1B4,
	23574 - 19968: 0xF4D3,
	23577 - 19968: 0xDFC6,
	23588 - 19968: 0xE9D6,
	23592 - 19968: 0xDBAB,
	23601 - 19968: 0xF6A6,
	23608 - 19968: 0xE3B9,
	23609 - 19968: 0xEBC5,
	23610 - 19968: 0xF4A9,
	23611 - 19968: 0xCDB6,
	23612 - 19968: 0xD2F9,
	23614 - 19968: 0xDAAD,
	23615 - 19968: 0xD2E3,
	23616 - 19968: 0xCFD1,
	23621 - 19968: 0xCBDC,
	23622 - 19968: 0xCCFA,
	23624 - 19968: 0xCFDD,
	23627 - 19968: 0xE8A9,
	23629 - 19968: 0xE3BB,
	23630 - 19968: 0xE3BA,
	23633 - 19968: 0xE0DA,
	23637 - 19968: 0xEEF7,
	23643 - 19968: 0xDCB3,
	23648 - 19968: 0xD3F5,
	23650 - 19968: 0xD7A6,
	23652 - 19968: 0xF6B5,
	23653 - 19968: 0xD7DB,
	23660 - 19968: 0xE1D5,
	23663 - 19968: 0xD4EA,
	23665 - 19968: 0xDFA3,
	23673 - 19968: 0xFDDF,
	23696 - 19968: 0xD0F7,
	23697 - 19968: 0xEDD4,
	23713 - 19968: 0xCBAA,
	23721 - 19968: 0xE4DB,
	23723 - 19968: 0xE1FB,
	23724 - 19968: 0xCBA2,
	23729 - 19968: 0xD3E0,
	23731 - 19968: 0xE4BF,
	23733 - 19968: 0xFBC0,
	23735 - 19968: 0xDABE,
	23736 - 19968: 0xE4CD,
	23738 - 19968: 0xD6B9,
	23742 - 19968: 0xEFC0,
	23744 - 19968: 0xE1FC,
	23769 - 19968: 0xF6B9,
	23776 - 19968: 0xDFC7,
	23784 - 19968: 0xE4B1,
	23791 - 19968: 0xDCE7,
	23792 - 19968: 0xDCE8,
	23796 - 19968: 0xFAD6,
	23798 - 19968: 0xD3F6,
	23803 - 19968: 0xF1DA,
	23805 - 19968: 0xFAF2,
	23815 - 19968: 0xE2FD,
	23821 - 19968: 0xD5CF,
	23822 - 19968: 0xD0F8,
	23825 - 19968: 0xCDDF,
	23828 - 19968: 0xF5CB,
	23830 - 19968: 0xE4F0,
	23831 - 19968: 0xCBAB,
	23833 - 19968: 0xD7C4,
	23847 - 19968: 0xE2FE,
	23849 - 19968: 0xDDDA,
	23883 - 19968: 0xDAAE,
	23884 - 19968: 0xCAEE,
	23888 - 19968: 0xD5B9,
	23913 - 19968: 0xE3A1,
	23916 - 19968: 0xE8E3,
	23919 - 19968: 0xF3AB,
	23943 - 19968: 0xCFA9,
	23947 - 19968: 0xD3F7,
	23965 - 19968: 0xD4F1,
	23968 - 19968: 0xCEE4,
	23970 - 19968: 0xE8F2,
	23978 - 19968: 0xE5F5,
	23992 - 19968: 0xE7AE,
	23994 - 19968: 0xD6BA,
	23996 - 19968: 0xDFEC,
	23997 - 19968: 0xE4C0,
	24013 - 19968: 0xE8E4,
	24018 - 19968: 0xD8B5,
	24022 - 19968: 0xE4DC,
	24029 - 19968: 0xF4B9,
	24030 - 19968: 0xF1B6,
	24033 - 19968: 0xE2DE,
	24034 - 19968: 0xE1B5,
	24037 - 19968: 0xCDEF,
	24038 - 19968: 0xF1A7,
	24039 - 19968: 0xCEE5,
	24040 - 19968: 0xCBDD,
	24043 - 19968: 0xD9E3,
	24046 - 19968: 0xF3AC,
	24049 - 19968: 0xD0F9,
	24050 - 19968: 0xECAB,
	24051 - 19968: 0xDED3,
	24052 - 19968: 0xF7E9,
	24055 - 19968: 0xF9F5,
	24061 - 19968: 0xE1DE,
	24062 - 19968: 0xCBEE,
	24066 - 19968: 0xE3BC,
	24067 - 19968: 0xF8D6,
	24070 - 19968: 0xDBEE,
	24076 - 19968: 0xFDF1,
	24081 - 19968: 0xF7B6,
	24086 - 19968: 0xF4DE,
	24089 - 19968: 0xF2ED,
	24091 - 19968: 0xDBD9,
	24093 - 19968: 0xF0A8,
	24101 - 19968: 0xE1FD,
	24107 - 19968: 0xDED4,
	24109 - 19968: 0xE0AC,
	24115 - 19968: 0xEDE3,
	24118 - 19968: 0xD3E1,
	24120 - 19968: 0xDFC8,
	24125 - 19968: 0xD9B6,
	24127 - 19968: 0xFDAC,
	24128 - 19968: 0xEFD3,
	24132 - 19968: 0xE4C1,
	24133 - 19968: 0xF8EB,
	24135 - 19968: 0xDBAC,
	24140 - 19968: 0xFCC6,
	24149 - 19968: 0xD8AD,
	24159 - 19968: 0xF6BA,
	24161 - 19968: 0xDBDF,
	24162 - 19968: 0xD3D3,
	24163 - 19968: 0xF8C7,
	24178 - 19968: 0xCACE,
	24179 - 19968: 0xF8C1,
	24180 - 19968: 0xD2B4,
	24183 - 19968: 0xDCB4,
	24184 - 19968: 0xFAB9,
	24185 - 19968: 0xCACF,
	24187 - 19968: 0xFCB3,
	24188 - 19968: 0xEAEA,
	24189 - 19968: 0xEAEB,
	24190 - 19968: 0xD0FA,
	24196 - 19968: 0xEDE4,
	24199 - 19968: 0xDDE7,
	24202 - 19968: 0xDFC9,
	24207 - 19968: 0xDFED,
	24213 - 19968: 0xEEBC,
	24215 - 19968: 0xEFC1,
	24218 - 19968: 0xCCD2,
	24220 - 19968: 0xDDA4,
	24224 - 19968: 0xDFCA,
	24230 - 19968: 0xD3F8,
	24231 - 19968: 0xF1A8,
	24235 - 19968: 0xCDB7,
	24237 - 19968: 0xEFD4,
	24245 - 19968: 0xE4DD,
	24246 - 19968: 0xDFEE,
	24247 - 19968: 0xCBAC,
	24248 - 19968: 0xE9BC,
	24254 - 19968: 0xEAEC,
	24258 - 19968: 0xDFCB,
	24264 - 19968: 0xF9BF,
	24265 - 19968: 0xD6AF,
	24266 - 19968: 0xD5C6,
	24272 - 19968: 0xCFAA,
	24275 - 19968: 0xCEA9,
	24278 - 19968: 0xD6F8,
	24282 - 19968: 0xF1B7,
	24283 - 19968: 0xEEF8,
	24287 - 19968: 0xD9D9,
	24288 - 19968: 0xF3DF,
	24290 - 19968: 0xF8C8,
	24291 - 19968: 0xCEC6,
	24300 - 19968: 0xD5E6,
	24307 - 19968: 0xF4E6,
	24310 - 19968: 0xE6C5,
	24311 - 19968: 0xEFD5,
	24314 - 19968: 0xCBEF,
	24315 - 19968: 0xFCDF,
	24321 - 19968: 0xDCA7,
	24324 - 19968: 0xD6E7,
	24330 - 19968: 0xF8C9,
	24335 - 19968: 0xE3D2,
	24337 - 19968: 0xE3BD,
	24339 - 19968: 0xCFE1,
	24340 - 19968: 0xF0C0,
	24341 - 19968: 0xECDA,
	24343 - 19968: 0xDDD7,
	24344 - 19968: 0xFBF0,
	24347 - 19968: 0xECAC,
	24351 - 19968: 0xF0A9,
	24358 - 19968: 0xFAD7,
	24359 - 19968: 0xFBC1,
	24361 - 19968: 0xD2C0,
	24369 - 19968: 0xE5B0,
	24373 - 19968: 0xEDE5,
	24378 - 19968: 0xCBAD,
	24380 - 19968: 0xF9B0,
	24392 - 19968: 0xF7A5,
	24394 - 19968: 0xCBAE,
	24396 - 19968: 0xDAAF,
	24398 - 19968: 0xD8B6,
	24406 - 19968: 0xD3A7,
	24407 - 19968: 0xFBB2,
	24409 - 19968: 0xFDC4,
	24411 - 19968: 0xECAD,
	24418 - 19968: 0xFBA1,
	24422 - 19968: 0xE5E9,
	24423 - 19968: 0xE9EE,
	24425 - 19968: 0xF3F4,
	24426 - 19968: 0xF8F3,
	24427 - 19968: 0xF0C1,
	24428 - 19968: 0xDEAF,
	24429 - 19968: 0xF8B0,
	24432 - 19968: 0xF3E0,
	24433 - 19968: 0xE7AF,
	24439 - 19968: 0xDBAD,
	24441 - 19968: 0xE6B5,
	24444 - 19968: 0xF9A8,
	24447 - 19968: 0xDDD8,
	24448 - 19968: 0xE8D9,
	24449 - 19968: 0xEFD6,
	24453 - 19968: 0xD3E2,
	24455 - 19968: 0xE2DF,
	24458 - 19968: 0xFCE0,
	24459 - 19968: 0xD7C8,
	24460 - 19968: 0xFDAD,
	24464 - 19968: 0xDFEF,
	24465 - 19968: 0xCCD3,
	24466 - 19968: 0xD3F9,
	24471 - 19968: 0xD4F0,
	24472 - 19968: 0xDBC7,
	24473 - 19968: 0xDED5,
	24478 - 19968: 0xF0F4,
	24480 - 19968: 0xD5D0,
	24481 - 19968: 0xE5D9,
	24488 - 19968: 0xFCC7,
	24489 - 19968: 0xDCD6,
	24490 - 19968: 0xE2E0,
	24494 - 19968: 0xDAB0,
	24501 - 19968: 0xF3A3,
	24503 - 19968: 0xD3EC,
	24505 - 19968: 0xF4CB,
	24509 - 19968: 0xFDC5,
	24515 - 19968: 0xE3FD,
	24517 - 19968: 0xF9B1,
	24524 - 19968: 0xD0FB,
	24525 - 19968: 0xECDB,
	24534 - 19968: 0xF5BC,
	24535 - 19968: 0xF2A4,
	24536 - 19968: 0xD8CE,
	24537 - 19968: 0xD8CF,
	24544 - 19968: 0xF5F7,
	24555 - 19968: 0xF6E1,
	24565 - 19968: 0xD2B7,
	24573 - 19968: 0xFBEC,
	24575 - 19968: 0xDDC8,
	24591 - 19968: 0xE4E8,
	24594 - 19968: 0xD2C1,
	24598 - 19968: 0xF8D7,
	24604 - 19968: 0xD6BB,
	24605 - 19968: 0xDED6,
	24608 - 19968: 0xF7BD,
	24609 - 19968: 0xECAE,
	24613 - 19968: 0xD0E1,
	24615 - 19968: 0xE0F5,
	24616 - 19968: 0xEAB3,
	24618 - 19968: 0xCED6,
	24623 - 19968: 0xCCA5,
	24641 - 19968: 0xECF6,
	24642 - 19968: 0xE2E1,
	24643 - 19968: 0xE3BE,
	24653 - 19968: 0xFCC8,
	24656 - 19968: 0xCDF0,
	24658 - 19968: 0xF9F6,
	24661 - 19968: 0xDFF0,
	24665 - 19968: 0xE5BF,
	24669 - 19968: 0xCEBF,
	24674 - 19968: 0xFCE1,
	24675 - 19968: 0xEDB0,
	24676 - 19968: 0xFDD1,
	24677 - 19968: 0xF6BB,
	24680 - 19968: 0xF9CF,
	24681 - 19968: 0xEBDA,
	24682 - 19968: 0xCAC1,
	24684 - 19968: 0xD2B8,
	24685 - 19968: 0xCDF1,
	24687 - 19968: 0xE3D3,
	24688 - 19968: 0xFDE6,
	24709 - 19968: 0xE6ED,
	24713 - 19968: 0xE3FA,
	24716 - 19968: 0xF0AA,
	24717 - 19968: 0xF9D0,
	24724 - 19968: 0xFCE2,
	24726 - 19968: 0xF8A7,
	24730 - 19968: 0xE1E5,
	24731 - 19968: 0xEEF9,
	24735 - 19968: 0xE7F6,
	24736 - 19968: 0xEAED,
	24739 - 19968: 0xFCB4,
	24740 - 19968: 0xF5C2,
	24743 - 19968: 0xD7DC,
	24752 - 19968: 0xF0F5,
	24754 - 19968: 0xDDE8,
	24755 - 19968: 0xD3ED,
	24756 - 19968: 0xF5FC,
	24758 - 19968: 0xDABF,
	24760 - 19968: 0xCCFB,
	24764 - 19968: 0xD3FA,
	24765 - 19968: 0xF4A4,
	24773 - 19968: 0xEFD7,
	24775 - 19968: 0xD4C3,
	24785 - 19968: 0xFBE3,
	24794 - 19968: 0xFBED,
	24796 - 19968: 0xE0AD,
	24799 - 19968: 0xEAEE,
	24800 - 19968: 0xFBB3,
	24801 - 19968: 0xE4C2,
	24816 - 19968: 0xF6E7,
	24817 - 19968: 0xD2DD,
	24819 - 19968: 0xDFCC,
	24822 - 19968: 0xFCC9,
	24825 - 19968: 0xE5A9,
	24826 - 19968: 0xE0F6,
	24827 - 19968: 0xF6B3,
	24833 - 19968: 0xE1FE,
	24838 - 19968: 0xCBF0,
	24840 - 19968: 0xEAEF,
	24841 - 19968: 0xEAF0,
	24845 - 19968: 0xDAC0,
	24846 - 19968: 0xF8B4,
	24847 - 19968: 0xEBF2,
	24853 - 19968: 0xE4C3,
	24858 - 19968: 0xE9D7,
	24859 - 19968: 0xE4F1,
	24863 - 19968: 0xCAEF,
	24871 - 19968: 0xCED7,
	24880 - 19968: 0xFCCA,
	24884 - 19968: 0xF3E1,
	24887 - 19968: 0xCBC4,
	24892 - 19968: 0xE3E5,
	24894 - 19968: 0xCBC5,
	24895 - 19968: 0xEAB4,
	24898 - 19968: 0xE9BD,
	24900 - 19968: 0xD7C9,
	24903 - 19968: 0xEBDB,
	24904 - 19968: 0xEDB1,
	24906 - 19968: 0xCCC3,
	24907 - 19968: 0xF7BE,
	24908 - 19968: 0xFCCB,
	24915 - 19968: 0xF8F4,
	24917 - 19968: 0xD9B7,
	24920 - 19968: 0xF3D3,
	24921 - 19968: 0xF3D4,
	24925 - 19968: 0xF7E4,
	24927 - 19968: 0xF7D1,
	24930 - 19968: 0xD8B7,
	24931 - 19968: 0xCEB1,
	24932 - 19968: 0xCAC2,
	24935 - 19968: 0xFBB4,
	24936 - 19968: 0xCBC6,
	24939 - 19968: 0xF0F6,
	24942 - 19968: 0xD5E7,
	24944 - 19968: 0xEAD0,
	24950 - 19968: 0xCCD4,
	24951 - 19968: 0xCBAF,
	24957 - 19968: 0xF4AA,
	24958 - 19968: 0xE9AF,
	24961 - 19968: 0xF5C3,
	24962 - 19968: 0xE9D8,
	24970 - 19968: 0xDDE9,
	24974 - 19968: 0xF1F3,
	24976 - 19968: 0xD5FB,
	24977 - 19968: 0xDEBB,
	24980 - 19968: 0xF4FB,
	24984 - 19968: 0xFDF3,
	24985 - 19968: 0xFDF2,
	24986 - 19968: 0xF7A6,
	24996 - 19968: 0xDDC9,
	24999 - 19968: 0xD4D3,
	25001 - 19968: 0xCCA8,
	25003 - 19968: 0xDAC1,
	25004 - 19968: 0xCCD5,
	25006 - 19968: 0xD9E4,
	25010 - 19968: 0xFACA,
	25014 - 19968: 0xE5E3,
	25018 - 19968: 0xD3BC,
	25022 - 19968: 0xCAF0,
	25027 - 19968: 0xD0C4,
	25031 - 19968: 0xCAD0,
	25032 - 19968: 0xFAAB,
	25033 - 19968: 0xEBEB,
	25034 - 19968: 0xE7F8,
	25035 - 19968: 0xD9E5,
	25062 - 19968: 0xD1D7,
	25074 - 19968: 0xF3A4,
	25078 - 19968: 0xD4FB,
	25079 - 19968: 0xFCE3,
	25080 - 19968: 0xFAD8,
	25082 - 19968: 0xF3D5,
	25084 - 19968: 0xCFAB,
	25087 - 19968: 0xEBF3,
	25088 - 19968: 0xD5FC,
	25095 - 19968: 0xD3D4,
	25096 - 19968: 0xCDFC,
	25098 - 19968: 0xD9E6,
	25100 - 19968: 0xE2F9,
	25101 - 19968: 0xE2A1,
	25102 - 19968: 0xEBD4,
	25104 - 19968: 0xE0F7,
	25105 - 19968: 0xE4B2,
	25106 - 19968: 0xCCFC,
	25110 - 19968: 0xFBE4,
	25114 - 19968: 0xF4AB,
	25119 - 19968: 0xD0BD,
	25121 - 19968: 0xCAF1,
	25130 - 19968: 0xEFB8,
	25134 - 19968: 0xD7C0,
	25136 - 19968: 0xEEFA,
	25137 - 19968: 0xFDF4,
	25140 - 19968: 0xD3E3,
	25142 - 19968: 0xFBC2,
	25150 - 19968: 0xD5E8,
	25151 - 19968: 0xDBAE,
	25152 - 19968: 0xE1B6,
	25153 - 19968: 0xF8B7,
	25159 - 19968: 0xE0BF,
	25160 - 19968: 0xFBC3,
	25161 - 19968: 0xDDEA,
	25163 - 19968: 0xE2A2,
	25165 - 19968: 0xEEA6,
	25171 - 19968: 0xF6E8,
	25176 - 19968: 0xF6F5,
	25198 - 19968: 0xDDCA,
	25201 - 19968: 0xD0E2,
	25206 - 19968: 0xDDA6,
	25209 - 19968: 0xDDEB,
	25212 - 19968: 0xE4F9,
	25215 - 19968: 0xE3AF,
	25216 - 19968: 0xD0FC,
	25220 - 19968: 0xF4FC,
	25225 - 19968: 0xCCBC,
	25226 - 19968: 0xF7EA,
	25233 - 19968: 0xE5E4,
	25234 - 19968: 0xDFF1,
	25237 - 19968: 0xF7E1,
	25239 - 19968: 0xF9F7,
	25240 - 19968: 0xEFB9,
	25243 - 19968: 0xF8D8,
	25259 - 19968: 0xF9A9,
	25265 - 19968: 0xF8D9,
	25269 - 19968: 0xEEBD,
	25273 - 19968: 0xD8C6,
	25276 - 19968: 0xE4E3,
	25277 - 19968: 0xF5CE,
	25282 - 19968: 0xDDD9,
	25287 - 19968: 0xD9E7,
	25288 - 19968: 0xD2B9,
	25289 - 19968: 0xD5C3,
	25292 - 19968: 0xDAE5,
	25293 - 19968: 0xDAD0,
	25295 - 19968: 0xD1D9,
	25296 - 19968: 0xCED8,
	25298 - 19968: 0xCBDE,
	25299 - 19968: 0xF4AC,
	25300 - 19968: 0xDAFB,
	25302 - 19968: 0xF6E9,
	25303 - 19968: 0xE8F3,
	25304 - 19968: 0xCFAC,
	25305 - 19968: 0xF0F0,
	25307 - 19968: 0xF4FD,
	25308 - 19968: 0xDBC8,
	25324 - 19968: 0xCEC0,
	25325 - 19968: 0xE3D4,
	25326 - 19968: 0xD1CF,
	25327 - 19968: 0xF1F5,
	25329 - 19968: 0xCDF2,
	25331 - 19968: 0xCFEB,
	25335 - 19968: 0xCDB8,
	25342 - 19968: 0xE3A6,
	25343 - 19968: 0xD1DA,
	25345 - 19968: 0xF2A5,
	25351 - 19968: 0xF2A6,
	25353 - 19968: 0xE4CE,
	25361 - 19968: 0xD3FB,
	25387 - 19968: 0xF1A9,
	25391 - 19968: 0xF2C9,
	25402 - 19968: 0xEFD8,
	25403 - 19968: 0xE6C9,
	25405 - 19968: 0xD8B8,
	25406 - 19968: 0xFAF3,
	25417 - 19968: 0xF3B5,
	25420 - 19968: 0xF8A4,
	25423 - 19968: 0xD1F3,
	25424 - 19968: 0xE6C8,
	25429 - 19968: 0xF8DA,
	25447 - 19968: 0xDCE9,
	25448 - 19968: 0xDED7,
	25454 - 19968: 0xCBDF,
	25458 - 19968: 0xCFEC,
	25463 - 19968: 0xF4DF,
	25466 - 19968: 0xD1F4,
	25467 - 19968: 0xD2BA,
	25471 - 19968: 0xDFF2,
	25475 - 19968: 0xE1B7,
	25480 - 19968: 0xE2A3,
	25481 - 19968: 0xD3FC,
	25484 - 19968: 0xEDE6,
	25490 - 19968: 0xDBC9,
	25494 - 19968: 0xE4FA,
	25496 - 19968: 0xCFDE,
	25499 - 19968: 0xCED0,
	25504 - 19968: 0xD5D3,
	25505 - 19968: 0xF3F5,
	25506 - 19968: 0xF7AE,
	25509 - 19968: 0xEFC8,
	25511 - 19968: 0xCDF3,
	25512 - 19968: 0xF5CF,
	25513 - 19968: 0xE5F3,
	25514 - 19968: 0xF0C2,
	25536 - 19968: 0xCAD1,
	25540 - 19968: 0xEAF1,
	25542 - 19968: 0xD0A6,
	25551 - 19968: 0xD9DA,
	25552 - 19968: 0xF0AB,
	25558 - 19968: 0xEBE7,
	25562 - 19968: 0xE5C0,
	25563 - 19968: 0xFCB5,
	25569 - 19968: 0xE4C4,
	25581 - 19968: 0xCCA9,
	25582 - 19968: 0xFDC6,
	25588 - 19968: 0xEAB5,
	25590 - 19968: 0xE5AA,
	25591 - 19968: 0xDFBA,
	25613 - 19968: 0xE1DF,
	25615 - 19968: 0xDAD1,
	25620 - 19968: 0xE1B8,
	25622 - 19968: 0xE8F4,
	25623 - 19968: 0xD3FD,
	25628 - 19968: 0xE2A4,
	25634 - 19968: 0xF2CA,
	25644 - 19968: 0xDAE6,
	25645 - 19968: 0xF7B3,
	25658 - 19968: 0xFDCD,
	25662 - 19968: 0xF3B6,
	25688 - 19968: 0xEED7,
	25696 - 19968: 0xF5C4,
	25705 - 19968: 0xD8A4,
	25711 - 19968: 0xF2A7,
	25720 - 19968: 0xD9B8,
	25721 - 19968: 0xD9B9,
	25722 - 19968: 0xEFC9,
	25736 - 19968: 0xD6CE,
	25745 - 19968: 0xF7CB,
	25746 - 19968: 0xDFAE,
	25747 - 19968: 0xE8F5,
	25754 - 19968: 0xD2B5,
	25758 - 19968: 0xD3D5,
	25764 - 19968: 0xF4CC,
	25765 - 19968: 0xDAFC,
	25771 - 19968: 0xD9E8,
	25773 - 19968: 0xF7EB,
	25774 - 19968: 0xF5C9,
	25776 - 19968: 0xF3BC,
	25778 - 19968: 0xDAD2,
	25787 - 19968: 0xD3B5,
	25793 - 19968: 0xE8B6,
	25796 - 19968: 0xD6CF,
	25797 - 19968: 0xF4BA,
	25799 - 19968: 0xF7C9,
	25802 - 19968: 0xCCAA,
	25805 - 19968: 0xF0C3,
	25806 - 19968: 0xCCD6,
	25810 - 19968: 0xD0D3,
	25812 - 19968: 0xD3BD,
	25816 - 19968: 0xDBFB,
	25818 - 19968: 0xCBE0,
	25825 - 19968: 0xD3E4,
	25826 - 19968: 0xF6F7,
	25829 - 19968: 0xD5BA,
	25830 - 19968: 0xF3CD,
	25831 - 19968: 0xCBE1,
	25836 - 19968: 0xEBF4,
	25842 - 19968: 0xF4AD,
	25844 - 19968: 0xFCAA,
	25850 - 19968: 0xF7EC,
	25854 - 19968: 0xE8F6,
	25856 - 19968: 0xDAE7,
	25860 - 19968: 0xF7CC,
	25880 - 19968: 0xE5C1,
	25885 - 19968: 0xE0EE,
	25891 - 19968: 0xD5FD,
	25898 - 19968: 0xCEE6,
	25899 - 19968: 0xFCAB,
	25900 - 19968: 0xD5BB,
	25903 - 19968: 0xF2A8,
	25910 - 19968: 0xE2A5,
	25911 - 19968: 0xCDB9,
	25912 - 19968: 0xEAF2,
	25913 - 19968: 0xCBC7,
	25915 - 19968: 0xCDF4,
	25918 - 19968: 0xDBAF,
	25919 - 19968: 0xEFD9,
	25925 - 19968: 0xCDBA,
	25928 - 19968: 0xFCF9,
	25933 - 19968: 0xDFF3,
	25934 - 19968: 0xCEE7,
	25935 - 19968: 0xDAC2,
	25937 - 19968: 0xCFAD,
	25942 - 19968: 0xE7F9,
	25943 - 19968: 0xF8A8,
	25950 - 19968: 0xF3E2,
	25954 - 19968: 0xCAF2,
	25955 - 19968: 0xDFA4,
	25958 - 19968: 0xD4C4,
	25964 - 19968: 0xCCD7,
	25965 - 19968: 0xE5C2,
	25970 - 19968: 0xCDBB,
	25972 - 19968: 0xEFDA,
	25973 - 19968: 0xEED8,
	25975 - 19968: 0xDDA7,
	25976 - 19968: 0xE2A6,
	25982 - 19968: 0xE0C0,
	25986 - 19968: 0xD6B0,
	25987 - 19968: 0xF8CA,
	25989 - 19968: 0xFCFA,
	25991 - 19968: 0xD9FE,
	25996 - 19968: 0xDEB0,
	26000 - 19968: 0xDDEC,
	26001 - 19968: 0xDAE8,
	26007 - 19968: 0xD4E0,
	26009 - 19968: 0xD6F9,
	26011 - 19968: 0xCDD7,
	26012 - 19968: 0xDED8,
	26015 - 19968: 0xF2F8,
	26017 - 19968: 0xE4D6,
	26020 - 19968: 0xD0C5,
	26021 - 19968: 0xF4AE,
	26023 - 19968: 0xDDA8,
	26027 - 19968: 0xEDC5,
	26028 - 19968: 0xF3D6,
	26031 - 19968: 0xDED9,
	26032 - 19968: 0xE3E6,
	26039 - 19968: 0xD3A8,
	26041 - 19968: 0xDBB0,
	26044 - 19968: 0xE5DA,
	26045 - 19968: 0xE3BF,
	26049 - 19968: 0xDBB1,
	26053 - 19968: 0xD5E9,
	26059 - 19968: 0xE0C1,
	26060 - 19968: 0xEFDB,
	26063 - 19968: 0xF0E9,
	26066 - 19968: 0xD7B2,
	26071 - 19968: 0xD0FD,
	26080 - 19968: 0xD9E9,
	26083 - 19968: 0xD0FE,
	26085 - 19968: 0xECED,
	26086 - 19968: 0xD3A9,
	26088 - 19968: 0xF2A9,
	26089 - 19968: 0xF0C4,
	26092 - 19968: 0xE2E2,
	26093 - 19968: 0xE9EF,
	26097 - 19968: 0xF9D1,
	26100 - 19968: 0xE9D9,
	26106 - 19968: 0xE8DA,
	26107 - 19968: 0xDAC3,
	26108 - 19968: 0xDAC4,
	26109 - 19968: 0xD4C5,
	26111 - 19968: 0xE7FA,
	26118 - 19968: 0xCDE0,
	26119 - 19968: 0xE3B0,
	26121 - 19968: 0xDBB2,
	26122 - 19968: 0xFBC4,
	26124 - 19968: 0xF3E3,
	26126 - 19968: 0xD9A5,
	26127 - 19968: 0xFBE7,
	26128 - 19968: 0xDDCB,
	26129 - 19968: 0xD0D4,
	26131 - 19968: 0xE6B6,
	26132 - 19968: 0xE0AE,
	26133 - 19968: 0xFDDA,
	26142 - 19968: 0xDCB5,
	26143 - 19968: 0xE0F8,
	26144 - 19968: 0xE7B1,
	26149 - 19968: 0xF5F0,
	26151 - 19968: 0xD8DC,
	26152 - 19968: 0xEDC6,
	26157 - 19968: 0xE1B9,
	26159 - 19968: 0xE3C0,
	26160 - 19968: 0xF9C0,
	26161 - 19968: 0xE9F0,
	26164 - 19968: 0xD9DB,
	26166 - 19968: 0xF3E4,
	26170 - 19968: 0xDCB6,
	26171 - 19968: 0xE4E9,
	26177 - 19968: 0xF0C5,
	26178 - 19968: 0xE3C1,
	26179 - 19968: 0xFCCC,
	26180 - 19968: 0xFCCD,
	26185 - 19968: 0xF2CB,
	26187 - 19968: 0xF2CC,
	26191 - 19968: 0xE4CF,
	26201 - 19968: 0xF1DB,
	26203 - 19968: 0xFAD9,
	26205 - 19968: 0xF1B8,
	26206 - 19968: 0xFDF5,
	26207 - 19968: 0xE0F9,
	26212 - 19968: 0xE7FB,
	26213 - 19968: 0xFCB7,
	26214 - 19968: 0xFCE4,
	26215 - 19968: 0xFBC5,
	26216 - 19968: 0xE3E7,
	26217 - 19968: 0xD8B9,
	26219 - 19968: 0xF6F8,
	26222 - 19968: 0xDCC5,
	26223 - 19968: 0xCCD8,
	26227 - 19968: 0xE0AF,
	26228 - 19968: 0xF4E7,
	26230 - 19968: 0xEFDC,
	26231 - 19968: 0xCFFC,
	26232 - 19968: 0xEFDD,
	26234 - 19968: 0xF2AA,
	26244 - 19968: 0xFDBE,
	26247 - 19968: 0xCAAC,
	26248 - 19968: 0xFDBB,
	26249 - 19968: 0xFDC7,
	26254 - 19968: 0xE7B2,
	26256 - 19968: 0xEAD1,
	26257 - 19968: 0xDFF4,
	26262 - 19968: 0xD1EC,
	26263 - 19968: 0xE4DE,
	26264 - 19968: 0xE5C3,
	26269 - 19968: 0xD9A6,
	26272 - 19968: 0xCDBC,
	26274 - 19968: 0xF3E5,
	26283 - 19968: 0xEDD5,
	26286 - 19968: 0xD9BA,
	26290 - 19968: 0xEDE7,
	26291 - 19968: 0xFBB5,
	26292 - 19968: 0xF8EC,
	26297 - 19968: 0xE0E7,
	26299 - 19968: 0xCCD9,
	26302 - 19968: 0xD4C6,
	26308 - 19968: 0xE7A5,
	26310 - 19968: 0xD5F5,
	26311 - 19968: 0xD3BE,
	26313 - 19968: 0xFCFB,
	26326 - 19968: 0xE4F2,
	26329 - 19968: 0xDFF5,
	26332 - 19968: 0xE8F8,
	26333 - 19968: 0xF8ED,
	26336 - 19968: 0xCEC7,
	26342 - 19968: 0xFDF6,
	26352 - 19968: 0xE8D8,
	26354 - 19968: 0xCDD8,
	26355 - 19968: 0xE7D6,
	26356 - 19968: 0xCCDA,
	26359 - 19968: 0xCAE3,
	26360 - 19968: 0xDFF6,
	26361 - 19968: 0xF0C7,
	26362 - 19968: 0xF0C6,
	26364 - 19968: 0xD8BA,
	26366 - 19968: 0xF1F4,
	26367 - 19968: 0xF4F0,
	26368 - 19968: 0xF5CC,
	26371 - 19968: 0xFCE5,
	26376 - 19968: 0xEAC5,
	26377 - 19968: 0xEAF3,
	26379 - 19968: 0xDDDB,
	26381 - 19968: 0xDCD7,
	26388 - 19968: 0xDEFD,
	26389 - 19968: 0xF2F9,
	26391 - 19968: 0xD5C7,
	26395 - 19968: 0xD8D0,
	26397 - 19968: 0xF0C8,
	26398 - 19968: 0xD1A1,
	26399 - 19968: 0xD1A2,
	26406 - 19968: 0xD9D4,
	26407 - 19968: 0xD6E8,
	26408 - 19968: 0xD9CA,
	26410 - 19968: 0xDAB1,
	26411 - 19968: 0xD8C7,
	26412 - 19968: 0xDCE2,
	26413 - 19968: 0xF3CE,
	26414 - 19968: 0xF5F4,
	26417 - 19968: 0xF1B9,
	26420 - 19968: 0xDAD3,
	26422 - 19968: 0xF6EA,
	26426 - 19968: 0xCFF5,
	26429 - 19968: 0xFDAE,
	26438 - 19968: 0xCAD2,
	26441 - 19968: 0xDFB4,
	26446 - 19968: 0xD7DD,
	26447 - 19968: 0xFABA,
	26448 - 19968: 0xEEA7,
	26449 - 19968: 0xF5BD,
	26451 - 19968: 0xF8F5,
	26454 - 19968: 0xEDE8,
	26460 - 19968: 0xD4E1,
	26462 - 19968: 0xD1A3,
	26463 - 19968: 0xE1D6,
	26477 - 19968: 0xF9F8,
	26479 - 19968: 0xDBCA,
	26480 - 19968: 0xCBF9,
	26481 - 19968: 0xD4D4,
	26483 - 19968: 0xD9DC,
	26485 - 19968: 0xEEBE,
	26487 - 19968: 0xF7ED,
	26491 - 19968: 0xD2EE,
	26494 - 19968: 0xE1E6,
	26495 - 19968: 0xF7F9,
	26503 - 19968: 0xDDED,
	26505 - 19968: 0xE8DB,
	26507 - 19968: 0xDBB3,
	26511 - 19968: 0xD1F7,
	26512 - 19968: 0xE0B0,
	26515 - 19968: 0xD4E2,
	26517 - 19968: 0xF6D7,
	26519 - 19968: 0xD7F9,
	26522 - 19968: 0xD8DD,
	26524 - 19968: 0xCDFD,
	26525 - 19968: 0xF2AB,
	26543 - 19968: 0xCDBD,
	26544 - 19968: 0xF8C2,
	26547 - 19968: 0xF2AC,
	26550 - 19968: 0xCAAD,
	26551 - 19968: 0xCAAE,
	26552 - 19968: 0xCFAE,
	26558 - 19968: 0xE3C2,
	26564 - 19968: 0xDCB7,
	26575 - 19968: 0xDBDA,
	26576 - 19968: 0xD9BB,
	26577 - 19968: 0xCAF3,
	26578 - 19968: 0xF6D3,
	26579 - 19968: 0xE6F8,
	26580 - 19968: 0xEAF5,
	26586 - 19968: 0xEAF6,
	26589 - 19968: 0xF6F9,
	26601 - 19968: 0xCFAF,
	26604 - 19968: 0xCAD3,
	26607 - 19968: 0xCAAF,
	26608 - 19968: 0xD2B0,
	26609 - 19968: 0xF1BA,
	26611 - 19968: 0xD7B3,
	26612 - 19968: 0xE3C3,
	26613 - 19968: 0xF3FD,
	26614 - 19968: 0xDEDA,
	26619 - 19968: 0xDEDB,
	26622 - 19968: 0xEFDE,
	26642 - 19968: 0xE2E3,
	26643 - 19968: 0xEEFB,
	26646 - 19968: 0xDFF7,
	26647 - 19968: 0xD7CA,
	26657 - 19968: 0xCEE8,
	26658 - 19968: 0xDBDB,
	26666 - 19968: 0xF1BB,
	26671 - 19968: 0xE9F1,
	26680 - 19968: 0xFAB7,
	26681 - 19968: 0xD0C6,
	26684 - 19968: 0xCCAB,
	26685 - 19968: 0xEEA8,
	26688 - 19968: 0xCBFA,
	26689 - 19968: 0xF9F9,
	26690 - 19968: 0xCCFD,
	26691 - 19968: 0xD3FE,
	26696 - 19968: 0xE4D0,
	26702 - 19968: 0xF2EE,
	26704 - 19968: 0xD4D5,
	26705 - 19968: 0xDFCD,
	26707 - 19968: 0xFCB8,
	26708 - 19968: 0xD1D0,
	26733 - 19968: 0xF2CD,
	26742 - 19968: 0xF7D2,
	26751 - 19968: 0xCAD4,
	26753 - 19968: 0xD5D9,
	26757 - 19968: 0xD8DE,
	26767 - 19968: 0xCDD9,
	26771 - 19968: 0xEEA9,
	26772 - 19968: 0xF6BC,
	26775 - 19968: 0xCCDB,
	26781 - 19968: 0xF0C9,
	26783 - 19968: 0xFCFC,
	26785 - 19968: 0xE8C9,
	26786 - 19968: 0xF4FE,
	26791 - 19968: 0xE7FC,
	26792 - 19968: 0xD7DE,
	26797 - 19968: 0xDEDC,
	26799 - 19968: 0xF0AC,
	26800 - 19968: 0xCCFE,
	26801 - 19968: 0xCDE1,
	26803 - 19968: 0xE1BA,
	26805 - 19968: 0xDBEF,
	26806 - 19968: 0xDAB2,
	26820 - 19968: 0xD1A5,
	26821 - 19968: 0xDCB8,
	26825 - 19968: 0xD8F6,
	26827 - 19968: 0xD1A4,
	26829 - 19968: 0xCDE2,
	26834 - 19968: 0xDCEA,
	26837 - 19968: 0xF0F7,
	26839 - 19968: 0xF0CA,
	26840 - 19968: 0xD0BE,
	26842 - 19968: 0xDDDC,
	26847 - 19968: 0xD4D6,
	26848 - 19968: 0xD3D6,
	26855 - 19968: 0xEDD0,
	26856 - 19968: 0xCDA1,
	26862 - 19968: 0xDFB5,
	26866 - 19968: 0xDFF8,
	26873 - 19968: 0xD4A1,
	26874 - 19968: 0xCEB2,
	26880 - 19968: 0xE8CA,
	26885 - 19968: 0xEBF5,
	26893 - 19968: 0xE3D5,
	26894 - 19968: 0xF5D0,
	26898 - 19968: 0xF5A1,
	26919 - 19968: 0xD9A7,
	26928 - 19968: 0xE5AB,
	26941 - 19968: 0xE6CB,
	26943 - 19968: 0xF5F1,
	26954 - 19968: 0xE5C5,
	26963 - 19968: 0xF9A3,
	26964 - 19968: 0xE0DB,
	26965 - 19968: 0xF6EB,
	26967 - 19968: 0xCBF1,
	26969 - 19968: 0xD9EA,
	26970 - 19968: 0xF5A2,
	26974 - 19968: 0xD7D1,
	26976 - 19968: 0xD1F8,
	26977 - 19968: 0xEAF8,
	26978 - 19968: 0xEAF9,
	26979 - 19968: 0xDAB3,
	26984 - 19968: 0xEFDF,
	26987 - 19968: 0xF1EF,
	26989 - 19968: 0xE5F6,
	26990 - 19968: 0xEEBF,
	26991 - 19968: 0xE2E4,
	26997 - 19968: 0xD0BF,
	26999 - 19968: 0xFAAC,
	27000 - 19968: 0xF5D1,
	27001 - 19968: 0xE7B3,
	27029 - 19968: 0xE9BE,
	27035 - 19968: 0xF2CE,
	27036 - 19968: 0xDBB4,
	27045 - 19968: 0xFCCE,
	27047 - 19968: 0xDDEE,
	27054 - 19968: 0xE7B4,
	27060 - 19968: 0xD7B4,
	27067 - 19968: 0xF7B4,
	27073 - 19968: 0xCDBE,
	27075 - 19968: 0xDAE9,
	27083 - 19968: 0xCFB0,
	27084 - 19968: 0xF7D9,
	27085 - 19968: 0xF3E6,
	27088 - 19968: 0xCED9,
	27112 - 19968: 0xCEAA,
	27114 - 19968: 0xCBC8,
	27131 - 19968: 0xD0A7,
	27133 - 19968: 0xF0CB,
	27135 - 19968: 0xD0C7,
	27138 - 19968: 0xE4C5,
	27146 - 19968: 0xDBE0,
	27153 - 19968: 0xD5DA,
	27155 - 19968: 0xD7A7,
	27159 - 19968: 0xEEC0,
	27161 - 19968: 0xF8F6,
	27166 - 19968: 0xF5D2,
	27167 - 19968: 0xEDE9,
	27169 - 19968: 0xD9BC,
	27171 - 19968: 0xE5C6,
	27189 - 19968: 0xF5A3,
	27192 - 19968: 0xDAD4,
	27193 - 19968: 0xE2A7,
	27194 - 19968: 0xFBFC,
	27197 - 19968: 0xF1DC,
	27204 - 19968: 0xCAF4,
	27208 - 19968: 0xE8FA,
	27211 - 19968: 0xCEE9,
	27218 - 19968: 0xE9F8,
	27219 - 19968: 0xE2E5,
	27224 - 19968: 0xD0B9,
	27225 - 19968: 0xD4F2,
	27231 - 19968: 0xD1A6,
	27233 - 19968: 0xDFCE,
	27243 - 19968: 0xFCF4,
	27264 - 19968: 0xD3AA,
	27268 - 19968: 0xCCAC,
	27273 - 19968: 0xEFE0,
	27277 - 19968: 0xE5E5,
	27278 - 19968: 0xD0D5,
	27287 - 19968: 0xDBFC,
	27292 - 19968: 0xFCE6,
	27298 - 19968: 0xCBFE,
	27299 - 19968: 0xEDEA,
	27315 - 19968: 0xDEB1,
	27323 - 19968: 0xF9E3,
	27330 - 19968: 0xD4A2,
	27331 - 19968: 0xCFF6,
	27347 - 19968: 0xD6D0,
	27354 - 19968: 0xD5EA,
	27355 - 19968: 0xF1EE,
	27382 - 19968: 0xFACB,
	27387 - 19968: 0xE5A1,
	27396 - 19968: 0xD5B1,
	27402 - 19968: 0xCFED,
	27404 - 19968: 0xEDEB,
	27410 - 19968: 0xD5B2,
	27414 - 19968: 0xD5BC,
	27424 - 19968: 0xFDE2,
	27425 - 19968: 0xF3AD,
	27427 - 19968: 0xFDDB,
	27442 - 19968: 0xE9B0,
	27450 - 19968: 0xD1A7,
	27453 - 19968: 0xFDE3,
	27454 - 19968: 0xCEB3,
	27462 - 19968: 0xFDE4,
	27463 - 19968: 0xFACE,
	27468 - 19968: 0xCAB0,
	27470 - 19968: 0xF7A7,
	27472 - 19968: 0xCFB1,
	27487 - 19968: 0xE6A2,
	27489 - 19968: 0xFCB6,
	27490 - 19968: 0xF2AD,
	27491 - 19968: 0xEFE1,
	27492 - 19968: 0xF3AE,
	27493 - 19968: 0xDCC6,
	27494 - 19968: 0xD9EB,
	27498 - 19968: 0xE8E0,
	27506 - 19968: 0xE1A8,
	27511 - 19968: 0xD5F6,
	27512 - 19968: 0xCFFD,
	27515 - 19968: 0xDEDD,
	27519 - 19968: 0xD9D1,
	27523 - 19968: 0xE4EA,
	27524 - 19968: 0xF2CF,
	27526 - 19968: 0xF7BF,
	27529 - 19968: 0xE2E6,
	27530 - 19968: 0xE2A8,
	27542 - 19968: 0xE3D6,
	27544 - 19968: 0xEDD1,
	27550 - 19968: 0xE9F9,
	27566 - 19968: 0xD6B1,
	27567 - 19968: 0xDEB2,
	27570 - 19968: 0xE0E8,
	27573 - 19968: 0xD3AB,
	27575 - 19968: 0xEBDC,
	27578 - 19968: 0xDFAF,
	27580 - 19968: 0xCAC3,
	27583 - 19968: 0xEEFC,
	27585 - 19968: 0xFDC3,
	27589 - 19968: 0xEBF6,
	27590 - 19968: 0xCFB2,
	27595 - 19968: 0xD9EC,
	27597 - 19968: 0xD9BD,
	27599 - 19968: 0xD8DF,
	27602 - 19968: 0xD4B8,
	27603 - 19968: 0xEBBE,
	27604 - 19968: 0xDDEF,
	27606 - 19968: 0xDDF0,
	27607 - 19968: 0xDDF1,
	27608 - 19968: 0xDDF2,
	27611 - 19968: 0xD9BE,
	27627 - 19968: 0xFBC6,
	27628 - 19968: 0xCFB3,
	27656 - 19968: 0xEEFD,
	27663 - 19968: 0xE4AB,
	27665 - 19968: 0xDAC5,
	27667 - 19968: 0xD8EC,
	27683 - 19968: 0xD1A8,
	27700 - 19968: 0xE2A9,
	27703 - 19968: 0xDEBC,
	27704 - 19968: 0xE7B5,
	27710 - 19968: 0xDBF0,
	27712 - 19968: 0xEFE2,
	27713 - 19968: 0xF1F0,
	27714 - 19968: 0xCFB4,
	27726 - 19968: 0xDBF1,
	27728 - 19968: 0xE0B1,
	27733 - 19968: 0xDFA5,
	27735 - 19968: 0xF9D2,
	27738 - 19968: 0xE7FD,
	27741 - 19968: 0xE6A3,
	27742 - 19968: 0xFBF1,
	27743 - 19968: 0xCBB0,
	27744 - 19968: 0xF2AE,
	27752 - 19968: 0xCDE7,
	27754 - 19968: 0xE8DC,
	27757 - 19968: 0xE7D7,
	27760 - 19968: 0xF7C0,
	27762 - 19968: 0xD0E3,
	27766 - 19968: 0xDAA1,
	27770 - 19968: 0xCCBD,
	27773 - 19968: 0xD1A9,
	27774 - 19968: 0xDDCC,
	27777 - 19968: 0xE3FE,
	27778 - 19968: 0xD1AA,
	27779 - 19968: 0xE8AA,
	27781 - 19968: 0xEAB6,
	27782 - 19968: 0xF9FA,
	27783 - 19968: 0xE6CC,
	27784 - 19968: 0xF6D8,
	27788 - 19968: 0xD4C7,
	27792 - 19968: 0xD9CB,
	27794 - 19968: 0xD9D2,
	27795 - 19968: 0xD3CB,
	27796 - 19968: 0xD8F7,
	27797 - 19968: 0xDAA9,
	27798 - 19968: 0xF5F8,
	27801 - 19968: 0xDEDE,
	27802 - 19968: 0xF2AF,
	27803 - 19968: 0xF8A9,
	27819 - 19968: 0xD8C8,
	27822 - 19968: 0xEEC1,
	27827 - 19968: 0xF9C1,
	27832 - 19968: 0xDDF3,
	27833 - 19968: 0xEAFA,
	27835 - 19968: 0xF6BD,
	27836 - 19968: 0xE1BB,
	27837 - 19968: 0xCDBF,
	27838 - 19968: 0xF4D4,
	27839 - 19968: 0xE6CD,
	27841 - 19968: 0xFCCF,
	27842 - 19968: 0xFBA2,
	27844 - 19968: 0xE0DC,
	27849 - 19968: 0xF4BB,
	27850 - 19968: 0xDAD5,
	27852 - 19968: 0xF9B2,
	27859 - 19968: 0xFBF2,
	27861 - 19968: 0xDBF6,
	27863 - 19968: 0xDEDF,
	27867 - 19968: 0xDBF2,
	27873 - 19968: 0xF8DC,
	27874 - 19968: 0xF7EE,
	27875 - 19968: 0xEBE8,
	27877 - 19968: 0xD2FA,
	27880 - 19968: 0xF1BC,
	27883 - 19968: 0xFADA,
	27886 - 19968: 0xDAEA,
	27887 - 19968: 0xDAC6,
	27888 - 19968: 0xF7C1,
	27891 - 19968: 0xE7B6,
	27915 - 19968: 0xE5C7,
	27916 - 19968: 0xD6AC,
	27921 - 19968: 0xDCC7,
	27927 - 19968: 0xE1A9,
	27929 - 19968: 0xE2AA,
	27931 - 19968: 0xD5A6,
	27934 - 19968: 0xD4D7,
	27941 - 19968: 0xF2D0,
	27943 - 19968: 0xEAFB,
	27945 - 19968: 0xE0DD,
	27946 - 19968: 0xFBF3,
	27954 - 19968: 0xF1BD,
	27957 - 19968: 0xE2E7,
	27958 - 19968: 0xFDD7,
	27960 - 19968: 0xCEC8,
	27961 - 19968: 0xEAB7,
	27963 - 19968: 0xFCC0,
	27965 - 19968: 0xFDE7,
	27966 - 19968: 0xF7EF,
	27969 - 19968: 0xD7B5,
	27993 - 19968: 0xEFBA,
	27994 - 19968: 0xF1DD,
	27996 - 19968: 0xDEB3,
	28003 - 19968: 0xE8CB,
	28006 - 19968: 0xF8DD,
	28009 - 19968: 0xFBC7,
	28010 - 19968: 0xD5C8,
	28012 - 19968: 0xD7DF,
	28014 - 19968: 0xDDA9,
	28020 - 19968: 0xE9B1,
	28023 - 19968: 0xFAAD,
	28024 - 19968: 0xF6D9,
	28025 - 19968: 0xFAF4,
	28031 - 19968: 0xF8AA,
	28037 - 19968: 0xE6EE,
	28039 - 19968: 0xCCDC,
	28040 - 19968: 0xE1BC,
	28041 - 19968: 0xE0EF,
	28044 - 19968: 0xE9BF,
	28045 - 19968: 0xFCFD,
	28046 - 19968: 0xE6CE,
	28049 - 19968: 0xE1D7,
	28051 - 19968: 0xE6CF,
	28053 - 19968: 0xF4F1,
	28079 - 19968: 0xE4F3,
	28082 - 19968: 0xE4FB,
	28085 - 19968: 0xF9E4,
	28096 - 19968: 0xEFE3,
	28099 - 19968: 0xCFEE,
	28100 - 19968: 0xF6BE,
	28101 - 19968: 0xE0B2,
	28102 - 19968: 0xFCFE,
	28103 - 19968: 0xD1AB,
	28107 - 19968: 0xD7FA,
	28111 - 19968: 0xFBC8,
	28113 - 19968: 0xE2D7,
	28120 - 19968: 0xD4A3,
	28121 - 19968: 0xF0F8,
	28122 - 19968: 0xD7A8,
	28126 - 19968: 0xE1E7,
	28129 - 19968: 0xD3BF,
	28136 - 19968: 0xEFE4,
	28138 - 19968: 0xD7C5,
	28139 - 19968: 0xEBE2,
	28142 - 19968: 0xFCE7,
	28145 - 19968: 0xE4A2,
	28147 - 19968: 0xE2E8,
	28149 - 19968: 0xE6D0,
	28151 - 19968: 0xFBE8,
	28152 - 19968: 0xF4E8,
	28153 - 19968: 0xE5F4,
	28154 - 19968: 0xF4BC,
	28155 - 19968: 0xF4D5,
	28183 - 19968: 0xDFB6,
	28185 - 19968: 0xFCB9,
	28186 - 19968: 0xEEC2,
	28187 - 19968: 0xCAF5,
	28191 - 19968: 0xEFE5,
	28192 - 19968: 0xCBE2,
	28193 - 19968: 0xD4A4,
	28195 - 19968: 0xDEE0,
	28196 - 19968: 0xDAFD,
	28197 - 19968: 0xE4C6,
	28198 - 19968: 0xE8BE,
	28203 - 19968: 0xE0DE,
	28204 - 19968: 0xF6B4,
	28205 - 19968: 0xEAD2,
	28207 - 19968: 0xF9FB,
	28210 - 19968: 0xE0C2,
	28212 - 19968: 0xCAE4,
	28214 - 19968: 0xE7B7,
	28216 - 19968: 0xEAFD,
	28218 - 19968: 0xD9DD,
	28220 - 19968: 0xDAB4,
	28221 - 19968: 0xEEAA,
	28222 - 19968: 0xFBE9,
	28227 - 19968: 0xDBCB,
	28228 - 19968: 0xDAB5,
	28234 - 19968: 0xF1BE,
	28237 - 19968: 0xD3AC,
	28246 - 19968: 0xFBC9,
	28248 - 19968: 0xDFCF,
	28251 - 19968: 0xD3C0,
	28252 - 19968: 0xE3D7,
	28254 - 19968: 0xEFE6,
	28255 - 19968: 0xFCD0,
	28263 - 19968: 0xE9C0,
	28267 - 19968: 0xF5D3,
	28270 - 19968: 0xECDC,
	28271 - 19968: 0xF7B7,
	28274 - 19968: 0xEAB8,
	28275 - 19968: 0xD1F9,
	28282 - 19968: 0xDCC8,
	28304 - 19968: 0xEAB9,
	28310 - 19968: 0xF1DE,
	28316 - 19968: 0xD7B6,
	28317 - 19968: 0xCFB5,
	28319 - 19968: 0xD9A8,
	28322 - 19968: 0xECEE,
	28325 - 19968: 0xDDAA,
	28330 - 19968: 0xCDA2,
	28331 - 19968: 0xE8AE,
	28335 - 19968: 0xE1BD,
	28337 - 19968: 0xF2D1,
	28342 - 19968: 0xE9C1,
	28346 - 19968: 0xD2FC,
	28354 - 19968: 0xDBB5,
	28356 - 19968: 0xF3E7,
	28357 - 19968: 0xD8FE,
	28361 - 19968: 0xFCD1,
	28363 - 19968: 0xEDB2,
	28364 - 19968: 0xF4AF,
	28366 - 19968: 0xFBA3,
	28369 - 19968: 0xFCC1,
	28371 - 19968: 0xEEAB,
	28372 - 19968: 0xD4A5,
	28399 - 19968: 0xF4F2,
	28404 - 19968: 0xEED9,
	28408 - 19968: 0xFBCA,
	28414 - 19968: 0xCDE3,
	28415 - 19968: 0xD8BB,
	28417 - 19968: 0xE5DB,
	28418 - 19968: 0xF8F7,
	28422 - 19968: 0xF6D4,
	28431 - 19968: 0xD7A9,
	28433 - 19968: 0xCBC9,
	28436 - 19968: 0xE6D1,
	28437 - 19968: 0xF0CC,
	28448 - 19968: 0xD8AE,
	28450 - 19968: 0xF9D3,
	28451 - 19968: 0xD5FE,
	28459 - 19968: 0xD8BC,
	28460 - 19968: 0xF2B0,
	28465 - 19968: 0xE2AB,
	28466 - 19968: 0xF3E8,
	28472 - 19968: 0xEFC2,
	28479 - 19968: 0xEDEC,
	28481 - 19968: 0xE7B8,
	28497 - 19968: 0xDAFE,
	28500 - 19968: 0xCCBE,
	28503 - 19968: 0xF2FC,
	28504 - 19968: 0xDAEB,
	28506 - 19968: 0xE2D8,
	28507 - 19968: 0xEDD6,
	28510 - 19968: 0xD6D1,
	28511 - 19968: 0xE0B3,
	28514 - 19968: 0xFCD2,
	28516 - 19968: 0xEBC8,
	28525 - 19968: 0xD3C1,
	28526 - 19968: 0xF0CD,
	28528 - 19968: 0xCFF7,
	28538 - 19968: 0xEDD2,
	28540 - 19968: 0xD4D8,
	28541 - 19968: 0xDCC9,
	28542 - 19968: 0xD7F1,
	28545 - 19968: 0xDFBB,
	28548 - 19968: 0xF3A5,
	28552 - 19968: 0xF4CD,
	28557 - 19968: 0xF1BF,
	28558 - 19968: 0xF8B1,
	28560 - 19968: 0xE9FA,
	28564 - 19968: 0xFBCB,
	28567 - 19968: 0xCAD5,
	28579 - 19968: 0xF9D4,
	28580 - 19968: 0xF7CA,
	28583 - 19968: 0xD6C8,
	28590 - 19968: 0xFCE8,
	28591 - 19968: 0xF3BD,
	28593 - 19968: 0xEEFE,
	28595 - 19968: 0xE7FE,
	28601 - 19968: 0xD3C2,
	28606 - 19968: 0xD3B6,
	28608 - 19968: 0xCCAD,
	28609 - 19968: 0xF6FA,
	28610 - 19968: 0xD6B2,
	28611 - 19968: 0xD2D8,
	28618 - 19968: 0xE7D8,
	28629 - 19968: 0xE3A5,
	28634 - 19968: 0xE7B9,
	28639 - 19968: 0xF0AD,
	28640 - 19968: 0xFBCC,
	28641 - 19968: 0xEBA1,
	28644 - 19968: 0xD4A6,
	28649 - 19968: 0xFBCD,
	28651 - 19968: 0xD5BD,
	28652 - 19968: 0xF1DF,
	28655 - 19968: 0xF6FB,
	28657 - 19968: 0xDEB4,
	28670 - 19968: 0xD5EB,
	28673 - 19968: 0xE5C8,
	28677 - 19968: 0xFBA4,
	28678 - 19968: 0xD4B9,
	28681 - 19968: 0xDEE1,
	28683 - 19968: 0xE4A3,
	28687 - 19968: 0xD7B7,
	28689 - 19968: 0xF8EE,
	28693 - 19968: 0xDEB5,
	28696 - 19968: 0xD6D2,
	28698 - 19968: 0xF9D5,
	28699 - 19968: 0xE7BA,
	28700 - 19968: 0xEBD5,
	28701 - 19968: 0xD5F7,
	28702 - 19968: 0xEFE7,
	28703 - 19968: 0xE1BE,
	28707 - 19968: 0xFAAE,
	28711 - 19968: 0xD6E9,
	28712 - 19968: 0xD6EE,
	28719 - 19968: 0xE7BB,
	28727 - 19968: 0xECCB,
	28734 - 19968: 0xD5B3,
	28748 - 19968: 0xCEB4,
	28752 - 19968: 0xFBA5,
	28753 - 19968: 0xE1EE,
	28760 - 19968: 0xF7A8,
	28765 - 19968: 0xFBCE,
	28771 - 19968: 0xD8BD,
	28779 - 19968: 0xFBFD,
	28784 - 19968: 0xFCE9,
	28792 - 19968: 0xCFB6,
	28796 - 19968: 0xEDC7,
	28797 - 19968: 0xEEAC,
	28805 - 19968: 0xCCDD,
	28810 - 19968: 0xF6A7,
	28814 - 19968: 0xE6FA,
	28818 - 19968: 0xF5A4,
	28824 - 19968: 0xFDDC,
	28825 - 19968: 0xEDB3,
	28826 - 19968: 0xCEC9,
	28833 - 19968: 0xEFE8,
	28836 - 19968: 0xE1BF,
	28843 - 19968: 0xFADB,
	28844 - 19968: 0xCBE3,
	28845 - 19968: 0xF7A9,
	28847 - 19968: 0xFBA6,
	28851 - 19968: 0xDCB9,
	28855 - 19968: 0xF1C0,
	28856 - 19968: 0xEDC8,
	28857 - 19968: 0xEFC3,
	28872 - 19968: 0xD6AD,
	28875 - 19968: 0xFDCE,
	28879 - 19968: 0xE8A1,
	28888 - 19968: 0xFBF4,
	28889 - 19968: 0xD5A7,
	28893 - 19968: 0xF1F6,
	28895 - 19968: 0xE6D3,
	28913 - 19968: 0xCCDE,
	28921 - 19968: 0xF8B2,
	28925 - 19968: 0xDCEB,
	28932 - 19968: 0xFDB6,
	28937 - 19968: 0xE5EA,
	28940 - 19968: 0xF1E0,
	28953 - 19968: 0xDBCC,
	28954 - 19968: 0xDDCD,
	28958 - 19968: 0xD4C8,
	28961 - 19968: 0xD9ED,
	28966 - 19968: 0xF5A5,
	28976 - 19968: 0xE6FB,
	28982 - 19968: 0xE6D4,
	28999 - 19968: 0xFDC8,
	29001 - 19968: 0xD6A1,
	29002 - 19968: 0xFDBF,
	29004 - 19968: 0xFCD3,
	29006 - 19968: 0xEFA1,
	29008 - 19968: 0xE7BC,
	29014 - 19968: 0xD1EE,
	29017 - 19968: 0xE6D5,
	29020 - 19968: 0xE9F2,
	29022 - 19968: 0xDFB0,
	29028 - 19968: 0xD8E0,
	29029 - 19968: 0xFCBA,
	29030 - 19968: 0xFDAF,
	29031 - 19968: 0xF0CE,
	29033 - 19968: 0xDBE1,
	29036 - 19968: 0xE5C9,
	29038 - 19968: 0xEDB4,
	29053 - 19968: 0xE0C3,
	29060 - 19968: 0xE3D8,
	29065 - 19968: 0xE9FB,
	29066 - 19968: 0xEAA8,
	29071 - 19968: 0xFDB7,
	29074 - 19968: 0xFBA7,
	29076 - 19968: 0xE9C2,
	29081 - 19968: 0xFDF7,
	29087 - 19968: 0xE2D9,
	29090 - 19968: 0xDCEC,
	29100 - 19968: 0xE8A2,
	29105 - 19968: 0xE6F0,
	29113 - 19968: 0xFDF8,
	29114 - 19968: 0xFDF9,
	29118 - 19968: 0xF6BF,
	29121 - 19968: 0xE7A7,
	29123 - 19968: 0xE6D7,
	29128 - 19968: 0xD4F3,
	29129 - 19968: 0xD4C9,
	29134 - 19968: 0xD6FA,
	29136 - 19968: 0xD7F2,
	29138 - 19968: 0xE1C0,
	29140 - 19968: 0xDBE2,
	29141 - 19968: 0xE6D8,
	29151 - 19968: 0xE7BD,
	29157 - 19968: 0xF0CF,
	29158 - 19968: 0xF3BE,
	29159 - 19968: 0xE2AC,
	29165 - 19968: 0xF5B7,
	29166 - 19968: 0xE0F0,
	29179 - 19968: 0xFDB8,
	29180 - 19968: 0xE3E8,
	29182 - 19968: 0xD4A7,
	29183 - 19968: 0xE8FC,
	29184 - 19968: 0xFAD2,
	29190 - 19968: 0xF8EF,
	29200 - 19968: 0xD6D3,
	29211 - 19968: 0xD5B4,
	29226 - 19968: 0xF0D0,
	29228 - 19968: 0xF7F0,
	29229 - 19968: 0xEEB3,
	29232 - 19968: 0xEABA,
	29234 - 19968: 0xEAD3,
	29237 - 19968: 0xEDC9,
	29238 - 19968: 0xDDAB,
	29242 - 19968: 0xE5AC,
	29243 - 19968: 0xFDA1,
	29245 - 19968: 0xDFD0,
	29246 - 19968: 0xECB3,
	29248 - 19968: 0xDFD1,
	29254 - 19968: 0xEDED,
	29255 - 19968: 0xF8B8,
	29256 - 19968: 0xF7FA,
	29260 - 19968: 0xF8AB,
	29266 - 19968: 0xF4E0,
	29272 - 19968: 0xD4BA,
	29273 - 19968: 0xE4B3,
	29275 - 19968: 0xE9DA,
	29277 - 19968: 0xDEB6,
	29279 - 19968: 0xD9BF,
	29281 - 19968: 0xD9C0,
	29282 - 19968: 0xD6EF,
	29287 - 19968: 0xD9CC,
	29289 - 19968: 0xDAAA,
	29298 - 19968: 0xDFE5,
	29305 - 19968: 0xF7E5,
	29309 - 19968: 0xCCB2,
	29312 - 19968: 0xDFF9,
	29313 - 19968: 0xD7E0,
	29346 - 19968: 0xD4BB,
	29351 - 19968: 0xFDFA,
	29356 - 19968: 0xCCB3,
	29359 - 19968: 0xDBF3,
	29376 - 19968: 0xDFD2,
	29378 - 19968: 0xCECA,
	29380 - 19968: 0xEEDA,
	29390 - 19968: 0xE4E4,
	29392 - 19968: 0xFBCF,
	29399 - 19968: 0xCFB7,
	29401 - 19968: 0xEEC3,
	29409 - 19968: 0xCEEA,
	29417 - 19968: 0xE2AD,
	29432 - 19968: 0xD7E1,
	29433 - 19968: 0xFAF5,
	29436 - 19968: 0xD5C9,
	29437 - 19968: 0xF8AC,
	29450 - 19968: 0xE7D9,
	29462 - 19968: 0xF3E9,
	29467 - 19968: 0xD8ED,
	29468 - 19968: 0xE3C4,
	29469 - 19968: 0xF0F1,
	29477 - 19968: 0xE8E5,
	29481 - 19968: 0xE0FA,
	29482 - 19968: 0xEEC4,
	29483 - 19968: 0xD9DE,
	29494 - 19968: 0xEBA2,
	29495 - 19968: 0xEBA3,
	29502 - 19968: 0xFCC2,
	29503 - 19968: 0xEABB,
	29508 - 19968: 0xE8AB,
	29509 - 19968: 0xDEE2,
	29520 - 19968: 0xEDEF,
	29522 - 19968: 0xE8A3,
	29527 - 19968: 0xCFF1,
	29544 - 19968: 0xD4BC,
	29546 - 19968: 0xFCEA,
	29552 - 19968: 0xE7BE,
	29554 - 19968: 0xFCF2,
	29557 - 19968: 0xD6B4,
	29560 - 19968: 0xE2AE,
	29562 - 19968: 0xD3B7,
	29563 - 19968: 0xFACC,
	29572 - 19968: 0xFADC,
	29574 - 19968: 0xEDB5,
	29575 - 19968: 0xE1E3,
	29577 - 19968: 0xE8AC,
	29579 - 19968: 0xE8DD,
	29582 - 19968: 0xEFE9,
	29588 - 19968: 0xF4BD,
	29590 - 19968: 0xCFB8,
	29591 - 19968: 0xE9DB,
	29592 - 19968: 0xD1AC,
	29599 - 19968: 0xDAC7,
	29607 - 19968: 0xEBC9,
	29609 - 19968: 0xE8CC,
	29613 - 19968: 0xDEB7,
	29618 - 19968: 0xD6BC,
	29619 - 19968: 0xD3E5,
	29625 - 19968: 0xFADD,
	29632 - 19968: 0xDAD6,
	29634 - 19968: 0xCAB1,
	29641 - 19968: 0xDAC8,
	29642 - 19968: 0xDFA6,
	29644 - 19968: 0xF9B3,
	29645 - 19968: 0xF2D2,
	29647 - 19968: 0xCAC4,
	29654 - 19968: 0xCECB,
	29657 - 19968: 0xCDF5,
	29661 - 19968: 0xFDB0,
	29662 - 19968: 0xD5A8,
	29664 - 19968: 0xF1C1,
	29667 - 19968: 0xE2E9,
	29668 - 19968: 0xDCCA,
	29669 - 19968: 0xECB4,
	29670 - 19968: 0xFAC0,
	29673 - 19968: 0xFBA8,
	29674 - 19968: 0xD0A8,
	29677 - 19968: 0xDAEC,
	29687 - 19968: 0xD9EE,
	29689 - 19968: 0xE0FB,
	29693 - 19968: 0xEFEA,
	29694 - 19968: 0xFADE,
	29697 - 19968: 0xE0C4,
	29699 - 19968: 0xCFB9,
	29701 - 19968: 0xD5CA,
	29702 - 19968: 0xD7E2,
	29703 - 19968: 0xE2AF,
	29705 - 19968: 0xD7B8,
	29715 - 19968: 0xE8CD,
	29723 - 19968: 0xF6DA,
	29728 - 19968: 0xEFA2,
	29729 - 19968: 0xE2DA,
	29730 - 19968: 0xF6FC,
	29733 - 19968: 0xFBD0,
	29734 - 19968: 0xD1AD,
	29736 - 19968: 0xCDE4,
	29738 - 19968: 0xD1AE,
	29739 - 19968: 0xDCED,
	29740 - 19968: 0xE8CE,
	29742 - 19968: 0xF0F9,
	29743 - 19968: 0xCEB5,
	29744 - 19968: 0xE6FC,
	29747 - 19968: 0xD7FB,
	29748 - 19968: 0xD0D6,
	29749 - 19968: 0xDDF5,
	29750 - 19968: 0xF7F1,
	29752 - 19968: 0xF6FD,
	29754 - 19968: 0xDBF7,
	29759 - 19968: 0xFBEA,
	29760 - 19968: 0xE9DC,
	29761 - 19968: 0xD9C1,
	29763 - 19968: 0xF5F2,
	29764 - 19968: 0xE0C5,
	29771 - 19968: 0xEAD4,
	29781 - 19968: 0xF9C2,
	29783 - 19968: 0xEABC,
	29785 - 19968: 0xD2C5,
	29786 - 19968: 0xFBD1,
	29787 - 19968: 0xE7C0,
	29788 - 19968: 0xEBA5,
	29790 - 19968: 0xDFFA,
	29791 - 19968: 0xE3A2,
	29792 - 19968: 0xD7B9,
	29794 - 19968: 0xE9C3,
	29796 - 19968: 0xE8FD,
	29797 - 19968: 0xE8AF,
	29800 - 19968: 0xF2D3,
	29801 - 19968: 0xFBA9,
	29802 - 19968: 0xD8A5,
	29807 - 19968: 0xD5CB,
	29822 - 19968: 0xD0C8,
	29826 - 19968: 0xD1AF,
	29827 - 19968: 0xD7E3,
	29831 - 19968: 0xE0C6,
	29833 - 19968: 0xD6A2,
	29835 - 19968: 0xEDF0,
	29848 - 19968: 0xD7F3,
	29852 - 19968: 0xFCD4,
	29854 - 19968: 0xDAD7,
	29855 - 19968: 0xCCDF,
	29857 - 19968: 0xF2D4,
	29859 - 19968: 0xD1B0,
	29861 - 19968: 0xCCE0,
	29863 - 19968: 0xDBFD,
	29864 - 19968: 0xF3BF,
	29866 - 19968: 0xF0D1,
	29872 - 19968: 0xFCBB,
	29874 - 19968: 0xE2B0,
	29877 - 19968: 0xE6A5,
	29881 - 19968: 0xE2DB,
	29885 - 19968: 0xDFDE,
	29887 - 19968: 0xE0C7,
	29894 - 19968: 0xF2EF,
	29898 - 19968: 0xCCE1,
	29903 - 19968: 0xD6EA,
	29908 - 19968: 0xE7C2,
	29912 - 19968: 0xCEB6,
	29914 - 19968: 0xF3C0,
	29916 - 19968: 0xCDFE,
	29920 - 19968: 0xFBD2,
	29922 - 19968: 0xF8F8,
	29923 - 19968: 0xF7FB,
	29926 - 19968: 0xE8BF,
	29934 - 19968: 0xE8B7,
	29943 - 19968: 0xEDB6,
	29953 - 19968: 0xDCBA,
	29956 - 19968: 0xCCB4,
	29969 - 19968: 0xF1F7,
	29973 - 19968: 0xE8B8,
	29976 - 19968: 0xCAF6,
	29978 - 19968: 0xE4A4,
	29979 - 19968: 0xF4D6,
	29983 - 19968: 0xDFE6,
	29987 - 19968: 0xDFA7,
	29989 - 19968: 0xDFE7,
	29990 - 19968: 0xE1C1,
	29992 - 19968: 0xE9C4,
	29995 - 19968: 0xDCCB,
	29996 - 19968: 0xE9C5,
	30000 - 19968: 0xEFA3,
	30001 - 19968: 0xEBA6,
	30002 - 19968: 0xCBA3,
	30003 - 19968: 0xE3E9,
	30007 - 19968: 0xD1FB,
	30008 - 19968: 0xEFA4,
	30010 - 19968: 0xEFEB,
	30023 - 19968: 0xD0B4,
	30028 - 19968: 0xCDA3,
	30031 - 19968: 0xE8E6,
	30033 - 19968: 0xEFA5,
	30035 - 19968: 0xD3CC,
	30036 - 19968: 0xDAED,
	30041 - 19968: 0xD7BA,
	30043 - 19968: 0xF2D5,
	30044 - 19968: 0xF5E5,
	30045 - 19968: 0xD9EF,
	30050 - 19968: 0xF9B4,
	30053 - 19968: 0xD5D4,
	30054 - 19968: 0xFDCF,
	30058 - 19968: 0xDBE3,
	30063 - 19968: 0xF1E1,
	30064 - 19968: 0xECB6,
	30069 - 19968: 0xFBFE,
	30070 - 19968: 0xD3D7,
	30072 - 19968: 0xD1B1,
	30074 - 19968: 0xCBB1,
	30079 - 19968: 0xD1B2,
	30086 - 19968: 0xCBB2,
	30087 - 19968: 0xF1C2,
	30090 - 19968: 0xF4E1,
	30091 - 19968: 0xF9B5,
	30094 - 19968: 0xE1C3,
	30095 - 19968: 0xE1C2,
	30097 - 19968: 0xEBF7,
	30109 - 19968: 0xDFA8,
	30117 - 19968: 0xCBCA,
	30123 - 19968: 0xE6B9,
	30129 - 19968: 0xF8DE,
	30130 - 19968: 0xF9AA,
	30131 - 19968: 0xCAF7,
	30133 - 19968: 0xEDB7,
	30136 - 19968: 0xD3B8,
	30137 - 19968: 0xF2D6,
	30140 - 19968: 0xD4D9,
	30141 - 19968: 0xEEC5,
	30142 - 19968: 0xF2F0,
	30146 - 19968: 0xCAB2,
	30149 - 19968: 0xDCBB,
	30151 - 19968: 0xF1F8,
	30157 - 19968: 0xECB7,
	30162 - 19968: 0xE5CA,
	30164 - 19968: 0xF6C0,
	30165 - 19968: 0xFDDD,
	30168 - 19968: 0xD4E3,
	30169 - 19968: 0xCCE2,
	30171 - 19968: 0xF7D4,
	30178 - 19968: 0xD7E5,
	30192 - 19968: 0xD3C3,
	30194 - 19968: 0xD8A6,
	30196 - 19968: 0xF6C1,
	30202 - 19968: 0xDDF6,
	30204 - 19968: 0xCDC0,
	30208 - 19968: 0xE5DC,
	30221 - 19968: 0xE5CB,
	30233 - 19968: 0xE1C4,
	30239 - 19968: 0xE8B0,
	30240 - 19968: 0xF4B0,
	30241 - 19968: 0xF3EA,
	30242 - 19968: 0xDAEE,
	30244 - 19968: 0xD7BB,
	30246 - 19968: 0xE2B1,
	30267 - 19968: 0xD7AA,
	30274 - 19968: 0xD6FB,
	30284 - 19968: 0xE4DF,
	30286 - 19968: 0xCAD6,
	30290 - 19968: 0xEBA8,
	30294 - 19968: 0xDBFE,
	30305 - 19968: 0xF6C2,
	30308 - 19968: 0xEFBB,
	30313 - 19968: 0xD4FD,
	30316 - 19968: 0xE0C8,
	30320 - 19968: 0xE8B9,
	30322 - 19968: 0xEFA6,
	30328 - 19968: 0xCDA4,
	30331 - 19968: 0xD4F4,
	30332 - 19968: 0xDBA1,
	30333 - 19968: 0xDBDC,
	30334 - 19968: 0xDBDD,
	30340 - 19968: 0xEEDC,
	30342 - 19968: 0xCBCB,
	30343 - 19968: 0xFCD5,
	30350 - 19968: 0xCEEB,
	30352 - 19968: 0xCDC1,
	30355 - 19968: 0xFBD3,
	30382 - 19968: 0xF9AB,
	30394 - 19968: 0xF5D4,
	30399 - 19968: 0xD9A9,
	30402 - 19968: 0xE9DD,
	30403 - 19968: 0xDBCD,
	30406 - 19968: 0xDDCE,
	30408 - 19968: 0xE7C3,
	30410 - 19968: 0xECCC,
	30418 - 19968: 0xF9EC,
	30422 - 19968: 0xCBCC,
	30427 - 19968: 0xE0FC,
	30428 - 19968: 0xD4A8,
	30430 - 19968: 0xEDD3,
	30431 - 19968: 0xD8EF,
	30433 - 19968: 0xF2D7,
	30435 - 19968: 0xCAF8,
	30436 - 19968: 0xDAEF,
	30439 - 19968: 0xD6D4,
	30446 - 19968: 0xD9CD,
	30450 - 19968: 0xD8EE,
	30452 - 19968: 0xF2C1,
	30456 - 19968: 0xDFD3,
	30460 - 19968: 0xDAF0,
	30462 - 19968: 0xE2EA,
	30465 - 19968: 0xE0FD,
	30468 - 19968: 0xD8F8,
	30472 - 19968: 0xF7AF,
	30473 - 19968: 0xDAB6,
	30475 - 19968: 0xCAD7,
	30494 - 19968: 0xF2D8,
	30496 - 19968: 0xD8F9,
	30505 - 19968: 0xFADF,
	30519 - 19968: 0xCFEF,
	30520 - 19968: 0xD9C2,
	30522 - 19968: 0xF0D2,
	30524 - 19968: 0xE4D1,
	30528 - 19968: 0xF3B7,
	30541 - 19968: 0xFAE0,
	30555 - 19968: 0xEFEC,
	30561 - 19968: 0xE2B2,
	30563 - 19968: 0xD4BD,
	30566 - 19968: 0xD9CE,
	30571 - 19968: 0xF4E2,
	30585 - 19968: 0xD4A9,
	30590 - 19968: 0xCDC2,
	30591 - 19968: 0xE7DA,
	30603 - 19968: 0xF2D9,
	30609 - 19968: 0xD9AA,
	30622 - 19968: 0xD8BE,
	30629 - 19968: 0xDCAD,
	30636 - 19968: 0xE2EB,
	30637 - 19968: 0xD6FC,
	30640 - 19968: 0xCAF9,
	30643 - 19968: 0xD4DA,
	30651 - 19968: 0xF4D7,
	30652 - 19968: 0xCCA1,
	30655 - 19968: 0xCFBA,
	30679 - 19968: 0xF5B8,
	30683 - 19968: 0xD9C3,
	30684 - 19968: 0xD0E8,
	30690 - 19968: 0xE3C5,
	30691 - 19968: 0xEBF8,
	30693 - 19968: 0xF2B1,
	30697 - 19968: 0xCFBB,
	30701 - 19968: 0xD3AD,
	30702 - 19968: 0xE8E1,
	30703 - 19968: 0xCEEC,
	30707 - 19968: 0xE0B4,
	30722 - 19968: 0xDEE3,
	30738 - 19968: 0xDDF7,
	30757 - 19968: 0xF2B2,
	30758 - 19968: 0xF3F6,
	30759 - 19968: 0xF6DB,
	30764 - 19968: 0xD7FE,
	30770 - 19968: 0xF8DF,
	30772 - 19968: 0xF7F2,
	30789 - 19968: 0xD0A9,
	30799 - 19968: 0xE6DA,
	30813 - 19968: 0xF5A6,
	30827 - 19968: 0xD7BC,
	30828 - 19968: 0xCCE3,
	30831 - 19968: 0xE6DB,
	30844 - 19968: 0xDDDD,
	30849 - 19968: 0xD1B3,
	30855 - 19968: 0xEFED,
	30860 - 19968: 0xD6DE,
	30861 - 19968: 0xE4F4,
	30862 - 19968: 0xE1EF,
	30865 - 19968: 0xDDF8,
	30871 - 19968: 0xE8CF,
	30883 - 19968: 0xCAE5,
	30887 - 19968: 0xDCA1,
	30889 - 19968: 0xE0B5,
	30906 - 19968: 0xFCAC,
	30907 - 19968: 0xFCAD,
	30908 - 19968: 0xD8A7,
	30913 - 19968: 0xEDB8,
	30917 - 19968: 0xDBB6,
	30922 - 19968: 0xD6F0,
	30923 - 19968: 0xF3AF,
	30926 - 19968: 0xCDA5,
	30928 - 19968: 0xDAF1,
	30952 - 19968: 0xD8A8,
	30956 - 19968: 0xCCE4,
	30959 - 19968: 0xD1B4,
	30965 - 19968: 0xCAD8,
	30971 - 19968: 0xDAF2,
	30977 - 19968: 0xF5A7,
	30990 - 19968: 0xF5A8,
	30998 - 19968: 0xE6A6,
	31018 - 19968: 0xD5EC,
	31019 - 19968: 0xD5F8,
	31020 - 19968: 0xDAF3,
	31034 - 19968: 0xE3C6,
	31038 - 19968: 0xDEE4,
	31040 - 19968: 0xDEE5,
	31041 - 19968: 0xD1B5,
	31047 - 19968: 0xD1B6,
	31048 - 19968: 0xD1B7,
	31049 - 19968: 0xF2B3,
	31056 - 19968: 0xE9DE,
	31062 - 19968: 0xF0D3,
	31063 - 19968: 0xF2B4,
	31066 - 19968: 0xF0D4,
	31067 - 19968: 0xCBE4,
	31068 - 19968: 0xFBD4,
	31069 - 19968: 0xF5E6,
	31070 - 19968: 0xE3EA,
	31072 - 19968: 0xDEE6,
	31077 - 19968: 0xDFD4,
	31080 - 19968: 0xF8F9,
	31085 - 19968: 0xF0AE,
	31098 - 19968: 0xD1B8,
	31103 - 19968: 0xD6DF,
	31105 - 19968: 0xD0D7,
	31117 - 19968: 0xFCA1,
	31118 - 19968: 0xEFEE,
	31119 - 19968: 0xDCD8,
	31121 - 19968: 0xE9DF,
	31142 - 19968: 0xE5DD,
	31143 - 19968: 0xFDFB,
	31146 - 19968: 0xE0C9,
	31150 - 19968: 0xD6C9,
	31153 - 19968: 0xD4AA,
	31155 - 19968: 0xE5CC,
	31161 - 19968: 0xE9E0,
	31165 - 19968: 0xD0D8,
	31166 - 19968: 0xFCA2,
	31167 - 19968: 0xD4BE,
	31168 - 19968: 0xE2B3,
	31169 - 19968: 0xDEE7,
	31177 - 19968: 0xDCBC,
	31178 - 19968: 0xD2B6,
	31179 - 19968: 0xF5D5,
	31185 - 19968: 0xCEA1,
	31186 - 19968: 0xF5A9,
	31189 - 19968: 0xDDF9,
	31192 - 19968: 0xDDFA,
	31199 - 19968: 0xF0D5,
	31204 - 19968: 0xF6DF,
	31206 - 19968: 0xF2DA,
	31207 - 19968: 0xE4EB,
	31209 - 19968: 0xF2F1,
	31227 - 19968: 0xECB9,
	31232 - 19968: 0xFDFC,
	31237 - 19968: 0xE1AA,
	31240 - 19968: 0xCAD9,
	31243 - 19968: 0xEFEF,
	31245 - 19968: 0xF5AA,
	31252 - 19968: 0xECF9,
	31255 - 19968: 0xF8AD,
	31257 - 19968: 0xF2C2,
	31258 - 19968: 0xF6C3,
	31260 - 19968: 0xD7D2,
	31263 - 19968: 0xF9A2,
	31264 - 19968: 0xF0D6,
	31278 - 19968: 0xF0FA,
	31281 - 19968: 0xF6E0,
	31286 - 19968: 0xE9F3,
	31287 - 19968: 0xF2C3,
	31291 - 19968: 0xD4AB,
	31292 - 19968: 0xCAB3,
	31293 - 19968: 0xCDA6,
	31295 - 19968: 0xCDC3,
	31296 - 19968: 0xCDDA,
	31302 - 19968: 0xD9CF,
	31305 - 19968: 0xF6C4,
	31309 - 19968: 0xEEDD,
	31310 - 19968: 0xE7C4,
	31319 - 19968: 0xE2B4,
	31329 - 19968: 0xDFE2,
	31330 - 19968: 0xE7DB,
	31337 - 19968: 0xE8B1,
	31339 - 19968: 0xFCAE,
	31344 - 19968: 0xE5CD,
	31348 - 19968: 0xFAEB,
	31350 - 19968: 0xCFBC,
	31353 - 19968: 0xCFE2,
	31354 - 19968: 0xCDF6,
	31357 - 19968: 0xEFF0,
	31359 - 19968: 0xF4BE,
	31361 - 19968: 0xD4CD,
	31364 - 19968: 0xF3B8,
	31368 - 19968: 0xE9A1,
	31378 - 19968: 0xF2F2,
	31379 - 19968: 0xF3EB,
	31381 - 19968: 0xF0D7,
	31384 - 19968: 0xCFD7,
	31391 - 19968: 0xCFDF,
	31401 - 19968: 0xE8C0,
	31402 - 19968: 0xE8C1,
	31406 - 19968: 0xCFE3,
	31407 - 19968: 0xE9A2,
	31418 - 19968: 0xD0AA,
	31428 - 19968: 0xF3C1,
	31429 - 19968: 0xD0AB,
	31431 - 19968: 0xD4E4,
	31434 - 19968: 0xEFBC,
	31435 - 19968: 0xD8A1,
	31447 - 19968: 0xD9DF,
	31449 - 19968: 0xF3D7,
	31453 - 19968: 0xDCBD,
	31455 - 19968: 0xCCE5,
	31456 - 19968: 0xEDF1,
	31459 - 19968: 0xF1E2,
	31461 - 19968: 0xD4DB,
	31466 - 19968: 0xE2B5,
	31469 - 19968: 0xCAE6,
	31471 - 19968: 0xD3AE,
	31478 - 19968: 0xCCE6,
	31481 - 19968: 0xF1D3,
	31482 - 19968: 0xF5E7,
	31487 - 19968: 0xCADA,
	31503 - 19968: 0xFBEE,
	31505 - 19968: 0xE1C5,
	31513 - 19968: 0xDFE9,
	31515 - 19968: 0xEEDE,
	31518 - 19968: 0xF7C2,
	31520 - 19968: 0xD8A2,
	31526 - 19968: 0xDDAC,
	31532 - 19968: 0xF0AF,
	31533 - 19968: 0xD6BD,
	31545 - 19968: 0xE1AB,
	31558 - 19968: 0xF9B6,
	31561 - 19968: 0xD4F5,
	31563 - 19968: 0xD0C9,
	31564 - 19968: 0xEFA7,
	31565 - 19968: 0xE2EC,
	31567 - 19968: 0xDBEA,
	31568 - 19968: 0xCECC,
	31569 - 19968: 0xF5E8,
	31570 - 19968: 0xF7D5,
	31572 - 19968: 0xD3CD,
	31574 - 19968: 0xF3FE,
	31584 - 19968: 0xD0B5,
	31596 - 19968: 0xE0FE,
	31598 - 19968: 0xDFFB,
	31605 - 19968: 0xE6DD,
	31613 - 19968: 0xE8A4,
	31623 - 19968: 0xCBCD,
	31627 - 19968: 0xEFA8,
	31631 - 19968: 0xEEB4,
	31636 - 19968: 0xDAD8,
	31637 - 19968: 0xD1B9,
	31639 - 19968: 0xDFA9,
	31642 - 19968: 0xF3B0,
	31645 - 19968: 0xCCC4,
	31649 - 19968: 0xCEB7,
	31661 - 19968: 0xEFA9,
	31665 - 19968: 0xDFD5,
	31668 - 19968: 0xEDD7,
	31672 - 19968: 0xEEC6,
	31680 - 19968: 0xEFBD,
	31681 - 19968: 0xFCD6,
	31684 - 19968: 0xDBF4,
	31686 - 19968: 0xEFAA,
	31687 - 19968: 0xF8B9,
	31689 - 19968: 0xF5E9,
	31698 - 19968: 0xE3D9,
	31712 - 19968: 0xE1C6,
	31716 - 19968: 0xD4BF,
	31721 - 19968: 0xDEE8,
	31751 - 19968: 0xF0EA,
	31762 - 19968: 0xF3C2,
	31774 - 19968: 0xD3AF,
	31777 - 19968: 0xCADB,
	31783 - 19968: 0xFCD7,
	31786 - 19968: 0xEDD8,
	31787 - 19968: 0xE1C7,
	31805 - 19968: 0xF4D8,
	31806 - 19968: 0xD6B3,
	31807 - 19968: 0xDDAD,
	31811 - 19968: 0xD5BE,
	31820 - 19968: 0xF1C3,
	31821 - 19968: 0xEEDF,
	31840 - 19968: 0xD6EB,
	31844 - 19968: 0xF4D9,
	31852 - 19968: 0xD7E6,
	31859 - 19968: 0xDAB7,
	31875 - 19968: 0xDDFB,
	31881 - 19968: 0xDDCF,
	31890 - 19968: 0xD8A3,
	31893 - 19968: 0xDAD9,
	31895 - 19968: 0xF0D8,
	31896 - 19968: 0xEFC4,
	31903 - 19968: 0xE1D8,
	31909 - 19968: 0xF1D4,
	31911 - 19968: 0xEDF2,
	31918 - 19968: 0xD5DB,
	31921 - 19968: 0xD5DC,
	31922 - 19968: 0xF3C4,
	31923 - 19968: 0xCBD7,
	31929 - 19968: 0xE2B6,
	31934 - 19968: 0xEFF1,
	31946 - 19968: 0xFBD5,
	31958 - 19968: 0xD3D8,
	31966 - 19968: 0xDDD0,
	31967 - 19968: 0xF0D9,
	31968 - 19968: 0xCBB3,
	31975 - 19968: 0xD5DD,
	31995 - 19968: 0xCDA7,
	31998 - 19968: 0xD0AC,
	32000 - 19968: 0xD1BA,
	32002 - 19968: 0xF1C4,
	32004 - 19968: 0xE5B3,
	32005 - 19968: 0xFBF5,
	32006 - 19968: 0xE9E1,
	32007 - 19968: 0xFDE0,
	32008 - 19968: 0xFCBC,
	32010 - 19968: 0xDAA2,
	32011 - 19968: 0xDAA3,
	32013 - 19968: 0xD2A1,
	32016 - 19968: 0xD2EF,
	32020 - 19968: 0xE2ED,
	32023 - 19968: 0xDEE9,
	32024 - 19968: 0xCEDC,
	32025 - 19968: 0xF2B5,
	32026 - 19968: 0xD0E4,
	32027 - 19968: 0xDDD1,
	32032 - 19968: 0xE1C8,
	32033 - 19968: 0xDBB7,
	32034 - 19968: 0xDFE3,
	32043 - 19968: 0xEDB9,
	32044 - 19968: 0xF1C5,
	32046 - 19968: 0xF3CF,
	32047 - 19968: 0xD7AB,
	32048 - 19968: 0xE1AC,
	32051 - 19968: 0xE3EB,
	32053 - 19968: 0xEEC7,
	32057 - 19968: 0xE1C9,
	32058 - 19968: 0xCAFA,
	32066 - 19968: 0xF0FB,
	32067 - 19968: 0xFAE1,
	32068 - 19968: 0xF0DA,
	32069 - 19968: 0xCCE7,
	32070 - 19968: 0xDAF4,
	32080 - 19968: 0xCCBF,
	32094 - 19968: 0xCEED,
	32097 - 19968: 0xD5A9,
	32098 - 19968: 0xFAE2,
	32102 - 19968: 0xD0E5,
	32104 - 19968: 0xEBD6,
	32106 - 19968: 0xECDF,
	32110 - 19968: 0xDFFC,
	32113 - 19968: 0xF7D6,
	32114 - 19968: 0xDEEA,
	32115 - 19968: 0xCBB4,
	32118 - 19968: 0xEFBE,
	32121 - 19968: 0xCCB5,
	32127 - 19968: 0xCFBD,
	32142 - 19968: 0xEFF2,
	32143 - 19968: 0xE2B7,
	32147 - 19968: 0xCCE8,
	32156 - 19968: 0xF0FC,
	32160 - 19968: 0xD6E0,
	32162 - 19968: 0xF1C6,
	32172 - 19968: 0xE2B8,
	32173 - 19968: 0xEBAB,
	32177 - 19968: 0xCBB5,
	32178 - 19968: 0xD8D1,
	32180 - 19968: 0xF4CE,
	32181 - 19968: 0xF3F7,
	32184 - 19968: 0xD7C6,
	32186 - 19968: 0xD1BB,
	32187 - 19968: 0xF7AA,
	32189 - 19968: 0xEDCA,
	32190 - 19968: 0xD7D3,
	32191 - 19968: 0xD8FA,
	32199 - 19968: 0xF6C5,
	32202 - 19968: 0xD1CC,
	32203 - 19968: 0xDDFC,
	32214 - 19968: 0xDFFD,
	32216 - 19968: 0xF9E5,
	32218 - 19968: 0xE0CA,
	32221 - 19968: 0xF2FD,
	32222 - 19968: 0xD3B0,
	32224 - 19968: 0xF4F3,
	32225 - 19968: 0xDAC9,
	32227 - 19968: 0xE6DE,
	32232 - 19968: 0xF8BA,
	32233 - 19968: 0xE8D0,
	32236 - 19968: 0xD8FB,
	32239 - 19968: 0xEAD5,
	32244 - 19968: 0xD6A3,
	32251 - 19968: 0xF6C6,
	32265 - 19968: 0xF2DB,
	32266 - 19968: 0xE4FC,
	32277 - 19968: 0xE8B2,
	32283 - 19968: 0xDADA,
	32285 - 19968: 0xF2DC,
	32286 - 19968: 0xFBD6,
	32287 - 19968: 0xE9B2,
	32289 - 19968: 0xEEAD,
	32291 - 19968: 0xFAE3,
	32299 - 19968: 0xDCEE,
	32302 - 19968: 0xF5EA,
	32303 - 19968: 0xE6E0,
	32305 - 19968: 0xF0FD,
	32311 - 19968: 0xD7AC,
	32317 - 19968: 0xF5C5,
	32318 - 19968: 0xEEE0,
	32321 - 19968: 0xDBE5,
	32323 - 19968: 0xDDDE,
	32326 - 19968: 0xD9F0,
	32327 - 19968: 0xE9A3,
	32338 - 19968: 0xF1F9,
	32340 - 19968: 0xF2C4,
	32341 - 19968: 0xE0CB,
	32350 - 19968: 0xE9A4,
	32353 - 19968: 0xE2B9,
	32361 - 19968: 0xE3B1,
	32362 - 19968: 0xFCEB,
	32363 - 19968: 0xCDA8,
	32365 - 19968: 0xCCB6,
	32368 - 19968: 0xF0DB,
	32377 - 19968: 0xE6BA,
	32380 - 19968: 0xCDA9,
	32386 - 19968: 0xF3C3,
	32396 - 19968: 0xE1D9,
	32399 - 19968: 0xEFAB,
	32403 - 19968: 0xE7C5,
	32406 - 19968: 0xE0E9,
	32408 - 19968: 0xF3C5,
	32411 - 19968: 0xD4C0,
	32412 - 19968: 0xD5BF,
	32566 - 19968: 0xDDAE,
	32568 - 19968: 0xF9FC,
	32570 - 19968: 0xCCC0,
	32588 - 19968: 0xE5A2,
	32592 - 19968: 0xCEB8,
	32596 - 19968: 0xD8D2,
	32597 - 19968: 0xF9D6,
	32618 - 19968: 0xF1AA,
	32619 - 19968: 0xCED1,
	32622 - 19968: 0xF6C7,
	32624 - 19968: 0xDBEB,
	32626 - 19968: 0xDFFE,
	32629 - 19968: 0xD8E1,
	32631 - 19968: 0xF7F3,
	32633 - 19968: 0xD7E7,
	32645 - 19968: 0xD4FE,
	32648 - 19968: 0xD1BC,
	32650 - 19968: 0xE5CF,
	32652 - 19968: 0xCBB6,
	32654 - 19968: 0xDAB8,
	32660 - 19968: 0xCDC4,
	32666 - 19968: 0xD6BE,
	32670 - 19968: 0xE2BA,
	32676 - 19968: 0xCFD8,
	32680 - 19968: 0xE0CC,
	32681 - 19968: 0xEBF9,
	32690 - 19968: 0xFDFD,
	32696 - 19968: 0xD7E8,
	32697 - 19968: 0xCBD8,
	32701 - 19968: 0xE9E2,
	32705 - 19968: 0xE8BA,
	32709 - 19968: 0xE3C7,
	32714 - 19968: 0xECCD,
	32716 - 19968: 0xECCE,
	32718 - 19968: 0xD6BF,
	32722 - 19968: 0xE3A7,
	32724 - 19968: 0xDFD6,
	32725 - 19968: 0xFDE8,
	32735 - 19968: 0xEEE1,
	32736 - 19968: 0xF6A8,
	32737 - 19968: 0xDDFD,
	32745 - 19968: 0xF8BB,
	32747 - 19968: 0xE8D1,
	32752 - 19968: 0xF9D7,
	32761 - 19968: 0xCEEE,
	32764 - 19968: 0xECCF,
	32768 - 19968: 0xE9A5,
	32769 - 19968: 0xD6D5,
	32771 - 19968: 0xCDC5,
	32773 - 19968: 0xEDBA,
	32774 - 19968: 0xD1BD,
	32777 - 19968: 0xCFBE,
	32780 - 19968: 0xECBB,
	32784 - 19968: 0xD2B1,
	32789 - 19968: 0xCCE9,
	32791 - 19968: 0xD9C4,
	32792 - 19968: 0xE9FC,
	32813 - 19968: 0xD1BE,
	32819 - 19968: 0xECBC,
	32822 - 19968: 0xE5AD,
	32829 - 19968: 0xF7B0,
	32831 - 19968: 0xCCEA,
	32835 - 19968: 0xD3C4,
	32838 - 19968: 0xD6C0,
	32842 - 19968: 0xD6FD,
	32854 - 19968: 0xE1A1,
	32856 - 19968: 0xDEBD,
	32858 - 19968: 0xF6A9,
	32862 - 19968: 0xDAA4,
	32879 - 19968: 0xD6A4,
	32880 - 19968: 0xF5C6,
	32882 - 19968: 0xE1A2,
	32883 - 19968: 0xE9C6,
	32887 - 19968: 0xF2C5,
	32893 - 19968: 0xF4E9,
	32894 - 19968: 0xD6EC,
	32895 - 19968: 0xEBD3,
	32900 - 19968: 0xECBD,
	32901 - 19968: 0xE2DC,
	32902 - 19968: 0xDEEB,
	32903 - 19968: 0xF0DC,
	32905 - 19968: 0xEBBF,
	32907 - 19968: 0xD7CE,
	32908 - 19968: 0xD1BF,
	32918 - 19968: 0xF5AB,
	32923 - 19968: 0xF9FD,
	32925 - 19968: 0xCADC,
	32929 - 19968: 0xCDC6,
	32930 - 19968: 0xF2B6,
	32933 - 19968: 0xDDFE,
	32937 - 19968: 0xCCB7,
	32938 - 19968: 0xDBB8,
	32943 - 19968: 0xD0E9,
	32945 - 19968: 0xCEDD,
	32946 - 19968: 0xEBC0,
	32948 - 19968: 0xFDA2,
	32954 - 19968: 0xF8CB,
	32963 - 19968: 0xEAD6,
	32964 - 19968: 0xF1B0,
	32972 - 19968: 0xDBCE,
	32974 - 19968: 0xF7C3,
	32986 - 19968: 0xDBCF,
	32987 - 19968: 0xCBA4,
	32990 - 19968: 0xF8E0,
	32993 - 19968: 0xFBD7,
	32996 - 19968: 0xEBCA,
	32997 - 19968: 0xE0A1,
	33009 - 19968: 0xCECD,
	33012 - 19968: 0xD4DC,
	33016 - 19968: 0xFDD8,
	33021 - 19968: 0xD2F6,
	33026 - 19968: 0xF2B7,
	33029 - 19968: 0xFAF6,
	33030 - 19968: 0xF6AA,
	33031 - 19968: 0xFAF7,
	33032 - 19968: 0xD8E6,
	33034 - 19968: 0xF4B1,
	33048 - 19968: 0xE8D2,
	33050 - 19968: 0xCAC5,
	33051 - 19968: 0xCCEB,
	33059 - 19968: 0xE2EE,
	33065 - 19968: 0xE2BB,
	33067 - 19968: 0xF7AD,
	33071 - 19968: 0xF8E1,
	33081 - 19968: 0xF3EC,
	33086 - 19968: 0xDEA1,
	33099 - 19968: 0xE4FD,
	33102 - 19968: 0xE3EC,
	33104 - 19968: 0xDDAF,
	33105 - 19968: 0xDDB0,
	33108 - 19968: 0xCBB7,
	33109 - 19968: 0xE8D3,
	33125 - 19968: 0xE1A3,
	33126 - 19968: 0xD2E0,
	33131 - 19968: 0xF0FE,
	33136 - 19968: 0xE9A6,
	33137 - 19968: 0xCBF2,
	33144 - 19968: 0xEDF3,
	33145 - 19968: 0xDCD9,
	33146 - 19968: 0xE0CD,
	33151 - 19968: 0xF7DA,
	33152 - 19968: 0xDBB9,
	33160 - 19968: 0xCCAE,
	33162 - 19968: 0xDADB,
	33167 - 19968: 0xCDC7,
	33178 - 19968: 0xDDB1,
	33180 - 19968: 0xD8AF,
	33181 - 19968: 0xE3A3,
	33184 - 19968: 0xCEEF,
	33187 - 19968: 0xF2F3,
	33192 - 19968: 0xF8B3,
	33203 - 19968: 0xE0CE,
	33205 - 19968: 0xF5FD,
	33210 - 19968: 0xEBEC,
	33213 - 19968: 0xD3C5,
	33214 - 19968: 0xFCEC,
	33215 - 19968: 0xD2DB,
	33216 - 19968: 0xD4EB,
	33218 - 19968: 0xDEA2,
	33222 - 19968: 0xE5E6,
	33229 - 19968: 0xF0B0,
	33240 - 19968: 0xD5C4,
	33247 - 19968: 0xEDF4,
	33251 - 19968: 0xE3ED,
	33253 - 19968: 0xE8C2,
	33255 - 19968: 0xEDF5,
	33256 - 19968: 0xD7FC,
	33258 - 19968: 0xEDBB,
	33261 - 19968: 0xF6AB,
	33267 - 19968: 0xF2B8,
	33268 - 19968: 0xF6C8,
	33274 - 19968: 0xD3E6,
	33275 - 19968: 0xF2DD,
	33276 - 19968: 0xCFBF,
	33278 - 19968: 0xEBAC,
	33285 - 19968: 0xCFC0,
	33287 - 19968: 0xE6A8,
	33288 - 19968: 0xFDE9,
	33290 - 19968: 0xCFC1,
	33292 - 19968: 0xE0DF,
	33293 - 19968: 0xDEEC,
	33298 - 19968: 0xE0A2,
	33307 - 19968: 0xF4BF,
	33308 - 19968: 0xE2EF,
	33310 - 19968: 0xD9F1,
	33311 - 19968: 0xF1C7,
	33313 - 19968: 0xCBB8,
	33322 - 19968: 0xF9FE,
	33323 - 19968: 0xDBBA,
	33324 - 19968: 0xDAF5,
	33333 - 19968: 0xF6EC,
	33334 - 19968: 0xDADC,
	33335 - 19968: 0xFAE4,
	33337 - 19968: 0xE0CF,
	33344 - 19968: 0xDDB2,
	33349 - 19968: 0xE6A9,
	33351 - 19968: 0xEFF3,
	33369 - 19968: 0xF3ED,
	33380 - 19968: 0xEBFA,
	33382 - 19968: 0xF9E6,
	33390 - 19968: 0xCADD,
	33391 - 19968: 0xD5DE,
	33393 - 19968: 0xCADE,
	33394 - 19968: 0xDFE4,
	33398 - 19968: 0xE6FD,
	33400 - 19968: 0xF5AC,
	33406 - 19968: 0xE4F5,
	33419 - 19968: 0xE9E3,
	33421 - 19968: 0xEDCB,
	33422 - 19968: 0xCFE4,
	33426 - 19968: 0xD8D3,
	33433 - 19968: 0xDDB3,
	33434 - 19968: 0xD4EC,
	33437 - 19968: 0xF2B9,
	33439 - 19968: 0xDFB7,
	33445 - 19968: 0xCBCE,
	33446 - 19968: 0xFBD8,
	33449 - 19968: 0xD0D9,
	33452 - 19968: 0xDDD2,
	33453 - 19968: 0xF7F4,
	33454 - 19968: 0xE7DC,
	33455 - 19968: 0xE4A5,
	33457 - 19968: 0xFCA3,
	33459 - 19968: 0xDBBB,
	33463 - 19968: 0xF2BA,
	33464 - 19968: 0xE9FD,
	33465 - 19968: 0xD0CA,
	33467 - 19968: 0xF5D6,
	33468 - 19968: 0xD9C5,
	33469 - 19968: 0xE4B4,
	33471 - 19968: 0xEDA7,
	33489 - 19968: 0xEABD,
	33490 - 19968: 0xE6FE,
	33492 - 19968: 0xF7C4,
	33493 - 19968: 0xF5AD,
	33495 - 19968: 0xD9E0,
	33499 - 19968: 0xCAB4,
	33502 - 19968: 0xF8E2,
	33503 - 19968: 0xCFC2,
	33505 - 19968: 0xECBE,
	33509 - 19968: 0xE5B4,
	33510 - 19968: 0xCDC8,
	33511 - 19968: 0xEEC8,
	33521 - 19968: 0xE7C8,
	33533 - 19968: 0xCDC9,
	33534 - 19968: 0xF9B7,
	33537 - 19968: 0xF1E8,
	33538 - 19968: 0xD9F2,
	33539 - 19968: 0xDBF5,
	33540 - 19968: 0xCAB5,
	33541 - 19968: 0xD9C6,
	33545 - 19968: 0xD8C9,
	33559 - 19968: 0xD9AB,
	33576 - 19968: 0xEDBC,
	33579 - 19968: 0xD8D4,
	33583 - 19968: 0xDCDA,
	33585 - 19968: 0xE2BC,
	33588 - 19968: 0xFCED,
	33589 - 19968: 0xECE0,
	33590 - 19968: 0xD2FE,
	33592 - 19968: 0xE9C7,
	33593 - 19968: 0xE6AA,
	33600 - 19968: 0xE2F0,
	33607 - 19968: 0xFABB,
	33609 - 19968: 0xF5AE,
	33610 - 19968: 0xFBAA,
	33615 - 19968: 0xECFB,
	33617 - 19968: 0xECBF,
	33618 - 19968: 0xFCD8,
	33651 - 19968: 0xD4E5,
	33655 - 19968: 0xF9C3,
	33659 - 19968: 0xEEE2,
	33673 - 19968: 0xD7E9,
	33674 - 19968: 0xEDF6,
	33678 - 19968: 0xDEED,
	33686 - 19968: 0xCCEC,
	33688 - 19968: 0xE3EE,
	33694 - 19968: 0xE8D4,
	33698 - 19968: 0xFAF8,
	33705 - 19968: 0xDDB4,
	33706 - 19968: 0xE4B5,
	33707 - 19968: 0xD8B0,
	33725 - 19968: 0xD8D5,
	33729 - 19968: 0xF4EA,
	33733 - 19968: 0xCEB9,
	33737 - 19968: 0xD6E1,
	33738 - 19968: 0xCFD2,
	33740 - 19968: 0xD0B6,
	33747 - 19968: 0xCEA2,
	33750 - 19968: 0xF3EE,
	33756 - 19968: 0xF3F8,
	33769 - 19968: 0xDCCC,
	33771 - 19968: 0xD0CB,
	33775 - 19968: 0xFCA4,
	33776 - 19968: 0xCDCA,
	33777 - 19968: 0xD7D4,
	33778 - 19968: 0xDEA3,
	33780 - 19968: 0xE4E0,
	33785 - 19968: 0xEEC9,
	33789 - 19968: 0xE2DD,
	33795 - 19968: 0xF5FE,
	33796 - 19968: 0xD4AC,
	33802 - 19968: 0xD5D1,
	33804 - 19968: 0xD8F0,
	33805 - 19968: 0xF8C3,
	33806 - 19968: 0xEAD7,
	33833 - 19968: 0xF5D7,
	33836 - 19968: 0xD8BF,
	33841 - 19968: 0xFDC0,
	33848 - 19968: 0xEBAD,
	33853 - 19968: 0xD5AA,
	33865 - 19968: 0xE7A8,
	33879 - 19968: 0xEECA,
	33883 - 19968: 0xCAE7,
	33889 - 19968: 0xF8E3,
	33891 - 19968: 0xD4DD,
	33894 - 19968: 0xEAD8,
	33899 - 19968: 0xFBD9,
	33900 - 19968: 0xEDF7,
	33903 - 19968: 0xE5B5,
	33909 - 19968: 0xD0AD,
	33914 - 19968: 0xF1F1,
	33936 - 19968: 0xE2BD,
	33940 - 19968: 0xE3C8,
	33945 - 19968: 0xD9D5,
	33948 - 19968: 0xDFAA,
	33953 - 19968: 0xDBBC,
	33970 - 19968: 0xF8E4,
	33976 - 19968: 0xF1FA,
	33979 - 19968: 0xE5B6,
	33980 - 19968: 0xF3EF,
	33983 - 19968: 0xFBDA,
	33984 - 19968: 0xE1E0,
	33986 - 19968: 0xD9AC,
	33988 - 19968: 0xF5EB,
	33990 - 19968: 0xE0B6,
	33993 - 19968: 0xE9C8,
	33995 - 19968: 0xCBCF,
	33997 - 19968: 0xE3C9,
	34001 - 19968: 0xDEEE,
	34010 - 19968: 0xE2BE,
	34028 - 19968: 0xDCEF,
	34030 - 19968: 0xD6A5,
	34036 - 19968: 0xE2F1,
	34044 - 19968: 0xD6FE,
	34065 - 19968: 0xD9A1,
	34067 - 19968: 0xD8C0,
	34068 - 19968: 0xDCDB,
	34071 - 19968: 0xEDBD,
	34072 - 19968: 0xDFB8,
	34074 - 19968: 0xEAA5,
	34078 - 19968: 0xD7AD,
	34081 - 19968: 0xF3F9,
	34083 - 19968: 0xEDF8,
	34085 - 19968: 0xF5C7,
	34092 - 19968: 0xE1CA,
	34093 - 19968: 0xEBE3,
	34095 - 19968: 0xF2DE,
	34109 - 19968: 0xF8CC,
	34111 - 19968: 0xEAD9,
	34113 - 19968: 0xD3C6,
	34115 - 19968: 0xDBE6,
	34121 - 19968: 0xF5AF,
	34126 - 19968: 0xCEF0,
	34131 - 19968: 0xE9FE,
	34137 - 19968: 0xFBB6,
	34147 - 19968: 0xE2F2,
	34152 - 19968: 0xCFF2,
	34153 - 19968: 0xF7B9,
	34154 - 19968: 0xD9F3,
	34157 - 19968: 0xE1CB,
	34180 - 19968: 0xDADD,
	34183 - 19968: 0xDAB9,
	34191 - 19968: 0xEBFB,
	34193 - 19968: 0xCBB9,
	34196 - 19968: 0xEDF9,
	34203 - 19968: 0xE0E0,
	34214 - 19968: 0xF4C0,
	34216 - 19968: 0xFDBC,
	34217 - 19968: 0xDFB1,
	34218 - 19968: 0xE3EF,
	34223 - 19968: 0xE0A3,
	34224 - 19968: 0xFDB9,
	34234 - 19968: 0xF0B1,
	34241 - 19968: 0xCDCB,
	34249 - 19968: 0xEDBE,
	34253 - 19968: 0xD5C0,
	34254 - 19968: 0xE3F0,
	34255 - 19968: 0xEDFA,
	34261 - 19968: 0xE9E4,
	34268 - 19968: 0xD5ED,
	34269 - 19968: 0xE7DD,
	34276 - 19968: 0xD4F6,
	34277 - 19968: 0xE5B7,
	34281 - 19968: 0xDBE7,
	34282 - 19968: 0xE2BF,
	34295 - 19968: 0xEECB,
	34298 - 19968: 0xD7F4,
	34299 - 19968: 0xF0DD,
	34303 - 19968: 0xCEAB,
	34306 - 19968: 0xE7DE,
	34310 - 19968: 0xD6D6,
	34311 - 19968: 0xE1CC,
	34314 - 19968: 0xE8B3,
	34326 - 19968: 0xE5EE,
	34327 - 19968: 0xDCA2,
	34330 - 19968: 0xE0D0,
	34349 - 19968: 0xD5B5,
	34367 - 19968: 0xD5A1,
	34382 - 19968: 0xFBDB,
	34384 - 19968: 0xF9CB,
	34388 - 19968: 0xCBF3,
	34389 - 19968: 0xF4A5,
	34395 - 19968: 0xFAC8,
	34396 - 19968: 0xD6D7,
	34398 - 19968: 0xE9E5,
	34399 - 19968: 0xFBDC,
	34407 - 19968: 0xFDD0,
	34425 - 19968: 0xFBF6,
	34442 - 19968: 0xDAA5,
	34444 - 19968: 0xDBBD,
	34451 - 19968: 0xECE2,
	34467 - 19968: 0xCDF7,
	34468 - 19968: 0xF0DE,
	34473 - 19968: 0xF6C9,
	34503 - 19968: 0xDEEF,
	34507 - 19968: 0xD3B1,
	34516 - 19968: 0xFCEE,
	34521 - 19968: 0xE8C3,
	34523 - 19968: 0xF1C8,
	34527 - 19968: 0xCEF1,
	34532 - 19968: 0xF9ED,
	34541 - 19968: 0xF2F4,
	34558 - 19968: 0xE4B6,
	34560 - 19968: 0xF5B9,
	34562 - 19968: 0xDCF0,
	34563 - 19968: 0xE3F1,
	34568 - 19968: 0xE8A5,
	34584 - 19968: 0xF2BB,
	34586 - 19968: 0xDEA4,
	34588 - 19968: 0xDACC,
	34638 - 19968: 0xCAE9,
	34645 - 19968: 0xE3DA,
	34647 - 19968: 0xFCD9,
	34655 - 19968: 0xEADA,
	34662 - 19968: 0xF9C4,
	34664 - 19968: 0xE3A4,
	34676 - 19968: 0xFBDD,
	34678 - 19968: 0xEFCA,
	34680 - 19968: 0xE8C4,
	34690 - 19968: 0xD5CC,
	34701 - 19968: 0xEBD7,
	34719 - 19968: 0xD9AD,
	34722 - 19968: 0xFBAB,
	34739 - 19968: 0xD3D9,
	34746 - 19968: 0xD5A2,
	34756 - 19968: 0xF6DE,
	34784 - 19968: 0xDAF6,
	34796 - 19968: 0xE0D1,
	34799 - 19968: 0xE9A8,
	34802 - 19968: 0xF5F9,
	34809 - 19968: 0xFAAF,
	34811 - 19968: 0xEBFC,
	34814 - 19968: 0xE0EA,
	34821 - 19968: 0xE3B2,
	34847 - 19968: 0xD5C5,
	34850 - 19968: 0xF1E3,
	34851 - 19968: 0xD5EE,
	34865 - 19968: 0xCDCC,
	34870 - 19968: 0xEDD9,
	34875 - 19968: 0xD8C1,
	34880 - 19968: 0xFAEC,
	34886 - 19968: 0xF1EB,
	34892 - 19968: 0xFABC,
	34893 - 19968: 0xE6E2,
	34898 - 19968: 0xFAE5,
	34899 - 19968: 0xE2FA,
	34903 - 19968: 0xCAB6,
	34905 - 19968: 0xE4B7,
	34907 - 19968: 0xEADB,
	34909 - 19968: 0xF5FA,
	34913 - 19968: 0xFBAC,
	34914 - 19968: 0xCFC3,
	34915 - 19968: 0xEBFD,
	34920 - 19968: 0xF8FA,
	34923 - 19968: 0xDFB9,
	34928 - 19968: 0xE1F1,
	34930 - 19968: 0xD2A4,
	34935 - 19968: 0xF5FB,
	34942 - 19968: 0xD0DA,
	34943 - 19968: 0xD0DB,
	34945 - 19968: 0xEABE,
	34946 - 19968: 0xD9B1,
	34952 - 19968: 0xCAB7,
	34955 - 19968: 0xD3E7,
	34957 - 19968: 0xF8E5,
	34962 - 19968: 0xD3B2,
	34966 - 19968: 0xE2C0,
	34967 - 19968: 0xF2DF,
	34974 - 19968: 0xCDE5,
	34987 - 19968: 0xF9AC,
	34996 - 19968: 0xCDCD,
	35009 - 19968: 0xEEAE,
	35010 - 19968: 0xD6AE,
	35023 - 19968: 0xD7EA,
	35028 - 19968: 0xE7E0,
	35029 - 19968: 0xEBAE,
	35033 - 19968: 0xCFD9,
	35036 - 19968: 0xDCCD,
	35037 - 19968: 0xEDFB,
	35039 - 19968: 0xDEF0,
	35041 - 19968: 0xD7EB,
	35048 - 19968: 0xDEA5,
	35059 - 19968: 0xDFD7,
	35060 - 19968: 0xDBD0,
	35061 - 19968: 0xDBD1,
	35064 - 19968: 0xD5A3,
	35069 - 19968: 0xF0B2,
	35079 - 19968: 0xDCDC,
	35088 - 19968: 0xCAE8,
	35090 - 19968: 0xF8E6,
	35091 - 19968: 0xDCCE,
	35096 - 19968: 0xEADC,
	35097 - 19968: 0xDBD2,
	35109 - 19968: 0xE9B3,
	35114 - 19968: 0xF7DB,
	35126 - 19968: 0xE3A8,
	35128 - 19968: 0xD7AE,
	35131 - 19968: 0xE0E1,
	35137 - 19968: 0xCBBA,
	35140 - 19968: 0xE5D1,
	35167 - 19968: 0xD0DC,
	35172 - 19968: 0xD5C1,
	35178 - 19968: 0xD8CA,
	35186 - 19968: 0xE3A9,
	35199 - 19968: 0xE0A4,
	35201 - 19968: 0xE9A9,
	35203 - 19968: 0xD3C7,
	35206 - 19968: 0xDCDD,
	35207 - 19968: 0xF8AE,
	35211 - 19968: 0xCCB8,
	35215 - 19968: 0xD0AE,
	35219 - 19968: 0xD8F2,
	35222 - 19968: 0xE3CA,
	35233 - 19968: 0xCCAF,
	35241 - 19968: 0xD4AD,
	35242 - 19968: 0xF6D1,
	35250 - 19968: 0xD0CC,
	35258 - 19968: 0xCAC6,
	35261 - 19968: 0xD5C2,
	35264 - 19968: 0xCEBA,
	35282 - 19968: 0xCAC7,
	35299 - 19968: 0xFAB0,
	35316 - 19968: 0xDFD8,
	35320 - 19968: 0xF5BA,
	35328 - 19968: 0xE5EB,
	35330 - 19968: 0xEFF4,
	35331 - 19968: 0xDDB5,
	35336 - 19968: 0xCDAA,
	35338 - 19968: 0xE3F2,
	35340 - 19968: 0xFBF7,
	35342 - 19968: 0xF7D0,
	35347 - 19968: 0xFDBA,
	35350 - 19968: 0xFDE1,
	35351 - 19968: 0xF6FE,
	35352 - 19968: 0xD1C0,
	35355 - 19968: 0xE8C5,
	35357 - 19968: 0xE4B8,
	35359 - 19968: 0xE1E8,
	35363 - 19968: 0xCCC1,
	35365 - 19968: 0xD2ED,
	35370 - 19968: 0xDBBE,
	35373 - 19968: 0xE0E2,
	35377 - 19968: 0xFAC9,
	35380 - 19968: 0xE1CD,
	35382 - 19968: 0xCAB8,
	35386 - 19968: 0xF2E0,
	35387 - 19968: 0xF1C9,
	35408 - 19968: 0xDEF1,
	35412 - 19968: 0xF0DF,
	35413 - 19968: 0xF8C4,
	35419 - 19968: 0xEECC,
	35422 - 19968: 0xDEF2,
	35424 - 19968: 0xE7C9,
	35426 - 19968: 0xE2F3,
	35427 - 19968: 0xE7E1,
	35430 - 19968: 0xE3CB,
	35433 - 19968: 0xE3CC,
	35437 - 19968: 0xCFF8,
	35438 - 19968: 0xEFAC,
	35440 - 19968: 0xFDFE,
	35441 - 19968: 0xFCA5,
	35442 - 19968: 0xFAB1,
	35443 - 19968: 0xDFD9,
	35445 - 19968: 0xE0D2,
	35449 - 19968: 0xF4DA,
	35461 - 19968: 0xF1CA,
	35463 - 19968: 0xCEA3,
	35468 - 19968: 0xF2BC,
	35469 - 19968: 0xECE3,
	35475 - 19968: 0xE0A5,
	35477 - 19968: 0xF7AB,
	35480 - 19968: 0xEBAF,
	35486 - 19968: 0xE5DE,
	35488 - 19968: 0xE1A4,
	35489 - 19968: 0xCDAB,
	35491 - 19968: 0xD9F4,
	35492 - 19968: 0xE8A6,
	35493 - 19968: 0xCDCE,
	35494 - 19968: 0xE1E9,
	35496 - 19968: 0xFCEF,
	35498 - 19968: 0xE0E3,
	35504 - 19968: 0xE2C1,
	35506 - 19968: 0xCEA4,
	35513 - 19968: 0xDEA6,
	35516 - 19968: 0xEBFE,
	35518 - 19968: 0xEBDD,
	35519 - 19968: 0xF0E0,
	35522 - 19968: 0xF4DB,
	35524 - 19968: 0xE2F4,
	35527 - 19968: 0xD3C8,
	35531 - 19968: 0xF4EB,
	35533 - 19968: 0xEEB5,
	35535 - 19968: 0xF5D8,
	35538 - 19968: 0xD5DF,
	35542 - 19968: 0xD6E5,
	35547 - 19968: 0xEBB0,
	35548 - 19968: 0xF4E3,
	35553 - 19968: 0xE3CD,
	35558 - 19968: 0xF4F4,
	35559 - 19968: 0xFAB2,
	35562 - 19968: 0xEFF5,
	35563 - 19968: 0xCADF,
	35565 - 19968: 0xEBB1,
	35566 - 19968: 0xEDBF,
	35569 - 19968: 0xFDC9,
	35574 - 19968: 0xE4A6,
	35575 - 19968: 0xF9A4,
	35576 - 19968: 0xF0B3,
	35578 - 19968: 0xE5EC,
	35582 - 19968: 0xD1E7,
	35584 - 19968: 0xD9C7,
	35585 - 19968: 0xE4D7,
	35586 - 19968: 0xEADD,
	35588 - 19968: 0xD4F7,
	35598 - 19968: 0xDABA,
	35600 - 19968: 0xDACD,
	35604 - 19968: 0xF9CC,
	35606 - 19968: 0xE1DA,
	35607 - 19968: 0xDBBF,
	35609 - 19968: 0xCCC5,
	35610 - 19968: 0xECD0,
	35611 - 19968: 0xCBBB,
	35613 - 19968: 0xDEF3,
	35616 - 19968: 0xE9AA,
	35624 - 19968: 0xD9C8,
	35627 - 19968: 0xEEE3,
	35628 - 19968: 0xD7BD,
	35635 - 19968: 0xCFC4,
	35641 - 19968: 0xD0CD,
	35649 - 19968: 0xFCA6,
	35657 - 19968: 0xF1FB,
	35662 - 19968: 0xFDD2,
	35663 - 19968: 0xD1C1,
	35672 - 19968: 0xE3DB,
	35674 - 19968: 0xD3C9,
	35676 - 19968: 0xDCCF,
	35686 - 19968: 0xCCED,
	35692 - 19968: 0xDEA7,
	35695 - 19968: 0xE6BB,
	35696 - 19968: 0xECA1,
	35700 - 19968: 0xCCB9,
	35703 - 19968: 0xFBDE,
	35709 - 19968: 0xE7E2,
	35712 - 19968: 0xD4C1,
	35722 - 19968: 0xDCA8,
	35728 - 19968: 0xE2C2,
	35730 - 19968: 0xF3D8,
	35731 - 19968: 0xE5D3,
	35734 - 19968: 0xF3D9,
	35738 - 19968: 0xF3C6,
	35895 - 19968: 0xCDDB,
	35903 - 19968: 0xCDAC,
	35905 - 19968: 0xFCC3,
	35910 - 19968: 0xD4E7,
	35912 - 19968: 0xD1C2,
	35914 - 19968: 0xF9A5,
	35916 - 19968: 0xE8D5,
	35925 - 19968: 0xE3CE,
	35930 - 19968: 0xD4CA,
	35937 - 19968: 0xDFDA,
	35946 - 19968: 0xFBDF,
	35947 - 19968: 0xE7E3,
	35961 - 19968: 0xF8FB,
	35962 - 19968: 0xE3CF,
	35970 - 19968: 0xF5B0,
	35978 - 19968: 0xD8E7,
	35980 - 19968: 0xD9C9,
	35997 - 19968: 0xF8AF,
	35998 - 19968: 0xEFF6,
	36000 - 19968: 0xDDB6,
	36001 - 19968: 0xEEAF,
	36002 - 19968: 0xCDF8,
	36007 - 19968: 0xDEB8,
	36008 - 19968: 0xFCA7,
	36009 - 19968: 0xF7FC,
	36010 - 19968: 0xF7B1,
	36011 - 19968: 0xCEBB,
	36012 - 19968: 0xF4A1,
	36015 - 19968: 0xEECD,
	36016 - 19968: 0xE1AE,
	36019 - 19968: 0xECC3,
	36020 - 19968: 0xCFFE,
	36022 - 19968: 0xF8BF,
	36023 - 19968: 0xD8E2,
	36024 - 19968: 0xD3E8,
	36027 - 19968: 0xDEA8,
	36028 - 19968: 0xF4E4,
	36029 - 19968: 0xECC2,
	36031 - 19968: 0xD9F5,
	36032 - 19968: 0xF9C5,
	36033 - 19968: 0xDDD3,
	36034 - 19968: 0xD6F1,
	36035 - 19968: 0xECFC,
	36036 - 19968: 0xFCF0,
	36039 - 19968: 0xEDC0,
	36040 - 19968: 0xCAB9,
	36042 - 19968: 0xEEE4,
	36049 - 19968: 0xF2E1,
	36051 - 19968: 0xDEB9,
	36058 - 19968: 0xD6F2,
	36060 - 19968: 0xDEF4,
	36062 - 19968: 0xDFDB,
	36064 - 19968: 0xDBD3,
	36066 - 19968: 0xFAE7,
	36067 - 19968: 0xD8E3,
	36068 - 19968: 0xF4C1,
	36070 - 19968: 0xDDB7,
	36074 - 19968: 0xF2F5,
	36077 - 19968: 0xD4AE,
	36084 - 19968: 0xD6F3,
	36091 - 19968: 0xDDB8,
	36092 - 19968: 0xCFC5,
	36093 - 19968: 0xDFDF,
	36100 - 19968: 0xF2BE,
	36101 - 19968: 0xF6A1,
	36103 - 19968: 0xEBCB,
	36104 - 19968: 0xF1FC,
	36106 - 19968: 0xF3C7,
	36109 - 19968: 0xE0EB,
	36115 - 19968: 0xEDFC,
	36118 - 19968: 0xE1DB,
	36196 - 19968: 0xEEE5,
	36198 - 19968: 0xDEF5,
	36203 - 19968: 0xFAD3,
	36208 - 19968: 0xF1CB,
	36211 - 19968: 0xD0AF,
	36212 - 19968: 0xDDB9,
	36215 - 19968: 0xD1C3,
	36229 - 19968: 0xF5B1,
	36234 - 19968: 0xEAC6,
	36249 - 19968: 0xF0E1,
	36259 - 19968: 0xF6AC,
	36264 - 19968: 0xF5D9,
	36275 - 19968: 0xF0EB,
	36282 - 19968: 0xDDBA,
	36286 - 19968: 0xF2BF,
	36294 - 19968: 0xF7C5,
	36299 - 19968: 0xDBA2,
	36300 - 19968: 0xF2F6,
	36303 - 19968: 0xCABA,
	36315 - 19968: 0xF7F5,
	36317 - 19968: 0xCBE5,
	36321 - 19968: 0xEEE6,
	36323 - 19968: 0xE0D3,
	36328 - 19968: 0xCEA5,
	36335 - 19968: 0xD6D8,
	36339 - 19968: 0xD4AF,
	36362 - 19968: 0xE9C9,
	36367 - 19968: 0xD3CE,
	36368 - 19968: 0xF4C2,
	36382 - 19968: 0xCBE6,
	36394 - 19968: 0xF1A1,
	36400 - 19968: 0xEBB2,
	36405 - 19968: 0xF1A2,
	36418 - 19968: 0xEBB3,
	36420 - 19968: 0xF0B4,
	36423 - 19968: 0xCBF4,
	36424 - 19968: 0xD4B0,
	36425 - 19968: 0xF3B2,
	36426 - 19968: 0xFBB7,
	36441 - 19968: 0xF5EC,
	36447 - 19968: 0xEEE7,
	36448 - 19968: 0xF4B2,
	36468 - 19968: 0xF5ED,
	36470 - 19968: 0xCFF3,
	36481 - 19968: 0xF0E2,
	36487 - 19968: 0xEECE,
	36490 - 19968: 0xF1CC,
	36493 - 19968: 0xE5B8,
	36522 - 19968: 0xD7F5,
	36523 - 19968: 0xE3F3,
	36524 - 19968: 0xCFE5,
	36544 - 19968: 0xCFC6,
	36554 - 19968: 0xF3B3,
	36555 - 19968: 0xE4D8,
	36556 - 19968: 0xCFF9,
	36557 - 19968: 0xCFDA,
	36562 - 19968: 0xFACD,
	36575 - 19968: 0xE6E3,
	36587 - 19968: 0xF2E2,
	36600 - 19968: 0xF5EE,
	36603 - 19968: 0xCABB,
	36606 - 19968: 0xE3DC,
	36611 - 19968: 0xCEF2,
	36613 - 19968: 0xD6D9,
	36617 - 19968: 0xEEB0,
	36626 - 19968: 0xF4E5,
	36627 - 19968: 0xD8C2,
	36628 - 19968: 0xDCD0,
	36629 - 19968: 0xCCEE,
	36635 - 19968: 0xD5E0,
	36636 - 19968: 0xF6CA,
	36637 - 19968: 0xFDCA,
	36638 - 19968: 0xD8D6,
	36639 - 19968: 0xF4CF,
	36646 - 19968: 0xD6A6,
	36647 - 19968: 0xDCBE,
	36649 - 19968: 0xDBD4,
	36650 - 19968: 0xD7C7,
	36655 - 19968: 0xF2FE,
	36659 - 19968: 0xF1CD,
	36664 - 19968: 0xE2C3,
	36665 - 19968: 0xDCDE,
	36667 - 19968: 0xDCDF,
	36670 - 19968: 0xEFAD,
	36671 - 19968: 0xE6AB,
	36676 - 19968: 0xF9DD,
	36677 - 19968: 0xEABF,
	36681 - 19968: 0xEFAE,
	36685 - 19968: 0xF4D0,
	36686 - 19968: 0xCEF3,
	36701 - 19968: 0xE6AC,
	36703 - 19968: 0xCEDE,
	36706 - 19968: 0xD5F9,
	36763 - 19968: 0xE3F4,
	36764 - 19968: 0xCDD0,
	36771 - 19968: 0xD5B8,
	36774 - 19968: 0xF7FD,
	36776 - 19968: 0xDCA9,
	36781 - 19968: 0xDEF6,
	36783 - 19968: 0xDCAA,
	36784 - 19968: 0xF2E3,
	36785 - 19968: 0xE9B4,
	36786 - 19968: 0xD2DC,
	36802 - 19968: 0xE9E6,
	36805 - 19968: 0xE3F6,
	36814 - 19968: 0xE7CA,
	36817 - 19968: 0xD0CE,
	36820 - 19968: 0xDAF7,
	36838 - 19968: 0xCABC,
	36842 - 19968: 0xEEE8,
	36843 - 19968: 0xDADE,
	36845 - 19968: 0xF2F7,
	36848 - 19968: 0xE2FB,
	36850 - 19968: 0xCCA6,
	36855 - 19968: 0xDABB,
	36857 - 19968: 0xEEE9,
	36861 - 19968: 0xF5DA,
	36864 - 19968: 0xF7DC,
	36865 - 19968: 0xE1EA,
	36866 - 19968: 0xCEC1,
	36867 - 19968: 0xD4B1,
	36869 - 19968: 0xFDB1,
	36870 - 19968: 0xE6BD,
	36872 - 19968: 0xFBAD,
	36875 - 19968: 0xF8E7,
	36877 - 19968: 0xE1CE,
	36879 - 19968: 0xF7E2,
	36880 - 19968: 0xF5EF,
	36881 - 19968: 0xCFC7,
	36884 - 19968: 0xD4B2,
	36885 - 19968: 0xCCEF,
	36887 - 19968: 0xD4E8,
	36889 - 19968: 0xEECF,
	36890 - 19968: 0xF7D7,
	36893 - 19968: 0xE0A6,
	36894 - 19968: 0xD6C1,
	36895 - 19968: 0xE1DC,
	36896 - 19968: 0xF0E3,
	36897 - 19968: 0xF1E4,
	36898 - 19968: 0xDCF1,
	36899 - 19968: 0xD6A7,
	36910 - 19968: 0xF4F5,
	36913 - 19968: 0xF1CE,
	36914 - 19968: 0xF2E4,
	36917 - 19968: 0xD0B0,
	36920 - 19968: 0xECEF,
	36924 - 19968: 0xF9BA,
	36926 - 19968: 0xEBB5,
	36929 - 19968: 0xD4ED,
	36930 - 19968: 0xE2C4,
	36935 - 19968: 0xE9E7,
	36938 - 19968: 0xEBB4,
	36939 - 19968: 0xEAA1,
	36941 - 19968: 0xF8BC,
	36942 - 19968: 0xCEA6,
	36944 - 19968: 0xF9C6,
	36945 - 19968: 0xFCDA,
	36947 - 19968: 0xD4B3,
	36948 - 19968: 0xD3B9,
	36949 - 19968: 0xEADE,
	36953 - 19968: 0xE9AB,
	36956 - 19968: 0xE1E1,
	36957 - 19968: 0xD3CF,
	36958 - 19968: 0xF4F6,
	36960 - 19968: 0xEAC0,
	36961 - 19968: 0xE1CF,
	36963 - 19968: 0xCCBA,
	36969 - 19968: 0xEEEA,
	36973 - 19968: 0xF0E4,
	36974 - 19968: 0xF3B4,
	36975 - 19968: 0xD4EE,
	36978 - 19968: 0xF2C0,
	36981 - 19968: 0xF1E5,
	36983 - 19968: 0xF4C3,
	36984 - 19968: 0xE0D4,
	36986 - 19968: 0xEBB6,
	36988 - 19968: 0xD7A1,
	36989 - 19968: 0xCBE8,
	36991 - 19968: 0xF9AD,
	36992 - 19968: 0xE9AD,
	36993 - 19968: 0xD8E4,
	36994 - 19968: 0xFAB3,
	36995 - 19968: 0xE2C5,
	36996 - 19968: 0xFCBD,
	36999 - 19968: 0xECC4,
	37000 - 19968: 0xD8B1,
	37002 - 19968: 0xDCAB,
	37007 - 19968: 0xD5A4,
	37009 - 19968: 0xEBE9,
	37013 - 19968: 0xE8BB,
	37017 - 19968: 0xD8D7,
	37026 - 19968: 0xFBAE,
	37027 - 19968: 0xD1E1,
	37030 - 19968: 0xDBC0,
	37032 - 19968: 0xF5BE,
	37034 - 19968: 0xDEF7,
	37039 - 19968: 0xCAFB,
	37040 - 19968: 0xF7C6,
	37041 - 19968: 0xCFC8,
	37045 - 19968: 0xE1D0,
	37048 - 19968: 0xEED0,
	37057 - 19968: 0xE9F4,
	37066 - 19968: 0xCEF4,
	37086 - 19968: 0xD5CD,
	37089 - 19968: 0xCFDB,
	37096 - 19968: 0xDDBB,
	37101 - 19968: 0xCEAC,
	37109 - 19968: 0xE9E8,
	37117 - 19968: 0xD4B4,
	37122 - 19968: 0xE4C7,
	37138 - 19968: 0xF5DB,
	37141 - 19968: 0xFAC1,
	37145 - 19968: 0xDEA9,
	37159 - 19968: 0xD4F8,
	37165 - 19968: 0xEFF7,
	37170 - 19968: 0xD3B3,
	37193 - 19968: 0xEBB7,
	37194 - 19968: 0xEFF8,
	37195 - 19968: 0xF5DC,
	37196 - 19968: 0xEDCC,
	37197 - 19968: 0xDBD5,
	37198 - 19968: 0xF1CF,
	37202 - 19968: 0xF1D0,
	37218 - 19968: 0xF5B2,
	37225 - 19968: 0xD9AE,
	37226 - 19968: 0xD5AC,
	37228 - 19968: 0xE2C6,
	37237 - 19968: 0xFDA3,
	37239 - 19968: 0xFBE5,
	37240 - 19968: 0xDFAB,
	37255 - 19968: 0xE2F5,
	37257 - 19968: 0xF6AD,
	37259 - 19968: 0xF5B3,
	37261 - 19968: 0xF0B5,
	37266 - 19968: 0xE1A5,
	37276 - 19968: 0xF5DD,
	37291 - 19968: 0xECA2,
	37292 - 19968: 0xEDFD,
	37294 - 19968: 0xF5B4,
	37295 - 19968: 0xFBB8,
	37297 - 19968: 0xDBA3,
	37300 - 19968: 0xD6CA,
	37301 - 19968: 0xCBD9,
	37312 - 19968: 0xE5D4,
	37319 - 19968: 0xF3FA,
	37321 - 19968: 0xEBB8,
	37323 - 19968: 0xE0B7,
	37324 - 19968: 0xD7EC,
	37325 - 19968: 0xF1EC,
	37326 - 19968: 0xE5AF,
	37327 - 19968: 0xD5E1,
	37328 - 19968: 0xD7ED,
	37329 - 19968: 0xD1D1,
	37335 - 19968: 0xE1F2,
	37336 - 19968: 0xEFF9,
	37340 - 19968: 0xDDBC,
	37341 - 19968: 0xF6DC,
	37347 - 19968: 0xF0E5,
	37351 - 19968: 0xF4C4,
	37354 - 19968: 0xE9E9,
	37365 - 19968: 0xF3FB,
	37389 - 19968: 0xD4EF,
	37392 - 19968: 0xCCA2,
	37393 - 19968: 0xF7FE,
	37394 - 19968: 0xDFBC,
	37399 - 19968: 0xEBCD,
	37406 - 19968: 0xD0B7,
	37428 - 19968: 0xD6C2,
	37434 - 19968: 0xE8AD,
	37439 - 19968: 0xEFAF,
	37440 - 19968: 0xCBA5,
	37445 - 19968: 0xCBE9,
	37449 - 19968: 0xFAE8,
	37463 - 19968: 0xCCC6,
	37467 - 19968: 0xE6E7,
	37470 - 19968: 0xEAC7,
	37474 - 19968: 0xDBA4,
	37476 - 19968: 0xCFC9,
	37477 - 19968: 0xE2FC,
	37478 - 19968: 0xEFFA,
	37504 - 19968: 0xEBDE,
	37507 - 19968: 0xF5C8,
	37509 - 19968: 0xD4DE,
	37521 - 19968: 0xE0D5,
	37523 - 19968: 0xEFB0,
	37526 - 19968: 0xE2C7,
	37528 - 19968: 0xD9AF,
	37532 - 19968: 0xF9E7,
	37555 - 19968: 0xE7E5,
	37558 - 19968: 0xCFCA,
	37559 - 19968: 0xE1D1,
	37561 - 19968: 0xE2C8,
	37580 - 19968: 0xEFFB,
	37583 - 19968: 0xFAF9,
	37586 - 19968: 0xDCF2,
	37604 - 19968: 0xE0A7,
	37610 - 19968: 0xF8E8,
	37624 - 19968: 0xCBEA,
	37628 - 19968: 0xCBBC,
	37636 - 19968: 0xD6E2,
	37648 - 19968: 0xF5DE,
	37656 - 19968: 0xF5DF,
	37658 - 19968: 0xEEB6,
	37662 - 19968: 0xE2F6,
	37663 - 19968: 0xD3CA,
	37664 - 19968: 0xEFFC,
	37665 - 19968: 0xD1C4,
	37666 - 19968: 0xEFB1,
	37668 - 19968: 0xD1C5,
	37670 - 19968: 0xD0DE,
	37672 - 19968: 0xD9E1,
	37675 - 19968: 0xE0B8,
	37678 - 19968: 0xCDD1,
	37679 - 19968: 0xF3B9,
	37704 - 19968: 0xE7CC,
	37706 - 19968: 0xD6A8,
	37707 - 19968: 0xCEA7,
	37709 - 19968: 0xD4B5,
	37716 - 19968: 0xE4C8,
	37723 - 19968: 0xD3B4,
	37742 - 19968: 0xEBB9,
	37749 - 19968: 0xCBF5,
	37756 - 19968: 0xF6DD,
	37758 - 19968: 0xF1A3,
	37772 - 19968: 0xCCC7,
	37780 - 19968: 0xE9CA,
	37782 - 19968: 0xE1F0,
	37786 - 19968: 0xF5E0,
	37795 - 19968: 0xFBAF,
	37799 - 19968: 0xCBD1,
	37804 - 19968: 0xFBE0,
	37805 - 19968: 0xF2E5,
	37808 - 19968: 0xECF0,
	37827 - 19968: 0xF0EC,
	37841 - 19968: 0xEEEB,
	37854 - 19968: 0xE9CB,
	37857 - 19968: 0xCCF0,
	37860 - 19968: 0xD7AF,
	37878 - 19968: 0xF3A1,
	37892 - 19968: 0xFCF5,
	37912 - 19968: 0xF1A4,
	37925 - 19968: 0xE0D6,
	37931 - 19968: 0xEFB2,
	37941 - 19968: 0xF4D1,
	37944 - 19968: 0xF7A1,
	37956 - 19968: 0xF1D1,
	37969 - 19968: 0xCAFC,
	37970 - 19968: 0xCAFD,
	37979 - 19968: 0xCECE,
	38013 - 19968: 0xF3C8,
	38015 - 19968: 0xF3BA,
	38263 - 19968: 0xEDFE,
	38272 - 19968: 0xDAA6,
	38275 - 19968: 0xE0EC,
	38281 - 19968: 0xF8CD,
	38283 - 19968: 0xCBD2,
	38287 - 19968: 0xEBCE,
	38289 - 19968: 0xF9D8,
	38290 - 19968: 0xF9D9,
	38291 - 19968: 0xCAE0,
	38292 - 19968: 0xDACA,
	38296 - 19968: 0xCBA6,
	38307 - 19968: 0xCAC8,
	38308 - 19968: 0xF9EE,
	38309 - 19968: 0xDBEC,
	38312 - 19968: 0xD0B1,
	38317 - 19968: 0xD5EF,
	38321 - 19968: 0xE6F3,
	38331 - 19968: 0xE7A2,
	38332 - 19968: 0xE4D9,
	38343 - 19968: 0xE4E1,
	38346 - 19968: 0xFCC4,
	38356 - 19968: 0xF9EF,
	38357 - 19968: 0xCFF4,
	38358 - 19968: 0xF7E6,
	38364 - 19968: 0xCEBC,
	38369 - 19968: 0xF4C5,
	38370 - 19968: 0xDCA3,
	38428 - 19968: 0xDDBD,
	38433 - 19968: 0xF4C6,
	38442 - 19968: 0xF8A1,
	38446 - 19968: 0xE8D6,
	38450 - 19968: 0xDBC1,
	38459 - 19968: 0xF0E6,
	38463 - 19968: 0xE4B9,
	38464 - 19968: 0xF6ED,
	38466 - 19968: 0xF9AE,
	38468 - 19968: 0xDDBE,
	38475 - 19968: 0xD7B0,
	38476 - 19968: 0xD8E8,
	38477 - 19968: 0xCBBD,
	38480 - 19968: 0xF9DA,
	38491 - 19968: 0xF8CE,
	38492 - 19968: 0xF9F0,
	38493 - 19968: 0xE0ED,
	38494 - 19968: 0xE3B3,
	38495 - 19968: 0xF4B3,
	38498 - 19968: 0xEAC2,
	38499 - 19968: 0xF2E6,
	38500 - 19968: 0xF0B6,
	38506 - 19968: 0xDBD6,
	38512 - 19968: 0xEBE4,
	38515 - 19968: 0xF2E7,
	38517 - 19968: 0xD7D5,
	38518 - 19968: 0xD4B6,
	38519 - 19968: 0xF9E8,
	38520 - 19968: 0xD7C1,
	38525 - 19968: 0xE5D5,
	38533 - 19968: 0xE9EA,
	38534 - 19968: 0xD7CC,
	38538 - 19968: 0xD3E9,
	38539 - 19968: 0xE2C9,
	38541 - 19968: 0xFCDB,
	38542 - 19968: 0xCDAD,
	38548 - 19968: 0xCCB0,
	38549 - 19968: 0xEAA2,
	38552 - 19968: 0xE4F6,
	38553 - 19968: 0xD0C0,
	38555 - 19968: 0xF0B7,
	38556 - 19968: 0xEEA1,
	38563 - 19968: 0xD7F6,
	38567 - 19968: 0xE2CA,
	38568 - 19968: 0xE2CB,
	38570 - 19968: 0xFACF,
	38577 - 19968: 0xEBDF,
	38583 - 19968: 0xD6CB,
	38587 - 19968: 0xF4B4,
	38592 - 19968: 0xEDCD,
	38593 - 19968: 0xE4D2,
	38596 - 19968: 0xEAA9,
	38597 - 19968: 0xE4BA,
	38598 - 19968: 0xF3A2,
	38599 - 19968: 0xCDD2,
	38601 - 19968: 0xF6CB,
	38603 - 19968: 0xF1E6,
	38604 - 19968: 0xEDC1,
	38605 - 19968: 0xE8BC,
	38606 - 19968: 0xEED1,
	38613 - 19968: 0xF0E7,
	38614 - 19968: 0xE2CC,
	38617 - 19968: 0xE4AA,
	38619 - 19968: 0xF5E1,
	38620 - 19968: 0xEDDA,
	38626 - 19968: 0xD7EE,
	38627 - 19968: 0xD1F1,
	38632 - 19968: 0xE9EB,
	38633 - 19968: 0xE9EC,
	38634 - 19968: 0xE0E4,
	38639 - 19968: 0xDAA7,
	38640 - 19968: 0xDDD4,
	38642 - 19968: 0xEAA3,
	38646 - 19968: 0xD6C3,
	38647 - 19968: 0xD6F4,
	38649 - 19968: 0xDADF,
	38651 - 19968: 0xEFB3,
	38656 - 19968: 0xE2CD,
	38662 - 19968: 0xEFFD,
	38663 - 19968: 0xF2E8,
	38673 - 19968: 0xEFC5,
	38675 - 19968: 0xE7E7,
	38678 - 19968: 0xD7FD,
	38681 - 19968: 0xE7CE,
	38684 - 19968: 0xDFDC,
	38686 - 19968: 0xF9C7,
	38695 - 19968: 0xD9F6,
	38704 - 19968: 0xDFAC,
	38706 - 19968: 0xD6DA,
	38713 - 19968: 0xDCA4,
	38717 - 19968: 0xF0B8,
	38722 - 19968: 0xD5FA,
	38724 - 19968: 0xE4F7,
	38728 - 19968: 0xD6C4,
	38737 - 19968: 0xF4EC,
	38742 - 19968: 0xEFFE,
	38748 - 19968: 0xF0A1,
	38750 - 19968: 0xDEAA,
	38753 - 19968: 0xDABC,
	38754 - 19968: 0xD8FC,
	38761 - 19968: 0xFAD4,
	38765 - 19968: 0xECE5,
	38772 - 19968: 0xFCA8,
	38775 - 19968: 0xECE6,
	38778 - 19968: 0xD8CB,
	38795 - 19968: 0xFBB9,
	38797 - 19968: 0xE4D3,
	38799 - 19968: 0xCDF9,
	38816 - 19968: 0xCFD3,
	38824 - 19968: 0xCAEA,
	38827 - 19968: 0xCFD4,
	38829 - 19968: 0xF8BD,
	38854 - 19968: 0xF4C7,
	38859 - 19968: 0xEADF,
	38867 - 19968: 0xF9DB,
	38876 - 19968: 0xD4B7,
	38899 - 19968: 0xEBE5,
	38902 - 19968: 0xE1D2,
	38907 - 19968: 0xEAA4,
	38911 - 19968: 0xFAC2,
	38912 - 19968: 0xFBE1,
	38913 - 19968: 0xFAED,
	38914 - 19968: 0xF0A2,
	38915 - 19968: 0xCCF1,
	38917 - 19968: 0xFAA3,
	38918 - 19968: 0xE2F7,
	38920 - 19968: 0xE2CE,
	38922 - 19968: 0xE9F5,
	38924 - 19968: 0xE1EB,
	38928 - 19968: 0xE7E8,
	38929 - 19968: 0xE8D7,
	38930 - 19968: 0xDAF8,
	38931 - 19968: 0xD4CB,
	38935 - 19968: 0xF7F6,
	38936 - 19968: 0xD6C5,
	38957 - 19968: 0xD4E9,
	38960 - 19968: 0xFAFA,
	38968 - 19968: 0xCCF2,
	38969 - 19968: 0xF7DD,
	38971 - 19968: 0xDEBA,
	38982 - 19968: 0xCEA8,
	38988 - 19968: 0xF0B9,
	38989 - 19968: 0xE4FE,
	38990 - 19968: 0xE4C9,
	38996 - 19968: 0xE4D4,
	39000 - 19968: 0xEAC3,
	39002 - 19968: 0xEFB4,
	39006 - 19968: 0xD7BE,
	39013 - 19968: 0xFBE2,
	39015 - 19968: 0xCDD3,
	39019 - 19968: 0xEFB5,
	39023 - 19968: 0xFAE9,
	39080 - 19968: 0xF9A6,
	39087 - 19968: 0xDFBD,
	39089 - 19968: 0xF7C7,
	39108 - 19968: 0xF8FD,
	39111 - 19968: 0xF8FC,
	39131 - 19968: 0xDEAB,
	39132 - 19968: 0xDBE8,
	39135 - 19968: 0xE3DD,
	39137 - 19968: 0xE1E2,
	39138 - 19968: 0xD1C6,
	39149 - 19968: 0xF6D0,
	39150 - 19968: 0xEBE6,
	39151 - 19968: 0xDAF9,
	39156 - 19968: 0xECC7,
	39164 - 19968: 0xDEF8,
	39165 - 19968: 0xF8E9,
	39166 - 19968: 0xE3DE,
	39171 - 19968: 0xCEF5,
	39177 - 19968: 0xFAC3,
	39178 - 19968: 0xE5D7,
	39180 - 19968: 0xECC8,
	39184 - 19968: 0xF3C9,
	39187 - 19968: 0xE4BB,
	39192 - 19968: 0xE6AE,
	39198 - 19968: 0xEFB6,
	39200 - 19968: 0xDCBF,
	39208 - 19968: 0xCEBD,
	39237 - 19968: 0xD8C3,
	39241 - 19968: 0xD0CF,
	39243 - 19968: 0xCFFA,
	39244 - 19968: 0xF3CA,
	39245 - 19968: 0xE0D7,
	39249 - 19968: 0xD1C7,
	39250 - 19968: 0xE9AE,
	39252 - 19968: 0xE8BD,
	39255 - 19968: 0xFAC4,
	39318 - 19968: 0xE2CF,
	39321 - 19968: 0xFAC5,
	39325 - 19968: 0xF9B8,
	39333 - 19968: 0xDCE0,
	39336 - 19968: 0xFBB0,
	39340 - 19968: 0xD8A9,
	39341 - 19968: 0xE5DF,
	39342 - 19968: 0xF9A7,
	39345 - 19968: 0xF6EE,
	39347 - 19968: 0xF6CC,
	39348 - 19968: 0xE2F8,
	39353 - 19968: 0xECF1,
	39361 - 19968: 0xDAE0,
	39376 - 19968: 0xF1D2,
	39377 - 19968: 0xD2CC,
	39378 - 19968: 0xCFCB,
	39381 - 19968: 0xCABD,
	39385 - 19968: 0xDDBF,
	39389 - 19968: 0xF6EF,
	39391 - 19968: 0xDEF9,
	39405 - 19968: 0xFAB4,
	39409 - 19968: 0xD5AD,
	39423 - 19968: 0xF1E7,
	39425 - 19968: 0xDEBE,
	39432 - 19968: 0xDCC0,
	39438 - 19968: 0xD1C8,
	39439 - 19968: 0xD1C9,
	39449 - 19968: 0xF8BE,
	39467 - 19968: 0xCBF6,
	39472 - 19968: 0xD4F9,
	39478 - 19968: 0xF5E2,
	39479 - 19968: 0xE1D3,
	39488 - 19968: 0xD8E9,
	39491 - 19968: 0xF8FE,
	39493 - 19968: 0xCFCC,
	39501 - 19968: 0xFDA4,
	39509 - 19968: 0xCEF6,
	39511 - 19968: 0xFAD0,
	39514 - 19968: 0xCCF3,
	39515 - 19968: 0xE6BE,
	39519 - 19968: 0xF6AE,
	39522 - 19968: 0xD5F0,
	39525 - 19968: 0xD1CA,
	39529 - 19968: 0xFCBE,
	39530 - 19968: 0xD5F1,
	39592 - 19968: 0xCDE9,
	39608 - 19968: 0xFAB5,
	39635 - 19968: 0xE2D0,
	39636 - 19968: 0xF4F7,
	39640 - 19968: 0xCDD4,
	39653 - 19968: 0xE7A3,
	39662 - 19968: 0xDBA5,
	39706 - 19968: 0xE2D1,
	39719 - 19968: 0xD7A2,
	39722 - 19968: 0xF7E3,
	39729 - 19968: 0xEAA6,
	39740 - 19968: 0xD0A1,
	39745 - 19968: 0xCEDA,
	39746 - 19968: 0xFBEB,
	39747 - 19968: 0xDBA6,
	39748 - 19968: 0xDBDE,
	39749 - 19968: 0xD8E5,
	39759 - 19968: 0xEAE0,
	39764 - 19968: 0xD8AA,
	39770 - 19968: 0xE5E0,
	39791 - 19968: 0xD6DB,
	39822 - 19968: 0xEFC6,
	39825 - 19968: 0xF8EA,
	39839 - 19968: 0xE4D5,
	39851 - 19968: 0xCEF7,
	39854 - 19968: 0xE0D8,
	39881 - 19968: 0xD7EF,
	39894 - 19968: 0xF4ED,
	39908 - 19968: 0xCDE6,
	39912 - 19968: 0xCCF4,
	39949 - 19968: 0xF5E3,
	39952 - 19968: 0xE4CA,
	39954 - 19968: 0xDCE1,
	39957 - 19968: 0xF9C8,
	39973 - 19968: 0xFCBF,
	39986 - 19968: 0xE8A7,
	39995 - 19968: 0xD8C4,
	40007 - 19968: 0xCBBE,
	40009 - 19968: 0xDCAE,
	40023 - 19968: 0xD7F7,
	40165 - 19968: 0xF0E8,
	40167 - 19968: 0xDDC0,
	40169 - 19968: 0xCFCD,
	40179 - 19968: 0xDCF3,
	40180 - 19968: 0xD9B0,
	40182 - 19968: 0xE6E9,
	40201 - 19968: 0xE4BC,
	40219 - 19968: 0xEAC4,
	40230 - 19968: 0xE4EC,
	40232 - 19968: 0xE4E5,
	40251 - 19968: 0xFBF8,
	40273 - 19968: 0xCCBB,
	40285 - 19968: 0xE4BD,
	40288 - 19968: 0xCDDC,
	40289 - 19968: 0xD9F7,
	40300 - 19968: 0xDDDF,
	40306 - 19968: 0xEDCE,
	40361 - 19968: 0xD9D0,
	40367 - 19968: 0xE5A3,
	40372 - 19968: 0xF9CD,
	40388 - 19968: 0xCDAE,
	40407 - 19968: 0xCFCE,
	40434 - 19968: 0xF6AF,
	40440 - 19968: 0xFDD3,
	40441 - 19968: 0xEBED,
	40442 - 19968: 0xD6DC,
	40474 - 19968: 0xE5A4,
	40478 - 19968: 0xD5B6,
	40565 - 19968: 0xD6DD,
	40569 - 19968: 0xF9E9,
	40573 - 19968: 0xE7A4,
	40575 - 19968: 0xD6E3,
	40594 - 19968: 0xD1CB,
	40595 - 19968: 0xD6E4,
	40599 - 19968: 0xD5F2,
	40605 - 19968: 0xDEFA,
	40607 - 19968: 0xD7F8,
	40613 - 19968: 0xD8EA,
	40628 - 19968: 0xCFD5,
	40629 - 19968: 0xD8FD,
	40635 - 19968: 0xD8AB,
	40638 - 19968: 0xFDCB,
	40643 - 19968: 0xFCDC,
	40653 - 19968: 0xE0A8,
	40654 - 19968: 0xD5F3,
	40657 - 19968: 0xFDD9,
	40660 - 19968: 0xCCA3,
	40664 - 19968: 0xD9F9,
	40667 - 19968: 0xD3EA,
	40668 - 19968: 0xF5F5,
	40670 - 19968: 0xEFC7,
	40680 - 19968: 0xD3DA,
	40692 - 19968: 0xDABD,
	40711 - 19968: 0xE8A8,
	40712 - 19968: 0xDCAF,
	40718 - 19968: 0xF0A3,
	40723 - 19968: 0xCDD5,
	40736 - 19968: 0xE0A9,
	40763 - 19968: 0xDEAC,
	40778 - 19968: 0xF0BA,
	40779 - 19968: 0xEEB1,
	40782 - 19968: 0xEEB2,
	40786 - 19968: 0xF6CD,
	40799 - 19968: 0xEED2,
	40801 - 19968: 0xD6C6,
	40807 - 19968: 0xE0E5,
	40810 - 19968: 0xF3BB,
	40812 - 19968: 0xE5E1,
	40823 - 19968: 0xE4CB,
	40845 - 19968: 0xD7A3,
	40848 - 19968: 0xDBC2,
	40853 - 19968: 0xCAFE,
	40860 - 19968: 0xCFCF,
}

const encode1Low, encode1High = 44032, 55204

var encode1 = [...]uint16{
	44032 - 44032: 0xB0A1,
	44033 - 44032: 0xB0A2,
	44034 - 44032: 0x8141,
	44035 - 44032: 0x8142,
	44036 - 44032: 0xB0A3,
	44037 - 44032: 0x8143,
	44038 - 44032: 0x8144,
	44039 - 44032: 0xB0A4,
	44040 - 44032: 0xB0A5,
	44041 - 44032: 0xB0A6,
	44042 - 44032: 0xB0A7,
	44043 - 44032: 0x8145,
	44044 - 44032: 0x8146,
	44045 - 44032: 0x8147,
	44046 - 44032: 0x8148,
	44047 - 44032: 0x8149,
	44048 - 44032: 0xB0A8,
	44049 - 44032: 0xB0A9,
	44050 - 44032: 0xB0AA,
	44051 - 44032: 0xB0AB,
	44052 - 44032: 0xB0AC,
	44053 - 44032: 0xB0AD,
	44054 - 44032: 0xB0AE,
	44055 - 44032: 0xB0AF,
	44056 - 44032: 0x814A,
	44057 - 44032: 0xB0B0,
	44058 - 44032: 0xB0B1,
	44059 - 44032: 0xB0B2,
	44060 - 44032: 0xB0B3,
	44061 - 44032: 0xB0B4,
	44062 - 44032: 0x814B,
	44063 - 44032: 0x814C,
	44064 - 44032: 0xB0B5,
	44065 - 44032: 0x814D,
	44066 - 44032: 0x814E,
	44067 - 44032: 0x814F,
	44068 - 44032: 0xB0B6,
	44069 - 44032: 0x8150,
	44070 - 44032: 0x8151,
	44071 - 44032: 0x8152,
	44072 - 44032: 0x8153,
	44073 - 44032: 0x8154,
	44074 - 44032: 0x8155,
	44075 - 44032: 0x8156,
	44076 - 44032: 0xB0B7,
	44077 - 44032: 0xB0B8,
	44078 - 44032: 0x8157,
	44079 - 44032: 0xB0B9,
	44080 - 44032: 0xB0BA,
	44081 - 44032: 0xB0BB,
	44082 - 44032: 0x8158,
	44083 - 44032: 0x8159,
	44084 - 44032: 0x815A,
	44085 - 44032: 0x8161,
	44086 - 44032: 0x8162,
	44087 - 44032: 0x8163,
	44088 - 44032: 0xB0BC,
	44089 - 44032: 0xB0BD,
	44090 - 44032: 0x8164,
	44091 - 44032: 0x8165,
	44092 - 44032: 0xB0BE,
	44093 - 44032: 0x8166,
	44094 - 44032: 0x8167,
	44095 - 44032: 0x8168,
	44096 - 44032: 0xB0BF,
	44097 - 44032: 0x8169,
	44098 - 44032: 0x816A,
	44099 - 44032: 0x816B,
	44100 - 44032: 0x816C,
	44101 - 44032: 0x816D,
	44102 - 44032: 0x816E,
	44103 - 44032: 0x816F,
	44104 - 44032: 0x8170,
	44105 - 44032: 0x8171,
	44106 - 44032: 0x8172,
	44107 - 44032: 0xB0C0,
	44108 - 44032: 0x8173,
	44109 - 44032: 0xB0C1,
	44110 - 44032: 0x8174,
	44111 - 44032: 0x8175,
	44112 - 44032: 0x8176,
	44113 - 44032: 0x8177,
	44114 - 44032: 0x8178,
	44115 - 44032: 0x8179,
	44116 - 44032: 0xB0C2,
	44117 - 44032: 0x817A,
	44118 - 44032: 0x8181,
	44119 - 44032: 0x8182,
	44120 - 44032: 0xB0C3,
	44121 - 44032: 0x8183,
	44122 - 44032: 0x8184,
	44123 - 44032: 0x8185,
	44124 - 44032: 0xB0C4,
	44125 - 44032: 0x8186,
	44126 - 44032: 0x8187,
	44127 - 44032: 0x8188,
	44128 - 44032: 0x8189,
	44129 - 44032: 0x818A,
	44130 - 44032: 0x818B,
	44131 - 44032: 0x818C,
	44132 - 44032: 0x818D,
	44133 - 44032: 0x818E,
	44134 - 44032: 0x818F,
	44135 - 44032: 0x8190,
	44136 - 44032: 0x8191,
	44137 - 44032: 0x8192,
	44138 - 44032: 0x8193,
	44139 - 44032: 0x8194,
	44140 - 44032: 0x8195,
	44141 - 44032: 0x8196,
	44142 - 44032: 0x8197,
	44143 - 44032: 0x8198,
	44144 - 44032: 0xB0C5,
	44145 - 44032: 0xB0C6,
	44146 - 44032: 0x8199,
	44147 - 44032: 0x819A,
	44148 - 44032: 0xB0C7,
	44149 - 44032: 0x819B,
	44150 - 44032: 0x819C,
	44151 - 44032: 0xB0C8,
	44152 - 44032: 0xB0C9,
	44153 - 44032: 0x819D,
	44154 - 44032: 0xB0CA,
	44155 - 44032: 0x819E,
	44156 - 44032: 0x819F,
	44157 - 44032: 0x81A0,
	44158 - 44032: 0x81A1,
	44159 - 44032: 0x81A2,
	44160 - 44032: 0xB0CB,
	44161 - 44032: 0xB0CC,
	44162 - 44032: 0x81A3,
	44163 - 44032: 0xB0CD,
	44164 - 44032: 0xB0CE,
	44165 - 44032: 0xB0CF,
	44166 - 44032: 0xB0D0,
	44167 - 44032: 0x81A4,
	44168 - 44032: 0x81A5,
	44169 - 44032: 0xB0D1,
	44170 - 44032: 0xB0D2,
	44171 - 44032: 0xB0D3,
	44172 - 44032: 0xB0D4,
	44173 - 44032: 0x81A6,
	44174 - 44032: 0x81A7,
	44175 - 44032: 0x81A8,
	44176 - 44032: 0xB0D5,
	44177 - 44032: 0x81A9,
	44178 - 44032: 0x81AA,
	44179 - 44032: 0x81AB,
	44180 - 44032: 0xB0D6,
	44181 - 44032: 0x81AC,
	44182 - 44032: 0x81AD,
	44183 - 44032: 0x81AE,
	44184 - 44032: 0x81AF,
	44185 - 44032: 0x81B0,
	44186 - 44032: 0x81B1,
	44187 - 44032: 0x81B2,
	44188 - 44032: 0xB0D7,
	44189 - 44032: 0xB0D8,
	44190 - 44032: 0x81B3,
	44191 - 44032: 0xB0D9,
	44192 - 44032: 0xB0DA,
	44193 - 44032: 0xB0DB,
	44194 - 44032: 0x81B4,
	44195 - 44032: 0x81B5,
	44196 - 44032: 0x81B6,
	44197 - 44032: 0x81B7,
	44198 - 44032: 0x81B8,
	44199 - 44032: 0x81B9,
	44200 - 44032: 0xB0DC,
	44201 - 44032: 0xB0DD,
	44202 - 44032: 0xB0DE,
	44203 - 44032: 0x81BA,
	44204 - 44032: 0xB0DF,
	44205 - 44032: 0x81BB,
	44206 - 44032: 0x81BC,
	44207 - 44032: 0xB0E0,
	44208 - 44032: 0xB0E1,
	44209 - 44032: 0x81BD,
	44210 - 44032: 0x81BE,
	44211 - 44032: 0x81BF,
	44212 - 44032: 0x81C0,
	44213 - 44032: 0x81C1,
	44214 - 44032: 0x81C2,
	44215 - 44032: 0x81C3,
	44216 - 44032: 0xB0E2,
	44217 - 44032: 0xB0E3,
	44218 - 44032: 0x81C4,
	44219 - 44032: 0xB0E4,
	44220 - 44032: 0xB0E5,
	44221 - 44032: 0xB0E6,
	44222 - 44032: 0x81C5,
	44223 - 44032: 0x81C6,
	44224 - 44032: 0x81C7,
	44225 - 44032: 0xB0E7,
	44226 - 44032: 0x81C8,
	44227 - 44032: 0x81C9,
	44228 - 44032: 0xB0E8,
	44229 - 44032: 0x81CA,
	44230 - 44032: 0x81CB,
	44231 - 44032: 0x81CC,
	44232 - 44032: 0xB0E9,
	44233 - 44032: 0x81CD,
	44234 - 44032: 0x81CE,
	44235 - 44032: 0x81CF,
	44236 - 44032: 0xB0EA,
	44237 - 44032: 0x81D0,
	44238 - 44032: 0x81D1,
	44239 - 44032: 0x81D2,
	44240 - 44032: 0x81D3,
	44241 - 44032: 0x81D4,
	44242 - 44032: 0x81D5,
	44243 - 44032: 0x81D6,
	44244 - 44032: 0x81D7,
	44245 - 44032: 0xB0EB,
	44246 - 44032: 0x81D8,
	44247 - 44032: 0xB0EC,
	44248 - 44032: 0x81D9,
	44249 - 44032: 0x81DA,
	44250 - 44032: 0x81DB,
	44251 - 44032: 0x81DC,
	44252 - 44032: 0x81DD,
	44253 - 44032: 0x81DE,
	44254 - 44032: 0x81DF,
	44255 - 44032: 0x81E0,
	44256 - 44032: 0xB0ED,
	44257 - 44032: 0xB0EE,
	44258 - 44032: 0x81E1,
	44259 - 44032: 0x81E2,
	44260 - 44032: 0xB0EF,
	44261 - 44032: 0x81E3,
	44262 - 44032: 0x81E4,
	44263 - 44032: 0xB0F0,
	44264 - 44032: 0xB0F1,
	44265 - 44032: 0x81E5,
	44266 - 44032: 0xB0F2,
	44267 - 44032: 0x81E6,
	44268 - 44032: 0xB0F3,
	44269 - 44032: 0x81E7,
	44270 - 44032: 0x81E8,
	44271 - 44032: 0xB0F4,
	44272 - 44032: 0xB0F5,
	44273 - 44032: 0xB0F6,
	44274 - 44032: 0x81E9,
	44275 - 44032: 0xB0F7,
	44276 - 44032: 0x81EA,
	44277 - 44032: 0xB0F8,
	44278 - 44032: 0xB0F9,
	44279 - 44032: 0x81EB,
	44280 - 44032: 0x81EC,
	44281 - 44032: 0x81ED,
	44282 - 44032: 0x81EE,
	44283 - 44032: 0x81EF,
	44284 - 44032: 0xB0FA,
	44285 - 44032: 0xB0FB,
	44286 - 44032: 0x81F0,
	44287 - 44032: 0x81F1,
	44288 - 44032: 0xB0FC,
	44289 - 44032: 0x81F2,
	44290 - 44032: 0x81F3,
	44291 - 44032: 0x81F4,
	44292 - 44032: 0xB0FD,
	44293 - 44032: 0x81F5,
	44294 - 44032: 0xB0FE,
	44295 - 44032: 0x81F6,
	44296 - 44032: 0x81F7,
	44297 - 44032: 0x81F8,
	44298 - 44032: 0x81F9,
	44299 - 44032: 0x81FA,
	44300 - 44032: 0xB1A1,
	44301 - 44032: 0xB1A2,
	44302 - 44032: 0x81FB,
	44303 - 44032: 0xB1A3,
	44304 - 44032: 0x81FC,
	44305 - 44032: 0xB1A4,
	44306 - 44032: 0x81FD,
	44307 - 44032: 0x81FE,
	44308 - 44032: 0x8241,
	44309 - 44032: 0x8242,
	44310 - 44032: 0x8243,
	44311 - 44032: 0x8244,
	44312 - 44032: 0xB1A5,
	44313 - 44032: 0x8245,
	44314 - 44032: 0x8246,
	44315 - 44032: 0x8247,
	44316 - 44032: 0xB1A6,
	44317 - 44032: 0x8248,
	44318 - 44032: 0x8249,
	44319 - 44032: 0x824A,
	44320 - 44032: 0xB1A7,
	44321 - 44032: 0x824B,
	44322 - 44032: 0x824C,
	44323 - 44032: 0x824D,
	44324 - 44032: 0x824E,
	44325 - 44032: 0x824F,
	44326 - 44032: 0x8250,
	44327 - 44032: 0x8251,
	44328 - 44032: 0x8252,
	44329 - 44032: 0xB1A8,
	44330 - 44032: 0x8253,
	44331 - 44032: 0x8254,
	44332 - 44032: 0xB1A9,
	44333 - 44032: 0xB1AA,
	44334 - 44032: 0x8255,
	44335 - 44032: 0x8256,
	44336 - 44032: 0x8257,
	44337 - 44032: 0x8258,
	44338 - 44032: 0x8259,
	44339 - 44032: 0x825A,
	44340 - 44032: 0xB1AB,
	44341 - 44032: 0xB1AC,
	44342 - 44032: 0x8261,
	44343 - 44032: 0x8262,
	44344 - 44032: 0xB1AD,
	44345 - 44032: 0x8263,
	44346 - 44032: 0x8264,
	44347 - 44032: 0x8265,
	44348 - 44032: 0xB1AE,
	44349 - 44032: 0x8266,
	44350 - 44032: 0x8267,
	44351 - 44032: 0x8268,
	44352 - 44032: 0x8269,
	44353 - 44032: 0x826A,
	44354 - 44032: 0x826B,
	44355 - 44032: 0x826C,
	44356 - 44032: 0xB1AF,
	44357 - 44032: 0xB1B0,
	44358 - 44032: 0x826D,
	44359 - 44032: 0xB1B1,
	44360 - 44032: 0x826E,
	44361 - 44032: 0xB1B2,
	44362 - 44032: 0x826F,
	44363 - 44032: 0x8270,
	44364 - 44032: 0x8271,
	44365 - 44032: 0x8272,
	44366 - 44032: 0x8273,
	44367 - 44032: 0x8274,
	44368 - 44032: 0xB1B3,
	44369 - 44032: 0x8275,
	44370 - 44032: 0x8276,
	44371 - 44032: 0x8277,
	44372 - 44032: 0xB1B4,
	44373 - 44032: 0x8278,
	44374 - 44032: 0x8279,
	44375 - 44032: 0x827A,
	44376 - 44032: 0xB1B5,
	44377 - 44032: 0x8281,
	44378 - 44032: 0x8282,
	44379 - 44032: 0x8283,
	44380 - 44032: 0x8284,
	44381 - 44032: 0x8285,
	44382 - 44032: 0x8286,
	44383 - 44032: 0x8287,
	44384 - 44032: 0x8288,
	44385 - 44032: 0xB1B6,
	44386 - 44032: 0x8289,
	44387 - 44032: 0xB1B7,
	44388 - 44032: 0x828A,
	44389 - 44032: 0x828B,
	44390 - 44032: 0x828C,
	44391 - 44032: 0x828D,
	44392 - 44032: 0x828E,
	44393 - 44032: 0x828F,
	44394 - 44032: 0x8290,
	44395 - 44032: 0x8291,
	44396 - 44032: 0xB1B8,
	44397 - 44032: 0xB1B9,
	44398 - 44032: 0x8292,
	44399 - 44032: 0x8293,
	44400 - 44032: 0xB1BA,
	44401 - 44032: 0x8294,
	44402 - 44032: 0x8295,
	44403 - 44032: 0xB1BB,
	44404 - 44032: 0xB1BC,
	44405 - 44032: 0xB1BD,
	44406 - 44032: 0xB1BE,
	44407 - 44032: 0x8296,
	44408 - 44032: 0x8297,
	44409 - 44032: 0x8298,
	44410 - 44032: 0x8299,
	44411 - 44032: 0xB1BF,
	44412 - 44032: 0xB1C0,
	44413 - 44032: 0xB1C1,
	44414 - 44032: 0x829A,
	44415 - 44032: 0xB1C2,
	44416 - 44032: 0x829B,
	44417 - 44032: 0xB1C3,
	44418 - 44032: 0xB1C4,
	44419 - 44032: 0x829C,
	44420 - 44032: 0x829D,
	44421 - 44032: 0x829E,
	44422 - 44032: 0x829F,
	44423 - 44032: 0x82A0,
	44424 - 44032: 0xB1C5,
	44425 - 44032: 0xB1C6,
	44426 - 44032: 0x82A1,
	44427 - 44032: 0x82A2,
	44428 - 44032: 0xB1C7,
	44429 - 44032: 0x82A3,
	44430 - 44032: 0x82A4,
	44431 - 44032: 0x82A5,
	44432 - 44032: 0xB1C8,
	44433 - 44032: 0x82A6,
	44434 - 44032: 0x82A7,
	44435 - 44032: 0x82A8,
	44436 - 44032: 0x82A9,
	44437 - 44032: 0x82AA,
	44438 - 44032: 0x82AB,
	44439 - 44032: 0x82AC,
	44440 - 44032: 0x82AD,
	44441 - 44032: 0x82AE,
	44442 - 44032: 0x82AF,
	44443 - 44032: 0x82B0,
	44444 - 44032: 0xB1C9,
	44445 - 44032: 0xB1CA,
	44446 - 44032: 0x82B1,
	44447 - 44032: 0x82B2,
	44448 - 44032: 0x82B3,
	44449 - 44032: 0x82B4,
	44450 - 44032: 0x82B5,
	44451 - 44032: 0x82B6,
	44452 - 44032: 0xB1CB,
	44453 - 44032: 0x82B7,
	44454 - 44032: 0x82B8,
	44455 - 44032: 0x82B9,
	44456 - 44032: 0x82BA,
	44457 - 44032: 0x82BB,
	44458 - 44032: 0x82BC,
	44459 - 44032: 0x82BD,
	44460 - 44032: 0x82BE,
	44461 - 44032: 0x82BF,
	44462 - 44032: 0x82C0,
	44463 - 44032: 0x82C1,
	44464 - 44032: 0x82C2,
	44465 - 44032: 0x82C3,
	44466 - 44032: 0x82C4,
	44467 - 44032: 0x82C5,
	44468 - 44032: 0x82C6,
	44469 - 44032: 0x82C7,
	44470 - 44032: 0x82C8,
	44471 - 44032: 0xB1CC,
	44472 - 44032: 0x82C9,
	44473 - 44032: 0x82CA,
	44474 - 44032: 0x82CB,
	44475 - 44032: 0x82CC,
	44476 - 44032: 0x82CD,
	44477 - 44032: 0x82CE,
	44478 - 44032: 0x82CF,
	44479 - 44032: 0x82D0,
	44480 - 44032: 0xB1CD,
	44481 - 44032: 0xB1CE,
	44482 - 44032: 0x82D1,
	44483 - 44032: 0x82D2,
	44484 - 44032: 0xB1CF,
	44485 - 44032: 0x82D3,
	44486 - 44032: 0x82D4,
	44487 - 44032: 0x82D5,
	44488 - 44032: 0xB1D0,
	44489 - 44032: 0x82D6,
	44490 - 44032: 0x82D7,
	44491 - 44032: 0x82D8,
	44492 - 44032: 0x82D9,
	44493 - 44032: 0x82DA,
	44494 - 44032: 0x82DB,
	44495 - 44032: 0x82DC,
	44496 - 44032: 0xB1D1,
	44497 - 44032: 0xB1D2,
	44498 - 44032: 0x82DD,
	44499 - 44032: 0xB1D3,
	44500 - 44032: 0x82DE,
	44501 - 44032: 0x82DF,
	44502 - 44032: 0x82E0,
	44503 - 44032: 0x82E1,
	44504 - 44032: 0x82E2,
	44505 - 44032: 0x82E3,
	44506 - 44032: 0x82E4,
	44507 - 44032: 0x82E5,
	44508 - 44032: 0xB1D4,
	44509 - 44032: 0x82E6,
	44510 - 44032: 0x82E7,
	44511 - 44032: 0x82E8,
	44512 - 44032: 0xB1D5,
	44513 - 44032: 0x82E9,
	44514 - 44032: 0x82EA,
	44515 - 44032: 0x82EB,
	44516 - 44032: 0xB1D6,
	44517 - 44032: 0x82EC,
	44518 - 44032: 0x82ED,
	44519 - 44032: 0x82EE,
	44520 - 44032: 0x82EF,
	44521 - 44032: 0x82F0,
	44522 - 44032: 0x82F1,
	44523 - 44032: 0x82F2,
	44524 - 44032: 0x82F3,
	44525 - 44032: 0x82F4,
	44526 - 44032: 0x82F5,
	44527 - 44032: 0x82F6,
	44528 - 44032: 0x82F7,
	44529 - 44032: 0x82F8,
	44530 - 44032: 0x82F9,
	44531 - 44032: 0x82FA,
	44532 - 44032: 0x82FB,
	44533 - 44032: 0x82FC,
	44534 - 44032: 0x82FD,
	44535 - 44032: 0x82FE,
	44536 - 44032: 0xB1D7,
	44537 - 44032: 0xB1D8,
	44538 - 44032: 0x8341,
	44539 - 44032: 0x8342,
	44540 - 44032: 0xB1D9,
	44541 - 44032: 0x8343,
	44542 - 44032: 0x8344,
	44543 - 44032: 0xB1DA,
	44544 - 44032: 0xB1DB,
	44545 - 44032: 0xB1DC,
	44546 - 44032: 0x8345,
	44547 - 44032: 0x8346,
	44548 - 44032: 0x8347,
	44549 - 44032: 0x8348,
	44550 - 44032: 0x8349,
	44551 - 44032: 0x834A,
	44552 - 44032: 0xB1DD,
	44553 - 44032: 0xB1DE,
	44554 - 44032: 0x834B,
	44555 - 44032: 0xB1DF,
	44556 - 44032: 0x834C,
	44557 - 44032: 0xB1E0,
	44558 - 44032: 0x834D,
	44559 - 44032: 0x834E,
	44560 - 44032: 0x834F,
	44561 - 44032: 0x8350,
	44562 - 44032: 0x8351,
	44563 - 44032: 0x8352,
	44564 - 44032: 0xB1E1,
	44565 - 44032: 0x8353,
	44566 - 44032: 0x8354,
	44567 - 44032: 0x8355,
	44568 - 44032: 0x8356,
	44569 - 44032: 0x8357,
	44570 - 44032: 0x8358,
	44571 - 44032: 0x8359,
	44572 - 44032: 0x835A,
	44573 - 44032: 0x8361,
	44574 - 44032: 0x8362,
	44575 - 44032: 0x8363,
	44576 - 44032: 0x8364,
	44577 - 44032: 0x8365,
	44578 - 44032: 0x8366,
	44579 - 44032: 0x8367,
	44580 - 44032: 0x8368,
	44581 - 44032: 0x8369,
	44582 - 44032: 0x836A,
	44583 - 44032: 0x836B,
	44584 - 44032: 0x836C,
	44585 - 44032: 0x836D,
	44586 - 44032: 0x836E,
	44587 - 44032: 0x836F,
	44588 - 44032: 0x8370,
	44589 - 44032: 0x8371,
	44590 - 44032: 0x8372,
	44591 - 44032: 0x8373,
	44592 - 44032: 0xB1E2,
	44593 - 44032: 0xB1E3,
	44594 - 44032: 0x8374,
	44595 - 44032: 0x8375,
	44596 - 44032: 0xB1E4,
	44597 - 44032: 0x8376,
	44598 - 44032: 0x8377,
	44599 - 44032: 0xB1E5,
	44600 - 44032: 0xB1E6,
	44601 - 44032: 0x8378,
	44602 - 44032: 0xB1E7,
	44603 - 44032: 0x8379,
	44604 - 44032: 0x837A,
	44605 - 44032: 0x8381,
	44606 - 44032: 0x8382,
	44607 - 44032: 0x8383,
	44608 - 44032: 0xB1E8,
	44609 - 44032: 0xB1E9,
	44610 - 44032: 0x8384,
	44611 - 44032: 0xB1EA,
	44612 - 44032: 0x8385,
	44613 - 44032: 0xB1EB,
	44614 - 44032: 0xB1EC,
	44615 - 44032: 0x8386,
	44616 - 44032: 0x8387,
	44617 - 44032: 0x8388,
	44618 - 44032: 0xB1ED,
	44619 - 44032: 0x8389,
	44620 - 44032: 0xB1EE,
	44621 - 44032: 0xB1EF,
	44622 - 44032: 0xB1F0,
	44623 - 44032: 0x838A,
	44624 - 44032: 0xB1F1,
	44625 - 44032: 0x838B,
	44626 - 44032: 0x838C,
	44627 - 44032: 0x838D,
	44628 - 44032: 0xB1F2,
	44629 - 44032: 0x838E,
	44630 - 44032: 0xB1F3,
	44631 - 44032: 0x838F,
	44632 - 44032: 0x8390,
	44633 - 44032: 0x8391,
	44634 - 44032: 0x8392,
	44635 - 44032: 0x8393,
	44636 - 44032: 0xB1F4,
	44637 - 44032: 0xB1F5,
	44638 - 44032: 0x8394,
	44639 - 44032: 0xB1F6,
	44640 - 44032: 0xB1F7,
	44641 - 44032: 0xB1F8,
	44642 - 44032: 0x8395,
	44643 - 44032: 0x8396,
	44644 - 44032: 0x8397,
	44645 - 44032: 0xB1F9,
	44646 - 44032: 0x8398,
	44647 - 44032: 0x8399,
	44648 - 44032: 0xB1FA,
	44649 - 44032: 0xB1FB,
	44650 - 44032: 0x839A,
	44651 - 44032: 0x839B,
	44652 - 44032: 0xB1FC,
	44653 - 44032: 0x839C,
	44654 - 44032: 0x839D,
	44655 - 44032: 0x839E,
	44656 - 44032: 0xB1FD,
	44657 - 44032: 0x839F,
	44658 - 44032: 0x83A0,
	44659 - 44032: 0x83A1,
	44660 - 44032: 0x83A2,
	44661 - 44032: 0x83A3,
	44662 - 44032: 0x83A4,
	44663 - 44032: 0x83A5,
	44664 - 44032: 0xB1FE,
	44665 - 44032: 0xB2A1,
	44666 - 44032: 0x83A6,
	44667 - 44032: 0xB2A2,
	44668 - 44032: 0xB2A3,
	44669 - 44032: 0xB2A4,
	44670 - 44032: 0x83A7,
	44671 - 44032: 0x83A8,
	44672 - 44032: 0x83A9,
	44673 - 44032: 0x83AA,
	44674 - 44032: 0x83AB,
	44675 - 44032: 0x83AC,
	44676 - 44032: 0xB2A5,
	44677 - 44032: 0xB2A6,
	44678 - 44032: 0x83AD,
	44679 - 44032: 0x83AE,
	44680 - 44032: 0x83AF,
	44681 - 44032: 0x83B0,
	44682 - 44032: 0x83B1,
	44683 - 44032: 0x83B2,
	44684 - 44032: 0xB2A7,
	44685 - 44032: 0x83B3,
	44686 - 44032: 0x83B4,
	44687 - 44032: 0x83B5,
	44688 - 44032: 0x83B6,
	44689 - 44032: 0x83B7,
	44690 - 44032: 0x83B8,
	44691 - 44032: 0x83B9,
	44692 - 44032: 0x83BA,
	44693 - 44032: 0x83BB,
	44694 - 44032: 0x83BC,
	44695 - 44032: 0x83BD,
	44696 - 44032: 0x83BE,
	44697 - 44032: 0x83BF,
	44698 - 44032: 0x83C0,
	44699 - 44032: 0x83C1,
	44700 - 44032: 0x83C2,
	44701 - 44032: 0x83C3,
	44702 - 44032: 0x83C4,
	44703 - 44032: 0x83C5,
	44704 - 44032: 0x83C6,
	44705 - 44032: 0x83C7,
	44706 - 44032: 0x83C8,
	44707 - 44032: 0x83C9,
	44708 - 44032: 0x83CA,
	44709 - 44032: 0x83CB,
	44710 - 44032: 0x83CC,
	44711 - 44032: 0x83CD,
	44712 - 44032: 0x83CE,
	44713 - 44032: 0x83CF,
	44714 - 44032: 0x83D0,
	44715 - 44032: 0x83D1,
	44716 - 44032: 0x83D2,
	44717 - 44032: 0x83D3,
	44718 - 44032: 0x83D4,
	44719 - 44032: 0x83D5,
	44720 - 44032: 0x83D6,
	44721 - 44032: 0x83D7,
	44722 - 44032: 0x83D8,
	44723 - 44032: 0x83D9,
	44724 - 44032: 0x83DA,
	44725 - 44032: 0x83DB,
	44726 - 44032: 0x83DC,
	44727 - 44032: 0x83DD,
	44728 - 44032: 0x83DE,
	44729 - 44032: 0x83DF,
	44730 - 44032: 0x83E0,
	44731 - 44032: 0x83E1,
	44732 - 44032: 0xB2A8,
	44733 - 44032: 0xB2A9,
	44734 - 44032: 0xB2AA,
	44735 - 44032: 0x83E2,
	44736 - 44032: 0xB2AB,
	44737 - 44032: 0x83E3,
	44738 - 44032: 0x83E4,
	44739 - 44032: 0x83E5,
	44740 - 44032: 0xB2AC,
	44741 - 44032: 0x83E6,
	44742 - 44032: 0x83E7,
	44743 - 44032: 0x83E8,
	44744 - 44032: 0x83E9,
	44745 - 44032: 0x83EA,
	44746 - 44032: 0x83EB,
	44747 - 44032: 0x83EC,
	44748 - 44032: 0xB2AD,
	44749 - 44032: 0xB2AE,
	44750 - 44032: 0x83ED,
	44751 - 44032: 0xB2AF,
	44752 - 44032: 0xB2B0,
	44753 - 44032: 0xB2B1,
	44754 - 44032: 0x83EE,
	44755 - 44032: 0x83EF,
	44756 - 44032: 0x83F0,
	44757 - 44032: 0x83F1,
	44758 - 44032: 0x83F2,
	44759 - 44032: 0x83F3,
	44760 - 44032: 0xB2B2,
	44761 - 44032: 0xB2B3,
	44762 - 44032: 0x83F4,
	44763 - 44032: 0x83F5,
	44764 - 44032: 0xB2B4,
	44765 - 44032: 0x83F6,
	44766 - 44032: 0x83F7,
	44767 - 44032: 0x83F8,
	44768 - 44032: 0x83F9,
	44769 - 44032: 0x83FA,
	44770 - 44032: 0x83FB,
	44771 - 44032: 0x83FC,
	44772 - 44032: 0x83FD,
	44773 - 44032: 0x83FE,
	44774 - 44032: 0x8441,
	44775 - 44032: 0x8442,
	44776 - 44032: 0xB2B5,
	44777 - 44032: 0x8443,
	44778 - 44032: 0x8444,
	44779 - 44032: 0xB2B6,
	44780 - 44032: 0x8445,
	44781 - 44032: 0xB2B7,
	44782 - 44032: 0x8446,
	44783 - 44032: 0x8447,
	44784 - 44032: 0x8448,
	44785 - 44032: 0x8449,
	44786 - 44032: 0x844A,
	44787 - 44032: 0x844B,
	44788 - 44032: 0xB2B8,
	44789 - 44032: 0x844C,
	44790 - 44032: 0x844D,
	44791 - 44032: 0x844E,
	44792 - 44032: 0xB2B9,
	44793 - 44032: 0x844F,
	44794 - 44032: 0x8450,
	44795 - 44032: 0x8451,
	44796 - 44032: 0xB2BA,
	44797 - 44032: 0x8452,
	44798 - 44032: 0x8453,
	44799 - 44032: 0x8454,
	44800 - 44032: 0x8455,
	44801 - 44032: 0x8456,
	44802 - 44032: 0x8457,
	44803 - 44032: 0x8458,
	44804 - 44032: 0x8459,
	44805 - 44032: 0x845A,
	44806 - 44032: 0x8461,
	44807 - 44032: 0xB2BB,
	44808 - 44032: 0xB2BC,
	44809 - 44032: 0x8462,
	44810 - 44032: 0x8463,
	44811 - 44032: 0x8464,
	44812 - 44032: 0x8465,
	44813 - 44032: 0xB2BD,
	44814 - 44032: 0x8466,
	44815 - 44032: 0x8467,
	44816 - 44032: 0xB2BE,
	44817 - 44032: 0x8468,
	44818 - 44032: 0x8469,
	44819 - 44032: 0x846A,
	44820 - 44032: 0x846B,
	44821 - 44032: 0x846C,
	44822 - 44032: 0x846D,
	44823 - 44032: 0x846E,
	44824 - 44032: 0x846F,
	44825 - 44032: 0x8470,
	44826 - 44032: 0x8471,
	44827 - 44032: 0x8472,
	44828 - 44032: 0x8473,
	44829 - 44032: 0x8474,
	44830 - 44032: 0x8475,
	44831 - 44032: 0x8476,
	44832 - 44032: 0x8477,
	44833 - 44032: 0x8478,
	44834 - 44032: 0x8479,
	44835 - 44032: 0x847A,
	44836 - 44032: 0x8481,
	44837 - 44032: 0x8482,
	44838 - 44032: 0x8483,
	44839 - 44032: 0x8484,
	44840 - 44032: 0x8485,
	44841 - 44032: 0x8486,
	44842 - 44032: 0x8487,
	44843 - 44032: 0x8488,
	44844 - 44032: 0xB2BF,
	44845 - 44032: 0xB2C0,
	44846 - 44032: 0x8489,
	44847 - 44032: 0x848A,
	44848 - 44032: 0xB2C1,
	44849 - 44032: 0x848B,
	44850 - 44032: 0xB2C2,
	44851 - 44032: 0x848C,
	44852 - 44032: 0xB2C3,
	44853 - 44032: 0x848D,
	44854 - 44032: 0x848E,
	44855 - 44032: 0x848F,
	44856 - 44032: 0x8490,
	44857 - 44032: 0x8491,
	44858 - 44032: 0x8492,
	44859 - 44032: 0x8493,
	44860 - 44032: 0xB2C4,
	44861 - 44032: 0xB2C5,
	44862 - 44032: 0x8494,
	44863 - 44032: 0xB2C6,
	44864 - 44032: 0x8495,
	44865 - 44032: 0xB2C7,
	44866 - 44032: 0xB2C8,
	44867 - 44032: 0xB2C9,
	44868 - 44032: 0x8496,
	44869 - 44032: 0x8497,
	44870 - 44032: 0x8498,
	44871 - 44032: 0x8499,
	44872 - 44032: 0xB2CA,
	44873 - 44032: 0xB2CB,
	44874 - 44032: 0x849A,
	44875 - 44032: 0x849B,
	44876 - 44032: 0x849C,
	44877 - 44032: 0x849D,
	44878 - 44032: 0x849E,
	44879 - 44032: 0x849F,
	44880 - 44032: 0xB2CC,
	44881 - 44032: 0x84A0,
	44882 - 44032: 0x84A1,
	44883 - 44032: 0x84A2,
	44884 - 44032: 0x84A3,
	44885 - 44032: 0x84A4,
	44886 - 44032: 0x84A5,
	44887 - 44032: 0x84A6,
	44888 - 44032: 0x84A7,
	44889 - 44032: 0x84A8,
	44890 - 44032: 0x84A9,
	44891 - 44032: 0x84AA,
	44892 - 44032: 0xB2CD,
	44893 - 44032: 0xB2CE,
	44894 - 44032: 0x84AB,
	44895 - 44032: 0x84AC,
	44896 - 44032: 0x84AD,
	44897 - 44032: 0x84AE,
	44898 - 44032: 0x84AF,
	44899 - 44032: 0x84B0,
	44900 - 44032: 0xB2CF,
	44901 - 44032: 0xB2D0,
	44902 - 44032: 0x84B1,
	44903 - 44032: 0x84B2,
	44904 - 44032: 0x84B3,
	44905 - 44032: 0x84B4,
	44906 - 44032: 0x84B5,
	44907 - 44032: 0x84B6,
	44908 - 44032: 0x84B7,
	44909 - 44032: 0x84B8,
	44910 - 44032: 0x84B9,
	44911 - 44032: 0x84BA,
	44912 - 44032: 0x84BB,
	44913 - 44032: 0x84BC,
	44914 - 44032: 0x84BD,
	44915 - 44032: 0x84BE,
	44916 - 44032: 0x84BF,
	44917 - 44032: 0x84C0,
	44918 - 44032: 0x84C1,
	44919 - 44032: 0x84C2,
	44920 - 44032: 0x84C3,
	44921 - 44032: 0xB2D1,
	44922 - 44032: 0x84C4,
	44923 - 44032: 0x84C5,
	44924 - 44032: 0x84C6,
	44925 - 44032: 0x84C7,
	44926 - 44032: 0x84C8,
	44927 - 44032: 0x84C9,
	44928 - 44032: 0xB2D2,
	44929 - 44032: 0x84CA,
	44930 - 44032: 0x84CB,
	44931 - 44032: 0x84CC,
	44932 - 44032: 0xB2D3,
	44933 - 44032: 0x84CD,
	44934 - 44032: 0x84CE,
	44935 - 44032: 0x84CF,
	44936 - 44032: 0xB2D4,
	44937 - 44032: 0x84D0,
	44938 - 44032: 0x84D1,
	44939 - 44032: 0x84D2,
	44940 - 44032: 0x84D3,
	44941 - 44032: 0x84D4,
	44942 - 44032: 0x84D5,
	44943 - 44032: 0x84D6,
	44944 - 44032: 0xB2D5,
	44945 - 44032: 0xB2D6,
	44946 - 44032: 0x84D7,
	44947 - 44032: 0x84D8,
	44948 - 44032: 0x84D9,
	44949 - 44032: 0xB2D7,
	44950 - 44032: 0x84DA,
	44951 - 44032: 0x84DB,
	44952 - 44032: 0x84DC,
	44953 - 44032: 0x84DD,
	44954 - 44032: 0x84DE,
	44955 - 44032: 0x84DF,
	44956 - 44032: 0xB2D8,
	44957 - 44032: 0x84E0,
	44958 - 44032: 0x84E1,
	44959 - 44032: 0x84E2,
	44960 - 44032: 0x84E3,
	44961 - 44032: 0x84E4,
	44962 - 44032: 0x84E5,
	44963 - 44032: 0x84E6,
	44964 - 44032: 0x84E7,
	44965 - 44032: 0x84E8,
	44966 - 44032: 0x84E9,
	44967 - 44032: 0x84EA,
	44968 - 44032: 0x84EB,
	44969 - 44032: 0x84EC,
	44970 - 44032: 0x84ED,
	44971 - 44032: 0x84EE,
	44972 - 44032: 0x84EF,
	44973 - 44032: 0x84F0,
	44974 - 44032: 0x84F1,
	44975 - 44032: 0x84F2,
	44976 - 44032: 0x84F3,
	44977 - 44032: 0x84F4,
	44978 - 44032: 0x84F5,
	44979 - 44032: 0x84F6,
	44980 - 44032: 0x84F7,
	44981 - 44032: 0x84F8,
	44982 - 44032: 0x84F9,
	44983 - 44032: 0x84FA,
	44984 - 44032: 0xB2D9,
	44985 - 44032: 0xB2DA,
	44986 - 44032: 0x84FB,
	44987 - 44032: 0x84FC,
	44988 - 44032: 0xB2DB,
	44989 - 44032: 0x84FD,
	44990 - 44032: 0x84FE,
	44991 - 44032: 0x8541,
	44992 - 44032: 0xB2DC,
	44993 - 44032: 0x8542,
	44994 - 44032: 0x8543,
	44995 - 44032: 0x8544,
	44996 - 44032: 0x8545,
	44997 - 44032: 0x8546,
	44998 - 44032: 0x8547,
	44999 - 44032: 0xB2DD,
	45000 - 44032: 0xB2DE,
	45001 - 44032: 0xB2DF,
	45002 - 44032: 0x8548,
	45003 - 44032: 0xB2E0,
	45004 - 44032: 0x8549,
	45005 - 44032: 0xB2E1,
	45006 - 44032: 0xB2E2,
	45007 - 44032: 0x854A,
	45008 - 44032: 0x854B,
	45009 - 44032: 0x854C,
	45010 - 44032: 0x854D,
	45011 - 44032: 0x854E,
	45012 - 44032: 0xB2E3,
	45013 - 44032: 0x854F,
	45014 - 44032: 0x8550,
	45015 - 44032: 0x8551,
	45016 - 44032: 0x8552,
	45017 - 44032: 0x8553,
	45018 - 44032: 0x8554,
	45019 - 44032: 0x8555,
	45020 - 44032: 0xB2E4,
	45021 - 44032: 0x8556,
	45022 - 44032: 0x8557,
	45023 - 44032: 0x8558,
	45024 - 44032: 0x8559,
	45025 - 44032: 0x855A,
	45026 - 44032: 0x8561,
	45027 - 44032: 0x8562,
	45028 - 44032: 0x8563,
	45029 - 44032: 0x8564,
	45030 - 44032: 0x8565,
	45031 - 44032: 0x8566,
	45032 - 44032: 0xB2E5,
	45033 - 44032: 0xB2E6,
	45034 - 44032: 0x8567,
	45035 - 44032: 0x8568,
	45036 - 44032: 0x8569,
	45037 - 44032: 0x856A,
	45038 - 44032: 0x856B,
	45039 - 44032: 0x856C,
	45040 - 44032: 0xB2E7,
	45041 - 44032: 0xB2E8,
	45042 - 44032: 0x856D,
	45043 - 44032: 0x856E,
	45044 - 44032: 0xB2E9,
	45045 - 44032: 0x856F,
	45046 - 44032: 0x8570,
	45047 - 44032: 0x8571,
	45048 - 44032: 0xB2EA,
	45049 - 44032: 0x8572,
	45050 - 44032: 0x8573,
	45051 - 44032: 0x8574,
	45052 - 44032: 0x8575,
	45053 - 44032: 0x8576,
	45054 - 44032: 0x8577,
	45055 - 44032: 0x8578,
	45056 - 44032: 0xB2EB,
	45057 - 44032: 0xB2EC,
	45058 - 44032: 0x8579,
	45059 - 44032: 0x857A,
	45060 - 44032: 0xB2ED,
	45061 - 44032: 0x8581,
	45062 - 44032: 0x8582,
	45063 - 44032: 0x8583,
	45064 - 44032: 0x8584,
	45065 - 44032: 0x8585,
	45066 - 44032: 0x8586,
	45067 - 44032: 0x8587,
	45068 - 44032: 0xB2EE,
	45069 - 44032: 0x8588,
	45070 - 44032: 0x8589,
	45071 - 44032: 0x858A,
	45072 - 44032: 0xB2EF,
	45073 - 44032: 0x858B,
	45074 - 44032: 0x858C,
	45075 - 44032: 0x858D,
	45076 - 44032: 0xB2F0,
	45077 - 44032: 0x858E,
	45078 - 44032: 0x858F,
	45079 - 44032: 0x8590,
	45080 - 44032: 0x8591,
	45081 - 44032: 0x8592,
	45082 - 44032: 0x8593,
	45083 - 44032: 0x8594,
	45084 - 44032: 0xB2F1,
	45085 - 44032: 0xB2F2,
	45086 - 44032: 0x8595,
	45087 - 44032: 0x8596,
	45088 - 44032: 0x8597,
	45089 - 44032: 0x8598,
	45090 - 44032: 0x8599,
	45091 - 44032: 0x859A,
	45092 - 44032: 0x859B,
	45093 - 44032: 0x859C,
	45094 - 44032: 0x859D,
	45095 - 44032: 0x859E,
	45096 - 44032: 0xB2F3,
	45097 - 44032: 0x859F,
	45098 - 44032: 0x85A0,
	45099 - 44032: 0x85A1,
	45100 - 44032: 0x85A2,
	45101 - 44032: 0x85A3,
	45102 - 44032: 0x85A4,
	45103 - 44032: 0x85A5,
	45104 - 44032: 0x85A6,
	45105 - 44032: 0x85A7,
	45106 - 44032: 0x85A8,
	45107 - 44032: 0x85A9,
	45108 - 44032: 0x85AA,
	45109 - 44032: 0x85AB,
	45110 - 44032: 0x85AC,
	45111 - 44032: 0x85AD,
	45112 - 44032: 0x85AE,
	45113 - 44032: 0x85AF,
	45114 - 44032: 0x85B0,
	45115 - 44032: 0x85B1,
	45116 - 44032: 0x85B2,
	45117 - 44032: 0x85B3,
	45118 - 44032: 0x85B4,
	45119 - 44032: 0x85B5,
	45120 - 44032: 0x85B6,
	45121 - 44032: 0x85B7,
	45122 - 44032: 0x85B8,
	45123 - 44032: 0x85B9,
	45124 - 44032: 0xB2F4,
	45125 - 44032: 0xB2F5,
	45126 - 44032: 0x85BA,
	45127 - 44032: 0x85BB,
	45128 - 44032: 0xB2F6,
	45129 - 44032: 0x85BC,
	45130 - 44032: 0xB2F7,
	45131 - 44032: 0x85BD,
	45132 - 44032: 0xB2F8,
	45133 - 44032: 0x85BE,
	45134 - 44032: 0xB2F9,
	45135 - 44032: 0x85BF,
	45136 - 44032: 0x85C0,
	45137 - 44032: 0x85C1,
	45138 - 44032: 0x85C2,
	45139 - 44032: 0xB2FA,
	45140 - 44032: 0xB2FB,
	45141 - 44032: 0xB2FC,
	45142 - 44032: 0x85C3,
	45143 - 44032: 0xB2FD,
	45144 - 44032: 0x85C4,
	45145 - 44032: 0xB2FE,
	45146 - 44032: 0x85C5,
	45147 - 44032: 0x85C6,
	45148 - 44032: 0x85C7,
	45149 - 44032: 0xB3A1,
	45150 - 44032: 0x85C8,
	45151 - 44032: 0x85C9,
	45152 - 44032: 0x85CA,
	45153 - 44032: 0x85CB,
	45154 - 44032: 0x85CC,
	45155 - 44032: 0x85CD,
	45156 - 44032: 0x85CE,
	45157 - 44032: 0x85CF,
	45158 - 44032: 0x85D0,
	45159 - 44032: 0x85D1,
	45160 - 44032: 0x85D2,
	45161 - 44032: 0x85D3,
	45162 - 44032: 0x85D4,
	45163 - 44032: 0x85D5,
	45164 - 44032: 0x85D6,
	45165 - 44032: 0x85D7,
	45166 - 44032: 0x85D8,
	45167 - 44032: 0x85D9,
	45168 - 44032: 0x85DA,
	45169 - 44032: 0x85DB,
	45170 - 44032: 0x85DC,
	45171 - 44032: 0x85DD,
	45172 - 44032: 0x85DE,
	45173 - 44032: 0x85DF,
	45174 - 44032: 0x85E0,
	45175 - 44032: 0x85E1,
	45176 - 44032: 0x85E2,
	45177 - 44032: 0x85E3,
	45178 - 44032: 0x85E4,
	45179 - 44032: 0x85E5,
	45180 - 44032: 0xB3A2,
	45181 - 44032: 0xB3A3,
	45182 - 44032: 0x85E6,
	45183 - 44032: 0x85E7,
	45184 - 44032: 0xB3A4,
	45185 - 44032: 0x85E8,
	45186 - 44032: 0x85E9,
	45187 - 44032: 0x85EA,
	45188 - 44032: 0xB3A5,
	45189 - 44032: 0x85EB,
	45190 - 44032: 0x85EC,
	45191 - 44032: 0x85ED,
	45192 - 44032: 0x85EE,
	45193 - 44032: 0x85EF,
	45194 - 44032: 0x85F0,
	45195 - 44032: 0x85F1,
	45196 - 44032: 0xB3A6,
	45197 - 44032: 0xB3A7,
	45198 - 44032: 0x85F2,
	45199 - 44032: 0xB3A8,
	45200 - 44032: 0x85F3,
	45201 - 44032: 0xB3A9,
	45202 - 44032: 0x85F4,
	45203 - 44032: 0x85F5,
	45204 - 44032: 0x85F6,
	45205 - 44032: 0x85F7,
	45206 - 44032: 0x85F8,
	45207 - 44032: 0x85F9,
	45208 - 44032: 0xB3AA,
	45209 - 44032: 0xB3AB,
	45210 - 44032: 0xB3AC,
	45211 - 44032: 0x85FA,
	45212 - 44032: 0xB3AD,
	45213 - 44032: 0x85FB,
	45214 - 44032: 0x85FC,
	45215 - 44032: 0xB3AE,
	45216 - 44032: 0xB3AF,
	45217 - 44032: 0xB3B0,
	45218 - 44032: 0xB3B1,
	45219 - 44032: 0x85FD,
	45220 - 44032: 0x85FE,
	45221 - 44032: 0x8641,
	45222 - 44032: 0x8642,
	45223 - 44032: 0x8643,
	45224 - 44032: 0xB3B2,
	45225 - 44032: 0xB3B3,
	45226 - 44032: 0x8644,
	45227 - 44032: 0xB3B4,
	45228 - 44032: 0xB3B5,
	45229 - 44032: 0xB3B6,
	45230 - 44032: 0xB3B7,
	45231 - 44032: 0xB3B8,
	45232 - 44032: 0x8645,
	45233 - 44032: 0xB3B9,
	45234 - 44032: 0x8646,
	45235 - 44032: 0xB3BA,
	45236 - 44032: 0xB3BB,
	45237 - 44032: 0xB3BC,
	45238 - 44032: 0x8647,
	45239 - 44032: 0x8648,
	45240 - 44032: 0xB3BD,
	45241 - 44032: 0x8649,
	45242 - 44032: 0x864A,
	45243 - 44032: 0x864B,
	45244 - 44032: 0xB3BE,
	45245 - 44032: 0x864C,
	45246 - 44032: 0x864D,
	45247 - 44032: 0x864E,
	45248 - 44032: 0x864F,
	45249 - 44032: 0x8650,
	45250 - 44032: 0x8651,
	45251 - 44032: 0x8652,
	45252 - 44032: 0xB3BF,
	45253 - 44032: 0xB3C0,
	45254 - 44032: 0x8653,
	45255 - 44032: 0xB3C1,
	45256 - 44032: 0xB3C2,
	45257 - 44032: 0xB3C3,
	45258 - 44032: 0x8654,
	45259 - 44032: 0x8655,
	45260 - 44032: 0x8656,
	45261 - 44032: 0x8657,
	45262 - 44032: 0x8658,
	45263 - 44032: 0x8659,
	45264 - 44032: 0xB3C4,
	45265 - 44032: 0xB3C5,
	45266 - 44032: 0x865A,
	45267 - 44032: 0x8661,
	45268 - 44032: 0xB3C6,
	45269 - 44032: 0x8662,
	45270 - 44032: 0x8663,
	45271 - 44032: 0x8664,
	45272 - 44032: 0xB3C7,
	45273 - 44032: 0x8665,
	45274 - 44032: 0x8666,
	45275 - 44032: 0x8667,
	45276 - 44032: 0x8668,
	45277 - 44032: 0x8669,
	45278 - 44032: 0x866A,
	45279 - 44032: 0x866B,
	45280 - 44032: 0xB3C8,
	45281 - 44032: 0x866C,
	45282 - 44032: 0x866D,
	45283 - 44032: 0x866E,
	45284 - 44032: 0x866F,
	45285 - 44032: 0xB3C9,
	45286 - 44032: 0x8670,
	45287 - 44032: 0x8671,
	45288 - 44032: 0x8672,
	45289 - 44032: 0x8673,
	45290 - 44032: 0x8674,
	45291 - 44032: 0x8675,
	45292 - 44032: 0x8676,
	45293 - 44032: 0x8677,
	45294 - 44032: 0x8678,
	45295 - 44032: 0x8679,
	45296 - 44032: 0x867A,
	45297 - 44032: 0x8681,
	45298 - 44032: 0x8682,
	45299 - 44032: 0x8683,
	45300 - 44032: 0x8684,
	45301 - 44032: 0x8685,
	45302 - 44032: 0x8686,
	45303 - 44032: 0x8687,
	45304 - 44032: 0x8688,
	45305 - 44032: 0x8689,
	45306 - 44032: 0x868A,
	45307 - 44032: 0x868B,
	45308 - 44032: 0x868C,
	45309 - 44032: 0x868D,
	45310 - 44032: 0x868E,
	45311 - 44032: 0x868F,
	45312 - 44032: 0x8690,
	45313 - 44032: 0x8691,
	45314 - 44032: 0x8692,
	45315 - 44032: 0x8693,
	45316 - 44032: 0x8694,
	45317 - 44032: 0x8695,
	45318 - 44032: 0x8696,
	45319 - 44032: 0x8697,
	45320 - 44032: 0xB3CA,
	45321 - 44032: 0xB3CB,
	45322 - 44032: 0x8698,
	45323 - 44032: 0xB3CC,
	45324 - 44032: 0xB3CD,
	45325 - 44032: 0x8699,
	45326 - 44032: 0x869A,
	45327 - 44032: 0x869B,
	45328 - 44032: 0xB3CE,
	45329 - 44032: 0x869C,
	45330 - 44032: 0xB3CF,
	45331 - 44032: 0xB3D0,
	45332 - 44032: 0x869D,
	45333 - 44032: 0x869E,
	45334 - 44032: 0x869F,
	45335 - 44032: 0x86A0,
	45336 - 44032: 0xB3D1,
	45337 - 44032: 0xB3D2,
	45338 - 44032: 0x86A1,
	45339 - 44032: 0xB3D3,
	45340 - 44032: 0xB3D4,
	45341 - 44032: 0xB3D5,
	45342 - 44032: 0x86A2,
	45343 - 44032: 0x86A3,
	45344 - 44032: 0x86A4,
	45345 - 44032: 0x86A5,
	45346 - 44032: 0x86A6,
	45347 - 44032: 0xB3D6,
	45348 - 44032: 0xB3D7,
	45349 - 44032: 0xB3D8,
	45350 - 44032: 0x86A7,
	45351 - 44032: 0x86A8,
	45352 - 44032: 0xB3D9,
	45353 - 44032: 0x86A9,
	45354 - 44032: 0x86AA,
	45355 - 44032: 0x86AB,
	45356 - 44032: 0xB3DA,
	45357 - 44032: 0x86AC,
	45358 - 44032: 0x86AD,
	45359 - 44032: 0x86AE,
	45360 - 44032: 0x86AF,
	45361 - 44032: 0x86B0,
	45362 - 44032: 0x86B1,
	45363 - 44032: 0x86B2,
	45364 - 44032: 0xB3DB,
	45365 - 44032: 0xB3DC,
	45366 - 44032: 0x86B3,
	45367 - 44032: 0xB3DD,
	45368 - 44032: 0xB3DE,
	45369 - 44032: 0xB3DF,
	45370 - 44032: 0x86B4,
	45371 - 44032: 0x86B5,
	45372 - 44032: 0x86B6,
	45373 - 44032: 0x86B7,
	45374 - 44032: 0x86B8,
	45375 - 44032: 0x86B9,
	45376 - 44032: 0xB3E0,
	45377 - 44032: 0xB3E1,
	45378 - 44032: 0x86BA,
	45379 - 44032: 0x86BB,
	45380 - 44032: 0xB3E2,
	45381 - 44032: 0x86BC,
	45382 - 44032: 0x86BD,
	45383 - 44032: 0x86BE,
	45384 - 44032: 0xB3E3,
	45385 - 44032: 0x86BF,
	45386 - 44032: 0x86C0,
	45387 - 44032: 0x86C1,
	45388 - 44032: 0x86C2,
	45389 - 44032: 0x86C3,
	45390 - 44032: 0x86C4,
	45391 - 44032: 0x86C5,
	45392 - 44032: 0xB3E4,
	45393 - 44032: 0xB3E5,
	45394 - 44032: 0x86C6,
	45395 - 44032: 0x86C7,
	45396 - 44032: 0xB3E6,
	45397 - 44032: 0xB3E7,
	45398 - 44032: 0x86C8,
	45399 - 44032: 0x86C9,
	45400 - 44032: 0xB3E8,
	45401 - 44032: 0x86CA,
	45402 - 44032: 0x86CB,
	45403 - 44032: 0x86CC,
	45404 - 44032: 0xB3E9,
	45405 - 44032: 0x86CD,
	45406 - 44032: 0x86CE,
	45407 - 44032: 0x86CF,
	45408 - 44032: 0xB3EA,
	45409 - 44032: 0x86D0,
	45410 - 44032: 0x86D1,
	45411 - 44032: 0x86D2,
	45412 - 44032: 0x86D3,
	45413 - 44032: 0x86D4,
	45414 - 44032: 0x86D5,
	45415 - 44032: 0x86D6,
	45416 - 44032: 0x86D7,
	45417 - 44032: 0x86D8,
	45418 - 44032: 0x86D9,
	45419 - 44032: 0x86DA,
	45420 - 44032: 0x86DB,
	45421 - 44032: 0x86DC,
	45422 - 44032: 0x86DD,
	45423 - 44032: 0x86DE,
	45424 - 44032: 0x86DF,
	45425 - 44032: 0x86E0,
	45426 - 44032: 0x86E1,
	45427 - 44032: 0x86E2,
	45428 - 44032: 0x86E3,
	45429 - 44032: 0x86E4,
	45430 - 44032: 0x86E5,
	45431 - 44032: 0x86E6,
	45432 - 44032: 0xB3EB,
	45433 - 44032: 0xB3EC,
	45434 - 44032: 0x86E7,
	45435 - 44032: 0x86E8,
	45436 - 44032: 0xB3ED,
	45437 - 44032: 0x86E9,
	45438 - 44032: 0x86EA,
	45439 - 44032: 0x86EB,
	45440 - 44032: 0xB3EE,
	45441 - 44032: 0x86EC,
	45442 - 44032: 0xB3EF,
	45443 - 44032: 0x86ED,
	45444 - 44032: 0x86EE,
	45445 - 44032: 0x86EF,
	45446 - 44032: 0x86F0,
	45447 - 44032: 0x86F1,
	45448 - 44032: 0xB3F0,
	45449 - 44032: 0xB3F1,
	45450 - 44032: 0x86F2,
	45451 - 44032: 0xB3F2,
	45452 - 44032: 0x86F3,
	45453 - 44032: 0xB3F3,
	45454 - 44032: 0x86F4,
	45455 - 44032: 0x86F5,
	45456 - 44032: 0x86F6,
	45457 - 44032: 0x86F7,
	45458 - 44032: 0xB3F4,
	45459 - 44032: 0xB3F5,
	45460 - 44032: 0xB3F6,
	45461 - 44032: 0x86F8,
	45462 - 44032: 0x86F9,
	45463 - 44032: 0x86FA,
	45464 - 44032: 0xB3F7,
	45465 - 44032: 0x86FB,
	45466 - 44032: 0x86FC,
	45467 - 44032: 0x86FD,
	45468 - 44032: 0xB3F8,
	45469 - 44032: 0x86FE,
	45470 - 44032: 0x8741,
	45471 - 44032: 0x8742,
	45472 - 44032: 0x8743,
	45473 - 44032: 0x8744,
	45474 - 44032: 0x8745,
	45475 - 44032: 0x8746,
	45476 - 44032: 0x8747,
	45477 - 44032: 0x8748,
	45478 - 44032: 0x8749,
	45479 - 44032: 0x874A,
	45480 - 44032: 0xB3F9,
	45481 - 44032: 0x874B,
	45482 - 44032: 0x874C,
	45483 - 44032: 0x874D,
	45484 - 44032: 0x874E,
	45485 - 44032: 0x874F,
	45486 - 44032: 0x8750,
	45487 - 44032: 0x8751,
	45488 - 44032: 0x8752,
	45489 - 44032: 0x8753,
	45490 - 44032: 0x8754,
	45491 - 44032: 0x8755,
	45492 - 44032: 0x8756,
	45493 - 44032: 0x8757,
	45494 - 44032: 0x8758,
	45495 - 44032: 0x8759,
	45496 - 44032: 0x875A,
	45497 - 44032: 0x8761,
	45498 - 44032: 0x8762,
	45499 - 44032: 0x8763,
	45500 - 44032: 0x8764,
	45501 - 44032: 0x8765,
	45502 - 44032: 0x8766,
	45503 - 44032: 0x8767,
	45504 - 44032: 0x8768,
	45505 - 44032: 0x8769,
	45506 - 44032: 0x876A,
	45507 - 44032: 0x876B,
	45508 - 44032: 0x876C,
	45509 - 44032: 0x876D,
	45510 - 44032: 0x876E,
	45511 - 44032: 0x876F,
	45512 - 44032: 0x8770,
	45513 - 44032: 0x8771,
	45514 - 44032: 0x8772,
	45515 - 44032: 0x8773,
	45516 - 44032: 0xB3FA,
	45517 - 44032: 0x8774,
	45518 - 44032: 0x8775,
	45519 - 44032: 0x8776,
	45520 - 44032: 0xB3FB,
	45521 - 44032: 0x8777,
	45522 - 44032: 0x8778,
	45523 - 44032: 0x8779,
	45524 - 44032: 0xB3FC,
	45525 - 44032: 0x877A,
	45526 - 44032: 0x8781,
	45527 - 44032: 0x8782,
	45528 - 44032: 0x8783,
	45529 - 44032: 0x8784,
	45530 - 44032: 0x8785,
	45531 - 44032: 0x8786,
	45532 - 44032: 0xB3FD,
	45533 - 44032: 0xB3FE,
	45534 - 44032: 0x8787,
	45535 - 44032: 0xB4A1,
	45536 - 44032: 0x8788,
	45537 - 44032: 0x8789,
	45538 - 44032: 0x878A,
	45539 - 44032: 0x878B,
	45540 - 44032: 0x878C,
	45541 - 44032: 0x878D,
	45542 - 44032: 0x878E,
	45543 - 44032: 0x878F,
	45544 - 44032: 0xB4A2,
	45545 - 44032: 0xB4A3,
	45546 - 44032: 0x8790,
	45547 - 44032: 0x8791,
	45548 - 44032: 0xB4A4,
	45549 - 44032: 0x8792,
	45550 - 44032: 0x8793,
	45551 - 44032: 0x8794,
	45552 - 44032: 0xB4A5,
	45553 - 44032: 0x8795,
	45554 - 44032: 0x8796,
	45555 - 44032: 0x8797,
	45556 - 44032: 0x8798,
	45557 - 44032: 0x8799,
	45558 - 44032: 0x879A,
	45559 - 44032: 0x879B,
	45560 - 44032: 0x879C,
	45561 - 44032: 0xB4A6,
	45562 - 44032: 0x879D,
	45563 - 44032: 0xB4A7,
	45564 - 44032: 0x879E,
	45565 - 44032: 0xB4A8,
	45566 - 44032: 0x879F,
	45567 - 44032: 0x87A0,
	45568 - 44032: 0x87A1,
	45569 - 44032: 0x87A2,
	45570 - 44032: 0x87A3,
	45571 - 44032: 0x87A4,
	45572 - 44032: 0xB4A9,
	45573 - 44032: 0xB4AA,
	45574 - 44032: 0x87A5,
	45575 - 44032: 0x87A6,
	45576 - 44032: 0xB4AB,
	45577 - 44032: 0x87A7,
	45578 - 44032: 0x87A8,
	45579 - 44032: 0xB4AC,
	45580 - 44032: 0xB4AD,
	45581 - 44032: 0x87A9,
	45582 - 44032: 0x87AA,
	45583 - 44032: 0x87AB,
	45584 - 44032: 0x87AC,
	45585 - 44032: 0x87AD,
	45586 - 44032: 0x87AE,
	45587 - 44032: 0x87AF,
	45588 - 44032: 0xB4AE,
	45589 - 44032: 0xB4AF,
	45590 - 44032: 0x87B0,
	45591 - 44032: 0xB4B0,
	45592 - 44032: 0x87B1,
	45593 - 44032: 0xB4B1,
	45594 - 44032: 0x87B2,
	45595 - 44032: 0x87B3,
	45596 - 44032: 0x87B4,
	45597 - 44032: 0x87B5,
	45598 - 44032: 0x87B6,
	45599 - 44032: 0x87B7,
	45600 - 44032: 0xB4B2,
	45601 - 44032: 0x87B8,
	45602 - 44032: 0x87B9,
	45603 - 44032: 0x87BA,
	45604 - 44032: 0x87BB,
	45605 - 44032: 0x87BC,
	45606 - 44032: 0x87BD,
	45607 - 44032: 0x87BE,
	45608 - 44032: 0x87BF,
	45609 - 44032: 0x87C0,
	45610 - 44032: 0x87C1,
	45611 - 44032: 0x87C2,
	45612 - 44032: 0x87C3,
	45613 - 44032: 0x87C4,
	45614 - 44032: 0x87C5,
	45615 - 44032: 0x87C6,
	45616 - 44032: 0x87C7,
	45617 - 44032: 0x87C8,
	45618 - 44032: 0x87C9,
	45619 - 44032: 0x87CA,
	45620 - 44032: 0xB4B3,
	45621 - 44032: 0x87CB,
	45622 - 44032: 0x87CC,
	45623 - 44032: 0x87CD,
	45624 - 44032: 0x87CE,
	45625 - 44032: 0x87CF,
	45626 - 44032: 0x87D0,
	45627 - 44032: 0x87D1,
	45628 - 44032: 0xB4B4,
	45629 - 44032: 0x87D2,
	45630 - 44032: 0x87D3,
	45631 - 44032: 0x87D4,
	45632 - 44032: 0x87D5,
	45633 - 44032: 0x87D6,
	45634 - 44032: 0x87D7,
	45635 - 44032: 0x87D8,
	45636 - 44032: 0x87D9,
	45637 - 44032: 0x87DA,
	45638 - 44032: 0x87DB,
	45639 - 44032: 0x87DC,
	45640 - 44032: 0x87DD,
	45641 - 44032: 0x87DE,
	45642 - 44032: 0x87DF,
	45643 - 44032: 0x87E0,
	45644 - 44032: 0x87E1,
	45645 - 44032: 0x87E2,
	45646 - 44032: 0x87E3,
	45647 - 44032: 0x87E4,
	45648 - 44032: 0x87E5,
	45649 - 44032: 0x87E6,
	45650 - 44032: 0x87E7,
	45651 - 44032: 0x87E8,
	45652 - 44032: 0x87E9,
	45653 - 44032: 0x87EA,
	45654 - 44032: 0x87EB,
	45655 - 44032: 0x87EC,
	45656 - 44032: 0xB4B5,
	45657 - 44032: 0x87ED,
	45658 - 44032: 0x87EE,
	45659 - 44032: 0x87EF,
	45660 - 44032: 0xB4B6,
	45661 - 44032: 0x87F0,
	45662 - 44032: 0x87F1,
	45663 - 44032: 0x87F2,
	45664 - 44032: 0xB4B7,
	45665 - 44032: 0x87F3,
	45666 - 44032: 0x87F4,
	45667 - 44032: 0x87F5,
	45668 - 44032: 0x87F6,
	45669 - 44032: 0x87F7,
	45670 - 44032: 0x87F8,
	45671 - 44032: 0x87F9,
	45672 - 44032: 0xB4B8,
	45673 - 44032: 0xB4B9,
	45674 - 44032: 0x87FA,
	45675 - 44032: 0x87FB,
	45676 - 44032: 0x87FC,
	45677 - 44032: 0x87FD,
	45678 - 44032: 0x87FE,
	45679 - 44032: 0x8841,
	45680 - 44032: 0x8842,
	45681 - 44032: 0x8843,
	45682 - 44032: 0x8844,
	45683 - 44032: 0x8845,
	45684 - 44032: 0xB4BA,
	45685 - 44032: 0xB4BB,
	45686 - 44032: 0x8846,
	45687 - 44032: 0x8847,
	45688 - 44032: 0x8848,
	45689 - 44032: 0x8849,
	45690 - 44032: 0x884A,
	45691 - 44032: 0x884B,
	45692 - 44032: 0xB4BC,
	45693 - 44032: 0x884C,
	45694 - 44032: 0x884D,
	45695 - 44032: 0x884E,
	45696 - 44032: 0x884F,
	45697 - 44032: 0x8850,
	45698 - 44032: 0x8851,
	45699 - 44032: 0x8852,
	45700 - 44032: 0xB4BD,
	45701 - 44032: 0xB4BE,
	45702 - 44032: 0x8853,
	45703 - 44032: 0x8854,
	45704 - 44032: 0x8855,
	45705 - 44032: 0xB4BF,
	45706 - 44032: 0x8856,
	45707 - 44032: 0x8857,
	45708 - 44032: 0x8858,
	45709 - 44032: 0x8859,
	45710 - 44032: 0x885A,
	45711 - 44032: 0x8861,
	45712 - 44032: 0xB4C0,
	45713 - 44032: 0xB4C1,
	45714 - 44032: 0x8862,
	45715 - 44032: 0x8863,
	45716 - 44032: 0xB4C2,
	45717 - 44032: 0x8864,
	45718 - 44032: 0x8865,
	45719 - 44032: 0x8866,
	45720 - 44032: 0xB4C3,
	45721 - 44032: 0xB4C4,
	45722 - 44032: 0xB4C5,
	45723 - 44032: 0x8867,
	45724 - 44032: 0x8868,
	45725 - 44032: 0x8869,
	45726 - 44032: 0x886A,
	45727 - 44032: 0x886B,
	45728 - 44032: 0xB4C6,
	45729 - 44032: 0xB4C7,
	45730 - 44032: 0x886C,
	45731 - 44032: 0xB4C8,
	45732 - 44032: 0x886D,
	45733 - 44032: 0xB4C9,
	45734 - 44032: 0xB4CA,
	45735 - 44032: 0x886E,
	45736 - 44032: 0x886F,
	45737 - 44032: 0x8870,
	45738 - 44032: 0xB4CB,
	45739 - 44032: 0x8871,
	45740 - 44032: 0xB4CC,
	45741 - 44032: 0x8872,
	45742 - 44032: 0x8873,
	45743 - 44032: 0x8874,
	45744 - 44032: 0xB4CD,
	45745 - 44032: 0x8875,
	45746 - 44032: 0x8876,
	45747 - 44032: 0x8877,
	45748 - 44032: 0xB4CE,
	45749 - 44032: 0x8878,
	45750 - 44032: 0x8879,
	45751 - 44032: 0x887A,
	45752 - 44032: 0x8881,
	45753 - 44032: 0x8882,
	45754 - 44032: 0x8883,
	45755 - 44032: 0x8884,
	45756 - 44032: 0x8885,
	45757 - 44032: 0x8886,
	45758 - 44032: 0x8887,
	45759 - 44032: 0x8888,
	45760 - 44032: 0x8889,
	45761 - 44032: 0x888A,
	45762 - 44032: 0x888B,
	45763 - 44032: 0x888C,
	45764 - 44032: 0x888D,
	45765 - 44032: 0x888E,
	45766 - 44032: 0x888F,
	45767 - 44032: 0x8890,
	45768 - 44032: 0xB4CF,
	45769 - 44032: 0xB4D0,
	45770 - 44032: 0x8891,
	45771 - 44032: 0x8892,
	45772 - 44032: 0xB4D1,
	45773 - 44032: 0x8893,
	45774 - 44032: 0x8894,
	45775 - 44032: 0x8895,
	45776 - 44032: 0xB4D2,
	45777 - 44032: 0x8896,
	45778 - 44032: 0xB4D3,
	45779 - 44032: 0x8897,
	45780 - 44032: 0x8898,
	45781 - 44032: 0x8899,
	45782 - 44032: 0x889A,
	45783 - 44032: 0x889B,
	45784 - 44032: 0xB4D4,
	45785 - 44032: 0xB4D5,
	45786 - 44032: 0x889C,
	45787 - 44032: 0xB4D6,
	45788 - 44032: 0x889D,
	45789 - 44032: 0xB4D7,
	45790 - 44032: 0x889E,
	45791 - 44032: 0x889F,
	45792 - 44032: 0x88A0,
	45793 - 44032: 0x88A1,
	45794 - 44032: 0xB4D8,
	45795 - 44032: 0x88A2,
	45796 - 44032: 0xB4D9,
	45797 - 44032: 0xB4DA,
	45798 - 44032: 0xB4DB,
	45799 - 44032: 0x88A3,
	45800 - 44032: 0xB4DC,
	45801 - 44032: 0x88A4,
	45802 - 44032: 0x88A5,
	45803 - 44032: 0xB4DD,
	45804 - 44032: 0xB4DE,
	45805 - 44032: 0xB4DF,
	45806 - 44032: 0xB4E0,
	45807 - 44032: 0xB4E1,
	45808 - 44032: 0x88A6,
	45809 - 44032: 0x88A7,
	45810 - 44032: 0x88A8,
	45811 - 44032: 0xB4E2,
	45812 - 44032: 0xB4E3,
	45813 - 44032: 0xB4E4,
	45814 - 44032: 0x88A9,
	45815 - 44032: 0xB4E5,
	45816 - 44032: 0xB4E6,
	45817 - 44032: 0xB4E7,
	45818 - 44032: 0xB4E8,
	45819 - 44032: 0xB4E9,
	45820 - 44032: 0x88AA,
	45821 - 44032: 0x88AB,
	45822 - 44032: 0x88AC,
	45823 - 44032: 0xB4EA,
	45824 - 44032: 0xB4EB,
	45825 - 44032: 0xB4EC,
	45826 - 44032: 0x88AD,
	45827 - 44032: 0x88AE,
	45828 - 44032: 0xB4ED,
	45829 - 44032: 0x88AF,
	45830 - 44032: 0x88B0,
	45831 - 44032: 0x88B1,
	45832 - 44032: 0xB4EE,
	45833 - 44032: 0x88B2,
	45834 - 44032: 0x88B3,
	45835 - 44032: 0x88B4,
	45836 - 44032: 0x88B5,
	45837 - 44032: 0x88B6,
	45838 - 44032: 0x88B7,
	45839 - 44032: 0x88B8,
	45840 - 44032: 0xB4EF,
	45841 - 44032: 0xB4F0,
	45842 - 44032: 0x88B9,
	45843 - 44032: 0xB4F1,
	45844 - 44032: 0xB4F2,
	45845 - 44032: 0xB4F3,
	45846 - 44032: 0x88BA,
	45847 - 44032: 0x88BB,
	45848 - 44032: 0x88BC,
	45849 - 44032: 0x88BD,
	45850 - 44032: 0x88BE,
	45851 - 44032: 0x88BF,
	45852 - 44032: 0xB4F4,
	45853 - 44032: 0x88C0,
	45854 - 44032: 0x88C1,
	45855 - 44032: 0x88C2,
	45856 - 44032: 0x88C3,
	45857 - 44032: 0x88C4,
	45858 - 44032: 0x88C5,
	45859 - 44032: 0x88C6,
	45860 - 44032: 0x88C7,
	45861 - 44032: 0x88C8,
	45862 - 44032: 0x88C9,
	45863 - 44032: 0x88CA,
	45864 - 44032: 0x88CB,
	45865 - 44032: 0x88CC,
	45866 - 44032: 0x88CD,
	45867 - 44032: 0x88CE,
	45868 - 44032: 0x88CF,
	45869 - 44032: 0x88D0,
	45870 - 44032: 0x88D1,
	45871 - 44032: 0x88D2,
	45872 - 44032: 0x88D3,
	45873 - 44032: 0x88D4,
	45874 - 44032: 0x88D5,
	45875 - 44032: 0x88D6,
	45876 - 44032: 0x88D7,
	45877 - 44032: 0x88D8,
	45878 - 44032: 0x88D9,
	45879 - 44032: 0x88DA,
	45880 - 44032: 0x88DB,
	45881 - 44032: 0x88DC,
	45882 - 44032: 0x88DD,
	45883 - 44032: 0x88DE,
	45884 - 44032: 0x88DF,
	45885 - 44032: 0x88E0,
	45886 - 44032: 0x88E1,
	45887 - 44032: 0x88E2,
	45888 - 44032: 0x88E3,
	45889 - 44032: 0x88E4,
	45890 - 44032: 0x88E5,
	45891 - 44032: 0x88E6,
	45892 - 44032: 0x88E7,
	45893 - 44032: 0x88E8,
	45894 - 44032: 0x88E9,
	45895 - 44032: 0x88EA,
	45896 - 44032: 0x88EB,
	45897 - 44032: 0x88EC,
	45898 - 44032: 0x88ED,
	45899 - 44032: 0x88EE,
	45900 - 44032: 0x88EF,
	45901 - 44032: 0x88F0,
	45902 - 44032: 0x88F1,
	45903 - 44032: 0x88F2,
	45904 - 44032: 0x88F3,
	45905 - 44032: 0x88F4,
	45906 - 44032: 0x88F5,
	45907 - 44032: 0x88F6,
	45908 - 44032: 0xB4F5,
	45909 - 44032: 0xB4F6,
	45910 - 44032: 0xB4F7,
	45911 - 44032: 0x88F7,
	45912 - 44032: 0xB4F8,
	45913 - 44032: 0x88F8,
	45914 - 44032: 0x88F9,
	45915 - 44032: 0xB4F9,
	45916 - 44032: 0xB4FA,
	45917 - 44032: 0x88FA,
	45918 - 44032: 0xB4FB,
	45919 - 44032: 0xB4FC,
	45920 - 44032: 0x88FB,
	45921 - 44032: 0x88FC,
	45922 - 44032: 0x88FD,
	45923 - 44032: 0x88FE,
	45924 - 44032: 0xB4FD,
	45925 - 44032: 0xB4FE,
	45926 - 44032: 0x8941,
	45927 - 44032: 0xB5A1,
	45928 - 44032: 0x8942,
	45929 - 44032: 0xB5A2,
	45930 - 44032: 0x8943,
	45931 - 44032: 0xB5A3,
	45932 - 44032: 0x8944,
	45933 - 44032: 0x8945,
	45934 - 44032: 0xB5A4,
	45935 - 44032: 0x8946,
	45936 - 44032: 0xB5A5,
	45937 - 44032: 0xB5A6,
	45938 - 44032: 0x8947,
	45939 - 44032: 0x8948,
	45940 - 44032: 0xB5A7,
	45941 - 44032: 0x8949,
	45942 - 44032: 0x894A,
	45943 - 44032: 0x894B,
	45944 - 44032: 0xB5A8,
	45945 - 44032: 0x894C,
	45946 - 44032: 0x894D,
	45947 - 44032: 0x894E,
	45948 - 44032: 0x894F,
	45949 - 44032: 0x8950,
	45950 - 44032: 0x8951,
	45951 - 44032: 0x8952,
	45952 - 44032: 0xB5A9,
	45953 - 44032: 0xB5AA,
	45954 - 44032: 0x8953,
	45955 - 44032: 0xB5AB,
	45956 - 44032: 0xB5AC,
	45957 - 44032: 0xB5AD,
	45958 - 44032: 0x8954,
	45959 - 44032: 0x8955,
	45960 - 44032: 0x8956,
	45961 - 44032: 0x8957,
	45962 - 44032: 0x8958,
	45963 - 44032: 0x8959,
	45964 - 44032: 0xB5AE,
	45965 - 44032: 0x895A,
	45966 - 44032: 0x8961,
	45967 - 44032: 0x8962,
	45968 - 44032: 0xB5AF,
	45969 - 44032: 0x8963,
	45970 - 44032: 0x8964,
	45971 - 44032: 0x8965,
	45972 - 44032: 0xB5B0,
	45973 - 44032: 0x8966,
	45974 - 44032: 0x8967,
	45975 - 44032: 0x8968,
	45976 - 44032: 0x8969,
	45977 - 44032: 0x896A,
	45978 - 44032: 0x896B,
	45979 - 44032: 0x896C,
	45980 - 44032: 0x896D,
	45981 - 44032: 0x896E,
	45982 - 44032: 0x896F,
	45983 - 44032: 0x8970,
	45984 - 44032: 0xB5B1,
	45985 - 44032: 0xB5B2,
	45986 - 44032: 0x8971,
	45987 - 44032: 0x8972,
	45988 - 44032: 0x8973,
	45989 - 44032: 0x8974,
	45990 - 44032: 0x8975,
	45991 - 44032: 0x8976,
	45992 - 44032: 0xB5B3,
	45993 - 44032: 0x8977,
	45994 - 44032: 0x8978,
	45995 - 44032: 0x8979,
	45996 - 44032: 0xB5B4,
	45997 - 44032: 0x897A,
	45998 - 44032: 0x8981,
	45999 - 44032: 0x8982,
	46000 - 44032: 0x8983,
	46001 - 44032: 0x8984,
	46002 - 44032: 0x8985,
	46003 - 44032: 0x8986,
	46004 - 44032: 0x8987,
	46005 - 44032: 0x8988,
	46006 - 44032: 0x8989,
	46007 - 44032: 0x898A,
	46008 - 44032: 0x898B,
	46009 - 44032: 0x898C,
	46010 - 44032: 0x898D,
	46011 - 44032: 0x898E,
	46012 - 44032: 0x898F,
	46013 - 44032: 0x8990,
	46014 - 44032: 0x8991,
	46015 - 44032: 0x8992,
	46016 - 44032: 0x8993,
	46017 - 44032: 0x8994,
	46018 - 44032: 0x8995,
	46019 - 44032: 0x8996,
	46020 - 44032: 0xB5B5,
	46021 - 44032: 0xB5B6,
	46022 - 44032: 0x8997,
	46023 - 44032: 0x8998,
	46024 - 44032: 0xB5B7,
	46025 - 44032: 0x8999,
	46026 - 44032: 0x899A,
	46027 - 44032: 0xB5B8,
	46028 - 44032: 0xB5B9,
	46029 - 44032: 0x899B,
	46030 - 44032: 0xB5BA,
	46031 - 44032: 0x899C,
	46032 - 44032: 0xB5BB,
	46033 - 44032: 0x899D,
	46034 - 44032: 0x899E,
	46035 - 44032: 0x899F,
	46036 - 44032: 0xB5BC,
	46037 - 44032: 0xB5BD,
	46038 - 44032: 0x89A0,
	46039 - 44032: 0xB5BE,
	46040 - 44032: 0x89A1,
	46041 - 44032: 0xB5BF,
	46042 - 44032: 0x89A2,
	46043 - 44032: 0xB5C0,
	46044 - 44032: 0x89A3,
	46045 - 44032: 0xB5C1,
	46046 - 44032: 0x89A4,
	46047 - 44032: 0x89A5,
	46048 - 44032: 0xB5C2,
	46049 - 44032: 0x89A6,
	46050 - 44032: 0x89A7,
	46051 - 44032: 0x89A8,
	46052 - 44032: 0xB5C3,
	46053 - 44032: 0x89A9,
	46054 - 44032: 0x89AA,
	46055 - 44032: 0x89AB,
	46056 - 44032: 0xB5C4,
	46057 - 44032: 0x89AC,
	46058 - 44032: 0x89AD,
	46059 - 44032: 0x89AE,
	46060 - 44032: 0x89AF,
	46061 - 44032: 0x89B0,
	46062 - 44032: 0x89B1,
	46063 - 44032: 0x89B2,
	46064 - 44032: 0x89B3,
	46065 - 44032: 0x89B4,
	46066 - 44032: 0x89B5,
	46067 - 44032: 0x89B6,
	46068 - 44032: 0x89B7,
	46069 - 44032: 0x89B8,
	46070 - 44032: 0x89B9,
	46071 - 44032: 0x89BA,
	46072 - 44032: 0x89BB,
	46073 - 44032: 0x89BC,
	46074 - 44032: 0x89BD,
	46075 - 44032: 0x89BE,
	46076 - 44032: 0xB5C5,
	46077 - 44032: 0x89BF,
	46078 - 44032: 0x89C0,
	46079 - 44032: 0x89C1,
	46080 - 44032: 0x89C2,
	46081 - 44032: 0x89C3,
	46082 - 44032: 0x89C4,
	46083 - 44032: 0x89C5,
	46084 - 44032: 0x89C6,
	46085 - 44032: 0x89C7,
	46086 - 44032: 0x89C8,
	46087 - 44032: 0x89C9,
	46088 - 44032: 0x89CA,
	46089 - 44032: 0x89CB,
	46090 - 44032: 0x89CC,
	46091 - 44032: 0x89CD,
	46092 - 44032: 0x89CE,
	46093 - 44032: 0x89CF,
	46094 - 44032: 0x89D0,
	46095 - 44032: 0x89D1,
	46096 - 44032: 0xB5C6,
	46097 - 44032: 0x89D2,
	46098 - 44032: 0x89D3,
	46099 - 44032: 0x89D4,
	46100 - 44032: 0x89D5,
	46101 - 44032: 0x89D6,
	46102 - 44032: 0x89D7,
	46103 - 44032: 0x89D8,
	46104 - 44032: 0xB5C7,
	46105 - 44032: 0x89D9,
	46106 - 44032: 0x89DA,
	46107 - 44032: 0x89DB,
	46108 - 44032: 0xB5C8,
	46109 - 44032: 0x89DC,
	46110 - 44032: 0x89DD,
	46111 - 44032: 0x89DE,
	46112 - 44032: 0xB5C9,
	46113 - 44032: 0x89DF,
	46114 - 44032: 0x89E0,
	46115 - 44032: 0x89E1,
	46116 - 44032: 0x89E2,
	46117 - 44032: 0x89E3,
	46118 - 44032: 0x89E4,
	46119 - 44032: 0x89E5,
	46120 - 44032: 0xB5CA,
	46121 - 44032: 0xB5CB,
	46122 - 44032: 0x89E6,
	46123 - 44032: 0xB5CC,
	46124 - 44032: 0x89E7,
	46125 - 44032: 0x89E8,
	46126 - 44032: 0x89E9,
	46127 - 44032: 0x89EA,
	46128 - 44032: 0x89EB,
	46129 - 44032: 0x89EC,
	46130 - 44032: 0x89ED,
	46131 - 44032: 0x89EE,
	46132 - 44032: 0xB5CD,
	46133 - 44032: 0x89EF,
	46134 - 44032: 0x89F0,
	46135 - 44032: 0x89F1,
	46136 - 44032: 0x89F2,
	46137 - 44032: 0x89F3,
	46138 - 44032: 0x89F4,
	46139 - 44032: 0x89F5,
	46140 - 44032: 0x89F6,
	46141 - 44032: 0x89F7,
	46142 - 44032: 0x89F8,
	46143 - 44032: 0x89F9,
	46144 - 44032: 0x89FA,
	46145 - 44032: 0x89FB,
	46146 - 44032: 0x89FC,
	46147 - 44032: 0x89FD,
	46148 - 44032: 0x89FE,
	46149 - 44032: 0x8A41,
	46150 - 44032: 0x8A42,
	46151 - 44032: 0x8A43,
	46152 - 44032: 0x8A44,
	46153 - 44032: 0x8A45,
	46154 - 44032: 0x8A46,
	46155 - 44032: 0x8A47,
	46156 - 44032: 0x8A48,
	46157 - 44032: 0x8A49,
	46158 - 44032: 0x8A4A,
	46159 - 44032: 0x8A4B,
	46160 - 44032: 0xB5CE,
	46161 - 44032: 0xB5CF,
	46162 - 44032: 0x8A4C,
	46163 - 44032: 0x8A4D,
	46164 - 44032: 0xB5D0,
	46165 - 44032: 0x8A4E,
	46166 - 44032: 0x8A4F,
	46167 - 44032: 0x8A50,
	46168 - 44032: 0xB5D1,
	46169 - 44032: 0x8A51,
	46170 - 44032: 0x8A52,
	46171 - 44032: 0x8A53,
	46172 - 44032: 0x8A54,
	46173 - 44032: 0x8A55,
	46174 - 44032: 0x8A56,
	46175 - 44032: 0x8A57,
	46176 - 44032: 0xB5D2,
	46177 - 44032: 0xB5D3,
	46178 - 44032: 0x8A58,
	46179 - 44032: 0xB5D4,
	46180 - 44032: 0x8A59,
	46181 - 44032: 0xB5D5,
	46182 - 44032: 0x8A5A,
	46183 - 44032: 0x8A61,
	46184 - 44032: 0x8A62,
	46185 - 44032: 0x8A63,
	46186 - 44032: 0x8A64,
	46187 - 44032: 0x8A65,
	46188 - 44032: 0xB5D6,
	46189 - 44032: 0x8A66,
	46190 - 44032: 0x8A67,
	46191 - 44032: 0x8A68,
	46192 - 44032: 0x8A69,
	46193 - 44032: 0x8A6A,
	46194 - 44032: 0x8A6B,
	46195 - 44032: 0x8A6C,
	46196 - 44032: 0x8A6D,
	46197 - 44032: 0x8A6E,
	46198 - 44032: 0x8A6F,
	46199 - 44032: 0x8A70,
	46200 - 44032: 0x8A71,
	46201 - 44032: 0x8A72,
	46202 - 44032: 0x8A73,
	46203 - 44032: 0x8A74,
	46204 - 44032: 0x8A75,
	46205 - 44032: 0x8A76,
	46206 - 44032: 0x8A77,
	46207 - 44032: 0x8A78,
	46208 - 44032: 0xB5D7,
	46209 - 44032: 0x8A79,
	46210 - 44032: 0x8A7A,
	46211 - 44032: 0x8A81,
	46212 - 44032: 0x8A82,
	46213 - 44032: 0x8A83,
	46214 - 44032: 0x8A84,
	46215 - 44032: 0x8A85,
	46216 - 44032: 0xB5D8,
	46217 - 44032: 0x8A86,
	46218 - 44032: 0x8A87,
	46219 - 44032: 0x8A88,
	46220 - 44032: 0x8A89,
	46221 - 44032: 0x8A8A,
	46222 - 44032: 0x8A8B,
	46223 - 44032: 0x8A8C,
	46224 - 44032: 0x8A8D,
	46225 - 44032: 0x8A8E,
	46226 - 44032: 0x8A8F,
	46227 - 44032: 0x8A90,
	46228 - 44032: 0x8A91,
	46229 - 44032: 0x8A92,
	46230 - 44032: 0x8A93,
	46231 - 44032: 0x8A94,
	46232 - 44032: 0x8A95,
	46233 - 44032: 0x8A96,
	46234 - 44032: 0x8A97,
	46235 - 44032: 0x8A98,
	46236 - 44032: 0x8A99,
	46237 - 44032: 0xB5D9,
	46238 - 44032: 0x8A9A,
	46239 - 44032: 0x8A9B,
	46240 - 44032: 0x8A9C,
	46241 - 44032: 0x8A9D,
	46242 - 44032: 0x8A9E,
	46243 - 44032: 0x8A9F,
	46244 - 44032: 0xB5DA,
	46245 - 44032: 0x8AA0,
	46246 - 44032: 0x8AA1,
	46247 - 44032: 0x8AA2,
	46248 - 44032: 0xB5DB,
	46249 - 44032: 0x8AA3,
	46250 - 44032: 0x8AA4,
	46251 - 44032: 0x8AA5,
	46252 - 44032: 0xB5DC,
	46253 - 44032: 0x8AA6,
	46254 - 44032: 0x8AA7,
	46255 - 44032: 0x8AA8,
	46256 - 44032: 0x8AA9,
	46257 - 44032: 0x8AAA,
	46258 - 44032: 0x8AAB,
	46259 - 44032: 0x8AAC,
	46260 - 44032: 0x8AAD,
	46261 - 44032: 0xB5DD,
	46262 - 44032: 0x8AAE,
	46263 - 44032: 0xB5DE,
	46264 - 44032: 0x8AAF,
	46265 - 44032: 0xB5DF,
	46266 - 44032: 0x8AB0,
	46267 - 44032: 0x8AB1,
	46268 - 44032: 0x8AB2,
	46269 - 44032: 0x8AB3,
	46270 - 44032: 0x8AB4,
	46271 - 44032: 0x8AB5,
	46272 - 44032: 0xB5E0,
	46273 - 44032: 0x8AB6,
	46274 - 44032: 0x8AB7,
	46275 - 44032: 0x8AB8,
	46276 - 44032: 0xB5E1,
	46277 - 44032: 0x8AB9,
	46278 - 44032: 0x8ABA,
	46279 - 44032: 0x8ABB,
	46280 - 44032: 0xB5E2,
	46281 - 44032: 0x8ABC,
	46282 - 44032: 0x8ABD,
	46283 - 44032: 0x8ABE,
	46284 - 44032: 0x8ABF,
	46285 - 44032: 0x8AC0,
	46286 - 44032: 0x8AC1,
	46287 - 44032: 0x8AC2,
	46288 - 44032: 0xB5E3,
	46289 - 44032: 0x8AC3,
	46290 - 44032: 0x8AC4,
	46291 - 44032: 0x8AC5,
	46292 - 44032: 0x8AC6,
	46293 - 44032: 0xB5E4,
	46294 - 44032: 0x8AC7,
	46295 - 44032: 0x8AC8,
	46296 - 44032: 0x8AC9,
	46297 - 44032: 0x8ACA,
	46298 - 44032: 0x8ACB,
	46299 - 44032: 0x8ACC,
	46300 - 44032: 0xB5E5,
	46301 - 44032: 0xB5E6,
	46302 - 44032: 0x8ACD,
	46303 - 44032: 0x8ACE,
	46304 - 44032: 0xB5E7,
	46305 - 44032: 0x8ACF,
	46306 - 44032: 0x8AD0,
	46307 - 44032: 0xB5E8,
	46308 - 44032: 0xB5E9,
	46309 - 44032: 0x8AD1,
	46310 - 44032: 0xB5EA,
	46311 - 44032: 0x8AD2,
	46312 - 44032: 0x8AD3,
	46313 - 44032: 0x8AD4,
	46314 - 44032: 0x8AD5,
	46315 - 44032: 0x8AD6,
	46316 - 44032: 0xB5EB,
	46317 - 44032: 0xB5EC,
	46318 - 44032: 0x8AD7,
	46319 - 44032: 0xB5ED,
	46320 - 44032: 0x8AD8,
	46321 - 44032: 0xB5EE,
	46322 - 44032: 0x8AD9,
	46323 - 44032: 0x8ADA,
	46324 - 44032: 0x8ADB,
	46325 - 44032: 0x8ADC,
	46326 - 44032: 0x8ADD,
	46327 - 44032: 0x8ADE,
	46328 - 44032: 0xB5EF,
	46329 - 44032: 0x8ADF,
	46330 - 44032: 0x8AE0,
	46331 - 44032: 0x8AE1,
	46332 - 44032: 0x8AE2,
	46333 - 44032: 0x8AE3,
	46334 - 44032: 0x8AE4,
	46335 - 44032: 0x8AE5,
	46336 - 44032: 0x8AE6,
	46337 - 44032: 0x8AE7,
	46338 - 44032: 0x8AE8,
	46339 - 44032: 0x8AE9,
	46340 - 44032: 0x8AEA,
	46341 - 44032: 0x8AEB,
	46342 - 44032: 0x8AEC,
	46343 - 44032: 0x8AED,
	46344 - 44032: 0x8AEE,
	46345 - 44032: 0x8AEF,
	46346 - 44032: 0x8AF0,
	46347 - 44032: 0x8AF1,
	46348 - 44032: 0x8AF2,
	46349 - 44032: 0x8AF3,
	46350 - 44032: 0x8AF4,
	46351 - 44032: 0x8AF5,
	46352 - 44032: 0x8AF6,
	46353 - 44032: 0x8AF7,
	46354 - 44032: 0x8AF8,
	46355 - 44032: 0x8AF9,
	46356 - 44032: 0xB5F0,
	46357 - 44032: 0xB5F1,
	46358 - 44032: 0x8AFA,
	46359 - 44032: 0x8AFB,
	46360 - 44032: 0xB5F2,
	46361 - 44032: 0x8AFC,
	46362 - 44032: 0x8AFD,
	46363 - 44032: 0xB5F3,
	46364 - 44032: 0xB5F4,
	46365 - 44032: 0x8AFE,
	46366 - 44032: 0x8B41,
	46367 - 44032: 0x8B42,
	46368 - 44032: 0x8B43,
	46369 - 44032: 0x8B44,
	46370 - 44032: 0x8B45,
	46371 - 44032: 0x8B46,
	46372 - 44032: 0xB5F5,
	46373 - 44032: 0xB5F6,
	46374 - 44032: 0x8B47,
	46375 - 44032: 0xB5F7,
	46376 - 44032: 0xB5F8,
	46377 - 44032: 0xB5F9,
	46378 - 44032: 0xB5FA,
	46379 - 44032: 0x8B48,
	46380 - 44032: 0x8B49,
	46381 - 44032: 0x8B4A,
	46382 - 44032: 0x8B4B,
	46383 - 44032: 0x8B4C,
	46384 - 44032: 0xB5FB,
	46385 - 44032: 0xB5FC,
	46386 - 44032: 0x8B4D,
	46387 - 44032: 0x8B4E,
	46388 - 44032: 0xB5FD,
	46389 - 44032: 0x8B4F,
	46390 - 44032: 0x8B50,
	46391 - 44032: 0x8B51,
	46392 - 44032: 0xB5FE,
	46393 - 44032: 0x8B52,
	46394 - 44032: 0x8B53,
	46395 - 44032: 0x8B54,
	46396 - 44032: 0x8B55,
	46397 - 44032: 0x8B56,
	46398 - 44032: 0x8B57,
	46399 - 44032: 0x8B58,
	46400 - 44032: 0xB6A1,
	46401 - 44032: 0xB6A2,
	46402 - 44032: 0x8B59,
	46403 - 44032: 0xB6A3,
	46404 - 44032: 0xB6A4,
	46405 - 44032: 0xB6A5,
	46406 - 44032: 0x8B5A,
	46407 - 44032: 0x8B61,
	46408 - 44032: 0x8B62,
	46409 - 44032: 0x8B63,
	46410 - 44032: 0x8B64,
	46411 - 44032: 0xB6A6,
	46412 - 44032: 0xB6A7,
	46413 - 44032: 0xB6A8,
	46414 - 44032: 0x8B65,
	46415 - 44032: 0x8B66,
	46416 - 44032: 0xB6A9,
	46417 - 44032: 0x8B67,
	46418 - 44032: 0x8B68,
	46419 - 44032: 0x8B69,
	46420 - 44032: 0xB6AA,
	46421 - 44032: 0x8B6A,
	46422 - 44032: 0x8B6B,
	46423 - 44032: 0x8B6C,
	46424 - 44032: 0x8B6D,
	46425 - 44032: 0x8B6E,
	46426 - 44032: 0x8B6F,
	46427 - 44032: 0x8B70,
	46428 - 44032: 0xB6AB,
	46429 - 44032: 0xB6AC,
	46430 - 44032: 0x8B71,
	46431 - 44032: 0xB6AD,
	46432 - 44032: 0xB6AE,
	46433 - 44032: 0xB6AF,
	46434 - 44032: 0x8B72,
	46435 - 44032: 0x8B73,
	46436 - 44032: 0x8B74,
	46437 - 44032: 0x8B75,
	46438 - 44032: 0x8B76,
	46439 - 44032: 0x8B77,
	46440 - 44032: 0x8B78,
	46441 - 44032: 0x8B79,
	46442 - 44032: 0x8B7A,
	46443 - 44032: 0x8B81,
	46444 - 44032: 0x8B82,
	46445 - 44032: 0x8B83,
	46446 - 44032: 0x8B84,
	46447 - 44032: 0x8B85,
	46448 - 44032: 0x8B86,
	46449 - 44032: 0x8B87,
	46450 - 44032: 0x8B88,
	46451 - 44032: 0x8B89,
	46452 - 44032: 0x8B8A,
	46453 - 44032: 0x8B8B,
	46454 - 44032: 0x8B8C,
	46455 - 44032: 0x8B8D,
	46456 - 44032: 0x8B8E,
	46457 - 44032: 0x8B8F,
	46458 - 44032: 0x8B90,
	46459 - 44032: 0x8B91,
	46460 - 44032: 0x8B92,
	46461 - 44032: 0x8B93,
	46462 - 44032: 0x8B94,
	46463 - 44032: 0x8B95,
	46464 - 44032: 0x8B96,
	46465 - 44032: 0x8B97,
	46466 - 44032: 0x8B98,
	46467 - 44032: 0x8B99,
	46468 - 44032: 0x8B9A,
	46469 - 44032: 0x8B9B,
	46470 - 44032: 0x8B9C,
	46471 - 44032: 0x8B9D,
	46472 - 44032: 0x8B9E,
	46473 - 44032: 0x8B9F,
	46474 - 44032: 0x8BA0,
	46475 - 44032: 0x8BA1,
	46476 - 44032: 0x8BA2,
	46477 - 44032: 0x8BA3,
	46478 - 44032: 0x8BA4,
	46479 - 44032: 0x8BA5,
	46480 - 44032: 0x8BA6,
	46481 - 44032: 0x8BA7,
	46482 - 44032: 0x8BA8,
	46483 - 44032: 0x8BA9,
	46484 - 44032: 0x8BAA,
	46485 - 44032: 0x8BAB,
	46486 - 44032: 0x8BAC,
	46487 - 44032: 0x8BAD,
	46488 - 44032: 0x8BAE,
	46489 - 44032: 0x8BAF,
	46490 - 44032: 0x8BB0,
	46491 - 44032: 0x8BB1,
	46492 - 44032: 0x8BB2,
	46493 - 44032: 0x8BB3,
	46494 - 44032: 0x8BB4,
	46495 - 44032: 0x8BB5,
	46496 - 44032: 0xB6B0,
	46497 - 44032: 0xB6B1,
	46498 - 44032: 0x8BB6,
	46499 - 44032: 0x8BB7,
	46500 - 44032: 0xB6B2,
	46501 - 44032: 0x8BB8,
	46502 - 44032: 0x8BB9,
	46503 - 44032: 0x8BBA,
	46504 - 44032: 0xB6B3,
	46505 - 44032: 0x8BBB,
	46506 - 44032: 0xB6B4,
	46507 - 44032: 0xB6B5,
	46508 - 44032: 0x8BBC,
	46509 - 44032: 0x8BBD,
	46510 - 44032: 0x8BBE,
	46511 - 44032: 0x8BBF,
	46512 - 44032: 0xB6B6,
	46513 - 44032: 0xB6B7,
	46514 - 44032: 0x8BC0,
	46515 - 44032: 0xB6B8,
	46516 - 44032: 0xB6B9,
	46517 - 44032: 0xB6BA,
	46518 - 44032: 0x8BC1,
	46519 - 44032: 0x8BC2,
	46520 - 44032: 0x8BC3,
	46521 - 44032: 0x8BC4,
	46522 - 44032: 0x8BC5,
	46523 - 44032: 0xB6BB,
	46524 - 44032: 0xB6BC,
	46525 - 44032: 0xB6BD,
	46526 - 44032: 0x8BC6,
	46527 - 44032: 0x8BC7,
	46528 - 44032: 0xB6BE,
	46529 - 44032: 0x8BC8,
	46530 - 44032: 0x8BC9,
	46531 - 44032: 0x8BCA,
	46532 - 44032: 0xB6BF,
	46533 - 44032: 0x8BCB,
	46534 - 44032: 0x8BCC,
	46535 - 44032: 0x8BCD,
	46536 - 44032: 0x8BCE,
	46537 - 44032: 0x8BCF,
	46538 - 44032: 0x8BD0,
	46539 - 44032: 0x8BD1,
	46540 - 44032: 0xB6C0,
	46541 - 44032: 0xB6C1,
	46542 - 44032: 0x8BD2,
	46543 - 44032: 0xB6C2,
	46544 - 44032: 0xB6C3,
	46545 - 44032: 0xB6C4,
	46546 - 44032: 0x8BD3,
	46547 - 44032: 0x8BD4,
	46548 - 44032: 0x8BD5,
	46549 - 44032: 0x8BD6,
	46550 - 44032: 0x8BD7,
	46551 - 44032: 0x8BD8,
	46552 - 44032: 0xB6C5,
	46553 - 44032: 0x8BD9,
	46554 - 44032: 0x8BDA,
	46555 - 44032: 0x8BDB,
	46556 - 44032: 0x8BDC,
	46557 - 44032: 0x8BDD,
	46558 - 44032: 0x8BDE,
	46559 - 44032: 0x8BDF,
	46560 - 44032: 0x8BE0,
	46561 - 44032: 0x8BE1,
	46562 - 44032: 0x8BE2,
	46563 - 44032: 0x8BE3,
	46564 - 44032: 0x8BE4,
	46565 - 44032: 0x8BE5,
	46566 - 44032: 0x8BE6,
	46567 - 44032: 0x8BE7,
	46568 - 44032: 0x8BE8,
	46569 - 44032: 0x8BE9,
	46570 - 44032: 0x8BEA,
	46571 - 44032: 0x8BEB,
	46572 - 44032: 0xB6C6,
	46573 - 44032: 0x8BEC,
	46574 - 44032: 0x8BED,
	46575 - 44032: 0x8BEE,
	46576 - 44032: 0x8BEF,
	46577 - 44032: 0x8BF0,
	46578 - 44032: 0x8BF1,
	46579 - 44032: 0x8BF2,
	46580 - 44032: 0x8BF3,
	46581 - 44032: 0x8BF4,
	46582 - 44032: 0x8BF5,
	46583 - 44032: 0x8BF6,
	46584 - 44032: 0x8BF7,
	46585 - 44032: 0x8BF8,
	46586 - 44032: 0x8BF9,
	46587 - 44032: 0x8BFA,
	46588 - 44032: 0x8BFB,
	46589 - 44032: 0x8BFC,
	46590 - 44032: 0x8BFD,
	46591 - 44032: 0x8BFE,
	46592 - 44032: 0x8C41,
	46593 - 44032: 0x8C42,
	46594 - 44032: 0x8C43,
	46595 - 44032: 0x8C44,
	46596 - 44032: 0x8C45,
	46597 - 44032: 0x8C46,
	46598 - 44032: 0x8C47,
	46599 - 44032: 0x8C48,
	46600 - 44032: 0x8C49,
	46601 - 44032: 0x8C4A,
	46602 - 44032: 0x8C4B,
	46603 - 44032: 0x8C4C,
	46604 - 44032: 0x8C4D,
	46605 - 44032: 0x8C4E,
	46606 - 44032: 0x8C4F,
	46607 - 44032: 0x8C50,
	46608 - 44032: 0xB6C7,
	46609 - 44032: 0xB6C8,
	46610 - 44032: 0x8C51,
	46611 - 44032: 0x8C52,
	46612 - 44032: 0xB6C9,
	46613 - 44032: 0x8C53,
	46614 - 44032: 0x8C54,
	46615 - 44032: 0x8C55,
	46616 - 44032: 0xB6CA,
	46617 - 44032: 0x8C56,
	46618 - 44032: 0x8C57,
	46619 - 44032: 0x8C58,
	46620 - 44032: 0x8C59,
	46621 - 44032: 0x8C5A,
	46622 - 44032: 0x8C61,
	46623 - 44032: 0x8C62,
	46624 - 44032: 0x8C63,
	46625 - 44032: 0x8C64,
	46626 - 44032: 0x8C65,
	46627 - 44032: 0x8C66,
	46628 - 44032: 0x8C67,
	46629 - 44032: 0xB6CB,
	46630 - 44032: 0x8C68,
	46631 - 44032: 0x8C69,
	46632 - 44032: 0x8C6A,
	46633 - 44032: 0x8C6B,
	46634 - 44032: 0x8C6C,
	46635 - 44032: 0x8C6D,
	46636 - 44032: 0xB6CC,
	46637 - 44032: 0x8C6E,
	46638 - 44032: 0x8C6F,
	46639 - 44032: 0x8C70,
	46640 - 44032: 0x8C71,
	46641 - 44032: 0x8C72,
	46642 - 44032: 0x8C73,
	46643 - 44032: 0x8C74,
	46644 - 44032: 0xB6CD,
	46645 - 44032: 0x8C75,
	46646 - 44032: 0x8C76,
	46647 - 44032: 0x8C77,
	46648 - 44032: 0x8C78,
	46649 - 44032: 0x8C79,
	46650 - 44032: 0x8C7A,
	46651 - 44032: 0x8C81,
	46652 - 44032: 0x8C82,
	46653 - 44032: 0x8C83,
	46654 - 44032: 0x8C84,
	46655 - 44032: 0x8C85,
	46656 - 44032: 0x8C86,
	46657 - 44032: 0x8C87,
	46658 - 44032: 0x8C88,
	46659 - 44032: 0x8C89,
	46660 - 44032: 0x8C8A,
	46661 - 44032: 0x8C8B,
	46662 - 44032: 0x8C8C,
	46663 - 44032: 0x8C8D,
	46664 - 44032: 0xB6CE,
	46665 - 44032: 0x8C8E,
	46666 - 44032: 0x8C8F,
	46667 - 44032: 0x8C90,
	46668 - 44032: 0x8C91,
	46669 - 44032: 0x8C92,
	46670 - 44032: 0x8C93,
	46671 - 44032: 0x8C94,
	46672 - 44032: 0x8C95,
	46673 - 44032: 0x8C96,
	46674 - 44032: 0x8C97,
	46675 - 44032: 0x8C98,
	46676 - 44032: 0x8C99,
	46677 - 44032: 0x8C9A,
	46678 - 44032: 0x8C9B,
	46679 - 44032: 0x8C9C,
	46680 - 44032: 0x8C9D,
	46681 - 44032: 0x8C9E,
	46682 - 44032: 0x8C9F,
	46683 - 44032: 0x8CA0,
	46684 - 44032: 0x8CA1,
	46685 - 44032: 0x8CA2,
	46686 - 44032: 0x8CA3,
	46687 - 44032: 0x8CA4,
	46688 - 44032: 0x8CA5,
	46689 - 44032: 0x8CA6,
	46690 - 44032: 0x8CA7,
	46691 - 44032: 0x8CA8,
	46692 - 44032: 0xB6CF,
	46693 - 44032: 0x8CA9,
	46694 - 44032: 0x8CAA,
	46695 - 44032: 0x8CAB,
	46696 - 44032: 0xB6D0,
	46697 - 44032: 0x8CAC,
	46698 - 44032: 0x8CAD,
	46699 - 44032: 0x8CAE,
	46700 - 44032: 0x8CAF,
	46701 - 44032: 0x8CB0,
	46702 - 44032: 0x8CB1,
	46703 - 44032: 0x8CB2,
	46704 - 44032: 0x8CB3,
	46705 - 44032: 0x8CB4,
	46706 - 44032: 0x8CB5,
	46707 - 44032: 0x8CB6,
	46708 - 44032: 0x8CB7,
	46709 - 44032: 0x8CB8,
	46710 - 44032: 0x8CB9,
	46711 - 44032: 0x8CBA,
	46712 - 44032: 0x8CBB,
	46713 - 44032: 0x8CBC,
	46714 - 44032: 0x8CBD,
	46715 - 44032: 0x8CBE,
	46716 - 44032: 0x8CBF,
	46717 - 44032: 0x8CC0,
	46718 - 44032: 0x8CC1,
	46719 - 44032: 0x8CC2,
	46720 - 44032: 0x8CC3,
	46721 - 44032: 0x8CC4,
	46722 - 44032: 0x8CC5,
	46723 - 44032: 0x8CC6,
	46724 - 44032: 0x8CC7,
	46725 - 44032: 0x8CC8,
	46726 - 44032: 0x8CC9,
	46727 - 44032: 0x8CCA,
	46728 - 44032: 0x8CCB,
	46729 - 44032: 0x8CCC,
	46730 - 44032: 0x8CCD,
	46731 - 44032: 0x8CCE,
	46732 - 44032: 0x8CCF,
	46733 - 44032: 0x8CD0,
	46734 - 44032: 0x8CD1,
	46735 - 44032: 0x8CD2,
	46736 - 44032: 0x8CD3,
	46737 - 44032: 0x8CD4,
	46738 - 44032: 0x8CD5,
	46739 - 44032: 0x8CD6,
	46740 - 44032: 0x8CD7,
	46741 - 44032: 0x8CD8,
	46742 - 44032: 0x8CD9,
	46743 - 44032: 0x8CDA,
	46744 - 44032: 0x8CDB,
	46745 - 44032: 0x8CDC,
	46746 - 44032: 0x8CDD,
	46747 - 44032: 0x8CDE,
	46748 - 44032: 0xB6D1,
	46749 - 44032: 0xB6D2,
	46750 - 44032: 0x8CDF,
	46751 - 44032: 0x8CE0,
	46752 - 44032: 0xB6D3,
	46753 - 44032: 0x8CE1,
	46754 - 44032: 0x8CE2,
	46755 - 44032: 0x8CE3,
	46756 - 44032: 0xB6D4,
	46757 - 44032: 0x8CE4,
	46758 - 44032: 0x8CE5,
	46759 - 44032: 0x8CE6,
	46760 - 44032: 0x8CE7,
	46761 - 44032: 0x8CE8,
	46762 - 44032: 0x8CE9,
	46763 - 44032: 0xB6D5,
	46764 - 44032: 0xB6D6,
	46765 - 44032: 0x8CEA,
	46766 - 44032: 0x8CEB,
	46767 - 44032: 0x8CEC,
	46768 - 44032: 0x8CED,
	46769 - 44032: 0xB6D7,
	46770 - 44032: 0x8CEE,
	46771 - 44032: 0x8CEF,
	46772 - 44032: 0x8CF0,
	46773 - 44032: 0x8CF1,
	46774 - 44032: 0x8CF2,
	46775 - 44032: 0x8CF3,
	46776 - 44032: 0x8CF4,
	46777 - 44032: 0x8CF5,
	46778 - 44032: 0x8CF6,
	46779 - 44032: 0x8CF7,
	46780 - 44032: 0x8CF8,
	46781 - 44032: 0x8CF9,
	46782 - 44032: 0x8CFA,
	46783 - 44032: 0x8CFB,
	46784 - 44032: 0x8CFC,
	46785 - 44032: 0x8CFD,
	46786 - 44032: 0x8CFE,
	46787 - 44032: 0x8D41,
	46788 - 44032: 0x8D42,
	46789 - 44032: 0x8D43,
	46790 - 44032: 0x8D44,
	46791 - 44032: 0x8D45,
	46792 - 44032: 0x8D46,
	46793 - 44032: 0x8D47,
	46794 - 44032: 0x8D48,
	46795 - 44032: 0x8D49,
	46796 - 44032: 0x8D4A,
	46797 - 44032: 0x8D4B,
	46798 - 44032: 0x8D4C,
	46799 - 44032: 0x8D4D,
	46800 - 44032: 0x8D4E,
	46801 - 44032: 0x8D4F,
	46802 - 44032: 0x8D50,
	46803 - 44032: 0x8D51,
	46804 - 44032: 0xB6D8,
	46805 - 44032: 0x8D52,
	46806 - 44032: 0x8D53,
	46807 - 44032: 0x8D54,
	46808 - 44032: 0x8D55,
	46809 - 44032: 0x8D56,
	46810 - 44032: 0x8D57,
	46811 - 44032: 0x8D58,
	46812 - 44032: 0x8D59,
	46813 - 44032: 0x8D5A,
	46814 - 44032: 0x8D61,
	46815 - 44032: 0x8D62,
	46816 - 44032: 0x8D63,
	46817 - 44032: 0x8D64,
	46818 - 44032: 0x8D65,
	46819 - 44032: 0x8D66,
	46820 - 44032: 0x8D67,
	46821 - 44032: 0x8D68,
	46822 - 44032: 0x8D69,
	46823 - 44032: 0x8D6A,
	46824 - 44032: 0x8D6B,
	46825 - 44032: 0x8D6C,
	46826 - 44032: 0x8D6D,
	46827 - 44032: 0x8D6E,
	46828 - 44032: 0x8D6F,
	46829 - 44032: 0x8D70,
	46830 - 44032: 0x8D71,
	46831 - 44032: 0x8D72,
	46832 - 44032: 0xB6D9,
	46833 - 44032: 0x8D73,
	46834 - 44032: 0x8D74,
	46835 - 44032: 0x8D75,
	46836 - 44032: 0xB6DA,
	46837 - 44032: 0x8D76,
	46838 - 44032: 0x8D77,
	46839 - 44032: 0x8D78,
	46840 - 44032: 0xB6DB,
	46841 - 44032: 0x8D79,
	46842 - 44032: 0x8D7A,
	46843 - 44032: 0x8D81,
	46844 - 44032: 0x8D82,
	46845 - 44032: 0x8D83,
	46846 - 44032: 0x8D84,
	46847 - 44032: 0x8D85,
	46848 - 44032: 0xB6DC,
	46849 - 44032: 0xB6DD,
	46850 - 44032: 0x8D86,
	46851 - 44032: 0x8D87,
	46852 - 44032: 0x8D88,
	46853 - 44032: 0xB6DE,
	46854 - 44032: 0x8D89,
	46855 - 44032: 0x8D8A,
	46856 - 44032: 0x8D8B,
	46857 - 44032: 0x8D8C,
	46858 - 44032: 0x8D8D,
	46859 - 44032: 0x8D8E,
	46860 - 44032: 0x8D8F,
	46861 - 44032: 0x8D90,
	46862 - 44032: 0x8D91,
	46863 - 44032: 0x8D92,
	46864 - 44032: 0x8D93,
	46865 - 44032: 0x8D94,
	46866 - 44032: 0x8D95,
	46867 - 44032: 0x8D96,
	46868 - 44032: 0x8D97,
	46869 - 44032: 0x8D98,
	46870 - 44032: 0x8D99,
	46871 - 44032: 0x8D9A,
	46872 - 44032: 0x8D9B,
	46873 - 44032: 0x8D9C,
	46874 - 44032: 0x8D9D,
	46875 - 44032: 0x8D9E,
	46876 - 44032: 0x8D9F,
	46877 - 44032: 0x8DA0,
	46878 - 44032: 0x8DA1,
	46879 - 44032: 0x8DA2,
	46880 - 44032: 0x8DA3,
	46881 - 44032: 0x8DA4,
	46882 - 44032: 0x8DA5,
	46883 - 44032: 0x8DA6,
	46884 - 44032: 0x8DA7,
	46885 - 44032: 0x8DA8,
	46886 - 44032: 0x8DA9,
	46887 - 44032: 0x8DAA,
	46888 - 44032: 0xB6DF,
	46889 - 44032: 0xB6E0,
	46890 - 44032: 0x8DAB,
	46891 - 44032: 0x8DAC,
	46892 - 44032: 0xB6E1,
	46893 - 44032: 0x8DAD,
	46894 - 44032: 0x8DAE,
	46895 - 44032: 0xB6E2,
	46896 - 44032: 0xB6E3,
	46897 - 44032: 0x8DAF,
	46898 - 44032: 0x8DB0,
	46899 - 44032: 0x8DB1,
	46900 - 44032: 0x8DB2,
	46901 - 44032: 0x8DB3,
	46902 - 44032: 0x8DB4,
	46903 - 44032: 0x8DB5,
	46904 - 44032: 0xB6E4,
	46905 - 44032: 0xB6E5,
	46906 - 44032: 0x8DB6,
	46907 - 44032: 0xB6E6,
	46908 - 44032: 0x8DB7,
	46909 - 44032: 0x8DB8,
	46910 - 44032: 0x8DB9,
	46911 - 44032: 0x8DBA,
	46912 - 44032: 0x8DBB,
	46913 - 44032: 0x8DBC,
	46914 - 44032: 0x8DBD,
	46915 - 44032: 0x8DBE,
	46916 - 44032: 0xB6E7,
	46917 - 44032: 0x8DBF,
	46918 - 44032: 0x8DC0,
	46919 - 44032: 0x8DC1,
	46920 - 44032: 0xB6E8,
	46921 - 44032: 0x8DC2,
	46922 - 44032: 0x8DC3,
	46923 - 44032: 0x8DC4,
	46924 - 44032: 0xB6E9,
	46925 - 44032: 0x8DC5,
	46926 - 44032: 0x8DC6,
	46927 - 44032: 0x8DC7,
	46928 - 44032: 0x8DC8,
	46929 - 44032: 0x8DC9,
	46930 - 44032: 0x8DCA,
	46931 - 44032: 0x8DCB,
	46932 - 44032: 0xB6EA,
	46933 - 44032: 0xB6EB,
	46934 - 44032: 0x8DCC,
	46935 - 44032: 0x8DCD,
	46936 - 44032: 0x8DCE,
	46937 - 44032: 0x8DCF,
	46938 - 44032: 0x8DD0,
	46939 - 44032: 0x8DD1,
	46940 - 44032: 0x8DD2,
	46941 - 44032: 0x8DD3,
	46942 - 44032: 0x8DD4,
	46943 - 44032: 0x8DD5,
	46944 - 44032: 0xB6EC,
	46945 - 44032: 0x8DD6,
	46946 - 44032: 0x8DD7,
	46947 - 44032: 0x8DD8,
	46948 - 44032: 0xB6ED,
	46949 - 44032: 0x8DD9,
	46950 - 44032: 0x8DDA,
	46951 - 44032: 0x8DDB,
	46952 - 44032: 0xB6EE,
	46953 - 44032: 0x8DDC,
	46954 - 44032: 0x8DDD,
	46955 - 44032: 0x8DDE,
	46956 - 44032: 0x8DDF,
	46957 - 44032: 0x8DE0,
	46958 - 44032: 0x8DE1,
	46959 - 44032: 0x8DE2,
	46960 - 44032: 0xB6EF,
	46961 - 44032: 0xB6F0,
	46962 - 44032: 0x8DE3,
	46963 - 44032: 0xB6F1,
	46964 - 44032: 0x8DE4,
	46965 - 44032: 0xB6F2,
	46966 - 44032: 0x8DE5,
	46967 - 44032: 0x8DE6,
	46968 - 44032: 0x8DE7,
	46969 - 44032: 0x8DE8,
	46970 - 44032: 0x8DE9,
	46971 - 44032: 0x8DEA,
	46972 - 44032: 0xB6F3,
	46973 - 44032: 0xB6F4,
	46974 - 44032: 0x8DEB,
	46975 - 44032: 0x8DEC,
	46976 - 44032: 0xB6F5,
	46977 - 44032: 0x8DED,
	46978 - 44032: 0x8DEE,
	46979 - 44032: 0x8DEF,
	46980 - 44032: 0xB6F6,
	46981 - 44032: 0x8DF0,
	46982 - 44032: 0x8DF1,
	46983 - 44032: 0x8DF2,
	46984 - 44032: 0x8DF3,
	46985 - 44032: 0x8DF4,
	46986 - 44032: 0x8DF5,
	46987 - 44032: 0x8DF6,
	46988 - 44032: 0xB6F7,
	46989 - 44032: 0xB6F8,
	46990 - 44032: 0x8DF7,
	46991 - 44032: 0xB6F9,
	46992 - 44032: 0xB6FA,
	46993 - 44032: 0xB6FB,
	46994 - 44032: 0xB6FC,
	46995 - 44032: 0x8DF8,
	46996 - 44032: 0x8DF9,
	46997 - 44032: 0x8DFA,
	46998 - 44032: 0xB6FD,
	46999 - 44032: 0xB6FE,
	47000 - 44032: 0xB7A1,
	47001 - 44032: 0xB7A2,
	47002 - 44032: 0x8DFB,
	47003 - 44032: 0x8DFC,
	47004 - 44032: 0xB7A3,
	47005 - 44032: 0x8DFD,
	47006 - 44032: 0x8DFE,
	47007 - 44032: 0x8E41,
	47008 - 44032: 0xB7A4,
	47009 - 44032: 0x8E42,
	47010 - 44032: 0x8E43,
	47011 - 44032: 0x8E44,
	47012 - 44032: 0x8E45,
	47013 - 44032: 0x8E46,
	47014 - 44032: 0x8E47,
	47015 - 44032: 0x8E48,
	47016 - 44032: 0xB7A5,
	47017 - 44032: 0xB7A6,
	47018 - 44032: 0x8E49,
	47019 - 44032: 0xB7A7,
	47020 - 44032: 0xB7A8,
	47021 - 44032: 0xB7A9,
	47022 - 44032: 0x8E4A,
	47023 - 44032: 0x8E4B,
	47024 - 44032: 0x8E4C,
	47025 - 44032: 0x8E4D,
	47026 - 44032: 0x8E4E,
	47027 - 44032: 0x8E4F,
	47028 - 44032: 0xB7AA,
	47029 - 44032: 0xB7AB,
	47030 - 44032: 0x8E50,
	47031 - 44032: 0x8E51,
	47032 - 44032: 0xB7AC,
	47033 - 44032: 0x8E52,
	47034 - 44032: 0x8E53,
	47035 - 44032: 0x8E54,
	47036 - 44032: 0x8E55,
	47037 - 44032: 0x8E56,
	47038 - 44032: 0x8E57,
	47039 - 44032: 0x8E58,
	47040 - 44032: 0x8E59,
	47041 - 44032: 0x8E5A,
	47042 - 44032: 0x8E61,
	47043 - 44032: 0x8E62,
	47044 - 44032: 0x8E63,
	47045 - 44032: 0x8E64,
	47046 - 44032: 0x8E65,
	47047 - 44032: 0xB7AD,
	47048 - 44032: 0x8E66,
	47049 - 44032: 0xB7AE,
	47050 - 44032: 0x8E67,
	47051 - 44032: 0x8E68,
	47052 - 44032: 0x8E69,
	47053 - 44032: 0x8E6A,
	47054 - 44032: 0x8E6B,
	47055 - 44032: 0x8E6C,
	47056 - 44032: 0x8E6D,
	47057 - 44032: 0x8E6E,
	47058 - 44032: 0x8E6F,
	47059 - 44032: 0x8E70,
	47060 - 44032: 0x8E71,
	47061 - 44032: 0x8E72,
	47062 - 44032: 0x8E73,
	47063 - 44032: 0x8E74,
	47064 - 44032: 0x8E75,
	47065 - 44032: 0x8E76,
	47066 - 44032: 0x8E77,
	47067 - 44032: 0x8E78,
	47068 - 44032: 0x8E79,
	47069 - 44032: 0x8E7A,
	47070 - 44032: 0x8E81,
	47071 - 44032: 0x8E82,
	47072 - 44032: 0x8E83,
	47073 - 44032: 0x8E84,
	47074 - 44032: 0x8E85,
	47075 - 44032: 0x8E86,
	47076 - 44032: 0x8E87,
	47077 - 44032: 0x8E88,
	47078 - 44032: 0x8E89,
	47079 - 44032: 0x8E8A,
	47080 - 44032: 0x8E8B,
	47081 - 44032: 0x8E8C,
	47082 - 44032: 0x8E8D,
	47083 - 44032: 0x8E8E,
	47084 - 44032: 0xB7AF,
	47085 - 44032: 0xB7B0,
	47086 - 44032: 0x8E8F,
	47087 - 44032: 0x8E90,
	47088 - 44032: 0xB7B1,
	47089 - 44032: 0x8E91,
	47090 - 44032: 0x8E92,
	47091 - 44032: 0x8E93,
	47092 - 44032: 0xB7B2,
	47093 - 44032: 0x8E94,
	47094 - 44032: 0x8E95,
	47095 - 44032: 0x8E96,
	47096 - 44032: 0x8E97,
	47097 - 44032: 0x8E98,
	47098 - 44032: 0x8E99,
	47099 - 44032: 0x8E9A,
	47100 - 44032: 0xB7B3,
	47101 - 44032: 0xB7B4,
	47102 - 44032: 0x8E9B,
	47103 - 44032: 0xB7B5,
	47104 - 44032: 0xB7B6,
	47105 - 44032: 0xB7B7,
	47106 - 44032: 0x8E9C,
	47107 - 44032: 0x8E9D,
	47108 - 44032: 0x8E9E,
	47109 - 44032: 0x8E9F,
	47110 - 44032: 0x8EA0,
	47111 - 44032: 0xB7B8,
	47112 - 44032: 0xB7B9,
	47113 - 44032: 0xB7BA,
	47114 - 44032: 0x8EA1,
	47115 - 44032: 0x8EA2,
	47116 - 44032: 0xB7BB,
	47117 - 44032: 0x8EA3,
	47118 - 44032: 0x8EA4,
	47119 - 44032: 0x8EA5,
	47120 - 44032: 0xB7BC,
	47121 - 44032: 0x8EA6,
	47122 - 44032: 0x8EA7,
	47123 - 44032: 0x8EA8,
	47124 - 44032: 0x8EA9,
	47125 - 44032: 0x8EAA,
	47126 - 44032: 0x8EAB,
	47127 - 44032: 0x8EAC,
	47128 - 44032: 0xB7BD,
	47129 - 44032: 0xB7BE,
	47130 - 44032: 0x8EAD,
	47131 - 44032: 0xB7BF,
	47132 - 44032: 0x8EAE,
	47133 - 44032: 0xB7C0,
	47134 - 44032: 0x8EAF,
	47135 - 44032: 0x8EB0,
	47136 - 44032: 0x8EB1,
	47137 - 44032: 0x8EB2,
	47138 - 44032: 0x8EB3,
	47139 - 44032: 0x8EB4,
	47140 - 44032: 0xB7C1,
	47141 - 44032: 0xB7C2,
	47142 - 44032: 0x8EB5,
	47143 - 44032: 0x8EB6,
	47144 - 44032: 0xB7C3,
	47145 - 44032: 0x8EB7,
	47146 - 44032: 0x8EB8,
	47147 - 44032: 0x8EB9,
	47148 - 44032: 0xB7C4,
	47149 - 44032: 0x8EBA,
	47150 - 44032: 0x8EBB,
	47151 - 44032: 0x8EBC,
	47152 - 44032: 0x8EBD,
	47153 - 44032: 0x8EBE,
	47154 - 44032: 0x8EBF,
	47155 - 44032: 0x8EC0,
	47156 - 44032: 0xB7C5,
	47157 - 44032: 0xB7C6,
	47158 - 44032: 0x8EC1,
	47159 - 44032: 0xB7C7,
	47160 - 44032: 0xB7C8,
	47161 - 44032: 0xB7C9,
	47162 - 44032: 0x8EC2,
	47163 - 44032: 0x8EC3,
	47164 - 44032: 0x8EC4,
	47165 - 44032: 0x8EC5,
	47166 - 44032: 0x8EC6,
	47167 - 44032: 0x8EC7,
	47168 - 44032: 0xB7CA,
	47169 - 44032: 0x8EC8,
	47170 - 44032: 0x8EC9,
	47171 - 44032: 0x8ECA,
	47172 - 44032: 0xB7CB,
	47173 - 44032: 0x8ECB,
	47174 - 44032: 0x8ECC,
	47175 - 44032: 0x8ECD,
	47176 - 44032: 0x8ECE,
	47177 - 44032: 0x8ECF,
	47178 - 44032: 0x8ED0,
	47179 - 44032: 0x8ED1,
	47180 - 44032: 0x8ED2,
	47181 - 44032: 0x8ED3,
	47182 - 44032: 0x8ED4,
	47183 - 44032: 0x8ED5,
	47184 - 44032: 0x8ED6,
	47185 - 44032: 0xB7CC,
	47186 - 44032: 0x8ED7,
	47187 - 44032: 0xB7CD,
	47188 - 44032: 0x8ED8,
	47189 - 44032: 0x8ED9,
	47190 - 44032: 0x8EDA,
	47191 - 44032: 0x8EDB,
	47192 - 44032: 0x8EDC,
	47193 - 44032: 0x8EDD,
	47194 - 44032: 0x8EDE,
	47195 - 44032: 0x8EDF,
	47196 - 44032: 0xB7CE,
	47197 - 44032: 0xB7CF,
	47198 - 44032: 0x8EE0,
	47199 - 44032: 0x8EE1,
	47200 - 44032: 0xB7D0,
	47201 - 44032: 0x8EE2,
	47202 - 44032: 0x8EE3,
	47203 - 44032: 0x8EE4,
	47204 - 44032: 0xB7D1,
	47205 - 44032: 0x8EE5,
	47206 - 44032: 0x8EE6,
	47207 - 44032: 0x8EE7,
	47208 - 44032: 0x8EE8,
	47209 - 44032: 0x8EE9,
	47210 - 44032: 0x8EEA,
	47211 - 44032: 0x8EEB,
	47212 - 44032: 0xB7D2,
	47213 - 44032: 0xB7D3,
	47214 - 44032: 0x8EEC,
	47215 - 44032: 0xB7D4,
	47216 - 44032: 0x8EED,
	47217 - 44032: 0xB7D5,
	47218 - 44032: 0x8EEE,
	47219 - 44032: 0x8EEF,
	47220 - 44032: 0x8EF0,
	47221 - 44032: 0x8EF1,
	47222 - 44032: 0x8EF2,
	47223 - 44032: 0x8EF3,
	47224 - 44032: 0xB7D6,
	47225 - 44032: 0x8EF4,
	47226 - 44032: 0x8EF5,
	47227 - 44032: 0x8EF6,
	47228 - 44032: 0xB7D7,
	47229 - 44032: 0x8EF7,
	47230 - 44032: 0x8EF8,
	47231 - 44032: 0x8EF9,
	47232 - 44032: 0x8EFA,
	47233 - 44032: 0x8EFB,
	47234 - 44032: 0x8EFC,
	47235 - 44032: 0x8EFD,
	47236 - 44032: 0x8EFE,
	47237 - 44032: 0x8F41,
	47238 - 44032: 0x8F42,
	47239 - 44032: 0x8F43,
	47240 - 44032: 0x8F44,
	47241 - 44032: 0x8F45,
	47242 - 44032: 0x8F46,
	47243 - 44032: 0x8F47,
	47244 - 44032: 0x8F48,
	47245 - 44032: 0xB7D8,
	47246 - 44032: 0x8F49,
	47247 - 44032: 0x8F4A,
	47248 - 44032: 0x8F4B,
	47249 - 44032: 0x8F4C,
	47250 - 44032: 0x8F4D,
	47251 - 44032: 0x8F4E,
	47252 - 44032: 0x8F4F,
	47253 - 44032: 0x8F50,
	47254 - 44032: 0x8F51,
	47255 - 44032: 0x8F52,
	47256 - 44032: 0x8F53,
	47257 - 44032: 0x8F54,
	47258 - 44032: 0x8F55,
	47259 - 44032: 0x8F56,
	47260 - 44032: 0x8F57,
	47261 - 44032: 0x8F58,
	47262 - 44032: 0x8F59,
	47263 - 44032: 0x8F5A,
	47264 - 44032: 0x8F61,
	47265 - 44032: 0x8F62,
	47266 - 44032: 0x8F63,
	47267 - 44032: 0x8F64,
	47268 - 44032: 0x8F65,
	47269 - 44032: 0x8F66,
	47270 - 44032: 0x8F67,
	47271 - 44032: 0x8F68,
	47272 - 44032: 0xB7D9,
	47273 - 44032: 0x8F69,
	47274 - 44032: 0x8F6A,
	47275 - 44032: 0x8F6B,
	47276 - 44032: 0x8F6C,
	47277 - 44032: 0x8F6D,
	47278 - 44032: 0x8F6E,
	47279 - 44032: 0x8F6F,
	47280 - 44032: 0xB7DA,
	47281 - 44032: 0x8F70,
	47282 - 44032: 0x8F71,
	47283 - 44032: 0x8F72,
	47284 - 44032: 0xB7DB,
	47285 - 44032: 0x8F73,
	47286 - 44032: 0x8F74,
	47287 - 44032: 0x8F75,
	47288 - 44032: 0xB7DC,
	47289 - 44032: 0x8F76,
	47290 - 44032: 0x8F77,
	47291 - 44032: 0x8F78,
	47292 - 44032: 0x8F79,
	47293 - 44032: 0x8F7A,
	47294 - 44032: 0x8F81,
	47295 - 44032: 0x8F82,
	47296 - 44032: 0xB7DD,
	47297 - 44032: 0xB7DE,
	47298 - 44032: 0x8F83,
	47299 - 44032: 0xB7DF,
	47300 - 44032: 0x8F84,
	47301 - 44032: 0xB7E0,
	47302 - 44032: 0x8F85,
	47303 - 44032: 0x8F86,
	47304 - 44032: 0x8F87,
	47305 - 44032: 0x8F88,
	47306 - 44032: 0x8F89,
	47307 - 44032: 0x8F8A,
	47308 - 44032: 0xB7E1,
	47309 - 44032: 0x8F8B,
	47310 - 44032: 0x8F8C,
	47311 - 44032: 0x8F8D,
	47312 - 44032: 0xB7E2,
	47313 - 44032: 0x8F8E,
	47314 - 44032: 0x8F8F,
	47315 - 44032: 0x8F90,
	47316 - 44032: 0xB7E3,
	47317 - 44032: 0x8F91,
	47318 - 44032: 0x8F92,
	47319 - 44032: 0x8F93,
	47320 - 44032: 0x8F94,
	47321 - 44032: 0x8F95,
	47322 - 44032: 0x8F96,
	47323 - 44032: 0x8F97,
	47324 - 44032: 0x8F98,
	47325 - 44032: 0xB7E4,
	47326 - 44032: 0x8F99,
	47327 - 44032: 0xB7E5,
	47328 - 44032: 0x8F9A,
	47329 - 44032: 0xB7E6,
	47330 - 44032: 0x8F9B,
	47331 - 44032: 0x8F9C,
	47332 - 44032: 0x8F9D,
	47333 - 44032: 0x8F9E,
	47334 - 44032: 0x8F9F,
	47335 - 44032: 0x8FA0,
	47336 - 44032: 0xB7E7,
	47337 - 44032: 0xB7E8,
	47338 - 44032: 0x8FA1,
	47339 - 44032: 0x8FA2,
	47340 - 44032: 0xB7E9,
	47341 - 44032: 0x8FA3,
	47342 - 44032: 0x8FA4,
	47343 - 44032: 0x8FA5,
	47344 - 44032: 0xB7EA,
	47345 - 44032: 0x8FA6,
	47346 - 44032: 0x8FA7,
	47347 - 44032: 0x8FA8,
	47348 - 44032: 0x8FA9,
	47349 - 44032: 0x8FAA,
	47350 - 44032: 0x8FAB,
	47351 - 44032: 0x8FAC,
	47352 - 44032: 0xB7EB,
	47353 - 44032: 0xB7EC,
	47354 - 44032: 0x8FAD,
	47355 - 44032: 0xB7ED,
	47356 - 44032: 0x8FAE,
	47357 - 44032: 0xB7EE,
	47358 - 44032: 0x8FAF,
	47359 - 44032: 0x8FB0,
	47360 - 44032: 0x8FB1,
	47361 - 44032: 0x8FB2,
	47362 - 44032: 0x8FB3,
	47363 - 44032: 0x8FB4,
	47364 - 44032: 0xB7EF,
	47365 - 44032: 0x8FB5,
	47366 - 44032: 0x8FB6,
	47367 - 44032: 0x8FB7,
	47368 - 44032: 0x8FB8,
	47369 - 44032: 0x8FB9,
	47370 - 44032: 0x8FBA,
	47371 - 44032: 0x8FBB,
	47372 - 44032: 0x8FBC,
	47373 - 44032: 0x8FBD,
	47374 - 44032: 0x8FBE,
	47375 - 44032: 0x8FBF,
	47376 - 44032: 0x8FC0,
	47377 - 44032: 0x8FC1,
	47378 - 44032: 0x8FC2,
	47379 - 44032: 0x8FC3,
	47380 - 44032: 0x8FC4,
	47381 - 44032: 0x8FC5,
	47382 - 44032: 0x8FC6,
	47383 - 44032: 0x8FC7,
	47384 - 44032: 0xB7F0,
	47385 - 44032: 0x8FC8,
	47386 - 44032: 0x8FC9,
	47387 - 44032: 0x8FCA,
	47388 - 44032: 0x8FCB,
	47389 - 44032: 0x8FCC,
	47390 - 44032: 0x8FCD,
	47391 - 44032: 0x8FCE,
	47392 - 44032: 0xB7F1,
	47393 - 44032: 0x8FCF,
	47394 - 44032: 0x8FD0,
	47395 - 44032: 0x8FD1,
	47396 - 44032: 0x8FD2,
	47397 - 44032: 0x8FD3,
	47398 - 44032: 0x8FD4,
	47399 - 44032: 0x8FD5,
	47400 - 44032: 0x8FD6,
	47401 - 44032: 0x8FD7,
	47402 - 44032: 0x8FD8,
	47403 - 44032: 0x8FD9,
	47404 - 44032: 0x8FDA,
	47405 - 44032: 0x8FDB,
	47406 - 44032: 0x8FDC,
	47407 - 44032: 0x8FDD,
	47408 - 44032: 0x8FDE,
	47409 - 44032: 0x8FDF,
	47410 - 44032: 0x8FE0,
	47411 - 44032: 0x8FE1,
	47412 - 44032: 0x8FE2,
	47413 - 44032: 0x8FE3,
	47414 - 44032: 0x8FE4,
	47415 - 44032: 0x8FE5,
	47416 - 44032: 0x8FE6,
	47417 - 44032: 0x8FE7,
	47418 - 44032: 0x8FE8,
	47419 - 44032: 0x8FE9,
	47420 - 44032: 0xB7F2,
	47421 - 44032: 0xB7F3,
	47422 - 44032: 0x8FEA,
	47423 - 44032: 0x8FEB,
	47424 - 44032: 0xB7F4,
	47425 - 44032: 0x8FEC,
	47426 - 44032: 0x8FED,
	47427 - 44032: 0x8FEE,
	47428 - 44032: 0xB7F5,
	47429 - 44032: 0x8FEF,
	47430 - 44032: 0x8FF0,
	47431 - 44032: 0x8FF1,
	47432 - 44032: 0x8FF2,
	47433 - 44032: 0x8FF3,
	47434 - 44032: 0x8FF4,
	47435 - 44032: 0x8FF5,
	47436 - 44032: 0xB7F6,
	47437 - 44032: 0x8FF6,
	47438 - 44032: 0x8FF7,
	47439 - 44032: 0xB7F7,
	47440 - 44032: 0x8FF8,
	47441 - 44032: 0xB7F8,
	47442 - 44032: 0x8FF9,
	47443 - 44032: 0x8FFA,
	47444 - 44032: 0x8FFB,
	47445 - 44032: 0x8FFC,
	47446 - 44032: 0x8FFD,
	47447 - 44032: 0x8FFE,
	47448 - 44032: 0xB7F9,
	47449 - 44032: 0xB7FA,
	47450 - 44032: 0x9041,
	47451 - 44032: 0x9042,
	47452 - 44032: 0xB7FB,
	47453 - 44032: 0x9043,
	47454 - 44032: 0x9044,
	47455 - 44032: 0x9045,
	47456 - 44032: 0xB7FC,
	47457 - 44032: 0x9046,
	47458 - 44032: 0x9047,
	47459 - 44032: 0x9048,
	47460 - 44032: 0x9049,
	47461 - 44032: 0x904A,
	47462 - 44032: 0x904B,
	47463 - 44032: 0x904C,
	47464 - 44032: 0xB7FD,
	47465 - 44032: 0xB7FE,
	47466 - 44032: 0x904D,
	47467 - 44032: 0xB8A1,
	47468 - 44032: 0x904E,
	47469 - 44032: 0xB8A2,
	47470 - 44032: 0x904F,
	47471 - 44032: 0x9050,
	47472 - 44032: 0x9051,
	47473 - 44032: 0x9052,
	47474 - 44032: 0x9053,
	47475 - 44032: 0x9054,
	47476 - 44032: 0xB8A3,
	47477 - 44032: 0xB8A4,
	47478 - 44032: 0x9055,
	47479 - 44032: 0x9056,
	47480 - 44032: 0xB8A5,
	47481 - 44032: 0x9057,
	47482 - 44032: 0x9058,
	47483 - 44032: 0x9059,
	47484 - 44032: 0xB8A6,
	47485 - 44032: 0x905A,
	47486 - 44032: 0x9061,
	47487 - 44032: 0x9062,
	47488 - 44032: 0x9063,
	47489 - 44032: 0x9064,
	47490 - 44032: 0x9065,
	47491 - 44032: 0x9066,
	47492 - 44032: 0xB8A7,
	47493 - 44032: 0xB8A8,
	47494 - 44032: 0x9067,
	47495 - 44032: 0xB8A9,
	47496 - 44032: 0x9068,
	47497 - 44032: 0xB8AA,
	47498 - 44032: 0xB8AB,
	47499 - 44032: 0x9069,
	47500 - 44032: 0x906A,
	47501 - 44032: 0xB8AC,
	47502 - 44032: 0xB8AD,
	47503 - 44032: 0x906B,
	47504 - 44032: 0x906C,
	47505 - 44032: 0x906D,
	47506 - 44032: 0x906E,
	47507 - 44032: 0x906F,
	47508 - 44032: 0x9070,
	47509 - 44032: 0x9071,
	47510 - 44032: 0x9072,
	47511 - 44032: 0x9073,
	47512 - 44032: 0x9074,
	47513 - 44032: 0x9075,
	47514 - 44032: 0x9076,
	47515 - 44032: 0x9077,
	47516 - 44032: 0x9078,
	47517 - 44032: 0x9079,
	47518 - 44032: 0x907A,
	47519 - 44032: 0x9081,
	47520 - 44032: 0x9082,
	47521 - 44032: 0x9083,
	47522 - 44032: 0x9084,
	47523 - 44032: 0x9085,
	47524 - 44032: 0x9086,
	47525 - 44032: 0x9087,
	47526 - 44032: 0x9088,
	47527 - 44032: 0x9089,
	47528 - 44032: 0x908A,
	47529 - 44032: 0x908B,
	47530 - 44032: 0x908C,
	47531 - 44032: 0x908D,
	47532 - 44032: 0xB8AE,
	47533 - 44032: 0xB8AF,
	47534 - 44032: 0x908E,
	47535 - 44032: 0x908F,
	47536 - 44032: 0xB8B0,
	47537 - 44032: 0x9090,
	47538 - 44032: 0x9091,
	47539 - 44032: 0x9092,
	47540 - 44032: 0xB8B1,
	47541 - 44032: 0x9093,
	47542 - 44032: 0x9094,
	47543 - 44032: 0x9095,
	47544 - 44032: 0x9096,
	47545 - 44032: 0x9097,
	47546 - 44032: 0x9098,
	47547 - 44032: 0x9099,
	47548 - 44032: 0xB8B2,
	47549 - 44032: 0xB8B3,
	47550 - 44032: 0x909A,
	47551 - 44032: 0xB8B4,
	47552 - 44032: 0x909B,
	47553 - 44032: 0xB8B5,
	47554 - 44032: 0x909C,
	47555 - 44032: 0x909D,
	47556 - 44032: 0x909E,
	47557 - 44032: 0x909F,
	47558 - 44032: 0x90A0,
	47559 - 44032: 0x90A1,
	47560 - 44032: 0xB8B6,
	47561 - 44032: 0xB8B7,
	47562 - 44032: 0x90A2,
	47563 - 44032: 0x90A3,
	47564 - 44032: 0xB8B8,
	47565 - 44032: 0x90A4,
	47566 - 44032: 0xB8B9,
	47567 - 44032: 0xB8BA,
	47568 - 44032: 0xB8BB,
	47569 - 44032: 0xB8BC,
	47570 - 44032: 0xB8BD,
	47571 - 44032: 0x90A5,
	47572 - 44032: 0x90A6,
	47573 - 44032: 0x90A7,
	47574 - 44032: 0x90A8,
	47575 - 44032: 0x90A9,
	47576 - 44032: 0xB8BE,
	47577 - 44032: 0xB8BF,
	47578 - 44032: 0x90AA,
	47579 - 44032: 0xB8C0,
	47580 - 44032: 0x90AB,
	47581 - 44032: 0xB8C1,
	47582 - 44032: 0xB8C2,
	47583 - 44032: 0x90AC,
	47584 - 44032: 0x90AD,
	47585 - 44032: 0xB8C3,
	47586 - 44032: 0x90AE,
	47587 - 44032: 0xB8C4,
	47588 - 44032: 0xB8C5,
	47589 - 44032: 0xB8C6,
	47590 - 44032: 0x90AF,
	47591 - 44032: 0x90B0,
	47592 - 44032: 0xB8C7,
	47593 - 44032: 0x90B1,
	47594 - 44032: 0x90B2,
	47595 - 44032: 0x90B3,
	47596 - 44032: 0xB8C8,
	47597 - 44032: 0x90B4,
	47598 - 44032: 0x90B5,
	47599 - 44032: 0x90B6,
	47600 - 44032: 0x90B7,
	47601 - 44032: 0x90B8,
	47602 - 44032: 0x90B9,
	47603 - 44032: 0x90BA,
	47604 - 44032: 0xB8C9,
	47605 - 44032: 0xB8CA,
	47606 - 44032: 0x90BB,
	47607 - 44032: 0xB8CB,
	47608 - 44032: 0xB8CC,
	47609 - 44032: 0xB8CD,
	47610 - 44032: 0xB8CE,
	47611 - 44032: 0x90BC,
	47612 - 44032: 0x90BD,
	47613 - 44032: 0x90BE,
	47614 - 44032: 0x90BF,
	47615 - 44032: 0x90C0,
	47616 - 44032: 0xB8CF,
	47617 - 44032: 0xB8D0,
	47618 - 44032: 0x90C1,
	47619 - 44032: 0x90C2,
	47620 - 44032: 0x90C3,
	47621 - 44032: 0x90C4,
	47622 - 44032: 0x90C5,
	47623 - 44032: 0x90C6,
	47624 - 44032: 0xB8D1,
	47625 - 44032: 0x90C7,
	47626 - 44032: 0x90C8,
	47627 - 44032: 0x90C9,
	47628 - 44032: 0x90CA,
	47629 - 44032: 0x90CB,
	47630 - 44032: 0x90CC,
	47631 - 44032: 0x90CD,
	47632 - 44032: 0x90CE,
	47633 - 44032: 0x90CF,
	47634 - 44032: 0x90D0,
	47635 - 44032: 0x90D1,
	47636 - 44032: 0x90D2,
	47637 - 44032: 0xB8D2,
	47638 - 44032: 0x90D3,
	47639 - 44032: 0x90D4,
	47640 - 44032: 0x90D5,
	47641 - 44032: 0x90D6,
	47642 - 44032: 0x90D7,
	47643 - 44032: 0x90D8,
	47644 - 44032: 0x90D9,
	47645 - 44032: 0x90DA,
	47646 - 44032: 0x90DB,
	47647 - 44032: 0x90DC,
	47648 - 44032: 0x90DD,
	47649 - 44032: 0x90DE,
	47650 - 44032: 0x90DF,
	47651 - 44032: 0x90E0,
	47652 - 44032: 0x90E1,
	47653 - 44032: 0x90E2,
	47654 - 44032: 0x90E3,
	47655 - 44032: 0x90E4,
	47656 - 44032: 0x90E5,
	47657 - 44032: 0x90E6,
	47658 - 44032: 0x90E7,
	47659 - 44032: 0x90E8,
	47660 - 44032: 0x90E9,
	47661 - 44032: 0x90EA,
	47662 - 44032: 0x90EB,
	47663 - 44032: 0x90EC,
	47664 - 44032: 0x90ED,
	47665 - 44032: 0x90EE,
	47666 - 44032: 0x90EF,
	47667 - 44032: 0x90F0,
	47668 - 44032: 0x90F1,
	47669 - 44032: 0x90F2,
	47670 - 44032: 0x90F3,
	47671 - 44032: 0x90F4,
	47672 - 44032: 0xB8D3,
	47673 - 44032: 0xB8D4,
	47674 - 44032: 0x90F5,
	47675 - 44032: 0x90F6,
	47676 - 44032: 0xB8D5,
	47677 - 44032: 0x90F7,
	47678 - 44032: 0x90F8,
	47679 - 44032: 0x90F9,
	47680 - 44032: 0xB8D6,
	47681 - 44032: 0x90FA,
	47682 - 44032: 0xB8D7,
	47683 - 44032: 0x90FB,
	47684 - 44032: 0x90FC,
	47685 - 44032: 0x90FD,
	47686 - 44032: 0x90FE,
	47687 - 44032: 0x9141,
	47688 - 44032: 0xB8D8,
	47689 - 44032: 0xB8D9,
	47690 - 44032: 0x9142,
	47691 - 44032: 0xB8DA,
	47692 - 44032: 0x9143,
	47693 - 44032: 0xB8DB,
	47694 - 44032: 0xB8DC,
	47695 - 44032: 0x9144,
	47696 - 44032: 0x9145,
	47697 - 44032: 0x9146,
	47698 - 44032: 0x9147,
	47699 - 44032: 0xB8DD,
	47700 - 44032: 0xB8DE,
	47701 - 44032: 0xB8DF,
	47702 - 44032: 0x9148,
	47703 - 44032: 0x9149,
	47704 - 44032: 0xB8E0,
	47705 - 44032: 0x914A,
	47706 - 44032: 0x914B,
	47707 - 44032: 0x914C,
	47708 - 44032: 0xB8E1,
	47709 - 44032: 0x914D,
	47710 - 44032: 0x914E,
	47711 - 44032: 0x914F,
	47712 - 44032: 0x9150,
	47713 - 44032: 0x9151,
	47714 - 44032: 0x9152,
	47715 - 44032: 0x9153,
	47716 - 44032: 0xB8E2,
	47717 - 44032: 0xB8E3,
	47718 - 44032: 0x9154,
	47719 - 44032: 0xB8E4,
	47720 - 44032: 0xB8E5,
	47721 - 44032: 0xB8E6,
	47722 - 44032: 0x9155,
	47723 - 44032: 0x9156,
	47724 - 44032: 0x9157,
	47725 - 44032: 0x9158,
	47726 - 44032: 0x9159,
	47727 - 44032: 0x915A,
	47728 - 44032: 0xB8E7,
	47729 - 44032: 0xB8E8,
	47730 - 44032: 0x9161,
	47731 - 44032: 0x9162,
	47732 - 44032: 0xB8E9,
	47733 - 44032: 0x9163,
	47734 - 44032: 0x9164,
	47735 - 44032: 0x9165,
	47736 - 44032: 0xB8EA,
	47737 - 44032: 0x9166,
	47738 - 44032: 0x9167,
	47739 - 44032: 0x9168,
	47740 - 44032: 0x9169,
	47741 - 44032: 0x916A,
	47742 - 44032: 0x916B,
	47743 - 44032: 0x916C,
	47744 - 44032: 0x916D,
	47745 - 44032: 0x916E,
	47746 - 44032: 0x916F,
	47747 - 44032: 0xB8EB,
	47748 - 44032: 0xB8EC,
	47749 - 44032: 0xB8ED,
	47750 - 44032: 0x9170,
	47751 - 44032: 0xB8EE,
	47752 - 44032: 0x9171,
	47753 - 44032: 0x9172,
	47754 - 44032: 0x9173,
	47755 - 44032: 0x9174,
	47756 - 44032: 0xB8EF,
	47757 - 44032: 0x9175,
	47758 - 44032: 0x9176,
	47759 - 44032: 0x9177,
	47760 - 44032: 0x9178,
	47761 - 44032: 0x9179,
	47762 - 44032: 0x917A,
	47763 - 44032: 0x9181,
	47764 - 44032: 0x9182,
	47765 - 44032: 0x9183,
	47766 - 44032: 0x9184,
	47767 - 44032: 0x9185,
	47768 - 44032: 0x9186,
	47769 - 44032: 0x9187,
	47770 - 44032: 0x9188,
	47771 - 44032: 0x9189,
	47772 - 44032: 0x918A,
	47773 - 44032: 0x918B,
	47774 - 44032: 0x918C,
	47775 - 44032: 0x918D,
	47776 - 44032: 0x918E,
	47777 - 44032: 0x918F,
	47778 - 44032: 0x9190,
	47779 - 44032: 0x9191,
	47780 - 44032: 0x9192,
	47781 - 44032: 0x9193,
	47782 - 44032: 0x9194,
	47783 - 44032: 0x9195,
	47784 - 44032: 0xB8F0,
	47785 - 44032: 0xB8F1,
	47786 - 44032: 0x9196,
	47787 - 44032: 0xB8F2,
	47788 - 44032: 0xB8F3,
	47789 - 44032: 0x9197,
	47790 - 44032: 0x9198,
	47791 - 44032: 0x9199,
	47792 - 44032: 0xB8F4,
	47793 - 44032: 0x919A,
	47794 - 44032: 0xB8F5,
	47795 - 44032: 0x919B,
	47796 - 44032: 0x919C,
	47797 - 44032: 0x919D,
	47798 - 44032: 0x919E,
	47799 - 44032: 0x919F,
	47800 - 44032: 0xB8F6,
	47801 - 44032: 0xB8F7,
	47802 - 44032: 0x91A0,
	47803 - 44032: 0xB8F8,
	47804 - 44032: 0x91A1,
	47805 - 44032: 0xB8F9,
	47806 - 44032: 0x91A2,
	47807 - 44032: 0x91A3,
	47808 - 44032: 0x91A4,
	47809 - 44032: 0x91A5,
	47810 - 44032: 0x91A6,
	47811 - 44032: 0x91A7,
	47812 - 44032: 0xB8FA,
	47813 - 44032: 0x91A8,
	47814 - 44032: 0x91A9,
	47815 - 44032: 0x91AA,
	47816 - 44032: 0xB8FB,
	47817 - 44032: 0x91AB,
	47818 - 44032: 0x91AC,
	47819 - 44032: 0x91AD,
	47820 - 44032: 0x91AE,
	47821 - 44032: 0x91AF,
	47822 - 44032: 0x91B0,
	47823 - 44032: 0x91B1,
	47824 - 44032: 0x91B2,
	47825 - 44032: 0x91B3,
	47826 - 44032: 0x91B4,
	47827 - 44032: 0x91B5,
	47828 - 44032: 0x91B6,
	47829 - 44032: 0x91B7,
	47830 - 44032: 0x91B8,
	47831 - 44032: 0x91B9,
	47832 - 44032: 0xB8FC,
	47833 - 44032: 0xB8FD,
	47834 - 44032: 0x91BA,
	47835 - 44032: 0x91BB,
	47836 - 44032: 0x91BC,
	47837 - 44032: 0x91BD,
	47838 - 44032: 0x91BE,
	47839 - 44032: 0x91BF,
	47840 - 44032: 0x91C0,
	47841 - 44032: 0x91C1,
	47842 - 44032: 0x91C2,
	47843 - 44032: 0x91C3,
	47844 - 44032: 0x91C4,
	47845 - 44032: 0x91C5,
	47846 - 44032: 0x91C6,
	47847 - 44032: 0x91C7,
	47848 - 44032: 0x91C8,
	47849 - 44032: 0x91C9,
	47850 - 44032: 0x91CA,
	47851 - 44032: 0x91CB,
	47852 - 44032: 0x91CC,
	47853 - 44032: 0x91CD,
	47854 - 44032: 0x91CE,
	47855 - 44032: 0x91CF,
	47856 - 44032: 0x91D0,
	47857 - 44032: 0x91D1,
	47858 - 44032: 0x91D2,
	47859 - 44032: 0x91D3,
	47860 - 44032: 0x91D4,
	47861 - 44032: 0x91D5,
	47862 - 44032: 0x91D6,
	47863 - 44032: 0x91D7,
	47864 - 44032: 0x91D8,
	47865 - 44032: 0x91D9,
	47866 - 44032: 0x91DA,
	47867 - 44032: 0x91DB,
	47868 - 44032: 0xB8FE,
	47869 - 44032: 0x91DC,
	47870 - 44032: 0x91DD,
	47871 - 44032: 0x91DE,
	47872 - 44032: 0xB9A1,
	47873 - 44032: 0x91DF,
	47874 - 44032: 0x91E0,
	47875 - 44032: 0x91E1,
	47876 - 44032: 0xB9A2,
	47877 - 44032: 0x91E2,
	47878 - 44032: 0x91E3,
	47879 - 44032: 0x91E4,
	47880 - 44032: 0x91E5,
	47881 - 44032: 0x91E6,
	47882 - 44032: 0x91E7,
	47883 - 44032: 0x91E8,
	47884 - 44032: 0x91E9,
	47885 - 44032: 0xB9A3,
	47886 - 44032: 0x91EA,
	47887 - 44032: 0xB9A4,
	47888 - 44032: 0x91EB,
	47889 - 44032: 0xB9A5,
	47890 - 44032: 0x91EC,
	47891 - 44032: 0x91ED,
	47892 - 44032: 0x91EE,
	47893 - 44032: 0x91EF,
	47894 - 44032: 0x91F0,
	47895 - 44032: 0x91F1,
	47896 - 44032: 0xB9A6,
	47897 - 44032: 0x91F2,
	47898 - 44032: 0x91F3,
	47899 - 44032: 0x91F4,
	47900 - 44032: 0xB9A7,
	47901 - 44032: 0x91F5,
	47902 - 44032: 0x91F6,
	47903 - 44032: 0x91F7,
	47904 - 44032: 0xB9A8,
	47905 - 44032: 0x91F8,
	47906 - 44032: 0x91F9,
	47907 - 44032: 0x91FA,
	47908 - 44032: 0x91FB,
	47909 - 44032: 0x91FC,
	47910 - 44032: 0x91FD,
	47911 - 44032: 0x91FE,
	47912 - 44032: 0x9241,
	47913 - 44032: 0xB9A9,
	47914 - 44032: 0x9242,
	47915 - 44032: 0xB9AA,
	47916 - 44032: 0x9243,
	47917 - 44032: 0x9244,
	47918 - 44032: 0x9245,
	47919 - 44032: 0x9246,
	47920 - 44032: 0x9247,
	47921 - 44032: 0x9248,
	47922 - 44032: 0x9249,
	47923 - 44032: 0x924A,
	47924 - 44032: 0xB9AB,
	47925 - 44032: 0xB9AC,
	47926 - 44032: 0xB9AD,
	47927 - 44032: 0x924B,
	47928 - 44032: 0xB9AE,
	47929 - 44032: 0x924C,
	47930 - 44032: 0x924D,
	47931 - 44032: 0xB9AF,
	47932 - 44032: 0xB9B0,
	47933 - 44032: 0xB9B1,
	47934 - 44032: 0xB9B2,
	47935 - 44032: 0x924E,
	47936 - 44032: 0x924F,
	47937 - 44032: 0x9250,
	47938 - 44032: 0x9251,
	47939 - 44032: 0x9252,
	47940 - 44032: 0xB9B3,
	47941 - 44032: 0xB9B4,
	47942 - 44032: 0x9253,
	47943 - 44032: 0xB9B5,
	47944 - 44032: 0x9254,
	47945 - 44032: 0xB9B6,
	47946 - 44032: 0x9255,
	47947 - 44032: 0x9256,
	47948 - 44032: 0x9257,
	47949 - 44032: 0xB9B7,
	47950 - 44032: 0x9258,
	47951 - 44032: 0xB9B8,
	47952 - 44032: 0xB9B9,
	47953 - 44032: 0x9259,
	47954 - 44032: 0x925A,
	47955 - 44032: 0x9261,
	47956 - 44032: 0xB9BA,
	47957 - 44032: 0x9262,
	47958 - 44032: 0x9263,
	47959 - 44032: 0x9264,
	47960 - 44032: 0xB9BB,
	47961 - 44032: 0x9265,
	47962 - 44032: 0x9266,
	47963 - 44032: 0x9267,
	47964 - 44032: 0x9268,
	47965 - 44032: 0x9269,
	47966 - 44032: 0x926A,
	47967 - 44032: 0x926B,
	47968 - 44032: 0x926C,
	47969 - 44032: 0xB9BC,
	47970 - 44032: 0x926D,
	47971 - 44032: 0xB9BD,
	47972 - 44032: 0x926E,
	47973 - 44032: 0x926F,
	47974 - 44032: 0x9270,
	47975 - 44032: 0x9271,
	47976 - 44032: 0x9272,
	47977 - 44032: 0x9273,
	47978 - 44032: 0x9274,
	47979 - 44032: 0x9275,
	47980 - 44032: 0xB9BE,
	47981 - 44032: 0x9276,
	47982 - 44032: 0x9277,
	47983 - 44032: 0x9278,
	47984 - 44032: 0x9279,
	47985 - 44032: 0x927A,
	47986 - 44032: 0x9281,
	47987 - 44032: 0x9282,
	47988 - 44032: 0x9283,
	47989 - 44032: 0x9284,
	47990 - 44032: 0x9285,
	47991 - 44032: 0x9286,
	47992 - 44032: 0x9287,
	47993 - 44032: 0x9288,
	47994 - 44032: 0x9289,
	47995 - 44032: 0x928A,
	47996 - 44032: 0x928B,
	47997 - 44032: 0x928C,
	47998 - 44032: 0x928D,
	47999 - 44032: 0x928E,
	48000 - 44032: 0x928F,
	48001 - 44032: 0x9290,
	48002 - 44032: 0x9291,
	48003 - 44032: 0x9292,
	48004 - 44032: 0x9293,
	48005 - 44032: 0x9294,
	48006 - 44032: 0x9295,
	48007 - 44032: 0x9296,
	48008 - 44032: 0xB9BF,
	48009 - 44032: 0x9297,
	48010 - 44032: 0x9298,
	48011 - 44032: 0x9299,
	48012 - 44032: 0xB9C0,
	48013 - 44032: 0x929A,
	48014 - 44032: 0x929B,
	48015 - 44032: 0x929C,
	48016 - 44032: 0xB9C1,
	48017 - 44032: 0x929D,
	48018 - 44032: 0x929E,
	48019 - 44032: 0x929F,
	48020 - 44032: 0x92A0,
	48021 - 44032: 0x92A1,
	48022 - 44032: 0x92A2,
	48023 - 44032: 0x92A3,
	48024 - 44032: 0x92A4,
	48025 - 44032: 0x92A5,
	48026 - 44032: 0x92A6,
	48027 - 44032: 0x92A7,
	48028 - 44032: 0x92A8,
	48029 - 44032: 0x92A9,
	48030 - 44032: 0x92AA,
	48031 - 44032: 0x92AB,
	48032 - 44032: 0x92AC,
	48033 - 44032: 0x92AD,
	48034 - 44032: 0x92AE,
	48035 - 44032: 0x92AF,
	48036 - 44032: 0xB9C2,
	48037 - 44032: 0x92B0,
	48038 - 44032: 0x92B1,
	48039 - 44032: 0x92B2,
	48040 - 44032: 0xB9C3,
	48041 - 44032: 0x92B3,
	48042 - 44032: 0x92B4,
	48043 - 44032: 0x92B5,
	48044 - 44032: 0xB9C4,
	48045 - 44032: 0x92B6,
	48046 - 44032: 0x92B7,
	48047 - 44032: 0x92B8,
	48048 - 44032: 0x92B9,
	48049 - 44032: 0x92BA,
	48050 - 44032: 0x92BB,
	48051 - 44032: 0x92BC,
	48052 - 44032: 0xB9C5,
	48053 - 44032: 0x92BD,
	48054 - 44032: 0x92BE,
	48055 - 44032: 0xB9C6,
	48056 - 44032: 0x92BF,
	48057 - 44032: 0x92C0,
	48058 - 44032: 0x92C1,
	48059 - 44032: 0x92C2,
	48060 - 44032: 0x92C3,
	48061 - 44032: 0x92C4,
	48062 - 44032: 0x92C5,
	48063 - 44032: 0x92C6,
	48064 - 44032: 0xB9C7,
	48065 - 44032: 0x92C7,
	48066 - 44032: 0x92C8,
	48067 - 44032: 0x92C9,
	48068 - 44032: 0xB9C8,
	48069 - 44032: 0x92CA,
	48070 - 44032: 0x92CB,
	48071 - 44032: 0x92CC,
	48072 - 44032: 0xB9C9,
	48073 - 44032: 0x92CD,
	48074 - 44032: 0x92CE,
	48075 - 44032: 0x92CF,
	48076 - 44032: 0x92D0,
	48077 - 44032: 0x92D1,
	48078 - 44032: 0x92D2,
	48079 - 44032: 0x92D3,
	48080 - 44032: 0xB9CA,
	48081 - 44032: 0x92D4,
	48082 - 44032: 0x92D5,
	48083 - 44032: 0xB9CB,
	48084 - 44032: 0x92D6,
	48085 - 44032: 0x92D7,
	48086 - 44032: 0x92D8,
	48087 - 44032: 0x92D9,
	48088 - 44032: 0x92DA,
	48089 - 44032: 0x92DB,
	48090 - 44032: 0x92DC,
	48091 - 44032: 0x92DD,
	48092 - 44032: 0x92DE,
	48093 - 44032: 0x92DF,
	48094 - 44032: 0x92E0,
	48095 - 44032: 0x92E1,
	48096 - 44032: 0x92E2,
	48097 - 44032: 0x92E3,
	48098 - 44032: 0x92E4,
	48099 - 44032: 0x92E5,
	48100 - 44032: 0x92E6,
	48101 - 44032: 0x92E7,
	48102 - 44032: 0x92E8,
	48103 - 44032: 0x92E9,
	48104 - 44032: 0x92EA,
	48105 - 44032: 0x92EB,
	48106 - 44032: 0x92EC,
	48107 - 44032: 0x92ED,
	48108 - 44032: 0x92EE,
	48109 - 44032: 0x92EF,
	48110 - 44032: 0x92F0,
	48111 - 44032: 0x92F1,
	48112 - 44032: 0x92F2,
	48113 - 44032: 0x92F3,
	48114 - 44032: 0x92F4,
	48115 - 44032: 0x92F5,
	48116 - 44032: 0x92F6,
	48117 - 44032: 0x92F7,
	48118 - 44032: 0x92F8,
	48119 - 44032: 0x92F9,
	48120 - 44032: 0xB9CC,
	48121 - 44032: 0xB9CD,
	48122 - 44032: 0x92FA,
	48123 - 44032: 0x92FB,
	48124 - 44032: 0xB9CE,
	48125 - 44032: 0x92FC,
	48126 - 44032: 0x92FD,
	48127 - 44032: 0xB9CF,
	48128 - 44032: 0xB9D0,
	48129 - 44032: 0x92FE,
	48130 - 44032: 0xB9D1,
	48131 - 44032: 0x9341,
	48132 - 44032: 0x9342,
	48133 - 44032: 0x9343,
	48134 - 44032: 0x9344,
	48135 - 44032: 0x9345,
	48136 - 44032: 0xB9D2,
	48137 - 44032: 0xB9D3,
	48138 - 44032: 0x9346,
	48139 - 44032: 0xB9D4,
	48140 - 44032: 0xB9D5,
	48141 - 44032: 0xB9D6,
	48142 - 44032: 0x9347,
	48143 - 44032: 0xB9D7,
	48144 - 44032: 0x9348,
	48145 - 44032: 0xB9D8,
	48146 - 44032: 0x9349,
	48147 - 44032: 0x934A,
	48148 - 44032: 0xB9D9,
	48149 - 44032: 0xB9DA,
	48150 - 44032: 0xB9DB,
	48151 - 44032: 0xB9DC,
	48152 - 44032: 0xB9DD,
	48153 - 44032: 0x934B,
	48154 - 44032: 0x934C,
	48155 - 44032: 0xB9DE,
	48156 - 44032: 0xB9DF,
	48157 - 44032: 0xB9E0,
	48158 - 44032: 0xB9E1,
	48159 - 44032: 0xB9E2,
	48160 - 44032: 0x934D,
	48161 - 44032: 0x934E,
	48162 - 44032: 0x934F,
	48163 - 44032: 0x9350,
	48164 - 44032: 0xB9E3,
	48165 - 44032: 0xB9E4,
	48166 - 44032: 0x9351,
	48167 - 44032: 0xB9E5,
	48168 - 44032: 0x9352,
	48169 - 44032: 0xB9E6,
	48170 - 44032: 0x9353,
	48171 - 44032: 0x9354,
	48172 - 44032: 0x9355,
	48173 - 44032: 0xB9E7,
	48174 - 44032: 0x9356,
	48175 - 44032: 0x9357,
	48176 - 44032: 0xB9E8,
	48177 - 44032: 0xB9E9,
	48178 - 44032: 0x9358,
	48179 - 44032: 0x9359,
	48180 - 44032: 0xB9EA,
	48181 - 44032: 0x935A,
	48182 - 44032: 0x9361,
	48183 - 44032: 0x9362,
	48184 - 44032: 0xB9EB,
	48185 - 44032: 0x9363,
	48186 - 44032: 0x9364,
	48187 - 44032: 0x9365,
	48188 - 44032: 0x9366,
	48189 - 44032: 0x9367,
	48190 - 44032: 0x9368,
	48191 - 44032: 0x9369,
	48192 - 44032: 0xB9EC,
	48193 - 44032: 0xB9ED,
	48194 - 44032: 0x936A,
	48195 - 44032: 0xB9EE,
	48196 - 44032: 0xB9EF,
	48197 - 44032: 0xB9F0,
	48198 - 44032: 0x936B,
	48199 - 44032: 0x936C,
	48200 - 44032: 0x936D,
	48201 - 44032: 0xB9F1,
	48202 - 44032: 0x936E,
	48203 - 44032: 0x936F,
	48204 - 44032: 0xB9F2,
	48205 - 44032: 0xB9F3,
	48206 - 44032: 0x9370,
	48207 - 44032: 0x9371,
	48208 - 44032: 0xB9F4,
	48209 - 44032: 0x9372,
	48210 - 44032: 0x9373,
	48211 - 44032: 0x9374,
	48212 - 44032: 0x9375,
	48213 - 44032: 0x9376,
	48214 - 44032: 0x9377,
	48215 - 44032: 0x9378,
	48216 - 44032: 0x9379,
	48217 - 44032: 0x937A,
	48218 - 44032: 0x9381,
	48219 - 44032: 0x9382,
	48220 - 44032: 0x9383,
	48221 - 44032: 0xB9F5,
	48222 - 44032: 0x9384,
	48223 - 44032: 0x9385,
	48224 - 44032: 0x9386,
	48225 - 44032: 0x9387,
	48226 - 44032: 0x9388,
	48227 - 44032: 0x9389,
	48228 - 44032: 0x938A,
	48229 - 44032: 0x938B,
	48230 - 44032: 0x938C,
	48231 - 44032: 0x938D,
	48232 - 44032: 0x938E,
	48233 - 44032: 0x938F,
	48234 - 44032: 0x9390,
	48235 - 44032: 0x9391,
	48236 - 44032: 0x9392,
	48237 - 44032: 0x9393,
	48238 - 44032: 0x9394,
	48239 - 44032: 0x9395,
	48240 - 44032: 0x9396,
	48241 - 44032: 0x9397,
	48242 - 44032: 0x9398,
	48243 - 44032: 0x9399,
	48244 - 44032: 0x939A,
	48245 - 44032: 0x939B,
	48246 - 44032: 0x939C,
	48247 - 44032: 0x939D,
	48248 - 44032: 0x939E,
	48249 - 44032: 0x939F,
	48250 - 44032: 0x93A0,
	48251 - 44032: 0x93A1,
	48252 - 44032: 0x93A2,
	48253 - 44032: 0x93A3,
	48254 - 44032: 0x93A4,
	48255 - 44032: 0x93A5,
	48256 - 44032: 0x93A6,
	48257 - 44032: 0x93A7,
	48258 - 44032: 0x93A8,
	48259 - 44032: 0x93A9,
	48260 - 44032: 0xB9F6,
	48261 - 44032: 0xB9F7,
	48262 - 44032: 0x93AA,
	48263 - 44032: 0x93AB,
	48264 - 44032: 0xB9F8,
	48265 - 44032: 0x93AC,
	48266 - 44032: 0x93AD,
	48267 - 44032: 0xB9F9,
	48268 - 44032: 0xB9FA,
	48269 - 44032: 0x93AE,
	48270 - 44032: 0xB9FB,
	48271 - 44032: 0x93AF,
	48272 - 44032: 0x93B0,
	48273 - 44032: 0x93B1,
	48274 - 44032: 0x93B2,
	48275 - 44032: 0x93B3,
	48276 - 44032: 0xB9FC,
	48277 - 44032: 0xB9FD,
	48278 - 44032: 0x93B4,
	48279 - 44032: 0xB9FE,
	48280 - 44032: 0x93B5,
	48281 - 44032: 0xBAA1,
	48282 - 44032: 0xBAA2,
	48283 - 44032: 0x93B6,
	48284 - 44032: 0x93B7,
	48285 - 44032: 0x93B8,
	48286 - 44032: 0x93B9,
	48287 - 44032: 0x93BA,
	48288 - 44032: 0xBAA3,
	48289 - 44032: 0xBAA4,
	48290 - 44032: 0x93BB,
	48291 - 44032: 0x93BC,
	48292 - 44032: 0xBAA5,
	48293 - 44032: 0x93BD,
	48294 - 44032: 0x93BE,
	48295 - 44032: 0xBAA6,
	48296 - 44032: 0xBAA7,
	48297 - 44032: 0x93BF,
	48298 - 44032: 0x93C0,
	48299 - 44032: 0x93C1,
	48300 - 44032: 0x93C2,
	48301 - 44032: 0x93C3,
	48302 - 44032: 0x93C4,
	48303 - 44032: 0x93C5,
	48304 - 44032: 0xBAA8,
	48305 - 44032: 0xBAA9,
	48306 - 44032: 0x93C6,
	48307 - 44032: 0xBAAA,
	48308 - 44032: 0xBAAB,
	48309 - 44032: 0xBAAC,
	48310 - 44032: 0x93C7,
	48311 - 44032: 0x93C8,
	48312 - 44032: 0x93C9,
	48313 - 44032: 0x93CA,
	48314 - 44032: 0x93CB,
	48315 - 44032: 0x93CC,
	48316 - 44032: 0xBAAD,
	48317 - 44032: 0xBAAE,
	48318 - 44032: 0x93CD,
	48319 - 44032: 0x93CE,
	48320 - 44032: 0xBAAF,
	48321 - 44032: 0x93CF,
	48322 - 44032: 0x93D0,
	48323 - 44032: 0x93D1,
	48324 - 44032: 0xBAB0,
	48325 - 44032: 0x93D2,
	48326 - 44032: 0x93D3,
	48327 - 44032: 0x93D4,
	48328 - 44032: 0x93D5,
	48329 - 44032: 0x93D6,
	48330 - 44032: 0x93D7,
	48331 - 44032: 0x93D8,
	48332 - 44032: 0x93D9,
	48333 - 44032: 0xBAB1,
	48334 - 44032: 0x93DA,
	48335 - 44032: 0xBAB2,
	48336 - 44032: 0xBAB3,
	48337 - 44032: 0xBAB4,
	48338 - 44032: 0x93DB,
	48339 - 44032: 0x93DC,
	48340 - 44032: 0x93DD,
	48341 - 44032: 0xBAB5,
	48342 - 44032: 0x93DE,
	48343 - 44032: 0x93DF,
	48344 - 44032: 0xBAB6,
	48345 - 44032: 0x93E0,
	48346 - 44032: 0x93E1,
	48347 - 44032: 0x93E2,
	48348 - 44032: 0xBAB7,
	48349 - 44032: 0x93E3,
	48350 - 44032: 0x93E4,
	48351 - 44032: 0x93E5,
	48352 - 44032: 0x93E6,
	48353 - 44032: 0x93E7,
	48354 - 44032: 0x93E8,
	48355 - 44032: 0x93E9,
	48356 - 44032: 0x93EA,
	48357 - 44032: 0x93EB,
	48358 - 44032: 0x93EC,
	48359 - 44032: 0x93ED,
	48360 - 44032: 0x93EE,
	48361 - 44032: 0x93EF,
	48362 - 44032: 0x93F0,
	48363 - 44032: 0x93F1,
	48364 - 44032: 0x93F2,
	48365 - 44032: 0x93F3,
	48366 - 44032: 0x93F4,
	48367 - 44032: 0x93F5,
	48368 - 44032: 0x93F6,
	48369 - 44032: 0x93F7,
	48370 - 44032: 0x93F8,
	48371 - 44032: 0x93F9,
	48372 - 44032: 0xBAB8,
	48373 - 44032: 0xBAB9,
	48374 - 44032: 0xBABA,
	48375 - 44032: 0x93FA,
	48376 - 44032: 0xBABB,
	48377 - 44032: 0x93FB,
	48378 - 44032: 0x93FC,
	48379 - 44032: 0x93FD,
	48380 - 44032: 0xBABC,
	48381 - 44032: 0x93FE,
	48382 - 44032: 0x9441,
	48383 - 44032: 0x9442,
	48384 - 44032: 0x9443,
	48385 - 44032: 0x9444,
	48386 - 44032: 0x9445,
	48387 - 44032: 0x9446,
	48388 - 44032: 0xBABD,
	48389 - 44032: 0xBABE,
	48390 - 44032: 0x9447,
	48391 - 44032: 0xBABF,
	48392 - 44032: 0x9448,
	48393 - 44032: 0xBAC0,
	48394 - 44032: 0x9449,
	48395 - 44032: 0x944A,
	48396 - 44032: 0x944B,
	48397 - 44032: 0x944C,
	48398 - 44032: 0x944D,
	48399 - 44032: 0x944E,
	48400 - 44032: 0xBAC1,
	48401 - 44032: 0x944F,
	48402 - 44032: 0x9450,
	48403 - 44032: 0x9451,
	48404 - 44032: 0xBAC2,
	48405 - 44032: 0x9452,
	48406 - 44032: 0x9453,
	48407 - 44032: 0x9454,
	48408 - 44032: 0x9455,
	48409 - 44032: 0x9456,
	48410 - 44032: 0x9457,
	48411 - 44032: 0x9458,
	48412 - 44032: 0x9459,
	48413 - 44032: 0x945A,
	48414 - 44032: 0x9461,
	48415 - 44032: 0x9462,
	48416 - 44032: 0x9463,
	48417 - 44032: 0x9464,
	48418 - 44032: 0x9465,
	48419 - 44032: 0x9466,
	48420 - 44032: 0xBAC3,
	48421 - 44032: 0x9467,
	48422 - 44032: 0x9468,
	48423 - 44032: 0x9469,
	48424 - 44032: 0x946A,
	48425 - 44032: 0x946B,
	48426 - 44032: 0x946C,
	48427 - 44032: 0x946D,
	48428 - 44032: 0xBAC4,
	48429 - 44032: 0x946E,
	48430 - 44032: 0x946F,
	48431 - 44032: 0x9470,
	48432 - 44032: 0x9471,
	48433 - 44032: 0x9472,
	48434 - 44032: 0x9473,
	48435 - 44032: 0x9474,
	48436 - 44032: 0x9475,
	48437 - 44032: 0x9476,
	48438 - 44032: 0x9477,
	48439 - 44032: 0x9478,
	48440 - 44032: 0x9479,
	48441 - 44032: 0x947A,
	48442 - 44032: 0x9481,
	48443 - 44032: 0x9482,
	48444 - 44032: 0x9483,
	48445 - 44032: 0x9484,
	48446 - 44032: 0x9485,
	48447 - 44032: 0x9486,
	48448 - 44032: 0xBAC5,
	48449 - 44032: 0x9487,
	48450 - 44032: 0x9488,
	48451 - 44032: 0x9489,
	48452 - 44032: 0x948A,
	48453 - 44032: 0x948B,
	48454 - 44032: 0x948C,
	48455 - 44032: 0x948D,
	48456 - 44032: 0xBAC6,
	48457 - 44032: 0xBAC7,
	48458 - 44032: 0x948E,
	48459 - 44032: 0x948F,
	48460 - 44032: 0xBAC8,
	48461 - 44032: 0x9490,
	48462 - 44032: 0x9491,
	48463 - 44032: 0x9492,
	48464 - 44032: 0xBAC9,
	48465 - 44032: 0x9493,
	48466 - 44032: 0x9494,
	48467 - 44032: 0x9495,
	48468 - 44032: 0x9496,
	48469 - 44032: 0x9497,
	48470 - 44032: 0x9498,
	48471 - 44032: 0x9499,
	48472 - 44032: 0xBACA,
	48473 - 44032: 0xBACB,
	48474 - 44032: 0x949A,
	48475 - 44032: 0x949B,
	48476 - 44032: 0x949C,
	48477 - 44032: 0x949D,
	48478 - 44032: 0x949E,
	48479 - 44032: 0x949F,
	48480 - 44032: 0x94A0,
	48481 - 44032: 0x94A1,
	48482 - 44032: 0x94A2,
	48483 - 44032: 0x94A3,
	48484 - 44032: 0xBACC,
	48485 - 44032: 0x94A4,
	48486 - 44032: 0x94A5,
	48487 - 44032: 0x94A6,
	48488 - 44032: 0xBACD,
	48489 - 44032: 0x94A7,
	48490 - 44032: 0x94A8,
	48491 - 44032: 0x94A9,
	48492 - 44032: 0x94AA,
	48493 - 44032: 0x94AB,
	48494 - 44032: 0x94AC,
	48495 - 44032: 0x94AD,
	48496 - 44032: 0x94AE,
	48497 - 44032: 0x94AF,
	48498 - 44032: 0x94B0,
	48499 - 44032: 0x94B1,
	48500 - 44032: 0x94B2,
	48501 - 44032: 0x94B3,
	48502 - 44032: 0x94B4,
	48503 - 44032: 0x94B5,
	48504 - 44032: 0x94B6,
	48505 - 44032: 0x94B7,
	48506 - 44032: 0x94B8,
	48507 - 44032: 0x94B9,
	48508 - 44032: 0x94BA,
	48509 - 44032: 0x94BB,
	48510 - 44032: 0x94BC,
	48511 - 44032: 0x94BD,
	48512 - 44032: 0xBACE,
	48513 - 44032: 0xBACF,
	48514 - 44032: 0x94BE,
	48515 - 44032: 0x94BF,
	48516 - 44032: 0xBAD0,
	48517 - 44032: 0x94C0,
	48518 - 44032: 0x94C1,
	48519 - 44032: 0xBAD1,
	48520 - 44032: 0xBAD2,
	48521 - 44032: 0xBAD3,
	48522 - 44032: 0xBAD4,
	48523 - 44032: 0x94C2,
	48524 - 44032: 0x94C3,
	48525 - 44032: 0x94C4,
	48526 - 44032: 0x94C5,
	48527 - 44032: 0x94C6,
	48528 - 44032: 0xBAD5,
	48529 - 44032: 0xBAD6,
	48530 - 44032: 0x94C7,
	48531 - 44032: 0xBAD7,
	48532 - 44032: 0x94C8,
	48533 - 44032: 0xBAD8,
	48534 - 44032: 0x94C9,
	48535 - 44032: 0x94CA,
	48536 - 44032: 0x94CB,
	48537 - 44032: 0xBAD9,
	48538 - 44032: 0xBADA,
	48539 - 44032: 0x94CC,
	48540 - 44032: 0xBADB,
	48541 - 44032: 0x94CD,
	48542 - 44032: 0x94CE,
	48543 - 44032: 0x94CF,
	48544 - 44032: 0x94D0,
	48545 - 44032: 0x94D1,
	48546 - 44032: 0x94D2,
	48547 - 44032: 0x94D3,
	48548 - 44032: 0xBADC,
	48549 - 44032: 0x94D4,
	48550 - 44032: 0x94D5,
	48551 - 44032: 0x94D6,
	48552 - 44032: 0x94D7,
	48553 - 44032: 0x94D8,
	48554 - 44032: 0x94D9,
	48555 - 44032: 0x94DA,
	48556 - 44032: 0x94DB,
	48557 - 44032: 0x94DC,
	48558 - 44032: 0x94DD,
	48559 - 44032: 0x94DE,
	48560 - 44032: 0xBADD,
	48561 - 44032: 0x94DF,
	48562 - 44032: 0x94E0,
	48563 - 44032: 0x94E1,
	48564 - 44032: 0x94E2,
	48565 - 44032: 0x94E3,
	48566 - 44032: 0x94E4,
	48567 - 44032: 0x94E5,
	48568 - 44032: 0xBADE,
	48569 - 44032: 0x94E6,
	48570 - 44032: 0x94E7,
	48571 - 44032: 0x94E8,
	48572 - 44032: 0x94E9,
	48573 - 44032: 0x94EA,
	48574 - 44032: 0x94EB,
	48575 - 44032: 0x94EC,
	48576 - 44032: 0x94ED,
	48577 - 44032: 0x94EE,
	48578 - 44032: 0x94EF,
	48579 - 44032: 0x94F0,
	48580 - 44032: 0x94F1,
	48581 - 44032: 0x94F2,
	48582 - 44032: 0x94F3,
	48583 - 44032: 0x94F4,
	48584 - 44032: 0x94F5,
	48585 - 44032: 0x94F6,
	48586 - 44032: 0x94F7,
	48587 - 44032: 0x94F8,
	48588 - 44032: 0x94F9,
	48589 - 44032: 0x94FA,
	48590 - 44032: 0x94FB,
	48591 - 44032: 0x94FC,
	48592 - 44032: 0x94FD,
	48593 - 44032: 0x94FE,
	48594 - 44032: 0x9541,
	48595 - 44032: 0x9542,
	48596 - 44032: 0xBADF,
	48597 - 44032: 0xBAE0,
	48598 - 44032: 0x9543,
	48599 - 44032: 0x9544,
	48600 - 44032: 0xBAE1,
	48601 - 44032: 0x9545,
	48602 - 44032: 0x9546,
	48603 - 44032: 0x9547,
	48604 - 44032: 0xBAE2,
	48605 - 44032: 0x9548,
	48606 - 44032: 0x9549,
	48607 - 44032: 0x954A,
	48608 - 44032: 0x954B,
	48609 - 44032: 0x954C,
	48610 - 44032: 0x954D,
	48611 - 44032: 0x954E,
	48612 - 44032: 0x954F,
	48613 - 44032: 0x9550,
	48614 - 44032: 0x9551,
	48615 - 44032: 0x9552,
	48616 - 44032: 0x9553,
	48617 - 44032: 0xBAE3,
	48618 - 44032: 0x9554,
	48619 - 44032: 0x9555,
	48620 - 44032: 0x9556,
	48621 - 44032: 0x9557,
	48622 - 44032: 0x9558,
	48623 - 44032: 0x9559,
	48624 - 44032: 0xBAE4,
	48625 - 44032: 0x955A,
	48626 - 44032: 0x9561,
	48627 - 44032: 0x9562,
	48628 - 44032: 0xBAE5,
	48629 - 44032: 0x9563,
	48630 - 44032: 0x9564,
	48631 - 44032: 0x9565,
	48632 - 44032: 0xBAE6,
	48633 - 44032: 0x9566,
	48634 - 44032: 0x9567,
	48635 - 44032: 0x9568,
	48636 - 44032: 0x9569,
	48637 - 44032: 0x956A,
	48638 - 44032: 0x956B,
	48639 - 44032: 0x956C,
	48640 - 44032: 0xBAE7,
	48641 - 44032: 0x956D,
	48642 - 44032: 0x956E,
	48643 - 44032: 0xBAE8,
	48644 - 44032: 0x956F,
	48645 - 44032: 0xBAE9,
	48646 - 44032: 0x9570,
	48647 - 44032: 0x9571,
	48648 - 44032: 0x9572,
	48649 - 44032: 0x9573,
	48650 - 44032: 0x9574,
	48651 - 44032: 0x9575,
	48652 - 44032: 0xBAEA,
	48653 - 44032: 0xBAEB,
	48654 - 44032: 0x9576,
	48655 - 44032: 0x9577,
	48656 - 44032: 0xBAEC,
	48657 - 44032: 0x9578,
	48658 - 44032: 0x9579,
	48659 - 44032: 0x957A,
	48660 - 44032: 0xBAED,
	48661 - 44032: 0x9581,
	48662 - 44032: 0x9582,
	48663 - 44032: 0x9583,
	48664 - 44032: 0x9584,
	48665 - 44032: 0x9585,
	48666 - 44032: 0x9586,
	48667 - 44032: 0x9587,
	48668 - 44032: 0xBAEE,
	48669 - 44032: 0xBAEF,
	48670 - 44032: 0x9588,
	48671 - 44032: 0xBAF0,
	48672 - 44032: 0x9589,
	48673 - 44032: 0x958A,
	48674 - 44032: 0x958B,
	48675 - 44032: 0x958C,
	48676 - 44032: 0x958D,
	48677 - 44032: 0x958E,
	48678 - 44032: 0x958F,
	48679 - 44032: 0x9590,
	48680 - 44032: 0x9591,
	48681 - 44032: 0x9592,
	48682 - 44032: 0x9593,
	48683 - 44032: 0x9594,
	48684 - 44032: 0x9595,
	48685 - 44032: 0x9596,
	48686 - 44032: 0x9597,
	48687 - 44032: 0x9598,
	48688 - 44032: 0x9599,
	48689 - 44032: 0x959A,
	48690 - 44032: 0x959B,
	48691 - 44032: 0x959C,
	48692 - 44032: 0x959D,
	48693 - 44032: 0x959E,
	48694 - 44032: 0x959F,
	48695 - 44032: 0x95A0,
	48696 - 44032: 0x95A1,
	48697 - 44032: 0x95A2,
	48698 - 44032: 0x95A3,
	48699 - 44032: 0x95A4,
	48700 - 44032: 0x95A5,
	48701 - 44032: 0x95A6,
	48702 - 44032: 0x95A7,
	48703 - 44032: 0x95A8,
	48704 - 44032: 0x95A9,
	48705 - 44032: 0x95AA,
	48706 - 44032: 0x95AB,
	48707 - 44032: 0x95AC,
	48708 - 44032: 0xBAF1,
	48709 - 44032: 0xBAF2,
	48710 - 44032: 0x95AD,
	48711 - 44032: 0x95AE,
	48712 - 44032: 0xBAF3,
	48713 - 44032: 0x95AF,
	48714 - 44032: 0x95B0,
	48715 - 44032: 0x95B1,
	48716 - 44032: 0xBAF4,
	48717 - 44032: 0x95B2,
	48718 - 44032: 0xBAF5,
	48719 - 44032: 0x95B3,
	48720 - 44032: 0x95B4,
	48721 - 44032: 0x95B5,
	48722 - 44032: 0x95B6,
	48723 - 44032: 0x95B7,
	48724 - 44032: 0xBAF6,
	48725 - 44032: 0xBAF7,
	48726 - 44032: 0x95B8,
	48727 - 44032: 0xBAF8,
	48728 - 44032: 0x95B9,
	48729 - 44032: 0xBAF9,
	48730 - 44032: 0xBAFA,
	48731 - 44032: 0xBAFB,
	48732 - 44032: 0x95BA,
	48733 - 44032: 0x95BB,
	48734 - 44032: 0x95BC,
	48735 - 44032: 0x95BD,
	48736 - 44032: 0xBAFC,
	48737 - 44032: 0xBAFD,
	48738 - 44032: 0x95BE,
	48739 - 44032: 0x95BF,
	48740 - 44032: 0xBAFE,
	48741 - 44032: 0x95C0,
	48742 - 44032: 0x95C1,
	48743 - 44032: 0x95C2,
	48744 - 44032: 0xBBA1,
	48745 - 44032: 0x95C3,
	48746 - 44032: 0xBBA2,
	48747 - 44032: 0x95C4,
	48748 - 44032: 0x95C5,
	48749 - 44032: 0x95C6,
	48750 - 44032: 0x95C7,
	48751 - 44032: 0x95C8,
	48752 - 44032: 0xBBA3,
	48753 - 44032: 0xBBA4,
	48754 - 44032: 0x95C9,
	48755 - 44032: 0xBBA5,
	48756 - 44032: 0xBBA6,
	48757 - 44032: 0xBBA7,
	48758 - 44032: 0x95CA,
	48759 - 44032: 0x95CB,
	48760 - 44032: 0x95CC,
	48761 - 44032: 0x95CD,
	48762 - 44032: 0x95CE,
	48763 - 44032: 0xBBA8,
	48764 - 44032: 0xBBA9,
	48765 - 44032: 0xBBAA,
	48766 - 44032: 0x95CF,
	48767 - 44032: 0x95D0,
	48768 - 44032: 0xBBAB,
	48769 - 44032: 0x95D1,
	48770 - 44032: 0x95D2,
	48771 - 44032: 0x95D3,
	48772 - 44032: 0xBBAC,
	48773 - 44032: 0x95D4,
	48774 - 44032: 0x95D5,
	48775 - 44032: 0x95D6,
	48776 - 44032: 0x95D7,
	48777 - 44032: 0x95D8,
	48778 - 44032: 0x95D9,
	48779 - 44032: 0x95DA,
	48780 - 44032: 0xBBAD,
	48781 - 44032: 0xBBAE,
	48782 - 44032: 0x95DB,
	48783 - 44032: 0xBBAF,
	48784 - 44032: 0xBBB0,
	48785 - 44032: 0xBBB1,
	48786 - 44032: 0x95DC,
	48787 - 44032: 0x95DD,
	48788 - 44032: 0x95DE,
	48789 - 44032: 0x95DF,
	48790 - 44032: 0x95E0,
	48791 - 44032: 0x95E1,
	48792 - 44032: 0xBBB2,
	48793 - 44032: 0xBBB3,
	48794 - 44032: 0x95E2,
	48795 - 44032: 0x95E3,
	48796 - 44032: 0x95E4,
	48797 - 44032: 0x95E5,
	48798 - 44032: 0x95E6,
	48799 - 44032: 0x95E7,
	48800 - 44032: 0x95E8,
	48801 - 44032: 0x95E9,
	48802 - 44032: 0x95EA,
	48803 - 44032: 0x95EB,
	48804 - 44032: 0x95EC,
	48805 - 44032: 0x95ED,
	48806 - 44032: 0x95EE,
	48807 - 44032: 0x95EF,
	48808 - 44032: 0xBBB4,
	48809 - 44032: 0x95F0,
	48810 - 44032: 0x95F1,
	48811 - 44032: 0x95F2,
	48812 - 44032: 0x95F3,
	48813 - 44032: 0x95F4,
	48814 - 44032: 0x95F5,
	48815 - 44032: 0x95F6,
	48816 - 44032: 0x95F7,
	48817 - 44032: 0x95F8,
	48818 - 44032: 0x95F9,
	48819 - 44032: 0x95FA,
	48820 - 44032: 0x95FB,
	48821 - 44032: 0x95FC,
	48822 - 44032: 0x95FD,
	48823 - 44032: 0x95FE,
	48824 - 44032: 0x9641,
	48825 - 44032: 0x9642,
	48826 - 44032: 0x9643,
	48827 - 44032: 0x9644,
	48828 - 44032: 0x9645,
	48829 - 44032: 0x9646,
	48830 - 44032: 0x9647,
	48831 - 44032: 0x9648,
	48832 - 44032: 0x9649,
	48833 - 44032: 0x964A,
	48834 - 44032: 0x964B,
	48835 - 44032: 0x964C,
	48836 - 44032: 0x964D,
	48837 - 44032: 0x964E,
	48838 - 44032: 0x964F,
	48839 - 44032: 0x9650,
	48840 - 44032: 0x9651,
	48841 - 44032: 0x9652,
	48842 - 44032: 0x9653,
	48843 - 44032: 0x9654,
	48844 - 44032: 0x9655,
	48845 - 44032: 0x9656,
	48846 - 44032: 0x9657,
	48847 - 44032: 0x9658,
	48848 - 44032: 0xBBB5,
	48849 - 44032: 0xBBB6,
	48850 - 44032: 0x9659,
	48851 - 44032: 0x965A,
	48852 - 44032: 0xBBB7,
	48853 - 44032: 0x9661,
	48854 - 44032: 0x9662,
	48855 - 44032: 0xBBB8,
	48856 - 44032: 0xBBB9,
	48857 - 44032: 0x9663,
	48858 - 44032: 0x9664,
	48859 - 44032: 0x9665,
	48860 - 44032: 0x9666,
	48861 - 44032: 0x9667,
	48862 - 44032: 0x9668,
	48863 - 44032: 0x9669,
	48864 - 44032: 0xBBBA,
	48865 - 44032: 0x966A,
	48866 - 44032: 0x966B,
	48867 - 44032: 0xBBBB,
	48868 - 44032: 0xBBBC,
	48869 - 44032: 0xBBBD,
	48870 - 44032: 0x966C,
	48871 - 44032: 0x966D,
	48872 - 44032: 0x966E,
	48873 - 44032: 0x966F,
	48874 - 44032: 0x9670,
	48875 - 44032: 0x9671,
	48876 - 44032: 0xBBBE,
	48877 - 44032: 0x9672,
	48878 - 44032: 0x9673,
	48879 - 44032: 0x9674,
	48880 - 44032: 0x9675,
	48881 - 44032: 0x9676,
	48882 - 44032: 0x9677,
	48883 - 44032: 0x9678,
	48884 - 44032: 0x9679,
	48885 - 44032: 0x967A,
	48886 - 44032: 0x9681,
	48887 - 44032: 0x9682,
	48888 - 44032: 0x9683,
	48889 - 44032: 0x9684,
	48890 - 44032: 0x9685,
	48891 - 44032: 0x9686,
	48892 - 44032: 0x9687,
	48893 - 44032: 0x9688,
	48894 - 44032: 0x9689,
	48895 - 44032: 0x968A,
	48896 - 44032: 0x968B,
	48897 - 44032: 0xBBBF,
	48898 - 44032: 0x968C,
	48899 - 44032: 0x968D,
	48900 - 44032: 0x968E,
	48901 - 44032: 0x968F,
	48902 - 44032: 0x9690,
	48903 - 44032: 0x9691,
	48904 - 44032: 0xBBC0,
	48905 - 44032: 0xBBC1,
	48906 - 44032: 0x9692,
	48907 - 44032: 0x9693,
	48908 - 44032: 0x9694,
	48909 - 44032: 0x9695,
	48910 - 44032: 0x9696,
	48911 - 44032: 0x9697,
	48912 - 44032: 0x9698,
	48913 - 44032: 0x9699,
	48914 - 44032: 0x969A,
	48915 - 44032: 0x969B,
	48916 - 44032: 0x969C,
	48917 - 44032: 0x969D,
	48918 - 44032: 0x969E,
	48919 - 44032: 0x969F,
	48920 - 44032: 0xBBC2,
	48921 - 44032: 0xBBC3,
	48922 - 44032: 0x96A0,
	48923 - 44032: 0xBBC4,
	48924 - 44032: 0xBBC5,
	48925 - 44032: 0xBBC6,
	48926 - 44032: 0x96A1,
	48927 - 44032: 0x96A2,
	48928 - 44032: 0x96A3,
	48929 - 44032: 0x96A4,
	48930 - 44032: 0x96A5,
	48931 - 44032: 0x96A6,
	48932 - 44032: 0x96A7,
	48933 - 44032: 0x96A8,
	48934 - 44032: 0x96A9,
	48935 - 44032: 0x96AA,
	48936 - 44032: 0x96AB,
	48937 - 44032: 0x96AC,
	48938 - 44032: 0x96AD,
	48939 - 44032: 0x96AE,
	48940 - 44032: 0x96AF,
	48941 - 44032: 0x96B0,
	48942 - 44032: 0x96B1,
	48943 - 44032: 0x96B2,
	48944 - 44032: 0x96B3,
	48945 - 44032: 0x96B4,
	48946 - 44032: 0x96B5,
	48947 - 44032: 0x96B6,
	48948 - 44032: 0x96B7,
	48949 - 44032: 0x96B8,
	48950 - 44032: 0x96B9,
	48951 - 44032: 0x96BA,
	48952 - 44032: 0x96BB,
	48953 - 44032: 0x96BC,
	48954 - 44032: 0x96BD,
	48955 - 44032: 0x96BE,
	48956 - 44032: 0x96BF,
	48957 - 44032: 0x96C0,
	48958 - 44032: 0x96C1,
	48959 - 44032: 0x96C2,
	48960 - 44032: 0xBBC7,
	48961 - 44032: 0xBBC8,
	48962 - 44032: 0x96C3,
	48963 - 44032: 0x96C4,
	48964 - 44032: 0xBBC9,
	48965 - 44032: 0x96C5,
	48966 - 44032: 0x96C6,
	48967 - 44032: 0x96C7,
	48968 - 44032: 0xBBCA,
	48969 - 44032: 0x96C8,
	48970 - 44032: 0x96C9,
	48971 - 44032: 0x96CA,
	48972 - 44032: 0x96CB,
	48973 - 44032: 0x96CC,
	48974 - 44032: 0x96CD,
	48975 - 44032: 0x96CE,
	48976 - 44032: 0xBBCB,
	48977 - 44032: 0xBBCC,
	48978 - 44032: 0x96CF,
	48979 - 44032: 0x96D0,
	48980 - 44032: 0x96D1,
	48981 - 44032: 0xBBCD,
	48982 - 44032: 0x96D2,
	48983 - 44032: 0x96D3,
	48984 - 44032: 0x96D4,
	48985 - 44032: 0x96D5,
	48986 - 44032: 0x96D6,
	48987 - 44032: 0x96D7,
	48988 - 44032: 0x96D8,
	48989 - 44032: 0x96D9,
	48990 - 44032: 0x96DA,
	48991 - 44032: 0x96DB,
	48992 - 44032: 0x96DC,
	48993 - 44032: 0x96DD,
	48994 - 44032: 0x96DE,
	48995 - 44032: 0x96DF,
	48996 - 44032: 0x96E0,
	48997 - 44032: 0x96E1,
	48998 - 44032: 0x96E2,
	48999 - 44032: 0x96E3,
	49000 - 44032: 0x96E4,
	49001 - 44032: 0x96E5,
	49002 - 44032: 0x96E6,
	49003 - 44032: 0x96E7,
	49004 - 44032: 0x96E8,
	49005 - 44032: 0x96E9,
	49006 - 44032: 0x96EA,
	49007 - 44032: 0x96EB,
	49008 - 44032: 0x96EC,
	49009 - 44032: 0x96ED,
	49010 - 44032: 0x96EE,
	49011 - 44032: 0x96EF,
	49012 - 44032: 0x96F0,
	49013 - 44032: 0x96F1,
	49014 - 44032: 0x96F2,
	49015 - 44032: 0x96F3,
	49016 - 44032: 0x96F4,
	49017 - 44032: 0x96F5,
	49018 - 44032: 0x96F6,
	49019 - 44032: 0x96F7,
	49020 - 44032: 0x96F8,
	49021 - 44032: 0x96F9,
	49022 - 44032: 0x96FA,
	49023 - 44032: 0x96FB,
	49024 - 44032: 0x96FC,
	49025 - 44032: 0x96FD,
	49026 - 44032: 0x96FE,
	49027 - 44032: 0x9741,
	49028 - 44032: 0x9742,
	49029 - 44032: 0x9743,
	49030 - 44032: 0x9744,
	49031 - 44032: 0x9745,
	49032 - 44032: 0x9746,
	49033 - 44032: 0x9747,
	49034 - 44032: 0x9748,
	49035 - 44032: 0x9749,
	49036 - 44032: 0x974A,
	49037 - 44032: 0x974B,
	49038 - 44032: 0x974C,
	49039 - 44032: 0x974D,
	49040 - 44032: 0x974E,
	49041 - 44032: 0x974F,
	49042 - 44032: 0x9750,
	49043 - 44032: 0x9751,
	49044 - 44032: 0xBBCE,
	49045 - 44032: 0x9752,
	49046 - 44032: 0x9753,
	49047 - 44032: 0x9754,
	49048 - 44032: 0x9755,
	49049 - 44032: 0x9756,
	49050 - 44032: 0x9757,
	49051 - 44032: 0x9758,
	49052 - 44032: 0x9759,
	49053 - 44032: 0x975A,
	49054 - 44032: 0x9761,
	49055 - 44032: 0x9762,
	49056 - 44032: 0x9763,
	49057 - 44032: 0x9764,
	49058 - 44032: 0x9765,
	49059 - 44032: 0x9766,
	49060 - 44032: 0x9767,
	49061 - 44032: 0x9768,
	49062 - 44032: 0x9769,
	49063 - 44032: 0x976A,
	49064 - 44032: 0x976B,
	49065 - 44032: 0x976C,
	49066 - 44032: 0x976D,
	49067 - 44032: 0x976E,
	49068 - 44032: 0x976F,
	49069 - 44032: 0x9770,
	49070 - 44032: 0x9771,
	49071 - 44032: 0x9772,
	49072 - 44032: 0xBBCF,
	49073 - 44032: 0x9773,
	49074 - 44032: 0x9774,
	49075 - 44032: 0x9775,
	49076 - 44032: 0x9776,
	49077 - 44032: 0x9777,
	49078 - 44032: 0x9778,
	49079 - 44032: 0x9779,
	49080 - 44032: 0x977A,
	49081 - 44032: 0x9781,
	49082 - 44032: 0x9782,
	49083 - 44032: 0x9783,
	49084 - 44032: 0x9784,
	49085 - 44032: 0x9785,
	49086 - 44032: 0x9786,
	49087 - 44032: 0x9787,
	49088 - 44032: 0x9788,
	49089 - 44032: 0x9789,
	49090 - 44032: 0x978A,
	49091 - 44032: 0x978B,
	49092 - 44032: 0x978C,
	49093 - 44032: 0xBBD0,
	49094 - 44032: 0x978D,
	49095 - 44032: 0x978E,
	49096 - 44032: 0x978F,
	49097 - 44032: 0x9790,
	49098 - 44032: 0x9791,
	49099 - 44032: 0x9792,
	49100 - 44032: 0xBBD1,
	49101 - 44032: 0xBBD2,
	49102 - 44032: 0x9793,
	49103 - 44032: 0x9794,
	49104 - 44032: 0xBBD3,
	49105 - 44032: 0x9795,
	49106 - 44032: 0x9796,
	49107 - 44032: 0x9797,
	49108 - 44032: 0xBBD4,
	49109 - 44032: 0x9798,
	49110 - 44032: 0x9799,
	49111 - 44032: 0x979A,
	49112 - 44032: 0x979B,
	49113 - 44032: 0x979C,
	49114 - 44032: 0x979D,
	49115 - 44032: 0x979E,
	49116 - 44032: 0xBBD5,
	49117 - 44032: 0x979F,
	49118 - 44032: 0x97A0,
	49119 - 44032: 0xBBD6,
	49120 - 44032: 0x97A1,
	49121 - 44032: 0xBBD7,
	49122 - 44032: 0x97A2,
	49123 - 44032: 0x97A3,
	49124 - 44032: 0x97A4,
	49125 - 44032: 0x97A5,
	49126 - 44032: 0x97A6,
	49127 - 44032: 0x97A7,
	49128 - 44032: 0x97A8,
	49129 - 44032: 0x97A9,
	49130 - 44032: 0x97AA,
	49131 - 44032: 0x97AB,
	49132 - 44032: 0x97AC,
	49133 - 44032: 0x97AD,
	49134 - 44032: 0x97AE,
	49135 - 44032: 0x97AF,
	49136 - 44032: 0x97B0,
	49137 - 44032: 0x97B1,
	49138 - 44032: 0x97B2,
	49139 - 44032: 0x97B3,
	49140 - 44032: 0x97B4,
	49141 - 44032: 0x97B5,
	49142 - 44032: 0x97B6,
	49143 - 44032: 0x97B7,
	49144 - 44032: 0x97B8,
	49145 - 44032: 0x97B9,
	49146 - 44032: 0x97BA,
	49147 - 44032: 0x97BB,
	49148 - 44032: 0x97BC,
	49149 - 44032: 0x97BD,
	49150 - 44032: 0x97BE,
	49151 - 44032: 0x97BF,
	49152 - 44032: 0x97C0,
	49153 - 44032: 0x97C1,
	49154 - 44032: 0x97C2,
	49155 - 44032: 0x97C3,
	49156 - 44032: 0x97C4,
	49157 - 44032: 0x97C5,
	49158 - 44032: 0x97C6,
	49159 - 44032: 0x97C7,
	49160 - 44032: 0x97C8,
	49161 - 44032: 0x97C9,
	49162 - 44032: 0x97CA,
	49163 - 44032: 0x97CB,
	49164 - 44032: 0x97CC,
	49165 - 44032: 0x97CD,
	49166 - 44032: 0x97CE,
	49167 - 44032: 0x97CF,
	49168 - 44032: 0x97D0,
	49169 - 44032: 0x97D1,
	49170 - 44032: 0x97D2,
	49171 - 44032: 0x97D3,
	49172 - 44032: 0x97D4,
	49173 - 44032: 0x97D5,
	49174 - 44032: 0x97D6,
	49175 - 44032: 0x97D7,
	49176 - 44032: 0x97D8,
	49177 - 44032: 0x97D9,
	49178 - 44032: 0x97DA,
	49179 - 44032: 0x97DB,
	49180 - 44032: 0x97DC,
	49181 - 44032: 0x97DD,
	49182 - 44032: 0x97DE,
	49183 - 44032: 0x97DF,
	49184 - 44032: 0x97E0,
	49185 - 44032: 0x97E1,
	49186 - 44032: 0x97E2,
	49187 - 44032: 0x97E3,
	49188 - 44032: 0x97E4,
	49189 - 44032: 0x97E5,
	49190 - 44032: 0x97E6,
	49191 - 44032: 0x97E7,
	49192 - 44032: 0x97E8,
	49193 - 44032: 0x97E9,
	49194 - 44032: 0x97EA,
	49195 - 44032: 0x97EB,
	49196 - 44032: 0x97EC,
	49197 - 44032: 0x97ED,
	49198 - 44032: 0x97EE,
	49199 - 44032: 0x97EF,
	49200 - 44032: 0x97F0,
	49201 - 44032: 0x97F1,
	49202 - 44032: 0x97F2,
	49203 - 44032: 0x97F3,
	49204 - 44032: 0x97F4,
	49205 - 44032: 0x97F5,
	49206 - 44032: 0x97F6,
	49207 - 44032: 0x97F7,
	49208 - 44032: 0x97F8,
	49209 - 44032: 0x97F9,
	49210 - 44032: 0x97FA,
	49211 - 44032: 0x97FB,
	49212 - 44032: 0xBBD8,
	49213 - 44032: 0x97FC,
	49214 - 44032: 0x97FD,
	49215 - 44032: 0x97FE,
	49216 - 44032: 0x9841,
	49217 - 44032: 0x9842,
	49218 - 44032: 0x9843,
	49219 - 44032: 0x9844,
	49220 - 44032: 0x9845,
	49221 - 44032: 0x9846,
	49222 - 44032: 0x9847,
	49223 - 44032: 0x9848,
	49224 - 44032: 0x9849,
	49225 - 44032: 0x984A,
	49226 - 44032: 0x984B,
	49227 - 44032: 0x984C,
	49228 - 44032: 0x984D,
	49229 - 44032: 0x984E,
	49230 - 44032: 0x984F,
	49231 - 44032: 0x9850,
	49232 - 44032: 0x9851,
	49233 - 44032: 0xBBD9,
	49234 - 44032: 0x9852,
	49235 - 44032: 0x9853,
	49236 - 44032: 0x9854,
	49237 - 44032: 0x9855,
	49238 - 44032: 0x9856,
	49239 - 44032: 0x9857,
	49240 - 44032: 0xBBDA,
	49241 - 44032: 0x9858,
	49242 - 44032: 0x9859,
	49243 - 44032: 0x985A,
	49244 - 44032: 0xBBDB,
	49245 - 44032: 0x9861,
	49246 - 44032: 0x9862,
	49247 - 44032: 0x9863,
	49248 - 44032: 0xBBDC,
	49249 - 44032: 0x9864,
	49250 - 44032: 0x9865,
	49251 - 44032: 0x9866,
	49252 - 44032: 0x9867,
	49253 - 44032: 0x9868,
	49254 - 44032: 0x9869,
	49255 - 44032: 0x986A,
	49256 - 44032: 0xBBDD,
	49257 - 44032: 0xBBDE,
	49258 - 44032: 0x986B,
	49259 - 44032: 0x986C,
	49260 - 44032: 0x986D,
	49261 - 44032: 0x986E,
	49262 - 44032: 0x986F,
	49263 - 44032: 0x9870,
	49264 - 44032: 0x9871,
	49265 - 44032: 0x9872,
	49266 - 44032: 0x9873,
	49267 - 44032: 0x9874,
	49268 - 44032: 0x9875,
	49269 - 44032: 0x9876,
	49270 - 44032: 0x9877,
	49271 - 44032: 0x9878,
	49272 - 44032: 0x9879,
	49273 - 44032: 0x987A,
	49274 - 44032: 0x9881,
	49275 - 44032: 0x9882,
	49276 - 44032: 0x9883,
	49277 - 44032: 0x9884,
	49278 - 44032: 0x9885,
	49279 - 44032: 0x9886,
	49280 - 44032: 0x9887,
	49281 - 44032: 0x9888,
	49282 - 44032: 0x9889,
	49283 - 44032: 0x988A,
	49284 - 44032: 0x988B,
	49285 - 44032: 0x988C,
	49286 - 44032: 0x988D,
	49287 - 44032: 0x988E,
	49288 - 44032: 0x988F,
	49289 - 44032: 0x9890,
	49290 - 44032: 0x9891,
	49291 - 44032: 0x9892,
	49292 - 44032: 0x9893,
	49293 - 44032: 0x9894,
	49294 - 44032: 0x9895,
	49295 - 44032: 0x9896,
	49296 - 44032: 0xBBDF,
	49297 - 44032: 0xBBE0,
	49298 - 44032: 0x9897,
	49299 - 44032: 0x9898,
	49300 - 44032: 0xBBE1,
	49301 - 44032: 0x9899,
	49302 - 44032: 0x989A,
	49303 - 44032: 0x989B,
	49304 - 44032: 0xBBE2,
	49305 - 44032: 0x989C,
	49306 - 44032: 0x989D,
	49307 - 44032: 0x989E,
	49308 - 44032: 0x989F,
	49309 - 44032: 0x98A0,
	49310 - 44032: 0x98A1,
	49311 - 44032: 0x98A2,
	49312 - 44032: 0xBBE3,
	49313 - 44032: 0xBBE4,
	49314 - 44032: 0x98A3,
	49315 - 44032: 0xBBE5,
	49316 - 44032: 0x98A4,
	49317 - 44032: 0xBBE6,
	49318 - 44032: 0x98A5,
	49319 - 44032: 0x98A6,
	49320 - 44032: 0x98A7,
	49321 - 44032: 0x98A8,
	49322 - 44032: 0x98A9,
	49323 - 44032: 0x98AA,
	49324 - 44032: 0xBBE7,
	49325 - 44032: 0xBBE8,
	49326 - 44032: 0x98AB,
	49327 - 44032: 0xBBE9,
	49328 - 44032: 0xBBEA,
	49329 - 44032: 0x98AC,
	49330 - 44032: 0x98AD,
	49331 - 44032: 0xBBEB,
	49332 - 44032: 0xBBEC,
	49333 - 44032: 0xBBED,
	49334 - 44032: 0xBBEE,
	49335 - 44032: 0x98AE,
	49336 - 44032: 0x98AF,
	49337 - 44032: 0x98B0,
	49338 - 44032: 0x98B1,
	49339 - 44032: 0x98B2,
	49340 - 44032: 0xBBEF,
	49341 - 44032: 0xBBF0,
	49342 - 44032: 0x98B3,
	49343 - 44032: 0xBBF1,
	49344 - 44032: 0xBBF2,
	49345 - 44032: 0xBBF3,
	49346 - 44032: 0x98B4,
	49347 - 44032: 0x98B5,
	49348 - 44032: 0x98B6,
	49349 - 44032: 0xBBF4,
	49350 - 44032: 0x98B7,
	49351 - 44032: 0x98B8,
	49352 - 44032: 0xBBF5,
	49353 - 44032: 0xBBF6,
	49354 - 44032: 0x98B9,
	49355 - 44032: 0x98BA,
	49356 - 44032: 0xBBF7,
	49357 - 44032: 0x98BB,
	49358 - 44032: 0x98BC,
	49359 - 44032: 0x98BD,
	49360 - 44032: 0xBBF8,
	49361 - 44032: 0x98BE,
	49362 - 44032: 0x98BF,
	49363 - 44032: 0x98C0,
	49364 - 44032: 0x98C1,
	49365 - 44032: 0x98C2,
	49366 - 44032: 0x98C3,
	49367 - 44032: 0x98C4,
	49368 - 44032: 0xBBF9,
	49369 - 44032: 0xBBFA,
	49370 - 44032: 0x98C5,
	49371 - 44032: 0xBBFB,
	49372 - 44032: 0xBBFC,
	49373 - 44032: 0xBBFD,
	49374 - 44032: 0x98C6,
	49375 - 44032: 0x98C7,
	49376 - 44032: 0x98C8,
	49377 - 44032: 0x98C9,
	49378 - 44032: 0x98CA,
	49379 - 44032: 0x98CB,
	49380 - 44032: 0xBBFE,
	49381 - 44032: 0xBCA1,
	49382 - 44032: 0x98CC,
	49383 - 44032: 0x98CD,
	49384 - 44032: 0xBCA2,
	49385 - 44032: 0x98CE,
	49386 - 44032: 0x98CF,
	49387 - 44032: 0x98D0,
	49388 - 44032: 0xBCA3,
	49389 - 44032: 0x98D1,
	49390 - 44032: 0x98D2,
	49391 - 44032: 0x98D3,
	49392 - 44032: 0x98D4,
	49393 - 44032: 0x98D5,
	49394 - 44032: 0x98D6,
	49395 - 44032: 0x98D7,
	49396 - 44032: 0xBCA4,
	49397 - 44032: 0xBCA5,
	49398 - 44032: 0x98D8,
	49399 - 44032: 0xBCA6,
	49400 - 44032: 0x98D9,
	49401 - 44032: 0xBCA7,
	49402 - 44032: 0x98DA,
	49403 - 44032: 0x98DB,
	49404 - 44032: 0x98DC,
	49405 - 44032: 0x98DD,
	49406 - 44032: 0x98DE,
	49407 - 44032: 0x98DF,
	49408 - 44032: 0xBCA8,
	49409 - 44032: 0x98E0,
	49410 - 44032: 0x98E1,
	49411 - 44032: 0x98E2,
	49412 - 44032: 0xBCA9,
	49413 - 44032: 0x98E3,
	49414 - 44032: 0x98E4,
	49415 - 44032: 0x98E5,
	49416 - 44032: 0xBCAA,
	49417 - 44032: 0x98E6,
	49418 - 44032: 0x98E7,
	49419 - 44032: 0x98E8,
	49420 - 44032: 0x98E9,
	49421 - 44032: 0x98EA,
	49422 - 44032: 0x98EB,
	49423 - 44032: 0x98EC,
	49424 - 44032: 0xBCAB,
	49425 - 44032: 0x98ED,
	49426 - 44032: 0x98EE,
	49427 - 44032: 0x98EF,
	49428 - 44032: 0x98F0,
	49429 - 44032: 0xBCAC,
	49430 - 44032: 0x98F1,
	49431 - 44032: 0x98F2,
	49432 - 44032: 0x98F3,
	49433 - 44032: 0x98F4,
	49434 - 44032: 0x98F5,
	49435 - 44032: 0x98F6,
	49436 - 44032: 0xBCAD,
	49437 - 44032: 0xBCAE,
	49438 - 44032: 0xBCAF,
	49439 - 44032: 0xBCB0,
	49440 - 44032: 0xBCB1,
	49441 - 44032: 0x98F7,
	49442 - 44032: 0x98F8,
	49443 - 44032: 0xBCB2,
	49444 - 44032: 0xBCB3,
	49445 - 44032: 0x98F9,
	49446 - 44032: 0xBCB4,
	49447 - 44032: 0xBCB5,
	49448 - 44032: 0x98FA,
	49449 - 44032: 0x98FB,
	49450 - 44032: 0x98FC,
	49451 - 44032: 0x98FD,
	49452 - 44032: 0xBCB6,
	49453 - 44032: 0xBCB7,
	49454 - 44032: 0x98FE,
	49455 - 44032: 0xBCB8,
	49456 - 44032: 0xBCB9,
	49457 - 44032: 0xBCBA,
	49458 - 44032: 0x9941,
	49459 - 44032: 0x9942,
	49460 - 44032: 0x9943,
	49461 - 44032: 0x9944,
	49462 - 44032: 0xBCBB,
	49463 - 44032: 0x9945,
	49464 - 44032: 0xBCBC,
	49465 - 44032: 0xBCBD,
	49466 - 44032: 0x9946,
	49467 - 44032: 0x9947,
	49468 - 44032: 0xBCBE,
	49469 - 44032: 0x9948,
	49470 - 44032: 0x9949,
	49471 - 44032: 0x994A,
	49472 - 44032: 0xBCBF,
	49473 - 44032: 0x994B,
	49474 - 44032: 0x994C,
	49475 - 44032: 0x994D,
	49476 - 44032: 0x994E,
	49477 - 44032: 0x994F,
	49478 - 44032: 0x9950,
	49479 - 44032: 0x9951,
	49480 - 44032: 0xBCC0,
	49481 - 44032: 0xBCC1,
	49482 - 44032: 0x9952,
	49483 - 44032: 0xBCC2,
	49484 - 44032: 0xBCC3,
	49485 - 44032: 0xBCC4,
	49486 - 44032: 0x9953,
	49487 - 44032: 0x9954,
	49488 - 44032: 0x9955,
	49489 - 44032: 0x9956,
	49490 - 44032: 0x9957,
	49491 - 44032: 0x9958,
	49492 - 44032: 0xBCC5,
	49493 - 44032: 0xBCC6,
	49494 - 44032: 0x9959,
	49495 - 44032: 0x995A,
	49496 - 44032: 0xBCC7,
	49497 - 44032: 0x9961,
	49498 - 44032: 0x9962,
	49499 - 44032: 0x9963,
	49500 - 44032: 0xBCC8,
	49501 - 44032: 0x9964,
	49502 - 44032: 0x9965,
	49503 - 44032: 0x9966,
	49504 - 44032: 0x9967,
	49505 - 44032: 0x9968,
	49506 - 44032: 0x9969,
	49507 - 44032: 0x996A,
	49508 - 44032: 0xBCC9,
	49509 - 44032: 0xBCCA,
	49510 - 44032: 0x996B,
	49511 - 44032: 0xBCCB,
	49512 - 44032: 0xBCCC,
	49513 - 44032: 0xBCCD,
	49514 - 44032: 0x996C,
	49515 - 44032: 0x996D,
	49516 - 44032: 0x996E,
	49517 - 44032: 0x996F,
	49518 - 44032: 0x9970,
	49519 - 44032: 0x9971,
	49520 - 44032: 0xBCCE,
	49521 - 44032: 0x9972,
	49522 - 44032: 0x9973,
	49523 - 44032: 0x9974,
	49524 - 44032: 0xBCCF,
	49525 - 44032: 0x9975,
	49526 - 44032: 0x9976,
	49527 - 44032: 0x9977,
	49528 - 44032: 0xBCD0,
	49529 - 44032: 0x9978,
	49530 - 44032: 0x9979,
	49531 - 44032: 0x997A,
	49532 - 44032: 0x9981,
	49533 - 44032: 0x9982,
	49534 - 44032: 0x9983,
	49535 - 44032: 0x9984,
	49536 - 44032: 0x9985,
	49537 - 44032: 0x9986,
	49538 - 44032: 0x9987,
	49539 - 44032: 0x9988,
	49540 - 44032: 0x9989,
	49541 - 44032: 0xBCD1,
	49542 - 44032: 0x998A,
	49543 - 44032: 0x998B,
	49544 - 44032: 0x998C,
	49545 - 44032: 0x998D,
	49546 - 44032: 0x998E,
	49547 - 44032: 0x998F,
	49548 - 44032: 0xBCD2,
	49549 - 44032: 0xBCD3,
	49550 - 44032: 0xBCD4,
	49551 - 44032: 0x9990,
	49552 - 44032: 0xBCD5,
	49553 - 44032: 0x9991,
	49554 - 44032: 0x9992,
	49555 - 44032: 0x9993,
	49556 - 44032: 0xBCD6,
	49557 - 44032: 0x9994,
	49558 - 44032: 0xBCD7,
	49559 - 44032: 0x9995,
	49560 - 44032: 0x9996,
	49561 - 44032: 0x9997,
	49562 - 44032: 0x9998,
	49563 - 44032: 0x9999,
	49564 - 44032: 0xBCD8,
	49565 - 44032: 0xBCD9,
	49566 - 44032: 0x999A,
	49567 - 44032: 0xBCDA,
	49568 - 44032: 0x999B,
	49569 - 44032: 0xBCDB,
	49570 - 44032: 0x999C,
	49571 - 44032: 0x999D,
	49572 - 44032: 0x999E,
	49573 - 44032: 0xBCDC,
	49574 - 44032: 0x999F,
	49575 - 44032: 0x99A0,
	49576 - 44032: 0xBCDD,
	49577 - 44032: 0xBCDE,
	49578 - 44032: 0x99A1,
	49579 - 44032: 0x99A2,
	49580 - 44032: 0xBCDF,
	49581 - 44032: 0x99A3,
	49582 - 44032: 0x99A4,
	49583 - 44032: 0x99A5,
	49584 - 44032: 0xBCE0,
	49585 - 44032: 0x99A6,
	49586 - 44032: 0x99A7,
	49587 - 44032: 0x99A8,
	49588 - 44032: 0x99A9,
	49589 - 44032: 0x99AA,
	49590 - 44032: 0x99AB,
	49591 - 44032: 0x99AC,
	49592 - 44032: 0x99AD,
	49593 - 44032: 0x99AE,
	49594 - 44032: 0x99AF,
	49595 - 44032: 0x99B0,
	49596 - 44032: 0x99B1,
	49597 - 44032: 0xBCE1,
	49598 - 44032: 0x99B2,
	49599 - 44032: 0x99B3,
	49600 - 44032: 0x99B4,
	49601 - 44032: 0x99B5,
	49602 - 44032: 0x99B6,
	49603 - 44032: 0x99B7,
	49604 - 44032: 0xBCE2,
	49605 - 44032: 0x99B8,
	49606 - 44032: 0x99B9,
	49607 - 44032: 0x99BA,
	49608 - 44032: 0xBCE3,
	49609 - 44032: 0x99BB,
	49610 - 44032: 0x99BC,
	49611 - 44032: 0x99BD,
	49612 - 44032: 0xBCE4,
	49613 - 44032: 0x99BE,
	49614 - 44032: 0x99BF,
	49615 - 44032: 0x99C0,
	49616 - 44032: 0x99C1,
	49617 - 44032: 0x99C2,
	49618 - 44032: 0x99C3,
	49619 - 44032: 0x99C4,
	49620 - 44032: 0xBCE5,
	49621 - 44032: 0x99C5,
	49622 - 44032: 0x99C6,
	49623 - 44032: 0xBCE6,
	49624 - 44032: 0xBCE7,
	49625 - 44032: 0x99C7,
	49626 - 44032: 0x99C8,
	49627 - 44032: 0x99C9,
	49628 - 44032: 0x99CA,
	49629 - 44032: 0x99CB,
	49630 - 44032: 0x99CC,
	49631 - 44032: 0x99CD,
	49632 - 44032: 0xBCE8,
	49633 - 44032: 0x99CE,
	49634 - 44032: 0x99CF,
	49635 - 44032: 0x99D0,
	49636 - 44032: 0xBCE9,
	49637 - 44032: 0x99D1,
	49638 - 44032: 0x99D2,
	49639 - 44032: 0x99D3,
	49640 - 44032: 0xBCEA,
	49641 - 44032: 0x99D4,
	49642 - 44032: 0x99D5,
	49643 - 44032: 0x99D6,
	49644 - 44032: 0x99D7,
	49645 - 44032: 0x99D8,
	49646 - 44032: 0x99D9,
	49647 - 44032: 0x99DA,
	49648 - 44032: 0xBCEB,
	49649 - 44032: 0xBCEC,
	49650 - 44032: 0x99DB,
	49651 - 44032: 0xBCED,
	49652 - 44032: 0x99DC,
	49653 - 44032: 0x99DD,
	49654 - 44032: 0x99DE,
	49655 - 44032: 0x99DF,
	49656 - 44032: 0x99E0,
	49657 - 44032: 0x99E1,
	49658 - 44032: 0x99E2,
	49659 - 44032: 0x99E3,
	49660 - 44032: 0xBCEE,
	49661 - 44032: 0xBCEF,
	49662 - 44032: 0x99E4,
	49663 - 44032: 0x99E5,
	49664 - 44032: 0xBCF0,
	49665 - 44032: 0x99E6,
	49666 - 44032: 0x99E7,
	49667 - 44032: 0x99E8,
	49668 - 44032: 0xBCF1,
	49669 - 44032: 0x99E9,
	49670 - 44032: 0x99EA,
	49671 - 44032: 0x99EB,
	49672 - 44032: 0x99EC,
	49673 - 44032: 0x99ED,
	49674 - 44032: 0x99EE,
	49675 - 44032: 0x99EF,
	49676 - 44032: 0xBCF2,
	49677 - 44032: 0xBCF3,
	49678 - 44032: 0x99F0,
	49679 - 44032: 0xBCF4,
	49680 - 44032: 0x99F1,
	49681 - 44032: 0xBCF5,
	49682 - 44032: 0x99F2,
	49683 - 44032: 0x99F3,
	49684 - 44032: 0x99F4,
	49685 - 44032: 0x99F5,
	49686 - 44032: 0x99F6,
	49687 - 44032: 0x99F7,
	49688 - 44032: 0xBCF6,
	49689 - 44032: 0xBCF7,
	49690 - 44032: 0x99F8,
	49691 - 44032: 0x99F9,
	49692 - 44032: 0xBCF8,
	49693 - 44032: 0x99FA,
	49694 - 44032: 0x99FB,
	49695 - 44032: 0xBCF9,
	49696 - 44032: 0xBCFA,
	49697 - 44032: 0x99FC,
	49698 - 44032: 0x99FD,
	49699 - 44032: 0x99FE,
	49700 - 44032: 0x9A41,
	49701 - 44032: 0x9A42,
	49702 - 44032: 0x9A43,
	49703 - 44032: 0x9A44,
	49704 - 44032: 0xBCFB,
	49705 - 44032: 0xBCFC,
	49706 - 44032: 0x9A45,
	49707 - 44032: 0xBCFD,
	49708 - 44032: 0x9A46,
	49709 - 44032: 0xBCFE,
	49710 - 44032: 0x9A47,
	49711 - 44032: 0xBDA1,
	49712 - 44032: 0x9A48,
	49713 - 44032: 0xBDA2,
	49714 - 44032: 0xBDA3,
	49715 - 44032: 0x9A49,
	49716 - 44032: 0xBDA4,
	49717 - 44032: 0x9A4A,
	49718 - 44032: 0x9A4B,
	49719 - 44032: 0x9A4C,
	49720 - 44032: 0x9A4D,
	49721 - 44032: 0x9A4E,
	49722 - 44032: 0x9A4F,
	49723 - 44032: 0x9A50,
	49724 - 44032: 0x9A51,
	49725 - 44032: 0x9A52,
	49726 - 44032: 0x9A53,
	49727 - 44032: 0x9A54,
	49728 - 44032: 0x9A55,
	49729 - 44032: 0x9A56,
	49730 - 44032: 0x9A57,
	49731 - 44032: 0x9A58,
	49732 - 44032: 0x9A59,
	49733 - 44032: 0x9A5A,
	49734 - 44032: 0x9A61,
	49735 - 44032: 0x9A62,
	49736 - 44032: 0xBDA5,
	49737 - 44032: 0x9A63,
	49738 - 44032: 0x9A64,
	49739 - 44032: 0x9A65,
	49740 - 44032: 0x9A66,
	49741 - 44032: 0x9A67,
	49742 - 44032: 0x9A68,
	49743 - 44032: 0x9A69,
	49744 - 44032: 0xBDA6,
	49745 - 44032: 0xBDA7,
	49746 - 44032: 0x9A6A,
	49747 - 44032: 0x9A6B,
	49748 - 44032: 0xBDA8,
	49749 - 44032: 0x9A6C,
	49750 - 44032: 0x9A6D,
	49751 - 44032: 0x9A6E,
	49752 - 44032: 0xBDA9,
	49753 - 44032: 0x9A6F,
	49754 - 44032: 0x9A70,
	49755 - 44032: 0x9A71,
	49756 - 44032: 0x9A72,
	49757 - 44032: 0x9A73,
	49758 - 44032: 0x9A74,
	49759 - 44032: 0x9A75,
	49760 - 44032: 0xBDAA,
	49761 - 44032: 0x9A76,
	49762 - 44032: 0x9A77,
	49763 - 44032: 0x9A78,
	49764 - 44032: 0x9A79,
	49765 - 44032: 0xBDAB,
	49766 - 44032: 0x9A7A,
	49767 - 44032: 0x9A81,
	49768 - 44032: 0x9A82,
	49769 - 44032: 0x9A83,
	49770 - 44032: 0x9A84,
	49771 - 44032: 0x9A85,
	49772 - 44032: 0xBDAC,
	49773 - 44032: 0xBDAD,
	49774 - 44032: 0x9A86,
	49775 - 44032: 0x9A87,
	49776 - 44032: 0xBDAE,
	49777 - 44032: 0x9A88,
	49778 - 44032: 0x9A89,
	49779 - 44032: 0x9A8A,
	49780 - 44032: 0xBDAF,
	49781 - 44032: 0x9A8B,
	49782 - 44032: 0x9A8C,
	49783 - 44032: 0x9A8D,
	49784 - 44032: 0x9A8E,
	49785 - 44032: 0x9A8F,
	49786 - 44032: 0x9A90,
	49787 - 44032: 0x9A91,
	49788 - 44032: 0xBDB0,
	49789 - 44032: 0xBDB1,
	49790 - 44032: 0x9A92,
	49791 - 44032: 0xBDB2,
	49792 - 44032: 0x9A93,
	49793 - 44032: 0xBDB3,
	49794 - 44032: 0x9A94,
	49795 - 44032: 0x9A95,
	49796 - 44032: 0x9A96,
	49797 - 44032: 0x9A97,
	49798 - 44032: 0x9A98,
	49799 - 44032: 0x9A99,
	49800 - 44032: 0xBDB4,
	49801 - 44032: 0xBDB5,
	49802 - 44032: 0x9A9A,
	49803 - 44032: 0x9A9B,
	49804 - 44032: 0x9A9C,
	49805 - 44032: 0x9A9D,
	49806 - 44032: 0x9A9E,
	49807 - 44032: 0x9A9F,
	49808 - 44032: 0xBDB6,
	49809 - 44032: 0x9AA0,
	49810 - 44032: 0x9AA1,
	49811 - 44032: 0x9AA2,
	49812 - 44032: 0x9AA3,
	49813 - 44032: 0x9AA4,
	49814 - 44032: 0x9AA5,
	49815 - 44032: 0x9AA6,
	49816 - 44032: 0xBDB7,
	49817 - 44032: 0x9AA7,
	49818 - 44032: 0x9AA8,
	49819 - 44032: 0xBDB8,
	49820 - 44032: 0x9AA9,
	49821 - 44032: 0xBDB9,
	49822 - 44032: 0x9AAA,
	49823 - 44032: 0x9AAB,
	49824 - 44032: 0x9AAC,
	49825 - 44032: 0x9AAD,
	49826 - 44032: 0x9AAE,
	49827 - 44032: 0x9AAF,
	49828 - 44032: 0xBDBA,
	49829 - 44032: 0xBDBB,
	49830 - 44032: 0x9AB0,
	49831 - 44032: 0x9AB1,
	49832 - 44032: 0xBDBC,
	49833 - 44032: 0x9AB2,
	49834 - 44032: 0x9AB3,
	49835 - 44032: 0x9AB4,
	49836 - 44032: 0xBDBD,
	49837 - 44032: 0xBDBE,
	49838 - 44032: 0x9AB5,
	49839 - 44032: 0x9AB6,
	49840 - 44032: 0x9AB7,
	49841 - 44032: 0x9AB8,
	49842 - 44032: 0x9AB9,
	49843 - 44032: 0x9ABA,
	49844 - 44032: 0xBDBF,
	49845 - 44032: 0xBDC0,
	49846 - 44032: 0x9ABB,
	49847 - 44032: 0xBDC1,
	49848 - 44032: 0x9ABC,
	49849 - 44032: 0xBDC2,
	49850 - 44032: 0x9ABD,
	49851 - 44032: 0x9ABE,
	49852 - 44032: 0x9ABF,
	49853 - 44032: 0x9AC0,
	49854 - 44032: 0x9AC1,
	49855 - 44032: 0x9AC2,
	49856 - 44032: 0x9AC3,
	49857 - 44032: 0x9AC4,
	49858 - 44032: 0x9AC5,
	49859 - 44032: 0x9AC6,
	49860 - 44032: 0x9AC7,
	49861 - 44032: 0x9AC8,
	49862 - 44032: 0x9AC9,
	49863 - 44032: 0x9ACA,
	49864 - 44032: 0x9ACB,
	49865 - 44032: 0x9ACC,
	49866 - 44032: 0x9ACD,
	49867 - 44032: 0x9ACE,
	49868 - 44032: 0x9ACF,
	49869 - 44032: 0x9AD0,
	49870 - 44032: 0x9AD1,
	49871 - 44032: 0x9AD2,
	49872 - 44032: 0x9AD3,
	49873 - 44032: 0x9AD4,
	49874 - 44032: 0x9AD5,
	49875 - 44032: 0x9AD6,
	49876 - 44032: 0x9AD7,
	49877 - 44032: 0x9AD8,
	49878 - 44032: 0x9AD9,
	49879 - 44032: 0x9ADA,
	49880 - 44032: 0x9ADB,
	49881 - 44032: 0x9ADC,
	49882 - 44032: 0x9ADD,
	49883 - 44032: 0x9ADE,
	49884 - 44032: 0xBDC3,
	49885 - 44032: 0xBDC4,
	49886 - 44032: 0x9ADF,
	49887 - 44032: 0x9AE0,
	49888 - 44032: 0xBDC5,
	49889 - 44032: 0x9AE1,
	49890 - 44032: 0x9AE2,
	49891 - 44032: 0xBDC6,
	49892 - 44032: 0xBDC7,
	49893 - 44032: 0x9AE3,
	49894 - 44032: 0x9AE4,
	49895 - 44032: 0x9AE5,
	49896 - 44032: 0x9AE6,
	49897 - 44032: 0x9AE7,
	49898 - 44032: 0x9AE8,
	49899 - 44032: 0xBDC8,
	49900 - 44032: 0xBDC9,
	49901 - 44032: 0xBDCA,
	49902 - 44032: 0x9AE9,
	49903 - 44032: 0xBDCB,
	49904 - 44032: 0x9AEA,
	49905 - 44032: 0xBDCC,
	49906 - 44032: 0x9AEB,
	49907 - 44032: 0x9AEC,
	49908 - 44032: 0x9AED,
	49909 - 44032: 0x9AEE,
	49910 - 44032: 0xBDCD,
	49911 - 44032: 0x9AEF,
	49912 - 44032: 0xBDCE,
	49913 - 44032: 0xBDCF,
	49914 - 44032: 0x9AF0,
	49915 - 44032: 0xBDD0,
	49916 - 44032: 0xBDD1,
	49917 - 44032: 0x9AF1,
	49918 - 44032: 0x9AF2,
	49919 - 44032: 0x9AF3,
	49920 - 44032: 0xBDD2,
	49921 - 44032: 0x9AF4,
	49922 - 44032: 0x9AF5,
	49923 - 44032: 0x9AF6,
	49924 - 44032: 0x9AF7,
	49925 - 44032: 0x9AF8,
	49926 - 44032: 0x9AF9,
	49927 - 44032: 0x9AFA,
	49928 - 44032: 0xBDD3,
	49929 - 44032: 0xBDD4,
	49930 - 44032: 0x9AFB,
	49931 - 44032: 0x9AFC,
	49932 - 44032: 0xBDD5,
	49933 - 44032: 0xBDD6,
	49934 - 44032: 0x9AFD,
	49935 - 44032: 0x9AFE,
	49936 - 44032: 0x9B41,
	49937 - 44032: 0x9B42,
	49938 - 44032: 0x9B43,
	49939 - 44032: 0xBDD7,
	49940 - 44032: 0xBDD8,
	49941 - 44032: 0xBDD9,
	49942 - 44032: 0x9B44,
	49943 - 44032: 0x9B45,
	49944 - 44032: 0xBDDA,
	49945 - 44032: 0x9B46,
	49946 - 44032: 0x9B47,
	49947 - 44032: 0x9B48,
	49948 - 44032: 0xBDDB,
	49949 - 44032: 0x9B49,
	49950 - 44032: 0x9B4A,
	49951 - 44032: 0x9B4B,
	49952 - 44032: 0x9B4C,
	49953 - 44032: 0x9B4D,
	49954 - 44032: 0x9B4E,
	49955 - 44032: 0x9B4F,
	49956 - 44032: 0xBDDC,
	49957 - 44032: 0xBDDD,
	49958 - 44032: 0x9B50,
	49959 - 44032: 0x9B51,
	49960 - 44032: 0xBDDE,
	49961 - 44032: 0xBDDF,
	49962 - 44032: 0x9B52,
	49963 - 44032: 0x9B53,
	49964 - 44032: 0x9B54,
	49965 - 44032: 0x9B55,
	49966 - 44032: 0x9B56,
	49967 - 44032: 0x9B57,
	49968 - 44032: 0x9B58,
	49969 - 44032: 0x9B59,
	49970 - 44032: 0x9B5A,
	49971 - 44032: 0x9B61,
	49972 - 44032: 0x9B62,
	49973 - 44032: 0x9B63,
	49974 - 44032: 0x9B64,
	49975 - 44032: 0x9B65,
	49976 - 44032: 0x9B66,
	49977 - 44032: 0x9B67,
	49978 - 44032: 0x9B68,
	49979 - 44032: 0x9B69,
	49980 - 44032: 0x9B6A,
	49981 - 44032: 0x9B6B,
	49982 - 44032: 0x9B6C,
	49983 - 44032: 0x9B6D,
	49984 - 44032: 0x9B6E,
	49985 - 44032: 0x9B6F,
	49986 - 44032: 0x9B70,
	49987 - 44032: 0x9B71,
	49988 - 44032: 0x9B72,
	49989 - 44032: 0xBDE0,
	49990 - 44032: 0x9B73,
	49991 - 44032: 0x9B74,
	49992 - 44032: 0x9B75,
	49993 - 44032: 0x9B76,
	49994 - 44032: 0x9B77,
	49995 - 44032: 0x9B78,
	49996 - 44032: 0x9B79,
	49997 - 44032: 0x9B7A,
	49998 - 44032: 0x9B81,
	49999 - 44032: 0x9B82,
	50000 - 44032: 0x9B83,
	50001 - 44032: 0x9B84,
	50002 - 44032: 0x9B85,
	50003 - 44032: 0x9B86,
	50004 - 44032: 0x9B87,
	50005 - 44032: 0x9B88,
	50006 - 44032: 0x9B89,
	50007 - 44032: 0x9B8A,
	50008 - 44032: 0x9B8B,
	50009 - 44032: 0x9B8C,
	50010 - 44032: 0x9B8D,
	50011 - 44032: 0x9B8E,
	50012 - 44032: 0x9B8F,
	50013 - 44032: 0x9B90,
	50014 - 44032: 0x9B91,
	50015 - 44032: 0x9B92,
	50016 - 44032: 0x9B93,
	50017 - 44032: 0x9B94,
	50018 - 44032: 0x9B95,
	50019 - 44032: 0x9B96,
	50020 - 44032: 0x9B97,
	50021 - 44032: 0x9B98,
	50022 - 44032: 0x9B99,
	50023 - 44032: 0x9B9A,
	50024 - 44032: 0xBDE1,
	50025 - 44032: 0xBDE2,
	50026 - 44032: 0x9B9B,
	50027 - 44032: 0x9B9C,
	50028 - 44032: 0xBDE3,
	50029 - 44032: 0x9B9D,
	50030 - 44032: 0x9B9E,
	50031 - 44032: 0x9B9F,
	50032 - 44032: 0xBDE4,
	50033 - 44032: 0x9BA0,
	50034 - 44032: 0xBDE5,
	50035 - 44032: 0x9BA1,
	50036 - 44032: 0x9BA2,
	50037 - 44032: 0x9BA3,
	50038 - 44032: 0x9BA4,
	50039 - 44032: 0x9BA5,
	50040 - 44032: 0xBDE6,
	50041 - 44032: 0xBDE7,
	50042 - 44032: 0x9BA6,
	50043 - 44032: 0x9BA7,
	50044 - 44032: 0xBDE8,
	50045 - 44032: 0xBDE9,
	50046 - 44032: 0x9BA8,
	50047 - 44032: 0x9BA9,
	50048 - 44032: 0x9BAA,
	50049 - 44032: 0x9BAB,
	50050 - 44032: 0x9BAC,
	50051 - 44032: 0x9BAD,
	50052 - 44032: 0xBDEA,
	50053 - 44032: 0x9BAE,
	50054 - 44032: 0x9BAF,
	50055 - 44032: 0x9BB0,
	50056 - 44032: 0xBDEB,
	50057 - 44032: 0x9BB1,
	50058 - 44032: 0x9BB2,
	50059 - 44032: 0x9BB3,
	50060 - 44032: 0xBDEC,
	50061 - 44032: 0x9BB4,
	50062 - 44032: 0x9BB5,
	50063 - 44032: 0x9BB6,
	50064 - 44032: 0x9BB7,
	50065 - 44032: 0x9BB8,
	50066 - 44032: 0x9BB9,
	50067 - 44032: 0x9BBA,
	50068 - 44032: 0x9BBB,
	50069 - 44032: 0x9BBC,
	50070 - 44032: 0x9BBD,
	50071 - 44032: 0x9BBE,
	50072 - 44032: 0x9BBF,
	50073 - 44032: 0x9BC0,
	50074 - 44032: 0x9BC1,
	50075 - 44032: 0x9BC2,
	50076 - 44032: 0x9BC3,
	50077 - 44032: 0x9BC4,
	50078 - 44032: 0x9BC5,
	50079 - 44032: 0x9BC6,
	50080 - 44032: 0x9BC7,
	50081 - 44032: 0x9BC8,
	50082 - 44032: 0x9BC9,
	50083 - 44032: 0x9BCA,
	50084 - 44032: 0x9BCB,
	50085 - 44032: 0x9BCC,
	50086 - 44032: 0x9BCD,
	50087 - 44032: 0x9BCE,
	50088 - 44032: 0x9BCF,
	50089 - 44032: 0x9BD0,
	50090 - 44032: 0x9BD1,
	50091 - 44032: 0x9BD2,
	50092 - 44032: 0x9BD3,
	50093 - 44032: 0x9BD4,
	50094 - 44032: 0x9BD5,
	50095 - 44032: 0x9BD6,
	50096 - 44032: 0x9BD7,
	50097 - 44032: 0x9BD8,
	50098 - 44032: 0x9BD9,
	50099 - 44032: 0x9BDA,
	50100 - 44032: 0x9BDB,
	50101 - 44032: 0x9BDC,
	50102 - 44032: 0x9BDD,
	50103 - 44032: 0x9BDE,
	50104 - 44032: 0x9BDF,
	50105 - 44032: 0x9BE0,
	50106 - 44032: 0x9BE1,
	50107 - 44032: 0x9BE2,
	50108 - 44032: 0x9BE3,
	50109 - 44032: 0x9BE4,
	50110 - 44032: 0x9BE5,
	50111 - 44032: 0x9BE6,
	50112 - 44032: 0xBDED,
	50113 - 44032: 0x9BE7,
	50114 - 44032: 0x9BE8,
	50115 - 44032: 0x9BE9,
	50116 - 44032: 0x9BEA,
	50117 - 44032: 0x9BEB,
	50118 - 44032: 0x9BEC,
	50119 - 44032: 0x9BED,
	50120 - 44032: 0x9BEE,
	50121 - 44032: 0x9BEF,
	50122 - 44032: 0x9BF0,
	50123 - 44032: 0x9BF1,
	50124 - 44032: 0x9BF2,
	50125 - 44032: 0x9BF3,
	50126 - 44032: 0x9BF4,
	50127 - 44032: 0x9BF5,
	50128 - 44032: 0x9BF6,
	50129 - 44032: 0x9BF7,
	50130 - 44032: 0x9BF8,
	50131 - 44032: 0x9BF9,
	50132 - 44032: 0x9BFA,
	50133 - 44032: 0x9BFB,
	50134 - 44032: 0x9BFC,
	50135 - 44032: 0x9BFD,
	50136 - 44032: 0xBDEE,
	50137 - 44032: 0xBDEF,
	50138 - 44032: 0x9BFE,
	50139 - 44032: 0x9C41,
	50140 - 44032: 0xBDF0,
	50141 - 44032: 0x9C42,
	50142 - 44032: 0x9C43,
	50143 - 44032: 0xBDF1,
	50144 - 44032: 0xBDF2,
	50145 - 44032: 0x9C44,
	50146 - 44032: 0xBDF3,
	50147 - 44032: 0x9C45,
	50148 - 44032: 0x9C46,
	50149 - 44032: 0x9C47,
	50150 - 44032: 0x9C48,
	50151 - 44032: 0x9C49,
	50152 - 44032: 0xBDF4,
	50153 - 44032: 0xBDF5,
	50154 - 44032: 0x9C4A,
	50155 - 44032: 0x9C4B,
	50156 - 44032: 0x9C4C,
	50157 - 44032: 0xBDF6,
	50158 - 44032: 0x9C4D,
	50159 - 44032: 0x9C4E,
	50160 - 44032: 0x9C4F,
	50161 - 44032: 0x9C50,
	50162 - 44032: 0x9C51,
	50163 - 44032: 0x9C52,
	50164 - 44032: 0xBDF7,
	50165 - 44032: 0xBDF8,
	50166 - 44032: 0x9C53,
	50167 - 44032: 0x9C54,
	50168 - 44032: 0xBDF9,
	50169 - 44032: 0x9C55,
	50170 - 44032: 0x9C56,
	50171 - 44032: 0x9C57,
	50172 - 44032: 0x9C58,
	50173 - 44032: 0x9C59,
	50174 - 44032: 0x9C5A,
	50175 - 44032: 0x9C61,
	50176 - 44032: 0x9C62,
	50177 - 44032: 0x9C63,
	50178 - 44032: 0x9C64,
	50179 - 44032: 0x9C65,
	50180 - 44032: 0x9C66,
	50181 - 44032: 0x9C67,
	50182 - 44032: 0x9C68,
	50183 - 44032: 0x9C69,
	50184 - 44032: 0xBDFA,
	50185 - 44032: 0x9C6A,
	50186 - 44032: 0x9C6B,
	50187 - 44032: 0x9C6C,
	50188 - 44032: 0x9C6D,
	50189 - 44032: 0x9C6E,
	50190 - 44032: 0x9C6F,
	50191 - 44032: 0x9C70,
	50192 - 44032: 0xBDFB,
	50193 - 44032: 0x9C71,
	50194 - 44032: 0x9C72,
	50195 - 44032: 0x9C73,
	50196 - 44032: 0x9C74,
	50197 - 44032: 0x9C75,
	50198 - 44032: 0x9C76,
	50199 - 44032: 0x9C77,
	50200 - 44032: 0x9C78,
	50201 - 44032: 0x9C79,
	50202 - 44032: 0x9C7A,
	50203 - 44032: 0x9C81,
	50204 - 44032: 0x9C82,
	50205 - 44032: 0x9C83,
	50206 - 44032: 0x9C84,
	50207 - 44032: 0x9C85,
	50208 - 44032: 0x9C86,
	50209 - 44032: 0x9C87,
	50210 - 44032: 0x9C88,
	50211 - 44032: 0x9C89,
	50212 - 44032: 0xBDFC,
	50213 - 44032: 0x9C8A,
	50214 - 44032: 0x9C8B,
	50215 - 44032: 0x9C8C,
	50216 - 44032: 0x9C8D,
	50217 - 44032: 0x9C8E,
	50218 - 44032: 0x9C8F,
	50219 - 44032: 0x9C90,
	50220 - 44032: 0xBDFD,
	50221 - 44032: 0x9C91,
	50222 - 44032: 0x9C92,
	50223 - 44032: 0x9C93,
	50224 - 44032: 0xBDFE,
	50225 - 44032: 0x9C94,
	50226 - 44032: 0x9C95,
	50227 - 44032: 0x9C96,
	50228 - 44032: 0xBEA1,
	50229 - 44032: 0x9C97,
	50230 - 44032: 0x9C98,
	50231 - 44032: 0x9C99,
	50232 - 44032: 0x9C9A,
	50233 - 44032: 0x9C9B,
	50234 - 44032: 0x9C9C,
	50235 - 44032: 0x9C9D,
	50236 - 44032: 0xBEA2,
	50237 - 44032: 0xBEA3,
	50238 - 44032: 0x9C9E,
	50239 - 44032: 0x9C9F,
	50240 - 44032: 0x9CA0,
	50241 - 44032: 0x9CA1,
	50242 - 44032: 0x9CA2,
	50243 - 44032: 0x9CA3,
	50244 - 44032: 0x9CA4,
	50245 - 44032: 0x9CA5,
	50246 - 44032: 0x9CA6,
	50247 - 44032: 0x9CA7,
	50248 - 44032: 0xBEA4,
	50249 - 44032: 0x9CA8,
	50250 - 44032: 0x9CA9,
	50251 - 44032: 0x9CAA,
	50252 - 44032: 0x9CAB,
	50253 - 44032: 0x9CAC,
	50254 - 44032: 0x9CAD,
	50255 - 44032: 0x9CAE,
	50256 - 44032: 0x9CAF,
	50257 - 44032: 0x9CB0,
	50258 - 44032: 0x9CB1,
	50259 - 44032: 0x9CB2,
	50260 - 44032: 0x9CB3,
	50261 - 44032: 0x9CB4,
	50262 - 44032: 0x9CB5,
	50263 - 44032: 0x9CB6,
	50264 - 44032: 0x9CB7,
	50265 - 44032: 0x9CB8,
	50266 - 44032: 0x9CB9,
	50267 - 44032: 0x9CBA,
	50268 - 44032: 0x9CBB,
	50269 - 44032: 0x9CBC,
	50270 - 44032: 0x9CBD,
	50271 - 44032: 0x9CBE,
	50272 - 44032: 0x9CBF,
	50273 - 44032: 0x9CC0,
	50274 - 44032: 0x9CC1,
	50275 - 44032: 0x9CC2,
	50276 - 44032: 0xBEA5,
	50277 - 44032: 0xBEA6,
	50278 - 44032: 0x9CC3,
	50279 - 44032: 0x9CC4,
	50280 - 44032: 0xBEA7,
	50281 - 44032: 0x9CC5,
	50282 - 44032: 0x9CC6,
	50283 - 44032: 0x9CC7,
	50284 - 44032: 0xBEA8,
	50285 - 44032: 0x9CC8,
	50286 - 44032: 0x9CC9,
	50287 - 44032: 0x9CCA,
	50288 - 44032: 0x9CCB,
	50289 - 44032: 0x9CCC,
	50290 - 44032: 0x9CCD,
	50291 - 44032: 0x9CCE,
	50292 - 44032: 0xBEA9,
	50293 - 44032: 0xBEAA,
	50294 - 44032: 0x9CCF,
	50295 - 44032: 0x9CD0,
	50296 - 44032: 0x9CD1,
	50297 - 44032: 0xBEAB,
	50298 - 44032: 0x9CD2,
	50299 - 44032: 0x9CD3,
	50300 - 44032: 0x9CD4,
	50301 - 44032: 0x9CD5,
	50302 - 44032: 0x9CD6,
	50303 - 44032: 0x9CD7,
	50304 - 44032: 0xBEAC,
	50305 - 44032: 0x9CD8,
	50306 - 44032: 0x9CD9,
	50307 - 44032: 0x9CDA,
	50308 - 44032: 0x9CDB,
	50309 - 44032: 0x9CDC,
	50310 - 44032: 0x9CDD,
	50311 - 44032: 0x9CDE,
	50312 - 44032: 0x9CDF,
	50313 - 44032: 0x9CE0,
	50314 - 44032: 0x9CE1,
	50315 - 44032: 0x9CE2,
	50316 - 44032: 0x9CE3,
	50317 - 44032: 0x9CE4,
	50318 - 44032: 0x9CE5,
	50319 - 44032: 0x9CE6,
	50320 - 44032: 0x9CE7,
	50321 - 44032: 0x9CE8,
	50322 - 44032: 0x9CE9,
	50323 - 44032: 0x9CEA,
	50324 - 44032: 0xBEAD,
	50325 - 44032: 0x9CEB,
	50326 - 44032: 0x9CEC,
	50327 - 44032: 0x9CED,
	50328 - 44032: 0x9CEE,
	50329 - 44032: 0x9CEF,
	50330 - 44032: 0x9CF0,
	50331 - 44032: 0x9CF1,
	50332 - 44032: 0xBEAE,
	50333 - 44032: 0x9CF2,
	50334 - 44032: 0x9CF3,
	50335 - 44032: 0x9CF4,
	50336 - 44032: 0x9CF5,
	50337 - 44032: 0x9CF6,
	50338 - 44032: 0x9CF7,
	50339 - 44032: 0x9CF8,
	50340 - 44032: 0x9CF9,
	50341 - 44032: 0x9CFA,
	50342 - 44032: 0x9CFB,
	50343 - 44032: 0x9CFC,
	50344 - 44032: 0x9CFD,
	50345 - 44032: 0x9CFE,
	50346 - 44032: 0x9D41,
	50347 - 44032: 0x9D42,
	50348 - 44032: 0x9D43,
	50349 - 44032: 0x9D44,
	50350 - 44032: 0x9D45,
	50351 - 44032: 0x9D46,
	50352 - 44032: 0x9D47,
	50353 - 44032: 0x9D48,
	50354 - 44032: 0x9D49,
	50355 - 44032: 0x9D4A,
	50356 - 44032: 0x9D4B,
	50357 - 44032: 0x9D4C,
	50358 - 44032: 0x9D4D,
	50359 - 44032: 0x9D4E,
	50360 - 44032: 0xBEAF,
	50361 - 44032: 0x9D4F,
	50362 - 44032: 0x9D50,
	50363 - 44032: 0x9D51,
	50364 - 44032: 0xBEB0,
	50365 - 44032: 0x9D52,
	50366 - 44032: 0x9D53,
	50367 - 44032: 0x9D54,
	50368 - 44032: 0x9D55,
	50369 - 44032: 0x9D56,
	50370 - 44032: 0x9D57,
	50371 - 44032: 0x9D58,
	50372 - 44032: 0x9D59,
	50373 - 44032: 0x9D5A,
	50374 - 44032: 0x9D61,
	50375 - 44032: 0x9D62,
	50376 - 44032: 0x9D63,
	50377 - 44032: 0x9D64,
	50378 - 44032: 0x9D65,
	50379 - 44032: 0x9D66,
	50380 - 44032: 0x9D67,
	50381 - 44032: 0x9D68,
	50382 - 44032: 0x9D69,
	50383 - 44032: 0x9D6A,
	50384 - 44032: 0x9D6B,
	50385 - 44032: 0x9D6C,
	50386 - 44032: 0x9D6D,
	50387 - 44032: 0x9D6E,
	50388 - 44032: 0x9D6F,
	50389 - 44032: 0x9D70,
	50390 - 44032: 0x9D71,
	50391 - 44032: 0x9D72,
	50392 - 44032: 0x9D73,
	50393 - 44032: 0x9D74,
	50394 - 44032: 0x9D75,
	50395 - 44032: 0x9D76,
	50396 - 44032: 0x9D77,
	50397 - 44032: 0x9D78,
	50398 - 44032: 0x9D79,
	50399 - 44032: 0x9D7A,
	50400 - 44032: 0x9D81,
	50401 - 44032: 0x9D82,
	50402 - 44032: 0x9D83,
	50403 - 44032: 0x9D84,
	50404 - 44032: 0x9D85,
	50405 - 44032: 0x9D86,
	50406 - 44032: 0x9D87,
	50407 - 44032: 0x9D88,
	50408 - 44032: 0x9D89,
	50409 - 44032: 0xBEB1,
	50410 - 44032: 0x9D8A,
	50411 - 44032: 0x9D8B,
	50412 - 44032: 0x9D8C,
	50413 - 44032: 0x9D8D,
	50414 - 44032: 0x9D8E,
	50415 - 44032: 0x9D8F,
	50416 - 44032: 0xBEB2,
	50417 - 44032: 0xBEB3,
	50418 - 44032: 0x9D90,
	50419 - 44032: 0x9D91,
	50420 - 44032: 0xBEB4,
	50421 - 44032: 0x9D92,
	50422 - 44032: 0x9D93,
	50423 - 44032: 0x9D94,
	50424 - 44032: 0xBEB5,
	50425 - 44032: 0x9D95,
	50426 - 44032: 0xBEB6,
	50427 - 44032: 0x9D96,
	50428 - 44032: 0x9D97,
	50429 - 44032: 0x9D98,
	50430 - 44032: 0x9D99,
	50431 - 44032: 0xBEB7,
	50432 - 44032: 0xBEB8,
	50433 - 44032: 0xBEB9,
	50434 - 44032: 0x9D9A,
	50435 - 44032: 0x9D9B,
	50436 - 44032: 0x9D9C,
	50437 - 44032: 0x9D9D,
	50438 - 44032: 0x9D9E,
	50439 - 44032: 0x9D9F,
	50440 - 44032: 0x9DA0,
	50441 - 44032: 0x9DA1,
	50442 - 44032: 0x9DA2,
	50443 - 44032: 0x9DA3,
	50444 - 44032: 0xBEBA,
	50445 - 44032: 0x9DA4,
	50446 - 44032: 0x9DA5,
	50447 - 44032: 0x9DA6,
	50448 - 44032: 0xBEBB,
	50449 - 44032: 0x9DA7,
	50450 - 44032: 0x9DA8,
	50451 - 44032: 0x9DA9,
	50452 - 44032: 0xBEBC,
	50453 - 44032: 0x9DAA,
	50454 - 44032: 0x9DAB,
	50455 - 44032: 0x9DAC,
	50456 - 44032: 0x9DAD,
	50457 - 44032: 0x9DAE,
	50458 - 44032: 0x9DAF,
	50459 - 44032: 0x9DB0,
	50460 - 44032: 0xBEBD,
	50461 - 44032: 0x9DB1,
	50462 - 44032: 0x9DB2,
	50463 - 44032: 0x9DB3,
	50464 - 44032: 0x9DB4,
	50465 - 44032: 0x9DB5,
	50466 - 44032: 0x9DB6,
	50467 - 44032: 0x9DB7,
	50468 - 44032: 0x9DB8,
	50469 - 44032: 0x9DB9,
	50470 - 44032: 0x9DBA,
	50471 - 44032: 0x9DBB,
	50472 - 44032: 0xBEBE,
	50473 - 44032: 0xBEBF,
	50474 - 44032: 0x9DBC,
	50475 - 44032: 0x9DBD,
	50476 - 44032: 0xBEC0,
	50477 - 44032: 0x9DBE,
	50478 - 44032: 0x9DBF,
	50479 - 44032: 0x9DC0,
	50480 - 44032: 0xBEC1,
	50481 - 44032: 0x9DC1,
	50482 - 44032: 0x9DC2,
	50483 - 44032: 0x9DC3,
	50484 - 44032: 0x9DC4,
	50485 - 44032: 0x9DC5,
	50486 - 44032: 0x9DC6,
	50487 - 44032: 0x9DC7,
	50488 - 44032: 0xBEC2,
	50489 - 44032: 0xBEC3,
	50490 - 44032: 0x9DC8,
	50491 - 44032: 0xBEC4,
	50492 - 44032: 0x9DC9,
	50493 - 44032: 0xBEC5,
	50494 - 44032: 0x9DCA,
	50495 - 44032: 0x9DCB,
	50496 - 44032: 0x9DCC,
	50497 - 44032: 0x9DCD,
	50498 - 44032: 0x9DCE,
	50499 - 44032: 0x9DCF,
	50500 - 44032: 0xBEC6,
	50501 - 44032: 0xBEC7,
	50502 - 44032: 0x9DD0,
	50503 - 44032: 0x9DD1,
	50504 - 44032: 0xBEC8,
	50505 - 44032: 0xBEC9,
	50506 - 44032: 0xBECA,
	50507 - 44032: 0x9DD2,
	50508 - 44032: 0xBECB,
	50509 - 44032: 0xBECC,
	50510 - 44032: 0xBECD,
	50511 - 44032: 0x9DD3,
	50512 - 44032: 0x9DD4,
	50513 - 44032: 0x9DD5,
	50514 - 44032: 0x9DD6,
	50515 - 44032: 0xBECE,
	50516 - 44032: 0xBECF,
	50517 - 44032: 0xBED0,
	50518 - 44032: 0x9DD7,
	50519 - 44032: 0xBED1,
	50520 - 44032: 0xBED2,
	50521 - 44032: 0xBED3,
	50522 - 44032: 0x9DD8,
	50523 - 44032: 0x9DD9,
	50524 - 44032: 0x9DDA,
	50525 - 44032: 0xBED4,
	50526 - 44032: 0xBED5,
	50527 - 44032: 0x9DDB,
	50528 - 44032: 0xBED6,
	50529 - 44032: 0xBED7,
	50530 - 44032: 0x9DDC,
	50531 - 44032: 0x9DDD,
	50532 - 44032: 0xBED8,
	50533 - 44032: 0x9DDE,
	50534 - 44032: 0x9DDF,
	50535 - 44032: 0x9DE0,
	50536 - 44032: 0xBED9,
	50537 - 44032: 0x9DE1,
	50538 - 44032: 0x9DE2,
	50539 - 44032: 0x9DE3,
	50540 - 44032: 0x9DE4,
	50541 - 44032: 0x9DE5,
	50542 - 44032: 0x9DE6,
	50543 - 44032: 0x9DE7,
	50544 - 44032: 0xBEDA,
	50545 - 44032: 0xBEDB,
	50546 - 44032: 0x9DE8,
	50547 - 44032: 0xBEDC,
	50548 - 44032: 0xBEDD,
	50549 - 44032: 0xBEDE,
	50550 - 44032: 0x9DE9,
	50551 - 44032: 0x9DEA,
	50552 - 44032: 0x9DEB,
	50553 - 44032: 0x9DEC,
	50554 - 44032: 0x9DED,
	50555 - 44032: 0x9DEE,
	50556 - 44032: 0xBEDF,
	50557 - 44032: 0xBEE0,
	50558 - 44032: 0x9DEF,
	50559 - 44032: 0x9DF0,
	50560 - 44032: 0xBEE1,
	50561 - 44032: 0x9DF1,
	50562 - 44032: 0x9DF2,
	50563 - 44032: 0x9DF3,
	50564 - 44032: 0xBEE2,
	50565 - 44032: 0x9DF4,
	50566 - 44032: 0x9DF5,
	50567 - 44032: 0xBEE3,
	50568 - 44032: 0x9DF6,
	50569 - 44032: 0x9DF7,
	50570 - 44032: 0x9DF8,
	50571 - 44032: 0x9DF9,
	50572 - 44032: 0xBEE4,
	50573 - 44032: 0xBEE5,
	50574 - 44032: 0x9DFA,
	50575 - 44032: 0xBEE6,
	50576 - 44032: 0x9DFB,
	50577 - 44032: 0xBEE7,
	50578 - 44032: 0x9DFC,
	50579 - 44032: 0x9DFD,
	50580 - 44032: 0x9DFE,
	50581 - 44032: 0xBEE8,
	50582 - 44032: 0x9E41,
	50583 - 44032: 0xBEE9,
	50584 - 44032: 0xBEEA,
	50585 - 44032: 0x9E42,
	50586 - 44032: 0x9E43,
	50587 - 44032: 0x9E44,
	50588 - 44032: 0xBEEB,
	50589 - 44032: 0x9E45,
	50590 - 44032: 0x9E46,
	50591 - 44032: 0x9E47,
	50592 - 44032: 0xBEEC,
	50593 - 44032: 0x9E48,
	50594 - 44032: 0x9E49,
	50595 - 44032: 0x9E4A,
	50596 - 44032: 0x9E4B,
	50597 - 44032: 0x9E4C,
	50598 - 44032: 0x9E4D,
	50599 - 44032: 0x9E4E,
	50600 - 44032: 0x9E4F,
	50601 - 44032: 0xBEED,
	50602 - 44032: 0x9E50,
	50603 - 44032: 0x9E51,
	50604 - 44032: 0x9E52,
	50605 - 44032: 0x9E53,
	50606 - 44032: 0x9E54,
	50607 - 44032: 0x9E55,
	50608 - 44032: 0x9E56,
	50609 - 44032: 0x9E57,
	50610 - 44032: 0x9E58,
	50611 - 44032: 0x9E59,
	50612 - 44032: 0xBEEE,
	50613 - 44032: 0xBEEF,
	50614 - 44032: 0x9E5A,
	50615 - 44032: 0x9E61,
	50616 - 44032: 0xBEF0,
	50617 - 44032: 0xBEF1,
	50618 - 44032: 0x9E62,
	50619 - 44032: 0xBEF2,
	50620 - 44032: 0xBEF3,
	50621 - 44032: 0xBEF4,
	50622 - 44032: 0xBEF5,
	50623 - 44032: 0x9E63,
	50624 - 44032: 0x9E64,
	50625 - 44032: 0x9E65,
	50626 - 44032: 0x9E66,
	50627 - 44032: 0x9E67,
	50628 - 44032: 0xBEF6,
	50629 - 44032: 0xBEF7,
	50630 - 44032: 0xBEF8,
	50631 - 44032: 0xBEF9,
	50632 - 44032: 0xBEFA,
	50633 - 44032: 0xBEFB,
	50634 - 44032: 0xBEFC,
	50635 - 44032: 0x9E68,
	50636 - 44032: 0xBEFD,
	50637 - 44032: 0x9E69,
	50638 - 44032: 0xBEFE,
	50639 - 44032: 0x9E6A,
	50640 - 44032: 0xBFA1,
	50641 - 44032: 0xBFA2,
	50642 - 44032: 0x9E6B,
	50643 - 44032: 0x9E6C,
	50644 - 44032: 0xBFA3,
	50645 - 44032: 0x9E6D,
	50646 - 44032: 0x9E6E,
	50647 - 44032: 0x9E6F,
	50648 - 44032: 0xBFA4,
	50649 - 44032: 0x9E70,
	50650 - 44032: 0x9E71,
	50651 - 44032: 0x9E72,
	50652 - 44032: 0x9E73,
	50653 - 44032: 0x9E74,
	50654 - 44032: 0x9E75,
	50655 - 44032: 0x9E76,
	50656 - 44032: 0xBFA5,
	50657 - 44032: 0xBFA6,
	50658 - 44032: 0x9E77,
	50659 - 44032: 0xBFA7,
	50660 - 44032: 0x9E78,
	50661 - 44032: 0xBFA8,
	50662 - 44032: 0x9E79,
	50663 - 44032: 0x9E7A,
	50664 - 44032: 0x9E81,
	50665 - 44032: 0x9E82,
	50666 - 44032: 0x9E83,
	50667 - 44032: 0x9E84,
	50668 - 44032: 0xBFA9,
	50669 - 44032: 0xBFAA,
	50670 - 44032: 0xBFAB,
	50671 - 44032: 0x9E85,
	50672 - 44032: 0xBFAC,
	50673 - 44032: 0x9E86,
	50674 - 44032: 0x9E87,
	50675 - 44032: 0x9E88,
	50676 - 44032: 0xBFAD,
	50677 - 44032: 0x9E89,
	50678 - 44032: 0xBFAE,
	50679 - 44032: 0xBFAF,
	50680 - 44032: 0x9E8A,
	50681 - 44032: 0x9E8B,
	50682 - 44032: 0x9E8C,
	50683 - 44032: 0x9E8D,
	50684 - 44032: 0xBFB0,
	50685 - 44032: 0xBFB1,
	50686 - 44032: 0xBFB2,
	50687 - 44032: 0xBFB3,
	50688 - 44032: 0xBFB4,
	50689 - 44032: 0xBFB5,
	50690 - 44032: 0x9E8E,
	50691 - 44032: 0x9E8F,
	50692 - 44032: 0x9E90,
	50693 - 44032: 0xBFB6,
	50694 - 44032: 0xBFB7,
	50695 - 44032: 0xBFB8,
	50696 - 44032: 0xBFB9,
	50697 - 44032: 0x9E91,
	50698 - 44032: 0x9E92,
	50699 - 44032: 0x9E93,
	50700 - 44032: 0xBFBA,
	50701 - 44032: 0x9E94,
	50702 - 44032: 0x9E95,
	50703 - 44032: 0x9E96,
	50704 - 44032: 0xBFBB,
	50705 - 44032: 0x9E97,
	50706 - 44032: 0x9E98,
	50707 - 44032: 0x9E99,
	50708 - 44032: 0x9E9A,
	50709 - 44032: 0x9E9B,
	50710 - 44032: 0x9E9C,
	50711 - 44032: 0x9E9D,
	50712 - 44032: 0xBFBC,
	50713 - 44032: 0xBFBD,
	50714 - 44032: 0x9E9E,
	50715 - 44032: 0xBFBE,
	50716 - 44032: 0xBFBF,
	50717 - 44032: 0x9E9F,
	50718 - 44032: 0x9EA0,
	50719 - 44032: 0x9EA1,
	50720 - 44032: 0x9EA2,
	50721 - 44032: 0x9EA3,
	50722 - 44032: 0x9EA4,
	50723 - 44032: 0x9EA5,
	50724 - 44032: 0xBFC0,
	50725 - 44032: 0xBFC1,
	50726 - 44032: 0x9EA6,
	50727 - 44032: 0x9EA7,
	50728 - 44032: 0xBFC2,
	50729 - 44032: 0x9EA8,
	50730 - 44032: 0x9EA9,
	50731 - 44032: 0x9EAA,
	50732 - 44032: 0xBFC3,
	50733 - 44032: 0xBFC4,
	50734 - 44032: 0xBFC5,
	50735 - 44032: 0x9EAB,
	50736 - 44032: 0xBFC6,
	50737 - 44032: 0x9EAC,
	50738 - 44032: 0x9EAD,
	50739 - 44032: 0xBFC7,
	50740 - 44032: 0xBFC8,
	50741 - 44032: 0xBFC9,
	50742 - 44032: 0x9EAE,
	50743 - 44032: 0xBFCA,
	50744 - 44032: 0x9EAF,
	50745 - 44032: 0xBFCB,
	50746 - 44032: 0x9EB0,
	50747 - 44032: 0xBFCC,
	50748 - 44032: 0x9EB1,
	50749 - 44032: 0x9EB2,
	50750 - 44032: 0x9EB3,
	50751 - 44032: 0x9EB4,
	50752 - 44032: 0xBFCD,
	50753 - 44032: 0xBFCE,
	50754 - 44032: 0x9EB5,
	50755 - 44032: 0x9EB6,
	50756 - 44032: 0xBFCF,
	50757 - 44032: 0x9EB7,
	50758 - 44032: 0x9EB8,
	50759 - 44032: 0x9EB9,
	50760 - 44032: 0xBFD0,
	50761 - 44032: 0x9EBA,
	50762 - 44032: 0x9EBB,
	50763 - 44032: 0x9EBC,
	50764 - 44032: 0x9EBD,
	50765 - 44032: 0x9EBE,
	50766 - 44032: 0x9EBF,
	50767 - 44032: 0x9EC0,
	50768 - 44032: 0xBFD1,
	50769 - 44032: 0xBFD2,
	50770 - 44032: 0x9EC1,
	50771 - 44032: 0xBFD3,
	50772 - 44032: 0xBFD4,
	50773 - 44032: 0xBFD5,
	50774 - 44032: 0x9EC2,
	50775 - 44032: 0x9EC3,
	50776 - 44032: 0x9EC4,
	50777 - 44032: 0x9EC5,
	50778 - 44032: 0x9EC6,
	50779 - 44032: 0x9EC7,
	50780 - 44032: 0xBFD6,
	50781 - 44032: 0xBFD7,
	50782 - 44032: 0x9EC8,
	50783 - 44032: 0x9EC9,
	50784 - 44032: 0xBFD8,
	50785 - 44032: 0x9ECA,
	50786 - 44032: 0x9ECB,
	50787 - 44032: 0x9ECC,
	50788 - 44032: 0x9ECD,
	50789 - 44032: 0x9ECE,
	50790 - 44032: 0x9ECF,
	50791 - 44032: 0x9ED0,
	50792 - 44032: 0x9ED1,
	50793 - 44032: 0x9ED2,
	50794 - 44032: 0x9ED3,
	50795 - 44032: 0x9ED4,
	50796 - 44032: 0xBFD9,
	50797 - 44032: 0x9ED5,
	50798 - 44032: 0x9ED6,
	50799 - 44032: 0xBFDA,
	50800 - 44032: 0x9ED7,
	50801 - 44032: 0xBFDB,
	50802 - 44032: 0x9ED8,
	50803 - 44032: 0x9ED9,
	50804 - 44032: 0x9EDA,
	50805 - 44032: 0x9EDB,
	50806 - 44032: 0x9EDC,
	50807 - 44032: 0x9EDD,
	50808 - 44032: 0xBFDC,
	50809 - 44032: 0xBFDD,
	50810 - 44032: 0x9EDE,
	50811 - 44032: 0x9EDF,
	50812 - 44032: 0xBFDE,
	50813 - 44032: 0x9EE0,
	50814 - 44032: 0x9EE1,
	50815 - 44032: 0x9EE2,
	50816 - 44032: 0xBFDF,
	50817 - 44032: 0x9EE3,
	50818 - 44032: 0x9EE4,
	50819 - 44032: 0x9EE5,
	50820 - 44032: 0x9EE6,
	50821 - 44032: 0x9EE7,
	50822 - 44032: 0x9EE8,
	50823 - 44032: 0x9EE9,
	50824 - 44032: 0xBFE0,
	50825 - 44032: 0xBFE1,
	50826 - 44032: 0x9EEA,
	50827 - 44032: 0xBFE2,
	50828 - 44032: 0x9EEB,
	50829 - 44032: 0xBFE3,
	50830 - 44032: 0x9EEC,
	50831 - 44032: 0x9EED,
	50832 - 44032: 0x9EEE,
	50833 - 44032: 0x9EEF,
	50834 - 44032: 0x9EF0,
	50835 - 44032: 0x9EF1,
	50836 - 44032: 0xBFE4,
	50837 - 44032: 0xBFE5,
	50838 - 44032: 0x9EF2,
	50839 - 44032: 0x9EF3,
	50840 - 44032: 0xBFE6,
	50841 - 44032: 0x9EF4,
	50842 - 44032: 0x9EF5,
	50843 - 44032: 0x9EF6,
	50844 - 44032: 0xBFE7,
	50845 - 44032: 0x9EF7,
	50846 - 44032: 0x9EF8,
	50847 - 44032: 0x9EF9,
	50848 - 44032: 0x9EFA,
	50849 - 44032: 0x9EFB,
	50850 - 44032: 0x9EFC,
	50851 - 44032: 0x9EFD,
	50852 - 44032: 0xBFE8,
	50853 - 44032: 0xBFE9,
	50854 - 44032: 0x9EFE,
	50855 - 44032: 0xBFEA,
	50856 - 44032: 0x9F41,
	50857 - 44032: 0xBFEB,
	50858 - 44032: 0x9F42,
	50859 - 44032: 0x9F43,
	50860 - 44032: 0x9F44,
	50861 - 44032: 0x9F45,
	50862 - 44032: 0x9F46,
	50863 - 44032: 0x9F47,
	50864 - 44032: 0xBFEC,
	50865 - 44032: 0xBFED,
	50866 - 44032: 0x9F48,
	50867 - 44032: 0x9F49,
	50868 - 44032: 0xBFEE,
	50869 - 44032: 0x9F4A,
	50870 - 44032: 0x9F4B,
	50871 - 44032: 0x9F4C,
	50872 - 44032: 0xBFEF,
	50873 - 44032: 0xBFF0,
	50874 - 44032: 0xBFF1,
	50875 - 44032: 0x9F4D,
	50876 - 44032: 0x9F4E,
	50877 - 44032: 0x9F4F,
	50878 - 44032: 0x9F50,
	50879 - 44032: 0x9F51,
	50880 - 44032: 0xBFF2,
	50881 - 44032: 0xBFF3,
	50882 - 44032: 0x9F52,
	50883 - 44032: 0xBFF4,
	50884 - 44032: 0x9F53,
	50885 - 44032: 0xBFF5,
	50886 - 44032: 0x9F54,
	50887 - 44032: 0x9F55,
	50888 - 44032: 0x9F56,
	50889 - 44032: 0x9F57,
	50890 - 44032: 0x9F58,
	50891 - 44032: 0x9F59,
	50892 - 44032: 0xBFF6,
	50893 - 44032: 0xBFF7,
	50894 - 44032: 0x9F5A,
	50895 - 44032: 0x9F61,
	50896 - 44032: 0xBFF8,
	50897 - 44032: 0x9F62,
	50898 - 44032: 0x9F63,
	50899 - 44032: 0x9F64,
	50900 - 44032: 0xBFF9,
	50901 - 44032: 0x9F65,
	50902 - 44032: 0x9F66,
	50903 - 44032: 0x9F67,
	50904 - 44032: 0x9F68,
	50905 - 44032: 0x9F69,
	50906 - 44032: 0x9F6A,
	50907 - 44032: 0x9F6B,
	50908 - 44032: 0xBFFA,
	50909 - 44032: 0xBFFB,
	50910 - 44032: 0x9F6C,
	50911 - 44032: 0x9F6D,
	50912 - 44032: 0xBFFC,
	50913 - 44032: 0xBFFD,
	50914 - 44032: 0x9F6E,
	50915 - 44032: 0x9F6F,
	50916 - 44032: 0x9F70,
	50917 - 44032: 0x9F71,
	50918 - 44032: 0x9F72,
	50919 - 44032: 0x9F73,
	50920 - 44032: 0xBFFE,
	50921 - 44032: 0xC0A1,
	50922 - 44032: 0x9F74,
	50923 - 44032: 0x9F75,
	50924 - 44032: 0xC0A2,
	50925 - 44032: 0x9F76,
	50926 - 44032: 0x9F77,
	50927 - 44032: 0x9F78,
	50928 - 44032: 0xC0A3,
	50929 - 44032: 0x9F79,
	50930 - 44032: 0x9F7A,
	50931 - 44032: 0x9F81,
	50932 - 44032: 0x9F82,
	50933 - 44032: 0x9F83,
	50934 - 44032: 0x9F84,
	50935 - 44032: 0x9F85,
	50936 - 44032: 0xC0A4,
	50937 - 44032: 0xC0A5,
	50938 - 44032: 0x9F86,
	50939 - 44032: 0x9F87,
	50940 - 44032: 0x9F88,
	50941 - 44032: 0xC0A6,
	50942 - 44032: 0x9F89,
	50943 - 44032: 0x9F8A,
	50944 - 44032: 0x9F8B,
	50945 - 44032: 0x9F8C,
	50946 - 44032: 0x9F8D,
	50947 - 44032: 0x9F8E,
	50948 - 44032: 0xC0A7,
	50949 - 44032: 0xC0A8,
	50950 - 44032: 0x9F8F,
	50951 - 44032: 0x9F90,
	50952 - 44032: 0xC0A9,
	50953 - 44032: 0x9F91,
	50954 - 44032: 0x9F92,
	50955 - 44032: 0x9F93,
	50956 - 44032: 0xC0AA,
	50957 - 44032: 0x9F94,
	50958 - 44032: 0x9F95,
	50959 - 44032: 0x9F96,
	50960 - 44032: 0x9F97,
	50961 - 44032: 0x9F98,
	50962 - 44032: 0x9F99,
	50963 - 44032: 0x9F9A,
	50964 - 44032: 0xC0AB,
	50965 - 44032: 0xC0AC,
	50966 - 44032: 0x9F9B,
	50967 - 44032: 0xC0AD,
	50968 - 44032: 0x9F9C,
	50969 - 44032: 0xC0AE,
	50970 - 44032: 0x9F9D,
	50971 - 44032: 0x9F9E,
	50972 - 44032: 0x9F9F,
	50973 - 44032: 0x9FA0,
	50974 - 44032: 0x9FA1,
	50975 - 44032: 0x9FA2,
	50976 - 44032: 0xC0AF,
	50977 - 44032: 0xC0B0,
	50978 - 44032: 0x9FA3,
	50979 - 44032: 0x9FA4,
	50980 - 44032: 0xC0B1,
	50981 - 44032: 0x9FA5,
	50982 - 44032: 0x9FA6,
	50983 - 44032: 0x9FA7,
	50984 - 44032: 0xC0B2,
	50985 - 44032: 0x9FA8,
	50986 - 44032: 0x9FA9,
	50987 - 44032: 0x9FAA,
	50988 - 44032: 0x9FAB,
	50989 - 44032: 0x9FAC,
	50990 - 44032: 0x9FAD,
	50991 - 44032: 0x9FAE,
	50992 - 44032: 0xC0B3,
	50993 - 44032: 0xC0B4,
	50994 - 44032: 0x9FAF,
	50995 - 44032: 0xC0B5,
	50996 - 44032: 0x9FB0,
	50997 - 44032: 0xC0B6,
	50998 - 44032: 0x9FB1,
	50999 - 44032: 0xC0B7,
	51000 - 44032: 0x9FB2,
	51001 - 44032: 0x9FB3,
	51002 - 44032: 0x9FB4,
	51003 - 44032: 0x9FB5,
	51004 - 44032: 0xC0B8,
	51005 - 44032: 0xC0B9,
	51006 - 44032: 0x9FB6,
	51007 - 44032: 0x9FB7,
	51008 - 44032: 0xC0BA,
	51009 - 44032: 0x9FB8,
	51010 - 44032: 0x9FB9,
	51011 - 44032: 0x9FBA,
	51012 - 44032: 0xC0BB,
	51013 - 44032: 0x9FBB,
	51014 - 44032: 0x9FBC,
	51015 - 44032: 0x9FBD,
	51016 - 44032: 0x9FBE,
	51017 - 44032: 0x9FBF,
	51018 - 44032: 0xC0BC,
	51019 - 44032: 0x9FC0,
	51020 - 44032: 0xC0BD,
	51021 - 44032: 0xC0BE,
	51022 - 44032: 0x9FC1,
	51023 - 44032: 0xC0BF,
	51024 - 44032: 0x9FC2,
	51025 - 44032: 0xC0C0,
	51026 - 44032: 0xC0C1,
	51027 - 44032: 0xC0C2,
	51028 - 44032: 0xC0C3,
	51029 - 44032: 0xC0C4,
	51030 - 44032: 0xC0C5,
	51031 - 44032: 0xC0C6,
	51032 - 44032: 0xC0C7,
	51033 - 44032: 0x9FC3,
	51034 - 44032: 0x9FC4,
	51035 - 44032: 0x9FC5,
	51036 - 44032: 0xC0C8,
	51037 - 44032: 0x9FC6,
	51038 - 44032: 0x9FC7,
	51039 - 44032: 0x9FC8,
	51040 - 44032: 0xC0C9,
	51041 - 44032: 0x9FC9,
	51042 - 44032: 0x9FCA,
	51043 - 44032: 0x9FCB,
	51044 - 44032: 0x9FCC,
	51045 - 44032: 0x9FCD,
	51046 - 44032: 0x9FCE,
	51047 - 44032: 0x9FCF,
	51048 - 44032: 0xC0CA,
	51049 - 44032: 0x9FD0,
	51050 - 44032: 0x9FD1,
	51051 - 44032: 0xC0CB,
	51052 - 44032: 0x9FD2,
	51053 - 44032: 0x9FD3,
	51054 - 44032: 0x9FD4,
	51055 - 44032: 0x9FD5,
	51056 - 44032: 0x9FD6,
	51057 - 44032: 0x9FD7,
	51058 - 44032: 0x9FD8,
	51059 - 44032: 0x9FD9,
	51060 - 44032: 0xC0CC,
	51061 - 44032: 0xC0CD,
	51062 - 44032: 0x9FDA,
	51063 - 44032: 0x9FDB,
	51064 - 44032: 0xC0CE,
	51065 - 44032: 0x9FDC,
	51066 - 44032: 0x9FDD,
	51067 - 44032: 0x9FDE,
	51068 - 44032: 0xC0CF,
	51069 - 44032: 0xC0D0,
	51070 - 44032: 0xC0D1,
	51071 - 44032: 0x9FDF,
	51072 - 44032: 0x9FE0,
	51073 - 44032: 0x9FE1,
	51074 - 44032: 0x9FE2,
	51075 - 44032: 0xC0D2,
	51076 - 44032: 0xC0D3,
	51077 - 44032: 0xC0D4,
	51078 - 44032: 0x9FE3,
	51079 - 44032: 0xC0D5,
	51080 - 44032: 0xC0D6,
	51081 - 44032: 0xC0D7,
	51082 - 44032: 0xC0D8,
	51083 - 44032: 0x9FE4,
	51084 - 44032: 0x9FE5,
	51085 - 44032: 0x9FE6,
	51086 - 44032: 0xC0D9,
	51087 - 44032: 0x9FE7,
	51088 - 44032: 0xC0DA,
	51089 - 44032: 0xC0DB,
	51090 - 44032: 0x9FE8,
	51091 - 44032: 0x9FE9,
	51092 - 44032: 0xC0DC,
	51093 - 44032: 0x9FEA,
	51094 - 44032: 0xC0DD,
	51095 - 44032: 0xC0DE,
	51096 - 44032: 0xC0DF,
	51097 - 44032: 0x9FEB,
	51098 - 44032: 0xC0E0,
	51099 - 44032: 0x9FEC,
	51100 - 44032: 0x9FED,
	51101 - 44032: 0x9FEE,
	51102 - 44032: 0x9FEF,
	51103 - 44032: 0x9FF0,
	51104 - 44032: 0xC0E1,
	51105 - 44032: 0xC0E2,
	51106 - 44032: 0x9FF1,
	51107 - 44032: 0xC0E3,
	51108 - 44032: 0xC0E4,
	51109 - 44032: 0xC0E5,
	51110 - 44032: 0xC0E6,
	51111 - 44032: 0x9FF2,
	51112 - 44032: 0x9FF3,
	51113 - 44032: 0x9FF4,
	51114 - 44032: 0x9FF5,
	51115 - 44032: 0x9FF6,
	51116 - 44032: 0xC0E7,
	51117 - 44032: 0xC0E8,
	51118 - 44032: 0x9FF7,
	51119 - 44032: 0x9FF8,
	51120 - 44032: 0xC0E9,
	51121 - 44032: 0x9FF9,
	51122 - 44032: 0x9FFA,
	51123 - 44032: 0x9FFB,
	51124 - 44032: 0xC0EA,
	51125 - 44032: 0x9FFC,
	51126 - 44032: 0x9FFD,
	51127 - 44032: 0x9FFE,
	51128 - 44032: 0xA041,
	51129 - 44032: 0xA042,
	51130 - 44032: 0xA043,
	51131 - 44032: 0xA044,
	51132 - 44032: 0xC0EB,
	51133 - 44032: 0xC0EC,
	51134 - 44032: 0xA045,
	51135 - 44032: 0xC0ED,
	51136 - 44032: 0xC0EE,
	51137 - 44032: 0xC0EF,
	51138 - 44032: 0xA046,
	51139 - 44032: 0xA047,
	51140 - 44032: 0xA048,
	51141 - 44032: 0xA049,
	51142 - 44032: 0xA04A,
	51143 - 44032: 0xA04B,
	51144 - 44032: 0xC0F0,
	51145 - 44032: 0xC0F1,
	51146 - 44032: 0xA04C,
	51147 - 44032: 0xA04D,
	51148 - 44032: 0xC0F2,
	51149 - 44032: 0xA04E,
	51150 - 44032: 0xC0F3,
	51151 - 44032: 0xA04F,
	51152 - 44032: 0xC0F4,
	51153 - 44032: 0xA050,
	51154 - 44032: 0xA051,
	51155 - 44032: 0xA052,
	51156 - 44032: 0xA053,
	51157 - 44032: 0xA054,
	51158 - 44032: 0xA055,
	51159 - 44032: 0xA056,
	51160 - 44032: 0xC0F5,
	51161 - 44032: 0xA057,
	51162 - 44032: 0xA058,
	51163 - 44032: 0xA059,
	51164 - 44032: 0xA05A,
	51165 - 44032: 0xC0F6,
	51166 - 44032: 0xA061,
	51167 - 44032: 0xA062,
	51168 - 44032: 0xA063,
	51169 - 44032: 0xA064,
	51170 - 44032: 0xA065,
	51171 - 44032: 0xA066,
	51172 - 44032: 0xC0F7,
	51173 - 44032: 0xA067,
	51174 - 44032: 0xA068,
	51175 - 44032: 0xA069,
	51176 - 44032: 0xC0F8,
	51177 - 44032: 0xA06A,
	51178 - 44032: 0xA06B,
	51179 - 44032: 0xA06C,
	51180 - 44032: 0xC0F9,
	51181 - 44032: 0xA06D,
	51182 - 44032: 0xA06E,
	51183 - 44032: 0xA06F,
	51184 - 44032: 0xA070,
	51185 - 44032: 0xA071,
	51186 - 44032: 0xA072,
	51187 - 44032: 0xA073,
	51188 - 44032: 0xA074,
	51189 - 44032: 0xA075,
	51190 - 44032: 0xA076,
	51191 - 44032: 0xA077,
	51192 - 44032: 0xA078,
	51193 - 44032: 0xA079,
	51194 - 44032: 0xA07A,
	51195 - 44032: 0xA081,
	51196 - 44032: 0xA082,
	51197 - 44032: 0xA083,
	51198 - 44032: 0xA084,
	51199 - 44032: 0xA085,
	51200 - 44032: 0xC0FA,
	51201 - 44032: 0xC0FB,
	51202 - 44032: 0xA086,
	51203 - 44032: 0xA087,
	51204 - 44032: 0xC0FC,
	51205 - 44032: 0xA088,
	51206 - 44032: 0xA089,
	51207 - 44032: 0xA08A,
	51208 - 44032: 0xC0FD,
	51209 - 44032: 0xA08B,
	51210 - 44032: 0xC0FE,
	51211 - 44032: 0xA08C,
	51212 - 44032: 0xA08D,
	51213 - 44032: 0xA08E,
	51214 - 44032: 0xA08F,
	51215 - 44032: 0xA090,
	51216 - 44032: 0xC1A1,
	51217 - 44032: 0xC1A2,
	51218 - 44032: 0xA091,
	51219 - 44032: 0xC1A3,
	51220 - 44032: 0xA092,
	51221 - 44032: 0xC1A4,
	51222 - 44032: 0xC1A5,
	51223 - 44032: 0xA093,
	51224 - 44032: 0xA094,
	51225 - 44032: 0xA095,
	51226 - 44032: 0xA096,
	51227 - 44032: 0xA097,
	51228 - 44032: 0xC1A6,
	51229 - 44032: 0xC1A7,
	51230 - 44032: 0xA098,
	51231 - 44032: 0xA099,
	51232 - 44032: 0xC1A8,
	51233 - 44032: 0xA09A,
	51234 - 44032: 0xA09B,
	51235 - 44032: 0xA09C,
	51236 - 44032: 0xC1A9,
	51237 - 44032: 0xA09D,
	51238 - 44032: 0xA09E,
	51239 - 44032: 0xA09F,
	51240 - 44032: 0xA0A0,
	51241 - 44032: 0xA0A1,
	51242 - 44032: 0xA0A2,
	51243 - 44032: 0xA0A3,
	51244 - 44032: 0xC1AA,
	51245 - 44032: 0xC1AB,
	51246 - 44032: 0xA0A4,
	51247 - 44032: 0xC1AC,
	51248 - 44032: 0xA0A5,
	51249 - 44032: 0xC1AD,
	51250 - 44032: 0xA0A6,
	51251 - 44032: 0xA0A7,
	51252 - 44032: 0xA0A8,
	51253 - 44032: 0xA0A9,
	51254 - 44032: 0xA0AA,
	51255 - 44032: 0xA0AB,
	51256 - 44032: 0xC1AE,
	51257 - 44032: 0xA0AC,
	51258 - 44032: 0xA0AD,
	51259 - 44032: 0xA0AE,
	51260 - 44032: 0xC1AF,
	51261 - 44032: 0xA0AF,
	51262 - 44032: 0xA0B0,
	51263 - 44032: 0xA0B1,
	51264 - 44032: 0xC1B0,
	51265 - 44032: 0xA0B2,
	51266 - 44032: 0xA0B3,
	51267 - 44032: 0xA0B4,
	51268 - 44032: 0xA0B5,
	51269 - 44032: 0xA0B6,
	51270 - 44032: 0xA0B7,
	51271 - 44032: 0xA0B8,
	51272 - 44032: 0xC1B1,
	51273 - 44032: 0xC1B2,
	51274 - 44032: 0xA0B9,
	51275 - 44032: 0xA0BA,
	51276 - 44032: 0xC1B3,
	51277 - 44032: 0xC1B4,
	51278 - 44032: 0xA0BB,
	51279 - 44032: 0xA0BC,
	51280 - 44032: 0xA0BD,
	51281 - 44032: 0xA0BE,
	51282 - 44032: 0xA0BF,
	51283 - 44032: 0xA0C0,
	51284 - 44032: 0xC1B5,
	51285 - 44032: 0xA0C1,
	51286 - 44032: 0xA0C2,
	51287 - 44032: 0xA0C3,
	51288 - 44032: 0xA0C4,
	51289 - 44032: 0xA0C5,
	51290 - 44032: 0xA0C6,
	51291 - 44032: 0xA0C7,
	51292 - 44032: 0xA0C8,
	51293 - 44032: 0xA0C9,
	51294 - 44032: 0xA0CA,
	51295 - 44032: 0xA0CB,
	51296 - 44032: 0xA0CC,
	51297 - 44032: 0xA0CD,
	51298 - 44032: 0xA0CE,
	51299 - 44032: 0xA0CF,
	51300 - 44032: 0xA0D0,
	51301 - 44032: 0xA0D1,
	51302 - 44032: 0xA0D2,
	51303 - 44032: 0xA0D3,
	51304 - 44032: 0xA0D4,
	51305 - 44032: 0xA0D5,
	51306 - 44032: 0xA0D6,
	51307 - 44032: 0xA0D7,
	51308 - 44032: 0xA0D8,
	51309 - 44032: 0xA0D9,
	51310 - 44032: 0xA0DA,
	51311 - 44032: 0xA0DB,
	51312 - 44032: 0xC1B6,
	51313 - 44032: 0xC1B7,
	51314 - 44032: 0xA0DC,
	51315 - 44032: 0xA0DD,
	51316 - 44032: 0xC1B8,
	51317 - 44032: 0xA0DE,
	51318 - 44032: 0xA0DF,
	51319 - 44032: 0xA0E0,
	51320 - 44032: 0xC1B9,
	51321 - 44032: 0xA0E1,
	51322 - 44032: 0xC1BA,
	51323 - 44032: 0xA0E2,
	51324 - 44032: 0xA0E3,
	51325 - 44032: 0xA0E4,
	51326 - 44032: 0xA0E5,
	51327 - 44032: 0xA0E6,
	51328 - 44032: 0xC1BB,
	51329 - 44032: 0xC1BC,
	51330 - 44032: 0xA0E7,
	51331 - 44032: 0xC1BD,
	51332 - 44032: 0xA0E8,
	51333 - 44032: 0xC1BE,
	51334 - 44032: 0xC1BF,
	51335 - 44032: 0xC1C0,
	51336 - 44032: 0xA0E9,
	51337 - 44032: 0xA0EA,
	51338 - 44032: 0xA0EB,
	51339 - 44032: 0xC1C1,
	51340 - 44032: 0xC1C2,
	51341 - 44032: 0xC1C3,
	51342 - 44032: 0xA0EC,
	51343 - 44032: 0xA0ED,
	51344 - 44032: 0xA0EE,
	51345 - 44032: 0xA0EF,
	51346 - 44032: 0xA0F0,
	51347 - 44032: 0xA0F1,
	51348 - 44032: 0xC1C4,
	51349 - 44032: 0xA0F2,
	51350 - 44032: 0xA0F3,
	51351 - 44032: 0xA0F4,
	51352 - 44032: 0xA0F5,
	51353 - 44032: 0xA0F6,
	51354 - 44032: 0xA0F7,
	51355 - 44032: 0xA0F8,
	51356 - 44032: 0xA0F9,
	51357 - 44032: 0xC1C5,
	51358 - 44032: 0xA0FA,
	51359 - 44032: 0xC1C6,
	51360 - 44032: 0xA0FB,
	51361 - 44032: 0xC1C7,
	51362 - 44032: 0xA0FC,
	51363 - 44032: 0xA0FD,
	51364 - 44032: 0xA0FE,
	51365 - 44032: 0xA141,
	51366 - 44032: 0xA142,
	51367 - 44032: 0xA143,
	51368 - 44032: 0xC1C8,
	51369 - 44032: 0xA144,
	51370 - 44032: 0xA145,
	51371 - 44032: 0xA146,
	51372 - 44032: 0xA147,
	51373 - 44032: 0xA148,
	51374 - 44032: 0xA149,
	51375 - 44032: 0xA14A,
	51376 - 44032: 0xA14B,
	51377 - 44032: 0xA14C,
	51378 - 44032: 0xA14D,
	51379 - 44032: 0xA14E,
	51380 - 44032: 0xA14F,
	51381 - 44032: 0xA150,
	51382 - 44032: 0xA151,
	51383 - 44032: 0xA152,
	51384 - 44032: 0xA153,
	51385 - 44032: 0xA154,
	51386 - 44032: 0xA155,
	51387 - 44032: 0xA156,
	51388 - 44032: 0xC1C9,
	51389 - 44032: 0xC1CA,
	51390 - 44032: 0xA157,
	51391 - 44032: 0xA158,
	51392 - 44032: 0xA159,
	51393 - 44032: 0xA15A,
	51394 - 44032: 0xA161,
	51395 - 44032: 0xA162,
	51396 - 44032: 0xC1CB,
	51397 - 44032: 0xA163,
	51398 - 44032: 0xA164,
	51399 - 44032: 0xA165,
	51400 - 44032: 0xC1CC,
	51401 - 44032: 0xA166,
	51402 - 44032: 0xA167,
	51403 - 44032: 0xA168,
	51404 - 44032: 0xC1CD,
	51405 - 44032: 0xA169,
	51406 - 44032: 0xA16A,
	51407 - 44032: 0xA16B,
	51408 - 44032: 0xA16C,
	51409 - 44032: 0xA16D,
	51410 - 44032: 0xA16E,
	51411 - 44032: 0xA16F,
	51412 - 44032: 0xC1CE,
	51413 - 44032: 0xC1CF,
	51414 - 44032: 0xA170,
	51415 - 44032: 0xC1D0,
	51416 - 44032: 0xA171,
	51417 - 44032: 0xC1D1,
	51418 - 44032: 0xA172,
	51419 - 44032: 0xA173,
	51420 - 44032: 0xA174,
	51421 - 44032: 0xA175,
	51422 - 44032: 0xA176,
	51423 - 44032: 0xA177,
	51424 - 44032: 0xC1D2,
	51425 - 44032: 0xC1D3,
	51426 - 44032: 0xA178,
	51427 - 44032: 0xA179,
	51428 - 44032: 0xC1D4,
	51429 - 44032: 0xA17A,
	51430 - 44032: 0xA181,
	51431 - 44032: 0xA182,
	51432 - 44032: 0xA183,
	51433 - 44032: 0xA184,
	51434 - 44032: 0xA185,
	51435 - 44032: 0xA186,
	51436 - 44032: 0xA187,
	51437 - 44032: 0xA188,
	51438 - 44032: 0xA189,
	51439 - 44032: 0xA18A,
	51440 - 44032: 0xA18B,
	51441 - 44032: 0xA18C,
	51442 - 44032: 0xA18D,
	51443 - 44032: 0xA18E,
	51444 - 44032: 0xA18F,
	51445 - 44032: 0xC1D5,
	51446 - 44032: 0xA190,
	51447 - 44032: 0xA191,
	51448 - 44032: 0xA192,
	51449 - 44032: 0xA193,
	51450 - 44032: 0xA194,
	51451 - 44032: 0xA195,
	51452 - 44032: 0xC1D6,
	51453 - 44032: 0xC1D7,
	51454 - 44032: 0xA196,
	51455 - 44032: 0xA197,
	51456 - 44032: 0xC1D8,
	51457 - 44032: 0xA198,
	51458 - 44032: 0xA199,
	51459 - 44032: 0xA19A,
	51460 - 44032: 0xC1D9,
	51461 - 44032: 0xC1DA,
	51462 - 44032: 0xC1DB,
	51463 - 44032: 0xA19B,
	51464 - 44032: 0xA19C,
	51465 - 44032: 0xA19D,
	51466 - 44032: 0xA19E,
	51467 - 44032: 0xA19F,
	51468 - 44032: 0xC1DC,
	51469 - 44032: 0xC1DD,
	51470 - 44032: 0xA1A0,
	51471 - 44032: 0xC1DE,
	51472 - 44032: 0xA241,
	51473 - 44032: 0xC1DF,
	51474 - 44032: 0xA242,
	51475 - 44032: 0xA243,
	51476 - 44032: 0xA244,
	51477 - 44032: 0xA245,
	51478 - 44032: 0xA246,
	51479 - 44032: 0xA247,
	51480 - 44032: 0xC1E0,
	51481 - 44032: 0xA248,
	51482 - 44032: 0xA249,
	51483 - 44032: 0xA24A,
	51484 - 44032: 0xA24B,
	51485 - 44032: 0xA24C,
	51486 - 44032: 0xA24D,
	51487 - 44032: 0xA24E,
	51488 - 44032: 0xA24F,
	51489 - 44032: 0xA250,
	51490 - 44032: 0xA251,
	51491 - 44032: 0xA252,
	51492 - 44032: 0xA253,
	51493 - 44032: 0xA254,
	51494 - 44032: 0xA255,
	51495 - 44032: 0xA256,
	51496 - 44032: 0xA257,
	51497 - 44032: 0xA258,
	51498 - 44032: 0xA259,
	51499 - 44032: 0xA25A,
	51500 - 44032: 0xC1E1,
	51501 - 44032: 0xA261,
	51502 - 44032: 0xA262,
	51503 - 44032: 0xA263,
	51504 - 44032: 0xA264,
	51505 - 44032: 0xA265,
	51506 - 44032: 0xA266,
	51507 - 44032: 0xA267,
	51508 - 44032: 0xC1E2,
	51509 - 44032: 0xA268,
	51510 - 44032: 0xA269,
	51511 - 44032: 0xA26A,
	51512 - 44032: 0xA26B,
	51513 - 44032: 0xA26C,
	51514 - 44032: 0xA26D,
	51515 - 44032: 0xA26E,
	51516 - 44032: 0xA26F,
	51517 - 44032: 0xA270,
	51518 - 44032: 0xA271,
	51519 - 44032: 0xA272,
	51520 - 44032: 0xA273,
	51521 - 44032: 0xA274,
	51522 - 44032: 0xA275,
	51523 - 44032: 0xA276,
	51524 - 44032: 0xA277,
	51525 - 44032: 0xA278,
	51526 - 44032: 0xA279,
	51527 - 44032: 0xA27A,
	51528 - 44032: 0xA281,
	51529 - 44032: 0xA282,
	51530 - 44032: 0xA283,
	51531 - 44032: 0xA284,
	51532 - 44032: 0xA285,
	51533 - 44032: 0xA286,
	51534 - 44032: 0xA287,
	51535 - 44032: 0xA288,
	51536 - 44032: 0xC1E3,
	51537 - 44032: 0xC1E4,
	51538 - 44032: 0xA289,
	51539 - 44032: 0xA28A,
	51540 - 44032: 0xC1E5,
	51541 - 44032: 0xA28B,
	51542 - 44032: 0xA28C,
	51543 - 44032: 0xA28D,
	51544 - 44032: 0xC1E6,
	51545 - 44032: 0xA28E,
	51546 - 44032: 0xA28F,
	51547 - 44032: 0xA290,
	51548 - 44032: 0xA291,
	51549 - 44032: 0xA292,
	51550 - 44032: 0xA293,
	51551 - 44032: 0xA294,
	51552 - 44032: 0xC1E7,
	51553 - 44032: 0xC1E8,
	51554 - 44032: 0xA295,
	51555 - 44032: 0xC1E9,
	51556 - 44032: 0xA296,
	51557 - 44032: 0xA297,
	51558 - 44032: 0xA298,
	51559 - 44032: 0xA299,
	51560 - 44032: 0xA29A,
	51561 - 44032: 0xA29B,
	51562 - 44032: 0xA29C,
	51563 - 44032: 0xA29D,
	51564 - 44032: 0xC1EA,
	51565 - 44032: 0xA29E,
	51566 - 44032: 0xA29F,
	51567 - 44032: 0xA2A0,
	51568 - 44032: 0xC1EB,
	51569 - 44032: 0xA341,
	51570 - 44032: 0xA342,
	51571 - 44032: 0xA343,
	51572 - 44032: 0xC1EC,
	51573 - 44032: 0xA344,
	51574 - 44032: 0xA345,
	51575 - 44032: 0xA346,
	51576 - 44032: 0xA347,
	51577 - 44032: 0xA348,
	51578 - 44032: 0xA349,
	51579 - 44032: 0xA34A,
	51580 - 44032: 0xC1ED,
	51581 - 44032: 0xA34B,
	51582 - 44032: 0xA34C,
	51583 - 44032: 0xA34D,
	51584 - 44032: 0xA34E,
	51585 - 44032: 0xA34F,
	51586 - 44032: 0xA350,
	51587 - 44032: 0xA351,
	51588 - 44032: 0xA352,
	51589 - 44032: 0xA353,
	51590 - 44032: 0xA354,
	51591 - 44032: 0xA355,
	51592 - 44032: 0xC1EE,
	51593 - 44032: 0xC1EF,
	51594 - 44032: 0xA356,
	51595 - 44032: 0xA357,
	51596 - 44032: 0xC1F0,
	51597 - 44032: 0xA358,
	51598 - 44032: 0xA359,
	51599 - 44032: 0xA35A,
	51600 - 44032: 0xC1F1,
	51601 - 44032: 0xA361,
	51602 - 44032: 0xA362,
	51603 - 44032: 0xA363,
	51604 - 44032: 0xA364,
	51605 - 44032: 0xA365,
	51606 - 44032: 0xA366,
	51607 - 44032: 0xA367,
	51608 - 44032: 0xC1F2,
	51609 - 44032: 0xC1F3,
	51610 - 44032: 0xA368,
	51611 - 44032: 0xC1F4,
	51612 - 44032: 0xA369,
	51613 - 44032: 0xC1F5,
	51614 - 44032: 0xA36A,
	51615 - 44032: 0xA36B,
	51616 - 44032: 0xA36C,
	51617 - 44032: 0xA36D,
	51618 - 44032: 0xA36E,
	51619 - 44032: 0xA36F,
	51620 - 44032: 0xA370,
	51621 - 44032: 0xA371,
	51622 - 44032: 0xA372,
	51623 - 44032: 0xA373,
	51624 - 44032: 0xA374,
	51625 - 44032: 0xA375,
	51626 - 44032: 0xA376,
	51627 - 44032: 0xA377,
	51628 - 44032: 0xA378,
	51629 - 44032: 0xA379,
	51630 - 44032: 0xA37A,
	51631 - 44032: 0xA381,
	51632 - 44032: 0xA382,
	51633 - 44032: 0xA383,
	51634 - 44032: 0xA384,
	51635 - 44032: 0xA385,
	51636 - 44032: 0xA386,
	51637 - 44032: 0xA387,
	51638 - 44032: 0xA388,
	51639 - 44032: 0xA389,
	51640 - 44032: 0xA38A,
	51641 - 44032: 0xA38B,
	51642 - 44032: 0xA38C,
	51643 - 44032: 0xA38D,
	51644 - 44032: 0xA38E,
	51645 - 44032: 0xA38F,
	51646 - 44032: 0xA390,
	51647 - 44032: 0xA391,
	51648 - 44032: 0xC1F6,
	51649 - 44032: 0xC1F7,
	51650 - 44032: 0xA392,
	51651 - 44032: 0xA393,
	51652 - 44032: 0xC1F8,
	51653 - 44032: 0xA394,
	51654 - 44032: 0xA395,
	51655 - 44032: 0xC1F9,
	51656 - 44032: 0xC1FA,
	51657 - 44032: 0xA396,
	51658 - 44032: 0xC1FB,
	51659 - 44032: 0xA397,
	51660 - 44032: 0xA398,
	51661 - 44032: 0xA399,
	51662 - 44032: 0xA39A,
	51663 - 44032: 0xA39B,
	51664 - 44032: 0xC1FC,
	51665 - 44032: 0xC1FD,
	51666 - 44032: 0xA39C,
	51667 - 44032: 0xC1FE,
	51668 - 44032: 0xA39D,
	51669 - 44032: 0xC2A1,
	51670 - 44032: 0xC2A2,
	51671 - 44032: 0xA39E,
	51672 - 44032: 0xA39F,
	51673 - 44032: 0xC2A3,
	51674 - 44032: 0xC2A4,
	51675 - 44032: 0xA3A0,
	51676 - 44032: 0xC2A5,
	51677 - 44032: 0xC2A6,
	51678 - 44032: 0xA441,
	51679 - 44032: 0xA442,
	51680 - 44032: 0xC2A7,
	51681 - 44032: 0xA443,
	51682 - 44032: 0xC2A8,
	51683 - 44032: 0xA444,
	51684 - 44032: 0xC2A9,
	51685 - 44032: 0xA445,
	51686 - 44032: 0xA446,
	51687 - 44032: 0xC2AA,
	51688 - 44032: 0xA447,
	51689 - 44032: 0xA448,
	51690 - 44032: 0xA449,
	51691 - 44032: 0xA44A,
	51692 - 44032: 0xC2AB,
	51693 - 44032: 0xC2AC,
	51694 - 44032: 0xA44B,
	51695 - 44032: 0xC2AD,
	51696 - 44032: 0xC2AE,
	51697 - 44032: 0xC2AF,
	51698 - 44032: 0xA44C,
	51699 - 44032: 0xA44D,
	51700 - 44032: 0xA44E,
	51701 - 44032: 0xA44F,
	51702 - 44032: 0xA450,
	51703 - 44032: 0xA451,
	51704 - 44032: 0xC2B0,
	51705 - 44032: 0xC2B1,
	51706 - 44032: 0xA452,
	51707 - 44032: 0xA453,
	51708 - 44032: 0xC2B2,
	51709 - 44032: 0xA454,
	51710 - 44032: 0xA455,
	51711 - 44032: 0xA456,
	51712 - 44032: 0xC2B3,
	51713 - 44032: 0xA457,
	51714 - 44032: 0xA458,
	51715 - 44032: 0xA459,
	51716 - 44032: 0xA45A,
	51717 - 44032: 0xA461,
	51718 - 44032: 0xA462,
	51719 - 44032: 0xA463,
	51720 - 44032: 0xC2B4,
	51721 - 44032: 0xC2B5,
	51722 - 44032: 0xA464,
	51723 - 44032: 0xC2B6,
	51724 - 44032: 0xC2B7,
	51725 - 44032: 0xC2B8,
	51726 - 44032: 0xA465,
	51727 - 44032: 0xA466,
	51728 - 44032: 0xA467,
	51729 - 44032: 0xA468,
	51730 - 44032: 0xA469,
	51731 - 44032: 0xA46A,
	51732 - 44032: 0xC2B9,
	51733 - 44032: 0xA46B,
	51734 - 44032: 0xA46C,
	51735 - 44032: 0xA46D,
	51736 - 44032: 0xC2BA,
	51737 - 44032: 0xA46E,
	51738 - 44032: 0xA46F,
	51739 - 44032: 0xA470,
	51740 - 44032: 0xA471,
	51741 - 44032: 0xA472,
	51742 - 44032: 0xA473,
	51743 - 44032: 0xA474,
	51744 - 44032: 0xA475,
	51745 - 44032: 0xA476,
	51746 - 44032: 0xA477,
	51747 - 44032: 0xA478,
	51748 - 44032: 0xA479,
	51749 - 44032: 0xA47A,
	51750 - 44032: 0xA481,
	51751 - 44032: 0xA482,
	51752 - 44032: 0xA483,
	51753 - 44032: 0xC2BB,
	51754 - 44032: 0xA484,
	51755 - 44032: 0xA485,
	51756 - 44032: 0xA486,
	51757 - 44032: 0xA487,
	51758 - 44032: 0xA488,
	51759 - 44032: 0xA489,
	51760 - 44032: 0xA48A,
	51761 - 44032: 0xA48B,
	51762 - 44032: 0xA48C,
	51763 - 44032: 0xA48D,
	51764 - 44032: 0xA48E,
	51765 - 44032: 0xA48F,
	51766 - 44032: 0xA490,
	51767 - 44032: 0xA491,
	51768 - 44032: 0xA492,
	51769 - 44032: 0xA493,
	51770 - 44032: 0xA494,
	51771 - 44032: 0xA495,
	51772 - 44032: 0xA496,
	51773 - 44032: 0xA497,
	51774 - 44032: 0xA498,
	51775 - 44032: 0xA499,
	51776 - 44032: 0xA49A,
	51777 - 44032: 0xA49B,
	51778 - 44032: 0xA49C,
	51779 - 44032: 0xA49D,
	51780 - 44032: 0xA49E,
	51781 - 44032: 0xA49F,
	51782 - 44032: 0xA4A0,
	51783 - 44032: 0xA541,
	51784 - 44032: 0xA542,
	51785 - 44032: 0xA543,
	51786 - 44032: 0xA544,
	51787 - 44032: 0xA545,
	51788 - 44032: 0xC2BC,
	51789 - 44032: 0xC2BD,
	51790 - 44032: 0xA546,
	51791 - 44032: 0xA547,
	51792 - 44032: 0xC2BE,
	51793 - 44032: 0xA548,
	51794 - 44032: 0xA549,
	51795 - 44032: 0xA54A,
	51796 - 44032: 0xC2BF,
	51797 - 44032: 0xA54B,
	51798 - 44032: 0xA54C,
	51799 - 44032: 0xA54D,
	51800 - 44032: 0xA54E,
	51801 - 44032: 0xA54F,
	51802 - 44032: 0xA550,
	51803 - 44032: 0xA551,
	51804 - 44032: 0xC2C0,
	51805 - 44032: 0xC2C1,
	51806 - 44032: 0xA552,
	51807 - 44032: 0xC2C2,
	51808 - 44032: 0xC2C3,
	51809 - 44032: 0xC2C4,
	51810 - 44032: 0xA553,
	51811 - 44032: 0xA554,
	51812 - 44032: 0xA555,
	51813 - 44032: 0xA556,
	51814 - 44032: 0xA557,
	51815 - 44032: 0xA558,
	51816 - 44032: 0xC2C5,
	51817 - 44032: 0xA559,
	51818 - 44032: 0xA55A,
	51819 - 44032: 0xA561,
	51820 - 44032: 0xA562,
	51821 - 44032: 0xA563,
	51822 - 44032: 0xA564,
	51823 - 44032: 0xA565,
	51824 - 44032: 0xA566,
	51825 - 44032: 0xA567,
	51826 - 44032: 0xA568,
	51827 - 44032: 0xA569,
	51828 - 44032: 0xA56A,
	51829 - 44032: 0xA56B,
	51830 - 44032: 0xA56C,
	51831 - 44032: 0xA56D,
	51832 - 44032: 0xA56E,
	51833 - 44032: 0xA56F,
	51834 - 44032: 0xA570,
	51835 - 44032: 0xA571,
	51836 - 44032: 0xA572,
	51837 - 44032: 0xC2C6,
	51838 - 44032: 0xA573,
	51839 - 44032: 0xA574,
	51840 - 44032: 0xA575,
	51841 - 44032: 0xA576,
	51842 - 44032: 0xA577,
	51843 - 44032: 0xA578,
	51844 - 44032: 0xC2C7,
	51845 - 44032: 0xA579,
	51846 - 44032: 0xA57A,
	51847 - 44032: 0xA581,
	51848 - 44032: 0xA582,
	51849 - 44032: 0xA583,
	51850 - 44032: 0xA584,
	51851 - 44032: 0xA585,
	51852 - 44032: 0xA586,
	51853 - 44032: 0xA587,
	51854 - 44032: 0xA588,
	51855 - 44032: 0xA589,
	51856 - 44032: 0xA58A,
	51857 - 44032: 0xA58B,
	51858 - 44032: 0xA58C,
	51859 - 44032: 0xA58D,
	51860 - 44032: 0xA58E,
	51861 - 44032: 0xA58F,
	51862 - 44032: 0xA590,
	51863 - 44032: 0xA591,
	51864 - 44032: 0xC2C8,
	51865 - 44032: 0xA592,
	51866 - 44032: 0xA593,
	51867 - 44032: 0xA594,
	51868 - 44032: 0xA595,
	51869 - 44032: 0xA596,
	51870 - 44032: 0xA597,
	51871 - 44032: 0xA598,
	51872 - 44032: 0xA599,
	51873 - 44032: 0xA59A,
	51874 - 44032: 0xA59B,
	51875 - 44032: 0xA59C,
	51876 - 44032: 0xA59D,
	51877 - 44032: 0xA59E,
	51878 - 44032: 0xA59F,
	51879 - 44032: 0xA5A0,
	51880 - 44032: 0xA641,
	51881 - 44032: 0xA642,
	51882 - 44032: 0xA643,
	51883 - 44032: 0xA644,
	51884 - 44032: 0xA645,
	51885 - 44032: 0xA646,
	51886 - 44032: 0xA647,
	51887 - 44032: 0xA648,
	51888 - 44032: 0xA649,
	51889 - 44032: 0xA64A,
	51890 - 44032: 0xA64B,
	51891 - 44032: 0xA64C,
	51892 - 44032: 0xA64D,
	51893 - 44032: 0xA64E,
	51894 - 44032: 0xA64F,
	51895 - 44032: 0xA650,
	51896 - 44032: 0xA651,
	51897 - 44032: 0xA652,
	51898 - 44032: 0xA653,
	51899 - 44032: 0xA654,
	51900 - 44032: 0xC2C9,
	51901 - 44032: 0xC2CA,
	51902 - 44032: 0xA655,
	51903 - 44032: 0xA656,
	51904 - 44032: 0xC2CB,
	51905 - 44032: 0xA657,
	51906 - 44032: 0xA658,
	51907 - 44032: 0xA659,
	51908 - 44032: 0xC2CC,
	51909 - 44032: 0xA65A,
	51910 - 44032: 0xA661,
	51911 - 44032: 0xA662,
	51912 - 44032: 0xA663,
	51913 - 44032: 0xA664,
	51914 - 44032: 0xA665,
	51915 - 44032: 0xA666,
	51916 - 44032: 0xC2CD,
	51917 - 44032: 0xC2CE,
	51918 - 44032: 0xA667,
	51919 - 44032: 0xC2CF,
	51920 - 44032: 0xA668,
	51921 - 44032: 0xC2D0,
	51922 - 44032: 0xA669,
	51923 - 44032: 0xC2D1,
	51924 - 44032: 0xA66A,
	51925 - 44032: 0xA66B,
	51926 - 44032: 0xA66C,
	51927 - 44032: 0xA66D,
	51928 - 44032: 0xC2D2,
	51929 - 44032: 0xC2D3,
	51930 - 44032: 0xA66E,
	51931 - 44032: 0xA66F,
	51932 - 44032: 0xA670,
	51933 - 44032: 0xA671,
	51934 - 44032: 0xA672,
	51935 - 44032: 0xA673,
	51936 - 44032: 0xC2D4,
	51937 - 44032: 0xA674,
	51938 - 44032: 0xA675,
	51939 - 44032: 0xA676,
	51940 - 44032: 0xA677,
	51941 - 44032: 0xA678,
	51942 - 44032: 0xA679,
	51943 - 44032: 0xA67A,
	51944 - 44032: 0xA681,
	51945 - 44032: 0xA682,
	51946 - 44032: 0xA683,
	51947 - 44032: 0xA684,
	51948 - 44032: 0xC2D5,
	51949 - 44032: 0xA685,
	51950 - 44032: 0xA686,
	51951 - 44032: 0xA687,
	51952 - 44032: 0xA688,
	51953 - 44032: 0xA689,
	51954 - 44032: 0xA68A,
	51955 - 44032: 0xA68B,
	51956 - 44032: 0xC2D6,
	51957 - 44032: 0xA68C,
	51958 - 44032: 0xA68D,
	51959 - 44032: 0xA68E,
	51960 - 44032: 0xA68F,
	51961 - 44032: 0xA690,
	51962 - 44032: 0xA691,
	51963 - 44032: 0xA692,
	51964 - 44032: 0xA693,
	51965 - 44032: 0xA694,
	51966 - 44032: 0xA695,
	51967 - 44032: 0xA696,
	51968 - 44032: 0xA697,
	51969 - 44032: 0xA698,
	51970 - 44032: 0xA699,
	51971 - 44032: 0xA69A,
	51972 - 44032: 0xA69B,
	51973 - 44032: 0xA69C,
	51974 - 44032: 0xA69D,
	51975 - 44032: 0xA69E,
	51976 - 44032: 0xC2D7,
	51977 - 44032: 0xA69F,
	51978 - 44032: 0xA6A0,
	51979 - 44032: 0xA741,
	51980 - 44032: 0xA742,
	51981 - 44032: 0xA743,
	51982 - 44032: 0xA744,
	51983 - 44032: 0xA745,
	51984 - 44032: 0xC2D8,
	51985 - 44032: 0xA746,
	51986 - 44032: 0xA747,
	51987 - 44032: 0xA748,
	51988 - 44032: 0xC2D9,
	51989 - 44032: 0xA749,
	51990 - 44032: 0xA74A,
	51991 - 44032: 0xA74B,
	51992 - 44032: 0xC2DA,
	51993 - 44032: 0xA74C,
	51994 - 44032: 0xA74D,
	51995 - 44032: 0xA74E,
	51996 - 44032: 0xA74F,
	51997 - 44032: 0xA750,
	51998 - 44032: 0xA751,
	51999 - 44032: 0xA752,
	52000 - 44032: 0xC2DB,
	52001 - 44032: 0xC2DC,
	52002 - 44032: 0xA753,
	52003 - 44032: 0xA754,
	52004 - 44032: 0xA755,
	52005 - 44032: 0xA756,
	52006 - 44032: 0xA757,
	52007 - 44032: 0xA758,
	52008 - 44032: 0xA759,
	52009 - 44032: 0xA75A,
	52010 - 44032: 0xA761,
	52011 - 44032: 0xA762,
	52012 - 44032: 0xA763,
	52013 - 44032: 0xA764,
	52014 - 44032: 0xA765,
	52015 - 44032: 0xA766,
	52016 - 44032: 0xA767,
	52017 - 44032: 0xA768,
	52018 - 44032: 0xA769,
	52019 - 44032: 0xA76A,
	52020 - 44032: 0xA76B,
	52021 - 44032: 0xA76C,
	52022 - 44032: 0xA76D,
	52023 - 44032: 0xA76E,
	52024 - 44032: 0xA76F,
	52025 - 44032: 0xA770,
	52026 - 44032: 0xA771,
	52027 - 44032: 0xA772,
	52028 - 44032: 0xA773,
	52029 - 44032: 0xA774,
	52030 - 44032: 0xA775,
	52031 - 44032: 0xA776,
	52032 - 44032: 0xA777,
	52033 - 44032: 0xC2DD,
	52034 - 44032: 0xA778,
	52035 - 44032: 0xA779,
	52036 - 44032: 0xA77A,
	52037 - 44032: 0xA781,
	52038 - 44032: 0xA782,
	52039 - 44032: 0xA783,
	52040 - 44032: 0xC2DE,
	52041 - 44032: 0xC2DF,
	52042 - 44032: 0xA784,
	52043 - 44032: 0xA785,
	52044 - 44032: 0xC2E0,
	52045 - 44032: 0xA786,
	52046 - 44032: 0xA787,
	52047 - 44032: 0xA788,
	52048 - 44032: 0xC2E1,
	52049 - 44032: 0xA789,
	52050 - 44032: 0xA78A,
	52051 - 44032: 0xA78B,
	52052 - 44032: 0xA78C,
	52053 - 44032: 0xA78D,
	52054 - 44032: 0xA78E,
	52055 - 44032: 0xA78F,
	52056 - 44032: 0xC2E2,
	52057 - 44032: 0xC2E3,
	52058 - 44032: 0xA790,
	52059 - 44032: 0xA791,
	52060 - 44032: 0xA792,
	52061 - 44032: 0xC2E4,
	52062 - 44032: 0xA793,
	52063 - 44032: 0xA794,
	52064 - 44032: 0xA795,
	52065 - 44032: 0xA796,
	52066 - 44032: 0xA797,
	52067 - 44032: 0xA798,
	52068 - 44032: 0xC2E5,
	52069 - 44032: 0xA799,
	52070 - 44032: 0xA79A,
	52071 - 44032: 0xA79B,
	52072 - 44032: 0xA79C,
	52073 - 44032: 0xA79D,
	52074 - 44032: 0xA79E,
	52075 - 44032: 0xA79F,
	52076 - 44032: 0xA7A0,
	52077 - 44032: 0xA841,
	52078 - 44032: 0xA842,
	52079 - 44032: 0xA843,
	52080 - 44032: 0xA844,
	52081 - 44032: 0xA845,
	52082 - 44032: 0xA846,
	52083 - 44032: 0xA847,
	52084 - 44032: 0xA848,
	52085 - 44032: 0xA849,
	52086 - 44032: 0xA84A,
	52087 - 44032: 0xA84B,
	52088 - 44032: 0xC2E6,
	52089 - 44032: 0xC2E7,
	52090 - 44032: 0xA84C,
	52091 - 44032: 0xA84D,
	52092 - 44032: 0xA84E,
	52093 - 44032: 0xA84F,
	52094 - 44032: 0xA850,
	52095 - 44032: 0xA851,
	52096 - 44032: 0xA852,
	52097 - 44032: 0xA853,
	52098 - 44032: 0xA854,
	52099 - 44032: 0xA855,
	52100 - 44032: 0xA856,
	52101 - 44032: 0xA857,
	52102 - 44032: 0xA858,
	52103 - 44032: 0xA859,
	52104 - 44032: 0xA85A,
	52105 - 44032: 0xA861,
	52106 - 44032: 0xA862,
	52107 - 44032: 0xA863,
	52108 - 44032: 0xA864,
	52109 - 44032: 0xA865,
	52110 - 44032: 0xA866,
	52111 - 44032: 0xA867,
	52112 - 44032: 0xA868,
	52113 - 44032: 0xA869,
	52114 - 44032: 0xA86A,
	52115 - 44032: 0xA86B,
	52116 - 44032: 0xA86C,
	52117 - 44032: 0xA86D,
	52118 - 44032: 0xA86E,
	52119 - 44032: 0xA86F,
	52120 - 44032: 0xA870,
	52121 - 44032: 0xA871,
	52122 - 44032: 0xA872,
	52123 - 44032: 0xA873,
	52124 - 44032: 0xC2E8,
	52125 - 44032: 0xA874,
	52126 - 44032: 0xA875,
	52127 - 44032: 0xA876,
	52128 - 44032: 0xA877,
	52129 - 44032: 0xA878,
	52130 - 44032: 0xA879,
	52131 - 44032: 0xA87A,
	52132 - 44032: 0xA881,
	52133 - 44032: 0xA882,
	52134 - 44032: 0xA883,
	52135 - 44032: 0xA884,
	52136 - 44032: 0xA885,
	52137 - 44032: 0xA886,
	52138 - 44032: 0xA887,
	52139 - 44032: 0xA888,
	52140 - 44032: 0xA889,
	52141 - 44032: 0xA88A,
	52142 - 44032: 0xA88B,
	52143 - 44032: 0xA88C,
	52144 - 44032: 0xA88D,
	52145 - 44032: 0xA88E,
	52146 - 44032: 0xA88F,
	52147 - 44032: 0xA890,
	52148 - 44032: 0xA891,
	52149 - 44032: 0xA892,
	52150 - 44032: 0xA893,
	52151 - 44032: 0xA894,
	52152 - 44032: 0xC2E9,
	52153 - 44032: 0xA895,
	52154 - 44032: 0xA896,
	52155 - 44032: 0xA897,
	52156 - 44032: 0xA898,
	52157 - 44032: 0xA899,
	52158 - 44032: 0xA89A,
	52159 - 44032: 0xA89B,
	52160 - 44032: 0xA89C,
	52161 - 44032: 0xA89D,
	52162 - 44032: 0xA89E,
	52163 - 44032: 0xA89F,
	52164 - 44032: 0xA8A0,
	52165 - 44032: 0xA941,
	52166 - 44032: 0xA942,
	52167 - 44032: 0xA943,
	52168 - 44032: 0xA944,
	52169 - 44032: 0xA945,
	52170 - 44032: 0xA946,
	52171 - 44032: 0xA947,
	52172 - 44032: 0xA948,
	52173 - 44032: 0xA949,
	52174 - 44032: 0xA94A,
	52175 - 44032: 0xA94B,
	52176 - 44032: 0xA94C,
	52177 - 44032: 0xA94D,
	52178 - 44032: 0xA94E,
	52179 - 44032: 0xA94F,
	52180 - 44032: 0xC2EA,
	52181 - 44032: 0xA950,
	52182 - 44032: 0xA951,
	52183 - 44032: 0xA952,
	52184 - 44032: 0xA953,
	52185 - 44032: 0xA954,
	52186 - 44032: 0xA955,
	52187 - 44032: 0xA956,
	52188 - 44032: 0xA957,
	52189 - 44032: 0xA958,
	52190 - 44032: 0xA959,
	52191 - 44032: 0xA95A,
	52192 - 44032: 0xA961,
	52193 - 44032: 0xA962,
	52194 - 44032: 0xA963,
	52195 - 44032: 0xA964,
	52196 - 44032: 0xC2EB,
	52197 - 44032: 0xA965,
	52198 - 44032: 0xA966,
	52199 - 44032: 0xC2EC,
	52200 - 44032: 0xA967,
	52201 - 44032: 0xC2ED,
	52202 - 44032: 0xA968,
	52203 - 44032: 0xA969,
	52204 - 44032: 0xA96A,
	52205 - 44032: 0xA96B,
	52206 - 44032: 0xA96C,
	52207 - 44032: 0xA96D,
	52208 - 44032: 0xA96E,
	52209 - 44032: 0xA96F,
	52210 - 44032: 0xA970,
	52211 - 44032: 0xA971,
	52212 - 44032: 0xA972,
	52213 - 44032: 0xA973,
	52214 - 44032: 0xA974,
	52215 - 44032: 0xA975,
	52216 - 44032: 0xA976,
	52217 - 44032: 0xA977,
	52218 - 44032: 0xA978,
	52219 - 44032: 0xA979,
	52220 - 44032: 0xA97A,
	52221 - 44032: 0xA981,
	52222 - 44032: 0xA982,
	52223 - 44032: 0xA983,
	52224 - 44032: 0xA984,
	52225 - 44032: 0xA985,
	52226 - 44032: 0xA986,
	52227 - 44032: 0xA987,
	52228 - 44032: 0xA988,
	52229 - 44032: 0xA989,
	52230 - 44032: 0xA98A,
	52231 - 44032: 0xA98B,
	52232 - 44032: 0xA98C,
	52233 - 44032: 0xA98D,
	52234 - 44032: 0xA98E,
	52235 - 44032: 0xA98F,
	52236 - 44032: 0xC2EE,
	52237 - 44032: 0xC2EF,
	52238 - 44032: 0xA990,
	52239 - 44032: 0xA991,
	52240 - 44032: 0xC2F0,
	52241 - 44032: 0xA992,
	52242 - 44032: 0xA993,
	52243 - 44032: 0xA994,
	52244 - 44032: 0xC2F1,
	52245 - 44032: 0xA995,
	52246 - 44032: 0xA996,
	52247 - 44032: 0xA997,
	52248 - 44032: 0xA998,
	52249 - 44032: 0xA999,
	52250 - 44032: 0xA99A,
	52251 - 44032: 0xA99B,
	52252 - 44032: 0xC2F2,
	52253 - 44032: 0xC2F3,
	52254 - 44032: 0xA99C,
	52255 - 44032: 0xA99D,
	52256 - 44032: 0xA99E,
	52257 - 44032: 0xC2F4,
	52258 - 44032: 0xC2F5,
	52259 - 44032: 0xA99F,
	52260 - 44032: 0xA9A0,
	52261 - 44032: 0xAA41,
	52262 - 44032: 0xAA42,
	52263 - 44032: 0xC2F6,
	52264 - 44032: 0xC2F7,
	52265 - 44032: 0xC2F8,
	52266 - 44032: 0xAA43,
	52267 - 44032: 0xAA44,
	52268 - 44032: 0xC2F9,
	52269 - 44032: 0xAA45,
	52270 - 44032: 0xC2FA,
	52271 - 44032: 0xAA46,
	52272 - 44032: 0xC2FB,
	52273 - 44032: 0xAA47,
	52274 - 44032: 0xAA48,
	52275 - 44032: 0xAA49,
	52276 - 44032: 0xAA4A,
	52277 - 44032: 0xAA4B,
	52278 - 44032: 0xAA4C,
	52279 - 44032: 0xAA4D,
	52280 - 44032: 0xC2FC,
	52281 - 44032: 0xC2FD,
	52282 - 44032: 0xAA4E,
	52283 - 44032: 0xC2FE,
	52284 - 44032: 0xC3A1,
	52285 - 44032: 0xC3A2,
	52286 - 44032: 0xC3A3,
	52287 - 44032: 0xAA4F,
	52288 - 44032: 0xAA50,
	52289 - 44032: 0xAA51,
	52290 - 44032: 0xAA52,
	52291 - 44032: 0xAA53,
	52292 - 44032: 0xC3A4,
	52293 - 44032: 0xC3A5,
	52294 - 44032: 0xAA54,
	52295 - 44032: 0xAA55,
	52296 - 44032: 0xC3A6,
	52297 - 44032: 0xAA56,
	52298 - 44032: 0xAA57,
	52299 - 44032: 0xAA58,
	52300 - 44032: 0xC3A7,
	52301 - 44032: 0xAA59,
	52302 - 44032: 0xAA5A,
	52303 - 44032: 0xAA61,
	52304 - 44032: 0xAA62,
	52305 - 44032: 0xAA63,
	52306 - 44032: 0xAA64,
	52307 - 44032: 0xAA65,
	52308 - 44032: 0xC3A8,
	52309 - 44032: 0xC3A9,
	52310 - 44032: 0xAA66,
	52311 - 44032: 0xC3AA,
	52312 - 44032: 0xC3AB,
	52313 - 44032: 0xC3AC,
	52314 - 44032: 0xAA67,
	52315 - 44032: 0xAA68,
	52316 - 44032: 0xAA69,
	52317 - 44032: 0xAA6A,
	52318 - 44032: 0xAA6B,
	52319 - 44032: 0xAA6C,
	52320 - 44032: 0xC3AD,
	52321 - 44032: 0xAA6D,
	52322 - 44032: 0xAA6E,
	52323 - 44032: 0xAA6F,
	52324 - 44032: 0xC3AE,
	52325 - 44032: 0xAA70,
	52326 - 44032: 0xC3AF,
	52327 - 44032: 0xAA71,
	52328 - 44032: 0xC3B0,
	52329 - 44032: 0xAA72,
	52330 - 44032: 0xAA73,
	52331 - 44032: 0xAA74,
	52332 - 44032: 0xAA75,
	52333 - 44032: 0xAA76,
	52334 - 44032: 0xAA77,
	52335 - 44032: 0xAA78,
	52336 - 44032: 0xC3B1,
	52337 - 44032: 0xAA79,
	52338 - 44032: 0xAA7A,
	52339 - 44032: 0xAA81,
	52340 - 44032: 0xAA82,
	52341 - 44032: 0xC3B2,
	52342 - 44032: 0xAA83,
	52343 - 44032: 0xAA84,
	52344 - 44032: 0xAA85,
	52345 - 44032: 0xAA86,
	52346 - 44032: 0xAA87,
	52347 - 44032: 0xAA88,
	52348 - 44032: 0xAA89,
	52349 - 44032: 0xAA8A,
	52350 - 44032: 0xAA8B,
	52351 - 44032: 0xAA8C,
	52352 - 44032: 0xAA8D,
	52353 - 44032: 0xAA8E,
	52354 - 44032: 0xAA8F,
	52355 - 44032: 0xAA90,
	52356 - 44032: 0xAA91,
	52357 - 44032: 0xAA92,
	52358 - 44032: 0xAA93,
	52359 - 44032: 0xAA94,
	52360 - 44032: 0xAA95,
	52361 - 44032: 0xAA96,
	52362 - 44032: 0xAA97,
	52363 - 44032: 0xAA98,
	52364 - 44032: 0xAA99,
	52365 - 44032: 0xAA9A,
	52366 - 44032: 0xAA9B,
	52367 - 44032: 0xAA9C,
	52368 - 44032: 0xAA9D,
	52369 - 44032: 0xAA9E,
	52370 - 44032: 0xAA9F,
	52371 - 44032: 0xAAA0,
	52372 - 44032: 0xAB41,
	52373 - 44032: 0xAB42,
	52374 - 44032: 0xAB43,
	52375 - 44032: 0xAB44,
	52376 - 44032: 0xC3B3,
	52377 - 44032: 0xC3B4,
	52378 - 44032: 0xAB45,
	52379 - 44032: 0xAB46,
	52380 - 44032: 0xC3B5,
	52381 - 44032: 0xAB47,
	52382 - 44032: 0xAB48,
	52383 - 44032: 0xAB49,
	52384 - 44032: 0xC3B6,
	52385 - 44032: 0xAB4A,
	52386 - 44032: 0xAB4B,
	52387 - 44032: 0xAB4C,
	52388 - 44032: 0xAB4D,
	52389 - 44032: 0xAB4E,
	52390 - 44032: 0xAB4F,
	52391 - 44032: 0xAB50,
	52392 - 44032: 0xC3B7,
	52393 - 44032: 0xC3B8,
	52394 - 44032: 0xAB51,
	52395 - 44032: 0xC3B9,
	52396 - 44032: 0xC3BA,
	52397 - 44032: 0xC3BB,
	52398 - 44032: 0xAB52,
	52399 - 44032: 0xAB53,
	52400 - 44032: 0xAB54,
	52401 - 44032: 0xAB55,
	52402 - 44032: 0xAB56,
	52403 - 44032: 0xAB57,
	52404 - 44032: 0xC3BC,
	52405 - 44032: 0xC3BD,
	52406 - 44032: 0xAB58,
	52407 - 44032: 0xAB59,
	52408 - 44032: 0xC3BE,
	52409 - 44032: 0xAB5A,
	52410 - 44032: 0xAB61,
	52411 - 44032: 0xAB62,
	52412 - 44032: 0xC3BF,
	52413 - 44032: 0xAB63,
	52414 - 44032: 0xAB64,
	52415 - 44032: 0xAB65,
	52416 - 44032: 0xAB66,
	52417 - 44032: 0xAB67,
	52418 - 44032: 0xAB68,
	52419 - 44032: 0xAB69,
	52420 - 44032: 0xC3C0,
	52421 - 44032: 0xC3C1,
	52422 - 44032: 0xAB6A,
	52423 - 44032: 0xC3C2,
	52424 - 44032: 0xAB6B,
	52425 - 44032: 0xC3C3,
	52426 - 44032: 0xAB6C,
	52427 - 44032: 0xAB6D,
	52428 - 44032: 0xAB6E,
	52429 - 44032: 0xAB6F,
	52430 - 44032: 0xAB70,
	52431 - 44032: 0xAB71,
	52432 - 44032: 0xC3C4,
	52433 - 44032: 0xAB72,
	52434 - 44032: 0xAB73,
	52435 - 44032: 0xAB74,
	52436 - 44032: 0xC3C5,
	52437 - 44032: 0xAB75,
	52438 - 44032: 0xAB76,
	52439 - 44032: 0xAB77,
	52440 - 44032: 0xAB78,
	52441 - 44032: 0xAB79,
	52442 - 44032: 0xAB7A,
	52443 - 44032: 0xAB81,
	52444 - 44032: 0xAB82,
	52445 - 44032: 0xAB83,
	52446 - 44032: 0xAB84,
	52447 - 44032: 0xAB85,
	52448 - 44032: 0xAB86,
	52449 - 44032: 0xAB87,
	52450 - 44032: 0xAB88,
	52451 - 44032: 0xAB89,
	52452 - 44032: 0xC3C6,
	52453 - 44032: 0xAB8A,
	52454 - 44032: 0xAB8B,
	52455 - 44032: 0xAB8C,
	52456 - 44032: 0xAB8D,
	52457 - 44032: 0xAB8E,
	52458 - 44032: 0xAB8F,
	52459 - 44032: 0xAB90,
	52460 - 44032: 0xC3C7,
	52461 - 44032: 0xAB91,
	52462 - 44032: 0xAB92,
	52463 - 44032: 0xAB93,
	52464 - 44032: 0xC3C8,
	52465 - 44032: 0xAB94,
	52466 - 44032: 0xAB95,
	52467 - 44032: 0xAB96,
	52468 - 44032: 0xAB97,
	52469 - 44032: 0xAB98,
	52470 - 44032: 0xAB99,
	52471 - 44032: 0xAB9A,
	52472 - 44032: 0xAB9B,
	52473 - 44032: 0xAB9C,
	52474 - 44032: 0xAB9D,
	52475 - 44032: 0xAB9E,
	52476 - 44032: 0xAB9F,
	52477 - 44032: 0xABA0,
	52478 - 44032: 0xAC41,
	52479 - 44032: 0xAC42,
	52480 - 44032: 0xAC43,
	52481 - 44032: 0xC3C9,
	52482 - 44032: 0xAC44,
	52483 - 44032: 0xAC45,
	52484 - 44032: 0xAC46,
	52485 - 44032: 0xAC47,
	52486 - 44032: 0xAC48,
	52487 - 44032: 0xAC49,
	52488 - 44032: 0xC3CA,
	52489 - 44032: 0xC3CB,
	52490 - 44032: 0xAC4A,
	52491 - 44032: 0xAC4B,
	52492 - 44032: 0xC3CC,
	52493 - 44032: 0xAC4C,
	52494 - 44032: 0xAC4D,
	52495 - 44032: 0xAC4E,
	52496 - 44032: 0xC3CD,
	52497 - 44032: 0xAC4F,
	52498 - 44032: 0xAC50,
	52499 - 44032: 0xAC51,
	52500 - 44032: 0xAC52,
	52501 - 44032: 0xAC53,
	52502 - 44032: 0xAC54,
	52503 - 44032: 0xAC55,
	52504 - 44032: 0xC3CE,
	52505 - 44032: 0xC3CF,
	52506 - 44032: 0xAC56,
	52507 - 44032: 0xC3D0,
	52508 - 44032: 0xAC57,
	52509 - 44032: 0xC3D1,
	52510 - 44032: 0xAC58,
	52511 - 44032: 0xAC59,
	52512 - 44032: 0xAC5A,
	52513 - 44032: 0xAC61,
	52514 - 44032: 0xAC62,
	52515 - 44032: 0xAC63,
	52516 - 44032: 0xC3D2,
	52517 - 44032: 0xAC64,
	52518 - 44032: 0xAC65,
	52519 - 44032: 0xAC66,
	52520 - 44032: 0xC3D3,
	52521 - 44032: 0xAC67,
	52522 - 44032: 0xAC68,
	52523 - 44032: 0xAC69,
	52524 - 44032: 0xC3D4,
	52525 - 44032: 0xAC6A,
	52526 - 44032: 0xAC6B,
	52527 - 44032: 0xAC6C,
	52528 - 44032: 0xAC6D,
	52529 - 44032: 0xAC6E,
	52530 - 44032: 0xAC6F,
	52531 - 44032: 0xAC70,
	52532 - 44032: 0xAC71,
	52533 - 44032: 0xAC72,
	52534 - 44032: 0xAC73,
	52535 - 44032: 0xAC74,
	52536 - 44032: 0xAC75,
	52537 - 44032: 0xC3D5,
	52538 - 44032: 0xAC76,
	52539 - 44032: 0xAC77,
	52540 - 44032: 0xAC78,
	52541 - 44032: 0xAC79,
	52542 - 44032: 0xAC7A,
	52543 - 44032: 0xAC81,
	52544 - 44032: 0xAC82,
	52545 - 44032: 0xAC83,
	52546 - 44032: 0xAC84,
	52547 - 44032: 0xAC85,
	52548 - 44032: 0xAC86,
	52549 - 44032: 0xAC87,
	52550 - 44032: 0xAC88,
	52551 - 44032: 0xAC89,
	52552 - 44032: 0xAC8A,
	52553 - 44032: 0xAC8B,
	52554 - 44032: 0xAC8C,
	52555 - 44032: 0xAC8D,
	52556 - 44032: 0xAC8E,
	52557 - 44032: 0xAC8F,
	52558 - 44032: 0xAC90,
	52559 - 44032: 0xAC91,
	52560 - 44032: 0xAC92,
	52561 - 44032: 0xAC93,
	52562 - 44032: 0xAC94,
	52563 - 44032: 0xAC95,
	52564 - 44032: 0xAC96,
	52565 - 44032: 0xAC97,
	52566 - 44032: 0xAC98,
	52567 - 44032: 0xAC99,
	52568 - 44032: 0xAC9A,
	52569 - 44032: 0xAC9B,
	52570 - 44032: 0xAC9C,
	52571 - 44032: 0xAC9D,
	52572 - 44032: 0xC3D6,
	52573 - 44032: 0xAC9E,
	52574 - 44032: 0xAC9F,
	52575 - 44032: 0xACA0,
	52576 - 44032: 0xC3D7,
	52577 - 44032: 0xAD41,
	52578 - 44032: 0xAD42,
	52579 - 44032: 0xAD43,
	52580 - 44032: 0xC3D8,
	52581 - 44032: 0xAD44,
	52582 - 44032: 0xAD45,
	52583 - 44032: 0xAD46,
	52584 - 44032: 0xAD47,
	52585 - 44032: 0xAD48,
	52586 - 44032: 0xAD49,
	52587 - 44032: 0xAD4A,
	52588 - 44032: 0xC3D9,
	52589 - 44032: 0xC3DA,
	52590 - 44032: 0xAD4B,
	52591 - 44032: 0xC3DB,
	52592 - 44032: 0xAD4C,
	52593 - 44032: 0xC3DC,
	52594 - 44032: 0xAD4D,
	52595 - 44032: 0xAD4E,
	52596 - 44032: 0xAD4F,
	52597 - 44032: 0xAD50,
	52598 - 44032: 0xAD51,
	52599 - 44032: 0xAD52,
	52600 - 44032: 0xC3DD,
	52601 - 44032: 0xAD53,
	52602 - 44032: 0xAD54,
	52603 - 44032: 0xAD55,
	52604 - 44032: 0xAD56,
	52605 - 44032: 0xAD57,
	52606 - 44032: 0xAD58,
	52607 - 44032: 0xAD59,
	52608 - 44032: 0xAD5A,
	52609 - 44032: 0xAD61,
	52610 - 44032: 0xAD62,
	52611 - 44032: 0xAD63,
	52612 - 44032: 0xAD64,
	52613 - 44032: 0xAD65,
	52614 - 44032: 0xAD66,
	52615 - 44032: 0xAD67,
	52616 - 44032: 0xC3DE,
	52617 - 44032: 0xAD68,
	52618 - 44032: 0xAD69,
	52619 - 44032: 0xAD6A,
	52620 - 44032: 0xAD6B,
	52621 - 44032: 0xAD6C,
	52622 - 44032: 0xAD6D,
	52623 - 44032: 0xAD6E,
	52624 - 44032: 0xAD6F,
	52625 - 44032: 0xAD70,
	52626 - 44032: 0xAD71,
	52627 - 44032: 0xAD72,
	52628 - 44032: 0xC3DF,
	52629 - 44032: 0xC3E0,
	52630 - 44032: 0xAD73,
	52631 - 44032: 0xAD74,
	52632 - 44032: 0xC3E1,
	52633 - 44032: 0xAD75,
	52634 - 44032: 0xAD76,
	52635 - 44032: 0xAD77,
	52636 - 44032: 0xC3E2,
	52637 - 44032: 0xAD78,
	52638 - 44032: 0xAD79,
	52639 - 44032: 0xAD7A,
	52640 - 44032: 0xAD81,
	52641 - 44032: 0xAD82,
	52642 - 44032: 0xAD83,
	52643 - 44032: 0xAD84,
	52644 - 44032: 0xC3E3,
	52645 - 44032: 0xC3E4,
	52646 - 44032: 0xAD85,
	52647 - 44032: 0xC3E5,
	52648 - 44032: 0xAD86,
	52649 - 44032: 0xC3E6,
	52650 - 44032: 0xAD87,
	52651 - 44032: 0xAD88,
	52652 - 44032: 0xAD89,
	52653 - 44032: 0xAD8A,
	52654 - 44032: 0xAD8B,
	52655 - 44032: 0xAD8C,
	52656 - 44032: 0xC3E7,
	52657 - 44032: 0xAD8D,
	52658 - 44032: 0xAD8E,
	52659 - 44032: 0xAD8F,
	52660 - 44032: 0xAD90,
	52661 - 44032: 0xAD91,
	52662 - 44032: 0xAD92,
	52663 - 44032: 0xAD93,
	52664 - 44032: 0xAD94,
	52665 - 44032: 0xAD95,
	52666 - 44032: 0xAD96,
	52667 - 44032: 0xAD97,
	52668 - 44032: 0xAD98,
	52669 - 44032: 0xAD99,
	52670 - 44032: 0xAD9A,
	52671 - 44032: 0xAD9B,
	52672 - 44032: 0xAD9C,
	52673 - 44032: 0xAD9D,
	52674 - 44032: 0xAD9E,
	52675 - 44032: 0xAD9F,
	52676 - 44032: 0xC3E8,
	52677 - 44032: 0xADA0,
	52678 - 44032: 0xAE41,
	52679 - 44032: 0xAE42,
	52680 - 44032: 0xAE43,
	52681 - 44032: 0xAE44,
	52682 - 44032: 0xAE45,
	52683 - 44032: 0xAE46,
	52684 - 44032: 0xC3E9,
	52685 - 44032: 0xAE47,
	52686 - 44032: 0xAE48,
	52687 - 44032: 0xAE49,
	52688 - 44032: 0xC3EA,
	52689 - 44032: 0xAE4A,
	52690 - 44032: 0xAE4B,
	52691 - 44032: 0xAE4C,
	52692 - 44032: 0xAE4D,
	52693 - 44032: 0xAE4E,
	52694 - 44032: 0xAE4F,
	52695 - 44032: 0xAE50,
	52696 - 44032: 0xAE51,
	52697 - 44032: 0xAE52,
	52698 - 44032: 0xAE53,
	52699 - 44032: 0xAE54,
	52700 - 44032: 0xAE55,
	52701 - 44032: 0xAE56,
	52702 - 44032: 0xAE57,
	52703 - 44032: 0xAE58,
	52704 - 44032: 0xAE59,
	52705 - 44032: 0xAE5A,
	52706 - 44032: 0xAE61,
	52707 - 44032: 0xAE62,
	52708 - 44032: 0xAE63,
	52709 - 44032: 0xAE64,
	52710 - 44032: 0xAE65,
	52711 - 44032: 0xAE66,
	52712 - 44032: 0xC3EB,
	52713 - 44032: 0xAE67,
	52714 - 44032: 0xAE68,
	52715 - 44032: 0xAE69,
	52716 - 44032: 0xC3EC,
	52717 - 44032: 0xAE6A,
	52718 - 44032: 0xAE6B,
	52719 - 44032: 0xAE6C,
	52720 - 44032: 0xC3ED,
	52721 - 44032: 0xAE6D,
	52722 - 44032: 0xAE6E,
	52723 - 44032: 0xAE6F,
	52724 - 44032: 0xAE70,
	52725 - 44032: 0xAE71,
	52726 - 44032: 0xAE72,
	52727 - 44032: 0xAE73,
	52728 - 44032: 0xC3EE,
	52729 - 44032: 0xC3EF,
	52730 - 44032: 0xAE74,
	52731 - 44032: 0xC3F0,
	52732 - 44032: 0xAE75,
	52733 - 44032: 0xC3F1,
	52734 - 44032: 0xAE76,
	52735 - 44032: 0xAE77,
	52736 - 44032: 0xAE78,
	52737 - 44032: 0xAE79,
	52738 - 44032: 0xAE7A,
	52739 - 44032: 0xAE81,
	52740 - 44032: 0xC3F2,
	52741 - 44032: 0xAE82,
	52742 - 44032: 0xAE83,
	52743 - 44032: 0xAE84,
	52744 - 44032: 0xC3F3,
	52745 - 44032: 0xAE85,
	52746 - 44032: 0xAE86,
	52747 - 44032: 0xAE87,
	52748 - 44032: 0xC3F4,
	52749 - 44032: 0xAE88,
	52750 - 44032: 0xAE89,
	52751 - 44032: 0xAE8A,
	52752 - 44032: 0xAE8B,
	52753 - 44032: 0xAE8C,
	52754 - 44032: 0xAE8D,
	52755 - 44032: 0xAE8E,
	52756 - 44032: 0xC3F5,
	52757 - 44032: 0xAE8F,
	52758 - 44032: 0xAE90,
	52759 - 44032: 0xAE91,
	52760 - 44032: 0xAE92,
	52761 - 44032: 0xC3F6,
	52762 - 44032: 0xAE93,
	52763 - 44032: 0xAE94,
	52764 - 44032: 0xAE95,
	52765 - 44032: 0xAE96,
	52766 - 44032: 0xAE97,
	52767 - 44032: 0xAE98,
	52768 - 44032: 0xC3F7,
	52769 - 44032: 0xC3F8,
	52770 - 44032: 0xAE99,
	52771 - 44032: 0xAE9A,
	52772 - 44032: 0xC3F9,
	52773 - 44032: 0xAE9B,
	52774 - 44032: 0xAE9C,
	52775 - 44032: 0xAE9D,
	52776 - 44032: 0xC3FA,
	52777 - 44032: 0xAE9E,
	52778 - 44032: 0xAE9F,
	52779 - 44032: 0xAEA0,
	52780 - 44032: 0xAF41,
	52781 - 44032: 0xAF42,
	52782 - 44032: 0xAF43,
	52783 - 44032: 0xAF44,
	52784 - 44032: 0xC3FB,
	52785 - 44032: 0xC3FC,
	52786 - 44032: 0xAF45,
	52787 - 44032: 0xC3FD,
	52788 - 44032: 0xAF46,
	52789 - 44032: 0xC3FE,
	52790 - 44032: 0xAF47,
	52791 - 44032: 0xAF48,
	52792 - 44032: 0xAF49,
	52793 - 44032: 0xAF4A,
	52794 - 44032: 0xAF4B,
	52795 - 44032: 0xAF4C,
	52796 - 44032: 0xAF4D,
	52797 - 44032: 0xAF4E,
	52798 - 44032: 0xAF4F,
	52799 - 44032: 0xAF50,
	52800 - 44032: 0xAF51,
	52801 - 44032: 0xAF52,
	52802 - 44032: 0xAF53,
	52803 - 44032: 0xAF54,
	52804 - 44032: 0xAF55,
	52805 - 44032: 0xAF56,
	52806 - 44032: 0xAF57,
	52807 - 44032: 0xAF58,
	52808 - 44032: 0xAF59,
	52809 - 44032: 0xAF5A,
	52810 - 44032: 0xAF61,
	52811 - 44032: 0xAF62,
	52812 - 44032: 0xAF63,
	52813 - 44032: 0xAF64,
	52814 - 44032: 0xAF65,
	52815 - 44032: 0xAF66,
	52816 - 44032: 0xAF67,
	52817 - 44032: 0xAF68,
	52818 - 44032: 0xAF69,
	52819 - 44032: 0xAF6A,
	52820 - 44032: 0xAF6B,
	52821 - 44032: 0xAF6C,
	52822 - 44032: 0xAF6D,
	52823 - 44032: 0xAF6E,
	52824 - 44032: 0xC4A1,
	52825 - 44032: 0xC4A2,
	52826 - 44032: 0xAF6F,
	52827 - 44032: 0xAF70,
	52828 - 44032: 0xC4A3,
	52829 - 44032: 0xAF71,
	52830 - 44032: 0xAF72,
	52831 - 44032: 0xC4A4,
	52832 - 44032: 0xC4A5,
	52833 - 44032: 0xC4A6,
	52834 - 44032: 0xAF73,
	52835 - 44032: 0xAF74,
	52836 - 44032: 0xAF75,
	52837 - 44032: 0xAF76,
	52838 - 44032: 0xAF77,
	52839 - 44032: 0xAF78,
	52840 - 44032: 0xC4A7,
	52841 - 44032: 0xC4A8,
	52842 - 44032: 0xAF79,
	52843 - 44032: 0xC4A9,
	52844 - 44032: 0xAF7A,
	52845 - 44032: 0xC4AA,
	52846 - 44032: 0xAF81,
	52847 - 44032: 0xAF82,
	52848 - 44032: 0xAF83,
	52849 - 44032: 0xAF84,
	52850 - 44032: 0xAF85,
	52851 - 44032: 0xAF86,
	52852 - 44032: 0xC4AB,
	52853 - 44032: 0xC4AC,
	52854 - 44032: 0xAF87,
	52855 - 44032: 0xAF88,
	52856 - 44032: 0xC4AD,
	52857 - 44032: 0xAF89,
	52858 - 44032: 0xAF8A,
	52859 - 44032: 0xAF8B,
	52860 - 44032: 0xC4AE,
	52861 - 44032: 0xAF8C,
	52862 - 44032: 0xAF8D,
	52863 - 44032: 0xAF8E,
	52864 - 44032: 0xAF8F,
	52865 - 44032: 0xAF90,
	52866 - 44032: 0xAF91,
	52867 - 44032: 0xAF92,
	52868 - 44032: 0xC4AF,
	52869 - 44032: 0xC4B0,
	52870 - 44032: 0xAF93,
	52871 - 44032: 0xC4B1,
	52872 - 44032: 0xAF94,
	52873 - 44032: 0xC4B2,
	52874 - 44032: 0xAF95,
	52875 - 44032: 0xAF96,
	52876 - 44032: 0xAF97,
	52877 - 44032: 0xAF98,
	52878 - 44032: 0xAF99,
	52879 - 44032: 0xAF9A,
	52880 - 44032: 0xC4B3,
	52881 - 44032: 0xC4B4,
	52882 - 44032: 0xAF9B,
	52883 - 44032: 0xAF9C,
	52884 - 44032: 0xC4B5,
	52885 - 44032: 0xAF9D,
	52886 - 44032: 0xAF9E,
	52887 - 44032: 0xAF9F,
	52888 - 44032: 0xC4B6,
	52889 - 44032: 0xAFA0,
	52890 - 44032: 0xB041,
	52891 - 44032: 0xB042,
	52892 - 44032: 0xB043,
	52893 - 44032: 0xB044,
	52894 - 44032: 0xB045,
	52895 - 44032: 0xB046,
	52896 - 44032: 0xC4B7,
	52897 - 44032: 0xC4B8,
	52898 - 44032: 0xB047,
	52899 - 44032: 0xC4B9,
	52900 - 44032: 0xC4BA,
	52901 - 44032: 0xC4BB,
	52902 - 44032: 0xB048,
	52903 - 44032: 0xB049,
	52904 - 44032: 0xB04A,
	52905 - 44032: 0xB04B,
	52906 - 44032: 0xB04C,
	52907 - 44032: 0xB04D,
	52908 - 44032: 0xC4BC,
	52909 - 44032: 0xC4BD,
	52910 - 44032: 0xB04E,
	52911 - 44032: 0xB04F,
	52912 - 44032: 0xB050,
	52913 - 44032: 0xB051,
	52914 - 44032: 0xB052,
	52915 - 44032: 0xB053,
	52916 - 44032: 0xB054,
	52917 - 44032: 0xB055,
	52918 - 44032: 0xB056,
	52919 - 44032: 0xB057,
	52920 - 44032: 0xB058,
	52921 - 44032: 0xB059,
	52922 - 44032: 0xB05A,
	52923 - 44032: 0xB061,
	52924 - 44032: 0xB062,
	52925 - 44032: 0xB063,
	52926 - 44032: 0xB064,
	52927 - 44032: 0xB065,
	52928 - 44032: 0xB066,
	52929 - 44032: 0xC4BE,
	52930 - 44032: 0xB067,
	52931 - 44032: 0xB068,
	52932 - 44032: 0xB069,
	52933 - 44032: 0xB06A,
	52934 - 44032: 0xB06B,
	52935 - 44032: 0xB06C,
	52936 - 44032: 0xB06D,
	52937 - 44032: 0xB06E,
	52938 - 44032: 0xB06F,
	52939 - 44032: 0xB070,
	52940 - 44032: 0xB071,
	52941 - 44032: 0xB072,
	52942 - 44032: 0xB073,
	52943 - 44032: 0xB074,
	52944 - 44032: 0xB075,
	52945 - 44032: 0xB076,
	52946 - 44032: 0xB077,
	52947 - 44032: 0xB078,
	52948 - 44032: 0xB079,
	52949 - 44032: 0xB07A,
	52950 - 44032: 0xB081,
	52951 - 44032: 0xB082,
	52952 - 44032: 0xB083,
	52953 - 44032: 0xB084,
	52954 - 44032: 0xB085,
	52955 - 44032: 0xB086,
	52956 - 44032: 0xB087,
	52957 - 44032: 0xB088,
	52958 - 44032: 0xB089,
	52959 - 44032: 0xB08A,
	52960 - 44032: 0xB08B,
	52961 - 44032: 0xB08C,
	52962 - 44032: 0xB08D,
	52963 - 44032: 0xB08E,
	52964 - 44032: 0xC4BF,
	52965 - 44032: 0xC4C0,
	52966 - 44032: 0xB08F,
	52967 - 44032: 0xB090,
	52968 - 44032: 0xC4C1,
	52969 - 44032: 0xB091,
	52970 - 44032: 0xB092,
	52971 - 44032: 0xC4C2,
	52972 - 44032: 0xC4C3,
	52973 - 44032: 0xB093,
	52974 - 44032: 0xB094,
	52975 - 44032: 0xB095,
	52976 - 44032: 0xB096,
	52977 - 44032: 0xB097,
	52978 - 44032: 0xB098,
	52979 - 44032: 0xB099,
	52980 - 44032: 0xC4C4,
	52981 - 44032: 0xC4C5,
	52982 - 44032: 0xB09A,
	52983 - 44032: 0xC4C6,
	52984 - 44032: 0xC4C7,
	52985 - 44032: 0xC4C8,
	52986 - 44032: 0xB09B,
	52987 - 44032: 0xB09C,
	52988 - 44032: 0xB09D,
	52989 - 44032: 0xB09E,
	52990 - 44032: 0xB09F,
	52991 - 44032: 0xB0A0,
	52992 - 44032: 0xC4C9,
	52993 - 44032: 0xC4CA,
	52994 - 44032: 0xB141,
	52995 - 44032: 0xB142,
	52996 - 44032: 0xC4CB,
	52997 - 44032: 0xB143,
	52998 - 44032: 0xB144,
	52999 - 44032: 0xB145,
	53000 - 44032: 0xC4CC,
	53001 - 44032: 0xB146,
	53002 - 44032: 0xB147,
	53003 - 44032: 0xB148,
	53004 - 44032: 0xB149,
	53005 - 44032: 0xB14A,
	53006 - 44032: 0xB14B,
	53007 - 44032: 0xB14C,
	53008 - 44032: 0xC4CD,
	53009 - 44032: 0xC4CE,
	53010 - 44032: 0xB14D,
	53011 - 44032: 0xC4CF,
	53012 - 44032: 0xB14E,
	53013 - 44032: 0xC4D0,
	53014 - 44032: 0xB14F,
	53015 - 44032: 0xB150,
	53016 - 44032: 0xB151,
	53017 - 44032: 0xB152,
	53018 - 44032: 0xB153,
	53019 - 44032: 0xB154,
	53020 - 44032: 0xC4D1,
	53021 - 44032: 0xB155,
	53022 - 44032: 0xB156,
	53023 - 44032: 0xB157,
	53024 - 44032: 0xC4D2,
	53025 - 44032: 0xB158,
	53026 - 44032: 0xB159,
	53027 - 44032: 0xB15A,
	53028 - 44032: 0xC4D3,
	53029 - 44032: 0xB161,
	53030 - 44032: 0xB162,
	53031 - 44032: 0xB163,
	53032 - 44032: 0xB164,
	53033 - 44032: 0xB165,
	53034 - 44032: 0xB166,
	53035 - 44032: 0xB167,
	53036 - 44032: 0xC4D4,
	53037 - 44032: 0xC4D5,
	53038 - 44032: 0xB168,
	53039 - 44032: 0xC4D6,
	53040 - 44032: 0xC4D7,
	53041 - 44032: 0xC4D8,
	53042 - 44032: 0xB169,
	53043 - 44032: 0xB16A,
	53044 - 44032: 0xB16B,
	53045 - 44032: 0xB16C,
	53046 - 44032: 0xB16D,
	53047 - 44032: 0xB16E,
	53048 - 44032: 0xC4D9,
	53049 - 44032: 0xB16F,
	53050 - 44032: 0xB170,
	53051 - 44032: 0xB171,
	53052 - 44032: 0xB172,
	53053 - 44032: 0xB173,
	53054 - 44032: 0xB174,
	53055 - 44032: 0xB175,
	53056 - 44032: 0xB176,
	53057 - 44032: 0xB177,
	53058 - 44032: 0xB178,
	53059 - 44032: 0xB179,
	53060 - 44032: 0xB17A,
	53061 - 44032: 0xB181,
	53062 - 44032: 0xB182,
	53063 - 44032: 0xB183,
	53064 - 44032: 0xB184,
	53065 - 44032: 0xB185,
	53066 - 44032: 0xB186,
	53067 - 44032: 0xB187,
	53068 - 44032: 0xB188,
	53069 - 44032: 0xB189,
	53070 - 44032: 0xB18A,
	53071 - 44032: 0xB18B,
	53072 - 44032: 0xB18C,
	53073 - 44032: 0xB18D,
	53074 - 44032: 0xB18E,
	53075 - 44032: 0xB18F,
	53076 - 44032: 0xC4DA,
	53077 - 44032: 0xC4DB,
	53078 - 44032: 0xB190,
	53079 - 44032: 0xB191,
	53080 - 44032: 0xC4DC,
	53081 - 44032: 0xB192,
	53082 - 44032: 0xB193,
	53083 - 44032: 0xB194,
	53084 - 44032: 0xC4DD,
	53085 - 44032: 0xB195,
	53086 - 44032: 0xB196,
	53087 - 44032: 0xB197,
	53088 - 44032: 0xB198,
	53089 - 44032: 0xB199,
	53090 - 44032: 0xB19A,
	53091 - 44032: 0xB19B,
	53092 - 44032: 0xC4DE,
	53093 - 44032: 0xC4DF,
	53094 - 44032: 0xB19C,
	53095 - 44032: 0xC4E0,
	53096 - 44032: 0xB19D,
	53097 - 44032: 0xC4E1,
	53098 - 44032: 0xB19E,
	53099 - 44032: 0xB19F,
	53100 - 44032: 0xB1A0,
	53101 - 44032: 0xB241,
	53102 - 44032: 0xB242,
	53103 - 44032: 0xB243,
	53104 - 44032: 0xC4E2,
	53105 - 44032: 0xC4E3,
	53106 - 44032: 0xB244,
	53107 - 44032: 0xB245,
	53108 - 44032: 0xC4E4,
	53109 - 44032: 0xB246,
	53110 - 44032: 0xB247,
	53111 - 44032: 0xB248,
	53112 - 44032: 0xC4E5,
	53113 - 44032: 0xB249,
	53114 - 44032: 0xB24A,
	53115 - 44032: 0xB24B,
	53116 - 44032: 0xB24C,
	53117 - 44032: 0xB24D,
	53118 - 44032: 0xB24E,
	53119 - 44032: 0xB24F,
	53120 - 44032: 0xC4E6,
	53121 - 44032: 0xB250,
	53122 - 44032: 0xB251,
	53123 - 44032: 0xB252,
	53124 - 44032: 0xB253,
	53125 - 44032: 0xC4E7,
	53126 - 44032: 0xB254,
	53127 - 44032: 0xB255,
	53128 - 44032: 0xB256,
	53129 - 44032: 0xB257,
	53130 - 44032: 0xB258,
	53131 - 44032: 0xB259,
	53132 - 44032: 0xC4E8,
	53133 - 44032: 0xB25A,
	53134 - 44032: 0xB261,
	53135 - 44032: 0xB262,
	53136 - 44032: 0xB263,
	53137 - 44032: 0xB264,
	53138 - 44032: 0xB265,
	53139 - 44032: 0xB266,
	53140 - 44032: 0xB267,
	53141 - 44032: 0xB268,
	53142 - 44032: 0xB269,
	53143 - 44032: 0xB26A,
	53144 - 44032: 0xB26B,
	53145 - 44032: 0xB26C,
	53146 - 44032: 0xB26D,
	53147 - 44032: 0xB26E,
	53148 - 44032: 0xB26F,
	53149 - 44032: 0xB270,
	53150 - 44032: 0xB271,
	53151 - 44032: 0xB272,
	53152 - 44032: 0xB273,
	53153 - 44032: 0xC4E9,
	53154 - 44032: 0xB274,
	53155 - 44032: 0xB275,
	53156 - 44032: 0xB276,
	53157 - 44032: 0xB277,
	53158 - 44032: 0xB278,
	53159 - 44032: 0xB279,
	53160 - 44032: 0xC4EA,
	53161 - 44032: 0xB27A,
	53162 - 44032: 0xB281,
	53163 - 44032: 0xB282,
	53164 - 44032: 0xB283,
	53165 - 44032: 0xB284,
	53166 - 44032: 0xB285,
	53167 - 44032: 0xB286,
	53168 - 44032: 0xC4EB,
	53169 - 44032: 0xB287,
	53170 - 44032: 0xB288,
	53171 - 44032: 0xB289,
	53172 - 44032: 0xB28A,
	53173 - 44032: 0xB28B,
	53174 - 44032: 0xB28C,
	53175 - 44032: 0xB28D,
	53176 - 44032: 0xB28E,
	53177 - 44032: 0xB28F,
	53178 - 44032: 0xB290,
	53179 - 44032: 0xB291,
	53180 - 44032: 0xB292,
	53181 - 44032: 0xB293,
	53182 - 44032: 0xB294,
	53183 - 44032: 0xB295,
	53184 - 44032: 0xB296,
	53185 - 44032: 0xB297,
	53186 - 44032: 0xB298,
	53187 - 44032: 0xB299,
	53188 - 44032: 0xC4EC,
	53189 - 44032: 0xB29A,
	53190 - 44032: 0xB29B,
	53191 - 44032: 0xB29C,
	53192 - 44032: 0xB29D,
	53193 - 44032: 0xB29E,
	53194 - 44032: 0xB29F,
	53195 - 44032: 0xB2A0,
	53196 - 44032: 0xB341,
	53197 - 44032: 0xB342,
	53198 - 44032: 0xB343,
	53199 - 44032: 0xB344,
	53200 - 44032: 0xB345,
	53201 - 44032: 0xB346,
	53202 - 44032: 0xB347,
	53203 - 44032: 0xB348,
	53204 - 44032: 0xB349,
	53205 - 44032: 0xB34A,
	53206 - 44032: 0xB34B,
	53207 - 44032: 0xB34C,
	53208 - 44032: 0xB34D,
	53209 - 44032: 0xB34E,
	53210 - 44032: 0xB34F,
	53211 - 44032: 0xB350,
	53212 - 44032: 0xB351,
	53213 - 44032: 0xB352,
	53214 - 44032: 0xB353,
	53215 - 44032: 0xB354,
	53216 - 44032: 0xC4ED,
	53217 - 44032: 0xC4EE,
	53218 - 44032: 0xB355,
	53219 - 44032: 0xB356,
	53220 - 44032: 0xC4EF,
	53221 - 44032: 0xB357,
	53222 - 44032: 0xB358,
	53223 - 44032: 0xB359,
	53224 - 44032: 0xC4F0,
	53225 - 44032: 0xB35A,
	53226 - 44032: 0xB361,
	53227 - 44032: 0xB362,
	53228 - 44032: 0xB363,
	53229 - 44032: 0xB364,
	53230 - 44032: 0xB365,
	53231 - 44032: 0xB366,
	53232 - 44032: 0xC4F1,
	53233 - 44032: 0xC4F2,
	53234 - 44032: 0xB367,
	53235 - 44032: 0xC4F3,
	53236 - 44032: 0xB368,
	53237 - 44032: 0xC4F4,
	53238 - 44032: 0xB369,
	53239 - 44032: 0xB36A,
	53240 - 44032: 0xB36B,
	53241 - 44032: 0xB36C,
	53242 - 44032: 0xB36D,
	53243 - 44032: 0xB36E,
	53244 - 44032: 0xC4F5,
	53245 - 44032: 0xB36F,
	53246 - 44032: 0xB370,
	53247 - 44032: 0xB371,
	53248 - 44032: 0xC4F6,
	53249 - 44032: 0xB372,
	53250 - 44032: 0xB373,
	53251 - 44032: 0xB374,
	53252 - 44032: 0xC4F7,
	53253 - 44032: 0xB375,
	53254 - 44032: 0xB376,
	53255 - 44032: 0xB377,
	53256 - 44032: 0xB378,
	53257 - 44032: 0xB379,
	53258 - 44032: 0xB37A,
	53259 - 44032: 0xB381,
	53260 - 44032: 0xB382,
	53261 - 44032: 0xB383,
	53262 - 44032: 0xB384,
	53263 - 44032: 0xB385,
	53264 - 44032: 0xB386,
	53265 - 44032: 0xC4F8,
	53266 - 44032: 0xB387,
	53267 - 44032: 0xB388,
	53268 - 44032: 0xB389,
	53269 - 44032: 0xB38A,
	53270 - 44032: 0xB38B,
	53271 - 44032: 0xB38C,
	53272 - 44032: 0xC4F9,
	53273 - 44032: 0xB38D,
	53274 - 44032: 0xB38E,
	53275 - 44032: 0xB38F,
	53276 - 44032: 0xB390,
	53277 - 44032: 0xB391,
	53278 - 44032: 0xB392,
	53279 - 44032: 0xB393,
	53280 - 44032: 0xB394,
	53281 - 44032: 0xB395,
	53282 - 44032: 0xB396,
	53283 - 44032: 0xB397,
	53284 - 44032: 0xB398,
	53285 - 44032: 0xB399,
	53286 - 44032: 0xB39A,
	53287 - 44032: 0xB39B,
	53288 - 44032: 0xB39C,
	53289 - 44032: 0xB39D,
	53290 - 44032: 0xB39E,
	53291 - 44032: 0xB39F,
	53292 - 44032: 0xB3A0,
	53293 - 44032: 0xC4FA,
	53294 - 44032: 0xB441,
	53295 - 44032: 0xB442,
	53296 - 44032: 0xB443,
	53297 - 44032: 0xB444,
	53298 - 44032: 0xB445,
	53299 - 44032: 0xB446,
	53300 - 44032: 0xC4FB,
	53301 - 44032: 0xC4FC,
	53302 - 44032: 0xB447,
	53303 - 44032: 0xB448,
	53304 - 44032: 0xC4FD,
	53305 - 44032: 0xB449,
	53306 - 44032: 0xB44A,
	53307 - 44032: 0xB44B,
	53308 - 44032: 0xC4FE,
	53309 - 44032: 0xB44C,
	53310 - 44032: 0xB44D,
	53311 - 44032: 0xB44E,
	53312 - 44032: 0xB44F,
	53313 - 44032: 0xB450,
	53314 - 44032: 0xB451,
	53315 - 44032: 0xB452,
	53316 - 44032: 0xC5A1,
	53317 - 44032: 0xC5A2,
	53318 - 44032: 0xB453,
	53319 - 44032: 0xC5A3,
	53320 - 44032: 0xB454,
	53321 - 44032: 0xC5A4,
	53322 - 44032: 0xB455,
	53323 - 44032: 0xB456,
	53324 - 44032: 0xB457,
	53325 - 44032: 0xB458,
	53326 - 44032: 0xB459,
	53327 - 44032: 0xB45A,
	53328 - 44032: 0xC5A5,
	53329 - 44032: 0xB461,
	53330 - 44032: 0xB462,
	53331 - 44032: 0xB463,
	53332 - 44032: 0xC5A6,
	53333 - 44032: 0xB464,
	53334 - 44032: 0xB465,
	53335 - 44032: 0xB466,
	53336 - 44032: 0xC5A7,
	53337 - 44032: 0xB467,
	53338 - 44032: 0xB468,
	53339 - 44032: 0xB469,
	53340 - 44032: 0xB46A,
	53341 - 44032: 0xB46B,
	53342 - 44032: 0xB46C,
	53343 - 44032: 0xB46D,
	53344 - 44032: 0xC5A8,
	53345 - 44032: 0xB46E,
	53346 - 44032: 0xB46F,
	53347 - 44032: 0xB470,
	53348 - 44032: 0xB471,
	53349 - 44032: 0xB472,
	53350 - 44032: 0xB473,
	53351 - 44032: 0xB474,
	53352 - 44032: 0xB475,
	53353 - 44032: 0xB476,
	53354 - 44032: 0xB477,
	53355 - 44032: 0xB478,
	53356 - 44032: 0xC5A9,
	53357 - 44032: 0xC5AA,
	53358 - 44032: 0xB479,
	53359 - 44032: 0xB47A,
	53360 - 44032: 0xC5AB,
	53361 - 44032: 0xB481,
	53362 - 44032: 0xB482,
	53363 - 44032: 0xB483,
	53364 - 44032: 0xC5AC,
	53365 - 44032: 0xB484,
	53366 - 44032: 0xB485,
	53367 - 44032: 0xB486,
	53368 - 44032: 0xB487,
	53369 - 44032: 0xB488,
	53370 - 44032: 0xB489,
	53371 - 44032: 0xB48A,
	53372 - 44032: 0xC5AD,
	53373 - 44032: 0xC5AE,
	53374 - 44032: 0xB48B,
	53375 - 44032: 0xB48C,
	53376 - 44032: 0xB48D,
	53377 - 44032: 0xC5AF,
	53378 - 44032: 0xB48E,
	53379 - 44032: 0xB48F,
	53380 - 44032: 0xB490,
	53381 - 44032: 0xB491,
	53382 - 44032: 0xB492,
	53383 - 44032: 0xB493,
	53384 - 44032: 0xB494,
	53385 - 44032: 0xB495,
	53386 - 44032: 0xB496,
	53387 - 44032: 0xB497,
	53388 - 44032: 0xB498,
	53389 - 44032: 0xB499,
	53390 - 44032: 0xB49A,
	53391 - 44032: 0xB49B,
	53392 - 44032: 0xB49C,
	53393 - 44032: 0xB49D,
	53394 - 44032: 0xB49E,
	53395 - 44032: 0xB49F,
	53396 - 44032: 0xB4A0,
	53397 - 44032: 0xB541,
	53398 - 44032: 0xB542,
	53399 - 44032: 0xB543,
	53400 - 44032: 0xB544,
	53401 - 44032: 0xB545,
	53402 - 44032: 0xB546,
	53403 - 44032: 0xB547,
	53404 - 44032: 0xB548,
	53405 - 44032: 0xB549,
	53406 - 44032: 0xB54A,
	53407 - 44032: 0xB54B,
	53408 - 44032: 0xB54C,
	53409 - 44032: 0xB54D,
	53410 - 44032: 0xB54E,
	53411 - 44032: 0xB54F,
	53412 - 44032: 0xC5B0,
	53413 - 44032: 0xC5B1,
	53414 - 44032: 0xB550,
	53415 - 44032: 0xB551,
	53416 - 44032: 0xC5B2,
	53417 - 44032: 0xB552,
	53418 - 44032: 0xB553,
	53419 - 44032: 0xB554,
	53420 - 44032: 0xC5B3,
	53421 - 44032: 0xB555,
	53422 - 44032: 0xB556,
	53423 - 44032: 0xB557,
	53424 - 44032: 0xB558,
	53425 - 44032: 0xB559,
	53426 - 44032: 0xB55A,
	53427 - 44032: 0xB561,
	53428 - 44032: 0xC5B4,
	53429 - 44032: 0xC5B5,
	53430 - 44032: 0xB562,
	53431 - 44032: 0xC5B6,
	53432 - 44032: 0xB563,
	53433 - 44032: 0xC5B7,
	53434 - 44032: 0xB564,
	53435 - 44032: 0xB565,
	53436 - 44032: 0xB566,
	53437 - 44032: 0xB567,
	53438 - 44032: 0xB568,
	53439 - 44032: 0xB569,
	53440 - 44032: 0xC5B8,
	53441 - 44032: 0xC5B9,
	53442 - 44032: 0xB56A,
	53443 - 44032: 0xB56B,
	53444 - 44032: 0xC5BA,
	53445 - 44032: 0xB56C,
	53446 - 44032: 0xB56D,
	53447 - 44032: 0xB56E,
	53448 - 44032: 0xC5BB,
	53449 - 44032: 0xC5BC,
	53450 - 44032: 0xB56F,
	53451 - 44032: 0xB570,
	53452 - 44032: 0xB571,
	53453 - 44032: 0xB572,
	53454 - 44032: 0xB573,
	53455 - 44032: 0xB574,
	53456 - 44032: 0xC5BD,
	53457 - 44032: 0xC5BE,
	53458 - 44032: 0xB575,
	53459 - 44032: 0xC5BF,
	53460 - 44032: 0xC5C0,
	53461 - 44032: 0xC5C1,
	53462 - 44032: 0xB576,
	53463 - 44032: 0xB577,
	53464 - 44032: 0xB578,
	53465 - 44032: 0xB579,
	53466 - 44032: 0xB57A,
	53467 - 44032: 0xB581,
	53468 - 44032: 0xC5C2,
	53469 - 44032: 0xC5C3,
	53470 - 44032: 0xB582,
	53471 - 44032: 0xB583,
	53472 - 44032: 0xC5C4,
	53473 - 44032: 0xB584,
	53474 - 44032: 0xB585,
	53475 - 44032: 0xB586,
	53476 - 44032: 0xC5C5,
	53477 - 44032: 0xB587,
	53478 - 44032: 0xB588,
	53479 - 44032: 0xB589,
	53480 - 44032: 0xB58A,
	53481 - 44032: 0xB58B,
	53482 - 44032: 0xB58C,
	53483 - 44032: 0xB58D,
	53484 - 44032: 0xC5C6,
	53485 - 44032: 0xC5C7,
	53486 - 44032: 0xB58E,
	53487 - 44032: 0xC5C8,
	53488 - 44032: 0xC5C9,
	53489 - 44032: 0xC5CA,
	53490 - 44032: 0xB58F,
	53491 - 44032: 0xB590,
	53492 - 44032: 0xB591,
	53493 - 44032: 0xB592,
	53494 - 44032: 0xB593,
	53495 - 44032: 0xB594,
	53496 - 44032: 0xC5CB,
	53497 - 44032: 0xB595,
	53498 - 44032: 0xB596,
	53499 - 44032: 0xB597,
	53500 - 44032: 0xB598,
	53501 - 44032: 0xB599,
	53502 - 44032: 0xB59A,
	53503 - 44032: 0xB59B,
	53504 - 44032: 0xB59C,
	53505 - 44032: 0xB59D,
	53506 - 44032: 0xB59E,
	53507 - 44032: 0xB59F,
	53508 - 44032: 0xB5A0,
	53509 - 44032: 0xB641,
	53510 - 44032: 0xB642,
	53511 - 44032: 0xB643,
	53512 - 44032: 0xB644,
	53513 - 44032: 0xB645,
	53514 - 44032: 0xB646,
	53515 - 44032: 0xB647,
	53516 - 44032: 0xB648,
	53517 - 44032: 0xC5CC,
	53518 - 44032: 0xB649,
	53519 - 44032: 0xB64A,
	53520 - 44032: 0xB64B,
	53521 - 44032: 0xB64C,
	53522 - 44032: 0xB64D,
	53523 - 44032: 0xB64E,
	53524 - 44032: 0xB64F,
	53525 - 44032: 0xB650,
	53526 - 44032: 0xB651,
	53527 - 44032: 0xB652,
	53528 - 44032: 0xB653,
	53529 - 44032: 0xB654,
	53530 - 44032: 0xB655,
	53531 - 44032: 0xB656,
	53532 - 44032: 0xB657,
	53533 - 44032: 0xB658,
	53534 - 44032: 0xB659,
	53535 - 44032: 0xB65A,
	53536 - 44032: 0xB661,
	53537 - 44032: 0xB662,
	53538 - 44032: 0xB663,
	53539 - 44032: 0xB664,
	53540 - 44032: 0xB665,
	53541 - 44032: 0xB666,
	53542 - 44032: 0xB667,
	53543 - 44032: 0xB668,
	53544 - 44032: 0xB669,
	53545 - 44032: 0xB66A,
	53546 - 44032: 0xB66B,
	53547 - 44032: 0xB66C,
	53548 - 44032: 0xB66D,
	53549 - 44032: 0xB66E,
	53550 - 44032: 0xB66F,
	53551 - 44032: 0xB670,
	53552 - 44032: 0xC5CD,
	53553 - 44032: 0xC5CE,
	53554 - 44032: 0xB671,
	53555 - 44032: 0xB672,
	53556 - 44032: 0xC5CF,
	53557 - 44032: 0xB673,
	53558 - 44032: 0xB674,
	53559 - 44032: 0xB675,
	53560 - 44032: 0xC5D0,
	53561 - 44032: 0xB676,
	53562 - 44032: 0xC5D1,
	53563 - 44032: 0xB677,
	53564 - 44032: 0xB678,
	53565 - 44032: 0xB679,
	53566 - 44032: 0xB67A,
	53567 - 44032: 0xB681,
	53568 - 44032: 0xC5D2,
	53569 - 44032: 0xC5D3,
	53570 - 44032: 0xB682,
	53571 - 44032: 0xC5D4,
	53572 - 44032: 0xC5D5,
	53573 - 44032: 0xC5D6,
	53574 - 44032: 0xB683,
	53575 - 44032: 0xB684,
	53576 - 44032: 0xB685,
	53577 - 44032: 0xB686,
	53578 - 44032: 0xB687,
	53579 - 44032: 0xB688,
	53580 - 44032: 0xC5D7,
	53581 - 44032: 0xC5D8,
	53582 - 44032: 0xB689,
	53583 - 44032: 0xB68A,
	53584 - 44032: 0xC5D9,
	53585 - 44032: 0xB68B,
	53586 - 44032: 0xB68C,
	53587 - 44032: 0xB68D,
	53588 - 44032: 0xC5DA,
	53589 - 44032: 0xB68E,
	53590 - 44032: 0xB68F,
	53591 - 44032: 0xB690,
	53592 - 44032: 0xB691,
	53593 - 44032: 0xB692,
	53594 - 44032: 0xB693,
	53595 - 44032: 0xB694,
	53596 - 44032: 0xC5DB,
	53597 - 44032: 0xC5DC,
	53598 - 44032: 0xB695,
	53599 - 44032: 0xC5DD,
	53600 - 44032: 0xB696,
	53601 - 44032: 0xC5DE,
	53602 - 44032: 0xB697,
	53603 - 44032: 0xB698,
	53604 - 44032: 0xB699,
	53605 - 44032: 0xB69A,
	53606 - 44032: 0xB69B,
	53607 - 44032: 0xB69C,
	53608 - 44032: 0xC5DF,
	53609 - 44032: 0xB69D,
	53610 - 44032: 0xB69E,
	53611 - 44032: 0xB69F,
	53612 - 44032: 0xC5E0,
	53613 - 44032: 0xB6A0,
	53614 - 44032: 0xB741,
	53615 - 44032: 0xB742,
	53616 - 44032: 0xB743,
	53617 - 44032: 0xB744,
	53618 - 44032: 0xB745,
	53619 - 44032: 0xB746,
	53620 - 44032: 0xB747,
	53621 - 44032: 0xB748,
	53622 - 44032: 0xB749,
	53623 - 44032: 0xB74A,
	53624 - 44032: 0xB74B,
	53625 - 44032: 0xB74C,
	53626 - 44032: 0xB74D,
	53627 - 44032: 0xB74E,
	53628 - 44032: 0xC5E1,
	53629 - 44032: 0xB74F,
	53630 - 44032: 0xB750,
	53631 - 44032: 0xB751,
	53632 - 44032: 0xB752,
	53633 - 44032: 0xB753,
	53634 - 44032: 0xB754,
	53635 - 44032: 0xB755,
	53636 - 44032: 0xC5E2,
	53637 - 44032: 0xB756,
	53638 - 44032: 0xB757,
	53639 - 44032: 0xB758,
	53640 - 44032: 0xC5E3,
	53641 - 44032: 0xB759,
	53642 - 44032: 0xB75A,
	53643 - 44032: 0xB761,
	53644 - 44032: 0xB762,
	53645 - 44032: 0xB763,
	53646 - 44032: 0xB764,
	53647 - 44032: 0xB765,
	53648 - 44032: 0xB766,
	53649 - 44032: 0xB767,
	53650 - 44032: 0xB768,
	53651 - 44032: 0xB769,
	53652 - 44032: 0xB76A,
	53653 - 44032: 0xB76B,
	53654 - 44032: 0xB76C,
	53655 - 44032: 0xB76D,
	53656 - 44032: 0xB76E,
	53657 - 44032: 0xB76F,
	53658 - 44032: 0xB770,
	53659 - 44032: 0xB771,
	53660 - 44032: 0xB772,
	53661 - 44032: 0xB773,
	53662 - 44032: 0xB774,
	53663 - 44032: 0xB775,
	53664 - 44032: 0xC5E4,
	53665 - 44032: 0xC5E5,
	53666 - 44032: 0xB776,
	53667 - 44032: 0xB777,
	53668 - 44032: 0xC5E6,
	53669 - 44032: 0xB778,
	53670 - 44032: 0xB779,
	53671 - 44032: 0xB77A,
	53672 - 44032: 0xC5E7,
	53673 - 44032: 0xB781,
	53674 - 44032: 0xB782,
	53675 - 44032: 0xB783,
	53676 - 44032: 0xB784,
	53677 - 44032: 0xB785,
	53678 - 44032: 0xB786,
	53679 - 44032: 0xB787,
	53680 - 44032: 0xC5E8,
	53681 - 44032: 0xC5E9,
	53682 - 44032: 0xB788,
	53683 - 44032: 0xC5EA,
	53684 - 44032: 0xB789,
	53685 - 44032: 0xC5EB,
	53686 - 44032: 0xB78A,
	53687 - 44032: 0xB78B,
	53688 - 44032: 0xB78C,
	53689 - 44032: 0xB78D,
	53690 - 44032: 0xC5EC,
	53691 - 44032: 0xB78E,
	53692 - 44032: 0xC5ED,
	53693 - 44032: 0xB78F,
	53694 - 44032: 0xB790,
	53695 - 44032: 0xB791,
	53696 - 44032: 0xC5EE,
	53697 - 44032: 0xB792,
	53698 - 44032: 0xB793,
	53699 - 44032: 0xB794,
	53700 - 44032: 0xB795,
	53701 - 44032: 0xB796,
	53702 - 44032: 0xB797,
	53703 - 44032: 0xB798,
	53704 - 44032: 0xB799,
	53705 - 44032: 0xB79A,
	53706 - 44032: 0xB79B,
	53707 - 44032: 0xB79C,
	53708 - 44032: 0xB79D,
	53709 - 44032: 0xB79E,
	53710 - 44032: 0xB79F,
	53711 - 44032: 0xB7A0,
	53712 - 44032: 0xB841,
	53713 - 44032: 0xB842,
	53714 - 44032: 0xB843,
	53715 - 44032: 0xB844,
	53716 - 44032: 0xB845,
	53717 - 44032: 0xB846,
	53718 - 44032: 0xB847,
	53719 - 44032: 0xB848,
	53720 - 44032: 0xC5EF,
	53721 - 44032: 0xB849,
	53722 - 44032: 0xB84A,
	53723 - 44032: 0xB84B,
	53724 - 44032: 0xB84C,
	53725 - 44032: 0xB84D,
	53726 - 44032: 0xB84E,
	53727 - 44032: 0xB84F,
	53728 - 44032: 0xB850,
	53729 - 44032: 0xB851,
	53730 - 44032: 0xB852,
	53731 - 44032: 0xB853,
	53732 - 44032: 0xB854,
	53733 - 44032: 0xB855,
	53734 - 44032: 0xB856,
	53735 - 44032: 0xB857,
	53736 - 44032: 0xB858,
	53737 - 44032: 0xB859,
	53738 - 44032: 0xB85A,
	53739 - 44032: 0xB861,
	53740 - 44032: 0xB862,
	53741 - 44032: 0xB863,
	53742 - 44032: 0xB864,
	53743 - 44032: 0xB865,
	53744 - 44032: 0xB866,
	53745 - 44032: 0xB867,
	53746 - 44032: 0xB868,
	53747 - 44032: 0xB869,
	53748 - 44032: 0xC5F0,
	53749 - 44032: 0xB86A,
	53750 - 44032: 0xB86B,
	53751 - 44032: 0xB86C,
	53752 - 44032: 0xC5F1,
	53753 - 44032: 0xB86D,
	53754 - 44032: 0xB86E,
	53755 - 44032: 0xB86F,
	53756 - 44032: 0xB870,
	53757 - 44032: 0xB871,
	53758 - 44032: 0xB872,
	53759 - 44032: 0xB873,
	53760 - 44032: 0xB874,
	53761 - 44032: 0xB875,
	53762 - 44032: 0xB876,
	53763 - 44032: 0xB877,
	53764 - 44032: 0xB878,
	53765 - 44032: 0xB879,
	53766 - 44032: 0xB87A,
	53767 - 44032: 0xC5F2,
	53768 - 44032: 0xB881,
	53769 - 44032: 0xC5F3,
	53770 - 44032: 0xB882,
	53771 - 44032: 0xB883,
	53772 - 44032: 0xB884,
	53773 - 44032: 0xB885,
	53774 - 44032: 0xB886,
	53775 - 44032: 0xB887,
	53776 - 44032: 0xC5F4,
	53777 - 44032: 0xB888,
	53778 - 44032: 0xB889,
	53779 - 44032: 0xB88A,
	53780 - 44032: 0xB88B,
	53781 - 44032: 0xB88C,
	53782 - 44032: 0xB88D,
	53783 - 44032: 0xB88E,
	53784 - 44032: 0xB88F,
	53785 - 44032: 0xB890,
	53786 - 44032: 0xB891,
	53787 - 44032: 0xB892,
	53788 - 44032: 0xB893,
	53789 - 44032: 0xB894,
	53790 - 44032: 0xB895,
	53791 - 44032: 0xB896,
	53792 - 44032: 0xB897,
	53793 - 44032: 0xB898,
	53794 - 44032: 0xB899,
	53795 - 44032: 0xB89A,
	53796 - 44032: 0xB89B,
	53797 - 44032: 0xB89C,
	53798 - 44032: 0xB89D,
	53799 - 44032: 0xB89E,
	53800 - 44032: 0xB89F,
	53801 - 44032: 0xB8A0,
	53802 - 44032: 0xB941,
	53803 - 44032: 0xB942,
	53804 - 44032: 0xC5F5,
	53805 - 44032: 0xC5F6,
	53806 - 44032: 0xB943,
	53807 - 44032: 0xB944,
	53808 - 44032: 0xC5F7,
	53809 - 44032: 0xB945,
	53810 - 44032: 0xB946,
	53811 - 44032: 0xB947,
	53812 - 44032: 0xC5F8,
	53813 - 44032: 0xB948,
	53814 - 44032: 0xB949,
	53815 - 44032: 0xB94A,
	53816 - 44032: 0xB94B,
	53817 - 44032: 0xB94C,
	53818 - 44032: 0xB94D,
	53819 - 44032: 0xB94E,
	53820 - 44032: 0xC5F9,
	53821 - 44032: 0xC5FA,
	53822 - 44032: 0xB94F,
	53823 - 44032: 0xC5FB,
	53824 - 44032: 0xB950,
	53825 - 44032: 0xC5FC,
	53826 - 44032: 0xB951,
	53827 - 44032: 0xB952,
	53828 - 44032: 0xB953,
	53829 - 44032: 0xB954,
	53830 - 44032: 0xB955,
	53831 - 44032: 0xB956,
	53832 - 44032: 0xC5FD,
	53833 - 44032: 0xB957,
	53834 - 44032: 0xB958,
	53835 - 44032: 0xB959,
	53836 - 44032: 0xB95A,
	53837 - 44032: 0xB961,
	53838 - 44032: 0xB962,
	53839 - 44032: 0xB963,
	53840 - 44032: 0xB964,
	53841 - 44032: 0xB965,
	53842 - 44032: 0xB966,
	53843 - 44032: 0xB967,
	53844 - 44032: 0xB968,
	53845 - 44032: 0xB969,
	53846 - 44032: 0xB96A,
	53847 - 44032: 0xB96B,
	53848 - 44032: 0xB96C,
	53849 - 44032: 0xB96D,
	53850 - 44032: 0xB96E,
	53851 - 44032: 0xB96F,
	53852 - 44032: 0xC5FE,
	53853 - 44032: 0xB970,
	53854 - 44032: 0xB971,
	53855 - 44032: 0xB972,
	53856 - 44032: 0xB973,
	53857 - 44032: 0xB974,
	53858 - 44032: 0xB975,
	53859 - 44032: 0xB976,
	53860 - 44032: 0xC6A1,
	53861 - 44032: 0xB977,
	53862 - 44032: 0xB978,
	53863 - 44032: 0xB979,
	53864 - 44032: 0xB97A,
	53865 - 44032: 0xB981,
	53866 - 44032: 0xB982,
	53867 - 44032: 0xB983,
	53868 - 44032: 0xB984,
	53869 - 44032: 0xB985,
	53870 - 44032: 0xB986,
	53871 - 44032: 0xB987,
	53872 - 44032: 0xB988,
	53873 - 44032: 0xB989,
	53874 - 44032: 0xB98A,
	53875 - 44032: 0xB98B,
	53876 - 44032: 0xB98C,
	53877 - 44032: 0xB98D,
	53878 - 44032: 0xB98E,
	53879 - 44032: 0xB98F,
	53880 - 44032: 0xB990,
	53881 - 44032: 0xB991,
	53882 - 44032: 0xB992,
	53883 - 44032: 0xB993,
	53884 - 44032: 0xB994,
	53885 - 44032: 0xB995,
	53886 - 44032: 0xB996,
	53887 - 44032: 0xB997,
	53888 - 44032: 0xC6A2,
	53889 - 44032: 0xC6A3,
	53890 - 44032: 0xB998,
	53891 - 44032: 0xB999,
	53892 - 44032: 0xC6A4,
	53893 - 44032: 0xB99A,
	53894 - 44032: 0xB99B,
	53895 - 44032: 0xB99C,
	53896 - 44032: 0xC6A5,
	53897 - 44032: 0xB99D,
	53898 - 44032: 0xB99E,
	53899 - 44032: 0xB99F,
	53900 - 44032: 0xB9A0,
	53901 - 44032: 0xBA41,
	53902 - 44032: 0xBA42,
	53903 - 44032: 0xBA43,
	53904 - 44032: 0xC6A6,
	53905 - 44032: 0xC6A7,
	53906 - 44032: 0xBA44,
	53907 - 44032: 0xBA45,
	53908 - 44032: 0xBA46,
	53909 - 44032: 0xC6A8,
	53910 - 44032: 0xBA47,
	53911 - 44032: 0xBA48,
	53912 - 44032: 0xBA49,
	53913 - 44032: 0xBA4A,
	53914 - 44032: 0xBA4B,
	53915 - 44032: 0xBA4C,
	53916 - 44032: 0xC6A9,
	53917 - 44032: 0xBA4D,
	53918 - 44032: 0xBA4E,
	53919 - 44032: 0xBA4F,
	53920 - 44032: 0xC6AA,
	53921 - 44032: 0xBA50,
	53922 - 44032: 0xBA51,
	53923 - 44032: 0xBA52,
	53924 - 44032: 0xC6AB,
	53925 - 44032: 0xBA53,
	53926 - 44032: 0xBA54,
	53927 - 44032: 0xBA55,
	53928 - 44032: 0xBA56,
	53929 - 44032: 0xBA57,
	53930 - 44032: 0xBA58,
	53931 - 44032: 0xBA59,
	53932 - 44032: 0xC6AC,
	53933 - 44032: 0xBA5A,
	53934 - 44032: 0xBA61,
	53935 - 44032: 0xBA62,
	53936 - 44032: 0xBA63,
	53937 - 44032: 0xC6AD,
	53938 - 44032: 0xBA64,
	53939 - 44032: 0xBA65,
	53940 - 44032: 0xBA66,
	53941 - 44032: 0xBA67,
	53942 - 44032: 0xBA68,
	53943 - 44032: 0xBA69,
	53944 - 44032: 0xC6AE,
	53945 - 44032: 0xC6AF,
	53946 - 44032: 0xBA6A,
	53947 - 44032: 0xBA6B,
	53948 - 44032: 0xC6B0,
	53949 - 44032: 0xBA6C,
	53950 - 44032: 0xBA6D,
	53951 - 44032: 0xC6B1,
	53952 - 44032: 0xC6B2,
	53953 - 44032: 0xBA6E,
	53954 - 44032: 0xC6B3,
	53955 - 44032: 0xBA6F,
	53956 - 44032: 0xBA70,
	53957 - 44032: 0xBA71,
	53958 - 44032: 0xBA72,
	53959 - 44032: 0xBA73,
	53960 - 44032: 0xC6B4,
	53961 - 44032: 0xC6B5,
	53962 - 44032: 0xBA74,
	53963 - 44032: 0xC6B6,
	53964 - 44032: 0xBA75,
	53965 - 44032: 0xBA76,
	53966 - 44032: 0xBA77,
	53967 - 44032: 0xBA78,
	53968 - 44032: 0xBA79,
	53969 - 44032: 0xBA7A,
	53970 - 44032: 0xBA81,
	53971 - 44032: 0xBA82,
	53972 - 44032: 0xC6B7,
	53973 - 44032: 0xBA83,
	53974 - 44032: 0xBA84,
	53975 - 44032: 0xBA85,
	53976 - 44032: 0xC6B8,
	53977 - 44032: 0xBA86,
	53978 - 44032: 0xBA87,
	53979 - 44032: 0xBA88,
	53980 - 44032: 0xC6B9,
	53981 - 44032: 0xBA89,
	53982 - 44032: 0xBA8A,
	53983 - 44032: 0xBA8B,
	53984 - 44032: 0xBA8C,
	53985 - 44032: 0xBA8D,
	53986 - 44032: 0xBA8E,
	53987 - 44032: 0xBA8F,
	53988 - 44032: 0xC6BA,
	53989 - 44032: 0xC6BB,
	53990 - 44032: 0xBA90,
	53991 - 44032: 0xBA91,
	53992 - 44032: 0xBA92,
	53993 - 44032: 0xBA93,
	53994 - 44032: 0xBA94,
	53995 - 44032: 0xBA95,
	53996 - 44032: 0xBA96,
	53997 - 44032: 0xBA97,
	53998 - 44032: 0xBA98,
	53999 - 44032: 0xBA99,
	54000 - 44032: 0xC6BC,
	54001 - 44032: 0xC6BD,
	54002 - 44032: 0xBA9A,
	54003 - 44032: 0xBA9B,
	54004 - 44032: 0xC6BE,
	54005 - 44032: 0xBA9C,
	54006 - 44032: 0xBA9D,
	54007 - 44032: 0xBA9E,
	54008 - 44032: 0xC6BF,
	54009 - 44032: 0xBA9F,
	54010 - 44032: 0xBAA0,
	54011 - 44032: 0xBB41,
	54012 - 44032: 0xBB42,
	54013 - 44032: 0xBB43,
	54014 - 44032: 0xBB44,
	54015 - 44032: 0xBB45,
	54016 - 44032: 0xC6C0,
	54017 - 44032: 0xC6C1,
	54018 - 44032: 0xBB46,
	54019 - 44032: 0xC6C2,
	54020 - 44032: 0xBB47,
	54021 - 44032: 0xC6C3,
	54022 - 44032: 0xBB48,
	54023 - 44032: 0xBB49,
	54024 - 44032: 0xBB4A,
	54025 - 44032: 0xBB4B,
	54026 - 44032: 0xBB4C,
	54027 - 44032: 0xBB4D,
	54028 - 44032: 0xC6C4,
	54029 - 44032: 0xC6C5,
	54030 - 44032: 0xC6C6,
	54031 - 44032: 0xBB4E,
	54032 - 44032: 0xC6C7,
	54033 - 44032: 0xBB4F,
	54034 - 44032: 0xBB50,
	54035 - 44032: 0xBB51,
	54036 - 44032: 0xC6C8,
	54037 - 44032: 0xBB52,
	54038 - 44032: 0xC6C9,
	54039 - 44032: 0xBB53,
	54040 - 44032: 0xBB54,
	54041 - 44032: 0xBB55,
	54042 - 44032: 0xBB56,
	54043 - 44032: 0xBB57,
	54044 - 44032: 0xC6CA,
	54045 - 44032: 0xC6CB,
	54046 - 44032: 0xBB58,
	54047 - 44032: 0xC6CC,
	54048 - 44032: 0xC6CD,
	54049 - 44032: 0xC6CE,
	54050 - 44032: 0xBB59,
	54051 - 44032: 0xBB5A,
	54052 - 44032: 0xBB61,
	54053 - 44032: 0xC6CF,
	54054 - 44032: 0xBB62,
	54055 - 44032: 0xBB63,
	54056 - 44032: 0xC6D0,
	54057 - 44032: 0xC6D1,
	54058 - 44032: 0xBB64,
	54059 - 44032: 0xBB65,
	54060 - 44032: 0xC6D2,
	54061 - 44032: 0xBB66,
	54062 - 44032: 0xBB67,
	54063 - 44032: 0xBB68,
	54064 - 44032: 0xC6D3,
	54065 - 44032: 0xBB69,
	54066 - 44032: 0xBB6A,
	54067 - 44032: 0xBB6B,
	54068 - 44032: 0xBB6C,
	54069 - 44032: 0xBB6D,
	54070 - 44032: 0xBB6E,
	54071 - 44032: 0xBB6F,
	54072 - 44032: 0xC6D4,
	54073 - 44032: 0xC6D5,
	54074 - 44032: 0xBB70,
	54075 - 44032: 0xC6D6,
	54076 - 44032: 0xC6D7,
	54077 - 44032: 0xC6D8,
	54078 - 44032: 0xBB71,
	54079 - 44032: 0xBB72,
	54080 - 44032: 0xBB73,
	54081 - 44032: 0xBB74,
	54082 - 44032: 0xBB75,
	54083 - 44032: 0xBB76,
	54084 - 44032: 0xC6D9,
	54085 - 44032: 0xC6DA,
	54086 - 44032: 0xBB77,
	54087 - 44032: 0xBB78,
	54088 - 44032: 0xBB79,
	54089 - 44032: 0xBB7A,
	54090 - 44032: 0xBB81,
	54091 - 44032: 0xBB82,
	54092 - 44032: 0xBB83,
	54093 - 44032: 0xBB84,
	54094 - 44032: 0xBB85,
	54095 - 44032: 0xBB86,
	54096 - 44032: 0xBB87,
	54097 - 44032: 0xBB88,
	54098 - 44032: 0xBB89,
	54099 - 44032: 0xBB8A,
	54100 - 44032: 0xBB8B,
	54101 - 44032: 0xBB8C,
	54102 - 44032: 0xBB8D,
	54103 - 44032: 0xBB8E,
	54104 - 44032: 0xBB8F,
	54105 - 44032: 0xBB90,
	54106 - 44032: 0xBB91,
	54107 - 44032: 0xBB92,
	54108 - 44032: 0xBB93,
	54109 - 44032: 0xBB94,
	54110 - 44032: 0xBB95,
	54111 - 44032: 0xBB96,
	54112 - 44032: 0xBB97,
	54113 - 44032: 0xBB98,
	54114 - 44032: 0xBB99,
	54115 - 44032: 0xBB9A,
	54116 - 44032: 0xBB9B,
	54117 - 44032: 0xBB9C,
	54118 - 44032: 0xBB9D,
	54119 - 44032: 0xBB9E,
	54120 - 44032: 0xBB9F,
	54121 - 44032: 0xBBA0,
	54122 - 44032: 0xBC41,
	54123 - 44032: 0xBC42,
	54124 - 44032: 0xBC43,
	54125 - 44032: 0xBC44,
	54126 - 44032: 0xBC45,
	54127 - 44032: 0xBC46,
	54128 - 44032: 0xBC47,
	54129 - 44032: 0xBC48,
	54130 - 44032: 0xBC49,
	54131 - 44032: 0xBC4A,
	54132 - 44032: 0xBC4B,
	54133 - 44032: 0xBC4C,
	54134 - 44032: 0xBC4D,
	54135 - 44032: 0xBC4E,
	54136 - 44032: 0xBC4F,
	54137 - 44032: 0xBC50,
	54138 - 44032: 0xBC51,
	54139 - 44032: 0xBC52,
	54140 - 44032: 0xC6DB,
	54141 - 44032: 0xC6DC,
	54142 - 44032: 0xBC53,
	54143 - 44032: 0xBC54,
	54144 - 44032: 0xC6DD,
	54145 - 44032: 0xBC55,
	54146 - 44032: 0xBC56,
	54147 - 44032: 0xBC57,
	54148 - 44032: 0xC6DE,
	54149 - 44032: 0xBC58,
	54150 - 44032: 0xBC59,
	54151 - 44032: 0xBC5A,
	54152 - 44032: 0xBC61,
	54153 - 44032: 0xBC62,
	54154 - 44032: 0xBC63,
	54155 - 44032: 0xBC64,
	54156 - 44032: 0xC6DF,
	54157 - 44032: 0xC6E0,
	54158 - 44032: 0xBC65,
	54159 - 44032: 0xC6E1,
	54160 - 44032: 0xC6E2,
	54161 - 44032: 0xC6E3,
	54162 - 44032: 0xBC66,
	54163 - 44032: 0xBC67,
	54164 - 44032: 0xBC68,
	54165 - 44032: 0xBC69,
	54166 - 44032: 0xBC6A,
	54167 - 44032: 0xBC6B,
	54168 - 44032: 0xC6E4,
	54169 - 44032: 0xC6E5,
	54170 - 44032: 0xBC6C,
	54171 - 44032: 0xBC6D,
	54172 - 44032: 0xC6E6,
	54173 - 44032: 0xBC6E,
	54174 - 44032: 0xBC6F,
	54175 - 44032: 0xBC70,
	54176 - 44032: 0xC6E7,
	54177 - 44032: 0xBC71,
	54178 - 44032: 0xBC72,
	54179 - 44032: 0xBC73,
	54180 - 44032: 0xBC74,
	54181 - 44032: 0xBC75,
	54182 - 44032: 0xBC76,
	54183 - 44032: 0xBC77,
	54184 - 44032: 0xC6E8,
	54185 - 44032: 0xC6E9,
	54186 - 44032: 0xBC78,
	54187 - 44032: 0xC6EA,
	54188 - 44032: 0xBC79,
	54189 - 44032: 0xC6EB,
	54190 - 44032: 0xBC7A,
	54191 - 44032: 0xBC81,
	54192 - 44032: 0xBC82,
	54193 - 44032: 0xBC83,
	54194 - 44032: 0xBC84,
	54195 - 44032: 0xBC85,
	54196 - 44032: 0xC6EC,
	54197 - 44032: 0xBC86,
	54198 - 44032: 0xBC87,
	54199 - 44032: 0xBC88,
	54200 - 44032: 0xC6ED,
	54201 - 44032: 0xBC89,
	54202 - 44032: 0xBC8A,
	54203 - 44032: 0xBC8B,
	54204 - 44032: 0xC6EE,
	54205 - 44032: 0xBC8C,
	54206 - 44032: 0xBC8D,
	54207 - 44032: 0xBC8E,
	54208 - 44032: 0xBC8F,
	54209 - 44032: 0xBC90,
	54210 - 44032: 0xBC91,
	54211 - 44032: 0xBC92,
	54212 - 44032: 0xC6EF,
	54213 - 44032: 0xC6F0,
	54214 - 44032: 0xBC93,
	54215 - 44032: 0xBC94,
	54216 - 44032: 0xC6F1,
	54217 - 44032: 0xC6F2,
	54218 - 44032: 0xBC95,
	54219 - 44032: 0xBC96,
	54220 - 44032: 0xBC97,
	54221 - 44032: 0xBC98,
	54222 - 44032: 0xBC99,
	54223 - 44032: 0xBC9A,
	54224 - 44032: 0xC6F3,
	54225 - 44032: 0xBC9B,
	54226 - 44032: 0xBC9C,
	54227 - 44032: 0xBC9D,
	54228 - 44032: 0xBC9E,
	54229 - 44032: 0xBC9F,
	54230 - 44032: 0xBCA0,
	54231 - 44032: 0xBD41,
	54232 - 44032: 0xC6F4,
	54233 - 44032: 0xBD42,
	54234 - 44032: 0xBD43,
	54235 - 44032: 0xBD44,
	54236 - 44032: 0xBD45,
	54237 - 44032: 0xBD46,
	54238 - 44032: 0xBD47,
	54239 - 44032: 0xBD48,
	54240 - 44032: 0xBD49,
	54241 - 44032: 0xC6F5,
	54242 - 44032: 0xBD4A,
	54243 - 44032: 0xC6F6,
	54244 - 44032: 0xBD4B,
	54245 - 44032: 0xBD4C,
	54246 - 44032: 0xBD4D,
	54247 - 44032: 0xBD4E,
	54248 - 44032: 0xBD4F,
	54249 - 44032: 0xBD50,
	54250 - 44032: 0xBD51,
	54251 - 44032: 0xBD52,
	54252 - 44032: 0xC6F7,
	54253 - 44032: 0xC6F8,
	54254 - 44032: 0xBD53,
	54255 - 44032: 0xBD54,
	54256 - 44032: 0xC6F9,
	54257 - 44032: 0xBD55,
	54258 - 44032: 0xBD56,
	54259 - 44032: 0xBD57,
	54260 - 44032: 0xC6FA,
	54261 - 44032: 0xBD58,
	54262 - 44032: 0xBD59,
	54263 - 44032: 0xBD5A,
	54264 - 44032: 0xBD61,
	54265 - 44032: 0xBD62,
	54266 - 44032: 0xBD63,
	54267 - 44032: 0xBD64,
	54268 - 44032: 0xC6FB,
	54269 - 44032: 0xC6FC,
	54270 - 44032: 0xBD65,
	54271 - 44032: 0xC6FD,
	54272 - 44032: 0xBD66,
	54273 - 44032: 0xC6FE,
	54274 - 44032: 0xBD67,
	54275 - 44032: 0xBD68,
	54276 - 44032: 0xBD69,
	54277 - 44032: 0xBD6A,
	54278 - 44032: 0xBD6B,
	54279 - 44032: 0xBD6C,
	54280 - 44032: 0xC7A1,
	54281 - 44032: 0xBD6D,
	54282 - 44032: 0xBD6E,
	54283 - 44032: 0xBD6F,
	54284 - 44032: 0xBD70,
	54285 - 44032: 0xBD71,
	54286 - 44032: 0xBD72,
	54287 - 44032: 0xBD73,
	54288 - 44032: 0xBD74,
	54289 - 44032: 0xBD75,
	54290 - 44032: 0xBD76,
	54291 - 44032: 0xBD77,
	54292 - 44032: 0xBD78,
	54293 - 44032: 0xBD79,
	54294 - 44032: 0xBD7A,
	54295 - 44032: 0xBD81,
	54296 - 44032: 0xBD82,
	54297 - 44032: 0xBD83,
	54298 - 44032: 0xBD84,
	54299 - 44032: 0xBD85,
	54300 - 44032: 0xBD86,
	54301 - 44032: 0xC7A2,
	54302 - 44032: 0xBD87,
	54303 - 44032: 0xBD88,
	54304 - 44032: 0xBD89,
	54305 - 44032: 0xBD8A,
	54306 - 44032: 0xBD8B,
	54307 - 44032: 0xBD8C,
	54308 - 44032: 0xBD8D,
	54309 - 44032: 0xBD8E,
	54310 - 44032: 0xBD8F,
	54311 - 44032: 0xBD90,
	54312 - 44032: 0xBD91,
	54313 - 44032: 0xBD92,
	54314 - 44032: 0xBD93,
	54315 - 44032: 0xBD94,
	54316 - 44032: 0xBD95,
	54317 - 44032: 0xBD96,
	54318 - 44032: 0xBD97,
	54319 - 44032: 0xBD98,
	54320 - 44032: 0xBD99,
	54321 - 44032: 0xBD9A,
	54322 - 44032: 0xBD9B,
	54323 - 44032: 0xBD9C,
	54324 - 44032: 0xBD9D,
	54325 - 44032: 0xBD9E,
	54326 - 44032: 0xBD9F,
	54327 - 44032: 0xBDA0,
	54328 - 44032: 0xBE41,
	54329 - 44032: 0xBE42,
	54330 - 44032: 0xBE43,
	54331 - 44032: 0xBE44,
	54332 - 44032: 0xBE45,
	54333 - 44032: 0xBE46,
	54334 - 44032: 0xBE47,
	54335 - 44032: 0xBE48,
	54336 - 44032: 0xC7A3,
	54337 - 44032: 0xBE49,
	54338 - 44032: 0xBE4A,
	54339 - 44032: 0xBE4B,
	54340 - 44032: 0xC7A4,
	54341 - 44032: 0xBE4C,
	54342 - 44032: 0xBE4D,
	54343 - 44032: 0xBE4E,
	54344 - 44032: 0xBE4F,
	54345 - 44032: 0xBE50,
	54346 - 44032: 0xBE51,
	54347 - 44032: 0xBE52,
	54348 - 44032: 0xBE53,
	54349 - 44032: 0xBE54,
	54350 - 44032: 0xBE55,
	54351 - 44032: 0xBE56,
	54352 - 44032: 0xBE57,
	54353 - 44032: 0xBE58,
	54354 - 44032: 0xBE59,
	54355 - 44032: 0xBE5A,
	54356 - 44032: 0xBE61,
	54357 - 44032: 0xBE62,
	54358 - 44032: 0xBE63,
	54359 - 44032: 0xBE64,
	54360 - 44032: 0xBE65,
	54361 - 44032: 0xBE66,
	54362 - 44032: 0xBE67,
	54363 - 44032: 0xBE68,
	54364 - 44032: 0xC7A5,
	54365 - 44032: 0xBE69,
	54366 - 44032: 0xBE6A,
	54367 - 44032: 0xBE6B,
	54368 - 44032: 0xC7A6,
	54369 - 44032: 0xBE6C,
	54370 - 44032: 0xBE6D,
	54371 - 44032: 0xBE6E,
	54372 - 44032: 0xC7A7,
	54373 - 44032: 0xBE6F,
	54374 - 44032: 0xBE70,
	54375 - 44032: 0xBE71,
	54376 - 44032: 0xBE72,
	54377 - 44032: 0xBE73,
	54378 - 44032: 0xBE74,
	54379 - 44032: 0xBE75,
	54380 - 44032: 0xBE76,
	54381 - 44032: 0xC7A8,
	54382 - 44032: 0xBE77,
	54383 - 44032: 0xC7A9,
	54384 - 44032: 0xBE78,
	54385 - 44032: 0xBE79,
	54386 - 44032: 0xBE7A,
	54387 - 44032: 0xBE81,
	54388 - 44032: 0xBE82,
	54389 - 44032: 0xBE83,
	54390 - 44032: 0xBE84,
	54391 - 44032: 0xBE85,
	54392 - 44032: 0xC7AA,
	54393 - 44032: 0xC7AB,
	54394 - 44032: 0xBE86,
	54395 - 44032: 0xBE87,
	54396 - 44032: 0xC7AC,
	54397 - 44032: 0xBE88,
	54398 - 44032: 0xBE89,
	54399 - 44032: 0xC7AD,
	54400 - 44032: 0xC7AE,
	54401 - 44032: 0xBE8A,
	54402 - 44032: 0xC7AF,
	54403 - 44032: 0xBE8B,
	54404 - 44032: 0xBE8C,
	54405 - 44032: 0xBE8D,
	54406 - 44032: 0xBE8E,
	54407 - 44032: 0xBE8F,
	54408 - 44032: 0xC7B0,
	54409 - 44032: 0xC7B1,
	54410 - 44032: 0xBE90,
	54411 - 44032: 0xC7B2,
	54412 - 44032: 0xBE91,
	54413 - 44032: 0xC7B3,
	54414 - 44032: 0xBE92,
	54415 - 44032: 0xBE93,
	54416 - 44032: 0xBE94,
	54417 - 44032: 0xBE95,
	54418 - 44032: 0xBE96,
	54419 - 44032: 0xBE97,
	54420 - 44032: 0xC7B4,
	54421 - 44032: 0xBE98,
	54422 - 44032: 0xBE99,
	54423 - 44032: 0xBE9A,
	54424 - 44032: 0xBE9B,
	54425 - 44032: 0xBE9C,
	54426 - 44032: 0xBE9D,
	54427 - 44032: 0xBE9E,
	54428 - 44032: 0xBE9F,
	54429 - 44032: 0xBEA0,
	54430 - 44032: 0xBF41,
	54431 - 44032: 0xBF42,
	54432 - 44032: 0xBF43,
	54433 - 44032: 0xBF44,
	54434 - 44032: 0xBF45,
	54435 - 44032: 0xBF46,
	54436 - 44032: 0xBF47,
	54437 - 44032: 0xBF48,
	54438 - 44032: 0xBF49,
	54439 - 44032: 0xBF4A,
	54440 - 44032: 0xBF4B,
	54441 - 44032: 0xC7B5,
	54442 - 44032: 0xBF4C,
	54443 - 44032: 0xBF4D,
	54444 - 44032: 0xBF4E,
	54445 - 44032: 0xBF4F,
	54446 - 44032: 0xBF50,
	54447 - 44032: 0xBF51,
	54448 - 44032: 0xBF52,
	54449 - 44032: 0xBF53,
	54450 - 44032: 0xBF54,
	54451 - 44032: 0xBF55,
	54452 - 44032: 0xBF56,
	54453 - 44032: 0xBF57,
	54454 - 44032: 0xBF58,
	54455 - 44032: 0xBF59,
	54456 - 44032: 0xBF5A,
	54457 - 44032: 0xBF61,
	54458 - 44032: 0xBF62,
	54459 - 44032: 0xBF63,
	54460 - 44032: 0xBF64,
	54461 - 44032: 0xBF65,
	54462 - 44032: 0xBF66,
	54463 - 44032: 0xBF67,
	54464 - 44032: 0xBF68,
	54465 - 44032: 0xBF69,
	54466 - 44032: 0xBF6A,
	54467 - 44032: 0xBF6B,
	54468 - 44032: 0xBF6C,
	54469 - 44032: 0xBF6D,
	54470 - 44032: 0xBF6E,
	54471 - 44032: 0xBF6F,
	54472 - 44032: 0xBF70,
	54473 - 44032: 0xBF71,
	54474 - 44032: 0xBF72,
	54475 - 44032: 0xBF73,
	54476 - 44032: 0xC7B6,
	54477 - 44032: 0xBF74,
	54478 - 44032: 0xBF75,
	54479 - 44032: 0xBF76,
	54480 - 44032: 0xC7B7,
	54481 - 44032: 0xBF77,
	54482 - 44032: 0xBF78,
	54483 - 44032: 0xBF79,
	54484 - 44032: 0xC7B8,
	54485 - 44032: 0xBF7A,
	54486 - 44032: 0xBF81,
	54487 - 44032: 0xBF82,
	54488 - 44032: 0xBF83,
	54489 - 44032: 0xBF84,
	54490 - 44032: 0xBF85,
	54491 - 44032: 0xBF86,
	54492 - 44032: 0xC7B9,
	54493 - 44032: 0xBF87,
	54494 - 44032: 0xBF88,
	54495 - 44032: 0xC7BA,
	54496 - 44032: 0xBF89,
	54497 - 44032: 0xBF8A,
	54498 - 44032: 0xBF8B,
	54499 - 44032: 0xBF8C,
	54500 - 44032: 0xBF8D,
	54501 - 44032: 0xBF8E,
	54502 - 44032: 0xBF8F,
	54503 - 44032: 0xBF90,
	54504 - 44032: 0xC7BB,
	54505 - 44032: 0xBF91,
	54506 - 44032: 0xBF92,
	54507 - 44032: 0xBF93,
	54508 - 44032: 0xC7BC,
	54509 - 44032: 0xBF94,
	54510 - 44032: 0xBF95,
	54511 - 44032: 0xBF96,
	54512 - 44032: 0xC7BD,
	54513 - 44032: 0xBF97,
	54514 - 44032: 0xBF98,
	54515 - 44032: 0xBF99,
	54516 - 44032: 0xBF9A,
	54517 - 44032: 0xBF9B,
	54518 - 44032: 0xBF9C,
	54519 - 44032: 0xBF9D,
	54520 - 44032: 0xC7BE,
	54521 - 44032: 0xBF9E,
	54522 - 44032: 0xBF9F,
	54523 - 44032: 0xC7BF,
	54524 - 44032: 0xBFA0,
	54525 - 44032: 0xC7C0,
	54526 - 44032: 0xC041,
	54527 - 44032: 0xC042,
	54528 - 44032: 0xC043,
	54529 - 44032: 0xC044,
	54530 - 44032: 0xC045,
	54531 - 44032: 0xC046,
	54532 - 44032: 0xC7C1,
	54533 - 44032: 0xC047,
	54534 - 44032: 0xC048,
	54535 - 44032: 0xC049,
	54536 - 44032: 0xC7C2,
	54537 - 44032: 0xC04A,
	54538 - 44032: 0xC04B,
	54539 - 44032: 0xC04C,
	54540 - 44032: 0xC7C3,
	54541 - 44032: 0xC04D,
	54542 - 44032: 0xC04E,
	54543 - 44032: 0xC04F,
	54544 - 44032: 0xC050,
	54545 - 44032: 0xC051,
	54546 - 44032: 0xC052,
	54547 - 44032: 0xC053,
	54548 - 44032: 0xC7C4,
	54549 - 44032: 0xC7C5,
	54550 - 44032: 0xC054,
	54551 - 44032: 0xC7C6,
	54552 - 44032: 0xC055,
	54553 - 44032: 0xC056,
	54554 - 44032: 0xC057,
	54555 - 44032: 0xC058,
	54556 - 44032: 0xC059,
	54557 - 44032: 0xC05A,
	54558 - 44032: 0xC061,
	54559 - 44032: 0xC062,
	54560 - 44032: 0xC063,
	54561 - 44032: 0xC064,
	54562 - 44032: 0xC065,
	54563 - 44032: 0xC066,
	54564 - 44032: 0xC067,
	54565 - 44032: 0xC068,
	54566 - 44032: 0xC069,
	54567 - 44032: 0xC06A,
	54568 - 44032: 0xC06B,
	54569 - 44032: 0xC06C,
	54570 - 44032: 0xC06D,
	54571 - 44032: 0xC06E,
	54572 - 44032: 0xC06F,
	54573 - 44032: 0xC070,
	54574 - 44032: 0xC071,
	54575 - 44032: 0xC072,
	54576 - 44032: 0xC073,
	54577 - 44032: 0xC074,
	54578 - 44032: 0xC075,
	54579 - 44032: 0xC076,
	54580 - 44032: 0xC077,
	54581 - 44032: 0xC078,
	54582 - 44032: 0xC079,
	54583 - 44032: 0xC07A,
	54584 - 44032: 0xC081,
	54585 - 44032: 0xC082,
	54586 - 44032: 0xC083,
	54587 - 44032: 0xC084,
	54588 - 44032: 0xC7C7,
	54589 - 44032: 0xC7C8,
	54590 - 44032: 0xC085,
	54591 - 44032: 0xC086,
	54592 - 44032: 0xC7C9,
	54593 - 44032: 0xC087,
	54594 - 44032: 0xC088,
	54595 - 44032: 0xC089,
	54596 - 44032: 0xC7CA,
	54597 - 44032: 0xC08A,
	54598 - 44032: 0xC08B,
	54599 - 44032: 0xC08C,
	54600 - 44032: 0xC08D,
	54601 - 44032: 0xC08E,
	54602 - 44032: 0xC08F,
	54603 - 44032: 0xC090,
	54604 - 44032: 0xC7CB,
	54605 - 44032: 0xC7CC,
	54606 - 44032: 0xC091,
	54607 - 44032: 0xC7CD,
	54608 - 44032: 0xC092,
	54609 - 44032: 0xC7CE,
	54610 - 44032: 0xC093,
	54611 - 44032: 0xC094,
	54612 - 44032: 0xC095,
	54613 - 44032: 0xC096,
	54614 - 44032: 0xC097,
	54615 - 44032: 0xC098,
	54616 - 44032: 0xC7CF,
	54617 - 44032: 0xC7D0,
	54618 - 44032: 0xC099,
	54619 - 44032: 0xC09A,
	54620 - 44032: 0xC7D1,
	54621 - 44032: 0xC09B,
	54622 - 44032: 0xC09C,
	54623 - 44032: 0xC09D,
	54624 - 44032: 0xC7D2,
	54625 - 44032: 0xC09E,
	54626 - 44032: 0xC09F,
	54627 - 44032: 0xC0A0,
	54628 - 44032: 0xC141,
	54629 - 44032: 0xC7D3,
	54630 - 44032: 0xC142,
	54631 - 44032: 0xC143,
	54632 - 44032: 0xC7D4,
	54633 - 44032: 0xC7D5,
	54634 - 44032: 0xC144,
	54635 - 44032: 0xC7D6,
	54636 - 44032: 0xC145,
	54637 - 44032: 0xC7D7,
	54638 - 44032: 0xC146,
	54639 - 44032: 0xC147,
	54640 - 44032: 0xC148,
	54641 - 44032: 0xC149,
	54642 - 44032: 0xC14A,
	54643 - 44032: 0xC14B,
	54644 - 44032: 0xC7D8,
	54645 - 44032: 0xC7D9,
	54646 - 44032: 0xC14C,
	54647 - 44032: 0xC14D,
	54648 - 44032: 0xC7DA,
	54649 - 44032: 0xC14E,
	54650 - 44032: 0xC14F,
	54651 - 44032: 0xC150,
	54652 - 44032: 0xC7DB,
	54653 - 44032: 0xC151,
	54654 - 44032: 0xC152,
	54655 - 44032: 0xC153,
	54656 - 44032: 0xC154,
	54657 - 44032: 0xC155,
	54658 - 44032: 0xC156,
	54659 - 44032: 0xC157,
	54660 - 44032: 0xC7DC,
	54661 - 44032: 0xC7DD,
	54662 - 44032: 0xC158,
	54663 - 44032: 0xC7DE,
	54664 - 44032: 0xC7DF,
	54665 - 44032: 0xC7E0,
	54666 - 44032: 0xC159,
	54667 - 44032: 0xC15A,
	54668 - 44032: 0xC161,
	54669 - 44032: 0xC162,
	54670 - 44032: 0xC163,
	54671 - 44032: 0xC164,
	54672 - 44032: 0xC7E1,
	54673 - 44032: 0xC165,
	54674 - 44032: 0xC166,
	54675 - 44032: 0xC167,
	54676 - 44032: 0xC168,
	54677 - 44032: 0xC169,
	54678 - 44032: 0xC16A,
	54679 - 44032: 0xC16B,
	54680 - 44032: 0xC16C,
	54681 - 44032: 0xC16D,
	54682 - 44032: 0xC16E,
	54683 - 44032: 0xC16F,
	54684 - 44032: 0xC170,
	54685 - 44032: 0xC171,
	54686 - 44032: 0xC172,
	54687 - 44032: 0xC173,
	54688 - 44032: 0xC174,
	54689 - 44032: 0xC175,
	54690 - 44032: 0xC176,
	54691 - 44032: 0xC177,
	54692 - 44032: 0xC178,
	54693 - 44032: 0xC7E2,
	54694 - 44032: 0xC179,
	54695 - 44032: 0xC17A,
	54696 - 44032: 0xC181,
	54697 - 44032: 0xC182,
	54698 - 44032: 0xC183,
	54699 - 44032: 0xC184,
	54700 - 44032: 0xC185,
	54701 - 44032: 0xC186,
	54702 - 44032: 0xC187,
	54703 - 44032: 0xC188,
	54704 - 44032: 0xC189,
	54705 - 44032: 0xC18A,
	54706 - 44032: 0xC18B,
	54707 - 44032: 0xC18C,
	54708 - 44032: 0xC18D,
	54709 - 44032: 0xC18E,
	54710 - 44032: 0xC18F,
	54711 - 44032: 0xC190,
	54712 - 44032: 0xC191,
	54713 - 44032: 0xC192,
	54714 - 44032: 0xC193,
	54715 - 44032: 0xC194,
	54716 - 44032: 0xC195,
	54717 - 44032: 0xC196,
	54718 - 44032: 0xC197,
	54719 - 44032: 0xC198,
	54720 - 44032: 0xC199,
	54721 - 44032: 0xC19A,
	54722 - 44032: 0xC19B,
	54723 - 44032: 0xC19C,
	54724 - 44032: 0xC19D,
	54725 - 44032: 0xC19E,
	54726 - 44032: 0xC19F,
	54727 - 44032: 0xC1A0,
	54728 - 44032: 0xC7E3,
	54729 - 44032: 0xC7E4,
	54730 - 44032: 0xC241,
	54731 - 44032: 0xC242,
	54732 - 44032: 0xC7E5,
	54733 - 44032: 0xC243,
	54734 - 44032: 0xC244,
	54735 - 44032: 0xC245,
	54736 - 44032: 0xC7E6,
	54737 - 44032: 0xC246,
	54738 - 44032: 0xC7E7,
	54739 - 44032: 0xC247,
	54740 - 44032: 0xC248,
	54741 - 44032: 0xC249,
	54742 - 44032: 0xC24A,
	54743 - 44032: 0xC24B,
	54744 - 44032: 0xC7E8,
	54745 - 44032: 0xC7E9,
	54746 - 44032: 0xC24C,
	54747 - 44032: 0xC7EA,
	54748 - 44032: 0xC24D,
	54749 - 44032: 0xC7EB,
	54750 - 44032: 0xC24E,
	54751 - 44032: 0xC24F,
	54752 - 44032: 0xC250,
	54753 - 44032: 0xC251,
	54754 - 44032: 0xC252,
	54755 - 44032: 0xC253,
	54756 - 44032: 0xC7EC,
	54757 - 44032: 0xC7ED,
	54758 - 44032: 0xC254,
	54759 - 44032: 0xC255,
	54760 - 44032: 0xC7EE,
	54761 - 44032: 0xC256,
	54762 - 44032: 0xC257,
	54763 - 44032: 0xC258,
	54764 - 44032: 0xC7EF,
	54765 - 44032: 0xC259,
	54766 - 44032: 0xC25A,
	54767 - 44032: 0xC261,
	54768 - 44032: 0xC262,
	54769 - 44032: 0xC263,
	54770 - 44032: 0xC264,
	54771 - 44032: 0xC265,
	54772 - 44032: 0xC7F0,
	54773 - 44032: 0xC7F1,
	54774 - 44032: 0xC266,
	54775 - 44032: 0xC7F2,
	54776 - 44032: 0xC267,
	54777 - 44032: 0xC7F3,
	54778 - 44032: 0xC268,
	54779 - 44032: 0xC269,
	54780 - 44032: 0xC26A,
	54781 - 44032: 0xC26B,
	54782 - 44032: 0xC26C,
	54783 - 44032: 0xC26D,
	54784 - 44032: 0xC7F4,
	54785 - 44032: 0xC7F5,
	54786 - 44032: 0xC26E,
	54787 - 44032: 0xC26F,
	54788 - 44032: 0xC7F6,
	54789 - 44032: 0xC270,
	54790 - 44032: 0xC271,
	54791 - 44032: 0xC272,
	54792 - 44032: 0xC7F7,
	54793 - 44032: 0xC273,
	54794 - 44032: 0xC274,
	54795 - 44032: 0xC275,
	54796 - 44032: 0xC276,
	54797 - 44032: 0xC277,
	54798 - 44032: 0xC278,
	54799 - 44032: 0xC279,
	54800 - 44032: 0xC7F8,
	54801 - 44032: 0xC7F9,
	54802 - 44032: 0xC27A,
	54803 - 44032: 0xC7FA,
	54804 - 44032: 0xC7FB,
	54805 - 44032: 0xC7FC,
	54806 - 44032: 0xC281,
	54807 - 44032: 0xC282,
	54808 - 44032: 0xC283,
	54809 - 44032: 0xC284,
	54810 - 44032: 0xC285,
	54811 - 44032: 0xC286,
	54812 - 44032: 0xC7FD,
	54813 - 44032: 0xC287,
	54814 - 44032: 0xC288,
	54815 - 44032: 0xC289,
	54816 - 44032: 0xC7FE,
	54817 - 44032: 0xC28A,
	54818 - 44032: 0xC28B,
	54819 - 44032: 0xC28C,
	54820 - 44032: 0xC8A1,
	54821 - 44032: 0xC28D,
	54822 - 44032: 0xC28E,
	54823 - 44032: 0xC28F,
	54824 - 44032: 0xC290,
	54825 - 44032: 0xC291,
	54826 - 44032: 0xC292,
	54827 - 44032: 0xC293,
	54828 - 44032: 0xC294,
	54829 - 44032: 0xC8A2,
	54830 - 44032: 0xC295,
	54831 - 44032: 0xC296,
	54832 - 44032: 0xC297,
	54833 - 44032: 0xC298,
	54834 - 44032: 0xC299,
	54835 - 44032: 0xC29A,
	54836 - 44032: 0xC29B,
	54837 - 44032: 0xC29C,
	54838 - 44032: 0xC29D,
	54839 - 44032: 0xC29E,
	54840 - 44032: 0xC8A3,
	54841 - 44032: 0xC8A4,
	54842 - 44032: 0xC29F,
	54843 - 44032: 0xC2A0,
	54844 - 44032: 0xC8A5,
	54845 - 44032: 0xC341,
	54846 - 44032: 0xC342,
	54847 - 44032: 0xC343,
	54848 - 44032: 0xC8A6,
	54849 - 44032: 0xC344,
	54850 - 44032: 0xC345,
	54851 - 44032: 0xC346,
	54852 - 44032: 0xC347,
	54853 - 44032: 0xC8A7,
	54854 - 44032: 0xC348,
	54855 - 44032: 0xC349,
	54856 - 44032: 0xC8A8,
	54857 - 44032: 0xC8A9,
	54858 - 44032: 0xC34A,
	54859 - 44032: 0xC8AA,
	54860 - 44032: 0xC34B,
	54861 - 44032: 0xC8AB,
	54862 - 44032: 0xC34C,
	54863 - 44032: 0xC34D,
	54864 - 44032: 0xC34E,
	54865 - 44032: 0xC8AC,
	54866 - 44032: 0xC34F,
	54867 - 44032: 0xC350,
	54868 - 44032: 0xC8AD,
	54869 - 44032: 0xC8AE,
	54870 - 44032: 0xC351,
	54871 - 44032: 0xC352,
	54872 - 44032: 0xC8AF,
	54873 - 44032: 0xC353,
	54874 - 44032: 0xC354,
	54875 - 44032: 0xC355,
	54876 - 44032: 0xC8B0,
	54877 - 44032: 0xC356,
	54878 - 44032: 0xC357,
	54879 - 44032: 0xC358,
	54880 - 44032: 0xC359,
	54881 - 44032: 0xC35A,
	54882 - 44032: 0xC361,
	54883 - 44032: 0xC362,
	54884 - 44032: 0xC363,
	54885 - 44032: 0xC364,
	54886 - 44032: 0xC365,
	54887 - 44032: 0xC8B1,
	54888 - 44032: 0xC366,
	54889 - 44032: 0xC8B2,
	54890 - 44032: 0xC367,
	54891 - 44032: 0xC368,
	54892 - 44032: 0xC369,
	54893 - 44032: 0xC36A,
	54894 - 44032: 0xC36B,
	54895 - 44032: 0xC36C,
	54896 - 44032: 0xC8B3,
	54897 - 44032: 0xC8B4,
	54898 - 44032: 0xC36D,
	54899 - 44032: 0xC36E,
	54900 - 44032: 0xC8B5,
	54901 - 44032: 0xC36F,
	54902 - 44032: 0xC370,
	54903 - 44032: 0xC371,
	54904 - 44032: 0xC372,
	54905 - 44032: 0xC373,
	54906 - 44032: 0xC374,
	54907 - 44032: 0xC375,
	54908 - 44032: 0xC376,
	54909 - 44032: 0xC377,
	54910 - 44032: 0xC378,
	54911 - 44032: 0xC379,
	54912 - 44032: 0xC37A,
	54913 - 44032: 0xC381,
	54914 - 44032: 0xC382,
	54915 - 44032: 0xC8B6,
	54916 - 44032: 0xC383,
	54917 - 44032: 0xC8B7,
	54918 - 44032: 0xC384,
	54919 - 44032: 0xC385,
	54920 - 44032: 0xC386,
	54921 - 44032: 0xC387,
	54922 - 44032: 0xC388,
	54923 - 44032: 0xC389,
	54924 - 44032: 0xC8B8,
	54925 - 44032: 0xC8B9,
	54926 - 44032: 0xC38A,
	54927 - 44032: 0xC38B,
	54928 - 44032: 0xC8BA,
	54929 - 44032: 0xC38C,
	54930 - 44032: 0xC38D,
	54931 - 44032: 0xC38E,
	54932 - 44032: 0xC8BB,
	54933 - 44032: 0xC38F,
	54934 - 44032: 0xC390,
	54935 - 44032: 0xC391,
	54936 - 44032: 0xC392,
	54937 - 44032: 0xC393,
	54938 - 44032: 0xC394,
	54939 - 44032: 0xC395,
	54940 - 44032: 0xC396,
	54941 - 44032: 0xC8BC,
	54942 - 44032: 0xC397,
	54943 - 44032: 0xC8BD,
	54944 - 44032: 0xC398,
	54945 - 44032: 0xC8BE,
	54946 - 44032: 0xC399,
	54947 - 44032: 0xC39A,
	54948 - 44032: 0xC39B,
	54949 - 44032: 0xC39C,
	54950 - 44032: 0xC39D,
	54951 - 44032: 0xC39E,
	54952 - 44032: 0xC8BF,
	54953 - 44032: 0xC39F,
	54954 - 44032: 0xC3A0,
	54955 - 44032: 0xC441,
	54956 - 44032: 0xC8C0,
	54957 - 44032: 0xC442,
	54958 - 44032: 0xC443,
	54959 - 44032: 0xC444,
	54960 - 44032: 0xC8C1,
	54961 - 44032: 0xC445,
	54962 - 44032: 0xC446,
	54963 - 44032: 0xC447,
	54964 - 44032: 0xC448,
	54965 - 44032: 0xC449,
	54966 - 44032: 0xC44A,
	54967 - 44032: 0xC44B,
	54968 - 44032: 0xC44C,
	54969 - 44032: 0xC8C2,
	54970 - 44032: 0xC44D,
	54971 - 44032: 0xC8C3,
	54972 - 44032: 0xC44E,
	54973 - 44032: 0xC44F,
	54974 - 44032: 0xC450,
	54975 - 44032: 0xC451,
	54976 - 44032: 0xC452,
	54977 - 44032: 0xC453,
	54978 - 44032: 0xC454,
	54979 - 44032: 0xC455,
	54980 - 44032: 0xC8C4,
	54981 - 44032: 0xC8C5,
	54982 - 44032: 0xC456,
	54983 - 44032: 0xC457,
	54984 - 44032: 0xC8C6,
	54985 - 44032: 0xC458,
	54986 - 44032: 0xC459,
	54987 - 44032: 0xC45A,
	54988 - 44032: 0xC8C7,
	54989 - 44032: 0xC461,
	54990 - 44032: 0xC462,
	54991 - 44032: 0xC463,
	54992 - 44032: 0xC464,
	54993 - 44032: 0xC8C8,
	54994 - 44032: 0xC465,
	54995 - 44032: 0xC466,
	54996 - 44032: 0xC8C9,
	54997 - 44032: 0xC467,
	54998 - 44032: 0xC468,
	54999 - 44032: 0xC8CA,
	55000 - 44032: 0xC469,
	55001 - 44032: 0xC8CB,
	55002 - 44032: 0xC46A,
	55003 - 44032: 0xC46B,
	55004 - 44032: 0xC46C,
	55005 - 44032: 0xC46D,
	55006 - 44032: 0xC46E,
	55007 - 44032: 0xC46F,
	55008 - 44032: 0xC8CC,
	55009 - 44032: 0xC470,
	55010 - 44032: 0xC471,
	55011 - 44032: 0xC472,
	55012 - 44032: 0xC8CD,
	55013 - 44032: 0xC473,
	55014 - 44032: 0xC474,
	55015 - 44032: 0xC475,
	55016 - 44032: 0xC8CE,
	55017 - 44032: 0xC476,
	55018 - 44032: 0xC477,
	55019 - 44032: 0xC478,
	55020 - 44032: 0xC479,
	55021 - 44032: 0xC47A,
	55022 - 44032: 0xC481,
	55023 - 44032: 0xC482,
	55024 - 44032: 0xC8CF,
	55025 - 44032: 0xC483,
	55026 - 44032: 0xC484,
	55027 - 44032: 0xC485,
	55028 - 44032: 0xC486,
	55029 - 44032: 0xC8D0,
	55030 - 44032: 0xC487,
	55031 - 44032: 0xC488,
	55032 - 44032: 0xC489,
	55033 - 44032: 0xC48A,
	55034 - 44032: 0xC48B,
	55035 - 44032: 0xC48C,
	55036 - 44032: 0xC8D1,
	55037 - 44032: 0xC8D2,
	55038 - 44032: 0xC48D,
	55039 - 44032: 0xC48E,
	55040 - 44032: 0xC8D3,
	55041 - 44032: 0xC48F,
	55042 - 44032: 0xC490,
	55043 - 44032: 0xC491,
	55044 - 44032: 0xC8D4,
	55045 - 44032: 0xC492,
	55046 - 44032: 0xC493,
	55047 - 44032: 0xC494,
	55048 - 44032: 0xC495,
	55049 - 44032: 0xC496,
	55050 - 44032: 0xC497,
	55051 - 44032: 0xC498,
	55052 - 44032: 0xC499,
	55053 - 44032: 0xC49A,
	55054 - 44032: 0xC49B,
	55055 - 44032: 0xC49C,
	55056 - 44032: 0xC49D,
	55057 - 44032: 0xC8D5,
	55058 - 44032: 0xC49E,
	55059 - 44032: 0xC49F,
	55060 - 44032: 0xC4A0,
	55061 - 44032: 0xC541,
	55062 - 44032: 0xC542,
	55063 - 44032: 0xC543,
	55064 - 44032: 0xC8D6,
	55065 - 44032: 0xC8D7,
	55066 - 44032: 0xC544,
	55067 - 44032: 0xC545,
	55068 - 44032: 0xC8D8,
	55069 - 44032: 0xC546,
	55070 - 44032: 0xC547,
	55071 - 44032: 0xC548,
	55072 - 44032: 0xC8D9,
	55073 - 44032: 0xC549,
	55074 - 44032: 0xC54A,
	55075 - 44032: 0xC54B,
	55076 - 44032: 0xC54C,
	55077 - 44032: 0xC54D,
	55078 - 44032: 0xC54E,
	55079 - 44032: 0xC54F,
	55080 - 44032: 0xC8DA,
	55081 - 44032: 0xC8DB,
	55082 - 44032: 0xC550,
	55083 - 44032: 0xC8DC,
	55084 - 44032: 0xC551,
	55085 - 44032: 0xC8DD,
	55086 - 44032: 0xC552,
	55087 - 44032: 0xC553,
	55088 - 44032: 0xC554,
	55089 - 44032: 0xC555,
	55090 - 44032: 0xC556,
	55091 - 44032: 0xC557,
	55092 - 44032: 0xC8DE,
	55093 - 44032: 0xC8DF,
	55094 - 44032: 0xC558,
	55095 - 44032: 0xC559,
	55096 - 44032: 0xC8E0,
	55097 - 44032: 0xC55A,
	55098 - 44032: 0xC561,
	55099 - 44032: 0xC562,
	55100 - 44032: 0xC8E1,
	55101 - 44032: 0xC563,
	55102 - 44032: 0xC564,
	55103 - 44032: 0xC565,
	55104 - 44032: 0xC566,
	55105 - 44032: 0xC567,
	55106 - 44032: 0xC568,
	55107 - 44032: 0xC569,
	55108 - 44032: 0xC8E2,
	55109 - 44032: 0xC56A,
	55110 - 44032: 0xC56B,
	55111 - 44032: 0xC8E3,
	55112 - 44032: 0xC56C,
	55113 - 44032: 0xC8E4,
	55114 - 44032: 0xC56D,
	55115 - 44032: 0xC56E,
	55116 - 44032: 0xC56F,
	55117 - 44032: 0xC570,
	55118 - 44032: 0xC571,
	55119 - 44032: 0xC572,
	55120 - 44032: 0xC8E5,
	55121 - 44032: 0xC8E6,
	55122 - 44032: 0xC573,
	55123 - 44032: 0xC574,
	55124 - 44032: 0xC8E7,
	55125 - 44032: 0xC575,
	55126 - 44032: 0xC8E8,
	55127 - 44032: 0xC8E9,
	55128 - 44032: 0xC8EA,
	55129 - 44032: 0xC8EB,
	55130 - 44032: 0xC576,
	55131 - 44032: 0xC577,
	55132 - 44032: 0xC578,
	55133 - 44032: 0xC579,
	55134 - 44032: 0xC57A,
	55135 - 44032: 0xC581,
	55136 - 44032: 0xC8EC,
	55137 - 44032: 0xC8ED,
	55138 - 44032: 0xC582,
	55139 - 44032: 0xC8EE,
	55140 - 44032: 0xC583,
	55141 - 44032: 0xC8EF,
	55142 - 44032: 0xC584,
	55143 - 44032: 0xC585,
	55144 - 44032: 0xC586,
	55145 - 44032: 0xC8F0,
	55146 - 44032: 0xC587,
	55147 - 44032: 0xC588,
	55148 - 44032: 0xC8F1,
	55149 - 44032: 0xC589,
	55150 - 44032: 0xC58A,
	55151 - 44032: 0xC58B,
	55152 - 44032: 0xC8F2,
	55153 - 44032: 0xC58C,
	55154 - 44032: 0xC58D,
	55155 - 44032: 0xC58E,
	55156 - 44032: 0xC8F3,
	55157 - 44032: 0xC58F,
	55158 - 44032: 0xC590,
	55159 - 44032: 0xC591,
	55160 - 44032: 0xC592,
	55161 - 44032: 0xC593,
	55162 - 44032: 0xC594,
	55163 - 44032: 0xC595,
	55164 - 44032: 0xC8F4,
	55165 - 44032: 0xC8F5,
	55166 - 44032: 0xC596,
	55167 - 44032: 0xC597,
	55168 - 44032: 0xC598,
	55169 - 44032: 0xC8F6,
	55170 - 44032: 0xC599,
	55171 - 44032: 0xC59A,
	55172 - 44032: 0xC59B,
	55173 - 44032: 0xC59C,
	55174 - 44032: 0xC59D,
	55175 - 44032: 0xC59E,
	55176 - 44032: 0xC8F7,
	55177 - 44032: 0xC8F8,
	55178 - 44032: 0xC59F,
	55179 - 44032: 0xC5A0,
	55180 - 44032: 0xC8F9,
	55181 - 44032: 0xC641,
	55182 - 44032: 0xC642,
	55183 - 44032: 0xC643,
	55184 - 44032: 0xC8FA,
	55185 - 44032: 0xC644,
	55186 - 44032: 0xC645,
	55187 - 44032: 0xC646,
	55188 - 44032: 0xC647,
	55189 - 44032: 0xC648,
	55190 - 44032: 0xC649,
	55191 - 44032: 0xC64A,
	55192 - 44032: 0xC8FB,
	55193 - 44032: 0xC8FC,
	55194 - 44032: 0xC64B,
	55195 - 44032: 0xC8FD,
	55196 - 44032: 0xC64C,
	55197 - 44032: 0xC8FE,
	55198 - 44032: 0xC64D,
	55199 - 44032: 0xC64E,
	55200 - 44032: 0xC64F,
	55201 - 44032: 0xC650,
	55202 - 44032: 0xC651,
	55203 - 44032: 0xC652,
}

const encode2Low, encode2High = 8213, 9838

var encode2 = [...]uint16{
	8213 - 8213: 0xA1AA,
	8216 - 8213: 0xA1AE,
	8217 - 8213: 0xA1AF,
	8220 - 8213: 0xA1B0,
	8221 - 8213: 0xA1B1,
	8224 - 8213: 0xA2D3,
	8225 - 8213: 0xA2D4,
	8229 - 8213: 0xA1A5,
	8230 - 8213: 0xA1A6,
	8240 - 8213: 0xA2B6,
	8242 - 8213: 0xA1C7,
	8243 - 8213: 0xA1C8,
	8251 - 8213: 0xA1D8,
	8308 - 8213: 0xA9F9,
	8319 - 8213: 0xA9FA,
	8321 - 8213: 0xA9FB,
	8322 - 8213: 0xA9FC,
	8323 - 8213: 0xA9FD,
	8324 - 8213: 0xA9FE,
	8364 - 8213: 0xA2E6,
	8451 - 8213: 0xA1C9,
	8457 - 8213: 0xA2B5,
	8467 - 8213: 0xA7A4,
	8470 - 8213: 0xA2E0,
	8481 - 8213: 0xA2E5,
	8482 - 8213: 0xA2E2,
	8486 - 8213: 0xA7D9,
	8491 - 8213: 0xA1CA,
	8531 - 8213: 0xA8F7,
	8532 - 8213: 0xA8F8,
	8539 - 8213: 0xA8FB,
	8540 - 8213: 0xA8FC,
	8541 - 8213: 0xA8FD,
	8542 - 8213: 0xA8FE,
	8544 - 8213: 0xA5B0,
	8545 - 8213: 0xA5B1,
	8546 - 8213: 0xA5B2,
	8547 - 8213: 0xA5B3,
	8548 - 8213: 0xA5B4,
	8549 - 8213: 0xA5B5,
	8550 - 8213: 0xA5B6,
	8551 - 8213: 0xA5B7,
	8552 - 8213: 0xA5B8,
	8553 - 8213: 0xA5B9,
	8560 - 8213: 0xA5A1,
	8561 - 8213: 0xA5A2,
	8562 - 8213: 0xA5A3,
	8563 - 8213: 0xA5A4,
	8564 - 8213: 0xA5A5,
	8565 - 8213: 0xA5A6,
	8566 - 8213: 0xA5A7,
	8567 - 8213: 0xA5A8,
	8568 - 8213: 0xA5A9,
	8569 - 8213: 0xA5AA,
	8592 - 8213: 0xA1E7,
	8593 - 8213: 0xA1E8,
	8594 - 8213: 0xA1E6,
	8595 - 8213: 0xA1E9,
	8596 - 8213: 0xA1EA,
	8597 - 8213: 0xA2D5,
	8598 - 8213: 0xA2D8,
	8599 - 8213: 0xA2D6,
	8600 - 8213: 0xA2D9,
	8601 - 8213: 0xA2D7,
	8658 - 8213: 0xA2A1,
	8660 - 8213: 0xA2A2,
	8704 - 8213: 0xA2A3,
	8706 - 8213: 0xA1D3,
	8707 - 8213: 0xA2A4,
	8711 - 8213: 0xA1D4,
	8712 - 8213: 0xA1F4,
	8715 - 8213: 0xA1F5,
	8719 - 8213: 0xA2B3,
	8721 - 8213: 0xA2B2,
	8730 - 8213: 0xA1EE,
	8733 - 8213: 0xA1F0,
	8734 - 8213: 0xA1C4,
	8736 - 8213: 0xA1D0,
	8741 - 8213: 0xA1AB,
	8743 - 8213: 0xA1FC,
	8744 - 8213: 0xA1FD,
	8745 - 8213: 0xA1FB,
	8746 - 8213: 0xA1FA,
	8747 - 8213: 0xA1F2,
	8748 - 8213: 0xA1F3,
	8750 - 8213: 0xA2B1,
	8756 - 8213: 0xA1C5,
	8757 - 8213: 0xA1F1,
	8764 - 8213: 0xA1AD,
	8765 - 8213: 0xA1EF,
	8786 - 8213: 0xA1D6,
	8800 - 8213: 0xA1C1,
	8801 - 8213: 0xA1D5,
	8804 - 8213: 0xA1C2,
	8805 - 8213: 0xA1C3,
	8810 - 8213: 0xA1EC,
	8811 - 8213: 0xA1ED,
	8834 - 8213: 0xA1F8,
	8835 - 8213: 0xA1F9,
	8838 - 8213: 0xA1F6,
	8839 - 8213: 0xA1F7,
	8857 - 8213: 0xA2C1,
	8869 - 8213: 0xA1D1,
	8978 - 8213: 0xA1D2,
	9312 - 8213: 0xA8E7,
	9313 - 8213: 0xA8E8,
	9314 - 8213: 0xA8E9,
	9315 - 8213: 0xA8EA,
	9316 - 8213: 0xA8EB,
	9317 - 8213: 0xA8EC,
	9318 - 8213: 0xA8ED,
	9319 - 8213: 0xA8EE,
	9320 - 8213: 0xA8EF,
	9321 - 8213: 0xA8F0,
	9322 - 8213: 0xA8F1,
	9323 - 8213: 0xA8F2,
	9324 - 8213: 0xA8F3,
	9325 - 8213: 0xA8F4,
	9326 - 8213: 0xA8F5,
	9332 - 8213: 0xA9E7,
	9333 - 8213: 0xA9E8,
	9334 - 8213: 0xA9E9,
	9335 - 8213: 0xA9EA,
	9336 - 8213: 0xA9EB,
	9337 - 8213: 0xA9EC,
	9338 - 8213: 0xA9ED,
	9339 - 8213: 0xA9EE,
	9340 - 8213: 0xA9EF,
	9341 - 8213: 0xA9F0,
	9342 - 8213: 0xA9F1,
	9343 - 8213: 0xA9F2,
	9344 - 8213: 0xA9F3,
	9345 - 8213: 0xA9F4,
	9346 - 8213: 0xA9F5,
	9372 - 8213: 0xA9CD,
	9373 - 8213: 0xA9CE,
	9374 - 8213: 0xA9CF,
	9375 - 8213: 0xA9D0,
	9376 - 8213: 0xA9D1,
	9377 - 8213: 0xA9D2,
	9378 - 8213: 0xA9D3,
	9379 - 8213: 0xA9D4,
	9380 - 8213: 0xA9D5,
	9381 - 8213: 0xA9D6,
	9382 - 8213: 0xA9D7,
	9383 - 8213: 0xA9D8,
	9384 - 8213: 0xA9D9,
	9385 - 8213: 0xA9DA,
	9386 - 8213: 0xA9DB,
	9387 - 8213: 0xA9DC,
	9388 - 8213: 0xA9DD,
	9389 - 8213: 0xA9DE,
	9390 - 8213: 0xA9DF,
	9391 - 8213: 0xA9E0,
	9392 - 8213: 0xA9E1,
	9393 - 8213: 0xA9E2,
	9394 - 8213: 0xA9E3,
	9395 - 8213: 0xA9E4,
	9396 - 8213: 0xA9E5,
	9397 - 8213: 0xA9E6,
	9424 - 8213: 0xA8CD,
	9425 - 8213: 0xA8CE,
	9426 - 8213: 0xA8CF,
	9427 - 8213: 0xA8D0,
	9428 - 8213: 0xA8D1,
	9429 - 8213: 0xA8D2,
	9430 - 8213: 0xA8D3,
	9431 - 8213: 0xA8D4,
	9432 - 8213: 0xA8D5,
	9433 - 8213: 0xA8D6,
	9434 - 8213: 0xA8D7,
	9435 - 8213: 0xA8D8,
	9436 - 8213: 0xA8D9,
	9437 - 8213: 0xA8DA,
	9438 - 8213: 0xA8DB,
	9439 - 8213: 0xA8DC,
	9440 - 8213: 0xA8DD,
	9441 - 8213: 0xA8DE,
	9442 - 8213: 0xA8DF,
	9443 - 8213: 0xA8E0,
	9444 - 8213: 0xA8E1,
	9445 - 8213: 0xA8E2,
	9446 - 8213: 0xA8E3,
	9447 - 8213: 0xA8E4,
	9448 - 8213: 0xA8E5,
	9449 - 8213: 0xA8E6,
	9472 - 8213: 0xA6A1,
	9473 - 8213: 0xA6AC,
	9474 - 8213: 0xA6A2,
	9475 - 8213: 0xA6AD,
	9484 - 8213: 0xA6A3,
	9485 - 8213: 0xA6C8,
	9486 - 8213: 0xA6C7,
	9487 - 8213: 0xA6AE,
	9488 - 8213: 0xA6A4,
	9489 - 8213: 0xA6C2,
	9490 - 8213: 0xA6C1,
	9491 - 8213: 0xA6AF,
	9492 - 8213: 0xA6A6,
	9493 - 8213: 0xA6C6,
	9494 - 8213: 0xA6C5,
	9495 - 8213: 0xA6B1,
	9496 - 8213: 0xA6A5,
	9497 - 8213: 0xA6C4,
	9498 - 8213: 0xA6C3,
	9499 - 8213: 0xA6B0,
	9500 - 8213: 0xA6A7,
	9501 - 8213: 0xA6BC,
	9502 - 8213: 0xA6C9,
	9503 - 8213: 0xA6CA,
	9504 - 8213: 0xA6B7,
	9505 - 8213: 0xA6CB,
	9506 - 8213: 0xA6CC,
	9507 - 8213: 0xA6B2,
	9508 - 8213: 0xA6A9,
	9509 - 8213: 0xA6BE,
	9510 - 8213: 0xA6CD,
	9511 - 8213: 0xA6CE,
	9512 - 8213: 0xA6B9,
	9513 - 8213: 0xA6CF,
	9514 - 8213: 0xA6D0,
	9515 - 8213: 0xA6B4,
	9516 - 8213: 0xA6A8,
	9517 - 8213: 0xA6D1,
	9518 - 8213: 0xA6D2,
	9519 - 8213: 0xA6B8,
	9520 - 8213: 0xA6BD,
	9521 - 8213: 0xA6D3,
	9522 - 8213: 0xA6D4,
	9523 - 8213: 0xA6B3,
	9524 - 8213: 0xA6AA,
	9525 - 8213: 0xA6D5,
	9526 - 8213: 0xA6D6,
	9527 - 8213: 0xA6BA,
	9528 - 8213: 0xA6BF,
	9529 - 8213: 0xA6D7,
	9530 - 8213: 0xA6D8,
	9531 - 8213: 0xA6B5,
	9532 - 8213: 0xA6AB,
	9533 - 8213: 0xA6D9,
	9534 - 8213: 0xA6DA,
	9535 - 8213: 0xA6BB,
	9536 - 8213: 0xA6DB,
	9537 - 8213: 0xA6DC,
	9538 - 8213: 0xA6C0,
	9539 - 8213: 0xA6DD,
	9540 - 8213: 0xA6DE,
	9541 - 8213: 0xA6DF,
	9542 - 8213: 0xA6E0,
	9543 - 8213: 0xA6E1,
	9544 - 8213: 0xA6E2,
	9545 - 8213: 0xA6E3,
	9546 - 8213: 0xA6E4,
	9547 - 8213: 0xA6B6,
	9618 - 8213: 0xA2C6,
	9632 - 8213: 0xA1E1,
	9633 - 8213: 0xA1E0,
	9635 - 8213: 0xA2C3,
	9636 - 8213: 0xA2C7,
	9637 - 8213: 0xA2C8,
	9638 - 8213: 0xA2CB,
	9639 - 8213: 0xA2CA,
	9640 - 8213: 0xA2C9,
	9641 - 8213: 0xA2CC,
	9650 - 8213: 0xA1E3,
	9651 - 8213: 0xA1E2,
	9654 - 8213: 0xA2BA,
	9655 - 8213: 0xA2B9,
	9660 - 8213: 0xA1E5,
	9661 - 8213: 0xA1E4,
	9664 - 8213: 0xA2B8,
	9665 - 8213: 0xA2B7,
	9670 - 8213: 0xA1DF,
	9671 - 8213: 0xA1DE,
	9672 - 8213: 0xA2C2,
	9675 - 8213: 0xA1DB,
	9678 - 8213: 0xA1DD,
	9679 - 8213: 0xA1DC,
	9680 - 8213: 0xA2C4,
	9681 - 8213: 0xA2C5,
	9733 - 8213: 0xA1DA,
	9734 - 8213: 0xA1D9,
	9742 - 8213: 0xA2CF,
	9743 - 8213: 0xA2CE,
	9756 - 8213: 0xA2D0,
	9758 - 8213: 0xA2D1,
	9792 - 8213: 0xA1CF,
	9794 - 8213: 0xA1CE,
	9824 - 8213: 0xA2BC,
	9825 - 8213: 0xA2BD,
	9827 - 8213: 0xA2C0,
	9828 - 8213: 0xA2BB,
	9829 - 8213: 0xA2BE,
	9831 - 8213: 0xA2BF,
	9832 - 8213: 0xA2CD,
	9833 - 8213: 0xA2DB,
	9834 - 8213: 0xA2DC,
	9836 - 8213: 0xA2DD,
	9837 - 8213: 0xA2DA,
}

const encode3Low, encode3High = 12288, 13278

var encode3 = [...]uint16{
	12288 - 12288: 0xA1A1,
	12289 - 12288: 0xA1A2,
	12290 - 12288: 0xA1A3,
	12291 - 12288: 0xA1A8,
	12296 - 12288: 0xA1B4,
	12297 - 12288: 0xA1B5,
	12298 - 12288: 0xA1B6,
	12299 - 12288: 0xA1B7,
	12300 - 12288: 0xA1B8,
	12301 - 12288: 0xA1B9,
	12302 - 12288: 0xA1BA,
	12303 - 12288: 0xA1BB,
	12304 - 12288: 0xA1BC,
	12305 - 12288: 0xA1BD,
	12307 - 12288: 0xA1EB,
	12308 - 12288: 0xA1B2,
	12309 - 12288: 0xA1B3,
	12353 - 12288: 0xAAA1,
	12354 - 12288: 0xAAA2,
	12355 - 12288: 0xAAA3,
	12356 - 12288: 0xAAA4,
	12357 - 12288: 0xAAA5,
	12358 - 12288: 0xAAA6,
	12359 - 12288: 0xAAA7,
	12360 - 12288: 0xAAA8,
	12361 - 12288: 0xAAA9,
	12362 - 12288: 0xAAAA,
	12363 - 12288: 0xAAAB,
	12364 - 12288: 0xAAAC,
	12365 - 12288: 0xAAAD,
	12366 - 12288: 0xAAAE,
	12367 - 12288: 0xAAAF,
	12368 - 12288: 0xAAB0,
	12369 - 12288: 0xAAB1,
	12370 - 12288: 0xAAB2,
	12371 - 12288: 0xAAB3,
	12372 - 12288: 0xAAB4,
	12373 - 12288: 0xAAB5,
	12374 - 12288: 0xAAB6,
	12375 - 12288: 0xAAB7,
	12376 - 12288: 0xAAB8,
	12377 - 12288: 0xAAB9,
	12378 - 12288: 0xAABA,
	12379 - 12288: 0xAABB,
	12380 - 12288: 0xAABC,
	12381 - 12288: 0xAABD,
	12382 - 12288: 0xAABE,
	12383 - 12288: 0xAABF,
	12384 - 12288: 0xAAC0,
	12385 - 12288: 0xAAC1,
	12386 - 12288: 0xAAC2,
	12387 - 12288: 0xAAC3,
	12388 - 12288: 0xAAC4,
	12389 - 12288: 0xAAC5,
	12390 - 12288: 0xAAC6,
	12391 - 12288: 0xAAC7,
	12392 - 12288: 0xAAC8,
	12393 - 12288: 0xAAC9,
	12394 - 12288: 0xAACA,
	12395 - 12288: 0xAACB,
	12396 - 12288: 0xAACC,
	12397 - 12288: 0xAACD,
	12398 - 12288: 0xAACE,
	12399 - 12288: 0xAACF,
	12400 - 12288: 0xAAD0,
	12401 - 12288: 0xAAD1,
	12402 - 12288: 0xAAD2,
	12403 - 12288: 0xAAD3,
	12404 - 12288: 0xAAD4,
	12405 - 12288: 0xAAD5,
	12406 - 12288: 0xAAD6,
	12407 - 12288: 0xAAD7,
	12408 - 12288: 0xAAD8,
	12409 - 12288: 0xAAD9,
	12410 - 12288: 0xAADA,
	12411 - 12288: 0xAADB,
	12412 - 12288: 0xAADC,
	12413 - 12288: 0xAADD,
	12414 - 12288: 0xAADE,
	12415 - 12288: 0xAADF,
	12416 - 12288: 0xAAE0,
	12417 - 12288: 0xAAE1,
	12418 - 12288: 0xAAE2,
	12419 - 12288: 0xAAE3,
	12420 - 12288: 0xAAE4,
	12421 - 12288: 0xAAE5,
	12422 - 12288: 0xAAE6,
	12423 - 12288: 0xAAE7,
	12424 - 12288: 0xAAE8,
	12425 - 12288: 0xAAE9,
	12426 - 12288: 0xAAEA,
	12427 - 12288: 0xAAEB,
	12428 - 12288: 0xAAEC,
	12429 - 12288: 0xAAED,
	12430 - 12288: 0xAAEE,
	12431 - 12288: 0xAAEF,
	12432 - 12288: 0xAAF0,
	12433 - 12288: 0xAAF1,
	12434 - 12288: 0xAAF2,
	12435 - 12288: 0xAAF3,
	12449 - 12288: 0xABA1,
	12450 - 12288: 0xABA2,
	12451 - 12288: 0xABA3,
	12452 - 12288: 0xABA4,
	12453 - 12288: 0xABA5,
	12454 - 12288: 0xABA6,
	12455 - 12288: 0xABA7,
	12456 - 12288: 0xABA8,
	12457 - 12288: 0xABA9,
	12458 - 12288: 0xABAA,
	12459 - 12288: 0xABAB,
	12460 - 12288: 0xABAC,
	12461 - 12288: 0xABAD,
	12462 - 12288: 0xABAE,
	12463 - 12288: 0xABAF,
	12464 - 12288: 0xABB0,
	12465 - 12288: 0xABB1,
	12466 - 12288: 0xABB2,
	12467 - 12288: 0xABB3,
	12468 - 12288: 0xABB4,
	12469 - 12288: 0xABB5,
	12470 - 12288: 0xABB6,
	12471 - 12288: 0xABB7,
	12472 - 12288: 0xABB8,
	12473 - 12288: 0xABB9,
	12474 - 12288: 0xABBA,
	12475 - 12288: 0xABBB,
	12476 - 12288: 0xABBC,
	12477 - 12288: 0xABBD,
	12478 - 12288: 0xABBE,
	12479 - 12288: 0xABBF,
	12480 - 12288: 0xABC0,
	12481 - 12288: 0xABC1,
	12482 - 12288: 0xABC2,
	12483 - 12288: 0xABC3,
	12484 - 12288: 0xABC4,
	12485 - 12288: 0xABC5,
	12486 - 12288: 0xABC6,
	12487 - 12288: 0xABC7,
	12488 - 12288: 0xABC8,
	12489 - 12288: 0xABC9,
	12490 - 12288: 0xABCA,
	12491 - 12288: 0xABCB,
	12492 - 12288: 0xABCC,
	12493 - 12288: 0xABCD,
	12494 - 12288: 0xABCE,
	12495 - 12288: 0xABCF,
	12496 - 12288: 0xABD0,
	12497 - 12288: 0xABD1,
	12498 - 12288: 0xABD2,
	12499 - 12288: 0xABD3,
	12500 - 12288: 0xABD4,
	12501 - 12288: 0xABD5,
	12502 - 12288: 0xABD6,
	12503 - 12288: 0xABD7,
	12504 - 12288: 0xABD8,
	12505 - 12288: 0xABD9,
	12506 - 12288: 0xABDA,
	12507 - 12288: 0xABDB,
	12508 - 12288: 0xABDC,
	12509 - 12288: 0xABDD,
	12510 - 12288: 0xABDE,
	12511 - 12288: 0xABDF,
	12512 - 12288: 0xABE0,
	12513 - 12288: 0xABE1,
	12514 - 12288: 0xABE2,
	12515 - 12288: 0xABE3,
	12516 - 12288: 0xABE4,
	12517 - 12288: 0xABE5,
	12518 - 12288: 0xABE6,
	12519 - 12288: 0xABE7,
	12520 - 12288: 0xABE8,
	12521 - 12288: 0xABE9,
	12522 - 12288: 0xABEA,
	12523 - 12288: 0xABEB,
	12524 - 12288: 0xABEC,
	12525 - 12288: 0xABED,
	12526 - 12288: 0xABEE,
	12527 - 12288: 0xABEF,
	12528 - 12288: 0xABF0,
	12529 - 12288: 0xABF1,
	12530 - 12288: 0xABF2,
	12531 - 12288: 0xABF3,
	12532 - 12288: 0xABF4,
	12533 - 12288: 0xABF5,
	12534 - 12288: 0xABF6,
	12593 - 12288: 0xA4A1,
	12594 - 12288: 0xA4A2,
	12595 - 12288: 0xA4A3,
	12596 - 12288: 0xA4A4,
	12597 - 12288: 0xA4A5,
	12598 - 12288: 0xA4A6,
	12599 - 12288: 0xA4A7,
	12600 - 12288: 0xA4A8,
	12601 - 12288: 0xA4A9,
	12602 - 12288: 0xA4AA,
	12603 - 12288: 0xA4AB,
	12604 - 12288: 0xA4AC,
	12605 - 12288: 0xA4AD,
	12606 - 12288: 0xA4AE,
	12607 - 12288: 0xA4AF,
	12608 - 12288: 0xA4B0,
	12609 - 12288: 0xA4B1,
	12610 - 12288: 0xA4B2,
	12611 - 12288: 0xA4B3,
	12612 - 12288: 0xA4B4,
	12613 - 12288: 0xA4B5,
	12614 - 12288: 0xA4B6,
	12615 - 12288: 0xA4B7,
	12616 - 12288: 0xA4B8,
	12617 - 12288: 0xA4B9,
	12618 - 12288: 0xA4BA,
	12619 - 12288: 0xA4BB,
	12620 - 12288: 0xA4BC,
	12621 - 12288: 0xA4BD,
	12622 - 12288: 0xA4BE,
	12623 - 12288: 0xA4BF,
	12624 - 12288: 0xA4C0,
	12625 - 12288: 0xA4C1,
	12626 - 12288: 0xA4C2,
	12627 - 12288: 0xA4C3,
	12628 - 12288: 0xA4C4,
	12629 - 12288: 0xA4C5,
	12630 - 12288: 0xA4C6,
	12631 - 12288: 0xA4C7,
	12632 - 12288: 0xA4C8,
	12633 - 12288: 0xA4C9,
	12634 - 12288: 0xA4CA,
	12635 - 12288: 0xA4CB,
	12636 - 12288: 0xA4CC,
	12637 - 12288: 0xA4CD,
	12638 - 12288: 0xA4CE,
	12639 - 12288: 0xA4CF,
	12640 - 12288: 0xA4D0,
	12641 - 12288: 0xA4D1,
	12642 - 12288: 0xA4D2,
	12643 - 12288: 0xA4D3,
	12644 - 12288: 0xA4D4,
	12645 - 12288: 0xA4D5,
	12646 - 12288: 0xA4D6,
	12647 - 12288: 0xA4D7,
	12648 - 12288: 0xA4D8,
	12649 - 12288: 0xA4D9,
	12650 - 12288: 0xA4DA,
	12651 - 12288: 0xA4DB,
	12652 - 12288: 0xA4DC,
	12653 - 12288: 0xA4DD,
	12654 - 12288: 0xA4DE,
	12655 - 12288: 0xA4DF,
	12656 - 12288: 0xA4E0,
	12657 - 12288: 0xA4E1,
	12658 - 12288: 0xA4E2,
	12659 - 12288: 0xA4E3,
	12660 - 12288: 0xA4E4,
	12661 - 12288: 0xA4E5,
	12662 - 12288: 0xA4E6,
	12663 - 12288: 0xA4E7,
	12664 - 12288: 0xA4E8,
	12665 - 12288: 0xA4E9,
	12666 - 12288: 0xA4EA,
	12667 - 12288: 0xA4EB,
	12668 - 12288: 0xA4EC,
	12669 - 12288: 0xA4ED,
	12670 - 12288: 0xA4EE,
	12671 - 12288: 0xA4EF,
	12672 - 12288: 0xA4F0,
	12673 - 12288: 0xA4F1,
	12674 - 12288: 0xA4F2,
	12675 - 12288: 0xA4F3,
	12676 - 12288: 0xA4F4,
	12677 - 12288: 0xA4F5,
	12678 - 12288: 0xA4F6,
	12679 - 12288: 0xA4F7,
	12680 - 12288: 0xA4F8,
	12681 - 12288: 0xA4F9,
	12682 - 12288: 0xA4FA,
	12683 - 12288: 0xA4FB,
	12684 - 12288: 0xA4FC,
	12685 - 12288: 0xA4FD,
	12686 - 12288: 0xA4FE,
	12800 - 12288: 0xA9B1,
	12801 - 12288: 0xA9B2,
	12802 - 12288: 0xA9B3,
	12803 - 12288: 0xA9B4,
	12804 - 12288: 0xA9B5,
	12805 - 12288: 0xA9B6,
	12806 - 12288: 0xA9B7,
	12807 - 12288: 0xA9B8,
	12808 - 12288: 0xA9B9,
	12809 - 12288: 0xA9BA,
	12810 - 12288: 0xA9BB,
	12811 - 12288: 0xA9BC,
	12812 - 12288: 0xA9BD,
	12813 - 12288: 0xA9BE,
	12814 - 12288: 0xA9BF,
	12815 - 12288: 0xA9C0,
	12816 - 12288: 0xA9C1,
	12817 - 12288: 0xA9C2,
	12818 - 12288: 0xA9C3,
	12819 - 12288: 0xA9C4,
	12820 - 12288: 0xA9C5,
	12821 - 12288: 0xA9C6,
	12822 - 12288: 0xA9C7,
	12823 - 12288: 0xA9C8,
	12824 - 12288: 0xA9C9,
	12825 - 12288: 0xA9CA,
	12826 - 12288: 0xA9CB,
	12827 - 12288: 0xA9CC,
	12828 - 12288: 0xA2DF,
	12896 - 12288: 0xA8B1,
	12897 - 12288: 0xA8B2,
	12898 - 12288: 0xA8B3,
	12899 - 12288: 0xA8B4,
	12900 - 12288: 0xA8B5,
	12901 - 12288: 0xA8B6,
	12902 - 12288: 0xA8B7,
	12903 - 12288: 0xA8B8,
	12904 - 12288: 0xA8B9,
	12905 - 12288: 0xA8BA,
	12906 - 12288: 0xA8BB,
	12907 - 12288: 0xA8BC,
	12908 - 12288: 0xA8BD,
	12909 - 12288: 0xA8BE,
	12910 - 12288: 0xA8BF,
	12911 - 12288: 0xA8C0,
	12912 - 12288: 0xA8C1,
	12913 - 12288: 0xA8C2,
	12914 - 12288: 0xA8C3,
	12915 - 12288: 0xA8C4,
	12916 - 12288: 0xA8C5,
	12917 - 12288: 0xA8C6,
	12918 - 12288: 0xA8C7,
	12919 - 12288: 0xA8C8,
	12920 - 12288: 0xA8C9,
	12921 - 12288: 0xA8CA,
	12922 - 12288: 0xA8CB,
	12923 - 12288: 0xA8CC,
	12927 - 12288: 0xA2DE,
	13184 - 12288: 0xA7C9,
	13185 - 12288: 0xA7CA,
	13186 - 12288: 0xA7CB,
	13187 - 12288: 0xA7CC,
	13188 - 12288: 0xA7CD,
	13192 - 12288: 0xA7BA,
	13193 - 12288: 0xA7BB,
	13194 - 12288: 0xA7DC,
	13195 - 12288: 0xA7DD,
	13196 - 12288: 0xA7DE,
	13197 - 12288: 0xA7B6,
	13198 - 12288: 0xA7B7,
	13199 - 12288: 0xA7B8,
	13200 - 12288: 0xA7D4,
	13201 - 12288: 0xA7D5,
	13202 - 12288: 0xA7D6,
	13203 - 12288: 0xA7D7,
	13204 - 12288: 0xA7D8,
	13205 - 12288: 0xA7A1,
	13206 - 12288: 0xA7A2,
	13207 - 12288: 0xA7A3,
	13208 - 12288: 0xA7A5,
	13209 - 12288: 0xA7AB,
	13210 - 12288: 0xA7AC,
	13211 - 12288: 0xA7AD,
	13212 - 12288: 0xA7AE,
	13213 - 12288: 0xA7AF,
	13214 - 12288: 0xA7B0,
	13215 - 12288: 0xA7B1,
	13216 - 12288: 0xA7B2,
	13217 - 12288: 0xA7B3,
	13218 - 12288: 0xA7B4,
	13219 - 12288: 0xA7A7,
	13220 - 12288: 0xA7A8,
	13221 - 12288: 0xA7A9,
	13222 - 12288: 0xA7AA,
	13223 - 12288: 0xA7BD,
	13224 - 12288: 0xA7BE,
	13225 - 12288: 0xA7E5,
	13226 - 12288: 0xA7E6,
	13227 - 12288: 0xA7E7,
	13228 - 12288: 0xA7E8,
	13229 - 12288: 0xA7E1,
	13230 - 12288: 0xA7E2,
	13231 - 12288: 0xA7E3,
	13232 - 12288: 0xA7BF,
	13233 - 12288: 0xA7C0,
	13234 - 12288: 0xA7C1,
	13235 - 12288: 0xA7C2,
	13236 - 12288: 0xA7C3,
	13237 - 12288: 0xA7C4,
	13238 - 12288: 0xA7C5,
	13239 - 12288: 0xA7C6,
	13240 - 12288: 0xA7C7,
	13241 - 12288: 0xA7C8,
	13242 - 12288: 0xA7CE,
	13243 - 12288: 0xA7CF,
	13244 - 12288: 0xA7D0,
	13245 - 12288: 0xA7D1,
	13246 - 12288: 0xA7D2,
	13247 - 12288: 0xA7D3,
	13248 - 12288: 0xA7DA,
	13249 - 12288: 0xA7DB,
	13250 - 12288: 0xA2E3,
	13251 - 12288: 0xA7EC,
	13252 - 12288: 0xA7A6,
	13253 - 12288: 0xA7E0,
	13254 - 12288: 0xA7EF,
	13255 - 12288: 0xA2E1,
	13256 - 12288: 0xA7BC,
	13257 - 12288: 0xA7ED,
	13258 - 12288: 0xA7B5,
	13263 - 12288: 0xA7B9,
	13264 - 12288: 0xA7EA,
	13267 - 12288: 0xA7EB,
	13270 - 12288: 0xA7DF,
	13272 - 12288: 0xA2E4,
	13275 - 12288: 0xA7E4,
	13276 - 12288: 0xA7EE,
	13277 - 12288: 0xA7E9,
}

const encode4Low, encode4High = 161, 1106

var encode4 = [...]uint16{
	161 - 161:  0xA2AE,
	164 - 161:  0xA2B4,
	167 - 161:  0xA1D7,
	168 - 161:  0xA1A7,
	170 - 161:  0xA8A3,
	173 - 161:  0xA1A9,
	174 - 161:  0xA2E7,
	176 - 161:  0xA1C6,
	177 - 161:  0xA1BE,
	178 - 161:  0xA9F7,
	179 - 161:  0xA9F8,
	180 - 161:  0xA2A5,
	182 - 161:  0xA2D2,
	183 - 161:  0xA1A4,
	184 - 161:  0xA2AC,
	185 - 161:  0xA9F6,
	186 - 161:  0xA8AC,
	188 - 161:  0xA8F9,
	189 - 161:  0xA8F6,
	190 - 161:  0xA8FA,
	191 - 161:  0xA2AF,
	198 - 161:  0xA8A1,
	208 - 161:  0xA8A2,
	215 - 161:  0xA1BF,
	216 - 161:  0xA8AA,
	222 - 161:  0xA8AD,
	223 - 161:  0xA9AC,
	230 - 161:  0xA9A1,
	240 - 161:  0xA9A3,
	247 - 161:  0xA1C0,
	248 - 161:  0xA9AA,
	254 - 161:  0xA9AD,
	273 - 161:  0xA9A2,
	294 - 161:  0xA8A4,
	295 - 161:  0xA9A4,
	305 - 161:  0xA9A5,
	306 - 161:  0xA8A6,
	307 - 161:  0xA9A6,
	312 - 161:  0xA9A7,
	319 - 161:  0xA8A8,
	320 - 161:  0xA9A8,
	321 - 161:  0xA8A9,
	322 - 161:  0xA9A9,
	329 - 161:  0xA9B0,
	330 - 161:  0xA8AF,
	331 - 161:  0xA9AF,
	338 - 161:  0xA8AB,
	339 - 161:  0xA9AB,
	358 - 161:  0xA8AE,
	359 - 161:  0xA9AE,
	711 - 161:  0xA2A7,
	720 - 161:  0xA2B0,
	728 - 161:  0xA2A8,
	729 - 161:  0xA2AB,
	730 - 161:  0xA2AA,
	731 - 161:  0xA2AD,
	733 - 161:  0xA2A9,
	913 - 161:  0xA5C1,
	914 - 161:  0xA5C2,
	915 - 161:  0xA5C3,
	916 - 161:  0xA5C4,
	917 - 161:  0xA5C5,
	918 - 161:  0xA5C6,
	919 - 161:  0xA5C7,
	920 - 161:  0xA5C8,
	921 - 161:  0xA5C9,
	922 - 161:  0xA5CA,
	923 - 161:  0xA5CB,
	924 - 161:  0xA5CC,
	925 - 161:  0xA5CD,
	926 - 161:  0xA5CE,
	927 - 161:  0xA5CF,
	928 - 161:  0xA5D0,
	929 - 161:  0xA5D1,
	931 - 161:  0xA5D2,
	932 - 161:  0xA5D3,
	933 - 161:  0xA5D4,
	934 - 161:  0xA5D5,
	935 - 161:  0xA5D6,
	936 - 161:  0xA5D7,
	937 - 161:  0xA5D8,
	945 - 161:  0xA5E1,
	946 - 161:  0xA5E2,
	947 - 161:  0xA5E3,
	948 - 161:  0xA5E4,
	949 - 161:  0xA5E5,
	950 - 161:  0xA5E6,
	951 - 161:  0xA5E7,
	952 - 161:  0xA5E8,
	953 - 161:  0xA5E9,
	954 - 161:  0xA5EA,
	955 - 161:  0xA5EB,
	956 - 161:  0xA5EC,
	957 - 161:  0xA5ED,
	958 - 161:  0xA5EE,
	959 - 161:  0xA5EF,
	960 - 161:  0xA5F0,
	961 - 161:  0xA5F1,
	963 - 161:  0xA5F2,
	964 - 161:  0xA5F3,
	965 - 161:  0xA5F4,
	966 - 161:  0xA5F5,
	967 - 161:  0xA5F6,
	968 - 161:  0xA5F7,
	969 - 161:  0xA5F8,
	1025 - 161: 0xACA7,
	1040 - 161: 0xACA1,
	1041 - 161: 0xACA2,
	1042 - 161: 0xACA3,
	1043 - 161: 0xACA4,
	1044 - 161: 0xACA5,
	1045 - 161: 0xACA6,
	1046 - 161: 0xACA8,
	1047 - 161: 0xACA9,
	1048 - 161: 0xACAA,
	1049 - 161: 0xACAB,
	1050 - 161: 0xACAC,
	1051 - 161: 0xACAD,
	1052 - 161: 0xACAE,
	1053 - 161: 0xACAF,
	1054 - 161: 0xACB0,
	1055 - 161: 0xACB1,
	1056 - 161: 0xACB2,
	1057 - 161: 0xACB3,
	1058 - 161: 0xACB4,
	1059 - 161: 0xACB5,
	1060 - 161: 0xACB6,
	1061 - 161: 0xACB7,
	1062 - 161: 0xACB8,
	1063 - 161: 0xACB9,
	1064 - 161: 0xACBA,
	1065 - 161: 0xACBB,
	1066 - 161: 0xACBC,
	1067 - 161: 0xACBD,
	1068 - 161: 0xACBE,
	1069 - 161: 0xACBF,
	1070 - 161: 0xACC0,
	1071 - 161: 0xACC1,
	1072 - 161: 0xACD1,
	1073 - 161: 0xACD2,
	1074 - 161: 0xACD3,
	1075 - 161: 0xACD4,
	1076 - 161: 0xACD5,
	1077 - 161: 0xACD6,
	1078 - 161: 0xACD8,
	1079 - 161: 0xACD9,
	1080 - 161: 0xACDA,
	1081 - 161: 0xACDB,
	1082 - 161: 0xACDC,
	1083 - 161: 0xACDD,
	1084 - 161: 0xACDE,
	1085 - 161: 0xACDF,
	1086 - 161: 0xACE0,
	1087 - 161: 0xACE1,
	1088 - 161: 0xACE2,
	1089 - 161: 0xACE3,
	1090 - 161: 0xACE4,
	1091 - 161: 0xACE5,
	1092 - 161: 0xACE6,
	1093 - 161: 0xACE7,
	1094 - 161: 0xACE8,
	1095 - 161: 0xACE9,
	1096 - 161: 0xACEA,
	1097 - 161: 0xACEB,
	1098 - 161: 0xACEC,
	1099 - 161: 0xACED,
	1100 - 161: 0xACEE,
	1101 - 161: 0xACEF,
	1102 - 161: 0xACF0,
	1103 - 161: 0xACF1,
	1105 - 161: 0xACD7,
}

const encode5Low, encode5High = 63744, 64012

var encode5 = [...]uint16{
	63744 - 63744: 0xCBD0,
	63745 - 63744: 0xCBD6,
	63746 - 63744: 0xCBE7,
	63747 - 63744: 0xCDCF,
	63748 - 63744: 0xCDE8,
	63749 - 63744: 0xCEAD,
	63750 - 63744: 0xCFFB,
	63751 - 63744: 0xD0A2,
	63752 - 63744: 0xD0B8,
	63753 - 63744: 0xD0D0,
	63754 - 63744: 0xD0DD,
	63755 - 63744: 0xD1D4,
	63756 - 63744: 0xD1D5,
	63757 - 63744: 0xD1D8,
	63758 - 63744: 0xD1DB,
	63759 - 63744: 0xD1DC,
	63760 - 63744: 0xD1DD,
	63761 - 63744: 0xD1DE,
	63762 - 63744: 0xD1DF,
	63763 - 63744: 0xD1E0,
	63764 - 63744: 0xD1E2,
	63765 - 63744: 0xD1E3,
	63766 - 63744: 0xD1E4,
	63767 - 63744: 0xD1E5,
	63768 - 63744: 0xD1E6,
	63769 - 63744: 0xD1E8,
	63770 - 63744: 0xD1E9,
	63771 - 63744: 0xD1EA,
	63772 - 63744: 0xD1EB,
	63773 - 63744: 0xD1ED,
	63774 - 63744: 0xD1EF,
	63775 - 63744: 0xD1F0,
	63776 - 63744: 0xD1F2,
	63777 - 63744: 0xD1F6,
	63778 - 63744: 0xD1FA,
	63779 - 63744: 0xD1FC,
	63780 - 63744: 0xD1FD,
	63781 - 63744: 0xD1FE,
	63782 - 63744: 0xD2A2,
	63783 - 63744: 0xD2A3,
	63784 - 63744: 0xD2A7,
	63785 - 63744: 0xD2A8,
	63786 - 63744: 0xD2A9,
	63787 - 63744: 0xD2AA,
	63788 - 63744: 0xD2AB,
	63789 - 63744: 0xD2AD,
	63790 - 63744: 0xD2B2,
	63791 - 63744: 0xD2BE,
	63792 - 63744: 0xD2C2,
	63793 - 63744: 0xD2C3,
	63794 - 63744: 0xD2C4,
	63795 - 63744: 0xD2C6,
	63796 - 63744: 0xD2C7,
	63797 - 63744: 0xD2C8,
	63798 - 63744: 0xD2C9,
	63799 - 63744: 0xD2CA,
	63800 - 63744: 0xD2CB,
	63801 - 63744: 0xD2CD,
	63802 - 63744: 0xD2CE,
	63803 - 63744: 0xD2CF,
	63804 - 63744: 0xD2D0,
	63805 - 63744: 0xD2D1,
	63806 - 63744: 0xD2D2,
	63807 - 63744: 0xD2D3,
	63808 - 63744: 0xD2D4,
	63809 - 63744: 0xD2D5,
	63810 - 63744: 0xD2D6,
	63811 - 63744: 0xD2D7,
	63812 - 63744: 0xD2D9,
	63813 - 63744: 0xD2DA,
	63814 - 63744: 0xD2DE,
	63815 - 63744: 0xD2DF,
	63816 - 63744: 0xD2E1,
	63817 - 63744: 0xD2E2,
	63818 - 63744: 0xD2E4,
	63819 - 63744: 0xD2E5,
	63820 - 63744: 0xD2E6,
	63821 - 63744: 0xD2E7,
	63822 - 63744: 0xD2E8,
	63823 - 63744: 0xD2E9,
	63824 - 63744: 0xD2EA,
	63825 - 63744: 0xD2EB,
	63826 - 63744: 0xD2F0,
	63827 - 63744: 0xD2F1,
	63828 - 63744: 0xD2F2,
	63829 - 63744: 0xD2F3,
	63830 - 63744: 0xD2F4,
	63831 - 63744: 0xD2F5,
	63832 - 63744: 0xD2F7,
	63833 - 63744: 0xD2F8,
	63834 - 63744: 0xD4E6,
	63835 - 63744: 0xD4FC,
	63836 - 63744: 0xD5A5,
	63837 - 63744: 0xD5AB,
	63838 - 63744: 0xD5AE,
	63839 - 63744: 0xD6B8,
	63840 - 63744: 0xD6CD,
	63841 - 63744: 0xD7CB,
	63842 - 63744: 0xD7E4,
	63843 - 63744: 0xDBC5,
	63844 - 63744: 0xDBE4,
	63845 - 63744: 0xDCA5,
	63846 - 63744: 0xDDA5,
	63847 - 63744: 0xDDD5,
	63848 - 63744: 0xDDF4,
	63849 - 63744: 0xDEFC,
	63850 - 63744: 0xDEFE,
	63851 - 63744: 0xDFB3,
	63852 - 63744: 0xDFE1,
	63853 - 63744: 0xDFE8,
	63854 - 63744: 0xE0F1,
	63855 - 63744: 0xE1AD,
	63856 - 63744: 0xE1ED,
	63857 - 63744: 0xE3F5,
	63858 - 63744: 0xE4A1,
	63859 - 63744: 0xE4A9,
	63860 - 63744: 0xE5AE,
	63861 - 63744: 0xE5B1,
	63862 - 63744: 0xE5B2,
	63863 - 63744: 0xE5B9,
	63864 - 63744: 0xE5BB,
	63865 - 63744: 0xE5BC,
	63866 - 63744: 0xE5C4,
	63867 - 63744: 0xE5CE,
	63868 - 63744: 0xE5D0,
	63869 - 63744: 0xE5D2,
	63870 - 63744: 0xE5D6,
	63871 - 63744: 0xE5FA,
	63872 - 63744: 0xE5FB,
	63873 - 63744: 0xE5FC,
	63874 - 63744: 0xE5FE,
	63875 - 63744: 0xE6A1,
	63876 - 63744: 0xE6A4,
	63877 - 63744: 0xE6A7,
	63878 - 63744: 0xE6AD,
	63879 - 63744: 0xE6AF,
	63880 - 63744: 0xE6B0,
	63881 - 63744: 0xE6B1,
	63882 - 63744: 0xE6B3,
	63883 - 63744: 0xE6B7,
	63884 - 63744: 0xE6B8,
	63885 - 63744: 0xE6BC,
	63886 - 63744: 0xE6C4,
	63887 - 63744: 0xE6C6,
	63888 - 63744: 0xE6C7,
	63889 - 63744: 0xE6CA,
	63890 - 63744: 0xE6D2,
	63891 - 63744: 0xE6D6,
	63892 - 63744: 0xE6D9,
	63893 - 63744: 0xE6DC,
	63894 - 63744: 0xE6DF,
	63895 - 63744: 0xE6E1,
	63896 - 63744: 0xE6E4,
	63897 - 63744: 0xE6E5,
	63898 - 63744: 0xE6E6,
	63899 - 63744: 0xE6E8,
	63900 - 63744: 0xE6EA,
	63901 - 63744: 0xE6EB,
	63902 - 63744: 0xE6EC,
	63903 - 63744: 0xE6EF,
	63904 - 63744: 0xE6F1,
	63905 - 63744: 0xE6F2,
	63906 - 63744: 0xE6F5,
	63907 - 63744: 0xE6F6,
	63908 - 63744: 0xE6F7,
	63909 - 63744: 0xE6F9,
	63910 - 63744: 0xE7A1,
	63911 - 63744: 0xE7A6,
	63912 - 63744: 0xE7A9,
	63913 - 63744: 0xE7AA,
	63914 - 63744: 0xE7AC,
	63915 - 63744: 0xE7AD,
	63916 - 63744: 0xE7B0,
	63917 - 63744: 0xE7BF,
	63918 - 63744: 0xE7C1,
	63919 - 63744: 0xE7C6,
	63920 - 63744: 0xE7C7,
	63921 - 63744: 0xE7CB,
	63922 - 63744: 0xE7CD,
	63923 - 63744: 0xE7CF,
	63924 - 63744: 0xE7D0,
	63925 - 63744: 0xE7D3,
	63926 - 63744: 0xE7DF,
	63927 - 63744: 0xE7E4,
	63928 - 63744: 0xE7E6,
	63929 - 63744: 0xE7F7,
	63930 - 63744: 0xE8E7,
	63931 - 63744: 0xE8E8,
	63932 - 63744: 0xE8F0,
	63933 - 63744: 0xE8F1,
	63934 - 63744: 0xE8F7,
	63935 - 63744: 0xE8F9,
	63936 - 63744: 0xE8FB,
	63937 - 63744: 0xE8FE,
	63938 - 63744: 0xE9A7,
	63939 - 63744: 0xE9AC,
	63940 - 63744: 0xE9CC,
	63941 - 63744: 0xE9F7,
	63942 - 63744: 0xEAC1,
	63943 - 63744: 0xEAE5,
	63944 - 63744: 0xEAF4,
	63945 - 63744: 0xEAF7,
	63946 - 63744: 0xEAFC,
	63947 - 63744: 0xEAFE,
	63948 - 63744: 0xEBA4,
	63949 - 63744: 0xEBA7,
	63950 - 63744: 0xEBA9,
	63951 - 63744: 0xEBAA,
	63952 - 63744: 0xEBBA,
	63953 - 63744: 0xEBBB,
	63954 - 63744: 0xEBBD,
	63955 - 63744: 0xEBC1,
	63956 - 63744: 0xEBC2,
	63957 - 63744: 0xEBC6,
	63958 - 63744: 0xEBC7,
	63959 - 63744: 0xEBCC,
	63960 - 63744: 0xEBCF,
	63961 - 63744: 0xEBD0,
	63962 - 63744: 0xEBD1,
	63963 - 63744: 0xEBD2,
	63964 - 63744: 0xEBD8,
	63965 - 63744: 0xECA6,
	63966 - 63744: 0xECA7,
	63967 - 63744: 0xECAA,
	63968 - 63744: 0xECAF,
	63969 - 63744: 0xECB0,
	63970 - 63744: 0xECB1,
	63971 - 63744: 0xECB2,
	63972 - 63744: 0xECB5,
	63973 - 63744: 0xECB8,
	63974 - 63744: 0xECBA,
	63975 - 63744: 0xECC0,
	63976 - 63744: 0xECC1,
	63977 - 63744: 0xECC5,
	63978 - 63744: 0xECC6,
	63979 - 63744: 0xECC9,
	63980 - 63744: 0xECCA,
	63981 - 63744: 0xECD5,
	63982 - 63744: 0xECDD,
	63983 - 63744: 0xECDE,
	63984 - 63744: 0xECE1,
	63985 - 63744: 0xECE4,
	63986 - 63744: 0xECE7,
	63987 - 63744: 0xECE8,
	63988 - 63744: 0xECF7,
	63989 - 63744: 0xECF8,
	63990 - 63744: 0xECFA,
	63991 - 63744: 0xEDA1,
	63992 - 63744: 0xEDA2,
	63993 - 63744: 0xEDA3,
	63994 - 63744: 0xEDEE,
	63995 - 63744: 0xEEDB,
	63996 - 63744: 0xF2BD,
	63997 - 63744: 0xF2FA,
	63998 - 63744: 0xF3B1,
	63999 - 63744: 0xF4A7,
	64000 - 63744: 0xF4EE,
	64001 - 63744: 0xF6F4,
	64002 - 63744: 0xF6F6,
	64003 - 63744: 0xF7B8,
	64004 - 63744: 0xF7C8,
	64005 - 63744: 0xF7D3,
	64006 - 63744: 0xF8DB,
	64007 - 63744: 0xF8F0,
	64008 - 63744: 0xFAA1,
	64009 - 63744: 0xFAA2,
	64010 - 63744: 0xFAE6,
	64011 - 63744: 0xFCA9,
}

const encode6Low, encode6High = 65281, 65511

var encode6 = [...]uint16{
	65281 - 65281: 0xA3A1,
	65282 - 65281: 0xA3A2,
	65283 - 65281: 0xA3A3,
	65284 - 65281: 0xA3A4,
	65285 - 65281: 0xA3A5,
	65286 - 65281: 0xA3A6,
	65287 - 65281: 0xA3A7,
	65288 - 65281: 0xA3A8,
	65289 - 65281: 0xA3A9,
	65290 - 65281: 0xA3AA,
	65291 - 65281: 0xA3AB,
	65292 - 65281: 0xA3AC,
	65293 - 65281: 0xA3AD,
	65294 - 65281: 0xA3AE,
	65295 - 65281: 0xA3AF,
	65296 - 65281: 0xA3B0,
	65297 - 65281: 0xA3B1,
	65298 - 65281: 0xA3B2,
	65299 - 65281: 0xA3B3,
	65300 - 65281: 0xA3B4,
	65301 - 65281: 0xA3B5,
	65302 - 65281: 0xA3B6,
	65303 - 65281: 0xA3B7,
	65304 - 65281: 0xA3B8,
	65305 - 65281: 0xA3B9,
	65306 - 65281: 0xA3BA,
	65307 - 65281: 0xA3BB,
	65308 - 65281: 0xA3BC,
	65309 - 65281: 0xA3BD,
	65310 - 65281: 0xA3BE,
	65311 - 65281: 0xA3BF,
	65312 - 65281: 0xA3C0,
	65313 - 65281: 0xA3C1,
	65314 - 65281: 0xA3C2,
	65315 - 65281: 0xA3C3,
	65316 - 65281: 0xA3C4,
	65317 - 65281: 0xA3C5,
	65318 - 65281: 0xA3C6,
	65319 - 65281: 0xA3C7,
	65320 - 65281: 0xA3C8,
	65321 - 65281: 0xA3C9,
	65322 - 65281: 0xA3CA,
	65323 - 65281: 0xA3CB,
	65324 - 65281: 0xA3CC,
	65325 - 65281: 0xA3CD,
	65326 - 65281: 0xA3CE,
	65327 - 65281: 0xA3CF,
	65328 - 65281: 0xA3D0,
	65329 - 65281: 0xA3D1,
	65330 - 65281: 0xA3D2,
	65331 - 65281: 0xA3D3,
	65332 - 65281: 0xA3D4,
	65333 - 65281: 0xA3D5,
	65334 - 65281: 0xA3D6,
	65335 - 65281: 0xA3D7,
	65336 - 65281: 0xA3D8,
	65337 - 65281: 0xA3D9,
	65338 - 65281: 0xA3DA,
	65339 - 65281: 0xA3DB,
	65340 - 65281: 0xA1AC,
	65341 - 65281: 0xA3DD,
	65342 - 65281: 0xA3DE,
	65343 - 65281: 0xA3DF,
	65344 - 65281: 0xA3E0,
	65345 - 65281: 0xA3E1,
	65346 - 65281: 0xA3E2,
	65347 - 65281: 0xA3E3,
	65348 - 65281: 0xA3E4,
	65349 - 65281: 0xA3E5,
	65350 - 65281: 0xA3E6,
	65351 - 65281: 0xA3E7,
	65352 - 65281: 0xA3E8,
	65353 - 65281: 0xA3E9,
	65354 - 65281: 0xA3EA,
	65355 - 65281: 0xA3EB,
	65356 - 65281: 0xA3EC,
	65357 - 65281: 0xA3ED,
	65358 - 65281: 0xA3EE,
	65359 - 65281: 0xA3EF,
	65360 - 65281: 0xA3F0,
	65361 - 65281: 0xA3F1,
	65362 - 65281: 0xA3F2,
	65363 - 65281: 0xA3F3,
	65364 - 65281: 0xA3F4,
	65365 - 65281: 0xA3F5,
	65366 - 65281: 0xA3F6,
	65367 - 65281: 0xA3F7,
	65368 - 65281: 0xA3F8,
	65369 - 65281: 0xA3F9,
	65370 - 65281: 0xA3FA,
	65371 - 65281: 0xA3FB,
	65372 - 65281: 0xA3FC,
	65373 - 65281: 0xA3FD,
	65374 - 65281: 0xA2A6,
	65504 - 65281: 0xA1CB,
	65505 - 65281: 0xA1CC,
	65506 - 65281: 0xA1FE,
	65507 - 65281: 0xA3FE,
	65509 - 65281: 0xA1CD,
	65510 - 65281: 0xA3DC,
}
