package redis

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Everyday ...
	Everyday DayOfWeek = "Everyday"
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
	// Weekend ...
	Weekend DayOfWeek = "Weekend"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Everyday, Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday, Weekend}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// Primary ...
	Primary KeyType = "Primary"
	// Secondary ...
	Secondary KeyType = "Secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{Primary, Secondary}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Disabled ...
	Disabled ProvisioningState = "Disabled"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Linking ...
	Linking ProvisioningState = "Linking"
	// Provisioning ...
	Provisioning ProvisioningState = "Provisioning"
	// RecoveringScaleFailure ...
	RecoveringScaleFailure ProvisioningState = "RecoveringScaleFailure"
	// Scaling ...
	Scaling ProvisioningState = "Scaling"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Unlinking ...
	Unlinking ProvisioningState = "Unlinking"
	// Unprovisioning ...
	Unprovisioning ProvisioningState = "Unprovisioning"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, Deleting, Disabled, Failed, Linking, Provisioning, RecoveringScaleFailure, Scaling, Succeeded, Unlinking, Unprovisioning, Updating}
}

// RebootType enumerates the values for reboot type.
type RebootType string

const (
	// AllNodes ...
	AllNodes RebootType = "AllNodes"
	// PrimaryNode ...
	PrimaryNode RebootType = "PrimaryNode"
	// SecondaryNode ...
	SecondaryNode RebootType = "SecondaryNode"
)

// PossibleRebootTypeValues returns an array of possible values for the RebootType const type.
func PossibleRebootTypeValues() []RebootType {
	return []RebootType{AllNodes, PrimaryNode, SecondaryNode}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRolePrimary, ReplicationRoleSecondary}
}

// SkuFamily enumerates the values for sku family.
type SkuFamily string

const (
	// C ...
	C SkuFamily = "C"
	// P ...
	P SkuFamily = "P"
)

// PossibleSkuFamilyValues returns an array of possible values for the SkuFamily const type.
func PossibleSkuFamilyValues() []SkuFamily {
	return []SkuFamily{C, P}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Premium, Standard}
}

// TLSVersion enumerates the values for tls version.
type TLSVersion string

const (
	// OneFullStopOne ...
	OneFullStopOne TLSVersion = "1.1"
	// OneFullStopTwo ...
	OneFullStopTwo TLSVersion = "1.2"
	// OneFullStopZero ...
	OneFullStopZero TLSVersion = "1.0"
)

// PossibleTLSVersionValues returns an array of possible values for the TLSVersion const type.
func PossibleTLSVersionValues() []TLSVersion {
	return []TLSVersion{OneFullStopOne, OneFullStopTwo, OneFullStopZero}
}

// AccessKeys redis cache access keys.
type AccessKeys struct {
	autorest.Response `json:"-"`
	// PrimaryKey - The current primary key that clients can use to authenticate with Redis cache.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The current secondary key that clients can use to authenticate with Redis cache.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
}

// CheckNameAvailabilityParameters parameters body to pass for resource name availability check.
type CheckNameAvailabilityParameters struct {
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type. The only legal value of this property for checking redis cache name availability is 'Microsoft.Cache/redis'.
	Type *string `json:"type,omitempty"`
}

// CommonProperties create/Update/Get common properties of the redis cache.
type CommonProperties struct {
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - A dictionary of tenant settings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// MinimumTLSVersion - Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinimumTLSVersion TLSVersion `json:"minimumTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for CommonProperties.
func (cp CommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = cp.RedisConfiguration
	}
	if cp.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = cp.EnableNonSslPort
	}
	if cp.TenantSettings != nil {
		objectMap["tenantSettings"] = cp.TenantSettings
	}
	if cp.ShardCount != nil {
		objectMap["shardCount"] = cp.ShardCount
	}
	if cp.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = cp.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// CreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CreateFuture) Result(client Client) (rt ResourceType, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.CreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("redis.CreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rt.Response.Response, err = future.GetResult(sender); err == nil && rt.Response.Response.StatusCode != http.StatusNoContent {
		rt, err = client.CreateResponder(rt.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redis.CreateFuture", "Result", rt.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateParameters parameters supplied to the Create Redis operation.
type CreateParameters struct {
	// CreateProperties - Redis cache properties.
	*CreateProperties `json:"properties,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreateParameters.
func (cp CreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.CreateProperties != nil {
		objectMap["properties"] = cp.CreateProperties
	}
	if cp.Zones != nil {
		objectMap["zones"] = cp.Zones
	}
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateParameters struct.
func (cp *CreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var createProperties CreateProperties
				err = json.Unmarshal(*v, &createProperties)
				if err != nil {
					return err
				}
				cp.CreateProperties = &createProperties
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				cp.Zones = &zones
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		}
	}

	return nil
}

// CreateProperties properties supplied to Create Redis operation.
type CreateProperties struct {
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - A dictionary of tenant settings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// MinimumTLSVersion - Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinimumTLSVersion TLSVersion `json:"minimumTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateProperties.
func (cp CreateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Sku != nil {
		objectMap["sku"] = cp.Sku
	}
	if cp.SubnetID != nil {
		objectMap["subnetId"] = cp.SubnetID
	}
	if cp.StaticIP != nil {
		objectMap["staticIP"] = cp.StaticIP
	}
	if cp.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = cp.RedisConfiguration
	}
	if cp.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = cp.EnableNonSslPort
	}
	if cp.TenantSettings != nil {
		objectMap["tenantSettings"] = cp.TenantSettings
	}
	if cp.ShardCount != nil {
		objectMap["shardCount"] = cp.ShardCount
	}
	if cp.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = cp.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeleteFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("redis.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ExportDataFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExportDataFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.ExportDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("redis.ExportDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportRDBParameters parameters for Redis export operation.
type ExportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Prefix - Prefix to use for exported files.
	Prefix *string `json:"prefix,omitempty"`
	// Container - Container name to export to.
	Container *string `json:"container,omitempty"`
}

// FirewallRule a firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses
// permitted to connect
type FirewallRule struct {
	autorest.Response `json:"-"`
	// FirewallRuleProperties - redis cache firewall rule properties
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	if fr.ID != nil {
		objectMap["id"] = fr.ID
	}
	if fr.Name != nil {
		objectMap["name"] = fr.Name
	}
	if fr.Type != nil {
		objectMap["type"] = fr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleCreateParameters parameters required for creating a firewall rule on redis cache.
type FirewallRuleCreateParameters struct {
	// FirewallRuleProperties - Properties required to create a firewall rule .
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRuleCreateParameters.
func (frcp FirewallRuleCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if frcp.FirewallRuleProperties != nil {
		objectMap["properties"] = frcp.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRuleCreateParameters struct.
func (frcp *FirewallRuleCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				frcp.FirewallRuleProperties = &firewallRuleProperties
			}
		}
	}

	return nil
}

// FirewallRuleListResult the response of list firewall rules Redis operation.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list firewall rules operation.
	Value *[]FirewallRule `json:"value,omitempty"`
	// NextLink - Link for next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FirewallRuleListResultIterator provides access to a complete listing of FirewallRule values.
type FirewallRuleListResultIterator struct {
	i    int
	page FirewallRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FirewallRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FirewallRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FirewallRuleListResultIterator) Response() FirewallRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FirewallRuleListResultIterator) Value() FirewallRule {
	if !iter.page.NotDone() {
		return FirewallRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (frlr FirewallRuleListResult) IsEmpty() bool {
	return frlr.Value == nil || len(*frlr.Value) == 0
}

// firewallRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (frlr FirewallRuleListResult) firewallRuleListResultPreparer() (*http.Request, error) {
	if frlr.NextLink == nil || len(to.String(frlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(frlr.NextLink)))
}

// FirewallRuleListResultPage contains a page of FirewallRule values.
type FirewallRuleListResultPage struct {
	fn   func(FirewallRuleListResult) (FirewallRuleListResult, error)
	frlr FirewallRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FirewallRuleListResultPage) Next() error {
	next, err := page.fn(page.frlr)
	if err != nil {
		return err
	}
	page.frlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FirewallRuleListResultPage) NotDone() bool {
	return !page.frlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FirewallRuleListResultPage) Response() FirewallRuleListResult {
	return page.frlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FirewallRuleListResultPage) Values() []FirewallRule {
	if page.frlr.IsEmpty() {
		return nil
	}
	return *page.frlr.Value
}

// FirewallRuleProperties specifies a range of IP addresses permitted to connect to the cache
type FirewallRuleProperties struct {
	// StartIP - lowest IP address included in the range
	StartIP *string `json:"startIP,omitempty"`
	// EndIP - highest IP address included in the range
	EndIP *string `json:"endIP,omitempty"`
}

// ForceRebootResponse response to force reboot for Redis cache.
type ForceRebootResponse struct {
	autorest.Response `json:"-"`
	// Message - Status message
	Message *string `json:"message,omitempty"`
}

// ImportDataFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ImportDataFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ImportDataFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.ImportDataFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("redis.ImportDataFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ImportRDBParameters parameters for Redis import operation.
type ImportRDBParameters struct {
	// Format - File format.
	Format *string `json:"format,omitempty"`
	// Files - files to import.
	Files *[]string `json:"files,omitempty"`
}

// LinkedServer linked server Id
type LinkedServer struct {
	// ID - Linked server Id.
	ID *string `json:"id,omitempty"`
}

// LinkedServerCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LinkedServerCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *LinkedServerCreateFuture) Result(client LinkedServerClient) (lswp LinkedServerWithProperties, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redis.LinkedServerCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("redis.LinkedServerCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lswp.Response.Response, err = future.GetResult(sender); err == nil && lswp.Response.Response.StatusCode != http.StatusNoContent {
		lswp, err = client.CreateResponder(lswp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "redis.LinkedServerCreateFuture", "Result", lswp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LinkedServerCreateParameters parameter required for creating a linked server to redis cache.
type LinkedServerCreateParameters struct {
	// LinkedServerCreateProperties - Properties required to create a linked server.
	*LinkedServerCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedServerCreateParameters.
func (lscp LinkedServerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lscp.LinkedServerCreateProperties != nil {
		objectMap["properties"] = lscp.LinkedServerCreateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkedServerCreateParameters struct.
func (lscp *LinkedServerCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedServerCreateProperties LinkedServerCreateProperties
				err = json.Unmarshal(*v, &linkedServerCreateProperties)
				if err != nil {
					return err
				}
				lscp.LinkedServerCreateProperties = &linkedServerCreateProperties
			}
		}
	}

	return nil
}

// LinkedServerCreateProperties create properties for a linked server
type LinkedServerCreateProperties struct {
	// LinkedRedisCacheID - Fully qualified resourceId of the linked redis cache.
	LinkedRedisCacheID *string `json:"linkedRedisCacheId,omitempty"`
	// LinkedRedisCacheLocation - Location of the linked redis cache.
	LinkedRedisCacheLocation *string `json:"linkedRedisCacheLocation,omitempty"`
	// ServerRole - Role of the linked server. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary'
	ServerRole ReplicationRole `json:"serverRole,omitempty"`
}

// LinkedServerProperties properties of a linked server to be returned in get/put response
type LinkedServerProperties struct {
	// ProvisioningState - Terminal state of the link between primary and secondary redis cache.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// LinkedRedisCacheID - Fully qualified resourceId of the linked redis cache.
	LinkedRedisCacheID *string `json:"linkedRedisCacheId,omitempty"`
	// LinkedRedisCacheLocation - Location of the linked redis cache.
	LinkedRedisCacheLocation *string `json:"linkedRedisCacheLocation,omitempty"`
	// ServerRole - Role of the linked server. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary'
	ServerRole ReplicationRole `json:"serverRole,omitempty"`
}

// LinkedServerWithProperties response to put/get linked server (with properties) for Redis cache.
type LinkedServerWithProperties struct {
	autorest.Response `json:"-"`
	// LinkedServerProperties - Properties of the linked server.
	*LinkedServerProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LinkedServerWithProperties.
func (lswp LinkedServerWithProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lswp.LinkedServerProperties != nil {
		objectMap["properties"] = lswp.LinkedServerProperties
	}
	if lswp.ID != nil {
		objectMap["id"] = lswp.ID
	}
	if lswp.Name != nil {
		objectMap["name"] = lswp.Name
	}
	if lswp.Type != nil {
		objectMap["type"] = lswp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkedServerWithProperties struct.
func (lswp *LinkedServerWithProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedServerProperties LinkedServerProperties
				err = json.Unmarshal(*v, &linkedServerProperties)
				if err != nil {
					return err
				}
				lswp.LinkedServerProperties = &linkedServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lswp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lswp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lswp.Type = &typeVar
			}
		}
	}

	return nil
}

// LinkedServerWithPropertiesList list of linked servers (with properites) of a Redis cache.
type LinkedServerWithPropertiesList struct {
	autorest.Response `json:"-"`
	// Value - List of linked servers (with properites) of a Redis cache.
	Value *[]LinkedServerWithProperties `json:"value,omitempty"`
	// NextLink - Link for next set.
	NextLink *string `json:"nextLink,omitempty"`
}

// LinkedServerWithPropertiesListIterator provides access to a complete listing of LinkedServerWithProperties
// values.
type LinkedServerWithPropertiesListIterator struct {
	i    int
	page LinkedServerWithPropertiesListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LinkedServerWithPropertiesListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LinkedServerWithPropertiesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LinkedServerWithPropertiesListIterator) Response() LinkedServerWithPropertiesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LinkedServerWithPropertiesListIterator) Value() LinkedServerWithProperties {
	if !iter.page.NotDone() {
		return LinkedServerWithProperties{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lswpl LinkedServerWithPropertiesList) IsEmpty() bool {
	return lswpl.Value == nil || len(*lswpl.Value) == 0
}

// linkedServerWithPropertiesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lswpl LinkedServerWithPropertiesList) linkedServerWithPropertiesListPreparer() (*http.Request, error) {
	if lswpl.NextLink == nil || len(to.String(lswpl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lswpl.NextLink)))
}

// LinkedServerWithPropertiesListPage contains a page of LinkedServerWithProperties values.
type LinkedServerWithPropertiesListPage struct {
	fn    func(LinkedServerWithPropertiesList) (LinkedServerWithPropertiesList, error)
	lswpl LinkedServerWithPropertiesList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LinkedServerWithPropertiesListPage) Next() error {
	next, err := page.fn(page.lswpl)
	if err != nil {
		return err
	}
	page.lswpl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LinkedServerWithPropertiesListPage) NotDone() bool {
	return !page.lswpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LinkedServerWithPropertiesListPage) Response() LinkedServerWithPropertiesList {
	return page.lswpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LinkedServerWithPropertiesListPage) Values() []LinkedServerWithProperties {
	if page.lswpl.IsEmpty() {
		return nil
	}
	return *page.lswpl.Value
}

// ListResult the response of list Redis operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Redis cache instances.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link for next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// NotificationListResponse the response of listUpgradeNotifications.
type NotificationListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of all notifications.
	Value *[]UpgradeNotification `json:"value,omitempty"`
	// NextLink - Link for next set of notifications.
	NextLink *string `json:"nextLink,omitempty"`
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that describes the operation.
type OperationDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list REST API operations. It contains a list of operations and a
// URL nextLink to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// PatchSchedule response to put/get patch schedules for Redis cache.
type PatchSchedule struct {
	autorest.Response `json:"-"`
	// ScheduleEntries - List of patch schedules for a Redis cache.
	*ScheduleEntries `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchSchedule.
func (ps PatchSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.ScheduleEntries != nil {
		objectMap["properties"] = ps.ScheduleEntries
	}
	if ps.ID != nil {
		objectMap["id"] = ps.ID
	}
	if ps.Name != nil {
		objectMap["name"] = ps.Name
	}
	if ps.Type != nil {
		objectMap["type"] = ps.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchSchedule struct.
func (ps *PatchSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduleEntries ScheduleEntries
				err = json.Unmarshal(*v, &scheduleEntries)
				if err != nil {
					return err
				}
				ps.ScheduleEntries = &scheduleEntries
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		}
	}

	return nil
}

// PatchScheduleListResult the response of list patch schedules Redis operation.
type PatchScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Results of the list patch schedules operation.
	Value *[]PatchSchedule `json:"value,omitempty"`
	// NextLink - Link for next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PatchScheduleListResultIterator provides access to a complete listing of PatchSchedule values.
type PatchScheduleListResultIterator struct {
	i    int
	page PatchScheduleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PatchScheduleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PatchScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PatchScheduleListResultIterator) Response() PatchScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PatchScheduleListResultIterator) Value() PatchSchedule {
	if !iter.page.NotDone() {
		return PatchSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pslr PatchScheduleListResult) IsEmpty() bool {
	return pslr.Value == nil || len(*pslr.Value) == 0
}

// patchScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pslr PatchScheduleListResult) patchScheduleListResultPreparer() (*http.Request, error) {
	if pslr.NextLink == nil || len(to.String(pslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pslr.NextLink)))
}

// PatchScheduleListResultPage contains a page of PatchSchedule values.
type PatchScheduleListResultPage struct {
	fn   func(PatchScheduleListResult) (PatchScheduleListResult, error)
	pslr PatchScheduleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PatchScheduleListResultPage) Next() error {
	next, err := page.fn(page.pslr)
	if err != nil {
		return err
	}
	page.pslr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PatchScheduleListResultPage) NotDone() bool {
	return !page.pslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PatchScheduleListResultPage) Response() PatchScheduleListResult {
	return page.pslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PatchScheduleListResultPage) Values() []PatchSchedule {
	if page.pslr.IsEmpty() {
		return nil
	}
	return *page.pslr.Value
}

// Properties properties of the redis cache.
type Properties struct {
	// RedisVersion - Redis version.
	RedisVersion *string `json:"redisVersion,omitempty"`
	// ProvisioningState - Redis instance provisioning status. Possible values include: 'Creating', 'Deleting', 'Disabled', 'Failed', 'Linking', 'Provisioning', 'RecoveringScaleFailure', 'Scaling', 'Succeeded', 'Unlinking', 'Unprovisioning', 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// HostName - Redis host name.
	HostName *string `json:"hostName,omitempty"`
	// Port - Redis non-SSL port.
	Port *int32 `json:"port,omitempty"`
	// SslPort - Redis SSL port.
	SslPort *int32 `json:"sslPort,omitempty"`
	// AccessKeys - The keys of the Redis cache - not set if this object is not the response to Create or Update redis cache
	AccessKeys *AccessKeys `json:"accessKeys,omitempty"`
	// LinkedServers - List of the linked servers associated with the cache
	LinkedServers *[]LinkedServer `json:"linkedServers,omitempty"`
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// SubnetID - The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subid}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
	SubnetID *string `json:"subnetId,omitempty"`
	// StaticIP - Static IP address. Required when deploying a Redis cache inside an existing Azure Virtual Network.
	StaticIP *string `json:"staticIP,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - A dictionary of tenant settings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// MinimumTLSVersion - Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinimumTLSVersion TLSVersion `json:"minimumTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.RedisVersion != nil {
		objectMap["redisVersion"] = p.RedisVersion
	}
	if p.ProvisioningState != "" {
		objectMap["provisioningState"] = p.ProvisioningState
	}
	if p.HostName != nil {
		objectMap["hostName"] = p.HostName
	}
	if p.Port != nil {
		objectMap["port"] = p.Port
	}
	if p.SslPort != nil {
		objectMap["sslPort"] = p.SslPort
	}
	if p.AccessKeys != nil {
		objectMap["accessKeys"] = p.AccessKeys
	}
	if p.LinkedServers != nil {
		objectMap["linkedServers"] = p.LinkedServers
	}
	if p.Sku != nil {
		objectMap["sku"] = p.Sku
	}
	if p.SubnetID != nil {
		objectMap["subnetId"] = p.SubnetID
	}
	if p.StaticIP != nil {
		objectMap["staticIP"] = p.StaticIP
	}
	if p.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = p.RedisConfiguration
	}
	if p.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = p.EnableNonSslPort
	}
	if p.TenantSettings != nil {
		objectMap["tenantSettings"] = p.TenantSettings
	}
	if p.ShardCount != nil {
		objectMap["shardCount"] = p.ShardCount
	}
	if p.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = p.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// RebootParameters specifies which Redis node(s) to reboot.
type RebootParameters struct {
	// RebootType - Which Redis node(s) to reboot. Depending on this value data loss is possible. Possible values include: 'PrimaryNode', 'SecondaryNode', 'AllNodes'
	RebootType RebootType `json:"rebootType,omitempty"`
	// ShardID - If clustering is enabled, the ID of the shard to be rebooted.
	ShardID *int32 `json:"shardId,omitempty"`
}

// RegenerateKeyParameters specifies which Redis access keys to reset.
type RegenerateKeyParameters struct {
	// KeyType - The Redis access key to regenerate. Possible values include: 'Primary', 'Secondary'
	KeyType KeyType `json:"keyType,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceType a single Redis item in List or Get Operation.
type ResourceType struct {
	autorest.Response `json:"-"`
	// Properties - Redis cache properties.
	*Properties `json:"properties,omitempty"`
	// Zones - A list of availability zones denoting where the resource needs to come from.
	Zones *[]string `json:"zones,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Properties != nil {
		objectMap["properties"] = rt.Properties
	}
	if rt.Zones != nil {
		objectMap["zones"] = rt.Zones
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Name != nil {
		objectMap["name"] = rt.Name
	}
	if rt.Type != nil {
		objectMap["type"] = rt.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				rt.Properties = &properties
			}
		case "zones":
			if v != nil {
				var zones []string
				err = json.Unmarshal(*v, &zones)
				if err != nil {
					return err
				}
				rt.Zones = &zones
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		}
	}

	return nil
}

// ScheduleEntries list of patch schedules for a Redis cache.
type ScheduleEntries struct {
	// ScheduleEntries - List of patch schedules for a Redis cache.
	ScheduleEntries *[]ScheduleEntry `json:"scheduleEntries,omitempty"`
}

// ScheduleEntry patch schedule entry for a Premium Redis Cache.
type ScheduleEntry struct {
	// DayOfWeek - Day of the week when a cache can be patched. Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday', 'Everyday', 'Weekend'
	DayOfWeek DayOfWeek `json:"dayOfWeek,omitempty"`
	// StartHourUtc - Start hour after which cache patching can start.
	StartHourUtc *int32 `json:"startHourUtc,omitempty"`
	// MaintenanceWindow - ISO8601 timespan specifying how much time cache patching can take.
	MaintenanceWindow *string `json:"maintenanceWindow,omitempty"`
}

// Sku SKU parameters supplied to the create Redis operation.
type Sku struct {
	// Name - The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium). Possible values include: 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Family - The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium). Possible values include: 'C', 'P'
	Family SkuFamily `json:"family,omitempty"`
	// Capacity - The size of the Redis cache to deploy. Valid values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4).
	Capacity *int32 `json:"capacity,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// UpdateParameters parameters supplied to the Update Redis operation.
type UpdateParameters struct {
	// UpdateProperties - Redis cache properties.
	*UpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateParameters.
func (up UpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.UpdateProperties != nil {
		objectMap["properties"] = up.UpdateProperties
	}
	if up.Tags != nil {
		objectMap["tags"] = up.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UpdateParameters struct.
func (up *UpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateProperties UpdateProperties
				err = json.Unmarshal(*v, &updateProperties)
				if err != nil {
					return err
				}
				up.UpdateProperties = &updateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				up.Tags = tags
			}
		}
	}

	return nil
}

// UpdateProperties patchable properties of the redis cache.
type UpdateProperties struct {
	// Sku - The SKU of the Redis cache to deploy.
	Sku *Sku `json:"sku,omitempty"`
	// RedisConfiguration - All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
	RedisConfiguration map[string]*string `json:"redisConfiguration"`
	// EnableNonSslPort - Specifies whether the non-ssl Redis server port (6379) is enabled.
	EnableNonSslPort *bool `json:"enableNonSslPort,omitempty"`
	// TenantSettings - A dictionary of tenant settings
	TenantSettings map[string]*string `json:"tenantSettings"`
	// ShardCount - The number of shards to be created on a Premium Cluster Cache.
	ShardCount *int32 `json:"shardCount,omitempty"`
	// MinimumTLSVersion - Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinimumTLSVersion TLSVersion `json:"minimumTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateProperties.
func (up UpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.Sku != nil {
		objectMap["sku"] = up.Sku
	}
	if up.RedisConfiguration != nil {
		objectMap["redisConfiguration"] = up.RedisConfiguration
	}
	if up.EnableNonSslPort != nil {
		objectMap["enableNonSslPort"] = up.EnableNonSslPort
	}
	if up.TenantSettings != nil {
		objectMap["tenantSettings"] = up.TenantSettings
	}
	if up.ShardCount != nil {
		objectMap["shardCount"] = up.ShardCount
	}
	if up.MinimumTLSVersion != "" {
		objectMap["minimumTlsVersion"] = up.MinimumTLSVersion
	}
	return json.Marshal(objectMap)
}

// UpgradeNotification properties of upgrade notification.
type UpgradeNotification struct {
	// Name - Name of upgrade notification.
	Name *string `json:"name,omitempty"`
	// Timestamp - Timestamp when upgrade notification occured.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// UpsellNotification - Details about this upgrade notification
	UpsellNotification map[string]*string `json:"upsellNotification"`
}

// MarshalJSON is the custom marshaler for UpgradeNotification.
func (un UpgradeNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if un.Name != nil {
		objectMap["name"] = un.Name
	}
	if un.Timestamp != nil {
		objectMap["timestamp"] = un.Timestamp
	}
	if un.UpsellNotification != nil {
		objectMap["upsellNotification"] = un.UpsellNotification
	}
	return json.Marshal(objectMap)
}
