// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package security

import original "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/2017-08-01-preview/security"

type AdvancedThreatProtectionClient = original.AdvancedThreatProtectionClient
type AlertsClient = original.AlertsClient
type AutoProvisioningSettingsClient = original.AutoProvisioningSettingsClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type CompliancesClient = original.CompliancesClient
type ContactsClient = original.ContactsClient
type DiscoveredSecuritySolutionsClient = original.DiscoveredSecuritySolutionsClient
type ExternalSecuritySolutionsClient = original.ExternalSecuritySolutionsClient
type InformationProtectionPoliciesClient = original.InformationProtectionPoliciesClient
type JitNetworkAccessPoliciesClient = original.JitNetworkAccessPoliciesClient
type LocationsClient = original.LocationsClient
type AadConnectivityState = original.AadConnectivityState

const (
	Connected   AadConnectivityState = original.Connected
	Discovered  AadConnectivityState = original.Discovered
	NotLicensed AadConnectivityState = original.NotLicensed
)

type AlertNotifications = original.AlertNotifications

const (
	Off AlertNotifications = original.Off
	On  AlertNotifications = original.On
)

type AlertsToAdmins = original.AlertsToAdmins

const (
	AlertsToAdminsOff AlertsToAdmins = original.AlertsToAdminsOff
	AlertsToAdminsOn  AlertsToAdmins = original.AlertsToAdminsOn
)

type AutoProvision = original.AutoProvision

const (
	AutoProvisionOff AutoProvision = original.AutoProvisionOff
	AutoProvisionOn  AutoProvision = original.AutoProvisionOn
)

type ExternalSecuritySolutionKind = original.ExternalSecuritySolutionKind

const (
	AAD ExternalSecuritySolutionKind = original.AAD
	ATA ExternalSecuritySolutionKind = original.ATA
	CEF ExternalSecuritySolutionKind = original.CEF
)

type Family = original.Family

const (
	Ngfw    Family = original.Ngfw
	SaasWaf Family = original.SaasWaf
	Va      Family = original.Va
	Waf     Family = original.Waf
)

type KindEnum = original.KindEnum

const (
	KindDataExportSetting KindEnum = original.KindDataExportSetting
	KindSetting           KindEnum = original.KindSetting
)

type KindEnum1 = original.KindEnum1

const (
	KindAAD                      KindEnum1 = original.KindAAD
	KindATA                      KindEnum1 = original.KindATA
	KindCEF                      KindEnum1 = original.KindCEF
	KindExternalSecuritySolution KindEnum1 = original.KindExternalSecuritySolution
)

type PricingTier = original.PricingTier

const (
	Free     PricingTier = original.Free
	Standard PricingTier = original.Standard
)

type Protocol = original.Protocol

const (
	All Protocol = original.All
	TCP Protocol = original.TCP
	UDP Protocol = original.UDP
)

type SettingKind = original.SettingKind

const (
	SettingKindDataExportSetting SettingKind = original.SettingKindDataExportSetting
)

type Status = original.Status

const (
	Initiated Status = original.Initiated
	Revoked   Status = original.Revoked
)

type StatusReason = original.StatusReason

const (
	Expired               StatusReason = original.Expired
	NewerRequestInitiated StatusReason = original.NewerRequestInitiated
	UserRequested         StatusReason = original.UserRequested
)

type AadConnectivityState1 = original.AadConnectivityState1
type AadExternalSecuritySolution = original.AadExternalSecuritySolution
type AadSolutionProperties = original.AadSolutionProperties
type AdvancedThreatProtectionProperties = original.AdvancedThreatProtectionProperties
type AdvancedThreatProtectionSetting = original.AdvancedThreatProtectionSetting
type Alert = original.Alert
type AlertConfidenceReason = original.AlertConfidenceReason
type AlertEntity = original.AlertEntity
type AlertList = original.AlertList
type AlertListIterator = original.AlertListIterator
type AlertListPage = original.AlertListPage
type AlertProperties = original.AlertProperties
type AscLocation = original.AscLocation
type AscLocationList = original.AscLocationList
type AscLocationListIterator = original.AscLocationListIterator
type AscLocationListPage = original.AscLocationListPage
type AtaExternalSecuritySolution = original.AtaExternalSecuritySolution
type AtaSolutionProperties = original.AtaSolutionProperties
type AutoProvisioningSetting = original.AutoProvisioningSetting
type AutoProvisioningSettingList = original.AutoProvisioningSettingList
type AutoProvisioningSettingListIterator = original.AutoProvisioningSettingListIterator
type AutoProvisioningSettingListPage = original.AutoProvisioningSettingListPage
type AutoProvisioningSettingProperties = original.AutoProvisioningSettingProperties
type CefExternalSecuritySolution = original.CefExternalSecuritySolution
type CefSolutionProperties = original.CefSolutionProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type Compliance = original.Compliance
type ComplianceList = original.ComplianceList
type ComplianceListIterator = original.ComplianceListIterator
type ComplianceListPage = original.ComplianceListPage
type ComplianceProperties = original.ComplianceProperties
type ComplianceSegment = original.ComplianceSegment
type ConnectedWorkspace = original.ConnectedWorkspace
type Contact = original.Contact
type ContactList = original.ContactList
type ContactListIterator = original.ContactListIterator
type ContactListPage = original.ContactListPage
type ContactProperties = original.ContactProperties
type DataExportSetting = original.DataExportSetting
type DataExportSettingProperties = original.DataExportSettingProperties
type DiscoveredSecuritySolution = original.DiscoveredSecuritySolution
type DiscoveredSecuritySolutionList = original.DiscoveredSecuritySolutionList
type DiscoveredSecuritySolutionListIterator = original.DiscoveredSecuritySolutionListIterator
type DiscoveredSecuritySolutionListPage = original.DiscoveredSecuritySolutionListPage
type DiscoveredSecuritySolutionProperties = original.DiscoveredSecuritySolutionProperties
type BasicExternalSecuritySolution = original.BasicExternalSecuritySolution
type ExternalSecuritySolution = original.ExternalSecuritySolution
type ExternalSecuritySolutionKind1 = original.ExternalSecuritySolutionKind1
type ExternalSecuritySolutionList = original.ExternalSecuritySolutionList
type ExternalSecuritySolutionListIterator = original.ExternalSecuritySolutionListIterator
type ExternalSecuritySolutionListPage = original.ExternalSecuritySolutionListPage
type ExternalSecuritySolutionModel = original.ExternalSecuritySolutionModel
type ExternalSecuritySolutionProperties = original.ExternalSecuritySolutionProperties
type InformationProtectionKeyword = original.InformationProtectionKeyword
type InformationProtectionPolicy = original.InformationProtectionPolicy
type InformationProtectionPolicyList = original.InformationProtectionPolicyList
type InformationProtectionPolicyListIterator = original.InformationProtectionPolicyListIterator
type InformationProtectionPolicyListPage = original.InformationProtectionPolicyListPage
type InformationProtectionPolicyProperties = original.InformationProtectionPolicyProperties
type InformationType = original.InformationType
type JitNetworkAccessPoliciesList = original.JitNetworkAccessPoliciesList
type JitNetworkAccessPoliciesListIterator = original.JitNetworkAccessPoliciesListIterator
type JitNetworkAccessPoliciesListPage = original.JitNetworkAccessPoliciesListPage
type JitNetworkAccessPolicy = original.JitNetworkAccessPolicy
type JitNetworkAccessPolicyInitiatePort = original.JitNetworkAccessPolicyInitiatePort
type JitNetworkAccessPolicyInitiateRequest = original.JitNetworkAccessPolicyInitiateRequest
type JitNetworkAccessPolicyInitiateVirtualMachine = original.JitNetworkAccessPolicyInitiateVirtualMachine
type JitNetworkAccessPolicyProperties = original.JitNetworkAccessPolicyProperties
type JitNetworkAccessPolicyVirtualMachine = original.JitNetworkAccessPolicyVirtualMachine
type JitNetworkAccessPortRule = original.JitNetworkAccessPortRule
type JitNetworkAccessRequest = original.JitNetworkAccessRequest
type JitNetworkAccessRequestPort = original.JitNetworkAccessRequestPort
type JitNetworkAccessRequestVirtualMachine = original.JitNetworkAccessRequestVirtualMachine
type Kind = original.Kind
type Location = original.Location
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type Pricing = original.Pricing
type PricingList = original.PricingList
type PricingListIterator = original.PricingListIterator
type PricingListPage = original.PricingListPage
type PricingProperties = original.PricingProperties
type Resource = original.Resource
type SensitivityLabel = original.SensitivityLabel
type BasicSetting = original.BasicSetting
type Setting = original.Setting
type SettingKind1 = original.SettingKind1
type SettingModel = original.SettingModel
type SettingsList = original.SettingsList
type SettingsListIterator = original.SettingsListIterator
type SettingsListPage = original.SettingsListPage
type Task = original.Task
type TaskList = original.TaskList
type TaskListIterator = original.TaskListIterator
type TaskListPage = original.TaskListPage
type TaskParameters = original.TaskParameters
type TaskProperties = original.TaskProperties
type TopologyList = original.TopologyList
type TopologyListIterator = original.TopologyListIterator
type TopologyListPage = original.TopologyListPage
type TopologyResource = original.TopologyResource
type TopologyResourceProperties = original.TopologyResourceProperties
type TopologySingleResource = original.TopologySingleResource
type TopologySingleResourceChild = original.TopologySingleResourceChild
type TopologySingleResourceParent = original.TopologySingleResourceParent
type WorkspaceSetting = original.WorkspaceSetting
type WorkspaceSettingList = original.WorkspaceSettingList
type WorkspaceSettingListIterator = original.WorkspaceSettingListIterator
type WorkspaceSettingListPage = original.WorkspaceSettingListPage
type WorkspaceSettingProperties = original.WorkspaceSettingProperties
type OperationsClient = original.OperationsClient
type PricingsClient = original.PricingsClient
type SettingsClient = original.SettingsClient
type TasksClient = original.TasksClient
type TopologyClient = original.TopologyClient
type WorkspaceSettingsClient = original.WorkspaceSettingsClient

func NewAdvancedThreatProtectionClient(subscriptionID string, ascLocation string) AdvancedThreatProtectionClient {
	return original.NewAdvancedThreatProtectionClient(subscriptionID, ascLocation)
}
func NewAdvancedThreatProtectionClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) AdvancedThreatProtectionClient {
	return original.NewAdvancedThreatProtectionClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewAlertsClient(subscriptionID string, ascLocation string) AlertsClient {
	return original.NewAlertsClient(subscriptionID, ascLocation)
}
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) AlertsClient {
	return original.NewAlertsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewAutoProvisioningSettingsClient(subscriptionID string, ascLocation string) AutoProvisioningSettingsClient {
	return original.NewAutoProvisioningSettingsClient(subscriptionID, ascLocation)
}
func NewAutoProvisioningSettingsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) AutoProvisioningSettingsClient {
	return original.NewAutoProvisioningSettingsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func New(subscriptionID string, ascLocation string) BaseClient {
	return original.New(subscriptionID, ascLocation)
}
func NewWithBaseURI(baseURI string, subscriptionID string, ascLocation string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewCompliancesClient(subscriptionID string, ascLocation string) CompliancesClient {
	return original.NewCompliancesClient(subscriptionID, ascLocation)
}
func NewCompliancesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) CompliancesClient {
	return original.NewCompliancesClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewContactsClient(subscriptionID string, ascLocation string) ContactsClient {
	return original.NewContactsClient(subscriptionID, ascLocation)
}
func NewContactsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) ContactsClient {
	return original.NewContactsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewDiscoveredSecuritySolutionsClient(subscriptionID string, ascLocation string) DiscoveredSecuritySolutionsClient {
	return original.NewDiscoveredSecuritySolutionsClient(subscriptionID, ascLocation)
}
func NewDiscoveredSecuritySolutionsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) DiscoveredSecuritySolutionsClient {
	return original.NewDiscoveredSecuritySolutionsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewExternalSecuritySolutionsClient(subscriptionID string, ascLocation string) ExternalSecuritySolutionsClient {
	return original.NewExternalSecuritySolutionsClient(subscriptionID, ascLocation)
}
func NewExternalSecuritySolutionsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) ExternalSecuritySolutionsClient {
	return original.NewExternalSecuritySolutionsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewInformationProtectionPoliciesClient(subscriptionID string, ascLocation string) InformationProtectionPoliciesClient {
	return original.NewInformationProtectionPoliciesClient(subscriptionID, ascLocation)
}
func NewInformationProtectionPoliciesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) InformationProtectionPoliciesClient {
	return original.NewInformationProtectionPoliciesClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewJitNetworkAccessPoliciesClient(subscriptionID string, ascLocation string) JitNetworkAccessPoliciesClient {
	return original.NewJitNetworkAccessPoliciesClient(subscriptionID, ascLocation)
}
func NewJitNetworkAccessPoliciesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) JitNetworkAccessPoliciesClient {
	return original.NewJitNetworkAccessPoliciesClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewLocationsClient(subscriptionID string, ascLocation string) LocationsClient {
	return original.NewLocationsClient(subscriptionID, ascLocation)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func PossibleAadConnectivityStateValues() []AadConnectivityState {
	return original.PossibleAadConnectivityStateValues()
}
func PossibleAlertNotificationsValues() []AlertNotifications {
	return original.PossibleAlertNotificationsValues()
}
func PossibleAlertsToAdminsValues() []AlertsToAdmins {
	return original.PossibleAlertsToAdminsValues()
}
func PossibleAutoProvisionValues() []AutoProvision {
	return original.PossibleAutoProvisionValues()
}
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return original.PossibleExternalSecuritySolutionKindValues()
}
func PossibleFamilyValues() []Family {
	return original.PossibleFamilyValues()
}
func PossibleKindEnumValues() []KindEnum {
	return original.PossibleKindEnumValues()
}
func PossibleKindEnum1Values() []KindEnum1 {
	return original.PossibleKindEnum1Values()
}
func PossiblePricingTierValues() []PricingTier {
	return original.PossiblePricingTierValues()
}
func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}
func PossibleSettingKindValues() []SettingKind {
	return original.PossibleSettingKindValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleStatusReasonValues() []StatusReason {
	return original.PossibleStatusReasonValues()
}
func NewOperationsClient(subscriptionID string, ascLocation string) OperationsClient {
	return original.NewOperationsClient(subscriptionID, ascLocation)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewPricingsClient(subscriptionID string, ascLocation string) PricingsClient {
	return original.NewPricingsClient(subscriptionID, ascLocation)
}
func NewPricingsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) PricingsClient {
	return original.NewPricingsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewSettingsClient(subscriptionID string, ascLocation string) SettingsClient {
	return original.NewSettingsClient(subscriptionID, ascLocation)
}
func NewSettingsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) SettingsClient {
	return original.NewSettingsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewTasksClient(subscriptionID string, ascLocation string) TasksClient {
	return original.NewTasksClient(subscriptionID, ascLocation)
}
func NewTasksClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) TasksClient {
	return original.NewTasksClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func NewTopologyClient(subscriptionID string, ascLocation string) TopologyClient {
	return original.NewTopologyClient(subscriptionID, ascLocation)
}
func NewTopologyClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) TopologyClient {
	return original.NewTopologyClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
func NewWorkspaceSettingsClient(subscriptionID string, ascLocation string) WorkspaceSettingsClient {
	return original.NewWorkspaceSettingsClient(subscriptionID, ascLocation)
}
func NewWorkspaceSettingsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) WorkspaceSettingsClient {
	return original.NewWorkspaceSettingsClientWithBaseURI(baseURI, subscriptionID, ascLocation)
}
