package customimagesearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// Freshness enumerates the values for freshness.
type Freshness string

const (
	// Day ...
	Day Freshness = "Day"
	// Month ...
	Month Freshness = "Month"
	// Week ...
	Week Freshness = "Week"
)

// PossibleFreshnessValues returns an array of possible values for the Freshness const type.
func PossibleFreshnessValues() []Freshness {
	return []Freshness{Day, Month, Week}
}

// ImageAspect enumerates the values for image aspect.
type ImageAspect string

const (
	// All ...
	All ImageAspect = "All"
	// Square ...
	Square ImageAspect = "Square"
	// Tall ...
	Tall ImageAspect = "Tall"
	// Wide ...
	Wide ImageAspect = "Wide"
)

// PossibleImageAspectValues returns an array of possible values for the ImageAspect const type.
func PossibleImageAspectValues() []ImageAspect {
	return []ImageAspect{All, Square, Tall, Wide}
}

// ImageColor enumerates the values for image color.
type ImageColor string

const (
	// Black ...
	Black ImageColor = "Black"
	// Blue ...
	Blue ImageColor = "Blue"
	// Brown ...
	Brown ImageColor = "Brown"
	// ColorOnly ...
	ColorOnly ImageColor = "ColorOnly"
	// Gray ...
	Gray ImageColor = "Gray"
	// Green ...
	Green ImageColor = "Green"
	// Monochrome ...
	Monochrome ImageColor = "Monochrome"
	// Orange ...
	Orange ImageColor = "Orange"
	// Pink ...
	Pink ImageColor = "Pink"
	// Purple ...
	Purple ImageColor = "Purple"
	// Red ...
	Red ImageColor = "Red"
	// Teal ...
	Teal ImageColor = "Teal"
	// White ...
	White ImageColor = "White"
	// Yellow ...
	Yellow ImageColor = "Yellow"
)

// PossibleImageColorValues returns an array of possible values for the ImageColor const type.
func PossibleImageColorValues() []ImageColor {
	return []ImageColor{Black, Blue, Brown, ColorOnly, Gray, Green, Monochrome, Orange, Pink, Purple, Red, Teal, White, Yellow}
}

// ImageContent enumerates the values for image content.
type ImageContent string

const (
	// Face ...
	Face ImageContent = "Face"
	// Portrait ...
	Portrait ImageContent = "Portrait"
)

// PossibleImageContentValues returns an array of possible values for the ImageContent const type.
func PossibleImageContentValues() []ImageContent {
	return []ImageContent{Face, Portrait}
}

// ImageLicense enumerates the values for image license.
type ImageLicense string

const (
	// ImageLicenseAll ...
	ImageLicenseAll ImageLicense = "All"
	// ImageLicenseAny ...
	ImageLicenseAny ImageLicense = "Any"
	// ImageLicenseModify ...
	ImageLicenseModify ImageLicense = "Modify"
	// ImageLicenseModifyCommercially ...
	ImageLicenseModifyCommercially ImageLicense = "ModifyCommercially"
	// ImageLicensePublic ...
	ImageLicensePublic ImageLicense = "Public"
	// ImageLicenseShare ...
	ImageLicenseShare ImageLicense = "Share"
	// ImageLicenseShareCommercially ...
	ImageLicenseShareCommercially ImageLicense = "ShareCommercially"
)

// PossibleImageLicenseValues returns an array of possible values for the ImageLicense const type.
func PossibleImageLicenseValues() []ImageLicense {
	return []ImageLicense{ImageLicenseAll, ImageLicenseAny, ImageLicenseModify, ImageLicenseModifyCommercially, ImageLicensePublic, ImageLicenseShare, ImageLicenseShareCommercially}
}

// ImageSize enumerates the values for image size.
type ImageSize string

const (
	// ImageSizeAll ...
	ImageSizeAll ImageSize = "All"
	// ImageSizeLarge ...
	ImageSizeLarge ImageSize = "Large"
	// ImageSizeMedium ...
	ImageSizeMedium ImageSize = "Medium"
	// ImageSizeSmall ...
	ImageSizeSmall ImageSize = "Small"
	// ImageSizeWallpaper ...
	ImageSizeWallpaper ImageSize = "Wallpaper"
)

// PossibleImageSizeValues returns an array of possible values for the ImageSize const type.
func PossibleImageSizeValues() []ImageSize {
	return []ImageSize{ImageSizeAll, ImageSizeLarge, ImageSizeMedium, ImageSizeSmall, ImageSizeWallpaper}
}

// ImageType enumerates the values for image type.
type ImageType string

const (
	// AnimatedGif ...
	AnimatedGif ImageType = "AnimatedGif"
	// Clipart ...
	Clipart ImageType = "Clipart"
	// Line ...
	Line ImageType = "Line"
	// Photo ...
	Photo ImageType = "Photo"
	// Shopping ...
	Shopping ImageType = "Shopping"
	// Transparent ...
	Transparent ImageType = "Transparent"
)

// PossibleImageTypeValues returns an array of possible values for the ImageType const type.
func PossibleImageTypeValues() []ImageType {
	return []ImageType{AnimatedGif, Clipart, Line, Photo, Shopping, Transparent}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAnswer ...
	TypeAnswer Type = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeImageObject ...
	TypeImageObject Type = "ImageObject"
	// TypeImages ...
	TypeImages Type = "Images"
	// TypeMediaObject ...
	TypeMediaObject Type = "MediaObject"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer Type = "SearchResultsAnswer"
	// TypeThing ...
	TypeThing Type = "Thing"
	// TypeWebPage ...
	TypeWebPage Type = "WebPage"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAnswer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeImageObject, TypeImages, TypeMediaObject, TypeResponse, TypeResponseBase, TypeSearchResultsAnswer, TypeThing, TypeWebPage}
}

// BasicAnswer defines an answer.
type BasicAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer defines an answer.
type Answer struct {
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	objectMap := make(map[string]interface{})
	if a.ReadLink != nil {
		objectMap["readLink"] = a.ReadLink
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Answer.
func (a Answer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsWebPage() (*WebPage, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type CreativeWork struct {
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = cw.ThumbnailURL
	}
	if cw.Provider != nil {
		objectMap["provider"] = cw.Provider
	}
	if cw.Text != nil {
		objectMap["text"] = cw.Text
	}
	if cw.Name != nil {
		objectMap["name"] = cw.Name
	}
	if cw.URL != nil {
		objectMap["url"] = cw.URL
	}
	if cw.Image != nil {
		objectMap["image"] = cw.Image
	}
	if cw.Description != nil {
		objectMap["description"] = cw.Description
	}
	if cw.AlternateName != nil {
		objectMap["alternateName"] = cw.AlternateName
	}
	if cw.BingID != nil {
		objectMap["bingId"] = cw.BingID
	}
	if cw.ReadLink != nil {
		objectMap["readLink"] = cw.ReadLink
	}
	if cw.WebSearchURL != nil {
		objectMap["webSearchUrl"] = cw.WebSearchURL
	}
	if cw.ID != nil {
		objectMap["id"] = cw.ID
	}
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				cw.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cw.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				cw.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cw.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				cw.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				cw.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				cw.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.ReadLink != nil {
		objectMap["readLink"] = er.ReadLink
	}
	if er.WebSearchURL != nil {
		objectMap["webSearchUrl"] = er.WebSearchURL
	}
	if er.ID != nil {
		objectMap["id"] = er.ID
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
	// ImageInsightsToken - The token that you use in a subsequent call to the Image Search API to get additional information about the image. For information about using this token, see the insightsToken query parameter.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// ImageID - Unique Id for the image
	ImageID *string `json:"imageId,omitempty"`
	// AccentColor - A three-byte hexadecimal number that represents the color that dominates the image. Use the color as the temporary background in your client until the image is loaded.
	AccentColor *string `json:"accentColor,omitempty"`
	// VisualWords - Visual representation of the image. Used for getting more sizes
	VisualWords *string `json:"visualWords,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	objectMap := make(map[string]interface{})
	if ioVar.Thumbnail != nil {
		objectMap["thumbnail"] = ioVar.Thumbnail
	}
	if ioVar.ImageInsightsToken != nil {
		objectMap["imageInsightsToken"] = ioVar.ImageInsightsToken
	}
	if ioVar.ImageID != nil {
		objectMap["imageId"] = ioVar.ImageID
	}
	if ioVar.AccentColor != nil {
		objectMap["accentColor"] = ioVar.AccentColor
	}
	if ioVar.VisualWords != nil {
		objectMap["visualWords"] = ioVar.VisualWords
	}
	if ioVar.ContentURL != nil {
		objectMap["contentUrl"] = ioVar.ContentURL
	}
	if ioVar.HostPageURL != nil {
		objectMap["hostPageUrl"] = ioVar.HostPageURL
	}
	if ioVar.ContentSize != nil {
		objectMap["contentSize"] = ioVar.ContentSize
	}
	if ioVar.EncodingFormat != nil {
		objectMap["encodingFormat"] = ioVar.EncodingFormat
	}
	if ioVar.HostPageDisplayURL != nil {
		objectMap["hostPageDisplayUrl"] = ioVar.HostPageDisplayURL
	}
	if ioVar.Width != nil {
		objectMap["width"] = ioVar.Width
	}
	if ioVar.Height != nil {
		objectMap["height"] = ioVar.Height
	}
	if ioVar.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ioVar.ThumbnailURL
	}
	if ioVar.Provider != nil {
		objectMap["provider"] = ioVar.Provider
	}
	if ioVar.Text != nil {
		objectMap["text"] = ioVar.Text
	}
	if ioVar.Name != nil {
		objectMap["name"] = ioVar.Name
	}
	if ioVar.URL != nil {
		objectMap["url"] = ioVar.URL
	}
	if ioVar.Image != nil {
		objectMap["image"] = ioVar.Image
	}
	if ioVar.Description != nil {
		objectMap["description"] = ioVar.Description
	}
	if ioVar.AlternateName != nil {
		objectMap["alternateName"] = ioVar.AlternateName
	}
	if ioVar.BingID != nil {
		objectMap["bingId"] = ioVar.BingID
	}
	if ioVar.ReadLink != nil {
		objectMap["readLink"] = ioVar.ReadLink
	}
	if ioVar.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ioVar.WebSearchURL
	}
	if ioVar.ID != nil {
		objectMap["id"] = ioVar.ID
	}
	if ioVar.Type != "" {
		objectMap["_type"] = ioVar.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsImages is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnail":
			if v != nil {
				var thumbnail ImageObject
				err = json.Unmarshal(*v, &thumbnail)
				if err != nil {
					return err
				}
				ioVar.Thumbnail = &thumbnail
			}
		case "imageInsightsToken":
			if v != nil {
				var imageInsightsToken string
				err = json.Unmarshal(*v, &imageInsightsToken)
				if err != nil {
					return err
				}
				ioVar.ImageInsightsToken = &imageInsightsToken
			}
		case "imageId":
			if v != nil {
				var imageID string
				err = json.Unmarshal(*v, &imageID)
				if err != nil {
					return err
				}
				ioVar.ImageID = &imageID
			}
		case "accentColor":
			if v != nil {
				var accentColor string
				err = json.Unmarshal(*v, &accentColor)
				if err != nil {
					return err
				}
				ioVar.AccentColor = &accentColor
			}
		case "visualWords":
			if v != nil {
				var visualWords string
				err = json.Unmarshal(*v, &visualWords)
				if err != nil {
					return err
				}
				ioVar.VisualWords = &visualWords
			}
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				ioVar.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				ioVar.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				ioVar.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				ioVar.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				ioVar.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				ioVar.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				ioVar.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ioVar.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ioVar.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ioVar.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ioVar.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ioVar.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ioVar.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ioVar.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ioVar.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ioVar.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ioVar.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ioVar.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ioVar.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ioVar.Type = typeVar
			}
		}
	}

	return nil
}

// Images defines an image answer
type Images struct {
	autorest.Response `json:"-"`
	// NextOffset - Used as part of deduping. Tells client the next offset that client should use in the next pagination request
	NextOffset *int32 `json:"nextOffset,omitempty"`
	// Value - A list of image objects that are relevant to the query. If there are no results, the List is empty.
	Value *[]ImageObject `json:"value,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Images.
func (i Images) MarshalJSON() ([]byte, error) {
	i.Type = TypeImages
	objectMap := make(map[string]interface{})
	if i.NextOffset != nil {
		objectMap["nextOffset"] = i.NextOffset
	}
	if i.Value != nil {
		objectMap["value"] = i.Value
	}
	if i.TotalEstimatedMatches != nil {
		objectMap["totalEstimatedMatches"] = i.TotalEstimatedMatches
	}
	if i.ReadLink != nil {
		objectMap["readLink"] = i.ReadLink
	}
	if i.WebSearchURL != nil {
		objectMap["webSearchUrl"] = i.WebSearchURL
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Images.
func (i Images) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Images.
func (i Images) AsImages() (*Images, bool) {
	return &i, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Images.
func (i Images) AsBasicAnswer() (BasicAnswer, bool) {
	return &i, true
}

// AsMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Images.
func (i Images) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Images.
func (i Images) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsThing is the BasicResponseBase implementation for Images.
func (i Images) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Images.
func (i Images) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Images.
func (i Images) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Images.
func (i Images) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Images.
func (i Images) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Images.
func (i Images) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Images.
func (i Images) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicMediaObject defines a media object.
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject defines a media object.
type MediaObject struct {
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content (use format "value unit" e.g "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	objectMap := make(map[string]interface{})
	if mo.ContentURL != nil {
		objectMap["contentUrl"] = mo.ContentURL
	}
	if mo.HostPageURL != nil {
		objectMap["hostPageUrl"] = mo.HostPageURL
	}
	if mo.ContentSize != nil {
		objectMap["contentSize"] = mo.ContentSize
	}
	if mo.EncodingFormat != nil {
		objectMap["encodingFormat"] = mo.EncodingFormat
	}
	if mo.HostPageDisplayURL != nil {
		objectMap["hostPageDisplayUrl"] = mo.HostPageDisplayURL
	}
	if mo.Width != nil {
		objectMap["width"] = mo.Width
	}
	if mo.Height != nil {
		objectMap["height"] = mo.Height
	}
	if mo.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = mo.ThumbnailURL
	}
	if mo.Provider != nil {
		objectMap["provider"] = mo.Provider
	}
	if mo.Text != nil {
		objectMap["text"] = mo.Text
	}
	if mo.Name != nil {
		objectMap["name"] = mo.Name
	}
	if mo.URL != nil {
		objectMap["url"] = mo.URL
	}
	if mo.Image != nil {
		objectMap["image"] = mo.Image
	}
	if mo.Description != nil {
		objectMap["description"] = mo.Description
	}
	if mo.AlternateName != nil {
		objectMap["alternateName"] = mo.AlternateName
	}
	if mo.BingID != nil {
		objectMap["bingId"] = mo.BingID
	}
	if mo.ReadLink != nil {
		objectMap["readLink"] = mo.ReadLink
	}
	if mo.WebSearchURL != nil {
		objectMap["webSearchUrl"] = mo.WebSearchURL
	}
	if mo.ID != nil {
		objectMap["id"] = mo.ID
	}
	if mo.Type != "" {
		objectMap["_type"] = mo.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				mo.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				mo.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				mo.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				mo.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				mo.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				mo.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				mo.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				mo.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				mo.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				mo.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mo.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				mo.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				mo.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mo.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				mo.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				mo.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				mo.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				mo.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mo.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mo.Type = typeVar
			}
		}
	}

	return nil
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// SearchLink - The URL that you use to get the results of the related search. Before using the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL if you're displaying the results in your own user interface. Otherwise, use the webSearchUrl URL.
	SearchLink *string `json:"searchLink,omitempty"`
	// Thumbnail - The URL to a thumbnail of a related image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type Response struct {
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.ReadLink != nil {
		objectMap["readLink"] = r.ReadLink
	}
	if r.WebSearchURL != nil {
		objectMap["webSearchUrl"] = r.WebSearchURL
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Response.
func (r Response) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase response base
type BasicResponseBase interface {
	AsImageObject() (*ImageObject, bool)
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsWebPage() (*WebPage, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicSearchResultsAnswer defines a search result answer.
type BasicSearchResultsAnswer interface {
	AsImages() (*Images, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer defines a search result answer.
type SearchResultsAnswer struct {
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImages):
		var i Images
		err := json.Unmarshal(body, &i)
		return i, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	objectMap := make(map[string]interface{})
	if sra.TotalEstimatedMatches != nil {
		objectMap["totalEstimatedMatches"] = sra.TotalEstimatedMatches
	}
	if sra.ReadLink != nil {
		objectMap["readLink"] = sra.ReadLink
	}
	if sra.WebSearchURL != nil {
		objectMap["webSearchUrl"] = sra.WebSearchURL
	}
	if sra.ID != nil {
		objectMap["id"] = sra.ID
	}
	if sra.Type != "" {
		objectMap["_type"] = sra.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsWebPage() (*WebPage, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	if t.URL != nil {
		objectMap["url"] = t.URL
	}
	if t.Image != nil {
		objectMap["image"] = t.Image
	}
	if t.Description != nil {
		objectMap["description"] = t.Description
	}
	if t.AlternateName != nil {
		objectMap["alternateName"] = t.AlternateName
	}
	if t.BingID != nil {
		objectMap["bingId"] = t.BingID
	}
	if t.ReadLink != nil {
		objectMap["readLink"] = t.ReadLink
	}
	if t.WebSearchURL != nil {
		objectMap["webSearchUrl"] = t.WebSearchURL
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for Thing.
func (t Thing) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// WebPage defines a webpage that is relevant to the query.
type WebPage struct {
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// Text - Text content of this creative work
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeImages', 'TypeSearchResultsAnswer', 'TypeAnswer', 'TypeMediaObject', 'TypeResponse', 'TypeThing', 'TypeCreativeWork', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeWebPage'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for WebPage.
func (wp WebPage) MarshalJSON() ([]byte, error) {
	wp.Type = TypeWebPage
	objectMap := make(map[string]interface{})
	if wp.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = wp.ThumbnailURL
	}
	if wp.Provider != nil {
		objectMap["provider"] = wp.Provider
	}
	if wp.Text != nil {
		objectMap["text"] = wp.Text
	}
	if wp.Name != nil {
		objectMap["name"] = wp.Name
	}
	if wp.URL != nil {
		objectMap["url"] = wp.URL
	}
	if wp.Image != nil {
		objectMap["image"] = wp.Image
	}
	if wp.Description != nil {
		objectMap["description"] = wp.Description
	}
	if wp.AlternateName != nil {
		objectMap["alternateName"] = wp.AlternateName
	}
	if wp.BingID != nil {
		objectMap["bingId"] = wp.BingID
	}
	if wp.ReadLink != nil {
		objectMap["readLink"] = wp.ReadLink
	}
	if wp.WebSearchURL != nil {
		objectMap["webSearchUrl"] = wp.WebSearchURL
	}
	if wp.ID != nil {
		objectMap["id"] = wp.ID
	}
	if wp.Type != "" {
		objectMap["_type"] = wp.Type
	}
	return json.Marshal(objectMap)
}

// AsImageObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImages is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsImages() (*Images, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponse() (BasicResponse, bool) {
	return &wp, true
}

// AsThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicThing() (BasicThing, bool) {
	return &wp, true
}

// AsCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &wp, true
}

// AsIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wp, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebPage() (*WebPage, bool) {
	return &wp, true
}

// AsResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wp, true
}

// UnmarshalJSON is the custom unmarshaler for WebPage struct.
func (wp *WebPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				wp.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				wp.Provider = &provider
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				wp.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wp.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				wp.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				wp.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				wp.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				wp.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				wp.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				wp.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				wp.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wp.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wp.Type = typeVar
			}
		}
	}

	return nil
}
