package blueprint

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AssignmentLockMode enumerates the values for assignment lock mode.
type AssignmentLockMode string

const (
	// AllResources ...
	AllResources AssignmentLockMode = "AllResources"
	// None ...
	None AssignmentLockMode = "None"
)

// PossibleAssignmentLockModeValues returns an array of possible values for the AssignmentLockMode const type.
func PossibleAssignmentLockModeValues() []AssignmentLockMode {
	return []AssignmentLockMode{AllResources, None}
}

// AssignmentProvisioningState enumerates the values for assignment provisioning state.
type AssignmentProvisioningState string

const (
	// Canceled ...
	Canceled AssignmentProvisioningState = "canceled"
	// Cancelling ...
	Cancelling AssignmentProvisioningState = "cancelling"
	// Creating ...
	Creating AssignmentProvisioningState = "creating"
	// Deleting ...
	Deleting AssignmentProvisioningState = "deleting"
	// Deploying ...
	Deploying AssignmentProvisioningState = "deploying"
	// Failed ...
	Failed AssignmentProvisioningState = "failed"
	// Locking ...
	Locking AssignmentProvisioningState = "locking"
	// Succeeded ...
	Succeeded AssignmentProvisioningState = "succeeded"
	// Validating ...
	Validating AssignmentProvisioningState = "validating"
	// Waiting ...
	Waiting AssignmentProvisioningState = "waiting"
)

// PossibleAssignmentProvisioningStateValues returns an array of possible values for the AssignmentProvisioningState const type.
func PossibleAssignmentProvisioningStateValues() []AssignmentProvisioningState {
	return []AssignmentProvisioningState{Canceled, Cancelling, Creating, Deleting, Deploying, Failed, Locking, Succeeded, Validating, Waiting}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindArtifact ...
	KindArtifact Kind = "Artifact"
	// KindPolicyAssignment ...
	KindPolicyAssignment Kind = "policyAssignment"
	// KindRoleAssignment ...
	KindRoleAssignment Kind = "roleAssignment"
	// KindTemplate ...
	KindTemplate Kind = "template"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindArtifact, KindPolicyAssignment, KindRoleAssignment, KindTemplate}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// ManagedServiceIdentityTypeNone ...
	ManagedServiceIdentityTypeNone ManagedServiceIdentityType = "None"
	// ManagedServiceIdentityTypeSystemAssigned ...
	ManagedServiceIdentityTypeSystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	// ManagedServiceIdentityTypeUserAssigned ...
	ManagedServiceIdentityTypeUserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{ManagedServiceIdentityTypeNone, ManagedServiceIdentityTypeSystemAssigned, ManagedServiceIdentityTypeUserAssigned}
}

// TargetScope enumerates the values for target scope.
type TargetScope string

const (
	// ManagementGroup ...
	ManagementGroup TargetScope = "managementGroup"
	// Subscription ...
	Subscription TargetScope = "subscription"
)

// PossibleTargetScopeValues returns an array of possible values for the TargetScope const type.
func PossibleTargetScopeValues() []TargetScope {
	return []TargetScope{ManagementGroup, Subscription}
}

// TemplateParameterType enumerates the values for template parameter type.
type TemplateParameterType string

const (
	// Array ...
	Array TemplateParameterType = "array"
	// Bool ...
	Bool TemplateParameterType = "bool"
	// Int ...
	Int TemplateParameterType = "int"
	// Object ...
	Object TemplateParameterType = "object"
	// SecureObject ...
	SecureObject TemplateParameterType = "secureObject"
	// SecureString ...
	SecureString TemplateParameterType = "secureString"
	// String ...
	String TemplateParameterType = "string"
)

// PossibleTemplateParameterTypeValues returns an array of possible values for the TemplateParameterType const type.
func PossibleTemplateParameterTypeValues() []TemplateParameterType {
	return []TemplateParameterType{Array, Bool, Int, Object, SecureObject, SecureString, String}
}

// BasicArtifact represents a Blueprint artifact.
type BasicArtifact interface {
	AsTemplateArtifact() (*TemplateArtifact, bool)
	AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool)
	AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool)
	AsArtifact() (*Artifact, bool)
}

// Artifact represents a Blueprint artifact.
type Artifact struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

func unmarshalBasicArtifact(body []byte) (BasicArtifact, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindTemplate):
		var ta TemplateArtifact
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(KindRoleAssignment):
		var raa RoleAssignmentArtifact
		err := json.Unmarshal(body, &raa)
		return raa, err
	case string(KindPolicyAssignment):
		var paa PolicyAssignmentArtifact
		err := json.Unmarshal(body, &paa)
		return paa, err
	default:
		var a Artifact
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicArtifactArray(body []byte) ([]BasicArtifact, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicArtifact, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicArtifact(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	a.Kind = KindArtifact
	objectMap := make(map[string]interface{})
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsArtifact() (*Artifact, bool) {
	return &a, true
}

// AsBasicArtifact is the BasicArtifact implementation for Artifact.
func (a Artifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &a, true
}

// ArtifactList list of Blueprint artifacts
type ArtifactList struct {
	autorest.Response `json:"-"`
	// Value - List of Blueprint artifacts.
	Value *[]BasicArtifact `json:"value,omitempty"`
	// NextLink - Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ArtifactList struct.
func (al *ArtifactList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicArtifactArray(*v)
				if err != nil {
					return err
				}
				al.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				al.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ArtifactListIterator provides access to a complete listing of Artifact values.
type ArtifactListIterator struct {
	i    int
	page ArtifactListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArtifactListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArtifactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArtifactListIterator) Response() ArtifactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArtifactListIterator) Value() BasicArtifact {
	if !iter.page.NotDone() {
		return Artifact{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (al ArtifactList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// artifactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ArtifactList) artifactListPreparer() (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ArtifactListPage contains a page of BasicArtifact values.
type ArtifactListPage struct {
	fn func(ArtifactList) (ArtifactList, error)
	al ArtifactList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArtifactListPage) Next() error {
	next, err := page.fn(page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArtifactListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArtifactListPage) Response() ArtifactList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArtifactListPage) Values() []BasicArtifact {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// ArtifactModel ...
type ArtifactModel struct {
	autorest.Response `json:"-"`
	Value             BasicArtifact `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ArtifactModel struct.
func (am *ArtifactModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicArtifact(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// ArtifactPropertiesBase common properties shared by different artifacts.
type ArtifactPropertiesBase struct {
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
}

// Assignment represents a Blueprint assignment.
type Assignment struct {
	autorest.Response `json:"-"`
	// Identity - Managed Service Identity for this Blueprint assignment
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`
	// AssignmentProperties - Properties for Assignment object.
	*AssignmentProperties `json:"properties,omitempty"`
	// Location - The location of this Blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Assignment.
func (a Assignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.AssignmentProperties != nil {
		objectMap["properties"] = a.AssignmentProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assignment struct.
func (a *Assignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "properties":
			if v != nil {
				var assignmentProperties AssignmentProperties
				err = json.Unmarshal(*v, &assignmentProperties)
				if err != nil {
					return err
				}
				a.AssignmentProperties = &assignmentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		}
	}

	return nil
}

// AssignmentList list of Blueprint assignments
type AssignmentList struct {
	autorest.Response `json:"-"`
	// Value - List of Blueprint assignments.
	Value *[]Assignment `json:"value,omitempty"`
	// NextLink - Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AssignmentListIterator provides access to a complete listing of Assignment values.
type AssignmentListIterator struct {
	i    int
	page AssignmentListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssignmentListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssignmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssignmentListIterator) Response() AssignmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssignmentListIterator) Value() Assignment {
	if !iter.page.NotDone() {
		return Assignment{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (al AssignmentList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// assignmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AssignmentList) assignmentListPreparer() (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AssignmentListPage contains a page of Assignment values.
type AssignmentListPage struct {
	fn func(AssignmentList) (AssignmentList, error)
	al AssignmentList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssignmentListPage) Next() error {
	next, err := page.fn(page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssignmentListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssignmentListPage) Response() AssignmentList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssignmentListPage) Values() []Assignment {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// AssignmentLockSettings defines how Blueprint-managed resources will be locked.
type AssignmentLockSettings struct {
	// Mode - Lock mode. Possible values include: 'None', 'AllResources'
	Mode AssignmentLockMode `json:"mode,omitempty"`
}

// AssignmentProperties detailed properties for Assignment.
type AssignmentProperties struct {
	// BlueprintID - ID of the Blueprint definition resource.
	BlueprintID *string `json:"blueprintId,omitempty"`
	// Parameters - Blueprint parameter values.
	Parameters map[string]*ParameterValueBase `json:"parameters"`
	// ResourceGroups - Names and locations of resource group placeholders.
	ResourceGroups map[string]*ResourceGroupValue `json:"resourceGroups"`
	// Status - Status of Blueprint assignment. This field is readonly.
	Status *AssignmentStatus `json:"status,omitempty"`
	// Locks - Defines how Blueprint-managed resources will be locked.
	Locks *AssignmentLockSettings `json:"locks,omitempty"`
	// ProvisioningState - State of the assignment. Possible values include: 'Creating', 'Validating', 'Waiting', 'Deploying', 'Cancelling', 'Locking', 'Succeeded', 'Failed', 'Canceled', 'Deleting'
	ProvisioningState AssignmentProvisioningState `json:"provisioningState,omitempty"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentProperties.
func (ap AssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.BlueprintID != nil {
		objectMap["blueprintId"] = ap.BlueprintID
	}
	if ap.Parameters != nil {
		objectMap["parameters"] = ap.Parameters
	}
	if ap.ResourceGroups != nil {
		objectMap["resourceGroups"] = ap.ResourceGroups
	}
	if ap.Status != nil {
		objectMap["status"] = ap.Status
	}
	if ap.Locks != nil {
		objectMap["locks"] = ap.Locks
	}
	if ap.ProvisioningState != "" {
		objectMap["provisioningState"] = ap.ProvisioningState
	}
	if ap.DisplayName != nil {
		objectMap["displayName"] = ap.DisplayName
	}
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	return json.Marshal(objectMap)
}

// AssignmentStatus the status of Blueprint assignment. This field is readonly.
type AssignmentStatus struct {
	// TimeCreated - Creation time of this blueprint.
	TimeCreated *string `json:"timeCreated,omitempty"`
	// LastModified - Last modified time of this blueprint.
	LastModified *string `json:"lastModified,omitempty"`
}

// AzureResourceBase common properties for all Azure resources.
type AzureResourceBase struct {
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// KeyVaultReference specifies the link to a KeyVault.
type KeyVaultReference struct {
	// ID - Azure resource ID of the KeyVault.
	ID *string `json:"id,omitempty"`
}

// List list of Blueprint definitions.
type List struct {
	autorest.Response `json:"-"`
	// Value - List of Blueprint definitions.
	Value *[]Model `json:"value,omitempty"`
	// NextLink - Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListIterator provides access to a complete listing of Model values.
type ListIterator struct {
	i    int
	page ListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListIterator) Response() List {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListIterator) Value() Model {
	if !iter.page.NotDone() {
		return Model{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (l List) IsEmpty() bool {
	return l.Value == nil || len(*l.Value) == 0
}

// listPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (l List) listPreparer() (*http.Request, error) {
	if l.NextLink == nil || len(to.String(l.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(l.NextLink)))
}

// ListPage contains a page of Model values.
type ListPage struct {
	fn func(List) (List, error)
	l  List
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListPage) Next() error {
	next, err := page.fn(page.l)
	if err != nil {
		return err
	}
	page.l = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListPage) NotDone() bool {
	return !page.l.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListPage) Response() List {
	return page.l
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListPage) Values() []Model {
	if page.l.IsEmpty() {
		return nil
	}
	return *page.l.Value
}

// ManagedServiceIdentity managed Service Identity
type ManagedServiceIdentity struct {
	// Type - Type of the Managed Service Identity. Possible values include: 'ManagedServiceIdentityTypeNone', 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeUserAssigned'
	Type ManagedServiceIdentityType `json:"type,omitempty"`
	// PrincipalID - Azure Active Directory principal ID associated with this Identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - ID of the Azure Active Directory.
	TenantID *string `json:"tenantId,omitempty"`
}

// Model represents a Blueprint definition.
type Model struct {
	autorest.Response `json:"-"`
	// Properties - Detailed properties for blueprint
	*Properties `json:"properties,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	if mVar.ID != nil {
		objectMap["id"] = mVar.ID
	}
	if mVar.Type != nil {
		objectMap["type"] = mVar.Type
	}
	if mVar.Name != nil {
		objectMap["name"] = mVar.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mVar.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		}
	}

	return nil
}

// ParameterDefinition represent a parameter with constrains and metadata.
type ParameterDefinition struct {
	// Type - Allowed data types for Azure Resource Manager template parameters. Possible values include: 'String', 'Array', 'Bool', 'Int', 'Object', 'SecureObject', 'SecureString'
	Type TemplateParameterType `json:"type,omitempty"`
	// ParameterDefinitionMetadata - User-friendly properties for this parameter.
	*ParameterDefinitionMetadata `json:"metadata,omitempty"`
	// DefaultValue - Default Value for this parameter.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// AllowedValues - Array of allowed values for this parameter.
	AllowedValues *[]interface{} `json:"allowedValues,omitempty"`
}

// MarshalJSON is the custom marshaler for ParameterDefinition.
func (pd ParameterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.Type != "" {
		objectMap["type"] = pd.Type
	}
	if pd.ParameterDefinitionMetadata != nil {
		objectMap["metadata"] = pd.ParameterDefinitionMetadata
	}
	objectMap["defaultValue"] = pd.DefaultValue
	if pd.AllowedValues != nil {
		objectMap["allowedValues"] = pd.AllowedValues
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ParameterDefinition struct.
func (pd *ParameterDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "type":
			if v != nil {
				var typeVar TemplateParameterType
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pd.Type = typeVar
			}
		case "metadata":
			if v != nil {
				var parameterDefinitionMetadata ParameterDefinitionMetadata
				err = json.Unmarshal(*v, &parameterDefinitionMetadata)
				if err != nil {
					return err
				}
				pd.ParameterDefinitionMetadata = &parameterDefinitionMetadata
			}
		case "defaultValue":
			if v != nil {
				var defaultValue interface{}
				err = json.Unmarshal(*v, &defaultValue)
				if err != nil {
					return err
				}
				pd.DefaultValue = defaultValue
			}
		case "allowedValues":
			if v != nil {
				var allowedValues []interface{}
				err = json.Unmarshal(*v, &allowedValues)
				if err != nil {
					return err
				}
				pd.AllowedValues = &allowedValues
			}
		}
	}

	return nil
}

// ParameterDefinitionMetadata user-friendly properties for this parameter.
type ParameterDefinitionMetadata struct {
	// DisplayName - DisplayName of this parameter/resourceGroup.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Description of this parameter/resourceGroup.
	Description *string `json:"description,omitempty"`
	// StrongType - StrongType for UI to render rich experience during assignment time.
	StrongType *string `json:"strongType,omitempty"`
}

// ParameterValue value for the specified parameter.
type ParameterValue struct {
	// Value - actual value.
	Value interface{} `json:"value,omitempty"`
	// Description - Optional property, just to establish ParameterValueBase as a BaseClass.
	Description *string `json:"description,omitempty"`
}

// ParameterValueBase base class for ParameterValue.
type ParameterValueBase struct {
	// Description - Optional property, just to establish ParameterValueBase as a BaseClass.
	Description *string `json:"description,omitempty"`
}

// PolicyAssignmentArtifact blueprint artifact applies Policy assignments.
type PolicyAssignmentArtifact struct {
	// PolicyAssignmentArtifactProperties - properties for policyAssginment Artifact
	*PolicyAssignmentArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) MarshalJSON() ([]byte, error) {
	paa.Kind = KindPolicyAssignment
	objectMap := make(map[string]interface{})
	if paa.PolicyAssignmentArtifactProperties != nil {
		objectMap["properties"] = paa.PolicyAssignmentArtifactProperties
	}
	if paa.Kind != "" {
		objectMap["kind"] = paa.Kind
	}
	if paa.ID != nil {
		objectMap["id"] = paa.ID
	}
	if paa.Type != nil {
		objectMap["type"] = paa.Type
	}
	if paa.Name != nil {
		objectMap["name"] = paa.Name
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return &paa, true
}

// AsArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for PolicyAssignmentArtifact.
func (paa PolicyAssignmentArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &paa, true
}

// UnmarshalJSON is the custom unmarshaler for PolicyAssignmentArtifact struct.
func (paa *PolicyAssignmentArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var policyAssignmentArtifactProperties PolicyAssignmentArtifactProperties
				err = json.Unmarshal(*v, &policyAssignmentArtifactProperties)
				if err != nil {
					return err
				}
				paa.PolicyAssignmentArtifactProperties = &policyAssignmentArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				paa.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				paa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				paa.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				paa.Name = &name
			}
		}
	}

	return nil
}

// PolicyAssignmentArtifactProperties policyAssignment properties
type PolicyAssignmentArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// PolicyDefinitionID - Azure resource ID of the policy definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Parameters - Parameter values for the policy definition.
	Parameters map[string]*ParameterValueBase `json:"parameters"`
	// ResourceGroup - Name of the resource group placeholder to which the policy will be assigned.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyAssignmentArtifactProperties.
func (paap PolicyAssignmentArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paap.DisplayName != nil {
		objectMap["displayName"] = paap.DisplayName
	}
	if paap.Description != nil {
		objectMap["description"] = paap.Description
	}
	if paap.DependsOn != nil {
		objectMap["dependsOn"] = paap.DependsOn
	}
	if paap.PolicyDefinitionID != nil {
		objectMap["policyDefinitionId"] = paap.PolicyDefinitionID
	}
	if paap.Parameters != nil {
		objectMap["parameters"] = paap.Parameters
	}
	if paap.ResourceGroup != nil {
		objectMap["resourceGroup"] = paap.ResourceGroup
	}
	return json.Marshal(objectMap)
}

// Properties schema for Blueprint properties.
type Properties struct {
	// Versions - Published versions of this blueprint.
	Versions interface{} `json:"versions,omitempty"`
	// Layout - Layout view of the blueprint, for UI reference.
	Layout interface{} `json:"layout,omitempty"`
	// Status - Status of the Blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this Blueprint can be applied. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this Blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this Blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["versions"] = p.Versions
	objectMap["layout"] = p.Layout
	if p.Status != nil {
		objectMap["status"] = p.Status
	}
	if p.TargetScope != "" {
		objectMap["targetScope"] = p.TargetScope
	}
	if p.Parameters != nil {
		objectMap["parameters"] = p.Parameters
	}
	if p.ResourceGroups != nil {
		objectMap["resourceGroups"] = p.ResourceGroups
	}
	if p.DisplayName != nil {
		objectMap["displayName"] = p.DisplayName
	}
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	return json.Marshal(objectMap)
}

// PublishedBlueprint represents a published Blueprint.
type PublishedBlueprint struct {
	autorest.Response `json:"-"`
	// PublishedBlueprintProperties - Detailed properties for published Blueprint
	*PublishedBlueprintProperties `json:"properties,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for PublishedBlueprint.
func (pb PublishedBlueprint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pb.PublishedBlueprintProperties != nil {
		objectMap["properties"] = pb.PublishedBlueprintProperties
	}
	if pb.ID != nil {
		objectMap["id"] = pb.ID
	}
	if pb.Type != nil {
		objectMap["type"] = pb.Type
	}
	if pb.Name != nil {
		objectMap["name"] = pb.Name
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublishedBlueprint struct.
func (pb *PublishedBlueprint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publishedBlueprintProperties PublishedBlueprintProperties
				err = json.Unmarshal(*v, &publishedBlueprintProperties)
				if err != nil {
					return err
				}
				pb.PublishedBlueprintProperties = &publishedBlueprintProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pb.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pb.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pb.Name = &name
			}
		}
	}

	return nil
}

// PublishedBlueprintList list of published Blueprints
type PublishedBlueprintList struct {
	autorest.Response `json:"-"`
	// Value - List of published Blueprints.
	Value *[]PublishedBlueprint `json:"value,omitempty"`
	// NextLink - Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PublishedBlueprintListIterator provides access to a complete listing of PublishedBlueprint values.
type PublishedBlueprintListIterator struct {
	i    int
	page PublishedBlueprintListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublishedBlueprintListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublishedBlueprintListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublishedBlueprintListIterator) Response() PublishedBlueprintList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublishedBlueprintListIterator) Value() PublishedBlueprint {
	if !iter.page.NotDone() {
		return PublishedBlueprint{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pbl PublishedBlueprintList) IsEmpty() bool {
	return pbl.Value == nil || len(*pbl.Value) == 0
}

// publishedBlueprintListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pbl PublishedBlueprintList) publishedBlueprintListPreparer() (*http.Request, error) {
	if pbl.NextLink == nil || len(to.String(pbl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pbl.NextLink)))
}

// PublishedBlueprintListPage contains a page of PublishedBlueprint values.
type PublishedBlueprintListPage struct {
	fn  func(PublishedBlueprintList) (PublishedBlueprintList, error)
	pbl PublishedBlueprintList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublishedBlueprintListPage) Next() error {
	next, err := page.fn(page.pbl)
	if err != nil {
		return err
	}
	page.pbl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublishedBlueprintListPage) NotDone() bool {
	return !page.pbl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublishedBlueprintListPage) Response() PublishedBlueprintList {
	return page.pbl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublishedBlueprintListPage) Values() []PublishedBlueprint {
	if page.pbl.IsEmpty() {
		return nil
	}
	return *page.pbl.Value
}

// PublishedBlueprintProperties schema for published Blueprint properties.
type PublishedBlueprintProperties struct {
	// BlueprintName - Name of the Blueprint definition.
	BlueprintName *string `json:"blueprintName,omitempty"`
	// ChangeNotes - Version-specific change notes
	ChangeNotes *string `json:"changeNotes,omitempty"`
	// Status - Status of the Blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this Blueprint can be applied. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this Blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this Blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for PublishedBlueprintProperties.
func (pbp PublishedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pbp.BlueprintName != nil {
		objectMap["blueprintName"] = pbp.BlueprintName
	}
	if pbp.ChangeNotes != nil {
		objectMap["changeNotes"] = pbp.ChangeNotes
	}
	if pbp.Status != nil {
		objectMap["status"] = pbp.Status
	}
	if pbp.TargetScope != "" {
		objectMap["targetScope"] = pbp.TargetScope
	}
	if pbp.Parameters != nil {
		objectMap["parameters"] = pbp.Parameters
	}
	if pbp.ResourceGroups != nil {
		objectMap["resourceGroups"] = pbp.ResourceGroups
	}
	if pbp.DisplayName != nil {
		objectMap["displayName"] = pbp.DisplayName
	}
	if pbp.Description != nil {
		objectMap["description"] = pbp.Description
	}
	return json.Marshal(objectMap)
}

// ResourceGroupDefinition represents an Azure resource group in a Blueprint definition.
type ResourceGroupDefinition struct {
	// Name - Name of this resourceGroup, leave empty if the resource group name will be specified during the Blueprint assignment.
	Name *string `json:"name,omitempty"`
	// Location - Location of this resourceGroup, leave empty if the resource group location will be specified during the Blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ParameterDefinitionMetadata - User-friendly properties for this resource group.
	*ParameterDefinitionMetadata `json:"metadata,omitempty"`
	// DependsOn - Artifacts which need to be deployed before this resource group.
	DependsOn *[]string `json:"dependsOn,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceGroupDefinition.
func (rgd ResourceGroupDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rgd.Name != nil {
		objectMap["name"] = rgd.Name
	}
	if rgd.Location != nil {
		objectMap["location"] = rgd.Location
	}
	if rgd.ParameterDefinitionMetadata != nil {
		objectMap["metadata"] = rgd.ParameterDefinitionMetadata
	}
	if rgd.DependsOn != nil {
		objectMap["dependsOn"] = rgd.DependsOn
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceGroupDefinition struct.
func (rgd *ResourceGroupDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rgd.Name = &name
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rgd.Location = &location
			}
		case "metadata":
			if v != nil {
				var parameterDefinitionMetadata ParameterDefinitionMetadata
				err = json.Unmarshal(*v, &parameterDefinitionMetadata)
				if err != nil {
					return err
				}
				rgd.ParameterDefinitionMetadata = &parameterDefinitionMetadata
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []string
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				rgd.DependsOn = &dependsOn
			}
		}
	}

	return nil
}

// ResourceGroupValue represents an Azure resource group.
type ResourceGroupValue struct {
	// Name - Name of the resource group
	Name *string `json:"name,omitempty"`
	// Location - Location of the resource group
	Location *string `json:"location,omitempty"`
}

// ResourcePropertiesBase shared properties between all Blueprint resources.
type ResourcePropertiesBase struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft Blueprint.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
}

// ResourceStatusBase shared status properties between all Blueprint resources.
type ResourceStatusBase struct {
	// TimeCreated - Creation time of this blueprint.
	TimeCreated *string `json:"timeCreated,omitempty"`
	// LastModified - Last modified time of this blueprint.
	LastModified *string `json:"lastModified,omitempty"`
}

// RoleAssignmentArtifact blueprint artifact applies Azure role assignment.
type RoleAssignmentArtifact struct {
	// RoleAssignmentArtifactProperties - Properties for roleAssignment artifact.
	*RoleAssignmentArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) MarshalJSON() ([]byte, error) {
	raa.Kind = KindRoleAssignment
	objectMap := make(map[string]interface{})
	if raa.RoleAssignmentArtifactProperties != nil {
		objectMap["properties"] = raa.RoleAssignmentArtifactProperties
	}
	if raa.Kind != "" {
		objectMap["kind"] = raa.Kind
	}
	if raa.ID != nil {
		objectMap["id"] = raa.ID
	}
	if raa.Type != nil {
		objectMap["type"] = raa.Type
	}
	if raa.Name != nil {
		objectMap["name"] = raa.Name
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return nil, false
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return &raa, true
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for RoleAssignmentArtifact.
func (raa RoleAssignmentArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &raa, true
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentArtifact struct.
func (raa *RoleAssignmentArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var roleAssignmentArtifactProperties RoleAssignmentArtifactProperties
				err = json.Unmarshal(*v, &roleAssignmentArtifactProperties)
				if err != nil {
					return err
				}
				raa.RoleAssignmentArtifactProperties = &roleAssignmentArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				raa.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				raa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				raa.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				raa.Name = &name
			}
		}
	}

	return nil
}

// RoleAssignmentArtifactProperties properties of the Role assignment artifact.
type RoleAssignmentArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// RoleDefinitionID - Azure resource ID of the RoleDefinition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalIds - Array of user or group identities in Azure Active Directory. The roleDefinition will apply to these identity.
	PrincipalIds interface{} `json:"principalIds,omitempty"`
	// ResourceGroup - RoleAssignment will be scope to this resourceGroup, if left empty, it would scope to the subscription.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// SecretReferenceParameterValue the reference to a secret, if the parameter should be protected.
type SecretReferenceParameterValue struct {
	// Reference - Specifies the reference.
	Reference *SecretValueReference `json:"reference,omitempty"`
	// Description - Optional property, just to establish ParameterValueBase as a BaseClass.
	Description *string `json:"description,omitempty"`
}

// SecretValueReference reference to a KeyVault secret.
type SecretValueReference struct {
	// KeyVault - Specifies the reference to a given Azure KeyVault.
	KeyVault *KeyVaultReference `json:"keyVault,omitempty"`
	// SecretName - Name of the secret.
	SecretName *string `json:"secretName,omitempty"`
	// SecretVersion - Version of the secret, (if there are multiple versions)
	SecretVersion *string `json:"secretVersion,omitempty"`
}

// SharedBlueprintProperties shared Schema for both blueprintProperties and publishedBlueprintProperties.
type SharedBlueprintProperties struct {
	// Status - Status of the Blueprint. This field is readonly.
	Status *Status `json:"status,omitempty"`
	// TargetScope - The scope where this Blueprint can be applied. Possible values include: 'Subscription', 'ManagementGroup'
	TargetScope TargetScope `json:"targetScope,omitempty"`
	// Parameters - Parameters required by this Blueprint definition.
	Parameters map[string]*ParameterDefinition `json:"parameters"`
	// ResourceGroups - Resource group placeholders defined by this Blueprint definition.
	ResourceGroups map[string]*ResourceGroupDefinition `json:"resourceGroups"`
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedBlueprintProperties.
func (sbp SharedBlueprintProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbp.Status != nil {
		objectMap["status"] = sbp.Status
	}
	if sbp.TargetScope != "" {
		objectMap["targetScope"] = sbp.TargetScope
	}
	if sbp.Parameters != nil {
		objectMap["parameters"] = sbp.Parameters
	}
	if sbp.ResourceGroups != nil {
		objectMap["resourceGroups"] = sbp.ResourceGroups
	}
	if sbp.DisplayName != nil {
		objectMap["displayName"] = sbp.DisplayName
	}
	if sbp.Description != nil {
		objectMap["description"] = sbp.Description
	}
	return json.Marshal(objectMap)
}

// Status the status of the blueprint. This field is readonly.
type Status struct {
	// TimeCreated - Creation time of this blueprint.
	TimeCreated *string `json:"timeCreated,omitempty"`
	// LastModified - Last modified time of this blueprint.
	LastModified *string `json:"lastModified,omitempty"`
}

// TemplateArtifact blueprint artifact deploys Azure resource manager template.
type TemplateArtifact struct {
	// TemplateArtifactProperties - Properties for template artifact
	*TemplateArtifactProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindArtifact', 'KindTemplate', 'KindRoleAssignment', 'KindPolicyAssignment'
	Kind Kind `json:"kind,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TemplateArtifact.
func (ta TemplateArtifact) MarshalJSON() ([]byte, error) {
	ta.Kind = KindTemplate
	objectMap := make(map[string]interface{})
	if ta.TemplateArtifactProperties != nil {
		objectMap["properties"] = ta.TemplateArtifactProperties
	}
	if ta.Kind != "" {
		objectMap["kind"] = ta.Kind
	}
	if ta.ID != nil {
		objectMap["id"] = ta.ID
	}
	if ta.Type != nil {
		objectMap["type"] = ta.Type
	}
	if ta.Name != nil {
		objectMap["name"] = ta.Name
	}
	return json.Marshal(objectMap)
}

// AsTemplateArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsTemplateArtifact() (*TemplateArtifact, bool) {
	return &ta, true
}

// AsRoleAssignmentArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsRoleAssignmentArtifact() (*RoleAssignmentArtifact, bool) {
	return nil, false
}

// AsPolicyAssignmentArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsPolicyAssignmentArtifact() (*PolicyAssignmentArtifact, bool) {
	return nil, false
}

// AsArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsArtifact() (*Artifact, bool) {
	return nil, false
}

// AsBasicArtifact is the BasicArtifact implementation for TemplateArtifact.
func (ta TemplateArtifact) AsBasicArtifact() (BasicArtifact, bool) {
	return &ta, true
}

// UnmarshalJSON is the custom unmarshaler for TemplateArtifact struct.
func (ta *TemplateArtifact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var templateArtifactProperties TemplateArtifactProperties
				err = json.Unmarshal(*v, &templateArtifactProperties)
				if err != nil {
					return err
				}
				ta.TemplateArtifactProperties = &templateArtifactProperties
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ta.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ta.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ta.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ta.Name = &name
			}
		}
	}

	return nil
}

// TemplateArtifactProperties properties of a Template Artifact.
type TemplateArtifactProperties struct {
	// DisplayName - One-liner string explain this resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - Multi-line explain this resource.
	Description *string `json:"description,omitempty"`
	// DependsOn - Artifacts which need to be deployed before the specified artifact.
	DependsOn *[]string `json:"dependsOn,omitempty"`
	// Template - The Azure Resource Manager template body.
	Template interface{} `json:"template,omitempty"`
	// ResourceGroup - If applicable, the name of the resource group placeholder to which the template will be deployed.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Parameters - Template parameter values.
	Parameters map[string]*ParameterValueBase `json:"parameters"`
}

// MarshalJSON is the custom marshaler for TemplateArtifactProperties.
func (tap TemplateArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tap.DisplayName != nil {
		objectMap["displayName"] = tap.DisplayName
	}
	if tap.Description != nil {
		objectMap["description"] = tap.Description
	}
	if tap.DependsOn != nil {
		objectMap["dependsOn"] = tap.DependsOn
	}
	objectMap["template"] = tap.Template
	if tap.ResourceGroup != nil {
		objectMap["resourceGroup"] = tap.ResourceGroup
	}
	if tap.Parameters != nil {
		objectMap["parameters"] = tap.Parameters
	}
	return json.Marshal(objectMap)
}

// TrackedResource common properties for all Azure tracked resources.
type TrackedResource struct {
	// Location - The location of this Blueprint assignment.
	Location *string `json:"location,omitempty"`
	// ID - String Id used to locate any resource on Azure.
	ID *string `json:"id,omitempty"`
	// Type - Type of this resource.
	Type *string `json:"type,omitempty"`
	// Name - Name of this resource.
	Name *string `json:"name,omitempty"`
}
