package siterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// A2ARpRecoveryPointType enumerates the values for a2a rp recovery point type.
type A2ARpRecoveryPointType string

const (
	// Latest ...
	Latest A2ARpRecoveryPointType = "Latest"
	// LatestApplicationConsistent ...
	LatestApplicationConsistent A2ARpRecoveryPointType = "LatestApplicationConsistent"
	// LatestCrashConsistent ...
	LatestCrashConsistent A2ARpRecoveryPointType = "LatestCrashConsistent"
	// LatestProcessed ...
	LatestProcessed A2ARpRecoveryPointType = "LatestProcessed"
)

// PossibleA2ARpRecoveryPointTypeValues returns an array of possible values for the A2ARpRecoveryPointType const type.
func PossibleA2ARpRecoveryPointTypeValues() []A2ARpRecoveryPointType {
	return []A2ARpRecoveryPointType{Latest, LatestApplicationConsistent, LatestCrashConsistent, LatestProcessed}
}

// AlternateLocationRecoveryOption enumerates the values for alternate location recovery option.
type AlternateLocationRecoveryOption string

const (
	// CreateVMIfNotFound ...
	CreateVMIfNotFound AlternateLocationRecoveryOption = "CreateVmIfNotFound"
	// NoAction ...
	NoAction AlternateLocationRecoveryOption = "NoAction"
)

// PossibleAlternateLocationRecoveryOptionValues returns an array of possible values for the AlternateLocationRecoveryOption const type.
func PossibleAlternateLocationRecoveryOptionValues() []AlternateLocationRecoveryOption {
	return []AlternateLocationRecoveryOption{CreateVMIfNotFound, NoAction}
}

// DataSyncStatus enumerates the values for data sync status.
type DataSyncStatus string

const (
	// ForDownTime ...
	ForDownTime DataSyncStatus = "ForDownTime"
	// ForSynchronization ...
	ForSynchronization DataSyncStatus = "ForSynchronization"
)

// PossibleDataSyncStatusValues returns an array of possible values for the DataSyncStatus const type.
func PossibleDataSyncStatusValues() []DataSyncStatus {
	return []DataSyncStatus{ForDownTime, ForSynchronization}
}

// DisableProtectionReason enumerates the values for disable protection reason.
type DisableProtectionReason string

const (
	// MigrationComplete ...
	MigrationComplete DisableProtectionReason = "MigrationComplete"
	// NotSpecified ...
	NotSpecified DisableProtectionReason = "NotSpecified"
)

// PossibleDisableProtectionReasonValues returns an array of possible values for the DisableProtectionReason const type.
func PossibleDisableProtectionReasonValues() []DisableProtectionReason {
	return []DisableProtectionReason{MigrationComplete, NotSpecified}
}

// FailoverDeploymentModel enumerates the values for failover deployment model.
type FailoverDeploymentModel string

const (
	// Classic ...
	Classic FailoverDeploymentModel = "Classic"
	// NotApplicable ...
	NotApplicable FailoverDeploymentModel = "NotApplicable"
	// ResourceManager ...
	ResourceManager FailoverDeploymentModel = "ResourceManager"
)

// PossibleFailoverDeploymentModelValues returns an array of possible values for the FailoverDeploymentModel const type.
func PossibleFailoverDeploymentModelValues() []FailoverDeploymentModel {
	return []FailoverDeploymentModel{Classic, NotApplicable, ResourceManager}
}

// HealthErrorCategory enumerates the values for health error category.
type HealthErrorCategory string

const (
	// Configuration ...
	Configuration HealthErrorCategory = "Configuration"
	// Replication ...
	Replication HealthErrorCategory = "Replication"
	// TestFailover ...
	TestFailover HealthErrorCategory = "TestFailover"
)

// PossibleHealthErrorCategoryValues returns an array of possible values for the HealthErrorCategory const type.
func PossibleHealthErrorCategoryValues() []HealthErrorCategory {
	return []HealthErrorCategory{Configuration, Replication, TestFailover}
}

// HyperVReplicaAzureRpRecoveryPointType enumerates the values for hyper v replica azure rp recovery point
// type.
type HyperVReplicaAzureRpRecoveryPointType string

const (
	// HyperVReplicaAzureRpRecoveryPointTypeLatest ...
	HyperVReplicaAzureRpRecoveryPointTypeLatest HyperVReplicaAzureRpRecoveryPointType = "Latest"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent ...
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = "LatestApplicationConsistent"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed ...
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed HyperVReplicaAzureRpRecoveryPointType = "LatestProcessed"
)

// PossibleHyperVReplicaAzureRpRecoveryPointTypeValues returns an array of possible values for the HyperVReplicaAzureRpRecoveryPointType const type.
func PossibleHyperVReplicaAzureRpRecoveryPointTypeValues() []HyperVReplicaAzureRpRecoveryPointType {
	return []HyperVReplicaAzureRpRecoveryPointType{HyperVReplicaAzureRpRecoveryPointTypeLatest, HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent, HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed}
}

// IdentityProviderType enumerates the values for identity provider type.
type IdentityProviderType string

const (
	// CustomerActiveDirectory ...
	CustomerActiveDirectory IdentityProviderType = "CustomerActiveDirectory"
	// RecoveryServicesActiveDirectory ...
	RecoveryServicesActiveDirectory IdentityProviderType = "RecoveryServicesActiveDirectory"
)

// PossibleIdentityProviderTypeValues returns an array of possible values for the IdentityProviderType const type.
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return []IdentityProviderType{CustomerActiveDirectory, RecoveryServicesActiveDirectory}
}

// InMageV2RpRecoveryPointType enumerates the values for in mage v2 rp recovery point type.
type InMageV2RpRecoveryPointType string

const (
	// InMageV2RpRecoveryPointTypeLatest ...
	InMageV2RpRecoveryPointTypeLatest InMageV2RpRecoveryPointType = "Latest"
	// InMageV2RpRecoveryPointTypeLatestApplicationConsistent ...
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = "LatestApplicationConsistent"
	// InMageV2RpRecoveryPointTypeLatestCrashConsistent ...
	InMageV2RpRecoveryPointTypeLatestCrashConsistent InMageV2RpRecoveryPointType = "LatestCrashConsistent"
	// InMageV2RpRecoveryPointTypeLatestProcessed ...
	InMageV2RpRecoveryPointTypeLatestProcessed InMageV2RpRecoveryPointType = "LatestProcessed"
)

// PossibleInMageV2RpRecoveryPointTypeValues returns an array of possible values for the InMageV2RpRecoveryPointType const type.
func PossibleInMageV2RpRecoveryPointTypeValues() []InMageV2RpRecoveryPointType {
	return []InMageV2RpRecoveryPointType{InMageV2RpRecoveryPointTypeLatest, InMageV2RpRecoveryPointTypeLatestApplicationConsistent, InMageV2RpRecoveryPointTypeLatestCrashConsistent, InMageV2RpRecoveryPointTypeLatestProcessed}
}

// InstanceType enumerates the values for instance type.
type InstanceType string

const (
	// InstanceTypeA2A ...
	InstanceTypeA2A InstanceType = "A2A"
	// InstanceTypeEventProviderSpecificDetails ...
	InstanceTypeEventProviderSpecificDetails InstanceType = "EventProviderSpecificDetails"
	// InstanceTypeHyperVReplica2012 ...
	InstanceTypeHyperVReplica2012 InstanceType = "HyperVReplica2012"
	// InstanceTypeHyperVReplica2012R2 ...
	InstanceTypeHyperVReplica2012R2 InstanceType = "HyperVReplica2012R2"
	// InstanceTypeHyperVReplicaAzure ...
	InstanceTypeHyperVReplicaAzure InstanceType = "HyperVReplicaAzure"
	// InstanceTypeHyperVReplicaBaseEventDetails ...
	InstanceTypeHyperVReplicaBaseEventDetails InstanceType = "HyperVReplicaBaseEventDetails"
	// InstanceTypeInMageAzureV2 ...
	InstanceTypeInMageAzureV2 InstanceType = "InMageAzureV2"
)

// PossibleInstanceTypeValues returns an array of possible values for the InstanceType const type.
func PossibleInstanceTypeValues() []InstanceType {
	return []InstanceType{InstanceTypeA2A, InstanceTypeEventProviderSpecificDetails, InstanceTypeHyperVReplica2012, InstanceTypeHyperVReplica2012R2, InstanceTypeHyperVReplicaAzure, InstanceTypeHyperVReplicaBaseEventDetails, InstanceTypeInMageAzureV2}
}

// InstanceTypeBasicApplyRecoveryPointProviderSpecificInput enumerates the values for instance type basic apply
// recovery point provider specific input.
type InstanceTypeBasicApplyRecoveryPointProviderSpecificInput string

const (
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "A2A"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "ApplyRecoveryPointProviderSpecificInput"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "InMageAzureV2"
)

// PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicApplyRecoveryPointProviderSpecificInput const type.
func PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues() []InstanceTypeBasicApplyRecoveryPointProviderSpecificInput {
	return []InstanceTypeBasicApplyRecoveryPointProviderSpecificInput{InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2}
}

// InstanceTypeBasicConfigurationSettings enumerates the values for instance type basic configuration settings.
type InstanceTypeBasicConfigurationSettings string

const (
	// InstanceTypeConfigurationSettings ...
	InstanceTypeConfigurationSettings InstanceTypeBasicConfigurationSettings = "ConfigurationSettings"
	// InstanceTypeHyperVVirtualMachine ...
	InstanceTypeHyperVVirtualMachine InstanceTypeBasicConfigurationSettings = "HyperVVirtualMachine"
	// InstanceTypeReplicationGroupDetails ...
	InstanceTypeReplicationGroupDetails InstanceTypeBasicConfigurationSettings = "ReplicationGroupDetails"
	// InstanceTypeVMwareVirtualMachine ...
	InstanceTypeVMwareVirtualMachine InstanceTypeBasicConfigurationSettings = "VMwareVirtualMachine"
)

// PossibleInstanceTypeBasicConfigurationSettingsValues returns an array of possible values for the InstanceTypeBasicConfigurationSettings const type.
func PossibleInstanceTypeBasicConfigurationSettingsValues() []InstanceTypeBasicConfigurationSettings {
	return []InstanceTypeBasicConfigurationSettings{InstanceTypeConfigurationSettings, InstanceTypeHyperVVirtualMachine, InstanceTypeReplicationGroupDetails, InstanceTypeVMwareVirtualMachine}
}

// InstanceTypeBasicDisableProtectionProviderSpecificInput enumerates the values for instance type basic
// disable protection provider specific input.
type InstanceTypeBasicDisableProtectionProviderSpecificInput string

const (
	// InstanceTypeDisableProtectionProviderSpecificInput ...
	InstanceTypeDisableProtectionProviderSpecificInput InstanceTypeBasicDisableProtectionProviderSpecificInput = "DisableProtectionProviderSpecificInput"
	// InstanceTypeInMage ...
	InstanceTypeInMage InstanceTypeBasicDisableProtectionProviderSpecificInput = "InMage"
)

// PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicDisableProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues() []InstanceTypeBasicDisableProtectionProviderSpecificInput {
	return []InstanceTypeBasicDisableProtectionProviderSpecificInput{InstanceTypeDisableProtectionProviderSpecificInput, InstanceTypeInMage}
}

// InstanceTypeBasicEnableProtectionProviderSpecificInput enumerates the values for instance type basic enable
// protection provider specific input.
type InstanceTypeBasicEnableProtectionProviderSpecificInput string

const (
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A InstanceTypeBasicEnableProtectionProviderSpecificInput = "A2A"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput InstanceTypeBasicEnableProtectionProviderSpecificInput = "EnableProtectionProviderSpecificInput"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicEnableProtectionProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage InstanceTypeBasicEnableProtectionProviderSpecificInput = "InMage"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicEnableProtectionProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan InstanceTypeBasicEnableProtectionProviderSpecificInput = "San"
)

// PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicEnableProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues() []InstanceTypeBasicEnableProtectionProviderSpecificInput {
	return []InstanceTypeBasicEnableProtectionProviderSpecificInput{InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan}
}

// InstanceTypeBasicEventSpecificDetails enumerates the values for instance type basic event specific details.
type InstanceTypeBasicEventSpecificDetails string

const (
	// InstanceTypeEventSpecificDetails ...
	InstanceTypeEventSpecificDetails InstanceTypeBasicEventSpecificDetails = "EventSpecificDetails"
	// InstanceTypeJobStatus ...
	InstanceTypeJobStatus InstanceTypeBasicEventSpecificDetails = "JobStatus"
)

// PossibleInstanceTypeBasicEventSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicEventSpecificDetails const type.
func PossibleInstanceTypeBasicEventSpecificDetailsValues() []InstanceTypeBasicEventSpecificDetails {
	return []InstanceTypeBasicEventSpecificDetails{InstanceTypeEventSpecificDetails, InstanceTypeJobStatus}
}

// InstanceTypeBasicFabricSpecificCreateNetworkMappingInput enumerates the values for instance type basic
// fabric specific create network mapping input.
type InstanceTypeBasicFabricSpecificCreateNetworkMappingInput string

const (
	// InstanceTypeAzureToAzure ...
	InstanceTypeAzureToAzure InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeFabricSpecificCreateNetworkMappingInput ...
	InstanceTypeFabricSpecificCreateNetworkMappingInput InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "FabricSpecificCreateNetworkMappingInput"
	// InstanceTypeVmmToAzure ...
	InstanceTypeVmmToAzure InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeVmmToVmm ...
	InstanceTypeVmmToVmm InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "VmmToVmm"
)

// PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificCreateNetworkMappingInput const type.
func PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput {
	return []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput{InstanceTypeAzureToAzure, InstanceTypeFabricSpecificCreateNetworkMappingInput, InstanceTypeVmmToAzure, InstanceTypeVmmToVmm}
}

// InstanceTypeBasicFabricSpecificCreationInput enumerates the values for instance type basic fabric specific
// creation input.
type InstanceTypeBasicFabricSpecificCreationInput string

const (
	// InstanceTypeAzure ...
	InstanceTypeAzure InstanceTypeBasicFabricSpecificCreationInput = "Azure"
	// InstanceTypeFabricSpecificCreationInput ...
	InstanceTypeFabricSpecificCreationInput InstanceTypeBasicFabricSpecificCreationInput = "FabricSpecificCreationInput"
	// InstanceTypeVMwareV2 ...
	InstanceTypeVMwareV2 InstanceTypeBasicFabricSpecificCreationInput = "VMwareV2"
)

// PossibleInstanceTypeBasicFabricSpecificCreationInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificCreationInput const type.
func PossibleInstanceTypeBasicFabricSpecificCreationInputValues() []InstanceTypeBasicFabricSpecificCreationInput {
	return []InstanceTypeBasicFabricSpecificCreationInput{InstanceTypeAzure, InstanceTypeFabricSpecificCreationInput, InstanceTypeVMwareV2}
}

// InstanceTypeBasicFabricSpecificDetails enumerates the values for instance type basic fabric specific
// details.
type InstanceTypeBasicFabricSpecificDetails string

const (
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure InstanceTypeBasicFabricSpecificDetails = "Azure"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails InstanceTypeBasicFabricSpecificDetails = "FabricSpecificDetails"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite InstanceTypeBasicFabricSpecificDetails = "HyperVSite"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM InstanceTypeBasicFabricSpecificDetails = "VMM"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware InstanceTypeBasicFabricSpecificDetails = "VMware"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2 ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2 InstanceTypeBasicFabricSpecificDetails = "VMwareV2"
)

// PossibleInstanceTypeBasicFabricSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicFabricSpecificDetails const type.
func PossibleInstanceTypeBasicFabricSpecificDetailsValues() []InstanceTypeBasicFabricSpecificDetails {
	return []InstanceTypeBasicFabricSpecificDetails{InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure, InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails, InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2}
}

// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput enumerates the values for instance type basic
// fabric specific update network mapping input.
type InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput string

const (
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "FabricSpecificUpdateNetworkMappingInput"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "VmmToVmm"
)

// PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput const type.
func PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput {
	return []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput{InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm}
}

// InstanceTypeBasicGroupTaskDetails enumerates the values for instance type basic group task details.
type InstanceTypeBasicGroupTaskDetails string

const (
	// InstanceTypeGroupTaskDetails ...
	InstanceTypeGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "GroupTaskDetails"
	// InstanceTypeInlineWorkflowTaskDetails ...
	InstanceTypeInlineWorkflowTaskDetails InstanceTypeBasicGroupTaskDetails = "InlineWorkflowTaskDetails"
	// InstanceTypeRecoveryPlanGroupTaskDetails ...
	InstanceTypeRecoveryPlanGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "RecoveryPlanGroupTaskDetails"
	// InstanceTypeRecoveryPlanShutdownGroupTaskDetails ...
	InstanceTypeRecoveryPlanShutdownGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "RecoveryPlanShutdownGroupTaskDetails"
)

// PossibleInstanceTypeBasicGroupTaskDetailsValues returns an array of possible values for the InstanceTypeBasicGroupTaskDetails const type.
func PossibleInstanceTypeBasicGroupTaskDetailsValues() []InstanceTypeBasicGroupTaskDetails {
	return []InstanceTypeBasicGroupTaskDetails{InstanceTypeGroupTaskDetails, InstanceTypeInlineWorkflowTaskDetails, InstanceTypeRecoveryPlanGroupTaskDetails, InstanceTypeRecoveryPlanShutdownGroupTaskDetails}
}

// InstanceTypeBasicJobDetails enumerates the values for instance type basic job details.
type InstanceTypeBasicJobDetails string

const (
	// InstanceTypeAsrJobDetails ...
	InstanceTypeAsrJobDetails InstanceTypeBasicJobDetails = "AsrJobDetails"
	// InstanceTypeExportJobDetails ...
	InstanceTypeExportJobDetails InstanceTypeBasicJobDetails = "ExportJobDetails"
	// InstanceTypeFailoverJobDetails ...
	InstanceTypeFailoverJobDetails InstanceTypeBasicJobDetails = "FailoverJobDetails"
	// InstanceTypeJobDetails ...
	InstanceTypeJobDetails InstanceTypeBasicJobDetails = "JobDetails"
	// InstanceTypeSwitchProtectionJobDetails ...
	InstanceTypeSwitchProtectionJobDetails InstanceTypeBasicJobDetails = "SwitchProtectionJobDetails"
	// InstanceTypeTestFailoverJobDetails ...
	InstanceTypeTestFailoverJobDetails InstanceTypeBasicJobDetails = "TestFailoverJobDetails"
)

// PossibleInstanceTypeBasicJobDetailsValues returns an array of possible values for the InstanceTypeBasicJobDetails const type.
func PossibleInstanceTypeBasicJobDetailsValues() []InstanceTypeBasicJobDetails {
	return []InstanceTypeBasicJobDetails{InstanceTypeAsrJobDetails, InstanceTypeExportJobDetails, InstanceTypeFailoverJobDetails, InstanceTypeJobDetails, InstanceTypeSwitchProtectionJobDetails, InstanceTypeTestFailoverJobDetails}
}

// InstanceTypeBasicNetworkMappingFabricSpecificSettings enumerates the values for instance type basic network
// mapping fabric specific settings.
type InstanceTypeBasicNetworkMappingFabricSpecificSettings string

const (
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure InstanceTypeBasicNetworkMappingFabricSpecificSettings = "AzureToAzure"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings InstanceTypeBasicNetworkMappingFabricSpecificSettings = "NetworkMappingFabricSpecificSettings"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure InstanceTypeBasicNetworkMappingFabricSpecificSettings = "VmmToAzure"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm InstanceTypeBasicNetworkMappingFabricSpecificSettings = "VmmToVmm"
)

// PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues returns an array of possible values for the InstanceTypeBasicNetworkMappingFabricSpecificSettings const type.
func PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues() []InstanceTypeBasicNetworkMappingFabricSpecificSettings {
	return []InstanceTypeBasicNetworkMappingFabricSpecificSettings{InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm}
}

// InstanceTypeBasicPolicyProviderSpecificDetails enumerates the values for instance type basic policy provider
// specific details.
type InstanceTypeBasicPolicyProviderSpecificDetails string

const (
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A InstanceTypeBasicPolicyProviderSpecificDetails = "A2A"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplica2012"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplica2012R2"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplicaAzure"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplicaBasePolicyDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage InstanceTypeBasicPolicyProviderSpecificDetails = "InMage"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 InstanceTypeBasicPolicyProviderSpecificDetails = "InMageAzureV2"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = "InMageBasePolicyDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails InstanceTypeBasicPolicyProviderSpecificDetails = "PolicyProviderSpecificDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration InstanceTypeBasicPolicyProviderSpecificDetails = "RcmAzureMigration"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt InstanceTypeBasicPolicyProviderSpecificDetails = "VMwareCbt"
)

// PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicPolicyProviderSpecificDetails const type.
func PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues() []InstanceTypeBasicPolicyProviderSpecificDetails {
	return []InstanceTypeBasicPolicyProviderSpecificDetails{InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt}
}

// InstanceTypeBasicPolicyProviderSpecificInput enumerates the values for instance type basic policy provider
// specific input.
type InstanceTypeBasicPolicyProviderSpecificInput string

const (
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A InstanceTypeBasicPolicyProviderSpecificInput = "A2A"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012 InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplica2012"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplica2012R2"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage InstanceTypeBasicPolicyProviderSpecificInput = "InMage"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicPolicyProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput InstanceTypeBasicPolicyProviderSpecificInput = "PolicyProviderSpecificInput"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt InstanceTypeBasicPolicyProviderSpecificInput = "VMwareCbt"
)

// PossibleInstanceTypeBasicPolicyProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicPolicyProviderSpecificInput const type.
func PossibleInstanceTypeBasicPolicyProviderSpecificInputValues() []InstanceTypeBasicPolicyProviderSpecificInput {
	return []InstanceTypeBasicPolicyProviderSpecificInput{InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt}
}

// InstanceTypeBasicProviderSpecificFailoverInput enumerates the values for instance type basic provider
// specific failover input.
type InstanceTypeBasicProviderSpecificFailoverInput string

const (
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeBasicProviderSpecificFailoverInput = "A2A"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeBasicProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeBasicProviderSpecificFailoverInput = "InMage"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeBasicProviderSpecificFailoverInput = "InMageAzureV2"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput InstanceTypeBasicProviderSpecificFailoverInput = "ProviderSpecificFailoverInput"
)

// PossibleInstanceTypeBasicProviderSpecificFailoverInputValues returns an array of possible values for the InstanceTypeBasicProviderSpecificFailoverInput const type.
func PossibleInstanceTypeBasicProviderSpecificFailoverInputValues() []InstanceTypeBasicProviderSpecificFailoverInput {
	return []InstanceTypeBasicProviderSpecificFailoverInput{InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput}
}

// InstanceTypeBasicRecoveryPlanActionDetails enumerates the values for instance type basic recovery plan
// action details.
type InstanceTypeBasicRecoveryPlanActionDetails string

const (
	// InstanceTypeAutomationRunbookActionDetails ...
	InstanceTypeAutomationRunbookActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "AutomationRunbookActionDetails"
	// InstanceTypeManualActionDetails ...
	InstanceTypeManualActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "ManualActionDetails"
	// InstanceTypeRecoveryPlanActionDetails ...
	InstanceTypeRecoveryPlanActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "RecoveryPlanActionDetails"
	// InstanceTypeScriptActionDetails ...
	InstanceTypeScriptActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "ScriptActionDetails"
)

// PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues returns an array of possible values for the InstanceTypeBasicRecoveryPlanActionDetails const type.
func PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues() []InstanceTypeBasicRecoveryPlanActionDetails {
	return []InstanceTypeBasicRecoveryPlanActionDetails{InstanceTypeAutomationRunbookActionDetails, InstanceTypeManualActionDetails, InstanceTypeRecoveryPlanActionDetails, InstanceTypeScriptActionDetails}
}

// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput enumerates the values for instance type basic
// recovery plan provider specific failover input.
type InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput string

const (
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "A2A"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "InMage"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "InMageAzureV2"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "RecoveryPlanProviderSpecificFailoverInput"
)

// PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues returns an array of possible values for the InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput const type.
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues() []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput {
	return []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput{InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput}
}

// InstanceTypeBasicReplicationProviderSpecificContainerCreationInput enumerates the values for instance type
// basic replication provider specific container creation input.
type InstanceTypeBasicReplicationProviderSpecificContainerCreationInput string

const (
	// InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A ...
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = "A2A"
	// InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput ...
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = "ReplicationProviderSpecificContainerCreationInput"
)

// PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues returns an array of possible values for the InstanceTypeBasicReplicationProviderSpecificContainerCreationInput const type.
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput {
	return []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput{InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A, InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput}
}

// InstanceTypeBasicReplicationProviderSpecificSettings enumerates the values for instance type basic
// replication provider specific settings.
type InstanceTypeBasicReplicationProviderSpecificSettings string

const (
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A InstanceTypeBasicReplicationProviderSpecificSettings = "A2A"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplica2012"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplica2012R2"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplicaAzure"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplicaBaseReplicationDetails"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage InstanceTypeBasicReplicationProviderSpecificSettings = "InMage"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 InstanceTypeBasicReplicationProviderSpecificSettings = "InMageAzureV2"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings InstanceTypeBasicReplicationProviderSpecificSettings = "ReplicationProviderSpecificSettings"
)

// PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues returns an array of possible values for the InstanceTypeBasicReplicationProviderSpecificSettings const type.
func PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues() []InstanceTypeBasicReplicationProviderSpecificSettings {
	return []InstanceTypeBasicReplicationProviderSpecificSettings{InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings}
}

// InstanceTypeBasicReverseReplicationProviderSpecificInput enumerates the values for instance type basic
// reverse replication provider specific input.
type InstanceTypeBasicReverseReplicationProviderSpecificInput string

const (
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A InstanceTypeBasicReverseReplicationProviderSpecificInput = "A2A"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicReverseReplicationProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage InstanceTypeBasicReverseReplicationProviderSpecificInput = "InMage"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicReverseReplicationProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput InstanceTypeBasicReverseReplicationProviderSpecificInput = "ReverseReplicationProviderSpecificInput"
)

// PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicReverseReplicationProviderSpecificInput const type.
func PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues() []InstanceTypeBasicReverseReplicationProviderSpecificInput {
	return []InstanceTypeBasicReverseReplicationProviderSpecificInput{InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput}
}

// InstanceTypeBasicSwitchProtectionProviderSpecificInput enumerates the values for instance type basic switch
// protection provider specific input.
type InstanceTypeBasicSwitchProtectionProviderSpecificInput string

const (
	// InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A InstanceTypeBasicSwitchProtectionProviderSpecificInput = "A2A"
	// InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput ...
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput InstanceTypeBasicSwitchProtectionProviderSpecificInput = "SwitchProtectionProviderSpecificInput"
)

// PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicSwitchProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues() []InstanceTypeBasicSwitchProtectionProviderSpecificInput {
	return []InstanceTypeBasicSwitchProtectionProviderSpecificInput{InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput}
}

// InstanceTypeBasicTaskTypeDetails enumerates the values for instance type basic task type details.
type InstanceTypeBasicTaskTypeDetails string

const (
	// InstanceTypeAutomationRunbookTaskDetails ...
	InstanceTypeAutomationRunbookTaskDetails InstanceTypeBasicTaskTypeDetails = "AutomationRunbookTaskDetails"
	// InstanceTypeConsistencyCheckTaskDetails ...
	InstanceTypeConsistencyCheckTaskDetails InstanceTypeBasicTaskTypeDetails = "ConsistencyCheckTaskDetails"
	// InstanceTypeFabricReplicationGroupTaskDetails ...
	InstanceTypeFabricReplicationGroupTaskDetails InstanceTypeBasicTaskTypeDetails = "FabricReplicationGroupTaskDetails"
	// InstanceTypeJobTaskDetails ...
	InstanceTypeJobTaskDetails InstanceTypeBasicTaskTypeDetails = "JobTaskDetails"
	// InstanceTypeManualActionTaskDetails ...
	InstanceTypeManualActionTaskDetails InstanceTypeBasicTaskTypeDetails = "ManualActionTaskDetails"
	// InstanceTypeScriptActionTaskDetails ...
	InstanceTypeScriptActionTaskDetails InstanceTypeBasicTaskTypeDetails = "ScriptActionTaskDetails"
	// InstanceTypeTaskTypeDetails ...
	InstanceTypeTaskTypeDetails InstanceTypeBasicTaskTypeDetails = "TaskTypeDetails"
	// InstanceTypeVirtualMachineTaskDetails ...
	InstanceTypeVirtualMachineTaskDetails InstanceTypeBasicTaskTypeDetails = "VirtualMachineTaskDetails"
	// InstanceTypeVMNicUpdatesTaskDetails ...
	InstanceTypeVMNicUpdatesTaskDetails InstanceTypeBasicTaskTypeDetails = "VmNicUpdatesTaskDetails"
)

// PossibleInstanceTypeBasicTaskTypeDetailsValues returns an array of possible values for the InstanceTypeBasicTaskTypeDetails const type.
func PossibleInstanceTypeBasicTaskTypeDetailsValues() []InstanceTypeBasicTaskTypeDetails {
	return []InstanceTypeBasicTaskTypeDetails{InstanceTypeAutomationRunbookTaskDetails, InstanceTypeConsistencyCheckTaskDetails, InstanceTypeFabricReplicationGroupTaskDetails, InstanceTypeJobTaskDetails, InstanceTypeManualActionTaskDetails, InstanceTypeScriptActionTaskDetails, InstanceTypeTaskTypeDetails, InstanceTypeVirtualMachineTaskDetails, InstanceTypeVMNicUpdatesTaskDetails}
}

// InstanceTypeBasicUpdateReplicationProtectedItemProviderInput enumerates the values for instance type basic
// update replication protected item provider input.
type InstanceTypeBasicUpdateReplicationProtectedItemProviderInput string

const (
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "A2A"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "HyperVReplicaAzure"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2 InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "InMageAzureV2"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "UpdateReplicationProtectedItemProviderInput"
)

// PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues returns an array of possible values for the InstanceTypeBasicUpdateReplicationProtectedItemProviderInput const type.
func PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues() []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput {
	return []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput{InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput}
}

// LicenseType enumerates the values for license type.
type LicenseType string

const (
	// LicenseTypeNoLicenseType ...
	LicenseTypeNoLicenseType LicenseType = "NoLicenseType"
	// LicenseTypeNotSpecified ...
	LicenseTypeNotSpecified LicenseType = "NotSpecified"
	// LicenseTypeWindowsServer ...
	LicenseTypeWindowsServer LicenseType = "WindowsServer"
)

// PossibleLicenseTypeValues returns an array of possible values for the LicenseType const type.
func PossibleLicenseTypeValues() []LicenseType {
	return []LicenseType{LicenseTypeNoLicenseType, LicenseTypeNotSpecified, LicenseTypeWindowsServer}
}

// MultiVMSyncStatus enumerates the values for multi vm sync status.
type MultiVMSyncStatus string

const (
	// Disabled ...
	Disabled MultiVMSyncStatus = "Disabled"
	// Enabled ...
	Enabled MultiVMSyncStatus = "Enabled"
)

// PossibleMultiVMSyncStatusValues returns an array of possible values for the MultiVMSyncStatus const type.
func PossibleMultiVMSyncStatusValues() []MultiVMSyncStatus {
	return []MultiVMSyncStatus{Disabled, Enabled}
}

// PossibleOperationsDirections enumerates the values for possible operations directions.
type PossibleOperationsDirections string

const (
	// PrimaryToRecovery ...
	PrimaryToRecovery PossibleOperationsDirections = "PrimaryToRecovery"
	// RecoveryToPrimary ...
	RecoveryToPrimary PossibleOperationsDirections = "RecoveryToPrimary"
)

// PossiblePossibleOperationsDirectionsValues returns an array of possible values for the PossibleOperationsDirections const type.
func PossiblePossibleOperationsDirectionsValues() []PossibleOperationsDirections {
	return []PossibleOperationsDirections{PrimaryToRecovery, RecoveryToPrimary}
}

// RecoveryPlanActionLocation enumerates the values for recovery plan action location.
type RecoveryPlanActionLocation string

const (
	// Primary ...
	Primary RecoveryPlanActionLocation = "Primary"
	// Recovery ...
	Recovery RecoveryPlanActionLocation = "Recovery"
)

// PossibleRecoveryPlanActionLocationValues returns an array of possible values for the RecoveryPlanActionLocation const type.
func PossibleRecoveryPlanActionLocationValues() []RecoveryPlanActionLocation {
	return []RecoveryPlanActionLocation{Primary, Recovery}
}

// RecoveryPlanGroupType enumerates the values for recovery plan group type.
type RecoveryPlanGroupType string

const (
	// Boot ...
	Boot RecoveryPlanGroupType = "Boot"
	// Failover ...
	Failover RecoveryPlanGroupType = "Failover"
	// Shutdown ...
	Shutdown RecoveryPlanGroupType = "Shutdown"
)

// PossibleRecoveryPlanGroupTypeValues returns an array of possible values for the RecoveryPlanGroupType const type.
func PossibleRecoveryPlanGroupTypeValues() []RecoveryPlanGroupType {
	return []RecoveryPlanGroupType{Boot, Failover, Shutdown}
}

// RecoveryPointType enumerates the values for recovery point type.
type RecoveryPointType string

const (
	// Custom ...
	Custom RecoveryPointType = "Custom"
	// LatestTag ...
	LatestTag RecoveryPointType = "LatestTag"
	// LatestTime ...
	LatestTime RecoveryPointType = "LatestTime"
)

// PossibleRecoveryPointTypeValues returns an array of possible values for the RecoveryPointType const type.
func PossibleRecoveryPointTypeValues() []RecoveryPointType {
	return []RecoveryPointType{Custom, LatestTag, LatestTime}
}

// ReplicationProtectedItemOperation enumerates the values for replication protected item operation.
type ReplicationProtectedItemOperation string

const (
	// ReplicationProtectedItemOperationChangePit ...
	ReplicationProtectedItemOperationChangePit ReplicationProtectedItemOperation = "ChangePit"
	// ReplicationProtectedItemOperationCommit ...
	ReplicationProtectedItemOperationCommit ReplicationProtectedItemOperation = "Commit"
	// ReplicationProtectedItemOperationCompleteMigration ...
	ReplicationProtectedItemOperationCompleteMigration ReplicationProtectedItemOperation = "CompleteMigration"
	// ReplicationProtectedItemOperationDisableProtection ...
	ReplicationProtectedItemOperationDisableProtection ReplicationProtectedItemOperation = "DisableProtection"
	// ReplicationProtectedItemOperationFailback ...
	ReplicationProtectedItemOperationFailback ReplicationProtectedItemOperation = "Failback"
	// ReplicationProtectedItemOperationFinalizeFailback ...
	ReplicationProtectedItemOperationFinalizeFailback ReplicationProtectedItemOperation = "FinalizeFailback"
	// ReplicationProtectedItemOperationPlannedFailover ...
	ReplicationProtectedItemOperationPlannedFailover ReplicationProtectedItemOperation = "PlannedFailover"
	// ReplicationProtectedItemOperationRepairReplication ...
	ReplicationProtectedItemOperationRepairReplication ReplicationProtectedItemOperation = "RepairReplication"
	// ReplicationProtectedItemOperationReverseReplicate ...
	ReplicationProtectedItemOperationReverseReplicate ReplicationProtectedItemOperation = "ReverseReplicate"
	// ReplicationProtectedItemOperationSwitchProtection ...
	ReplicationProtectedItemOperationSwitchProtection ReplicationProtectedItemOperation = "SwitchProtection"
	// ReplicationProtectedItemOperationTestFailover ...
	ReplicationProtectedItemOperationTestFailover ReplicationProtectedItemOperation = "TestFailover"
	// ReplicationProtectedItemOperationTestFailoverCleanup ...
	ReplicationProtectedItemOperationTestFailoverCleanup ReplicationProtectedItemOperation = "TestFailoverCleanup"
	// ReplicationProtectedItemOperationUnplannedFailover ...
	ReplicationProtectedItemOperationUnplannedFailover ReplicationProtectedItemOperation = "UnplannedFailover"
)

// PossibleReplicationProtectedItemOperationValues returns an array of possible values for the ReplicationProtectedItemOperation const type.
func PossibleReplicationProtectedItemOperationValues() []ReplicationProtectedItemOperation {
	return []ReplicationProtectedItemOperation{ReplicationProtectedItemOperationChangePit, ReplicationProtectedItemOperationCommit, ReplicationProtectedItemOperationCompleteMigration, ReplicationProtectedItemOperationDisableProtection, ReplicationProtectedItemOperationFailback, ReplicationProtectedItemOperationFinalizeFailback, ReplicationProtectedItemOperationPlannedFailover, ReplicationProtectedItemOperationRepairReplication, ReplicationProtectedItemOperationReverseReplicate, ReplicationProtectedItemOperationSwitchProtection, ReplicationProtectedItemOperationTestFailover, ReplicationProtectedItemOperationTestFailoverCleanup, ReplicationProtectedItemOperationUnplannedFailover}
}

// RpInMageRecoveryPointType enumerates the values for rp in mage recovery point type.
type RpInMageRecoveryPointType string

const (
	// RpInMageRecoveryPointTypeCustom ...
	RpInMageRecoveryPointTypeCustom RpInMageRecoveryPointType = "Custom"
	// RpInMageRecoveryPointTypeLatestTag ...
	RpInMageRecoveryPointTypeLatestTag RpInMageRecoveryPointType = "LatestTag"
	// RpInMageRecoveryPointTypeLatestTime ...
	RpInMageRecoveryPointTypeLatestTime RpInMageRecoveryPointType = "LatestTime"
)

// PossibleRpInMageRecoveryPointTypeValues returns an array of possible values for the RpInMageRecoveryPointType const type.
func PossibleRpInMageRecoveryPointTypeValues() []RpInMageRecoveryPointType {
	return []RpInMageRecoveryPointType{RpInMageRecoveryPointTypeCustom, RpInMageRecoveryPointTypeLatestTag, RpInMageRecoveryPointTypeLatestTime}
}

// SetMultiVMSyncStatus enumerates the values for set multi vm sync status.
type SetMultiVMSyncStatus string

const (
	// Disable ...
	Disable SetMultiVMSyncStatus = "Disable"
	// Enable ...
	Enable SetMultiVMSyncStatus = "Enable"
)

// PossibleSetMultiVMSyncStatusValues returns an array of possible values for the SetMultiVMSyncStatus const type.
func PossibleSetMultiVMSyncStatusValues() []SetMultiVMSyncStatus {
	return []SetMultiVMSyncStatus{Disable, Enable}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// Error ...
	Error Severity = "Error"
	// Info ...
	Info Severity = "Info"
	// NONE ...
	NONE Severity = "NONE"
	// Warning ...
	Warning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{Error, Info, NONE, Warning}
}

// SourceSiteOperations enumerates the values for source site operations.
type SourceSiteOperations string

const (
	// NotRequired ...
	NotRequired SourceSiteOperations = "NotRequired"
	// Required ...
	Required SourceSiteOperations = "Required"
)

// PossibleSourceSiteOperationsValues returns an array of possible values for the SourceSiteOperations const type.
func PossibleSourceSiteOperationsValues() []SourceSiteOperations {
	return []SourceSiteOperations{NotRequired, Required}
}

// A2AApplyRecoveryPointInput applyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	aarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aarpi.InstanceType != "" {
		objectMap["instanceType"] = aarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return &aarpi, true
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &aarpi, true
}

// A2AContainerCreationInput a2A cloud creation input.
type A2AContainerCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput', 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificContainerCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) MarshalJSON() ([]byte, error) {
	acci.InstanceType = InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if acci.InstanceType != "" {
		objectMap["instanceType"] = acci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool) {
	return &acci, true
}

// AsReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsReplicationProviderSpecificContainerCreationInput() (*ReplicationProviderSpecificContainerCreationInput, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsBasicReplicationProviderSpecificContainerCreationInput() (BasicReplicationProviderSpecificContainerCreationInput, bool) {
	return &acci, true
}

// A2AEnableProtectionInput a2A enable protection input.
type A2AEnableProtectionInput struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) MarshalJSON() ([]byte, error) {
	aepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aepi.FabricObjectID != nil {
		objectMap["fabricObjectId"] = aepi.FabricObjectID
	}
	if aepi.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = aepi.RecoveryContainerID
	}
	if aepi.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aepi.RecoveryResourceGroupID
	}
	if aepi.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aepi.RecoveryCloudServiceID
	}
	if aepi.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = aepi.RecoveryAvailabilitySetID
	}
	if aepi.VMDisks != nil {
		objectMap["vmDisks"] = aepi.VMDisks
	}
	if aepi.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = aepi.VMManagedDisks
	}
	if aepi.InstanceType != "" {
		objectMap["instanceType"] = aepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return &aepi, true
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &aepi, true
}

// A2AEventDetails model class for event details of a A2A event.
type A2AEventDetails struct {
	// ProtectedItemName - The protected item arm name.
	ProtectedItemName *string `json:"protectedItemName,omitempty"`
	// FabricObjectID - The azure vm arm id.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// FabricName - Fabric arm name.
	FabricName *string `json:"fabricName,omitempty"`
	// FabricLocation - The fabric location.
	FabricLocation *string `json:"fabricLocation,omitempty"`
	// RemoteFabricName - Remote fabric arm name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// RemoteFabricLocation - Remote fabric location.
	RemoteFabricLocation *string `json:"remoteFabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEventDetails.
func (aed A2AEventDetails) MarshalJSON() ([]byte, error) {
	aed.InstanceType = InstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aed.ProtectedItemName != nil {
		objectMap["protectedItemName"] = aed.ProtectedItemName
	}
	if aed.FabricObjectID != nil {
		objectMap["fabricObjectId"] = aed.FabricObjectID
	}
	if aed.FabricName != nil {
		objectMap["fabricName"] = aed.FabricName
	}
	if aed.FabricLocation != nil {
		objectMap["fabricLocation"] = aed.FabricLocation
	}
	if aed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = aed.RemoteFabricName
	}
	if aed.RemoteFabricLocation != nil {
		objectMap["remoteFabricLocation"] = aed.RemoteFabricLocation
	}
	if aed.InstanceType != "" {
		objectMap["instanceType"] = aed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return &aed, true
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &aed, true
}

// A2AFailoverProviderInput a2A provider specific input for failover.
type A2AFailoverProviderInput struct {
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) MarshalJSON() ([]byte, error) {
	afpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if afpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = afpi.RecoveryPointID
	}
	if afpi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = afpi.CloudServiceCreationOption
	}
	if afpi.InstanceType != "" {
		objectMap["instanceType"] = afpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return &afpi, true
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &afpi, true
}

// A2APolicyCreationInput a2A Policy creation input.
type A2APolicyCreationInput struct {
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) MarshalJSON() ([]byte, error) {
	apci.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if apci.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = apci.RecoveryPointHistory
	}
	if apci.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = apci.CrashConsistentFrequencyInMinutes
	}
	if apci.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = apci.AppConsistentFrequencyInMinutes
	}
	if apci.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = apci.MultiVMSyncStatus
	}
	if apci.InstanceType != "" {
		objectMap["instanceType"] = apci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return &apci, true
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &apci, true
}

// A2APolicyDetails a2A specific policy details.
type A2APolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyDetails.
func (apd A2APolicyDetails) MarshalJSON() ([]byte, error) {
	apd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if apd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = apd.RecoveryPointThresholdInMinutes
	}
	if apd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = apd.RecoveryPointHistory
	}
	if apd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = apd.AppConsistentFrequencyInMinutes
	}
	if apd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = apd.MultiVMSyncStatus
	}
	if apd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = apd.CrashConsistentFrequencyInMinutes
	}
	if apd.InstanceType != "" {
		objectMap["instanceType"] = apd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return &apd, true
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &apd, true
}

// A2AProtectedDiskDetails a2A protected disk details.
type A2AProtectedDiskDetails struct {
	// DiskURI - The disk uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountID - The recovery disk storage account.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
	// PrimaryDiskAzureStorageAccountID - The primary disk storage account.
	PrimaryDiskAzureStorageAccountID *string `json:"primaryDiskAzureStorageAccountId,omitempty"`
	// RecoveryDiskURI - Recovery disk uri.
	RecoveryDiskURI *string `json:"recoveryDiskUri,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// DiskType - The type of disk.
	DiskType *string `json:"diskType,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// DataPendingInStagingStorageAccountInMB - The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	// DataPendingAtSourceAgentInMB - The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
}

// A2AProtectedManagedDiskDetails a2A protected managed disk details.
type A2AProtectedManagedDiskDetails struct {
	// DiskID - The managed disk Arm id.
	DiskID *string `json:"diskId,omitempty"`
	// RecoveryAzureResourceGroupID - The recovery disk resource group Arm Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryDiskID - Recovery disk Arm Id.
	RecoveryDiskID *string `json:"recoveryDiskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// DiskType - The type of disk.
	DiskType *string `json:"diskType,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// DataPendingInStagingStorageAccountInMB - The data pending for replication in MB at staging account.
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	// DataPendingAtSourceAgentInMB - The data pending at source virtual machine in MB.
	DataPendingAtSourceAgentInMB *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
}

// A2AReplicationDetails a2A provider specific settings.
type A2AReplicationDetails struct {
	// FabricObjectID - The fabric specific object Id of the virtual machine.
	FabricObjectID *string `json:"fabricObjectId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// ManagementID - The management Id.
	ManagementID *string `json:"managementId,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]A2AProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// ProtectedManagedDisks - The list of protected managed disks.
	ProtectedManagedDisks *[]A2AProtectedManagedDiskDetails `json:"protectedManagedDisks,omitempty"`
	// PrimaryFabricLocation - Primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`
	// RecoveryFabricLocation - The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
	// OsType - The type of operating system.
	OsType *string `json:"osType,omitempty"`
	// RecoveryAzureVMSize - The size of recovery virtual machine.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureVMName - The name of recovery virtual machine.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureResourceGroupID - The recovery resource group.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryCloudService - The recovery cloud service.
	RecoveryCloudService *string `json:"recoveryCloudService,omitempty"`
	// RecoveryAvailabilitySet - The recovery availability set.
	RecoveryAvailabilitySet *string `json:"recoveryAvailabilitySet,omitempty"`
	// SelectedRecoveryAzureNetworkID - The recovery virtual network.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// VMNics - The virtual machine nic details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMSyncedConfigDetails - The synced configuration details.
	VMSyncedConfigDetails *AzureToAzureVMSyncedConfigDetails `json:"vmSyncedConfigDetails,omitempty"`
	// MonitoringPercentageCompletion - The percentage of the monitoring job. The type of the monitoring job is defined by MonitoringJobType property.
	MonitoringPercentageCompletion *int32 `json:"monitoringPercentageCompletion,omitempty"`
	// MonitoringJobType - The type of the monitoring job. The progress is contained in MonitoringPercentageCompletion property.
	MonitoringJobType *string `json:"monitoringJobType,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// IsReplicationAgentUpdateRequired - A value indicating whether replication agent update is required.
	IsReplicationAgentUpdateRequired *bool `json:"isReplicationAgentUpdateRequired,omitempty"`
	// RecoveryFabricObjectID - The recovery fabric object Id.
	RecoveryFabricObjectID *string `json:"recoveryFabricObjectId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// LifecycleID - An id associated with the PE that survives actions like switch protection which change the backing PE/CPE objects internally.The lifecycle id gets carried forward to have a link/continuity in being able to have an Id that denotes the "same" protected item even though other internal Ids/ARM Id might be changing.
	LifecycleID *string `json:"lifecycleId,omitempty"`
	// TestFailoverRecoveryFabricObjectID - The test failover fabric object Id.
	TestFailoverRecoveryFabricObjectID *string `json:"testFailoverRecoveryFabricObjectId,omitempty"`
	// RpoInSeconds - The last RPO value in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// LastRpoCalculatedTime - The time (in UTC) when the last RPO value was calculated by Protection Service.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReplicationDetails.
func (ard A2AReplicationDetails) MarshalJSON() ([]byte, error) {
	ard.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if ard.FabricObjectID != nil {
		objectMap["fabricObjectId"] = ard.FabricObjectID
	}
	if ard.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = ard.MultiVMGroupID
	}
	if ard.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = ard.MultiVMGroupName
	}
	if ard.ManagementID != nil {
		objectMap["managementId"] = ard.ManagementID
	}
	if ard.ProtectedDisks != nil {
		objectMap["protectedDisks"] = ard.ProtectedDisks
	}
	if ard.ProtectedManagedDisks != nil {
		objectMap["protectedManagedDisks"] = ard.ProtectedManagedDisks
	}
	if ard.PrimaryFabricLocation != nil {
		objectMap["primaryFabricLocation"] = ard.PrimaryFabricLocation
	}
	if ard.RecoveryFabricLocation != nil {
		objectMap["recoveryFabricLocation"] = ard.RecoveryFabricLocation
	}
	if ard.OsType != nil {
		objectMap["osType"] = ard.OsType
	}
	if ard.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = ard.RecoveryAzureVMSize
	}
	if ard.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVMName"] = ard.RecoveryAzureVMName
	}
	if ard.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = ard.RecoveryAzureResourceGroupID
	}
	if ard.RecoveryCloudService != nil {
		objectMap["recoveryCloudService"] = ard.RecoveryCloudService
	}
	if ard.RecoveryAvailabilitySet != nil {
		objectMap["recoveryAvailabilitySet"] = ard.RecoveryAvailabilitySet
	}
	if ard.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = ard.SelectedRecoveryAzureNetworkID
	}
	if ard.VMNics != nil {
		objectMap["vmNics"] = ard.VMNics
	}
	if ard.VMSyncedConfigDetails != nil {
		objectMap["vmSyncedConfigDetails"] = ard.VMSyncedConfigDetails
	}
	if ard.MonitoringPercentageCompletion != nil {
		objectMap["monitoringPercentageCompletion"] = ard.MonitoringPercentageCompletion
	}
	if ard.MonitoringJobType != nil {
		objectMap["monitoringJobType"] = ard.MonitoringJobType
	}
	if ard.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = ard.LastHeartbeat
	}
	if ard.AgentVersion != nil {
		objectMap["agentVersion"] = ard.AgentVersion
	}
	if ard.IsReplicationAgentUpdateRequired != nil {
		objectMap["isReplicationAgentUpdateRequired"] = ard.IsReplicationAgentUpdateRequired
	}
	if ard.RecoveryFabricObjectID != nil {
		objectMap["recoveryFabricObjectId"] = ard.RecoveryFabricObjectID
	}
	if ard.VMProtectionState != nil {
		objectMap["vmProtectionState"] = ard.VMProtectionState
	}
	if ard.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = ard.VMProtectionStateDescription
	}
	if ard.LifecycleID != nil {
		objectMap["lifecycleId"] = ard.LifecycleID
	}
	if ard.TestFailoverRecoveryFabricObjectID != nil {
		objectMap["testFailoverRecoveryFabricObjectId"] = ard.TestFailoverRecoveryFabricObjectID
	}
	if ard.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = ard.RpoInSeconds
	}
	if ard.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = ard.LastRpoCalculatedTime
	}
	if ard.InstanceType != "" {
		objectMap["instanceType"] = ard.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return &ard, true
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &ard, true
}

// A2AReprotectInput azure specific reprotect input.
type A2AReprotectInput struct {
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReprotectInput.
func (ari A2AReprotectInput) MarshalJSON() ([]byte, error) {
	ari.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if ari.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = ari.RecoveryContainerID
	}
	if ari.VMDisks != nil {
		objectMap["vmDisks"] = ari.VMDisks
	}
	if ari.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = ari.RecoveryResourceGroupID
	}
	if ari.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = ari.RecoveryCloudServiceID
	}
	if ari.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = ari.RecoveryAvailabilitySetID
	}
	if ari.PolicyID != nil {
		objectMap["policyId"] = ari.PolicyID
	}
	if ari.InstanceType != "" {
		objectMap["instanceType"] = ari.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return &ari, true
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &ari, true
}

// A2ASwitchProtectionInput a2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
	// VMDisks - The list of vm disk details.
	VMDisks *[]A2AVMDiskInputDetails `json:"vmDisks,omitempty"`
	// VMManagedDisks - The list of vm managed disk details.
	VMManagedDisks *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	// RecoveryResourceGroupID - The recovery resource group Id. Valid for V2 scenarios.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// RecoveryCloudServiceID - The recovery cloud service Id. Valid for V1 scenarios.
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput', 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicSwitchProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) MarshalJSON() ([]byte, error) {
	aspi.InstanceType = InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aspi.RecoveryContainerID != nil {
		objectMap["recoveryContainerId"] = aspi.RecoveryContainerID
	}
	if aspi.VMDisks != nil {
		objectMap["vmDisks"] = aspi.VMDisks
	}
	if aspi.VMManagedDisks != nil {
		objectMap["vmManagedDisks"] = aspi.VMManagedDisks
	}
	if aspi.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aspi.RecoveryResourceGroupID
	}
	if aspi.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aspi.RecoveryCloudServiceID
	}
	if aspi.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = aspi.RecoveryAvailabilitySetID
	}
	if aspi.PolicyID != nil {
		objectMap["policyId"] = aspi.PolicyID
	}
	if aspi.InstanceType != "" {
		objectMap["instanceType"] = aspi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ASwitchProtectionInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool) {
	return &aspi, true
}

// AsSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsSwitchProtectionProviderSpecificInput() (*SwitchProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsBasicSwitchProtectionProviderSpecificInput() (BasicSwitchProtectionProviderSpecificInput, bool) {
	return &aspi, true
}

// A2AUpdateReplicationProtectedItemInput inMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	// RecoveryCloudServiceID - The target cloud service ARM Id (for V1).
	RecoveryCloudServiceID *string `json:"recoveryCloudServiceId,omitempty"`
	// RecoveryResourceGroupID - The target resource group ARM Id (for V2).
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	aurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if aurpii.RecoveryCloudServiceID != nil {
		objectMap["recoveryCloudServiceId"] = aurpii.RecoveryCloudServiceID
	}
	if aurpii.RecoveryResourceGroupID != nil {
		objectMap["recoveryResourceGroupId"] = aurpii.RecoveryResourceGroupID
	}
	if aurpii.InstanceType != "" {
		objectMap["instanceType"] = aurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return &aurpii, true
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &aurpii, true
}

// A2AVMDiskInputDetails azure VM disk input details.
type A2AVMDiskInputDetails struct {
	// DiskURI - The disk Uri.
	DiskURI *string `json:"diskUri,omitempty"`
	// RecoveryAzureStorageAccountID - The recovery VHD storage account Id.
	RecoveryAzureStorageAccountID *string `json:"recoveryAzureStorageAccountId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
}

// A2AVMManagedDiskInputDetails azure VM managed disk input details.
type A2AVMManagedDiskInputDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// PrimaryStagingAzureStorageAccountID - The primary staging storage account Arm Id.
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	// RecoveryResourceGroupID - The target resource group Arm Id.
	RecoveryResourceGroupID *string `json:"recoveryResourceGroupId,omitempty"`
}

// AddVCenterRequest input required to add vCenter.
type AddVCenterRequest struct {
	// Properties - The properties of an add vCenter request.
	Properties *AddVCenterRequestProperties `json:"properties,omitempty"`
}

// AddVCenterRequestProperties the properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	// FriendlyName - The friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IPAddress - The IP address of the vCenter to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`
	// ProcessServerID - The process server Id from where the discovery is orchestrated.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// Port - The port number for discovery.
	Port *string `json:"port,omitempty"`
	// RunAsAccountID - The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// Alert implements the Alert class.
type Alert struct {
	autorest.Response `json:"-"`
	// Properties - Alert related data.
	Properties *AlertProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// AlertCollection collection of alerts.
type AlertCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of alerts.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// AlertCollectionIterator provides access to a complete listing of Alert values.
type AlertCollectionIterator struct {
	i    int
	page AlertCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertCollectionIterator) Response() AlertCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertCollectionIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AlertCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// alertCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AlertCollection) alertCollectionPreparer() (*http.Request, error) {
	if ac.NextLink == nil || len(to.String(ac.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// AlertCollectionPage contains a page of Alert values.
type AlertCollectionPage struct {
	fn func(AlertCollection) (AlertCollection, error)
	ac AlertCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertCollectionPage) Next() error {
	next, err := page.fn(page.ac)
	if err != nil {
		return err
	}
	page.ac = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertCollectionPage) Response() AlertCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertCollectionPage) Values() []Alert {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// AlertProperties the proprties of an alert.
type AlertProperties struct {
	// SendToOwners - A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
	// CustomEmailAddresses - The custom email address for sending emails.
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	// Locale - The locale for the email notification.
	Locale *string `json:"locale,omitempty"`
}

// ApplyRecoveryPointInput input to apply recovery point.
type ApplyRecoveryPointInput struct {
	// Properties - The input properties to apply recovery point.
	Properties *ApplyRecoveryPointInputProperties `json:"properties,omitempty"`
}

// ApplyRecoveryPointInputProperties input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	// RecoveryPointID - The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// ProviderSpecificDetails - Provider specific input for applying recovery point.
	ProviderSpecificDetails BasicApplyRecoveryPointProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApplyRecoveryPointInputProperties struct.
func (arpip *ApplyRecoveryPointInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryPointId":
			if v != nil {
				var recoveryPointID string
				err = json.Unmarshal(*v, &recoveryPointID)
				if err != nil {
					return err
				}
				arpip.RecoveryPointID = &recoveryPointID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicApplyRecoveryPointProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				arpip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicApplyRecoveryPointProviderSpecificInput provider specific input for apply recovery point.
type BasicApplyRecoveryPointProviderSpecificInput interface {
	AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool)
	AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool)
	AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool)
	AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool)
}

// ApplyRecoveryPointProviderSpecificInput provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicApplyRecoveryPointProviderSpecificInput(body []byte) (BasicApplyRecoveryPointProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvraarpi HyperVReplicaAzureApplyRecoveryPointInput
		err := json.Unmarshal(body, &hvraarpi)
		return hvraarpi, err
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavarpi InMageAzureV2ApplyRecoveryPointInput
		err := json.Unmarshal(body, &imavarpi)
		return imavarpi, err
	case string(InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A):
		var aarpi A2AApplyRecoveryPointInput
		err := json.Unmarshal(body, &aarpi)
		return aarpi, err
	default:
		var arppsi ApplyRecoveryPointProviderSpecificInput
		err := json.Unmarshal(body, &arppsi)
		return arppsi, err
	}
}
func unmarshalBasicApplyRecoveryPointProviderSpecificInputArray(body []byte) ([]BasicApplyRecoveryPointProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arppsiArray := make([]BasicApplyRecoveryPointProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		arppsi, err := unmarshalBasicApplyRecoveryPointProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		arppsiArray[index] = arppsi
	}
	return arppsiArray, nil
}

// MarshalJSON is the custom marshaler for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) MarshalJSON() ([]byte, error) {
	arppsi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput
	objectMap := make(map[string]interface{})
	if arppsi.InstanceType != "" {
		objectMap["instanceType"] = arppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return &arppsi, true
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for ApplyRecoveryPointProviderSpecificInput.
func (arppsi ApplyRecoveryPointProviderSpecificInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &arppsi, true
}

// ARMException ARM inner exception class.
type ARMException struct {
	// Code - Gets HTTP status code for the error.
	Code *string `json:"code,omitempty"`
	// Message - Gets exception message.
	Message *string `json:"message,omitempty"`
	// Target - Gets exception target.
	Target *string `json:"target,omitempty"`
	// Details - Gets service based error details.
	Details *[]ARMExceptionDetails `json:"details,omitempty"`
	// Innererror - Gets private data for service debugging.
	Innererror *ARMInnerError `json:"innererror,omitempty"`
}

// ARMExceptionDetails service based exception details.
type ARMExceptionDetails struct {
	// Code - Gets service error code.
	Code *string `json:"code,omitempty"`
	// Message - Gets error message.
	Message *string `json:"message,omitempty"`
	// PossibleCauses - Gets possible cause for error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - Gets recommended action for the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ClientRequestID - Gets the client request Id for the session.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ActivityID - Gets the activity Id for the session.
	ActivityID *string `json:"activityId,omitempty"`
	// Target - Gets exception target.
	Target *string `json:"target,omitempty"`
}

// ARMInnerError ARM internal error class for providing additional debug data.
type ARMInnerError struct {
	// Trace - Gets complete stack trace of the exception.
	Trace *string `json:"trace,omitempty"`
	// Source - Gets exception source.
	Source *string `json:"source,omitempty"`
	// MethodStatus - Gets data related to method which threw the exception.
	MethodStatus *MethodCallStatus `json:"methodStatus,omitempty"`
	// CloudID - Gets cloud Id in exception.
	CloudID *string `json:"cloudId,omitempty"`
	// HVHostID - Gets hyperV host ID.
	HVHostID *string `json:"hVHostId,omitempty"`
	// HVClusterID - Gets hyperV cluster Id.
	HVClusterID *string `json:"hVClusterId,omitempty"`
	// NetworkID - Gets network Id.
	NetworkID *string `json:"networkId,omitempty"`
	// VMID - Gets Vm Id.
	VMID *string `json:"vmId,omitempty"`
	// FabricID - Gets Fabric Id.
	FabricID *string `json:"fabricId,omitempty"`
	// LiveID - Gets Live Id of the caller.
	LiveID *string `json:"liveId,omitempty"`
	// ContainerID - Gets container Id of the caller.
	ContainerID *string `json:"containerId,omitempty"`
	// ResourceID - Gets resource id used in the call.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceName - Gets caller resource name.
	ResourceName *string `json:"resourceName,omitempty"`
	// SubscriptionID - Gets subscription Id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// SerializedSRSLogContext - Gets serialized SRS log context.
	SerializedSRSLogContext *string `json:"serializedSRSLogContext,omitempty"`
}

// AsrJobDetails this class represents job details based on specific job type.
type AsrJobDetails struct {
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AsrJobDetails.
func (ajd AsrJobDetails) MarshalJSON() ([]byte, error) {
	ajd.InstanceType = InstanceTypeAsrJobDetails
	objectMap := make(map[string]interface{})
	if ajd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = ajd.AffectedObjectDetails
	}
	if ajd.InstanceType != "" {
		objectMap["instanceType"] = ajd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return &ajd, true
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &ajd, true
}

// ASRTask task of the Job.
type ASRTask struct {
	// TaskID - The Id.
	TaskID *string `json:"taskId,omitempty"`
	// Name - The unique Task name.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AllowedActions - The state/actions applicable on this task.
	AllowedActions *[]string `json:"allowedActions,omitempty"`
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// State - The State. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`
	// StateDescription - The description of the task state. For example - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`
	// TaskType - The type of task. Details in CustomDetails property depend on this type.
	TaskType *string `json:"taskType,omitempty"`
	// CustomDetails - The custom task details based on the task type.
	CustomDetails BasicTaskTypeDetails `json:"customDetails,omitempty"`
	// GroupTaskCustomDetails - The custom task details based on the task type, if the task type is GroupTaskDetails or one of the types derived from it.
	GroupTaskCustomDetails BasicGroupTaskDetails `json:"groupTaskCustomDetails,omitempty"`
	// Errors - The task error details.
	Errors *[]JobErrorDetails `json:"errors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ASRTask struct.
func (at *ASRTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "taskId":
			if v != nil {
				var taskID string
				err = json.Unmarshal(*v, &taskID)
				if err != nil {
					return err
				}
				at.TaskID = &taskID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				at.Name = &name
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				at.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				at.EndTime = &endTime
			}
		case "allowedActions":
			if v != nil {
				var allowedActions []string
				err = json.Unmarshal(*v, &allowedActions)
				if err != nil {
					return err
				}
				at.AllowedActions = &allowedActions
			}
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				at.FriendlyName = &friendlyName
			}
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				at.State = &state
			}
		case "stateDescription":
			if v != nil {
				var stateDescription string
				err = json.Unmarshal(*v, &stateDescription)
				if err != nil {
					return err
				}
				at.StateDescription = &stateDescription
			}
		case "taskType":
			if v != nil {
				var taskType string
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				at.TaskType = &taskType
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicTaskTypeDetails(*v)
				if err != nil {
					return err
				}
				at.CustomDetails = customDetails
			}
		case "groupTaskCustomDetails":
			if v != nil {
				groupTaskCustomDetails, err := unmarshalBasicGroupTaskDetails(*v)
				if err != nil {
					return err
				}
				at.GroupTaskCustomDetails = groupTaskCustomDetails
			}
		case "errors":
			if v != nil {
				var errorsVar []JobErrorDetails
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				at.Errors = &errorsVar
			}
		}
	}

	return nil
}

// AutomationRunbookTaskDetails this class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	// Name - The recovery plan task name.
	Name *string `json:"name,omitempty"`
	// CloudServiceName - The cloud service of the automation runbook account.
	CloudServiceName *string `json:"cloudServiceName,omitempty"`
	// SubscriptionID - The subscription Id of the automation runbook account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// AccountName - The automation account name of the runbook.
	AccountName *string `json:"accountName,omitempty"`
	// RunbookID - The runbook Id.
	RunbookID *string `json:"runbookId,omitempty"`
	// RunbookName - The runbook name.
	RunbookName *string `json:"runbookName,omitempty"`
	// JobID - The job Id of the runbook execution.
	JobID *string `json:"jobId,omitempty"`
	// JobOutput - The execution output of the runbook.
	JobOutput *string `json:"jobOutput,omitempty"`
	// IsPrimarySideScript - A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool `json:"isPrimarySideScript,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) MarshalJSON() ([]byte, error) {
	artd.InstanceType = InstanceTypeAutomationRunbookTaskDetails
	objectMap := make(map[string]interface{})
	if artd.Name != nil {
		objectMap["name"] = artd.Name
	}
	if artd.CloudServiceName != nil {
		objectMap["cloudServiceName"] = artd.CloudServiceName
	}
	if artd.SubscriptionID != nil {
		objectMap["subscriptionId"] = artd.SubscriptionID
	}
	if artd.AccountName != nil {
		objectMap["accountName"] = artd.AccountName
	}
	if artd.RunbookID != nil {
		objectMap["runbookId"] = artd.RunbookID
	}
	if artd.RunbookName != nil {
		objectMap["runbookName"] = artd.RunbookName
	}
	if artd.JobID != nil {
		objectMap["jobId"] = artd.JobID
	}
	if artd.JobOutput != nil {
		objectMap["jobOutput"] = artd.JobOutput
	}
	if artd.IsPrimarySideScript != nil {
		objectMap["isPrimarySideScript"] = artd.IsPrimarySideScript
	}
	if artd.InstanceType != "" {
		objectMap["instanceType"] = artd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return &artd, true
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &artd, true
}

// AzureFabricCreationInput fabric provider specific settings.
type AzureFabricCreationInput struct {
	// Location - The Location.
	Location *string `json:"location,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) MarshalJSON() ([]byte, error) {
	afci.InstanceType = InstanceTypeAzure
	objectMap := make(map[string]interface{})
	if afci.Location != nil {
		objectMap["location"] = afci.Location
	}
	if afci.InstanceType != "" {
		objectMap["instanceType"] = afci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return &afci, true
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &afci, true
}

// AzureFabricSpecificDetails azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	// Location - The Location for the Azure fabric.
	Location *string `json:"location,omitempty"`
	// ContainerIds - The container Ids for the Azure fabric.
	ContainerIds *[]string `json:"containerIds,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	afsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure
	objectMap := make(map[string]interface{})
	if afsd.Location != nil {
		objectMap["location"] = afsd.Location
	}
	if afsd.ContainerIds != nil {
		objectMap["containerIds"] = afsd.ContainerIds
	}
	if afsd.InstanceType != "" {
		objectMap["instanceType"] = afsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return &afsd, true
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &afsd, true
}

// AzureToAzureCreateNetworkMappingInput create network mappings input properties/behaviour specific to Azure to
// Azure Network mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	// PrimaryNetworkID - The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	atacnmi.InstanceType = InstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if atacnmi.PrimaryNetworkID != nil {
		objectMap["primaryNetworkId"] = atacnmi.PrimaryNetworkID
	}
	if atacnmi.InstanceType != "" {
		objectMap["instanceType"] = atacnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return &atacnmi, true
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &atacnmi, true
}

// AzureToAzureNetworkMappingSettings a2A Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	// PrimaryFabricLocation - The primary fabric location.
	PrimaryFabricLocation *string `json:"primaryFabricLocation,omitempty"`
	// RecoveryFabricLocation - The recovery fabric location.
	RecoveryFabricLocation *string `json:"recoveryFabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	atanms.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if atanms.PrimaryFabricLocation != nil {
		objectMap["primaryFabricLocation"] = atanms.PrimaryFabricLocation
	}
	if atanms.RecoveryFabricLocation != nil {
		objectMap["recoveryFabricLocation"] = atanms.RecoveryFabricLocation
	}
	if atanms.InstanceType != "" {
		objectMap["instanceType"] = atanms.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return &atanms, true
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return nil, false
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &atanms, true
}

// AzureToAzureUpdateNetworkMappingInput updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	// PrimaryNetworkID - The primary azure vnet Id.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	ataunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure
	objectMap := make(map[string]interface{})
	if ataunmi.PrimaryNetworkID != nil {
		objectMap["primaryNetworkId"] = ataunmi.PrimaryNetworkID
	}
	if ataunmi.InstanceType != "" {
		objectMap["instanceType"] = ataunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return &ataunmi, true
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &ataunmi, true
}

// AzureToAzureVMSyncedConfigDetails azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	// Tags - The Azure VM tags.
	Tags map[string]*string `json:"tags"`
	// RoleAssignments - The Azure role assignments.
	RoleAssignments *[]RoleAssignment `json:"roleAssignments,omitempty"`
	// InputEndpoints - The Azure VM input endpoints.
	InputEndpoints *[]InputEndpoint `json:"inputEndpoints,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureVMSyncedConfigDetails.
func (atavscd AzureToAzureVMSyncedConfigDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atavscd.Tags != nil {
		objectMap["tags"] = atavscd.Tags
	}
	if atavscd.RoleAssignments != nil {
		objectMap["roleAssignments"] = atavscd.RoleAssignments
	}
	if atavscd.InputEndpoints != nil {
		objectMap["inputEndpoints"] = atavscd.InputEndpoints
	}
	return json.Marshal(objectMap)
}

// AzureVMDiskDetails disk details for E2A provider.
type AzureVMDiskDetails struct {
	// VhdType - VHD type.
	VhdType *string `json:"vhdType,omitempty"`
	// VhdID - The VHD id.
	VhdID *string `json:"vhdId,omitempty"`
	// VhdName - VHD name.
	VhdName *string `json:"vhdName,omitempty"`
	// MaxSizeMB - Max side in MB.
	MaxSizeMB *string `json:"maxSizeMB,omitempty"`
	// TargetDiskLocation - Blob uri of the Azure disk.
	TargetDiskLocation *string `json:"targetDiskLocation,omitempty"`
	// TargetDiskName - The target Azure disk name.
	TargetDiskName *string `json:"targetDiskName,omitempty"`
	// LunID - Ordinal\LunId of the disk for the Azure VM.
	LunID *string `json:"lunId,omitempty"`
}

// BasicConfigurationSettings replication provider specific settings.
type BasicConfigurationSettings interface {
	AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool)
	AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool)
	AsReplicationGroupDetails() (*ReplicationGroupDetails, bool)
	AsConfigurationSettings() (*ConfigurationSettings, bool)
}

// ConfigurationSettings replication provider specific settings.
type ConfigurationSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeVMwareVirtualMachine', 'InstanceTypeReplicationGroupDetails'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicConfigurationSettings(body []byte) (BasicConfigurationSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVVirtualMachine):
		var hvvmd HyperVVirtualMachineDetails
		err := json.Unmarshal(body, &hvvmd)
		return hvvmd, err
	case string(InstanceTypeVMwareVirtualMachine):
		var vmvmd VMwareVirtualMachineDetails
		err := json.Unmarshal(body, &vmvmd)
		return vmvmd, err
	case string(InstanceTypeReplicationGroupDetails):
		var rgd ReplicationGroupDetails
		err := json.Unmarshal(body, &rgd)
		return rgd, err
	default:
		var cs ConfigurationSettings
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicConfigurationSettingsArray(body []byte) ([]BasicConfigurationSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicConfigurationSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicConfigurationSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ConfigurationSettings.
func (cs ConfigurationSettings) MarshalJSON() ([]byte, error) {
	cs.InstanceType = InstanceTypeConfigurationSettings
	objectMap := make(map[string]interface{})
	if cs.InstanceType != "" {
		objectMap["instanceType"] = cs.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return &cs, true
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for ConfigurationSettings.
func (cs ConfigurationSettings) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &cs, true
}

// ConfigureAlertRequest request to configure alerts for the system.
type ConfigureAlertRequest struct {
	// Properties - The properties of a configure alert request.
	Properties *ConfigureAlertRequestProperties `json:"properties,omitempty"`
}

// ConfigureAlertRequestProperties properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	// SendToOwners - A value indicating whether to send email to subscription administrator.
	SendToOwners *string `json:"sendToOwners,omitempty"`
	// CustomEmailAddresses - The custom email address for sending emails.
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	// Locale - The locale for the email notification.
	Locale *string `json:"locale,omitempty"`
}

// ConsistencyCheckTaskDetails this class contains monitoring details of all the inconsistent Protected Entites in
// Vmm.
type ConsistencyCheckTaskDetails struct {
	// VMDetails - The list of inconsistent Vm details.
	VMDetails *[]InconsistentVMDetails `json:"vmDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) MarshalJSON() ([]byte, error) {
	cctd.InstanceType = InstanceTypeConsistencyCheckTaskDetails
	objectMap := make(map[string]interface{})
	if cctd.VMDetails != nil {
		objectMap["vmDetails"] = cctd.VMDetails
	}
	if cctd.InstanceType != "" {
		objectMap["instanceType"] = cctd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return &cctd, true
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &cctd, true
}

// CreateNetworkMappingInput create network mappings input.
type CreateNetworkMappingInput struct {
	// Properties - Input properties for creating network mapping.
	Properties *CreateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// CreateNetworkMappingInputProperties common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	// RecoveryFabricName - Recovery fabric Name.
	RecoveryFabricName *string `json:"recoveryFabricName,omitempty"`
	// RecoveryNetworkID - Recovery network Id.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
	// FabricSpecificDetails - Fabric specific input properties.
	FabricSpecificDetails BasicFabricSpecificCreateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateNetworkMappingInputProperties struct.
func (cnmip *CreateNetworkMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryFabricName":
			if v != nil {
				var recoveryFabricName string
				err = json.Unmarshal(*v, &recoveryFabricName)
				if err != nil {
					return err
				}
				cnmip.RecoveryFabricName = &recoveryFabricName
			}
		case "recoveryNetworkId":
			if v != nil {
				var recoveryNetworkID string
				err = json.Unmarshal(*v, &recoveryNetworkID)
				if err != nil {
					return err
				}
				cnmip.RecoveryNetworkID = &recoveryNetworkID
			}
		case "fabricSpecificDetails":
			if v != nil {
				fabricSpecificDetails, err := unmarshalBasicFabricSpecificCreateNetworkMappingInput(*v)
				if err != nil {
					return err
				}
				cnmip.FabricSpecificDetails = fabricSpecificDetails
			}
		}
	}

	return nil
}

// CreatePolicyInput protection profile input.
type CreatePolicyInput struct {
	// Properties - Policy creation properties.
	Properties *CreatePolicyInputProperties `json:"properties,omitempty"`
}

// CreatePolicyInputProperties policy creation properties.
type CreatePolicyInputProperties struct {
	// ProviderSpecificInput - The ReplicationProviderSettings.
	ProviderSpecificInput BasicPolicyProviderSpecificInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreatePolicyInputProperties struct.
func (cpip *CreatePolicyInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicPolicyProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				cpip.ProviderSpecificInput = providerSpecificInput
			}
		}
	}

	return nil
}

// CreateProtectionContainerInput create protection container input.
type CreateProtectionContainerInput struct {
	// Properties - Create protection container input properties.
	Properties *CreateProtectionContainerInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerInputProperties create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	// ProviderSpecificInput - Provider specific inputs for container creation.
	ProviderSpecificInput *[]BasicReplicationProviderSpecificContainerCreationInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateProtectionContainerInputProperties struct.
func (cpcip *CreateProtectionContainerInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "providerSpecificInput":
			if v != nil {
				providerSpecificInput, err := unmarshalBasicReplicationProviderSpecificContainerCreationInputArray(*v)
				if err != nil {
					return err
				}
				cpcip.ProviderSpecificInput = &providerSpecificInput
			}
		}
	}

	return nil
}

// CreateProtectionContainerMappingInput configure pairing input.
type CreateProtectionContainerMappingInput struct {
	// Properties - Configure protection input properties.
	Properties *CreateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerMappingInputProperties configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	// TargetProtectionContainerID - The target unique protection container name.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
	// PolicyID - Applicable policy.
	PolicyID *string `json:"PolicyId,omitempty"`
	// ProviderSpecificInput - Provider specific input for pairing.
	ProviderSpecificInput *ReplicationProviderSpecificContainerMappingInput `json:"providerSpecificInput,omitempty"`
}

// CreateRecoveryPlanInput create recovery plan input class.
type CreateRecoveryPlanInput struct {
	// Properties - Recovery plan creation properties.
	Properties *CreateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// CreateRecoveryPlanInputProperties recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	// PrimaryFabricID - The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`
	// RecoveryFabricID - The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// FailoverDeploymentModel - The failover deployment model. Possible values include: 'NotApplicable', 'Classic', 'ResourceManager'
	FailoverDeploymentModel FailoverDeploymentModel `json:"failoverDeploymentModel,omitempty"`
	// Groups - The recovery plan groups.
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
}

// CurrentScenarioDetails current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	// ScenarioName - Scenario name.
	ScenarioName *string `json:"scenarioName,omitempty"`
	// JobID - ARM Id of the job being executed.
	JobID *string `json:"jobId,omitempty"`
	// StartTime - Start time of the workflow.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// DataStore the datastore details of the MT.
type DataStore struct {
	// SymbolicName - The symbolic name of data store.
	SymbolicName *string `json:"symbolicName,omitempty"`
	// UUID - The uuid of data store.
	UUID *string `json:"uuid,omitempty"`
	// Capacity - The capacity of data store in GBs.
	Capacity *string `json:"capacity,omitempty"`
	// FreeSpace - The free space of data store in GBs.
	FreeSpace *string `json:"freeSpace,omitempty"`
	// Type - The type of data store.
	Type *string `json:"type,omitempty"`
}

// DisableProtectionInput disable protection input.
type DisableProtectionInput struct {
	// Properties - Disable protection input properties.
	Properties *DisableProtectionInputProperties `json:"properties,omitempty"`
}

// DisableProtectionInputProperties disable protection input properties.
type DisableProtectionInputProperties struct {
	// DisableProtectionReason - Disable protection reason. It can have values NotSpecified/MigrationComplete. Possible values include: 'NotSpecified', 'MigrationComplete'
	DisableProtectionReason DisableProtectionReason `json:"disableProtectionReason,omitempty"`
	// ReplicationProviderInput - Replication provider specific input.
	ReplicationProviderInput BasicDisableProtectionProviderSpecificInput `json:"replicationProviderInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DisableProtectionInputProperties struct.
func (dpip *DisableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "disableProtectionReason":
			if v != nil {
				var disableProtectionReason DisableProtectionReason
				err = json.Unmarshal(*v, &disableProtectionReason)
				if err != nil {
					return err
				}
				dpip.DisableProtectionReason = disableProtectionReason
			}
		case "replicationProviderInput":
			if v != nil {
				replicationProviderInput, err := unmarshalBasicDisableProtectionProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				dpip.ReplicationProviderInput = replicationProviderInput
			}
		}
	}

	return nil
}

// BasicDisableProtectionProviderSpecificInput disable protection provider specific input.
type BasicDisableProtectionProviderSpecificInput interface {
	AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool)
	AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool)
}

// DisableProtectionProviderSpecificInput disable protection provider specific input.
type DisableProtectionProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeDisableProtectionProviderSpecificInput', 'InstanceTypeInMage'
	InstanceType InstanceTypeBasicDisableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicDisableProtectionProviderSpecificInput(body []byte) (BasicDisableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInMage):
		var imdppsi InMageDisableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &imdppsi)
		return imdppsi, err
	default:
		var dppsi DisableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &dppsi)
		return dppsi, err
	}
}
func unmarshalBasicDisableProtectionProviderSpecificInputArray(body []byte) ([]BasicDisableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dppsiArray := make([]BasicDisableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dppsi, err := unmarshalBasicDisableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		dppsiArray[index] = dppsi
	}
	return dppsiArray, nil
}

// MarshalJSON is the custom marshaler for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	dppsi.InstanceType = InstanceTypeDisableProtectionProviderSpecificInput
	objectMap := make(map[string]interface{})
	if dppsi.InstanceType != "" {
		objectMap["instanceType"] = dppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInMageDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool) {
	return &dppsi, true
}

// AsBasicDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for DisableProtectionProviderSpecificInput.
func (dppsi DisableProtectionProviderSpecificInput) AsBasicDisableProtectionProviderSpecificInput() (BasicDisableProtectionProviderSpecificInput, bool) {
	return &dppsi, true
}

// DiscoverProtectableItemRequest request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	// Properties - The properties of a discover protectable item request.
	Properties *DiscoverProtectableItemRequestProperties `json:"properties,omitempty"`
}

// DiscoverProtectableItemRequestProperties discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	// FriendlyName - The friendly name of the physical machine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IPAddress - The IP address of the physical machine to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`
	// OsType - The OS type on the physical machine.
	OsType *string `json:"osType,omitempty"`
}

// DiskDetails onprem disk details data.
type DiskDetails struct {
	// MaxSizeMB - The hard disk max size in MB.
	MaxSizeMB *int64 `json:"maxSizeMB,omitempty"`
	// VhdType - The type of the volume.
	VhdType *string `json:"vhdType,omitempty"`
	// VhdID - The VHD Id.
	VhdID *string `json:"vhdId,omitempty"`
	// VhdName - The VHD name.
	VhdName *string `json:"vhdName,omitempty"`
}

// DiskVolumeDetails volume details.
type DiskVolumeDetails struct {
	// Label - The volume label.
	Label *string `json:"label,omitempty"`
	// Name - The volume name.
	Name *string `json:"name,omitempty"`
}

// Display contains the localized display information for this particular operation / action. These value will be
// used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event
// service; and (3) audit history / records for management operations.
type Display struct {
	// Provider - The provider. The localized friendly form of the resource provider name – it is expected to also include the publisher/company responsible. It should use Title Casing and begin with "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or "Microsoft Compute."
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource. The localized friendly form of the resource related to this action/operation – it should match the public documentation for the resource provider. It should use Title Casing. This value should be unique for a particular URL type (e.g. nested types should *not* reuse their parent’s display.resource field). e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM Sizes" or "Scheduler Jobs"
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation. The localized friendly name for the operation, as it should be shown to the user. It should be concise (to fit in drop downs) but clear (i.e. self-documenting). It should use Title Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'
	Operation *string `json:"operation,omitempty"`
	// Description - The description. The localized friendly description for the operation, as it should be shown to the user. It should be thorough, yet concise – it will be used in tool tips and detailed views. Prescriptive guidance for namespaces: Read any 'display.provider' resource Create or Update any 'display.provider' resource Delete any 'display.provider' resource Perform any other action on any 'display.provider' resource Prescriptive guidance for namespaces: Read any 'display.resource' Create or Update any 'display.resource' Delete any 'display.resource' 'ActionName' any 'display.resources'
	Description *string `json:"description,omitempty"`
}

// EnableProtectionInput enable protection input.
type EnableProtectionInput struct {
	// Properties - Enable protection input properties.
	Properties *EnableProtectionInputProperties `json:"properties,omitempty"`
}

// EnableProtectionInputProperties enable protection input properties.
type EnableProtectionInputProperties struct {
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// ProtectableItemID - The protectable item Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`
	// ProviderSpecificDetails - The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
	ProviderSpecificDetails BasicEnableProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EnableProtectionInputProperties struct.
func (epip *EnableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				epip.PolicyID = &policyID
			}
		case "protectableItemId":
			if v != nil {
				var protectableItemID string
				err = json.Unmarshal(*v, &protectableItemID)
				if err != nil {
					return err
				}
				epip.ProtectableItemID = &protectableItemID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicEnableProtectionProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				epip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicEnableProtectionProviderSpecificInput enable protection provider specific input.
type BasicEnableProtectionProviderSpecificInput interface {
	AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool)
	AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool)
	AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool)
	AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool)
	AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool)
	AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool)
}

// EnableProtectionProviderSpecificInput enable protection provider specific input.
type EnableProtectionProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicEnableProtectionProviderSpecificInput(body []byte) (BasicEnableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvraepi HyperVReplicaAzureEnableProtectionInput
		err := json.Unmarshal(body, &hvraepi)
		return hvraepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan):
		var sepi SanEnableProtectionInput
		err := json.Unmarshal(body, &sepi)
		return sepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavepi InMageAzureV2EnableProtectionInput
		err := json.Unmarshal(body, &imavepi)
		return imavepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage):
		var imepi InMageEnableProtectionInput
		err := json.Unmarshal(body, &imepi)
		return imepi, err
	case string(InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A):
		var aepi A2AEnableProtectionInput
		err := json.Unmarshal(body, &aepi)
		return aepi, err
	default:
		var eppsi EnableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &eppsi)
		return eppsi, err
	}
}
func unmarshalBasicEnableProtectionProviderSpecificInputArray(body []byte) ([]BasicEnableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eppsiArray := make([]BasicEnableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eppsi, err := unmarshalBasicEnableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		eppsiArray[index] = eppsi
	}
	return eppsiArray, nil
}

// MarshalJSON is the custom marshaler for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	eppsi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput
	objectMap := make(map[string]interface{})
	if eppsi.InstanceType != "" {
		objectMap["instanceType"] = eppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return &eppsi, true
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for EnableProtectionProviderSpecificInput.
func (eppsi EnableProtectionProviderSpecificInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &eppsi, true
}

// EncryptionDetails encryption details for the fabric.
type EncryptionDetails struct {
	// KekState - The key encryption key state for the Vmm.
	KekState *string `json:"kekState,omitempty"`
	// KekCertThumbprint - The key encryption key certificate thumbprint.
	KekCertThumbprint *string `json:"kekCertThumbprint,omitempty"`
	// KekCertExpiryDate - The key encryption key certificate expiry date.
	KekCertExpiryDate *date.Time `json:"kekCertExpiryDate,omitempty"`
}

// Event implements the Event class.
type Event struct {
	autorest.Response `json:"-"`
	// Properties - Event related data.
	Properties *EventProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// EventCollection collection of fabric details.
type EventCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventCollectionIterator provides access to a complete listing of Event values.
type EventCollectionIterator struct {
	i    int
	page EventCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventCollectionIterator) Response() EventCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventCollectionIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ec EventCollection) IsEmpty() bool {
	return ec.Value == nil || len(*ec.Value) == 0
}

// eventCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ec EventCollection) eventCollectionPreparer() (*http.Request, error) {
	if ec.NextLink == nil || len(to.String(ec.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ec.NextLink)))
}

// EventCollectionPage contains a page of Event values.
type EventCollectionPage struct {
	fn func(EventCollection) (EventCollection, error)
	ec EventCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventCollectionPage) Next() error {
	next, err := page.fn(page.ec)
	if err != nil {
		return err
	}
	page.ec = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventCollectionPage) NotDone() bool {
	return !page.ec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventCollectionPage) Response() EventCollection {
	return page.ec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventCollectionPage) Values() []Event {
	if page.ec.IsEmpty() {
		return nil
	}
	return *page.ec.Value
}

// EventProperties the properties of a monitoring event.
type EventProperties struct {
	// EventCode - The Id of the monitoring event.
	EventCode *string `json:"eventCode,omitempty"`
	// Description - The event name.
	Description *string `json:"description,omitempty"`
	// EventType - The type of the event. for example: VM Health, Server Health, Job Failure etc.
	EventType *string `json:"eventType,omitempty"`
	// AffectedObjectFriendlyName - The friendly name of the source of the event on which it is raised (for example, VM, VMM etc).
	AffectedObjectFriendlyName *string `json:"affectedObjectFriendlyName,omitempty"`
	// Severity - The severity of the event.
	Severity *string `json:"severity,omitempty"`
	// TimeOfOccurrence - The time of occurence of the event.
	TimeOfOccurrence *date.Time `json:"timeOfOccurrence,omitempty"`
	// FabricID - The ARM ID of the fabric.
	FabricID *string `json:"fabricId,omitempty"`
	// ProviderSpecificDetails - The provider specific settings.
	ProviderSpecificDetails BasicEventProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	// EventSpecificDetails - The event specific settings.
	EventSpecificDetails BasicEventSpecificDetails `json:"eventSpecificDetails,omitempty"`
	// HealthErrors - The list of errors / warnings capturing details associated with the issue(s).
	HealthErrors *[]HealthError `json:"healthErrors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventProperties struct.
func (ep *EventProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "eventCode":
			if v != nil {
				var eventCode string
				err = json.Unmarshal(*v, &eventCode)
				if err != nil {
					return err
				}
				ep.EventCode = &eventCode
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ep.Description = &description
			}
		case "eventType":
			if v != nil {
				var eventType string
				err = json.Unmarshal(*v, &eventType)
				if err != nil {
					return err
				}
				ep.EventType = &eventType
			}
		case "affectedObjectFriendlyName":
			if v != nil {
				var affectedObjectFriendlyName string
				err = json.Unmarshal(*v, &affectedObjectFriendlyName)
				if err != nil {
					return err
				}
				ep.AffectedObjectFriendlyName = &affectedObjectFriendlyName
			}
		case "severity":
			if v != nil {
				var severity string
				err = json.Unmarshal(*v, &severity)
				if err != nil {
					return err
				}
				ep.Severity = &severity
			}
		case "timeOfOccurrence":
			if v != nil {
				var timeOfOccurrence date.Time
				err = json.Unmarshal(*v, &timeOfOccurrence)
				if err != nil {
					return err
				}
				ep.TimeOfOccurrence = &timeOfOccurrence
			}
		case "fabricId":
			if v != nil {
				var fabricID string
				err = json.Unmarshal(*v, &fabricID)
				if err != nil {
					return err
				}
				ep.FabricID = &fabricID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicEventProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				ep.ProviderSpecificDetails = providerSpecificDetails
			}
		case "eventSpecificDetails":
			if v != nil {
				eventSpecificDetails, err := unmarshalBasicEventSpecificDetails(*v)
				if err != nil {
					return err
				}
				ep.EventSpecificDetails = eventSpecificDetails
			}
		case "healthErrors":
			if v != nil {
				var healthErrors []HealthError
				err = json.Unmarshal(*v, &healthErrors)
				if err != nil {
					return err
				}
				ep.HealthErrors = &healthErrors
			}
		}
	}

	return nil
}

// BasicEventProviderSpecificDetails model class for provider specific details for an event.
type BasicEventProviderSpecificDetails interface {
	AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool)
	AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool)
	AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool)
	AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool)
	AsA2AEventDetails() (*A2AEventDetails, bool)
	AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool)
	AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool)
}

// EventProviderSpecificDetails model class for provider specific details for an event.
type EventProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

func unmarshalBasicEventProviderSpecificDetails(body []byte) (BasicEventProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVReplicaBaseEventDetails):
		var hvrbed HyperVReplicaBaseEventDetails
		err := json.Unmarshal(body, &hvrbed)
		return hvrbed, err
	case string(InstanceTypeHyperVReplica2012):
		var hvr2ed HyperVReplica2012EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeHyperVReplica2012R2):
		var hvr2ed HyperVReplica2012R2EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeHyperVReplicaAzure):
		var hvraed HyperVReplicaAzureEventDetails
		err := json.Unmarshal(body, &hvraed)
		return hvraed, err
	case string(InstanceTypeA2A):
		var aed A2AEventDetails
		err := json.Unmarshal(body, &aed)
		return aed, err
	case string(InstanceTypeInMageAzureV2):
		var imaved InMageAzureV2EventDetails
		err := json.Unmarshal(body, &imaved)
		return imaved, err
	default:
		var epsd EventProviderSpecificDetails
		err := json.Unmarshal(body, &epsd)
		return epsd, err
	}
}
func unmarshalBasicEventProviderSpecificDetailsArray(body []byte) ([]BasicEventProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	epsdArray := make([]BasicEventProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		epsd, err := unmarshalBasicEventProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		epsdArray[index] = epsd
	}
	return epsdArray, nil
}

// MarshalJSON is the custom marshaler for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	epsd.InstanceType = InstanceTypeEventProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if epsd.InstanceType != "" {
		objectMap["instanceType"] = epsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return &epsd, true
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for EventProviderSpecificDetails.
func (epsd EventProviderSpecificDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &epsd, true
}

// EventQueryParameter implements the event query parameter.
type EventQueryParameter struct {
	// EventCode - The source id of the events to be queried.
	EventCode *string `json:"EventCode,omitempty"`
	// Severity - The severity of the events to be queried.
	Severity *string `json:"Severity,omitempty"`
	// EventType - The type of the events to be queried.
	EventType *string `json:"EventType,omitempty"`
	// FabricName - The affected object server id of the events to be queried.
	FabricName *string `json:"FabricName,omitempty"`
	// AffectedObjectFriendlyName - The affected object name of the events to be queried.
	AffectedObjectFriendlyName *string `json:"AffectedObjectFriendlyName,omitempty"`
	// StartTime - The start time of the time range within which the events are to be queried.
	StartTime *date.Time `json:"StartTime,omitempty"`
	// EndTime - The end time of the time range within which the events are to be queried.
	EndTime *date.Time `json:"EndTime,omitempty"`
}

// BasicEventSpecificDetails model class for event specific details for an event.
type BasicEventSpecificDetails interface {
	AsJobStatusEventDetails() (*JobStatusEventDetails, bool)
	AsEventSpecificDetails() (*EventSpecificDetails, bool)
}

// EventSpecificDetails model class for event specific details for an event.
type EventSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeEventSpecificDetails', 'InstanceTypeJobStatus'
	InstanceType InstanceTypeBasicEventSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicEventSpecificDetails(body []byte) (BasicEventSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeJobStatus):
		var jsed JobStatusEventDetails
		err := json.Unmarshal(body, &jsed)
		return jsed, err
	default:
		var esd EventSpecificDetails
		err := json.Unmarshal(body, &esd)
		return esd, err
	}
}
func unmarshalBasicEventSpecificDetailsArray(body []byte) ([]BasicEventSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]BasicEventSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalBasicEventSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// MarshalJSON is the custom marshaler for EventSpecificDetails.
func (esd EventSpecificDetails) MarshalJSON() ([]byte, error) {
	esd.InstanceType = InstanceTypeEventSpecificDetails
	objectMap := make(map[string]interface{})
	if esd.InstanceType != "" {
		objectMap["instanceType"] = esd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobStatusEventDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsJobStatusEventDetails() (*JobStatusEventDetails, bool) {
	return nil, false
}

// AsEventSpecificDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsEventSpecificDetails() (*EventSpecificDetails, bool) {
	return &esd, true
}

// AsBasicEventSpecificDetails is the BasicEventSpecificDetails implementation for EventSpecificDetails.
func (esd EventSpecificDetails) AsBasicEventSpecificDetails() (BasicEventSpecificDetails, bool) {
	return &esd, true
}

// ExportJobDetails this class represents details for export jobs workflow.
type ExportJobDetails struct {
	// BlobURI - BlobUri of the exported jobs.
	BlobURI *string `json:"blobUri,omitempty"`
	// SasToken - The sas token to access blob.
	SasToken *string `json:"sasToken,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportJobDetails.
func (ejd ExportJobDetails) MarshalJSON() ([]byte, error) {
	ejd.InstanceType = InstanceTypeExportJobDetails
	objectMap := make(map[string]interface{})
	if ejd.BlobURI != nil {
		objectMap["blobUri"] = ejd.BlobURI
	}
	if ejd.SasToken != nil {
		objectMap["sasToken"] = ejd.SasToken
	}
	if ejd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = ejd.AffectedObjectDetails
	}
	if ejd.InstanceType != "" {
		objectMap["instanceType"] = ejd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return &ejd, true
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &ejd, true
}

// Fabric fabric definition.
type Fabric struct {
	autorest.Response `json:"-"`
	// Properties - Fabric related data.
	Properties *FabricProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// FabricCollection collection of fabric details.
type FabricCollection struct {
	autorest.Response `json:"-"`
	// Value - The fabric details.
	Value *[]Fabric `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// FabricCollectionIterator provides access to a complete listing of Fabric values.
type FabricCollectionIterator struct {
	i    int
	page FabricCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FabricCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FabricCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FabricCollectionIterator) Response() FabricCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FabricCollectionIterator) Value() Fabric {
	if !iter.page.NotDone() {
		return Fabric{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (fc FabricCollection) IsEmpty() bool {
	return fc.Value == nil || len(*fc.Value) == 0
}

// fabricCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fc FabricCollection) fabricCollectionPreparer() (*http.Request, error) {
	if fc.NextLink == nil || len(to.String(fc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fc.NextLink)))
}

// FabricCollectionPage contains a page of Fabric values.
type FabricCollectionPage struct {
	fn func(FabricCollection) (FabricCollection, error)
	fc FabricCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FabricCollectionPage) Next() error {
	next, err := page.fn(page.fc)
	if err != nil {
		return err
	}
	page.fc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FabricCollectionPage) NotDone() bool {
	return !page.fc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FabricCollectionPage) Response() FabricCollection {
	return page.fc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FabricCollectionPage) Values() []Fabric {
	if page.fc.IsEmpty() {
		return nil
	}
	return *page.fc.Value
}

// FabricCreationInput site details provided during the time of site creation
type FabricCreationInput struct {
	// Properties - Fabric creation input.
	Properties *FabricCreationInputProperties `json:"properties,omitempty"`
}

// FabricCreationInputProperties properties of site details provided during the time of site creation
type FabricCreationInputProperties struct {
	// CustomDetails - Fabric provider specific creation input.
	CustomDetails BasicFabricSpecificCreationInput `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricCreationInputProperties struct.
func (fcip *FabricCreationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicFabricSpecificCreationInput(*v)
				if err != nil {
					return err
				}
				fcip.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// FabricProperties fabric properties.
type FabricProperties struct {
	// FriendlyName - Friendly name of the fabric.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// EncryptionDetails - Encryption details for the fabric.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`
	// RolloverEncryptionDetails - Rollover encryption details for the fabric.
	RolloverEncryptionDetails *EncryptionDetails `json:"rolloverEncryptionDetails,omitempty"`
	// InternalIdentifier - Dra Registration Id.
	InternalIdentifier *string `json:"internalIdentifier,omitempty"`
	// BcdrState - BCDR state of the fabric.
	BcdrState *string `json:"bcdrState,omitempty"`
	// CustomDetails - Fabric specific settings.
	CustomDetails BasicFabricSpecificDetails `json:"customDetails,omitempty"`
	// HealthErrorDetails - Fabric health error details.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// Health - Health of fabric.
	Health *string `json:"health,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricProperties struct.
func (fp *FabricProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				fp.FriendlyName = &friendlyName
			}
		case "encryptionDetails":
			if v != nil {
				var encryptionDetails EncryptionDetails
				err = json.Unmarshal(*v, &encryptionDetails)
				if err != nil {
					return err
				}
				fp.EncryptionDetails = &encryptionDetails
			}
		case "rolloverEncryptionDetails":
			if v != nil {
				var rolloverEncryptionDetails EncryptionDetails
				err = json.Unmarshal(*v, &rolloverEncryptionDetails)
				if err != nil {
					return err
				}
				fp.RolloverEncryptionDetails = &rolloverEncryptionDetails
			}
		case "internalIdentifier":
			if v != nil {
				var internalIdentifier string
				err = json.Unmarshal(*v, &internalIdentifier)
				if err != nil {
					return err
				}
				fp.InternalIdentifier = &internalIdentifier
			}
		case "bcdrState":
			if v != nil {
				var bcdrState string
				err = json.Unmarshal(*v, &bcdrState)
				if err != nil {
					return err
				}
				fp.BcdrState = &bcdrState
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicFabricSpecificDetails(*v)
				if err != nil {
					return err
				}
				fp.CustomDetails = customDetails
			}
		case "healthErrorDetails":
			if v != nil {
				var healthErrorDetails []HealthError
				err = json.Unmarshal(*v, &healthErrorDetails)
				if err != nil {
					return err
				}
				fp.HealthErrorDetails = &healthErrorDetails
			}
		case "health":
			if v != nil {
				var health string
				err = json.Unmarshal(*v, &health)
				if err != nil {
					return err
				}
				fp.Health = &health
			}
		}
	}

	return nil
}

// FabricReplicationGroupTaskDetails this class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	// SkippedReason - The skipped reason.
	SkippedReason *string `json:"skippedReason,omitempty"`
	// SkippedReasonString - The skipped reason string.
	SkippedReasonString *string `json:"skippedReasonString,omitempty"`
	// JobTask - The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) MarshalJSON() ([]byte, error) {
	frgtd.InstanceType = InstanceTypeFabricReplicationGroupTaskDetails
	objectMap := make(map[string]interface{})
	if frgtd.SkippedReason != nil {
		objectMap["skippedReason"] = frgtd.SkippedReason
	}
	if frgtd.SkippedReasonString != nil {
		objectMap["skippedReasonString"] = frgtd.SkippedReasonString
	}
	if frgtd.JobTask != nil {
		objectMap["jobTask"] = frgtd.JobTask
	}
	if frgtd.InstanceType != "" {
		objectMap["instanceType"] = frgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return &frgtd, true
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &frgtd, true
}

// BasicFabricSpecificCreateNetworkMappingInput input details specific to fabrics during Network Mapping.
type BasicFabricSpecificCreateNetworkMappingInput interface {
	AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool)
	AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool)
	AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool)
	AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool)
}

// FabricSpecificCreateNetworkMappingInput input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificCreateNetworkMappingInput(body []byte) (BasicFabricSpecificCreateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzureToAzure):
		var atacnmi AzureToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &atacnmi)
		return atacnmi, err
	case string(InstanceTypeVmmToAzure):
		var vtacnmi VmmToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtacnmi)
		return vtacnmi, err
	case string(InstanceTypeVmmToVmm):
		var vtvcnmi VmmToVmmCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtvcnmi)
		return vtvcnmi, err
	default:
		var fscnmi FabricSpecificCreateNetworkMappingInput
		err := json.Unmarshal(body, &fscnmi)
		return fscnmi, err
	}
}
func unmarshalBasicFabricSpecificCreateNetworkMappingInputArray(body []byte) ([]BasicFabricSpecificCreateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fscnmiArray := make([]BasicFabricSpecificCreateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fscnmi, err := unmarshalBasicFabricSpecificCreateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fscnmiArray[index] = fscnmi
	}
	return fscnmiArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	fscnmi.InstanceType = InstanceTypeFabricSpecificCreateNetworkMappingInput
	objectMap := make(map[string]interface{})
	if fscnmi.InstanceType != "" {
		objectMap["instanceType"] = fscnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return &fscnmi, true
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for FabricSpecificCreateNetworkMappingInput.
func (fscnmi FabricSpecificCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &fscnmi, true
}

// BasicFabricSpecificCreationInput fabric provider specific settings.
type BasicFabricSpecificCreationInput interface {
	AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool)
	AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool)
	AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool)
}

// FabricSpecificCreationInput fabric provider specific settings.
type FabricSpecificCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificCreationInput(body []byte) (BasicFabricSpecificCreationInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzure):
		var afci AzureFabricCreationInput
		err := json.Unmarshal(body, &afci)
		return afci, err
	case string(InstanceTypeVMwareV2):
		var vmvfci VMwareV2FabricCreationInput
		err := json.Unmarshal(body, &vmvfci)
		return vmvfci, err
	default:
		var fsci FabricSpecificCreationInput
		err := json.Unmarshal(body, &fsci)
		return fsci, err
	}
}
func unmarshalBasicFabricSpecificCreationInputArray(body []byte) ([]BasicFabricSpecificCreationInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsciArray := make([]BasicFabricSpecificCreationInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsci, err := unmarshalBasicFabricSpecificCreationInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsciArray[index] = fsci
	}
	return fsciArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) MarshalJSON() ([]byte, error) {
	fsci.InstanceType = InstanceTypeFabricSpecificCreationInput
	objectMap := make(map[string]interface{})
	if fsci.InstanceType != "" {
		objectMap["instanceType"] = fsci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return nil, false
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return &fsci, true
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for FabricSpecificCreationInput.
func (fsci FabricSpecificCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &fsci, true
}

// BasicFabricSpecificDetails fabric specific details.
type BasicFabricSpecificDetails interface {
	AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool)
	AsVmmDetails() (*VmmDetails, bool)
	AsHyperVSiteDetails() (*HyperVSiteDetails, bool)
	AsVMwareDetails() (*VMwareDetails, bool)
	AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool)
	AsFabricSpecificDetails() (*FabricSpecificDetails, bool)
}

// FabricSpecificDetails fabric specific details.
type FabricSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificDetails(body []byte) (BasicFabricSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure):
		var afsd AzureFabricSpecificDetails
		err := json.Unmarshal(body, &afsd)
		return afsd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM):
		var vd VmmDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite):
		var hvsd HyperVSiteDetails
		err := json.Unmarshal(body, &hvsd)
		return hvsd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware):
		var vmd VMwareDetails
		err := json.Unmarshal(body, &vmd)
		return vmd, err
	case string(InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2):
		var vmvfsd VMwareV2FabricSpecificDetails
		err := json.Unmarshal(body, &vmvfsd)
		return vmvfsd, err
	default:
		var fsd FabricSpecificDetails
		err := json.Unmarshal(body, &fsd)
		return fsd, err
	}
}
func unmarshalBasicFabricSpecificDetailsArray(body []byte) ([]BasicFabricSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsdArray := make([]BasicFabricSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsd, err := unmarshalBasicFabricSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsdArray[index] = fsd
	}
	return fsdArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificDetails.
func (fsd FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	fsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails
	objectMap := make(map[string]interface{})
	if fsd.InstanceType != "" {
		objectMap["instanceType"] = fsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return &fsd, true
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for FabricSpecificDetails.
func (fsd FabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &fsd, true
}

// BasicFabricSpecificUpdateNetworkMappingInput input details specific to fabrics during Network Mapping.
type BasicFabricSpecificUpdateNetworkMappingInput interface {
	AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool)
	AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool)
	AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool)
	AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool)
}

// FabricSpecificUpdateNetworkMappingInput input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

func unmarshalBasicFabricSpecificUpdateNetworkMappingInput(body []byte) (BasicFabricSpecificUpdateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure):
		var ataunmi AzureToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &ataunmi)
		return ataunmi, err
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure):
		var vtaunmi VmmToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtaunmi)
		return vtaunmi, err
	case string(InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm):
		var vtvunmi VmmToVmmUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtvunmi)
		return vtvunmi, err
	default:
		var fsunmi FabricSpecificUpdateNetworkMappingInput
		err := json.Unmarshal(body, &fsunmi)
		return fsunmi, err
	}
}
func unmarshalBasicFabricSpecificUpdateNetworkMappingInputArray(body []byte) ([]BasicFabricSpecificUpdateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsunmiArray := make([]BasicFabricSpecificUpdateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsunmi, err := unmarshalBasicFabricSpecificUpdateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsunmiArray[index] = fsunmi
	}
	return fsunmiArray, nil
}

// MarshalJSON is the custom marshaler for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	fsunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput
	objectMap := make(map[string]interface{})
	if fsunmi.InstanceType != "" {
		objectMap["instanceType"] = fsunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return &fsunmi, true
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for FabricSpecificUpdateNetworkMappingInput.
func (fsunmi FabricSpecificUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &fsunmi, true
}

// FailoverJobDetails this class represents the details for a failover job.
type FailoverJobDetails struct {
	// ProtectedItemDetails - The test VM details.
	ProtectedItemDetails *[]FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverJobDetails.
func (fjd FailoverJobDetails) MarshalJSON() ([]byte, error) {
	fjd.InstanceType = InstanceTypeFailoverJobDetails
	objectMap := make(map[string]interface{})
	if fjd.ProtectedItemDetails != nil {
		objectMap["protectedItemDetails"] = fjd.ProtectedItemDetails
	}
	if fjd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = fjd.AffectedObjectDetails
	}
	if fjd.InstanceType != "" {
		objectMap["instanceType"] = fjd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return &fjd, true
}

// AsExportJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &fjd, true
}

// FailoverProcessServerRequest request to failover a process server.
type FailoverProcessServerRequest struct {
	// Properties - The properties of the PS Failover request.
	Properties *FailoverProcessServerRequestProperties `json:"properties,omitempty"`
}

// FailoverProcessServerRequestProperties the properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	// ContainerName - The container identifier.
	ContainerName *string `json:"containerName,omitempty"`
	// SourceProcessServerID - The source process server.
	SourceProcessServerID *string `json:"sourceProcessServerId,omitempty"`
	// TargetProcessServerID - The new process server.
	TargetProcessServerID *string `json:"targetProcessServerId,omitempty"`
	// VmsToMigrate - The VMS to migrate.
	VmsToMigrate *[]string `json:"vmsToMigrate,omitempty"`
	// UpdateType - A value for failover type. It can be systemlevel/serverlevel
	UpdateType *string `json:"updateType,omitempty"`
}

// FailoverReplicationProtectedItemDetails failover details for a replication protected item.
type FailoverReplicationProtectedItemDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// FriendlyName - The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// TestVMName - The test Vm name.
	TestVMName *string `json:"testVmName,omitempty"`
	// TestVMFriendlyName - The test Vm friendly name.
	TestVMFriendlyName *string `json:"testVmFriendlyName,omitempty"`
	// NetworkConnectionStatus - The network connection status.
	NetworkConnectionStatus *string `json:"networkConnectionStatus,omitempty"`
	// NetworkFriendlyName - The network friendly name.
	NetworkFriendlyName *string `json:"networkFriendlyName,omitempty"`
	// Subnet - The network subnet.
	Subnet *string `json:"subnet,omitempty"`
	// RecoveryPointID - The recovery point Id.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RecoveryPointTime - The recovery point time.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
}

// BasicGroupTaskDetails this class represents the group task details when parent child relationship exists in the
// drill down.
type BasicGroupTaskDetails interface {
	AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool)
	AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool)
	AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool)
	AsGroupTaskDetails() (*GroupTaskDetails, bool)
}

// GroupTaskDetails this class represents the group task details when parent child relationship exists in the drill
// down.
type GroupTaskDetails struct {
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicGroupTaskDetails(body []byte) (BasicGroupTaskDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInlineWorkflowTaskDetails):
		var iwtd InlineWorkflowTaskDetails
		err := json.Unmarshal(body, &iwtd)
		return iwtd, err
	case string(InstanceTypeRecoveryPlanGroupTaskDetails):
		var rpgtd RecoveryPlanGroupTaskDetails
		err := json.Unmarshal(body, &rpgtd)
		return rpgtd, err
	case string(InstanceTypeRecoveryPlanShutdownGroupTaskDetails):
		var rpsgtd RecoveryPlanShutdownGroupTaskDetails
		err := json.Unmarshal(body, &rpsgtd)
		return rpsgtd, err
	default:
		var gtd GroupTaskDetails
		err := json.Unmarshal(body, &gtd)
		return gtd, err
	}
}
func unmarshalBasicGroupTaskDetailsArray(body []byte) ([]BasicGroupTaskDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	gtdArray := make([]BasicGroupTaskDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		gtd, err := unmarshalBasicGroupTaskDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		gtdArray[index] = gtd
	}
	return gtdArray, nil
}

// MarshalJSON is the custom marshaler for GroupTaskDetails.
func (gtd GroupTaskDetails) MarshalJSON() ([]byte, error) {
	gtd.InstanceType = InstanceTypeGroupTaskDetails
	objectMap := make(map[string]interface{})
	if gtd.ChildTasks != nil {
		objectMap["childTasks"] = gtd.ChildTasks
	}
	if gtd.InstanceType != "" {
		objectMap["instanceType"] = gtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return &gtd, true
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for GroupTaskDetails.
func (gtd GroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &gtd, true
}

// HealthError health Error
type HealthError struct {
	// ErrorSource - Source of error.
	ErrorSource *string `json:"errorSource,omitempty"`
	// ErrorType - Type of error.
	ErrorType *string `json:"errorType,omitempty"`
	// ErrorLevel - Level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// PossibleCauses - Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// CreationTimeUtc - Error creation time (UTC)
	CreationTimeUtc *date.Time `json:"creationTimeUtc,omitempty"`
	// RecoveryProviderErrorMessage - DRA error message.
	RecoveryProviderErrorMessage *string `json:"recoveryProviderErrorMessage,omitempty"`
	// EntityID - ID of the entity.
	EntityID *string `json:"entityId,omitempty"`
	// ChildErrors - The child health errors.
	ChildErrors *[]HealthError `json:"childErrors,omitempty"`
}

// HealthErrorSummary class to define the summary of the health error details.
type HealthErrorSummary struct {
	// SummaryCode - The code of the health error.
	SummaryCode *string `json:"summaryCode,omitempty"`
	// Category - The category of the health error. Possible values include: 'Replication', 'TestFailover', 'Configuration'
	Category HealthErrorCategory `json:"category,omitempty"`
	// Severity - Severity of error. Possible values include: 'NONE', 'Warning', 'Error', 'Info'
	Severity Severity `json:"severity,omitempty"`
	// SummaryMessage - The summary message of the health error.
	SummaryMessage *string `json:"summaryMessage,omitempty"`
	// AffectedResourceType - The type of affected ARM resource.
	AffectedResourceType *string `json:"affectedResourceType,omitempty"`
	// AffectedResourceSubtype - The sub type of any subcomponent within the ARM resource that this might be applicable. Value remains null if not applicable.
	AffectedResourceSubtype *string `json:"affectedResourceSubtype,omitempty"`
	// AffectedResourceCorrelationIds - The list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected by a specific category and severity as well as count of item affected by an specific issue.
	AffectedResourceCorrelationIds *[]string `json:"affectedResourceCorrelationIds,omitempty"`
}

// HyperVReplica2012EventDetails model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvr2ed.ContainerName != nil {
		objectMap["containerName"] = hvr2ed.ContainerName
	}
	if hvr2ed.FabricName != nil {
		objectMap["fabricName"] = hvr2ed.FabricName
	}
	if hvr2ed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvr2ed.RemoteContainerName
	}
	if hvr2ed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvr2ed.RemoteFabricName
	}
	if hvr2ed.InstanceType != "" {
		objectMap["instanceType"] = hvr2ed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvr2ed, true
}

// HyperVReplica2012R2EventDetails model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvr2ed.ContainerName != nil {
		objectMap["containerName"] = hvr2ed.ContainerName
	}
	if hvr2ed.FabricName != nil {
		objectMap["fabricName"] = hvr2ed.FabricName
	}
	if hvr2ed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvr2ed.RemoteContainerName
	}
	if hvr2ed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvr2ed.RemoteFabricName
	}
	if hvr2ed.InstanceType != "" {
		objectMap["instanceType"] = hvr2ed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvr2ed, true
}

// HyperVReplicaAzureApplyRecoveryPointInput applyRecoveryPoint input specific to HyperVReplicaAzure provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	// VaultLocation - The vault location where the recovery Vm resides.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - The primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - The secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	hvraarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraarpi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvraarpi.VaultLocation
	}
	if hvraarpi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvraarpi.PrimaryKekCertificatePfx
	}
	if hvraarpi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvraarpi.SecondaryKekCertificatePfx
	}
	if hvraarpi.InstanceType != "" {
		objectMap["instanceType"] = hvraarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return &hvraarpi, true
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &hvraarpi, true
}

// HyperVReplicaAzureEnableProtectionInput azure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	// HvHostVMID - The Hyper-V host Vm Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`
	// VMName - The Vm Name.
	VMName *string `json:"vmName,omitempty"`
	// OsType - The OS type associated with vm.
	OsType *string `json:"osType,omitempty"`
	// VhdID - The OS disk VHD id associated with vm.
	VhdID *string `json:"vhdId,omitempty"`
	// TargetStorageAccountID - The storage account name.
	TargetStorageAccountID *string `json:"targetStorageAccountId,omitempty"`
	// TargetAzureNetworkID - The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`
	// TargetAzureSubnetID - The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`
	// EnableRDPOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRDPOnTargetOption *string `json:"enableRDPOnTargetOption,omitempty"`
	// TargetAzureVMName - The target azure Vm Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DisksToInclude - The list of VHD IDs of disks to be protected.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// TargetAzureV1ResourceGroupID - The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`
	// TargetAzureV2ResourceGroupID - The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) MarshalJSON() ([]byte, error) {
	hvraepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraepi.HvHostVMID != nil {
		objectMap["hvHostVmId"] = hvraepi.HvHostVMID
	}
	if hvraepi.VMName != nil {
		objectMap["vmName"] = hvraepi.VMName
	}
	if hvraepi.OsType != nil {
		objectMap["osType"] = hvraepi.OsType
	}
	if hvraepi.VhdID != nil {
		objectMap["vhdId"] = hvraepi.VhdID
	}
	if hvraepi.TargetStorageAccountID != nil {
		objectMap["targetStorageAccountId"] = hvraepi.TargetStorageAccountID
	}
	if hvraepi.TargetAzureNetworkID != nil {
		objectMap["targetAzureNetworkId"] = hvraepi.TargetAzureNetworkID
	}
	if hvraepi.TargetAzureSubnetID != nil {
		objectMap["targetAzureSubnetId"] = hvraepi.TargetAzureSubnetID
	}
	if hvraepi.EnableRDPOnTargetOption != nil {
		objectMap["enableRDPOnTargetOption"] = hvraepi.EnableRDPOnTargetOption
	}
	if hvraepi.TargetAzureVMName != nil {
		objectMap["targetAzureVmName"] = hvraepi.TargetAzureVMName
	}
	if hvraepi.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = hvraepi.LogStorageAccountID
	}
	if hvraepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = hvraepi.DisksToInclude
	}
	if hvraepi.TargetAzureV1ResourceGroupID != nil {
		objectMap["targetAzureV1ResourceGroupId"] = hvraepi.TargetAzureV1ResourceGroupID
	}
	if hvraepi.TargetAzureV2ResourceGroupID != nil {
		objectMap["targetAzureV2ResourceGroupId"] = hvraepi.TargetAzureV2ResourceGroupID
	}
	if hvraepi.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvraepi.UseManagedDisks
	}
	if hvraepi.InstanceType != "" {
		objectMap["instanceType"] = hvraepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return &hvraepi, true
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &hvraepi, true
}

// HyperVReplicaAzureEventDetails model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) MarshalJSON() ([]byte, error) {
	hvraed.InstanceType = InstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraed.ContainerName != nil {
		objectMap["containerName"] = hvraed.ContainerName
	}
	if hvraed.FabricName != nil {
		objectMap["fabricName"] = hvraed.FabricName
	}
	if hvraed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvraed.RemoteContainerName
	}
	if hvraed.InstanceType != "" {
		objectMap["instanceType"] = hvraed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return &hvraed, true
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvraed, true
}

// HyperVReplicaAzureFailbackProviderInput hvrA provider specific input for failback.
type HyperVReplicaAzureFailbackProviderInput struct {
	// DataSyncOption - Data sync option.
	DataSyncOption *string `json:"dataSyncOption,omitempty"`
	// RecoveryVMCreationOption - ALR options to create alternate recovery.
	RecoveryVMCreationOption *string `json:"recoveryVmCreationOption,omitempty"`
	// ProviderIDForAlternateRecovery - Provider ID for alternate location
	ProviderIDForAlternateRecovery *string `json:"providerIdForAlternateRecovery,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	objectMap := make(map[string]interface{})
	if hvrafpi.DataSyncOption != nil {
		objectMap["dataSyncOption"] = hvrafpi.DataSyncOption
	}
	if hvrafpi.RecoveryVMCreationOption != nil {
		objectMap["recoveryVmCreationOption"] = hvrafpi.RecoveryVMCreationOption
	}
	if hvrafpi.ProviderIDForAlternateRecovery != nil {
		objectMap["providerIdForAlternateRecovery"] = hvrafpi.ProviderIDForAlternateRecovery
	}
	if hvrafpi.InstanceType != "" {
		objectMap["instanceType"] = hvrafpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return &hvrafpi, true
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &hvrafpi, true
}

// HyperVReplicaAzureFailoverProviderInput hvrA provider specific input for failover.
type HyperVReplicaAzureFailoverProviderInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - Primary kek certificate pfx.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - Secondary kek certificate pfx.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrafpi.VaultLocation != nil {
		objectMap["vaultLocation"] = hvrafpi.VaultLocation
	}
	if hvrafpi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = hvrafpi.PrimaryKekCertificatePfx
	}
	if hvrafpi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = hvrafpi.SecondaryKekCertificatePfx
	}
	if hvrafpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = hvrafpi.RecoveryPointID
	}
	if hvrafpi.InstanceType != "" {
		objectMap["instanceType"] = hvrafpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return &hvrafpi, true
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &hvrafpi, true
}

// HyperVReplicaAzurePolicyDetails hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	// RecoveryPointHistoryDurationInHours - The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDurationInHours *int32 `json:"recoveryPointHistoryDurationInHours,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// ReplicationInterval - The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`
	// OnlineReplicationStartTime - The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// Encryption - A value indicating whether encryption is enabled for virtual machines in this cloud.
	Encryption *string `json:"encryption,omitempty"`
	// ActiveStorageAccountID - The active storage account Id.
	ActiveStorageAccountID *string `json:"activeStorageAccountId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrapd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrapd.RecoveryPointHistoryDurationInHours != nil {
		objectMap["recoveryPointHistoryDurationInHours"] = hvrapd.RecoveryPointHistoryDurationInHours
	}
	if hvrapd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrapd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrapd.ReplicationInterval != nil {
		objectMap["replicationInterval"] = hvrapd.ReplicationInterval
	}
	if hvrapd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrapd.OnlineReplicationStartTime
	}
	if hvrapd.Encryption != nil {
		objectMap["encryption"] = hvrapd.Encryption
	}
	if hvrapd.ActiveStorageAccountID != nil {
		objectMap["activeStorageAccountId"] = hvrapd.ActiveStorageAccountID
	}
	if hvrapd.InstanceType != "" {
		objectMap["instanceType"] = hvrapd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return &hvrapd, true
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrapd, true
}

// HyperVReplicaAzurePolicyInput hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	// RecoveryPointHistoryDuration - The duration (in hours) to which point the recovery history needs to be maintained.
	RecoveryPointHistoryDuration *int32 `json:"recoveryPointHistoryDuration,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// ReplicationInterval - The replication interval.
	ReplicationInterval *int32 `json:"replicationInterval,omitempty"`
	// OnlineReplicationStartTime - The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// Encryption - A value indicating whether encryption needs to be enabled for Vms in this cloud.
	Encryption *string `json:"encryption,omitempty"`
	// StorageAccounts - The list of storage accounts to which the VMs in the primary cloud can replicate to.
	StorageAccounts *[]string `json:"storageAccounts,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) MarshalJSON() ([]byte, error) {
	hvrapi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrapi.RecoveryPointHistoryDuration != nil {
		objectMap["recoveryPointHistoryDuration"] = hvrapi.RecoveryPointHistoryDuration
	}
	if hvrapi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrapi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrapi.ReplicationInterval != nil {
		objectMap["replicationInterval"] = hvrapi.ReplicationInterval
	}
	if hvrapi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrapi.OnlineReplicationStartTime
	}
	if hvrapi.Encryption != nil {
		objectMap["encryption"] = hvrapi.Encryption
	}
	if hvrapi.StorageAccounts != nil {
		objectMap["storageAccounts"] = hvrapi.StorageAccounts
	}
	if hvrapi.InstanceType != "" {
		objectMap["instanceType"] = hvrapi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return &hvrapi, true
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrapi, true
}

// HyperVReplicaAzureReplicationDetails hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	// AzureVMDiskDetails - Azure VM Disk details.
	AzureVMDiskDetails *[]AzureVMDiskDetails `json:"azureVMDiskDetails,omitempty"`
	// RecoveryAzureVMName - Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureVMSize - The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureStorageAccount - The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`
	// RecoveryAzureLogStorageAccountID - The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// SelectedRecoveryAzureNetworkID - The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// Encryption - The encryption info.
	Encryption *string `json:"encryption,omitempty"`
	// OSDetails - The operating system info.
	OSDetails *OSDetails `json:"oSDetails,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRAMSizeInMB,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCPUCount,omitempty"`
	// EnableRDPOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRDPOnTargetOption *string `json:"enableRDPOnTargetOption,omitempty"`
	// RecoveryAzureResourceGroupID - The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// LicenseType - License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrard.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrard.AzureVMDiskDetails != nil {
		objectMap["azureVMDiskDetails"] = hvrard.AzureVMDiskDetails
	}
	if hvrard.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVMName"] = hvrard.RecoveryAzureVMName
	}
	if hvrard.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = hvrard.RecoveryAzureVMSize
	}
	if hvrard.RecoveryAzureStorageAccount != nil {
		objectMap["recoveryAzureStorageAccount"] = hvrard.RecoveryAzureStorageAccount
	}
	if hvrard.RecoveryAzureLogStorageAccountID != nil {
		objectMap["recoveryAzureLogStorageAccountId"] = hvrard.RecoveryAzureLogStorageAccountID
	}
	if hvrard.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrard.LastReplicatedTime
	}
	if hvrard.VMID != nil {
		objectMap["vmId"] = hvrard.VMID
	}
	if hvrard.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrard.VMProtectionState
	}
	if hvrard.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrard.VMProtectionStateDescription
	}
	if hvrard.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrard.InitialReplicationDetails
	}
	if hvrard.VMNics != nil {
		objectMap["vmNics"] = hvrard.VMNics
	}
	if hvrard.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = hvrard.SelectedRecoveryAzureNetworkID
	}
	if hvrard.Encryption != nil {
		objectMap["encryption"] = hvrard.Encryption
	}
	if hvrard.OSDetails != nil {
		objectMap["oSDetails"] = hvrard.OSDetails
	}
	if hvrard.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRAMSizeInMB"] = hvrard.SourceVMRAMSizeInMB
	}
	if hvrard.SourceVMCPUCount != nil {
		objectMap["sourceVmCPUCount"] = hvrard.SourceVMCPUCount
	}
	if hvrard.EnableRDPOnTargetOption != nil {
		objectMap["enableRDPOnTargetOption"] = hvrard.EnableRDPOnTargetOption
	}
	if hvrard.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = hvrard.RecoveryAzureResourceGroupID
	}
	if hvrard.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = hvrard.RecoveryAvailabilitySetID
	}
	if hvrard.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvrard.UseManagedDisks
	}
	if hvrard.LicenseType != nil {
		objectMap["licenseType"] = hvrard.LicenseType
	}
	if hvrard.InstanceType != "" {
		objectMap["instanceType"] = hvrard.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return &hvrard, true
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrard, true
}

// HyperVReplicaAzureReprotectInput azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	// HvHostVMID - The Hyper-V host Vm Id.
	HvHostVMID *string `json:"hvHostVmId,omitempty"`
	// VMName - The Vm Name.
	VMName *string `json:"vmName,omitempty"`
	// OsType - The OS type associated with vm.
	OsType *string `json:"osType,omitempty"`
	// VHDID - The OS disk VHD id associated with vm.
	VHDID *string `json:"vHDId,omitempty"`
	// StorageAccountID - The storage account name.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) MarshalJSON() ([]byte, error) {
	hvrari.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvrari.HvHostVMID != nil {
		objectMap["hvHostVmId"] = hvrari.HvHostVMID
	}
	if hvrari.VMName != nil {
		objectMap["vmName"] = hvrari.VMName
	}
	if hvrari.OsType != nil {
		objectMap["osType"] = hvrari.OsType
	}
	if hvrari.VHDID != nil {
		objectMap["vHDId"] = hvrari.VHDID
	}
	if hvrari.StorageAccountID != nil {
		objectMap["storageAccountId"] = hvrari.StorageAccountID
	}
	if hvrari.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = hvrari.LogStorageAccountID
	}
	if hvrari.InstanceType != "" {
		objectMap["instanceType"] = hvrari.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return &hvrari, true
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &hvrari, true
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput hyperV replica Azure input to update replication protected
// item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	// RecoveryAzureV1ResourceGroupID - The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	// RecoveryAzureV2ResourceGroupID - The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	hvraurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if hvraurpii.RecoveryAzureV1ResourceGroupID != nil {
		objectMap["recoveryAzureV1ResourceGroupId"] = hvraurpii.RecoveryAzureV1ResourceGroupID
	}
	if hvraurpii.RecoveryAzureV2ResourceGroupID != nil {
		objectMap["recoveryAzureV2ResourceGroupId"] = hvraurpii.RecoveryAzureV2ResourceGroupID
	}
	if hvraurpii.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = hvraurpii.UseManagedDisks
	}
	if hvraurpii.InstanceType != "" {
		objectMap["instanceType"] = hvraurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return &hvraurpii, true
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &hvraurpii, true
}

// HyperVReplicaBaseEventDetails abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	// ContainerName - The container friendly name.
	ContainerName *string `json:"containerName,omitempty"`
	// FabricName - The fabric friendly name.
	FabricName *string `json:"fabricName,omitempty"`
	// RemoteContainerName - The remote container name.
	RemoteContainerName *string `json:"remoteContainerName,omitempty"`
	// RemoteFabricName - The remote fabric name.
	RemoteFabricName *string `json:"remoteFabricName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) MarshalJSON() ([]byte, error) {
	hvrbed.InstanceType = InstanceTypeHyperVReplicaBaseEventDetails
	objectMap := make(map[string]interface{})
	if hvrbed.ContainerName != nil {
		objectMap["containerName"] = hvrbed.ContainerName
	}
	if hvrbed.FabricName != nil {
		objectMap["fabricName"] = hvrbed.FabricName
	}
	if hvrbed.RemoteContainerName != nil {
		objectMap["remoteContainerName"] = hvrbed.RemoteContainerName
	}
	if hvrbed.RemoteFabricName != nil {
		objectMap["remoteFabricName"] = hvrbed.RemoteFabricName
	}
	if hvrbed.InstanceType != "" {
		objectMap["instanceType"] = hvrbed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return &hvrbed, true
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &hvrbed, true
}

// HyperVReplicaBasePolicyDetails base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails
	objectMap := make(map[string]interface{})
	if hvrbpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpd.RecoveryPoints
	}
	if hvrbpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpd.Compression != nil {
		objectMap["compression"] = hvrbpd.Compression
	}
	if hvrbpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpd.InitialReplicationMethod
	}
	if hvrbpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpd.OnlineReplicationStartTime
	}
	if hvrbpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpd.OfflineReplicationImportPath
	}
	if hvrbpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpd.OfflineReplicationExportPath
	}
	if hvrbpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpd.ReplicationPort
	}
	if hvrbpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpd.AllowedAuthenticationType
	}
	if hvrbpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrbpd.ReplicaDeletionOption
	}
	if hvrbpd.InstanceType != "" {
		objectMap["instanceType"] = hvrbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrbpd, true
}

// HyperVReplicaBaseReplicationDetails hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails
	objectMap := make(map[string]interface{})
	if hvrbrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrbrd.LastReplicatedTime
	}
	if hvrbrd.VMNics != nil {
		objectMap["vmNics"] = hvrbrd.VMNics
	}
	if hvrbrd.VMID != nil {
		objectMap["vmId"] = hvrbrd.VMID
	}
	if hvrbrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrbrd.VMProtectionState
	}
	if hvrbrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrbrd.VMProtectionStateDescription
	}
	if hvrbrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrbrd.InitialReplicationDetails
	}
	if hvrbrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrbrd.VMDiskDetails
	}
	if hvrbrd.InstanceType != "" {
		objectMap["instanceType"] = hvrbrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrbrd, true
}

// HyperVReplicaBluePolicyDetails hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	// ReplicationFrequencyInSeconds - A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbpd.ReplicationFrequencyInSeconds != nil {
		objectMap["replicationFrequencyInSeconds"] = hvrbpd.ReplicationFrequencyInSeconds
	}
	if hvrbpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpd.RecoveryPoints
	}
	if hvrbpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpd.Compression != nil {
		objectMap["compression"] = hvrbpd.Compression
	}
	if hvrbpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpd.InitialReplicationMethod
	}
	if hvrbpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpd.OnlineReplicationStartTime
	}
	if hvrbpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpd.OfflineReplicationImportPath
	}
	if hvrbpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpd.OfflineReplicationExportPath
	}
	if hvrbpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpd.ReplicationPort
	}
	if hvrbpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpd.AllowedAuthenticationType
	}
	if hvrbpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrbpd.ReplicaDeletionOption
	}
	if hvrbpd.InstanceType != "" {
		objectMap["instanceType"] = hvrbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrbpd, true
}

// HyperVReplicaBluePolicyInput hyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	// ReplicationFrequencyInSeconds - A value indicating the replication interval.
	ReplicationFrequencyInSeconds *int32 `json:"replicationFrequencyInSeconds,omitempty"`
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletion - A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) MarshalJSON() ([]byte, error) {
	hvrbpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbpi.ReplicationFrequencyInSeconds != nil {
		objectMap["replicationFrequencyInSeconds"] = hvrbpi.ReplicationFrequencyInSeconds
	}
	if hvrbpi.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrbpi.RecoveryPoints
	}
	if hvrbpi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrbpi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrbpi.Compression != nil {
		objectMap["compression"] = hvrbpi.Compression
	}
	if hvrbpi.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrbpi.InitialReplicationMethod
	}
	if hvrbpi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrbpi.OnlineReplicationStartTime
	}
	if hvrbpi.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrbpi.OfflineReplicationImportPath
	}
	if hvrbpi.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrbpi.OfflineReplicationExportPath
	}
	if hvrbpi.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrbpi.ReplicationPort
	}
	if hvrbpi.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrbpi.AllowedAuthenticationType
	}
	if hvrbpi.ReplicaDeletion != nil {
		objectMap["replicaDeletion"] = hvrbpi.ReplicaDeletion
	}
	if hvrbpi.InstanceType != "" {
		objectMap["instanceType"] = hvrbpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return &hvrbpi, true
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrbpi, true
}

// HyperVReplicaBlueReplicationDetails hyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2
	objectMap := make(map[string]interface{})
	if hvrbrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrbrd.LastReplicatedTime
	}
	if hvrbrd.VMNics != nil {
		objectMap["vmNics"] = hvrbrd.VMNics
	}
	if hvrbrd.VMID != nil {
		objectMap["vmId"] = hvrbrd.VMID
	}
	if hvrbrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrbrd.VMProtectionState
	}
	if hvrbrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrbrd.VMProtectionStateDescription
	}
	if hvrbrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrbrd.InitialReplicationDetails
	}
	if hvrbrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrbrd.VMDiskDetails
	}
	if hvrbrd.InstanceType != "" {
		objectMap["instanceType"] = hvrbrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrbrd, true
}

// HyperVReplicaPolicyDetails hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletionOption - A value indicating whether the VM has to be auto deleted. Supported Values: String.Empty, None, OnRecoveryCloud
	ReplicaDeletionOption *string `json:"replicaDeletionOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) MarshalJSON() ([]byte, error) {
	hvrpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrpd.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrpd.RecoveryPoints
	}
	if hvrpd.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrpd.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrpd.Compression != nil {
		objectMap["compression"] = hvrpd.Compression
	}
	if hvrpd.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrpd.InitialReplicationMethod
	}
	if hvrpd.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrpd.OnlineReplicationStartTime
	}
	if hvrpd.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrpd.OfflineReplicationImportPath
	}
	if hvrpd.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrpd.OfflineReplicationExportPath
	}
	if hvrpd.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrpd.ReplicationPort
	}
	if hvrpd.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrpd.AllowedAuthenticationType
	}
	if hvrpd.ReplicaDeletionOption != nil {
		objectMap["replicaDeletionOption"] = hvrpd.ReplicaDeletionOption
	}
	if hvrpd.InstanceType != "" {
		objectMap["instanceType"] = hvrpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return &hvrpd, true
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &hvrpd, true
}

// HyperVReplicaPolicyInput hyper-V Replica specific protection profile Input.
type HyperVReplicaPolicyInput struct {
	// RecoveryPoints - A value indicating the number of recovery points.
	RecoveryPoints *int32 `json:"recoveryPoints,omitempty"`
	// ApplicationConsistentSnapshotFrequencyInHours - A value indicating the application consistent frequency.
	ApplicationConsistentSnapshotFrequencyInHours *int32 `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	// Compression - A value indicating whether compression has to be enabled.
	Compression *string `json:"compression,omitempty"`
	// InitialReplicationMethod - A value indicating whether IR is online.
	InitialReplicationMethod *string `json:"initialReplicationMethod,omitempty"`
	// OnlineReplicationStartTime - A value indicating the online IR start time.
	OnlineReplicationStartTime *string `json:"onlineReplicationStartTime,omitempty"`
	// OfflineReplicationImportPath - A value indicating the offline IR import path.
	OfflineReplicationImportPath *string `json:"offlineReplicationImportPath,omitempty"`
	// OfflineReplicationExportPath - A value indicating the offline IR export path.
	OfflineReplicationExportPath *string `json:"offlineReplicationExportPath,omitempty"`
	// ReplicationPort - A value indicating the recovery HTTPS port.
	ReplicationPort *int32 `json:"replicationPort,omitempty"`
	// AllowedAuthenticationType - A value indicating the authentication type.
	AllowedAuthenticationType *int32 `json:"allowedAuthenticationType,omitempty"`
	// ReplicaDeletion - A value indicating whether the VM has to be auto deleted.
	ReplicaDeletion *string `json:"replicaDeletion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) MarshalJSON() ([]byte, error) {
	hvrpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrpi.RecoveryPoints != nil {
		objectMap["recoveryPoints"] = hvrpi.RecoveryPoints
	}
	if hvrpi.ApplicationConsistentSnapshotFrequencyInHours != nil {
		objectMap["applicationConsistentSnapshotFrequencyInHours"] = hvrpi.ApplicationConsistentSnapshotFrequencyInHours
	}
	if hvrpi.Compression != nil {
		objectMap["compression"] = hvrpi.Compression
	}
	if hvrpi.InitialReplicationMethod != nil {
		objectMap["initialReplicationMethod"] = hvrpi.InitialReplicationMethod
	}
	if hvrpi.OnlineReplicationStartTime != nil {
		objectMap["onlineReplicationStartTime"] = hvrpi.OnlineReplicationStartTime
	}
	if hvrpi.OfflineReplicationImportPath != nil {
		objectMap["offlineReplicationImportPath"] = hvrpi.OfflineReplicationImportPath
	}
	if hvrpi.OfflineReplicationExportPath != nil {
		objectMap["offlineReplicationExportPath"] = hvrpi.OfflineReplicationExportPath
	}
	if hvrpi.ReplicationPort != nil {
		objectMap["replicationPort"] = hvrpi.ReplicationPort
	}
	if hvrpi.AllowedAuthenticationType != nil {
		objectMap["allowedAuthenticationType"] = hvrpi.AllowedAuthenticationType
	}
	if hvrpi.ReplicaDeletion != nil {
		objectMap["replicaDeletion"] = hvrpi.ReplicaDeletion
	}
	if hvrpi.InstanceType != "" {
		objectMap["instanceType"] = hvrpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return &hvrpi, true
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &hvrpi, true
}

// HyperVReplicaReplicationDetails hyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	// LastReplicatedTime - The Last replication time.
	LastReplicatedTime *date.Time `json:"lastReplicatedTime,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// InitialReplicationDetails - Initial replication details.
	InitialReplicationDetails *InitialReplicationDetails `json:"initialReplicationDetails,omitempty"`
	// VMDiskDetails - VM disk details.
	VMDiskDetails *[]DiskDetails `json:"vMDiskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012
	objectMap := make(map[string]interface{})
	if hvrrd.LastReplicatedTime != nil {
		objectMap["lastReplicatedTime"] = hvrrd.LastReplicatedTime
	}
	if hvrrd.VMNics != nil {
		objectMap["vmNics"] = hvrrd.VMNics
	}
	if hvrrd.VMID != nil {
		objectMap["vmId"] = hvrrd.VMID
	}
	if hvrrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = hvrrd.VMProtectionState
	}
	if hvrrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = hvrrd.VMProtectionStateDescription
	}
	if hvrrd.InitialReplicationDetails != nil {
		objectMap["initialReplicationDetails"] = hvrrd.InitialReplicationDetails
	}
	if hvrrd.VMDiskDetails != nil {
		objectMap["vMDiskDetails"] = hvrrd.VMDiskDetails
	}
	if hvrrd.InstanceType != "" {
		objectMap["instanceType"] = hvrrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return &hvrrd, true
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &hvrrd, true
}

// HyperVSiteDetails hyperVSite fabric specific details.
type HyperVSiteDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) MarshalJSON() ([]byte, error) {
	hvsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite
	objectMap := make(map[string]interface{})
	if hvsd.InstanceType != "" {
		objectMap["instanceType"] = hvsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return &hvsd, true
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &hvsd, true
}

// HyperVVirtualMachineDetails hyper V replica provider specific settings
type HyperVVirtualMachineDetails struct {
	// SourceItemID - The source id of the object.
	SourceItemID *string `json:"sourceItemId,omitempty"`
	// Generation - The id of the object in fabric.
	Generation *string `json:"generation,omitempty"`
	// OsDetails - The Last replication time.
	OsDetails *OSDetails `json:"osDetails,omitempty"`
	// DiskDetails - The Last successful failover time.
	DiskDetails *[]DiskDetails `json:"diskDetails,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeVMwareVirtualMachine', 'InstanceTypeReplicationGroupDetails'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	hvvmd.InstanceType = InstanceTypeHyperVVirtualMachine
	objectMap := make(map[string]interface{})
	if hvvmd.SourceItemID != nil {
		objectMap["sourceItemId"] = hvvmd.SourceItemID
	}
	if hvvmd.Generation != nil {
		objectMap["generation"] = hvvmd.Generation
	}
	if hvvmd.OsDetails != nil {
		objectMap["osDetails"] = hvvmd.OsDetails
	}
	if hvvmd.DiskDetails != nil {
		objectMap["diskDetails"] = hvvmd.DiskDetails
	}
	if hvvmd.InstanceType != "" {
		objectMap["instanceType"] = hvvmd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return &hvvmd, true
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return nil, false
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &hvvmd, true
}

// IdentityInformation identity details.
type IdentityInformation struct {
	// IdentityProviderType - The identity provider type. Value is the ToString() of a IdentityProviderType value. Possible values include: 'RecoveryServicesActiveDirectory', 'CustomerActiveDirectory'
	IdentityProviderType IdentityProviderType `json:"identityProviderType,omitempty"`
	// TenantID - The tenant Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	TenantID *string `json:"tenantId,omitempty"`
	// ApplicationID - The application/client Id for the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ApplicationID *string `json:"applicationId,omitempty"`
	// ObjectID - The object Id of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	ObjectID *string `json:"objectId,omitempty"`
	// Audience - The intended Audience of the service principal with which the on-premise management/data plane components would communicate with our Azure services.
	Audience *string `json:"audience,omitempty"`
	// AadAuthority - The base authority for Azure Active Directory authentication.
	AadAuthority *string `json:"aadAuthority,omitempty"`
	// CertificateThumbprint - The certificate thumbprint. Applicable only if IdentityProviderType is RecoveryServicesActiveDirectory.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`
}

// InconsistentVMDetails this class stores the monitoring details for consistency check of inconsistent Protected
// Entity.
type InconsistentVMDetails struct {
	// VMName - The Vm name.
	VMName *string `json:"vmName,omitempty"`
	// CloudName - The Cloud name.
	CloudName *string `json:"cloudName,omitempty"`
	// Details - The list of details regarding state of the Protected Entity in SRS and On prem.
	Details *[]string `json:"details,omitempty"`
	// ErrorIds - The list of error ids.
	ErrorIds *[]string `json:"errorIds,omitempty"`
}

// InitialReplicationDetails initial replication details.
type InitialReplicationDetails struct {
	// InitialReplicationType - Initial replication type.
	InitialReplicationType *string `json:"initialReplicationType,omitempty"`
	// InitialReplicationProgressPercentage - The initial replication progress percentage.
	InitialReplicationProgressPercentage *string `json:"initialReplicationProgressPercentage,omitempty"`
}

// InlineWorkflowTaskDetails this class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	// WorkflowIds - The list of child workflow ids.
	WorkflowIds *[]string `json:"workflowIds,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) MarshalJSON() ([]byte, error) {
	iwtd.InstanceType = InstanceTypeInlineWorkflowTaskDetails
	objectMap := make(map[string]interface{})
	if iwtd.WorkflowIds != nil {
		objectMap["workflowIds"] = iwtd.WorkflowIds
	}
	if iwtd.ChildTasks != nil {
		objectMap["childTasks"] = iwtd.ChildTasks
	}
	if iwtd.InstanceType != "" {
		objectMap["instanceType"] = iwtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return &iwtd, true
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &iwtd, true
}

// InMageAgentDetails the details of the InMage agent.
type InMageAgentDetails struct {
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// AgentUpdateStatus - A value indicating whether installed agent needs to be updated.
	AgentUpdateStatus *string `json:"agentUpdateStatus,omitempty"`
	// PostUpdateRebootStatus - A value indicating whether reboot is required after update is applied.
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
}

// InMageAzureV2ApplyRecoveryPointInput applyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	// VaultLocation - The vault location where the recovery Vm resides.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicApplyRecoveryPointProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	imavarpi.InstanceType = InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavarpi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavarpi.VaultLocation
	}
	if imavarpi.InstanceType != "" {
		objectMap["instanceType"] = imavarpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return &imavarpi, true
}

// AsA2AApplyRecoveryPointInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsApplyRecoveryPointProviderSpecificInput() (*ApplyRecoveryPointProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicApplyRecoveryPointProviderSpecificInput is the BasicApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsBasicApplyRecoveryPointProviderSpecificInput() (BasicApplyRecoveryPointProviderSpecificInput, bool) {
	return &imavarpi, true
}

// InMageAzureV2EnableProtectionInput vMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	// MasterTargetID - The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// StorageAccountID - The storage account name.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// TargetAzureNetworkID - The selected target Azure network Id.
	TargetAzureNetworkID *string `json:"targetAzureNetworkId,omitempty"`
	// TargetAzureSubnetID - The selected target Azure subnet Id.
	TargetAzureSubnetID *string `json:"targetAzureSubnetId,omitempty"`
	// EnableRDPOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRDPOnTargetOption *string `json:"enableRDPOnTargetOption,omitempty"`
	// TargetAzureVMName - The target azure Vm Name.
	TargetAzureVMName *string `json:"targetAzureVmName,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// TargetAzureV1ResourceGroupID - The Id of the target resource group (for classic deployment) in which the failover VM is to be created.
	TargetAzureV1ResourceGroupID *string `json:"targetAzureV1ResourceGroupId,omitempty"`
	// TargetAzureV2ResourceGroupID - The Id of the target resource group (for resource manager deployment) in which the failover VM is to be created.
	TargetAzureV2ResourceGroupID *string `json:"targetAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) MarshalJSON() ([]byte, error) {
	imavepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavepi.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavepi.MasterTargetID
	}
	if imavepi.ProcessServerID != nil {
		objectMap["processServerId"] = imavepi.ProcessServerID
	}
	if imavepi.StorageAccountID != nil {
		objectMap["storageAccountId"] = imavepi.StorageAccountID
	}
	if imavepi.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imavepi.RunAsAccountID
	}
	if imavepi.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imavepi.MultiVMGroupID
	}
	if imavepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imavepi.MultiVMGroupName
	}
	if imavepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = imavepi.DisksToInclude
	}
	if imavepi.TargetAzureNetworkID != nil {
		objectMap["targetAzureNetworkId"] = imavepi.TargetAzureNetworkID
	}
	if imavepi.TargetAzureSubnetID != nil {
		objectMap["targetAzureSubnetId"] = imavepi.TargetAzureSubnetID
	}
	if imavepi.EnableRDPOnTargetOption != nil {
		objectMap["enableRDPOnTargetOption"] = imavepi.EnableRDPOnTargetOption
	}
	if imavepi.TargetAzureVMName != nil {
		objectMap["targetAzureVmName"] = imavepi.TargetAzureVMName
	}
	if imavepi.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = imavepi.LogStorageAccountID
	}
	if imavepi.TargetAzureV1ResourceGroupID != nil {
		objectMap["targetAzureV1ResourceGroupId"] = imavepi.TargetAzureV1ResourceGroupID
	}
	if imavepi.TargetAzureV2ResourceGroupID != nil {
		objectMap["targetAzureV2ResourceGroupId"] = imavepi.TargetAzureV2ResourceGroupID
	}
	if imavepi.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = imavepi.UseManagedDisks
	}
	if imavepi.InstanceType != "" {
		objectMap["instanceType"] = imavepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return &imavepi, true
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &imavepi, true
}

// InMageAzureV2EventDetails model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	// EventType - InMage Event type. Takes one of the values of {InMageDataContract.InMageMonitoringEventType}.
	EventType *string `json:"eventType,omitempty"`
	// Category - InMage Event Category.
	Category *string `json:"category,omitempty"`
	// Component - InMage Event Component.
	Component *string `json:"component,omitempty"`
	// CorrectiveAction - Corrective Action string for the event.
	CorrectiveAction *string `json:"correctiveAction,omitempty"`
	// Details - InMage Event Details.
	Details *string `json:"details,omitempty"`
	// Summary - InMage Event Summary.
	Summary *string `json:"summary,omitempty"`
	// SiteName - VMware Site name.
	SiteName *string `json:"siteName,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventProviderSpecificDetails', 'InstanceTypeHyperVReplicaBaseEventDetails', 'InstanceTypeHyperVReplica2012', 'InstanceTypeHyperVReplica2012R2', 'InstanceTypeHyperVReplicaAzure', 'InstanceTypeA2A', 'InstanceTypeInMageAzureV2'
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) MarshalJSON() ([]byte, error) {
	imaved.InstanceType = InstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imaved.EventType != nil {
		objectMap["eventType"] = imaved.EventType
	}
	if imaved.Category != nil {
		objectMap["category"] = imaved.Category
	}
	if imaved.Component != nil {
		objectMap["component"] = imaved.Component
	}
	if imaved.CorrectiveAction != nil {
		objectMap["correctiveAction"] = imaved.CorrectiveAction
	}
	if imaved.Details != nil {
		objectMap["details"] = imaved.Details
	}
	if imaved.Summary != nil {
		objectMap["summary"] = imaved.Summary
	}
	if imaved.SiteName != nil {
		objectMap["siteName"] = imaved.SiteName
	}
	if imaved.InstanceType != "" {
		objectMap["instanceType"] = imaved.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return &imaved, true
}

// AsEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsEventProviderSpecificDetails() (*EventProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventProviderSpecificDetails is the BasicEventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsBasicEventProviderSpecificDetails() (BasicEventProviderSpecificDetails, bool) {
	return &imaved, true
}

// InMageAzureV2FailoverProviderInput inMageAzureV2 provider specific input for failover.
type InMageAzureV2FailoverProviderInput struct {
	// VaultLocation - Location of the vault.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) MarshalJSON() ([]byte, error) {
	imavfpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavfpi.VaultLocation != nil {
		objectMap["vaultLocation"] = imavfpi.VaultLocation
	}
	if imavfpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imavfpi.RecoveryPointID
	}
	if imavfpi.InstanceType != "" {
		objectMap["instanceType"] = imavfpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return &imavfpi, true
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &imavfpi, true
}

// InMageAzureV2PolicyDetails inMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) MarshalJSON() ([]byte, error) {
	imavpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavpd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = imavpd.CrashConsistentFrequencyInMinutes
	}
	if imavpd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imavpd.RecoveryPointThresholdInMinutes
	}
	if imavpd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imavpd.RecoveryPointHistory
	}
	if imavpd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imavpd.AppConsistentFrequencyInMinutes
	}
	if imavpd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imavpd.MultiVMSyncStatus
	}
	if imavpd.InstanceType != "" {
		objectMap["instanceType"] = imavpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return &imavpd, true
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &imavpd, true
}

// InMageAzureV2PolicyInput vMWare Azure specific protection profile Input.
type InMageAzureV2PolicyInput struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) MarshalJSON() ([]byte, error) {
	imavpi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavpi.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imavpi.RecoveryPointThresholdInMinutes
	}
	if imavpi.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imavpi.RecoveryPointHistory
	}
	if imavpi.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = imavpi.CrashConsistentFrequencyInMinutes
	}
	if imavpi.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imavpi.AppConsistentFrequencyInMinutes
	}
	if imavpi.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = imavpi.MultiVMSyncStatus
	}
	if imavpi.InstanceType != "" {
		objectMap["instanceType"] = imavpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return &imavpi, true
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &imavpi, true
}

// InMageAzureV2ProtectedDiskDetails inMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	// DiskID - The disk id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// HealthErrorCode - The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// ResyncDurationInSeconds - The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// FileSystemCapacityInBytes - The disk file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`
	// SourceDataInMegaBytes - The source data transit in MB.
	SourceDataInMegaBytes *float64 `json:"sourceDataInMegaBytes,omitempty"`
	// PsDataInMegaBytes - The PS data transit in MB.
	PsDataInMegaBytes *float64 `json:"psDataInMegaBytes,omitempty"`
	// TargetDataInMegaBytes - The target data transit in MB.
	TargetDataInMegaBytes *float64 `json:"targetDataInMegaBytes,omitempty"`
	// DiskResized - A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageAzureV2RecoveryPointDetails inMage Azure V2 provider specific recovery point details.
type InMageAzureV2RecoveryPointDetails struct {
	// InstanceType - Gets the instance type.
	InstanceType *string `json:"instanceType,omitempty"`
	// IsMultiVMSyncPoint - A value indicating whether the recovery point is multi VM consistent.
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty"`
	// Type - Gets the provider type.
	Type *string `json:"Type,omitempty"`
}

// InMageAzureV2ReplicationDetails inMageAzureV2 provider specific settings
type InMageAzureV2ReplicationDetails struct {
	// InfrastructureVMID - The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`
	// VCenterInfrastructureID - The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// CompressedDataRateInMB - The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`
	// UncompressedDataRateInMB - The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`
	// IPAddress - The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// IsAgentUpdateRequired - A value indicating whether installed agent needs to be updated.
	IsAgentUpdateRequired *string `json:"isAgentUpdateRequired,omitempty"`
	// IsRebootAfterUpdateRequired - A value indicating whether the source server requires a restart after update.
	IsRebootAfterUpdateRequired *string `json:"isRebootAfterUpdateRequired,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]InMageAzureV2ProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// DiskResized - A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`
	// MasterTargetID - The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCPUCount,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRAMSizeInMB,omitempty"`
	// OsType - The type of the OS on the VM.
	OsType *string `json:"osType,omitempty"`
	// VhdName - The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`
	// OsDiskID - The id of the disk containing the OS.
	OsDiskID *string `json:"osDiskId,omitempty"`
	// AzureVMDiskDetails - Azure VM Disk details.
	AzureVMDiskDetails *[]AzureVMDiskDetails `json:"azureVMDiskDetails,omitempty"`
	// RecoveryAzureVMName - Recovery Azure given name.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureVMSize - The Recovery Azure VM size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// RecoveryAzureStorageAccount - The recovery Azure storage account.
	RecoveryAzureStorageAccount *string `json:"recoveryAzureStorageAccount,omitempty"`
	// RecoveryAzureLogStorageAccountID - The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
	RecoveryAzureLogStorageAccountID *string `json:"recoveryAzureLogStorageAccountId,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// SelectedRecoveryAzureNetworkID - The selected recovery azure network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// DiscoveryType - A value indicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// EnableRDPOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRDPOnTargetOption *string `json:"enableRDPOnTargetOption,omitempty"`
	// Datastores - The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
	Datastores *[]string `json:"datastores,omitempty"`
	// TargetVMID - The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
	TargetVMID *string `json:"targetVmId,omitempty"`
	// RecoveryAzureResourceGroupID - The target resource group Id.
	RecoveryAzureResourceGroupID *string `json:"recoveryAzureResourceGroupId,omitempty"`
	// RecoveryAvailabilitySetID - The recovery availability set Id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// LicenseType - License Type of the VM to be used.
	LicenseType *string `json:"licenseType,omitempty"`
	// ValidationErrors - The validation errors of the on-premise machine Value can be list of validation errors.
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// LastUpdateReceivedTime - The last update time received from on-prem components.
	LastUpdateReceivedTime *date.Time `json:"lastUpdateReceivedTime,omitempty"`
	// ReplicaID - The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`
	// OsVersion - The OS Version of the protected item.
	OsVersion *string `json:"osVersion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) MarshalJSON() ([]byte, error) {
	imavrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavrd.InfrastructureVMID != nil {
		objectMap["infrastructureVmId"] = imavrd.InfrastructureVMID
	}
	if imavrd.VCenterInfrastructureID != nil {
		objectMap["vCenterInfrastructureId"] = imavrd.VCenterInfrastructureID
	}
	if imavrd.ProtectionStage != nil {
		objectMap["protectionStage"] = imavrd.ProtectionStage
	}
	if imavrd.VMID != nil {
		objectMap["vmId"] = imavrd.VMID
	}
	if imavrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = imavrd.VMProtectionState
	}
	if imavrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = imavrd.VMProtectionStateDescription
	}
	if imavrd.ResyncProgressPercentage != nil {
		objectMap["resyncProgressPercentage"] = imavrd.ResyncProgressPercentage
	}
	if imavrd.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = imavrd.RpoInSeconds
	}
	if imavrd.CompressedDataRateInMB != nil {
		objectMap["compressedDataRateInMB"] = imavrd.CompressedDataRateInMB
	}
	if imavrd.UncompressedDataRateInMB != nil {
		objectMap["uncompressedDataRateInMB"] = imavrd.UncompressedDataRateInMB
	}
	if imavrd.IPAddress != nil {
		objectMap["ipAddress"] = imavrd.IPAddress
	}
	if imavrd.AgentVersion != nil {
		objectMap["agentVersion"] = imavrd.AgentVersion
	}
	if imavrd.IsAgentUpdateRequired != nil {
		objectMap["isAgentUpdateRequired"] = imavrd.IsAgentUpdateRequired
	}
	if imavrd.IsRebootAfterUpdateRequired != nil {
		objectMap["isRebootAfterUpdateRequired"] = imavrd.IsRebootAfterUpdateRequired
	}
	if imavrd.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = imavrd.LastHeartbeat
	}
	if imavrd.ProcessServerID != nil {
		objectMap["processServerId"] = imavrd.ProcessServerID
	}
	if imavrd.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imavrd.MultiVMGroupID
	}
	if imavrd.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imavrd.MultiVMGroupName
	}
	if imavrd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imavrd.MultiVMSyncStatus
	}
	if imavrd.ProtectedDisks != nil {
		objectMap["protectedDisks"] = imavrd.ProtectedDisks
	}
	if imavrd.DiskResized != nil {
		objectMap["diskResized"] = imavrd.DiskResized
	}
	if imavrd.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavrd.MasterTargetID
	}
	if imavrd.SourceVMCPUCount != nil {
		objectMap["sourceVmCPUCount"] = imavrd.SourceVMCPUCount
	}
	if imavrd.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRAMSizeInMB"] = imavrd.SourceVMRAMSizeInMB
	}
	if imavrd.OsType != nil {
		objectMap["osType"] = imavrd.OsType
	}
	if imavrd.VhdName != nil {
		objectMap["vhdName"] = imavrd.VhdName
	}
	if imavrd.OsDiskID != nil {
		objectMap["osDiskId"] = imavrd.OsDiskID
	}
	if imavrd.AzureVMDiskDetails != nil {
		objectMap["azureVMDiskDetails"] = imavrd.AzureVMDiskDetails
	}
	if imavrd.RecoveryAzureVMName != nil {
		objectMap["recoveryAzureVMName"] = imavrd.RecoveryAzureVMName
	}
	if imavrd.RecoveryAzureVMSize != nil {
		objectMap["recoveryAzureVMSize"] = imavrd.RecoveryAzureVMSize
	}
	if imavrd.RecoveryAzureStorageAccount != nil {
		objectMap["recoveryAzureStorageAccount"] = imavrd.RecoveryAzureStorageAccount
	}
	if imavrd.RecoveryAzureLogStorageAccountID != nil {
		objectMap["recoveryAzureLogStorageAccountId"] = imavrd.RecoveryAzureLogStorageAccountID
	}
	if imavrd.VMNics != nil {
		objectMap["vmNics"] = imavrd.VMNics
	}
	if imavrd.SelectedRecoveryAzureNetworkID != nil {
		objectMap["selectedRecoveryAzureNetworkId"] = imavrd.SelectedRecoveryAzureNetworkID
	}
	if imavrd.DiscoveryType != nil {
		objectMap["discoveryType"] = imavrd.DiscoveryType
	}
	if imavrd.EnableRDPOnTargetOption != nil {
		objectMap["enableRDPOnTargetOption"] = imavrd.EnableRDPOnTargetOption
	}
	if imavrd.Datastores != nil {
		objectMap["datastores"] = imavrd.Datastores
	}
	if imavrd.TargetVMID != nil {
		objectMap["targetVmId"] = imavrd.TargetVMID
	}
	if imavrd.RecoveryAzureResourceGroupID != nil {
		objectMap["recoveryAzureResourceGroupId"] = imavrd.RecoveryAzureResourceGroupID
	}
	if imavrd.RecoveryAvailabilitySetID != nil {
		objectMap["recoveryAvailabilitySetId"] = imavrd.RecoveryAvailabilitySetID
	}
	if imavrd.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = imavrd.UseManagedDisks
	}
	if imavrd.LicenseType != nil {
		objectMap["licenseType"] = imavrd.LicenseType
	}
	if imavrd.ValidationErrors != nil {
		objectMap["validationErrors"] = imavrd.ValidationErrors
	}
	if imavrd.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = imavrd.LastRpoCalculatedTime
	}
	if imavrd.LastUpdateReceivedTime != nil {
		objectMap["lastUpdateReceivedTime"] = imavrd.LastUpdateReceivedTime
	}
	if imavrd.ReplicaID != nil {
		objectMap["replicaId"] = imavrd.ReplicaID
	}
	if imavrd.OsVersion != nil {
		objectMap["osVersion"] = imavrd.OsVersion
	}
	if imavrd.InstanceType != "" {
		objectMap["instanceType"] = imavrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return &imavrd, true
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &imavrd, true
}

// InMageAzureV2ReprotectInput inMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	// MasterTargetID - The Master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// StorageAccountID - The storage account id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// PolicyID - The Policy Id.
	PolicyID *string `json:"policyId,omitempty"`
	// LogStorageAccountID - The storage account to be used for logging during replication.
	LogStorageAccountID *string `json:"logStorageAccountId,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) MarshalJSON() ([]byte, error) {
	imavri.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavri.MasterTargetID != nil {
		objectMap["masterTargetId"] = imavri.MasterTargetID
	}
	if imavri.ProcessServerID != nil {
		objectMap["processServerId"] = imavri.ProcessServerID
	}
	if imavri.StorageAccountID != nil {
		objectMap["storageAccountId"] = imavri.StorageAccountID
	}
	if imavri.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imavri.RunAsAccountID
	}
	if imavri.PolicyID != nil {
		objectMap["policyId"] = imavri.PolicyID
	}
	if imavri.LogStorageAccountID != nil {
		objectMap["logStorageAccountId"] = imavri.LogStorageAccountID
	}
	if imavri.DisksToInclude != nil {
		objectMap["disksToInclude"] = imavri.DisksToInclude
	}
	if imavri.InstanceType != "" {
		objectMap["instanceType"] = imavri.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return &imavri, true
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &imavri, true
}

// InMageAzureV2UpdateReplicationProtectedItemInput inMage Azure V2 input to update replication protected item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	// RecoveryAzureV1ResourceGroupID - The recovery Azure resource group Id for classic deployment.
	RecoveryAzureV1ResourceGroupID *string `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	// RecoveryAzureV2ResourceGroupID - The recovery Azure resource group Id for resource manager deployment.
	RecoveryAzureV2ResourceGroupID *string `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	// UseManagedDisks - A value indicating whether managed disks should be used during failover.
	UseManagedDisks *string `json:"useManagedDisks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	imavurpii.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if imavurpii.RecoveryAzureV1ResourceGroupID != nil {
		objectMap["recoveryAzureV1ResourceGroupId"] = imavurpii.RecoveryAzureV1ResourceGroupID
	}
	if imavurpii.RecoveryAzureV2ResourceGroupID != nil {
		objectMap["recoveryAzureV2ResourceGroupId"] = imavurpii.RecoveryAzureV2ResourceGroupID
	}
	if imavurpii.UseManagedDisks != nil {
		objectMap["useManagedDisks"] = imavurpii.UseManagedDisks
	}
	if imavurpii.InstanceType != "" {
		objectMap["instanceType"] = imavurpii.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return &imavurpii, true
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return nil, false
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &imavurpii, true
}

// InMageBasePolicyDetails base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) MarshalJSON() ([]byte, error) {
	imbpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails
	objectMap := make(map[string]interface{})
	if imbpd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = imbpd.RecoveryPointThresholdInMinutes
	}
	if imbpd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = imbpd.RecoveryPointHistory
	}
	if imbpd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = imbpd.AppConsistentFrequencyInMinutes
	}
	if imbpd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imbpd.MultiVMSyncStatus
	}
	if imbpd.InstanceType != "" {
		objectMap["instanceType"] = imbpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return &imbpd, true
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &imbpd, true
}

// InMageDisableProtectionProviderSpecificInput inMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	// ReplicaVMDeletionStatus - A value indicating whether the replica VM should be destroyed or retained. Values from Delete and Retain.
	ReplicaVMDeletionStatus *string `json:"replicaVmDeletionStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeDisableProtectionProviderSpecificInput', 'InstanceTypeInMage'
	InstanceType InstanceTypeBasicDisableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	imdppsi.InstanceType = InstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imdppsi.ReplicaVMDeletionStatus != nil {
		objectMap["replicaVmDeletionStatus"] = imdppsi.ReplicaVMDeletionStatus
	}
	if imdppsi.InstanceType != "" {
		objectMap["instanceType"] = imdppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInMageDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool) {
	return &imdppsi, true
}

// AsDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsDisableProtectionProviderSpecificInput() (*DisableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicDisableProtectionProviderSpecificInput is the BasicDisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsBasicDisableProtectionProviderSpecificInput() (BasicDisableProtectionProviderSpecificInput, bool) {
	return &imdppsi, true
}

// InMageDiskDetails vMware/Physical specific Disk Details
type InMageDiskDetails struct {
	// DiskID - The disk Id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// DiskSizeInMB - The disk size in MB.
	DiskSizeInMB *string `json:"diskSizeInMB,omitempty"`
	// DiskType - Whether disk is system disk or data disk.
	DiskType *string `json:"diskType,omitempty"`
	// DiskConfiguration - Whether disk is dynamic disk or basic disk.
	DiskConfiguration *string `json:"diskConfiguration,omitempty"`
	// VolumeList - Volumes of the disk.
	VolumeList *[]DiskVolumeDetails `json:"volumeList,omitempty"`
}

// InMageDiskExclusionInput diskExclusionInput when doing enable protection of virtual machine in InMage provider.
type InMageDiskExclusionInput struct {
	// VolumeOptions - The volume label based option for disk exclusion.
	VolumeOptions *[]InMageVolumeExclusionOptions `json:"volumeOptions,omitempty"`
	// DiskSignatureOptions - The guest disk signature based option for disk exclusion.
	DiskSignatureOptions *[]InMageDiskSignatureExclusionOptions `json:"diskSignatureOptions,omitempty"`
}

// InMageDiskSignatureExclusionOptions guest disk signature based disk exclusion option when doing enable
// protection of virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	// DiskSignature - The guest signature of disk to be excluded from replication.
	DiskSignature *string `json:"diskSignature,omitempty"`
}

// InMageEnableProtectionInput vMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	// VMFriendlyName - The Vm Name.
	VMFriendlyName *string `json:"vmFriendlyName,omitempty"`
	// MasterTargetID - The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// RetentionDrive - The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// MultiVMGroupID - The multi vm group Id.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// DatastoreName - The target datastore name.
	DatastoreName *string `json:"datastoreName,omitempty"`
	// DiskExclusionInput - The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) MarshalJSON() ([]byte, error) {
	imepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imepi.VMFriendlyName != nil {
		objectMap["vmFriendlyName"] = imepi.VMFriendlyName
	}
	if imepi.MasterTargetID != nil {
		objectMap["masterTargetId"] = imepi.MasterTargetID
	}
	if imepi.ProcessServerID != nil {
		objectMap["processServerId"] = imepi.ProcessServerID
	}
	if imepi.RetentionDrive != nil {
		objectMap["retentionDrive"] = imepi.RetentionDrive
	}
	if imepi.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imepi.RunAsAccountID
	}
	if imepi.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imepi.MultiVMGroupID
	}
	if imepi.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imepi.MultiVMGroupName
	}
	if imepi.DatastoreName != nil {
		objectMap["datastoreName"] = imepi.DatastoreName
	}
	if imepi.DiskExclusionInput != nil {
		objectMap["diskExclusionInput"] = imepi.DiskExclusionInput
	}
	if imepi.DisksToInclude != nil {
		objectMap["disksToInclude"] = imepi.DisksToInclude
	}
	if imepi.InstanceType != "" {
		objectMap["instanceType"] = imepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return &imepi, true
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &imepi, true
}

// InMageFailoverProviderInput provider specific input for InMage failover.
type InMageFailoverProviderInput struct {
	// RecoveryPointType - The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom, the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery point id will be ignored. Possible values include: 'LatestTime', 'LatestTag', 'Custom'
	RecoveryPointType RecoveryPointType `json:"recoveryPointType,omitempty"`
	// RecoveryPointID - The recovery point id to be passed to failover to a particular recovery point. In case of latest recovery point, null should be passed.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) MarshalJSON() ([]byte, error) {
	imfpi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imfpi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = imfpi.RecoveryPointType
	}
	if imfpi.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = imfpi.RecoveryPointID
	}
	if imfpi.InstanceType != "" {
		objectMap["instanceType"] = imfpi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return &imfpi, true
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &imfpi, true
}

// InMagePolicyDetails inMage specific protection profile details.
type InMagePolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyDetails.
func (impd InMagePolicyDetails) MarshalJSON() ([]byte, error) {
	impd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if impd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = impd.RecoveryPointThresholdInMinutes
	}
	if impd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = impd.RecoveryPointHistory
	}
	if impd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = impd.AppConsistentFrequencyInMinutes
	}
	if impd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = impd.MultiVMSyncStatus
	}
	if impd.InstanceType != "" {
		objectMap["instanceType"] = impd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return &impd, true
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &impd, true
}

// InMagePolicyInput vMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or 'Disabled'. Possible values include: 'Enable', 'Disable'
	MultiVMSyncStatus SetMultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyInput.
func (impi InMagePolicyInput) MarshalJSON() ([]byte, error) {
	impi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if impi.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = impi.RecoveryPointThresholdInMinutes
	}
	if impi.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = impi.RecoveryPointHistory
	}
	if impi.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = impi.AppConsistentFrequencyInMinutes
	}
	if impi.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = impi.MultiVMSyncStatus
	}
	if impi.InstanceType != "" {
		objectMap["instanceType"] = impi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return &impi, true
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &impi, true
}

// InMageProtectedDiskDetails inMage protected disk details.
type InMageProtectedDiskDetails struct {
	// DiskID - The disk id.
	DiskID *string `json:"diskId,omitempty"`
	// DiskName - The disk name.
	DiskName *string `json:"diskName,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// HealthErrorCode - The health error code for the disk.
	HealthErrorCode *string `json:"healthErrorCode,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ResyncRequired - A value indicating whether resync is required for this disk.
	ResyncRequired *string `json:"resyncRequired,omitempty"`
	// ResyncProgressPercentage - The resync progress percentage.
	ResyncProgressPercentage *int32 `json:"resyncProgressPercentage,omitempty"`
	// ResyncDurationInSeconds - The resync duration in seconds.
	ResyncDurationInSeconds *int64 `json:"resyncDurationInSeconds,omitempty"`
	// DiskCapacityInBytes - The disk capacity in bytes.
	DiskCapacityInBytes *int64 `json:"diskCapacityInBytes,omitempty"`
	// FileSystemCapacityInBytes - The file system capacity in bytes.
	FileSystemCapacityInBytes *int64 `json:"fileSystemCapacityInBytes,omitempty"`
	// SourceDataInMB - The source data transit in MB.
	SourceDataInMB *float64 `json:"sourceDataInMB,omitempty"`
	// PsDataInMB - The PS data transit in MB.
	PsDataInMB *float64 `json:"psDataInMB,omitempty"`
	// TargetDataInMB - The target data transit in MB.
	TargetDataInMB *float64 `json:"targetDataInMB,omitempty"`
	// DiskResized - A value indicating whether disk is resized.
	DiskResized *string `json:"diskResized,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageReplicationDetails inMage provider specific settings
type InMageReplicationDetails struct {
	// ActiveSiteType - The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always.
	ActiveSiteType *string `json:"activeSiteType,omitempty"`
	// SourceVMCPUCount - The CPU count of the VM on the primary side.
	SourceVMCPUCount *int32 `json:"sourceVmCPUCount,omitempty"`
	// SourceVMRAMSizeInMB - The RAM size of the VM on the primary side.
	SourceVMRAMSizeInMB *int32 `json:"sourceVmRAMSizeInMB,omitempty"`
	// OsDetails - The OS details.
	OsDetails *OSDiskDetails `json:"osDetails,omitempty"`
	// ProtectionStage - The protection stage.
	ProtectionStage *string `json:"protectionStage,omitempty"`
	// VMID - The virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// VMProtectionState - The protection state for the vm.
	VMProtectionState *string `json:"vmProtectionState,omitempty"`
	// VMProtectionStateDescription - The protection state description for the vm.
	VMProtectionStateDescription *string `json:"vmProtectionStateDescription,omitempty"`
	// ResyncDetails - The resync details of the machine
	ResyncDetails *InitialReplicationDetails `json:"resyncDetails,omitempty"`
	// RetentionWindowStart - The retention window start time.
	RetentionWindowStart *date.Time `json:"retentionWindowStart,omitempty"`
	// RetentionWindowEnd - The retention window end time.
	RetentionWindowEnd *date.Time `json:"retentionWindowEnd,omitempty"`
	// CompressedDataRateInMB - The compressed data change rate in MB.
	CompressedDataRateInMB *float64 `json:"compressedDataRateInMB,omitempty"`
	// UncompressedDataRateInMB - The uncompressed data change rate in MB.
	UncompressedDataRateInMB *float64 `json:"uncompressedDataRateInMB,omitempty"`
	// RpoInSeconds - The RPO in seconds.
	RpoInSeconds *int64 `json:"rpoInSeconds,omitempty"`
	// ProtectedDisks - The list of protected disks.
	ProtectedDisks *[]InMageProtectedDiskDetails `json:"protectedDisks,omitempty"`
	// IPAddress - The source IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// LastHeartbeat - The last heartbeat received from the source server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// MasterTargetID - The master target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ConsistencyPoints - The collection of Consistency points.
	ConsistencyPoints map[string]*date.Time `json:"consistencyPoints"`
	// DiskResized - A value indicating whether any disk is resized for this VM.
	DiskResized *string `json:"diskResized,omitempty"`
	// RebootAfterUpdateStatus - A value indicating whether the source server requires a restart after update.
	RebootAfterUpdateStatus *string `json:"rebootAfterUpdateStatus,omitempty"`
	// MultiVMGroupID - The multi vm group Id, if any.
	MultiVMGroupID *string `json:"multiVmGroupId,omitempty"`
	// MultiVMGroupName - The multi vm group name, if any.
	MultiVMGroupName *string `json:"multiVmGroupName,omitempty"`
	// MultiVMSyncStatus - A value indicating whether the multi vm sync is enabled or disabled.
	MultiVMSyncStatus *string `json:"multiVmSyncStatus,omitempty"`
	// AgentDetails - The agent details.
	AgentDetails *InMageAgentDetails `json:"agentDetails,omitempty"`
	// VCenterInfrastructureID - The vCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`
	// InfrastructureVMID - The infrastructure VM Id.
	InfrastructureVMID *string `json:"infrastructureVmId,omitempty"`
	// VMNics - The PE Network details.
	VMNics *[]VMNicDetails `json:"vmNics,omitempty"`
	// DiscoveryType - A value indicating the discovery type of the machine.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// AzureStorageAccountID - A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null.
	AzureStorageAccountID *string `json:"azureStorageAccountId,omitempty"`
	// Datastores - The datastores of the on-premise machine Value can be list of strings that contain datastore names
	Datastores *[]string `json:"datastores,omitempty"`
	// ValidationErrors - The validation errors of the on-premise machine Value can be list of validation errors
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// LastRpoCalculatedTime - The last RPO calculated time.
	LastRpoCalculatedTime *date.Time `json:"lastRpoCalculatedTime,omitempty"`
	// LastUpdateReceivedTime - The last update time received from on-prem components.
	LastUpdateReceivedTime *date.Time `json:"lastUpdateReceivedTime,omitempty"`
	// ReplicaID - The replica id of the protected item.
	ReplicaID *string `json:"replicaId,omitempty"`
	// OsVersion - The OS Version of the protected item.
	OsVersion *string `json:"osVersion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReplicationDetails.
func (imrd InMageReplicationDetails) MarshalJSON() ([]byte, error) {
	imrd.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imrd.ActiveSiteType != nil {
		objectMap["activeSiteType"] = imrd.ActiveSiteType
	}
	if imrd.SourceVMCPUCount != nil {
		objectMap["sourceVmCPUCount"] = imrd.SourceVMCPUCount
	}
	if imrd.SourceVMRAMSizeInMB != nil {
		objectMap["sourceVmRAMSizeInMB"] = imrd.SourceVMRAMSizeInMB
	}
	if imrd.OsDetails != nil {
		objectMap["osDetails"] = imrd.OsDetails
	}
	if imrd.ProtectionStage != nil {
		objectMap["protectionStage"] = imrd.ProtectionStage
	}
	if imrd.VMID != nil {
		objectMap["vmId"] = imrd.VMID
	}
	if imrd.VMProtectionState != nil {
		objectMap["vmProtectionState"] = imrd.VMProtectionState
	}
	if imrd.VMProtectionStateDescription != nil {
		objectMap["vmProtectionStateDescription"] = imrd.VMProtectionStateDescription
	}
	if imrd.ResyncDetails != nil {
		objectMap["resyncDetails"] = imrd.ResyncDetails
	}
	if imrd.RetentionWindowStart != nil {
		objectMap["retentionWindowStart"] = imrd.RetentionWindowStart
	}
	if imrd.RetentionWindowEnd != nil {
		objectMap["retentionWindowEnd"] = imrd.RetentionWindowEnd
	}
	if imrd.CompressedDataRateInMB != nil {
		objectMap["compressedDataRateInMB"] = imrd.CompressedDataRateInMB
	}
	if imrd.UncompressedDataRateInMB != nil {
		objectMap["uncompressedDataRateInMB"] = imrd.UncompressedDataRateInMB
	}
	if imrd.RpoInSeconds != nil {
		objectMap["rpoInSeconds"] = imrd.RpoInSeconds
	}
	if imrd.ProtectedDisks != nil {
		objectMap["protectedDisks"] = imrd.ProtectedDisks
	}
	if imrd.IPAddress != nil {
		objectMap["ipAddress"] = imrd.IPAddress
	}
	if imrd.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = imrd.LastHeartbeat
	}
	if imrd.ProcessServerID != nil {
		objectMap["processServerId"] = imrd.ProcessServerID
	}
	if imrd.MasterTargetID != nil {
		objectMap["masterTargetId"] = imrd.MasterTargetID
	}
	if imrd.ConsistencyPoints != nil {
		objectMap["consistencyPoints"] = imrd.ConsistencyPoints
	}
	if imrd.DiskResized != nil {
		objectMap["diskResized"] = imrd.DiskResized
	}
	if imrd.RebootAfterUpdateStatus != nil {
		objectMap["rebootAfterUpdateStatus"] = imrd.RebootAfterUpdateStatus
	}
	if imrd.MultiVMGroupID != nil {
		objectMap["multiVmGroupId"] = imrd.MultiVMGroupID
	}
	if imrd.MultiVMGroupName != nil {
		objectMap["multiVmGroupName"] = imrd.MultiVMGroupName
	}
	if imrd.MultiVMSyncStatus != nil {
		objectMap["multiVmSyncStatus"] = imrd.MultiVMSyncStatus
	}
	if imrd.AgentDetails != nil {
		objectMap["agentDetails"] = imrd.AgentDetails
	}
	if imrd.VCenterInfrastructureID != nil {
		objectMap["vCenterInfrastructureId"] = imrd.VCenterInfrastructureID
	}
	if imrd.InfrastructureVMID != nil {
		objectMap["infrastructureVmId"] = imrd.InfrastructureVMID
	}
	if imrd.VMNics != nil {
		objectMap["vmNics"] = imrd.VMNics
	}
	if imrd.DiscoveryType != nil {
		objectMap["discoveryType"] = imrd.DiscoveryType
	}
	if imrd.AzureStorageAccountID != nil {
		objectMap["azureStorageAccountId"] = imrd.AzureStorageAccountID
	}
	if imrd.Datastores != nil {
		objectMap["datastores"] = imrd.Datastores
	}
	if imrd.ValidationErrors != nil {
		objectMap["validationErrors"] = imrd.ValidationErrors
	}
	if imrd.LastRpoCalculatedTime != nil {
		objectMap["lastRpoCalculatedTime"] = imrd.LastRpoCalculatedTime
	}
	if imrd.LastUpdateReceivedTime != nil {
		objectMap["lastUpdateReceivedTime"] = imrd.LastUpdateReceivedTime
	}
	if imrd.ReplicaID != nil {
		objectMap["replicaId"] = imrd.ReplicaID
	}
	if imrd.OsVersion != nil {
		objectMap["osVersion"] = imrd.OsVersion
	}
	if imrd.InstanceType != "" {
		objectMap["instanceType"] = imrd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return &imrd, true
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return nil, false
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &imrd, true
}

// InMageReprotectInput inMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	// MasterTargetID - The Master Target Id.
	MasterTargetID *string `json:"masterTargetId,omitempty"`
	// ProcessServerID - The Process Server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// RetentionDrive - The retention drive to use on the MT.
	RetentionDrive *string `json:"retentionDrive,omitempty"`
	// RunAsAccountID - The CS account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// DatastoreName - The target datastore name.
	DatastoreName *string `json:"datastoreName,omitempty"`
	// DiskExclusionInput - The enable disk exclusion input.
	DiskExclusionInput *InMageDiskExclusionInput `json:"diskExclusionInput,omitempty"`
	// ProfileID - The Policy Id.
	ProfileID *string `json:"profileId,omitempty"`
	// DisksToInclude - The disks to include list.
	DisksToInclude *[]string `json:"disksToInclude,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReprotectInput.
func (imri InMageReprotectInput) MarshalJSON() ([]byte, error) {
	imri.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if imri.MasterTargetID != nil {
		objectMap["masterTargetId"] = imri.MasterTargetID
	}
	if imri.ProcessServerID != nil {
		objectMap["processServerId"] = imri.ProcessServerID
	}
	if imri.RetentionDrive != nil {
		objectMap["retentionDrive"] = imri.RetentionDrive
	}
	if imri.RunAsAccountID != nil {
		objectMap["runAsAccountId"] = imri.RunAsAccountID
	}
	if imri.DatastoreName != nil {
		objectMap["datastoreName"] = imri.DatastoreName
	}
	if imri.DiskExclusionInput != nil {
		objectMap["diskExclusionInput"] = imri.DiskExclusionInput
	}
	if imri.ProfileID != nil {
		objectMap["profileId"] = imri.ProfileID
	}
	if imri.DisksToInclude != nil {
		objectMap["disksToInclude"] = imri.DisksToInclude
	}
	if imri.InstanceType != "" {
		objectMap["instanceType"] = imri.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return &imri, true
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &imri, true
}

// InMageVolumeExclusionOptions guest disk signature based disk exclusion option when doing enable protection of
// virtual machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	// VolumeLabel - The volume label. The disk having any volume with this label will be excluded from replication.
	VolumeLabel *string `json:"volumeLabel,omitempty"`
	// OnlyExcludeIfSingleVolume - The value indicating whether to exclude multi volume disk or not. If a disk has multiple volumes and one of the volume has label matching with VolumeLabel this disk will be excluded from replication if OnlyExcludeIfSingleVolume is false.
	OnlyExcludeIfSingleVolume *string `json:"OnlyExcludeIfSingleVolume,omitempty"`
}

// InputEndpoint azure VM input endpoint details.
type InputEndpoint struct {
	// EndpointName - The input endpoint name.
	EndpointName *string `json:"endpointName,omitempty"`
	// PrivatePort - The input endpoint private port.
	PrivatePort *int32 `json:"privatePort,omitempty"`
	// PublicPort - The input endpoint public port.
	PublicPort *int32 `json:"publicPort,omitempty"`
	// Protocol - The input endpoint protocol.
	Protocol *string `json:"protocol,omitempty"`
}

// Job job details.
type Job struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *JobProperties `json:"properties,omitempty"`
	// Status - The status of the Job. ARM expects the terminal status to be one of (1) Succeeded, (2) Failed or (3) Canceled. All other values imply that the operation is still running / being applied.
	Status *string `json:"status,omitempty"`
	// Error - The error.
	Error *ARMException `json:"error,omitempty"`
	// StartTime - The start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The start time.
	EndTime *string `json:"endTime,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// JobCollection collection of jobs.
type JobCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of jobs.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCollectionIterator provides access to a complete listing of Job values.
type JobCollectionIterator struct {
	i    int
	page JobCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCollectionIterator) Response() JobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jc JobCollection) IsEmpty() bool {
	return jc.Value == nil || len(*jc.Value) == 0
}

// jobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jc JobCollection) jobCollectionPreparer() (*http.Request, error) {
	if jc.NextLink == nil || len(to.String(jc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jc.NextLink)))
}

// JobCollectionPage contains a page of Job values.
type JobCollectionPage struct {
	fn func(JobCollection) (JobCollection, error)
	jc JobCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionPage) Next() error {
	next, err := page.fn(page.jc)
	if err != nil {
		return err
	}
	page.jc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionPage) NotDone() bool {
	return !page.jc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCollectionPage) Response() JobCollection {
	return page.jc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionPage) Values() []Job {
	if page.jc.IsEmpty() {
		return nil
	}
	return *page.jc.Value
}

// BasicJobDetails job details based on specific job type.
type BasicJobDetails interface {
	AsAsrJobDetails() (*AsrJobDetails, bool)
	AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool)
	AsFailoverJobDetails() (*FailoverJobDetails, bool)
	AsExportJobDetails() (*ExportJobDetails, bool)
	AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details based on specific job type.
type JobDetails struct {
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAsrJobDetails):
		var ajd AsrJobDetails
		err := json.Unmarshal(body, &ajd)
		return ajd, err
	case string(InstanceTypeTestFailoverJobDetails):
		var tfjd TestFailoverJobDetails
		err := json.Unmarshal(body, &tfjd)
		return tfjd, err
	case string(InstanceTypeFailoverJobDetails):
		var fjd FailoverJobDetails
		err := json.Unmarshal(body, &fjd)
		return fjd, err
	case string(InstanceTypeExportJobDetails):
		var ejd ExportJobDetails
		err := json.Unmarshal(body, &ejd)
		return ejd, err
	case string(InstanceTypeSwitchProtectionJobDetails):
		var spjd SwitchProtectionJobDetails
		err := json.Unmarshal(body, &spjd)
		return spjd, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.InstanceType = InstanceTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = jd.AffectedObjectDetails
	}
	if jd.InstanceType != "" {
		objectMap["instanceType"] = jd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// JobEntity this class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	// JobID - The job id.
	JobID *string `json:"jobId,omitempty"`
	// JobFriendlyName - The job display name.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`
	// TargetObjectID - The object id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`
	// TargetObjectName - The object name.
	TargetObjectName *string `json:"targetObjectName,omitempty"`
	// TargetInstanceType - The workflow affected object type.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	// JobScenarioName - The job name. Enum type ScenarioName.
	JobScenarioName *string `json:"jobScenarioName,omitempty"`
}

// JobErrorDetails this class contains the error details per object.
type JobErrorDetails struct {
	// ServiceErrorDetails - The Service error details.
	ServiceErrorDetails *ServiceError `json:"serviceErrorDetails,omitempty"`
	// ProviderErrorDetails - The Provider error details.
	ProviderErrorDetails *ProviderError `json:"providerErrorDetails,omitempty"`
	// ErrorLevel - Error level of error.
	ErrorLevel *string `json:"errorLevel,omitempty"`
	// CreationTime - The creation time of job error.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// TaskID - The Id of the task.
	TaskID *string `json:"taskId,omitempty"`
}

// JobProperties job custom data details.
type JobProperties struct {
	// ActivityID - The activity id.
	ActivityID *string `json:"activityId,omitempty"`
	// ScenarioName - The ScenarioName.
	ScenarioName *string `json:"scenarioName,omitempty"`
	// FriendlyName - The DisplayName.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// State - The status of the Job. It is one of these values - NotStarted, InProgress, Succeeded, Failed, Cancelled, Suspended or Other.
	State *string `json:"state,omitempty"`
	// StateDescription - The description of the state of the Job. For e.g. - For Succeeded state, description can be Completed, PartiallySucceeded, CompletedWithInformation or Skipped.
	StateDescription *string `json:"stateDescription,omitempty"`
	// Tasks - The tasks.
	Tasks *[]ASRTask `json:"tasks,omitempty"`
	// Errors - The errors.
	Errors *[]JobErrorDetails `json:"errors,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// AllowedActions - The Allowed action the job.
	AllowedActions *[]string `json:"allowedActions,omitempty"`
	// TargetObjectID - The affected Object Id.
	TargetObjectID *string `json:"targetObjectId,omitempty"`
	// TargetObjectName - The name of the affected object.
	TargetObjectName *string `json:"targetObjectName,omitempty"`
	// TargetInstanceType - The type of the affected object which is of {Microsoft.Azure.SiteRecovery.V2015_11_10.AffectedObjectType} class.
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	// CustomDetails - The custom job details like test failover job details.
	CustomDetails BasicJobDetails `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "activityId":
			if v != nil {
				var activityID string
				err = json.Unmarshal(*v, &activityID)
				if err != nil {
					return err
				}
				jp.ActivityID = &activityID
			}
		case "scenarioName":
			if v != nil {
				var scenarioName string
				err = json.Unmarshal(*v, &scenarioName)
				if err != nil {
					return err
				}
				jp.ScenarioName = &scenarioName
			}
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				jp.FriendlyName = &friendlyName
			}
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				jp.State = &state
			}
		case "stateDescription":
			if v != nil {
				var stateDescription string
				err = json.Unmarshal(*v, &stateDescription)
				if err != nil {
					return err
				}
				jp.StateDescription = &stateDescription
			}
		case "tasks":
			if v != nil {
				var tasks []ASRTask
				err = json.Unmarshal(*v, &tasks)
				if err != nil {
					return err
				}
				jp.Tasks = &tasks
			}
		case "errors":
			if v != nil {
				var errorsVar []JobErrorDetails
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				jp.Errors = &errorsVar
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				jp.EndTime = &endTime
			}
		case "allowedActions":
			if v != nil {
				var allowedActions []string
				err = json.Unmarshal(*v, &allowedActions)
				if err != nil {
					return err
				}
				jp.AllowedActions = &allowedActions
			}
		case "targetObjectId":
			if v != nil {
				var targetObjectID string
				err = json.Unmarshal(*v, &targetObjectID)
				if err != nil {
					return err
				}
				jp.TargetObjectID = &targetObjectID
			}
		case "targetObjectName":
			if v != nil {
				var targetObjectName string
				err = json.Unmarshal(*v, &targetObjectName)
				if err != nil {
					return err
				}
				jp.TargetObjectName = &targetObjectName
			}
		case "targetInstanceType":
			if v != nil {
				var targetInstanceType string
				err = json.Unmarshal(*v, &targetInstanceType)
				if err != nil {
					return err
				}
				jp.TargetInstanceType = &targetInstanceType
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// JobQueryParameter query parameter to enumerate jobs.
type JobQueryParameter struct {
	// StartTime - Date time to get jobs from.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - Date time to get jobs upto.
	EndTime *string `json:"endTime,omitempty"`
	// FabricID - The Id of the fabric to search jobs under.
	FabricID *string `json:"fabricId,omitempty"`
	// AffectedObjectTypes - The type of objects.
	AffectedObjectTypes *[]string `json:"affectedObjectTypes,omitempty"`
	// JobStatus - The states of the job to be filtered can be in.
	JobStatus *[]string `json:"jobStatus,omitempty"`
}

// JobStatusEventDetails model class for event details of a job status event.
type JobStatusEventDetails struct {
	// JobID - Job arm id for the event.
	JobID *string `json:"jobId,omitempty"`
	// JobFriendlyName - JobName for the Event.
	JobFriendlyName *string `json:"jobFriendlyName,omitempty"`
	// JobStatus - JobStatus for the Event.
	JobStatus *string `json:"jobStatus,omitempty"`
	// AffectedObjectType - AffectedObjectType for the event.
	AffectedObjectType *string `json:"affectedObjectType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeEventSpecificDetails', 'InstanceTypeJobStatus'
	InstanceType InstanceTypeBasicEventSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStatusEventDetails.
func (jsed JobStatusEventDetails) MarshalJSON() ([]byte, error) {
	jsed.InstanceType = InstanceTypeJobStatus
	objectMap := make(map[string]interface{})
	if jsed.JobID != nil {
		objectMap["jobId"] = jsed.JobID
	}
	if jsed.JobFriendlyName != nil {
		objectMap["jobFriendlyName"] = jsed.JobFriendlyName
	}
	if jsed.JobStatus != nil {
		objectMap["jobStatus"] = jsed.JobStatus
	}
	if jsed.AffectedObjectType != nil {
		objectMap["affectedObjectType"] = jsed.AffectedObjectType
	}
	if jsed.InstanceType != "" {
		objectMap["instanceType"] = jsed.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobStatusEventDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsJobStatusEventDetails() (*JobStatusEventDetails, bool) {
	return &jsed, true
}

// AsEventSpecificDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsEventSpecificDetails() (*EventSpecificDetails, bool) {
	return nil, false
}

// AsBasicEventSpecificDetails is the BasicEventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsBasicEventSpecificDetails() (BasicEventSpecificDetails, bool) {
	return &jsed, true
}

// JobTaskDetails this class represents a task which is actually a workflow so that one can navigate to its
// individual drill down.
type JobTaskDetails struct {
	// JobTask - The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTaskDetails.
func (jtd JobTaskDetails) MarshalJSON() ([]byte, error) {
	jtd.InstanceType = InstanceTypeJobTaskDetails
	objectMap := make(map[string]interface{})
	if jtd.JobTask != nil {
		objectMap["jobTask"] = jtd.JobTask
	}
	if jtd.InstanceType != "" {
		objectMap["instanceType"] = jtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return &jtd, true
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &jtd, true
}

// LogicalNetwork logical network data model.
type LogicalNetwork struct {
	autorest.Response `json:"-"`
	// Properties - The Logical Network Properties.
	Properties *LogicalNetworkProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// LogicalNetworkCollection list of logical networks.
type LogicalNetworkCollection struct {
	autorest.Response `json:"-"`
	// Value - The Logical Networks list details.
	Value *[]LogicalNetwork `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalNetworkCollectionIterator provides access to a complete listing of LogicalNetwork values.
type LogicalNetworkCollectionIterator struct {
	i    int
	page LogicalNetworkCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalNetworkCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalNetworkCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalNetworkCollectionIterator) Response() LogicalNetworkCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalNetworkCollectionIterator) Value() LogicalNetwork {
	if !iter.page.NotDone() {
		return LogicalNetwork{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lnc LogicalNetworkCollection) IsEmpty() bool {
	return lnc.Value == nil || len(*lnc.Value) == 0
}

// logicalNetworkCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lnc LogicalNetworkCollection) logicalNetworkCollectionPreparer() (*http.Request, error) {
	if lnc.NextLink == nil || len(to.String(lnc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lnc.NextLink)))
}

// LogicalNetworkCollectionPage contains a page of LogicalNetwork values.
type LogicalNetworkCollectionPage struct {
	fn  func(LogicalNetworkCollection) (LogicalNetworkCollection, error)
	lnc LogicalNetworkCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalNetworkCollectionPage) Next() error {
	next, err := page.fn(page.lnc)
	if err != nil {
		return err
	}
	page.lnc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalNetworkCollectionPage) NotDone() bool {
	return !page.lnc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalNetworkCollectionPage) Response() LogicalNetworkCollection {
	return page.lnc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalNetworkCollectionPage) Values() []LogicalNetwork {
	if page.lnc.IsEmpty() {
		return nil
	}
	return *page.lnc.Value
}

// LogicalNetworkProperties logical Network Properties.
type LogicalNetworkProperties struct {
	// FriendlyName - The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// NetworkVirtualizationStatus - A value indicating whether Network Virtualization is enabled for the logical network.
	NetworkVirtualizationStatus *string `json:"networkVirtualizationStatus,omitempty"`
	// LogicalNetworkUsage - A value indicating whether logical network is used as private test network by test failover.
	LogicalNetworkUsage *string `json:"logicalNetworkUsage,omitempty"`
	// LogicalNetworkDefinitionsStatus - A value indicating whether logical network definitions are isolated.
	LogicalNetworkDefinitionsStatus *string `json:"logicalNetworkDefinitionsStatus,omitempty"`
}

// ManualActionTaskDetails this class represents the manual action task details.
type ManualActionTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// Instructions - The instructions.
	Instructions *string `json:"instructions,omitempty"`
	// Observation - The observation.
	Observation *string `json:"observation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) MarshalJSON() ([]byte, error) {
	matd.InstanceType = InstanceTypeManualActionTaskDetails
	objectMap := make(map[string]interface{})
	if matd.Name != nil {
		objectMap["name"] = matd.Name
	}
	if matd.Instructions != nil {
		objectMap["instructions"] = matd.Instructions
	}
	if matd.Observation != nil {
		objectMap["observation"] = matd.Observation
	}
	if matd.InstanceType != "" {
		objectMap["instanceType"] = matd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return &matd, true
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &matd, true
}

// MasterTargetServer details of a Master Target Server.
type MasterTargetServer struct {
	// ID - The server Id.
	ID *string `json:"id,omitempty"`
	// IPAddress - The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Name - The server name.
	Name *string `json:"name,omitempty"`
	// OsType - The OS type of the server.
	OsType *string `json:"osType,omitempty"`
	// AgentVersion - The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// LastHeartbeat - The last heartbeat received from the server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// VersionStatus - Version status
	VersionStatus *string `json:"versionStatus,omitempty"`
	// RetentionVolumes - The retention volumes of Master target Server.
	RetentionVolumes *[]RetentionVolume `json:"retentionVolumes,omitempty"`
	// DataStores - The list of data stores in the fabric.
	DataStores *[]DataStore `json:"dataStores,omitempty"`
	// ValidationErrors - Validation errors.
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// DiskCount - Disk count of the master target.
	DiskCount *int32 `json:"diskCount,omitempty"`
	// OsVersion - OS Version of the master target.
	OsVersion *string `json:"osVersion,omitempty"`
}

// MethodCallStatus reports method status where exception was raised.
type MethodCallStatus struct {
	// IsVirtual - Gets a value indicating whether called method was virtual
	IsVirtual *string `json:"isVirtual,omitempty"`
	// Parameters - Gets parameter list passed to method.
	Parameters *[]string `json:"parameters,omitempty"`
	// ContainsGenericParameters - Gets a value indicating whether method container generic params.
	ContainsGenericParameters *string `json:"containsGenericParameters,omitempty"`
}

// MobilityServiceUpdate the Mobility Service update details.
type MobilityServiceUpdate struct {
	// Version - The version of the latest update.
	Version *string `json:"version,omitempty"`
	// RebootStatus - The reboot status of the update - whether it is required or not.
	RebootStatus *string `json:"rebootStatus,omitempty"`
	// OsType - The OS type.
	OsType *string `json:"osType,omitempty"`
}

// Network network model.
type Network struct {
	autorest.Response `json:"-"`
	// Properties - The Network Properties.
	Properties *NetworkProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// NetworkCollection list of networks.
type NetworkCollection struct {
	autorest.Response `json:"-"`
	// Value - The Networks list details.
	Value *[]Network `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkCollectionIterator provides access to a complete listing of Network values.
type NetworkCollectionIterator struct {
	i    int
	page NetworkCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkCollectionIterator) Response() NetworkCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkCollectionIterator) Value() Network {
	if !iter.page.NotDone() {
		return Network{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nc NetworkCollection) IsEmpty() bool {
	return nc.Value == nil || len(*nc.Value) == 0
}

// networkCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nc NetworkCollection) networkCollectionPreparer() (*http.Request, error) {
	if nc.NextLink == nil || len(to.String(nc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nc.NextLink)))
}

// NetworkCollectionPage contains a page of Network values.
type NetworkCollectionPage struct {
	fn func(NetworkCollection) (NetworkCollection, error)
	nc NetworkCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkCollectionPage) Next() error {
	next, err := page.fn(page.nc)
	if err != nil {
		return err
	}
	page.nc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkCollectionPage) NotDone() bool {
	return !page.nc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkCollectionPage) Response() NetworkCollection {
	return page.nc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkCollectionPage) Values() []Network {
	if page.nc.IsEmpty() {
		return nil
	}
	return *page.nc.Value
}

// NetworkMapping network Mapping model. Ideally it should have been possible to inherit this class from prev
// version in InheritedModels as long as there is no difference in structure or method signature. Since there were
// no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type,
// the class has been introduced in its entirety with references to base models to facilitate exensions in
// subsequent versions.
type NetworkMapping struct {
	autorest.Response `json:"-"`
	// Properties - The Network Mapping Properties.
	Properties *NetworkMappingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// NetworkMappingCollection list of network mappings. As with NetworkMapping, it should be possible to reuse a prev
// version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke
// collection of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing
// CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	autorest.Response `json:"-"`
	// Value - The Network Mappings list.
	Value *[]NetworkMapping `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// NetworkMappingCollectionIterator provides access to a complete listing of NetworkMapping values.
type NetworkMappingCollectionIterator struct {
	i    int
	page NetworkMappingCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NetworkMappingCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NetworkMappingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NetworkMappingCollectionIterator) Response() NetworkMappingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NetworkMappingCollectionIterator) Value() NetworkMapping {
	if !iter.page.NotDone() {
		return NetworkMapping{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nmc NetworkMappingCollection) IsEmpty() bool {
	return nmc.Value == nil || len(*nmc.Value) == 0
}

// networkMappingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nmc NetworkMappingCollection) networkMappingCollectionPreparer() (*http.Request, error) {
	if nmc.NextLink == nil || len(to.String(nmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nmc.NextLink)))
}

// NetworkMappingCollectionPage contains a page of NetworkMapping values.
type NetworkMappingCollectionPage struct {
	fn  func(NetworkMappingCollection) (NetworkMappingCollection, error)
	nmc NetworkMappingCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NetworkMappingCollectionPage) Next() error {
	next, err := page.fn(page.nmc)
	if err != nil {
		return err
	}
	page.nmc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NetworkMappingCollectionPage) NotDone() bool {
	return !page.nmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NetworkMappingCollectionPage) Response() NetworkMappingCollection {
	return page.nmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NetworkMappingCollectionPage) Values() []NetworkMapping {
	if page.nmc.IsEmpty() {
		return nil
	}
	return *page.nmc.Value
}

// BasicNetworkMappingFabricSpecificSettings network Mapping fabric specific settings.
type BasicNetworkMappingFabricSpecificSettings interface {
	AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool)
	AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool)
	AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool)
	AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool)
}

// NetworkMappingFabricSpecificSettings network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicNetworkMappingFabricSpecificSettings(body []byte) (BasicNetworkMappingFabricSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure):
		var atanms AzureToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &atanms)
		return atanms, err
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure):
		var vtanms VmmToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &vtanms)
		return vtanms, err
	case string(InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm):
		var vtvnms VmmToVmmNetworkMappingSettings
		err := json.Unmarshal(body, &vtvnms)
		return vtvnms, err
	default:
		var nmfss NetworkMappingFabricSpecificSettings
		err := json.Unmarshal(body, &nmfss)
		return nmfss, err
	}
}
func unmarshalBasicNetworkMappingFabricSpecificSettingsArray(body []byte) ([]BasicNetworkMappingFabricSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nmfssArray := make([]BasicNetworkMappingFabricSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nmfss, err := unmarshalBasicNetworkMappingFabricSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		nmfssArray[index] = nmfss
	}
	return nmfssArray, nil
}

// MarshalJSON is the custom marshaler for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) MarshalJSON() ([]byte, error) {
	nmfss.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings
	objectMap := make(map[string]interface{})
	if nmfss.InstanceType != "" {
		objectMap["instanceType"] = nmfss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return &nmfss, true
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for NetworkMappingFabricSpecificSettings.
func (nmfss NetworkMappingFabricSpecificSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &nmfss, true
}

// NetworkMappingProperties network Mapping Properties.
type NetworkMappingProperties struct {
	// State - The pairing state for network mapping.
	State *string `json:"state,omitempty"`
	// PrimaryNetworkFriendlyName - The primary network friendly name.
	PrimaryNetworkFriendlyName *string `json:"primaryNetworkFriendlyName,omitempty"`
	// PrimaryNetworkID - The primary network id for network mapping.
	PrimaryNetworkID *string `json:"primaryNetworkId,omitempty"`
	// PrimaryFabricFriendlyName - The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryNetworkFriendlyName - The recovery network friendly name.
	RecoveryNetworkFriendlyName *string `json:"recoveryNetworkFriendlyName,omitempty"`
	// RecoveryNetworkID - The recovery network id for network mapping.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
	// RecoveryFabricArmID - The recovery fabric ARM id.
	RecoveryFabricArmID *string `json:"recoveryFabricArmId,omitempty"`
	// RecoveryFabricFriendlyName - The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// FabricSpecificSettings - The fabric specific settings.
	FabricSpecificSettings BasicNetworkMappingFabricSpecificSettings `json:"fabricSpecificSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for NetworkMappingProperties struct.
func (nmp *NetworkMappingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "state":
			if v != nil {
				var state string
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				nmp.State = &state
			}
		case "primaryNetworkFriendlyName":
			if v != nil {
				var primaryNetworkFriendlyName string
				err = json.Unmarshal(*v, &primaryNetworkFriendlyName)
				if err != nil {
					return err
				}
				nmp.PrimaryNetworkFriendlyName = &primaryNetworkFriendlyName
			}
		case "primaryNetworkId":
			if v != nil {
				var primaryNetworkID string
				err = json.Unmarshal(*v, &primaryNetworkID)
				if err != nil {
					return err
				}
				nmp.PrimaryNetworkID = &primaryNetworkID
			}
		case "primaryFabricFriendlyName":
			if v != nil {
				var primaryFabricFriendlyName string
				err = json.Unmarshal(*v, &primaryFabricFriendlyName)
				if err != nil {
					return err
				}
				nmp.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
			}
		case "recoveryNetworkFriendlyName":
			if v != nil {
				var recoveryNetworkFriendlyName string
				err = json.Unmarshal(*v, &recoveryNetworkFriendlyName)
				if err != nil {
					return err
				}
				nmp.RecoveryNetworkFriendlyName = &recoveryNetworkFriendlyName
			}
		case "recoveryNetworkId":
			if v != nil {
				var recoveryNetworkID string
				err = json.Unmarshal(*v, &recoveryNetworkID)
				if err != nil {
					return err
				}
				nmp.RecoveryNetworkID = &recoveryNetworkID
			}
		case "recoveryFabricArmId":
			if v != nil {
				var recoveryFabricArmID string
				err = json.Unmarshal(*v, &recoveryFabricArmID)
				if err != nil {
					return err
				}
				nmp.RecoveryFabricArmID = &recoveryFabricArmID
			}
		case "recoveryFabricFriendlyName":
			if v != nil {
				var recoveryFabricFriendlyName string
				err = json.Unmarshal(*v, &recoveryFabricFriendlyName)
				if err != nil {
					return err
				}
				nmp.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
			}
		case "fabricSpecificSettings":
			if v != nil {
				fabricSpecificSettings, err := unmarshalBasicNetworkMappingFabricSpecificSettings(*v)
				if err != nil {
					return err
				}
				nmp.FabricSpecificSettings = fabricSpecificSettings
			}
		}
	}

	return nil
}

// NetworkProperties network Properties
type NetworkProperties struct {
	// FabricType - The Fabric Type.
	FabricType *string `json:"fabricType,omitempty"`
	// Subnets - The List of subnets.
	Subnets *[]Subnet `json:"subnets,omitempty"`
	// FriendlyName - The Friendly Name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// NetworkType - The Network Type.
	NetworkType *string `json:"networkType,omitempty"`
}

// OperationsDiscovery operations discovery class.
type OperationsDiscovery struct {
	// Name - Name of the API. The name of the operation being performed on this particular object. It should match the action name that appears in RBAC / the event service. Examples of operations include: * Microsoft.Compute/virtualMachine/capture/action * Microsoft.Compute/virtualMachine/restart/action * Microsoft.Compute/virtualMachine/write * Microsoft.Compute/virtualMachine/read * Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL Azure database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named value, Write should be used. If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to include the "{Resource Provider Namespace}/register/action" operation in their response. This API is used to register for their service, and should include details about the operation (e.g. a localized name for the resource provider + any special considerations like PII release)
	Name *string `json:"name,omitempty"`
	// Display - Object type
	Display *Display `json:"display,omitempty"`
	// Origin - Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default value is "user,system"
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties. Reserved for future use.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	autorest.Response `json:"-"`
	// Value - The ClientDiscovery details.
	Value *[]OperationsDiscovery `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsDiscoveryCollectionIterator provides access to a complete listing of OperationsDiscovery values.
type OperationsDiscoveryCollectionIterator struct {
	i    int
	page OperationsDiscoveryCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsDiscoveryCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsDiscoveryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsDiscoveryCollectionIterator) Response() OperationsDiscoveryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsDiscoveryCollectionIterator) Value() OperationsDiscovery {
	if !iter.page.NotDone() {
		return OperationsDiscovery{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (odc OperationsDiscoveryCollection) IsEmpty() bool {
	return odc.Value == nil || len(*odc.Value) == 0
}

// operationsDiscoveryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (odc OperationsDiscoveryCollection) operationsDiscoveryCollectionPreparer() (*http.Request, error) {
	if odc.NextLink == nil || len(to.String(odc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(odc.NextLink)))
}

// OperationsDiscoveryCollectionPage contains a page of OperationsDiscovery values.
type OperationsDiscoveryCollectionPage struct {
	fn  func(OperationsDiscoveryCollection) (OperationsDiscoveryCollection, error)
	odc OperationsDiscoveryCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsDiscoveryCollectionPage) Next() error {
	next, err := page.fn(page.odc)
	if err != nil {
		return err
	}
	page.odc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsDiscoveryCollectionPage) NotDone() bool {
	return !page.odc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsDiscoveryCollectionPage) Response() OperationsDiscoveryCollection {
	return page.odc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsDiscoveryCollectionPage) Values() []OperationsDiscovery {
	if page.odc.IsEmpty() {
		return nil
	}
	return *page.odc.Value
}

// OSDetails disk Details.
type OSDetails struct {
	// OsType - VM Disk details.
	OsType *string `json:"osType,omitempty"`
	// ProductType - Product type.
	ProductType *string `json:"productType,omitempty"`
	// OsEdition - The OSEdition.
	OsEdition *string `json:"osEdition,omitempty"`
	// OSVersion - The OS Version.
	OSVersion *string `json:"oSVersion,omitempty"`
	// OSMajorVersion - The OS Major Version.
	OSMajorVersion *string `json:"oSMajorVersion,omitempty"`
	// OSMinorVersion - The OS Minor Version.
	OSMinorVersion *string `json:"oSMinorVersion,omitempty"`
}

// OSDiskDetails details of the OS Disk.
type OSDiskDetails struct {
	// OsVhdID - The id of the disk containing the OS.
	OsVhdID *string `json:"osVhdId,omitempty"`
	// OsType - The type of the OS on the VM.
	OsType *string `json:"osType,omitempty"`
	// VhdName - The OS disk VHD name.
	VhdName *string `json:"vhdName,omitempty"`
}

// PlannedFailoverInput input definition for planned failover.
type PlannedFailoverInput struct {
	// Properties - Planned failover input properties
	Properties *PlannedFailoverInputProperties `json:"properties,omitempty"`
}

// PlannedFailoverInputProperties input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	// FailoverDirection - Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`
	// ProviderSpecificDetails - Provider specific settings
	ProviderSpecificDetails BasicProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PlannedFailoverInputProperties struct.
func (pfip *PlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection string
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				pfip.FailoverDirection = &failoverDirection
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProviderSpecificFailoverInput(*v)
				if err != nil {
					return err
				}
				pfip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// Policy protection profile details.
type Policy struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *PolicyProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// PolicyCollection protection Profile Collection details.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - The policy details.
	Value *[]Policy `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// PolicyCollectionIterator provides access to a complete listing of Policy values.
type PolicyCollectionIterator struct {
	i    int
	page PolicyCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PolicyCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PolicyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PolicyCollectionIterator) Response() PolicyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PolicyCollectionIterator) Value() Policy {
	if !iter.page.NotDone() {
		return Policy{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pc PolicyCollection) IsEmpty() bool {
	return pc.Value == nil || len(*pc.Value) == 0
}

// policyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pc PolicyCollection) policyCollectionPreparer() (*http.Request, error) {
	if pc.NextLink == nil || len(to.String(pc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pc.NextLink)))
}

// PolicyCollectionPage contains a page of Policy values.
type PolicyCollectionPage struct {
	fn func(PolicyCollection) (PolicyCollection, error)
	pc PolicyCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PolicyCollectionPage) Next() error {
	next, err := page.fn(page.pc)
	if err != nil {
		return err
	}
	page.pc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PolicyCollectionPage) NotDone() bool {
	return !page.pc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PolicyCollectionPage) Response() PolicyCollection {
	return page.pc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PolicyCollectionPage) Values() []Policy {
	if page.pc.IsEmpty() {
		return nil
	}
	return *page.pc.Value
}

// PolicyProperties protection profile custom data details.
type PolicyProperties struct {
	// FriendlyName - The FriendlyName.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProviderSpecificDetails - The ReplicationChannelSetting.
	ProviderSpecificDetails BasicPolicyProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PolicyProperties struct.
func (pp *PolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				pp.FriendlyName = &friendlyName
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicPolicyProviderSpecificDetails(*v)
				if err != nil {
					return err
				}
				pp.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicPolicyProviderSpecificDetails base class for Provider specific details for policies.
type BasicPolicyProviderSpecificDetails interface {
	AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool)
	AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool)
	AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool)
	AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool)
	AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool)
	AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool)
	AsInMagePolicyDetails() (*InMagePolicyDetails, bool)
	AsA2APolicyDetails() (*A2APolicyDetails, bool)
	AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool)
	AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool)
	AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool)
}

// PolicyProviderSpecificDetails base class for Provider specific details for policies.
type PolicyProviderSpecificDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicPolicyProviderSpecificDetails(body []byte) (BasicPolicyProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure):
		var hvrapd HyperVReplicaAzurePolicyDetails
		err := json.Unmarshal(body, &hvrapd)
		return hvrapd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails):
		var hvrbpd HyperVReplicaBasePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012):
		var hvrpd HyperVReplicaPolicyDetails
		err := json.Unmarshal(body, &hvrpd)
		return hvrpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2):
		var hvrbpd HyperVReplicaBluePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails):
		var imbpd InMageBasePolicyDetails
		err := json.Unmarshal(body, &imbpd)
		return imbpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2):
		var imavpd InMageAzureV2PolicyDetails
		err := json.Unmarshal(body, &imavpd)
		return imavpd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage):
		var impd InMagePolicyDetails
		err := json.Unmarshal(body, &impd)
		return impd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A):
		var apd A2APolicyDetails
		err := json.Unmarshal(body, &apd)
		return apd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration):
		var rampd RcmAzureMigrationPolicyDetails
		err := json.Unmarshal(body, &rampd)
		return rampd, err
	case string(InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt):
		var vcpd VmwareCbtPolicyDetails
		err := json.Unmarshal(body, &vcpd)
		return vcpd, err
	default:
		var ppsd PolicyProviderSpecificDetails
		err := json.Unmarshal(body, &ppsd)
		return ppsd, err
	}
}
func unmarshalBasicPolicyProviderSpecificDetailsArray(body []byte) ([]BasicPolicyProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsdArray := make([]BasicPolicyProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsd, err := unmarshalBasicPolicyProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsdArray[index] = ppsd
	}
	return ppsdArray, nil
}

// MarshalJSON is the custom marshaler for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) MarshalJSON() ([]byte, error) {
	ppsd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails
	objectMap := make(map[string]interface{})
	if ppsd.InstanceType != "" {
		objectMap["instanceType"] = ppsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return &ppsd, true
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for PolicyProviderSpecificDetails.
func (ppsd PolicyProviderSpecificDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &ppsd, true
}

// BasicPolicyProviderSpecificInput base class for provider specific input
type BasicPolicyProviderSpecificInput interface {
	AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool)
	AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool)
	AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool)
	AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool)
	AsInMagePolicyInput() (*InMagePolicyInput, bool)
	AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool)
	AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool)
	AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool)
}

// PolicyProviderSpecificInput base class for provider specific input
type PolicyProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicPolicyProviderSpecificInput(body []byte) (BasicPolicyProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvrapi HyperVReplicaAzurePolicyInput
		err := json.Unmarshal(body, &hvrapi)
		return hvrapi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012):
		var hvrpi HyperVReplicaPolicyInput
		err := json.Unmarshal(body, &hvrpi)
		return hvrpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2):
		var hvrbpi HyperVReplicaBluePolicyInput
		err := json.Unmarshal(body, &hvrbpi)
		return hvrbpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavpi InMageAzureV2PolicyInput
		err := json.Unmarshal(body, &imavpi)
		return imavpi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage):
		var impi InMagePolicyInput
		err := json.Unmarshal(body, &impi)
		return impi, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A):
		var apci A2APolicyCreationInput
		err := json.Unmarshal(body, &apci)
		return apci, err
	case string(InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt):
		var vmcpci VMwareCbtPolicyCreationInput
		err := json.Unmarshal(body, &vmcpci)
		return vmcpci, err
	default:
		var ppsi PolicyProviderSpecificInput
		err := json.Unmarshal(body, &ppsi)
		return ppsi, err
	}
}
func unmarshalBasicPolicyProviderSpecificInputArray(body []byte) ([]BasicPolicyProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsiArray := make([]BasicPolicyProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsi, err := unmarshalBasicPolicyProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsiArray[index] = ppsi
	}
	return ppsiArray, nil
}

// MarshalJSON is the custom marshaler for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) MarshalJSON() ([]byte, error) {
	ppsi.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput
	objectMap := make(map[string]interface{})
	if ppsi.InstanceType != "" {
		objectMap["instanceType"] = ppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return &ppsi, true
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for PolicyProviderSpecificInput.
func (ppsi PolicyProviderSpecificInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &ppsi, true
}

// ProcessServer details of the Process Server.
type ProcessServer struct {
	// FriendlyName - The Process Server's friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ID - The Process Server Id.
	ID *string `json:"id,omitempty"`
	// IPAddress - The IP address of the server.
	IPAddress *string `json:"ipAddress,omitempty"`
	// OsType - The OS type of the server.
	OsType *string `json:"osType,omitempty"`
	// AgentVersion - The version of the scout component on the server.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// LastHeartbeat - The last heartbeat received from the server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// VersionStatus - Version status
	VersionStatus *string `json:"versionStatus,omitempty"`
	// MobilityServiceUpdates - The list of the mobility service updates available on the Process Server.
	MobilityServiceUpdates *[]MobilityServiceUpdate `json:"mobilityServiceUpdates,omitempty"`
	// HostID - The agent generated Id.
	HostID *string `json:"hostId,omitempty"`
	// MachineCount - The servers configured with this PS.
	MachineCount *string `json:"machineCount,omitempty"`
	// ReplicationPairCount - The number of replication pairs configured in this PS.
	ReplicationPairCount *string `json:"replicationPairCount,omitempty"`
	// SystemLoad - The percentage of the system load.
	SystemLoad *string `json:"systemLoad,omitempty"`
	// SystemLoadStatus - The system load status.
	SystemLoadStatus *string `json:"systemLoadStatus,omitempty"`
	// CPULoad - The percentage of the CPU load.
	CPULoad *string `json:"cpuLoad,omitempty"`
	// CPULoadStatus - The CPU load status.
	CPULoadStatus *string `json:"cpuLoadStatus,omitempty"`
	// TotalMemoryInBytes - The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`
	// AvailableMemoryInBytes - The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`
	// MemoryUsageStatus - The memory usage status.
	MemoryUsageStatus *string `json:"memoryUsageStatus,omitempty"`
	// TotalSpaceInBytes - The total space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`
	// AvailableSpaceInBytes - The available space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`
	// SpaceUsageStatus - The space usage status.
	SpaceUsageStatus *string `json:"spaceUsageStatus,omitempty"`
	// PsServiceStatus - The PS service status.
	PsServiceStatus *string `json:"psServiceStatus,omitempty"`
	// SslCertExpiryDate - The PS SSL cert expiry date.
	SslCertExpiryDate *date.Time `json:"sslCertExpiryDate,omitempty"`
	// SslCertExpiryRemainingDays - CS SSL cert expiry date.
	SslCertExpiryRemainingDays *int32 `json:"sslCertExpiryRemainingDays,omitempty"`
	// OsVersion - OS Version of the process server. Note: This will get populated if user has CS version greater than 9.12.0.0.
	OsVersion *string `json:"osVersion,omitempty"`
}

// ProtectableItem replication protected item
type ProtectableItem struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectableItemProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// ProtectableItemCollection protectable item collection.
type ProtectableItemCollection struct {
	autorest.Response `json:"-"`
	// Value - The Protectable item details.
	Value *[]ProtectableItem `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectableItemCollectionIterator provides access to a complete listing of ProtectableItem values.
type ProtectableItemCollectionIterator struct {
	i    int
	page ProtectableItemCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectableItemCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectableItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectableItemCollectionIterator) Response() ProtectableItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectableItemCollectionIterator) Value() ProtectableItem {
	if !iter.page.NotDone() {
		return ProtectableItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pic ProtectableItemCollection) IsEmpty() bool {
	return pic.Value == nil || len(*pic.Value) == 0
}

// protectableItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pic ProtectableItemCollection) protectableItemCollectionPreparer() (*http.Request, error) {
	if pic.NextLink == nil || len(to.String(pic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pic.NextLink)))
}

// ProtectableItemCollectionPage contains a page of ProtectableItem values.
type ProtectableItemCollectionPage struct {
	fn  func(ProtectableItemCollection) (ProtectableItemCollection, error)
	pic ProtectableItemCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectableItemCollectionPage) Next() error {
	next, err := page.fn(page.pic)
	if err != nil {
		return err
	}
	page.pic = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectableItemCollectionPage) NotDone() bool {
	return !page.pic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectableItemCollectionPage) Response() ProtectableItemCollection {
	return page.pic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectableItemCollectionPage) Values() []ProtectableItem {
	if page.pic.IsEmpty() {
		return nil
	}
	return *page.pic.Value
}

// ProtectableItemProperties replication protected item custom data details.
type ProtectableItemProperties struct {
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionStatus - The protection status.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ReplicationProtectedItemID - The ARM resource of protected items.
	ReplicationProtectedItemID *string `json:"replicationProtectedItemId,omitempty"`
	// RecoveryServicesProviderID - The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`
	// ProtectionReadinessErrors - The Current protection readiness errors.
	ProtectionReadinessErrors *[]string `json:"protectionReadinessErrors,omitempty"`
	// SupportedReplicationProviders - The list of replication providers supported for the protectable item.
	SupportedReplicationProviders *[]string `json:"supportedReplicationProviders,omitempty"`
	// CustomDetails - The Replication provider custom settings.
	CustomDetails BasicConfigurationSettings `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProtectableItemProperties struct.
func (pip *ProtectableItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				pip.FriendlyName = &friendlyName
			}
		case "protectionStatus":
			if v != nil {
				var protectionStatus string
				err = json.Unmarshal(*v, &protectionStatus)
				if err != nil {
					return err
				}
				pip.ProtectionStatus = &protectionStatus
			}
		case "replicationProtectedItemId":
			if v != nil {
				var replicationProtectedItemID string
				err = json.Unmarshal(*v, &replicationProtectedItemID)
				if err != nil {
					return err
				}
				pip.ReplicationProtectedItemID = &replicationProtectedItemID
			}
		case "recoveryServicesProviderId":
			if v != nil {
				var recoveryServicesProviderID string
				err = json.Unmarshal(*v, &recoveryServicesProviderID)
				if err != nil {
					return err
				}
				pip.RecoveryServicesProviderID = &recoveryServicesProviderID
			}
		case "protectionReadinessErrors":
			if v != nil {
				var protectionReadinessErrors []string
				err = json.Unmarshal(*v, &protectionReadinessErrors)
				if err != nil {
					return err
				}
				pip.ProtectionReadinessErrors = &protectionReadinessErrors
			}
		case "supportedReplicationProviders":
			if v != nil {
				var supportedReplicationProviders []string
				err = json.Unmarshal(*v, &supportedReplicationProviders)
				if err != nil {
					return err
				}
				pip.SupportedReplicationProviders = &supportedReplicationProviders
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicConfigurationSettings(*v)
				if err != nil {
					return err
				}
				pip.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// ProtectedItemsQueryParameter query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	// SourceFabricName - The source fabric name filter.
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
	// RecoveryPlanName - The recovery plan filter.
	RecoveryPlanName *string `json:"recoveryPlanName,omitempty"`
	// VCenterName - The vCenter name filter.
	VCenterName *string `json:"vCenterName,omitempty"`
}

// ProtectionContainer protection container details.
type ProtectionContainer struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectionContainerProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// ProtectionContainerCollection protection Container collection.
type ProtectionContainerCollection struct {
	autorest.Response `json:"-"`
	// Value - The Protection Container details.
	Value *[]ProtectionContainer `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerCollectionIterator provides access to a complete listing of ProtectionContainer values.
type ProtectionContainerCollectionIterator struct {
	i    int
	page ProtectionContainerCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerCollectionIterator) Response() ProtectionContainerCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerCollectionIterator) Value() ProtectionContainer {
	if !iter.page.NotDone() {
		return ProtectionContainer{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pcc ProtectionContainerCollection) IsEmpty() bool {
	return pcc.Value == nil || len(*pcc.Value) == 0
}

// protectionContainerCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcc ProtectionContainerCollection) protectionContainerCollectionPreparer() (*http.Request, error) {
	if pcc.NextLink == nil || len(to.String(pcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcc.NextLink)))
}

// ProtectionContainerCollectionPage contains a page of ProtectionContainer values.
type ProtectionContainerCollectionPage struct {
	fn  func(ProtectionContainerCollection) (ProtectionContainerCollection, error)
	pcc ProtectionContainerCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerCollectionPage) Next() error {
	next, err := page.fn(page.pcc)
	if err != nil {
		return err
	}
	page.pcc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerCollectionPage) NotDone() bool {
	return !page.pcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerCollectionPage) Response() ProtectionContainerCollection {
	return page.pcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerCollectionPage) Values() []ProtectionContainer {
	if page.pcc.IsEmpty() {
		return nil
	}
	return *page.pcc.Value
}

// ProtectionContainerFabricSpecificDetails base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	// InstanceType - Gets the class type. Overriden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerMapping protection container mapping object.
type ProtectionContainerMapping struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ProtectionContainerMappingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// ProtectionContainerMappingCollection protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	autorest.Response `json:"-"`
	// Value - List of container mappings.
	Value *[]ProtectionContainerMapping `json:"value,omitempty"`
	// NextLink - Link to fetch rest of the data.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectionContainerMappingCollectionIterator provides access to a complete listing of ProtectionContainerMapping
// values.
type ProtectionContainerMappingCollectionIterator struct {
	i    int
	page ProtectionContainerMappingCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectionContainerMappingCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectionContainerMappingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectionContainerMappingCollectionIterator) Response() ProtectionContainerMappingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectionContainerMappingCollectionIterator) Value() ProtectionContainerMapping {
	if !iter.page.NotDone() {
		return ProtectionContainerMapping{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (pcmc ProtectionContainerMappingCollection) IsEmpty() bool {
	return pcmc.Value == nil || len(*pcmc.Value) == 0
}

// protectionContainerMappingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcmc ProtectionContainerMappingCollection) protectionContainerMappingCollectionPreparer() (*http.Request, error) {
	if pcmc.NextLink == nil || len(to.String(pcmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcmc.NextLink)))
}

// ProtectionContainerMappingCollectionPage contains a page of ProtectionContainerMapping values.
type ProtectionContainerMappingCollectionPage struct {
	fn   func(ProtectionContainerMappingCollection) (ProtectionContainerMappingCollection, error)
	pcmc ProtectionContainerMappingCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectionContainerMappingCollectionPage) Next() error {
	next, err := page.fn(page.pcmc)
	if err != nil {
		return err
	}
	page.pcmc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectionContainerMappingCollectionPage) NotDone() bool {
	return !page.pcmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectionContainerMappingCollectionPage) Response() ProtectionContainerMappingCollection {
	return page.pcmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectionContainerMappingCollectionPage) Values() []ProtectionContainerMapping {
	if page.pcmc.IsEmpty() {
		return nil
	}
	return *page.pcmc.Value
}

// ProtectionContainerMappingProperties protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	// TargetProtectionContainerID - Paired protection container ARM ID.
	TargetProtectionContainerID *string `json:"targetProtectionContainerId,omitempty"`
	// TargetProtectionContainerFriendlyName - Friendly name of paired container.
	TargetProtectionContainerFriendlyName *string `json:"targetProtectionContainerFriendlyName,omitempty"`
	// ProviderSpecificDetails - Provider specific provider details.
	ProviderSpecificDetails *ProtectionContainerMappingProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	// Health - Health of pairing.
	Health *string `json:"health,omitempty"`
	// HealthErrorDetails - Health error.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// PolicyID - Policy ARM Id.
	PolicyID *string `json:"policyId,omitempty"`
	// State - Association Status
	State *string `json:"state,omitempty"`
	// SourceProtectionContainerFriendlyName - Friendly name of source protection container.
	SourceProtectionContainerFriendlyName *string `json:"sourceProtectionContainerFriendlyName,omitempty"`
	// SourceFabricFriendlyName - Friendly name of source fabric.
	SourceFabricFriendlyName *string `json:"sourceFabricFriendlyName,omitempty"`
	// TargetFabricFriendlyName - Friendly name of target fabric.
	TargetFabricFriendlyName *string `json:"targetFabricFriendlyName,omitempty"`
	// PolicyFriendlyName - Friendly name of replication policy.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`
}

// ProtectionContainerMappingProviderSpecificDetails container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	// InstanceType - Gets the class type. Overriden in derived classes.
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerProperties protection profile custom data details.
type ProtectionContainerProperties struct {
	// FabricFriendlyName - Fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FabricType - The fabric type.
	FabricType *string `json:"fabricType,omitempty"`
	// ProtectedItemCount - Number of protected PEs
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`
	// PairingStatus - The pairing status of this cloud.
	PairingStatus *string `json:"pairingStatus,omitempty"`
	// Role - The role of this cloud.
	Role *string `json:"role,omitempty"`
	// FabricSpecificDetails - Fabric specific details.
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails `json:"fabricSpecificDetails,omitempty"`
}

// ProviderError this class contains the error details per object.
type ProviderError struct {
	// ErrorCode - The Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - The Error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorID - The Provider error Id.
	ErrorID *string `json:"errorId,omitempty"`
	// PossibleCauses - The possible causes for the error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - The recommended action to resolve the error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// BasicProviderSpecificFailoverInput provider specific failover input.
type BasicProviderSpecificFailoverInput interface {
	AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool)
	AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool)
	AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool)
	AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool)
	AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool)
	AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool)
}

// ProviderSpecificFailoverInput provider specific failover input.
type ProviderSpecificFailoverInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

func unmarshalBasicProviderSpecificFailoverInput(body []byte) (BasicProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var hvrafpi HyperVReplicaAzureFailoverProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var hvrafpi HyperVReplicaAzureFailbackProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var imavfpi InMageAzureV2FailoverProviderInput
		err := json.Unmarshal(body, &imavfpi)
		return imavfpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage):
		var imfpi InMageFailoverProviderInput
		err := json.Unmarshal(body, &imfpi)
		return imfpi, err
	case string(InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A):
		var afpi A2AFailoverProviderInput
		err := json.Unmarshal(body, &afpi)
		return afpi, err
	default:
		var psfi ProviderSpecificFailoverInput
		err := json.Unmarshal(body, &psfi)
		return psfi, err
	}
}
func unmarshalBasicProviderSpecificFailoverInputArray(body []byte) ([]BasicProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psfiArray := make([]BasicProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psfi, err := unmarshalBasicProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		psfiArray[index] = psfi
	}
	return psfiArray, nil
}

// MarshalJSON is the custom marshaler for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	psfi.InstanceType = InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput
	objectMap := make(map[string]interface{})
	if psfi.InstanceType != "" {
		objectMap["instanceType"] = psfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// AsProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsProviderSpecificFailoverInput() (*ProviderSpecificFailoverInput, bool) {
	return &psfi, true
}

// AsBasicProviderSpecificFailoverInput is the BasicProviderSpecificFailoverInput implementation for ProviderSpecificFailoverInput.
func (psfi ProviderSpecificFailoverInput) AsBasicProviderSpecificFailoverInput() (BasicProviderSpecificFailoverInput, bool) {
	return &psfi, true
}

// ProviderSpecificRecoveryPointDetails replication provider specific recovery point details.
type ProviderSpecificRecoveryPointDetails struct {
	// Type - Gets the provider type.
	Type *string `json:"Type,omitempty"`
}

// RcmAzureMigrationPolicyDetails RCM based Azure migration specific policy details.
type RcmAzureMigrationPolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// MultiVMSyncStatus - A value indicating whether multi-VM sync has to be enabled. Possible values include: 'Enabled', 'Disabled'
	MultiVMSyncStatus MultiVMSyncStatus `json:"multiVmSyncStatus,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) MarshalJSON() ([]byte, error) {
	rampd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration
	objectMap := make(map[string]interface{})
	if rampd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = rampd.RecoveryPointThresholdInMinutes
	}
	if rampd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = rampd.RecoveryPointHistory
	}
	if rampd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = rampd.AppConsistentFrequencyInMinutes
	}
	if rampd.MultiVMSyncStatus != "" {
		objectMap["multiVmSyncStatus"] = rampd.MultiVMSyncStatus
	}
	if rampd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = rampd.CrashConsistentFrequencyInMinutes
	}
	if rampd.InstanceType != "" {
		objectMap["instanceType"] = rampd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return &rampd, true
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &rampd, true
}

// RecoveryPlan recovery plan details.
type RecoveryPlan struct {
	autorest.Response `json:"-"`
	// Properties - The custom details.
	Properties *RecoveryPlanProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// RecoveryPlanA2AFailoverInput recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	// RecoveryPointType - The recovery point type. Possible values include: 'Latest', 'LatestApplicationConsistent', 'LatestCrashConsistent', 'LatestProcessed'
	RecoveryPointType A2ARpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// CloudServiceCreationOption - A value indicating whether to use recovery cloud service for TFO or not.
	CloudServiceCreationOption *string `json:"cloudServiceCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) MarshalJSON() ([]byte, error) {
	rpafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A
	objectMap := make(map[string]interface{})
	if rpafi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpafi.RecoveryPointType
	}
	if rpafi.CloudServiceCreationOption != nil {
		objectMap["cloudServiceCreationOption"] = rpafi.CloudServiceCreationOption
	}
	if rpafi.InstanceType != "" {
		objectMap["instanceType"] = rpafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return &rpafi, true
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpafi, true
}

// RecoveryPlanAction recovery plan action details.
type RecoveryPlanAction struct {
	// ActionName - The action name.
	ActionName *string `json:"actionName,omitempty"`
	// FailoverTypes - The list of failover types.
	FailoverTypes *[]ReplicationProtectedItemOperation `json:"failoverTypes,omitempty"`
	// FailoverDirections - The list of failover directions.
	FailoverDirections *[]PossibleOperationsDirections `json:"failoverDirections,omitempty"`
	// CustomDetails - The custom details.
	CustomDetails BasicRecoveryPlanActionDetails `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanAction struct.
func (rpa *RecoveryPlanAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "actionName":
			if v != nil {
				var actionName string
				err = json.Unmarshal(*v, &actionName)
				if err != nil {
					return err
				}
				rpa.ActionName = &actionName
			}
		case "failoverTypes":
			if v != nil {
				var failoverTypes []ReplicationProtectedItemOperation
				err = json.Unmarshal(*v, &failoverTypes)
				if err != nil {
					return err
				}
				rpa.FailoverTypes = &failoverTypes
			}
		case "failoverDirections":
			if v != nil {
				var failoverDirections []PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirections)
				if err != nil {
					return err
				}
				rpa.FailoverDirections = &failoverDirections
			}
		case "customDetails":
			if v != nil {
				customDetails, err := unmarshalBasicRecoveryPlanActionDetails(*v)
				if err != nil {
					return err
				}
				rpa.CustomDetails = customDetails
			}
		}
	}

	return nil
}

// BasicRecoveryPlanActionDetails recovery plan action custom details.
type BasicRecoveryPlanActionDetails interface {
	AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool)
	AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool)
	AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool)
	AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool)
}

// RecoveryPlanActionDetails recovery plan action custom details.
type RecoveryPlanActionDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeScriptActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanActionDetails(body []byte) (BasicRecoveryPlanActionDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeScriptActionDetails):
		var rpsad RecoveryPlanScriptActionDetails
		err := json.Unmarshal(body, &rpsad)
		return rpsad, err
	case string(InstanceTypeAutomationRunbookActionDetails):
		var rparad RecoveryPlanAutomationRunbookActionDetails
		err := json.Unmarshal(body, &rparad)
		return rparad, err
	case string(InstanceTypeManualActionDetails):
		var rpmad RecoveryPlanManualActionDetails
		err := json.Unmarshal(body, &rpmad)
		return rpmad, err
	default:
		var rpad RecoveryPlanActionDetails
		err := json.Unmarshal(body, &rpad)
		return rpad, err
	}
}
func unmarshalBasicRecoveryPlanActionDetailsArray(body []byte) ([]BasicRecoveryPlanActionDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpadArray := make([]BasicRecoveryPlanActionDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpad, err := unmarshalBasicRecoveryPlanActionDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpadArray[index] = rpad
	}
	return rpadArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) MarshalJSON() ([]byte, error) {
	rpad.InstanceType = InstanceTypeRecoveryPlanActionDetails
	objectMap := make(map[string]interface{})
	if rpad.InstanceType != "" {
		objectMap["instanceType"] = rpad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return &rpad, true
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanActionDetails.
func (rpad RecoveryPlanActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpad, true
}

// RecoveryPlanAutomationRunbookActionDetails recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	// RunbookID - The runbook ARM Id.
	RunbookID *string `json:"runbookId,omitempty"`
	// Timeout - The runbook timeout.
	Timeout *string `json:"timeout,omitempty"`
	// FabricLocation - The fabric location. Possible values include: 'Primary', 'Recovery'
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeScriptActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) MarshalJSON() ([]byte, error) {
	rparad.InstanceType = InstanceTypeAutomationRunbookActionDetails
	objectMap := make(map[string]interface{})
	if rparad.RunbookID != nil {
		objectMap["runbookId"] = rparad.RunbookID
	}
	if rparad.Timeout != nil {
		objectMap["timeout"] = rparad.Timeout
	}
	if rparad.FabricLocation != "" {
		objectMap["fabricLocation"] = rparad.FabricLocation
	}
	if rparad.InstanceType != "" {
		objectMap["instanceType"] = rparad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return &rparad, true
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rparad, true
}

// RecoveryPlanCollection recovery plan collection details.
type RecoveryPlanCollection struct {
	autorest.Response `json:"-"`
	// Value - The list of recovery plans.
	Value *[]RecoveryPlan `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryPlanCollectionIterator provides access to a complete listing of RecoveryPlan values.
type RecoveryPlanCollectionIterator struct {
	i    int
	page RecoveryPlanCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryPlanCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryPlanCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryPlanCollectionIterator) Response() RecoveryPlanCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryPlanCollectionIterator) Value() RecoveryPlan {
	if !iter.page.NotDone() {
		return RecoveryPlan{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (RPCVar RecoveryPlanCollection) IsEmpty() bool {
	return RPCVar.Value == nil || len(*RPCVar.Value) == 0
}

// recoveryPlanCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (RPCVar RecoveryPlanCollection) recoveryPlanCollectionPreparer() (*http.Request, error) {
	if RPCVar.NextLink == nil || len(to.String(RPCVar.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(RPCVar.NextLink)))
}

// RecoveryPlanCollectionPage contains a page of RecoveryPlan values.
type RecoveryPlanCollectionPage struct {
	fn     func(RecoveryPlanCollection) (RecoveryPlanCollection, error)
	RPCVar RecoveryPlanCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryPlanCollectionPage) Next() error {
	next, err := page.fn(page.RPCVar)
	if err != nil {
		return err
	}
	page.RPCVar = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryPlanCollectionPage) NotDone() bool {
	return !page.RPCVar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryPlanCollectionPage) Response() RecoveryPlanCollection {
	return page.RPCVar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryPlanCollectionPage) Values() []RecoveryPlan {
	if page.RPCVar.IsEmpty() {
		return nil
	}
	return *page.RPCVar.Value
}

// RecoveryPlanGroup recovery plan group details.
type RecoveryPlanGroup struct {
	// GroupType - The group type. Possible values include: 'Shutdown', 'Boot', 'Failover'
	GroupType RecoveryPlanGroupType `json:"groupType,omitempty"`
	// ReplicationProtectedItems - The list of protected items.
	ReplicationProtectedItems *[]RecoveryPlanProtectedItem `json:"replicationProtectedItems,omitempty"`
	// StartGroupActions - The start group actions.
	StartGroupActions *[]RecoveryPlanAction `json:"startGroupActions,omitempty"`
	// EndGroupActions - The end group actions.
	EndGroupActions *[]RecoveryPlanAction `json:"endGroupActions,omitempty"`
}

// RecoveryPlanGroupTaskDetails this class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// GroupID - The group identifier.
	GroupID *string `json:"groupId,omitempty"`
	// RpGroupType - The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpgtd.InstanceType = InstanceTypeRecoveryPlanGroupTaskDetails
	objectMap := make(map[string]interface{})
	if rpgtd.Name != nil {
		objectMap["name"] = rpgtd.Name
	}
	if rpgtd.GroupID != nil {
		objectMap["groupId"] = rpgtd.GroupID
	}
	if rpgtd.RpGroupType != nil {
		objectMap["rpGroupType"] = rpgtd.RpGroupType
	}
	if rpgtd.ChildTasks != nil {
		objectMap["childTasks"] = rpgtd.ChildTasks
	}
	if rpgtd.InstanceType != "" {
		objectMap["instanceType"] = rpgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return &rpgtd, true
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &rpgtd, true
}

// RecoveryPlanHyperVReplicaAzureFailbackInput recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	// DataSyncOption - The data sync option. Possible values include: 'ForDownTime', 'ForSynchronization'
	DataSyncOption DataSyncStatus `json:"dataSyncOption,omitempty"`
	// RecoveryVMCreationOption - The ALR option. Possible values include: 'CreateVMIfNotFound', 'NoAction'
	RecoveryVMCreationOption AlternateLocationRecoveryOption `json:"recoveryVmCreationOption,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	objectMap := make(map[string]interface{})
	if rphvrafi.DataSyncOption != "" {
		objectMap["dataSyncOption"] = rphvrafi.DataSyncOption
	}
	if rphvrafi.RecoveryVMCreationOption != "" {
		objectMap["recoveryVmCreationOption"] = rphvrafi.RecoveryVMCreationOption
	}
	if rphvrafi.InstanceType != "" {
		objectMap["instanceType"] = rphvrafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rphvrafi, true
}

// RecoveryPlanHyperVReplicaAzureFailoverInput recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	// VaultLocation - The vault location.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// PrimaryKekCertificatePfx - The primary KEK certificate PFX.
	PrimaryKekCertificatePfx *string `json:"primaryKekCertificatePfx,omitempty"`
	// SecondaryKekCertificatePfx - The secondary KEK certificate PFX.
	SecondaryKekCertificatePfx *string `json:"secondaryKekCertificatePfx,omitempty"`
	// RecoveryPointType - The recovery point type. Possible values include: 'HyperVReplicaAzureRpRecoveryPointTypeLatest', 'HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent', 'HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed'
	RecoveryPointType HyperVReplicaAzureRpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	objectMap := make(map[string]interface{})
	if rphvrafi.VaultLocation != nil {
		objectMap["vaultLocation"] = rphvrafi.VaultLocation
	}
	if rphvrafi.PrimaryKekCertificatePfx != nil {
		objectMap["primaryKekCertificatePfx"] = rphvrafi.PrimaryKekCertificatePfx
	}
	if rphvrafi.SecondaryKekCertificatePfx != nil {
		objectMap["secondaryKekCertificatePfx"] = rphvrafi.SecondaryKekCertificatePfx
	}
	if rphvrafi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rphvrafi.RecoveryPointType
	}
	if rphvrafi.InstanceType != "" {
		objectMap["instanceType"] = rphvrafi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rphvrafi, true
}

// RecoveryPlanInMageAzureV2FailoverInput recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	// VaultLocation - The vault location.
	VaultLocation *string `json:"vaultLocation,omitempty"`
	// RecoveryPointType - The recovery point type. Possible values include: 'InMageV2RpRecoveryPointTypeLatest', 'InMageV2RpRecoveryPointTypeLatestApplicationConsistent', 'InMageV2RpRecoveryPointTypeLatestCrashConsistent', 'InMageV2RpRecoveryPointTypeLatestProcessed'
	RecoveryPointType InMageV2RpRecoveryPointType `json:"recoveryPointType,omitempty"`
	// UseMultiVMSyncPoint - A value indicating whether multi VM sync enabled VMs should use multi VM sync points for failover.
	UseMultiVMSyncPoint *string `json:"useMultiVmSyncPoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) MarshalJSON() ([]byte, error) {
	rpimavfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	objectMap := make(map[string]interface{})
	if rpimavfi.VaultLocation != nil {
		objectMap["vaultLocation"] = rpimavfi.VaultLocation
	}
	if rpimavfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpimavfi.RecoveryPointType
	}
	if rpimavfi.UseMultiVMSyncPoint != nil {
		objectMap["useMultiVmSyncPoint"] = rpimavfi.UseMultiVMSyncPoint
	}
	if rpimavfi.InstanceType != "" {
		objectMap["instanceType"] = rpimavfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return &rpimavfi, true
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpimavfi, true
}

// RecoveryPlanInMageFailoverInput recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	// RecoveryPointType - The recovery point type. Possible values include: 'RpInMageRecoveryPointTypeLatestTime', 'RpInMageRecoveryPointTypeLatestTag', 'RpInMageRecoveryPointTypeCustom'
	RecoveryPointType RpInMageRecoveryPointType `json:"recoveryPointType,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) MarshalJSON() ([]byte, error) {
	rpimfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage
	objectMap := make(map[string]interface{})
	if rpimfi.RecoveryPointType != "" {
		objectMap["recoveryPointType"] = rpimfi.RecoveryPointType
	}
	if rpimfi.InstanceType != "" {
		objectMap["instanceType"] = rpimfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return &rpimfi, true
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return nil, false
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rpimfi, true
}

// RecoveryPlanManualActionDetails recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	// Description - The manual action description.
	Description *string `json:"description,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeScriptActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) MarshalJSON() ([]byte, error) {
	rpmad.InstanceType = InstanceTypeManualActionDetails
	objectMap := make(map[string]interface{})
	if rpmad.Description != nil {
		objectMap["description"] = rpmad.Description
	}
	if rpmad.InstanceType != "" {
		objectMap["instanceType"] = rpmad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return &rpmad, true
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpmad, true
}

// RecoveryPlanPlannedFailoverInput recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	// Properties - The recovery plan planned failover input properties.
	Properties *RecoveryPlanPlannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanPlannedFailoverInputProperties recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanPlannedFailoverInputProperties struct.
func (rppfip *RecoveryPlanPlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rppfip.FailoverDirection = failoverDirection
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rppfip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPlanProperties recovery plan custom details.
type RecoveryPlanProperties struct {
	// FriendlyName - The friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// PrimaryFabricID - The primary fabric Id.
	PrimaryFabricID *string `json:"primaryFabricId,omitempty"`
	// PrimaryFabricFriendlyName - The primary fabric friendly name.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryFabricID - The recovery fabric Id.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// RecoveryFabricFriendlyName - The recovery fabric friendly name.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// FailoverDeploymentModel - The failover deployment model.
	FailoverDeploymentModel *string `json:"failoverDeploymentModel,omitempty"`
	// ReplicationProviders - The list of replication providers.
	ReplicationProviders *[]string `json:"replicationProviders,omitempty"`
	// AllowedOperations - The list of allowed operations.
	AllowedOperations *[]string `json:"allowedOperations,omitempty"`
	// LastPlannedFailoverTime - The start time of the last planned failover.
	LastPlannedFailoverTime *date.Time `json:"lastPlannedFailoverTime,omitempty"`
	// LastUnplannedFailoverTime - The start time of the last unplanned failover.
	LastUnplannedFailoverTime *date.Time `json:"lastUnplannedFailoverTime,omitempty"`
	// LastTestFailoverTime - The start time of the last test failover.
	LastTestFailoverTime *date.Time `json:"lastTestFailoverTime,omitempty"`
	// CurrentScenario - The current scenario details.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	// CurrentScenarioStatus - The recovery plan status.
	CurrentScenarioStatus *string `json:"currentScenarioStatus,omitempty"`
	// CurrentScenarioStatusDescription - The recovery plan status description.
	CurrentScenarioStatusDescription *string `json:"currentScenarioStatusDescription,omitempty"`
	// Groups - The recovery plan groups.
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
}

// RecoveryPlanProtectedItem recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	// ID - The ARM Id of the recovery plan protected item.
	ID *string `json:"id,omitempty"`
	// VirtualMachineID - The virtual machine Id.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// BasicRecoveryPlanProviderSpecificFailoverInput recovery plan provider specific failover input base class.
type BasicRecoveryPlanProviderSpecificFailoverInput interface {
	AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool)
	AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool)
	AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool)
	AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool)
	AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool)
	AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool)
}

// RecoveryPlanProviderSpecificFailoverInput recovery plan provider specific failover input base class.
type RecoveryPlanProviderSpecificFailoverInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage', 'InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
}

func unmarshalBasicRecoveryPlanProviderSpecificFailoverInput(body []byte) (BasicRecoveryPlanProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var rpimavfi RecoveryPlanInMageAzureV2FailoverInput
		err := json.Unmarshal(body, &rpimavfi)
		return rpimavfi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage):
		var rpimfi RecoveryPlanInMageFailoverInput
		err := json.Unmarshal(body, &rpimfi)
		return rpimfi, err
	case string(InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A):
		var rpafi RecoveryPlanA2AFailoverInput
		err := json.Unmarshal(body, &rpafi)
		return rpafi, err
	default:
		var rppsfi RecoveryPlanProviderSpecificFailoverInput
		err := json.Unmarshal(body, &rppsfi)
		return rppsfi, err
	}
}
func unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(body []byte) ([]BasicRecoveryPlanProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppsfiArray := make([]BasicRecoveryPlanProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppsfi, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppsfiArray[index] = rppsfi
	}
	return rppsfiArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) MarshalJSON() ([]byte, error) {
	rppsfi.InstanceType = InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput
	objectMap := make(map[string]interface{})
	if rppsfi.InstanceType != "" {
		objectMap["instanceType"] = rppsfi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsRecoveryPlanProviderSpecificFailoverInput() (*RecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rppsfi, true
}

// AsBasicRecoveryPlanProviderSpecificFailoverInput is the BasicRecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanProviderSpecificFailoverInput.
func (rppsfi RecoveryPlanProviderSpecificFailoverInput) AsBasicRecoveryPlanProviderSpecificFailoverInput() (BasicRecoveryPlanProviderSpecificFailoverInput, bool) {
	return &rppsfi, true
}

// RecoveryPlanScriptActionDetails recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	// Path - The script path.
	Path *string `json:"path,omitempty"`
	// Timeout - The script timeout.
	Timeout *string `json:"timeout,omitempty"`
	// FabricLocation - The fabric location. Possible values include: 'Primary', 'Recovery'
	FabricLocation RecoveryPlanActionLocation `json:"fabricLocation,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeRecoveryPlanActionDetails', 'InstanceTypeScriptActionDetails', 'InstanceTypeAutomationRunbookActionDetails', 'InstanceTypeManualActionDetails'
	InstanceType InstanceTypeBasicRecoveryPlanActionDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) MarshalJSON() ([]byte, error) {
	rpsad.InstanceType = InstanceTypeScriptActionDetails
	objectMap := make(map[string]interface{})
	if rpsad.Path != nil {
		objectMap["path"] = rpsad.Path
	}
	if rpsad.Timeout != nil {
		objectMap["timeout"] = rpsad.Timeout
	}
	if rpsad.FabricLocation != "" {
		objectMap["fabricLocation"] = rpsad.FabricLocation
	}
	if rpsad.InstanceType != "" {
		objectMap["instanceType"] = rpsad.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsRecoveryPlanScriptActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return &rpsad, true
}

// AsRecoveryPlanAutomationRunbookActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanActionDetails() (*RecoveryPlanActionDetails, bool) {
	return nil, false
}

// AsBasicRecoveryPlanActionDetails is the BasicRecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsBasicRecoveryPlanActionDetails() (BasicRecoveryPlanActionDetails, bool) {
	return &rpsad, true
}

// RecoveryPlanShutdownGroupTaskDetails this class represents the recovery plan shutdown group task details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// GroupID - The group identifier.
	GroupID *string `json:"groupId,omitempty"`
	// RpGroupType - The group type.
	RpGroupType *string `json:"rpGroupType,omitempty"`
	// ChildTasks - The child tasks.
	ChildTasks *[]ASRTask `json:"childTasks,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeGroupTaskDetails', 'InstanceTypeInlineWorkflowTaskDetails', 'InstanceTypeRecoveryPlanGroupTaskDetails', 'InstanceTypeRecoveryPlanShutdownGroupTaskDetails'
	InstanceType InstanceTypeBasicGroupTaskDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpsgtd.InstanceType = InstanceTypeRecoveryPlanShutdownGroupTaskDetails
	objectMap := make(map[string]interface{})
	if rpsgtd.Name != nil {
		objectMap["name"] = rpsgtd.Name
	}
	if rpsgtd.GroupID != nil {
		objectMap["groupId"] = rpsgtd.GroupID
	}
	if rpsgtd.RpGroupType != nil {
		objectMap["rpGroupType"] = rpsgtd.RpGroupType
	}
	if rpsgtd.ChildTasks != nil {
		objectMap["childTasks"] = rpsgtd.ChildTasks
	}
	if rpsgtd.InstanceType != "" {
		objectMap["instanceType"] = rpsgtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsInlineWorkflowTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return &rpsgtd, true
}

// AsGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsGroupTaskDetails() (*GroupTaskDetails, bool) {
	return nil, false
}

// AsBasicGroupTaskDetails is the BasicGroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsBasicGroupTaskDetails() (BasicGroupTaskDetails, bool) {
	return &rpsgtd, true
}

// RecoveryPlanTestFailoverCleanupInput recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	// Properties - The recovery plan test failover cleanup input properties.
	Properties *RecoveryPlanTestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInputProperties recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	// Comments - The test failover cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// RecoveryPlanTestFailoverInput recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	// Properties - The recovery plan test failover input properties.
	Properties *RecoveryPlanTestFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverInputProperties recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// NetworkType - The network type to be used for test failover.
	NetworkType *string `json:"networkType,omitempty"`
	// NetworkID - The Id of the network to be used for test failover.
	NetworkID *string `json:"networkId,omitempty"`
	// SkipTestFailoverCleanup - A value indicating whether the test failover cleanup is to be skipped.
	SkipTestFailoverCleanup *string `json:"skipTestFailoverCleanup,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanTestFailoverInputProperties struct.
func (rptfip *RecoveryPlanTestFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rptfip.FailoverDirection = failoverDirection
			}
		case "networkType":
			if v != nil {
				var networkType string
				err = json.Unmarshal(*v, &networkType)
				if err != nil {
					return err
				}
				rptfip.NetworkType = &networkType
			}
		case "networkId":
			if v != nil {
				var networkID string
				err = json.Unmarshal(*v, &networkID)
				if err != nil {
					return err
				}
				rptfip.NetworkID = &networkID
			}
		case "skipTestFailoverCleanup":
			if v != nil {
				var skipTestFailoverCleanup string
				err = json.Unmarshal(*v, &skipTestFailoverCleanup)
				if err != nil {
					return err
				}
				rptfip.SkipTestFailoverCleanup = &skipTestFailoverCleanup
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rptfip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPlanUnplannedFailoverInput recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	// Properties - The recovery plan unplanned failover input properties.
	Properties *RecoveryPlanUnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanUnplannedFailoverInputProperties recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	// FailoverDirection - The failover direction. Possible values include: 'PrimaryToRecovery', 'RecoveryToPrimary'
	FailoverDirection PossibleOperationsDirections `json:"failoverDirection,omitempty"`
	// SourceSiteOperations - A value indicating whether source site operations are required. Possible values include: 'Required', 'NotRequired'
	SourceSiteOperations SourceSiteOperations `json:"sourceSiteOperations,omitempty"`
	// ProviderSpecificDetails - The provider specific properties.
	ProviderSpecificDetails *[]BasicRecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanUnplannedFailoverInputProperties struct.
func (rpufip *RecoveryPlanUnplannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection PossibleOperationsDirections
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rpufip.FailoverDirection = failoverDirection
			}
		case "sourceSiteOperations":
			if v != nil {
				var sourceSiteOperations SourceSiteOperations
				err = json.Unmarshal(*v, &sourceSiteOperations)
				if err != nil {
					return err
				}
				rpufip.SourceSiteOperations = sourceSiteOperations
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicRecoveryPlanProviderSpecificFailoverInputArray(*v)
				if err != nil {
					return err
				}
				rpufip.ProviderSpecificDetails = &providerSpecificDetails
			}
		}
	}

	return nil
}

// RecoveryPoint base class representing a recovery point.
type RecoveryPoint struct {
	autorest.Response `json:"-"`
	// Properties - Recovery point related data.
	Properties *RecoveryPointProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// RecoveryPointCollection collection of recovery point details.
type RecoveryPointCollection struct {
	autorest.Response `json:"-"`
	// Value - The recovery point details.
	Value *[]RecoveryPoint `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryPointCollectionIterator provides access to a complete listing of RecoveryPoint values.
type RecoveryPointCollectionIterator struct {
	i    int
	page RecoveryPointCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryPointCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryPointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryPointCollectionIterator) Response() RecoveryPointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryPointCollectionIterator) Value() RecoveryPoint {
	if !iter.page.NotDone() {
		return RecoveryPoint{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (RPCVar RecoveryPointCollection) IsEmpty() bool {
	return RPCVar.Value == nil || len(*RPCVar.Value) == 0
}

// recoveryPointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (RPCVar RecoveryPointCollection) recoveryPointCollectionPreparer() (*http.Request, error) {
	if RPCVar.NextLink == nil || len(to.String(RPCVar.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(RPCVar.NextLink)))
}

// RecoveryPointCollectionPage contains a page of RecoveryPoint values.
type RecoveryPointCollectionPage struct {
	fn     func(RecoveryPointCollection) (RecoveryPointCollection, error)
	RPCVar RecoveryPointCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryPointCollectionPage) Next() error {
	next, err := page.fn(page.RPCVar)
	if err != nil {
		return err
	}
	page.RPCVar = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryPointCollectionPage) NotDone() bool {
	return !page.RPCVar.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryPointCollectionPage) Response() RecoveryPointCollection {
	return page.RPCVar
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryPointCollectionPage) Values() []RecoveryPoint {
	if page.RPCVar.IsEmpty() {
		return nil
	}
	return *page.RPCVar.Value
}

// RecoveryPointProperties recovery point properties.
type RecoveryPointProperties struct {
	// RecoveryPointTime - The recovery point time.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointType - The recovery point type: ApplicationConsistent, CrashConsistent.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// ProviderSpecificDetails - The provider specific details for the recovery point.
	ProviderSpecificDetails *ProviderSpecificRecoveryPointDetails `json:"providerSpecificDetails,omitempty"`
}

// RecoveryServicesProvider provider details.
type RecoveryServicesProvider struct {
	autorest.Response `json:"-"`
	// Properties - Provider properties.
	Properties *RecoveryServicesProviderProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// RecoveryServicesProviderCollection collection of providers.
type RecoveryServicesProviderCollection struct {
	autorest.Response `json:"-"`
	// Value - The Servers details.
	Value *[]RecoveryServicesProvider `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// RecoveryServicesProviderCollectionIterator provides access to a complete listing of RecoveryServicesProvider
// values.
type RecoveryServicesProviderCollectionIterator struct {
	i    int
	page RecoveryServicesProviderCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecoveryServicesProviderCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecoveryServicesProviderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecoveryServicesProviderCollectionIterator) Response() RecoveryServicesProviderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecoveryServicesProviderCollectionIterator) Value() RecoveryServicesProvider {
	if !iter.page.NotDone() {
		return RecoveryServicesProvider{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rspc RecoveryServicesProviderCollection) IsEmpty() bool {
	return rspc.Value == nil || len(*rspc.Value) == 0
}

// recoveryServicesProviderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rspc RecoveryServicesProviderCollection) recoveryServicesProviderCollectionPreparer() (*http.Request, error) {
	if rspc.NextLink == nil || len(to.String(rspc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rspc.NextLink)))
}

// RecoveryServicesProviderCollectionPage contains a page of RecoveryServicesProvider values.
type RecoveryServicesProviderCollectionPage struct {
	fn   func(RecoveryServicesProviderCollection) (RecoveryServicesProviderCollection, error)
	rspc RecoveryServicesProviderCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecoveryServicesProviderCollectionPage) Next() error {
	next, err := page.fn(page.rspc)
	if err != nil {
		return err
	}
	page.rspc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecoveryServicesProviderCollectionPage) NotDone() bool {
	return !page.rspc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecoveryServicesProviderCollectionPage) Response() RecoveryServicesProviderCollection {
	return page.rspc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecoveryServicesProviderCollectionPage) Values() []RecoveryServicesProvider {
	if page.rspc.IsEmpty() {
		return nil
	}
	return *page.rspc.Value
}

// RecoveryServicesProviderProperties recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	// FabricType - Type of the site.
	FabricType *string `json:"fabricType,omitempty"`
	// FriendlyName - Friendly name of the DRA.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProviderVersion - The provider version.
	ProviderVersion *string `json:"providerVersion,omitempty"`
	// ServerVersion - The fabric provider.
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ProviderVersionState - DRA version status.
	ProviderVersionState *string `json:"providerVersionState,omitempty"`
	// ProviderVersionExpiryDate - Expiry date if the version is deprecated.
	ProviderVersionExpiryDate *date.Time `json:"providerVersionExpiryDate,omitempty"`
	// FabricFriendlyName - The fabric friendly name.
	FabricFriendlyName *string `json:"fabricFriendlyName,omitempty"`
	// LastHeartBeat - Time when last heartbeat was sent by the DRA.
	LastHeartBeat *date.Time `json:"lastHeartBeat,omitempty"`
	// ConnectionStatus - A value indicating whether DRA is responsive.
	ConnectionStatus *string `json:"connectionStatus,omitempty"`
	// ProtectedItemCount - Number of protected VMs currently managed by the DRA.
	ProtectedItemCount *int32 `json:"protectedItemCount,omitempty"`
	// AllowedScenarios - The scenarios allowed on this provider.
	AllowedScenarios *[]string `json:"allowedScenarios,omitempty"`
	// HealthErrorDetails - The recovery services provider health error details.
	HealthErrorDetails *[]HealthError `json:"healthErrorDetails,omitempty"`
	// DraIdentifier - The DRA Id.
	DraIdentifier *string `json:"draIdentifier,omitempty"`
	// IdentityDetails - The identity details.
	IdentityDetails *IdentityInformation `json:"identityDetails,omitempty"`
}

// RemoveProtectionContainerMappingInput container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	// Properties - Configure protection input properties.
	Properties *RemoveProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// RemoveProtectionContainerMappingInputProperties unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	// ProviderSpecificInput - Provider specific input for unpairing.
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput `json:"providerSpecificInput,omitempty"`
}

// RenewCertificateInput certificate renewal input.
type RenewCertificateInput struct {
	// Properties - Renew certificate input properties.
	Properties *RenewCertificateInputProperties `json:"properties,omitempty"`
}

// RenewCertificateInputProperties renew Certificate input properties.
type RenewCertificateInputProperties struct {
	// RenewCertificateType - Renew certificate type.
	RenewCertificateType *string `json:"renewCertificateType,omitempty"`
}

// ReplicationFabricsCheckConsistencyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsCheckConsistencyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsCheckConsistencyFuture) Result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCheckConsistencyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsCheckConsistencyFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CheckConsistencyResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCheckConsistencyFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationFabricsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsCreateFuture) Result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.CreateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsCreateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationFabricsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsDeleteFuture) Result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsMigrateToAadFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationFabricsMigrateToAadFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsMigrateToAadFuture) Result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsMigrateToAadFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsMigrateToAadFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsPurgeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationFabricsPurgeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsPurgeFuture) Result(client ReplicationFabricsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationFabricsReassociateGatewayFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsReassociateGatewayFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsReassociateGatewayFuture) Result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsReassociateGatewayFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsReassociateGatewayFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.ReassociateGatewayResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsReassociateGatewayFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationFabricsRenewCertificateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationFabricsRenewCertificateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationFabricsRenewCertificateFuture) Result(client ReplicationFabricsClient) (f Fabric, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsRenewCertificateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationFabricsRenewCertificateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if f.Response.Response, err = future.GetResult(sender); err == nil && f.Response.Response.StatusCode != http.StatusNoContent {
		f, err = client.RenewCertificateResponder(f.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationFabricsRenewCertificateFuture", "Result", f.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationGroupDetails replication group details. This will be used in case of San and Wvr.
type ReplicationGroupDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeVMwareVirtualMachine', 'InstanceTypeReplicationGroupDetails'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) MarshalJSON() ([]byte, error) {
	rgd.InstanceType = InstanceTypeReplicationGroupDetails
	objectMap := make(map[string]interface{})
	if rgd.InstanceType != "" {
		objectMap["instanceType"] = rgd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return &rgd, true
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return nil, false
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &rgd, true
}

// ReplicationJobsCancelFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsCancelFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationJobsCancelFuture) Result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsCancelFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.CancelResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsCancelFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsExportFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationJobsExportFuture) Result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.ExportResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsExportFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsRestartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsRestartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationJobsRestartFuture) Result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsRestartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsRestartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.RestartResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsRestartFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationJobsResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationJobsResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationJobsResumeFuture) Result(client ReplicationJobsClient) (j Job, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationJobsResumeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if j.Response.Response, err = future.GetResult(sender); err == nil && j.Response.Response.StatusCode != http.StatusNoContent {
		j, err = client.ResumeResponder(j.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationJobsResumeFuture", "Result", j.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationNetworkMappingsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationNetworkMappingsCreateFuture) Result(client ReplicationNetworkMappingsClient) (nm NetworkMapping, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nm.Response.Response, err = future.GetResult(sender); err == nil && nm.Response.Response.StatusCode != http.StatusNoContent {
		nm, err = client.CreateResponder(nm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsCreateFuture", "Result", nm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationNetworkMappingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationNetworkMappingsDeleteFuture) Result(client ReplicationNetworkMappingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationNetworkMappingsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationNetworkMappingsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationNetworkMappingsUpdateFuture) Result(client ReplicationNetworkMappingsClient) (nm NetworkMapping, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationNetworkMappingsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nm.Response.Response, err = future.GetResult(sender); err == nil && nm.Response.Response.StatusCode != http.StatusNoContent {
		nm, err = client.UpdateResponder(nm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationNetworkMappingsUpdateFuture", "Result", nm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationPoliciesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationPoliciesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationPoliciesCreateFuture) Result(client ReplicationPoliciesClient) (p Policy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationPoliciesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationPoliciesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationPoliciesDeleteFuture) Result(client ReplicationPoliciesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationPoliciesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationPoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationPoliciesUpdateFuture) Result(client ReplicationPoliciesClient) (p Policy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationPoliciesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItem replication protected item.
type ReplicationProtectedItem struct {
	autorest.Response `json:"-"`
	// Properties - The custom data.
	Properties *ReplicationProtectedItemProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// ReplicationProtectedItemCollection replication protected item collection.
type ReplicationProtectedItemCollection struct {
	autorest.Response `json:"-"`
	// Value - The Replication protected item details.
	Value *[]ReplicationProtectedItem `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationProtectedItemCollectionIterator provides access to a complete listing of ReplicationProtectedItem
// values.
type ReplicationProtectedItemCollectionIterator struct {
	i    int
	page ReplicationProtectedItemCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationProtectedItemCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationProtectedItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationProtectedItemCollectionIterator) Response() ReplicationProtectedItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationProtectedItemCollectionIterator) Value() ReplicationProtectedItem {
	if !iter.page.NotDone() {
		return ReplicationProtectedItem{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rpic ReplicationProtectedItemCollection) IsEmpty() bool {
	return rpic.Value == nil || len(*rpic.Value) == 0
}

// replicationProtectedItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rpic ReplicationProtectedItemCollection) replicationProtectedItemCollectionPreparer() (*http.Request, error) {
	if rpic.NextLink == nil || len(to.String(rpic.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rpic.NextLink)))
}

// ReplicationProtectedItemCollectionPage contains a page of ReplicationProtectedItem values.
type ReplicationProtectedItemCollectionPage struct {
	fn   func(ReplicationProtectedItemCollection) (ReplicationProtectedItemCollection, error)
	rpic ReplicationProtectedItemCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationProtectedItemCollectionPage) Next() error {
	next, err := page.fn(page.rpic)
	if err != nil {
		return err
	}
	page.rpic = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationProtectedItemCollectionPage) NotDone() bool {
	return !page.rpic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationProtectedItemCollectionPage) Response() ReplicationProtectedItemCollection {
	return page.rpic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationProtectedItemCollectionPage) Values() []ReplicationProtectedItem {
	if page.rpic.IsEmpty() {
		return nil
	}
	return *page.rpic.Value
}

// ReplicationProtectedItemProperties replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	// FriendlyName - The name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectedItemType - The type of protected item type.
	ProtectedItemType *string `json:"protectedItemType,omitempty"`
	// ProtectableItemID - The protected item ARM Id.
	ProtectableItemID *string `json:"protectableItemId,omitempty"`
	// RecoveryServicesProviderID - The recovery provider ARM Id.
	RecoveryServicesProviderID *string `json:"recoveryServicesProviderId,omitempty"`
	// PrimaryFabricFriendlyName - The friendly name of the primary fabric.
	PrimaryFabricFriendlyName *string `json:"primaryFabricFriendlyName,omitempty"`
	// RecoveryFabricFriendlyName - The friendly name of recovery fabric.
	RecoveryFabricFriendlyName *string `json:"recoveryFabricFriendlyName,omitempty"`
	// RecoveryFabricID - The Arm Id of recovery fabric.
	RecoveryFabricID *string `json:"recoveryFabricId,omitempty"`
	// PrimaryProtectionContainerFriendlyName - The name of primary protection container friendly name.
	PrimaryProtectionContainerFriendlyName *string `json:"primaryProtectionContainerFriendlyName,omitempty"`
	// RecoveryProtectionContainerFriendlyName - The name of recovery container friendly name.
	RecoveryProtectionContainerFriendlyName *string `json:"recoveryProtectionContainerFriendlyName,omitempty"`
	// ProtectionState - The protection status.
	ProtectionState *string `json:"protectionState,omitempty"`
	// ProtectionStateDescription - The protection state description.
	ProtectionStateDescription *string `json:"protectionStateDescription,omitempty"`
	// ActiveLocation - The Current active location of the PE.
	ActiveLocation *string `json:"activeLocation,omitempty"`
	// TestFailoverState - The Test failover state.
	TestFailoverState *string `json:"testFailoverState,omitempty"`
	// TestFailoverStateDescription - The Test failover state description.
	TestFailoverStateDescription *string `json:"testFailoverStateDescription,omitempty"`
	// AllowedOperations - The allowed operations on the Replication protected item.
	AllowedOperations *[]string `json:"allowedOperations,omitempty"`
	// ReplicationHealth - The consolidated protection health for the VM taking any issues with SRS as well as all the replication units associated with the VM's replication group into account. This is a string representation of the ProtectionHealth enumeration.
	ReplicationHealth *string `json:"replicationHealth,omitempty"`
	// FailoverHealth - The consolidated failover health for the VM.
	FailoverHealth *string `json:"failoverHealth,omitempty"`
	// ReplicationHealthErrors - List of replication health errors.
	ReplicationHealthErrors *[]HealthError `json:"replicationHealthErrors,omitempty"`
	// FailoverHealthErrors - List of failover health errors.
	FailoverHealthErrors *[]HealthError `json:"failoverHealthErrors,omitempty"`
	// PolicyID - The ID of Policy governing this PE.
	PolicyID *string `json:"policyId,omitempty"`
	// PolicyFriendlyName - The name of Policy governing this PE.
	PolicyFriendlyName *string `json:"policyFriendlyName,omitempty"`
	// LastSuccessfulFailoverTime - The Last successful failover time.
	LastSuccessfulFailoverTime *date.Time `json:"lastSuccessfulFailoverTime,omitempty"`
	// LastSuccessfulTestFailoverTime - The Last successful test failover time.
	LastSuccessfulTestFailoverTime *date.Time `json:"lastSuccessfulTestFailoverTime,omitempty"`
	// CurrentScenario - The current scenario.
	CurrentScenario *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	// FailoverRecoveryPointID - The recovery point ARM Id to which the Vm was failed over.
	FailoverRecoveryPointID *string `json:"failoverRecoveryPointId,omitempty"`
	// ProviderSpecificDetails - The Replication provider custom settings.
	ProviderSpecificDetails BasicReplicationProviderSpecificSettings `json:"providerSpecificDetails,omitempty"`
	// RecoveryContainerID - The recovery container Id.
	RecoveryContainerID *string `json:"recoveryContainerId,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ReplicationProtectedItemProperties struct.
func (rpip *ReplicationProtectedItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "friendlyName":
			if v != nil {
				var friendlyName string
				err = json.Unmarshal(*v, &friendlyName)
				if err != nil {
					return err
				}
				rpip.FriendlyName = &friendlyName
			}
		case "protectedItemType":
			if v != nil {
				var protectedItemType string
				err = json.Unmarshal(*v, &protectedItemType)
				if err != nil {
					return err
				}
				rpip.ProtectedItemType = &protectedItemType
			}
		case "protectableItemId":
			if v != nil {
				var protectableItemID string
				err = json.Unmarshal(*v, &protectableItemID)
				if err != nil {
					return err
				}
				rpip.ProtectableItemID = &protectableItemID
			}
		case "recoveryServicesProviderId":
			if v != nil {
				var recoveryServicesProviderID string
				err = json.Unmarshal(*v, &recoveryServicesProviderID)
				if err != nil {
					return err
				}
				rpip.RecoveryServicesProviderID = &recoveryServicesProviderID
			}
		case "primaryFabricFriendlyName":
			if v != nil {
				var primaryFabricFriendlyName string
				err = json.Unmarshal(*v, &primaryFabricFriendlyName)
				if err != nil {
					return err
				}
				rpip.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
			}
		case "recoveryFabricFriendlyName":
			if v != nil {
				var recoveryFabricFriendlyName string
				err = json.Unmarshal(*v, &recoveryFabricFriendlyName)
				if err != nil {
					return err
				}
				rpip.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
			}
		case "recoveryFabricId":
			if v != nil {
				var recoveryFabricID string
				err = json.Unmarshal(*v, &recoveryFabricID)
				if err != nil {
					return err
				}
				rpip.RecoveryFabricID = &recoveryFabricID
			}
		case "primaryProtectionContainerFriendlyName":
			if v != nil {
				var primaryProtectionContainerFriendlyName string
				err = json.Unmarshal(*v, &primaryProtectionContainerFriendlyName)
				if err != nil {
					return err
				}
				rpip.PrimaryProtectionContainerFriendlyName = &primaryProtectionContainerFriendlyName
			}
		case "recoveryProtectionContainerFriendlyName":
			if v != nil {
				var recoveryProtectionContainerFriendlyName string
				err = json.Unmarshal(*v, &recoveryProtectionContainerFriendlyName)
				if err != nil {
					return err
				}
				rpip.RecoveryProtectionContainerFriendlyName = &recoveryProtectionContainerFriendlyName
			}
		case "protectionState":
			if v != nil {
				var protectionState string
				err = json.Unmarshal(*v, &protectionState)
				if err != nil {
					return err
				}
				rpip.ProtectionState = &protectionState
			}
		case "protectionStateDescription":
			if v != nil {
				var protectionStateDescription string
				err = json.Unmarshal(*v, &protectionStateDescription)
				if err != nil {
					return err
				}
				rpip.ProtectionStateDescription = &protectionStateDescription
			}
		case "activeLocation":
			if v != nil {
				var activeLocation string
				err = json.Unmarshal(*v, &activeLocation)
				if err != nil {
					return err
				}
				rpip.ActiveLocation = &activeLocation
			}
		case "testFailoverState":
			if v != nil {
				var testFailoverState string
				err = json.Unmarshal(*v, &testFailoverState)
				if err != nil {
					return err
				}
				rpip.TestFailoverState = &testFailoverState
			}
		case "testFailoverStateDescription":
			if v != nil {
				var testFailoverStateDescription string
				err = json.Unmarshal(*v, &testFailoverStateDescription)
				if err != nil {
					return err
				}
				rpip.TestFailoverStateDescription = &testFailoverStateDescription
			}
		case "allowedOperations":
			if v != nil {
				var allowedOperations []string
				err = json.Unmarshal(*v, &allowedOperations)
				if err != nil {
					return err
				}
				rpip.AllowedOperations = &allowedOperations
			}
		case "replicationHealth":
			if v != nil {
				var replicationHealth string
				err = json.Unmarshal(*v, &replicationHealth)
				if err != nil {
					return err
				}
				rpip.ReplicationHealth = &replicationHealth
			}
		case "failoverHealth":
			if v != nil {
				var failoverHealth string
				err = json.Unmarshal(*v, &failoverHealth)
				if err != nil {
					return err
				}
				rpip.FailoverHealth = &failoverHealth
			}
		case "replicationHealthErrors":
			if v != nil {
				var replicationHealthErrors []HealthError
				err = json.Unmarshal(*v, &replicationHealthErrors)
				if err != nil {
					return err
				}
				rpip.ReplicationHealthErrors = &replicationHealthErrors
			}
		case "failoverHealthErrors":
			if v != nil {
				var failoverHealthErrors []HealthError
				err = json.Unmarshal(*v, &failoverHealthErrors)
				if err != nil {
					return err
				}
				rpip.FailoverHealthErrors = &failoverHealthErrors
			}
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				rpip.PolicyID = &policyID
			}
		case "policyFriendlyName":
			if v != nil {
				var policyFriendlyName string
				err = json.Unmarshal(*v, &policyFriendlyName)
				if err != nil {
					return err
				}
				rpip.PolicyFriendlyName = &policyFriendlyName
			}
		case "lastSuccessfulFailoverTime":
			if v != nil {
				var lastSuccessfulFailoverTime date.Time
				err = json.Unmarshal(*v, &lastSuccessfulFailoverTime)
				if err != nil {
					return err
				}
				rpip.LastSuccessfulFailoverTime = &lastSuccessfulFailoverTime
			}
		case "lastSuccessfulTestFailoverTime":
			if v != nil {
				var lastSuccessfulTestFailoverTime date.Time
				err = json.Unmarshal(*v, &lastSuccessfulTestFailoverTime)
				if err != nil {
					return err
				}
				rpip.LastSuccessfulTestFailoverTime = &lastSuccessfulTestFailoverTime
			}
		case "currentScenario":
			if v != nil {
				var currentScenario CurrentScenarioDetails
				err = json.Unmarshal(*v, &currentScenario)
				if err != nil {
					return err
				}
				rpip.CurrentScenario = &currentScenario
			}
		case "failoverRecoveryPointId":
			if v != nil {
				var failoverRecoveryPointID string
				err = json.Unmarshal(*v, &failoverRecoveryPointID)
				if err != nil {
					return err
				}
				rpip.FailoverRecoveryPointID = &failoverRecoveryPointID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicReplicationProviderSpecificSettings(*v)
				if err != nil {
					return err
				}
				rpip.ProviderSpecificDetails = providerSpecificDetails
			}
		case "recoveryContainerId":
			if v != nil {
				var recoveryContainerID string
				err = json.Unmarshal(*v, &recoveryContainerID)
				if err != nil {
					return err
				}
				rpip.RecoveryContainerID = &recoveryContainerID
			}
		}
	}

	return nil
}

// ReplicationProtectedItemsApplyRecoveryPointFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsApplyRecoveryPointFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsApplyRecoveryPointFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsApplyRecoveryPointFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsApplyRecoveryPointFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.ApplyRecoveryPointResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsApplyRecoveryPointFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationProtectedItemsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsCreateFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.CreateResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsCreateFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationProtectedItemsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsDeleteFuture) Result(client ReplicationProtectedItemsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationProtectedItemsFailoverCommitFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsFailoverCommitFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsFailoverCommitFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsFailoverCommitFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsFailoverCommitFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.FailoverCommitResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsFailoverCommitFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsPlannedFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsPlannedFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsPlannedFailoverFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsPlannedFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsPlannedFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.PlannedFailoverResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsPlannedFailoverFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsPurgeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationProtectedItemsPurgeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsPurgeFuture) Result(client ReplicationProtectedItemsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationProtectedItemsRepairReplicationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsRepairReplicationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsRepairReplicationFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsRepairReplicationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsRepairReplicationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.RepairReplicationResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsRepairReplicationFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsReprotectFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsReprotectFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsReprotectFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsReprotectFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsReprotectFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.ReprotectResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsReprotectFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsTestFailoverCleanupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsTestFailoverCleanupFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsTestFailoverCleanupFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsTestFailoverCleanupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsTestFailoverCleanupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.TestFailoverCleanupResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsTestFailoverCleanupFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsTestFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsTestFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsTestFailoverFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsTestFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsTestFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.TestFailoverResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsTestFailoverFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsUnplannedFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectedItemsUnplannedFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsUnplannedFailoverFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUnplannedFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsUnplannedFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.UnplannedFailoverResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUnplannedFailoverFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationProtectedItemsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsUpdateFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.UpdateResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUpdateFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectedItemsUpdateMobilityServiceFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationProtectedItemsUpdateMobilityServiceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectedItemsUpdateMobilityServiceFuture) Result(client ReplicationProtectedItemsClient) (rpi ReplicationProtectedItem, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUpdateMobilityServiceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectedItemsUpdateMobilityServiceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rpi.Response.Response, err = future.GetResult(sender); err == nil && rpi.Response.Response.StatusCode != http.StatusNoContent {
		rpi, err = client.UpdateMobilityServiceResponder(rpi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsUpdateMobilityServiceFuture", "Result", rpi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectionContainerMappingsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectionContainerMappingsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainerMappingsCreateFuture) Result(client ReplicationProtectionContainerMappingsClient) (pcm ProtectionContainerMapping, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainerMappingsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainerMappingsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pcm.Response.Response, err = future.GetResult(sender); err == nil && pcm.Response.Response.StatusCode != http.StatusNoContent {
		pcm, err = client.CreateResponder(pcm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainerMappingsCreateFuture", "Result", pcm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectionContainerMappingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectionContainerMappingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainerMappingsDeleteFuture) Result(client ReplicationProtectionContainerMappingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainerMappingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainerMappingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationProtectionContainerMappingsPurgeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectionContainerMappingsPurgeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainerMappingsPurgeFuture) Result(client ReplicationProtectionContainerMappingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainerMappingsPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainerMappingsPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationProtectionContainersCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectionContainersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainersCreateFuture) Result(client ReplicationProtectionContainersClient) (pc ProtectionContainer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.CreateResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersCreateFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectionContainersDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationProtectionContainersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainersDeleteFuture) Result(client ReplicationProtectionContainersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationProtectionContainersDiscoverProtectableItemFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ReplicationProtectionContainersDiscoverProtectableItemFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainersDiscoverProtectableItemFuture) Result(client ReplicationProtectionContainersClient) (pc ProtectionContainer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersDiscoverProtectableItemFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainersDiscoverProtectableItemFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.DiscoverProtectableItemResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersDiscoverProtectableItemFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProtectionContainersSwitchProtectionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ReplicationProtectionContainersSwitchProtectionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationProtectionContainersSwitchProtectionFuture) Result(client ReplicationProtectionContainersClient) (pc ProtectionContainer, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersSwitchProtectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationProtectionContainersSwitchProtectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pc.Response.Response, err = future.GetResult(sender); err == nil && pc.Response.Response.StatusCode != http.StatusNoContent {
		pc, err = client.SwitchProtectionResponder(pc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectionContainersSwitchProtectionFuture", "Result", pc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationProviderContainerUnmappingInput provider specific input for unpairing operations.
type ReplicationProviderContainerUnmappingInput struct {
	// InstanceType - The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// BasicReplicationProviderSpecificContainerCreationInput provider specific input for container creation operation.
type BasicReplicationProviderSpecificContainerCreationInput interface {
	AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool)
	AsReplicationProviderSpecificContainerCreationInput() (*ReplicationProviderSpecificContainerCreationInput, bool)
}

// ReplicationProviderSpecificContainerCreationInput provider specific input for container creation operation.
type ReplicationProviderSpecificContainerCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput', 'InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificContainerCreationInput `json:"instanceType,omitempty"`
}

func unmarshalBasicReplicationProviderSpecificContainerCreationInput(body []byte) (BasicReplicationProviderSpecificContainerCreationInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A):
		var acci A2AContainerCreationInput
		err := json.Unmarshal(body, &acci)
		return acci, err
	default:
		var rpscci ReplicationProviderSpecificContainerCreationInput
		err := json.Unmarshal(body, &rpscci)
		return rpscci, err
	}
}
func unmarshalBasicReplicationProviderSpecificContainerCreationInputArray(body []byte) ([]BasicReplicationProviderSpecificContainerCreationInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpscciArray := make([]BasicReplicationProviderSpecificContainerCreationInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpscci, err := unmarshalBasicReplicationProviderSpecificContainerCreationInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpscciArray[index] = rpscci
	}
	return rpscciArray, nil
}

// MarshalJSON is the custom marshaler for ReplicationProviderSpecificContainerCreationInput.
func (rpscci ReplicationProviderSpecificContainerCreationInput) MarshalJSON() ([]byte, error) {
	rpscci.InstanceType = InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput
	objectMap := make(map[string]interface{})
	if rpscci.InstanceType != "" {
		objectMap["instanceType"] = rpscci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2AContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for ReplicationProviderSpecificContainerCreationInput.
func (rpscci ReplicationProviderSpecificContainerCreationInput) AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool) {
	return nil, false
}

// AsReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for ReplicationProviderSpecificContainerCreationInput.
func (rpscci ReplicationProviderSpecificContainerCreationInput) AsReplicationProviderSpecificContainerCreationInput() (*ReplicationProviderSpecificContainerCreationInput, bool) {
	return &rpscci, true
}

// AsBasicReplicationProviderSpecificContainerCreationInput is the BasicReplicationProviderSpecificContainerCreationInput implementation for ReplicationProviderSpecificContainerCreationInput.
func (rpscci ReplicationProviderSpecificContainerCreationInput) AsBasicReplicationProviderSpecificContainerCreationInput() (BasicReplicationProviderSpecificContainerCreationInput, bool) {
	return &rpscci, true
}

// ReplicationProviderSpecificContainerMappingInput provider specific input for pairing operations.
type ReplicationProviderSpecificContainerMappingInput struct {
	// InstanceType - The class type.
	InstanceType *string `json:"instanceType,omitempty"`
}

// BasicReplicationProviderSpecificSettings replication provider specific settings.
type BasicReplicationProviderSpecificSettings interface {
	AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool)
	AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool)
	AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool)
	AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool)
	AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool)
	AsInMageReplicationDetails() (*InMageReplicationDetails, bool)
	AsA2AReplicationDetails() (*A2AReplicationDetails, bool)
	AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool)
}

// ReplicationProviderSpecificSettings replication provider specific settings.
type ReplicationProviderSpecificSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage', 'InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A'
	InstanceType InstanceTypeBasicReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
}

func unmarshalBasicReplicationProviderSpecificSettings(body []byte) (BasicReplicationProviderSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails):
		var hvrbrd HyperVReplicaBaseReplicationDetails
		err := json.Unmarshal(body, &hvrbrd)
		return hvrbrd, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012):
		var hvrrd HyperVReplicaReplicationDetails
		err := json.Unmarshal(body, &hvrrd)
		return hvrrd, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2):
		var hvrbrd HyperVReplicaBlueReplicationDetails
		err := json.Unmarshal(body, &hvrbrd)
		return hvrbrd, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure):
		var hvrard HyperVReplicaAzureReplicationDetails
		err := json.Unmarshal(body, &hvrard)
		return hvrard, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2):
		var imavrd InMageAzureV2ReplicationDetails
		err := json.Unmarshal(body, &imavrd)
		return imavrd, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage):
		var imrd InMageReplicationDetails
		err := json.Unmarshal(body, &imrd)
		return imrd, err
	case string(InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A):
		var ard A2AReplicationDetails
		err := json.Unmarshal(body, &ard)
		return ard, err
	default:
		var rpss ReplicationProviderSpecificSettings
		err := json.Unmarshal(body, &rpss)
		return rpss, err
	}
}
func unmarshalBasicReplicationProviderSpecificSettingsArray(body []byte) ([]BasicReplicationProviderSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpssArray := make([]BasicReplicationProviderSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpss, err := unmarshalBasicReplicationProviderSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpssArray[index] = rpss
	}
	return rpssArray, nil
}

// MarshalJSON is the custom marshaler for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) MarshalJSON() ([]byte, error) {
	rpss.InstanceType = InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings
	objectMap := make(map[string]interface{})
	if rpss.InstanceType != "" {
		objectMap["instanceType"] = rpss.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaBaseReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// AsReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsReplicationProviderSpecificSettings() (*ReplicationProviderSpecificSettings, bool) {
	return &rpss, true
}

// AsBasicReplicationProviderSpecificSettings is the BasicReplicationProviderSpecificSettings implementation for ReplicationProviderSpecificSettings.
func (rpss ReplicationProviderSpecificSettings) AsBasicReplicationProviderSpecificSettings() (BasicReplicationProviderSpecificSettings, bool) {
	return &rpss, true
}

// ReplicationRecoveryPlansCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationRecoveryPlansCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansCreateFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.CreateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansCreateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationRecoveryPlansDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansDeleteFuture) Result(client ReplicationRecoveryPlansClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationRecoveryPlansFailoverCommitFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansFailoverCommitFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansFailoverCommitFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansFailoverCommitFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansFailoverCommitFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.FailoverCommitResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansFailoverCommitFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansPlannedFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansPlannedFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansPlannedFailoverFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansPlannedFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansPlannedFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.PlannedFailoverResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansPlannedFailoverFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansReprotectFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansReprotectFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansReprotectFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansReprotectFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansReprotectFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.ReprotectResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansReprotectFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansTestFailoverCleanupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansTestFailoverCleanupFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansTestFailoverCleanupFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansTestFailoverCleanupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansTestFailoverCleanupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.TestFailoverCleanupResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansTestFailoverCleanupFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansTestFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansTestFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansTestFailoverFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansTestFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansTestFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.TestFailoverResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansTestFailoverFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansUnplannedFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryPlansUnplannedFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansUnplannedFailoverFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansUnplannedFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansUnplannedFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.UnplannedFailoverResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansUnplannedFailoverFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryPlansUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationRecoveryPlansUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryPlansUpdateFuture) Result(client ReplicationRecoveryPlansClient) (rp RecoveryPlan, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryPlansUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.UpdateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryPlansUpdateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationRecoveryServicesProvidersDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryServicesProvidersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryServicesProvidersDeleteFuture) Result(client ReplicationRecoveryServicesProvidersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryServicesProvidersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryServicesProvidersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationRecoveryServicesProvidersPurgeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationRecoveryServicesProvidersPurgeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryServicesProvidersPurgeFuture) Result(client ReplicationRecoveryServicesProvidersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryServicesProvidersPurgeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryServicesProvidersPurgeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationRecoveryServicesProvidersRefreshProviderFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ReplicationRecoveryServicesProvidersRefreshProviderFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationRecoveryServicesProvidersRefreshProviderFuture) Result(client ReplicationRecoveryServicesProvidersClient) (rsp RecoveryServicesProvider, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryServicesProvidersRefreshProviderFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationRecoveryServicesProvidersRefreshProviderFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rsp.Response.Response, err = future.GetResult(sender); err == nil && rsp.Response.Response.StatusCode != http.StatusNoContent {
		rsp, err = client.RefreshProviderResponder(rsp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationRecoveryServicesProvidersRefreshProviderFuture", "Result", rsp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationStorageClassificationMappingsCreateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationStorageClassificationMappingsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationStorageClassificationMappingsCreateFuture) Result(client ReplicationStorageClassificationMappingsClient) (scm StorageClassificationMapping, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationStorageClassificationMappingsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationStorageClassificationMappingsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scm.Response.Response, err = future.GetResult(sender); err == nil && scm.Response.Response.StatusCode != http.StatusNoContent {
		scm, err = client.CreateResponder(scm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationStorageClassificationMappingsCreateFuture", "Result", scm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationStorageClassificationMappingsDeleteFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationStorageClassificationMappingsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationStorageClassificationMappingsDeleteFuture) Result(client ReplicationStorageClassificationMappingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationStorageClassificationMappingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationStorageClassificationMappingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationvCentersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationvCentersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationvCentersCreateFuture) Result(client ReplicationvCentersClient) (vc VCenter, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationvCentersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationvCentersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vc.Response.Response, err = future.GetResult(sender); err == nil && vc.Response.Response.StatusCode != http.StatusNoContent {
		vc, err = client.CreateResponder(vc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationvCentersCreateFuture", "Result", vc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationvCentersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationvCentersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationvCentersDeleteFuture) Result(client ReplicationvCentersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationvCentersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationvCentersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationvCentersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationvCentersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationvCentersUpdateFuture) Result(client ReplicationvCentersClient) (vc VCenter, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationvCentersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("siterecovery.ReplicationvCentersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vc.Response.Response, err = future.GetResult(sender); err == nil && vc.Response.Response.StatusCode != http.StatusNoContent {
		vc, err = client.UpdateResponder(vc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "siterecovery.ReplicationvCentersUpdateFuture", "Result", vc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Resource azure resource.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// ResourceHealthSummary base class to define the health summary of the resources contained under an Arm resource.
type ResourceHealthSummary struct {
	// ResourceCount - The count of total resources umder the container.
	ResourceCount *int32 `json:"resourceCount,omitempty"`
	// Issues - The list of summary of health errors across the resources under the container.
	Issues *[]HealthErrorSummary `json:"issues,omitempty"`
}

// ResumeJobParams resume job params.
type ResumeJobParams struct {
	// Properties - Resume job properties.
	Properties *ResumeJobParamsProperties `json:"properties,omitempty"`
}

// ResumeJobParamsProperties resume job properties.
type ResumeJobParamsProperties struct {
	// Comments - Resume job comments.
	Comments *string `json:"comments,omitempty"`
}

// RetentionVolume the retention details of the MT.
type RetentionVolume struct {
	// VolumeName - The volume name.
	VolumeName *string `json:"volumeName,omitempty"`
	// CapacityInBytes - The volume capacity.
	CapacityInBytes *int64 `json:"capacityInBytes,omitempty"`
	// FreeSpaceInBytes - The free space available in this volume.
	FreeSpaceInBytes *int64 `json:"freeSpaceInBytes,omitempty"`
	// ThresholdPercentage - The threshold percentage.
	ThresholdPercentage *int32 `json:"thresholdPercentage,omitempty"`
}

// ReverseReplicationInput reverse replication input.
type ReverseReplicationInput struct {
	// Properties - Reverse replication properties
	Properties *ReverseReplicationInputProperties `json:"properties,omitempty"`
}

// ReverseReplicationInputProperties reverse replication input properties.
type ReverseReplicationInputProperties struct {
	// FailoverDirection - Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`
	// ProviderSpecificDetails - Provider specific reverse replication input.
	ProviderSpecificDetails BasicReverseReplicationProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ReverseReplicationInputProperties struct.
func (rrip *ReverseReplicationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection string
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				rrip.FailoverDirection = &failoverDirection
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicReverseReplicationProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				rrip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicReverseReplicationProviderSpecificInput provider specific reverse replication input.
type BasicReverseReplicationProviderSpecificInput interface {
	AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool)
	AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool)
	AsInMageReprotectInput() (*InMageReprotectInput, bool)
	AsA2AReprotectInput() (*A2AReprotectInput, bool)
	AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool)
}

// ReverseReplicationProviderSpecificInput provider specific reverse replication input.
type ReverseReplicationProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicReverseReplicationProviderSpecificInput(body []byte) (BasicReverseReplicationProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvrari HyperVReplicaAzureReprotectInput
		err := json.Unmarshal(body, &hvrari)
		return hvrari, err
	case string(InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavri InMageAzureV2ReprotectInput
		err := json.Unmarshal(body, &imavri)
		return imavri, err
	case string(InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage):
		var imri InMageReprotectInput
		err := json.Unmarshal(body, &imri)
		return imri, err
	case string(InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A):
		var ari A2AReprotectInput
		err := json.Unmarshal(body, &ari)
		return ari, err
	default:
		var rrpsi ReverseReplicationProviderSpecificInput
		err := json.Unmarshal(body, &rrpsi)
		return rrpsi, err
	}
}
func unmarshalBasicReverseReplicationProviderSpecificInputArray(body []byte) ([]BasicReverseReplicationProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrpsiArray := make([]BasicReverseReplicationProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rrpsi, err := unmarshalBasicReverseReplicationProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrpsiArray[index] = rrpsi
	}
	return rrpsiArray, nil
}

// MarshalJSON is the custom marshaler for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) MarshalJSON() ([]byte, error) {
	rrpsi.InstanceType = InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput
	objectMap := make(map[string]interface{})
	if rrpsi.InstanceType != "" {
		objectMap["instanceType"] = rrpsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// AsReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsReverseReplicationProviderSpecificInput() (*ReverseReplicationProviderSpecificInput, bool) {
	return &rrpsi, true
}

// AsBasicReverseReplicationProviderSpecificInput is the BasicReverseReplicationProviderSpecificInput implementation for ReverseReplicationProviderSpecificInput.
func (rrpsi ReverseReplicationProviderSpecificInput) AsBasicReverseReplicationProviderSpecificInput() (BasicReverseReplicationProviderSpecificInput, bool) {
	return &rrpsi, true
}

// RoleAssignment azure role assignment details.
type RoleAssignment struct {
	// ID - The ARM Id of the role assignment.
	ID *string `json:"id,omitempty"`
	// Name - The name of the role assignment.
	Name *string `json:"name,omitempty"`
	// Scope - Role assignment scope.
	Scope *string `json:"scope,omitempty"`
	// PrincipalID - Principal Id.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Role definition id.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// RunAsAccount CS Accounts Details.
type RunAsAccount struct {
	// AccountID - The CS RunAs account Id.
	AccountID *string `json:"accountId,omitempty"`
	// AccountName - The CS RunAs account name.
	AccountName *string `json:"accountName,omitempty"`
}

// SanEnableProtectionInput san enable protection provider specific input.
type SanEnableProtectionInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) MarshalJSON() ([]byte, error) {
	sepi.InstanceType = InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan
	objectMap := make(map[string]interface{})
	if sepi.InstanceType != "" {
		objectMap["instanceType"] = sepi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return &sepi, true
}

// AsInMageAzureV2EnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// AsEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsEnableProtectionProviderSpecificInput() (*EnableProtectionProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicEnableProtectionProviderSpecificInput is the BasicEnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsBasicEnableProtectionProviderSpecificInput() (BasicEnableProtectionProviderSpecificInput, bool) {
	return &sepi, true
}

// ScriptActionTaskDetails this class represents the script action task details.
type ScriptActionTaskDetails struct {
	// Name - The name.
	Name *string `json:"name,omitempty"`
	// Path - The path.
	Path *string `json:"path,omitempty"`
	// Output - The output.
	Output *string `json:"output,omitempty"`
	// IsPrimarySideScript - A value indicating whether it is a primary side script or not.
	IsPrimarySideScript *bool `json:"isPrimarySideScript,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) MarshalJSON() ([]byte, error) {
	satd.InstanceType = InstanceTypeScriptActionTaskDetails
	objectMap := make(map[string]interface{})
	if satd.Name != nil {
		objectMap["name"] = satd.Name
	}
	if satd.Path != nil {
		objectMap["path"] = satd.Path
	}
	if satd.Output != nil {
		objectMap["output"] = satd.Output
	}
	if satd.IsPrimarySideScript != nil {
		objectMap["isPrimarySideScript"] = satd.IsPrimarySideScript
	}
	if satd.InstanceType != "" {
		objectMap["instanceType"] = satd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return &satd, true
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &satd, true
}

// ServiceError ASR error model
type ServiceError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// PossibleCauses - Possible causes of error.
	PossibleCauses *string `json:"possibleCauses,omitempty"`
	// RecommendedAction - Recommended action to resolve error.
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	// ActivityID - Activity Id.
	ActivityID *string `json:"activityId,omitempty"`
}

// StorageClassification storage object definition.
type StorageClassification struct {
	autorest.Response `json:"-"`
	// Properties - Proprties of the storage object.
	Properties *StorageClassificationProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// StorageClassificationCollection collection of storage details.
type StorageClassificationCollection struct {
	autorest.Response `json:"-"`
	// Value - The storage details.
	Value *[]StorageClassification `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageClassificationCollectionIterator provides access to a complete listing of StorageClassification values.
type StorageClassificationCollectionIterator struct {
	i    int
	page StorageClassificationCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageClassificationCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageClassificationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageClassificationCollectionIterator) Response() StorageClassificationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageClassificationCollectionIterator) Value() StorageClassification {
	if !iter.page.NotDone() {
		return StorageClassification{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (scc StorageClassificationCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// storageClassificationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc StorageClassificationCollection) storageClassificationCollectionPreparer() (*http.Request, error) {
	if scc.NextLink == nil || len(to.String(scc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// StorageClassificationCollectionPage contains a page of StorageClassification values.
type StorageClassificationCollectionPage struct {
	fn  func(StorageClassificationCollection) (StorageClassificationCollection, error)
	scc StorageClassificationCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageClassificationCollectionPage) Next() error {
	next, err := page.fn(page.scc)
	if err != nil {
		return err
	}
	page.scc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageClassificationCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageClassificationCollectionPage) Response() StorageClassificationCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageClassificationCollectionPage) Values() []StorageClassification {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// StorageClassificationMapping storage mapping object.
type StorageClassificationMapping struct {
	autorest.Response `json:"-"`
	// Properties - Proprties of the storage mappping object.
	Properties *StorageClassificationMappingProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// StorageClassificationMappingCollection collection of storage mapping details.
type StorageClassificationMappingCollection struct {
	autorest.Response `json:"-"`
	// Value - The storage details.
	Value *[]StorageClassificationMapping `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// StorageClassificationMappingCollectionIterator provides access to a complete listing of
// StorageClassificationMapping values.
type StorageClassificationMappingCollectionIterator struct {
	i    int
	page StorageClassificationMappingCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StorageClassificationMappingCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StorageClassificationMappingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StorageClassificationMappingCollectionIterator) Response() StorageClassificationMappingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StorageClassificationMappingCollectionIterator) Value() StorageClassificationMapping {
	if !iter.page.NotDone() {
		return StorageClassificationMapping{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (scmc StorageClassificationMappingCollection) IsEmpty() bool {
	return scmc.Value == nil || len(*scmc.Value) == 0
}

// storageClassificationMappingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scmc StorageClassificationMappingCollection) storageClassificationMappingCollectionPreparer() (*http.Request, error) {
	if scmc.NextLink == nil || len(to.String(scmc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scmc.NextLink)))
}

// StorageClassificationMappingCollectionPage contains a page of StorageClassificationMapping values.
type StorageClassificationMappingCollectionPage struct {
	fn   func(StorageClassificationMappingCollection) (StorageClassificationMappingCollection, error)
	scmc StorageClassificationMappingCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StorageClassificationMappingCollectionPage) Next() error {
	next, err := page.fn(page.scmc)
	if err != nil {
		return err
	}
	page.scmc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StorageClassificationMappingCollectionPage) NotDone() bool {
	return !page.scmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StorageClassificationMappingCollectionPage) Response() StorageClassificationMappingCollection {
	return page.scmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StorageClassificationMappingCollectionPage) Values() []StorageClassificationMapping {
	if page.scmc.IsEmpty() {
		return nil
	}
	return *page.scmc.Value
}

// StorageClassificationMappingInput storage mapping input.
type StorageClassificationMappingInput struct {
	// Properties - Storage mapping input properties.
	Properties *StorageMappingInputProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingProperties storage mapping properties.
type StorageClassificationMappingProperties struct {
	// TargetStorageClassificationID - Target storage object Id.
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// StorageClassificationProperties storage object properties.
type StorageClassificationProperties struct {
	// FriendlyName - Friendly name of the Storage classification.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// StorageMappingInputProperties storage mapping input properties.
type StorageMappingInputProperties struct {
	// TargetStorageClassificationID - The ID of the storage object.
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// Subnet subnets of the network.
type Subnet struct {
	// Name - The subnet name.
	Name *string `json:"name,omitempty"`
	// FriendlyName - The subnet friendly name.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// AddressList - The list of addresses for the subnet.
	AddressList *[]string `json:"addressList,omitempty"`
}

// SwitchProtectionInput switch protection input.
type SwitchProtectionInput struct {
	// Properties - Switch protection properties
	Properties *SwitchProtectionInputProperties `json:"properties,omitempty"`
}

// SwitchProtectionInputProperties switch protection input properties.
type SwitchProtectionInputProperties struct {
	// ReplicationProtectedItemName - The unique replication protected item name.
	ReplicationProtectedItemName *string `json:"replicationProtectedItemName,omitempty"`
	// ProviderSpecificDetails - Provider specific switch protection input.
	ProviderSpecificDetails BasicSwitchProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SwitchProtectionInputProperties struct.
func (spip *SwitchProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "replicationProtectedItemName":
			if v != nil {
				var replicationProtectedItemName string
				err = json.Unmarshal(*v, &replicationProtectedItemName)
				if err != nil {
					return err
				}
				spip.ReplicationProtectedItemName = &replicationProtectedItemName
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicSwitchProtectionProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				spip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// SwitchProtectionJobDetails this class represents details for switch protection job.
type SwitchProtectionJobDetails struct {
	// NewReplicationProtectedItemID - ARM Id of the new replication protected item.
	NewReplicationProtectedItemID *string `json:"newReplicationProtectedItemId,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) MarshalJSON() ([]byte, error) {
	spjd.InstanceType = InstanceTypeSwitchProtectionJobDetails
	objectMap := make(map[string]interface{})
	if spjd.NewReplicationProtectedItemID != nil {
		objectMap["newReplicationProtectedItemId"] = spjd.NewReplicationProtectedItemID
	}
	if spjd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = spjd.AffectedObjectDetails
	}
	if spjd.InstanceType != "" {
		objectMap["instanceType"] = spjd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return &spjd, true
}

// AsJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &spjd, true
}

// BasicSwitchProtectionProviderSpecificInput provider specific switch protection input.
type BasicSwitchProtectionProviderSpecificInput interface {
	AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool)
	AsSwitchProtectionProviderSpecificInput() (*SwitchProtectionProviderSpecificInput, bool)
}

// SwitchProtectionProviderSpecificInput provider specific switch protection input.
type SwitchProtectionProviderSpecificInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput', 'InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicSwitchProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

func unmarshalBasicSwitchProtectionProviderSpecificInput(body []byte) (BasicSwitchProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A):
		var aspi A2ASwitchProtectionInput
		err := json.Unmarshal(body, &aspi)
		return aspi, err
	default:
		var sppsi SwitchProtectionProviderSpecificInput
		err := json.Unmarshal(body, &sppsi)
		return sppsi, err
	}
}
func unmarshalBasicSwitchProtectionProviderSpecificInputArray(body []byte) ([]BasicSwitchProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sppsiArray := make([]BasicSwitchProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppsi, err := unmarshalBasicSwitchProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		sppsiArray[index] = sppsi
	}
	return sppsiArray, nil
}

// MarshalJSON is the custom marshaler for SwitchProtectionProviderSpecificInput.
func (sppsi SwitchProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	sppsi.InstanceType = InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput
	objectMap := make(map[string]interface{})
	if sppsi.InstanceType != "" {
		objectMap["instanceType"] = sppsi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsA2ASwitchProtectionInput is the BasicSwitchProtectionProviderSpecificInput implementation for SwitchProtectionProviderSpecificInput.
func (sppsi SwitchProtectionProviderSpecificInput) AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool) {
	return nil, false
}

// AsSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for SwitchProtectionProviderSpecificInput.
func (sppsi SwitchProtectionProviderSpecificInput) AsSwitchProtectionProviderSpecificInput() (*SwitchProtectionProviderSpecificInput, bool) {
	return &sppsi, true
}

// AsBasicSwitchProtectionProviderSpecificInput is the BasicSwitchProtectionProviderSpecificInput implementation for SwitchProtectionProviderSpecificInput.
func (sppsi SwitchProtectionProviderSpecificInput) AsBasicSwitchProtectionProviderSpecificInput() (BasicSwitchProtectionProviderSpecificInput, bool) {
	return &sppsi, true
}

// BasicTaskTypeDetails task details based on specific task type.
type BasicTaskTypeDetails interface {
	AsJobTaskDetails() (*JobTaskDetails, bool)
	AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool)
	AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool)
	AsManualActionTaskDetails() (*ManualActionTaskDetails, bool)
	AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool)
	AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool)
	AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool)
	AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool)
	AsTaskTypeDetails() (*TaskTypeDetails, bool)
}

// TaskTypeDetails task details based on specific task type.
type TaskTypeDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

func unmarshalBasicTaskTypeDetails(body []byte) (BasicTaskTypeDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeJobTaskDetails):
		var jtd JobTaskDetails
		err := json.Unmarshal(body, &jtd)
		return jtd, err
	case string(InstanceTypeVirtualMachineTaskDetails):
		var vmtd VirtualMachineTaskDetails
		err := json.Unmarshal(body, &vmtd)
		return vmtd, err
	case string(InstanceTypeFabricReplicationGroupTaskDetails):
		var frgtd FabricReplicationGroupTaskDetails
		err := json.Unmarshal(body, &frgtd)
		return frgtd, err
	case string(InstanceTypeManualActionTaskDetails):
		var matd ManualActionTaskDetails
		err := json.Unmarshal(body, &matd)
		return matd, err
	case string(InstanceTypeScriptActionTaskDetails):
		var satd ScriptActionTaskDetails
		err := json.Unmarshal(body, &satd)
		return satd, err
	case string(InstanceTypeVMNicUpdatesTaskDetails):
		var vnutd VMNicUpdatesTaskDetails
		err := json.Unmarshal(body, &vnutd)
		return vnutd, err
	case string(InstanceTypeConsistencyCheckTaskDetails):
		var cctd ConsistencyCheckTaskDetails
		err := json.Unmarshal(body, &cctd)
		return cctd, err
	case string(InstanceTypeAutomationRunbookTaskDetails):
		var artd AutomationRunbookTaskDetails
		err := json.Unmarshal(body, &artd)
		return artd, err
	default:
		var ttd TaskTypeDetails
		err := json.Unmarshal(body, &ttd)
		return ttd, err
	}
}
func unmarshalBasicTaskTypeDetailsArray(body []byte) ([]BasicTaskTypeDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ttdArray := make([]BasicTaskTypeDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ttd, err := unmarshalBasicTaskTypeDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ttdArray[index] = ttd
	}
	return ttdArray, nil
}

// MarshalJSON is the custom marshaler for TaskTypeDetails.
func (ttd TaskTypeDetails) MarshalJSON() ([]byte, error) {
	ttd.InstanceType = InstanceTypeTaskTypeDetails
	objectMap := make(map[string]interface{})
	if ttd.InstanceType != "" {
		objectMap["instanceType"] = ttd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return &ttd, true
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for TaskTypeDetails.
func (ttd TaskTypeDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &ttd, true
}

// TestFailoverCleanupInput input definition for test failover cleanup.
type TestFailoverCleanupInput struct {
	// Properties - Test failover cleanup input properties.
	Properties *TestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// TestFailoverCleanupInputProperties input definition for test failover cleanup input properties.
type TestFailoverCleanupInputProperties struct {
	// Comments - Test failover cleanup comments.
	Comments *string `json:"comments,omitempty"`
}

// TestFailoverInput input definition for planned failover.
type TestFailoverInput struct {
	// Properties - Planned failover input properties
	Properties *TestFailoverInputProperties `json:"properties,omitempty"`
}

// TestFailoverInputProperties input definition for planned failover input properties.
type TestFailoverInputProperties struct {
	// FailoverDirection - Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`
	// NetworkType - Network type to be used for test failover.
	NetworkType *string `json:"networkType,omitempty"`
	// NetworkID - The id of the network to be used for test failover
	NetworkID *string `json:"networkId,omitempty"`
	// SkipTestFailoverCleanup - A value indicating whether the test failover cleanup is to be skipped.
	SkipTestFailoverCleanup *string `json:"skipTestFailoverCleanup,omitempty"`
	// ProviderSpecificDetails - Provider specific settings
	ProviderSpecificDetails BasicProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TestFailoverInputProperties struct.
func (tfip *TestFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection string
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				tfip.FailoverDirection = &failoverDirection
			}
		case "networkType":
			if v != nil {
				var networkType string
				err = json.Unmarshal(*v, &networkType)
				if err != nil {
					return err
				}
				tfip.NetworkType = &networkType
			}
		case "networkId":
			if v != nil {
				var networkID string
				err = json.Unmarshal(*v, &networkID)
				if err != nil {
					return err
				}
				tfip.NetworkID = &networkID
			}
		case "skipTestFailoverCleanup":
			if v != nil {
				var skipTestFailoverCleanup string
				err = json.Unmarshal(*v, &skipTestFailoverCleanup)
				if err != nil {
					return err
				}
				tfip.SkipTestFailoverCleanup = &skipTestFailoverCleanup
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProviderSpecificFailoverInput(*v)
				if err != nil {
					return err
				}
				tfip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// TestFailoverJobDetails this class represents the details for a test failover job.
type TestFailoverJobDetails struct {
	// TestFailoverStatus - The test failover status.
	TestFailoverStatus *string `json:"testFailoverStatus,omitempty"`
	// Comments - The test failover comments.
	Comments *string `json:"comments,omitempty"`
	// NetworkName - The test network name.
	NetworkName *string `json:"networkName,omitempty"`
	// NetworkFriendlyName - The test network friendly name.
	NetworkFriendlyName *string `json:"networkFriendlyName,omitempty"`
	// NetworkType - The test network type (see TestFailoverInput enum for possible values).
	NetworkType *string `json:"networkType,omitempty"`
	// ProtectedItemDetails - The test VM details.
	ProtectedItemDetails *[]FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
	// AffectedObjectDetails - The affected object properties like source server, source cloud, target server, target cloud etc. based on the workflow object details.
	AffectedObjectDetails map[string]*string `json:"affectedObjectDetails"`
	// InstanceType - Possible values include: 'InstanceTypeJobDetails', 'InstanceTypeAsrJobDetails', 'InstanceTypeTestFailoverJobDetails', 'InstanceTypeFailoverJobDetails', 'InstanceTypeExportJobDetails', 'InstanceTypeSwitchProtectionJobDetails'
	InstanceType InstanceTypeBasicJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) MarshalJSON() ([]byte, error) {
	tfjd.InstanceType = InstanceTypeTestFailoverJobDetails
	objectMap := make(map[string]interface{})
	if tfjd.TestFailoverStatus != nil {
		objectMap["testFailoverStatus"] = tfjd.TestFailoverStatus
	}
	if tfjd.Comments != nil {
		objectMap["comments"] = tfjd.Comments
	}
	if tfjd.NetworkName != nil {
		objectMap["networkName"] = tfjd.NetworkName
	}
	if tfjd.NetworkFriendlyName != nil {
		objectMap["networkFriendlyName"] = tfjd.NetworkFriendlyName
	}
	if tfjd.NetworkType != nil {
		objectMap["networkType"] = tfjd.NetworkType
	}
	if tfjd.ProtectedItemDetails != nil {
		objectMap["protectedItemDetails"] = tfjd.ProtectedItemDetails
	}
	if tfjd.AffectedObjectDetails != nil {
		objectMap["affectedObjectDetails"] = tfjd.AffectedObjectDetails
	}
	if tfjd.InstanceType != "" {
		objectMap["instanceType"] = tfjd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAsrJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return &tfjd, true
}

// AsFailoverJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &tfjd, true
}

// UnplannedFailoverInput input definition for planned failover.
type UnplannedFailoverInput struct {
	// Properties - Planned failover input properties
	Properties *UnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// UnplannedFailoverInputProperties input definition for planned failover input properties.
type UnplannedFailoverInputProperties struct {
	// FailoverDirection - Failover direction.
	FailoverDirection *string `json:"failoverDirection,omitempty"`
	// SourceSiteOperations - Source site operations status
	SourceSiteOperations *string `json:"sourceSiteOperations,omitempty"`
	// ProviderSpecificDetails - Provider specific settings
	ProviderSpecificDetails BasicProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnplannedFailoverInputProperties struct.
func (ufip *UnplannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "failoverDirection":
			if v != nil {
				var failoverDirection string
				err = json.Unmarshal(*v, &failoverDirection)
				if err != nil {
					return err
				}
				ufip.FailoverDirection = &failoverDirection
			}
		case "sourceSiteOperations":
			if v != nil {
				var sourceSiteOperations string
				err = json.Unmarshal(*v, &sourceSiteOperations)
				if err != nil {
					return err
				}
				ufip.SourceSiteOperations = &sourceSiteOperations
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicProviderSpecificFailoverInput(*v)
				if err != nil {
					return err
				}
				ufip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// UpdateMobilityServiceRequest request to update the mobility service on a protected item.
type UpdateMobilityServiceRequest struct {
	// Properties - The properties of the update mobility service request.
	Properties *UpdateMobilityServiceRequestProperties `json:"properties,omitempty"`
}

// UpdateMobilityServiceRequestProperties the properties of an update mobility service request.
type UpdateMobilityServiceRequestProperties struct {
	// RunAsAccountID - The CS run as account Id.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// UpdateNetworkMappingInput update network mapping input.
type UpdateNetworkMappingInput struct {
	// Properties - The input properties needed to update network mapping.
	Properties *UpdateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// UpdateNetworkMappingInputProperties common input details for network mapping operation.
type UpdateNetworkMappingInputProperties struct {
	// RecoveryFabricName - Recovery fabric name.
	RecoveryFabricName *string `json:"recoveryFabricName,omitempty"`
	// RecoveryNetworkID - Recovery network Id.
	RecoveryNetworkID *string `json:"recoveryNetworkId,omitempty"`
	// FabricSpecificDetails - Fabrics specific input network Id.
	FabricSpecificDetails BasicFabricSpecificUpdateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateNetworkMappingInputProperties struct.
func (unmip *UpdateNetworkMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryFabricName":
			if v != nil {
				var recoveryFabricName string
				err = json.Unmarshal(*v, &recoveryFabricName)
				if err != nil {
					return err
				}
				unmip.RecoveryFabricName = &recoveryFabricName
			}
		case "recoveryNetworkId":
			if v != nil {
				var recoveryNetworkID string
				err = json.Unmarshal(*v, &recoveryNetworkID)
				if err != nil {
					return err
				}
				unmip.RecoveryNetworkID = &recoveryNetworkID
			}
		case "fabricSpecificDetails":
			if v != nil {
				fabricSpecificDetails, err := unmarshalBasicFabricSpecificUpdateNetworkMappingInput(*v)
				if err != nil {
					return err
				}
				unmip.FabricSpecificDetails = fabricSpecificDetails
			}
		}
	}

	return nil
}

// UpdatePolicyInput update protection profile input.
type UpdatePolicyInput struct {
	// Properties - The ReplicationProviderSettings.
	Properties *UpdatePolicyInputProperties `json:"properties,omitempty"`
}

// UpdatePolicyInputProperties policy update properties.
type UpdatePolicyInputProperties struct {
	// ReplicationProviderSettings - The ReplicationProviderSettings.
	ReplicationProviderSettings BasicPolicyProviderSpecificInput `json:"replicationProviderSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdatePolicyInputProperties struct.
func (upip *UpdatePolicyInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "replicationProviderSettings":
			if v != nil {
				replicationProviderSettings, err := unmarshalBasicPolicyProviderSpecificInput(*v)
				if err != nil {
					return err
				}
				upip.ReplicationProviderSettings = replicationProviderSettings
			}
		}
	}

	return nil
}

// UpdateRecoveryPlanInput update recovery plan input class.
type UpdateRecoveryPlanInput struct {
	// Properties - Recovery plan update properties.
	Properties *UpdateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// UpdateRecoveryPlanInputProperties recovery plan updation properties.
type UpdateRecoveryPlanInputProperties struct {
	// Groups - The recovery plan groups.
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
}

// UpdateReplicationProtectedItemInput update replication protected item input.
type UpdateReplicationProtectedItemInput struct {
	// Properties - Update replication protected item properties.
	Properties *UpdateReplicationProtectedItemInputProperties `json:"properties,omitempty"`
}

// UpdateReplicationProtectedItemInputProperties update protected item input properties.
type UpdateReplicationProtectedItemInputProperties struct {
	// RecoveryAzureVMName - Target azure VM name given by the user.
	RecoveryAzureVMName *string `json:"recoveryAzureVMName,omitempty"`
	// RecoveryAzureVMSize - Target Azure Vm size.
	RecoveryAzureVMSize *string `json:"recoveryAzureVMSize,omitempty"`
	// SelectedRecoveryAzureNetworkID - Target Azure Network Id.
	SelectedRecoveryAzureNetworkID *string `json:"selectedRecoveryAzureNetworkId,omitempty"`
	// EnableRDPOnTargetOption - The selected option to enable RDP\SSH on target vm after failover. String value of {SrsDataContract.EnableRDPOnTargetOption} enum.
	EnableRDPOnTargetOption *string `json:"enableRDPOnTargetOption,omitempty"`
	// VMNics - The list of vm nic details.
	VMNics *[]VMNicInputDetails `json:"vmNics,omitempty"`
	// LicenseType - License type. Possible values include: 'LicenseTypeNotSpecified', 'LicenseTypeNoLicenseType', 'LicenseTypeWindowsServer'
	LicenseType LicenseType `json:"licenseType,omitempty"`
	// RecoveryAvailabilitySetID - The target availability set id.
	RecoveryAvailabilitySetID *string `json:"recoveryAvailabilitySetId,omitempty"`
	// ProviderSpecificDetails - The provider specific input to update replication protected item.
	ProviderSpecificDetails BasicUpdateReplicationProtectedItemProviderInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateReplicationProtectedItemInputProperties struct.
func (urpiip *UpdateReplicationProtectedItemInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "recoveryAzureVMName":
			if v != nil {
				var recoveryAzureVMName string
				err = json.Unmarshal(*v, &recoveryAzureVMName)
				if err != nil {
					return err
				}
				urpiip.RecoveryAzureVMName = &recoveryAzureVMName
			}
		case "recoveryAzureVMSize":
			if v != nil {
				var recoveryAzureVMSize string
				err = json.Unmarshal(*v, &recoveryAzureVMSize)
				if err != nil {
					return err
				}
				urpiip.RecoveryAzureVMSize = &recoveryAzureVMSize
			}
		case "selectedRecoveryAzureNetworkId":
			if v != nil {
				var selectedRecoveryAzureNetworkID string
				err = json.Unmarshal(*v, &selectedRecoveryAzureNetworkID)
				if err != nil {
					return err
				}
				urpiip.SelectedRecoveryAzureNetworkID = &selectedRecoveryAzureNetworkID
			}
		case "enableRDPOnTargetOption":
			if v != nil {
				var enableRDPOnTargetOption string
				err = json.Unmarshal(*v, &enableRDPOnTargetOption)
				if err != nil {
					return err
				}
				urpiip.EnableRDPOnTargetOption = &enableRDPOnTargetOption
			}
		case "vmNics":
			if v != nil {
				var VMNics []VMNicInputDetails
				err = json.Unmarshal(*v, &VMNics)
				if err != nil {
					return err
				}
				urpiip.VMNics = &VMNics
			}
		case "licenseType":
			if v != nil {
				var licenseType LicenseType
				err = json.Unmarshal(*v, &licenseType)
				if err != nil {
					return err
				}
				urpiip.LicenseType = licenseType
			}
		case "recoveryAvailabilitySetId":
			if v != nil {
				var recoveryAvailabilitySetID string
				err = json.Unmarshal(*v, &recoveryAvailabilitySetID)
				if err != nil {
					return err
				}
				urpiip.RecoveryAvailabilitySetID = &recoveryAvailabilitySetID
			}
		case "providerSpecificDetails":
			if v != nil {
				providerSpecificDetails, err := unmarshalBasicUpdateReplicationProtectedItemProviderInput(*v)
				if err != nil {
					return err
				}
				urpiip.ProviderSpecificDetails = providerSpecificDetails
			}
		}
	}

	return nil
}

// BasicUpdateReplicationProtectedItemProviderInput update replication protected item provider specific input.
type BasicUpdateReplicationProtectedItemProviderInput interface {
	AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool)
	AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool)
	AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool)
	AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool)
}

// UpdateReplicationProtectedItemProviderInput update replication protected item provider specific input.
type UpdateReplicationProtectedItemProviderInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A'
	InstanceType InstanceTypeBasicUpdateReplicationProtectedItemProviderInput `json:"instanceType,omitempty"`
}

func unmarshalBasicUpdateReplicationProtectedItemProviderInput(body []byte) (BasicUpdateReplicationProtectedItemProviderInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure):
		var hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &hvraurpii)
		return hvraurpii, err
	case string(InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2):
		var imavurpii InMageAzureV2UpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &imavurpii)
		return imavurpii, err
	case string(InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A):
		var aurpii A2AUpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &aurpii)
		return aurpii, err
	default:
		var urpipi UpdateReplicationProtectedItemProviderInput
		err := json.Unmarshal(body, &urpipi)
		return urpipi, err
	}
}
func unmarshalBasicUpdateReplicationProtectedItemProviderInputArray(body []byte) ([]BasicUpdateReplicationProtectedItemProviderInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	urpipiArray := make([]BasicUpdateReplicationProtectedItemProviderInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		urpipi, err := unmarshalBasicUpdateReplicationProtectedItemProviderInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		urpipiArray[index] = urpipi
	}
	return urpipiArray, nil
}

// MarshalJSON is the custom marshaler for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) MarshalJSON() ([]byte, error) {
	urpipi.InstanceType = InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput
	objectMap := make(map[string]interface{})
	if urpipi.InstanceType != "" {
		objectMap["instanceType"] = urpipi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsA2AUpdateReplicationProtectedItemInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) AsUpdateReplicationProtectedItemProviderInput() (*UpdateReplicationProtectedItemProviderInput, bool) {
	return &urpipi, true
}

// AsBasicUpdateReplicationProtectedItemProviderInput is the BasicUpdateReplicationProtectedItemProviderInput implementation for UpdateReplicationProtectedItemProviderInput.
func (urpipi UpdateReplicationProtectedItemProviderInput) AsBasicUpdateReplicationProtectedItemProviderInput() (BasicUpdateReplicationProtectedItemProviderInput, bool) {
	return &urpipi, true
}

// UpdateVCenterRequest input required to update vCenter.
type UpdateVCenterRequest struct {
	// Properties - The update VCenter Request Properties.
	Properties *UpdateVCenterRequestProperties `json:"properties,omitempty"`
}

// UpdateVCenterRequestProperties the properties of an update vCenter request.
type UpdateVCenterRequestProperties struct {
	// FriendlyName - The friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IPAddress - The IP address of the vCenter to be discovered.
	IPAddress *string `json:"ipAddress,omitempty"`
	// ProcessServerID - The process server Id from where the update can be orchestrated.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// Port - The port number for discovery.
	Port *string `json:"port,omitempty"`
	// RunAsAccountID - The CS account Id which has priviliges to update the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// VaultHealthDetails vault health details definition.
type VaultHealthDetails struct {
	autorest.Response `json:"-"`
	// Properties - The vault health related data.
	Properties *VaultHealthProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// VaultHealthProperties class to define the health summary of the Vault.
type VaultHealthProperties struct {
	// VaultErrors - The list of errors on the vault.
	VaultErrors *[]HealthError `json:"vaultErrors,omitempty"`
	// ProtectedItemsHealth - The list of the health detail of the protected items in the vault.
	ProtectedItemsHealth *ResourceHealthSummary `json:"protectedItemsHealth,omitempty"`
	// FabricsHealth - The list of the health detail of the fabrics in the vault.
	FabricsHealth *ResourceHealthSummary `json:"fabricsHealth,omitempty"`
}

// VCenter vCenter definition.
type VCenter struct {
	autorest.Response `json:"-"`
	// Properties - VCenter related data.
	Properties *VCenterProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource Name
	Name *string `json:"name,omitempty"`
	// Type - Resource Type
	Type *string `json:"type,omitempty"`
	// Location - Resource Location
	Location *string `json:"location,omitempty"`
}

// VCenterCollection collection of vCenter details.
type VCenterCollection struct {
	autorest.Response `json:"-"`
	// Value - The vCenter details.
	Value *[]VCenter `json:"value,omitempty"`
	// NextLink - The value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// VCenterCollectionIterator provides access to a complete listing of VCenter values.
type VCenterCollectionIterator struct {
	i    int
	page VCenterCollectionPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VCenterCollectionIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VCenterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VCenterCollectionIterator) Response() VCenterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VCenterCollectionIterator) Value() VCenter {
	if !iter.page.NotDone() {
		return VCenter{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (vcc VCenterCollection) IsEmpty() bool {
	return vcc.Value == nil || len(*vcc.Value) == 0
}

// vCenterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vcc VCenterCollection) vCenterCollectionPreparer() (*http.Request, error) {
	if vcc.NextLink == nil || len(to.String(vcc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vcc.NextLink)))
}

// VCenterCollectionPage contains a page of VCenter values.
type VCenterCollectionPage struct {
	fn  func(VCenterCollection) (VCenterCollection, error)
	vcc VCenterCollection
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VCenterCollectionPage) Next() error {
	next, err := page.fn(page.vcc)
	if err != nil {
		return err
	}
	page.vcc = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VCenterCollectionPage) NotDone() bool {
	return !page.vcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VCenterCollectionPage) Response() VCenterCollection {
	return page.vcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VCenterCollectionPage) Values() []VCenter {
	if page.vcc.IsEmpty() {
		return nil
	}
	return *page.vcc.Value
}

// VCenterProperties vCenter properties.
type VCenterProperties struct {
	// FriendlyName - Friendly name of the vCenter.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// InternalID - VCenter internal ID.
	InternalID *string `json:"internalId,omitempty"`
	// LastHeartbeat - The time when the last heartbeat was reveived by vCenter.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// DiscoveryStatus - The VCenter discovery status.
	DiscoveryStatus *string `json:"discoveryStatus,omitempty"`
	// ProcessServerID - The process server Id.
	ProcessServerID *string `json:"processServerId,omitempty"`
	// IPAddress - The IP address of the vCenter.
	IPAddress *string `json:"ipAddress,omitempty"`
	// InfrastructureID - The infrastructure Id of vCenter.
	InfrastructureID *string `json:"infrastructureId,omitempty"`
	// Port - The port number for discovery.
	Port *string `json:"port,omitempty"`
	// RunAsAccountID - The account Id which has privileges to discover the vCenter.
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
	// FabricArmResourceName - The ARM resource name of the fabric containing this VCenter.
	FabricArmResourceName *string `json:"fabricArmResourceName,omitempty"`
}

// VirtualMachineTaskDetails this class represents the virtual machine task details.
type VirtualMachineTaskDetails struct {
	// SkippedReason - The skipped reason.
	SkippedReason *string `json:"skippedReason,omitempty"`
	// SkippedReasonString - The skipped reason string.
	SkippedReasonString *string `json:"skippedReasonString,omitempty"`
	// JobTask - The job entity.
	JobTask *JobEntity `json:"jobTask,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) MarshalJSON() ([]byte, error) {
	vmtd.InstanceType = InstanceTypeVirtualMachineTaskDetails
	objectMap := make(map[string]interface{})
	if vmtd.SkippedReason != nil {
		objectMap["skippedReason"] = vmtd.SkippedReason
	}
	if vmtd.SkippedReasonString != nil {
		objectMap["skippedReasonString"] = vmtd.SkippedReasonString
	}
	if vmtd.JobTask != nil {
		objectMap["jobTask"] = vmtd.JobTask
	}
	if vmtd.InstanceType != "" {
		objectMap["instanceType"] = vmtd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return &vmtd, true
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &vmtd, true
}

// VmmDetails VMM fabric specific details.
type VmmDetails struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmDetails.
func (vd VmmDetails) MarshalJSON() ([]byte, error) {
	vd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM
	objectMap := make(map[string]interface{})
	if vd.InstanceType != "" {
		objectMap["instanceType"] = vd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVmmDetails() (*VmmDetails, bool) {
	return &vd, true
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &vd, true
}

// VmmToAzureCreateNetworkMappingInput create network mappings input properties/behaviour specific to Vmm to Azure
// Network mapping.
type VmmToAzureCreateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtacnmi.InstanceType = InstanceTypeVmmToAzure
	objectMap := make(map[string]interface{})
	if vtacnmi.InstanceType != "" {
		objectMap["instanceType"] = vtacnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return &vtacnmi, true
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &vtacnmi, true
}

// VmmToAzureNetworkMappingSettings e2A Network Mapping fabric specific settings.
type VmmToAzureNetworkMappingSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	vtanms.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure
	objectMap := make(map[string]interface{})
	if vtanms.InstanceType != "" {
		objectMap["instanceType"] = vtanms.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return &vtanms, true
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return nil, false
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &vtanms, true
}

// VmmToAzureUpdateNetworkMappingInput update network mappings input properties/behaviour specific to vmm to azure.
type VmmToAzureUpdateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtaunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure
	objectMap := make(map[string]interface{})
	if vtaunmi.InstanceType != "" {
		objectMap["instanceType"] = vtaunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return &vtaunmi, true
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &vtaunmi, true
}

// VmmToVmmCreateNetworkMappingInput create network mappings input properties/behaviour specific to vmm to vmm
// Network mapping.
type VmmToVmmCreateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreateNetworkMappingInput', 'InstanceTypeAzureToAzure', 'InstanceTypeVmmToAzure', 'InstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtvcnmi.InstanceType = InstanceTypeVmmToVmm
	objectMap := make(map[string]interface{})
	if vtvcnmi.InstanceType != "" {
		objectMap["instanceType"] = vtvcnmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return &vtvcnmi, true
}

// AsFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsFabricSpecificCreateNetworkMappingInput() (*FabricSpecificCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreateNetworkMappingInput is the BasicFabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsBasicFabricSpecificCreateNetworkMappingInput() (BasicFabricSpecificCreateNetworkMappingInput, bool) {
	return &vtvcnmi, true
}

// VmmToVmmNetworkMappingSettings e2E Network Mapping fabric specific settings.
type VmmToVmmNetworkMappingSettings struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure', 'InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	vtvnms.InstanceType = InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm
	objectMap := make(map[string]interface{})
	if vtvnms.InstanceType != "" {
		objectMap["instanceType"] = vtvnms.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return &vtvnms, true
}

// AsNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsNetworkMappingFabricSpecificSettings() (*NetworkMappingFabricSpecificSettings, bool) {
	return nil, false
}

// AsBasicNetworkMappingFabricSpecificSettings is the BasicNetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsBasicNetworkMappingFabricSpecificSettings() (BasicNetworkMappingFabricSpecificSettings, bool) {
	return &vtvnms, true
}

// VmmToVmmUpdateNetworkMappingInput update network mappings input properties/behaviour specific to vmm to vmm.
type VmmToVmmUpdateNetworkMappingInput struct {
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure', 'InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm'
	InstanceType InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtvunmi.InstanceType = InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm
	objectMap := make(map[string]interface{})
	if vtvunmi.InstanceType != "" {
		objectMap["instanceType"] = vtvunmi.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return &vtvunmi, true
}

// AsFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsFabricSpecificUpdateNetworkMappingInput() (*FabricSpecificUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificUpdateNetworkMappingInput is the BasicFabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsBasicFabricSpecificUpdateNetworkMappingInput() (BasicFabricSpecificUpdateNetworkMappingInput, bool) {
	return &vtvunmi, true
}

// VMNicDetails hyper V VM network details.
type VMNicDetails struct {
	// NicID - The nic Id.
	NicID *string `json:"nicId,omitempty"`
	// ReplicaNicID - The replica nic Id.
	ReplicaNicID *string `json:"replicaNicId,omitempty"`
	// SourceNicArmID - The source nic ARM Id.
	SourceNicArmID *string `json:"sourceNicArmId,omitempty"`
	// VMSubnetName - VM subnet name.
	VMSubnetName *string `json:"vMSubnetName,omitempty"`
	// VMNetworkName - VM network name.
	VMNetworkName *string `json:"vMNetworkName,omitempty"`
	// RecoveryVMNetworkID - Recovery VM network Id.
	RecoveryVMNetworkID *string `json:"recoveryVMNetworkId,omitempty"`
	// RecoveryVMSubnetName - Recovery VM subnet name.
	RecoveryVMSubnetName *string `json:"recoveryVMSubnetName,omitempty"`
	// IPAddressType - Ip address type.
	IPAddressType *string `json:"ipAddressType,omitempty"`
	// PrimaryNicStaticIPAddress - Primary nic static IP address.
	PrimaryNicStaticIPAddress *string `json:"primaryNicStaticIPAddress,omitempty"`
	// ReplicaNicStaticIPAddress - Replica nic static IP address.
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	// SelectionType - Selection type for failover.
	SelectionType *string `json:"selectionType,omitempty"`
	// RecoveryNicIPAddressType - IP allocation type for recovery VM.
	RecoveryNicIPAddressType *string `json:"recoveryNicIpAddressType,omitempty"`
}

// VMNicInputDetails hyper V VM network input details.
type VMNicInputDetails struct {
	// NicID - The nic Id.
	NicID *string `json:"nicId,omitempty"`
	// RecoveryVMSubnetName - Recovery VM subnet name.
	RecoveryVMSubnetName *string `json:"recoveryVMSubnetName,omitempty"`
	// ReplicaNicStaticIPAddress - Replica nic static IP address.
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	// SelectionType - Selection type for failover.
	SelectionType *string `json:"selectionType,omitempty"`
}

// VMNicUpdatesTaskDetails this class represents the vm NicUpdates task details.
type VMNicUpdatesTaskDetails struct {
	// VMID - Virtual machine Id.
	VMID *string `json:"vmId,omitempty"`
	// NicID - Nic Id.
	NicID *string `json:"nicId,omitempty"`
	// Name - Name of the Nic.
	Name *string `json:"name,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeTaskTypeDetails', 'InstanceTypeJobTaskDetails', 'InstanceTypeVirtualMachineTaskDetails', 'InstanceTypeFabricReplicationGroupTaskDetails', 'InstanceTypeManualActionTaskDetails', 'InstanceTypeScriptActionTaskDetails', 'InstanceTypeVMNicUpdatesTaskDetails', 'InstanceTypeConsistencyCheckTaskDetails', 'InstanceTypeAutomationRunbookTaskDetails'
	InstanceType InstanceTypeBasicTaskTypeDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) MarshalJSON() ([]byte, error) {
	vnutd.InstanceType = InstanceTypeVMNicUpdatesTaskDetails
	objectMap := make(map[string]interface{})
	if vnutd.VMID != nil {
		objectMap["vmId"] = vnutd.VMID
	}
	if vnutd.NicID != nil {
		objectMap["nicId"] = vnutd.NicID
	}
	if vnutd.Name != nil {
		objectMap["name"] = vnutd.Name
	}
	if vnutd.InstanceType != "" {
		objectMap["instanceType"] = vnutd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsJobTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return &vnutd, true
}

// AsConsistencyCheckTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// AsTaskTypeDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsTaskTypeDetails() (*TaskTypeDetails, bool) {
	return nil, false
}

// AsBasicTaskTypeDetails is the BasicTaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsBasicTaskTypeDetails() (BasicTaskTypeDetails, bool) {
	return &vnutd, true
}

// VMwareCbtPolicyCreationInput vMware Cbt Policy creation input.
type VMwareCbtPolicyCreationInput struct {
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) MarshalJSON() ([]byte, error) {
	vmcpci.InstanceType = InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt
	objectMap := make(map[string]interface{})
	if vmcpci.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = vmcpci.RecoveryPointHistory
	}
	if vmcpci.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = vmcpci.CrashConsistentFrequencyInMinutes
	}
	if vmcpci.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = vmcpci.AppConsistentFrequencyInMinutes
	}
	if vmcpci.InstanceType != "" {
		objectMap["instanceType"] = vmcpci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return &vmcpci, true
}

// AsPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsPolicyProviderSpecificInput() (*PolicyProviderSpecificInput, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificInput is the BasicPolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsBasicPolicyProviderSpecificInput() (BasicPolicyProviderSpecificInput, bool) {
	return &vmcpci, true
}

// VmwareCbtPolicyDetails vMware Cbt specific policy details.
type VmwareCbtPolicyDetails struct {
	// RecoveryPointThresholdInMinutes - The recovery point threshold in minutes.
	RecoveryPointThresholdInMinutes *int32 `json:"recoveryPointThresholdInMinutes,omitempty"`
	// RecoveryPointHistory - The duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistory *int32 `json:"recoveryPointHistory,omitempty"`
	// AppConsistentFrequencyInMinutes - The app consistent snapshot frequency in minutes.
	AppConsistentFrequencyInMinutes *int32 `json:"appConsistentFrequencyInMinutes,omitempty"`
	// CrashConsistentFrequencyInMinutes - The crash consistent snapshot frequency in minutes.
	CrashConsistentFrequencyInMinutes *int32 `json:"crashConsistentFrequencyInMinutes,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration', 'InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt'
	InstanceType InstanceTypeBasicPolicyProviderSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) MarshalJSON() ([]byte, error) {
	vcpd.InstanceType = InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt
	objectMap := make(map[string]interface{})
	if vcpd.RecoveryPointThresholdInMinutes != nil {
		objectMap["recoveryPointThresholdInMinutes"] = vcpd.RecoveryPointThresholdInMinutes
	}
	if vcpd.RecoveryPointHistory != nil {
		objectMap["recoveryPointHistory"] = vcpd.RecoveryPointHistory
	}
	if vcpd.AppConsistentFrequencyInMinutes != nil {
		objectMap["appConsistentFrequencyInMinutes"] = vcpd.AppConsistentFrequencyInMinutes
	}
	if vcpd.CrashConsistentFrequencyInMinutes != nil {
		objectMap["crashConsistentFrequencyInMinutes"] = vcpd.CrashConsistentFrequencyInMinutes
	}
	if vcpd.InstanceType != "" {
		objectMap["instanceType"] = vcpd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVReplicaAzurePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return &vcpd, true
}

// AsPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsPolicyProviderSpecificDetails() (*PolicyProviderSpecificDetails, bool) {
	return nil, false
}

// AsBasicPolicyProviderSpecificDetails is the BasicPolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsBasicPolicyProviderSpecificDetails() (BasicPolicyProviderSpecificDetails, bool) {
	return &vcpd, true
}

// VMwareDetails store the fabric details specific to the VMware fabric.
type VMwareDetails struct {
	// ProcessServers - The list of Process Servers associated with the fabric.
	ProcessServers *[]ProcessServer `json:"processServers,omitempty"`
	// MasterTargetServers - The list of Master Target servers associated with the fabric.
	MasterTargetServers *[]MasterTargetServer `json:"masterTargetServers,omitempty"`
	// RunAsAccounts - The list of run as accounts created on the server.
	RunAsAccounts *[]RunAsAccount `json:"runAsAccounts,omitempty"`
	// ReplicationPairCount - The number of replication pairs configured in this CS.
	ReplicationPairCount *string `json:"replicationPairCount,omitempty"`
	// ProcessServerCount - The number of process servers.
	ProcessServerCount *string `json:"processServerCount,omitempty"`
	// AgentCount - The number of source and target servers configured to talk to this CS.
	AgentCount *string `json:"agentCount,omitempty"`
	// ProtectedServers - The number of protected servers.
	ProtectedServers *string `json:"protectedServers,omitempty"`
	// SystemLoad - The percentage of the system load.
	SystemLoad *string `json:"systemLoad,omitempty"`
	// SystemLoadStatus - The system load status.
	SystemLoadStatus *string `json:"systemLoadStatus,omitempty"`
	// CPULoad - The percentage of the CPU load.
	CPULoad *string `json:"cpuLoad,omitempty"`
	// CPULoadStatus - The CPU load status.
	CPULoadStatus *string `json:"cpuLoadStatus,omitempty"`
	// TotalMemoryInBytes - The total memory.
	TotalMemoryInBytes *int64 `json:"totalMemoryInBytes,omitempty"`
	// AvailableMemoryInBytes - The available memory.
	AvailableMemoryInBytes *int64 `json:"availableMemoryInBytes,omitempty"`
	// MemoryUsageStatus - The memory usage status.
	MemoryUsageStatus *string `json:"memoryUsageStatus,omitempty"`
	// TotalSpaceInBytes - The total space.
	TotalSpaceInBytes *int64 `json:"totalSpaceInBytes,omitempty"`
	// AvailableSpaceInBytes - The available space.
	AvailableSpaceInBytes *int64 `json:"availableSpaceInBytes,omitempty"`
	// SpaceUsageStatus - The space usage status.
	SpaceUsageStatus *string `json:"spaceUsageStatus,omitempty"`
	// WebLoad - The web load.
	WebLoad *string `json:"webLoad,omitempty"`
	// WebLoadStatus - The web load status.
	WebLoadStatus *string `json:"webLoadStatus,omitempty"`
	// DatabaseServerLoad - The database server load.
	DatabaseServerLoad *string `json:"databaseServerLoad,omitempty"`
	// DatabaseServerLoadStatus - The database server load status.
	DatabaseServerLoadStatus *string `json:"databaseServerLoadStatus,omitempty"`
	// CsServiceStatus - The CS service status.
	CsServiceStatus *string `json:"csServiceStatus,omitempty"`
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// AgentVersion - The agent Version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// HostName - The host name.
	HostName *string `json:"hostName,omitempty"`
	// LastHeartbeat - The last heartbeat received from CS server.
	LastHeartbeat *date.Time `json:"lastHeartbeat,omitempty"`
	// VersionStatus - Version status
	VersionStatus *string `json:"versionStatus,omitempty"`
	// SslCertExpiryDate - CS SSL cert expiry date.
	SslCertExpiryDate *date.Time `json:"sslCertExpiryDate,omitempty"`
	// SslCertExpiryRemainingDays - CS SSL cert expiry date.
	SslCertExpiryRemainingDays *int32 `json:"sslCertExpiryRemainingDays,omitempty"`
	// PsTemplateVersion - PS template version.
	PsTemplateVersion *string `json:"psTemplateVersion,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareDetails.
func (vmd VMwareDetails) MarshalJSON() ([]byte, error) {
	vmd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware
	objectMap := make(map[string]interface{})
	if vmd.ProcessServers != nil {
		objectMap["processServers"] = vmd.ProcessServers
	}
	if vmd.MasterTargetServers != nil {
		objectMap["masterTargetServers"] = vmd.MasterTargetServers
	}
	if vmd.RunAsAccounts != nil {
		objectMap["runAsAccounts"] = vmd.RunAsAccounts
	}
	if vmd.ReplicationPairCount != nil {
		objectMap["replicationPairCount"] = vmd.ReplicationPairCount
	}
	if vmd.ProcessServerCount != nil {
		objectMap["processServerCount"] = vmd.ProcessServerCount
	}
	if vmd.AgentCount != nil {
		objectMap["agentCount"] = vmd.AgentCount
	}
	if vmd.ProtectedServers != nil {
		objectMap["protectedServers"] = vmd.ProtectedServers
	}
	if vmd.SystemLoad != nil {
		objectMap["systemLoad"] = vmd.SystemLoad
	}
	if vmd.SystemLoadStatus != nil {
		objectMap["systemLoadStatus"] = vmd.SystemLoadStatus
	}
	if vmd.CPULoad != nil {
		objectMap["cpuLoad"] = vmd.CPULoad
	}
	if vmd.CPULoadStatus != nil {
		objectMap["cpuLoadStatus"] = vmd.CPULoadStatus
	}
	if vmd.TotalMemoryInBytes != nil {
		objectMap["totalMemoryInBytes"] = vmd.TotalMemoryInBytes
	}
	if vmd.AvailableMemoryInBytes != nil {
		objectMap["availableMemoryInBytes"] = vmd.AvailableMemoryInBytes
	}
	if vmd.MemoryUsageStatus != nil {
		objectMap["memoryUsageStatus"] = vmd.MemoryUsageStatus
	}
	if vmd.TotalSpaceInBytes != nil {
		objectMap["totalSpaceInBytes"] = vmd.TotalSpaceInBytes
	}
	if vmd.AvailableSpaceInBytes != nil {
		objectMap["availableSpaceInBytes"] = vmd.AvailableSpaceInBytes
	}
	if vmd.SpaceUsageStatus != nil {
		objectMap["spaceUsageStatus"] = vmd.SpaceUsageStatus
	}
	if vmd.WebLoad != nil {
		objectMap["webLoad"] = vmd.WebLoad
	}
	if vmd.WebLoadStatus != nil {
		objectMap["webLoadStatus"] = vmd.WebLoadStatus
	}
	if vmd.DatabaseServerLoad != nil {
		objectMap["databaseServerLoad"] = vmd.DatabaseServerLoad
	}
	if vmd.DatabaseServerLoadStatus != nil {
		objectMap["databaseServerLoadStatus"] = vmd.DatabaseServerLoadStatus
	}
	if vmd.CsServiceStatus != nil {
		objectMap["csServiceStatus"] = vmd.CsServiceStatus
	}
	if vmd.IPAddress != nil {
		objectMap["ipAddress"] = vmd.IPAddress
	}
	if vmd.AgentVersion != nil {
		objectMap["agentVersion"] = vmd.AgentVersion
	}
	if vmd.HostName != nil {
		objectMap["hostName"] = vmd.HostName
	}
	if vmd.LastHeartbeat != nil {
		objectMap["lastHeartbeat"] = vmd.LastHeartbeat
	}
	if vmd.VersionStatus != nil {
		objectMap["versionStatus"] = vmd.VersionStatus
	}
	if vmd.SslCertExpiryDate != nil {
		objectMap["sslCertExpiryDate"] = vmd.SslCertExpiryDate
	}
	if vmd.SslCertExpiryRemainingDays != nil {
		objectMap["sslCertExpiryRemainingDays"] = vmd.SslCertExpiryRemainingDays
	}
	if vmd.PsTemplateVersion != nil {
		objectMap["psTemplateVersion"] = vmd.PsTemplateVersion
	}
	if vmd.InstanceType != "" {
		objectMap["instanceType"] = vmd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return &vmd, true
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &vmd, true
}

// VMwareV2FabricCreationInput fabric provider specific settings.
type VMwareV2FabricCreationInput struct {
	// InstanceType - Possible values include: 'InstanceTypeFabricSpecificCreationInput', 'InstanceTypeAzure', 'InstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) MarshalJSON() ([]byte, error) {
	vmvfci.InstanceType = InstanceTypeVMwareV2
	objectMap := make(map[string]interface{})
	if vmvfci.InstanceType != "" {
		objectMap["instanceType"] = vmvfci.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricCreationInput is the BasicFabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return nil, false
}

// AsVMwareV2FabricCreationInput is the BasicFabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return &vmvfci, true
}

// AsFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsFabricSpecificCreationInput() (*FabricSpecificCreationInput, bool) {
	return nil, false
}

// AsBasicFabricSpecificCreationInput is the BasicFabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsBasicFabricSpecificCreationInput() (BasicFabricSpecificCreationInput, bool) {
	return &vmvfci, true
}

// VMwareV2FabricSpecificDetails vMwareV2 fabric Specific Details.
type VMwareV2FabricSpecificDetails struct {
	// SrsServiceEndpoint - The endpoint for making requests to the SRS Service.
	SrsServiceEndpoint *string `json:"srsServiceEndpoint,omitempty"`
	// RcmServiceEndpoint - The endpoint for making requests to the RCM Service.
	RcmServiceEndpoint *string `json:"rcmServiceEndpoint,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware', 'InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2'
	InstanceType InstanceTypeBasicFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	vmvfsd.InstanceType = InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2
	objectMap := make(map[string]interface{})
	if vmvfsd.SrsServiceEndpoint != nil {
		objectMap["srsServiceEndpoint"] = vmvfsd.SrsServiceEndpoint
	}
	if vmvfsd.RcmServiceEndpoint != nil {
		objectMap["rcmServiceEndpoint"] = vmvfsd.RcmServiceEndpoint
	}
	if vmvfsd.InstanceType != "" {
		objectMap["instanceType"] = vmvfsd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsAzureFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return &vmvfsd, true
}

// AsFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsFabricSpecificDetails() (*FabricSpecificDetails, bool) {
	return nil, false
}

// AsBasicFabricSpecificDetails is the BasicFabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsBasicFabricSpecificDetails() (BasicFabricSpecificDetails, bool) {
	return &vmvfsd, true
}

// VMwareVirtualMachineDetails vMware provider specific settings
type VMwareVirtualMachineDetails struct {
	// AgentGeneratedID - The ID generated by the InMage agent after it gets installed on guest. This is the ID to be used during InMage CreateProtection.
	AgentGeneratedID *string `json:"agentGeneratedId,omitempty"`
	// AgentInstalled - The value indicating if InMage scout agent is installed on guest.
	AgentInstalled *string `json:"agentInstalled,omitempty"`
	// OsType - The OsType installed on VM.
	OsType *string `json:"osType,omitempty"`
	// AgentVersion - The agent version.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// IPAddress - The IP address.
	IPAddress *string `json:"ipAddress,omitempty"`
	// PoweredOn - The value indicating whether VM is powered on.
	PoweredOn *string `json:"poweredOn,omitempty"`
	// VCenterInfrastructureID - The VCenter infrastructure Id.
	VCenterInfrastructureID *string `json:"vCenterInfrastructureId,omitempty"`
	// DiscoveryType - A value inidicating the discovery type of the machine. Value can be vCenter or physical.
	DiscoveryType *string `json:"discoveryType,omitempty"`
	// DiskDetails - The disk details.
	DiskDetails *[]InMageDiskDetails `json:"diskDetails,omitempty"`
	// ValidationErrors - The validation errors.
	ValidationErrors *[]HealthError `json:"validationErrors,omitempty"`
	// InstanceType - Possible values include: 'InstanceTypeConfigurationSettings', 'InstanceTypeHyperVVirtualMachine', 'InstanceTypeVMwareVirtualMachine', 'InstanceTypeReplicationGroupDetails'
	InstanceType InstanceTypeBasicConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	vmvmd.InstanceType = InstanceTypeVMwareVirtualMachine
	objectMap := make(map[string]interface{})
	if vmvmd.AgentGeneratedID != nil {
		objectMap["agentGeneratedId"] = vmvmd.AgentGeneratedID
	}
	if vmvmd.AgentInstalled != nil {
		objectMap["agentInstalled"] = vmvmd.AgentInstalled
	}
	if vmvmd.OsType != nil {
		objectMap["osType"] = vmvmd.OsType
	}
	if vmvmd.AgentVersion != nil {
		objectMap["agentVersion"] = vmvmd.AgentVersion
	}
	if vmvmd.IPAddress != nil {
		objectMap["ipAddress"] = vmvmd.IPAddress
	}
	if vmvmd.PoweredOn != nil {
		objectMap["poweredOn"] = vmvmd.PoweredOn
	}
	if vmvmd.VCenterInfrastructureID != nil {
		objectMap["vCenterInfrastructureId"] = vmvmd.VCenterInfrastructureID
	}
	if vmvmd.DiscoveryType != nil {
		objectMap["discoveryType"] = vmvmd.DiscoveryType
	}
	if vmvmd.DiskDetails != nil {
		objectMap["diskDetails"] = vmvmd.DiskDetails
	}
	if vmvmd.ValidationErrors != nil {
		objectMap["validationErrors"] = vmvmd.ValidationErrors
	}
	if vmvmd.InstanceType != "" {
		objectMap["instanceType"] = vmvmd.InstanceType
	}
	return json.Marshal(objectMap)
}

// AsHyperVVirtualMachineDetails is the BasicConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the BasicConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return &vmvmd, true
}

// AsReplicationGroupDetails is the BasicConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// AsConfigurationSettings is the BasicConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsConfigurationSettings() (*ConfigurationSettings, bool) {
	return nil, false
}

// AsBasicConfigurationSettings is the BasicConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsBasicConfigurationSettings() (BasicConfigurationSettings, bool) {
	return &vmvmd, true
}
