package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventTypeEnum enumerates the values for event type enum.
type EventTypeEnum string

const (
	// All ...
	All EventTypeEnum = "$all"
	// AvailabilityResults ...
	AvailabilityResults EventTypeEnum = "availabilityResults"
	// BrowserTimings ...
	BrowserTimings EventTypeEnum = "browserTimings"
	// CustomEvents ...
	CustomEvents EventTypeEnum = "customEvents"
	// CustomMetrics ...
	CustomMetrics EventTypeEnum = "customMetrics"
	// Dependencies ...
	Dependencies EventTypeEnum = "dependencies"
	// Exceptions ...
	Exceptions EventTypeEnum = "exceptions"
	// PageViews ...
	PageViews EventTypeEnum = "pageViews"
	// PerformanceCounters ...
	PerformanceCounters EventTypeEnum = "performanceCounters"
	// Requests ...
	Requests EventTypeEnum = "requests"
	// Traces ...
	Traces EventTypeEnum = "traces"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricIDEnum enumerates the values for metric id enum.
type MetricIDEnum string

const (
	// AvailabilityResultsavailabilityPercentage ...
	AvailabilityResultsavailabilityPercentage MetricIDEnum = "availabilityResults/availabilityPercentage"
	// AvailabilityResultsduration ...
	AvailabilityResultsduration MetricIDEnum = "availabilityResults/duration"
	// BillingtelemetryCount ...
	BillingtelemetryCount MetricIDEnum = "billing/telemetryCount"
	// ClientnetworkDuration ...
	ClientnetworkDuration MetricIDEnum = "client/networkDuration"
	// ClientprocessingDuration ...
	ClientprocessingDuration MetricIDEnum = "client/processingDuration"
	// ClientreceiveDuration ...
	ClientreceiveDuration MetricIDEnum = "client/receiveDuration"
	// ClientsendDuration ...
	ClientsendDuration MetricIDEnum = "client/sendDuration"
	// ClienttotalDuration ...
	ClienttotalDuration MetricIDEnum = "client/totalDuration"
	// CustomEventscount ...
	CustomEventscount MetricIDEnum = "customEvents/count"
	// Dependenciescount ...
	Dependenciescount MetricIDEnum = "dependencies/count"
	// Dependenciesduration ...
	Dependenciesduration MetricIDEnum = "dependencies/duration"
	// Dependenciesfailed ...
	Dependenciesfailed MetricIDEnum = "dependencies/failed"
	// Exceptionsbrowser ...
	Exceptionsbrowser MetricIDEnum = "exceptions/browser"
	// Exceptionscount ...
	Exceptionscount MetricIDEnum = "exceptions/count"
	// Exceptionsserver ...
	Exceptionsserver MetricIDEnum = "exceptions/server"
	// PageViewscount ...
	PageViewscount MetricIDEnum = "pageViews/count"
	// PageViewsduration ...
	PageViewsduration MetricIDEnum = "pageViews/duration"
	// PerformanceCountersexceptionsPerSecond ...
	PerformanceCountersexceptionsPerSecond MetricIDEnum = "performanceCounters/exceptionsPerSecond"
	// PerformanceCountersmemoryAvailableBytes ...
	PerformanceCountersmemoryAvailableBytes MetricIDEnum = "performanceCounters/memoryAvailableBytes"
	// PerformanceCountersprocessCPUPercentage ...
	PerformanceCountersprocessCPUPercentage MetricIDEnum = "performanceCounters/processCpuPercentage"
	// PerformanceCountersprocessIOBytesPerSecond ...
	PerformanceCountersprocessIOBytesPerSecond MetricIDEnum = "performanceCounters/processIOBytesPerSecond"
	// PerformanceCountersprocessorCPUPercentage ...
	PerformanceCountersprocessorCPUPercentage MetricIDEnum = "performanceCounters/processorCpuPercentage"
	// PerformanceCountersprocessPrivateBytes ...
	PerformanceCountersprocessPrivateBytes MetricIDEnum = "performanceCounters/processPrivateBytes"
	// PerformanceCountersrequestExecutionTime ...
	PerformanceCountersrequestExecutionTime MetricIDEnum = "performanceCounters/requestExecutionTime"
	// PerformanceCountersrequestsInQueue ...
	PerformanceCountersrequestsInQueue MetricIDEnum = "performanceCounters/requestsInQueue"
	// PerformanceCountersrequestsPerSecond ...
	PerformanceCountersrequestsPerSecond MetricIDEnum = "performanceCounters/requestsPerSecond"
	// Requestscount ...
	Requestscount MetricIDEnum = "requests/count"
	// Requestsduration ...
	Requestsduration MetricIDEnum = "requests/duration"
	// Requestsfailed ...
	Requestsfailed MetricIDEnum = "requests/failed"
	// Sessionscount ...
	Sessionscount MetricIDEnum = "sessions/count"
	// Usersauthenticated ...
	Usersauthenticated MetricIDEnum = "users/authenticated"
	// Userscount ...
	Userscount MetricIDEnum = "users/count"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// TypeEnum enumerates the values for type enum.
type TypeEnum string

const (
	// TypeAvailabilityResult ...
	TypeAvailabilityResult TypeEnum = "availabilityResult"
	// TypeBrowserTiming ...
	TypeBrowserTiming TypeEnum = "browserTiming"
	// TypeCustomEvent ...
	TypeCustomEvent TypeEnum = "customEvent"
	// TypeCustomMetric ...
	TypeCustomMetric TypeEnum = "customMetric"
	// TypeDependency ...
	TypeDependency TypeEnum = "dependency"
	// TypeEventsResultData ...
	TypeEventsResultData TypeEnum = "eventsResultData"
	// TypeException ...
	TypeException TypeEnum = "exception"
	// TypePageView ...
	TypePageView TypeEnum = "pageView"
	// TypePerformanceCounter ...
	TypePerformanceCounter TypeEnum = "performanceCounter"
	// TypeRequest ...
	TypeRequest TypeEnum = "request"
	// TypeTrace ...
	TypeTrace TypeEnum = "trace"
)

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// ColumnType a column in a table.
type ColumnType struct {
	// Name - The name of this column.
	Name *string `json:"name,omitempty"`
	// Type - The data type of this column.
	Type *string `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// ErrorDetailType ...
type ErrorDetailType struct {
	// Code - The error's code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Value - Indicates which value in 'target' is responsible for the error.
	Value *string `json:"value,omitempty"`
	// Resources - Indicates resources which were responsible for the error.
	Resources            *[]string   `json:"resources,omitempty"`
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// ErrorInfoType ...
type ErrorInfoType struct {
	// Code - A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Details - error details.
	Details *[]ErrorDetailType `json:"details,omitempty"`
	// Innererror - Inner error details if they exist.
	Innererror           *ErrorInfoType `json:"innererror,omitempty"`
	AdditionalProperties interface{}    `json:"additionalProperties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// ErrorResponseType contains details when the response code indicates an error.
type ErrorResponseType struct {
	// Error - The error details.
	Error *ErrorInfoType `json:"error,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsAiInfoType AI related application info for an event result
type EventsAiInfoType struct {
	// IKey - iKey of the app
	IKey *string `json:"iKey,omitempty"`
	// AppName - Name of the application
	AppName *string `json:"appName,omitempty"`
	// AppID - ID of the application
	AppID *string `json:"appId,omitempty"`
	// SdkVersion - SDK version of the application
	SdkVersion *string `json:"sdkVersion,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsApplicationInfoType application info for an event result
type EventsApplicationInfoType struct {
	// Version - Version of the application
	Version *string `json:"version,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsAvailabilityResultInfoType the availability result info
type EventsAvailabilityResultInfoType struct {
	// Name - The name of the availability result
	Name *string `json:"name,omitempty"`
	// Success - Indicates if the availability result was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the availability result
	Duration *int64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the availability result
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// Message - The message of the availability result
	Message *string `json:"message,omitempty"`
	// Location - The location of the availability result
	Location *string `json:"location,omitempty"`
	// ID - The ID of the availability result
	ID *string `json:"id,omitempty"`
	// Size - The size of the availability result
	Size *string `json:"size,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsAvailabilityResultResultType an availability result result
type EventsAvailabilityResultResultType struct {
	AvailabilityResult *EventsAvailabilityResultInfoType `json:"availabilityResult,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) MarshalJSON() ([]byte, error) {
	earrt.Type = TypeAvailabilityResult
	objectMap := make(map[string]interface{})
	if earrt.AvailabilityResult != nil {
		objectMap["availabilityResult"] = earrt.AvailabilityResult
	}
	if earrt.ID != nil {
		objectMap["id"] = earrt.ID
	}
	if earrt.Count != nil {
		objectMap["count"] = earrt.Count
	}
	if earrt.Timestamp != nil {
		objectMap["timestamp"] = earrt.Timestamp
	}
	if earrt.CustomDimensions != nil {
		objectMap["customDimensions"] = earrt.CustomDimensions
	}
	if earrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = earrt.CustomMeasurements
	}
	if earrt.Operation != nil {
		objectMap["operation"] = earrt.Operation
	}
	if earrt.Session != nil {
		objectMap["session"] = earrt.Session
	}
	if earrt.User != nil {
		objectMap["user"] = earrt.User
	}
	if earrt.Cloud != nil {
		objectMap["cloud"] = earrt.Cloud
	}
	if earrt.Ai != nil {
		objectMap["ai"] = earrt.Ai
	}
	if earrt.Application != nil {
		objectMap["application"] = earrt.Application
	}
	if earrt.Client != nil {
		objectMap["client"] = earrt.Client
	}
	objectMap["type"] = earrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return &earrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsAvailabilityResultResultType.
func (earrt EventsAvailabilityResultResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &earrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsBrowserTimingInfoType the browser timing information
type EventsBrowserTimingInfoType struct {
	// URLPath - The path of the URL
	URLPath *string `json:"urlPath,omitempty"`
	// URLHost - The host of the URL
	URLHost *string `json:"urlHost,omitempty"`
	// Name - The name of the page
	Name *string `json:"name,omitempty"`
	// URL - The url of the page
	URL *string `json:"url,omitempty"`
	// TotalDuration - The total duration of the load
	TotalDuration *int64 `json:"totalDuration,omitempty"`
	// PerformanceBucket - The performance bucket of the load
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// NetworkDuration - The network duration of the load
	NetworkDuration *int64 `json:"networkDuration,omitempty"`
	// SendDuration - The send duration of the load
	SendDuration *int64 `json:"sendDuration,omitempty"`
	// ReceiveDuration - The receive duration of the load
	ReceiveDuration *int64 `json:"receiveDuration,omitempty"`
	// ProcessingDuration - The processing duration of the load
	ProcessingDuration *int64 `json:"processingDuration,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsBrowserTimingResultType a browser timing result
type EventsBrowserTimingResultType struct {
	BrowserTiming     *EventsBrowserTimingInfoType     `json:"browserTiming,omitempty"`
	ClientPerformance *EventsClientPerformanceInfoType `json:"clientPerformance,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) MarshalJSON() ([]byte, error) {
	ebtrt.Type = TypeBrowserTiming
	objectMap := make(map[string]interface{})
	if ebtrt.BrowserTiming != nil {
		objectMap["browserTiming"] = ebtrt.BrowserTiming
	}
	if ebtrt.ClientPerformance != nil {
		objectMap["clientPerformance"] = ebtrt.ClientPerformance
	}
	if ebtrt.ID != nil {
		objectMap["id"] = ebtrt.ID
	}
	if ebtrt.Count != nil {
		objectMap["count"] = ebtrt.Count
	}
	if ebtrt.Timestamp != nil {
		objectMap["timestamp"] = ebtrt.Timestamp
	}
	if ebtrt.CustomDimensions != nil {
		objectMap["customDimensions"] = ebtrt.CustomDimensions
	}
	if ebtrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ebtrt.CustomMeasurements
	}
	if ebtrt.Operation != nil {
		objectMap["operation"] = ebtrt.Operation
	}
	if ebtrt.Session != nil {
		objectMap["session"] = ebtrt.Session
	}
	if ebtrt.User != nil {
		objectMap["user"] = ebtrt.User
	}
	if ebtrt.Cloud != nil {
		objectMap["cloud"] = ebtrt.Cloud
	}
	if ebtrt.Ai != nil {
		objectMap["ai"] = ebtrt.Ai
	}
	if ebtrt.Application != nil {
		objectMap["application"] = ebtrt.Application
	}
	if ebtrt.Client != nil {
		objectMap["client"] = ebtrt.Client
	}
	objectMap["type"] = ebtrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return &ebtrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsBrowserTimingResultType.
func (ebtrt EventsBrowserTimingResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &ebtrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsClientInfoType client info for an event result
type EventsClientInfoType struct {
	// Model - Model of the client
	Model *string `json:"model,omitempty"`
	// Os - Operating system of the client
	Os *string `json:"os,omitempty"`
	// Type - Type of the client
	Type *string `json:"type,omitempty"`
	// Browser - Browser of the client
	Browser *string `json:"browser,omitempty"`
	// IP - IP address of the client
	IP *string `json:"ip,omitempty"`
	// City - City of the client
	City *string `json:"city,omitempty"`
	// StateOrProvince - State or province of the client
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// CountryOrRegion - Country or region of the client
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsClientPerformanceInfoType client performance information
type EventsClientPerformanceInfoType struct {
	// Name - The name of the client performance
	Name *string `json:"name,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsCloudInfoType cloud info for an event result
type EventsCloudInfoType struct {
	// RoleName - Role name of the cloud
	RoleName *string `json:"roleName,omitempty"`
	// RoleInstance - Role instance of the cloud
	RoleInstance *string `json:"roleInstance,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsCustomEventInfoType the custom event information
type EventsCustomEventInfoType struct {
	// Name - The name of the custom event
	Name *string `json:"name,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsCustomEventResultType a custom event result
type EventsCustomEventResultType struct {
	CustomEvent *EventsCustomEventInfoType `json:"customEvent,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) MarshalJSON() ([]byte, error) {
	ecert.Type = TypeCustomEvent
	objectMap := make(map[string]interface{})
	if ecert.CustomEvent != nil {
		objectMap["customEvent"] = ecert.CustomEvent
	}
	if ecert.ID != nil {
		objectMap["id"] = ecert.ID
	}
	if ecert.Count != nil {
		objectMap["count"] = ecert.Count
	}
	if ecert.Timestamp != nil {
		objectMap["timestamp"] = ecert.Timestamp
	}
	if ecert.CustomDimensions != nil {
		objectMap["customDimensions"] = ecert.CustomDimensions
	}
	if ecert.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ecert.CustomMeasurements
	}
	if ecert.Operation != nil {
		objectMap["operation"] = ecert.Operation
	}
	if ecert.Session != nil {
		objectMap["session"] = ecert.Session
	}
	if ecert.User != nil {
		objectMap["user"] = ecert.User
	}
	if ecert.Cloud != nil {
		objectMap["cloud"] = ecert.Cloud
	}
	if ecert.Ai != nil {
		objectMap["ai"] = ecert.Ai
	}
	if ecert.Application != nil {
		objectMap["application"] = ecert.Application
	}
	if ecert.Client != nil {
		objectMap["client"] = ecert.Client
	}
	objectMap["type"] = ecert.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return &ecert, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsCustomEventResultType.
func (ecert EventsCustomEventResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &ecert, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsCustomMetricInfoType the custom metric info
type EventsCustomMetricInfoType struct {
	// Name - The name of the custom metric
	Name *string `json:"name,omitempty"`
	// Value - The value of the custom metric
	Value *float64 `json:"value,omitempty"`
	// ValueSum - The sum of the custom metric
	ValueSum *float64 `json:"valueSum,omitempty"`
	// ValueCount - The count of the custom metric
	ValueCount *float64 `json:"valueCount,omitempty"`
	// ValueMin - The minimum value of the custom metric
	ValueMin *float64 `json:"valueMin,omitempty"`
	// ValueMax - The maximum value of the custom metric
	ValueMax *float64 `json:"valueMax,omitempty"`
	// ValueStdDev - The standard deviation of the custom metric
	ValueStdDev *float64 `json:"valueStdDev,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsCustomMetricResultType a custom metric result
type EventsCustomMetricResultType struct {
	CustomMetric *EventsCustomMetricInfoType `json:"customMetric,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) MarshalJSON() ([]byte, error) {
	ecmrt.Type = TypeCustomMetric
	objectMap := make(map[string]interface{})
	if ecmrt.CustomMetric != nil {
		objectMap["customMetric"] = ecmrt.CustomMetric
	}
	if ecmrt.ID != nil {
		objectMap["id"] = ecmrt.ID
	}
	if ecmrt.Count != nil {
		objectMap["count"] = ecmrt.Count
	}
	if ecmrt.Timestamp != nil {
		objectMap["timestamp"] = ecmrt.Timestamp
	}
	if ecmrt.CustomDimensions != nil {
		objectMap["customDimensions"] = ecmrt.CustomDimensions
	}
	if ecmrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = ecmrt.CustomMeasurements
	}
	if ecmrt.Operation != nil {
		objectMap["operation"] = ecmrt.Operation
	}
	if ecmrt.Session != nil {
		objectMap["session"] = ecmrt.Session
	}
	if ecmrt.User != nil {
		objectMap["user"] = ecmrt.User
	}
	if ecmrt.Cloud != nil {
		objectMap["cloud"] = ecmrt.Cloud
	}
	if ecmrt.Ai != nil {
		objectMap["ai"] = ecmrt.Ai
	}
	if ecmrt.Application != nil {
		objectMap["application"] = ecmrt.Application
	}
	if ecmrt.Client != nil {
		objectMap["client"] = ecmrt.Client
	}
	objectMap["type"] = ecmrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return &ecmrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsCustomMetricResultType.
func (ecmrt EventsCustomMetricResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &ecmrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsDependencyInfoType the dependency info
type EventsDependencyInfoType struct {
	// Target - The target of the dependency
	Target *string `json:"target,omitempty"`
	// Data - The data of the dependency
	Data *string `json:"data,omitempty"`
	// Success - Indicates if the dependency was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the dependency
	Duration *int64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the dependency
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// ResultCode - The result code of the dependency
	ResultCode *string `json:"resultCode,omitempty"`
	// Type - The type of the dependency
	Type *string `json:"type,omitempty"`
	// Name - The name of the dependency
	Name *string `json:"name,omitempty"`
	// ID - The ID of the dependency
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsDependencyResultType a dependency result
type EventsDependencyResultType struct {
	Dependency *EventsDependencyInfoType `json:"dependency,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsDependencyResultType.
func (edrt EventsDependencyResultType) MarshalJSON() ([]byte, error) {
	edrt.Type = TypeDependency
	objectMap := make(map[string]interface{})
	if edrt.Dependency != nil {
		objectMap["dependency"] = edrt.Dependency
	}
	if edrt.ID != nil {
		objectMap["id"] = edrt.ID
	}
	if edrt.Count != nil {
		objectMap["count"] = edrt.Count
	}
	if edrt.Timestamp != nil {
		objectMap["timestamp"] = edrt.Timestamp
	}
	if edrt.CustomDimensions != nil {
		objectMap["customDimensions"] = edrt.CustomDimensions
	}
	if edrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = edrt.CustomMeasurements
	}
	if edrt.Operation != nil {
		objectMap["operation"] = edrt.Operation
	}
	if edrt.Session != nil {
		objectMap["session"] = edrt.Session
	}
	if edrt.User != nil {
		objectMap["user"] = edrt.User
	}
	if edrt.Cloud != nil {
		objectMap["cloud"] = edrt.Cloud
	}
	if edrt.Ai != nil {
		objectMap["ai"] = edrt.Ai
	}
	if edrt.Application != nil {
		objectMap["application"] = edrt.Application
	}
	if edrt.Client != nil {
		objectMap["client"] = edrt.Client
	}
	objectMap["type"] = edrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return &edrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsDependencyResultType.
func (edrt EventsDependencyResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &edrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsExceptionDetailsParsedStackType a parsed stack entry
type EventsExceptionDetailsParsedStackType struct {
	// Assembly - The assembly of the stack entry
	Assembly *string `json:"assembly,omitempty"`
	// Method - The method of the stack entry
	Method *string `json:"method,omitempty"`
	// Level - The level of the stack entry
	Level *int64 `json:"level,omitempty"`
	// Line - The line of the stack entry
	Line *int64 `json:"line,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsExceptionDetailType exception details
type EventsExceptionDetailType struct {
	// SeverityLevel - The severity level of the exception detail
	SeverityLevel *string `json:"severityLevel,omitempty"`
	// OuterID - The outer ID of the exception detail
	OuterID *string `json:"outerId,omitempty"`
	// Message - The message of the exception detail
	Message *string `json:"message,omitempty"`
	// Type - The type of the exception detail
	Type *string `json:"type,omitempty"`
	// ID - The ID of the exception detail
	ID *string `json:"id,omitempty"`
	// ParsedStack - The parsed stack
	ParsedStack *[]EventsExceptionDetailsParsedStackType `json:"parsedStack,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsExceptionInfoType the exception info
type EventsExceptionInfoType struct {
	// SeverityLevel - The severity level of the exception
	SeverityLevel *int32 `json:"severityLevel,omitempty"`
	// ProblemID - The problem ID of the exception
	ProblemID *string `json:"problemId,omitempty"`
	// HandledAt - Indicates where the exception was handled at
	HandledAt *string `json:"handledAt,omitempty"`
	// Assembly - The assembly which threw the exception
	Assembly *string `json:"assembly,omitempty"`
	// Method - The method that threw the exception
	Method *string `json:"method,omitempty"`
	// Message - The message of the exception
	Message *string `json:"message,omitempty"`
	// Type - The type of the exception
	Type *string `json:"type,omitempty"`
	// OuterType - The outer type of the exception
	OuterType *string `json:"outerType,omitempty"`
	// OuterMethod - The outer method of the exception
	OuterMethod *string `json:"outerMethod,omitempty"`
	// OuterAssembly - The outer assmebly of the exception
	OuterAssembly *string `json:"outerAssembly,omitempty"`
	// OuterMessage - The outer message of the exception
	OuterMessage *string `json:"outerMessage,omitempty"`
	// InnermostType - The inner most type of the exception
	InnermostType *string `json:"innermostType,omitempty"`
	// InnermostMessage - The inner most message of the exception
	InnermostMessage *string `json:"innermostMessage,omitempty"`
	// InnermostMethod - The inner most method of the exception
	InnermostMethod *string `json:"innermostMethod,omitempty"`
	// InnermostAssembly - The inner most assembly of the exception
	InnermostAssembly *string `json:"innermostAssembly,omitempty"`
	// Details - The details of the exception
	Details *[]EventsExceptionDetailType `json:"details,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsExceptionResultType an exception result
type EventsExceptionResultType struct {
	Exception *EventsExceptionInfoType `json:"exception,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsExceptionResultType.
func (eert EventsExceptionResultType) MarshalJSON() ([]byte, error) {
	eert.Type = TypeException
	objectMap := make(map[string]interface{})
	if eert.Exception != nil {
		objectMap["exception"] = eert.Exception
	}
	if eert.ID != nil {
		objectMap["id"] = eert.ID
	}
	if eert.Count != nil {
		objectMap["count"] = eert.Count
	}
	if eert.Timestamp != nil {
		objectMap["timestamp"] = eert.Timestamp
	}
	if eert.CustomDimensions != nil {
		objectMap["customDimensions"] = eert.CustomDimensions
	}
	if eert.CustomMeasurements != nil {
		objectMap["customMeasurements"] = eert.CustomMeasurements
	}
	if eert.Operation != nil {
		objectMap["operation"] = eert.Operation
	}
	if eert.Session != nil {
		objectMap["session"] = eert.Session
	}
	if eert.User != nil {
		objectMap["user"] = eert.User
	}
	if eert.Cloud != nil {
		objectMap["cloud"] = eert.Cloud
	}
	if eert.Ai != nil {
		objectMap["ai"] = eert.Ai
	}
	if eert.Application != nil {
		objectMap["application"] = eert.Application
	}
	if eert.Client != nil {
		objectMap["client"] = eert.Client
	}
	objectMap["type"] = eert.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return &eert, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsExceptionResultType.
func (eert EventsExceptionResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &eert, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsOperationInfoType operation info for an event result
type EventsOperationInfoType struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// ID - ID of the operation
	ID *string `json:"id,omitempty"`
	// ParentID - Parent ID of the operation
	ParentID *string `json:"parentId,omitempty"`
	// SyntheticSource - Synthetic source of the operation
	SyntheticSource *string `json:"syntheticSource,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsPageViewInfoType the page view information
type EventsPageViewInfoType struct {
	// Name - The name of the page
	Name *string `json:"name,omitempty"`
	// URL - The URL of the page
	URL *string `json:"url,omitempty"`
	// Duration - The duration of the page view
	Duration *string `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the page view
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsPageViewResultType a page view result
type EventsPageViewResultType struct {
	PageView *EventsPageViewInfoType `json:"pageView,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) MarshalJSON() ([]byte, error) {
	epvrt.Type = TypePageView
	objectMap := make(map[string]interface{})
	if epvrt.PageView != nil {
		objectMap["pageView"] = epvrt.PageView
	}
	if epvrt.ID != nil {
		objectMap["id"] = epvrt.ID
	}
	if epvrt.Count != nil {
		objectMap["count"] = epvrt.Count
	}
	if epvrt.Timestamp != nil {
		objectMap["timestamp"] = epvrt.Timestamp
	}
	if epvrt.CustomDimensions != nil {
		objectMap["customDimensions"] = epvrt.CustomDimensions
	}
	if epvrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = epvrt.CustomMeasurements
	}
	if epvrt.Operation != nil {
		objectMap["operation"] = epvrt.Operation
	}
	if epvrt.Session != nil {
		objectMap["session"] = epvrt.Session
	}
	if epvrt.User != nil {
		objectMap["user"] = epvrt.User
	}
	if epvrt.Cloud != nil {
		objectMap["cloud"] = epvrt.Cloud
	}
	if epvrt.Ai != nil {
		objectMap["ai"] = epvrt.Ai
	}
	if epvrt.Application != nil {
		objectMap["application"] = epvrt.Application
	}
	if epvrt.Client != nil {
		objectMap["client"] = epvrt.Client
	}
	objectMap["type"] = epvrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return &epvrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsPageViewResultType.
func (epvrt EventsPageViewResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &epvrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsPerformanceCounterInfoType the performance counter info
type EventsPerformanceCounterInfoType struct {
	// Value - The value of the performance counter
	Value *int64 `json:"value,omitempty"`
	// Name - The name of the performance counter
	Name *string `json:"name,omitempty"`
	// Category - The category of the performance counter
	Category *string `json:"category,omitempty"`
	// Counter - The counter of the performance counter
	Counter *string `json:"counter,omitempty"`
	// InstanceName - The instance name of the performance counter
	InstanceName *string `json:"instanceName,omitempty"`
	// Instance - The instance of the performance counter
	Instance *string `json:"instance,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsPerformanceCounterResultType a performance counter result
type EventsPerformanceCounterResultType struct {
	PerformanceCounter *EventsPerformanceCounterInfoType `json:"performanceCounter,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) MarshalJSON() ([]byte, error) {
	epcrt.Type = TypePerformanceCounter
	objectMap := make(map[string]interface{})
	if epcrt.PerformanceCounter != nil {
		objectMap["performanceCounter"] = epcrt.PerformanceCounter
	}
	if epcrt.ID != nil {
		objectMap["id"] = epcrt.ID
	}
	if epcrt.Count != nil {
		objectMap["count"] = epcrt.Count
	}
	if epcrt.Timestamp != nil {
		objectMap["timestamp"] = epcrt.Timestamp
	}
	if epcrt.CustomDimensions != nil {
		objectMap["customDimensions"] = epcrt.CustomDimensions
	}
	if epcrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = epcrt.CustomMeasurements
	}
	if epcrt.Operation != nil {
		objectMap["operation"] = epcrt.Operation
	}
	if epcrt.Session != nil {
		objectMap["session"] = epcrt.Session
	}
	if epcrt.User != nil {
		objectMap["user"] = epcrt.User
	}
	if epcrt.Cloud != nil {
		objectMap["cloud"] = epcrt.Cloud
	}
	if epcrt.Ai != nil {
		objectMap["ai"] = epcrt.Ai
	}
	if epcrt.Application != nil {
		objectMap["application"] = epcrt.Application
	}
	if epcrt.Client != nil {
		objectMap["client"] = epcrt.Client
	}
	objectMap["type"] = epcrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return &epcrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsPerformanceCounterResultType.
func (epcrt EventsPerformanceCounterResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &epcrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsRequestInfoType the request info
type EventsRequestInfoType struct {
	// Name - The name of the request
	Name *string `json:"name,omitempty"`
	// URL - The URL of the request
	URL *string `json:"url,omitempty"`
	// Success - Indicates if the request was successful
	Success *string `json:"success,omitempty"`
	// Duration - The duration of the request
	Duration *float64 `json:"duration,omitempty"`
	// PerformanceBucket - The performance bucket of the request
	PerformanceBucket *string `json:"performanceBucket,omitempty"`
	// ResultCode - The result code of the request
	ResultCode *string `json:"resultCode,omitempty"`
	// Source - The source of the request
	Source *string `json:"source,omitempty"`
	// ID - The ID of the request
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsRequestResultType a request result
type EventsRequestResultType struct {
	Request *EventsRequestInfoType `json:"request,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsRequestResultType.
func (errt EventsRequestResultType) MarshalJSON() ([]byte, error) {
	errt.Type = TypeRequest
	objectMap := make(map[string]interface{})
	if errt.Request != nil {
		objectMap["request"] = errt.Request
	}
	if errt.ID != nil {
		objectMap["id"] = errt.ID
	}
	if errt.Count != nil {
		objectMap["count"] = errt.Count
	}
	if errt.Timestamp != nil {
		objectMap["timestamp"] = errt.Timestamp
	}
	if errt.CustomDimensions != nil {
		objectMap["customDimensions"] = errt.CustomDimensions
	}
	if errt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = errt.CustomMeasurements
	}
	if errt.Operation != nil {
		objectMap["operation"] = errt.Operation
	}
	if errt.Session != nil {
		objectMap["session"] = errt.Session
	}
	if errt.User != nil {
		objectMap["user"] = errt.User
	}
	if errt.Cloud != nil {
		objectMap["cloud"] = errt.Cloud
	}
	if errt.Ai != nil {
		objectMap["ai"] = errt.Ai
	}
	if errt.Application != nil {
		objectMap["application"] = errt.Application
	}
	if errt.Client != nil {
		objectMap["client"] = errt.Client
	}
	objectMap["type"] = errt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return &errt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsRequestResultType.
func (errt EventsRequestResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &errt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsResultDataCustomDimensionsType custom dimensions of the event
type EventsResultDataCustomDimensionsType struct {
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsResultDataCustomMeasurementsType custom measurements of the event
type EventsResultDataCustomMeasurementsType struct {
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// BasicEventsResultDataType events query result data.
type BasicEventsResultDataType interface {
	AsEventsTraceResultType() (*EventsTraceResultType, bool)
	AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool)
	AsEventsPageViewResultType() (*EventsPageViewResultType, bool)
	AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool)
	AsEventsRequestResultType() (*EventsRequestResultType, bool)
	AsEventsDependencyResultType() (*EventsDependencyResultType, bool)
	AsEventsExceptionResultType() (*EventsExceptionResultType, bool)
	AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool)
	AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool)
	AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool)
	AsEventsResultDataType() (*EventsResultDataType, bool)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsResultDataType events query result data.
type EventsResultDataType struct {
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

func unmarshalBasicEventsResultDataType(body []byte) (BasicEventsResultDataType, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeTrace):
		var etrt EventsTraceResultType
		err := json.Unmarshal(body, &etrt)
		return etrt, err
	case string(TypeCustomEvent):
		var ecert EventsCustomEventResultType
		err := json.Unmarshal(body, &ecert)
		return ecert, err
	case string(TypePageView):
		var epvrt EventsPageViewResultType
		err := json.Unmarshal(body, &epvrt)
		return epvrt, err
	case string(TypeBrowserTiming):
		var ebtrt EventsBrowserTimingResultType
		err := json.Unmarshal(body, &ebtrt)
		return ebtrt, err
	case string(TypeRequest):
		var errt EventsRequestResultType
		err := json.Unmarshal(body, &errt)
		return errt, err
	case string(TypeDependency):
		var edrt EventsDependencyResultType
		err := json.Unmarshal(body, &edrt)
		return edrt, err
	case string(TypeException):
		var eert EventsExceptionResultType
		err := json.Unmarshal(body, &eert)
		return eert, err
	case string(TypeAvailabilityResult):
		var earrt EventsAvailabilityResultResultType
		err := json.Unmarshal(body, &earrt)
		return earrt, err
	case string(TypePerformanceCounter):
		var epcrt EventsPerformanceCounterResultType
		err := json.Unmarshal(body, &epcrt)
		return epcrt, err
	case string(TypeCustomMetric):
		var ecmrt EventsCustomMetricResultType
		err := json.Unmarshal(body, &ecmrt)
		return ecmrt, err
	default:
		var erdt EventsResultDataType
		err := json.Unmarshal(body, &erdt)
		return erdt, err
	}
}
func unmarshalBasicEventsResultDataTypeArray(body []byte) ([]BasicEventsResultDataType, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	erdtArray := make([]BasicEventsResultDataType, len(rawMessages))

	for index, rawMessage := range rawMessages {
		erdt, err := unmarshalBasicEventsResultDataType(*rawMessage)
		if err != nil {
			return nil, err
		}
		erdtArray[index] = erdt
	}
	return erdtArray, nil
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsResultDataType.
func (erdt EventsResultDataType) MarshalJSON() ([]byte, error) {
	erdt.Type = TypeEventsResultData
	objectMap := make(map[string]interface{})
	if erdt.ID != nil {
		objectMap["id"] = erdt.ID
	}
	if erdt.Count != nil {
		objectMap["count"] = erdt.Count
	}
	if erdt.Timestamp != nil {
		objectMap["timestamp"] = erdt.Timestamp
	}
	if erdt.CustomDimensions != nil {
		objectMap["customDimensions"] = erdt.CustomDimensions
	}
	if erdt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = erdt.CustomMeasurements
	}
	if erdt.Operation != nil {
		objectMap["operation"] = erdt.Operation
	}
	if erdt.Session != nil {
		objectMap["session"] = erdt.Session
	}
	if erdt.User != nil {
		objectMap["user"] = erdt.User
	}
	if erdt.Cloud != nil {
		objectMap["cloud"] = erdt.Cloud
	}
	if erdt.Ai != nil {
		objectMap["ai"] = erdt.Ai
	}
	if erdt.Application != nil {
		objectMap["application"] = erdt.Application
	}
	if erdt.Client != nil {
		objectMap["client"] = erdt.Client
	}
	objectMap["type"] = erdt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return &erdt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsResultDataType.
func (erdt EventsResultDataType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &erdt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsResultsType an events query result.
type EventsResultsType struct {
	autorest.Response `json:"-"`
	// OdataContext - OData context metadata endpoint for this response
	OdataContext *string `json:"@odata.context,omitempty"`
	// AiMessages - OData messages for this response.
	AiMessages *[]ErrorInfoType `json:"@ai.messages,omitempty"`
	// Value - Contents of the events query result.
	Value *[]BasicEventsResultDataType `json:"value,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// UnmarshalJSON is the custom unmarshaler for EventsResultsType struct.
func (ert *EventsResultsType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "@odata.context":
			if v != nil {
				var odataContext string
				err = json.Unmarshal(*v, &odataContext)
				if err != nil {
					return err
				}
				ert.OdataContext = &odataContext
			}
		case "@ai.messages":
			if v != nil {
				var aiMessages []ErrorInfoType
				err = json.Unmarshal(*v, &aiMessages)
				if err != nil {
					return err
				}
				ert.AiMessages = &aiMessages
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEventsResultDataTypeArray(*v)
				if err != nil {
					return err
				}
				ert.Value = &value
			}
		}
	}

	return nil
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsResultType an event query result.
type EventsResultType struct {
	// AiMessages - OData messages for this response.
	AiMessages *[]ErrorInfoType          `json:"@ai.messages,omitempty"`
	Value      BasicEventsResultDataType `json:"value,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// UnmarshalJSON is the custom unmarshaler for EventsResultType struct.
func (ert *EventsResultType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "@ai.messages":
			if v != nil {
				var aiMessages []ErrorInfoType
				err = json.Unmarshal(*v, &aiMessages)
				if err != nil {
					return err
				}
				ert.AiMessages = &aiMessages
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEventsResultDataType(*v)
				if err != nil {
					return err
				}
				ert.Value = value
			}
		}
	}

	return nil
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsSessionInfoType session info for an event result
type EventsSessionInfoType struct {
	// ID - ID of the session
	ID *string `json:"id,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsTraceInfoType the trace information
type EventsTraceInfoType struct {
	// Message - The trace message
	Message *string `json:"message,omitempty"`
	// SeverityLevel - The trace severity level
	SeverityLevel *int32 `json:"severityLevel,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsTraceResultType a trace result
type EventsTraceResultType struct {
	Trace *EventsTraceInfoType `json:"trace,omitempty"`
	// ID - The unique ID for this event.
	ID *string `json:"id,omitempty"`
	// Count - Count of the event
	Count *int64 `json:"count,omitempty"`
	// Timestamp - Timestamp of the event
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CustomDimensions - Custom dimensions of the event
	CustomDimensions *EventsResultDataCustomDimensionsType `json:"customDimensions,omitempty"`
	// CustomMeasurements - Custom measurements of the event
	CustomMeasurements *EventsResultDataCustomMeasurementsType `json:"customMeasurements,omitempty"`
	// Operation - Operation info of the event
	Operation *EventsOperationInfoType `json:"operation,omitempty"`
	// Session - Session info of the event
	Session *EventsSessionInfoType `json:"session,omitempty"`
	// User - User info of the event
	User *EventsUserInfoType `json:"user,omitempty"`
	// Cloud - Cloud info of the event
	Cloud *EventsCloudInfoType `json:"cloud,omitempty"`
	// Ai - AI info of the event
	Ai *EventsAiInfoType `json:"ai,omitempty"`
	// Application - Application info of the event
	Application *EventsApplicationInfoType `json:"application,omitempty"`
	// Client - Client info of the event
	Client *EventsClientInfoType `json:"client,omitempty"`
	// Type - Possible values include: 'TypeEventsResultData', 'TypeTrace', 'TypeCustomEvent', 'TypePageView', 'TypeBrowserTiming', 'TypeRequest', 'TypeDependency', 'TypeException', 'TypeAvailabilityResult', 'TypePerformanceCounter', 'TypeCustomMetric'
	Type TypeEnum `json:"type,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for EventsTraceResultType.
func (etrt EventsTraceResultType) MarshalJSON() ([]byte, error) {
	etrt.Type = TypeTrace
	objectMap := make(map[string]interface{})
	if etrt.Trace != nil {
		objectMap["trace"] = etrt.Trace
	}
	if etrt.ID != nil {
		objectMap["id"] = etrt.ID
	}
	if etrt.Count != nil {
		objectMap["count"] = etrt.Count
	}
	if etrt.Timestamp != nil {
		objectMap["timestamp"] = etrt.Timestamp
	}
	if etrt.CustomDimensions != nil {
		objectMap["customDimensions"] = etrt.CustomDimensions
	}
	if etrt.CustomMeasurements != nil {
		objectMap["customMeasurements"] = etrt.CustomMeasurements
	}
	if etrt.Operation != nil {
		objectMap["operation"] = etrt.Operation
	}
	if etrt.Session != nil {
		objectMap["session"] = etrt.Session
	}
	if etrt.User != nil {
		objectMap["user"] = etrt.User
	}
	if etrt.Cloud != nil {
		objectMap["cloud"] = etrt.Cloud
	}
	if etrt.Ai != nil {
		objectMap["ai"] = etrt.Ai
	}
	if etrt.Application != nil {
		objectMap["application"] = etrt.Application
	}
	if etrt.Client != nil {
		objectMap["client"] = etrt.Client
	}
	objectMap["type"] = etrt.Type
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsTraceResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsTraceResultType() (*EventsTraceResultType, bool) {
	return &etrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomEventResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsCustomEventResultType() (*EventsCustomEventResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPageViewResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsPageViewResultType() (*EventsPageViewResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsBrowserTimingResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsBrowserTimingResultType() (*EventsBrowserTimingResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsRequestResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsRequestResultType() (*EventsRequestResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsDependencyResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsDependencyResultType() (*EventsDependencyResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsExceptionResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsExceptionResultType() (*EventsExceptionResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsAvailabilityResultResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsAvailabilityResultResultType() (*EventsAvailabilityResultResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsPerformanceCounterResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsPerformanceCounterResultType() (*EventsPerformanceCounterResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsCustomMetricResultType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsCustomMetricResultType() (*EventsCustomMetricResultType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsEventsResultDataType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsEventsResultDataType() (*EventsResultDataType, bool) {
	return nil, false
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// AsBasicEventsResultDataType is the BasicEventsResultDataType implementation for EventsTraceResultType.
func (etrt EventsTraceResultType) AsBasicEventsResultDataType() (BasicEventsResultDataType, bool) {
	return &etrt, true
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// EventsUserInfoType user info for an event result
type EventsUserInfoType struct {
	// ID - ID of the user
	ID *string `json:"id,omitempty"`
	// AccountID - Account ID of the user
	AccountID *string `json:"accountId,omitempty"`
	// AuthenticatedID - Authenticated ID of the user
	AuthenticatedID *string `json:"authenticatedId,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// ListMetricsResultsItemType ...
type ListMetricsResultsItemType struct {
	autorest.Response `json:"-"`
	Value             *[]MetricsResultsItemType `json:"value,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsPostBodySchemaParametersType the parameters for a single metrics query
type MetricsPostBodySchemaParametersType struct {
	// MetricID - Possible values include: 'Requestscount', 'Requestsduration', 'Requestsfailed', 'Userscount', 'Usersauthenticated', 'PageViewscount', 'PageViewsduration', 'ClientprocessingDuration', 'ClientreceiveDuration', 'ClientnetworkDuration', 'ClientsendDuration', 'ClienttotalDuration', 'Dependenciescount', 'Dependenciesfailed', 'Dependenciesduration', 'Exceptionscount', 'Exceptionsbrowser', 'Exceptionsserver', 'Sessionscount', 'PerformanceCountersrequestExecutionTime', 'PerformanceCountersrequestsPerSecond', 'PerformanceCountersrequestsInQueue', 'PerformanceCountersmemoryAvailableBytes', 'PerformanceCountersexceptionsPerSecond', 'PerformanceCountersprocessCPUPercentage', 'PerformanceCountersprocessIOBytesPerSecond', 'PerformanceCountersprocessPrivateBytes', 'PerformanceCountersprocessorCPUPercentage', 'AvailabilityResultsavailabilityPercentage', 'AvailabilityResultsduration', 'BillingtelemetryCount', 'CustomEventscount'
	MetricID    MetricIDEnum `json:"metricId,omitempty"`
	Timespan    *string      `json:"timespan,omitempty"`
	Aggregation *[]string    `json:"aggregation,omitempty"`
	Interval    *string      `json:"interval,omitempty"`
	Segment     *[]string    `json:"segment,omitempty"`
	Top         *int32       `json:"top,omitempty"`
	Orderby     *string      `json:"orderby,omitempty"`
	Filter      *string      `json:"filter,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsPostBodySchemaType a metric request
type MetricsPostBodySchemaType struct {
	// ID - An identifier for this query.  Must be unique within the post body of the request.  This identifier will be the 'id' property of the response object representing this query.
	ID *string `json:"id,omitempty"`
	// Parameters - The parameters for a single metrics query
	Parameters *MetricsPostBodySchemaParametersType `json:"parameters,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsResultInfoType a metric result data.
type MetricsResultInfoType struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Start - Start time of the metric.
	Start *date.Time `json:"start,omitempty"`
	// End - Start time of the metric.
	End *date.Time `json:"end,omitempty"`
	// Interval - The interval used to segment the metric data.
	Interval *string `json:"interval,omitempty"`
	// Segments - Segmented metric data (if segmented).
	Segments *[]MetricsSegmentInfoType `json:"segments,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for MetricsResultInfoType.
func (mrit MetricsResultInfoType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrit.Start != nil {
		objectMap["start"] = mrit.Start
	}
	if mrit.End != nil {
		objectMap["end"] = mrit.End
	}
	if mrit.Interval != nil {
		objectMap["interval"] = mrit.Interval
	}
	if mrit.Segments != nil {
		objectMap["segments"] = mrit.Segments
	}
	for k, v := range mrit.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsResultsItemType ...
type MetricsResultsItemType struct {
	// ID - The specified ID for this metric.
	ID *string `json:"id,omitempty"`
	// Status - The HTTP status code of this metric query.
	Status *int32 `json:"status,omitempty"`
	// Body - The results of this metric query.
	Body *MetricsResultType `json:"body,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsResultType a metric result.
type MetricsResultType struct {
	autorest.Response `json:"-"`
	Value             *MetricsResultInfoType `json:"value,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MetricsSegmentInfoType a metric segment
type MetricsSegmentInfoType struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Start - Start time of the metric segment (only when an interval was specified).
	Start *date.Time `json:"start,omitempty"`
	// End - Start time of the metric segment (only when an interval was specified).
	End *date.Time `json:"end,omitempty"`
	// Segments - Segmented metric data (if further segmented).
	Segments *[]MetricsSegmentInfoType `json:"segments,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// MarshalJSON is the custom marshaler for MetricsSegmentInfoType.
func (msit MetricsSegmentInfoType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msit.Start != nil {
		objectMap["start"] = msit.Start
	}
	if msit.End != nil {
		objectMap["end"] = msit.End
	}
	if msit.Segments != nil {
		objectMap["segments"] = msit.Segments
	}
	for k, v := range msit.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryBodyType query request body
type QueryBodyType struct {
	// Query - The query to execute.
	Query *string `json:"query,omitempty"`
	// Timespan - Optional. The timespan over which to query data. This is an ISO8601 time period value.  This timespan is applied in addition to any that are specified in the query expression.
	Timespan *string `json:"timespan,omitempty"`
	// Applications - A list of applications that are included in the query.
	Applications *[]string `json:"applications,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// QueryResultsType contains the tables, columns & rows resulting from a query.
type QueryResultsType struct {
	autorest.Response `json:"-"`
	// Tables - The list of tables, columns and rows.
	Tables *[]TableType `json:"tables,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// SetObjectType ...
type SetObjectType struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Deprecated: Please use github.com/Azure/azure-sdk-for-go/services/appinsights/v1/insights instead.
// TableType contains the columns and rows for one table in a query response.
type TableType struct {
	// Name - The name of the table.
	Name *string `json:"name,omitempty"`
	// Columns - The list of columns in this table.
	Columns *[]ColumnType `json:"columns,omitempty"`
	// Rows - The resulting rows from this query.
	Rows *[][]interface{} `json:"rows,omitempty"`
	// PrimaryTimeStampColumn - name of column in database containing primary
	PrimaryTimeStampColumn interface{} `json:"primaryTimeStampColumn,omitempty"`
}
