package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ClusterState enumerates the values for cluster state.
type ClusterState string

const (
	// AutoScale ...
	AutoScale ClusterState = "AutoScale"
	// BaselineUpgrade ...
	BaselineUpgrade ClusterState = "BaselineUpgrade"
	// Deploying ...
	Deploying ClusterState = "Deploying"
	// EnforcingClusterVersion ...
	EnforcingClusterVersion ClusterState = "EnforcingClusterVersion"
	// Ready ...
	Ready ClusterState = "Ready"
	// UpdatingInfrastructure ...
	UpdatingInfrastructure ClusterState = "UpdatingInfrastructure"
	// UpdatingUserCertificate ...
	UpdatingUserCertificate ClusterState = "UpdatingUserCertificate"
	// UpdatingUserConfiguration ...
	UpdatingUserConfiguration ClusterState = "UpdatingUserConfiguration"
	// UpgradeServiceUnreachable ...
	UpgradeServiceUnreachable ClusterState = "UpgradeServiceUnreachable"
	// WaitingForNodes ...
	WaitingForNodes ClusterState = "WaitingForNodes"
)

// PossibleClusterStateValues returns an array of possible values for the ClusterState const type.
func PossibleClusterStateValues() []ClusterState {
	return []ClusterState{AutoScale, BaselineUpgrade, Deploying, EnforcingClusterVersion, Ready, UpdatingInfrastructure, UpdatingUserCertificate, UpdatingUserConfiguration, UpgradeServiceUnreachable, WaitingForNodes}
}

// DefaultMoveCost enumerates the values for default move cost.
type DefaultMoveCost string

const (
	// High ...
	High DefaultMoveCost = "High"
	// Low ...
	Low DefaultMoveCost = "Low"
	// Medium ...
	Medium DefaultMoveCost = "Medium"
	// Zero ...
	Zero DefaultMoveCost = "Zero"
)

// PossibleDefaultMoveCostValues returns an array of possible values for the DefaultMoveCost const type.
func PossibleDefaultMoveCostValues() []DefaultMoveCost {
	return []DefaultMoveCost{High, Low, Medium, Zero}
}

// DurabilityLevel enumerates the values for durability level.
type DurabilityLevel string

const (
	// Bronze ...
	Bronze DurabilityLevel = "Bronze"
	// Gold ...
	Gold DurabilityLevel = "Gold"
	// Silver ...
	Silver DurabilityLevel = "Silver"
)

// PossibleDurabilityLevelValues returns an array of possible values for the DurabilityLevel const type.
func PossibleDurabilityLevelValues() []DurabilityLevel {
	return []DurabilityLevel{Bronze, Gold, Silver}
}

// Environment enumerates the values for environment.
type Environment string

const (
	// Linux ...
	Linux Environment = "Linux"
	// Windows ...
	Windows Environment = "Windows"
)

// PossibleEnvironmentValues returns an array of possible values for the Environment const type.
func PossibleEnvironmentValues() []Environment {
	return []Environment{Linux, Windows}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeNamed ...
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemePartitionSchemeDescription ...
	PartitionSchemePartitionSchemeDescription PartitionScheme = "PartitionSchemeDescription"
	// PartitionSchemeSingleton ...
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range ...
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeNamed, PartitionSchemePartitionSchemeDescription, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Canceled, Failed, Succeeded, Updating}
}

// ReliabilityLevel enumerates the values for reliability level.
type ReliabilityLevel string

const (
	// ReliabilityLevelBronze ...
	ReliabilityLevelBronze ReliabilityLevel = "Bronze"
	// ReliabilityLevelGold ...
	ReliabilityLevelGold ReliabilityLevel = "Gold"
	// ReliabilityLevelNone ...
	ReliabilityLevelNone ReliabilityLevel = "None"
	// ReliabilityLevelPlatinum ...
	ReliabilityLevelPlatinum ReliabilityLevel = "Platinum"
	// ReliabilityLevelSilver ...
	ReliabilityLevelSilver ReliabilityLevel = "Silver"
)

// PossibleReliabilityLevelValues returns an array of possible values for the ReliabilityLevel const type.
func PossibleReliabilityLevelValues() []ReliabilityLevel {
	return []ReliabilityLevel{ReliabilityLevelBronze, ReliabilityLevelGold, ReliabilityLevelNone, ReliabilityLevelPlatinum, ReliabilityLevelSilver}
}

// ReliabilityLevel1 enumerates the values for reliability level 1.
type ReliabilityLevel1 string

const (
	// ReliabilityLevel1Bronze ...
	ReliabilityLevel1Bronze ReliabilityLevel1 = "Bronze"
	// ReliabilityLevel1Gold ...
	ReliabilityLevel1Gold ReliabilityLevel1 = "Gold"
	// ReliabilityLevel1Silver ...
	ReliabilityLevel1Silver ReliabilityLevel1 = "Silver"
)

// PossibleReliabilityLevel1Values returns an array of possible values for the ReliabilityLevel1 const type.
func PossibleReliabilityLevel1Values() []ReliabilityLevel1 {
	return []ReliabilityLevel1{ReliabilityLevel1Bronze, ReliabilityLevel1Gold, ReliabilityLevel1Silver}
}

// Scheme enumerates the values for scheme.
type Scheme string

const (
	// Affinity ...
	Affinity Scheme = "Affinity"
	// AlignedAffinity ...
	AlignedAffinity Scheme = "AlignedAffinity"
	// Invalid ...
	Invalid Scheme = "Invalid"
	// NonAlignedAffinity ...
	NonAlignedAffinity Scheme = "NonAlignedAffinity"
)

// PossibleSchemeValues returns an array of possible values for the Scheme const type.
func PossibleSchemeValues() []Scheme {
	return []Scheme{Affinity, AlignedAffinity, Invalid, NonAlignedAffinity}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindServiceProperties ...
	ServiceKindServiceProperties ServiceKind = "ServiceProperties"
	// ServiceKindStateful ...
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless ...
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindServiceProperties, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicServiceUpdateProperties enumerates the values for service kind basic service update
// properties.
type ServiceKindBasicServiceUpdateProperties string

const (
	// ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties ...
	ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties ServiceKindBasicServiceUpdateProperties = "ServiceUpdateProperties"
	// ServiceKindBasicServiceUpdatePropertiesServiceKindStateful ...
	ServiceKindBasicServiceUpdatePropertiesServiceKindStateful ServiceKindBasicServiceUpdateProperties = "Stateful"
	// ServiceKindBasicServiceUpdatePropertiesServiceKindStateless ...
	ServiceKindBasicServiceUpdatePropertiesServiceKindStateless ServiceKindBasicServiceUpdateProperties = "Stateless"
)

// PossibleServiceKindBasicServiceUpdatePropertiesValues returns an array of possible values for the ServiceKindBasicServiceUpdateProperties const type.
func PossibleServiceKindBasicServiceUpdatePropertiesValues() []ServiceKindBasicServiceUpdateProperties {
	return []ServiceKindBasicServiceUpdateProperties{ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties, ServiceKindBasicServiceUpdatePropertiesServiceKindStateful, ServiceKindBasicServiceUpdatePropertiesServiceKindStateless}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeServicePlacementPolicyDescription}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic ...
	Automatic UpgradeMode = "Automatic"
	// Manual ...
	Manual UpgradeMode = "Manual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{Automatic, Manual}
}

// UpgradeMode1 enumerates the values for upgrade mode 1.
type UpgradeMode1 string

const (
	// UpgradeMode1Automatic ...
	UpgradeMode1Automatic UpgradeMode1 = "Automatic"
	// UpgradeMode1Manual ...
	UpgradeMode1Manual UpgradeMode1 = "Manual"
)

// PossibleUpgradeMode1Values returns an array of possible values for the UpgradeMode1 const type.
func PossibleUpgradeMode1Values() []UpgradeMode1 {
	return []UpgradeMode1{UpgradeMode1Automatic, UpgradeMode1Manual}
}

// Weight enumerates the values for weight.
type Weight string

const (
	// WeightHigh ...
	WeightHigh Weight = "High"
	// WeightLow ...
	WeightLow Weight = "Low"
	// WeightMedium ...
	WeightMedium Weight = "Medium"
	// WeightZero ...
	WeightZero Weight = "Zero"
)

// PossibleWeightValues returns an array of possible values for the Weight const type.
func PossibleWeightValues() []Weight {
	return []Weight{WeightHigh, WeightLow, WeightMedium, WeightZero}
}

// X509StoreName enumerates the values for x509 store name.
type X509StoreName string

const (
	// AddressBook ...
	AddressBook X509StoreName = "AddressBook"
	// AuthRoot ...
	AuthRoot X509StoreName = "AuthRoot"
	// CertificateAuthority ...
	CertificateAuthority X509StoreName = "CertificateAuthority"
	// Disallowed ...
	Disallowed X509StoreName = "Disallowed"
	// My ...
	My X509StoreName = "My"
	// Root ...
	Root X509StoreName = "Root"
	// TrustedPeople ...
	TrustedPeople X509StoreName = "TrustedPeople"
	// TrustedPublisher ...
	TrustedPublisher X509StoreName = "TrustedPublisher"
)

// PossibleX509StoreNameValues returns an array of possible values for the X509StoreName const type.
func PossibleX509StoreNameValues() []X509StoreName {
	return []X509StoreName{AddressBook, AuthRoot, CertificateAuthority, Disallowed, My, Root, TrustedPeople, TrustedPublisher}
}

// ApplicationDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ApplicationDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationDeleteFuture) Result(client ApplicationClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationHealthPolicy defines a health policy used to evaluate the health of an application or one of its
// children entities.
type ApplicationHealthPolicy struct {
	// ConsiderWarningAsError - Indicates whether warnings are treated with the same severity as errors.
	ConsiderWarningAsError *bool `json:"ConsiderWarningAsError,omitempty"`
	// MaxPercentUnhealthyDeployedApplications - The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of deployed applications that can be unhealthy before the application is considered in error.
	// This is calculated by dividing the number of unhealthy deployed applications over the number of nodes where the application is currently deployed on in the cluster.
	// The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage is zero.
	MaxPercentUnhealthyDeployedApplications *int32                            `json:"MaxPercentUnhealthyDeployedApplications,omitempty"`
	DefaultServiceTypeHealthPolicy          *ServiceTypeHealthPolicy          `json:"DefaultServiceTypeHealthPolicy,omitempty"`
	ServiceTypeHealthPolicyMap              *[]ServiceTypeHealthPolicyMapItem `json:"ServiceTypeHealthPolicyMap,omitempty"`
}

// ApplicationMetricDescription describes capacity information for a custom resource balancing metric. This can be
// used to limit the total consumption of this metric by the services of this application.
type ApplicationMetricDescription struct {
	// Name - The name of the metric.
	Name *string `json:"Name,omitempty"`
	// MaximumCapacity - The maximum node capacity for Service Fabric application.
	// This is the maximum Load for an instance of this application on a single node. Even if the capacity of node is greater than this value, Service Fabric will limit the total load of services within the application on each node to this value.
	// If set to zero, capacity for this metric is unlimited on each node.
	// When creating a new application with application capacity defined, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	// When updating existing application with application capacity, the product of MaximumNodes and this value must always be smaller than or equal to TotalApplicationCapacity.
	MaximumCapacity *int64 `json:"MaximumCapacity,omitempty"`
	// ReservationCapacity - The node reservation capacity for Service Fabric application.
	// This is the amount of load which is reserved on nodes which have instances of this application.
	// If MinimumNodes is specified, then the product of these values will be the capacity reserved in the cluster for the application.
	// If set to zero, no capacity is reserved for this metric.
	// When setting application capacity or when updating application capacity; this value must be smaller than or equal to MaximumCapacity for each metric.
	ReservationCapacity *int64 `json:"ReservationCapacity,omitempty"`
	// TotalApplicationCapacity - The total metric capacity for Service Fabric application.
	// This is the total metric capacity for this application in the cluster. Service Fabric will try to limit the sum of loads of services within the application to this value.
	// When creating a new application with application capacity defined, the product of MaximumNodes and MaximumCapacity must always be smaller than or equal to this value.
	TotalApplicationCapacity *int64 `json:"TotalApplicationCapacity,omitempty"`
}

// ApplicationParameter describes an application parameter override to be applied when creating or upgrading an
// application.
type ApplicationParameter struct {
	// Key - The name of the parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value of the parameter.
	Value *string `json:"Value,omitempty"`
}

// ApplicationPatchFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ApplicationPatchFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationPatchFuture) Result(client ApplicationClient) (aru ApplicationResourceUpdate, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if aru.Response.Response, err = future.GetResult(sender); err == nil && aru.Response.Response.StatusCode != http.StatusNoContent {
		aru, err = client.PatchResponder(aru.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ApplicationPatchFuture", "Result", aru.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationProperties the application resource properties.
type ApplicationProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string                   `json:"provisioningState,omitempty"`
	TypeName          *string                   `json:"typeName,omitempty"`
	TypeVersion       *string                   `json:"typeVersion,omitempty"`
	Parameters        *[]ApplicationParameter   `json:"parameters,omitempty"`
	UpgradePolicy     *ApplicationUpgradePolicy `json:"upgradePolicy,omitempty"`
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"minimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"maximumNodes,omitempty"`
	// RemoveApplicationCapacity - The version of the application type
	RemoveApplicationCapacity *bool                           `json:"removeApplicationCapacity,omitempty"`
	Metrics                   *[]ApplicationMetricDescription `json:"metrics,omitempty"`
}

// ApplicationPutFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ApplicationPutFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationPutFuture) Result(client ApplicationClient) (ar ApplicationResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationPutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationPutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ar.Response.Response, err = future.GetResult(sender); err == nil && ar.Response.Response.StatusCode != http.StatusNoContent {
		ar, err = client.PutResponder(ar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ApplicationPutFuture", "Result", ar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationResource the application resource.
type ApplicationResource struct {
	autorest.Response      `json:"-"`
	*ApplicationProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResource.
func (ar ApplicationResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.ApplicationProperties != nil {
		objectMap["properties"] = ar.ApplicationProperties
	}
	if ar.ID != nil {
		objectMap["id"] = ar.ID
	}
	if ar.Name != nil {
		objectMap["name"] = ar.Name
	}
	if ar.Type != nil {
		objectMap["type"] = ar.Type
	}
	if ar.Location != nil {
		objectMap["location"] = ar.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResource struct.
func (ar *ApplicationResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				ar.ApplicationProperties = &applicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ar.Location = &location
			}
		}
	}

	return nil
}

// ApplicationResourceList the list of application resources.
type ApplicationResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationResource `json:"value,omitempty"`
}

// ApplicationResourceUpdate the application resource for patch operations.
type ApplicationResourceUpdate struct {
	autorest.Response            `json:"-"`
	*ApplicationUpdateProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationResourceUpdate.
func (aru ApplicationResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aru.ApplicationUpdateProperties != nil {
		objectMap["properties"] = aru.ApplicationUpdateProperties
	}
	if aru.ID != nil {
		objectMap["id"] = aru.ID
	}
	if aru.Name != nil {
		objectMap["name"] = aru.Name
	}
	if aru.Type != nil {
		objectMap["type"] = aru.Type
	}
	if aru.Location != nil {
		objectMap["location"] = aru.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationResourceUpdate struct.
func (aru *ApplicationResourceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationUpdateProperties ApplicationUpdateProperties
				err = json.Unmarshal(*v, &applicationUpdateProperties)
				if err != nil {
					return err
				}
				aru.ApplicationUpdateProperties = &applicationUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aru.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aru.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aru.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aru.Location = &location
			}
		}
	}

	return nil
}

// ApplicationTypeDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationTypeDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ApplicationTypeDeleteFuture) Result(client ApplicationTypeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ApplicationTypeDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ApplicationTypeDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationTypeProperties the application type name properties
type ApplicationTypeProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationTypeResource the application type name resource
type ApplicationTypeResource struct {
	autorest.Response          `json:"-"`
	*ApplicationTypeProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationTypeResource.
func (atr ApplicationTypeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atr.ApplicationTypeProperties != nil {
		objectMap["properties"] = atr.ApplicationTypeProperties
	}
	if atr.ID != nil {
		objectMap["id"] = atr.ID
	}
	if atr.Name != nil {
		objectMap["name"] = atr.Name
	}
	if atr.Type != nil {
		objectMap["type"] = atr.Type
	}
	if atr.Location != nil {
		objectMap["location"] = atr.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationTypeResource struct.
func (atr *ApplicationTypeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationTypeProperties ApplicationTypeProperties
				err = json.Unmarshal(*v, &applicationTypeProperties)
				if err != nil {
					return err
				}
				atr.ApplicationTypeProperties = &applicationTypeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				atr.Location = &location
			}
		}
	}

	return nil
}

// ApplicationTypeResourceList the list of application type names.
type ApplicationTypeResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationTypeResource `json:"value,omitempty"`
}

// ApplicationUpdateProperties the application resource properties for patch operations.
type ApplicationUpdateProperties struct {
	TypeVersion   *string                   `json:"typeVersion,omitempty"`
	Parameters    *[]ApplicationParameter   `json:"parameters,omitempty"`
	UpgradePolicy *ApplicationUpgradePolicy `json:"upgradePolicy,omitempty"`
	// MinimumNodes - The minimum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. If this property is set to zero, no capacity will be reserved. The value of this property cannot be more than the value of the MaximumNodes property.
	MinimumNodes *int64 `json:"minimumNodes,omitempty"`
	// MaximumNodes - The maximum number of nodes where Service Fabric will reserve capacity for this application. Note that this does not mean that the services of this application will be placed on all of those nodes. By default, the value of this property is zero and it means that the services can be placed on any node.
	MaximumNodes *int64 `json:"maximumNodes,omitempty"`
	// RemoveApplicationCapacity - The version of the application type
	RemoveApplicationCapacity *bool                           `json:"removeApplicationCapacity,omitempty"`
	Metrics                   *[]ApplicationMetricDescription `json:"metrics,omitempty"`
}

// ApplicationUpgradePolicy describes the policy for a monitored application upgrade.
type ApplicationUpgradePolicy struct {
	UpgradeReplicaSetCheckTimeout  *int64                          `json:"upgradeReplicaSetCheckTimeout,omitempty"`
	ForceRestart                   *bool                           `json:"forceRestart,omitempty"`
	RollingUpgradeMonitoringPolicy *RollingUpgradeMonitoringPolicy `json:"rollingUpgradeMonitoringPolicy,omitempty"`
	ApplicationHealthPolicy        *ApplicationHealthPolicy        `json:"applicationHealthPolicy,omitempty"`
}

// AvailableOperationDisplay operation supported by Service Fabric resource provider
type AvailableOperationDisplay struct {
	// Provider - The name of the provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that can be performed.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description
	Description *string `json:"description,omitempty"`
}

// AzureActiveDirectory the settings to enable AAD authentication on the cluster.
type AzureActiveDirectory struct {
	// TenantID - Azure active directory tenant id.
	TenantID *string `json:"tenantId,omitempty"`
	// ClusterApplication - Azure active directory cluster application id.
	ClusterApplication *string `json:"clusterApplication,omitempty"`
	// ClientApplication - Azure active directory client application id.
	ClientApplication *string `json:"clientApplication,omitempty"`
}

// CertificateDescription describes the certificate details.
type CertificateDescription struct {
	// Thumbprint - Thumbprint of the primary certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ThumbprintSecondary - Thumbprint of the secondary certificate.
	ThumbprintSecondary *string `json:"thumbprintSecondary,omitempty"`
	// X509StoreName - The local certificate store location. Possible values include: 'AddressBook', 'AuthRoot', 'CertificateAuthority', 'Disallowed', 'My', 'Root', 'TrustedPeople', 'TrustedPublisher'
	X509StoreName X509StoreName `json:"x509StoreName,omitempty"`
}

// ClientCertificateCommonName describes the client certificate details using common name.
type ClientCertificateCommonName struct {
	// IsAdmin - Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateCommonName - The common name of the client certificate.
	CertificateCommonName *string `json:"certificateCommonName,omitempty"`
	// CertificateIssuerThumbprint - The issuer thumbprint of the client certificate.
	CertificateIssuerThumbprint *string `json:"certificateIssuerThumbprint,omitempty"`
}

// ClientCertificateThumbprint describes the client certificate details using thumbprint.
type ClientCertificateThumbprint struct {
	// IsAdmin - Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
	IsAdmin *bool `json:"isAdmin,omitempty"`
	// CertificateThumbprint - The thumbprint of the client certificate.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`
}

// Cluster the cluster resource
type Cluster struct {
	autorest.Response `json:"-"`
	// ClusterProperties - The cluster resource properties
	*ClusterProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// ClusterCodeVersionsListResult the list results of the ServiceFabric runtime versions.
type ClusterCodeVersionsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ClusterCodeVersionsResult `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterCodeVersionsResult the result of the ServiceFabric runtime versions
type ClusterCodeVersionsResult struct {
	// ID - The identification of the result
	ID *string `json:"id,omitempty"`
	// Name - The name of the result
	Name *string `json:"name,omitempty"`
	// Type - The result resource type
	Type                   *string `json:"type,omitempty"`
	*ClusterVersionDetails `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCodeVersionsResult.
func (ccvr ClusterCodeVersionsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccvr.ID != nil {
		objectMap["id"] = ccvr.ID
	}
	if ccvr.Name != nil {
		objectMap["name"] = ccvr.Name
	}
	if ccvr.Type != nil {
		objectMap["type"] = ccvr.Type
	}
	if ccvr.ClusterVersionDetails != nil {
		objectMap["properties"] = ccvr.ClusterVersionDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterCodeVersionsResult struct.
func (ccvr *ClusterCodeVersionsResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ccvr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ccvr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ccvr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var clusterVersionDetails ClusterVersionDetails
				err = json.Unmarshal(*v, &clusterVersionDetails)
				if err != nil {
					return err
				}
				ccvr.ClusterVersionDetails = &clusterVersionDetails
			}
		}
	}

	return nil
}

// ClusterHealthPolicy defines a health policy used to evaluate the health of the cluster or of a cluster node.
type ClusterHealthPolicy struct {
	// MaxPercentUnhealthyNodes - The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.
	MaxPercentUnhealthyNodes *int32 `json:"maxPercentUnhealthyNodes,omitempty"`
	// MaxPercentUnhealthyApplications - The maximum allowed percentage of unhealthy applications before reporting an error. For example, to allow 10% of applications to be unhealthy, this value would be 10.
	MaxPercentUnhealthyApplications *int32 `json:"maxPercentUnhealthyApplications,omitempty"`
}

// ClusterListResult cluster list results
type ClusterListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Cluster `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterProperties describes the cluster resource properties.
type ClusterProperties struct {
	// AvailableClusterVersions - The Service Fabric runtime versions available for this cluster.
	AvailableClusterVersions *[]ClusterVersionDetails `json:"availableClusterVersions,omitempty"`
	// ClusterID - A service generated unique identifier for the cluster resource.
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterState - Possible values include: 'WaitingForNodes', 'Deploying', 'BaselineUpgrade', 'UpdatingUserConfiguration', 'UpdatingUserCertificate', 'UpdatingInfrastructure', 'EnforcingClusterVersion', 'UpgradeServiceUnreachable', 'AutoScale', 'Ready'
	ClusterState ClusterState `json:"clusterState,omitempty"`
	// ClusterEndpoint - The Azure Resource Provider endpoint. A system service in the cluster connects to this  endpoint.
	ClusterEndpoint *string `json:"clusterEndpoint,omitempty"`
	// ClusterCodeVersion - The Service Fabric runtime version of the cluster. This property can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// Certificate - The certificate to use for securing the cluster. The certificate provided will be used for  node to node security within the cluster, SSL certificate for cluster management endpoint and default  admin client.
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// ReliabilityLevel - Possible values include: 'ReliabilityLevelNone', 'ReliabilityLevelBronze', 'ReliabilityLevelSilver', 'ReliabilityLevelGold', 'ReliabilityLevelPlatinum'
	ReliabilityLevel ReliabilityLevel `json:"reliabilityLevel,omitempty"`
	// UpgradeMode - Possible values include: 'Automatic', 'Manual'
	UpgradeMode UpgradeMode `json:"upgradeMode,omitempty"`
	// ClientCertificateThumbprints - The list of client certificates referenced by thumbprint that are allowed to manage the cluster.
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClientCertificateCommonNames - The list of client certificates referenced by common name that are allowed to manage the cluster.
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// FabricSettings - The list of custom fabric settings to configure the cluster.
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// ReverseProxyCertificate - The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// ManagementEndpoint - The http management endpoint of the cluster.
	ManagementEndpoint *string `json:"managementEndpoint,omitempty"`
	// NodeTypes - The list of node types in the cluster.
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// AzureActiveDirectory - The AAD authentication settings of the cluster.
	AzureActiveDirectory *AzureActiveDirectory `json:"azureActiveDirectory,omitempty"`
	// ProvisioningState - The provisioning state of the cluster resource. Possible values include: 'Updating', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// VMImage - The VM image VMSS has been configured with. Generic names such as Windows or Linux can be used.
	VMImage *string `json:"vmImage,omitempty"`
	// DiagnosticsStorageAccountConfig - The storage account information for storing Service Fabric diagnostic logs.
	DiagnosticsStorageAccountConfig *DiagnosticsStorageAccountConfig `json:"diagnosticsStorageAccountConfig,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
	// AddOnFeatures - The list of add-on features to enable in the cluster.
	AddOnFeatures *[]string `json:"addOnFeatures,omitempty"`
}

// ClusterPropertiesUpdateParameters describes the cluster resource properties that can be updated during PATCH
// operation.
type ClusterPropertiesUpdateParameters struct {
	// ReliabilityLevel - The reliability level sets the replica set size of system services. Learn about [ReliabilityLevel](https://docs.microsoft.com/en-us/azure/service-fabric/service-fabric-cluster-capacity). Possible values include: 'ReliabilityLevel1Bronze', 'ReliabilityLevel1Silver', 'ReliabilityLevel1Gold'
	ReliabilityLevel ReliabilityLevel1 `json:"reliabilityLevel,omitempty"`
	// UpgradeMode - The upgrade mode of the cluster. This indicates if the cluster should be automatically upgraded when new Service Fabric runtime version is available. Possible values include: 'UpgradeMode1Automatic', 'UpgradeMode1Manual'
	UpgradeMode UpgradeMode1 `json:"upgradeMode,omitempty"`
	// ClusterCodeVersion - The Service Fabric runtime version of the cluster. This property can only by set the user when **upgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for new clusters use [ClusterVersion API](./ClusterVersion.md). To get the list of available version for existing clusters use **availableClusterVersions**.
	ClusterCodeVersion *string `json:"clusterCodeVersion,omitempty"`
	// Certificate - The certificate to use for securing the cluster. The certificate provided will be used for  node to node security within the cluster, SSL certificate for cluster management endpoint and default  admin client.
	Certificate *CertificateDescription `json:"certificate,omitempty"`
	// ClientCertificateThumbprints - The list of client certificates referenced by thumbprint that are allowed to manage the cluster. This will overwrite the existing list.
	ClientCertificateThumbprints *[]ClientCertificateThumbprint `json:"clientCertificateThumbprints,omitempty"`
	// ClientCertificateCommonNames - The list of client certificates referenced by common name that are allowed to manage the cluster. This will overwrite the existing list.
	ClientCertificateCommonNames *[]ClientCertificateCommonName `json:"clientCertificateCommonNames,omitempty"`
	// FabricSettings - The list of custom fabric settings to configure the cluster. This will overwrite the existing list.
	FabricSettings *[]SettingsSectionDescription `json:"fabricSettings,omitempty"`
	// ReverseProxyCertificate - The server certificate used by reverse proxy.
	ReverseProxyCertificate *CertificateDescription `json:"reverseProxyCertificate,omitempty"`
	// NodeTypes - The list of node types in the cluster. This will overwrite the existing list.
	NodeTypes *[]NodeTypeDescription `json:"nodeTypes,omitempty"`
	// UpgradeDescription - The policy to use when upgrading the cluster.
	UpgradeDescription *ClusterUpgradePolicy `json:"upgradeDescription,omitempty"`
	// AddOnFeatures - The list of add-on features to enable in the cluster.
	AddOnFeatures *[]string `json:"addOnFeatures,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.CreateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersCreateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ClustersUpdateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if c.Response.Response, err = future.GetResult(sender); err == nil && c.Response.Response.StatusCode != http.StatusNoContent {
		c, err = client.UpdateResponder(c.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ClustersUpdateFuture", "Result", c.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClusterUpdateParameters cluster update request
type ClusterUpdateParameters struct {
	*ClusterPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - Cluster update parameters
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterUpdateParameters.
func (cup ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cup.ClusterPropertiesUpdateParameters != nil {
		objectMap["properties"] = cup.ClusterPropertiesUpdateParameters
	}
	if cup.Tags != nil {
		objectMap["tags"] = cup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterUpdateParameters struct.
func (cup *ClusterUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterPropertiesUpdateParameters ClusterPropertiesUpdateParameters
				err = json.Unmarshal(*v, &clusterPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				cup.ClusterPropertiesUpdateParameters = &clusterPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cup.Tags = tags
			}
		}
	}

	return nil
}

// ClusterUpgradeDeltaHealthPolicy describes the delta health policies for the cluster upgrade.
type ClusterUpgradeDeltaHealthPolicy struct {
	// MaxPercentDeltaUnhealthyNodes - The maximum allowed percentage of nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the nodes at the beginning of upgrade and the state of the nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits.
	MaxPercentDeltaUnhealthyNodes *int32 `json:"maxPercentDeltaUnhealthyNodes,omitempty"`
	// MaxPercentUpgradeDomainDeltaUnhealthyNodes - The maximum allowed percentage of upgrade domain nodes health degradation allowed during cluster upgrades. The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade and the state of the upgrade domain nodes at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion for all completed upgrade domains to make sure the state of the upgrade domains is within tolerated limits.
	MaxPercentUpgradeDomainDeltaUnhealthyNodes *int32 `json:"maxPercentUpgradeDomainDeltaUnhealthyNodes,omitempty"`
	// MaxPercentDeltaUnhealthyApplications - The maximum allowed percentage of applications health degradation allowed during cluster upgrades. The delta is measured between the state of the applications at the beginning of upgrade and the state of the applications at the time of the health evaluation. The check is performed after every upgrade domain upgrade completion to make sure the global state of the cluster is within tolerated limits. System services are not included in this.
	MaxPercentDeltaUnhealthyApplications *int32 `json:"maxPercentDeltaUnhealthyApplications,omitempty"`
}

// ClusterUpgradePolicy describes the policy used when upgrading the cluster.
type ClusterUpgradePolicy struct {
	// ForceRestart - If true, then processes are forcefully restarted during upgrade even when the code version has not changed (the upgrade only changes configuration or data).
	ForceRestart *bool `json:"forceRestart,omitempty"`
	// UpgradeReplicaSetCheckTimeout - The maximum amount of time to block processing of an upgrade domain and revent loss of availability when there are unexpected issues. When this timeout expires, processing of the upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeReplicaSetCheckTimeout *string `json:"upgradeReplicaSetCheckTimeout,omitempty"`
	// HealthCheckWaitDuration - The length of time to wait after completing an upgrade domain before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckWaitDuration *string `json:"healthCheckWaitDuration,omitempty"`
	// HealthCheckStableDuration - The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckStableDuration *string `json:"healthCheckStableDuration,omitempty"`
	// HealthCheckRetryTimeout - The amount of time to retry health evaluation when the application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	HealthCheckRetryTimeout *string `json:"healthCheckRetryTimeout,omitempty"`
	// UpgradeTimeout - The amount of time the overall upgrade has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeTimeout *string `json:"upgradeTimeout,omitempty"`
	// UpgradeDomainTimeout - The amount of time each upgrade domain has to complete before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format.
	UpgradeDomainTimeout *string `json:"upgradeDomainTimeout,omitempty"`
	// HealthPolicy - The cluster health policy used when upgrading the cluster.
	HealthPolicy *ClusterHealthPolicy `json:"healthPolicy,omitempty"`
	// DeltaHealthPolicy - The delta health policy used when upgrading the cluster.
	DeltaHealthPolicy *ClusterUpgradeDeltaHealthPolicy `json:"deltaHealthPolicy,omitempty"`
}

// ClusterVersionDetails the detail of the Service Fabric runtime version result
type ClusterVersionDetails struct {
	// CodeVersion - The Service Fabric runtime version of the cluster.
	CodeVersion *string `json:"codeVersion,omitempty"`
	// SupportExpiryUtc - The date of expiry of support of the version.
	SupportExpiryUtc *string `json:"supportExpiryUtc,omitempty"`
	// Environment - Indicates if this version is for Windows or Linux operating system. Possible values include: 'Windows', 'Linux'
	Environment Environment `json:"environment,omitempty"`
}

// DiagnosticsStorageAccountConfig the storage account information for storing Service Fabric diagnostic logs.
type DiagnosticsStorageAccountConfig struct {
	// StorageAccountName - The Azure storage account name.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// ProtectedAccountKeyName - The protected diagnostics storage key name.
	ProtectedAccountKeyName *string `json:"protectedAccountKeyName,omitempty"`
	// BlobEndpoint - The blob endpoint of the azure storage account.
	BlobEndpoint *string `json:"blobEndpoint,omitempty"`
	// QueueEndpoint - The queue endpoint of the azure storage account.
	QueueEndpoint *string `json:"queueEndpoint,omitempty"`
	// TableEndpoint - The table endpoint of the azure storage account.
	TableEndpoint *string `json:"tableEndpoint,omitempty"`
}

// EndpointRangeDescription port range details
type EndpointRangeDescription struct {
	// StartPort - Starting port of a range of ports
	StartPort *int32 `json:"startPort,omitempty"`
	// EndPort - End port of a range of ports
	EndPort *int32 `json:"endPort,omitempty"`
}

// ErrorModel the error details.
type ErrorModel struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// NamedPartitionSchemeDescription describes the named partition scheme of the service.
type NamedPartitionSchemeDescription struct {
	// Count - The number of partitions.
	Count *int32 `json:"Count,omitempty"`
	// Names - Array of size specified by the ‘Count’ parameter, for the names of the partitions.
	Names *[]string `json:"Names,omitempty"`
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionScheme `json:"PartitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	npsd.PartitionScheme = PartitionSchemeNamed
	objectMap := make(map[string]interface{})
	if npsd.Count != nil {
		objectMap["Count"] = npsd.Count
	}
	if npsd.Names != nil {
		objectMap["Names"] = npsd.Names
	}
	if npsd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = npsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return &npsd, true
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for NamedPartitionSchemeDescription.
func (npsd NamedPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &npsd, true
}

// NodeTypeDescription describes a node type in the cluster, each node type represents sub set of nodes in the
// cluster.
type NodeTypeDescription struct {
	// Name - The name of the node type.
	Name *string `json:"name,omitempty"`
	// PlacementProperties - The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
	PlacementProperties map[string]*string `json:"placementProperties"`
	// Capacities - The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
	Capacities map[string]*string `json:"capacities"`
	// ClientConnectionEndpointPort - The TCP cluster management endpoint port.
	ClientConnectionEndpointPort *int32 `json:"clientConnectionEndpointPort,omitempty"`
	// HTTPGatewayEndpointPort - The HTTP cluster management endpoint port.
	HTTPGatewayEndpointPort *int32 `json:"httpGatewayEndpointPort,omitempty"`
	// DurabilityLevel - Possible values include: 'Bronze', 'Silver', 'Gold'
	DurabilityLevel DurabilityLevel `json:"durabilityLevel,omitempty"`
	// ApplicationPorts - The range of ports from which cluster assigned port to Service Fabric applications.
	ApplicationPorts *EndpointRangeDescription `json:"applicationPorts,omitempty"`
	// EphemeralPorts - The range of empheral ports that nodes in this node type should be configured with.
	EphemeralPorts *EndpointRangeDescription `json:"ephemeralPorts,omitempty"`
	// IsPrimary - The node type on which system services will run. Only one node type should be marked as primary. Primary node type cannot be deleted or changed for existing clusters.
	IsPrimary *bool `json:"isPrimary,omitempty"`
	// VMInstanceCount - The number of nodes in the node type. This count should match the capacity property in the corresponding VirtualMachineScaleSet resource.
	VMInstanceCount *int32 `json:"vmInstanceCount,omitempty"`
	// ReverseProxyEndpointPort - The endpoint used by reverse proxy.
	ReverseProxyEndpointPort *int32 `json:"reverseProxyEndpointPort,omitempty"`
}

// MarshalJSON is the custom marshaler for NodeTypeDescription.
func (ntd NodeTypeDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ntd.Name != nil {
		objectMap["name"] = ntd.Name
	}
	if ntd.PlacementProperties != nil {
		objectMap["placementProperties"] = ntd.PlacementProperties
	}
	if ntd.Capacities != nil {
		objectMap["capacities"] = ntd.Capacities
	}
	if ntd.ClientConnectionEndpointPort != nil {
		objectMap["clientConnectionEndpointPort"] = ntd.ClientConnectionEndpointPort
	}
	if ntd.HTTPGatewayEndpointPort != nil {
		objectMap["httpGatewayEndpointPort"] = ntd.HTTPGatewayEndpointPort
	}
	if ntd.DurabilityLevel != "" {
		objectMap["durabilityLevel"] = ntd.DurabilityLevel
	}
	if ntd.ApplicationPorts != nil {
		objectMap["applicationPorts"] = ntd.ApplicationPorts
	}
	if ntd.EphemeralPorts != nil {
		objectMap["ephemeralPorts"] = ntd.EphemeralPorts
	}
	if ntd.IsPrimary != nil {
		objectMap["isPrimary"] = ntd.IsPrimary
	}
	if ntd.VMInstanceCount != nil {
		objectMap["vmInstanceCount"] = ntd.VMInstanceCount
	}
	if ntd.ReverseProxyEndpointPort != nil {
		objectMap["reverseProxyEndpointPort"] = ntd.ReverseProxyEndpointPort
	}
	return json.Marshal(objectMap)
}

// OperationListResult describes the result of the request to list Service Fabric operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Service Fabric operations supported by the Microsoft.ServiceFabric resource provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OperationResult available operation list result
type OperationResult struct {
	// Name - The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *AvailableOperationDisplay `json:"display,omitempty"`
	// Origin - Origin result
	Origin *string `json:"origin,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicPartitionSchemeDescription describes how the service is partitioned.
type BasicPartitionSchemeDescription interface {
	AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool)
	AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool)
	AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool)
	AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool)
}

// PartitionSchemeDescription describes how the service is partitioned.
type PartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionScheme `json:"PartitionScheme,omitempty"`
}

func unmarshalBasicPartitionSchemeDescription(body []byte) (BasicPartitionSchemeDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["PartitionScheme"] {
	case string(PartitionSchemeNamed):
		var npsd NamedPartitionSchemeDescription
		err := json.Unmarshal(body, &npsd)
		return npsd, err
	case string(PartitionSchemeSingleton):
		var spsd SingletonPartitionSchemeDescription
		err := json.Unmarshal(body, &spsd)
		return spsd, err
	case string(PartitionSchemeUniformInt64Range):
		var ui6rpsd UniformInt64RangePartitionSchemeDescription
		err := json.Unmarshal(body, &ui6rpsd)
		return ui6rpsd, err
	default:
		var psd PartitionSchemeDescription
		err := json.Unmarshal(body, &psd)
		return psd, err
	}
}
func unmarshalBasicPartitionSchemeDescriptionArray(body []byte) ([]BasicPartitionSchemeDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psdArray := make([]BasicPartitionSchemeDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psd, err := unmarshalBasicPartitionSchemeDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		psdArray[index] = psd
	}
	return psdArray, nil
}

// MarshalJSON is the custom marshaler for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	psd.PartitionScheme = PartitionSchemePartitionSchemeDescription
	objectMap := make(map[string]interface{})
	if psd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = psd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return &psd, true
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for PartitionSchemeDescription.
func (psd PartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &psd, true
}

// ProxyResource the resource model definition for proxy-only resource.
type ProxyResource struct {
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// Resource the resource model definition.
type Resource struct {
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RollingUpgradeMonitoringPolicy the policy used for monitoring the application upgrade
type RollingUpgradeMonitoringPolicy struct {
	HealthCheckWaitDuration   *string `json:"healthCheckWaitDuration,omitempty"`
	HealthCheckStableDuration *string `json:"healthCheckStableDuration,omitempty"`
	HealthCheckRetryTimeout   *string `json:"healthCheckRetryTimeout,omitempty"`
	UpgradeTimeout            *string `json:"upgradeTimeout,omitempty"`
	UpgradeDomainTimeout      *string `json:"upgradeDomainTimeout,omitempty"`
}

// ServiceCorrelationDescription creates a particular correlation between services.
type ServiceCorrelationDescription struct {
	// Scheme - Possible values include: 'Invalid', 'Affinity', 'AlignedAffinity', 'NonAlignedAffinity'
	Scheme      Scheme  `json:"Scheme,omitempty"`
	ServiceName *string `json:"ServiceName,omitempty"`
}

// ServiceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServiceDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServiceDeleteFuture) Result(client ServiceClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServiceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServiceDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceLoadMetricDescription specifies a metric to load balance a service during runtime.
type ServiceLoadMetricDescription struct {
	// Name - The name of the metric. If the service chooses to report load during runtime, the load metric name should match the name that is specified in Name exactly. Note that metric names are case sensitive.
	Name *string `json:"Name,omitempty"`
	// Weight - Possible values include: 'WeightZero', 'WeightLow', 'WeightMedium', 'WeightHigh'
	Weight Weight `json:"Weight,omitempty"`
	// PrimaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Primary replica.
	PrimaryDefaultLoad *int32 `json:"PrimaryDefaultLoad,omitempty"`
	// SecondaryDefaultLoad - Used only for Stateful services. The default amount of load, as a number, that this service creates for this metric when it is a Secondary replica.
	SecondaryDefaultLoad *int32 `json:"SecondaryDefaultLoad,omitempty"`
	// DefaultLoad - Used only for Stateless services. The default amount of load, as a number, that this service creates for this metric.
	DefaultLoad *int32 `json:"DefaultLoad,omitempty"`
}

// ServicePatchFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicePatchFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicePatchFuture) Result(client ServiceClient) (sru ServiceResourceUpdate, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServicePatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServicePatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sru.Response.Response, err = future.GetResult(sender); err == nil && sru.Response.Response.StatusCode != http.StatusNoContent {
		sru, err = client.PatchResponder(sru.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ServicePatchFuture", "Result", sru.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BasicServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type BasicServicePlacementPolicyDescription interface {
	AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool)
}

// ServicePlacementPolicyDescription describes the policy to be used for placement of a Service Fabric service.
type ServicePlacementPolicyDescription struct {
	// Type - Possible values include: 'TypeServicePlacementPolicyDescription'
	Type Type `json:"Type,omitempty"`
}

func unmarshalBasicServicePlacementPolicyDescription(body []byte) (BasicServicePlacementPolicyDescription, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["Type"] {
	default:
		var sppd ServicePlacementPolicyDescription
		err := json.Unmarshal(body, &sppd)
		return sppd, err
	}
}
func unmarshalBasicServicePlacementPolicyDescriptionArray(body []byte) ([]BasicServicePlacementPolicyDescription, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sppdArray := make([]BasicServicePlacementPolicyDescription, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppd, err := unmarshalBasicServicePlacementPolicyDescription(*rawMessage)
		if err != nil {
			return nil, err
		}
		sppdArray[index] = sppd
	}
	return sppdArray, nil
}

// MarshalJSON is the custom marshaler for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) MarshalJSON() ([]byte, error) {
	sppd.Type = TypeServicePlacementPolicyDescription
	objectMap := make(map[string]interface{})
	if sppd.Type != "" {
		objectMap["Type"] = sppd.Type
	}
	return json.Marshal(objectMap)
}

// AsServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsServicePlacementPolicyDescription() (*ServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// AsBasicServicePlacementPolicyDescription is the BasicServicePlacementPolicyDescription implementation for ServicePlacementPolicyDescription.
func (sppd ServicePlacementPolicyDescription) AsBasicServicePlacementPolicyDescription() (BasicServicePlacementPolicyDescription, bool) {
	return &sppd, true
}

// BasicServiceProperties the service resource properties.
type BasicServiceProperties interface {
	AsStatelessServiceProperties() (*StatelessServiceProperties, bool)
	AsStatefulServiceProperties() (*StatefulServiceProperties, bool)
	AsServiceProperties() (*ServiceProperties, bool)
}

// ServiceProperties the service resource properties.
type ServiceProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName      *string                         `json:"serviceTypeName,omitempty"`
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceProperties', 'ServiceKindStateless', 'ServiceKindStateful'
	ServiceKind ServiceKind `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

func unmarshalBasicServiceProperties(body []byte) (BasicServiceProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["serviceKind"] {
	case string(ServiceKindStateless):
		var ssp StatelessServiceProperties
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	case string(ServiceKindStateful):
		var ssp StatefulServiceProperties
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	default:
		var sp ServiceProperties
		err := json.Unmarshal(body, &sp)
		return sp, err
	}
}
func unmarshalBasicServicePropertiesArray(body []byte) ([]BasicServiceProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spArray := make([]BasicServiceProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sp, err := unmarshalBasicServiceProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		spArray[index] = sp
	}
	return spArray, nil
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	sp.ServiceKind = ServiceKindServiceProperties
	objectMap := make(map[string]interface{})
	if sp.ProvisioningState != nil {
		objectMap["provisioningState"] = sp.ProvisioningState
	}
	if sp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = sp.ServiceTypeName
	}
	objectMap["partitionDescription"] = sp.PartitionDescription
	if sp.ServiceKind != "" {
		objectMap["serviceKind"] = sp.ServiceKind
	}
	if sp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = sp.PlacementConstraints
	}
	if sp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = sp.CorrelationScheme
	}
	if sp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = sp.ServiceLoadMetrics
	}
	if sp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = sp.ServicePlacementPolicies
	}
	if sp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = sp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceProperties is the BasicServiceProperties implementation for ServiceProperties.
func (sp ServiceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return nil, false
}

// AsStatefulServiceProperties is the BasicServiceProperties implementation for ServiceProperties.
func (sp ServiceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return nil, false
}

// AsServiceProperties is the BasicServiceProperties implementation for ServiceProperties.
func (sp ServiceProperties) AsServiceProperties() (*ServiceProperties, bool) {
	return &sp, true
}

// AsBasicServiceProperties is the BasicServiceProperties implementation for ServiceProperties.
func (sp ServiceProperties) AsBasicServiceProperties() (BasicServiceProperties, bool) {
	return &sp, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceProperties struct.
func (sp *ServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				sp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				sp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				sp.PartitionDescription = partitionDescription
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKind
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				sp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				sp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				sp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				sp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				sp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				sp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// ServicePropertiesBase the common service resource properties.
type ServicePropertiesBase struct {
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ServicePropertiesBase struct.
func (spb *ServicePropertiesBase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				spb.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				spb.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				spb.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				spb.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				spb.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// ServicePutFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicePutFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicePutFuture) Result(client ServiceClient) (sr ServiceResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ServicePutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.ServicePutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sr.Response.Response, err = future.GetResult(sender); err == nil && sr.Response.Response.StatusCode != http.StatusNoContent {
		sr, err = client.PutResponder(sr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.ServicePutFuture", "Result", sr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServiceResource the service resource.
type ServiceResource struct {
	autorest.Response      `json:"-"`
	BasicServiceProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResource.
func (sr ServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sr.BasicServiceProperties
	if sr.ID != nil {
		objectMap["id"] = sr.ID
	}
	if sr.Name != nil {
		objectMap["name"] = sr.Name
	}
	if sr.Type != nil {
		objectMap["type"] = sr.Type
	}
	if sr.Location != nil {
		objectMap["location"] = sr.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResource struct.
func (sr *ServiceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicServiceProperties, err := unmarshalBasicServiceProperties(*v)
				if err != nil {
					return err
				}
				sr.BasicServiceProperties = basicServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sr.Location = &location
			}
		}
	}

	return nil
}

// ServiceResourceList the list of service resources.
type ServiceResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceResource `json:"value,omitempty"`
}

// ServiceResourceUpdate the service resource for patch operations.
type ServiceResourceUpdate struct {
	autorest.Response            `json:"-"`
	BasicServiceUpdateProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceResourceUpdate.
func (sru ServiceResourceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = sru.BasicServiceUpdateProperties
	if sru.ID != nil {
		objectMap["id"] = sru.ID
	}
	if sru.Name != nil {
		objectMap["name"] = sru.Name
	}
	if sru.Type != nil {
		objectMap["type"] = sru.Type
	}
	if sru.Location != nil {
		objectMap["location"] = sru.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceResourceUpdate struct.
func (sru *ServiceResourceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				basicServiceUpdateProperties, err := unmarshalBasicServiceUpdateProperties(*v)
				if err != nil {
					return err
				}
				sru.BasicServiceUpdateProperties = basicServiceUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sru.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sru.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sru.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sru.Location = &location
			}
		}
	}

	return nil
}

// ServiceTypeDeltaHealthPolicy service health policy
type ServiceTypeDeltaHealthPolicy struct {
	// MaxPercentDeltaUnhealthyServices - Maximum percentage of unhealthy services in cluster
	MaxPercentDeltaUnhealthyServices *int32 `json:"maxPercentDeltaUnhealthyServices,omitempty"`
}

// ServiceTypeHealthPolicy represents the health policy used to evaluate the health of services belonging to a
// service type.
type ServiceTypeHealthPolicy struct {
	// MaxPercentUnhealthyPartitionsPerService - The maximum allowed percentage of unhealthy partitions per service. Allowed values are Byte values from zero to 100
	// The percentage represents the maximum tolerated percentage of partitions that can be unhealthy before the service is considered in error.
	// If the percentage is respected but there is at least one unhealthy partition, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy partitions over the total number of partitions in the service.
	// The computation rounds up to tolerate one failure on small numbers of partitions. Default percentage is zero.
	MaxPercentUnhealthyPartitionsPerService *int32 `json:"MaxPercentUnhealthyPartitionsPerService,omitempty"`
	// MaxPercentUnhealthyReplicasPerPartition - The maximum allowed percentage of unhealthy replicas per partition. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of replicas that can be unhealthy before the partition is considered in error.
	// If the percentage is respected but there is at least one unhealthy replica, the health is evaluated as Warning.
	// The percentage is calculated by dividing the number of unhealthy replicas over the total number of replicas in the partition.
	// The computation rounds up to tolerate one failure on small numbers of replicas. Default percentage is zero.
	MaxPercentUnhealthyReplicasPerPartition *int32 `json:"MaxPercentUnhealthyReplicasPerPartition,omitempty"`
	// MaxPercentUnhealthyServices - The maximum maximum allowed percentage of unhealthy services. Allowed values are Byte values from zero to 100.
	// The percentage represents the maximum tolerated percentage of services that can be unhealthy before the application is considered in error.
	// If the percentage is respected but there is at least one unhealthy service, the health is evaluated as Warning.
	// This is calculated by dividing the number of unhealthy services of the specific service type over the total number of services of the specific service type.
	// The computation rounds up to tolerate one failure on small numbers of services. Default percentage is zero.
	MaxPercentUnhealthyServices *int32 `json:"MaxPercentUnhealthyServices,omitempty"`
}

// ServiceTypeHealthPolicyMapItem defines an item in ServiceTypeHealthPolicyMap.
type ServiceTypeHealthPolicyMapItem struct {
	// Key - The key of the service type health policy map item. This is the name of the service type.
	Key   *string                  `json:"Key,omitempty"`
	Value *ServiceTypeHealthPolicy `json:"Value,omitempty"`
}

// BasicServiceUpdateProperties the service resource properties for patch operations.
type BasicServiceUpdateProperties interface {
	AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool)
	AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool)
	AsServiceUpdateProperties() (*ServiceUpdateProperties, bool)
}

// ServiceUpdateProperties the service resource properties for patch operations.
type ServiceUpdateProperties struct {
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateless', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateful'
	ServiceKind ServiceKindBasicServiceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

func unmarshalBasicServiceUpdateProperties(body []byte) (BasicServiceUpdateProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["serviceKind"] {
	case string(ServiceKindBasicServiceUpdatePropertiesServiceKindStateless):
		var ssup StatelessServiceUpdateProperties
		err := json.Unmarshal(body, &ssup)
		return ssup, err
	case string(ServiceKindBasicServiceUpdatePropertiesServiceKindStateful):
		var ssup StatefulServiceUpdateProperties
		err := json.Unmarshal(body, &ssup)
		return ssup, err
	default:
		var sup ServiceUpdateProperties
		err := json.Unmarshal(body, &sup)
		return sup, err
	}
}
func unmarshalBasicServiceUpdatePropertiesArray(body []byte) ([]BasicServiceUpdateProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	supArray := make([]BasicServiceUpdateProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sup, err := unmarshalBasicServiceUpdateProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		supArray[index] = sup
	}
	return supArray, nil
}

// MarshalJSON is the custom marshaler for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	sup.ServiceKind = ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties
	objectMap := make(map[string]interface{})
	if sup.ServiceKind != "" {
		objectMap["serviceKind"] = sup.ServiceKind
	}
	if sup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = sup.PlacementConstraints
	}
	if sup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = sup.CorrelationScheme
	}
	if sup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = sup.ServiceLoadMetrics
	}
	if sup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = sup.ServicePlacementPolicies
	}
	if sup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = sup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceUpdateProperties is the BasicServiceUpdateProperties implementation for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return nil, false
}

// AsStatefulServiceUpdateProperties is the BasicServiceUpdateProperties implementation for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return nil, false
}

// AsServiceUpdateProperties is the BasicServiceUpdateProperties implementation for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) AsServiceUpdateProperties() (*ServiceUpdateProperties, bool) {
	return &sup, true
}

// AsBasicServiceUpdateProperties is the BasicServiceUpdateProperties implementation for ServiceUpdateProperties.
func (sup ServiceUpdateProperties) AsBasicServiceUpdateProperties() (BasicServiceUpdateProperties, bool) {
	return &sup, true
}

// UnmarshalJSON is the custom unmarshaler for ServiceUpdateProperties struct.
func (sup *ServiceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				sup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				sup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				sup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				sup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				sup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				sup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// SettingsParameterDescription describes a parameter in fabric settings of the cluster.
type SettingsParameterDescription struct {
	// Name - The parameter name of fabric setting.
	Name *string `json:"name,omitempty"`
	// Value - The parameter value of fabric setting.
	Value *string `json:"value,omitempty"`
}

// SettingsSectionDescription describes a section in the fabric settings of the cluster.
type SettingsSectionDescription struct {
	// Name - The section name of the fabric settings.
	Name *string `json:"name,omitempty"`
	// Parameters - The collection of parameters in the section.
	Parameters *[]SettingsParameterDescription `json:"parameters,omitempty"`
}

// SingletonPartitionSchemeDescription describes the partition scheme of a singleton-partitioned, or
// non-partitioned service.
type SingletonPartitionSchemeDescription struct {
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionScheme `json:"PartitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	spsd.PartitionScheme = PartitionSchemeSingleton
	objectMap := make(map[string]interface{})
	if spsd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = spsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return &spsd, true
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return nil, false
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for SingletonPartitionSchemeDescription.
func (spsd SingletonPartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &spsd, true
}

// StatefulServiceProperties the properties of a stateful service resource.
type StatefulServiceProperties struct {
	// HasPersistedState - A flag indicating whether this is a persistent service which stores states on the local disk. If it is then the value of this property is true, if not it is false.
	HasPersistedState *bool `json:"hasPersistedState,omitempty"`
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"targetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"minReplicaSetSize,omitempty"`
	// ReplicaRestartWaitDuration - The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *date.Time `json:"replicaRestartWaitDuration,omitempty"`
	// QuorumLossWaitDuration - The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *date.Time `json:"quorumLossWaitDuration,omitempty"`
	// StandByReplicaKeepDuration - The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *date.Time `json:"standByReplicaKeepDuration,omitempty"`
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName      *string                         `json:"serviceTypeName,omitempty"`
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceProperties', 'ServiceKindStateless', 'ServiceKindStateful'
	ServiceKind ServiceKind `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatefulServiceProperties.
func (ssp StatefulServiceProperties) MarshalJSON() ([]byte, error) {
	ssp.ServiceKind = ServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssp.HasPersistedState != nil {
		objectMap["hasPersistedState"] = ssp.HasPersistedState
	}
	if ssp.TargetReplicaSetSize != nil {
		objectMap["targetReplicaSetSize"] = ssp.TargetReplicaSetSize
	}
	if ssp.MinReplicaSetSize != nil {
		objectMap["minReplicaSetSize"] = ssp.MinReplicaSetSize
	}
	if ssp.ReplicaRestartWaitDuration != nil {
		objectMap["replicaRestartWaitDuration"] = ssp.ReplicaRestartWaitDuration
	}
	if ssp.QuorumLossWaitDuration != nil {
		objectMap["quorumLossWaitDuration"] = ssp.QuorumLossWaitDuration
	}
	if ssp.StandByReplicaKeepDuration != nil {
		objectMap["standByReplicaKeepDuration"] = ssp.StandByReplicaKeepDuration
	}
	if ssp.ProvisioningState != nil {
		objectMap["provisioningState"] = ssp.ProvisioningState
	}
	if ssp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = ssp.ServiceTypeName
	}
	objectMap["partitionDescription"] = ssp.PartitionDescription
	if ssp.ServiceKind != "" {
		objectMap["serviceKind"] = ssp.ServiceKind
	}
	if ssp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssp.PlacementConstraints
	}
	if ssp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssp.CorrelationScheme
	}
	if ssp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssp.ServiceLoadMetrics
	}
	if ssp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssp.ServicePlacementPolicies
	}
	if ssp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceProperties is the BasicServiceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return nil, false
}

// AsStatefulServiceProperties is the BasicServiceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return &ssp, true
}

// AsServiceProperties is the BasicServiceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsServiceProperties() (*ServiceProperties, bool) {
	return nil, false
}

// AsBasicServiceProperties is the BasicServiceProperties implementation for StatefulServiceProperties.
func (ssp StatefulServiceProperties) AsBasicServiceProperties() (BasicServiceProperties, bool) {
	return &ssp, true
}

// UnmarshalJSON is the custom unmarshaler for StatefulServiceProperties struct.
func (ssp *StatefulServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hasPersistedState":
			if v != nil {
				var hasPersistedState bool
				err = json.Unmarshal(*v, &hasPersistedState)
				if err != nil {
					return err
				}
				ssp.HasPersistedState = &hasPersistedState
			}
		case "targetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int32
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				ssp.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "minReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int32
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				ssp.MinReplicaSetSize = &minReplicaSetSize
			}
		case "replicaRestartWaitDuration":
			if v != nil {
				var replicaRestartWaitDuration date.Time
				err = json.Unmarshal(*v, &replicaRestartWaitDuration)
				if err != nil {
					return err
				}
				ssp.ReplicaRestartWaitDuration = &replicaRestartWaitDuration
			}
		case "quorumLossWaitDuration":
			if v != nil {
				var quorumLossWaitDuration date.Time
				err = json.Unmarshal(*v, &quorumLossWaitDuration)
				if err != nil {
					return err
				}
				ssp.QuorumLossWaitDuration = &quorumLossWaitDuration
			}
		case "standByReplicaKeepDuration":
			if v != nil {
				var standByReplicaKeepDuration date.Time
				err = json.Unmarshal(*v, &standByReplicaKeepDuration)
				if err != nil {
					return err
				}
				ssp.StandByReplicaKeepDuration = &standByReplicaKeepDuration
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ssp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				ssp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				ssp.PartitionDescription = partitionDescription
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKind
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatefulServiceUpdateProperties the properties of a stateful service resource for patch operations.
type StatefulServiceUpdateProperties struct {
	// TargetReplicaSetSize - The target replica set size as a number.
	TargetReplicaSetSize *int32 `json:"targetReplicaSetSize,omitempty"`
	// MinReplicaSetSize - The minimum replica set size as a number.
	MinReplicaSetSize *int32 `json:"minReplicaSetSize,omitempty"`
	// ReplicaRestartWaitDuration - The duration between when a replica goes down and when a new replica is created, represented in ISO 8601 format (hh:mm:ss.s).
	ReplicaRestartWaitDuration *date.Time `json:"replicaRestartWaitDuration,omitempty"`
	// QuorumLossWaitDuration - The maximum duration for which a partition is allowed to be in a state of quorum loss, represented in ISO 8601 format (hh:mm:ss.s).
	QuorumLossWaitDuration *date.Time `json:"quorumLossWaitDuration,omitempty"`
	// StandByReplicaKeepDuration - The definition on how long StandBy replicas should be maintained before being removed, represented in ISO 8601 format (hh:mm:ss.s).
	StandByReplicaKeepDuration *date.Time `json:"standByReplicaKeepDuration,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateless', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateful'
	ServiceKind ServiceKindBasicServiceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	ssup.ServiceKind = ServiceKindBasicServiceUpdatePropertiesServiceKindStateful
	objectMap := make(map[string]interface{})
	if ssup.TargetReplicaSetSize != nil {
		objectMap["targetReplicaSetSize"] = ssup.TargetReplicaSetSize
	}
	if ssup.MinReplicaSetSize != nil {
		objectMap["minReplicaSetSize"] = ssup.MinReplicaSetSize
	}
	if ssup.ReplicaRestartWaitDuration != nil {
		objectMap["replicaRestartWaitDuration"] = ssup.ReplicaRestartWaitDuration
	}
	if ssup.QuorumLossWaitDuration != nil {
		objectMap["quorumLossWaitDuration"] = ssup.QuorumLossWaitDuration
	}
	if ssup.StandByReplicaKeepDuration != nil {
		objectMap["standByReplicaKeepDuration"] = ssup.StandByReplicaKeepDuration
	}
	if ssup.ServiceKind != "" {
		objectMap["serviceKind"] = ssup.ServiceKind
	}
	if ssup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssup.PlacementConstraints
	}
	if ssup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssup.CorrelationScheme
	}
	if ssup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssup.ServiceLoadMetrics
	}
	if ssup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssup.ServicePlacementPolicies
	}
	if ssup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return nil, false
}

// AsStatefulServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return &ssup, true
}

// AsServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsServiceUpdateProperties() (*ServiceUpdateProperties, bool) {
	return nil, false
}

// AsBasicServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatefulServiceUpdateProperties.
func (ssup StatefulServiceUpdateProperties) AsBasicServiceUpdateProperties() (BasicServiceUpdateProperties, bool) {
	return &ssup, true
}

// UnmarshalJSON is the custom unmarshaler for StatefulServiceUpdateProperties struct.
func (ssup *StatefulServiceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "targetReplicaSetSize":
			if v != nil {
				var targetReplicaSetSize int32
				err = json.Unmarshal(*v, &targetReplicaSetSize)
				if err != nil {
					return err
				}
				ssup.TargetReplicaSetSize = &targetReplicaSetSize
			}
		case "minReplicaSetSize":
			if v != nil {
				var minReplicaSetSize int32
				err = json.Unmarshal(*v, &minReplicaSetSize)
				if err != nil {
					return err
				}
				ssup.MinReplicaSetSize = &minReplicaSetSize
			}
		case "replicaRestartWaitDuration":
			if v != nil {
				var replicaRestartWaitDuration date.Time
				err = json.Unmarshal(*v, &replicaRestartWaitDuration)
				if err != nil {
					return err
				}
				ssup.ReplicaRestartWaitDuration = &replicaRestartWaitDuration
			}
		case "quorumLossWaitDuration":
			if v != nil {
				var quorumLossWaitDuration date.Time
				err = json.Unmarshal(*v, &quorumLossWaitDuration)
				if err != nil {
					return err
				}
				ssup.QuorumLossWaitDuration = &quorumLossWaitDuration
			}
		case "standByReplicaKeepDuration":
			if v != nil {
				var standByReplicaKeepDuration date.Time
				err = json.Unmarshal(*v, &standByReplicaKeepDuration)
				if err != nil {
					return err
				}
				ssup.StandByReplicaKeepDuration = &standByReplicaKeepDuration
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatelessServiceProperties the properties of a stateless service resource.
type StatelessServiceProperties struct {
	// InstanceCount - The instance count.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServiceTypeName - The name of the service type
	ServiceTypeName      *string                         `json:"serviceTypeName,omitempty"`
	PartitionDescription BasicPartitionSchemeDescription `json:"partitionDescription,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindServiceProperties', 'ServiceKindStateless', 'ServiceKindStateful'
	ServiceKind ServiceKind `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatelessServiceProperties.
func (ssp StatelessServiceProperties) MarshalJSON() ([]byte, error) {
	ssp.ServiceKind = ServiceKindStateless
	objectMap := make(map[string]interface{})
	if ssp.InstanceCount != nil {
		objectMap["instanceCount"] = ssp.InstanceCount
	}
	if ssp.ProvisioningState != nil {
		objectMap["provisioningState"] = ssp.ProvisioningState
	}
	if ssp.ServiceTypeName != nil {
		objectMap["serviceTypeName"] = ssp.ServiceTypeName
	}
	objectMap["partitionDescription"] = ssp.PartitionDescription
	if ssp.ServiceKind != "" {
		objectMap["serviceKind"] = ssp.ServiceKind
	}
	if ssp.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssp.PlacementConstraints
	}
	if ssp.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssp.CorrelationScheme
	}
	if ssp.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssp.ServiceLoadMetrics
	}
	if ssp.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssp.ServicePlacementPolicies
	}
	if ssp.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssp.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceProperties is the BasicServiceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsStatelessServiceProperties() (*StatelessServiceProperties, bool) {
	return &ssp, true
}

// AsStatefulServiceProperties is the BasicServiceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsStatefulServiceProperties() (*StatefulServiceProperties, bool) {
	return nil, false
}

// AsServiceProperties is the BasicServiceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsServiceProperties() (*ServiceProperties, bool) {
	return nil, false
}

// AsBasicServiceProperties is the BasicServiceProperties implementation for StatelessServiceProperties.
func (ssp StatelessServiceProperties) AsBasicServiceProperties() (BasicServiceProperties, bool) {
	return &ssp, true
}

// UnmarshalJSON is the custom unmarshaler for StatelessServiceProperties struct.
func (ssp *StatelessServiceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instanceCount":
			if v != nil {
				var instanceCount int32
				err = json.Unmarshal(*v, &instanceCount)
				if err != nil {
					return err
				}
				ssp.InstanceCount = &instanceCount
			}
		case "provisioningState":
			if v != nil {
				var provisioningState string
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ssp.ProvisioningState = &provisioningState
			}
		case "serviceTypeName":
			if v != nil {
				var serviceTypeName string
				err = json.Unmarshal(*v, &serviceTypeName)
				if err != nil {
					return err
				}
				ssp.ServiceTypeName = &serviceTypeName
			}
		case "partitionDescription":
			if v != nil {
				partitionDescription, err := unmarshalBasicPartitionSchemeDescription(*v)
				if err != nil {
					return err
				}
				ssp.PartitionDescription = partitionDescription
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKind
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssp.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssp.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssp.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssp.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssp.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssp.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// StatelessServiceUpdateProperties the properties of a stateless service resource for patch operations.
type StatelessServiceUpdateProperties struct {
	// InstanceCount - The instance count.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
	// ServiceKind - Possible values include: 'ServiceKindBasicServiceUpdatePropertiesServiceKindServiceUpdateProperties', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateless', 'ServiceKindBasicServiceUpdatePropertiesServiceKindStateful'
	ServiceKind ServiceKindBasicServiceUpdateProperties `json:"serviceKind,omitempty"`
	// PlacementConstraints - The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
	PlacementConstraints     *string                                   `json:"placementConstraints,omitempty"`
	CorrelationScheme        *[]ServiceCorrelationDescription          `json:"correlationScheme,omitempty"`
	ServiceLoadMetrics       *[]ServiceLoadMetricDescription           `json:"serviceLoadMetrics,omitempty"`
	ServicePlacementPolicies *[]BasicServicePlacementPolicyDescription `json:"servicePlacementPolicies,omitempty"`
	// DefaultMoveCost - Possible values include: 'Zero', 'Low', 'Medium', 'High'
	DefaultMoveCost DefaultMoveCost `json:"defaultMoveCost,omitempty"`
}

// MarshalJSON is the custom marshaler for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) MarshalJSON() ([]byte, error) {
	ssup.ServiceKind = ServiceKindBasicServiceUpdatePropertiesServiceKindStateless
	objectMap := make(map[string]interface{})
	if ssup.InstanceCount != nil {
		objectMap["instanceCount"] = ssup.InstanceCount
	}
	if ssup.ServiceKind != "" {
		objectMap["serviceKind"] = ssup.ServiceKind
	}
	if ssup.PlacementConstraints != nil {
		objectMap["placementConstraints"] = ssup.PlacementConstraints
	}
	if ssup.CorrelationScheme != nil {
		objectMap["correlationScheme"] = ssup.CorrelationScheme
	}
	if ssup.ServiceLoadMetrics != nil {
		objectMap["serviceLoadMetrics"] = ssup.ServiceLoadMetrics
	}
	if ssup.ServicePlacementPolicies != nil {
		objectMap["servicePlacementPolicies"] = ssup.ServicePlacementPolicies
	}
	if ssup.DefaultMoveCost != "" {
		objectMap["defaultMoveCost"] = ssup.DefaultMoveCost
	}
	return json.Marshal(objectMap)
}

// AsStatelessServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsStatelessServiceUpdateProperties() (*StatelessServiceUpdateProperties, bool) {
	return &ssup, true
}

// AsStatefulServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsStatefulServiceUpdateProperties() (*StatefulServiceUpdateProperties, bool) {
	return nil, false
}

// AsServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsServiceUpdateProperties() (*ServiceUpdateProperties, bool) {
	return nil, false
}

// AsBasicServiceUpdateProperties is the BasicServiceUpdateProperties implementation for StatelessServiceUpdateProperties.
func (ssup StatelessServiceUpdateProperties) AsBasicServiceUpdateProperties() (BasicServiceUpdateProperties, bool) {
	return &ssup, true
}

// UnmarshalJSON is the custom unmarshaler for StatelessServiceUpdateProperties struct.
func (ssup *StatelessServiceUpdateProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "instanceCount":
			if v != nil {
				var instanceCount int32
				err = json.Unmarshal(*v, &instanceCount)
				if err != nil {
					return err
				}
				ssup.InstanceCount = &instanceCount
			}
		case "serviceKind":
			if v != nil {
				var serviceKind ServiceKindBasicServiceUpdateProperties
				err = json.Unmarshal(*v, &serviceKind)
				if err != nil {
					return err
				}
				ssup.ServiceKind = serviceKind
			}
		case "placementConstraints":
			if v != nil {
				var placementConstraints string
				err = json.Unmarshal(*v, &placementConstraints)
				if err != nil {
					return err
				}
				ssup.PlacementConstraints = &placementConstraints
			}
		case "correlationScheme":
			if v != nil {
				var correlationScheme []ServiceCorrelationDescription
				err = json.Unmarshal(*v, &correlationScheme)
				if err != nil {
					return err
				}
				ssup.CorrelationScheme = &correlationScheme
			}
		case "serviceLoadMetrics":
			if v != nil {
				var serviceLoadMetrics []ServiceLoadMetricDescription
				err = json.Unmarshal(*v, &serviceLoadMetrics)
				if err != nil {
					return err
				}
				ssup.ServiceLoadMetrics = &serviceLoadMetrics
			}
		case "servicePlacementPolicies":
			if v != nil {
				servicePlacementPolicies, err := unmarshalBasicServicePlacementPolicyDescriptionArray(*v)
				if err != nil {
					return err
				}
				ssup.ServicePlacementPolicies = &servicePlacementPolicies
			}
		case "defaultMoveCost":
			if v != nil {
				var defaultMoveCost DefaultMoveCost
				err = json.Unmarshal(*v, &defaultMoveCost)
				if err != nil {
					return err
				}
				ssup.DefaultMoveCost = defaultMoveCost
			}
		}
	}

	return nil
}

// UniformInt64RangePartitionSchemeDescription describes a partitioning scheme where an integer range is allocated
// evenly across a number of partitions.
type UniformInt64RangePartitionSchemeDescription struct {
	// Count - The number of partitions.
	Count *int32 `json:"Count,omitempty"`
	// LowKey - String indicating the lower bound of the partition key range that
	// should be split between the partition ‘Count’
	LowKey *string `json:"LowKey,omitempty"`
	// HighKey - String indicating the upper bound of the partition key range that
	// should be split between the partition ‘Count’
	HighKey *string `json:"HighKey,omitempty"`
	// PartitionScheme - Possible values include: 'PartitionSchemePartitionSchemeDescription', 'PartitionSchemeNamed', 'PartitionSchemeSingleton', 'PartitionSchemeUniformInt64Range'
	PartitionScheme PartitionScheme `json:"PartitionScheme,omitempty"`
}

// MarshalJSON is the custom marshaler for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) MarshalJSON() ([]byte, error) {
	ui6rpsd.PartitionScheme = PartitionSchemeUniformInt64Range
	objectMap := make(map[string]interface{})
	if ui6rpsd.Count != nil {
		objectMap["Count"] = ui6rpsd.Count
	}
	if ui6rpsd.LowKey != nil {
		objectMap["LowKey"] = ui6rpsd.LowKey
	}
	if ui6rpsd.HighKey != nil {
		objectMap["HighKey"] = ui6rpsd.HighKey
	}
	if ui6rpsd.PartitionScheme != "" {
		objectMap["PartitionScheme"] = ui6rpsd.PartitionScheme
	}
	return json.Marshal(objectMap)
}

// AsNamedPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsNamedPartitionSchemeDescription() (*NamedPartitionSchemeDescription, bool) {
	return nil, false
}

// AsSingletonPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsSingletonPartitionSchemeDescription() (*SingletonPartitionSchemeDescription, bool) {
	return nil, false
}

// AsUniformInt64RangePartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsUniformInt64RangePartitionSchemeDescription() (*UniformInt64RangePartitionSchemeDescription, bool) {
	return &ui6rpsd, true
}

// AsPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsPartitionSchemeDescription() (*PartitionSchemeDescription, bool) {
	return nil, false
}

// AsBasicPartitionSchemeDescription is the BasicPartitionSchemeDescription implementation for UniformInt64RangePartitionSchemeDescription.
func (ui6rpsd UniformInt64RangePartitionSchemeDescription) AsBasicPartitionSchemeDescription() (BasicPartitionSchemeDescription, bool) {
	return &ui6rpsd, true
}

// VersionDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VersionDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VersionDeleteFuture) Result(client VersionClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.VersionDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.VersionDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VersionProperties the properties of the version resource.
type VersionProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// AppPackageURL - The URL to the application package
	AppPackageURL        *string                 `json:"appPackageUrl,omitempty"`
	DefaultParameterList *[]ApplicationParameter `json:"defaultParameterList,omitempty"`
}

// VersionPutFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type VersionPutFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VersionPutFuture) Result(client VersionClient) (vr VersionResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.VersionPutFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("servicefabric.VersionPutFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vr.Response.Response, err = future.GetResult(sender); err == nil && vr.Response.Response.StatusCode != http.StatusNoContent {
		vr, err = client.PutResponder(vr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "servicefabric.VersionPutFuture", "Result", vr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VersionResource a version resource for the specified application type name.
type VersionResource struct {
	autorest.Response  `json:"-"`
	*VersionProperties `json:"properties,omitempty"`
	// ID - Azure resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Azure resource name.
	Name *string `json:"name,omitempty"`
	// Type - Azure resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for VersionResource.
func (vr VersionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.VersionProperties != nil {
		objectMap["properties"] = vr.VersionProperties
	}
	if vr.ID != nil {
		objectMap["id"] = vr.ID
	}
	if vr.Name != nil {
		objectMap["name"] = vr.Name
	}
	if vr.Type != nil {
		objectMap["type"] = vr.Type
	}
	if vr.Location != nil {
		objectMap["location"] = vr.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VersionResource struct.
func (vr *VersionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var versionProperties VersionProperties
				err = json.Unmarshal(*v, &versionProperties)
				if err != nil {
					return err
				}
				vr.VersionProperties = &versionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vr.Location = &location
			}
		}
	}

	return nil
}

// VersionResourceList the list of version resources for the specified application type name.
type VersionResourceList struct {
	autorest.Response `json:"-"`
	Value             *[]VersionResource `json:"value,omitempty"`
}
