package infrastructureinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// RegionHealthsClient is the infrastructureInsights Admin Client
type RegionHealthsClient struct {
	BaseClient
}

// NewRegionHealthsClient creates an instance of the RegionHealthsClient client.
func NewRegionHealthsClient(subscriptionID string) RegionHealthsClient {
	return NewRegionHealthsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRegionHealthsClientWithBaseURI creates an instance of the RegionHealthsClient client.
func NewRegionHealthsClientWithBaseURI(baseURI string, subscriptionID string) RegionHealthsClient {
	return RegionHealthsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get health status of a region.
//
// location is location name. region is name of the region
func (client RegionHealthsClient) Get(ctx context.Context, location string, region string) (result RegionHealth, err error) {
	req, err := client.GetPreparer(ctx, location, region)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client RegionHealthsClient) GetPreparer(ctx context.Context, location string, region string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"region":         autorest.Encode("path", region),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{region}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RegionHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RegionHealthsClient) GetResponder(resp *http.Response) (result RegionHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get the list of all regions health status.
//
// location is location name. filter is oData filter parameter.
func (client RegionHealthsClient) List(ctx context.Context, location string, filter string) (result RegionHealthListPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, location, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rhl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "List", resp, "Failure sending request")
		return
	}

	result.rhl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client RegionHealthsClient) ListPreparer(ctx context.Context, location string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client RegionHealthsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client RegionHealthsClient) ListResponder(resp *http.Response) (result RegionHealthList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client RegionHealthsClient) listNextResults(lastResults RegionHealthList) (result RegionHealthList, err error) {
	req, err := lastResults.regionHealthListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.RegionHealthsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client RegionHealthsClient) ListComplete(ctx context.Context, location string, filter string) (result RegionHealthListIterator, err error) {
	result.page, err = client.List(ctx, location, filter)
	return
}
