package notificationhubs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen ...
	Listen AccessRights = "Listen"
	// Manage ...
	Manage AccessRights = "Manage"
	// Send ...
	Send AccessRights = "Send"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{Listen, Manage, Send}
}

// NamespaceType enumerates the values for namespace type.
type NamespaceType string

const (
	// Messaging ...
	Messaging NamespaceType = "Messaging"
	// NotificationHub ...
	NotificationHub NamespaceType = "NotificationHub"
)

// PossibleNamespaceTypeValues returns an array of possible values for the NamespaceType const type.
func PossibleNamespaceTypeValues() []NamespaceType {
	return []NamespaceType{Messaging, NotificationHub}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Free ...
	Free SkuName = "Free"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Free, Standard}
}

// AdmCredential description of a NotificationHub AdmCredential.
type AdmCredential struct {
	// AdmCredentialProperties - Properties of NotificationHub AdmCredential.
	*AdmCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AdmCredential.
func (ac AdmCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.AdmCredentialProperties != nil {
		objectMap["properties"] = ac.AdmCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdmCredential struct.
func (ac *AdmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var admCredentialProperties AdmCredentialProperties
				err = json.Unmarshal(*v, &admCredentialProperties)
				if err != nil {
					return err
				}
				ac.AdmCredentialProperties = &admCredentialProperties
			}
		}
	}

	return nil
}

// AdmCredentialProperties description of a NotificationHub AdmCredential.
type AdmCredentialProperties struct {
	// ClientID - The client identifier.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The credential secret access key.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// AuthTokenURL - The URL of the authorization token.
	AuthTokenURL *string `json:"authTokenUrl,omitempty"`
}

// ApnsCredential description of a NotificationHub ApnsCredential.
type ApnsCredential struct {
	// ApnsCredentialProperties - Properties of NotificationHub ApnsCredential.
	*ApnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApnsCredential.
func (ac ApnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.ApnsCredentialProperties != nil {
		objectMap["properties"] = ac.ApnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApnsCredential struct.
func (ac *ApnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var apnsCredentialProperties ApnsCredentialProperties
				err = json.Unmarshal(*v, &apnsCredentialProperties)
				if err != nil {
					return err
				}
				ac.ApnsCredentialProperties = &apnsCredentialProperties
			}
		}
	}

	return nil
}

// ApnsCredentialProperties description of a NotificationHub ApnsCredential.
type ApnsCredentialProperties struct {
	// ApnsCertificate - The APNS certificate.
	ApnsCertificate *string `json:"apnsCertificate,omitempty"`
	// CertificateKey - The certificate key.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Endpoint - The endpoint of this credential.
	Endpoint *string `json:"endpoint,omitempty"`
	// Thumbprint - The Apns certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// KeyID - A 10-character key identifier (kid) key, obtained from your developer account
	KeyID *string `json:"keyId,omitempty"`
	// AppName - The name of the application
	AppName *string `json:"appName,omitempty"`
	// AppID - The issuer (iss) registered claim key, whose value is your 10-character Team ID, obtained from your developer account
	AppID *string `json:"appId,omitempty"`
	// Token - Provider Authentication Token, obtained through your developer account
	Token *string `json:"token,omitempty"`
}

// BaiduCredential description of a NotificationHub BaiduCredential.
type BaiduCredential struct {
	// BaiduCredentialProperties - Properties of NotificationHub BaiduCredential.
	*BaiduCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BaiduCredential.
func (bc BaiduCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.BaiduCredentialProperties != nil {
		objectMap["properties"] = bc.BaiduCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BaiduCredential struct.
func (bc *BaiduCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var baiduCredentialProperties BaiduCredentialProperties
				err = json.Unmarshal(*v, &baiduCredentialProperties)
				if err != nil {
					return err
				}
				bc.BaiduCredentialProperties = &baiduCredentialProperties
			}
		}
	}

	return nil
}

// BaiduCredentialProperties description of a NotificationHub BaiduCredential.
type BaiduCredentialProperties struct {
	// BaiduAPIKey - Baidu Api Key.
	BaiduAPIKey *string `json:"baiduApiKey,omitempty"`
	// BaiduEndPoint - Baidu Endpoint.
	BaiduEndPoint *string `json:"baiduEndPoint,omitempty"`
	// BaiduSecretKey - Baidu Secret Key
	BaiduSecretKey *string `json:"baiduSecretKey,omitempty"`
}

// CheckAvailabilityParameters parameters supplied to the Check Name Availability for Namespace and
// NotificationHubs.
type CheckAvailabilityParameters struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckAvailabilityParameters.
func (capVar CheckAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if capVar.ID != nil {
		objectMap["id"] = capVar.ID
	}
	if capVar.Name != nil {
		objectMap["name"] = capVar.Name
	}
	if capVar.Type != nil {
		objectMap["type"] = capVar.Type
	}
	if capVar.Location != nil {
		objectMap["location"] = capVar.Location
	}
	if capVar.Tags != nil {
		objectMap["tags"] = capVar.Tags
	}
	if capVar.Sku != nil {
		objectMap["sku"] = capVar.Sku
	}
	if capVar.IsAvailiable != nil {
		objectMap["isAvailiable"] = capVar.IsAvailiable
	}
	return json.Marshal(objectMap)
}

// CheckAvailabilityResult description of a CheckAvailibility resource.
type CheckAvailabilityResult struct {
	autorest.Response `json:"-"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckAvailabilityResult.
func (car CheckAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if car.IsAvailiable != nil {
		objectMap["isAvailiable"] = car.IsAvailiable
	}
	if car.ID != nil {
		objectMap["id"] = car.ID
	}
	if car.Name != nil {
		objectMap["name"] = car.Name
	}
	if car.Type != nil {
		objectMap["type"] = car.Type
	}
	if car.Location != nil {
		objectMap["location"] = car.Location
	}
	if car.Tags != nil {
		objectMap["tags"] = car.Tags
	}
	if car.Sku != nil {
		objectMap["sku"] = car.Sku
	}
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequestParameters parameters supplied to the Check Name Availability for Namespace and
// NotificationHubs.
type CheckNameAvailabilityRequestParameters struct {
	// Name - Resource name
	Name *string `json:"Name,omitempty"`
	// Type - Resource type
	Type *string `json:"Type,omitempty"`
}

// CheckNameAvailabilityResponse ...
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - Checks if the namespace name is available
	NameAvailable *bool `json:"NameAvailable,omitempty"`
	// Reason - States the reason due to which the namespace name is not available
	Reason *string `json:"Reason,omitempty"`
	// Message - The messsage returned when checking for namespace name availability
	Message *string `json:"Message,omitempty"`
}

// CreateOrUpdateParameters parameters supplied to the CreateOrUpdate NotificationHub operation.
type CreateOrUpdateParameters struct {
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateParameters.
func (coup CreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coup.Properties != nil {
		objectMap["properties"] = coup.Properties
	}
	if coup.ID != nil {
		objectMap["id"] = coup.ID
	}
	if coup.Name != nil {
		objectMap["name"] = coup.Name
	}
	if coup.Type != nil {
		objectMap["type"] = coup.Type
	}
	if coup.Location != nil {
		objectMap["location"] = coup.Location
	}
	if coup.Tags != nil {
		objectMap["tags"] = coup.Tags
	}
	if coup.Sku != nil {
		objectMap["sku"] = coup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateParameters struct.
func (coup *CreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				coup.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				coup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				coup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				coup.Sku = &sku
			}
		}
	}

	return nil
}

// GcmCredential description of a NotificationHub GcmCredential.
type GcmCredential struct {
	// GcmCredentialProperties - Properties of NotificationHub GcmCredential.
	*GcmCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GcmCredential.
func (gc GcmCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gc.GcmCredentialProperties != nil {
		objectMap["properties"] = gc.GcmCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GcmCredential struct.
func (gc *GcmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gcmCredentialProperties GcmCredentialProperties
				err = json.Unmarshal(*v, &gcmCredentialProperties)
				if err != nil {
					return err
				}
				gc.GcmCredentialProperties = &gcmCredentialProperties
			}
		}
	}

	return nil
}

// GcmCredentialProperties description of a NotificationHub GcmCredential.
type GcmCredentialProperties struct {
	// GcmEndpoint - The GCM endpoint.
	GcmEndpoint *string `json:"gcmEndpoint,omitempty"`
	// GoogleAPIKey - The Google API key.
	GoogleAPIKey *string `json:"googleApiKey,omitempty"`
}

// ListResult the response of the List NotificationHub operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List NotificationHub operation.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of NotificationHub
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// MpnsCredential description of a NotificationHub MpnsCredential.
type MpnsCredential struct {
	// MpnsCredentialProperties - Properties of NotificationHub MpnsCredential.
	*MpnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MpnsCredential.
func (mc MpnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.MpnsCredentialProperties != nil {
		objectMap["properties"] = mc.MpnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MpnsCredential struct.
func (mc *MpnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mpnsCredentialProperties MpnsCredentialProperties
				err = json.Unmarshal(*v, &mpnsCredentialProperties)
				if err != nil {
					return err
				}
				mc.MpnsCredentialProperties = &mpnsCredentialProperties
			}
		}
	}

	return nil
}

// MpnsCredentialProperties description of a NotificationHub MpnsCredential.
type MpnsCredentialProperties struct {
	// MpnsCertificate - The MPNS certificate.
	MpnsCertificate *string `json:"mpnsCertificate,omitempty"`
	// CertificateKey - The certificate key for this credential.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Thumbprint - The Mpns certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// NamespaceCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceCreateOrUpdateParameters.
func (ncoup NamespaceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncoup.NamespaceProperties != nil {
		objectMap["properties"] = ncoup.NamespaceProperties
	}
	if ncoup.ID != nil {
		objectMap["id"] = ncoup.ID
	}
	if ncoup.Name != nil {
		objectMap["name"] = ncoup.Name
	}
	if ncoup.Type != nil {
		objectMap["type"] = ncoup.Type
	}
	if ncoup.Location != nil {
		objectMap["location"] = ncoup.Location
	}
	if ncoup.Tags != nil {
		objectMap["tags"] = ncoup.Tags
	}
	if ncoup.Sku != nil {
		objectMap["sku"] = ncoup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceCreateOrUpdateParameters struct.
func (ncoup *NamespaceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				ncoup.NamespaceProperties = &namespaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ncoup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ncoup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ncoup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ncoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncoup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ncoup.Sku = &sku
			}
		}
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]NamespaceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of NamespaceResource values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() NamespaceResource {
	if !iter.page.NotDone() {
		return NamespaceResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer() (*http.Request, error) {
	if nlr.NextLink == nil || len(to.String(nlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of NamespaceResource values.
type NamespaceListResultPage struct {
	fn  func(NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) Next() error {
	next, err := page.fn(page.nlr)
	if err != nil {
		return err
	}
	page.nlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []NamespaceResource {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// NamespacePatchParameters parameters supplied to the Patch Namespace operation.
type NamespacePatchParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespacePatchParameters.
func (npp NamespacePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if npp.Tags != nil {
		objectMap["tags"] = npp.Tags
	}
	if npp.Sku != nil {
		objectMap["sku"] = npp.Sku
	}
	return json.Marshal(objectMap)
}

// NamespaceProperties namespace properties.
type NamespaceProperties struct {
	// Name - The name of the namespace.
	Name *string `json:"name,omitempty"`
	// ProvisioningState - Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Region - Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia EastAustralia SoutheastCentral USEast USEast US 2West USNorth Central USSouth Central USEast AsiaSoutheast AsiaBrazil SouthJapan EastJapan WestNorth EuropeWest Europe
	Region *string `json:"region,omitempty"`
	// Status - Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
	Status *string `json:"status,omitempty"`
	// CreatedAt - The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform NotificationHub operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// SubscriptionID - The Id of the Azure subscription associated with the namespace.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ScaleUnit - ScaleUnit where the namespace gets created
	ScaleUnit *string `json:"scaleUnit,omitempty"`
	// Enabled - Whether or not the namespace is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Critical - Whether or not the namespace is set as Critical.
	Critical *bool `json:"critical,omitempty"`
	// NamespaceType - The namespace type. Possible values include: 'Messaging', 'NotificationHub'
	NamespaceType NamespaceType `json:"namespaceType,omitempty"`
}

// NamespaceResource description of a Namespace resource.
type NamespaceResource struct {
	autorest.Response `json:"-"`
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceResource.
func (nr NamespaceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nr.NamespaceProperties != nil {
		objectMap["properties"] = nr.NamespaceProperties
	}
	if nr.ID != nil {
		objectMap["id"] = nr.ID
	}
	if nr.Name != nil {
		objectMap["name"] = nr.Name
	}
	if nr.Type != nil {
		objectMap["type"] = nr.Type
	}
	if nr.Location != nil {
		objectMap["location"] = nr.Location
	}
	if nr.Tags != nil {
		objectMap["tags"] = nr.Tags
	}
	if nr.Sku != nil {
		objectMap["sku"] = nr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceResource struct.
func (nr *NamespaceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				nr.NamespaceProperties = &namespaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				nr.Sku = &sku
			}
		}
	}

	return nil
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type NamespacesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future NamespacesDeleteFuture) Result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "notificationhubs.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("notificationhubs.NamespacesDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "notificationhubs.NamespacesDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "notificationhubs.NamespacesDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "notificationhubs.NamespacesDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// PnsCredentialsProperties description of a NotificationHub PNS Credentials.
type PnsCredentialsProperties struct {
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// PnsCredentialsResource description of a NotificationHub PNS Credentials.
type PnsCredentialsResource struct {
	autorest.Response `json:"-"`
	// PnsCredentialsProperties - NotificationHub PNS Credentials.
	*PnsCredentialsProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for PnsCredentialsResource.
func (pcr PnsCredentialsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcr.PnsCredentialsProperties != nil {
		objectMap["properties"] = pcr.PnsCredentialsProperties
	}
	if pcr.ID != nil {
		objectMap["id"] = pcr.ID
	}
	if pcr.Name != nil {
		objectMap["name"] = pcr.Name
	}
	if pcr.Type != nil {
		objectMap["type"] = pcr.Type
	}
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.Sku != nil {
		objectMap["sku"] = pcr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PnsCredentialsResource struct.
func (pcr *PnsCredentialsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pnsCredentialsProperties PnsCredentialsProperties
				err = json.Unmarshal(*v, &pnsCredentialsProperties)
				if err != nil {
					return err
				}
				pcr.PnsCredentialsProperties = &pnsCredentialsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pcr.Sku = &sku
			}
		}
	}

	return nil
}

// PolicykeyResource namespace/NotificationHub Regenerate Keys
type PolicykeyResource struct {
	// PolicyKey - Name of the key that has to be regenerated for the Namespace/Notification Hub Authorization Rule. The value can be Primary Key/Secondary Key.
	PolicyKey *string `json:"policyKey,omitempty"`
}

// Properties notificationHub properties.
type Properties struct {
	// Name - The NotificationHub name.
	Name *string `json:"name,omitempty"`
	// RegistrationTTL - The RegistrationTtl of the created NotificationHub
	RegistrationTTL *string `json:"registrationTtl,omitempty"`
	// AuthorizationRules - The AuthorizationRules of the created NotificationHub
	AuthorizationRules *[]SharedAccessAuthorizationRuleProperties `json:"authorizationRules,omitempty"`
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// ResourceListKeys namespace/NotificationHub Connection String
type ResourceListKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - PrimaryConnectionString of the AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - SecondaryConnectionString of the created AuthorizationRule
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - PrimaryKey of the created AuthorizationRule.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - SecondaryKey of the created AuthorizationRule
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - KeyName of the created AuthorizationRule
	KeyName *string `json:"keyName,omitempty"`
}

// ResourceType description of a NotificationHub Resource.
type ResourceType struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Properties != nil {
		objectMap["properties"] = rt.Properties
	}
	if rt.ID != nil {
		objectMap["id"] = rt.ID
	}
	if rt.Name != nil {
		objectMap["name"] = rt.Name
	}
	if rt.Type != nil {
		objectMap["type"] = rt.Type
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	if rt.Sku != nil {
		objectMap["sku"] = rt.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				rt.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rt.Sku = &sku
			}
		}
	}

	return nil
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Namespace
// AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// Properties - Properties of the Namespace AuthorizationRules.
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleCreateOrUpdateParameters.
func (saarcoup SharedAccessAuthorizationRuleCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarcoup.Properties != nil {
		objectMap["properties"] = saarcoup.Properties
	}
	if saarcoup.ID != nil {
		objectMap["id"] = saarcoup.ID
	}
	if saarcoup.Name != nil {
		objectMap["name"] = saarcoup.Name
	}
	if saarcoup.Type != nil {
		objectMap["type"] = saarcoup.Type
	}
	if saarcoup.Location != nil {
		objectMap["location"] = saarcoup.Location
	}
	if saarcoup.Tags != nil {
		objectMap["tags"] = saarcoup.Tags
	}
	if saarcoup.Sku != nil {
		objectMap["sku"] = saarcoup.Sku
	}
	return json.Marshal(objectMap)
}

// SharedAccessAuthorizationRuleListResult the response of the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List AuthorizationRules operation.
	Value *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessAuthorizationRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessAuthorizationRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessAuthorizationRuleListResultIterator) Response() SharedAccessAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessAuthorizationRuleListResultIterator) Value() SharedAccessAuthorizationRuleResource {
	if !iter.page.NotDone() {
		return SharedAccessAuthorizationRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (saarlr SharedAccessAuthorizationRuleListResult) IsEmpty() bool {
	return saarlr.Value == nil || len(*saarlr.Value) == 0
}

// sharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saarlr SharedAccessAuthorizationRuleListResult) sharedAccessAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if saarlr.NextLink == nil || len(to.String(saarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saarlr.NextLink)))
}

// SharedAccessAuthorizationRuleListResultPage contains a page of SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultPage struct {
	fn     func(SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)
	saarlr SharedAccessAuthorizationRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessAuthorizationRuleListResultPage) Next() error {
	next, err := page.fn(page.saarlr)
	if err != nil {
		return err
	}
	page.saarlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessAuthorizationRuleListResultPage) NotDone() bool {
	return !page.saarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessAuthorizationRuleListResultPage) Response() SharedAccessAuthorizationRuleListResult {
	return page.saarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessAuthorizationRuleListResultPage) Values() []SharedAccessAuthorizationRuleResource {
	if page.saarlr.IsEmpty() {
		return nil
	}
	return *page.saarlr.Value
}

// SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SharedAccessAuthorizationRuleResource description of a Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response `json:"-"`
	// SharedAccessAuthorizationRuleProperties - Pproperties of the Namespace AuthorizationRule.
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleResource.
func (saarr SharedAccessAuthorizationRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarr.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarr.SharedAccessAuthorizationRuleProperties
	}
	if saarr.ID != nil {
		objectMap["id"] = saarr.ID
	}
	if saarr.Name != nil {
		objectMap["name"] = saarr.Name
	}
	if saarr.Type != nil {
		objectMap["type"] = saarr.Type
	}
	if saarr.Location != nil {
		objectMap["location"] = saarr.Location
	}
	if saarr.Tags != nil {
		objectMap["tags"] = saarr.Tags
	}
	if saarr.Sku != nil {
		objectMap["sku"] = saarr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleResource struct.
func (saarr *SharedAccessAuthorizationRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarr.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saarr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saarr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				saarr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				saarr.Sku = &sku
			}
		}
	}

	return nil
}

// Sku the Sku description for a namespace
type Sku struct {
	// Name - Name of the notification hub sku. Possible values include: 'Free', 'Basic', 'Standard'
	Name SkuName `json:"name,omitempty"`
	// Tier - The tier of particular sku
	Tier *string `json:"tier,omitempty"`
	// Size - The Sku size
	Size *string `json:"size,omitempty"`
	// Family - The Sku Family
	Family *string `json:"family,omitempty"`
	// Capacity - The capacity of the resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// WnsCredential description of a NotificationHub WnsCredential.
type WnsCredential struct {
	// WnsCredentialProperties - Properties of NotificationHub WnsCredential.
	*WnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WnsCredential.
func (wc WnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WnsCredentialProperties != nil {
		objectMap["properties"] = wc.WnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WnsCredential struct.
func (wc *WnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var wnsCredentialProperties WnsCredentialProperties
				err = json.Unmarshal(*v, &wnsCredentialProperties)
				if err != nil {
					return err
				}
				wc.WnsCredentialProperties = &wnsCredentialProperties
			}
		}
	}

	return nil
}

// WnsCredentialProperties description of a NotificationHub WnsCredential.
type WnsCredentialProperties struct {
	// PackageSid - The package ID for this credential.
	PackageSid *string `json:"packageSid,omitempty"`
	// SecretKey - The secret key.
	SecretKey *string `json:"secretKey,omitempty"`
	// WindowsLiveEndpoint - The Windows Live endpoint.
	WindowsLiveEndpoint *string `json:"windowsLiveEndpoint,omitempty"`
}
