/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/operator-framework/operator-marketplace/pkg/apis/marketplace/v1alpha1"
	scheme "github.com/operator-framework/operator-marketplace/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CatalogSourceConfigsGetter has a method to return a CatalogSourceConfigInterface.
// A group's client should implement this interface.
type CatalogSourceConfigsGetter interface {
	CatalogSourceConfigs(namespace string) CatalogSourceConfigInterface
}

// CatalogSourceConfigInterface has methods to work with CatalogSourceConfig resources.
type CatalogSourceConfigInterface interface {
	Create(*v1alpha1.CatalogSourceConfig) (*v1alpha1.CatalogSourceConfig, error)
	Update(*v1alpha1.CatalogSourceConfig) (*v1alpha1.CatalogSourceConfig, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.CatalogSourceConfig, error)
	List(opts v1.ListOptions) (*v1alpha1.CatalogSourceConfigList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CatalogSourceConfig, err error)
	CatalogSourceConfigExpansion
}

// catalogSourceConfigs implements CatalogSourceConfigInterface
type catalogSourceConfigs struct {
	client rest.Interface
	ns     string
}

// newCatalogSourceConfigs returns a CatalogSourceConfigs
func newCatalogSourceConfigs(c *MarketplaceV1alpha1Client, namespace string) *catalogSourceConfigs {
	return &catalogSourceConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the catalogSourceConfig, and returns the corresponding catalogSourceConfig object, and an error if there is any.
func (c *catalogSourceConfigs) Get(name string, options v1.GetOptions) (result *v1alpha1.CatalogSourceConfig, err error) {
	result = &v1alpha1.CatalogSourceConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CatalogSourceConfigs that match those selectors.
func (c *catalogSourceConfigs) List(opts v1.ListOptions) (result *v1alpha1.CatalogSourceConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.CatalogSourceConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested catalogSourceConfigs.
func (c *catalogSourceConfigs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a catalogSourceConfig and creates it.  Returns the server's representation of the catalogSourceConfig, and an error, if there is any.
func (c *catalogSourceConfigs) Create(catalogSourceConfig *v1alpha1.CatalogSourceConfig) (result *v1alpha1.CatalogSourceConfig, err error) {
	result = &v1alpha1.CatalogSourceConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		Body(catalogSourceConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a catalogSourceConfig and updates it. Returns the server's representation of the catalogSourceConfig, and an error, if there is any.
func (c *catalogSourceConfigs) Update(catalogSourceConfig *v1alpha1.CatalogSourceConfig) (result *v1alpha1.CatalogSourceConfig, err error) {
	result = &v1alpha1.CatalogSourceConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		Name(catalogSourceConfig.Name).
		Body(catalogSourceConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the catalogSourceConfig and deletes it. Returns an error if one occurs.
func (c *catalogSourceConfigs) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *catalogSourceConfigs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched catalogSourceConfig.
func (c *catalogSourceConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.CatalogSourceConfig, err error) {
	result = &v1alpha1.CatalogSourceConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("catalogsourceconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
