// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetResourceConfig = "BatchGetResourceConfig"

// BatchGetResourceConfigRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetResourceConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetResourceConfig for more information on using the BatchGetResourceConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetResourceConfigRequest method.
//    req, resp := client.BatchGetResourceConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfigRequest(input *BatchGetResourceConfigInput) (req *request.Request, output *BatchGetResourceConfigOutput) {
	op := &request.Operation{
		Name:       opBatchGetResourceConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetResourceConfigInput{}
	}

	output = &BatchGetResourceConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetResourceConfig API operation for AWS Config.
//
// Returns the current configuration for one or more requested resources. The
// operation also returns a list of resources that are not processed in the
// current request. If there are no unprocessed resources, the operation returns
// an empty unprocessedResourceKeys list.
//
// The API does not return results for deleted resources.
//
//  The API does not return any tags for the requested resources. This information
// is filtered out of the supplementaryConfiguration section of the API response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation BatchGetResourceConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig
func (c *ConfigService) BatchGetResourceConfig(input *BatchGetResourceConfigInput) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	return out, req.Send()
}

// BatchGetResourceConfigWithContext is the same as BatchGetResourceConfig with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetResourceConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) BatchGetResourceConfigWithContext(ctx aws.Context, input *BatchGetResourceConfigInput, opts ...request.Option) (*BatchGetResourceConfigOutput, error) {
	req, out := c.BatchGetResourceConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAggregationAuthorization = "DeleteAggregationAuthorization"

// DeleteAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAggregationAuthorization for more information on using the DeleteAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAggregationAuthorizationRequest method.
//    req, resp := client.DeleteAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorizationRequest(input *DeleteAggregationAuthorizationInput) (req *request.Request, output *DeleteAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAggregationAuthorizationInput{}
	}

	output = &DeleteAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAggregationAuthorization API operation for AWS Config.
//
// Deletes the authorization granted to the specified configuration aggregator
// account in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteAggregationAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization
func (c *ConfigService) DeleteAggregationAuthorization(input *DeleteAggregationAuthorizationInput) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteAggregationAuthorizationWithContext is the same as DeleteAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteAggregationAuthorizationWithContext(ctx aws.Context, input *DeleteAggregationAuthorizationInput, opts ...request.Option) (*DeleteAggregationAuthorizationOutput, error) {
	req, out := c.DeleteAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigRule = "DeleteConfigRule"

// DeleteConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigRule for more information on using the DeleteConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigRuleRequest method.
//    req, resp := client.DeleteConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRuleRequest(input *DeleteConfigRuleInput) (req *request.Request, output *DeleteConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigRuleInput{}
	}

	output = &DeleteConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigRule API operation for AWS Config.
//
// Deletes the specified AWS Config rule and all of its evaluation results.
//
// AWS Config sets the state of a rule to DELETING until the deletion is complete.
// You cannot update a rule while it is in this state. If you make a PutConfigRule
// or DeleteConfigRule request for the rule, you will receive a ResourceInUseException.
//
// You can check the state of a rule by using the DescribeConfigRules request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The rule is currently being deleted or the rule is deleting your evaluation
//   results. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule
func (c *ConfigService) DeleteConfigRule(input *DeleteConfigRuleInput) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	return out, req.Send()
}

// DeleteConfigRuleWithContext is the same as DeleteConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigRuleWithContext(ctx aws.Context, input *DeleteConfigRuleInput, opts ...request.Option) (*DeleteConfigRuleOutput, error) {
	req, out := c.DeleteConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationAggregator = "DeleteConfigurationAggregator"

// DeleteConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationAggregator for more information on using the DeleteConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationAggregatorRequest method.
//    req, resp := client.DeleteConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregatorRequest(input *DeleteConfigurationAggregatorInput) (req *request.Request, output *DeleteConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationAggregatorInput{}
	}

	output = &DeleteConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationAggregator API operation for AWS Config.
//
// Deletes the specified configuration aggregator and the aggregated data associated
// with the aggregator.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationAggregator for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator
func (c *ConfigService) DeleteConfigurationAggregator(input *DeleteConfigurationAggregatorInput) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// DeleteConfigurationAggregatorWithContext is the same as DeleteConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationAggregatorWithContext(ctx aws.Context, input *DeleteConfigurationAggregatorInput, opts ...request.Option) (*DeleteConfigurationAggregatorOutput, error) {
	req, out := c.DeleteConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationRecorder = "DeleteConfigurationRecorder"

// DeleteConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfigurationRecorder for more information on using the DeleteConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigurationRecorderRequest method.
//    req, resp := client.DeleteConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorderRequest(input *DeleteConfigurationRecorderInput) (req *request.Request, output *DeleteConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationRecorderInput{}
	}

	output = &DeleteConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfigurationRecorder API operation for AWS Config.
//
// Deletes the configuration recorder.
//
// After the configuration recorder is deleted, AWS Config will not record resource
// configuration changes until you create a new configuration recorder.
//
// This action does not delete the configuration information that was previously
// recorded. You will be able to access the previously recorded information
// by using the GetResourceConfigHistory action, but you will not be able to
// access this information in the AWS Config console until you create a new
// configuration recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteConfigurationRecorder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationRecorderException "NoSuchConfigurationRecorderException"
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder
func (c *ConfigService) DeleteConfigurationRecorder(input *DeleteConfigurationRecorderInput) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	return out, req.Send()
}

// DeleteConfigurationRecorderWithContext is the same as DeleteConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteConfigurationRecorderWithContext(ctx aws.Context, input *DeleteConfigurationRecorderInput, opts ...request.Option) (*DeleteConfigurationRecorderOutput, error) {
	req, out := c.DeleteConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeliveryChannel = "DeleteDeliveryChannel"

// DeleteDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeliveryChannel for more information on using the DeleteDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeliveryChannelRequest method.
//    req, resp := client.DeleteDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannelRequest(input *DeleteDeliveryChannelInput) (req *request.Request, output *DeleteDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryChannelInput{}
	}

	output = &DeleteDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeliveryChannel API operation for AWS Config.
//
// Deletes the delivery channel.
//
// Before you can delete the delivery channel, you must stop the configuration
// recorder by using the StopConfigurationRecorder action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteDeliveryChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDeliveryChannelException "NoSuchDeliveryChannelException"
//   You have specified a delivery channel that does not exist.
//
//   * ErrCodeLastDeliveryChannelDeleteFailedException "LastDeliveryChannelDeleteFailedException"
//   You cannot delete the delivery channel you specified because the configuration
//   recorder is running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel
func (c *ConfigService) DeleteDeliveryChannel(input *DeleteDeliveryChannelInput) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	return out, req.Send()
}

// DeleteDeliveryChannelWithContext is the same as DeleteDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteDeliveryChannelWithContext(ctx aws.Context, input *DeleteDeliveryChannelInput, opts ...request.Option) (*DeleteDeliveryChannelOutput, error) {
	req, out := c.DeleteDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvaluationResults = "DeleteEvaluationResults"

// DeleteEvaluationResultsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvaluationResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvaluationResults for more information on using the DeleteEvaluationResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEvaluationResultsRequest method.
//    req, resp := client.DeleteEvaluationResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResultsRequest(input *DeleteEvaluationResultsInput) (req *request.Request, output *DeleteEvaluationResultsOutput) {
	op := &request.Operation{
		Name:       opDeleteEvaluationResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationResultsInput{}
	}

	output = &DeleteEvaluationResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEvaluationResults API operation for AWS Config.
//
// Deletes the evaluation results for the specified AWS Config rule. You can
// specify one AWS Config rule per request. After you delete the evaluation
// results, you can call the StartConfigRulesEvaluation API to start evaluating
// your AWS resources against the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteEvaluationResults for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The rule is currently being deleted or the rule is deleting your evaluation
//   results. Try your request again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults
func (c *ConfigService) DeleteEvaluationResults(input *DeleteEvaluationResultsInput) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	return out, req.Send()
}

// DeleteEvaluationResultsWithContext is the same as DeleteEvaluationResults with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvaluationResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteEvaluationResultsWithContext(ctx aws.Context, input *DeleteEvaluationResultsInput, opts ...request.Option) (*DeleteEvaluationResultsOutput, error) {
	req, out := c.DeleteEvaluationResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePendingAggregationRequest = "DeletePendingAggregationRequest"

// DeletePendingAggregationRequestRequest generates a "aws/request.Request" representing the
// client's request for the DeletePendingAggregationRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePendingAggregationRequest for more information on using the DeletePendingAggregationRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePendingAggregationRequestRequest method.
//    req, resp := client.DeletePendingAggregationRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequestRequest(input *DeletePendingAggregationRequestInput) (req *request.Request, output *DeletePendingAggregationRequestOutput) {
	op := &request.Operation{
		Name:       opDeletePendingAggregationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePendingAggregationRequestInput{}
	}

	output = &DeletePendingAggregationRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePendingAggregationRequest API operation for AWS Config.
//
// Deletes pending authorization requests for a specified aggregator account
// in a specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeletePendingAggregationRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest
func (c *ConfigService) DeletePendingAggregationRequest(input *DeletePendingAggregationRequestInput) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	return out, req.Send()
}

// DeletePendingAggregationRequestWithContext is the same as DeletePendingAggregationRequest with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePendingAggregationRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeletePendingAggregationRequestWithContext(ctx aws.Context, input *DeletePendingAggregationRequestInput, opts ...request.Option) (*DeletePendingAggregationRequestOutput, error) {
	req, out := c.DeletePendingAggregationRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRetentionConfiguration = "DeleteRetentionConfiguration"

// DeleteRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRetentionConfiguration for more information on using the DeleteRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRetentionConfigurationRequest method.
//    req, resp := client.DeleteRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfigurationRequest(input *DeleteRetentionConfigurationInput) (req *request.Request, output *DeleteRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRetentionConfigurationInput{}
	}

	output = &DeleteRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRetentionConfiguration API operation for AWS Config.
//
// Deletes the retention configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeleteRetentionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeNoSuchRetentionConfigurationException "NoSuchRetentionConfigurationException"
//   You have specified a retention configuration that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration
func (c *ConfigService) DeleteRetentionConfiguration(input *DeleteRetentionConfigurationInput) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	return out, req.Send()
}

// DeleteRetentionConfigurationWithContext is the same as DeleteRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeleteRetentionConfigurationWithContext(ctx aws.Context, input *DeleteRetentionConfigurationInput, opts ...request.Option) (*DeleteRetentionConfigurationOutput, error) {
	req, out := c.DeleteRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeliverConfigSnapshot = "DeliverConfigSnapshot"

// DeliverConfigSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeliverConfigSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeliverConfigSnapshot for more information on using the DeliverConfigSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeliverConfigSnapshotRequest method.
//    req, resp := client.DeliverConfigSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshotRequest(input *DeliverConfigSnapshotInput) (req *request.Request, output *DeliverConfigSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeliverConfigSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeliverConfigSnapshotInput{}
	}

	output = &DeliverConfigSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeliverConfigSnapshot API operation for AWS Config.
//
// Schedules delivery of a configuration snapshot to the Amazon S3 bucket in
// the specified delivery channel. After the delivery has started, AWS Config
// sends the following notifications using an Amazon SNS topic that you have
// specified.
//
//    * Notification of the start of the delivery.
//
//    * Notification of the completion of the delivery, if the delivery was
//    successfully completed.
//
//    * Notification of delivery failure, if the delivery failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DeliverConfigSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDeliveryChannelException "NoSuchDeliveryChannelException"
//   You have specified a delivery channel that does not exist.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * ErrCodeNoRunningConfigurationRecorderException "NoRunningConfigurationRecorderException"
//   There is no configuration recorder running.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot
func (c *ConfigService) DeliverConfigSnapshot(input *DeliverConfigSnapshotInput) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	return out, req.Send()
}

// DeliverConfigSnapshotWithContext is the same as DeliverConfigSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeliverConfigSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DeliverConfigSnapshotWithContext(ctx aws.Context, input *DeliverConfigSnapshotInput, opts ...request.Option) (*DeliverConfigSnapshotOutput, error) {
	req, out := c.DeliverConfigSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregateComplianceByConfigRules = "DescribeAggregateComplianceByConfigRules"

// DescribeAggregateComplianceByConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregateComplianceByConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregateComplianceByConfigRules for more information on using the DescribeAggregateComplianceByConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregateComplianceByConfigRulesRequest method.
//    req, resp := client.DescribeAggregateComplianceByConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesRequest(input *DescribeAggregateComplianceByConfigRulesInput) (req *request.Request, output *DescribeAggregateComplianceByConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregateComplianceByConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConfigRulesInput{}
	}

	output = &DescribeAggregateComplianceByConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregateComplianceByConfigRules API operation for AWS Config.
//
// Returns a list of compliant and noncompliant rules with the number of resources
// for compliant and noncompliant rules.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregateComplianceByConfigRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *ConfigService) DescribeAggregateComplianceByConfigRules(input *DescribeAggregateComplianceByConfigRulesInput) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeAggregateComplianceByConfigRulesWithContext is the same as DescribeAggregateComplianceByConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregateComplianceByConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregateComplianceByConfigRulesWithContext(ctx aws.Context, input *DescribeAggregateComplianceByConfigRulesInput, opts ...request.Option) (*DescribeAggregateComplianceByConfigRulesOutput, error) {
	req, out := c.DescribeAggregateComplianceByConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAggregationAuthorizations = "DescribeAggregationAuthorizations"

// DescribeAggregationAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAggregationAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAggregationAuthorizations for more information on using the DescribeAggregationAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAggregationAuthorizationsRequest method.
//    req, resp := client.DescribeAggregationAuthorizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizationsRequest(input *DescribeAggregationAuthorizationsInput) (req *request.Request, output *DescribeAggregationAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAggregationAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregationAuthorizationsInput{}
	}

	output = &DescribeAggregationAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAggregationAuthorizations API operation for AWS Config.
//
// Returns a list of authorizations granted to various aggregator accounts and
// regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeAggregationAuthorizations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations
func (c *ConfigService) DescribeAggregationAuthorizations(input *DescribeAggregationAuthorizationsInput) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	return out, req.Send()
}

// DescribeAggregationAuthorizationsWithContext is the same as DescribeAggregationAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAggregationAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeAggregationAuthorizationsWithContext(ctx aws.Context, input *DescribeAggregationAuthorizationsInput, opts ...request.Option) (*DescribeAggregationAuthorizationsOutput, error) {
	req, out := c.DescribeAggregationAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComplianceByConfigRule = "DescribeComplianceByConfigRule"

// DescribeComplianceByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByConfigRule for more information on using the DescribeComplianceByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByConfigRuleRequest method.
//    req, resp := client.DescribeComplianceByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRuleRequest(input *DescribeComplianceByConfigRuleInput) (req *request.Request, output *DescribeComplianceByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByConfigRuleInput{}
	}

	output = &DescribeComplianceByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByConfigRule API operation for AWS Config.
//
// Indicates whether the specified AWS Config rules are compliant. If a rule
// is noncompliant, this action returns the number of AWS resources that do
// not comply with the rule.
//
// A rule is compliant if all of the evaluated resources comply with it. It
// is noncompliant if any of these resources do not comply.
//
// If AWS Config has no current evaluation results for the rule, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByConfigRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule
func (c *ConfigService) DescribeComplianceByConfigRule(input *DescribeComplianceByConfigRuleInput) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	return out, req.Send()
}

// DescribeComplianceByConfigRuleWithContext is the same as DescribeComplianceByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByConfigRuleWithContext(ctx aws.Context, input *DescribeComplianceByConfigRuleInput, opts ...request.Option) (*DescribeComplianceByConfigRuleOutput, error) {
	req, out := c.DescribeComplianceByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeComplianceByResource = "DescribeComplianceByResource"

// DescribeComplianceByResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeComplianceByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeComplianceByResource for more information on using the DescribeComplianceByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeComplianceByResourceRequest method.
//    req, resp := client.DescribeComplianceByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResourceRequest(input *DescribeComplianceByResourceInput) (req *request.Request, output *DescribeComplianceByResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeComplianceByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComplianceByResourceInput{}
	}

	output = &DescribeComplianceByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeComplianceByResource API operation for AWS Config.
//
// Indicates whether the specified AWS resources are compliant. If a resource
// is noncompliant, this action returns the number of AWS Config rules that
// the resource does not comply with.
//
// A resource is compliant if it complies with all the AWS Config rules that
// evaluate it. It is noncompliant if it does not comply with one or more of
// these rules.
//
// If AWS Config has no current evaluation results for the resource, it returns
// INSUFFICIENT_DATA. This result might indicate one of the following conditions
// about the rules that evaluate the resource:
//
//    * AWS Config has never invoked an evaluation for the rule. To check whether
//    it has, use the DescribeConfigRuleEvaluationStatus action to get the LastSuccessfulInvocationTime
//    and LastFailedInvocationTime.
//
//    * The rule's AWS Lambda function is failing to send evaluation results
//    to AWS Config. Verify that the role that you assigned to your configuration
//    recorder includes the config:PutEvaluations permission. If the rule is
//    a custom rule, verify that the AWS Lambda execution role includes the
//    config:PutEvaluations permission.
//
//    * The rule's AWS Lambda function has returned NOT_APPLICABLE for all evaluation
//    results. This can occur if the resources were deleted or removed from
//    the rule's scope.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeComplianceByResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource
func (c *ConfigService) DescribeComplianceByResource(input *DescribeComplianceByResourceInput) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	return out, req.Send()
}

// DescribeComplianceByResourceWithContext is the same as DescribeComplianceByResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeComplianceByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeComplianceByResourceWithContext(ctx aws.Context, input *DescribeComplianceByResourceInput, opts ...request.Option) (*DescribeComplianceByResourceOutput, error) {
	req, out := c.DescribeComplianceByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigRuleEvaluationStatus = "DescribeConfigRuleEvaluationStatus"

// DescribeConfigRuleEvaluationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRuleEvaluationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRuleEvaluationStatus for more information on using the DescribeConfigRuleEvaluationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRuleEvaluationStatusRequest method.
//    req, resp := client.DescribeConfigRuleEvaluationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatusRequest(input *DescribeConfigRuleEvaluationStatusInput) (req *request.Request, output *DescribeConfigRuleEvaluationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRuleEvaluationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRuleEvaluationStatusInput{}
	}

	output = &DescribeConfigRuleEvaluationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRuleEvaluationStatus API operation for AWS Config.
//
// Returns status information for each of your AWS managed Config rules. The
// status includes information such as the last time AWS Config invoked the
// rule, the last time AWS Config failed to invoke the rule, and the related
// error for the last failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRuleEvaluationStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus
func (c *ConfigService) DescribeConfigRuleEvaluationStatus(input *DescribeConfigRuleEvaluationStatusInput) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigRuleEvaluationStatusWithContext is the same as DescribeConfigRuleEvaluationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRuleEvaluationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRuleEvaluationStatusWithContext(ctx aws.Context, input *DescribeConfigRuleEvaluationStatusInput, opts ...request.Option) (*DescribeConfigRuleEvaluationStatusOutput, error) {
	req, out := c.DescribeConfigRuleEvaluationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigRules = "DescribeConfigRules"

// DescribeConfigRulesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigRules for more information on using the DescribeConfigRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigRulesRequest method.
//    req, resp := client.DescribeConfigRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRulesRequest(input *DescribeConfigRulesInput) (req *request.Request, output *DescribeConfigRulesOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigRulesInput{}
	}

	output = &DescribeConfigRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigRules API operation for AWS Config.
//
// Returns details about your AWS Config rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules
func (c *ConfigService) DescribeConfigRules(input *DescribeConfigRulesInput) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	return out, req.Send()
}

// DescribeConfigRulesWithContext is the same as DescribeConfigRules with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigRulesWithContext(ctx aws.Context, input *DescribeConfigRulesInput, opts ...request.Option) (*DescribeConfigRulesOutput, error) {
	req, out := c.DescribeConfigRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationAggregatorSourcesStatus = "DescribeConfigurationAggregatorSourcesStatus"

// DescribeConfigurationAggregatorSourcesStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregatorSourcesStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregatorSourcesStatus for more information on using the DescribeConfigurationAggregatorSourcesStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorSourcesStatusRequest method.
//    req, resp := client.DescribeConfigurationAggregatorSourcesStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusRequest(input *DescribeConfigurationAggregatorSourcesStatusInput) (req *request.Request, output *DescribeConfigurationAggregatorSourcesStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregatorSourcesStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorSourcesStatusInput{}
	}

	output = &DescribeConfigurationAggregatorSourcesStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregatorSourcesStatus API operation for AWS Config.
//
// Returns status information for sources within an aggregator. The status includes
// information about the last time AWS Config aggregated data from source accounts
// or AWS Config failed to aggregate data from source accounts with the related
// error code or message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregatorSourcesStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatus(input *DescribeConfigurationAggregatorSourcesStatusInput) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorSourcesStatusWithContext is the same as DescribeConfigurationAggregatorSourcesStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregatorSourcesStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorSourcesStatusWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorSourcesStatusInput, opts ...request.Option) (*DescribeConfigurationAggregatorSourcesStatusOutput, error) {
	req, out := c.DescribeConfigurationAggregatorSourcesStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationAggregators = "DescribeConfigurationAggregators"

// DescribeConfigurationAggregatorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationAggregators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationAggregators for more information on using the DescribeConfigurationAggregators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationAggregatorsRequest method.
//    req, resp := client.DescribeConfigurationAggregatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregatorsRequest(input *DescribeConfigurationAggregatorsInput) (req *request.Request, output *DescribeConfigurationAggregatorsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationAggregators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationAggregatorsInput{}
	}

	output = &DescribeConfigurationAggregatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationAggregators API operation for AWS Config.
//
// Returns the details of one or more configuration aggregators. If the configuration
// aggregator is not specified, this action returns the details for all the
// configuration aggregators associated with the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationAggregators for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators
func (c *ConfigService) DescribeConfigurationAggregators(input *DescribeConfigurationAggregatorsInput) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	return out, req.Send()
}

// DescribeConfigurationAggregatorsWithContext is the same as DescribeConfigurationAggregators with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationAggregators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationAggregatorsWithContext(ctx aws.Context, input *DescribeConfigurationAggregatorsInput, opts ...request.Option) (*DescribeConfigurationAggregatorsOutput, error) {
	req, out := c.DescribeConfigurationAggregatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRecorderStatus = "DescribeConfigurationRecorderStatus"

// DescribeConfigurationRecorderStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorderStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorderStatus for more information on using the DescribeConfigurationRecorderStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecorderStatusRequest method.
//    req, resp := client.DescribeConfigurationRecorderStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatusRequest(input *DescribeConfigurationRecorderStatusInput) (req *request.Request, output *DescribeConfigurationRecorderStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorderStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecorderStatusInput{}
	}

	output = &DescribeConfigurationRecorderStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorderStatus API operation for AWS Config.
//
// Returns the current status of the specified configuration recorder. If a
// configuration recorder is not specified, this action returns the status of
// all configuration recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorderStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationRecorderException "NoSuchConfigurationRecorderException"
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus
func (c *ConfigService) DescribeConfigurationRecorderStatus(input *DescribeConfigurationRecorderStatusInput) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecorderStatusWithContext is the same as DescribeConfigurationRecorderStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorderStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecorderStatusWithContext(ctx aws.Context, input *DescribeConfigurationRecorderStatusInput, opts ...request.Option) (*DescribeConfigurationRecorderStatusOutput, error) {
	req, out := c.DescribeConfigurationRecorderStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationRecorders = "DescribeConfigurationRecorders"

// DescribeConfigurationRecordersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationRecorders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConfigurationRecorders for more information on using the DescribeConfigurationRecorders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConfigurationRecordersRequest method.
//    req, resp := client.DescribeConfigurationRecordersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecordersRequest(input *DescribeConfigurationRecordersInput) (req *request.Request, output *DescribeConfigurationRecordersOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationRecorders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationRecordersInput{}
	}

	output = &DescribeConfigurationRecordersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationRecorders API operation for AWS Config.
//
// Returns the details for the specified configuration recorders. If the configuration
// recorder is not specified, this action returns the details for all configuration
// recorders associated with the account.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeConfigurationRecorders for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationRecorderException "NoSuchConfigurationRecorderException"
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders
func (c *ConfigService) DescribeConfigurationRecorders(input *DescribeConfigurationRecordersInput) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	return out, req.Send()
}

// DescribeConfigurationRecordersWithContext is the same as DescribeConfigurationRecorders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationRecorders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeConfigurationRecordersWithContext(ctx aws.Context, input *DescribeConfigurationRecordersInput, opts ...request.Option) (*DescribeConfigurationRecordersOutput, error) {
	req, out := c.DescribeConfigurationRecordersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryChannelStatus = "DescribeDeliveryChannelStatus"

// DescribeDeliveryChannelStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannelStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannelStatus for more information on using the DescribeDeliveryChannelStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelStatusRequest method.
//    req, resp := client.DescribeDeliveryChannelStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatusRequest(input *DescribeDeliveryChannelStatusInput) (req *request.Request, output *DescribeDeliveryChannelStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannelStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelStatusInput{}
	}

	output = &DescribeDeliveryChannelStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannelStatus API operation for AWS Config.
//
// Returns the current status of the specified delivery channel. If a delivery
// channel is not specified, this action returns the current status of all delivery
// channels associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannelStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDeliveryChannelException "NoSuchDeliveryChannelException"
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus
func (c *ConfigService) DescribeDeliveryChannelStatus(input *DescribeDeliveryChannelStatusInput) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelStatusWithContext is the same as DescribeDeliveryChannelStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannelStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelStatusWithContext(ctx aws.Context, input *DescribeDeliveryChannelStatusInput, opts ...request.Option) (*DescribeDeliveryChannelStatusOutput, error) {
	req, out := c.DescribeDeliveryChannelStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryChannels = "DescribeDeliveryChannels"

// DescribeDeliveryChannelsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryChannels for more information on using the DescribeDeliveryChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeliveryChannelsRequest method.
//    req, resp := client.DescribeDeliveryChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannelsRequest(input *DescribeDeliveryChannelsInput) (req *request.Request, output *DescribeDeliveryChannelsOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryChannelsInput{}
	}

	output = &DescribeDeliveryChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryChannels API operation for AWS Config.
//
// Returns details about the specified delivery channel. If a delivery channel
// is not specified, this action returns the details of all delivery channels
// associated with the account.
//
// Currently, you can specify only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeDeliveryChannels for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchDeliveryChannelException "NoSuchDeliveryChannelException"
//   You have specified a delivery channel that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels
func (c *ConfigService) DescribeDeliveryChannels(input *DescribeDeliveryChannelsInput) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	return out, req.Send()
}

// DescribeDeliveryChannelsWithContext is the same as DescribeDeliveryChannels with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeDeliveryChannelsWithContext(ctx aws.Context, input *DescribeDeliveryChannelsInput, opts ...request.Option) (*DescribeDeliveryChannelsOutput, error) {
	req, out := c.DescribeDeliveryChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePendingAggregationRequests = "DescribePendingAggregationRequests"

// DescribePendingAggregationRequestsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingAggregationRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingAggregationRequests for more information on using the DescribePendingAggregationRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingAggregationRequestsRequest method.
//    req, resp := client.DescribePendingAggregationRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequestsRequest(input *DescribePendingAggregationRequestsInput) (req *request.Request, output *DescribePendingAggregationRequestsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingAggregationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePendingAggregationRequestsInput{}
	}

	output = &DescribePendingAggregationRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingAggregationRequests API operation for AWS Config.
//
// Returns a list of all pending aggregation requests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribePendingAggregationRequests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests
func (c *ConfigService) DescribePendingAggregationRequests(input *DescribePendingAggregationRequestsInput) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	return out, req.Send()
}

// DescribePendingAggregationRequestsWithContext is the same as DescribePendingAggregationRequests with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingAggregationRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribePendingAggregationRequestsWithContext(ctx aws.Context, input *DescribePendingAggregationRequestsInput, opts ...request.Option) (*DescribePendingAggregationRequestsOutput, error) {
	req, out := c.DescribePendingAggregationRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRetentionConfigurations = "DescribeRetentionConfigurations"

// DescribeRetentionConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRetentionConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRetentionConfigurations for more information on using the DescribeRetentionConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRetentionConfigurationsRequest method.
//    req, resp := client.DescribeRetentionConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurationsRequest(input *DescribeRetentionConfigurationsInput) (req *request.Request, output *DescribeRetentionConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeRetentionConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRetentionConfigurationsInput{}
	}

	output = &DescribeRetentionConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRetentionConfigurations API operation for AWS Config.
//
// Returns the details of one or more retention configurations. If the retention
// configuration name is not specified, this action returns the details for
// all the retention configurations for that account.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation DescribeRetentionConfigurations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeNoSuchRetentionConfigurationException "NoSuchRetentionConfigurationException"
//   You have specified a retention configuration that does not exist.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations
func (c *ConfigService) DescribeRetentionConfigurations(input *DescribeRetentionConfigurationsInput) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeRetentionConfigurationsWithContext is the same as DescribeRetentionConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRetentionConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) DescribeRetentionConfigurationsWithContext(ctx aws.Context, input *DescribeRetentionConfigurationsInput, opts ...request.Option) (*DescribeRetentionConfigurationsOutput, error) {
	req, out := c.DescribeRetentionConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateComplianceDetailsByConfigRule = "GetAggregateComplianceDetailsByConfigRule"

// GetAggregateComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateComplianceDetailsByConfigRule for more information on using the GetAggregateComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetAggregateComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleRequest(input *GetAggregateComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetAggregateComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetAggregateComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateComplianceDetailsByConfigRuleInput{}
	}

	output = &GetAggregateComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS Config rule for a specific
// resource in a rule. The results indicate which AWS resources were evaluated
// by the rule, when each resource was last evaluated, and whether each resource
// complies with the rule.
//
// The results can return an empty result page. But if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRule(input *GetAggregateComplianceDetailsByConfigRuleInput) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetAggregateComplianceDetailsByConfigRuleWithContext is the same as GetAggregateComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetAggregateComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetAggregateComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetAggregateComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAggregateConfigRuleComplianceSummary = "GetAggregateConfigRuleComplianceSummary"

// GetAggregateConfigRuleComplianceSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAggregateConfigRuleComplianceSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAggregateConfigRuleComplianceSummary for more information on using the GetAggregateConfigRuleComplianceSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAggregateConfigRuleComplianceSummaryRequest method.
//    req, resp := client.GetAggregateConfigRuleComplianceSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryRequest(input *GetAggregateConfigRuleComplianceSummaryInput) (req *request.Request, output *GetAggregateConfigRuleComplianceSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAggregateConfigRuleComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	output = &GetAggregateConfigRuleComplianceSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAggregateConfigRuleComplianceSummary API operation for AWS Config.
//
// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetAggregateConfigRuleComplianceSummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoSuchConfigurationAggregatorException "NoSuchConfigurationAggregatorException"
//   You have specified a configuration aggregator that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *ConfigService) GetAggregateConfigRuleComplianceSummary(input *GetAggregateConfigRuleComplianceSummaryInput) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	return out, req.Send()
}

// GetAggregateConfigRuleComplianceSummaryWithContext is the same as GetAggregateConfigRuleComplianceSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetAggregateConfigRuleComplianceSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetAggregateConfigRuleComplianceSummaryWithContext(ctx aws.Context, input *GetAggregateConfigRuleComplianceSummaryInput, opts ...request.Option) (*GetAggregateConfigRuleComplianceSummaryOutput, error) {
	req, out := c.GetAggregateConfigRuleComplianceSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetailsByConfigRule = "GetComplianceDetailsByConfigRule"

// GetComplianceDetailsByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByConfigRule for more information on using the GetComplianceDetailsByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByConfigRuleRequest method.
//    req, resp := client.GetComplianceDetailsByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRuleRequest(input *GetComplianceDetailsByConfigRuleInput) (req *request.Request, output *GetComplianceDetailsByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailsByConfigRuleInput{}
	}

	output = &GetComplianceDetailsByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByConfigRule API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS Config rule. The results
// indicate which AWS resources were evaluated by the rule, when each resource
// was last evaluated, and whether each resource complies with the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByConfigRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule
func (c *ConfigService) GetComplianceDetailsByConfigRule(input *GetComplianceDetailsByConfigRuleInput) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByConfigRuleWithContext is the same as GetComplianceDetailsByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByConfigRuleWithContext(ctx aws.Context, input *GetComplianceDetailsByConfigRuleInput, opts ...request.Option) (*GetComplianceDetailsByConfigRuleOutput, error) {
	req, out := c.GetComplianceDetailsByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceDetailsByResource = "GetComplianceDetailsByResource"

// GetComplianceDetailsByResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceDetailsByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceDetailsByResource for more information on using the GetComplianceDetailsByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceDetailsByResourceRequest method.
//    req, resp := client.GetComplianceDetailsByResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResourceRequest(input *GetComplianceDetailsByResourceInput) (req *request.Request, output *GetComplianceDetailsByResourceOutput) {
	op := &request.Operation{
		Name:       opGetComplianceDetailsByResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailsByResourceInput{}
	}

	output = &GetComplianceDetailsByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceDetailsByResource API operation for AWS Config.
//
// Returns the evaluation results for the specified AWS resource. The results
// indicate which AWS Config rules were used to evaluate the resource, when
// each rule was last used, and whether the resource complies with each rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceDetailsByResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource
func (c *ConfigService) GetComplianceDetailsByResource(input *GetComplianceDetailsByResourceInput) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	return out, req.Send()
}

// GetComplianceDetailsByResourceWithContext is the same as GetComplianceDetailsByResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceDetailsByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceDetailsByResourceWithContext(ctx aws.Context, input *GetComplianceDetailsByResourceInput, opts ...request.Option) (*GetComplianceDetailsByResourceOutput, error) {
	req, out := c.GetComplianceDetailsByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummaryByConfigRule = "GetComplianceSummaryByConfigRule"

// GetComplianceSummaryByConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByConfigRule for more information on using the GetComplianceSummaryByConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByConfigRuleRequest method.
//    req, resp := client.GetComplianceSummaryByConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRuleRequest(input *GetComplianceSummaryByConfigRuleInput) (req *request.Request, output *GetComplianceSummaryByConfigRuleOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByConfigRuleInput{}
	}

	output = &GetComplianceSummaryByConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByConfigRule API operation for AWS Config.
//
// Returns the number of AWS Config rules that are compliant and noncompliant,
// up to a maximum of 25 for each.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByConfigRule for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule
func (c *ConfigService) GetComplianceSummaryByConfigRule(input *GetComplianceSummaryByConfigRuleInput) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByConfigRuleWithContext is the same as GetComplianceSummaryByConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByConfigRuleWithContext(ctx aws.Context, input *GetComplianceSummaryByConfigRuleInput, opts ...request.Option) (*GetComplianceSummaryByConfigRuleOutput, error) {
	req, out := c.GetComplianceSummaryByConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComplianceSummaryByResourceType = "GetComplianceSummaryByResourceType"

// GetComplianceSummaryByResourceTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetComplianceSummaryByResourceType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComplianceSummaryByResourceType for more information on using the GetComplianceSummaryByResourceType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetComplianceSummaryByResourceTypeRequest method.
//    req, resp := client.GetComplianceSummaryByResourceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceTypeRequest(input *GetComplianceSummaryByResourceTypeInput) (req *request.Request, output *GetComplianceSummaryByResourceTypeOutput) {
	op := &request.Operation{
		Name:       opGetComplianceSummaryByResourceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceSummaryByResourceTypeInput{}
	}

	output = &GetComplianceSummaryByResourceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComplianceSummaryByResourceType API operation for AWS Config.
//
// Returns the number of resources that are compliant and the number that are
// noncompliant. You can specify one or more resource types to get these numbers
// for each resource type. The maximum number returned is 100.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetComplianceSummaryByResourceType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType
func (c *ConfigService) GetComplianceSummaryByResourceType(input *GetComplianceSummaryByResourceTypeInput) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	return out, req.Send()
}

// GetComplianceSummaryByResourceTypeWithContext is the same as GetComplianceSummaryByResourceType with the addition of
// the ability to pass a context and additional request options.
//
// See GetComplianceSummaryByResourceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetComplianceSummaryByResourceTypeWithContext(ctx aws.Context, input *GetComplianceSummaryByResourceTypeInput, opts ...request.Option) (*GetComplianceSummaryByResourceTypeOutput, error) {
	req, out := c.GetComplianceSummaryByResourceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiscoveredResourceCounts = "GetDiscoveredResourceCounts"

// GetDiscoveredResourceCountsRequest generates a "aws/request.Request" representing the
// client's request for the GetDiscoveredResourceCounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiscoveredResourceCounts for more information on using the GetDiscoveredResourceCounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiscoveredResourceCountsRequest method.
//    req, resp := client.GetDiscoveredResourceCountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCountsRequest(input *GetDiscoveredResourceCountsInput) (req *request.Request, output *GetDiscoveredResourceCountsOutput) {
	op := &request.Operation{
		Name:       opGetDiscoveredResourceCounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiscoveredResourceCountsInput{}
	}

	output = &GetDiscoveredResourceCountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiscoveredResourceCounts API operation for AWS Config.
//
// Returns the resource types, the number of each resource type, and the total
// number of resources that AWS Config is recording in this region for your
// AWS account.
//
// Example
//
// AWS Config is recording three resource types in the US East (Ohio) Region
// for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets.
//
// You make a call to the GetDiscoveredResourceCounts action and specify that
// you want all resource types.
//
// AWS Config returns the following:
//
// The resource types (EC2 instances, IAM users, and S3 buckets).
//
// The number of each resource type (25, 20, and 15).
//
// The total number of all resources (60).
//
// The response is paginated. By default, AWS Config lists 100 ResourceCount
// objects on each page. You can customize this number with the limit parameter.
// The response includes a nextToken string. To get the next page of results,
// run the request again and specify the string for the nextToken parameter.
//
// If you make a call to the GetDiscoveredResourceCounts action, you might not
// immediately receive resource counts in the following situations:
//
// You are a new AWS Config customer.
//
// You just enabled resource recording.
//
// It might take a few minutes for AWS Config to record and count your resources.
// Wait a few minutes and then retry the GetDiscoveredResourceCounts action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetDiscoveredResourceCounts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts
func (c *ConfigService) GetDiscoveredResourceCounts(input *GetDiscoveredResourceCountsInput) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	return out, req.Send()
}

// GetDiscoveredResourceCountsWithContext is the same as GetDiscoveredResourceCounts with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiscoveredResourceCounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetDiscoveredResourceCountsWithContext(ctx aws.Context, input *GetDiscoveredResourceCountsInput, opts ...request.Option) (*GetDiscoveredResourceCountsOutput, error) {
	req, out := c.GetDiscoveredResourceCountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceConfigHistory = "GetResourceConfigHistory"

// GetResourceConfigHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceConfigHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceConfigHistory for more information on using the GetResourceConfigHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceConfigHistoryRequest method.
//    req, resp := client.GetResourceConfigHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistoryRequest(input *GetResourceConfigHistoryInput) (req *request.Request, output *GetResourceConfigHistoryOutput) {
	op := &request.Operation{
		Name:       opGetResourceConfigHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceConfigHistoryInput{}
	}

	output = &GetResourceConfigHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceConfigHistory API operation for AWS Config.
//
// Returns a list of configuration items for the specified resource. The list
// contains details about each state of the resource during the specified time
// interval. If you specified a retention period to retain your ConfigurationItems
// between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config
// returns the ConfigurationItems for the specified retention period.
//
// The response is paginated. By default, AWS Config returns a limit of 10 configuration
// items per page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Each call to the API is limited to span a duration of seven days. It is likely
// that the number of records returned is smaller than the specified limit.
// In such cases, you can make another call, using the nextToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation GetResourceConfigHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidTimeRangeException "InvalidTimeRangeException"
//   The specified time range is not valid. The earlier time is not chronologically
//   before the later time.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * ErrCodeResourceNotDiscoveredException "ResourceNotDiscoveredException"
//   You have specified a resource that is either unknown or has not been discovered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory
func (c *ConfigService) GetResourceConfigHistory(input *GetResourceConfigHistoryInput) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	return out, req.Send()
}

// GetResourceConfigHistoryWithContext is the same as GetResourceConfigHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceConfigHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, opts ...request.Option) (*GetResourceConfigHistoryOutput, error) {
	req, out := c.GetResourceConfigHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceConfigHistoryPages iterates over the pages of a GetResourceConfigHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceConfigHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceConfigHistory operation.
//    pageNum := 0
//    err := client.GetResourceConfigHistoryPages(params,
//        func(page *GetResourceConfigHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConfigService) GetResourceConfigHistoryPages(input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool) error {
	return c.GetResourceConfigHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceConfigHistoryPagesWithContext same as GetResourceConfigHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) GetResourceConfigHistoryPagesWithContext(ctx aws.Context, input *GetResourceConfigHistoryInput, fn func(*GetResourceConfigHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceConfigHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceConfigHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetResourceConfigHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDiscoveredResources = "ListDiscoveredResources"

// ListDiscoveredResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDiscoveredResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDiscoveredResources for more information on using the ListDiscoveredResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDiscoveredResourcesRequest method.
//    req, resp := client.ListDiscoveredResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResourcesRequest(input *ListDiscoveredResourcesInput) (req *request.Request, output *ListDiscoveredResourcesOutput) {
	op := &request.Operation{
		Name:       opListDiscoveredResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDiscoveredResourcesInput{}
	}

	output = &ListDiscoveredResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDiscoveredResources API operation for AWS Config.
//
// Accepts a resource type and returns a list of resource identifiers for the
// resources of that type. A resource identifier includes the resource type,
// ID, and (if available) the custom resource name. The results consist of resources
// that AWS Config has discovered, including those that AWS Config is not currently
// recording. You can narrow the results to include only resources that have
// specific resource IDs or a resource name.
//
// You can specify either resource IDs or a resource name, but not both, in
// the same request.
//
// The response is paginated. By default, AWS Config lists 100 resource identifiers
// on each page. You can customize this number with the limit parameter. The
// response includes a nextToken string. To get the next page of results, run
// the request again and specify the string for the nextToken parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation ListDiscoveredResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The requested action is not valid.
//
//   * ErrCodeInvalidLimitException "InvalidLimitException"
//   The specified limit is outside the allowable range.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The specified next token is invalid. Specify the nextToken string that was
//   returned in the previous response to get the next page of results.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources
func (c *ConfigService) ListDiscoveredResources(input *ListDiscoveredResourcesInput) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	return out, req.Send()
}

// ListDiscoveredResourcesWithContext is the same as ListDiscoveredResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDiscoveredResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) ListDiscoveredResourcesWithContext(ctx aws.Context, input *ListDiscoveredResourcesInput, opts ...request.Option) (*ListDiscoveredResourcesOutput, error) {
	req, out := c.ListDiscoveredResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAggregationAuthorization = "PutAggregationAuthorization"

// PutAggregationAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the PutAggregationAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAggregationAuthorization for more information on using the PutAggregationAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutAggregationAuthorizationRequest method.
//    req, resp := client.PutAggregationAuthorizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorizationRequest(input *PutAggregationAuthorizationInput) (req *request.Request, output *PutAggregationAuthorizationOutput) {
	op := &request.Operation{
		Name:       opPutAggregationAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAggregationAuthorizationInput{}
	}

	output = &PutAggregationAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAggregationAuthorization API operation for AWS Config.
//
// Authorizes the aggregator account and region to collect data from the source
// account and region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutAggregationAuthorization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization
func (c *ConfigService) PutAggregationAuthorization(input *PutAggregationAuthorizationInput) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	return out, req.Send()
}

// PutAggregationAuthorizationWithContext is the same as PutAggregationAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See PutAggregationAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutAggregationAuthorizationWithContext(ctx aws.Context, input *PutAggregationAuthorizationInput, opts ...request.Option) (*PutAggregationAuthorizationOutput, error) {
	req, out := c.PutAggregationAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigRule = "PutConfigRule"

// PutConfigRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigRule for more information on using the PutConfigRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigRuleRequest method.
//    req, resp := client.PutConfigRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRuleRequest(input *PutConfigRuleInput) (req *request.Request, output *PutConfigRuleOutput) {
	op := &request.Operation{
		Name:       opPutConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigRuleInput{}
	}

	output = &PutConfigRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigRule API operation for AWS Config.
//
// Adds or updates an AWS Config rule for evaluating whether your AWS resources
// comply with your desired configurations.
//
// You can use this action for custom AWS Config rules and AWS managed Config
// rules. A custom AWS Config rule is a rule that you develop and maintain.
// An AWS managed Config rule is a customizable, predefined rule that AWS Config
// provides.
//
// If you are adding a new custom AWS Config rule, you must first create the
// AWS Lambda function that the rule invokes to evaluate your resources. When
// you use the PutConfigRule action to add the rule to AWS Config, you must
// specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function.
// Specify the ARN for the SourceIdentifier key. This key is part of the Source
// object, which is part of the ConfigRule object.
//
// If you are adding an AWS managed Config rule, specify the rule's identifier
// for the SourceIdentifier key. To reference AWS managed Config rule identifiers,
// see About AWS Managed Config Rules (http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
//
// For any new rule that you add, specify the ConfigRuleName in the ConfigRule
// object. Do not specify the ConfigRuleArn or the ConfigRuleId. These values
// are generated by AWS Config for new rules.
//
// If you are updating a rule that you added previously, you can specify the
// rule by ConfigRuleName, ConfigRuleId, or ConfigRuleArn in the ConfigRule
// data type that you use in this request.
//
// The maximum number of rules that AWS Config supports is 50.
//
// For information about requesting a rule limit increase, see AWS Config Limits
// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
// in the AWS General Reference Guide.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeMaxNumberOfConfigRulesExceededException "MaxNumberOfConfigRulesExceededException"
//   Failed to add the AWS Config rule because the account already contains the
//   maximum number of 50 rules. Consider deleting any deactivated rules before
//   you add new rules.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The rule is currently being deleted or the rule is deleting your evaluation
//   results. Try your request again later.
//
//   * ErrCodeInsufficientPermissionsException "InsufficientPermissionsException"
//   Indicates one of the following errors:
//
//      * The rule cannot be created because the IAM role assigned to AWS Config
//      lacks permissions to perform the config:Put* action.
//
//      * The AWS Lambda function cannot be invoked. Check the function ARN, and
//      check the function's permissions.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *ConfigService) PutConfigRule(input *PutConfigRuleInput) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	return out, req.Send()
}

// PutConfigRuleWithContext is the same as PutConfigRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigRuleWithContext(ctx aws.Context, input *PutConfigRuleInput, opts ...request.Option) (*PutConfigRuleOutput, error) {
	req, out := c.PutConfigRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationAggregator = "PutConfigurationAggregator"

// PutConfigurationAggregatorRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationAggregator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationAggregator for more information on using the PutConfigurationAggregator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationAggregatorRequest method.
//    req, resp := client.PutConfigurationAggregatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregatorRequest(input *PutConfigurationAggregatorInput) (req *request.Request, output *PutConfigurationAggregatorOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationAggregator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationAggregatorInput{}
	}

	output = &PutConfigurationAggregatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConfigurationAggregator API operation for AWS Config.
//
// Creates and updates the configuration aggregator with the selected source
// accounts and regions. The source account can be individual account(s) or
// an organization.
//
// AWS Config should be enabled in source accounts and regions you want to aggregate.
//
// If your source type is an organization, you must be signed in to the master
// account and all features must be enabled in your organization. AWS Config
// calls EnableAwsServiceAccess API to enable integration between AWS Config
// and AWS Organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationAggregator for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   You have provided a null or empty role ARN.
//
//   * ErrCodeOrganizationAccessDeniedException "OrganizationAccessDeniedException"
//   No permission to call the EnableAWSServiceAccess API.
//
//   * ErrCodeNoAvailableOrganizationException "NoAvailableOrganizationException"
//   Organization does is no longer available.
//
//   * ErrCodeOrganizationAllFeaturesNotEnabledException "OrganizationAllFeaturesNotEnabledException"
//   The configuration aggregator cannot be created because organization does
//   not have all features enabled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator
func (c *ConfigService) PutConfigurationAggregator(input *PutConfigurationAggregatorInput) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	return out, req.Send()
}

// PutConfigurationAggregatorWithContext is the same as PutConfigurationAggregator with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationAggregator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationAggregatorWithContext(ctx aws.Context, input *PutConfigurationAggregatorInput, opts ...request.Option) (*PutConfigurationAggregatorOutput, error) {
	req, out := c.PutConfigurationAggregatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutConfigurationRecorder = "PutConfigurationRecorder"

// PutConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the PutConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfigurationRecorder for more information on using the PutConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutConfigurationRecorderRequest method.
//    req, resp := client.PutConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorderRequest(input *PutConfigurationRecorderInput) (req *request.Request, output *PutConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opPutConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigurationRecorderInput{}
	}

	output = &PutConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutConfigurationRecorder API operation for AWS Config.
//
// Creates a new configuration recorder to record the selected resource configurations.
//
// You can use this action to change the role roleARN or the recordingGroup
// of an existing recorder. To change the role, call the action on the existing
// configuration recorder and specify a role.
//
// Currently, you can specify only one configuration recorder per region in
// your account.
//
// If ConfigurationRecorder does not have the recordingGroup parameter specified,
// the default is to record all supported resource types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutConfigurationRecorder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMaxNumberOfConfigurationRecordersExceededException "MaxNumberOfConfigurationRecordersExceededException"
//   You have reached the limit of the number of recorders you can create.
//
//   * ErrCodeInvalidConfigurationRecorderNameException "InvalidConfigurationRecorderNameException"
//   You have provided a configuration recorder name that is not valid.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   You have provided a null or empty role ARN.
//
//   * ErrCodeInvalidRecordingGroupException "InvalidRecordingGroupException"
//   AWS Config throws an exception if the recording group does not contain a
//   valid list of resource types. Invalid values might also be incorrectly formatted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder
func (c *ConfigService) PutConfigurationRecorder(input *PutConfigurationRecorderInput) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	return out, req.Send()
}

// PutConfigurationRecorderWithContext is the same as PutConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutConfigurationRecorderWithContext(ctx aws.Context, input *PutConfigurationRecorderInput, opts ...request.Option) (*PutConfigurationRecorderOutput, error) {
	req, out := c.PutConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutDeliveryChannel = "PutDeliveryChannel"

// PutDeliveryChannelRequest generates a "aws/request.Request" representing the
// client's request for the PutDeliveryChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDeliveryChannel for more information on using the PutDeliveryChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDeliveryChannelRequest method.
//    req, resp := client.PutDeliveryChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannelRequest(input *PutDeliveryChannelInput) (req *request.Request, output *PutDeliveryChannelOutput) {
	op := &request.Operation{
		Name:       opPutDeliveryChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDeliveryChannelInput{}
	}

	output = &PutDeliveryChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDeliveryChannel API operation for AWS Config.
//
// Creates a delivery channel object to deliver configuration information to
// an Amazon S3 bucket and Amazon SNS topic.
//
// Before you can create a delivery channel, you must create a configuration
// recorder.
//
// You can use this action to change the Amazon S3 bucket or an Amazon SNS topic
// of the existing delivery channel. To change the Amazon S3 bucket or an Amazon
// SNS topic, call this action and specify the changed values for the S3 bucket
// and the SNS topic. If you specify a different value for either the S3 bucket
// or the SNS topic, this action will keep the existing value for the parameter
// that is not changed.
//
// You can have only one delivery channel per region in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutDeliveryChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMaxNumberOfDeliveryChannelsExceededException "MaxNumberOfDeliveryChannelsExceededException"
//   You have reached the limit of the number of delivery channels you can create.
//
//   * ErrCodeNoAvailableConfigurationRecorderException "NoAvailableConfigurationRecorderException"
//   There are no configuration recorders available to provide the role needed
//   to describe your resources. Create a configuration recorder.
//
//   * ErrCodeInvalidDeliveryChannelNameException "InvalidDeliveryChannelNameException"
//   The specified delivery channel name is not valid.
//
//   * ErrCodeNoSuchBucketException "NoSuchBucketException"
//   The specified Amazon S3 bucket does not exist.
//
//   * ErrCodeInvalidS3KeyPrefixException "InvalidS3KeyPrefixException"
//   The specified Amazon S3 key prefix is not valid.
//
//   * ErrCodeInvalidSNSTopicARNException "InvalidSNSTopicARNException"
//   The specified Amazon SNS topic does not exist.
//
//   * ErrCodeInsufficientDeliveryPolicyException "InsufficientDeliveryPolicyException"
//   Your Amazon S3 bucket policy does not permit AWS Config to write to it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutDeliveryChannel
func (c *ConfigService) PutDeliveryChannel(input *PutDeliveryChannelInput) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	return out, req.Send()
}

// PutDeliveryChannelWithContext is the same as PutDeliveryChannel with the addition of
// the ability to pass a context and additional request options.
//
// See PutDeliveryChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutDeliveryChannelWithContext(ctx aws.Context, input *PutDeliveryChannelInput, opts ...request.Option) (*PutDeliveryChannelOutput, error) {
	req, out := c.PutDeliveryChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvaluations = "PutEvaluations"

// PutEvaluationsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvaluations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvaluations for more information on using the PutEvaluations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEvaluationsRequest method.
//    req, resp := client.PutEvaluationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluationsRequest(input *PutEvaluationsInput) (req *request.Request, output *PutEvaluationsOutput) {
	op := &request.Operation{
		Name:       opPutEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEvaluationsInput{}
	}

	output = &PutEvaluationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvaluations API operation for AWS Config.
//
// Used by an AWS Lambda function to deliver evaluation results to AWS Config.
// This action is required in every AWS Lambda function that is invoked by an
// AWS Config rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutEvaluations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeInvalidResultTokenException "InvalidResultTokenException"
//   The specified ResultToken is invalid.
//
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutEvaluations
func (c *ConfigService) PutEvaluations(input *PutEvaluationsInput) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	return out, req.Send()
}

// PutEvaluationsWithContext is the same as PutEvaluations with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvaluations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutEvaluationsWithContext(ctx aws.Context, input *PutEvaluationsInput, opts ...request.Option) (*PutEvaluationsOutput, error) {
	req, out := c.PutEvaluationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRetentionConfiguration = "PutRetentionConfiguration"

// PutRetentionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutRetentionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRetentionConfiguration for more information on using the PutRetentionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRetentionConfigurationRequest method.
//    req, resp := client.PutRetentionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfigurationRequest(input *PutRetentionConfigurationInput) (req *request.Request, output *PutRetentionConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutRetentionConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRetentionConfigurationInput{}
	}

	output = &PutRetentionConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRetentionConfiguration API operation for AWS Config.
//
// Creates and updates the retention configuration with details about retention
// period (number of days) that AWS Config stores your historical information.
// The API creates the RetentionConfiguration object and names the object as
// default. When you have a RetentionConfiguration object named default, calling
// the API modifies the default object.
//
// Currently, AWS Config supports only one retention configuration per region
// in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation PutRetentionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
//   * ErrCodeMaxNumberOfRetentionConfigurationsExceededException "MaxNumberOfRetentionConfigurationsExceededException"
//   Failed to add the retention configuration because a retention configuration
//   with that name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutRetentionConfiguration
func (c *ConfigService) PutRetentionConfiguration(input *PutRetentionConfigurationInput) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	return out, req.Send()
}

// PutRetentionConfigurationWithContext is the same as PutRetentionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutRetentionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) PutRetentionConfigurationWithContext(ctx aws.Context, input *PutRetentionConfigurationInput, opts ...request.Option) (*PutRetentionConfigurationOutput, error) {
	req, out := c.PutRetentionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConfigRulesEvaluation = "StartConfigRulesEvaluation"

// StartConfigRulesEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigRulesEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigRulesEvaluation for more information on using the StartConfigRulesEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigRulesEvaluationRequest method.
//    req, resp := client.StartConfigRulesEvaluationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluationRequest(input *StartConfigRulesEvaluationInput) (req *request.Request, output *StartConfigRulesEvaluationOutput) {
	op := &request.Operation{
		Name:       opStartConfigRulesEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigRulesEvaluationInput{}
	}

	output = &StartConfigRulesEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartConfigRulesEvaluation API operation for AWS Config.
//
// Runs an on-demand evaluation for the specified AWS Config rules against the
// last known configuration state of the resources. Use StartConfigRulesEvaluation
// when you want to test that a rule you updated is working as expected. StartConfigRulesEvaluation
// does not re-record the latest configuration state for your resources. It
// re-runs an evaluation against the last known state of your resources.
//
// You can specify up to 25 AWS Config rules per request.
//
// An existing StartConfigRulesEvaluation call for the specified rules must
// complete before you can call the API again. If you chose to have AWS Config
// stream to an Amazon SNS topic, you will receive a ConfigRuleEvaluationStarted
// notification when the evaluation starts.
//
// You don't need to call the StartConfigRulesEvaluation API to run an evaluation
// for a new rule. When you create a rule, AWS Config evaluates your resources
// against the rule automatically.
//
// The StartConfigRulesEvaluation API is useful if you want to run on-demand
// evaluations, such as the following example:
//
// You have a custom rule that evaluates your IAM resources every 24 hours.
//
// You update your Lambda function to add additional conditions to your rule.
//
// Instead of waiting for the next periodic evaluation, you call the StartConfigRulesEvaluation
// API.
//
// AWS Config invokes your Lambda function and evaluates your IAM resources.
//
// Your custom rule will still run periodic evaluations every 24 hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigRulesEvaluation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigRuleException "NoSuchConfigRuleException"
//   One or more AWS Config rules in the request are invalid. Verify that the
//   rule names are correct and try again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   For StartConfigRulesEvaluation API, this exception is thrown if an evaluation
//   is in progress or if you call the StartConfigRulesEvaluation API more than
//   once per minute.
//
//   For PutConfigurationAggregator API, this exception is thrown if the number
//   of accounts and aggregators exceeds the limit.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The rule is currently being deleted or the rule is deleting your evaluation
//   results. Try your request again later.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One or more of the specified parameters are invalid. Verify that your parameters
//   are valid and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigRulesEvaluation
func (c *ConfigService) StartConfigRulesEvaluation(input *StartConfigRulesEvaluationInput) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	return out, req.Send()
}

// StartConfigRulesEvaluationWithContext is the same as StartConfigRulesEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigRulesEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigRulesEvaluationWithContext(ctx aws.Context, input *StartConfigRulesEvaluationInput, opts ...request.Option) (*StartConfigRulesEvaluationOutput, error) {
	req, out := c.StartConfigRulesEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartConfigurationRecorder = "StartConfigurationRecorder"

// StartConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StartConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartConfigurationRecorder for more information on using the StartConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartConfigurationRecorderRequest method.
//    req, resp := client.StartConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorderRequest(input *StartConfigurationRecorderInput) (req *request.Request, output *StartConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStartConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartConfigurationRecorderInput{}
	}

	output = &StartConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartConfigurationRecorder API operation for AWS Config.
//
// Starts recording configurations of the AWS resources you have selected to
// record in your AWS account.
//
// You must have created at least one delivery channel to successfully start
// the configuration recorder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StartConfigurationRecorder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationRecorderException "NoSuchConfigurationRecorderException"
//   You have specified a configuration recorder that does not exist.
//
//   * ErrCodeNoAvailableDeliveryChannelException "NoAvailableDeliveryChannelException"
//   There is no delivery channel available to record configurations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StartConfigurationRecorder
func (c *ConfigService) StartConfigurationRecorder(input *StartConfigurationRecorderInput) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StartConfigurationRecorderWithContext is the same as StartConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StartConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StartConfigurationRecorderWithContext(ctx aws.Context, input *StartConfigurationRecorderInput, opts ...request.Option) (*StartConfigurationRecorderOutput, error) {
	req, out := c.StartConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopConfigurationRecorder = "StopConfigurationRecorder"

// StopConfigurationRecorderRequest generates a "aws/request.Request" representing the
// client's request for the StopConfigurationRecorder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopConfigurationRecorder for more information on using the StopConfigurationRecorder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopConfigurationRecorderRequest method.
//    req, resp := client.StopConfigurationRecorderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorderRequest(input *StopConfigurationRecorderInput) (req *request.Request, output *StopConfigurationRecorderOutput) {
	op := &request.Operation{
		Name:       opStopConfigurationRecorder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopConfigurationRecorderInput{}
	}

	output = &StopConfigurationRecorderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopConfigurationRecorder API operation for AWS Config.
//
// Stops recording configurations of the AWS resources you have selected to
// record in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Config's
// API operation StopConfigurationRecorder for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchConfigurationRecorderException "NoSuchConfigurationRecorderException"
//   You have specified a configuration recorder that does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StopConfigurationRecorder
func (c *ConfigService) StopConfigurationRecorder(input *StopConfigurationRecorderInput) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	return out, req.Send()
}

// StopConfigurationRecorderWithContext is the same as StopConfigurationRecorder with the addition of
// the ability to pass a context and additional request options.
//
// See StopConfigurationRecorder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConfigService) StopConfigurationRecorderWithContext(ctx aws.Context, input *StopConfigurationRecorderInput, opts ...request.Option) (*StopConfigurationRecorderOutput, error) {
	req, out := c.StopConfigurationRecorderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A collection of accounts and regions.
type AccountAggregationSource struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account being aggregated.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s AccountAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountAggregationSource"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *AccountAggregationSource) SetAccountIds(v []*string) *AccountAggregationSource {
	s.AccountIds = v
	return s
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *AccountAggregationSource) SetAllAwsRegions(v bool) *AccountAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *AccountAggregationSource) SetAwsRegions(v []*string) *AccountAggregationSource {
	s.AwsRegions = v
	return s
}

// Indicates whether an AWS Config rule is compliant based on account ID, region,
// compliance, and rule name.
//
// A rule is compliant if all of the resources that the rule evaluated comply
// with it. It is noncompliant if any of these resources do not comply.
type AggregateComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// Indicates whether an AWS resource or AWS Config rule is compliant and provides
	// the number of contributors that affect the compliance.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateComplianceByConfigRule) SetAccountId(v string) *AggregateComplianceByConfigRule {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateComplianceByConfigRule) SetAwsRegion(v string) *AggregateComplianceByConfigRule {
	s.AwsRegion = &v
	return s
}

// SetCompliance sets the Compliance field's value.
func (s *AggregateComplianceByConfigRule) SetCompliance(v *Compliance) *AggregateComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *AggregateComplianceByConfigRule) SetConfigRuleName(v string) *AggregateComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
type AggregateComplianceCount struct {
	_ struct{} `type:"structure"`

	// The number of compliant and noncompliant AWS Config rules.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateComplianceCount) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *AggregateComplianceCount) SetComplianceSummary(v *ComplianceSummary) *AggregateComplianceCount {
	s.ComplianceSummary = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *AggregateComplianceCount) SetGroupName(v string) *AggregateComplianceCount {
	s.GroupName = &v
	return s
}

// The details of an AWS Config evaluation for an account ID and region in an
// aggregator. Provides the AWS resource that was evaluated, the compliance
// of the resource, related time stamps, and supplementary information.
type AggregateEvaluationResult struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string `min:"1" type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The resource compliance status.
	//
	// For the AggregationEvaluationResult data type, AWS Config supports only the
	// COMPLIANT and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE
	// and INSUFFICIENT_DATA value.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AggregateEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregateEvaluationResult) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AggregateEvaluationResult) SetAccountId(v string) *AggregateEvaluationResult {
	s.AccountId = &v
	return s
}

// SetAnnotation sets the Annotation field's value.
func (s *AggregateEvaluationResult) SetAnnotation(v string) *AggregateEvaluationResult {
	s.Annotation = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregateEvaluationResult) SetAwsRegion(v string) *AggregateEvaluationResult {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *AggregateEvaluationResult) SetComplianceType(v string) *AggregateEvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *AggregateEvaluationResult) SetConfigRuleInvokedTime(v time.Time) *AggregateEvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *AggregateEvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *AggregateEvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *AggregateEvaluationResult) SetResultRecordedTime(v time.Time) *AggregateEvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// The current sync status between the source and the aggregator account.
type AggregatedSourceStatus struct {
	_ struct{} `type:"structure"`

	// The region authorized to collect aggregated data.
	AwsRegion *string `min:"1" type:"string"`

	// The error code that AWS Config returned when the source account aggregation
	// last failed.
	LastErrorCode *string `type:"string"`

	// The message indicating that the source account aggregation failed due to
	// an error.
	LastErrorMessage *string `type:"string"`

	// Filters the last updated status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus *string `type:"string" enum:"AggregatedSourceStatusType"`

	// The time of the last update.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The source account ID or an organization.
	SourceId *string `type:"string"`

	// The source account or an organization.
	SourceType *string `type:"string" enum:"AggregatedSourceType"`
}

// String returns the string representation
func (s AggregatedSourceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregatedSourceStatus) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *AggregatedSourceStatus) SetAwsRegion(v string) *AggregatedSourceStatus {
	s.AwsRegion = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *AggregatedSourceStatus) SetLastErrorCode(v string) *AggregatedSourceStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *AggregatedSourceStatus) SetLastErrorMessage(v string) *AggregatedSourceStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastUpdateStatus sets the LastUpdateStatus field's value.
func (s *AggregatedSourceStatus) SetLastUpdateStatus(v string) *AggregatedSourceStatus {
	s.LastUpdateStatus = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AggregatedSourceStatus) SetLastUpdateTime(v time.Time) *AggregatedSourceStatus {
	s.LastUpdateTime = &v
	return s
}

// SetSourceId sets the SourceId field's value.
func (s *AggregatedSourceStatus) SetSourceId(v string) *AggregatedSourceStatus {
	s.SourceId = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *AggregatedSourceStatus) SetSourceType(v string) *AggregatedSourceStatus {
	s.SourceType = &v
	return s
}

// An object that represents the authorizations granted to aggregator accounts
// and regions.
type AggregationAuthorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string `type:"string"`

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string `type:"string"`

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string `min:"1" type:"string"`

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AggregationAuthorization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AggregationAuthorization) GoString() string {
	return s.String()
}

// SetAggregationAuthorizationArn sets the AggregationAuthorizationArn field's value.
func (s *AggregationAuthorization) SetAggregationAuthorizationArn(v string) *AggregationAuthorization {
	s.AggregationAuthorizationArn = &v
	return s
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *AggregationAuthorization) SetAuthorizedAccountId(v string) *AggregationAuthorization {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *AggregationAuthorization) SetAuthorizedAwsRegion(v string) *AggregationAuthorization {
	s.AuthorizedAwsRegion = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AggregationAuthorization) SetCreationTime(v time.Time) *AggregationAuthorization {
	s.CreationTime = &v
	return s
}

// The detailed configuration of a specified resource.
type BaseConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12 digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// The configuration item status.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s BaseConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaseConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BaseConfigurationItem) SetAccountId(v string) *BaseConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *BaseConfigurationItem) SetArn(v string) *BaseConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *BaseConfigurationItem) SetAvailabilityZone(v string) *BaseConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *BaseConfigurationItem) SetAwsRegion(v string) *BaseConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *BaseConfigurationItem) SetConfiguration(v string) *BaseConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *BaseConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *BaseConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *BaseConfigurationItem) SetConfigurationItemStatus(v string) *BaseConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *BaseConfigurationItem) SetConfigurationStateId(v string) *BaseConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *BaseConfigurationItem) SetResourceCreationTime(v time.Time) *BaseConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *BaseConfigurationItem) SetResourceId(v string) *BaseConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *BaseConfigurationItem) SetResourceName(v string) *BaseConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *BaseConfigurationItem) SetResourceType(v string) *BaseConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *BaseConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *BaseConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaseConfigurationItem) SetVersion(v string) *BaseConfigurationItem {
	s.Version = &v
	return s
}

type BatchGetResourceConfigInput struct {
	_ struct{} `type:"structure"`

	// A list of resource keys to be processed with the current request. Each element
	// in the list consists of the resource type and resource ID.
	//
	// ResourceKeys is a required field
	ResourceKeys []*ResourceKey `locationName:"resourceKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetResourceConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetResourceConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetResourceConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetResourceConfigInput"}
	if s.ResourceKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceKeys"))
	}
	if s.ResourceKeys != nil && len(s.ResourceKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceKeys", 1))
	}
	if s.ResourceKeys != nil {
		for i, v := range s.ResourceKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceKeys sets the ResourceKeys field's value.
func (s *BatchGetResourceConfigInput) SetResourceKeys(v []*ResourceKey) *BatchGetResourceConfigInput {
	s.ResourceKeys = v
	return s
}

type BatchGetResourceConfigOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the current configuration of one or more resources.
	BaseConfigurationItems []*BaseConfigurationItem `locationName:"baseConfigurationItems" type:"list"`

	// A list of resource keys that were not processed with the current response.
	// The unprocessesResourceKeys value is in the same form as ResourceKeys, so
	// the value can be directly provided to a subsequent BatchGetResourceConfig
	// operation. If there are no unprocessed resource keys, the response contains
	// an empty unprocessedResourceKeys list.
	UnprocessedResourceKeys []*ResourceKey `locationName:"unprocessedResourceKeys" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchGetResourceConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetResourceConfigOutput) GoString() string {
	return s.String()
}

// SetBaseConfigurationItems sets the BaseConfigurationItems field's value.
func (s *BatchGetResourceConfigOutput) SetBaseConfigurationItems(v []*BaseConfigurationItem) *BatchGetResourceConfigOutput {
	s.BaseConfigurationItems = v
	return s
}

// SetUnprocessedResourceKeys sets the UnprocessedResourceKeys field's value.
func (s *BatchGetResourceConfigOutput) SetUnprocessedResourceKeys(v []*ResourceKey) *BatchGetResourceConfigOutput {
	s.UnprocessedResourceKeys = v
	return s
}

// Indicates whether an AWS resource or AWS Config rule is compliant and provides
// the number of contributors that affect the compliance.
type Compliance struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources or AWS Config rules that cause a result of NON_COMPLIANT,
	// up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount `type:"structure"`

	// Indicates whether an AWS resource or AWS Config rule is compliant.
	//
	// A resource is compliant if it complies with all of the AWS Config rules that
	// evaluate it. A resource is noncompliant if it does not comply with one or
	// more of these rules.
	//
	// A rule is compliant if all of the resources that the rule evaluates comply
	// with it. A rule is noncompliant if any of these resources do not comply.
	//
	// AWS Config returns the INSUFFICIENT_DATA value when no evaluation results
	// are available for the AWS resource or AWS Config rule.
	//
	// For the Compliance data type, AWS Config supports only COMPLIANT, NON_COMPLIANT,
	// and INSUFFICIENT_DATA values. AWS Config does not support the NOT_APPLICABLE
	// value for the Compliance data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compliance) GoString() string {
	return s.String()
}

// SetComplianceContributorCount sets the ComplianceContributorCount field's value.
func (s *Compliance) SetComplianceContributorCount(v *ComplianceContributorCount) *Compliance {
	s.ComplianceContributorCount = v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Compliance) SetComplianceType(v string) *Compliance {
	s.ComplianceType = &v
	return s
}

// Indicates whether an AWS Config rule is compliant. A rule is compliant if
// all of the resources that the rule evaluated comply with it. A rule is noncompliant
// if any of these resources do not comply.
type ComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS Config rule is compliant.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceByConfigRule) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByConfigRule) SetCompliance(v *Compliance) *ComplianceByConfigRule {
	s.Compliance = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ComplianceByConfigRule) SetConfigRuleName(v string) *ComplianceByConfigRule {
	s.ConfigRuleName = &v
	return s
}

// Indicates whether an AWS resource that is evaluated according to one or more
// AWS Config rules is compliant. A resource is compliant if it complies with
// all of the rules that evaluate it. A resource is noncompliant if it does
// not comply with one or more of these rules.
type ComplianceByResource struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS resource complies with all of the AWS Config rules
	// that evaluated it.
	Compliance *Compliance `type:"structure"`

	// The ID of the AWS resource that was evaluated.
	ResourceId *string `min:"1" type:"string"`

	// The type of the AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceByResource) GoString() string {
	return s.String()
}

// SetCompliance sets the Compliance field's value.
func (s *ComplianceByResource) SetCompliance(v *Compliance) *ComplianceByResource {
	s.Compliance = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ComplianceByResource) SetResourceId(v string) *ComplianceByResource {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceByResource) SetResourceType(v string) *ComplianceByResource {
	s.ResourceType = &v
	return s
}

// The number of AWS resources or AWS Config rules responsible for the current
// compliance of the item, up to a maximum number.
type ComplianceContributorCount struct {
	_ struct{} `type:"structure"`

	// Indicates whether the maximum count is reached.
	CapExceeded *bool `type:"boolean"`

	// The number of AWS resources or AWS Config rules responsible for the current
	// compliance of the item.
	CappedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ComplianceContributorCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceContributorCount) GoString() string {
	return s.String()
}

// SetCapExceeded sets the CapExceeded field's value.
func (s *ComplianceContributorCount) SetCapExceeded(v bool) *ComplianceContributorCount {
	s.CapExceeded = &v
	return s
}

// SetCappedCount sets the CappedCount field's value.
func (s *ComplianceContributorCount) SetCappedCount(v int64) *ComplianceContributorCount {
	s.CappedCount = &v
	return s
}

// The number of AWS Config rules or AWS resources that are compliant and noncompliant.
type ComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The time that AWS Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time `type:"timestamp"`

	// The number of AWS Config rules or AWS resources that are compliant, up to
	// a maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount `type:"structure"`

	// The number of AWS Config rules or AWS resources that are noncompliant, up
	// to a maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount `type:"structure"`
}

// String returns the string representation
func (s ComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceSummary) GoString() string {
	return s.String()
}

// SetComplianceSummaryTimestamp sets the ComplianceSummaryTimestamp field's value.
func (s *ComplianceSummary) SetComplianceSummaryTimestamp(v time.Time) *ComplianceSummary {
	s.ComplianceSummaryTimestamp = &v
	return s
}

// SetCompliantResourceCount sets the CompliantResourceCount field's value.
func (s *ComplianceSummary) SetCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.CompliantResourceCount = v
	return s
}

// SetNonCompliantResourceCount sets the NonCompliantResourceCount field's value.
func (s *ComplianceSummary) SetNonCompliantResourceCount(v *ComplianceContributorCount) *ComplianceSummary {
	s.NonCompliantResourceCount = v
	return s
}

// The number of AWS resources of a specific type that are compliant or noncompliant,
// up to a maximum of 100 for each.
type ComplianceSummaryByResourceType struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that are compliant or noncompliant, up to a maximum
	// of 100 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The type of AWS resource.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceSummaryByResourceType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComplianceSummaryByResourceType) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *ComplianceSummaryByResourceType) SetComplianceSummary(v *ComplianceSummary) *ComplianceSummaryByResourceType {
	s.ComplianceSummary = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ComplianceSummaryByResourceType) SetResourceType(v string) *ComplianceSummaryByResourceType {
	s.ResourceType = &v
	return s
}

// Provides status of the delivery of the snapshot or the configuration history
// to the specified Amazon S3 bucket. Also provides the status of notifications
// about the Amazon S3 delivery to the specified Amazon SNS topic.
type ConfigExportDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time `locationName:"lastAttemptTime" type:"timestamp"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time `locationName:"lastSuccessfulTime" type:"timestamp"`

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time `locationName:"nextDeliveryTime" type:"timestamp"`
}

// String returns the string representation
func (s ConfigExportDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigExportDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastAttemptTime sets the LastAttemptTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastAttemptTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastAttemptTime = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorCode(v string) *ConfigExportDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigExportDeliveryInfo) SetLastErrorMessage(v string) *ConfigExportDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigExportDeliveryInfo) SetLastStatus(v string) *ConfigExportDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastSuccessfulTime sets the LastSuccessfulTime field's value.
func (s *ConfigExportDeliveryInfo) SetLastSuccessfulTime(v time.Time) *ConfigExportDeliveryInfo {
	s.LastSuccessfulTime = &v
	return s
}

// SetNextDeliveryTime sets the NextDeliveryTime field's value.
func (s *ConfigExportDeliveryInfo) SetNextDeliveryTime(v time.Time) *ConfigExportDeliveryInfo {
	s.NextDeliveryTime = &v
	return s
}

// An AWS Config rule represents an AWS Lambda function that you create for
// a custom rule or a predefined function for an AWS managed rule. The function
// evaluates configuration items to assess whether your AWS resources comply
// with your desired configurations. This function can run when AWS Config detects
// a configuration change to an AWS resource and at a periodic frequency that
// you choose (for example, every 24 hours).
//
// You can use the AWS CLI and AWS SDKs if you want to create a rule that triggers
// evaluations for your resources when AWS Config delivers the configuration
// snapshot. For more information, see ConfigSnapshotDeliveryProperties.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
type ConfigRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `type:"string"`

	// The name that you assign to the AWS Config rule. The name is required if
	// you are adding a new rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Indicates whether the AWS Config rule is active or is currently being deleted
	// by AWS Config. It can also indicate the evaluation status for the AWS Config
	// rule.
	//
	// AWS Config sets the state of the rule to EVALUATING temporarily after you
	// use the StartConfigRulesEvaluation request to evaluate your resources against
	// the AWS Config rule.
	//
	// AWS Config sets the state of the rule to DELETING_RESULTS temporarily after
	// you use the DeleteEvaluationResults request to delete the current evaluation
	// results for the AWS Config rule.
	//
	// AWS Config temporarily sets the state of a rule to DELETING after you use
	// the DeleteConfigRule request to delete the rule. After AWS Config deletes
	// the rule, the rule and all of its evaluations are erased and are no longer
	// available.
	ConfigRuleState *string `type:"string" enum:"ConfigRuleState"`

	// Service principal name of the service that created the rule.
	//
	// The field is populated only if the service linked rule is created by a service.
	// The field is empty if you create your own rule.
	CreatedBy *string `min:"1" type:"string"`

	// The description that you provide for the AWS Config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to the AWS Config rule Lambda function.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which AWS Config runs evaluations for a rule.
	// You can specify a value for MaximumExecutionFrequency when:
	//
	//    * You are using an AWS managed rule that is triggered at a periodic frequency.
	//
	//    * Your custom rule is triggered when AWS Config delivers the configuration
	//    snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// Defines which resources can trigger an evaluation for the rule. The scope
	// can include one or more resource types, a combination of one resource type
	// and one resource ID, or a combination of a tag key and value. Specify a scope
	// to constrain the resources that can trigger an evaluation for the rule. If
	// you do not specify a scope, evaluations are triggered when any resource in
	// the recording group changes.
	Scope *Scope `type:"structure"`

	// Provides the rule owner (AWS or customer), the rule identifier, and the notifications
	// that cause the function to evaluate your AWS resources.
	//
	// Source is a required field
	Source *Source `type:"structure" required:"true"`
}

// String returns the string representation
func (s ConfigRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRule"}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.CreatedBy != nil && len(*s.CreatedBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatedBy", 1))
	}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputParameters", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(request.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRule) SetConfigRuleArn(v string) *ConfigRule {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRule) SetConfigRuleId(v string) *ConfigRule {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRule) SetConfigRuleName(v string) *ConfigRule {
	s.ConfigRuleName = &v
	return s
}

// SetConfigRuleState sets the ConfigRuleState field's value.
func (s *ConfigRule) SetConfigRuleState(v string) *ConfigRule {
	s.ConfigRuleState = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *ConfigRule) SetCreatedBy(v string) *ConfigRule {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfigRule) SetDescription(v string) *ConfigRule {
	s.Description = &v
	return s
}

// SetInputParameters sets the InputParameters field's value.
func (s *ConfigRule) SetInputParameters(v string) *ConfigRule {
	s.InputParameters = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *ConfigRule) SetMaximumExecutionFrequency(v string) *ConfigRule {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ConfigRule) SetScope(v *Scope) *ConfigRule {
	s.Scope = v
	return s
}

// SetSource sets the Source field's value.
func (s *ConfigRule) SetSource(v *Source) *ConfigRule {
	s.Source = v
	return s
}

// Filters the compliance results based on account ID, region, compliance type,
// and rule name.
type ConfigRuleComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The rule compliance status.
	//
	// For the ConfigRuleComplianceFilters data type, AWS Config supports only COMPLIANT
	// and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE and the
	// INSUFFICIENT_DATA values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleComplianceFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceFilters) SetAccountId(v string) *ConfigRuleComplianceFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceFilters) SetAwsRegion(v string) *ConfigRuleComplianceFilters {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *ConfigRuleComplianceFilters) SetComplianceType(v string) *ConfigRuleComplianceFilters {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleComplianceFilters) SetConfigRuleName(v string) *ConfigRuleComplianceFilters {
	s.ConfigRuleName = &v
	return s
}

// Filters the results based on the account IDs and regions.
type ConfigRuleComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleComplianceSummaryFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceSummaryFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigRuleComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAccountId(v string) *ConfigRuleComplianceSummaryFilters {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigRuleComplianceSummaryFilters) SetAwsRegion(v string) *ConfigRuleComplianceSummaryFilters {
	s.AwsRegion = &v
	return s
}

// Status information for your AWS managed Config rules. The status includes
// information such as the last time the rule ran, the last time it failed,
// and the related error for the last failure.
//
// This action does not return status information about custom AWS Config rules.
type ConfigRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `type:"string"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// The time that you first activated the AWS Config rule.
	FirstActivatedTime *time.Time `type:"timestamp"`

	// Indicates whether AWS Config has evaluated your resources against the rule
	// at least once.
	//
	//    * true - AWS Config has evaluated your AWS resources against the rule
	//    at least once.
	//
	//    * false - AWS Config has not once finished evaluating your AWS resources
	//    against the rule.
	FirstEvaluationStarted *bool `type:"boolean"`

	// The error code that AWS Config returned when the rule last failed.
	LastErrorCode *string `type:"string"`

	// The error message that AWS Config returned when the rule last failed.
	LastErrorMessage *string `type:"string"`

	// The time that AWS Config last failed to evaluate your AWS resources against
	// the rule.
	LastFailedEvaluationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last failed to invoke the AWS Config rule to evaluate
	// your AWS resources.
	LastFailedInvocationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last successfully evaluated your AWS resources against
	// the rule.
	LastSuccessfulEvaluationTime *time.Time `type:"timestamp"`

	// The time that AWS Config last successfully invoked the AWS Config rule to
	// evaluate your AWS resources.
	LastSuccessfulInvocationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ConfigRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigRuleEvaluationStatus) GoString() string {
	return s.String()
}

// SetConfigRuleArn sets the ConfigRuleArn field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleArn(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleArn = &v
	return s
}

// SetConfigRuleId sets the ConfigRuleId field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleId(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleId = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *ConfigRuleEvaluationStatus) SetConfigRuleName(v string) *ConfigRuleEvaluationStatus {
	s.ConfigRuleName = &v
	return s
}

// SetFirstActivatedTime sets the FirstActivatedTime field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstActivatedTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.FirstActivatedTime = &v
	return s
}

// SetFirstEvaluationStarted sets the FirstEvaluationStarted field's value.
func (s *ConfigRuleEvaluationStatus) SetFirstEvaluationStarted(v bool) *ConfigRuleEvaluationStatus {
	s.FirstEvaluationStarted = &v
	return s
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorCode(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigRuleEvaluationStatus) SetLastErrorMessage(v string) *ConfigRuleEvaluationStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastFailedEvaluationTime sets the LastFailedEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedEvaluationTime = &v
	return s
}

// SetLastFailedInvocationTime sets the LastFailedInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastFailedInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastFailedInvocationTime = &v
	return s
}

// SetLastSuccessfulEvaluationTime sets the LastSuccessfulEvaluationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulEvaluationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulEvaluationTime = &v
	return s
}

// SetLastSuccessfulInvocationTime sets the LastSuccessfulInvocationTime field's value.
func (s *ConfigRuleEvaluationStatus) SetLastSuccessfulInvocationTime(v time.Time) *ConfigRuleEvaluationStatus {
	s.LastSuccessfulInvocationTime = &v
	return s
}

// Provides options for how often AWS Config delivers configuration snapshots
// to the Amazon S3 bucket in your delivery channel.
//
// If you want to create a rule that triggers evaluations for your resources
// when AWS Config delivers the configuration snapshot, see the following:
//
// The frequency for a rule that triggers evaluations for your resources when
// AWS Config delivers the configuration snapshot is set by one of two values,
// depending on which is less frequent:
//
//    * The value for the deliveryFrequency parameter within the delivery channel
//    configuration, which sets how often AWS Config delivers configuration
//    snapshots. This value also sets how often AWS Config invokes evaluations
//    for AWS Config rules.
//
//    * The value for the MaximumExecutionFrequency parameter, which sets the
//    maximum frequency with which AWS Config invokes evaluations for the rule.
//    For more information, see ConfigRule.
//
// If the deliveryFrequency value is less frequent than the MaximumExecutionFrequency
// value for a rule, AWS Config invokes the rule only as often as the deliveryFrequency
// value.
//
// For example, you want your rule to run evaluations when AWS Config delivers
// the configuration snapshot.
//
// You specify the MaximumExecutionFrequency value for Six_Hours.
//
// You then specify the delivery channel deliveryFrequency value for TwentyFour_Hours.
//
// Because the value for deliveryFrequency is less frequent than MaximumExecutionFrequency,
// AWS Config invokes evaluations for the rule every 24 hours.
//
// You should set the MaximumExecutionFrequency value to be at least as frequent
// as the deliveryFrequency value. You can view the deliveryFrequency value
// by using the DescribeDeliveryChannnels action.
//
// To update the deliveryFrequency with which AWS Config delivers your configuration
// snapshots, use the PutDeliveryChannel action.
type ConfigSnapshotDeliveryProperties struct {
	_ struct{} `type:"structure"`

	// The frequency with which AWS Config delivers configuration snapshots.
	DeliveryFrequency *string `locationName:"deliveryFrequency" type:"string" enum:"MaximumExecutionFrequency"`
}

// String returns the string representation
func (s ConfigSnapshotDeliveryProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigSnapshotDeliveryProperties) GoString() string {
	return s.String()
}

// SetDeliveryFrequency sets the DeliveryFrequency field's value.
func (s *ConfigSnapshotDeliveryProperties) SetDeliveryFrequency(v string) *ConfigSnapshotDeliveryProperties {
	s.DeliveryFrequency = &v
	return s
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
type ConfigStreamDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	//
	// Note Providing an SNS topic on a DeliveryChannel (http://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for AWS Config is optional. If the SNS delivery is turned off, the last status
	// will be Not_Applicable.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"DeliveryStatus"`

	// The time from the last status change.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`
}

// String returns the string representation
func (s ConfigStreamDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigStreamDeliveryInfo) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorCode(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigStreamDeliveryInfo) SetLastErrorMessage(v string) *ConfigStreamDeliveryInfo {
	s.LastErrorMessage = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatus(v string) *ConfigStreamDeliveryInfo {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigStreamDeliveryInfo) SetLastStatusChangeTime(v time.Time) *ConfigStreamDeliveryInfo {
	s.LastStatusChangeTime = &v
	return s
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
type ConfigurationAggregator struct {
	_ struct{} `type:"structure"`

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []*AccountAggregationSource `type:"list"`

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string `type:"string"`

	// The name of the aggregator.
	ConfigurationAggregatorName *string `min:"1" type:"string"`

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time `type:"timestamp"`

	// The time of the last update.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`
}

// String returns the string representation
func (s ConfigurationAggregator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationAggregator) GoString() string {
	return s.String()
}

// SetAccountAggregationSources sets the AccountAggregationSources field's value.
func (s *ConfigurationAggregator) SetAccountAggregationSources(v []*AccountAggregationSource) *ConfigurationAggregator {
	s.AccountAggregationSources = v
	return s
}

// SetConfigurationAggregatorArn sets the ConfigurationAggregatorArn field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorArn(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorArn = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *ConfigurationAggregator) SetConfigurationAggregatorName(v string) *ConfigurationAggregator {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ConfigurationAggregator) SetCreationTime(v time.Time) *ConfigurationAggregator {
	s.CreationTime = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ConfigurationAggregator) SetLastUpdatedTime(v time.Time) *ConfigurationAggregator {
	s.LastUpdatedTime = &v
	return s
}

// SetOrganizationAggregationSource sets the OrganizationAggregationSource field's value.
func (s *ConfigurationAggregator) SetOrganizationAggregationSource(v *OrganizationAggregationSource) *ConfigurationAggregator {
	s.OrganizationAggregationSource = v
	return s
}

// A list that contains detailed configurations of a specified resource.
type ConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp"`

	// Unique MD5 hash that represents the configuration item's state.
	//
	// You can use MD5 hash to compare the states of two or more configuration items
	// that are associated with the same resource.
	ConfigurationItemMD5Hash *string `locationName:"configurationItemMD5Hash" type:"string"`

	// The configuration item status.
	ConfigurationItemStatus *string `locationName:"configurationItemStatus" type:"string" enum:"ConfigurationItemStatus"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// A list of CloudTrail event IDs.
	//
	// A populated field indicates that the current configuration was initiated
	// by the events recorded in the CloudTrail log. For more information about
	// CloudTrail, see What Is AWS CloudTrail (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
	//
	// An empty field indicates that the current configuration was not initiated
	// by any event.
	RelatedEvents []*string `locationName:"relatedEvents" type:"list"`

	// A list of related AWS resources.
	Relationships []*Relationship `locationName:"relationships" type:"list"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]*string `locationName:"supplementaryConfiguration" type:"map"`

	// A mapping of key value tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationItem) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *ConfigurationItem) SetAccountId(v string) *ConfigurationItem {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *ConfigurationItem) SetArn(v string) *ConfigurationItem {
	s.Arn = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ConfigurationItem) SetAvailabilityZone(v string) *ConfigurationItem {
	s.AvailabilityZone = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *ConfigurationItem) SetAwsRegion(v string) *ConfigurationItem {
	s.AwsRegion = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ConfigurationItem) SetConfiguration(v string) *ConfigurationItem {
	s.Configuration = &v
	return s
}

// SetConfigurationItemCaptureTime sets the ConfigurationItemCaptureTime field's value.
func (s *ConfigurationItem) SetConfigurationItemCaptureTime(v time.Time) *ConfigurationItem {
	s.ConfigurationItemCaptureTime = &v
	return s
}

// SetConfigurationItemMD5Hash sets the ConfigurationItemMD5Hash field's value.
func (s *ConfigurationItem) SetConfigurationItemMD5Hash(v string) *ConfigurationItem {
	s.ConfigurationItemMD5Hash = &v
	return s
}

// SetConfigurationItemStatus sets the ConfigurationItemStatus field's value.
func (s *ConfigurationItem) SetConfigurationItemStatus(v string) *ConfigurationItem {
	s.ConfigurationItemStatus = &v
	return s
}

// SetConfigurationStateId sets the ConfigurationStateId field's value.
func (s *ConfigurationItem) SetConfigurationStateId(v string) *ConfigurationItem {
	s.ConfigurationStateId = &v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *ConfigurationItem) SetRelatedEvents(v []*string) *ConfigurationItem {
	s.RelatedEvents = v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *ConfigurationItem) SetRelationships(v []*Relationship) *ConfigurationItem {
	s.Relationships = v
	return s
}

// SetResourceCreationTime sets the ResourceCreationTime field's value.
func (s *ConfigurationItem) SetResourceCreationTime(v time.Time) *ConfigurationItem {
	s.ResourceCreationTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConfigurationItem) SetResourceId(v string) *ConfigurationItem {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ConfigurationItem) SetResourceName(v string) *ConfigurationItem {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ConfigurationItem) SetResourceType(v string) *ConfigurationItem {
	s.ResourceType = &v
	return s
}

// SetSupplementaryConfiguration sets the SupplementaryConfiguration field's value.
func (s *ConfigurationItem) SetSupplementaryConfiguration(v map[string]*string) *ConfigurationItem {
	s.SupplementaryConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConfigurationItem) SetTags(v map[string]*string) *ConfigurationItem {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *ConfigurationItem) SetVersion(v string) *ConfigurationItem {
	s.Version = &v
	return s
}

// An object that represents the recording of configuration changes of an AWS
// resource.
type ConfigurationRecorder struct {
	_ struct{} `type:"structure"`

	// The name of the recorder. By default, AWS Config automatically assigns the
	// name "default" when creating the configuration recorder. You cannot change
	// the assigned name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the types of AWS resources for which AWS Config records configuration
	// changes.
	RecordingGroup *RecordingGroup `locationName:"recordingGroup" type:"structure"`

	// Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources
	// associated with the account.
	RoleARN *string `locationName:"roleARN" type:"string"`
}

// String returns the string representation
func (s ConfigurationRecorder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRecorder) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationRecorder) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationRecorder"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorder) SetName(v string) *ConfigurationRecorder {
	s.Name = &v
	return s
}

// SetRecordingGroup sets the RecordingGroup field's value.
func (s *ConfigurationRecorder) SetRecordingGroup(v *RecordingGroup) *ConfigurationRecorder {
	s.RecordingGroup = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ConfigurationRecorder) SetRoleARN(v string) *ConfigurationRecorder {
	s.RoleARN = &v
	return s
}

// The current status of the configuration recorder.
type ConfigurationRecorderStatus struct {
	_ struct{} `type:"structure"`

	// The error code indicating that the recording failed.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The message indicating that the recording failed due to an error.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// The time the recorder was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp"`

	// The last (previous) status of the recorder.
	LastStatus *string `locationName:"lastStatus" type:"string" enum:"RecorderStatus"`

	// The time when the status was last changed.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp"`

	// The time the recorder was last stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp"`

	// The name of the configuration recorder.
	Name *string `locationName:"name" type:"string"`

	// Specifies whether or not the recorder is currently recording.
	Recording *bool `locationName:"recording" type:"boolean"`
}

// String returns the string representation
func (s ConfigurationRecorderStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationRecorderStatus) GoString() string {
	return s.String()
}

// SetLastErrorCode sets the LastErrorCode field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorCode(v string) *ConfigurationRecorderStatus {
	s.LastErrorCode = &v
	return s
}

// SetLastErrorMessage sets the LastErrorMessage field's value.
func (s *ConfigurationRecorderStatus) SetLastErrorMessage(v string) *ConfigurationRecorderStatus {
	s.LastErrorMessage = &v
	return s
}

// SetLastStartTime sets the LastStartTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStartTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStartTime = &v
	return s
}

// SetLastStatus sets the LastStatus field's value.
func (s *ConfigurationRecorderStatus) SetLastStatus(v string) *ConfigurationRecorderStatus {
	s.LastStatus = &v
	return s
}

// SetLastStatusChangeTime sets the LastStatusChangeTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStatusChangeTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStatusChangeTime = &v
	return s
}

// SetLastStopTime sets the LastStopTime field's value.
func (s *ConfigurationRecorderStatus) SetLastStopTime(v time.Time) *ConfigurationRecorderStatus {
	s.LastStopTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigurationRecorderStatus) SetName(v string) *ConfigurationRecorderStatus {
	s.Name = &v
	return s
}

// SetRecording sets the Recording field's value.
func (s *ConfigurationRecorderStatus) SetRecording(v bool) *ConfigurationRecorderStatus {
	s.Recording = &v
	return s
}

type DeleteAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAggregationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAggregationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAggregationAuthorizationInput"}
	if s.AuthorizedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAccountId"))
	}
	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAccountId(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *DeleteAggregationAuthorizationInput) SetAuthorizedAwsRegion(v string) *DeleteAggregationAuthorizationInput {
	s.AuthorizedAwsRegion = &v
	return s
}

type DeleteAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAggregationAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule that you want to delete.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteConfigRuleInput) SetConfigRuleName(v string) *DeleteConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

type DeleteConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigRuleOutput) GoString() string {
	return s.String()
}

type DeleteConfigurationAggregatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationAggregatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationAggregatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationAggregatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationAggregatorInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DeleteConfigurationAggregatorInput) SetConfigurationAggregatorName(v string) *DeleteConfigurationAggregatorInput {
	s.ConfigurationAggregatorName = &v
	return s
}

type DeleteConfigurationAggregatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationAggregatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationAggregatorOutput) GoString() string {
	return s.String()
}

// The request object for the DeleteConfigurationRecorder action.
type DeleteConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration recorder to be deleted. You can retrieve the
	// name of your configuration recorder by using the DescribeConfigurationRecorders
	// action.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *DeleteConfigurationRecorderInput) SetConfigurationRecorderName(v string) *DeleteConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type DeleteConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationRecorderOutput) GoString() string {
	return s.String()
}

// The input for the DeleteDeliveryChannel action. The action accepts the following
// data, in JSON format.
type DeleteDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel to delete.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryChannelInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeleteDeliveryChannelInput) SetDeliveryChannelName(v string) *DeleteDeliveryChannelInput {
	s.DeliveryChannelName = &v
	return s
}

type DeleteDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeliveryChannelOutput) GoString() string {
	return s.String()
}

type DeleteEvaluationResultsInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule for which you want to delete the evaluation
	// results.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEvaluationResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationResultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEvaluationResultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEvaluationResultsInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *DeleteEvaluationResultsInput) SetConfigRuleName(v string) *DeleteEvaluationResultsInput {
	s.ConfigRuleName = &v
	return s
}

// The output when you delete the evaluation results for the specified AWS Config
// rule.
type DeleteEvaluationResultsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEvaluationResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationResultsOutput) GoString() string {
	return s.String()
}

type DeletePendingAggregationRequestInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	//
	// RequesterAccountId is a required field
	RequesterAccountId *string `type:"string" required:"true"`

	// The region requesting to aggregate data.
	//
	// RequesterAwsRegion is a required field
	RequesterAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePendingAggregationRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePendingAggregationRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePendingAggregationRequestInput"}
	if s.RequesterAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAccountId"))
	}
	if s.RequesterAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterAwsRegion"))
	}
	if s.RequesterAwsRegion != nil && len(*s.RequesterAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequesterAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequesterAccountId sets the RequesterAccountId field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAccountId(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAccountId = &v
	return s
}

// SetRequesterAwsRegion sets the RequesterAwsRegion field's value.
func (s *DeletePendingAggregationRequestInput) SetRequesterAwsRegion(v string) *DeletePendingAggregationRequestInput {
	s.RequesterAwsRegion = &v
	return s
}

type DeletePendingAggregationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePendingAggregationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePendingAggregationRequestOutput) GoString() string {
	return s.String()
}

type DeleteRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration to delete.
	//
	// RetentionConfigurationName is a required field
	RetentionConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRetentionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRetentionConfigurationInput"}
	if s.RetentionConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionConfigurationName"))
	}
	if s.RetentionConfigurationName != nil && len(*s.RetentionConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetentionConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionConfigurationName sets the RetentionConfigurationName field's value.
func (s *DeleteRetentionConfigurationInput) SetRetentionConfigurationName(v string) *DeleteRetentionConfigurationInput {
	s.RetentionConfigurationName = &v
	return s
}

type DeleteRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRetentionConfigurationOutput) GoString() string {
	return s.String()
}

// The input for the DeliverConfigSnapshot action.
type DeliverConfigSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery channel through which the snapshot is delivered.
	//
	// DeliveryChannelName is a required field
	DeliveryChannelName *string `locationName:"deliveryChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeliverConfigSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverConfigSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliverConfigSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliverConfigSnapshotInput"}
	if s.DeliveryChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannelName"))
	}
	if s.DeliveryChannelName != nil && len(*s.DeliveryChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannelName sets the DeliveryChannelName field's value.
func (s *DeliverConfigSnapshotInput) SetDeliveryChannelName(v string) *DeliverConfigSnapshotInput {
	s.DeliveryChannelName = &v
	return s
}

// The output for the DeliverConfigSnapshot action, in JSON format.
type DeliverConfigSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot that is being created.
	ConfigSnapshotId *string `locationName:"configSnapshotId" type:"string"`
}

// String returns the string representation
func (s DeliverConfigSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliverConfigSnapshotOutput) GoString() string {
	return s.String()
}

// SetConfigSnapshotId sets the ConfigSnapshotId field's value.
func (s *DeliverConfigSnapshotOutput) SetConfigSnapshotId(v string) *DeliverConfigSnapshotOutput {
	s.ConfigSnapshotId = &v
	return s
}

// The channel through which AWS Config delivers notifications and updated configuration
// states.
type DeliveryChannel struct {
	_ struct{} `type:"structure"`

	// The options for how often AWS Config delivers configuration snapshots to
	// the Amazon S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties `locationName:"configSnapshotDeliveryProperties" type:"structure"`

	// The name of the delivery channel. By default, AWS Config assigns the name
	// "default" when creating the delivery channel. To change the delivery channel
	// name, you must use the DeleteDeliveryChannel action to delete your current
	// delivery channel, and then you must use the PutDeliveryChannel command to
	// create a delivery channel that has the desired name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The name of the Amazon S3 bucket to which AWS Config delivers configuration
	// snapshots and configuration history files.
	//
	// If you specify a bucket that belongs to another AWS account, that bucket
	// must have policies that grant access permissions to AWS Config. For more
	// information, see Permissions for the Amazon S3 Bucket (http://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the AWS Config Developer Guide.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config
	// sends notifications about configuration changes.
	//
	// If you choose a topic from another account, the topic must have policies
	// that grant access permissions to AWS Config. For more information, see Permissions
	// for the Amazon SNS Topic (http://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the AWS Config Developer Guide.
	SnsTopicARN *string `locationName:"snsTopicARN" type:"string"`
}

// String returns the string representation
func (s DeliveryChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliveryChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliveryChannel"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigSnapshotDeliveryProperties sets the ConfigSnapshotDeliveryProperties field's value.
func (s *DeliveryChannel) SetConfigSnapshotDeliveryProperties(v *ConfigSnapshotDeliveryProperties) *DeliveryChannel {
	s.ConfigSnapshotDeliveryProperties = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannel) SetName(v string) *DeliveryChannel {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DeliveryChannel) SetS3BucketName(v string) *DeliveryChannel {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *DeliveryChannel) SetS3KeyPrefix(v string) *DeliveryChannel {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *DeliveryChannel) SetSnsTopicARN(v string) *DeliveryChannel {
	s.SnsTopicARN = &v
	return s
}

// The status of a specified delivery channel.
//
// Valid values: Success | Failure
type DeliveryChannelStatus struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of the delivery of the configuration history
	// to the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configHistoryDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configSnapshotDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo `locationName:"configStreamDeliveryInfo" type:"structure"`

	// The name of the delivery channel.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DeliveryChannelStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeliveryChannelStatus) GoString() string {
	return s.String()
}

// SetConfigHistoryDeliveryInfo sets the ConfigHistoryDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigHistoryDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigHistoryDeliveryInfo = v
	return s
}

// SetConfigSnapshotDeliveryInfo sets the ConfigSnapshotDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigSnapshotDeliveryInfo(v *ConfigExportDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigSnapshotDeliveryInfo = v
	return s
}

// SetConfigStreamDeliveryInfo sets the ConfigStreamDeliveryInfo field's value.
func (s *DeliveryChannelStatus) SetConfigStreamDeliveryInfo(v *ConfigStreamDeliveryInfo) *DeliveryChannelStatus {
	s.ConfigStreamDeliveryInfo = v
	return s
}

// SetName sets the Name field's value.
func (s *DeliveryChannelStatus) SetName(v string) *DeliveryChannelStatus {
	s.Name = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results by ConfigRuleComplianceFilters object.
	Filters *ConfigRuleComplianceFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConfigRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConfigRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAggregateComplianceByConfigRulesInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetConfigurationAggregatorName(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetFilters(v *ConfigRuleComplianceFilters) *DescribeAggregateComplianceByConfigRulesInput {
	s.Filters = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetLimit(v int64) *DescribeAggregateComplianceByConfigRulesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesInput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeAggregateComplianceByConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceByConfigRule object.
	AggregateComplianceByConfigRules []*AggregateComplianceByConfigRule `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregateComplianceByConfigRulesOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceByConfigRules sets the AggregateComplianceByConfigRules field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetAggregateComplianceByConfigRules(v []*AggregateComplianceByConfigRule) *DescribeAggregateComplianceByConfigRulesOutput {
	s.AggregateComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregateComplianceByConfigRulesOutput) SetNextToken(v string) *DescribeAggregateComplianceByConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregationAuthorizationsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribeAggregationAuthorizationsInput) SetLimit(v int64) *DescribeAggregationAuthorizationsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsInput) SetNextToken(v string) *DescribeAggregationAuthorizationsInput {
	s.NextToken = &v
	return s
}

type DescribeAggregationAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of authorizations granted to various aggregator accounts and
	// regions.
	AggregationAuthorizations []*AggregationAuthorization `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregationAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAggregationAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetAggregationAuthorizations sets the AggregationAuthorizations field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetAggregationAuthorizations(v []*AggregationAuthorization) *DescribeAggregationAuthorizationsOutput {
	s.AggregationAuthorizations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAggregationAuthorizationsOutput) SetNextToken(v string) *DescribeAggregationAuthorizationsOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and INSUFFICIENT_DATA.
	ComplianceTypes []*string `type:"list"`

	// Specify one or more AWS Config rule names to filter the results by rule.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByConfigRuleInput) GoString() string {
	return s.String()
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByConfigRuleInput) SetComplianceTypes(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeComplianceByConfigRuleInput) SetConfigRuleNames(v []*string) *DescribeComplianceByConfigRuleInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleInput) SetNextToken(v string) *DescribeComplianceByConfigRuleInput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether each of the specified AWS Config rules is compliant.
	ComplianceByConfigRules []*ComplianceByConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceByConfigRules sets the ComplianceByConfigRules field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetComplianceByConfigRules(v []*ComplianceByConfigRule) *DescribeComplianceByConfigRuleOutput {
	s.ComplianceByConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByConfigRuleOutput) SetNextToken(v string) *DescribeComplianceByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type DescribeComplianceByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT and NON_COMPLIANT.
	ComplianceTypes []*string `type:"list"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information. You
	// can specify only one resource ID. If you specify a resource ID, you must
	// also specify a type for ResourceType.
	ResourceId *string `min:"1" type:"string"`

	// The types of AWS resources for which you want compliance information (for
	// example, AWS::EC2::Instance). For this action, you can specify that the resource
	// type is an AWS account by specifying AWS::::Account.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComplianceByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComplianceByResourceInput"}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *DescribeComplianceByResourceInput) SetComplianceTypes(v []*string) *DescribeComplianceByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeComplianceByResourceInput) SetLimit(v int64) *DescribeComplianceByResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceInput) SetNextToken(v string) *DescribeComplianceByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeComplianceByResourceInput) SetResourceId(v string) *DescribeComplianceByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeComplianceByResourceInput) SetResourceType(v string) *DescribeComplianceByResourceInput {
	s.ResourceType = &v
	return s
}

type DescribeComplianceByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies with all of the AWS
	// Config rules that evaluate it.
	ComplianceByResources []*ComplianceByResource `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeComplianceByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeComplianceByResourceOutput) GoString() string {
	return s.String()
}

// SetComplianceByResources sets the ComplianceByResources field's value.
func (s *DescribeComplianceByResourceOutput) SetComplianceByResources(v []*ComplianceByResource) *DescribeComplianceByResourceOutput {
	s.ComplianceByResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeComplianceByResourceOutput) SetNextToken(v string) *DescribeComplianceByResourceOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS managed Config rules for which you want status information.
	// If you do not specify any names, AWS Config returns status information for
	// all AWS managed Config rules that you use.
	ConfigRuleNames []*string `type:"list"`

	// The number of rule evaluation results that you want returned.
	//
	// This parameter is required if the rule limit for your account is more than
	// the default of 50 rules.
	//
	// For information about requesting a rule limit increase, see AWS Config Limits
	// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
	// in the AWS General Reference Guide.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRuleEvaluationStatusInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetConfigRuleNames(v []*string) *DescribeConfigRuleEvaluationStatusInput {
	s.ConfigRuleNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetLimit(v int64) *DescribeConfigRuleEvaluationStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusInput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRuleEvaluationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Status information about your AWS managed Config rules.
	ConfigRulesEvaluationStatus []*ConfigRuleEvaluationStatus `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRuleEvaluationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRuleEvaluationStatusOutput) GoString() string {
	return s.String()
}

// SetConfigRulesEvaluationStatus sets the ConfigRulesEvaluationStatus field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetConfigRulesEvaluationStatus(v []*ConfigRuleEvaluationStatus) *DescribeConfigRuleEvaluationStatusOutput {
	s.ConfigRulesEvaluationStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRuleEvaluationStatusOutput) SetNextToken(v string) *DescribeConfigRuleEvaluationStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The names of the AWS Config rules for which you want details. If you do not
	// specify any names, AWS Config returns details for all your rules.
	ConfigRuleNames []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRulesInput) GoString() string {
	return s.String()
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *DescribeConfigRulesInput) SetConfigRuleNames(v []*string) *DescribeConfigRulesInput {
	s.ConfigRuleNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesInput) SetNextToken(v string) *DescribeConfigRulesInput {
	s.NextToken = &v
	return s
}

type DescribeConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// The details about your AWS Config rules.
	ConfigRules []*ConfigRule `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigRulesOutput) GoString() string {
	return s.String()
}

// SetConfigRules sets the ConfigRules field's value.
func (s *DescribeConfigRulesOutput) SetConfigRules(v []*ConfigRule) *DescribeConfigRulesOutput {
	s.ConfigRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigRulesOutput) SetNextToken(v string) *DescribeConfigRulesOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of AggregatorSourceStatus returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Filters the status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	UpdateStatus []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationAggregatorSourcesStatusInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.UpdateStatus != nil && len(s.UpdateStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateStatus", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetConfigurationAggregatorName(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetLimit(v int64) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.NextToken = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusInput) SetUpdateStatus(v []*string) *DescribeConfigurationAggregatorSourcesStatusInput {
	s.UpdateStatus = v
	return s
}

type DescribeConfigurationAggregatorSourcesStatusOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregatedSourceStatus object.
	AggregatedSourceStatusList []*AggregatedSourceStatus `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorSourcesStatusOutput) GoString() string {
	return s.String()
}

// SetAggregatedSourceStatusList sets the AggregatedSourceStatusList field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetAggregatedSourceStatusList(v []*AggregatedSourceStatus) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.AggregatedSourceStatusList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorSourcesStatusOutput) SetNextToken(v string) *DescribeConfigurationAggregatorSourcesStatusOutput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregators.
	ConfigurationAggregatorNames []*string `type:"list"`

	// The maximum number of configuration aggregators returned on each page. The
	// default is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorsInput) GoString() string {
	return s.String()
}

// SetConfigurationAggregatorNames sets the ConfigurationAggregatorNames field's value.
func (s *DescribeConfigurationAggregatorsInput) SetConfigurationAggregatorNames(v []*string) *DescribeConfigurationAggregatorsInput {
	s.ConfigurationAggregatorNames = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConfigurationAggregatorsInput) SetLimit(v int64) *DescribeConfigurationAggregatorsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsInput) SetNextToken(v string) *DescribeConfigurationAggregatorsInput {
	s.NextToken = &v
	return s
}

type DescribeConfigurationAggregatorsOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationAggregators object.
	ConfigurationAggregators []*ConfigurationAggregator `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeConfigurationAggregatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationAggregatorsOutput) GoString() string {
	return s.String()
}

// SetConfigurationAggregators sets the ConfigurationAggregators field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetConfigurationAggregators(v []*ConfigurationAggregator) *DescribeConfigurationAggregatorsOutput {
	s.ConfigurationAggregators = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConfigurationAggregatorsOutput) SetNextToken(v string) *DescribeConfigurationAggregatorsOutput {
	s.NextToken = &v
	return s
}

// The input for the DescribeConfigurationRecorderStatus action.
type DescribeConfigurationRecorderStatusInput struct {
	_ struct{} `type:"structure"`

	// The name(s) of the configuration recorder. If the name is not specified,
	// the action returns the current status of all the configuration recorders
	// associated with the account.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecorderStatusInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecorderStatusInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecorderStatusInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorderStatus action, in JSON format.
type DescribeConfigurationRecorderStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains status of the specified recorders.
	ConfigurationRecordersStatus []*ConfigurationRecorderStatus `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecorderStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecorderStatusOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecordersStatus sets the ConfigurationRecordersStatus field's value.
func (s *DescribeConfigurationRecorderStatusOutput) SetConfigurationRecordersStatus(v []*ConfigurationRecorderStatus) *DescribeConfigurationRecorderStatusOutput {
	s.ConfigurationRecordersStatus = v
	return s
}

// The input for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration recorder names.
	ConfigurationRecorderNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecordersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecordersInput) GoString() string {
	return s.String()
}

// SetConfigurationRecorderNames sets the ConfigurationRecorderNames field's value.
func (s *DescribeConfigurationRecordersInput) SetConfigurationRecorderNames(v []*string) *DescribeConfigurationRecordersInput {
	s.ConfigurationRecorderNames = v
	return s
}

// The output for the DescribeConfigurationRecorders action.
type DescribeConfigurationRecordersOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified configuration recorders.
	ConfigurationRecorders []*ConfigurationRecorder `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationRecordersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationRecordersOutput) GoString() string {
	return s.String()
}

// SetConfigurationRecorders sets the ConfigurationRecorders field's value.
func (s *DescribeConfigurationRecordersOutput) SetConfigurationRecorders(v []*ConfigurationRecorder) *DescribeConfigurationRecordersOutput {
	s.ConfigurationRecorders = v
	return s
}

// The input for the DeliveryChannelStatus action.
type DescribeDeliveryChannelStatusInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelStatusInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelStatusInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelStatusInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannelStatus action.
type DescribeDeliveryChannelStatusOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of a specified delivery channel.
	DeliveryChannelsStatus []*DeliveryChannelStatus `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelStatusOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannelsStatus sets the DeliveryChannelsStatus field's value.
func (s *DescribeDeliveryChannelStatusOutput) SetDeliveryChannelsStatus(v []*DeliveryChannelStatus) *DescribeDeliveryChannelStatusOutput {
	s.DeliveryChannelsStatus = v
	return s
}

// The input for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsInput struct {
	_ struct{} `type:"structure"`

	// A list of delivery channel names.
	DeliveryChannelNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelsInput) GoString() string {
	return s.String()
}

// SetDeliveryChannelNames sets the DeliveryChannelNames field's value.
func (s *DescribeDeliveryChannelsInput) SetDeliveryChannelNames(v []*string) *DescribeDeliveryChannelsInput {
	s.DeliveryChannelNames = v
	return s
}

// The output for the DescribeDeliveryChannels action.
type DescribeDeliveryChannelsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the descriptions of the specified delivery channel.
	DeliveryChannels []*DeliveryChannel `type:"list"`
}

// String returns the string representation
func (s DescribeDeliveryChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeliveryChannelsOutput) GoString() string {
	return s.String()
}

// SetDeliveryChannels sets the DeliveryChannels field's value.
func (s *DescribeDeliveryChannelsOutput) SetDeliveryChannels(v []*DeliveryChannel) *DescribeDeliveryChannelsOutput {
	s.DeliveryChannels = v
	return s
}

type DescribePendingAggregationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingAggregationRequestsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *DescribePendingAggregationRequestsInput) SetLimit(v int64) *DescribePendingAggregationRequestsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsInput) SetNextToken(v string) *DescribePendingAggregationRequestsInput {
	s.NextToken = &v
	return s
}

type DescribePendingAggregationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a PendingAggregationRequests object.
	PendingAggregationRequests []*PendingAggregationRequest `type:"list"`
}

// String returns the string representation
func (s DescribePendingAggregationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingAggregationRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePendingAggregationRequestsOutput) SetNextToken(v string) *DescribePendingAggregationRequestsOutput {
	s.NextToken = &v
	return s
}

// SetPendingAggregationRequests sets the PendingAggregationRequests field's value.
func (s *DescribePendingAggregationRequestsOutput) SetPendingAggregationRequests(v []*PendingAggregationRequest) *DescribePendingAggregationRequestsOutput {
	s.PendingAggregationRequests = v
	return s
}

type DescribeRetentionConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// A list of names of retention configurations for which you want details. If
	// you do not specify a name, AWS Config returns details for all the retention
	// configurations for that account.
	//
	// Currently, AWS Config supports only one retention configuration per region
	// in your account.
	RetentionConfigurationNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRetentionConfigurationsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsInput) SetNextToken(v string) *DescribeRetentionConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurationNames sets the RetentionConfigurationNames field's value.
func (s *DescribeRetentionConfigurationsInput) SetRetentionConfigurationNames(v []*string) *DescribeRetentionConfigurationsInput {
	s.RetentionConfigurationNames = v
	return s
}

type DescribeRetentionConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// Returns a retention configuration object.
	RetentionConfigurations []*RetentionConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeRetentionConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRetentionConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRetentionConfigurationsOutput) SetNextToken(v string) *DescribeRetentionConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetRetentionConfigurations sets the RetentionConfigurations field's value.
func (s *DescribeRetentionConfigurationsOutput) SetRetentionConfigurations(v []*RetentionConfiguration) *DescribeRetentionConfigurationsOutput {
	s.RetentionConfigurations = v
	return s
}

// Identifies an AWS resource and indicates whether it complies with the AWS
// Config rule that it was evaluated against.
type Evaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// The ID of the AWS resource that was evaluated.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The type of AWS resource that was evaluated.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// it was evaluated against.
	//
	// For the Evaluation data type, AWS Config supports only the COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE values. AWS Config does not support the INSUFFICIENT_DATA
	// value for this data type.
	//
	// Similarly, AWS Config does not accept INSUFFICIENT_DATA as the value for
	// ComplianceType from a PutEvaluations request. For example, an AWS Lambda
	// function for a custom AWS Config rule cannot pass an INSUFFICIENT_DATA value
	// to AWS Config.
	//
	// ComplianceType is a required field
	ComplianceType *string `type:"string" required:"true" enum:"ComplianceType"`

	// The time of the event in AWS Config that triggered the evaluation. For event-based
	// evaluations, the time indicates when AWS Config created the configuration
	// item that triggered the evaluation. For periodic evaluations, the time indicates
	// when AWS Config triggered the evaluation at the frequency that you specified
	// (for example, every 24 hours).
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evaluation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Evaluation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Evaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Annotation", 1))
	}
	if s.ComplianceResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.ComplianceResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if s.ComplianceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComplianceType"))
	}
	if s.OrderingTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotation sets the Annotation field's value.
func (s *Evaluation) SetAnnotation(v string) *Evaluation {
	s.Annotation = &v
	return s
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *Evaluation) SetComplianceResourceId(v string) *Evaluation {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceType sets the ComplianceResourceType field's value.
func (s *Evaluation) SetComplianceResourceType(v string) *Evaluation {
	s.ComplianceResourceType = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *Evaluation) SetComplianceType(v string) *Evaluation {
	s.ComplianceType = &v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *Evaluation) SetOrderingTimestamp(v time.Time) *Evaluation {
	s.OrderingTimestamp = &v
	return s
}

// The details of an AWS Config evaluation. Provides the AWS resource that was
// evaluated, the compliance of the resource, related time stamps, and supplementary
// information.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// evaluated it.
	//
	// For the EvaluationResult data type, AWS Config supports only the COMPLIANT,
	// NON_COMPLIANT, and NOT_APPLICABLE values. AWS Config does not support the
	// INSUFFICIENT_DATA value for the EvaluationResult data type.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// The token identifies the rule, the AWS resource being evaluated, and the
	// event that triggered the evaluation.
	ResultToken *string `type:"string"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetAnnotation sets the Annotation field's value.
func (s *EvaluationResult) SetAnnotation(v string) *EvaluationResult {
	s.Annotation = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *EvaluationResult) SetComplianceType(v string) *EvaluationResult {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleInvokedTime sets the ConfigRuleInvokedTime field's value.
func (s *EvaluationResult) SetConfigRuleInvokedTime(v time.Time) *EvaluationResult {
	s.ConfigRuleInvokedTime = &v
	return s
}

// SetEvaluationResultIdentifier sets the EvaluationResultIdentifier field's value.
func (s *EvaluationResult) SetEvaluationResultIdentifier(v *EvaluationResultIdentifier) *EvaluationResult {
	s.EvaluationResultIdentifier = v
	return s
}

// SetResultRecordedTime sets the ResultRecordedTime field's value.
func (s *EvaluationResult) SetResultRecordedTime(v time.Time) *EvaluationResult {
	s.ResultRecordedTime = &v
	return s
}

// SetResultToken sets the ResultToken field's value.
func (s *EvaluationResult) SetResultToken(v string) *EvaluationResult {
	s.ResultToken = &v
	return s
}

// Uniquely identifies an evaluation result.
type EvaluationResultIdentifier struct {
	_ struct{} `type:"structure"`

	// Identifies an AWS Config rule used to evaluate an AWS resource, and provides
	// the type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier `type:"structure"`

	// The time of the event that triggered the evaluation of your AWS resources.
	// The time can indicate when AWS Config delivered a configuration item change
	// notification, or it can indicate when AWS Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EvaluationResultIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResultIdentifier) GoString() string {
	return s.String()
}

// SetEvaluationResultQualifier sets the EvaluationResultQualifier field's value.
func (s *EvaluationResultIdentifier) SetEvaluationResultQualifier(v *EvaluationResultQualifier) *EvaluationResultIdentifier {
	s.EvaluationResultQualifier = v
	return s
}

// SetOrderingTimestamp sets the OrderingTimestamp field's value.
func (s *EvaluationResultIdentifier) SetOrderingTimestamp(v time.Time) *EvaluationResultIdentifier {
	s.OrderingTimestamp = &v
	return s
}

// Identifies an AWS Config rule that evaluated an AWS resource, and provides
// the type and ID of the resource that the rule evaluated.
type EvaluationResultQualifier struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule that was used in the evaluation.
	ConfigRuleName *string `min:"1" type:"string"`

	// The ID of the evaluated AWS resource.
	ResourceId *string `min:"1" type:"string"`

	// The type of AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EvaluationResultQualifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResultQualifier) GoString() string {
	return s.String()
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *EvaluationResultQualifier) SetConfigRuleName(v string) *EvaluationResultQualifier {
	s.ConfigRuleName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *EvaluationResultQualifier) SetResourceId(v string) *EvaluationResultQualifier {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *EvaluationResultQualifier) SetResourceType(v string) *EvaluationResultQualifier {
	s.ResourceType = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The source region from where the data is aggregated.
	//
	// AwsRegion is a required field
	AwsRegion *string `min:"1" type:"string" required:"true"`

	// The resource compliance status.
	//
	// For the GetAggregateComplianceDetailsByConfigRuleRequest data type, AWS Config
	// supports only the COMPLIANT and NON_COMPLIANT. AWS Config does not support
	// the NOT_APPLICABLE and INSUFFICIENT_DATA values.
	ComplianceType *string `type:"string" enum:"ComplianceType"`

	// The name of the AWS Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 50. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateComplianceDetailsByConfigRuleInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AwsRegion"))
	}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAccountId(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AccountId = &v
	return s
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetAwsRegion(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.AwsRegion = &v
	return s
}

// SetComplianceType sets the ComplianceType field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetComplianceType(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ComplianceType = &v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetConfigurationAggregatorName(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetAggregateComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregateEvaluationResults object.
	AggregateEvaluationResults []*AggregateEvaluationResult `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetAggregateEvaluationResults sets the AggregateEvaluationResults field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetAggregateEvaluationResults(v []*AggregateEvaluationResult) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.AggregateEvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetAggregateComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ConfigRuleComplianceSummaryFilters object.
	Filters *ConfigRuleComplianceSummaryFilters `type:"structure"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `type:"string" enum:"ConfigRuleComplianceSummaryGroupKey"`

	// The maximum number of evaluation results returned on each page. The default
	// is 1000. You cannot specify a number greater than 1000. If you specify 0,
	// AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConfigRuleComplianceSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAggregateConfigRuleComplianceSummaryInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetConfigurationAggregatorName(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetFilters(v *ConfigRuleComplianceSummaryFilters) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Filters = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.GroupByKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetLimit(v int64) *GetAggregateConfigRuleComplianceSummaryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryInput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryInput {
	s.NextToken = &v
	return s
}

type GetAggregateConfigRuleComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceCounts object.
	AggregateComplianceCounts []*AggregateComplianceCount `type:"list"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryOutput) GoString() string {
	return s.String()
}

// SetAggregateComplianceCounts sets the AggregateComplianceCounts field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetAggregateComplianceCounts(v []*AggregateComplianceCount) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.AggregateComplianceCounts = v
	return s
}

// SetGroupByKey sets the GroupByKey field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetGroupByKey(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.GroupByKey = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAggregateConfigRuleComplianceSummaryOutput) SetNextToken(v string) *GetAggregateConfigRuleComplianceSummaryOutput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list"`

	// The name of the AWS Config rule for which you want compliance information.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByConfigRuleInput"}
	if s.ConfigRuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByConfigRuleInput {
	s.ComplianceTypes = v
	return s
}

// SetConfigRuleName sets the ConfigRuleName field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetConfigRuleName(v string) *GetComplianceDetailsByConfigRuleInput {
	s.ConfigRuleName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetLimit(v int64) *GetComplianceDetailsByConfigRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleInput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleInput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS resource complies with the specified AWS Config
	// rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByConfigRuleOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByConfigRuleOutput) SetNextToken(v string) *GetComplianceDetailsByConfigRuleOutput {
	s.NextToken = &v
	return s
}

type GetComplianceDetailsByResourceInput struct {
	_ struct{} `type:"structure"`

	// Filters the results by compliance.
	//
	// The allowed values are COMPLIANT, NON_COMPLIANT, and NOT_APPLICABLE.
	ComplianceTypes []*string `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`

	// The ID of the AWS resource for which you want compliance information.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The type of the AWS resource for which you want compliance information.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailsByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComplianceDetailsByResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceTypes sets the ComplianceTypes field's value.
func (s *GetComplianceDetailsByResourceInput) SetComplianceTypes(v []*string) *GetComplianceDetailsByResourceInput {
	s.ComplianceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceInput) SetNextToken(v string) *GetComplianceDetailsByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceId(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetComplianceDetailsByResourceInput) SetResourceType(v string) *GetComplianceDetailsByResourceInput {
	s.ResourceType = &v
	return s
}

type GetComplianceDetailsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified AWS resource complies each AWS Config rule.
	EvaluationResults []*EvaluationResult `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetComplianceDetailsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceDetailsByResourceOutput) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *GetComplianceDetailsByResourceOutput) SetEvaluationResults(v []*EvaluationResult) *GetComplianceDetailsByResourceOutput {
	s.EvaluationResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetComplianceDetailsByResourceOutput) SetNextToken(v string) *GetComplianceDetailsByResourceOutput {
	s.NextToken = &v
	return s
}

type GetComplianceSummaryByConfigRuleInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetComplianceSummaryByConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByConfigRuleInput) GoString() string {
	return s.String()
}

type GetComplianceSummaryByConfigRuleOutput struct {
	_ struct{} `type:"structure"`

	// The number of AWS Config rules that are compliant and the number that are
	// noncompliant, up to a maximum of 25 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`
}

// String returns the string representation
func (s GetComplianceSummaryByConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByConfigRuleOutput) GoString() string {
	return s.String()
}

// SetComplianceSummary sets the ComplianceSummary field's value.
func (s *GetComplianceSummaryByConfigRuleOutput) SetComplianceSummary(v *ComplianceSummary) *GetComplianceSummaryByConfigRuleOutput {
	s.ComplianceSummary = v
	return s
}

type GetComplianceSummaryByResourceTypeInput struct {
	_ struct{} `type:"structure"`

	// Specify one or more resource types to get the number of resources that are
	// compliant and the number that are noncompliant for each resource type.
	//
	// For this request, you can specify an AWS resource type such as AWS::EC2::Instance.
	// You can specify that the resource type is an AWS account by specifying AWS::::Account.
	ResourceTypes []*string `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByResourceTypeInput) GoString() string {
	return s.String()
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetComplianceSummaryByResourceTypeInput) SetResourceTypes(v []*string) *GetComplianceSummaryByResourceTypeInput {
	s.ResourceTypes = v
	return s
}

type GetComplianceSummaryByResourceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The number of resources that are compliant and the number that are noncompliant.
	// If one or more resource types were provided with the request, the numbers
	// are returned for each resource type. The maximum number returned is 100.
	ComplianceSummariesByResourceType []*ComplianceSummaryByResourceType `type:"list"`
}

// String returns the string representation
func (s GetComplianceSummaryByResourceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetComplianceSummaryByResourceTypeOutput) GoString() string {
	return s.String()
}

// SetComplianceSummariesByResourceType sets the ComplianceSummariesByResourceType field's value.
func (s *GetComplianceSummaryByResourceTypeOutput) SetComplianceSummariesByResourceType(v []*ComplianceSummaryByResourceType) *GetComplianceSummaryByResourceTypeOutput {
	s.ComplianceSummariesByResourceType = v
	return s
}

type GetDiscoveredResourceCountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of ResourceCount objects returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The comma-separated list that specifies the resource types that you want
	// AWS Config to return (for example, "AWS::EC2::Instance", "AWS::IAM::User").
	//
	// If a value for resourceTypes is not specified, AWS Config returns all resource
	// types that AWS Config is recording in the region for your account.
	//
	// If the configuration recorder is turned off, AWS Config returns an empty
	// list of ResourceCount objects. If the configuration recorder is not recording
	// a specific resource type (for example, S3 buckets), that resource type is
	// not returned in the list of ResourceCount objects.
	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s GetDiscoveredResourceCountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoveredResourceCountsInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetDiscoveredResourceCountsInput) SetLimit(v int64) *GetDiscoveredResourceCountsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsInput) SetNextToken(v string) *GetDiscoveredResourceCountsInput {
	s.NextToken = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetDiscoveredResourceCountsInput) SetResourceTypes(v []*string) *GetDiscoveredResourceCountsInput {
	s.ResourceTypes = v
	return s
}

type GetDiscoveredResourceCountsOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ResourceCount objects. Each object is listed in descending order
	// by the number of resources.
	ResourceCounts []*ResourceCount `locationName:"resourceCounts" type:"list"`

	// The total number of resources that AWS Config is recording in the region
	// for your account. If you specify resource types in the request, AWS Config
	// returns only the total number of resources for those resource types.
	//
	// Example
	//
	// AWS Config is recording three resource types in the US East (Ohio) Region
	// for your account: 25 EC2 instances, 20 IAM users, and 15 S3 buckets, for
	// a total of 60 resources.
	//
	// You make a call to the GetDiscoveredResourceCounts action and specify the
	// resource type, "AWS::EC2::Instances", in the request.
	//
	// AWS Config returns 25 for totalDiscoveredResources.
	TotalDiscoveredResources *int64 `locationName:"totalDiscoveredResources" type:"long"`
}

// String returns the string representation
func (s GetDiscoveredResourceCountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiscoveredResourceCountsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetDiscoveredResourceCountsOutput) SetNextToken(v string) *GetDiscoveredResourceCountsOutput {
	s.NextToken = &v
	return s
}

// SetResourceCounts sets the ResourceCounts field's value.
func (s *GetDiscoveredResourceCountsOutput) SetResourceCounts(v []*ResourceCount) *GetDiscoveredResourceCountsOutput {
	s.ResourceCounts = v
	return s
}

// SetTotalDiscoveredResources sets the TotalDiscoveredResources field's value.
func (s *GetDiscoveredResourceCountsOutput) SetTotalDiscoveredResources(v int64) *GetDiscoveredResourceCountsOutput {
	s.TotalDiscoveredResources = &v
	return s
}

// The input for the GetResourceConfigHistory action.
type GetResourceConfigHistoryInput struct {
	_ struct{} `type:"structure"`

	// The chronological order for configuration items listed. By default, the results
	// are listed in reverse chronological order.
	ChronologicalOrder *string `locationName:"chronologicalOrder" type:"string" enum:"ChronologicalOrder"`

	// The time stamp that indicates an earlier time. If not specified, the action
	// returns paginated results that contain configuration items that start when
	// the first configuration item was recorded.
	EarlierTime *time.Time `locationName:"earlierTime" type:"timestamp"`

	// The time stamp that indicates a later time. If not specified, current time
	// is taken.
	LaterTime *time.Time `locationName:"laterTime" type:"timestamp"`

	// The maximum number of configuration items returned on each page. The default
	// is 10. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s GetResourceConfigHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceConfigHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceConfigHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceConfigHistoryInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChronologicalOrder sets the ChronologicalOrder field's value.
func (s *GetResourceConfigHistoryInput) SetChronologicalOrder(v string) *GetResourceConfigHistoryInput {
	s.ChronologicalOrder = &v
	return s
}

// SetEarlierTime sets the EarlierTime field's value.
func (s *GetResourceConfigHistoryInput) SetEarlierTime(v time.Time) *GetResourceConfigHistoryInput {
	s.EarlierTime = &v
	return s
}

// SetLaterTime sets the LaterTime field's value.
func (s *GetResourceConfigHistoryInput) SetLaterTime(v time.Time) *GetResourceConfigHistoryInput {
	s.LaterTime = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetResourceConfigHistoryInput) SetLimit(v int64) *GetResourceConfigHistoryInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryInput) SetNextToken(v string) *GetResourceConfigHistoryInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResourceConfigHistoryInput) SetResourceId(v string) *GetResourceConfigHistoryInput {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetResourceConfigHistoryInput) SetResourceType(v string) *GetResourceConfigHistoryInput {
	s.ResourceType = &v
	return s
}

// The output for the GetResourceConfigHistory action.
type GetResourceConfigHistoryOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the configuration history of one or more resources.
	ConfigurationItems []*ConfigurationItem `locationName:"configurationItems" type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetResourceConfigHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceConfigHistoryOutput) GoString() string {
	return s.String()
}

// SetConfigurationItems sets the ConfigurationItems field's value.
func (s *GetResourceConfigHistoryOutput) SetConfigurationItems(v []*ConfigurationItem) *GetResourceConfigHistoryOutput {
	s.ConfigurationItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceConfigHistoryOutput) SetNextToken(v string) *GetResourceConfigHistoryOutput {
	s.NextToken = &v
	return s
}

type ListDiscoveredResourcesInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether AWS Config includes deleted resources in the results. By
	// default, deleted resources are not included.
	IncludeDeletedResources *bool `locationName:"includeDeletedResources" type:"boolean"`

	// The maximum number of resource identifiers returned on each page. The default
	// is 100. You cannot specify a number greater than 100. If you specify 0, AWS
	// Config uses the default.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The IDs of only those resources that you want AWS Config to list in the response.
	// If you do not specify this parameter, AWS Config lists all resources of the
	// specified type that it has discovered.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`

	// The custom name of only those resources that you want AWS Config to list
	// in the response. If you do not specify this parameter, AWS Config lists all
	// resources of the specified type that it has discovered.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resources that you want AWS Config to list in the response.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s ListDiscoveredResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDiscoveredResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDiscoveredResourcesInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeletedResources sets the IncludeDeletedResources field's value.
func (s *ListDiscoveredResourcesInput) SetIncludeDeletedResources(v bool) *ListDiscoveredResourcesInput {
	s.IncludeDeletedResources = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDiscoveredResourcesInput) SetLimit(v int64) *ListDiscoveredResourcesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesInput) SetNextToken(v string) *ListDiscoveredResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ListDiscoveredResourcesInput) SetResourceIds(v []*string) *ListDiscoveredResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListDiscoveredResourcesInput) SetResourceName(v string) *ListDiscoveredResourcesInput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListDiscoveredResourcesInput) SetResourceType(v string) *ListDiscoveredResourcesInput {
	s.ResourceType = &v
	return s
}

type ListDiscoveredResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details that identify a resource that is discovered by AWS Config, including
	// the resource type, ID, and (if available) the custom resource name.
	ResourceIdentifiers []*ResourceIdentifier `locationName:"resourceIdentifiers" type:"list"`
}

// String returns the string representation
func (s ListDiscoveredResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDiscoveredResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDiscoveredResourcesOutput) SetNextToken(v string) *ListDiscoveredResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListDiscoveredResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *ListDiscoveredResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

// This object contains regions to setup the aggregator and an IAM role to retrieve
// organization details.
type OrganizationAggregationSource struct {
	_ struct{} `type:"structure"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []*string `min:"1" type:"list"`

	// ARN of the IAM role used to retreive AWS Organization details associated
	// with the aggregator account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OrganizationAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationAggregationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationAggregationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrganizationAggregationSource"}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AwsRegions", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllAwsRegions sets the AllAwsRegions field's value.
func (s *OrganizationAggregationSource) SetAllAwsRegions(v bool) *OrganizationAggregationSource {
	s.AllAwsRegions = &v
	return s
}

// SetAwsRegions sets the AwsRegions field's value.
func (s *OrganizationAggregationSource) SetAwsRegions(v []*string) *OrganizationAggregationSource {
	s.AwsRegions = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *OrganizationAggregationSource) SetRoleArn(v string) *OrganizationAggregationSource {
	s.RoleArn = &v
	return s
}

// An object that represents the account ID and region of an aggregator account
// that is requesting authorization but is not yet authorized.
type PendingAggregationRequest struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	RequesterAccountId *string `type:"string"`

	// The region requesting to aggregate data.
	RequesterAwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PendingAggregationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingAggregationRequest) GoString() string {
	return s.String()
}

// SetRequesterAccountId sets the RequesterAccountId field's value.
func (s *PendingAggregationRequest) SetRequesterAccountId(v string) *PendingAggregationRequest {
	s.RequesterAccountId = &v
	return s
}

// SetRequesterAwsRegion sets the RequesterAwsRegion field's value.
func (s *PendingAggregationRequest) SetRequesterAwsRegion(v string) *PendingAggregationRequest {
	s.RequesterAwsRegion = &v
	return s
}

type PutAggregationAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account authorized to aggregate data.
	//
	// AuthorizedAccountId is a required field
	AuthorizedAccountId *string `type:"string" required:"true"`

	// The region authorized to collect aggregated data.
	//
	// AuthorizedAwsRegion is a required field
	AuthorizedAwsRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutAggregationAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAggregationAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAggregationAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAggregationAuthorizationInput"}
	if s.AuthorizedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAccountId"))
	}
	if s.AuthorizedAwsRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizedAwsRegion"))
	}
	if s.AuthorizedAwsRegion != nil && len(*s.AuthorizedAwsRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAccountId sets the AuthorizedAccountId field's value.
func (s *PutAggregationAuthorizationInput) SetAuthorizedAccountId(v string) *PutAggregationAuthorizationInput {
	s.AuthorizedAccountId = &v
	return s
}

// SetAuthorizedAwsRegion sets the AuthorizedAwsRegion field's value.
func (s *PutAggregationAuthorizationInput) SetAuthorizedAwsRegion(v string) *PutAggregationAuthorizationInput {
	s.AuthorizedAwsRegion = &v
	return s
}

type PutAggregationAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Returns an AggregationAuthorization object.
	AggregationAuthorization *AggregationAuthorization `type:"structure"`
}

// String returns the string representation
func (s PutAggregationAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAggregationAuthorizationOutput) GoString() string {
	return s.String()
}

// SetAggregationAuthorization sets the AggregationAuthorization field's value.
func (s *PutAggregationAuthorizationOutput) SetAggregationAuthorization(v *AggregationAuthorization) *PutAggregationAuthorizationOutput {
	s.AggregationAuthorization = v
	return s
}

type PutConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule that you want to add to your account.
	//
	// ConfigRule is a required field
	ConfigRule *ConfigRule `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigRuleInput"}
	if s.ConfigRule == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigRule"))
	}
	if s.ConfigRule != nil {
		if err := s.ConfigRule.Validate(); err != nil {
			invalidParams.AddNested("ConfigRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRule sets the ConfigRule field's value.
func (s *PutConfigRuleInput) SetConfigRule(v *ConfigRule) *PutConfigRuleInput {
	s.ConfigRule = v
	return s
}

type PutConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigRuleOutput) GoString() string {
	return s.String()
}

type PutConfigurationAggregatorInput struct {
	_ struct{} `type:"structure"`

	// A list of AccountAggregationSource object.
	AccountAggregationSources []*AccountAggregationSource `type:"list"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// An OrganizationAggregationSource object.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationAggregatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationAggregatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationAggregatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationAggregatorInput"}
	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.AccountAggregationSources != nil {
		for i, v := range s.AccountAggregationSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccountAggregationSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OrganizationAggregationSource != nil {
		if err := s.OrganizationAggregationSource.Validate(); err != nil {
			invalidParams.AddNested("OrganizationAggregationSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAggregationSources sets the AccountAggregationSources field's value.
func (s *PutConfigurationAggregatorInput) SetAccountAggregationSources(v []*AccountAggregationSource) *PutConfigurationAggregatorInput {
	s.AccountAggregationSources = v
	return s
}

// SetConfigurationAggregatorName sets the ConfigurationAggregatorName field's value.
func (s *PutConfigurationAggregatorInput) SetConfigurationAggregatorName(v string) *PutConfigurationAggregatorInput {
	s.ConfigurationAggregatorName = &v
	return s
}

// SetOrganizationAggregationSource sets the OrganizationAggregationSource field's value.
func (s *PutConfigurationAggregatorInput) SetOrganizationAggregationSource(v *OrganizationAggregationSource) *PutConfigurationAggregatorInput {
	s.OrganizationAggregationSource = v
	return s
}

type PutConfigurationAggregatorOutput struct {
	_ struct{} `type:"structure"`

	// Returns a ConfigurationAggregator object.
	ConfigurationAggregator *ConfigurationAggregator `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationAggregatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationAggregatorOutput) GoString() string {
	return s.String()
}

// SetConfigurationAggregator sets the ConfigurationAggregator field's value.
func (s *PutConfigurationAggregatorOutput) SetConfigurationAggregator(v *ConfigurationAggregator) *PutConfigurationAggregatorOutput {
	s.ConfigurationAggregator = v
	return s
}

// The input for the PutConfigurationRecorder action.
type PutConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The configuration recorder object that records each configuration change
	// made to the resources.
	//
	// ConfigurationRecorder is a required field
	ConfigurationRecorder *ConfigurationRecorder `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfigurationRecorderInput"}
	if s.ConfigurationRecorder == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorder"))
	}
	if s.ConfigurationRecorder != nil {
		if err := s.ConfigurationRecorder.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationRecorder", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorder sets the ConfigurationRecorder field's value.
func (s *PutConfigurationRecorderInput) SetConfigurationRecorder(v *ConfigurationRecorder) *PutConfigurationRecorderInput {
	s.ConfigurationRecorder = v
	return s
}

type PutConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutConfigurationRecorderOutput) GoString() string {
	return s.String()
}

// The input for the PutDeliveryChannel action.
type PutDeliveryChannelInput struct {
	_ struct{} `type:"structure"`

	// The configuration delivery channel object that delivers the configuration
	// information to an Amazon S3 bucket and to an Amazon SNS topic.
	//
	// DeliveryChannel is a required field
	DeliveryChannel *DeliveryChannel `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutDeliveryChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliveryChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDeliveryChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDeliveryChannelInput"}
	if s.DeliveryChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryChannel"))
	}
	if s.DeliveryChannel != nil {
		if err := s.DeliveryChannel.Validate(); err != nil {
			invalidParams.AddNested("DeliveryChannel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryChannel sets the DeliveryChannel field's value.
func (s *PutDeliveryChannelInput) SetDeliveryChannel(v *DeliveryChannel) *PutDeliveryChannelInput {
	s.DeliveryChannel = v
	return s
}

type PutDeliveryChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDeliveryChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDeliveryChannelOutput) GoString() string {
	return s.String()
}

type PutEvaluationsInput struct {
	_ struct{} `type:"structure"`

	// The assessments that the AWS Lambda function performs. Each evaluation identifies
	// an AWS resource and indicates whether it complies with the AWS Config rule
	// that invokes the AWS Lambda function.
	Evaluations []*Evaluation `type:"list"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// Identifies the rule and the event that triggered the evaluation.
	//
	// ResultToken is a required field
	ResultToken *string `type:"string" required:"true"`

	// Use this parameter to specify a test run for PutEvaluations. You can verify
	// whether your AWS Lambda function will deliver evaluation results to AWS Config.
	// No updates occur to your existing evaluations, and evaluation results are
	// not sent to AWS Config.
	//
	// When TestMode is true, PutEvaluations doesn't require a valid value for the
	// ResultToken parameter, but the value cannot be null.
	TestMode *bool `type:"boolean"`
}

// String returns the string representation
func (s PutEvaluationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEvaluationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEvaluationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEvaluationsInput"}
	if s.ResultToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultToken"))
	}
	if s.Evaluations != nil {
		for i, v := range s.Evaluations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Evaluations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluations sets the Evaluations field's value.
func (s *PutEvaluationsInput) SetEvaluations(v []*Evaluation) *PutEvaluationsInput {
	s.Evaluations = v
	return s
}

// SetResultToken sets the ResultToken field's value.
func (s *PutEvaluationsInput) SetResultToken(v string) *PutEvaluationsInput {
	s.ResultToken = &v
	return s
}

// SetTestMode sets the TestMode field's value.
func (s *PutEvaluationsInput) SetTestMode(v bool) *PutEvaluationsInput {
	s.TestMode = &v
	return s
}

type PutEvaluationsOutput struct {
	_ struct{} `type:"structure"`

	// Requests that failed because of a client or server error.
	FailedEvaluations []*Evaluation `type:"list"`
}

// String returns the string representation
func (s PutEvaluationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEvaluationsOutput) GoString() string {
	return s.String()
}

// SetFailedEvaluations sets the FailedEvaluations field's value.
func (s *PutEvaluationsOutput) SetFailedEvaluations(v []*Evaluation) *PutEvaluationsOutput {
	s.FailedEvaluations = v
	return s
}

type PutRetentionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s PutRetentionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRetentionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRetentionConfigurationInput"}
	if s.RetentionPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodInDays"))
	}
	if s.RetentionPeriodInDays != nil && *s.RetentionPeriodInDays < 30 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriodInDays", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodInDays sets the RetentionPeriodInDays field's value.
func (s *PutRetentionConfigurationInput) SetRetentionPeriodInDays(v int64) *PutRetentionConfigurationInput {
	s.RetentionPeriodInDays = &v
	return s
}

type PutRetentionConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns a retention configuration object.
	RetentionConfiguration *RetentionConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutRetentionConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRetentionConfigurationOutput) GoString() string {
	return s.String()
}

// SetRetentionConfiguration sets the RetentionConfiguration field's value.
func (s *PutRetentionConfigurationOutput) SetRetentionConfiguration(v *RetentionConfiguration) *PutRetentionConfigurationOutput {
	s.RetentionConfiguration = v
	return s
}

// Specifies the types of AWS resource for which AWS Config records configuration
// changes.
//
// In the recording group, you specify whether all supported types or specific
// types of resources are recorded.
//
// By default, AWS Config records configuration changes for all supported types
// of regional resources that AWS Config discovers in the region in which it
// is running. Regional resources are tied to a region and can be used only
// in that region. Examples of regional resources are EC2 instances and EBS
// volumes.
//
// You can also have AWS Config record configuration changes for supported types
// of global resources (for example, IAM resources). Global resources are not
// tied to an individual region and can be used in all regions.
//
// The configuration details for any global resource are the same in all regions.
// If you customize AWS Config in multiple regions to record global resources,
// it will create multiple configuration items each time a global resource changes:
// one configuration item for each region. These configuration items will contain
// identical data. To prevent duplicate configuration items, you should consider
// customizing AWS Config in only one region to record global resources, unless
// you want the configuration items to be available in multiple regions.
//
// If you don't want AWS Config to record all resources, you can specify which
// types of resources it will record with the resourceTypes parameter.
//
// For a list of supported resource types, see Supported Resource Types (http://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
//
// For more information, see Selecting Which Resources AWS Config Records (http://docs.aws.amazon.com/config/latest/developerguide/select-resources.html).
type RecordingGroup struct {
	_ struct{} `type:"structure"`

	// Specifies whether AWS Config records configuration changes for every supported
	// type of regional resource.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of regional resource, it starts recording resources of that type automatically.
	//
	// If you set this option to true, you cannot enumerate a list of resourceTypes.
	AllSupported *bool `locationName:"allSupported" type:"boolean"`

	// Specifies whether AWS Config includes all supported types of global resources
	// (for example, IAM resources) with the resources that it records.
	//
	// Before you can set this option to true, you must set the allSupported option
	// to true.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of global resource, it starts recording resources of that type automatically.
	//
	// The configuration details for any global resource are the same in all regions.
	// To prevent duplicate configuration items, you should consider customizing
	// AWS Config in only one region to record global resources.
	IncludeGlobalResourceTypes *bool `locationName:"includeGlobalResourceTypes" type:"boolean"`

	// A comma-separated list that specifies the types of AWS resources for which
	// AWS Config records configuration changes (for example, AWS::EC2::Instance
	// or AWS::CloudTrail::Trail).
	//
	// Before you can set this option to true, you must set the allSupported option
	// to false.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of resource, it will not record resources of that type unless you manually
	// add that type to your recording group.
	//
	// For a list of valid resourceTypes values, see the resourceType Value column
	// in Supported AWS Resource Types (http://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
	ResourceTypes []*string `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s RecordingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordingGroup) GoString() string {
	return s.String()
}

// SetAllSupported sets the AllSupported field's value.
func (s *RecordingGroup) SetAllSupported(v bool) *RecordingGroup {
	s.AllSupported = &v
	return s
}

// SetIncludeGlobalResourceTypes sets the IncludeGlobalResourceTypes field's value.
func (s *RecordingGroup) SetIncludeGlobalResourceTypes(v bool) *RecordingGroup {
	s.IncludeGlobalResourceTypes = &v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *RecordingGroup) SetResourceTypes(v []*string) *RecordingGroup {
	s.ResourceTypes = v
	return s
}

// The relationship of the related resource to the main resource.
type Relationship struct {
	_ struct{} `type:"structure"`

	// The type of relationship with the related resource.
	RelationshipName *string `locationName:"relationshipName" type:"string"`

	// The ID of the related resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the related resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type of the related resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Relationship) GoString() string {
	return s.String()
}

// SetRelationshipName sets the RelationshipName field's value.
func (s *Relationship) SetRelationshipName(v string) *Relationship {
	s.RelationshipName = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Relationship) SetResourceId(v string) *Relationship {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *Relationship) SetResourceName(v string) *Relationship {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Relationship) SetResourceType(v string) *Relationship {
	s.ResourceType = &v
	return s
}

// An object that contains the resource type and the number of resources.
type ResourceCount struct {
	_ struct{} `type:"structure"`

	// The number of resources.
	Count *int64 `locationName:"count" type:"long"`

	// The resource type (for example, "AWS::EC2::Instance").
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCount) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ResourceCount) SetCount(v int64) *ResourceCount {
	s.Count = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceCount) SetResourceType(v string) *ResourceCount {
	s.ResourceType = &v
	return s
}

// The details that identify a resource that is discovered by AWS Config, including
// the resource type, ID, and (if available) the custom resource name.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The time that the resource was deleted.
	ResourceDeletionTime *time.Time `locationName:"resourceDeletionTime" type:"timestamp"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource (if available).
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resource.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceIdentifier) GoString() string {
	return s.String()
}

// SetResourceDeletionTime sets the ResourceDeletionTime field's value.
func (s *ResourceIdentifier) SetResourceDeletionTime(v time.Time) *ResourceIdentifier {
	s.ResourceDeletionTime = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceIdentifier) SetResourceId(v string) *ResourceIdentifier {
	s.ResourceId = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ResourceIdentifier) SetResourceName(v string) *ResourceIdentifier {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifier) SetResourceType(v string) *ResourceIdentifier {
	s.ResourceType = &v
	return s
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
type ResourceKey struct {
	_ struct{} `type:"structure"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s ResourceKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceKey"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceKey) SetResourceId(v string) *ResourceKey {
	s.ResourceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceKey) SetResourceType(v string) *ResourceKey {
	s.ResourceType = &v
	return s
}

// An object with the name of the retention configuration and the retention
// period in days. The object stores the configuration for data retention in
// AWS Config.
type RetentionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration object.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s RetentionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetentionConfiguration) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RetentionConfiguration) SetName(v string) *RetentionConfiguration {
	s.Name = &v
	return s
}

// SetRetentionPeriodInDays sets the RetentionPeriodInDays field's value.
func (s *RetentionConfiguration) SetRetentionPeriodInDays(v int64) *RetentionConfiguration {
	s.RetentionPeriodInDays = &v
	return s
}

// Defines which resources trigger an evaluation for an AWS Config rule. The
// scope can include one or more resource types, a combination of a tag key
// and value, or a combination of one resource type and one resource ID. Specify
// a scope to constrain which resources trigger an evaluation for a rule. Otherwise,
// evaluations for the rule are triggered when any resource in your recording
// group changes in configuration.
type Scope struct {
	_ struct{} `type:"structure"`

	// The ID of the only AWS resource that you want to trigger an evaluation for
	// the rule. If you specify a resource ID, you must specify one resource type
	// for ComplianceResourceTypes.
	ComplianceResourceId *string `min:"1" type:"string"`

	// The resource types of only those AWS resources that you want to trigger an
	// evaluation for the rule. You can only specify one type if you also specify
	// a resource ID for ComplianceResourceId.
	ComplianceResourceTypes []*string `type:"list"`

	// The tag key that is applied to only those AWS resources that you want to
	// trigger an evaluation for the rule.
	TagKey *string `min:"1" type:"string"`

	// The tag value applied to only those AWS resources that you want to trigger
	// an evaluation for the rule. If you specify a value for TagValue, you must
	// also specify a value for TagKey.
	TagValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Scope) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scope) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Scope"}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue != nil && len(*s.TagValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceResourceId sets the ComplianceResourceId field's value.
func (s *Scope) SetComplianceResourceId(v string) *Scope {
	s.ComplianceResourceId = &v
	return s
}

// SetComplianceResourceTypes sets the ComplianceResourceTypes field's value.
func (s *Scope) SetComplianceResourceTypes(v []*string) *Scope {
	s.ComplianceResourceTypes = v
	return s
}

// SetTagKey sets the TagKey field's value.
func (s *Scope) SetTagKey(v string) *Scope {
	s.TagKey = &v
	return s
}

// SetTagValue sets the TagValue field's value.
func (s *Scope) SetTagValue(v string) *Scope {
	s.TagValue = &v
	return s
}

// Provides the AWS Config rule owner (AWS or customer), the rule identifier,
// and the events that trigger the evaluation of your AWS resources.
type Source struct {
	_ struct{} `type:"structure"`

	// Indicates whether AWS or the customer owns and manages the AWS Config rule.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true" enum:"Owner"`

	// Provides the source and type of the event that causes AWS Config to evaluate
	// your AWS resources.
	SourceDetails []*SourceDetail `type:"list"`

	// For AWS Config managed rules, a predefined identifier from a list. For example,
	// IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see Using
	// AWS Managed Config Rules (http://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	//
	// For custom rules, the identifier is the Amazon Resource Name (ARN) of the
	// rule's AWS Lambda function, such as arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Source"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}
	if s.SourceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SourceIdentifier != nil && len(*s.SourceIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwner sets the Owner field's value.
func (s *Source) SetOwner(v string) *Source {
	s.Owner = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *Source) SetSourceDetails(v []*SourceDetail) *Source {
	s.SourceDetails = v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Source) SetSourceIdentifier(v string) *Source {
	s.SourceIdentifier = &v
	return s
}

// Provides the source and the message types that trigger AWS Config to evaluate
// your AWS resources against a rule. It also provides the frequency with which
// you want AWS Config to run evaluations for the rule if the trigger type is
// periodic. You can specify the parameter values for SourceDetail only for
// custom rules.
type SourceDetail struct {
	_ struct{} `type:"structure"`

	// The source of the event, such as an AWS service, that triggers AWS Config
	// to evaluate your AWS resources.
	EventSource *string `type:"string" enum:"EventSource"`

	// The frequency at which you want AWS Config to run evaluations for a custom
	// rule with a periodic trigger. If you specify a value for MaximumExecutionFrequency,
	// then MessageType must use the ScheduledNotification value.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	//
	// Based on the valid value you choose, AWS Config runs evaluations once for
	// each valid value. For example, if you choose Three_Hours, AWS Config runs
	// evaluations once every three hours. In this case, Three_Hours is the frequency
	// of this rule.
	MaximumExecutionFrequency *string `type:"string" enum:"MaximumExecutionFrequency"`

	// The type of notification that triggers AWS Config to run an evaluation for
	// a rule. You can specify the following notification types:
	//
	//    * ConfigurationItemChangeNotification - Triggers an evaluation when AWS
	//    Config delivers a configuration item as a result of a resource change.
	//
	//    * OversizedConfigurationItemChangeNotification - Triggers an evaluation
	//    when AWS Config delivers an oversized configuration item. AWS Config may
	//    generate this notification type when a resource changes and the notification
	//    exceeds the maximum size allowed by Amazon SNS.
	//
	//    * ScheduledNotification - Triggers a periodic evaluation at the frequency
	//    specified for MaximumExecutionFrequency.
	//
	//    * ConfigurationSnapshotDeliveryCompleted - Triggers a periodic evaluation
	//    when AWS Config delivers a configuration snapshot.
	//
	// If you want your custom rule to be triggered by configuration changes, specify
	// two SourceDetail objects, one for ConfigurationItemChangeNotification and
	// one for OversizedConfigurationItemChangeNotification.
	MessageType *string `type:"string" enum:"MessageType"`
}

// String returns the string representation
func (s SourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceDetail) GoString() string {
	return s.String()
}

// SetEventSource sets the EventSource field's value.
func (s *SourceDetail) SetEventSource(v string) *SourceDetail {
	s.EventSource = &v
	return s
}

// SetMaximumExecutionFrequency sets the MaximumExecutionFrequency field's value.
func (s *SourceDetail) SetMaximumExecutionFrequency(v string) *SourceDetail {
	s.MaximumExecutionFrequency = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SourceDetail) SetMessageType(v string) *SourceDetail {
	s.MessageType = &v
	return s
}

type StartConfigRulesEvaluationInput struct {
	_ struct{} `type:"structure"`

	// The list of names of AWS Config rules that you want to run evaluations for.
	ConfigRuleNames []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigRulesEvaluationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConfigRulesEvaluationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartConfigRulesEvaluationInput"}
	if s.ConfigRuleNames != nil && len(s.ConfigRuleNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigRuleNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigRuleNames sets the ConfigRuleNames field's value.
func (s *StartConfigRulesEvaluationInput) SetConfigRuleNames(v []*string) *StartConfigRulesEvaluationInput {
	s.ConfigRuleNames = v
	return s
}

// The output when you start the evaluation for the specified AWS Config rule.
type StartConfigRulesEvaluationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartConfigRulesEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigRulesEvaluationOutput) GoString() string {
	return s.String()
}

// The input for the StartConfigurationRecorder action.
type StartConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the recorder object that records each configuration change made
	// to the resources.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *StartConfigurationRecorderInput) SetConfigurationRecorderName(v string) *StartConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type StartConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartConfigurationRecorderOutput) GoString() string {
	return s.String()
}

// The input for the StopConfigurationRecorder action.
type StopConfigurationRecorderInput struct {
	_ struct{} `type:"structure"`

	// The name of the recorder object that records each configuration change made
	// to the resources.
	//
	// ConfigurationRecorderName is a required field
	ConfigurationRecorderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopConfigurationRecorderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopConfigurationRecorderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopConfigurationRecorderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopConfigurationRecorderInput"}
	if s.ConfigurationRecorderName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationRecorderName"))
	}
	if s.ConfigurationRecorderName != nil && len(*s.ConfigurationRecorderName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigurationRecorderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationRecorderName sets the ConfigurationRecorderName field's value.
func (s *StopConfigurationRecorderInput) SetConfigurationRecorderName(v string) *StopConfigurationRecorderInput {
	s.ConfigurationRecorderName = &v
	return s
}

type StopConfigurationRecorderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopConfigurationRecorderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopConfigurationRecorderOutput) GoString() string {
	return s.String()
}

const (
	// AggregatedSourceStatusTypeFailed is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeFailed = "FAILED"

	// AggregatedSourceStatusTypeSucceeded is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeSucceeded = "SUCCEEDED"

	// AggregatedSourceStatusTypeOutdated is a AggregatedSourceStatusType enum value
	AggregatedSourceStatusTypeOutdated = "OUTDATED"
)

const (
	// AggregatedSourceTypeAccount is a AggregatedSourceType enum value
	AggregatedSourceTypeAccount = "ACCOUNT"

	// AggregatedSourceTypeOrganization is a AggregatedSourceType enum value
	AggregatedSourceTypeOrganization = "ORGANIZATION"
)

const (
	// ChronologicalOrderReverse is a ChronologicalOrder enum value
	ChronologicalOrderReverse = "Reverse"

	// ChronologicalOrderForward is a ChronologicalOrder enum value
	ChronologicalOrderForward = "Forward"
)

const (
	// ComplianceTypeCompliant is a ComplianceType enum value
	ComplianceTypeCompliant = "COMPLIANT"

	// ComplianceTypeNonCompliant is a ComplianceType enum value
	ComplianceTypeNonCompliant = "NON_COMPLIANT"

	// ComplianceTypeNotApplicable is a ComplianceType enum value
	ComplianceTypeNotApplicable = "NOT_APPLICABLE"

	// ComplianceTypeInsufficientData is a ComplianceType enum value
	ComplianceTypeInsufficientData = "INSUFFICIENT_DATA"
)

const (
	// ConfigRuleComplianceSummaryGroupKeyAccountId is a ConfigRuleComplianceSummaryGroupKey enum value
	ConfigRuleComplianceSummaryGroupKeyAccountId = "ACCOUNT_ID"

	// ConfigRuleComplianceSummaryGroupKeyAwsRegion is a ConfigRuleComplianceSummaryGroupKey enum value
	ConfigRuleComplianceSummaryGroupKeyAwsRegion = "AWS_REGION"
)

const (
	// ConfigRuleStateActive is a ConfigRuleState enum value
	ConfigRuleStateActive = "ACTIVE"

	// ConfigRuleStateDeleting is a ConfigRuleState enum value
	ConfigRuleStateDeleting = "DELETING"

	// ConfigRuleStateDeletingResults is a ConfigRuleState enum value
	ConfigRuleStateDeletingResults = "DELETING_RESULTS"

	// ConfigRuleStateEvaluating is a ConfigRuleState enum value
	ConfigRuleStateEvaluating = "EVALUATING"
)

const (
	// ConfigurationItemStatusOk is a ConfigurationItemStatus enum value
	ConfigurationItemStatusOk = "OK"

	// ConfigurationItemStatusResourceDiscovered is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDiscovered = "ResourceDiscovered"

	// ConfigurationItemStatusResourceNotRecorded is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceNotRecorded = "ResourceNotRecorded"

	// ConfigurationItemStatusResourceDeleted is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDeleted = "ResourceDeleted"

	// ConfigurationItemStatusResourceDeletedNotRecorded is a ConfigurationItemStatus enum value
	ConfigurationItemStatusResourceDeletedNotRecorded = "ResourceDeletedNotRecorded"
)

const (
	// DeliveryStatusSuccess is a DeliveryStatus enum value
	DeliveryStatusSuccess = "Success"

	// DeliveryStatusFailure is a DeliveryStatus enum value
	DeliveryStatusFailure = "Failure"

	// DeliveryStatusNotApplicable is a DeliveryStatus enum value
	DeliveryStatusNotApplicable = "Not_Applicable"
)

const (
	// EventSourceAwsConfig is a EventSource enum value
	EventSourceAwsConfig = "aws.config"
)

const (
	// MaximumExecutionFrequencyOneHour is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyOneHour = "One_Hour"

	// MaximumExecutionFrequencyThreeHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyThreeHours = "Three_Hours"

	// MaximumExecutionFrequencySixHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencySixHours = "Six_Hours"

	// MaximumExecutionFrequencyTwelveHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyTwelveHours = "Twelve_Hours"

	// MaximumExecutionFrequencyTwentyFourHours is a MaximumExecutionFrequency enum value
	MaximumExecutionFrequencyTwentyFourHours = "TwentyFour_Hours"
)

const (
	// MessageTypeConfigurationItemChangeNotification is a MessageType enum value
	MessageTypeConfigurationItemChangeNotification = "ConfigurationItemChangeNotification"

	// MessageTypeConfigurationSnapshotDeliveryCompleted is a MessageType enum value
	MessageTypeConfigurationSnapshotDeliveryCompleted = "ConfigurationSnapshotDeliveryCompleted"

	// MessageTypeScheduledNotification is a MessageType enum value
	MessageTypeScheduledNotification = "ScheduledNotification"

	// MessageTypeOversizedConfigurationItemChangeNotification is a MessageType enum value
	MessageTypeOversizedConfigurationItemChangeNotification = "OversizedConfigurationItemChangeNotification"
)

const (
	// OwnerCustomLambda is a Owner enum value
	OwnerCustomLambda = "CUSTOM_LAMBDA"

	// OwnerAws is a Owner enum value
	OwnerAws = "AWS"
)

const (
	// RecorderStatusPending is a RecorderStatus enum value
	RecorderStatusPending = "Pending"

	// RecorderStatusSuccess is a RecorderStatus enum value
	RecorderStatusSuccess = "Success"

	// RecorderStatusFailure is a RecorderStatus enum value
	RecorderStatusFailure = "Failure"
)

const (
	// ResourceTypeAwsEc2CustomerGateway is a ResourceType enum value
	ResourceTypeAwsEc2CustomerGateway = "AWS::EC2::CustomerGateway"

	// ResourceTypeAwsEc2Eip is a ResourceType enum value
	ResourceTypeAwsEc2Eip = "AWS::EC2::EIP"

	// ResourceTypeAwsEc2Host is a ResourceType enum value
	ResourceTypeAwsEc2Host = "AWS::EC2::Host"

	// ResourceTypeAwsEc2Instance is a ResourceType enum value
	ResourceTypeAwsEc2Instance = "AWS::EC2::Instance"

	// ResourceTypeAwsEc2InternetGateway is a ResourceType enum value
	ResourceTypeAwsEc2InternetGateway = "AWS::EC2::InternetGateway"

	// ResourceTypeAwsEc2NetworkAcl is a ResourceType enum value
	ResourceTypeAwsEc2NetworkAcl = "AWS::EC2::NetworkAcl"

	// ResourceTypeAwsEc2NetworkInterface is a ResourceType enum value
	ResourceTypeAwsEc2NetworkInterface = "AWS::EC2::NetworkInterface"

	// ResourceTypeAwsEc2RouteTable is a ResourceType enum value
	ResourceTypeAwsEc2RouteTable = "AWS::EC2::RouteTable"

	// ResourceTypeAwsEc2SecurityGroup is a ResourceType enum value
	ResourceTypeAwsEc2SecurityGroup = "AWS::EC2::SecurityGroup"

	// ResourceTypeAwsEc2Subnet is a ResourceType enum value
	ResourceTypeAwsEc2Subnet = "AWS::EC2::Subnet"

	// ResourceTypeAwsCloudTrailTrail is a ResourceType enum value
	ResourceTypeAwsCloudTrailTrail = "AWS::CloudTrail::Trail"

	// ResourceTypeAwsEc2Volume is a ResourceType enum value
	ResourceTypeAwsEc2Volume = "AWS::EC2::Volume"

	// ResourceTypeAwsEc2Vpc is a ResourceType enum value
	ResourceTypeAwsEc2Vpc = "AWS::EC2::VPC"

	// ResourceTypeAwsEc2Vpnconnection is a ResourceType enum value
	ResourceTypeAwsEc2Vpnconnection = "AWS::EC2::VPNConnection"

	// ResourceTypeAwsEc2Vpngateway is a ResourceType enum value
	ResourceTypeAwsEc2Vpngateway = "AWS::EC2::VPNGateway"

	// ResourceTypeAwsIamGroup is a ResourceType enum value
	ResourceTypeAwsIamGroup = "AWS::IAM::Group"

	// ResourceTypeAwsIamPolicy is a ResourceType enum value
	ResourceTypeAwsIamPolicy = "AWS::IAM::Policy"

	// ResourceTypeAwsIamRole is a ResourceType enum value
	ResourceTypeAwsIamRole = "AWS::IAM::Role"

	// ResourceTypeAwsIamUser is a ResourceType enum value
	ResourceTypeAwsIamUser = "AWS::IAM::User"

	// ResourceTypeAwsAcmCertificate is a ResourceType enum value
	ResourceTypeAwsAcmCertificate = "AWS::ACM::Certificate"

	// ResourceTypeAwsRdsDbinstance is a ResourceType enum value
	ResourceTypeAwsRdsDbinstance = "AWS::RDS::DBInstance"

	// ResourceTypeAwsRdsDbsubnetGroup is a ResourceType enum value
	ResourceTypeAwsRdsDbsubnetGroup = "AWS::RDS::DBSubnetGroup"

	// ResourceTypeAwsRdsDbsecurityGroup is a ResourceType enum value
	ResourceTypeAwsRdsDbsecurityGroup = "AWS::RDS::DBSecurityGroup"

	// ResourceTypeAwsRdsDbsnapshot is a ResourceType enum value
	ResourceTypeAwsRdsDbsnapshot = "AWS::RDS::DBSnapshot"

	// ResourceTypeAwsRdsEventSubscription is a ResourceType enum value
	ResourceTypeAwsRdsEventSubscription = "AWS::RDS::EventSubscription"

	// ResourceTypeAwsElasticLoadBalancingV2LoadBalancer is a ResourceType enum value
	ResourceTypeAwsElasticLoadBalancingV2LoadBalancer = "AWS::ElasticLoadBalancingV2::LoadBalancer"

	// ResourceTypeAwsS3Bucket is a ResourceType enum value
	ResourceTypeAwsS3Bucket = "AWS::S3::Bucket"

	// ResourceTypeAwsSsmManagedInstanceInventory is a ResourceType enum value
	ResourceTypeAwsSsmManagedInstanceInventory = "AWS::SSM::ManagedInstanceInventory"

	// ResourceTypeAwsRedshiftCluster is a ResourceType enum value
	ResourceTypeAwsRedshiftCluster = "AWS::Redshift::Cluster"

	// ResourceTypeAwsRedshiftClusterSnapshot is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSnapshot = "AWS::Redshift::ClusterSnapshot"

	// ResourceTypeAwsRedshiftClusterParameterGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterParameterGroup = "AWS::Redshift::ClusterParameterGroup"

	// ResourceTypeAwsRedshiftClusterSecurityGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSecurityGroup = "AWS::Redshift::ClusterSecurityGroup"

	// ResourceTypeAwsRedshiftClusterSubnetGroup is a ResourceType enum value
	ResourceTypeAwsRedshiftClusterSubnetGroup = "AWS::Redshift::ClusterSubnetGroup"

	// ResourceTypeAwsRedshiftEventSubscription is a ResourceType enum value
	ResourceTypeAwsRedshiftEventSubscription = "AWS::Redshift::EventSubscription"

	// ResourceTypeAwsCloudWatchAlarm is a ResourceType enum value
	ResourceTypeAwsCloudWatchAlarm = "AWS::CloudWatch::Alarm"

	// ResourceTypeAwsCloudFormationStack is a ResourceType enum value
	ResourceTypeAwsCloudFormationStack = "AWS::CloudFormation::Stack"

	// ResourceTypeAwsDynamoDbTable is a ResourceType enum value
	ResourceTypeAwsDynamoDbTable = "AWS::DynamoDB::Table"

	// ResourceTypeAwsAutoScalingAutoScalingGroup is a ResourceType enum value
	ResourceTypeAwsAutoScalingAutoScalingGroup = "AWS::AutoScaling::AutoScalingGroup"

	// ResourceTypeAwsAutoScalingLaunchConfiguration is a ResourceType enum value
	ResourceTypeAwsAutoScalingLaunchConfiguration = "AWS::AutoScaling::LaunchConfiguration"

	// ResourceTypeAwsAutoScalingScalingPolicy is a ResourceType enum value
	ResourceTypeAwsAutoScalingScalingPolicy = "AWS::AutoScaling::ScalingPolicy"

	// ResourceTypeAwsAutoScalingScheduledAction is a ResourceType enum value
	ResourceTypeAwsAutoScalingScheduledAction = "AWS::AutoScaling::ScheduledAction"

	// ResourceTypeAwsCodeBuildProject is a ResourceType enum value
	ResourceTypeAwsCodeBuildProject = "AWS::CodeBuild::Project"

	// ResourceTypeAwsWafRateBasedRule is a ResourceType enum value
	ResourceTypeAwsWafRateBasedRule = "AWS::WAF::RateBasedRule"

	// ResourceTypeAwsWafRule is a ResourceType enum value
	ResourceTypeAwsWafRule = "AWS::WAF::Rule"

	// ResourceTypeAwsWafWebAcl is a ResourceType enum value
	ResourceTypeAwsWafWebAcl = "AWS::WAF::WebACL"

	// ResourceTypeAwsWafregionalRateBasedRule is a ResourceType enum value
	ResourceTypeAwsWafregionalRateBasedRule = "AWS::WAFRegional::RateBasedRule"

	// ResourceTypeAwsWafregionalRule is a ResourceType enum value
	ResourceTypeAwsWafregionalRule = "AWS::WAFRegional::Rule"

	// ResourceTypeAwsWafregionalWebAcl is a ResourceType enum value
	ResourceTypeAwsWafregionalWebAcl = "AWS::WAFRegional::WebACL"

	// ResourceTypeAwsCloudFrontDistribution is a ResourceType enum value
	ResourceTypeAwsCloudFrontDistribution = "AWS::CloudFront::Distribution"

	// ResourceTypeAwsCloudFrontStreamingDistribution is a ResourceType enum value
	ResourceTypeAwsCloudFrontStreamingDistribution = "AWS::CloudFront::StreamingDistribution"

	// ResourceTypeAwsWafRuleGroup is a ResourceType enum value
	ResourceTypeAwsWafRuleGroup = "AWS::WAF::RuleGroup"

	// ResourceTypeAwsWafregionalRuleGroup is a ResourceType enum value
	ResourceTypeAwsWafregionalRuleGroup = "AWS::WAFRegional::RuleGroup"

	// ResourceTypeAwsLambdaFunction is a ResourceType enum value
	ResourceTypeAwsLambdaFunction = "AWS::Lambda::Function"

	// ResourceTypeAwsElasticBeanstalkApplication is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkApplication = "AWS::ElasticBeanstalk::Application"

	// ResourceTypeAwsElasticBeanstalkApplicationVersion is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkApplicationVersion = "AWS::ElasticBeanstalk::ApplicationVersion"

	// ResourceTypeAwsElasticBeanstalkEnvironment is a ResourceType enum value
	ResourceTypeAwsElasticBeanstalkEnvironment = "AWS::ElasticBeanstalk::Environment"

	// ResourceTypeAwsElasticLoadBalancingLoadBalancer is a ResourceType enum value
	ResourceTypeAwsElasticLoadBalancingLoadBalancer = "AWS::ElasticLoadBalancing::LoadBalancer"

	// ResourceTypeAwsXrayEncryptionConfig is a ResourceType enum value
	ResourceTypeAwsXrayEncryptionConfig = "AWS::XRay::EncryptionConfig"

	// ResourceTypeAwsSsmAssociationCompliance is a ResourceType enum value
	ResourceTypeAwsSsmAssociationCompliance = "AWS::SSM::AssociationCompliance"

	// ResourceTypeAwsSsmPatchCompliance is a ResourceType enum value
	ResourceTypeAwsSsmPatchCompliance = "AWS::SSM::PatchCompliance"

	// ResourceTypeAwsShieldProtection is a ResourceType enum value
	ResourceTypeAwsShieldProtection = "AWS::Shield::Protection"

	// ResourceTypeAwsShieldRegionalProtection is a ResourceType enum value
	ResourceTypeAwsShieldRegionalProtection = "AWS::ShieldRegional::Protection"

	// ResourceTypeAwsConfigResourceCompliance is a ResourceType enum value
	ResourceTypeAwsConfigResourceCompliance = "AWS::Config::ResourceCompliance"

	// ResourceTypeAwsCodePipelinePipeline is a ResourceType enum value
	ResourceTypeAwsCodePipelinePipeline = "AWS::CodePipeline::Pipeline"
)
