// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p2beta1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	7: "TEXT_DETECTION",
	9: "OBJECT_TRACKING",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"TEXT_DETECTION":             7,
	"OBJECT_TRACKING":            9,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p2beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig  *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if m != nil {
		return m.TextDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p2beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{4}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints        []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextDetectionConfig) Reset()         { *m = TextDetectionConfig{} }
func (m *TextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*TextDetectionConfig) ProtoMessage()    {}
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{5}
}

func (m *TextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextDetectionConfig.Unmarshal(m, b)
}
func (m *TextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextDetectionConfig.Marshal(b, m, deterministic)
}
func (m *TextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextDetectionConfig.Merge(m, src)
}
func (m *TextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_TextDetectionConfig.Size(m)
}
func (m *TextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TextDetectionConfig proto.InternalMessageInfo

func (m *TextDetectionConfig) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{6}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{7}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{8}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{9}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{10}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p2beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{11}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{12}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{13}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{14}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{15}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{16}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{17}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{18}
}

func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (m *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(m, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	// Normalized vertices of the bounding polygon.
	Vertices             []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{19}
}

func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(m, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames               []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *TextSegment) Reset()         { *m = TextSegment{} }
func (m *TextSegment) String() string { return proto.CompactTextString(m) }
func (*TextSegment) ProtoMessage()    {}
func (*TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{20}
}

func (m *TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSegment.Unmarshal(m, b)
}
func (m *TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSegment.Marshal(b, m, deterministic)
}
func (m *TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSegment.Merge(m, src)
}
func (m *TextSegment) XXX_Size() int {
	return xxx_messageInfo_TextSegment.Size(m)
}
func (m *TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TextSegment proto.InternalMessageInfo

func (m *TextSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *TextSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *TextSegment) GetFrames() []*TextFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextFrame) Reset()         { *m = TextFrame{} }
func (m *TextFrame) String() string { return proto.CompactTextString(m) }
func (*TextFrame) ProtoMessage()    {}
func (*TextFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{21}
}

func (m *TextFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextFrame.Unmarshal(m, b)
}
func (m *TextFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextFrame.Marshal(b, m, deterministic)
}
func (m *TextFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextFrame.Merge(m, src)
}
func (m *TextFrame) XXX_Size() int {
	return xxx_messageInfo_TextFrame.Size(m)
}
func (m *TextFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_TextFrame.DiscardUnknown(m)
}

var xxx_messageInfo_TextFrame proto.InternalMessageInfo

func (m *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if m != nil {
		return m.RotatedBoundingBox
	}
	return nil
}

func (m *TextFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments             []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TextAnnotation) Reset()         { *m = TextAnnotation{} }
func (m *TextAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextAnnotation) ProtoMessage()    {}
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{22}
}

func (m *TextAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAnnotation.Unmarshal(m, b)
}
func (m *TextAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAnnotation.Marshal(b, m, deterministic)
}
func (m *TextAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAnnotation.Merge(m, src)
}
func (m *TextAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextAnnotation.Size(m)
}
func (m *TextAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextAnnotation proto.InternalMessageInfo

func (m *TextAnnotation) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextAnnotation) GetSegments() []*TextSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{23}
}

func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(m, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

func (m *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	Frames []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
	// Each object track corresponds to one video segment where it appears.
	Segment              *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ObjectTrackingAnnotation) Reset()         { *m = ObjectTrackingAnnotation{} }
func (m *ObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingAnnotation) ProtoMessage()    {}
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_890c5161889e04ed, []int{24}
}

func (m *ObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *ObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingAnnotation.Merge(m, src)
}
func (m *ObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingAnnotation.Size(m)
}
func (m *ObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingAnnotation proto.InternalMessageInfo

func (m *ObjectTrackingAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1p2beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p2beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p2beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p2beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p2beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p2beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p2beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p2beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*TextDetectionConfig)(nil), "google.cloud.videointelligence.v1p2beta1.TextDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p2beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p2beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p2beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p2beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p2beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p2beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p2beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p2beta1.NormalizedBoundingBox")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p2beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p2beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p2beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p2beta1.AnnotateVideoProgress")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.videointelligence.v1p2beta1.NormalizedVertex")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.videointelligence.v1p2beta1.NormalizedBoundingPoly")
	proto.RegisterType((*TextSegment)(nil), "google.cloud.videointelligence.v1p2beta1.TextSegment")
	proto.RegisterType((*TextFrame)(nil), "google.cloud.videointelligence.v1p2beta1.TextFrame")
	proto.RegisterType((*TextAnnotation)(nil), "google.cloud.videointelligence.v1p2beta1.TextAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.videointelligence.v1p2beta1.ObjectTrackingFrame")
	proto.RegisterType((*ObjectTrackingAnnotation)(nil), "google.cloud.videointelligence.v1p2beta1.ObjectTrackingAnnotation")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p2beta1/video_intelligence.proto", fileDescriptor_890c5161889e04ed)
}

var fileDescriptor_890c5161889e04ed = []byte{
	// 1882 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0xcb, 0x6f, 0x23, 0x49,
	0x19, 0xa7, 0xed, 0x24, 0x13, 0x7f, 0x79, 0x39, 0x95, 0x97, 0x13, 0x76, 0x32, 0xa1, 0x97, 0x95,
	0xc2, 0x80, 0x6c, 0x92, 0x85, 0x15, 0x3b, 0xfb, 0x60, 0x6d, 0xa7, 0x33, 0x31, 0x93, 0xb1, 0x4d,
	0xc5, 0x89, 0x76, 0x60, 0x50, 0xab, 0xd3, 0x5d, 0xe9, 0x34, 0xd3, 0xee, 0xea, 0xe9, 0x2e, 0x67,
	0x13, 0x4e, 0x2b, 0xc4, 0x01, 0x89, 0xe3, 0x0a, 0x09, 0x89, 0xff, 0x00, 0x89, 0x0b, 0x57, 0x0e,
	0x5c, 0xb8, 0xb0, 0xe2, 0xc6, 0x09, 0x89, 0x23, 0x07, 0x24, 0xfe, 0x09, 0xd4, 0x55, 0xd5, 0xed,
	0xb6, 0x3b, 0x99, 0xd8, 0xc9, 0x4a, 0xdc, 0xba, 0xbe, 0xaf, 0xea, 0xf7, 0x3d, 0xea, 0x7b, 0x75,
	0x41, 0xd5, 0xa6, 0xd4, 0x76, 0x49, 0xc5, 0x74, 0x69, 0xcf, 0xaa, 0x5c, 0x38, 0x16, 0xa1, 0x8e,
	0xc7, 0x88, 0xeb, 0x3a, 0x36, 0xf1, 0x4c, 0x52, 0xb9, 0xd8, 0xf1, 0x77, 0x4f, 0x09, 0x33, 0x76,
	0x04, 0x4f, 0x4f, 0x33, 0xcb, 0x7e, 0x40, 0x19, 0x45, 0xdb, 0x02, 0xa2, 0xcc, 0x21, 0xca, 0x19,
	0x88, 0x72, 0x02, 0xb1, 0xf1, 0x96, 0x14, 0x66, 0xf8, 0x4e, 0xc5, 0xf0, 0x3c, 0xca, 0x0c, 0xe6,
	0x50, 0x2f, 0x14, 0x38, 0x1b, 0x6f, 0x4b, 0xae, 0x4b, 0x3d, 0x3b, 0xe8, 0x79, 0x9e, 0xe3, 0xd9,
	0x15, 0xea, 0x93, 0x60, 0x60, 0xd3, 0xa6, 0xdc, 0xc4, 0x57, 0xa7, 0xbd, 0xb3, 0x8a, 0xd5, 0x13,
	0x1b, 0x24, 0xff, 0xd1, 0x30, 0x9f, 0x39, 0x5d, 0x12, 0x32, 0xa3, 0xeb, 0xcb, 0x0d, 0x6b, 0x72,
	0x43, 0xe0, 0x9b, 0x95, 0x90, 0x19, 0xac, 0x27, 0x91, 0xd5, 0xbf, 0xe6, 0x60, 0xb9, 0x2a, 0x94,
	0x22, 0x27, 0x91, 0x11, 0x98, 0xbc, 0xee, 0x91, 0x90, 0xa1, 0xaf, 0x43, 0xc1, 0xf1, 0xfc, 0x1e,
	0xd3, 0x7b, 0x81, 0x53, 0x52, 0xb6, 0x94, 0xed, 0x02, 0x9e, 0xe6, 0x84, 0xe3, 0xc0, 0x41, 0x6f,
	0xc3, 0x9c, 0x60, 0x9a, 0xd4, 0x63, 0xc4, 0x63, 0xa5, 0xa9, 0x2d, 0x65, 0x7b, 0x16, 0xcf, 0x72,
	0x62, 0x5d, 0xd0, 0xd0, 0x73, 0x98, 0x3e, 0x23, 0x06, 0xeb, 0x05, 0x24, 0x2c, 0xe5, 0xb6, 0xf2,
	0xdb, 0xf3, 0xbb, 0x3b, 0xe5, 0x51, 0x9d, 0x56, 0xde, 0x17, 0x27, 0x71, 0x02, 0x81, 0x7e, 0x0a,
	0x73, 0xe2, 0x32, 0xb8, 0xcc, 0x4b, 0x56, 0xca, 0x6f, 0x29, 0xdb, 0x33, 0xbb, 0xef, 0x8d, 0x8e,
	0xc9, 0xed, 0xab, 0x8b, 0xd3, 0x78, 0xf6, 0x22, 0xb5, 0x42, 0x0f, 0x01, 0x68, 0x8f, 0xc5, 0xe6,
	0x4e, 0x70, 0x73, 0x0b, 0x82, 0x12, 0xd9, 0xfb, 0x08, 0x66, 0x5c, 0x6a, 0x72, 0x8f, 0xeb, 0x8e,
	0x55, 0x9a, 0xe4, 0x7c, 0x88, 0x49, 0x0d, 0x4b, 0xfd, 0xcf, 0x04, 0xcc, 0xa6, 0xe1, 0x11, 0x86,
	0xe9, 0x90, 0xd8, 0x5d, 0xe2, 0xb1, 0xb0, 0xa4, 0x6c, 0xe5, 0xef, 0xa0, 0xe8, 0x91, 0x38, 0x8e,
	0x13, 0x1c, 0xc4, 0x60, 0xd5, 0x35, 0x4e, 0x89, 0xab, 0x5b, 0x84, 0x11, 0x93, 0x2b, 0x63, 0x52,
	0xef, 0xcc, 0xb1, 0x4b, 0x39, 0xee, 0x8a, 0x8f, 0x47, 0x97, 0x70, 0x18, 0xe1, 0xec, 0xc5, 0x30,
	0x75, 0x8e, 0x82, 0x97, 0xdd, 0x6b, 0xa8, 0xe8, 0x57, 0x0a, 0xbc, 0x15, 0x9e, 0x53, 0xa6, 0x9b,
	0xe7, 0x86, 0x67, 0x93, 0xac, 0x70, 0x71, 0x0f, 0xf5, 0xd1, 0x85, 0x1f, 0x9d, 0x53, 0x56, 0xe7,
	0x60, 0xc3, 0x1a, 0xac, 0x87, 0x37, 0xb1, 0xd0, 0x17, 0x0a, 0x7c, 0x83, 0x5c, 0xfa, 0xae, 0x63,
	0x3a, 0x49, 0xd8, 0x65, 0x75, 0x99, 0xe0, 0xba, 0x1c, 0x8c, 0xae, 0x8b, 0x26, 0x21, 0x65, 0xd0,
	0x0e, 0x2b, 0xb4, 0x49, 0xde, 0xc8, 0x47, 0xaf, 0x61, 0x25, 0xba, 0xee, 0xac, 0x22, 0xd3, 0x5c,
	0x91, 0x8f, 0x46, 0x57, 0xa4, 0x43, 0x2e, 0x33, 0xd2, 0x97, 0x58, 0x96, 0xa8, 0xfe, 0x4d, 0x81,
	0xe5, 0xeb, 0xae, 0x0f, 0x79, 0xb0, 0x3c, 0x1c, 0x1e, 0x5d, 0x6a, 0x11, 0x9e, 0xbc, 0xf3, 0xbb,
	0x1f, 0xde, 0x35, 0x38, 0x9e, 0x53, 0x8b, 0x60, 0xe4, 0x66, 0x68, 0xe8, 0xdb, 0xb0, 0x18, 0x8a,
	0x5a, 0x66, 0x04, 0x57, 0xba, 0x69, 0x74, 0x49, 0x60, 0xf0, 0x48, 0x9c, 0xc6, 0xc5, 0x3e, 0xa3,
	0xce, 0xe9, 0x68, 0x19, 0x26, 0x23, 0x65, 0x5c, 0x1e, 0x2d, 0x05, 0x2c, 0x16, 0xea, 0x0e, 0xac,
	0xdf, 0x18, 0x0c, 0xfd, 0x23, 0x4a, 0xfa, 0xc8, 0x7b, 0xb0, 0xf9, 0xe6, 0x3b, 0xbb, 0xe1, 0xdc,
	0x87, 0xb0, 0x74, 0x8d, 0x8b, 0xd1, 0x3b, 0x30, 0xef, 0x1a, 0x9e, 0xdd, 0x33, 0x6c, 0xa2, 0x9f,
	0x3b, 0x71, 0xb6, 0x16, 0xf0, 0x5c, 0x4c, 0x3d, 0x88, 0x88, 0xea, 0xef, 0x14, 0x99, 0xdf, 0x32,
	0x2b, 0x91, 0xc6, 0x8d, 0x0f, 0x98, 0x1e, 0x55, 0x5a, 0x9d, 0x9e, 0x9d, 0x85, 0x84, 0x71, 0x81,
	0x33, 0xbb, 0xeb, 0xb1, 0xa7, 0xe3, 0x6a, 0x5c, 0xde, 0x93, 0xd5, 0x1a, 0x2f, 0xf0, 0x33, 0x1d,
	0xa7, 0x4b, 0x5a, 0xfc, 0x04, 0xaa, 0xc2, 0x02, 0xf1, 0xac, 0x01, 0x90, 0xdc, 0x6d, 0x20, 0x73,
	0xc4, 0xb3, 0xfa, 0x10, 0xea, 0xe7, 0x0a, 0xcc, 0xf2, 0x1b, 0x8b, 0x55, 0x6b, 0xc3, 0x03, 0x59,
	0x32, 0xa4, 0x42, 0x77, 0xad, 0x3c, 0x31, 0x0c, 0xda, 0x04, 0xe0, 0x61, 0x6d, 0x45, 0xbb, 0xb9,
	0x82, 0x39, 0x9c, 0xa2, 0xa8, 0xe7, 0x00, 0x5c, 0x83, 0xfd, 0xc0, 0xe8, 0x12, 0xf4, 0x04, 0x66,
	0xc6, 0x72, 0x0a, 0xb0, 0xbe, 0x3f, 0x6e, 0x93, 0xe4, 0xc2, 0x94, 0xe6, 0x31, 0x87, 0x5d, 0x45,
	0xfd, 0x89, 0xf0, 0xaf, 0xa8, 0x20, 0xcb, 0xfe, 0x24, 0x08, 0x0d, 0x0b, 0x6d, 0xc1, 0x8c, 0x45,
	0x42, 0x33, 0x70, 0xfc, 0x48, 0x02, 0xc7, 0x29, 0xe0, 0x34, 0x29, 0xea, 0x60, 0xc9, 0xbd, 0x9b,
	0x51, 0x96, 0x88, 0xb8, 0x9c, 0x8d, 0x89, 0x75, 0x6a, 0x11, 0xf5, 0x5f, 0x39, 0x58, 0xe0, 0x86,
	0x55, 0x93, 0xb6, 0x8d, 0x0e, 0x60, 0x4a, 0x88, 0x91, 0x86, 0x7d, 0x77, 0x8c, 0x5a, 0xc3, 0xcf,
	0x61, 0x79, 0x1e, 0xfd, 0x0c, 0x16, 0x4d, 0x83, 0x11, 0x9b, 0x06, 0x57, 0x3a, 0x27, 0x39, 0xb2,
	0x51, 0xde, 0x05, 0xb4, 0x18, 0x43, 0x69, 0x12, 0x69, 0xa0, 0x03, 0xe5, 0xc7, 0xed, 0x40, 0xe9,
	0x80, 0x4a, 0x75, 0xa0, 0x43, 0x98, 0x3a, 0x8b, 0xee, 0x38, 0x2c, 0x4d, 0x70, 0xc4, 0xef, 0x8d,
	0x89, 0xc8, 0x03, 0x04, 0x4b, 0x0c, 0xf5, 0x2f, 0x0a, 0x2c, 0x0f, 0xe5, 0xf2, 0xfd, 0x23, 0xe8,
	0x15, 0xac, 0xfa, 0x34, 0xf0, 0xa8, 0x1d, 0x18, 0xfe, 0xf9, 0x95, 0xee, 0x3a, 0xaf, 0x88, 0xeb,
	0x9c, 0x53, 0x6a, 0xf1, 0x28, 0x98, 0x1f, 0x4b, 0xe5, 0xe4, 0x2c, 0x5e, 0x49, 0x61, 0xf6, 0xc9,
	0x6a, 0x08, 0xeb, 0x43, 0x06, 0xa4, 0x22, 0xe5, 0x24, 0x71, 0x96, 0x18, 0x00, 0x3e, 0xbe, 0x73,
	0x57, 0x1a, 0x74, 0xdb, 0x2b, 0x58, 0x69, 0xd2, 0xa0, 0x6b, 0xb8, 0xce, 0x2f, 0x88, 0x55, 0xa3,
	0x3d, 0xcf, 0x72, 0x3c, 0xbb, 0x46, 0x2f, 0x11, 0x82, 0x09, 0x97, 0x9c, 0x09, 0x7f, 0xe5, 0x30,
	0xff, 0x46, 0x45, 0xc8, 0x33, 0xea, 0xcb, 0x4c, 0x8a, 0x3e, 0xa3, 0xf2, 0x18, 0x38, 0xf6, 0xb9,
	0x98, 0x9f, 0x72, 0x58, 0x2c, 0xd0, 0x2a, 0x4c, 0x9d, 0x52, 0xc6, 0x68, 0x97, 0xb7, 0xd0, 0x1c,
	0x96, 0x2b, 0xf5, 0xbf, 0x53, 0xb0, 0xca, 0x8b, 0x42, 0xdf, 0x30, 0x4c, 0xc2, 0x9e, 0xcb, 0xc2,
	0x37, 0x4f, 0x88, 0x3d, 0x58, 0x97, 0x51, 0xa3, 0x8b, 0xa6, 0x94, 0x9a, 0x7c, 0x65, 0x90, 0xbf,
	0x3f, 0x66, 0xf0, 0xa4, 0x34, 0x58, 0x93, 0xd8, 0x43, 0xf4, 0x10, 0x51, 0x58, 0xe5, 0xb3, 0x4a,
	0x56, 0x66, 0xfe, 0xbe, 0x32, 0x97, 0x23, 0xe0, 0x8c, 0xc0, 0xd7, 0xb0, 0xc6, 0xaf, 0xe5, 0x1a,
	0x89, 0x13, 0xf7, 0x95, 0xb8, 0xc2, 0x91, 0x33, 0x22, 0x0d, 0x28, 0x72, 0x1b, 0xd3, 0xb2, 0xa6,
	0xee, 0x35, 0x62, 0x2e, 0x44, 0x78, 0x69, 0x11, 0x0c, 0x96, 0x92, 0x59, 0xab, 0x2f, 0xa6, 0xf4,
	0x60, 0xdc, 0x49, 0xef, 0xc6, 0xe4, 0xc0, 0x28, 0xc6, 0x4f, 0x25, 0x8c, 0x09, 0x45, 0x3e, 0x4c,
	0xa5, 0x0d, 0x9b, 0xe5, 0x86, 0xfd, 0x60, 0xbc, 0x39, 0x2a, 0x25, 0x67, 0x81, 0x0d, 0xac, 0xa3,
	0x0b, 0x43, 0xf4, 0xf4, 0xe7, 0xc4, 0x1c, 0x14, 0x33, 0xcf, 0xc5, 0xd4, 0x46, 0x17, 0xd3, 0xe2,
	0x18, 0x9d, 0xc0, 0x30, 0x5f, 0x39, 0x9e, 0x9d, 0x12, 0xb8, 0x28, 0xd0, 0xd3, 0x22, 0xb7, 0x61,
	0x92, 0x04, 0x01, 0x0d, 0x4a, 0x05, 0xee, 0x3f, 0x14, 0x4b, 0x09, 0x7c, 0xb3, 0x7c, 0xc4, 0x7f,
	0xc6, 0xb0, 0xd8, 0xa0, 0xfe, 0x5a, 0x81, 0x95, 0xa1, 0xbf, 0xb1, 0xd0, 0xa7, 0x5e, 0x48, 0x10,
	0x05, 0xd4, 0xd7, 0x57, 0x0f, 0x44, 0x0a, 0xca, 0xc2, 0xf2, 0xc9, 0x98, 0xd7, 0x9e, 0x49, 0x65,
	0xbc, 0x68, 0x0c, 0x93, 0xd4, 0x7f, 0x2a, 0xb0, 0x36, 0xb4, 0xbb, 0x1d, 0x50, 0x3b, 0x20, 0xe1,
	0x2d, 0x99, 0xff, 0x2d, 0x28, 0xfa, 0x72, 0xa3, 0xee, 0x93, 0xc0, 0x8c, 0xe6, 0x90, 0xa8, 0xfc,
	0x4c, 0xe2, 0x85, 0x98, 0xde, 0x16, 0x64, 0xf4, 0x3e, 0x40, 0x7f, 0x88, 0x92, 0xff, 0x11, 0x1b,
	0x99, 0x32, 0xdf, 0x89, 0xff, 0x65, 0x71, 0x21, 0x19, 0x9f, 0xd0, 0x07, 0x30, 0xd3, 0xf3, 0x2d,
	0x83, 0x11, 0x71, 0x76, 0xe2, 0xd6, 0xb3, 0x20, 0xb6, 0x47, 0x04, 0xf5, 0x37, 0xc3, 0x6e, 0x4e,
	0x2c, 0x0b, 0x60, 0x29, 0xe5, 0xe6, 0x58, 0x5f, 0xe9, 0xe7, 0xea, 0x9d, 0xfd, 0x1c, 0xe3, 0xe3,
	0xd4, 0x25, 0xc6, 0x34, 0xb5, 0x0c, 0xc5, 0x7e, 0x3d, 0x3f, 0x21, 0x01, 0x23, 0x97, 0x68, 0x16,
	0x94, 0x4b, 0x59, 0xc7, 0x15, 0xbe, 0xba, 0x92, 0x25, 0x5c, 0xb9, 0x52, 0x7d, 0x58, 0xcd, 0xd6,
	0xff, 0x36, 0x75, 0xaf, 0xd0, 0x09, 0x4c, 0x5f, 0x90, 0x80, 0x39, 0x66, 0xd2, 0x73, 0x9e, 0x8c,
	0xae, 0xf2, 0xb0, 0x0e, 0x38, 0xc1, 0x52, 0xff, 0xae, 0xc0, 0x4c, 0x94, 0x57, 0xff, 0xb7, 0x09,
	0x13, 0x3d, 0x4b, 0x7a, 0xa9, 0xa8, 0xe3, 0xef, 0x8e, 0x57, 0x10, 0x06, 0x1b, 0xe8, 0x9f, 0x15,
	0x28, 0x24, 0x54, 0x14, 0xc0, 0x72, 0xc0, 0x23, 0xc1, 0xd2, 0x4f, 0xa5, 0x33, 0xf5, 0x53, 0x7a,
	0x29, 0x2d, 0xfb, 0xe4, 0x2e, 0x0e, 0x4c, 0x5f, 0x0a, 0x46, 0x12, 0x3d, 0xdd, 0xa9, 0x87, 0x06,
	0x9c, 0xdc, 0x18, 0x03, 0x8e, 0xfa, 0x19, 0xcc, 0x0f, 0xd6, 0xb8, 0xa8, 0xef, 0xf3, 0x07, 0x11,
	0x91, 0x89, 0xfc, 0x1b, 0xfd, 0x38, 0x35, 0xfd, 0x89, 0x76, 0xfb, 0xfd, 0xf1, 0x5c, 0x96, 0x19,
	0xfe, 0xd4, 0x2f, 0x15, 0x58, 0x1a, 0x2c, 0x7b, 0xc2, 0x81, 0x9f, 0xc1, 0x9a, 0x97, 0x98, 0x7e,
	0x9d, 0x0f, 0x7f, 0x78, 0x1f, 0x1f, 0xd6, 0xe8, 0x25, 0x5e, 0xf1, 0xae, 0x9d, 0x77, 0xee, 0xe3,
	0xc5, 0x3f, 0xe6, 0xa0, 0x74, 0x53, 0x0d, 0xff, 0x0a, 0x67, 0xfc, 0xc1, 0xb8, 0x9e, 0xc8, 0xc4,
	0xf5, 0x71, 0x12, 0xd7, 0xe2, 0x92, 0x3e, 0xba, 0x6b, 0x07, 0x1a, 0x88, 0xf0, 0x74, 0x82, 0xe6,
	0xbf, 0x92, 0x04, 0x7d, 0xfc, 0x7b, 0x05, 0x1e, 0xc8, 0x37, 0x39, 0xb4, 0x06, 0x4b, 0xfb, 0x5a,
	0xb5, 0x73, 0x8c, 0x35, 0xfd, 0xb8, 0x79, 0xd4, 0xd6, 0xea, 0x8d, 0xfd, 0x86, 0xb6, 0x57, 0xfc,
	0x1a, 0x5a, 0x82, 0x85, 0xc3, 0x6a, 0x4d, 0x3b, 0xd4, 0xf7, 0xb4, 0x8e, 0x56, 0xef, 0x34, 0x5a,
	0xcd, 0xa2, 0x82, 0xd6, 0x61, 0xe5, 0xe8, 0xa0, 0xd5, 0xd1, 0xeb, 0x07, 0xd5, 0xe6, 0x53, 0x2d,
	0xc5, 0xca, 0xa1, 0x4d, 0xd8, 0xd0, 0x3e, 0x6d, 0x1f, 0x36, 0xea, 0x8d, 0x8e, 0x5e, 0x6f, 0x35,
	0x3b, 0x5a, 0xb3, 0x93, 0xe2, 0xe7, 0x11, 0x82, 0xf9, 0x8e, 0xf6, 0x69, 0x9a, 0xf6, 0x20, 0x92,
	0xd1, 0xaa, 0xfd, 0x48, 0xab, 0x77, 0xf4, 0x0e, 0xae, 0xd6, 0x9f, 0x35, 0x9a, 0x4f, 0x8b, 0x85,
	0xc7, 0x01, 0xa0, 0xec, 0xa3, 0x05, 0xfa, 0x26, 0x6c, 0x0d, 0xa9, 0xa3, 0x3f, 0x6f, 0xed, 0x0d,
	0x2b, 0x3d, 0x07, 0x05, 0xae, 0x5f, 0xc4, 0x2a, 0x2a, 0x68, 0x1e, 0x60, 0x1f, 0x57, 0x9f, 0x6b,
	0x62, 0x9d, 0x8b, 0x8c, 0xe5, 0xec, 0x6a, 0x73, 0x4f, 0x4f, 0x31, 0xf2, 0x8f, 0x19, 0x40, 0xff,
	0x4f, 0x00, 0x6d, 0xc0, 0xea, 0x61, 0xe3, 0x99, 0x76, 0xd8, 0x38, 0x68, 0xb5, 0xf6, 0x86, 0x24,
	0x2c, 0xc2, 0xdc, 0x89, 0x86, 0x5f, 0xe8, 0xc7, 0x4d, 0xbe, 0xe5, 0x45, 0x51, 0x41, 0xb3, 0x30,
	0x9d, 0xac, 0x72, 0xd1, 0xaa, 0xdd, 0x3a, 0x3a, 0x6a, 0xd4, 0x0e, 0xb5, 0x62, 0x1e, 0x01, 0x4c,
	0x49, 0xce, 0x04, 0x5a, 0x80, 0x19, 0x7e, 0x54, 0x12, 0x26, 0x77, 0xff, 0xa4, 0x40, 0x89, 0xdf,
	0x50, 0x23, 0x75, 0x7b, 0x47, 0x24, 0xb8, 0x70, 0x4c, 0x82, 0x7e, 0xab, 0xc0, 0xdc, 0x40, 0x5f,
	0x43, 0x63, 0xfc, 0x73, 0x5c, 0xf7, 0x0a, 0xbc, 0xf1, 0x30, 0x3e, 0x9f, 0x7a, 0x9e, 0x2e, 0xb7,
	0xe2, 0xe7, 0x69, 0xf5, 0x9d, 0x5f, 0xfe, 0xe3, 0xdf, 0x5f, 0xe4, 0x1e, 0xa9, 0x1b, 0xc3, 0x2f,
	0xe6, 0xe1, 0x13, 0xd9, 0xe8, 0xc8, 0x13, 0xe5, 0x71, 0xed, 0xf3, 0x1c, 0x7c, 0xc7, 0xa4, 0xdd,
	0x91, 0x75, 0xa9, 0x3d, 0xbc, 0xc9, 0xc4, 0x76, 0x94, 0xd4, 0x6d, 0xe5, 0x27, 0x2f, 0x24, 0x94,
	0x4d, 0xa3, 0x1f, 0xf6, 0x32, 0x0d, 0xec, 0x8a, 0x4d, 0x3c, 0x9e, 0xf2, 0x15, 0xc1, 0x32, 0x7c,
	0x27, 0xbc, 0xfd, 0x7d, 0xff, 0x83, 0x0c, 0xef, 0x0f, 0xb9, 0xed, 0xa7, 0x02, 0xbb, 0xce, 0xd5,
	0xcc, 0x68, 0x52, 0x3e, 0xd9, 0x69, 0xef, 0xd6, 0xa2, 0xc3, 0x5f, 0xc6, 0x5b, 0x5f, 0xf2, 0xad,
	0x2f, 0x33, 0x5b, 0x5f, 0x9e, 0xc4, 0x72, 0x4e, 0xa7, 0xb8, 0x6e, 0xef, 0xfe, 0x2f, 0x00, 0x00,
	0xff, 0xff, 0x28, 0x2e, 0x0c, 0x2f, 0x7a, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p2beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p2beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p2beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p2beta1/video_intelligence.proto",
}
