// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscalingplans

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateScalingPlan = "CreateScalingPlan"

// CreateScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScalingPlan for more information on using the CreateScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScalingPlanRequest method.
//    req, resp := client.CreateScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan
func (c *AutoScalingPlans) CreateScalingPlanRequest(input *CreateScalingPlanInput) (req *request.Request, output *CreateScalingPlanOutput) {
	op := &request.Operation{
		Name:       opCreateScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScalingPlanInput{}
	}

	output = &CreateScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScalingPlan API operation for AWS Auto Scaling Plans.
//
// Creates a scaling plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation CreateScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Your account exceeded a limit. This exception is thrown when a per-account
//   resource limit is exceeded.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/CreateScalingPlan
func (c *AutoScalingPlans) CreateScalingPlan(input *CreateScalingPlanInput) (*CreateScalingPlanOutput, error) {
	req, out := c.CreateScalingPlanRequest(input)
	return out, req.Send()
}

// CreateScalingPlanWithContext is the same as CreateScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) CreateScalingPlanWithContext(ctx aws.Context, input *CreateScalingPlanInput, opts ...request.Option) (*CreateScalingPlanOutput, error) {
	req, out := c.CreateScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScalingPlan = "DeleteScalingPlan"

// DeleteScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPlan for more information on using the DeleteScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteScalingPlanRequest method.
//    req, resp := client.DeleteScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan
func (c *AutoScalingPlans) DeleteScalingPlanRequest(input *DeleteScalingPlanInput) (req *request.Request, output *DeleteScalingPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPlanInput{}
	}

	output = &DeleteScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteScalingPlan API operation for AWS Auto Scaling Plans.
//
// Deletes the specified scaling plan.
//
// Deleting a scaling plan deletes the underlying ScalingInstruction for all
// of the scalable resources that are covered by the plan.
//
// If the plan has launched resources or has scaling activities in progress,
// you must delete those resources separately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DeleteScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan
func (c *AutoScalingPlans) DeleteScalingPlan(input *DeleteScalingPlanInput) (*DeleteScalingPlanOutput, error) {
	req, out := c.DeleteScalingPlanRequest(input)
	return out, req.Send()
}

// DeleteScalingPlanWithContext is the same as DeleteScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DeleteScalingPlanWithContext(ctx aws.Context, input *DeleteScalingPlanInput, opts ...request.Option) (*DeleteScalingPlanOutput, error) {
	req, out := c.DeleteScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPlanResources = "DescribeScalingPlanResources"

// DescribeScalingPlanResourcesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPlanResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPlanResources for more information on using the DescribeScalingPlanResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPlanResourcesRequest method.
//    req, resp := client.DescribeScalingPlanResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources
func (c *AutoScalingPlans) DescribeScalingPlanResourcesRequest(input *DescribeScalingPlanResourcesInput) (req *request.Request, output *DescribeScalingPlanResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPlanResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPlanResourcesInput{}
	}

	output = &DescribeScalingPlanResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPlanResources API operation for AWS Auto Scaling Plans.
//
// Describes the scalable resources in the specified scaling plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DescribeScalingPlanResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token provided is not valid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlanResources
func (c *AutoScalingPlans) DescribeScalingPlanResources(input *DescribeScalingPlanResourcesInput) (*DescribeScalingPlanResourcesOutput, error) {
	req, out := c.DescribeScalingPlanResourcesRequest(input)
	return out, req.Send()
}

// DescribeScalingPlanResourcesWithContext is the same as DescribeScalingPlanResources with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPlanResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DescribeScalingPlanResourcesWithContext(ctx aws.Context, input *DescribeScalingPlanResourcesInput, opts ...request.Option) (*DescribeScalingPlanResourcesOutput, error) {
	req, out := c.DescribeScalingPlanResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPlans = "DescribeScalingPlans"

// DescribeScalingPlansRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPlans for more information on using the DescribeScalingPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeScalingPlansRequest method.
//    req, resp := client.DescribeScalingPlansRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans
func (c *AutoScalingPlans) DescribeScalingPlansRequest(input *DescribeScalingPlansInput) (req *request.Request, output *DescribeScalingPlansOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingPlansInput{}
	}

	output = &DescribeScalingPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPlans API operation for AWS Auto Scaling Plans.
//
// Describes one or more of your scaling plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation DescribeScalingPlans for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The token provided is not valid.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DescribeScalingPlans
func (c *AutoScalingPlans) DescribeScalingPlans(input *DescribeScalingPlansInput) (*DescribeScalingPlansOutput, error) {
	req, out := c.DescribeScalingPlansRequest(input)
	return out, req.Send()
}

// DescribeScalingPlansWithContext is the same as DescribeScalingPlans with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) DescribeScalingPlansWithContext(ctx aws.Context, input *DescribeScalingPlansInput, opts ...request.Option) (*DescribeScalingPlansOutput, error) {
	req, out := c.DescribeScalingPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetScalingPlanResourceForecastData = "GetScalingPlanResourceForecastData"

// GetScalingPlanResourceForecastDataRequest generates a "aws/request.Request" representing the
// client's request for the GetScalingPlanResourceForecastData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScalingPlanResourceForecastData for more information on using the GetScalingPlanResourceForecastData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetScalingPlanResourceForecastDataRequest method.
//    req, resp := client.GetScalingPlanResourceForecastDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData
func (c *AutoScalingPlans) GetScalingPlanResourceForecastDataRequest(input *GetScalingPlanResourceForecastDataInput) (req *request.Request, output *GetScalingPlanResourceForecastDataOutput) {
	op := &request.Operation{
		Name:       opGetScalingPlanResourceForecastData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetScalingPlanResourceForecastDataInput{}
	}

	output = &GetScalingPlanResourceForecastDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScalingPlanResourceForecastData API operation for AWS Auto Scaling Plans.
//
// Retrieves the forecast data for a scalable resource.
//
// Capacity forecasts are represented as predicted values, or data points, that
// are calculated using historical data points from a specified CloudWatch load
// metric. Data points are available for up to 56 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation GetScalingPlanResourceForecastData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/GetScalingPlanResourceForecastData
func (c *AutoScalingPlans) GetScalingPlanResourceForecastData(input *GetScalingPlanResourceForecastDataInput) (*GetScalingPlanResourceForecastDataOutput, error) {
	req, out := c.GetScalingPlanResourceForecastDataRequest(input)
	return out, req.Send()
}

// GetScalingPlanResourceForecastDataWithContext is the same as GetScalingPlanResourceForecastData with the addition of
// the ability to pass a context and additional request options.
//
// See GetScalingPlanResourceForecastData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) GetScalingPlanResourceForecastDataWithContext(ctx aws.Context, input *GetScalingPlanResourceForecastDataInput, opts ...request.Option) (*GetScalingPlanResourceForecastDataOutput, error) {
	req, out := c.GetScalingPlanResourceForecastDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScalingPlan = "UpdateScalingPlan"

// UpdateScalingPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScalingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScalingPlan for more information on using the UpdateScalingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateScalingPlanRequest method.
//    req, resp := client.UpdateScalingPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan
func (c *AutoScalingPlans) UpdateScalingPlanRequest(input *UpdateScalingPlanInput) (req *request.Request, output *UpdateScalingPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScalingPlanInput{}
	}

	output = &UpdateScalingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScalingPlan API operation for AWS Auto Scaling Plans.
//
// Updates the specified scaling plan.
//
// You cannot update a scaling plan if it is in the process of being created,
// updated, or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Auto Scaling Plans's
// API operation UpdateScalingPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   An exception was thrown for a validation issue. Review the parameters provided.
//
//   * ErrCodeConcurrentUpdateException "ConcurrentUpdateException"
//   Concurrent updates caused an exception, for example, if you request an update
//   to a scaling plan that already has a pending update.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The service encountered an internal error.
//
//   * ErrCodeObjectNotFoundException "ObjectNotFoundException"
//   The specified object could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan
func (c *AutoScalingPlans) UpdateScalingPlan(input *UpdateScalingPlanInput) (*UpdateScalingPlanOutput, error) {
	req, out := c.UpdateScalingPlanRequest(input)
	return out, req.Send()
}

// UpdateScalingPlanWithContext is the same as UpdateScalingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScalingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AutoScalingPlans) UpdateScalingPlanWithContext(ctx aws.Context, input *UpdateScalingPlanInput, opts ...request.Option) (*UpdateScalingPlanOutput, error) {
	req, out := c.UpdateScalingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an application source.
type ApplicationSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of a AWS CloudFormation stack.
	CloudFormationStackARN *string `type:"string"`

	// A set of tags (up to 50).
	TagFilters []*TagFilter `type:"list"`
}

// String returns the string representation
func (s ApplicationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSource"}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFormationStackARN sets the CloudFormationStackARN field's value.
func (s *ApplicationSource) SetCloudFormationStackARN(v string) *ApplicationSource {
	s.CloudFormationStackARN = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ApplicationSource) SetTagFilters(v []*TagFilter) *ApplicationSource {
	s.TagFilters = v
	return s
}

type CreateScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// A CloudFormation stack or set of tags. You can create one scaling plan per
	// application source.
	//
	// ApplicationSource is a required field
	ApplicationSource *ApplicationSource `type:"structure" required:"true"`

	// The scaling instructions.
	//
	// ScalingInstructions is a required field
	ScalingInstructions []*ScalingInstruction `type:"list" required:"true"`

	// The name of the scaling plan. Names cannot contain vertical bars, colons,
	// or forward slashes.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScalingPlanInput"}
	if s.ApplicationSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationSource"))
	}
	if s.ScalingInstructions == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingInstructions"))
	}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ApplicationSource != nil {
		if err := s.ApplicationSource.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ScalingInstructions != nil {
		for i, v := range s.ScalingInstructions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScalingInstructions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *CreateScalingPlanInput) SetApplicationSource(v *ApplicationSource) *CreateScalingPlanInput {
	s.ApplicationSource = v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *CreateScalingPlanInput) SetScalingInstructions(v []*ScalingInstruction) *CreateScalingPlanInput {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *CreateScalingPlanInput) SetScalingPlanName(v string) *CreateScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

type CreateScalingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The version number of the scaling plan. This value is always 1.
	//
	// Currently, you cannot specify multiple scaling plan versions.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScalingPlanOutput) GoString() string {
	return s.String()
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *CreateScalingPlanOutput) SetScalingPlanVersion(v int64) *CreateScalingPlanOutput {
	s.ScalingPlanVersion = &v
	return s
}

// Represents a CloudWatch metric of your choosing that can be used for predictive
// scaling.
//
// For predictive scaling to work with a customized load metric specification,
// AWS Auto Scaling needs access to the Sum and Average statistics that CloudWatch
// computes from metric data. Statistics are calculations used to aggregate
// data over specified time periods. For more information, see the Amazon CloudWatch
// User Guide (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
//
// When you choose a load metric, make sure that the required Sum and Average
// statistics for your metric are available in CloudWatch and that they provide
// relevant data for predictive scaling. The Sum statistic must represent the
// total load on the resource, and the Average statistic must represent the
// average load per capacity unit of the resource. For example, there is a metric
// that counts the number of requests processed by your Auto Scaling group.
// If the Sum statistic represents the total request count processed by the
// group, then the Average statistic for the specified metric must represent
// the average request count processed by each instance of the group.
//
// For information about terminology, see Amazon CloudWatch Concepts (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
type CustomizedLoadMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric. Currently, the value must always be Sum.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"MetricStatistic"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedLoadMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizedLoadMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedLoadMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedLoadMetricSpecification"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedLoadMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedLoadMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedLoadMetricSpecification) SetMetricName(v string) *CustomizedLoadMetricSpecification {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedLoadMetricSpecification) SetNamespace(v string) *CustomizedLoadMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedLoadMetricSpecification) SetStatistic(v string) *CustomizedLoadMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedLoadMetricSpecification) SetUnit(v string) *CustomizedLoadMetricSpecification {
	s.Unit = &v
	return s
}

// Represents a CloudWatch metric of your choosing that can be used for dynamic
// scaling as part of a target tracking scaling policy.
//
// For information about terminology, see Amazon CloudWatch Concepts (http://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
type CustomizedScalingMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	Dimensions []*MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic *string `type:"string" required:"true" enum:"MetricStatistic"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedScalingMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizedScalingMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedScalingMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomizedScalingMetricSpecification"}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Statistic == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensions sets the Dimensions field's value.
func (s *CustomizedScalingMetricSpecification) SetDimensions(v []*MetricDimension) *CustomizedScalingMetricSpecification {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CustomizedScalingMetricSpecification) SetMetricName(v string) *CustomizedScalingMetricSpecification {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CustomizedScalingMetricSpecification) SetNamespace(v string) *CustomizedScalingMetricSpecification {
	s.Namespace = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *CustomizedScalingMetricSpecification) SetStatistic(v string) *CustomizedScalingMetricSpecification {
	s.Statistic = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CustomizedScalingMetricSpecification) SetUnit(v string) *CustomizedScalingMetricSpecification {
	s.Unit = &v
	return s
}

// Represents a single value in the forecast data used for predictive scaling.
type Datapoint struct {
	_ struct{} `type:"structure"`

	// The time stamp for the data point in UTC format.
	Timestamp *time.Time `type:"timestamp"`

	// The value of the data point.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s Datapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Datapoint) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *Datapoint) SetTimestamp(v time.Time) *Datapoint {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Datapoint) SetValue(v float64) *Datapoint {
	s.Value = &v
	return s
}

type DeleteScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPlanInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *DeleteScalingPlanInput) SetScalingPlanName(v string) *DeleteScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DeleteScalingPlanInput) SetScalingPlanVersion(v int64) *DeleteScalingPlanInput {
	s.ScalingPlanVersion = &v
	return s
}

type DeleteScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScalingPlanOutput) GoString() string {
	return s.String()
}

type DescribeScalingPlanResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of scalable resources to return. The value must be between
	// 1 and 50. The default value is 50.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DescribeScalingPlanResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlanResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPlanResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPlanResourcesInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPlanResourcesInput) SetMaxResults(v int64) *DescribeScalingPlanResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlanResourcesInput) SetNextToken(v string) *DescribeScalingPlanResourcesInput {
	s.NextToken = &v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *DescribeScalingPlanResourcesInput) SetScalingPlanName(v string) *DescribeScalingPlanResourcesInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DescribeScalingPlanResourcesInput) SetScalingPlanVersion(v int64) *DescribeScalingPlanResourcesInput {
	s.ScalingPlanVersion = &v
	return s
}

type DescribeScalingPlanResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scalable resources.
	ScalingPlanResources []*ScalingPlanResource `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPlanResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlanResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlanResourcesOutput) SetNextToken(v string) *DescribeScalingPlanResourcesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPlanResources sets the ScalingPlanResources field's value.
func (s *DescribeScalingPlanResourcesOutput) SetScalingPlanResources(v []*ScalingPlanResource) *DescribeScalingPlanResourcesOutput {
	s.ScalingPlanResources = v
	return s
}

type DescribeScalingPlansInput struct {
	_ struct{} `type:"structure"`

	// The sources for the applications (up to 10). If you specify scaling plan
	// names, you cannot specify application sources.
	ApplicationSources []*ApplicationSource `type:"list"`

	// The maximum number of scalable resources to return. This value can be between
	// 1 and 50. The default value is 50.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of results.
	NextToken *string `type:"string"`

	// The names of the scaling plans (up to 10). If you specify application sources,
	// you cannot specify scaling plan names.
	ScalingPlanNames []*string `type:"list"`

	// The version number of the scaling plan. If you specify a scaling plan version,
	// you must also specify a scaling plan name.
	ScalingPlanVersion *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeScalingPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPlansInput"}
	if s.ApplicationSources != nil {
		for i, v := range s.ApplicationSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ApplicationSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSources sets the ApplicationSources field's value.
func (s *DescribeScalingPlansInput) SetApplicationSources(v []*ApplicationSource) *DescribeScalingPlansInput {
	s.ApplicationSources = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeScalingPlansInput) SetMaxResults(v int64) *DescribeScalingPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlansInput) SetNextToken(v string) *DescribeScalingPlansInput {
	s.NextToken = &v
	return s
}

// SetScalingPlanNames sets the ScalingPlanNames field's value.
func (s *DescribeScalingPlansInput) SetScalingPlanNames(v []*string) *DescribeScalingPlansInput {
	s.ScalingPlanNames = v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *DescribeScalingPlansInput) SetScalingPlanVersion(v int64) *DescribeScalingPlansInput {
	s.ScalingPlanVersion = &v
	return s
}

type DescribeScalingPlansOutput struct {
	_ struct{} `type:"structure"`

	// The token required to get the next set of results. This value is null if
	// there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the scaling plans.
	ScalingPlans []*ScalingPlan `type:"list"`
}

// String returns the string representation
func (s DescribeScalingPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPlansOutput) SetNextToken(v string) *DescribeScalingPlansOutput {
	s.NextToken = &v
	return s
}

// SetScalingPlans sets the ScalingPlans field's value.
func (s *DescribeScalingPlansOutput) SetScalingPlans(v []*ScalingPlan) *DescribeScalingPlansOutput {
	s.ScalingPlans = v
	return s
}

type GetScalingPlanResourceForecastDataInput struct {
	_ struct{} `type:"structure"`

	// The exclusive end time of the time range for the forecast data to get. The
	// maximum time duration between the start and end time is seven days.
	//
	// Although this parameter can accept a date and time that is more than two
	// days in the future, the availability of forecast data has limits. AWS Auto
	// Scaling only issues forecasts for periods of two days in advance.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The type of forecast data to get.
	//
	//    * LoadForecast: The load metric forecast.
	//
	//    * CapacityForecast: The capacity forecast.
	//
	//    * ScheduledActionMinCapacity: The minimum capacity for each scheduled
	//    scaling action. This data is calculated as the larger of two values: the
	//    capacity forecast or the minimum capacity in the scaling instruction.
	//
	//    * ScheduledActionMaxCapacity: The maximum capacity for each scheduled
	//    scaling action. The calculation used is determined by the predictive scaling
	//    maximum capacity behavior setting in the scaling instruction.
	//
	// ForecastDataType is a required field
	ForecastDataType *string `type:"string" required:"true" enum:"ForecastDataType"`

	// The ID of the resource. This string consists of the resource type and unique
	// identifier.
	//
	//    * Auto Scaling group - The resource type is autoScalingGroup and the unique
	//    identifier is the name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot Fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The scalable dimension for the resource.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`

	// The namespace of the AWS service.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The inclusive start time of the time range for the forecast data to get.
	// The date and time can be at most 56 days before the current date and time.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetScalingPlanResourceForecastDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetScalingPlanResourceForecastDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScalingPlanResourceForecastDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScalingPlanResourceForecastDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.ForecastDataType == nil {
		invalidParams.Add(request.NewErrParamRequired("ForecastDataType"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetEndTime(v time.Time) *GetScalingPlanResourceForecastDataInput {
	s.EndTime = &v
	return s
}

// SetForecastDataType sets the ForecastDataType field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetForecastDataType(v string) *GetScalingPlanResourceForecastDataInput {
	s.ForecastDataType = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetResourceId(v string) *GetScalingPlanResourceForecastDataInput {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetScalableDimension(v string) *GetScalingPlanResourceForecastDataInput {
	s.ScalableDimension = &v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetScalingPlanName(v string) *GetScalingPlanResourceForecastDataInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetScalingPlanVersion(v int64) *GetScalingPlanResourceForecastDataInput {
	s.ScalingPlanVersion = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetServiceNamespace(v string) *GetScalingPlanResourceForecastDataInput {
	s.ServiceNamespace = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetScalingPlanResourceForecastDataInput) SetStartTime(v time.Time) *GetScalingPlanResourceForecastDataInput {
	s.StartTime = &v
	return s
}

type GetScalingPlanResourceForecastDataOutput struct {
	_ struct{} `type:"structure"`

	// The data points to return.
	//
	// Datapoints is a required field
	Datapoints []*Datapoint `type:"list" required:"true"`
}

// String returns the string representation
func (s GetScalingPlanResourceForecastDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetScalingPlanResourceForecastDataOutput) GoString() string {
	return s.String()
}

// SetDatapoints sets the Datapoints field's value.
func (s *GetScalingPlanResourceForecastDataOutput) SetDatapoints(v []*Datapoint) *GetScalingPlanResourceForecastDataOutput {
	s.Datapoints = v
	return s
}

// Represents a dimension for a customized metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDimension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricDimension"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MetricDimension) SetName(v string) *MetricDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetricDimension) SetValue(v string) *MetricDimension {
	s.Value = &v
	return s
}

// Represents a predefined metric that can be used for predictive scaling.
type PredefinedLoadMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type.
	//
	// PredefinedLoadMetricType is a required field
	PredefinedLoadMetricType *string `type:"string" required:"true" enum:"LoadMetricType"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group for an Application Load Balancer attached to the Auto Scaling
	// group.
	//
	// The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
	// where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN.
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedLoadMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredefinedLoadMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedLoadMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedLoadMetricSpecification"}
	if s.PredefinedLoadMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedLoadMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedLoadMetricType sets the PredefinedLoadMetricType field's value.
func (s *PredefinedLoadMetricSpecification) SetPredefinedLoadMetricType(v string) *PredefinedLoadMetricSpecification {
	s.PredefinedLoadMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedLoadMetricSpecification) SetResourceLabel(v string) *PredefinedLoadMetricSpecification {
	s.ResourceLabel = &v
	return s
}

// Represents a predefined metric that can be used for dynamic scaling as part
// of a target tracking scaling policy.
type PredefinedScalingMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The ALBRequestCountPerTarget metric type applies only to
	// Auto Scaling groups, Spot Fleet requests, and ECS services.
	//
	// PredefinedScalingMetricType is a required field
	PredefinedScalingMetricType *string `type:"string" required:"true" enum:"ScalingMetricType"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group for an Application Load Balancer attached to the Auto Scaling
	// group, Spot Fleet request, or ECS service.
	//
	// The format is app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>,
	// where:
	//
	//    * app/<load-balancer-name>/<load-balancer-id> is the final portion of
	//    the load balancer ARN.
	//
	//    * targetgroup/<target-group-name>/<target-group-id> is the final portion
	//    of the target group ARN.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedScalingMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredefinedScalingMetricSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedScalingMetricSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PredefinedScalingMetricSpecification"}
	if s.PredefinedScalingMetricType == nil {
		invalidParams.Add(request.NewErrParamRequired("PredefinedScalingMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPredefinedScalingMetricType sets the PredefinedScalingMetricType field's value.
func (s *PredefinedScalingMetricSpecification) SetPredefinedScalingMetricType(v string) *PredefinedScalingMetricSpecification {
	s.PredefinedScalingMetricType = &v
	return s
}

// SetResourceLabel sets the ResourceLabel field's value.
func (s *PredefinedScalingMetricSpecification) SetResourceLabel(v string) *PredefinedScalingMetricSpecification {
	s.ResourceLabel = &v
	return s
}

// Describes a scaling instruction for a scalable resource.
//
// The scaling instruction is used in combination with a scaling plan, which
// is a set of instructions for configuring dynamic scaling and predictive scaling
// for the scalable resources in your application. Each scaling instruction
// applies to one resource.
//
// AWS Auto Scaling creates target tracking scaling policies based on the scaling
// instructions. Target tracking scaling policies adjust the capacity of your
// scalable resource as required to maintain resource utilization at the target
// value that you specified.
//
// AWS Auto Scaling also configures predictive scaling for your Amazon EC2 Auto
// Scaling groups using a subset of parameters, including the load metric, the
// scaling metric, the target value for the scaling metric, the predictive scaling
// mode (forecast and scale or forecast only), and the desired behavior when
// the forecast capacity exceeds the maximum capacity of the resource. With
// predictive scaling, AWS Auto Scaling generates forecasts with traffic predictions
// for the two days ahead and schedules scaling actions that proactively add
// and remove resource capacity to match the forecast.
//
// For more information, see the AWS Auto Scaling User Guide (http://docs.aws.amazon.com/autoscaling/plans/userguide/what-is-aws-auto-scaling.html).
type ScalingInstruction struct {
	_ struct{} `type:"structure"`

	// The customized load metric to use for predictive scaling. This parameter
	// or a PredefinedLoadMetricSpecification is required when configuring predictive
	// scaling, and cannot be used otherwise.
	CustomizedLoadMetricSpecification *CustomizedLoadMetricSpecification `type:"structure"`

	// Controls whether dynamic scaling by AWS Auto Scaling is disabled. When dynamic
	// scaling is enabled, AWS Auto Scaling creates target tracking scaling policies
	// based on the specified target tracking configurations.
	//
	// The default is enabled (false).
	DisableDynamicScaling *bool `type:"boolean"`

	// The maximum capacity of the resource. The exception to this upper limit is
	// if you specify a non-default setting for PredictiveScalingMaxCapacityBehavior.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The minimum capacity of the resource.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`

	// The predefined load metric to use for predictive scaling. This parameter
	// or a CustomizedLoadMetricSpecification is required when configuring predictive
	// scaling, and cannot be used otherwise.
	PredefinedLoadMetricSpecification *PredefinedLoadMetricSpecification `type:"structure"`

	// Defines the behavior that should be applied if the forecast capacity approaches
	// or exceeds the maximum capacity specified for the resource. The default value
	// is SetForecastCapacityToMaxCapacity.
	//
	// The following are possible values:
	//
	//    * SetForecastCapacityToMaxCapacity - AWS Auto Scaling cannot scale resource
	//    capacity higher than the maximum capacity. The maximum capacity is enforced
	//    as a hard limit.
	//
	//    * SetMaxCapacityToForecastCapacity - AWS Auto Scaling may scale resource
	//    capacity higher than the maximum capacity to equal but not exceed forecast
	//    capacity.
	//
	//    * SetMaxCapacityAboveForecastCapacity - AWS Auto Scaling may scale resource
	//    capacity higher than the maximum capacity by a specified buffer value.
	//    The intention is to give the target tracking scaling policy extra capacity
	//    if unexpected traffic occurs.
	//
	// Only valid when configuring predictive scaling.
	PredictiveScalingMaxCapacityBehavior *string `type:"string" enum:"PredictiveScalingMaxCapacityBehavior"`

	// The size of the capacity buffer to use when the forecast capacity is close
	// to or exceeds the maximum capacity. The value is specified as a percentage
	// relative to the forecast capacity. For example, if the buffer is 10, this
	// means a 10 percent buffer, such that if the forecast capacity is 50, and
	// the maximum capacity is 40, then the effective maximum capacity is 55.
	//
	// Only valid when configuring predictive scaling. Required if the PredictiveScalingMaxCapacityBehavior
	// is set to SetMaxCapacityAboveForecastCapacity, and cannot be used otherwise.
	//
	// The range is 1-100.
	PredictiveScalingMaxCapacityBuffer *int64 `type:"integer"`

	// The predictive scaling mode. The default value is ForecastAndScale. Otherwise,
	// AWS Auto Scaling forecasts capacity but does not create any scheduled scaling
	// actions based on the capacity forecast.
	PredictiveScalingMode *string `type:"string" enum:"PredictiveScalingMode"`

	// The ID of the resource. This string consists of the resource type and unique
	// identifier.
	//
	//    * Auto Scaling group - The resource type is autoScalingGroup and the unique
	//    identifier is the name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot Fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension associated with the resource.
	//
	//    * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity
	//    of an Auto Scaling group.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet request.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// Controls whether a resource's externally created scaling policies are kept
	// or replaced.
	//
	// The default value is KeepExternalPolicies. If the parameter is set to ReplaceExternalPolicies,
	// any scaling policies that are external to AWS Auto Scaling are deleted and
	// new target tracking scaling policies created.
	//
	// Only valid when configuring dynamic scaling.
	//
	// Condition: The number of existing policies to be replaced must be less than
	// or equal to 50. If there are more than 50 policies to be replaced, AWS Auto
	// Scaling keeps all existing policies and does not create new ones.
	ScalingPolicyUpdateBehavior *string `type:"string" enum:"ScalingPolicyUpdateBehavior"`

	// The amount of time, in seconds, to buffer the run time of scheduled scaling
	// actions when scaling out. For example, if the forecast says to add capacity
	// at 10:00 AM, and the buffer time is 5 minutes, then the run time of the corresponding
	// scheduled scaling action will be 9:55 AM. The intention is to give resources
	// time to be provisioned. For example, it can take a few minutes to launch
	// an EC2 instance. The actual amount of time required depends on several factors,
	// such as the size of the instance and whether there are startup scripts to
	// complete.
	//
	// The value must be less than the forecast interval duration of 3600 seconds
	// (60 minutes). The default is 300 seconds.
	//
	// Only valid when configuring predictive scaling.
	ScheduledActionBufferTime *int64 `type:"integer"`

	// The namespace of the AWS service.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`

	// The structure that defines new target tracking configurations (up to 10).
	// Each of these structures includes a specific scaling metric and a target
	// value for the metric, along with various parameters to use with dynamic scaling.
	//
	// With predictive scaling and dynamic scaling, the resource scales based on
	// the target tracking configuration that provides the largest capacity for
	// both scale in and scale out.
	//
	// Condition: The scaling metric must be unique across target tracking configurations.
	//
	// TargetTrackingConfigurations is a required field
	TargetTrackingConfigurations []*TargetTrackingConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s ScalingInstruction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingInstruction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingInstruction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingInstruction"}
	if s.MaxCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxCapacity"))
	}
	if s.MinCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("MinCapacity"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.ScalableDimension == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalableDimension"))
	}
	if s.ServiceNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceNamespace"))
	}
	if s.TargetTrackingConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTrackingConfigurations"))
	}
	if s.CustomizedLoadMetricSpecification != nil {
		if err := s.CustomizedLoadMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedLoadMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedLoadMetricSpecification != nil {
		if err := s.PredefinedLoadMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedLoadMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetTrackingConfigurations != nil {
		for i, v := range s.TargetTrackingConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetTrackingConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedLoadMetricSpecification sets the CustomizedLoadMetricSpecification field's value.
func (s *ScalingInstruction) SetCustomizedLoadMetricSpecification(v *CustomizedLoadMetricSpecification) *ScalingInstruction {
	s.CustomizedLoadMetricSpecification = v
	return s
}

// SetDisableDynamicScaling sets the DisableDynamicScaling field's value.
func (s *ScalingInstruction) SetDisableDynamicScaling(v bool) *ScalingInstruction {
	s.DisableDynamicScaling = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *ScalingInstruction) SetMaxCapacity(v int64) *ScalingInstruction {
	s.MaxCapacity = &v
	return s
}

// SetMinCapacity sets the MinCapacity field's value.
func (s *ScalingInstruction) SetMinCapacity(v int64) *ScalingInstruction {
	s.MinCapacity = &v
	return s
}

// SetPredefinedLoadMetricSpecification sets the PredefinedLoadMetricSpecification field's value.
func (s *ScalingInstruction) SetPredefinedLoadMetricSpecification(v *PredefinedLoadMetricSpecification) *ScalingInstruction {
	s.PredefinedLoadMetricSpecification = v
	return s
}

// SetPredictiveScalingMaxCapacityBehavior sets the PredictiveScalingMaxCapacityBehavior field's value.
func (s *ScalingInstruction) SetPredictiveScalingMaxCapacityBehavior(v string) *ScalingInstruction {
	s.PredictiveScalingMaxCapacityBehavior = &v
	return s
}

// SetPredictiveScalingMaxCapacityBuffer sets the PredictiveScalingMaxCapacityBuffer field's value.
func (s *ScalingInstruction) SetPredictiveScalingMaxCapacityBuffer(v int64) *ScalingInstruction {
	s.PredictiveScalingMaxCapacityBuffer = &v
	return s
}

// SetPredictiveScalingMode sets the PredictiveScalingMode field's value.
func (s *ScalingInstruction) SetPredictiveScalingMode(v string) *ScalingInstruction {
	s.PredictiveScalingMode = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingInstruction) SetResourceId(v string) *ScalingInstruction {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingInstruction) SetScalableDimension(v string) *ScalingInstruction {
	s.ScalableDimension = &v
	return s
}

// SetScalingPolicyUpdateBehavior sets the ScalingPolicyUpdateBehavior field's value.
func (s *ScalingInstruction) SetScalingPolicyUpdateBehavior(v string) *ScalingInstruction {
	s.ScalingPolicyUpdateBehavior = &v
	return s
}

// SetScheduledActionBufferTime sets the ScheduledActionBufferTime field's value.
func (s *ScalingInstruction) SetScheduledActionBufferTime(v int64) *ScalingInstruction {
	s.ScheduledActionBufferTime = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingInstruction) SetServiceNamespace(v string) *ScalingInstruction {
	s.ServiceNamespace = &v
	return s
}

// SetTargetTrackingConfigurations sets the TargetTrackingConfigurations field's value.
func (s *ScalingInstruction) SetTargetTrackingConfigurations(v []*TargetTrackingConfiguration) *ScalingInstruction {
	s.TargetTrackingConfigurations = v
	return s
}

// Represents a scaling plan.
type ScalingPlan struct {
	_ struct{} `type:"structure"`

	// The application source.
	//
	// ApplicationSource is a required field
	ApplicationSource *ApplicationSource `type:"structure" required:"true"`

	// The Unix time stamp when the scaling plan was created.
	CreationTime *time.Time `type:"timestamp"`

	// The scaling instructions.
	//
	// ScalingInstructions is a required field
	ScalingInstructions []*ScalingInstruction `type:"list" required:"true"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`

	// The status of the scaling plan.
	//
	//    * Active - The scaling plan is active.
	//
	//    * ActiveWithProblems - The scaling plan is active, but the scaling configuration
	//    for one or more resources could not be applied.
	//
	//    * CreationInProgress - The scaling plan is being created.
	//
	//    * CreationFailed - The scaling plan could not be created.
	//
	//    * DeletionInProgress - The scaling plan is being deleted.
	//
	//    * DeletionFailed - The scaling plan could not be deleted.
	//
	//    * UpdateInProgress - The scaling plan is being updated.
	//
	//    * UpdateFailed - The scaling plan could not be updated.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingPlanStatusCode"`

	// A simple message about the current status of the scaling plan.
	StatusMessage *string `type:"string"`

	// The Unix time stamp when the scaling plan entered the current status.
	StatusStartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ScalingPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPlan) GoString() string {
	return s.String()
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *ScalingPlan) SetApplicationSource(v *ApplicationSource) *ScalingPlan {
	s.ApplicationSource = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ScalingPlan) SetCreationTime(v time.Time) *ScalingPlan {
	s.CreationTime = &v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *ScalingPlan) SetScalingInstructions(v []*ScalingInstruction) *ScalingPlan {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *ScalingPlan) SetScalingPlanName(v string) *ScalingPlan {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *ScalingPlan) SetScalingPlanVersion(v int64) *ScalingPlan {
	s.ScalingPlanVersion = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ScalingPlan) SetStatusCode(v string) *ScalingPlan {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ScalingPlan) SetStatusMessage(v string) *ScalingPlan {
	s.StatusMessage = &v
	return s
}

// SetStatusStartTime sets the StatusStartTime field's value.
func (s *ScalingPlan) SetStatusStartTime(v time.Time) *ScalingPlan {
	s.StatusStartTime = &v
	return s
}

// Represents a scalable resource.
type ScalingPlanResource struct {
	_ struct{} `type:"structure"`

	// The ID of the resource. This string consists of the resource type and unique
	// identifier.
	//
	//    * Auto Scaling group - The resource type is autoScalingGroup and the unique
	//    identifier is the name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
	//
	//    * ECS service - The resource type is service and the unique identifier
	//    is the cluster name and service name. Example: service/default/sample-webapp.
	//
	//    * Spot Fleet request - The resource type is spot-fleet-request and the
	//    unique identifier is the Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
	//
	//    * DynamoDB table - The resource type is table and the unique identifier
	//    is the resource ID. Example: table/my-table.
	//
	//    * DynamoDB global secondary index - The resource type is index and the
	//    unique identifier is the resource ID. Example: table/my-table/index/my-table-index.
	//
	//    * Aurora DB cluster - The resource type is cluster and the unique identifier
	//    is the cluster name. Example: cluster:my-db-cluster.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The scalable dimension for the resource.
	//
	//    * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity
	//    of an Auto Scaling group.
	//
	//    * ecs:service:DesiredCount - The desired task count of an ECS service.
	//
	//    * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot
	//    Fleet request.
	//
	//    * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB table.
	//
	//    * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for
	//    a DynamoDB global secondary index.
	//
	//    * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for
	//    a DynamoDB global secondary index.
	//
	//    * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora
	//    DB cluster. Available for Aurora MySQL-compatible edition.
	//
	// ScalableDimension is a required field
	ScalableDimension *string `type:"string" required:"true" enum:"ScalableDimension"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`

	// The scaling status of the resource.
	//
	//    * Active - The scaling configuration is active.
	//
	//    * Inactive - The scaling configuration is not active because the scaling
	//    plan is being created or the scaling configuration could not be applied.
	//    Check the status message for more information.
	//
	//    * PartiallyActive - The scaling configuration is partially active because
	//    the scaling plan is being created or deleted or the scaling configuration
	//    could not be fully applied. Check the status message for more information.
	//
	// ScalingStatusCode is a required field
	ScalingStatusCode *string `type:"string" required:"true" enum:"ScalingStatusCode"`

	// A simple message about the current scaling status of the resource.
	ScalingStatusMessage *string `type:"string"`

	// The namespace of the AWS service.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `type:"string" required:"true" enum:"ServiceNamespace"`
}

// String returns the string representation
func (s ScalingPlanResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPlanResource) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ScalingPlanResource) SetResourceId(v string) *ScalingPlanResource {
	s.ResourceId = &v
	return s
}

// SetScalableDimension sets the ScalableDimension field's value.
func (s *ScalingPlanResource) SetScalableDimension(v string) *ScalingPlanResource {
	s.ScalableDimension = &v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *ScalingPlanResource) SetScalingPlanName(v string) *ScalingPlanResource {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *ScalingPlanResource) SetScalingPlanVersion(v int64) *ScalingPlanResource {
	s.ScalingPlanVersion = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *ScalingPlanResource) SetScalingPolicies(v []*ScalingPolicy) *ScalingPlanResource {
	s.ScalingPolicies = v
	return s
}

// SetScalingStatusCode sets the ScalingStatusCode field's value.
func (s *ScalingPlanResource) SetScalingStatusCode(v string) *ScalingPlanResource {
	s.ScalingStatusCode = &v
	return s
}

// SetScalingStatusMessage sets the ScalingStatusMessage field's value.
func (s *ScalingPlanResource) SetScalingStatusMessage(v string) *ScalingPlanResource {
	s.ScalingStatusMessage = &v
	return s
}

// SetServiceNamespace sets the ServiceNamespace field's value.
func (s *ScalingPlanResource) SetServiceNamespace(v string) *ScalingPlanResource {
	s.ServiceNamespace = &v
	return s
}

// Represents a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the scaling policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The type of scaling policy.
	//
	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true" enum:"PolicyType"`

	// The target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// SetPolicyName sets the PolicyName field's value.
func (s *ScalingPolicy) SetPolicyName(v string) *ScalingPolicy {
	s.PolicyName = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *ScalingPolicy) SetPolicyType(v string) *ScalingPolicy {
	s.PolicyType = &v
	return s
}

// SetTargetTrackingConfiguration sets the TargetTrackingConfiguration field's value.
func (s *ScalingPolicy) SetTargetTrackingConfiguration(v *TargetTrackingConfiguration) *ScalingPolicy {
	s.TargetTrackingConfiguration = v
	return s
}

// Represents a tag.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// The tag values (0 to 20).
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

// Describes a target tracking configuration. Used with ScalingInstruction and
// ScalingPolicy.
type TargetTrackingConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric.
	CustomizedScalingMetricSpecification *CustomizedScalingMetricSpecification `type:"structure"`

	// Indicates whether scale in by the target tracking scaling policy is disabled.
	// If the value is true, scale in is disabled and the target tracking scaling
	// policy doesn't remove capacity from the scalable resource. Otherwise, scale
	// in is enabled and the target tracking scaling policy can remove capacity
	// from the scalable resource.
	//
	// The default value is false.
	DisableScaleIn *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. This value is used only if the resource is an
	// Auto Scaling group.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// A predefined metric.
	PredefinedScalingMetricSpecification *PredefinedScalingMetricSpecification `type:"structure"`

	// The amount of time, in seconds, after a scale in activity completes before
	// another scale in activity can start. This value is not used if the scalable
	// resource is an Auto Scaling group.
	//
	// The cooldown period is used to block subsequent scale in requests until it
	// has expired. The intention is to scale in conservatively to protect your
	// application's availability. However, if another alarm triggers a scale-out
	// policy during the cooldown period after a scale-in, AWS Auto Scaling scales
	// out your scalable target immediately.
	ScaleInCooldown *int64 `type:"integer"`

	// The amount of time, in seconds, after a scale-out activity completes before
	// another scale-out activity can start. This value is not used if the scalable
	// resource is an Auto Scaling group.
	//
	// While the cooldown period is in effect, the capacity that has been added
	// by the previous scale-out event that initiated the cooldown is calculated
	// as part of the desired capacity for the next scale out. The intention is
	// to continuously (but not excessively) scale out.
	ScaleOutCooldown *int64 `type:"integer"`

	// The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
	// (Base 10) or 2e-360 to 2e360 (Base 2).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetTrackingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetTrackingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetTrackingConfiguration"}
	if s.TargetValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedScalingMetricSpecification != nil {
		if err := s.CustomizedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PredefinedScalingMetricSpecification != nil {
		if err := s.PredefinedScalingMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedScalingMetricSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizedScalingMetricSpecification sets the CustomizedScalingMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetCustomizedScalingMetricSpecification(v *CustomizedScalingMetricSpecification) *TargetTrackingConfiguration {
	s.CustomizedScalingMetricSpecification = v
	return s
}

// SetDisableScaleIn sets the DisableScaleIn field's value.
func (s *TargetTrackingConfiguration) SetDisableScaleIn(v bool) *TargetTrackingConfiguration {
	s.DisableScaleIn = &v
	return s
}

// SetEstimatedInstanceWarmup sets the EstimatedInstanceWarmup field's value.
func (s *TargetTrackingConfiguration) SetEstimatedInstanceWarmup(v int64) *TargetTrackingConfiguration {
	s.EstimatedInstanceWarmup = &v
	return s
}

// SetPredefinedScalingMetricSpecification sets the PredefinedScalingMetricSpecification field's value.
func (s *TargetTrackingConfiguration) SetPredefinedScalingMetricSpecification(v *PredefinedScalingMetricSpecification) *TargetTrackingConfiguration {
	s.PredefinedScalingMetricSpecification = v
	return s
}

// SetScaleInCooldown sets the ScaleInCooldown field's value.
func (s *TargetTrackingConfiguration) SetScaleInCooldown(v int64) *TargetTrackingConfiguration {
	s.ScaleInCooldown = &v
	return s
}

// SetScaleOutCooldown sets the ScaleOutCooldown field's value.
func (s *TargetTrackingConfiguration) SetScaleOutCooldown(v int64) *TargetTrackingConfiguration {
	s.ScaleOutCooldown = &v
	return s
}

// SetTargetValue sets the TargetValue field's value.
func (s *TargetTrackingConfiguration) SetTargetValue(v float64) *TargetTrackingConfiguration {
	s.TargetValue = &v
	return s
}

type UpdateScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// A CloudFormation stack or set of tags.
	ApplicationSource *ApplicationSource `type:"structure"`

	// The scaling instructions.
	ScalingInstructions []*ScalingInstruction `type:"list"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScalingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScalingPlanInput"}
	if s.ScalingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScalingPlanName", 1))
	}
	if s.ScalingPlanVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingPlanVersion"))
	}
	if s.ApplicationSource != nil {
		if err := s.ApplicationSource.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSource", err.(request.ErrInvalidParams))
		}
	}
	if s.ScalingInstructions != nil {
		for i, v := range s.ScalingInstructions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScalingInstructions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSource sets the ApplicationSource field's value.
func (s *UpdateScalingPlanInput) SetApplicationSource(v *ApplicationSource) *UpdateScalingPlanInput {
	s.ApplicationSource = v
	return s
}

// SetScalingInstructions sets the ScalingInstructions field's value.
func (s *UpdateScalingPlanInput) SetScalingInstructions(v []*ScalingInstruction) *UpdateScalingPlanInput {
	s.ScalingInstructions = v
	return s
}

// SetScalingPlanName sets the ScalingPlanName field's value.
func (s *UpdateScalingPlanInput) SetScalingPlanName(v string) *UpdateScalingPlanInput {
	s.ScalingPlanName = &v
	return s
}

// SetScalingPlanVersion sets the ScalingPlanVersion field's value.
func (s *UpdateScalingPlanInput) SetScalingPlanVersion(v int64) *UpdateScalingPlanInput {
	s.ScalingPlanVersion = &v
	return s
}

type UpdateScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateScalingPlanOutput) GoString() string {
	return s.String()
}

const (
	// ForecastDataTypeCapacityForecast is a ForecastDataType enum value
	ForecastDataTypeCapacityForecast = "CapacityForecast"

	// ForecastDataTypeLoadForecast is a ForecastDataType enum value
	ForecastDataTypeLoadForecast = "LoadForecast"

	// ForecastDataTypeScheduledActionMinCapacity is a ForecastDataType enum value
	ForecastDataTypeScheduledActionMinCapacity = "ScheduledActionMinCapacity"

	// ForecastDataTypeScheduledActionMaxCapacity is a ForecastDataType enum value
	ForecastDataTypeScheduledActionMaxCapacity = "ScheduledActionMaxCapacity"
)

const (
	// LoadMetricTypeAsgtotalCpuutilization is a LoadMetricType enum value
	LoadMetricTypeAsgtotalCpuutilization = "ASGTotalCPUUtilization"

	// LoadMetricTypeAsgtotalNetworkIn is a LoadMetricType enum value
	LoadMetricTypeAsgtotalNetworkIn = "ASGTotalNetworkIn"

	// LoadMetricTypeAsgtotalNetworkOut is a LoadMetricType enum value
	LoadMetricTypeAsgtotalNetworkOut = "ASGTotalNetworkOut"

	// LoadMetricTypeAlbtargetGroupRequestCount is a LoadMetricType enum value
	LoadMetricTypeAlbtargetGroupRequestCount = "ALBTargetGroupRequestCount"
)

const (
	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"
)

const (
	// PolicyTypeTargetTrackingScaling is a PolicyType enum value
	PolicyTypeTargetTrackingScaling = "TargetTrackingScaling"
)

const (
	// PredictiveScalingMaxCapacityBehaviorSetForecastCapacityToMaxCapacity is a PredictiveScalingMaxCapacityBehavior enum value
	PredictiveScalingMaxCapacityBehaviorSetForecastCapacityToMaxCapacity = "SetForecastCapacityToMaxCapacity"

	// PredictiveScalingMaxCapacityBehaviorSetMaxCapacityToForecastCapacity is a PredictiveScalingMaxCapacityBehavior enum value
	PredictiveScalingMaxCapacityBehaviorSetMaxCapacityToForecastCapacity = "SetMaxCapacityToForecastCapacity"

	// PredictiveScalingMaxCapacityBehaviorSetMaxCapacityAboveForecastCapacity is a PredictiveScalingMaxCapacityBehavior enum value
	PredictiveScalingMaxCapacityBehaviorSetMaxCapacityAboveForecastCapacity = "SetMaxCapacityAboveForecastCapacity"
)

const (
	// PredictiveScalingModeForecastAndScale is a PredictiveScalingMode enum value
	PredictiveScalingModeForecastAndScale = "ForecastAndScale"

	// PredictiveScalingModeForecastOnly is a PredictiveScalingMode enum value
	PredictiveScalingModeForecastOnly = "ForecastOnly"
)

const (
	// ScalableDimensionAutoscalingAutoScalingGroupDesiredCapacity is a ScalableDimension enum value
	ScalableDimensionAutoscalingAutoScalingGroupDesiredCapacity = "autoscaling:autoScalingGroup:DesiredCapacity"

	// ScalableDimensionEcsServiceDesiredCount is a ScalableDimension enum value
	ScalableDimensionEcsServiceDesiredCount = "ecs:service:DesiredCount"

	// ScalableDimensionEc2SpotFleetRequestTargetCapacity is a ScalableDimension enum value
	ScalableDimensionEc2SpotFleetRequestTargetCapacity = "ec2:spot-fleet-request:TargetCapacity"

	// ScalableDimensionRdsClusterReadReplicaCount is a ScalableDimension enum value
	ScalableDimensionRdsClusterReadReplicaCount = "rds:cluster:ReadReplicaCount"

	// ScalableDimensionDynamodbTableReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableReadCapacityUnits = "dynamodb:table:ReadCapacityUnits"

	// ScalableDimensionDynamodbTableWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbTableWriteCapacityUnits = "dynamodb:table:WriteCapacityUnits"

	// ScalableDimensionDynamodbIndexReadCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexReadCapacityUnits = "dynamodb:index:ReadCapacityUnits"

	// ScalableDimensionDynamodbIndexWriteCapacityUnits is a ScalableDimension enum value
	ScalableDimensionDynamodbIndexWriteCapacityUnits = "dynamodb:index:WriteCapacityUnits"
)

const (
	// ScalingMetricTypeAsgaverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageCpuutilization = "ASGAverageCPUUtilization"

	// ScalingMetricTypeAsgaverageNetworkIn is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageNetworkIn = "ASGAverageNetworkIn"

	// ScalingMetricTypeAsgaverageNetworkOut is a ScalingMetricType enum value
	ScalingMetricTypeAsgaverageNetworkOut = "ASGAverageNetworkOut"

	// ScalingMetricTypeDynamoDbreadCapacityUtilization is a ScalingMetricType enum value
	ScalingMetricTypeDynamoDbreadCapacityUtilization = "DynamoDBReadCapacityUtilization"

	// ScalingMetricTypeDynamoDbwriteCapacityUtilization is a ScalingMetricType enum value
	ScalingMetricTypeDynamoDbwriteCapacityUtilization = "DynamoDBWriteCapacityUtilization"

	// ScalingMetricTypeEcsserviceAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeEcsserviceAverageCpuutilization = "ECSServiceAverageCPUUtilization"

	// ScalingMetricTypeEcsserviceAverageMemoryUtilization is a ScalingMetricType enum value
	ScalingMetricTypeEcsserviceAverageMemoryUtilization = "ECSServiceAverageMemoryUtilization"

	// ScalingMetricTypeAlbrequestCountPerTarget is a ScalingMetricType enum value
	ScalingMetricTypeAlbrequestCountPerTarget = "ALBRequestCountPerTarget"

	// ScalingMetricTypeRdsreaderAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeRdsreaderAverageCpuutilization = "RDSReaderAverageCPUUtilization"

	// ScalingMetricTypeRdsreaderAverageDatabaseConnections is a ScalingMetricType enum value
	ScalingMetricTypeRdsreaderAverageDatabaseConnections = "RDSReaderAverageDatabaseConnections"

	// ScalingMetricTypeEc2spotFleetRequestAverageCpuutilization is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageCpuutilization = "EC2SpotFleetRequestAverageCPUUtilization"

	// ScalingMetricTypeEc2spotFleetRequestAverageNetworkIn is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageNetworkIn = "EC2SpotFleetRequestAverageNetworkIn"

	// ScalingMetricTypeEc2spotFleetRequestAverageNetworkOut is a ScalingMetricType enum value
	ScalingMetricTypeEc2spotFleetRequestAverageNetworkOut = "EC2SpotFleetRequestAverageNetworkOut"
)

const (
	// ScalingPlanStatusCodeActive is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeActive = "Active"

	// ScalingPlanStatusCodeActiveWithProblems is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeActiveWithProblems = "ActiveWithProblems"

	// ScalingPlanStatusCodeCreationInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeCreationInProgress = "CreationInProgress"

	// ScalingPlanStatusCodeCreationFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeCreationFailed = "CreationFailed"

	// ScalingPlanStatusCodeDeletionInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeDeletionInProgress = "DeletionInProgress"

	// ScalingPlanStatusCodeDeletionFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeDeletionFailed = "DeletionFailed"

	// ScalingPlanStatusCodeUpdateInProgress is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeUpdateInProgress = "UpdateInProgress"

	// ScalingPlanStatusCodeUpdateFailed is a ScalingPlanStatusCode enum value
	ScalingPlanStatusCodeUpdateFailed = "UpdateFailed"
)

const (
	// ScalingPolicyUpdateBehaviorKeepExternalPolicies is a ScalingPolicyUpdateBehavior enum value
	ScalingPolicyUpdateBehaviorKeepExternalPolicies = "KeepExternalPolicies"

	// ScalingPolicyUpdateBehaviorReplaceExternalPolicies is a ScalingPolicyUpdateBehavior enum value
	ScalingPolicyUpdateBehaviorReplaceExternalPolicies = "ReplaceExternalPolicies"
)

const (
	// ScalingStatusCodeInactive is a ScalingStatusCode enum value
	ScalingStatusCodeInactive = "Inactive"

	// ScalingStatusCodePartiallyActive is a ScalingStatusCode enum value
	ScalingStatusCodePartiallyActive = "PartiallyActive"

	// ScalingStatusCodeActive is a ScalingStatusCode enum value
	ScalingStatusCodeActive = "Active"
)

const (
	// ServiceNamespaceAutoscaling is a ServiceNamespace enum value
	ServiceNamespaceAutoscaling = "autoscaling"

	// ServiceNamespaceEcs is a ServiceNamespace enum value
	ServiceNamespaceEcs = "ecs"

	// ServiceNamespaceEc2 is a ServiceNamespace enum value
	ServiceNamespaceEc2 = "ec2"

	// ServiceNamespaceRds is a ServiceNamespace enum value
	ServiceNamespaceRds = "rds"

	// ServiceNamespaceDynamodb is a ServiceNamespace enum value
	ServiceNamespaceDynamodb = "dynamodb"
)
