// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateApp
func (c *Amplify) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for AWS Amplify.
//
// Creates a new Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation CreateApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateApp
func (c *Amplify) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBranch = "CreateBranch"

// CreateBranchRequest generates a "aws/request.Request" representing the
// client's request for the CreateBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBranch for more information on using the CreateBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBranchRequest method.
//    req, resp := client.CreateBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBranch
func (c *Amplify) CreateBranchRequest(input *CreateBranchInput) (req *request.Request, output *CreateBranchOutput) {
	op := &request.Operation{
		Name:       opCreateBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/branches",
	}

	if input == nil {
		input = &CreateBranchInput{}
	}

	output = &CreateBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBranch API operation for AWS Amplify.
//
// Creates a new Branch for an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation CreateBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateBranch
func (c *Amplify) CreateBranch(input *CreateBranchInput) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	return out, req.Send()
}

// CreateBranchWithContext is the same as CreateBranch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) CreateBranchWithContext(ctx aws.Context, input *CreateBranchInput, opts ...request.Option) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainAssociation = "CreateDomainAssociation"

// CreateDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainAssociation for more information on using the CreateDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainAssociationRequest method.
//    req, resp := client.CreateDomainAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDomainAssociation
func (c *Amplify) CreateDomainAssociationRequest(input *CreateDomainAssociationInput) (req *request.Request, output *CreateDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/domains",
	}

	if input == nil {
		input = &CreateDomainAssociationInput{}
	}

	output = &CreateDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainAssociation API operation for AWS Amplify.
//
// Create a new DomainAssociation on an App
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation CreateDomainAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/CreateDomainAssociation
func (c *Amplify) CreateDomainAssociation(input *CreateDomainAssociationInput) (*CreateDomainAssociationOutput, error) {
	req, out := c.CreateDomainAssociationRequest(input)
	return out, req.Send()
}

// CreateDomainAssociationWithContext is the same as CreateDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) CreateDomainAssociationWithContext(ctx aws.Context, input *CreateDomainAssociationInput, opts ...request.Option) (*CreateDomainAssociationOutput, error) {
	req, out := c.CreateDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteApp
func (c *Amplify) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApp API operation for AWS Amplify.
//
// Delete an existing Amplify App by appId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation DeleteApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteApp
func (c *Amplify) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBranch = "DeleteBranch"

// DeleteBranchRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBranch for more information on using the DeleteBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBranchRequest method.
//    req, resp := client.DeleteBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBranch
func (c *Amplify) DeleteBranchRequest(input *DeleteBranchInput) (req *request.Request, output *DeleteBranchOutput) {
	op := &request.Operation{
		Name:       opDeleteBranch,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}/branches/{branchName}",
	}

	if input == nil {
		input = &DeleteBranchInput{}
	}

	output = &DeleteBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBranch API operation for AWS Amplify.
//
// Deletes a branch for an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation DeleteBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteBranch
func (c *Amplify) DeleteBranch(input *DeleteBranchInput) (*DeleteBranchOutput, error) {
	req, out := c.DeleteBranchRequest(input)
	return out, req.Send()
}

// DeleteBranchWithContext is the same as DeleteBranch with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) DeleteBranchWithContext(ctx aws.Context, input *DeleteBranchInput, opts ...request.Option) (*DeleteBranchOutput, error) {
	req, out := c.DeleteBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainAssociation = "DeleteDomainAssociation"

// DeleteDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainAssociation for more information on using the DeleteDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainAssociationRequest method.
//    req, resp := client.DeleteDomainAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteDomainAssociation
func (c *Amplify) DeleteDomainAssociationRequest(input *DeleteDomainAssociationInput) (req *request.Request, output *DeleteDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}/domains/{domainName}",
	}

	if input == nil {
		input = &DeleteDomainAssociationInput{}
	}

	output = &DeleteDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomainAssociation API operation for AWS Amplify.
//
// Deletes a DomainAssociation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation DeleteDomainAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteDomainAssociation
func (c *Amplify) DeleteDomainAssociation(input *DeleteDomainAssociationInput) (*DeleteDomainAssociationOutput, error) {
	req, out := c.DeleteDomainAssociationRequest(input)
	return out, req.Send()
}

// DeleteDomainAssociationWithContext is the same as DeleteDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) DeleteDomainAssociationWithContext(ctx aws.Context, input *DeleteDomainAssociationInput, opts ...request.Option) (*DeleteDomainAssociationOutput, error) {
	req, out := c.DeleteDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJob
func (c *Amplify) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJob API operation for AWS Amplify.
//
// Delete a job, for an Amplify branch, part of Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation DeleteJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJob
func (c *Amplify) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApp = "GetApp"

// GetAppRequest generates a "aws/request.Request" representing the
// client's request for the GetApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApp for more information on using the GetApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppRequest method.
//    req, resp := client.GetAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetApp
func (c *Amplify) GetAppRequest(input *GetAppInput) (req *request.Request, output *GetAppOutput) {
	op := &request.Operation{
		Name:       opGetApp,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}",
	}

	if input == nil {
		input = &GetAppInput{}
	}

	output = &GetAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApp API operation for AWS Amplify.
//
// Retrieves an existing Amplify App by appId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation GetApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetApp
func (c *Amplify) GetApp(input *GetAppInput) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	return out, req.Send()
}

// GetAppWithContext is the same as GetApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) GetAppWithContext(ctx aws.Context, input *GetAppInput, opts ...request.Option) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBranch = "GetBranch"

// GetBranchRequest generates a "aws/request.Request" representing the
// client's request for the GetBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBranch for more information on using the GetBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBranchRequest method.
//    req, resp := client.GetBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBranch
func (c *Amplify) GetBranchRequest(input *GetBranchInput) (req *request.Request, output *GetBranchOutput) {
	op := &request.Operation{
		Name:       opGetBranch,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/branches/{branchName}",
	}

	if input == nil {
		input = &GetBranchInput{}
	}

	output = &GetBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBranch API operation for AWS Amplify.
//
// Retrieves a branch for an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation GetBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetBranch
func (c *Amplify) GetBranch(input *GetBranchInput) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	return out, req.Send()
}

// GetBranchWithContext is the same as GetBranch with the addition of
// the ability to pass a context and additional request options.
//
// See GetBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) GetBranchWithContext(ctx aws.Context, input *GetBranchInput, opts ...request.Option) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainAssociation = "GetDomainAssociation"

// GetDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainAssociation for more information on using the GetDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainAssociationRequest method.
//    req, resp := client.GetDomainAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetDomainAssociation
func (c *Amplify) GetDomainAssociationRequest(input *GetDomainAssociationInput) (req *request.Request, output *GetDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opGetDomainAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/domains/{domainName}",
	}

	if input == nil {
		input = &GetDomainAssociationInput{}
	}

	output = &GetDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainAssociation API operation for AWS Amplify.
//
// Retrieves domain info that corresponds to an appId and domainName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation GetDomainAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetDomainAssociation
func (c *Amplify) GetDomainAssociation(input *GetDomainAssociationInput) (*GetDomainAssociationOutput, error) {
	req, out := c.GetDomainAssociationRequest(input)
	return out, req.Send()
}

// GetDomainAssociationWithContext is the same as GetDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) GetDomainAssociationWithContext(ctx aws.Context, input *GetDomainAssociationInput, opts ...request.Option) (*GetDomainAssociationOutput, error) {
	req, out := c.GetDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetJob
func (c *Amplify) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs/{jobId}",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Amplify.
//
// Get a job for a branch, part of an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation GetJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/GetJob
func (c *Amplify) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApps = "ListApps"

// ListAppsRequest generates a "aws/request.Request" representing the
// client's request for the ListApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApps for more information on using the ListApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAppsRequest method.
//    req, resp := client.ListAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListApps
func (c *Amplify) ListAppsRequest(input *ListAppsInput) (req *request.Request, output *ListAppsOutput) {
	op := &request.Operation{
		Name:       opListApps,
		HTTPMethod: "GET",
		HTTPPath:   "/apps",
	}

	if input == nil {
		input = &ListAppsInput{}
	}

	output = &ListAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApps API operation for AWS Amplify.
//
// Lists existing Amplify Apps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation ListApps for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListApps
func (c *Amplify) ListApps(input *ListAppsInput) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	return out, req.Send()
}

// ListAppsWithContext is the same as ListApps with the addition of
// the ability to pass a context and additional request options.
//
// See ListApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) ListAppsWithContext(ctx aws.Context, input *ListAppsInput, opts ...request.Option) (*ListAppsOutput, error) {
	req, out := c.ListAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBranches = "ListBranches"

// ListBranchesRequest generates a "aws/request.Request" representing the
// client's request for the ListBranches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBranches for more information on using the ListBranches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBranchesRequest method.
//    req, resp := client.ListBranchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranches
func (c *Amplify) ListBranchesRequest(input *ListBranchesInput) (req *request.Request, output *ListBranchesOutput) {
	op := &request.Operation{
		Name:       opListBranches,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/branches",
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	output = &ListBranchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBranches API operation for AWS Amplify.
//
// Lists branches for an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation ListBranches for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListBranches
func (c *Amplify) ListBranches(input *ListBranchesInput) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	return out, req.Send()
}

// ListBranchesWithContext is the same as ListBranches with the addition of
// the ability to pass a context and additional request options.
//
// See ListBranches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) ListBranchesWithContext(ctx aws.Context, input *ListBranchesInput, opts ...request.Option) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainAssociations = "ListDomainAssociations"

// ListDomainAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainAssociations for more information on using the ListDomainAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainAssociationsRequest method.
//    req, resp := client.ListDomainAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListDomainAssociations
func (c *Amplify) ListDomainAssociationsRequest(input *ListDomainAssociationsInput) (req *request.Request, output *ListDomainAssociationsOutput) {
	op := &request.Operation{
		Name:       opListDomainAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/domains",
	}

	if input == nil {
		input = &ListDomainAssociationsInput{}
	}

	output = &ListDomainAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainAssociations API operation for AWS Amplify.
//
// List domains with an app
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation ListDomainAssociations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListDomainAssociations
func (c *Amplify) ListDomainAssociations(input *ListDomainAssociationsInput) (*ListDomainAssociationsOutput, error) {
	req, out := c.ListDomainAssociationsRequest(input)
	return out, req.Send()
}

// ListDomainAssociationsWithContext is the same as ListDomainAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) ListDomainAssociationsWithContext(ctx aws.Context, input *ListDomainAssociationsInput, opts ...request.Option) (*ListDomainAssociationsOutput, error) {
	req, out := c.ListDomainAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListJobs
func (c *Amplify) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs",
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Amplify.
//
// List Jobs for a branch, part of an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/ListJobs
func (c *Amplify) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJob = "StartJob"

// StartJobRequest generates a "aws/request.Request" representing the
// client's request for the StartJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJob for more information on using the StartJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartJobRequest method.
//    req, resp := client.StartJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartJob
func (c *Amplify) StartJobRequest(input *StartJobInput) (req *request.Request, output *StartJobOutput) {
	op := &request.Operation{
		Name:       opStartJob,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs",
	}

	if input == nil {
		input = &StartJobInput{}
	}

	output = &StartJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJob API operation for AWS Amplify.
//
// Starts a new job for a branch, part of an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation StartJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StartJob
func (c *Amplify) StartJob(input *StartJobInput) (*StartJobOutput, error) {
	req, out := c.StartJobRequest(input)
	return out, req.Send()
}

// StartJobWithContext is the same as StartJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) StartJobWithContext(ctx aws.Context, input *StartJobInput, opts ...request.Option) (*StartJobOutput, error) {
	req, out := c.StartJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopJob = "StopJob"

// StopJobRequest generates a "aws/request.Request" representing the
// client's request for the StopJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopJob for more information on using the StopJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopJobRequest method.
//    req, resp := client.StopJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StopJob
func (c *Amplify) StopJobRequest(input *StopJobInput) (req *request.Request, output *StopJobOutput) {
	op := &request.Operation{
		Name:       opStopJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs/{jobId}/stop",
	}

	if input == nil {
		input = &StopJobInput{}
	}

	output = &StopJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopJob API operation for AWS Amplify.
//
// Stop a job that is in progress, for an Amplify branch, part of Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation StopJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Exception thrown when a resource could not be created because of service
//   limits.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/StopJob
func (c *Amplify) StopJob(input *StopJobInput) (*StopJobOutput, error) {
	req, out := c.StopJobRequest(input)
	return out, req.Send()
}

// StopJobWithContext is the same as StopJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) StopJobWithContext(ctx aws.Context, input *StopJobInput, opts ...request.Option) (*StopJobOutput, error) {
	req, out := c.StopJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApp for more information on using the UpdateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppRequest method.
//    req, resp := client.UpdateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateApp
func (c *Amplify) UpdateAppRequest(input *UpdateAppInput) (req *request.Request, output *UpdateAppOutput) {
	op := &request.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	output = &UpdateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApp API operation for AWS Amplify.
//
// Updates an existing Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation UpdateApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateApp
func (c *Amplify) UpdateApp(input *UpdateAppInput) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	return out, req.Send()
}

// UpdateAppWithContext is the same as UpdateApp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) UpdateAppWithContext(ctx aws.Context, input *UpdateAppInput, opts ...request.Option) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBranch = "UpdateBranch"

// UpdateBranchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBranch for more information on using the UpdateBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBranchRequest method.
//    req, resp := client.UpdateBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateBranch
func (c *Amplify) UpdateBranchRequest(input *UpdateBranchInput) (req *request.Request, output *UpdateBranchOutput) {
	op := &request.Operation{
		Name:       opUpdateBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/branches/{branchName}",
	}

	if input == nil {
		input = &UpdateBranchInput{}
	}

	output = &UpdateBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBranch API operation for AWS Amplify.
//
// Updates a branch for an Amplify App.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation UpdateBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateBranch
func (c *Amplify) UpdateBranch(input *UpdateBranchInput) (*UpdateBranchOutput, error) {
	req, out := c.UpdateBranchRequest(input)
	return out, req.Send()
}

// UpdateBranchWithContext is the same as UpdateBranch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) UpdateBranchWithContext(ctx aws.Context, input *UpdateBranchInput, opts ...request.Option) (*UpdateBranchOutput, error) {
	req, out := c.UpdateBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainAssociation = "UpdateDomainAssociation"

// UpdateDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainAssociation for more information on using the UpdateDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainAssociationRequest method.
//    req, resp := client.UpdateDomainAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateDomainAssociation
func (c *Amplify) UpdateDomainAssociationRequest(input *UpdateDomainAssociationInput) (req *request.Request, output *UpdateDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/apps/{appId}/domains/{domainName}",
	}

	if input == nil {
		input = &UpdateDomainAssociationInput{}
	}

	output = &UpdateDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainAssociation API operation for AWS Amplify.
//
// Create a new DomainAssociation on an App
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Amplify's
// API operation UpdateDomainAssociation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Exception thrown when a request contains unexpected data.
//
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   Exception thrown when an operation fails due to a lack of access.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Exception thrown when an entity has not been found during an operation.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   Exception thrown when the service fails to perform an operation due to an
//   internal issue.
//
//   * ErrCodeDependentServiceFailureException "DependentServiceFailureException"
//   Exception thrown when an operation fails due to a dependent service throwing
//   an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/UpdateDomainAssociation
func (c *Amplify) UpdateDomainAssociation(input *UpdateDomainAssociationInput) (*UpdateDomainAssociationOutput, error) {
	req, out := c.UpdateDomainAssociationRequest(input)
	return out, req.Send()
}

// UpdateDomainAssociationWithContext is the same as UpdateDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Amplify) UpdateDomainAssociationWithContext(ctx aws.Context, input *UpdateDomainAssociationInput, opts ...request.Option) (*UpdateDomainAssociationOutput, error) {
	req, out := c.UpdateDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Amplify App represents different branches of a repository for building, deploying,
// and hosting.
type App struct {
	_ struct{} `type:"structure"`

	// ARN for the Amplify App.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// Unique Id for the Amplify App.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" min:"1" type:"string" required:"true"`

	// Basic Authorization credentials for branches for the Amplify App.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// BuildSpec content for Amplify App.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Create date / time for the Amplify App.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// Custom redirect / rewrite rules for the Amplify App.
	CustomRules []*CustomRule `locationName:"customRules" type:"list"`

	// Default domain for the Amplify App.
	//
	// DefaultDomain is a required field
	DefaultDomain *string `locationName:"defaultDomain" min:"1" type:"string" required:"true"`

	// Description for the Amplify App.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Enables Basic Authorization for branches for the Amplify App.
	//
	// EnableBasicAuth is a required field
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean" required:"true"`

	// Enables auto-building of branches for the Amplify App.
	//
	// EnableBranchAutoBuild is a required field
	EnableBranchAutoBuild *bool `locationName:"enableBranchAutoBuild" type:"boolean" required:"true"`

	// Environment Variables for the Amplify App.
	//
	// EnvironmentVariables is a required field
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map" required:"true"`

	// IAM service role ARN for the Amplify App.
	IamServiceRoleArn *string `locationName:"iamServiceRoleArn" min:"1" type:"string"`

	// Name for the Amplify App.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Platform for the Amplify App.
	//
	// Platform is a required field
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"Platform"`

	// Structure with Production Branch information.
	ProductionBranch *ProductionBranch `locationName:"productionBranch" type:"structure"`

	// Repository for the Amplify App.
	//
	// Repository is a required field
	Repository *string `locationName:"repository" type:"string" required:"true"`

	// Tag for Amplify App.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Update date / time for the Amplify App.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s App) GoString() string {
	return s.String()
}

// SetAppArn sets the AppArn field's value.
func (s *App) SetAppArn(v string) *App {
	s.AppArn = &v
	return s
}

// SetAppId sets the AppId field's value.
func (s *App) SetAppId(v string) *App {
	s.AppId = &v
	return s
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *App) SetBasicAuthCredentials(v string) *App {
	s.BasicAuthCredentials = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *App) SetBuildSpec(v string) *App {
	s.BuildSpec = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *App) SetCreateTime(v time.Time) *App {
	s.CreateTime = &v
	return s
}

// SetCustomRules sets the CustomRules field's value.
func (s *App) SetCustomRules(v []*CustomRule) *App {
	s.CustomRules = v
	return s
}

// SetDefaultDomain sets the DefaultDomain field's value.
func (s *App) SetDefaultDomain(v string) *App {
	s.DefaultDomain = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *App) SetDescription(v string) *App {
	s.Description = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *App) SetEnableBasicAuth(v bool) *App {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableBranchAutoBuild sets the EnableBranchAutoBuild field's value.
func (s *App) SetEnableBranchAutoBuild(v bool) *App {
	s.EnableBranchAutoBuild = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *App) SetEnvironmentVariables(v map[string]*string) *App {
	s.EnvironmentVariables = v
	return s
}

// SetIamServiceRoleArn sets the IamServiceRoleArn field's value.
func (s *App) SetIamServiceRoleArn(v string) *App {
	s.IamServiceRoleArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *App) SetName(v string) *App {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *App) SetPlatform(v string) *App {
	s.Platform = &v
	return s
}

// SetProductionBranch sets the ProductionBranch field's value.
func (s *App) SetProductionBranch(v *ProductionBranch) *App {
	s.ProductionBranch = v
	return s
}

// SetRepository sets the Repository field's value.
func (s *App) SetRepository(v string) *App {
	s.Repository = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *App) SetTags(v map[string]*string) *App {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *App) SetUpdateTime(v time.Time) *App {
	s.UpdateTime = &v
	return s
}

// Branch for an Amplify App, which maps to a 3rd party repository branch.
type Branch struct {
	_ struct{} `type:"structure"`

	// Id of the active job for a branch, part of an Amplify App.
	//
	// ActiveJobId is a required field
	ActiveJobId *string `locationName:"activeJobId" type:"string" required:"true"`

	// Basic Authorization credentials for a branch, part of an Amplify App.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// ARN for a branch, part of an Amplify App.
	//
	// BranchArn is a required field
	BranchArn *string `locationName:"branchArn" type:"string" required:"true"`

	// Name for a branch, part of an Amplify App.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// BuildSpec content for branch for Amplify App.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Creation date and time for a branch, part of an Amplify App.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// Custom domains for a branch, part of an Amplify App.
	//
	// CustomDomains is a required field
	CustomDomains []*string `locationName:"customDomains" type:"list" required:"true"`

	// Description for a branch, part of an Amplify App.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Display name for a branch, part of an Amplify App.
	DisplayName *string `locationName:"displayName" type:"string"`

	// Enables auto-building on push for a branch, part of an Amplify App.
	//
	// EnableAutoBuild is a required field
	EnableAutoBuild *bool `locationName:"enableAutoBuild" type:"boolean" required:"true"`

	// Enables Basic Authorization for a branch, part of an Amplify App.
	//
	// EnableBasicAuth is a required field
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean" required:"true"`

	// Enables notifications for a branch, part of an Amplify App.
	//
	// EnableNotification is a required field
	EnableNotification *bool `locationName:"enableNotification" type:"boolean" required:"true"`

	// Environment Variables specific to a branch, part of an Amplify App.
	//
	// EnvironmentVariables is a required field
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map" required:"true"`

	// Framework for a branch, part of an Amplify App.
	//
	// Framework is a required field
	Framework *string `locationName:"framework" type:"string" required:"true"`

	// Stage for a branch, part of an Amplify App.
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true" enum:"Stage"`

	// Tag for branch for Amplify App.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Thumbnail Url for the branch.
	ThumbnailUrl *string `locationName:"thumbnailUrl" min:"1" type:"string"`

	// Total number of Jobs part of an Amplify App.
	//
	// TotalNumberOfJobs is a required field
	TotalNumberOfJobs *string `locationName:"totalNumberOfJobs" type:"string" required:"true"`

	// The content TTL for the website in seconds.
	//
	// Ttl is a required field
	Ttl *string `locationName:"ttl" type:"string" required:"true"`

	// Last updated date and time for a branch, part of an Amplify App.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Branch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Branch) GoString() string {
	return s.String()
}

// SetActiveJobId sets the ActiveJobId field's value.
func (s *Branch) SetActiveJobId(v string) *Branch {
	s.ActiveJobId = &v
	return s
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *Branch) SetBasicAuthCredentials(v string) *Branch {
	s.BasicAuthCredentials = &v
	return s
}

// SetBranchArn sets the BranchArn field's value.
func (s *Branch) SetBranchArn(v string) *Branch {
	s.BranchArn = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *Branch) SetBranchName(v string) *Branch {
	s.BranchName = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *Branch) SetBuildSpec(v string) *Branch {
	s.BuildSpec = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Branch) SetCreateTime(v time.Time) *Branch {
	s.CreateTime = &v
	return s
}

// SetCustomDomains sets the CustomDomains field's value.
func (s *Branch) SetCustomDomains(v []*string) *Branch {
	s.CustomDomains = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Branch) SetDescription(v string) *Branch {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Branch) SetDisplayName(v string) *Branch {
	s.DisplayName = &v
	return s
}

// SetEnableAutoBuild sets the EnableAutoBuild field's value.
func (s *Branch) SetEnableAutoBuild(v bool) *Branch {
	s.EnableAutoBuild = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *Branch) SetEnableBasicAuth(v bool) *Branch {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableNotification sets the EnableNotification field's value.
func (s *Branch) SetEnableNotification(v bool) *Branch {
	s.EnableNotification = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *Branch) SetEnvironmentVariables(v map[string]*string) *Branch {
	s.EnvironmentVariables = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *Branch) SetFramework(v string) *Branch {
	s.Framework = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *Branch) SetStage(v string) *Branch {
	s.Stage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Branch) SetTags(v map[string]*string) *Branch {
	s.Tags = v
	return s
}

// SetThumbnailUrl sets the ThumbnailUrl field's value.
func (s *Branch) SetThumbnailUrl(v string) *Branch {
	s.ThumbnailUrl = &v
	return s
}

// SetTotalNumberOfJobs sets the TotalNumberOfJobs field's value.
func (s *Branch) SetTotalNumberOfJobs(v string) *Branch {
	s.TotalNumberOfJobs = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *Branch) SetTtl(v string) *Branch {
	s.Ttl = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *Branch) SetUpdateTime(v time.Time) *Branch {
	s.UpdateTime = &v
	return s
}

// Request structure used to create Apps in Amplify.
type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// Credentials for Basic Authorization for an Amplify App.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// BuildSpec for an Amplify App
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Custom rewrite / redirect rules for an Amplify App.
	CustomRules []*CustomRule `locationName:"customRules" type:"list"`

	// Description for an Amplify App
	Description *string `locationName:"description" type:"string"`

	// Enable Basic Authorization for an Amplify App, this will apply to all branches
	// part of this App.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enable the auto building of branches for an Amplify App.
	EnableBranchAutoBuild *bool `locationName:"enableBranchAutoBuild" type:"boolean"`

	// Environment variables map for an Amplify App.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// AWS IAM service role for an Amplify App
	IamServiceRoleArn *string `locationName:"iamServiceRoleArn" min:"1" type:"string"`

	// Name for the Amplify App
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// OAuth token for 3rd party source control system for an Amplify App, used
	// to create webhook and read-only deploy key. OAuth token is not stored.
	//
	// OauthToken is a required field
	OauthToken *string `locationName:"oauthToken" type:"string" required:"true"`

	// Platform / framework for an Amplify App
	//
	// Platform is a required field
	Platform *string `locationName:"platform" type:"string" required:"true" enum:"Platform"`

	// Repository for an Amplify App
	//
	// Repository is a required field
	Repository *string `locationName:"repository" type:"string" required:"true"`

	// Tag for an Amplify App
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BuildSpec", 1))
	}
	if s.IamServiceRoleArn != nil && len(*s.IamServiceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamServiceRoleArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OauthToken == nil {
		invalidParams.Add(request.NewErrParamRequired("OauthToken"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.Repository == nil {
		invalidParams.Add(request.NewErrParamRequired("Repository"))
	}
	if s.CustomRules != nil {
		for i, v := range s.CustomRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *CreateAppInput) SetBasicAuthCredentials(v string) *CreateAppInput {
	s.BasicAuthCredentials = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *CreateAppInput) SetBuildSpec(v string) *CreateAppInput {
	s.BuildSpec = &v
	return s
}

// SetCustomRules sets the CustomRules field's value.
func (s *CreateAppInput) SetCustomRules(v []*CustomRule) *CreateAppInput {
	s.CustomRules = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAppInput) SetDescription(v string) *CreateAppInput {
	s.Description = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *CreateAppInput) SetEnableBasicAuth(v bool) *CreateAppInput {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableBranchAutoBuild sets the EnableBranchAutoBuild field's value.
func (s *CreateAppInput) SetEnableBranchAutoBuild(v bool) *CreateAppInput {
	s.EnableBranchAutoBuild = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *CreateAppInput) SetEnvironmentVariables(v map[string]*string) *CreateAppInput {
	s.EnvironmentVariables = v
	return s
}

// SetIamServiceRoleArn sets the IamServiceRoleArn field's value.
func (s *CreateAppInput) SetIamServiceRoleArn(v string) *CreateAppInput {
	s.IamServiceRoleArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInput) SetName(v string) *CreateAppInput {
	s.Name = &v
	return s
}

// SetOauthToken sets the OauthToken field's value.
func (s *CreateAppInput) SetOauthToken(v string) *CreateAppInput {
	s.OauthToken = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CreateAppInput) SetPlatform(v string) *CreateAppInput {
	s.Platform = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *CreateAppInput) SetRepository(v string) *CreateAppInput {
	s.Repository = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAppInput) SetTags(v map[string]*string) *CreateAppInput {
	s.Tags = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// Amplify App represents different branches of a repository for building, deploying,
	// and hosting.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *CreateAppOutput) SetApp(v *App) *CreateAppOutput {
	s.App = v
	return s
}

// Request structure for a branch create request.
type CreateBranchInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Basic Authorization credentials for the branch.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// Name for the branch.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// BuildSpec for the branch.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Description for the branch.
	Description *string `locationName:"description" type:"string"`

	// Enables auto building for the branch.
	EnableAutoBuild *bool `locationName:"enableAutoBuild" type:"boolean"`

	// Enables Basic Auth for the branch.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enables notifications for the branch.
	EnableNotification *bool `locationName:"enableNotification" type:"boolean"`

	// Environment Variables for the branch.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// Framework for the branch.
	Framework *string `locationName:"framework" type:"string"`

	// Stage for the branch.
	Stage *string `locationName:"stage" type:"string" enum:"Stage"`

	// Tag for the branch.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The content TTL for the website in seconds.
	Ttl *string `locationName:"ttl" type:"string"`
}

// String returns the string representation
func (s CreateBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBranchInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BuildSpec", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBranchInput) SetAppId(v string) *CreateBranchInput {
	s.AppId = &v
	return s
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *CreateBranchInput) SetBasicAuthCredentials(v string) *CreateBranchInput {
	s.BasicAuthCredentials = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *CreateBranchInput) SetBranchName(v string) *CreateBranchInput {
	s.BranchName = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *CreateBranchInput) SetBuildSpec(v string) *CreateBranchInput {
	s.BuildSpec = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBranchInput) SetDescription(v string) *CreateBranchInput {
	s.Description = &v
	return s
}

// SetEnableAutoBuild sets the EnableAutoBuild field's value.
func (s *CreateBranchInput) SetEnableAutoBuild(v bool) *CreateBranchInput {
	s.EnableAutoBuild = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *CreateBranchInput) SetEnableBasicAuth(v bool) *CreateBranchInput {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableNotification sets the EnableNotification field's value.
func (s *CreateBranchInput) SetEnableNotification(v bool) *CreateBranchInput {
	s.EnableNotification = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *CreateBranchInput) SetEnvironmentVariables(v map[string]*string) *CreateBranchInput {
	s.EnvironmentVariables = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *CreateBranchInput) SetFramework(v string) *CreateBranchInput {
	s.Framework = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateBranchInput) SetStage(v string) *CreateBranchInput {
	s.Stage = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBranchInput) SetTags(v map[string]*string) *CreateBranchInput {
	s.Tags = v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CreateBranchInput) SetTtl(v string) *CreateBranchInput {
	s.Ttl = &v
	return s
}

// Result structure for create branch request.
type CreateBranchOutput struct {
	_ struct{} `type:"structure"`

	// Branch structure for an Amplify App.
	//
	// Branch is a required field
	Branch *Branch `locationName:"branch" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *CreateBranchOutput) SetBranch(v *Branch) *CreateBranchOutput {
	s.Branch = v
	return s
}

// Request structure for create Domain Association request.
type CreateDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Domain name for the Domain Association.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// Enables automated creation of Subdomains for branches.
	EnableAutoSubDomain *bool `locationName:"enableAutoSubDomain" type:"boolean"`

	// Setting structure for the Subdomain.
	//
	// SubDomainSettings is a required field
	SubDomainSettings []*SubDomainSetting `locationName:"subDomainSettings" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainAssociationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.SubDomainSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("SubDomainSettings"))
	}
	if s.SubDomainSettings != nil {
		for i, v := range s.SubDomainSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubDomainSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateDomainAssociationInput) SetAppId(v string) *CreateDomainAssociationInput {
	s.AppId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainAssociationInput) SetDomainName(v string) *CreateDomainAssociationInput {
	s.DomainName = &v
	return s
}

// SetEnableAutoSubDomain sets the EnableAutoSubDomain field's value.
func (s *CreateDomainAssociationInput) SetEnableAutoSubDomain(v bool) *CreateDomainAssociationInput {
	s.EnableAutoSubDomain = &v
	return s
}

// SetSubDomainSettings sets the SubDomainSettings field's value.
func (s *CreateDomainAssociationInput) SetSubDomainSettings(v []*SubDomainSetting) *CreateDomainAssociationInput {
	s.SubDomainSettings = v
	return s
}

// Result structure for the create Domain Association request.
type CreateDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Domain Association structure.
	//
	// DomainAssociation is a required field
	DomainAssociation *DomainAssociation `locationName:"domainAssociation" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetDomainAssociation sets the DomainAssociation field's value.
func (s *CreateDomainAssociationOutput) SetDomainAssociation(v *DomainAssociation) *CreateDomainAssociationOutput {
	s.DomainAssociation = v
	return s
}

// Custom rewrite / redirect rule.
type CustomRule struct {
	_ struct{} `type:"structure"`

	// The condition for a URL rewrite or redirect rule, e.g. country code.
	Condition *string `locationName:"condition" min:"1" type:"string"`

	// The source pattern for a URL rewrite or redirect rule.
	//
	// Source is a required field
	Source *string `locationName:"source" min:"1" type:"string" required:"true"`

	// The status code for a URL rewrite or redirect rule.
	Status *string `locationName:"status" min:"3" type:"string"`

	// The target pattern for a URL rewrite or redirect rule.
	//
	// Target is a required field
	Target *string `locationName:"target" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomRule"}
	if s.Condition != nil && len(*s.Condition) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Condition", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Status != nil && len(*s.Status) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Status", 3))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *CustomRule) SetCondition(v string) *CustomRule {
	s.Condition = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CustomRule) SetSource(v string) *CustomRule {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CustomRule) SetStatus(v string) *CustomRule {
	s.Status = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CustomRule) SetTarget(v string) *CustomRule {
	s.Target = &v
	return s
}

// Request structure for an Amplify App delete request.
type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppInput) SetAppId(v string) *DeleteAppInput {
	s.AppId = &v
	return s
}

// Result structure for an Amplify App delete request.
type DeleteAppOutput struct {
	_ struct{} `type:"structure"`

	// Amplify App represents different branches of a repository for building, deploying,
	// and hosting.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *DeleteAppOutput) SetApp(v *App) *DeleteAppOutput {
	s.App = v
	return s
}

// Request structure for delete branch request.
type DeleteBranchInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBranchInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteBranchInput) SetAppId(v string) *DeleteBranchInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *DeleteBranchInput) SetBranchName(v string) *DeleteBranchInput {
	s.BranchName = &v
	return s
}

// Result structure for delete branch request.
type DeleteBranchOutput struct {
	_ struct{} `type:"structure"`

	// Branch structure for an Amplify App.
	//
	// Branch is a required field
	Branch *Branch `locationName:"branch" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *DeleteBranchOutput) SetBranch(v *Branch) *DeleteBranchOutput {
	s.Branch = v
	return s
}

// Request structure for the delete Domain Association request.
type DeleteDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainAssociationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteDomainAssociationInput) SetAppId(v string) *DeleteDomainAssociationInput {
	s.AppId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainAssociationInput) SetDomainName(v string) *DeleteDomainAssociationInput {
	s.DomainName = &v
	return s
}

type DeleteDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Structure for Domain Association, which associates a custom domain with an
	// Amplify App.
	//
	// DomainAssociation is a required field
	DomainAssociation *DomainAssociation `locationName:"domainAssociation" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetDomainAssociation sets the DomainAssociation field's value.
func (s *DeleteDomainAssociationOutput) SetDomainAssociation(v *DomainAssociation) *DeleteDomainAssociationOutput {
	s.DomainAssociation = v
	return s
}

// Request structure for delete job request.
type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch, for the Job.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Unique Id for the Job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteJobInput) SetAppId(v string) *DeleteJobInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *DeleteJobInput) SetBranchName(v string) *DeleteJobInput {
	s.BranchName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteJobInput) SetJobId(v string) *DeleteJobInput {
	s.JobId = &v
	return s
}

// Result structure for the delete job request.
type DeleteJobOutput struct {
	_ struct{} `type:"structure"`

	// Structure for the summary of a Job.
	//
	// JobSummary is a required field
	JobSummary *JobSummary `locationName:"jobSummary" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

// SetJobSummary sets the JobSummary field's value.
func (s *DeleteJobOutput) SetJobSummary(v *JobSummary) *DeleteJobOutput {
	s.JobSummary = v
	return s
}

// Structure for Domain Association, which associates a custom domain with an
// Amplify App.
type DomainAssociation struct {
	_ struct{} `type:"structure"`

	// DNS Record for certificate verification.
	//
	// CertificateVerificationDNSRecord is a required field
	CertificateVerificationDNSRecord *string `locationName:"certificateVerificationDNSRecord" type:"string" required:"true"`

	// ARN for the Domain Association.
	//
	// DomainAssociationArn is a required field
	DomainAssociationArn *string `locationName:"domainAssociationArn" type:"string" required:"true"`

	// Name of the domain.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// Status fo the Domain Association.
	//
	// DomainStatus is a required field
	DomainStatus *string `locationName:"domainStatus" type:"string" required:"true" enum:"DomainStatus"`

	// Enables automated creation of Subdomains for branches.
	//
	// EnableAutoSubDomain is a required field
	EnableAutoSubDomain *bool `locationName:"enableAutoSubDomain" type:"boolean" required:"true"`

	// Reason for the current status of the Domain Association.
	//
	// StatusReason is a required field
	StatusReason *string `locationName:"statusReason" type:"string" required:"true"`

	// Subdomains for the Domain Association.
	//
	// SubDomains is a required field
	SubDomains []*SubDomain `locationName:"subDomains" type:"list" required:"true"`
}

// String returns the string representation
func (s DomainAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainAssociation) GoString() string {
	return s.String()
}

// SetCertificateVerificationDNSRecord sets the CertificateVerificationDNSRecord field's value.
func (s *DomainAssociation) SetCertificateVerificationDNSRecord(v string) *DomainAssociation {
	s.CertificateVerificationDNSRecord = &v
	return s
}

// SetDomainAssociationArn sets the DomainAssociationArn field's value.
func (s *DomainAssociation) SetDomainAssociationArn(v string) *DomainAssociation {
	s.DomainAssociationArn = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainAssociation) SetDomainName(v string) *DomainAssociation {
	s.DomainName = &v
	return s
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DomainAssociation) SetDomainStatus(v string) *DomainAssociation {
	s.DomainStatus = &v
	return s
}

// SetEnableAutoSubDomain sets the EnableAutoSubDomain field's value.
func (s *DomainAssociation) SetEnableAutoSubDomain(v bool) *DomainAssociation {
	s.EnableAutoSubDomain = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DomainAssociation) SetStatusReason(v string) *DomainAssociation {
	s.StatusReason = &v
	return s
}

// SetSubDomains sets the SubDomains field's value.
func (s *DomainAssociation) SetSubDomains(v []*SubDomain) *DomainAssociation {
	s.SubDomains = v
	return s
}

// Request structure for get App request.
type GetAppInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetAppInput) SetAppId(v string) *GetAppInput {
	s.AppId = &v
	return s
}

type GetAppOutput struct {
	_ struct{} `type:"structure"`

	// Amplify App represents different branches of a repository for building, deploying,
	// and hosting.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *GetAppOutput) SetApp(v *App) *GetAppOutput {
	s.App = v
	return s
}

// Result structure for get branch request.
type GetBranchInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBranchInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBranchInput) SetAppId(v string) *GetBranchInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *GetBranchInput) SetBranchName(v string) *GetBranchInput {
	s.BranchName = &v
	return s
}

type GetBranchOutput struct {
	_ struct{} `type:"structure"`

	// Branch for an Amplify App, which maps to a 3rd party repository branch.
	//
	// Branch is a required field
	Branch *Branch `locationName:"branch" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *GetBranchOutput) SetBranch(v *Branch) *GetBranchOutput {
	s.Branch = v
	return s
}

// Request structure for the get Domain Association request.
type GetDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainAssociationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetDomainAssociationInput) SetAppId(v string) *GetDomainAssociationInput {
	s.AppId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainAssociationInput) SetDomainName(v string) *GetDomainAssociationInput {
	s.DomainName = &v
	return s
}

// Result structure for the get Domain Association request.
type GetDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Domain Association structure.
	//
	// DomainAssociation is a required field
	DomainAssociation *DomainAssociation `locationName:"domainAssociation" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetDomainAssociation sets the DomainAssociation field's value.
func (s *GetDomainAssociationOutput) SetDomainAssociation(v *DomainAssociation) *GetDomainAssociationOutput {
	s.DomainAssociation = v
	return s
}

// Request structure for get job request.
type GetJobInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch, for the Job.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Unique Id for the Job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetJobInput) SetAppId(v string) *GetJobInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *GetJobInput) SetBranchName(v string) *GetJobInput {
	s.BranchName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobInput) SetJobId(v string) *GetJobInput {
	s.JobId = &v
	return s
}

type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// Structure for an execution job for an Amplify App.
	//
	// Job is a required field
	Job *Job `locationName:"job" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *GetJobOutput) SetJob(v *Job) *GetJobOutput {
	s.Job = v
	return s
}

// Structure for an execution job for an Amplify App.
type Job struct {
	_ struct{} `type:"structure"`

	// Execution steps for an execution job, for an Amplify App.
	//
	// Steps is a required field
	Steps []*Step `locationName:"steps" type:"list" required:"true"`

	// Summary for an execution job for an Amplify App.
	//
	// Summary is a required field
	Summary *JobSummary `locationName:"summary" type:"structure" required:"true"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetSteps sets the Steps field's value.
func (s *Job) SetSteps(v []*Step) *Job {
	s.Steps = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *Job) SetSummary(v *JobSummary) *Job {
	s.Summary = v
	return s
}

// Structure for the summary of a Job.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// Commit Id from 3rd party repository provider for the Job.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// Commit message from 3rd party repository provider for the Job.
	//
	// CommitMessage is a required field
	CommitMessage *string `locationName:"commitMessage" type:"string" required:"true"`

	// Commit date / time for the Job.
	//
	// CommitTime is a required field
	CommitTime *time.Time `locationName:"commitTime" type:"timestamp" required:"true"`

	// End date / time for the Job.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Arn for the Job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// Unique Id for the Job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// Type for the Job.
	//
	// JobType is a required field
	JobType *string `locationName:"jobType" type:"string" required:"true" enum:"JobType"`

	// Start date / time for the Job.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// Status for the Job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobSummary) GoString() string {
	return s.String()
}

// SetCommitId sets the CommitId field's value.
func (s *JobSummary) SetCommitId(v string) *JobSummary {
	s.CommitId = &v
	return s
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *JobSummary) SetCommitMessage(v string) *JobSummary {
	s.CommitMessage = &v
	return s
}

// SetCommitTime sets the CommitTime field's value.
func (s *JobSummary) SetCommitTime(v time.Time) *JobSummary {
	s.CommitTime = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *JobSummary) SetEndTime(v time.Time) *JobSummary {
	s.EndTime = &v
	return s
}

// SetJobArn sets the JobArn field's value.
func (s *JobSummary) SetJobArn(v string) *JobSummary {
	s.JobArn = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobSummary) SetJobType(v string) *JobSummary {
	s.JobType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *JobSummary) SetStartTime(v time.Time) *JobSummary {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobSummary) SetStatus(v string) *JobSummary {
	s.Status = &v
	return s
}

// Request structure for an Amplify App list request.
type ListAppsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAppsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAppsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAppsInput) SetMaxResults(v int64) *ListAppsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsInput) SetNextToken(v string) *ListAppsInput {
	s.NextToken = &v
	return s
}

// Result structure for an Amplify App list request.
type ListAppsOutput struct {
	_ struct{} `type:"structure"`

	// List of Amplify Apps.
	//
	// Apps is a required field
	Apps []*App `locationName:"apps" type:"list" required:"true"`

	// Pagination token. Set to null to start listing Apps from start. If non-null
	// pagination token is returned in a result, then pass its value in here to
	// list more projects.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAppsOutput) GoString() string {
	return s.String()
}

// SetApps sets the Apps field's value.
func (s *ListAppsOutput) SetApps(v []*App) *ListAppsOutput {
	s.Apps = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAppsOutput) SetNextToken(v string) *ListAppsOutput {
	s.NextToken = &v
	return s
}

// Request structure for list branches request.
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token. Set to null to start listing branches from start. If a
	// non-null pagination token is returned in a result, then pass its value in
	// here to list more branches.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBranchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBranchesInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListBranchesInput) SetAppId(v string) *ListBranchesInput {
	s.AppId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBranchesInput) SetMaxResults(v int64) *ListBranchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesInput) SetNextToken(v string) *ListBranchesInput {
	s.NextToken = &v
	return s
}

// Result structure for list branches request.
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// List of branches for an Amplify App.
	//
	// Branches is a required field
	Branches []*Branch `locationName:"branches" type:"list" required:"true"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesOutput) GoString() string {
	return s.String()
}

// SetBranches sets the Branches field's value.
func (s *ListBranchesOutput) SetBranches(v []*Branch) *ListBranchesOutput {
	s.Branches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesOutput) SetNextToken(v string) *ListBranchesOutput {
	s.NextToken = &v
	return s
}

// Request structure for the list Domain Associations request.
type ListDomainAssociationsInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token. Set to null to start listing Apps from start. If non-null
	// pagination token is returned in a result, then pass its value in here to
	// list more projects.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDomainAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainAssociationsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListDomainAssociationsInput) SetAppId(v string) *ListDomainAssociationsInput {
	s.AppId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainAssociationsInput) SetMaxResults(v int64) *ListDomainAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainAssociationsInput) SetNextToken(v string) *ListDomainAssociationsInput {
	s.NextToken = &v
	return s
}

// Result structure for the list Domain Association request.
type ListDomainAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// List of Domain Associations.
	//
	// DomainAssociations is a required field
	DomainAssociations []*DomainAssociation `locationName:"domainAssociations" type:"list" required:"true"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDomainAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainAssociationsOutput) GoString() string {
	return s.String()
}

// SetDomainAssociations sets the DomainAssociations field's value.
func (s *ListDomainAssociationsOutput) SetDomainAssociations(v []*DomainAssociation) *ListDomainAssociationsOutput {
	s.DomainAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainAssociationsOutput) SetNextToken(v string) *ListDomainAssociationsOutput {
	s.NextToken = &v
	return s
}

// Request structure for list job request.
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for a branch.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Maximum number of records to list in a single response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token. Set to null to start listing steps from start. If a non-null
	// pagination token is returned in a result, then pass its value in here to
	// list more steps.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListJobsInput) SetAppId(v string) *ListJobsInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *ListJobsInput) SetBranchName(v string) *ListJobsInput {
	s.BranchName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// Maximum number of records to list in a single response.
type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Result structure for list job result request.
	//
	// JobSummaries is a required field
	JobSummaries []*JobSummary `locationName:"jobSummaries" type:"list" required:"true"`

	// Pagination token. If non-null pagination token is returned in a result, then
	// pass its value in another request to fetch more entries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaries sets the JobSummaries field's value.
func (s *ListJobsOutput) SetJobSummaries(v []*JobSummary) *ListJobsOutput {
	s.JobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// Structure with Production Branch information.
type ProductionBranch struct {
	_ struct{} `type:"structure"`

	// Branch Name for Production Branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// Last Deploy Time of Production Branch.
	LastDeployTime *time.Time `locationName:"lastDeployTime" type:"timestamp"`

	// Status of Production Branch.
	Status *string `locationName:"status" min:"3" type:"string"`

	// Thumbnail Url for Production Branch.
	ThumbnailUrl *string `locationName:"thumbnailUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ProductionBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProductionBranch) GoString() string {
	return s.String()
}

// SetBranchName sets the BranchName field's value.
func (s *ProductionBranch) SetBranchName(v string) *ProductionBranch {
	s.BranchName = &v
	return s
}

// SetLastDeployTime sets the LastDeployTime field's value.
func (s *ProductionBranch) SetLastDeployTime(v time.Time) *ProductionBranch {
	s.LastDeployTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProductionBranch) SetStatus(v string) *ProductionBranch {
	s.Status = &v
	return s
}

// SetThumbnailUrl sets the ThumbnailUrl field's value.
func (s *ProductionBranch) SetThumbnailUrl(v string) *ProductionBranch {
	s.ThumbnailUrl = &v
	return s
}

// Request structure for Start job request.
type StartJobInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch, for the Job.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Commit Id from 3rd party repository provider for the Job.
	CommitId *string `locationName:"commitId" type:"string"`

	// Commit message from 3rd party repository provider for the Job.
	CommitMessage *string `locationName:"commitMessage" type:"string"`

	// Commit date / time for the Job.
	CommitTime *time.Time `locationName:"commitTime" type:"timestamp"`

	// Unique Id for the Job.
	JobId *string `locationName:"jobId" type:"string"`

	// Reason for the Job.
	JobReason *string `locationName:"jobReason" type:"string"`

	// Type for the Job.
	//
	// JobType is a required field
	JobType *string `locationName:"jobType" type:"string" required:"true" enum:"JobType"`
}

// String returns the string representation
func (s StartJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *StartJobInput) SetAppId(v string) *StartJobInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *StartJobInput) SetBranchName(v string) *StartJobInput {
	s.BranchName = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *StartJobInput) SetCommitId(v string) *StartJobInput {
	s.CommitId = &v
	return s
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *StartJobInput) SetCommitMessage(v string) *StartJobInput {
	s.CommitMessage = &v
	return s
}

// SetCommitTime sets the CommitTime field's value.
func (s *StartJobInput) SetCommitTime(v time.Time) *StartJobInput {
	s.CommitTime = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartJobInput) SetJobId(v string) *StartJobInput {
	s.JobId = &v
	return s
}

// SetJobReason sets the JobReason field's value.
func (s *StartJobInput) SetJobReason(v string) *StartJobInput {
	s.JobReason = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *StartJobInput) SetJobType(v string) *StartJobInput {
	s.JobType = &v
	return s
}

// Result structure for run job request.
type StartJobOutput struct {
	_ struct{} `type:"structure"`

	// Summary for the Job.
	//
	// JobSummary is a required field
	JobSummary *JobSummary `locationName:"jobSummary" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartJobOutput) GoString() string {
	return s.String()
}

// SetJobSummary sets the JobSummary field's value.
func (s *StartJobOutput) SetJobSummary(v *JobSummary) *StartJobOutput {
	s.JobSummary = v
	return s
}

// Structure for an execution step for an execution job, for an Amplify App.
type Step struct {
	_ struct{} `type:"structure"`

	// Url to teh artifact for the execution step.
	ArtifactsUrl *string `locationName:"artifactsUrl" type:"string"`

	// End date/ time of the execution step.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// Url to the logs for the execution step.
	LogUrl *string `locationName:"logUrl" type:"string"`

	// List of screenshot Urls for the execution step, if relevant.
	Screenshots map[string]*string `locationName:"screenshots" type:"map"`

	// Start date/ time of the execution step.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// Status of the execution step.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"JobStatus"`

	// Name of the execution step.
	//
	// StepName is a required field
	StepName *string `locationName:"stepName" type:"string" required:"true"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Step) GoString() string {
	return s.String()
}

// SetArtifactsUrl sets the ArtifactsUrl field's value.
func (s *Step) SetArtifactsUrl(v string) *Step {
	s.ArtifactsUrl = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *Step) SetEndTime(v time.Time) *Step {
	s.EndTime = &v
	return s
}

// SetLogUrl sets the LogUrl field's value.
func (s *Step) SetLogUrl(v string) *Step {
	s.LogUrl = &v
	return s
}

// SetScreenshots sets the Screenshots field's value.
func (s *Step) SetScreenshots(v map[string]*string) *Step {
	s.Screenshots = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Step) SetStartTime(v time.Time) *Step {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Step) SetStatus(v string) *Step {
	s.Status = &v
	return s
}

// SetStepName sets the StepName field's value.
func (s *Step) SetStepName(v string) *Step {
	s.StepName = &v
	return s
}

// Request structure for stop job request.
type StopJobInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch, for the Job.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Unique Id for the Job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *StopJobInput) SetAppId(v string) *StopJobInput {
	s.AppId = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *StopJobInput) SetBranchName(v string) *StopJobInput {
	s.BranchName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StopJobInput) SetJobId(v string) *StopJobInput {
	s.JobId = &v
	return s
}

// Result structure for the stop job request.
type StopJobOutput struct {
	_ struct{} `type:"structure"`

	// Summary for the Job.
	//
	// JobSummary is a required field
	JobSummary *JobSummary `locationName:"jobSummary" type:"structure" required:"true"`
}

// String returns the string representation
func (s StopJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopJobOutput) GoString() string {
	return s.String()
}

// SetJobSummary sets the JobSummary field's value.
func (s *StopJobOutput) SetJobSummary(v *JobSummary) *StopJobOutput {
	s.JobSummary = v
	return s
}

// Subdomain for the Domain Association.
type SubDomain struct {
	_ struct{} `type:"structure"`

	// DNS record for the Subdomain.
	//
	// DnsRecord is a required field
	DnsRecord *string `locationName:"dnsRecord" type:"string" required:"true"`

	// Setting structure for the Subdomain.
	//
	// SubDomainSetting is a required field
	SubDomainSetting *SubDomainSetting `locationName:"subDomainSetting" type:"structure" required:"true"`

	// Verified status of the Subdomain
	//
	// Verified is a required field
	Verified *bool `locationName:"verified" type:"boolean" required:"true"`
}

// String returns the string representation
func (s SubDomain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubDomain) GoString() string {
	return s.String()
}

// SetDnsRecord sets the DnsRecord field's value.
func (s *SubDomain) SetDnsRecord(v string) *SubDomain {
	s.DnsRecord = &v
	return s
}

// SetSubDomainSetting sets the SubDomainSetting field's value.
func (s *SubDomain) SetSubDomainSetting(v *SubDomainSetting) *SubDomain {
	s.SubDomainSetting = v
	return s
}

// SetVerified sets the Verified field's value.
func (s *SubDomain) SetVerified(v bool) *SubDomain {
	s.Verified = &v
	return s
}

// Setting for the Subdomain.
type SubDomainSetting struct {
	_ struct{} `type:"structure"`

	// Branch name setting for the Subdomain.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// Prefix setting for the Subdomain.
	//
	// Prefix is a required field
	Prefix *string `locationName:"prefix" type:"string" required:"true"`
}

// String returns the string representation
func (s SubDomainSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubDomainSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubDomainSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubDomainSetting"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *SubDomainSetting) SetBranchName(v string) *SubDomainSetting {
	s.BranchName = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *SubDomainSetting) SetPrefix(v string) *SubDomainSetting {
	s.Prefix = &v
	return s
}

// Request structure for update App request.
type UpdateAppInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Basic Authorization credentials for an Amplify App.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// BuildSpec for an Amplify App.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Custom redirect / rewrite rules for an Amplify App.
	CustomRules []*CustomRule `locationName:"customRules" type:"list"`

	// Description for an Amplify App.
	Description *string `locationName:"description" type:"string"`

	// Enables Basic Authorization for an Amplify App.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enables branch auto-building for an Amplify App.
	EnableBranchAutoBuild *bool `locationName:"enableBranchAutoBuild" type:"boolean"`

	// Environment Variables for an Amplify App.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// IAM service role for an Amplify App.
	IamServiceRoleArn *string `locationName:"iamServiceRoleArn" min:"1" type:"string"`

	// Name for an Amplify App.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Platform for an Amplify App.
	Platform *string `locationName:"platform" type:"string" enum:"Platform"`
}

// String returns the string representation
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BuildSpec", 1))
	}
	if s.IamServiceRoleArn != nil && len(*s.IamServiceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamServiceRoleArn", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.CustomRules != nil {
		for i, v := range s.CustomRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateAppInput) SetAppId(v string) *UpdateAppInput {
	s.AppId = &v
	return s
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *UpdateAppInput) SetBasicAuthCredentials(v string) *UpdateAppInput {
	s.BasicAuthCredentials = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *UpdateAppInput) SetBuildSpec(v string) *UpdateAppInput {
	s.BuildSpec = &v
	return s
}

// SetCustomRules sets the CustomRules field's value.
func (s *UpdateAppInput) SetCustomRules(v []*CustomRule) *UpdateAppInput {
	s.CustomRules = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAppInput) SetDescription(v string) *UpdateAppInput {
	s.Description = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *UpdateAppInput) SetEnableBasicAuth(v bool) *UpdateAppInput {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableBranchAutoBuild sets the EnableBranchAutoBuild field's value.
func (s *UpdateAppInput) SetEnableBranchAutoBuild(v bool) *UpdateAppInput {
	s.EnableBranchAutoBuild = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *UpdateAppInput) SetEnvironmentVariables(v map[string]*string) *UpdateAppInput {
	s.EnvironmentVariables = v
	return s
}

// SetIamServiceRoleArn sets the IamServiceRoleArn field's value.
func (s *UpdateAppInput) SetIamServiceRoleArn(v string) *UpdateAppInput {
	s.IamServiceRoleArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInput) SetName(v string) *UpdateAppInput {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *UpdateAppInput) SetPlatform(v string) *UpdateAppInput {
	s.Platform = &v
	return s
}

// Result structure for an Amplify App update request.
type UpdateAppOutput struct {
	_ struct{} `type:"structure"`

	// App structure for the updated App.
	//
	// App is a required field
	App *App `locationName:"app" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppOutput) GoString() string {
	return s.String()
}

// SetApp sets the App field's value.
func (s *UpdateAppOutput) SetApp(v *App) *UpdateAppOutput {
	s.App = v
	return s
}

// Request structure for update branch request.
type UpdateBranchInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Basic Authorization credentials for the branch.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string"`

	// Name for the branch.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// BuildSpec for the branch.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Description for the branch.
	Description *string `locationName:"description" type:"string"`

	// Enables auto building for the branch.
	EnableAutoBuild *bool `locationName:"enableAutoBuild" type:"boolean"`

	// Enables Basic Auth for the branch.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enables notifications for the branch.
	EnableNotification *bool `locationName:"enableNotification" type:"boolean"`

	// Environment Variables for the branch.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// Framework for the branch.
	Framework *string `locationName:"framework" type:"string"`

	// Stage for the branch.
	Stage *string `locationName:"stage" type:"string" enum:"Stage"`

	// The content TTL for the website in seconds.
	Ttl *string `locationName:"ttl" type:"string"`
}

// String returns the string representation
func (s UpdateBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBranchInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BuildSpec", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBranchInput) SetAppId(v string) *UpdateBranchInput {
	s.AppId = &v
	return s
}

// SetBasicAuthCredentials sets the BasicAuthCredentials field's value.
func (s *UpdateBranchInput) SetBasicAuthCredentials(v string) *UpdateBranchInput {
	s.BasicAuthCredentials = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *UpdateBranchInput) SetBranchName(v string) *UpdateBranchInput {
	s.BranchName = &v
	return s
}

// SetBuildSpec sets the BuildSpec field's value.
func (s *UpdateBranchInput) SetBuildSpec(v string) *UpdateBranchInput {
	s.BuildSpec = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateBranchInput) SetDescription(v string) *UpdateBranchInput {
	s.Description = &v
	return s
}

// SetEnableAutoBuild sets the EnableAutoBuild field's value.
func (s *UpdateBranchInput) SetEnableAutoBuild(v bool) *UpdateBranchInput {
	s.EnableAutoBuild = &v
	return s
}

// SetEnableBasicAuth sets the EnableBasicAuth field's value.
func (s *UpdateBranchInput) SetEnableBasicAuth(v bool) *UpdateBranchInput {
	s.EnableBasicAuth = &v
	return s
}

// SetEnableNotification sets the EnableNotification field's value.
func (s *UpdateBranchInput) SetEnableNotification(v bool) *UpdateBranchInput {
	s.EnableNotification = &v
	return s
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *UpdateBranchInput) SetEnvironmentVariables(v map[string]*string) *UpdateBranchInput {
	s.EnvironmentVariables = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *UpdateBranchInput) SetFramework(v string) *UpdateBranchInput {
	s.Framework = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *UpdateBranchInput) SetStage(v string) *UpdateBranchInput {
	s.Stage = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *UpdateBranchInput) SetTtl(v string) *UpdateBranchInput {
	s.Ttl = &v
	return s
}

// Result structure for update branch request.
type UpdateBranchOutput struct {
	_ struct{} `type:"structure"`

	// Branch structure for an Amplify App.
	//
	// Branch is a required field
	Branch *Branch `locationName:"branch" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *UpdateBranchOutput) SetBranch(v *Branch) *UpdateBranchOutput {
	s.Branch = v
	return s
}

// Request structure for update Domain Association request.
type UpdateDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domainName" type:"string" required:"true"`

	// Enables automated creation of Subdomains for branches.
	EnableAutoSubDomain *bool `locationName:"enableAutoSubDomain" type:"boolean"`

	// Setting structure for the Subdomain.
	//
	// SubDomainSettings is a required field
	SubDomainSettings []*SubDomainSetting `locationName:"subDomainSettings" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainAssociationInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.SubDomainSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("SubDomainSettings"))
	}
	if s.SubDomainSettings != nil {
		for i, v := range s.SubDomainSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubDomainSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateDomainAssociationInput) SetAppId(v string) *UpdateDomainAssociationInput {
	s.AppId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainAssociationInput) SetDomainName(v string) *UpdateDomainAssociationInput {
	s.DomainName = &v
	return s
}

// SetEnableAutoSubDomain sets the EnableAutoSubDomain field's value.
func (s *UpdateDomainAssociationInput) SetEnableAutoSubDomain(v bool) *UpdateDomainAssociationInput {
	s.EnableAutoSubDomain = &v
	return s
}

// SetSubDomainSettings sets the SubDomainSettings field's value.
func (s *UpdateDomainAssociationInput) SetSubDomainSettings(v []*SubDomainSetting) *UpdateDomainAssociationInput {
	s.SubDomainSettings = v
	return s
}

// Result structure for the update Domain Association request.
type UpdateDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Domain Association structure.
	//
	// DomainAssociation is a required field
	DomainAssociation *DomainAssociation `locationName:"domainAssociation" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetDomainAssociation sets the DomainAssociation field's value.
func (s *UpdateDomainAssociationOutput) SetDomainAssociation(v *DomainAssociation) *UpdateDomainAssociationOutput {
	s.DomainAssociation = v
	return s
}

const (
	// DomainStatusPendingVerification is a DomainStatus enum value
	DomainStatusPendingVerification = "PENDING_VERIFICATION"

	// DomainStatusInProgress is a DomainStatus enum value
	DomainStatusInProgress = "IN_PROGRESS"

	// DomainStatusAvailable is a DomainStatus enum value
	DomainStatusAvailable = "AVAILABLE"

	// DomainStatusPendingDeployment is a DomainStatus enum value
	DomainStatusPendingDeployment = "PENDING_DEPLOYMENT"

	// DomainStatusFailed is a DomainStatus enum value
	DomainStatusFailed = "FAILED"
)

const (
	// JobStatusPending is a JobStatus enum value
	JobStatusPending = "PENDING"

	// JobStatusProvisioning is a JobStatus enum value
	JobStatusProvisioning = "PROVISIONING"

	// JobStatusRunning is a JobStatus enum value
	JobStatusRunning = "RUNNING"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusSucceed is a JobStatus enum value
	JobStatusSucceed = "SUCCEED"

	// JobStatusCancelling is a JobStatus enum value
	JobStatusCancelling = "CANCELLING"

	// JobStatusCancelled is a JobStatus enum value
	JobStatusCancelled = "CANCELLED"
)

const (
	// JobTypeRelease is a JobType enum value
	JobTypeRelease = "RELEASE"

	// JobTypeRetry is a JobType enum value
	JobTypeRetry = "RETRY"

	// JobTypeWebHook is a JobType enum value
	JobTypeWebHook = "WEB_HOOK"
)

const (
	// PlatformIos is a Platform enum value
	PlatformIos = "IOS"

	// PlatformAndroid is a Platform enum value
	PlatformAndroid = "ANDROID"

	// PlatformWeb is a Platform enum value
	PlatformWeb = "WEB"

	// PlatformReactNative is a Platform enum value
	PlatformReactNative = "REACT_NATIVE"
)

const (
	// StageProduction is a Stage enum value
	StageProduction = "PRODUCTION"

	// StageBeta is a Stage enum value
	StageBeta = "BETA"

	// StageDevelopment is a Stage enum value
	StageDevelopment = "DEVELOPMENT"

	// StageExperimental is a Stage enum value
	StageExperimental = "EXPERIMENTAL"
)
