// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon CloudWatch Events.
//
// Deletes the specified rule.
//
// Before you can delete the rule, you must remove all targets, using RemoveTargets.
//
// When you delete a rule, incoming events might continue to match to the deleted
// rule. Allow a short period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventBus = "DescribeEventBus"

// DescribeEventBusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventBus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventBus for more information on using the DescribeEventBus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventBusRequest method.
//    req, resp := client.DescribeEventBusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventBus
func (c *CloudWatchEvents) DescribeEventBusRequest(input *DescribeEventBusInput) (req *request.Request, output *DescribeEventBusOutput) {
	op := &request.Operation{
		Name:       opDescribeEventBus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventBusInput{}
	}

	output = &DescribeEventBusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventBus API operation for Amazon CloudWatch Events.
//
// Displays the external AWS accounts that are permitted to write events to
// your account using your account's event bus, and the associated policy. To
// enable your account to receive events from other accounts, use PutPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DescribeEventBus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeEventBus
func (c *CloudWatchEvents) DescribeEventBus(input *DescribeEventBusInput) (*DescribeEventBusOutput, error) {
	req, out := c.DescribeEventBusRequest(input)
	return out, req.Send()
}

// DescribeEventBusWithContext is the same as DescribeEventBus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventBus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DescribeEventBusWithContext(ctx aws.Context, input *DescribeEventBusInput, opts ...request.Option) (*DescribeEventBusOutput, error) {
	req, out := c.DescribeEventBusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRule = "DescribeRule"

// DescribeRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRule for more information on using the DescribeRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuleRequest method.
//    req, resp := client.DescribeRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRuleRequest(input *DescribeRuleInput) (req *request.Request, output *DescribeRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleInput{}
	}

	output = &DescribeRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRule API operation for Amazon CloudWatch Events.
//
// Describes the specified rule.
//
// DescribeRule does not list the targets of a rule. To see the targets associated
// with a rule, use ListTargetsByRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DescribeRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRule(input *DescribeRuleInput) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	return out, req.Send()
}

// DescribeRuleWithContext is the same as DescribeRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DescribeRuleWithContext(ctx aws.Context, input *DescribeRuleInput, opts ...request.Option) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableRule = "DisableRule"

// DisableRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableRule for more information on using the DisableRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableRuleRequest method.
//    req, resp := client.DisableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRuleRequest(input *DisableRuleInput) (req *request.Request, output *DisableRuleOutput) {
	op := &request.Operation{
		Name:       opDisableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRuleInput{}
	}

	output = &DisableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableRule API operation for Amazon CloudWatch Events.
//
// Disables the specified rule. A disabled rule won't match any events, and
// won't self-trigger if it has a schedule expression.
//
// When you disable a rule, incoming events might continue to match to the disabled
// rule. Allow a short period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DisableRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRule(input *DisableRuleInput) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	return out, req.Send()
}

// DisableRuleWithContext is the same as DisableRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DisableRuleWithContext(ctx aws.Context, input *DisableRuleInput, opts ...request.Option) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableRule = "EnableRule"

// EnableRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableRule for more information on using the EnableRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableRuleRequest method.
//    req, resp := client.EnableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRuleRequest(input *EnableRuleInput) (req *request.Request, output *EnableRuleOutput) {
	op := &request.Operation{
		Name:       opEnableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRuleInput{}
	}

	output = &EnableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableRule API operation for Amazon CloudWatch Events.
//
// Enables the specified rule. If the rule does not exist, the operation fails.
//
// When you enable a rule, incoming events might not immediately start matching
// to a newly enabled rule. Allow a short period of time for changes to take
// effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation EnableRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRule(input *EnableRuleInput) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	return out, req.Send()
}

// EnableRuleWithContext is the same as EnableRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) EnableRuleWithContext(ctx aws.Context, input *EnableRuleInput, opts ...request.Option) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleNamesByTarget = "ListRuleNamesByTarget"

// ListRuleNamesByTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleNamesByTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleNamesByTarget for more information on using the ListRuleNamesByTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRuleNamesByTargetRequest method.
//    req, resp := client.ListRuleNamesByTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTargetRequest(input *ListRuleNamesByTargetInput) (req *request.Request, output *ListRuleNamesByTargetOutput) {
	op := &request.Operation{
		Name:       opListRuleNamesByTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleNamesByTargetInput{}
	}

	output = &ListRuleNamesByTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleNamesByTarget API operation for Amazon CloudWatch Events.
//
// Lists the rules for the specified target. You can see which of the rules
// in Amazon CloudWatch Events can invoke a specific target in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRuleNamesByTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTarget(input *ListRuleNamesByTargetInput) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	return out, req.Send()
}

// ListRuleNamesByTargetWithContext is the same as ListRuleNamesByTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleNamesByTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListRuleNamesByTargetWithContext(ctx aws.Context, input *ListRuleNamesByTargetInput, opts ...request.Option) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon CloudWatch Events.
//
// Lists your Amazon CloudWatch Events rules. You can either list all the rules
// or you can provide a prefix to match to the rule names.
//
// ListRules does not list the targets of a rule. To see the targets associated
// with a rule, use ListTargetsByRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsByRule = "ListTargetsByRule"

// ListTargetsByRuleRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsByRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTargetsByRule for more information on using the ListTargetsByRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTargetsByRuleRequest method.
//    req, resp := client.ListTargetsByRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRuleRequest(input *ListTargetsByRuleInput) (req *request.Request, output *ListTargetsByRuleOutput) {
	op := &request.Operation{
		Name:       opListTargetsByRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsByRuleInput{}
	}

	output = &ListTargetsByRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsByRule API operation for Amazon CloudWatch Events.
//
// Lists the targets assigned to the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListTargetsByRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRule(input *ListTargetsByRuleInput) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	return out, req.Send()
}

// ListTargetsByRuleWithContext is the same as ListTargetsByRule with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsByRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListTargetsByRuleWithContext(ctx aws.Context, input *ListTargetsByRuleInput, opts ...request.Option) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEvents for more information on using the PutEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventsRequest method.
//    req, resp := client.PutEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon CloudWatch Events.
//
// Sends custom events to Amazon CloudWatch Events so that they can be matched
// to rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	return out, req.Send()
}

// PutEventsWithContext is the same as PutEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutEventsWithContext(ctx aws.Context, input *PutEventsInput, opts ...request.Option) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermission = "PutPermission"

// PutPermissionRequest generates a "aws/request.Request" representing the
// client's request for the PutPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermission for more information on using the PutPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPermissionRequest method.
//    req, resp := client.PutPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPermission
func (c *CloudWatchEvents) PutPermissionRequest(input *PutPermissionInput) (req *request.Request, output *PutPermissionOutput) {
	op := &request.Operation{
		Name:       opPutPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPermissionInput{}
	}

	output = &PutPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermission API operation for Amazon CloudWatch Events.
//
// Running PutPermission permits the specified AWS account or AWS organization
// to put events to your account's default event bus. CloudWatch Events rules
// in your account are triggered by these events arriving to your default event
// bus.
//
// For another account to send events to your account, that external account
// must have a CloudWatch Events rule with your account's default event bus
// as a target.
//
// To enable multiple AWS accounts to put events to your default event bus,
// run PutPermission once for each of these accounts. Or, if all the accounts
// are members of the same AWS organization, you can run PutPermission once
// specifying Principal as "*" and specifying the AWS organization ID in Condition,
// to grant permissions to all accounts in that organization.
//
// If you grant permissions using an organization, then accounts in that organization
// must specify a RoleArn with proper permissions when they use PutTarget to
// add your account's event bus as a target. For more information, see Sending
// and Receiving Events Between AWS Accounts (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html)
// in the Amazon CloudWatch Events User Guide.
//
// The permission policy on the default event bus cannot exceed 10 KB in size.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodePolicyLengthExceededException "PolicyLengthExceededException"
//   The event bus policy is too long. For more information, see the limits.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutPermission
func (c *CloudWatchEvents) PutPermission(input *PutPermissionInput) (*PutPermissionOutput, error) {
	req, out := c.PutPermissionRequest(input)
	return out, req.Send()
}

// PutPermissionWithContext is the same as PutPermission with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutPermissionWithContext(ctx aws.Context, input *PutPermissionInput, opts ...request.Option) (*PutPermissionOutput, error) {
	req, out := c.PutPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRule = "PutRule"

// PutRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRule for more information on using the PutRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRuleRequest method.
//    req, resp := client.PutRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRuleRequest(input *PutRuleInput) (req *request.Request, output *PutRuleOutput) {
	op := &request.Operation{
		Name:       opPutRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRuleInput{}
	}

	output = &PutRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRule API operation for Amazon CloudWatch Events.
//
// Creates or updates the specified rule. Rules are enabled by default, or based
// on value of the state. You can disable a rule using DisableRule.
//
// If you are updating an existing rule, the rule is replaced with what you
// specify in this PutRule command. If you omit arguments in PutRule, the old
// values for those arguments are not kept. Instead, they are replaced with
// null values.
//
// When you create or update a rule, incoming events might not immediately start
// matching to new or updated rules. Allow a short period of time for changes
// to take effect.
//
// A rule must contain at least an EventPattern or ScheduleExpression. Rules
// with EventPatterns are triggered when a matching event is observed. Rules
// with ScheduleExpressions self-trigger based on the given schedule. A rule
// can have both an EventPattern and a ScheduleExpression, in which case the
// rule triggers on matching events as well as on a schedule.
//
// Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// In CloudWatch Events, it is possible to create rules that lead to infinite
// loops, where a rule is fired repeatedly. For example, a rule might detect
// that ACLs have changed on an S3 bucket, and trigger software to change them
// to the desired state. If the rule is not written carefully, the subsequent
// change to the ACLs fires the rule again, creating an infinite loop.
//
// To prevent this, write the rules so that the triggered actions do not re-fire
// the same rule. For example, your rule could fire only if ACLs are found to
// be in a bad state, instead of after any change.
//
// An infinite loop can quickly cause higher than expected charges. We recommend
// that you use budgeting, which alerts you when charges exceed your specified
// limit. For more information, see Managing Your Costs with Budgets (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidEventPatternException "InvalidEventPatternException"
//   The event pattern is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You tried to create more rules or add more targets to a rule than is allowed.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRule(input *PutRuleInput) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	return out, req.Send()
}

// PutRuleWithContext is the same as PutRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutRuleWithContext(ctx aws.Context, input *PutRuleInput, opts ...request.Option) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTargets = "PutTargets"

// PutTargetsRequest generates a "aws/request.Request" representing the
// client's request for the PutTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutTargets for more information on using the PutTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutTargetsRequest method.
//    req, resp := client.PutTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargetsRequest(input *PutTargetsInput) (req *request.Request, output *PutTargetsOutput) {
	op := &request.Operation{
		Name:       opPutTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutTargetsInput{}
	}

	output = &PutTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTargets API operation for Amazon CloudWatch Events.
//
// Adds the specified targets to the specified rule, or updates the targets
// if they are already associated with the rule.
//
// Targets are the resources that are invoked when a rule is triggered.
//
// You can configure the following as targets for CloudWatch Events:
//
//    * EC2 instances
//
//    * SSM Run Command
//
//    * SSM Automation
//
//    * AWS Lambda functions
//
//    * Data streams in Amazon Kinesis Data Streams
//
//    * Data delivery streams in Amazon Kinesis Data Firehose
//
//    * Amazon ECS tasks
//
//    * AWS Step Functions state machines
//
//    * AWS Batch jobs
//
//    * AWS CodeBuild projects
//
//    * Pipelines in AWS CodePipeline
//
//    * Amazon Inspector assessment templates
//
//    * Amazon SNS topics
//
//    * Amazon SQS queues, including FIFO queues
//
//    * The default event bus of another AWS account
//
// Creating rules with built-in targets is supported only in the AWS Management
// Console. The built-in targets are EC2 CreateSnapshot API call, EC2 RebootInstances
// API call, EC2 StopInstances API call, and EC2 TerminateInstances API call.
//
// For some target types, PutTargets provides target-specific parameters. If
// the target is a Kinesis data stream, you can optionally specify which shard
// the event goes to by using the KinesisParameters argument. To invoke a command
// on multiple EC2 instances with one rule, you can use the RunCommandParameters
// field.
//
// To be able to make API calls against the resources that you own, Amazon CloudWatch
// Events needs the appropriate permissions. For AWS Lambda and Amazon SNS resources,
// CloudWatch Events relies on resource-based policies. For EC2 instances, Kinesis
// data streams, and AWS Step Functions state machines, CloudWatch Events relies
// on IAM roles that you specify in the RoleARN argument in PutTargets. For
// more information, see Authentication and Access Control (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/auth-and-access-control-cwe.html)
// in the Amazon CloudWatch Events User Guide.
//
// If another AWS account is in the same region and has granted you permission
// (using PutPermission), you can send events to that account. Set that account's
// event bus as a target of the rules in your account. To send the matched events
// to the other account, specify that account's event bus as the Arn value when
// you run PutTargets. If your account sends events to another account, your
// account is charged for each sent event. Each event sent to another account
// is charged as a custom event. The account receiving the event is not charged.
// For more information, see Amazon CloudWatch Pricing (https://aws.amazon.com/cloudwatch/pricing/).
//
// If you are setting the event bus of another account as the target, and that
// account granted permission to your account through an organization instead
// of directly by the account ID, then you must specify a RoleArn with proper
// permissions in the Target structure. For more information, see Sending and
// Receiving Events Between AWS Accounts (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html)
// in the Amazon CloudWatch Events User Guide.
//
// For more information about enabling cross-account events, see PutPermission.
//
// Input, InputPath, and InputTransformer are mutually exclusive and optional
// parameters of a target. When a rule is triggered due to a matched event:
//
//    * If none of the following arguments are specified for a target, then
//    the entire event is passed to the target in JSON format (unless the target
//    is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from
//    the event is passed to the target).
//
//    * If Input is specified in the form of valid JSON, then the matched event
//    is overridden with this constant.
//
//    * If InputPath is specified in the form of JSONPath (for example, $.detail),
//    then only the part of the event specified in the path is passed to the
//    target (for example, only the detail part of the event is passed).
//
//    * If InputTransformer is specified, then one or more specified JSONPaths
//    are extracted from the event and used as values in a template that you
//    specify as the input to the target.
//
// When you specify InputPath or InputTransformer, you must use JSON dot notation,
// not bracket notation.
//
// When you add targets to a rule and the associated rule triggers soon after,
// new or updated targets might not be immediately invoked. Allow a short period
// of time for changes to take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You tried to create more rules or add more targets to a rule than is allowed.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargets(input *PutTargetsInput) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	return out, req.Send()
}

// PutTargetsWithContext is the same as PutTargets with the addition of
// the ability to pass a context and additional request options.
//
// See PutTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutTargetsWithContext(ctx aws.Context, input *PutTargetsInput, opts ...request.Option) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemovePermission for more information on using the RemovePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req, resp := client.RemovePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemovePermission
func (c *CloudWatchEvents) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for Amazon CloudWatch Events.
//
// Revokes the permission of another AWS account to be able to put events to
// your default event bus. Specify the account to revoke by the StatementId
// value that you associated with the account when you granted it permission
// with PutPermission. You can find the StatementId by using DescribeEventBus.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation RemovePermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemovePermission
func (c *CloudWatchEvents) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	return out, req.Send()
}

// RemovePermissionWithContext is the same as RemovePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemovePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) RemovePermissionWithContext(ctx aws.Context, input *RemovePermissionInput, opts ...request.Option) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTargets = "RemoveTargets"

// RemoveTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTargets for more information on using the RemoveTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTargetsRequest method.
//    req, resp := client.RemoveTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargetsRequest(input *RemoveTargetsInput) (req *request.Request, output *RemoveTargetsOutput) {
	op := &request.Operation{
		Name:       opRemoveTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTargetsInput{}
	}

	output = &RemoveTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTargets API operation for Amazon CloudWatch Events.
//
// Removes the specified targets from the specified rule. When the rule is triggered,
// those targets are no longer be invoked.
//
// When you remove a target, when the associated rule triggers, removed targets
// might continue to be invoked. Allow a short period of time for changes to
// take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation RemoveTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An entity that you specified does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargets(input *RemoveTargetsInput) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	return out, req.Send()
}

// RemoveTargetsWithContext is the same as RemoveTargets with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) RemoveTargetsWithContext(ctx aws.Context, input *RemoveTargetsInput, opts ...request.Option) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestEventPattern = "TestEventPattern"

// TestEventPatternRequest generates a "aws/request.Request" representing the
// client's request for the TestEventPattern operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestEventPattern for more information on using the TestEventPattern
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestEventPatternRequest method.
//    req, resp := client.TestEventPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPatternRequest(input *TestEventPatternInput) (req *request.Request, output *TestEventPatternOutput) {
	op := &request.Operation{
		Name:       opTestEventPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestEventPatternInput{}
	}

	output = &TestEventPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestEventPattern API operation for Amazon CloudWatch Events.
//
// Tests whether the specified event pattern matches the provided event.
//
// Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation TestEventPattern for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidEventPatternException "InvalidEventPatternException"
//   The event pattern is not valid.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPattern(input *TestEventPatternInput) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	return out, req.Send()
}

// TestEventPatternWithContext is the same as TestEventPattern with the addition of
// the ability to pass a context and additional request options.
//
// See TestEventPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) TestEventPatternWithContext(ctx aws.Context, input *TestEventPatternInput, opts ...request.Option) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This structure specifies the VPC subnets and security groups for the task,
// and whether a public IP address is to be used. This structure is relevant
// only for ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the task's elastic network interface receives a public
	// IP address. You can specify ENABLED only when LaunchType in EcsParameters
	// is set to FARGATE.
	AssignPublicIp *string `type:"string" enum:"AssignPublicIp"`

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups.
	// If you do not specify a security group, the default security group for the
	// VPC is used.
	SecurityGroups []*string `type:"list"`

	// Specifies the subnets associated with the task. These subnets must all be
	// in the same VPC. You can specify as many as 16 subnets.
	//
	// Subnets is a required field
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AwsVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsVpcConfiguration"}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsVpcConfiguration) SetAssignPublicIp(v string) *AwsVpcConfiguration {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsVpcConfiguration) SetSecurityGroups(v []*string) *AwsVpcConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsVpcConfiguration) SetSubnets(v []*string) *AwsVpcConfiguration {
	s.Subnets = v
	return s
}

// The array properties for the submitted job, such as the size of the array.
// The array size can be between 2 and 10,000. If you specify array properties
// for a job, it becomes an array job. This parameter is used only if the target
// is an AWS Batch job.
type BatchArrayProperties struct {
	_ struct{} `type:"structure"`

	// The size of the array, if this is an array batch job. Valid values are integers
	// between 2 and 10,000.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchArrayProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchArrayProperties) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *BatchArrayProperties) SetSize(v int64) *BatchArrayProperties {
	s.Size = &v
	return s
}

// The custom parameters to be used when the target is an AWS Batch job.
type BatchParameters struct {
	_ struct{} `type:"structure"`

	// The array properties for the submitted job, such as the size of the array.
	// The array size can be between 2 and 10,000. If you specify array properties
	// for a job, it becomes an array job. This parameter is used only if the target
	// is an AWS Batch job.
	ArrayProperties *BatchArrayProperties `type:"structure"`

	// The ARN or name of the job definition to use if the event target is an AWS
	// Batch job. This job definition must already exist.
	//
	// JobDefinition is a required field
	JobDefinition *string `type:"string" required:"true"`

	// The name to use for this execution of the job, if the target is an AWS Batch
	// job.
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`

	// The retry strategy to use for failed jobs, if the target is an AWS Batch
	// job. The retry strategy is the number of times to retry the failed job execution.
	// Valid values are 1–10. When you specify a retry strategy here, it overrides
	// the retry strategy defined in the job definition.
	RetryStrategy *BatchRetryStrategy `type:"structure"`
}

// String returns the string representation
func (s BatchParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchParameters"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *BatchParameters) SetArrayProperties(v *BatchArrayProperties) *BatchParameters {
	s.ArrayProperties = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *BatchParameters) SetJobDefinition(v string) *BatchParameters {
	s.JobDefinition = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchParameters) SetJobName(v string) *BatchParameters {
	s.JobName = &v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *BatchParameters) SetRetryStrategy(v *BatchRetryStrategy) *BatchParameters {
	s.RetryStrategy = v
	return s
}

// The retry strategy to use for failed jobs, if the target is an AWS Batch
// job. If you specify a retry strategy here, it overrides the retry strategy
// defined in the job definition.
type BatchRetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to attempt to retry, if the job fails. Valid values are
	// 1–10.
	Attempts *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchRetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchRetryStrategy) GoString() string {
	return s.String()
}

// SetAttempts sets the Attempts field's value.
func (s *BatchRetryStrategy) SetAttempts(v int64) *BatchRetryStrategy {
	s.Attempts = &v
	return s
}

// A JSON string which you can use to limit the event bus permissions you are
// granting to only accounts that fulfill the condition. Currently, the only
// supported condition is membership in a certain AWS organization. The string
// must contain Type, Key, and Value fields. The Value field specifies the ID
// of the AWS organization. Following is an example value for Condition:
//
// '{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value": "o-1234567890"}'
type Condition struct {
	_ struct{} `type:"structure"`

	// Specifies the key for the condition. Currently the only supported key is
	// aws:PrincipalOrgID.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Specifies the type of condition. Currently the only supported value is StringEquals.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`

	// Specifies the value for the key. Currently, this must be the ID of the organization.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Condition) SetKey(v string) *Condition {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *Condition) SetType(v string) *Condition {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Condition) SetValue(v string) *Condition {
	s.Value = &v
	return s
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRuleInput) SetName(v string) *DeleteRuleInput {
	s.Name = &v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type DescribeEventBusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeEventBusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventBusInput) GoString() string {
	return s.String()
}

type DescribeEventBusOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account permitted to write events to
	// the current account.
	Arn *string `type:"string"`

	// The name of the event bus. Currently, this is always default.
	Name *string `type:"string"`

	// The policy that enables the external account to send events to your account.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventBusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventBusOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeEventBusOutput) SetArn(v string) *DescribeEventBusOutput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeEventBusOutput) SetName(v string) *DescribeEventBusOutput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribeEventBusOutput) SetPolicy(v string) *DescribeEventBusOutput {
	s.Policy = &v
	return s
}

type DescribeRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRuleInput) SetName(v string) *DescribeRuleInput {
	s.Name = &v
	return s
}

type DescribeRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Specifies whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s DescribeRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRuleOutput) SetArn(v string) *DescribeRuleOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRuleOutput) SetDescription(v string) *DescribeRuleOutput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *DescribeRuleOutput) SetEventPattern(v string) *DescribeRuleOutput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRuleOutput) SetName(v string) *DescribeRuleOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeRuleOutput) SetRoleArn(v string) *DescribeRuleOutput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *DescribeRuleOutput) SetScheduleExpression(v string) *DescribeRuleOutput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeRuleOutput) SetState(v string) *DescribeRuleOutput {
	s.State = &v
	return s
}

type DisableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DisableRuleInput) SetName(v string) *DisableRuleInput {
	s.Name = &v
	return s
}

type DisableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleOutput) GoString() string {
	return s.String()
}

// The custom parameters to be used when the target is an Amazon ECS task.
type EcsParameters struct {
	_ struct{} `type:"structure"`

	// Specifies an ECS task group for the task. The maximum length is 255 characters.
	Group *string `type:"string"`

	// Specifies the launch type on which your task is running. The launch type
	// that you specify here must match one of the launch type (compatibilities)
	// of the target task. The FARGATE value is supported only in the Regions where
	// AWS Fargate with Amazon ECS is supported. For more information, see AWS Fargate
	// on Amazon ECS (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `type:"string" enum:"LaunchType"`

	// Use this structure if the ECS task uses the awsvpc network mode. This structure
	// specifies the VPC subnets and security groups associated with the task, and
	// whether a public IP address is to be used. This structure is required if
	// LaunchType is FARGATE because the awsvpc mode is required for Fargate tasks.
	//
	// If you specify NetworkConfiguration when the target ECS task does not use
	// the awsvpc network mode, the task fails.
	NetworkConfiguration *NetworkConfiguration `type:"structure"`

	// Specifies the platform version for the task. Specify only the numeric portion
	// of the platform version, such as 1.1.0.
	//
	// This structure is used only if LaunchType is FARGATE. For more information
	// about valid platform versions, see AWS Fargate Platform Versions (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `type:"string"`

	// The number of tasks to create based on TaskDefinition. The default is 1.
	TaskCount *int64 `min:"1" type:"integer"`

	// The ARN of the task definition to use if the event target is an Amazon ECS
	// task.
	//
	// TaskDefinitionArn is a required field
	TaskDefinitionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EcsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EcsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsParameters"}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TaskCount", 1))
	}
	if s.TaskDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinitionArn"))
	}
	if s.TaskDefinitionArn != nil && len(*s.TaskDefinitionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskDefinitionArn", 1))
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *EcsParameters) SetGroup(v string) *EcsParameters {
	s.Group = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *EcsParameters) SetLaunchType(v string) *EcsParameters {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *EcsParameters) SetNetworkConfiguration(v *NetworkConfiguration) *EcsParameters {
	s.NetworkConfiguration = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EcsParameters) SetPlatformVersion(v string) *EcsParameters {
	s.PlatformVersion = &v
	return s
}

// SetTaskCount sets the TaskCount field's value.
func (s *EcsParameters) SetTaskCount(v int64) *EcsParameters {
	s.TaskCount = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *EcsParameters) SetTaskDefinitionArn(v string) *EcsParameters {
	s.TaskDefinitionArn = &v
	return s
}

type EnableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EnableRuleInput) SetName(v string) *EnableRuleInput {
	s.Name = &v
	return s
}

type EnableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleOutput) GoString() string {
	return s.String()
}

// Contains the parameters needed for you to provide custom input to a target
// based on one or more pieces of data extracted from the event.
type InputTransformer struct {
	_ struct{} `type:"structure"`

	// Map of JSON paths to be extracted from the event. You can then insert these
	// in the template in InputTemplate to produce the output you want to be sent
	// to the target.
	//
	// InputPathsMap is an array key-value pairs, where each value is a valid JSON
	// path. You can have as many as 10 key-value pairs. You must use JSON dot notation,
	// not bracket notation.
	//
	// The keys cannot start with "AWS."
	InputPathsMap map[string]*string `type:"map"`

	// Input template where you specify placeholders that will be filled with the
	// values of the keys from InputPathsMap to customize the data sent to the target.
	// Enclose each InputPathsMaps value in brackets: <value> The InputTemplate
	// must be valid JSON.
	//
	// If InputTemplate is a JSON object (surrounded by curly braces), the following
	// restrictions apply:
	//
	//    * The placeholder cannot be used as an object key.
	//
	//    * Object values cannot include quote marks.
	//
	// The following example shows the syntax for using InputPathsMap and InputTemplate.
	//
	// "InputTransformer":
	//
	// {
	//
	// "InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},
	//
	// "InputTemplate": "<instance> is in state <status>"
	//
	// }
	//
	// To have the InputTemplate include quote marks within a JSON string, escape
	// each quote marks with a slash, as in the following example:
	//
	// "InputTransformer":
	//
	// {
	//
	// "InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},
	//
	// "InputTemplate": "<instance> is in state \"<status>\""
	//
	// }
	//
	// InputTemplate is a required field
	InputTemplate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputTransformer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputTransformer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputTransformer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputTransformer"}
	if s.InputTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("InputTemplate"))
	}
	if s.InputTemplate != nil && len(*s.InputTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputPathsMap sets the InputPathsMap field's value.
func (s *InputTransformer) SetInputPathsMap(v map[string]*string) *InputTransformer {
	s.InputPathsMap = v
	return s
}

// SetInputTemplate sets the InputTemplate field's value.
func (s *InputTransformer) SetInputTemplate(v string) *InputTransformer {
	s.InputTemplate = &v
	return s
}

// This object enables you to specify a JSON path to extract from the event
// and use as the partition key for the Amazon Kinesis data stream, so that
// you can control the shard to which the event goes. If you do not include
// this parameter, the default is to use the eventId as the partition key.
type KinesisParameters struct {
	_ struct{} `type:"structure"`

	// The JSON path to be extracted from the event and used as the partition key.
	// For more information, see Amazon Kinesis Streams Key Concepts (http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// PartitionKeyPath is a required field
	PartitionKeyPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisParameters"}
	if s.PartitionKeyPath == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKeyPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKeyPath sets the PartitionKeyPath field's value.
func (s *KinesisParameters) SetPartitionKeyPath(v string) *KinesisParameters {
	s.PartitionKeyPath = &v
	return s
}

type ListRuleNamesByTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target resource.
	//
	// TargetArn is a required field
	TargetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRuleNamesByTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleNamesByTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleNamesByTargetInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRuleNamesByTargetInput) SetLimit(v int64) *ListRuleNamesByTargetInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetInput) SetNextToken(v string) *ListRuleNamesByTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListRuleNamesByTargetInput) SetTargetArn(v string) *ListRuleNamesByTargetInput {
	s.TargetArn = &v
	return s
}

type ListRuleNamesByTargetOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The names of the rules that can invoke the given target.
	RuleNames []*string `type:"list"`
}

// String returns the string representation
func (s ListRuleNamesByTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetOutput) SetNextToken(v string) *ListRuleNamesByTargetOutput {
	s.NextToken = &v
	return s
}

// SetRuleNames sets the RuleNames field's value.
func (s *ListRuleNamesByTargetOutput) SetRuleNames(v []*string) *ListRuleNamesByTargetOutput {
	s.RuleNames = v
	return s
}

type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The prefix matching the rule name.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRulesInput) SetLimit(v int64) *ListRulesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListRulesInput) SetNamePrefix(v string) *ListRulesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The rules that match the specified criteria.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*Rule) *ListRulesOutput {
	s.Rules = v
	return s
}

type ListTargetsByRuleInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsByRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsByRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsByRuleInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsByRuleInput) SetLimit(v int64) *ListTargetsByRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleInput) SetNextToken(v string) *ListTargetsByRuleInput {
	s.NextToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *ListTargetsByRuleInput) SetRule(v string) *ListTargetsByRuleInput {
	s.Rule = &v
	return s
}

type ListTargetsByRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The targets assigned to the rule.
	Targets []*Target `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTargetsByRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleOutput) SetNextToken(v string) *ListTargetsByRuleOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsByRuleOutput) SetTargets(v []*Target) *ListTargetsByRuleOutput {
	s.Targets = v
	return s
}

// This structure specifies the network configuration for an ECS task.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Use this structure to specify the VPC subnets and security groups for the
	// task, and whether a public IP address is to be used. This structure is relevant
	// only for ECS tasks that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsvpcConfiguration sets the AwsvpcConfiguration field's value.
func (s *NetworkConfiguration) SetAwsvpcConfiguration(v *AwsVpcConfiguration) *NetworkConfiguration {
	s.AwsvpcConfiguration = v
	return s
}

type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The entry that defines an event in your system. You can specify several parameters
	// for the entry such as the source and type of the event, resources associated
	// with the event, and so on.
	//
	// Entries is a required field
	Entries []*PutEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *PutEventsInput) SetEntries(v []*PutEventsRequestEntry) *PutEventsInput {
	s.Entries = v
	return s
}

type PutEventsOutput struct {
	_ struct{} `type:"structure"`

	// The successfully and unsuccessfully ingested events results. If the ingestion
	// was successful, the entry has the event ID in it. Otherwise, you can use
	// the error code and error message to identify the problem with the entry.
	Entries []*PutEventsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *PutEventsOutput) SetEntries(v []*PutEventsResultEntry) *PutEventsOutput {
	s.Entries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutEventsOutput) SetFailedEntryCount(v int64) *PutEventsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents an event to be submitted.
type PutEventsRequestEntry struct {
	_ struct{} `type:"structure"`

	// A valid JSON string. There is no other schema imposed. The JSON string may
	// contain fields and nested subobjects.
	Detail *string `type:"string"`

	// Free-form string used to decide what fields to expect in the event detail.
	DetailType *string `type:"string"`

	// AWS resources, identified by Amazon Resource Name (ARN), which the event
	// primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The source of the event. This field is required.
	Source *string `type:"string"`

	// The time stamp of the event, per RFC3339 (https://www.rfc-editor.org/rfc/rfc3339.txt).
	// If no time stamp is provided, the time stamp of the PutEvents call is used.
	Time *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PutEventsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsRequestEntry) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *PutEventsRequestEntry) SetDetail(v string) *PutEventsRequestEntry {
	s.Detail = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *PutEventsRequestEntry) SetDetailType(v string) *PutEventsRequestEntry {
	s.DetailType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PutEventsRequestEntry) SetResources(v []*string) *PutEventsRequestEntry {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PutEventsRequestEntry) SetSource(v string) *PutEventsRequestEntry {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutEventsRequestEntry) SetTime(v time.Time) *PutEventsRequestEntry {
	s.Time = &v
	return s
}

// Represents an event that failed to be submitted.
type PutEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the event submission failed.
	ErrorCode *string `type:"string"`

	// The error message that explains why the event submission failed.
	ErrorMessage *string `type:"string"`

	// The ID of the event.
	EventId *string `type:"string"`
}

// String returns the string representation
func (s PutEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutEventsResultEntry) SetErrorCode(v string) *PutEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutEventsResultEntry) SetErrorMessage(v string) *PutEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutEventsResultEntry) SetEventId(v string) *PutEventsResultEntry {
	s.EventId = &v
	return s
}

type PutPermissionInput struct {
	_ struct{} `type:"structure"`

	// The action that you are enabling the other account to perform. Currently,
	// this must be events:PutEvents.
	//
	// Action is a required field
	Action *string `min:"1" type:"string" required:"true"`

	// This parameter enables you to limit the permission to accounts that fulfill
	// a certain condition, such as being a member of a certain AWS organization.
	// For more information about AWS Organizations, see What Is AWS Organizations
	// (http://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
	// in the AWS Organizations User Guide.
	//
	// If you specify Condition with an AWS organization ID, and specify "*" as
	// the value for Principal, you grant permission to all the accounts in the
	// named organization.
	//
	// The Condition is a JSON string which must contain Type, Key, and Value fields.
	Condition *Condition `type:"structure"`

	// The 12-digit AWS account ID that you are permitting to put events to your
	// default event bus. Specify "*" to permit any account to put events to your
	// default event bus.
	//
	// If you specify "*" without specifying Condition, avoid creating rules that
	// may match undesirable events. To create more secure rules, make sure that
	// the event pattern for each rule contains an account field with a specific
	// account ID from which to receive events. Rules with an account field do not
	// match any events sent from other accounts.
	//
	// Principal is a required field
	Principal *string `min:"1" type:"string" required:"true"`

	// An identifier string for the external account that you are granting permissions
	// to. If you later want to revoke the permission for this external account,
	// specify this StatementId when you run RemovePermission.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Action != nil && len(*s.Action) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Action", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Principal != nil && len(*s.Principal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Principal", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *PutPermissionInput) SetAction(v string) *PutPermissionInput {
	s.Action = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *PutPermissionInput) SetCondition(v *Condition) *PutPermissionInput {
	s.Condition = v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *PutPermissionInput) SetPrincipal(v string) *PutPermissionInput {
	s.Principal = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *PutPermissionInput) SetStatementId(v string) *PutPermissionInput {
	s.StatementId = &v
	return s
}

type PutPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionOutput) GoString() string {
	return s.String()
}

type PutRuleInput struct {
	_ struct{} `type:"structure"`

	// A description of the rule.
	Description *string `type:"string"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule that you are creating or updating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Indicates whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s PutRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutRuleInput) SetDescription(v string) *PutRuleInput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *PutRuleInput) SetEventPattern(v string) *PutRuleInput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleInput) SetName(v string) *PutRuleInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutRuleInput) SetRoleArn(v string) *PutRuleInput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *PutRuleInput) SetScheduleExpression(v string) *PutRuleInput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *PutRuleInput) SetState(v string) *PutRuleInput {
	s.State = &v
	return s
}

type PutRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleOutput) GoString() string {
	return s.String()
}

// SetRuleArn sets the RuleArn field's value.
func (s *PutRuleOutput) SetRuleArn(v string) *PutRuleOutput {
	s.RuleArn = &v
	return s
}

type PutTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`

	// The targets to update or add to the rule.
	//
	// Targets is a required field
	Targets []*Target `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTargetsInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *PutTargetsInput) SetRule(v string) *PutTargetsInput {
	s.Rule = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *PutTargetsInput) SetTargets(v []*Target) *PutTargetsInput {
	s.Targets = v
	return s
}

type PutTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*PutTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *PutTargetsOutput) SetFailedEntries(v []*PutTargetsResultEntry) *PutTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutTargetsOutput) SetFailedEntryCount(v int64) *PutTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be added to a rule.
type PutTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target addition failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target addition failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutTargetsResultEntry) SetErrorCode(v string) *PutTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutTargetsResultEntry) SetErrorMessage(v string) *PutTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PutTargetsResultEntry) SetTargetId(v string) *PutTargetsResultEntry {
	s.TargetId = &v
	return s
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The statement ID corresponding to the account that is no longer allowed to
	// put events to the default event bus.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatementId sets the StatementId field's value.
func (s *RemovePermissionInput) SetStatementId(v string) *RemovePermissionInput {
	s.StatementId = &v
	return s
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type RemoveTargetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the targets to remove from the rule.
	//
	// Ids is a required field
	Ids []*string `min:"1" type:"list" required:"true"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTargetsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *RemoveTargetsInput) SetIds(v []*string) *RemoveTargetsInput {
	s.Ids = v
	return s
}

// SetRule sets the Rule field's value.
func (s *RemoveTargetsInput) SetRule(v string) *RemoveTargetsInput {
	s.Rule = &v
	return s
}

type RemoveTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*RemoveTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s RemoveTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *RemoveTargetsOutput) SetFailedEntries(v []*RemoveTargetsResultEntry) *RemoveTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *RemoveTargetsOutput) SetFailedEntryCount(v int64) *RemoveTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be removed from a rule.
type RemoveTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target removal failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target removal failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RemoveTargetsResultEntry) SetErrorCode(v string) *RemoveTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RemoveTargetsResultEntry) SetErrorMessage(v string) *RemoveTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *RemoveTargetsResultEntry) SetTargetId(v string) *RemoveTargetsResultEntry {
	s.TargetId = &v
	return s
}

// Contains information about a rule in Amazon CloudWatch Events.
type Rule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The event pattern of the rule. For more information, see Events and Event
	// Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that is used for target invocation.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// The state of the rule.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Rule) SetArn(v string) *Rule {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Rule) SetDescription(v string) *Rule {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *Rule) SetEventPattern(v string) *Rule {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Rule) SetRoleArn(v string) *Rule {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Rule) SetScheduleExpression(v string) *Rule {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *Rule) SetState(v string) *Rule {
	s.State = &v
	return s
}

// This parameter contains the criteria (either InstanceIds or a tag) used to
// specify which EC2 instances are to be sent the command.
type RunCommandParameters struct {
	_ struct{} `type:"structure"`

	// Currently, we support including only one RunCommandTarget block, which specifies
	// either an array of InstanceIds or a tag.
	//
	// RunCommandTargets is a required field
	RunCommandTargets []*RunCommandTarget `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RunCommandParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandParameters"}
	if s.RunCommandTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("RunCommandTargets"))
	}
	if s.RunCommandTargets != nil && len(s.RunCommandTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunCommandTargets", 1))
	}
	if s.RunCommandTargets != nil {
		for i, v := range s.RunCommandTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RunCommandTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRunCommandTargets sets the RunCommandTargets field's value.
func (s *RunCommandParameters) SetRunCommandTargets(v []*RunCommandTarget) *RunCommandParameters {
	s.RunCommandTargets = v
	return s
}

// Information about the EC2 instances that are to be sent the command, specified
// as key-value pairs. Each RunCommandTarget block can include only one key,
// but this key may specify multiple values.
type RunCommandTarget struct {
	_ struct{} `type:"structure"`

	// Can be either tag:tag-key or InstanceIds.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// If Key is tag:tag-key, Values is a list of tag values. If Key is InstanceIds,
	// Values is a list of Amazon EC2 instance IDs.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RunCommandTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandTarget"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *RunCommandTarget) SetKey(v string) *RunCommandTarget {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RunCommandTarget) SetValues(v []*string) *RunCommandTarget {
	s.Values = v
	return s
}

// This structure includes the custom parameter to be used when the target is
// an SQS FIFO queue.
type SqsParameters struct {
	_ struct{} `type:"structure"`

	// The FIFO message group ID to use as the target.
	MessageGroupId *string `type:"string"`
}

// String returns the string representation
func (s SqsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqsParameters) GoString() string {
	return s.String()
}

// SetMessageGroupId sets the MessageGroupId field's value.
func (s *SqsParameters) SetMessageGroupId(v string) *SqsParameters {
	s.MessageGroupId = &v
	return s
}

// Targets are the resources to be invoked when a rule is triggered. For a complete
// list of services and resources that can be set as a target, see PutTargets.
//
// If you are setting the event bus of another account as the target, and that
// account granted permission to your account through an organization instead
// of directly by the account ID, then you must specify a RoleArn with proper
// permissions in the Target structure. For more information, see Sending and
// Receiving Events Between AWS Accounts (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html)
// in the Amazon CloudWatch Events User Guide.
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// If the event target is an AWS Batch job, this contains the job definition,
	// job name, and other parameters. For more information, see Jobs (http://docs.aws.amazon.com/batch/latest/userguide/jobs.html)
	// in the AWS Batch User Guide.
	BatchParameters *BatchParameters `type:"structure"`

	// Contains the Amazon ECS task definition and task count to be used, if the
	// event target is an Amazon ECS task. For more information about Amazon ECS
	// tasks, see Task Definitions  (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
	// in the Amazon EC2 Container Service Developer Guide.
	EcsParameters *EcsParameters `type:"structure"`

	// The ID of the target.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Valid JSON text passed to the target. In this case, nothing from the event
	// itself is passed to the target. For more information, see The JavaScript
	// Object Notation (JSON) Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	Input *string `type:"string"`

	// The value of the JSONPath that is used for extracting part of the matched
	// event when passing it to the target. You must use JSON dot notation, not
	// bracket notation. For more information about JSON paths, see JSONPath (http://goessner.net/articles/JsonPath/).
	InputPath *string `type:"string"`

	// Settings to enable you to provide custom input to a target based on certain
	// event data. You can extract one or more key-value pairs from the event and
	// then use that data to send customized input to the target.
	InputTransformer *InputTransformer `type:"structure"`

	// The custom parameter you can use to control the shard assignment, when the
	// target is a Kinesis data stream. If you do not include this parameter, the
	// default is to use the eventId as the partition key.
	KinesisParameters *KinesisParameters `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be used for this target
	// when the rule is triggered. If one rule triggers multiple targets, you can
	// use a different IAM role for each target.
	RoleArn *string `min:"1" type:"string"`

	// Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
	RunCommandParameters *RunCommandParameters `type:"structure"`

	// Contains the message group ID to use when the target is a FIFO queue.
	//
	// If you specify an SQS FIFO queue as a target, the queue must have content-based
	// deduplication enabled.
	SqsParameters *SqsParameters `type:"structure"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.BatchParameters != nil {
		if err := s.BatchParameters.Validate(); err != nil {
			invalidParams.AddNested("BatchParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsParameters != nil {
		if err := s.EcsParameters.Validate(); err != nil {
			invalidParams.AddNested("EcsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.InputTransformer != nil {
		if err := s.InputTransformer.Validate(); err != nil {
			invalidParams.AddNested("InputTransformer", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisParameters != nil {
		if err := s.KinesisParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RunCommandParameters != nil {
		if err := s.RunCommandParameters.Validate(); err != nil {
			invalidParams.AddNested("RunCommandParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Target) SetArn(v string) *Target {
	s.Arn = &v
	return s
}

// SetBatchParameters sets the BatchParameters field's value.
func (s *Target) SetBatchParameters(v *BatchParameters) *Target {
	s.BatchParameters = v
	return s
}

// SetEcsParameters sets the EcsParameters field's value.
func (s *Target) SetEcsParameters(v *EcsParameters) *Target {
	s.EcsParameters = v
	return s
}

// SetId sets the Id field's value.
func (s *Target) SetId(v string) *Target {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *Target) SetInput(v string) *Target {
	s.Input = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *Target) SetInputPath(v string) *Target {
	s.InputPath = &v
	return s
}

// SetInputTransformer sets the InputTransformer field's value.
func (s *Target) SetInputTransformer(v *InputTransformer) *Target {
	s.InputTransformer = v
	return s
}

// SetKinesisParameters sets the KinesisParameters field's value.
func (s *Target) SetKinesisParameters(v *KinesisParameters) *Target {
	s.KinesisParameters = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Target) SetRoleArn(v string) *Target {
	s.RoleArn = &v
	return s
}

// SetRunCommandParameters sets the RunCommandParameters field's value.
func (s *Target) SetRunCommandParameters(v *RunCommandParameters) *Target {
	s.RunCommandParameters = v
	return s
}

// SetSqsParameters sets the SqsParameters field's value.
func (s *Target) SetSqsParameters(v *SqsParameters) *Target {
	s.SqsParameters = v
	return s
}

type TestEventPatternInput struct {
	_ struct{} `type:"structure"`

	// The event, in JSON format, to test against the event pattern.
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	//
	// EventPattern is a required field
	EventPattern *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestEventPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestEventPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestEventPatternInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.EventPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("EventPattern"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *TestEventPatternInput) SetEvent(v string) *TestEventPatternInput {
	s.Event = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *TestEventPatternInput) SetEventPattern(v string) *TestEventPatternInput {
	s.EventPattern = &v
	return s
}

type TestEventPatternOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the event matches the event pattern.
	Result *bool `type:"boolean"`
}

// String returns the string representation
func (s TestEventPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *TestEventPatternOutput) SetResult(v bool) *TestEventPatternOutput {
	s.Result = &v
	return s
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

const (
	// LaunchTypeEc2 is a LaunchType enum value
	LaunchTypeEc2 = "EC2"

	// LaunchTypeFargate is a LaunchType enum value
	LaunchTypeFargate = "FARGATE"
)

const (
	// RuleStateEnabled is a RuleState enum value
	RuleStateEnabled = "ENABLED"

	// RuleStateDisabled is a RuleState enum value
	RuleStateDisabled = "DISABLED"
)
