// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package main

import (
	"golang.org/x/text/language"
	"golang.org/x/text/message"
	"golang.org/x/text/message/catalog"
)

type dictionary struct {
	index []uint32
	data  string
}

func (d *dictionary) Lookup(key string) (data string, ok bool) {
	p := messageKeyToIndex[key]
	start, end := d.index[p], d.index[p+1]
	if start == end {
		return "", false
	}
	return d.data[start:end], true
}

func init() {
	dict := map[string]catalog.Dictionary{
		"de":    &dictionary{index: deIndex, data: deData},
		"en_US": &dictionary{index: en_USIndex, data: en_USData},
		"zh":    &dictionary{index: zhIndex, data: zhData},
	}
	fallback := language.MustParse("en-US")
	cat, err := catalog.NewFromMap(dict, catalog.Fallback(fallback))
	if err != nil {
		panic(err)
	}
	message.DefaultCatalog = cat
}

var messageKeyToIndex = map[string]int{
	"%.2[1]f miles traveled (%[1]f)": 6,
	"%[1]s is visiting %[3]s!\n":     3,
	"%d more files remaining!":       4,
	"%s is out of order!":            5,
	"%s is visiting %s!\n":           2,
	"Hello %s!\n":                    1,
	"Hello world!\n":                 0,
}

var deIndex = []uint32{ // 8 elements
	0x00000000, 0x0000000d, 0x0000001b, 0x00000031,
	0x00000047, 0x00000066, 0x00000066, 0x00000066,
} // Size: 56 bytes

const deData string = "" + // Size: 102 bytes
	"\x02Hallo Welt!\x0a\x02Hallo %[1]s!\x0a\x02%[1]s besucht %[2]s!\x0a\x02%" +
	"[1]s besucht %[3]s!\x0a\x02Noch %[1]d Bestände zu gehen!"

var en_USIndex = []uint32{ // 8 elements
	0x00000000, 0x0000000e, 0x0000001c, 0x00000036,
	0x00000050, 0x00000093, 0x000000aa, 0x000000c9,
} // Size: 56 bytes

const en_USData string = "" + // Size: 201 bytes
	"\x02Hello world!\x0a\x02Hello %[1]s!\x0a\x02%[1]s is visiting %[2]s!\x0a" +
	"\x02%[1]s is visiting %[3]s!\x0a\x04\x01\x81\x01\x00\x02\x14\x02One file" +
	" remaining!\x00&\x02There are %[1]d more files remaining!\x02%[1]s is ou" +
	"t of order!\x02%.2[1]f miles traveled (%[1]f)"

var zhIndex = []uint32{ // 8 elements
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000,
} // Size: 56 bytes

const zhData string = ""

// Total table size 471 bytes (0KiB); checksum: 7746955
