package securityinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/securityinsight/mgmt/2017-08-01-preview/securityinsight"

// AggregationsKind enumerates the values for aggregations kind.
type AggregationsKind string

const (
	// AggregationsKindCasesAggregation ...
	AggregationsKindCasesAggregation AggregationsKind = "CasesAggregation"
)

// PossibleAggregationsKindValues returns an array of possible values for the AggregationsKind const type.
func PossibleAggregationsKindValues() []AggregationsKind {
	return []AggregationsKind{AggregationsKindCasesAggregation}
}

// AlertRuleKind enumerates the values for alert rule kind.
type AlertRuleKind string

const (
	// Scheduled ...
	Scheduled AlertRuleKind = "Scheduled"
)

// PossibleAlertRuleKindValues returns an array of possible values for the AlertRuleKind const type.
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return []AlertRuleKind{Scheduled}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// High High severity
	High AlertSeverity = "High"
	// Informational Informational severity
	Informational AlertSeverity = "Informational"
	// Low Low severity
	Low AlertSeverity = "Low"
	// Medium Medium severity
	Medium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{High, Informational, Low, Medium}
}

// CaseSeverity enumerates the values for case severity.
type CaseSeverity string

const (
	// CaseSeverityCritical Critical severity
	CaseSeverityCritical CaseSeverity = "Critical"
	// CaseSeverityHigh High severity
	CaseSeverityHigh CaseSeverity = "High"
	// CaseSeverityInformational Informational severity
	CaseSeverityInformational CaseSeverity = "Informational"
	// CaseSeverityLow Low severity
	CaseSeverityLow CaseSeverity = "Low"
	// CaseSeverityMedium Medium severity
	CaseSeverityMedium CaseSeverity = "Medium"
)

// PossibleCaseSeverityValues returns an array of possible values for the CaseSeverity const type.
func PossibleCaseSeverityValues() []CaseSeverity {
	return []CaseSeverity{CaseSeverityCritical, CaseSeverityHigh, CaseSeverityInformational, CaseSeverityLow, CaseSeverityMedium}
}

// CaseStatus enumerates the values for case status.
type CaseStatus string

const (
	// CaseStatusClosed A non active case
	CaseStatusClosed CaseStatus = "Closed"
	// CaseStatusDraft Case that wasn't promoted yet to active
	CaseStatusDraft CaseStatus = "Draft"
	// CaseStatusInProgress An active case which is handled
	CaseStatusInProgress CaseStatus = "InProgress"
	// CaseStatusNew An active case which isn't handled currently
	CaseStatusNew CaseStatus = "New"
)

// PossibleCaseStatusValues returns an array of possible values for the CaseStatus const type.
func PossibleCaseStatusValues() []CaseStatus {
	return []CaseStatus{CaseStatusClosed, CaseStatusDraft, CaseStatusInProgress, CaseStatusNew}
}

// CloseReason enumerates the values for close reason.
type CloseReason string

const (
	// Dismissed Case was dismissed
	Dismissed CloseReason = "Dismissed"
	// Other Case was closed for another reason
	Other CloseReason = "Other"
	// Resolved Case was resolved
	Resolved CloseReason = "Resolved"
)

// PossibleCloseReasonValues returns an array of possible values for the CloseReason const type.
func PossibleCloseReasonValues() []CloseReason {
	return []CloseReason{Dismissed, Other, Resolved}
}

// DataConnectorKind enumerates the values for data connector kind.
type DataConnectorKind string

const (
	// AzureActiveDirectory ...
	AzureActiveDirectory DataConnectorKind = "AzureActiveDirectory"
	// AzureSecurityCenter ...
	AzureSecurityCenter DataConnectorKind = "AzureSecurityCenter"
	// MicrosoftCloudAppSecurity ...
	MicrosoftCloudAppSecurity DataConnectorKind = "MicrosoftCloudAppSecurity"
	// Office365 ...
	Office365 DataConnectorKind = "Office365"
	// ThreatIntelligence ...
	ThreatIntelligence DataConnectorKind = "ThreatIntelligence"
)

// PossibleDataConnectorKindValues returns an array of possible values for the DataConnectorKind const type.
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return []DataConnectorKind{AzureActiveDirectory, AzureSecurityCenter, MicrosoftCloudAppSecurity, Office365, ThreatIntelligence}
}

// DataTypeState enumerates the values for data type state.
type DataTypeState string

const (
	// Disabled ...
	Disabled DataTypeState = "Disabled"
	// Enabled ...
	Enabled DataTypeState = "Enabled"
)

// PossibleDataTypeStateValues returns an array of possible values for the DataTypeState const type.
func PossibleDataTypeStateValues() []DataTypeState {
	return []DataTypeState{Disabled, Enabled}
}

// EntityKind enumerates the values for entity kind.
type EntityKind string

const (
	// Account Entity represents account in the system.
	Account EntityKind = "Account"
	// File Entity represents file in the system.
	File EntityKind = "File"
	// Host Entity represents host in the system.
	Host EntityKind = "Host"
)

// PossibleEntityKindValues returns an array of possible values for the EntityKind const type.
func PossibleEntityKindValues() []EntityKind {
	return []EntityKind{Account, File, Host}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAlertRule ...
	KindAlertRule Kind = "AlertRule"
	// KindScheduled ...
	KindScheduled Kind = "Scheduled"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAlertRule, KindScheduled}
}

// KindBasicAggregations enumerates the values for kind basic aggregations.
type KindBasicAggregations string

const (
	// KindAggregations ...
	KindAggregations KindBasicAggregations = "Aggregations"
	// KindCasesAggregation ...
	KindCasesAggregation KindBasicAggregations = "CasesAggregation"
)

// PossibleKindBasicAggregationsValues returns an array of possible values for the KindBasicAggregations const type.
func PossibleKindBasicAggregationsValues() []KindBasicAggregations {
	return []KindBasicAggregations{KindAggregations, KindCasesAggregation}
}

// KindBasicDataConnector enumerates the values for kind basic data connector.
type KindBasicDataConnector string

const (
	// KindAzureActiveDirectory ...
	KindAzureActiveDirectory KindBasicDataConnector = "AzureActiveDirectory"
	// KindAzureSecurityCenter ...
	KindAzureSecurityCenter KindBasicDataConnector = "AzureSecurityCenter"
	// KindDataConnector ...
	KindDataConnector KindBasicDataConnector = "DataConnector"
	// KindMicrosoftCloudAppSecurity ...
	KindMicrosoftCloudAppSecurity KindBasicDataConnector = "MicrosoftCloudAppSecurity"
	// KindOffice365 ...
	KindOffice365 KindBasicDataConnector = "Office365"
	// KindThreatIntelligence ...
	KindThreatIntelligence KindBasicDataConnector = "ThreatIntelligence"
)

// PossibleKindBasicDataConnectorValues returns an array of possible values for the KindBasicDataConnector const type.
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return []KindBasicDataConnector{KindAzureActiveDirectory, KindAzureSecurityCenter, KindDataConnector, KindMicrosoftCloudAppSecurity, KindOffice365, KindThreatIntelligence}
}

// KindBasicEntity enumerates the values for kind basic entity.
type KindBasicEntity string

const (
	// KindAccount ...
	KindAccount KindBasicEntity = "Account"
	// KindEntity ...
	KindEntity KindBasicEntity = "Entity"
	// KindFile ...
	KindFile KindBasicEntity = "File"
	// KindHost ...
	KindHost KindBasicEntity = "Host"
)

// PossibleKindBasicEntityValues returns an array of possible values for the KindBasicEntity const type.
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return []KindBasicEntity{KindAccount, KindEntity, KindFile, KindHost}
}

// KindBasicSettings enumerates the values for kind basic settings.
type KindBasicSettings string

const (
	// KindSettings ...
	KindSettings KindBasicSettings = "Settings"
	// KindToggleSettings ...
	KindToggleSettings KindBasicSettings = "ToggleSettings"
	// KindUebaSettings ...
	KindUebaSettings KindBasicSettings = "UebaSettings"
)

// PossibleKindBasicSettingsValues returns an array of possible values for the KindBasicSettings const type.
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return []KindBasicSettings{KindSettings, KindToggleSettings, KindUebaSettings}
}

// LicenseStatus enumerates the values for license status.
type LicenseStatus string

const (
	// LicenseStatusDisabled ...
	LicenseStatusDisabled LicenseStatus = "Disabled"
	// LicenseStatusEnabled ...
	LicenseStatusEnabled LicenseStatus = "Enabled"
)

// PossibleLicenseStatusValues returns an array of possible values for the LicenseStatus const type.
func PossibleLicenseStatusValues() []LicenseStatus {
	return []LicenseStatus{LicenseStatusDisabled, LicenseStatusEnabled}
}

// OSFamily enumerates the values for os family.
type OSFamily string

const (
	// Android Host with Android operating system.
	Android OSFamily = "Android"
	// IOS Host with IOS operating system.
	IOS OSFamily = "IOS"
	// Linux Host with Linux operating system.
	Linux OSFamily = "Linux"
	// Windows Host with Windows operating system.
	Windows OSFamily = "Windows"
)

// PossibleOSFamilyValues returns an array of possible values for the OSFamily const type.
func PossibleOSFamilyValues() []OSFamily {
	return []OSFamily{Android, IOS, Linux, Windows}
}

// SettingKind enumerates the values for setting kind.
type SettingKind string

const (
	// SettingKindToggleSettings ...
	SettingKindToggleSettings SettingKind = "ToggleSettings"
	// SettingKindUebaSettings ...
	SettingKindUebaSettings SettingKind = "UebaSettings"
)

// PossibleSettingKindValues returns an array of possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{SettingKindToggleSettings, SettingKindUebaSettings}
}

// StatusInMcas enumerates the values for status in mcas.
type StatusInMcas string

const (
	// StatusInMcasDisabled ...
	StatusInMcasDisabled StatusInMcas = "Disabled"
	// StatusInMcasEnabled ...
	StatusInMcasEnabled StatusInMcas = "Enabled"
)

// PossibleStatusInMcasValues returns an array of possible values for the StatusInMcas const type.
func PossibleStatusInMcasValues() []StatusInMcas {
	return []StatusInMcas{StatusInMcasDisabled, StatusInMcasEnabled}
}

// TriggerOperator enumerates the values for trigger operator.
type TriggerOperator string

const (
	// Equal ...
	Equal TriggerOperator = "Equal"
	// GreaterThan ...
	GreaterThan TriggerOperator = "GreaterThan"
	// LessThan ...
	LessThan TriggerOperator = "LessThan"
	// NotEqual ...
	NotEqual TriggerOperator = "NotEqual"
)

// PossibleTriggerOperatorValues returns an array of possible values for the TriggerOperator const type.
func PossibleTriggerOperatorValues() []TriggerOperator {
	return []TriggerOperator{Equal, GreaterThan, LessThan, NotEqual}
}

// AADDataConnector represents AAD (Azure Active Directory) data connector.
type AADDataConnector struct {
	// AADDataConnectorProperties - AAD (Azure Active Directory) data connector properties.
	*AADDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AADDataConnector.
func (adc AADDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindAzureActiveDirectory
	objectMap := make(map[string]interface{})
	if adc.AADDataConnectorProperties != nil {
		objectMap["properties"] = adc.AADDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsAADDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return &adc, true
}

// AsASCDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for AADDataConnector.
func (adc AADDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for AADDataConnector struct.
func (adc *AADDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aADDataConnectorProperties AADDataConnectorProperties
				err = json.Unmarshal(*v, &aADDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.AADDataConnectorProperties = &aADDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// AADDataConnectorProperties AAD (Azure Active Directory) data connector properties.
type AADDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// AccountEntity represents an account entity.
type AccountEntity struct {
	// AccountEntityProperties - Account entity properties
	*AccountEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindHost', 'KindFile'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountEntity.
func (ae AccountEntity) MarshalJSON() ([]byte, error) {
	ae.Kind = KindAccount
	objectMap := make(map[string]interface{})
	if ae.AccountEntityProperties != nil {
		objectMap["properties"] = ae.AccountEntityProperties
	}
	if ae.Kind != "" {
		objectMap["kind"] = ae.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsAccountEntity() (*AccountEntity, bool) {
	return &ae, true
}

// AsHostEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for AccountEntity.
func (ae AccountEntity) AsBasicEntity() (BasicEntity, bool) {
	return &ae, true
}

// UnmarshalJSON is the custom unmarshaler for AccountEntity struct.
func (ae *AccountEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var accountEntityProperties AccountEntityProperties
				err = json.Unmarshal(*v, &accountEntityProperties)
				if err != nil {
					return err
				}
				ae.AccountEntityProperties = &accountEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ae.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ae.Name = &name
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ae.Kind = kind
			}
		}
	}

	return nil
}

// AccountEntityProperties account entity property bag.
type AccountEntityProperties struct {
	// AccountName - READ-ONLY; The name of the account. This field should hold only the name without any domain added to it, i.e. administrator.
	AccountName *string `json:"accountName,omitempty"`
	// NtDomain - READ-ONLY; The NetBIOS domain name as it appears in the alert format – domain\username. Examples: NT AUTHORITY.
	NtDomain *string `json:"ntDomain,omitempty"`
	// UpnSuffix - READ-ONLY; The user principal name suffix for the account, in some cases it is also the domain name. Examples: contoso.com.
	UpnSuffix *string `json:"upnSuffix,omitempty"`
	// Sid - READ-ONLY; The account security identifier, e.g. S-1-5-18.
	Sid *string `json:"sid,omitempty"`
	// AadTenantID - READ-ONLY; The Azure Active Directory tenant id.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// AadUserID - READ-ONLY; The Azure Active Directory user id.
	AadUserID *string `json:"aadUserId,omitempty"`
	// Puid - READ-ONLY; The Azure Active Directory Passport User ID.
	Puid *string `json:"puid,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this is a domain account.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
	// ObjectGUID - READ-ONLY; The objectGUID attribute is a single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *uuid.UUID `json:"objectGuid,omitempty"`
}

// Action action for alert rule.
type Action struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the action.
	Etag *string `json:"etag,omitempty"`
	// ActionProperties - Action properties
	*ActionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Action.
func (a Action) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.ActionProperties != nil {
		objectMap["properties"] = a.ActionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Action struct.
func (a *Action) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "properties":
			if v != nil {
				var actionProperties ActionProperties
				err = json.Unmarshal(*v, &actionProperties)
				if err != nil {
					return err
				}
				a.ActionProperties = &actionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		}
	}

	return nil
}

// ActionProperties action property bag.
type ActionProperties struct {
	// TriggerURI - The uri for the action to trigger.
	TriggerURI *string `json:"triggerUri,omitempty"`
}

// ActionsList list all the actions.
type ActionsList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of actions.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of actions.
	Value *[]Action `json:"value,omitempty"`
}

// ActionsListIterator provides access to a complete listing of Action values.
type ActionsListIterator struct {
	i    int
	page ActionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ActionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActionsListIterator) Response() ActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActionsListIterator) Value() Action {
	if !iter.page.NotDone() {
		return Action{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ActionsListIterator type.
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return ActionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ActionsList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// actionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ActionsList) actionsListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ActionsListPage contains a page of Action values.
type ActionsListPage struct {
	fn func(context.Context, ActionsList) (ActionsList, error)
	al ActionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ActionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ActionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActionsListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActionsListPage) Response() ActionsList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActionsListPage) Values() []Action {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ActionsListPage type.
func NewActionsListPage(getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return ActionsListPage{fn: getNextPage}
}

// BasicAggregations the aggregation.
type BasicAggregations interface {
	AsCasesAggregation() (*CasesAggregation, bool)
	AsAggregations() (*Aggregations, bool)
}

// Aggregations the aggregation.
type Aggregations struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind KindBasicAggregations `json:"kind,omitempty"`
}

func unmarshalBasicAggregations(body []byte) (BasicAggregations, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCasesAggregation):
		var ca CasesAggregation
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Aggregations
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAggregationsArray(body []byte) ([]BasicAggregations, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAggregations, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAggregations(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Aggregations.
func (a Aggregations) MarshalJSON() ([]byte, error) {
	a.Kind = KindAggregations
	objectMap := make(map[string]interface{})
	if a.Kind != "" {
		objectMap["kind"] = a.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsCasesAggregation() (*CasesAggregation, bool) {
	return nil, false
}

// AsAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsAggregations() (*Aggregations, bool) {
	return &a, true
}

// AsBasicAggregations is the BasicAggregations implementation for Aggregations.
func (a Aggregations) AsBasicAggregations() (BasicAggregations, bool) {
	return &a, true
}

// AggregationsKind1 describes an Azure resource with kind.
type AggregationsKind1 struct {
	// Kind - The kind of the setting. Possible values include: 'AggregationsKindCasesAggregation'
	Kind AggregationsKind `json:"kind,omitempty"`
}

// AggregationsModel ...
type AggregationsModel struct {
	autorest.Response `json:"-"`
	Value             BasicAggregations `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AggregationsModel struct.
func (am *AggregationsModel) UnmarshalJSON(body []byte) error {
	a, err := unmarshalBasicAggregations(body)
	if err != nil {
		return err
	}
	am.Value = a

	return nil
}

// BasicAlertRule alert rule.
type BasicAlertRule interface {
	AsScheduledAlertRule() (*ScheduledAlertRule, bool)
	AsAlertRule() (*AlertRule, bool)
}

// AlertRule alert rule.
type AlertRule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindScheduled'
	Kind Kind `json:"kind,omitempty"`
}

func unmarshalBasicAlertRule(body []byte) (BasicAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindScheduled):
		var sar ScheduledAlertRule
		err := json.Unmarshal(body, &sar)
		return sar, err
	default:
		var ar AlertRule
		err := json.Unmarshal(body, &ar)
		return ar, err
	}
}
func unmarshalBasicAlertRuleArray(body []byte) ([]BasicAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arArray := make([]BasicAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ar, err := unmarshalBasicAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		arArray[index] = ar
	}
	return arArray, nil
}

// MarshalJSON is the custom marshaler for AlertRule.
func (ar AlertRule) MarshalJSON() ([]byte, error) {
	ar.Kind = KindAlertRule
	objectMap := make(map[string]interface{})
	if ar.Etag != nil {
		objectMap["etag"] = ar.Etag
	}
	if ar.Kind != "" {
		objectMap["kind"] = ar.Kind
	}
	return json.Marshal(objectMap)
}

// AsScheduledAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return nil, false
}

// AsAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsAlertRule() (*AlertRule, bool) {
	return &ar, true
}

// AsBasicAlertRule is the BasicAlertRule implementation for AlertRule.
func (ar AlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &ar, true
}

// AlertRuleKind1 describes an Azure resource with kind.
type AlertRuleKind1 struct {
	// Kind - The kind of the alert rule. Possible values include: 'Scheduled'
	Kind AlertRuleKind `json:"kind,omitempty"`
}

// AlertRuleModel ...
type AlertRuleModel struct {
	autorest.Response `json:"-"`
	Value             BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleModel struct.
func (arm *AlertRuleModel) UnmarshalJSON(body []byte) error {
	ar, err := unmarshalBasicAlertRule(body)
	if err != nil {
		return err
	}
	arm.Value = ar

	return nil
}

// AlertRulesList list all the alert rules.
type AlertRulesList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of alert rules.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of alert rules.
	Value *[]BasicAlertRule `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRulesList struct.
func (arl *AlertRulesList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				arl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicAlertRuleArray(*v)
				if err != nil {
					return err
				}
				arl.Value = &value
			}
		}
	}

	return nil
}

// AlertRulesListIterator provides access to a complete listing of AlertRule values.
type AlertRulesListIterator struct {
	i    int
	page AlertRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertRulesListIterator) Response() AlertRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertRulesListIterator) Value() BasicAlertRule {
	if !iter.page.NotDone() {
		return AlertRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertRulesListIterator type.
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return AlertRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (arl AlertRulesList) IsEmpty() bool {
	return arl.Value == nil || len(*arl.Value) == 0
}

// alertRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arl AlertRulesList) alertRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if arl.NextLink == nil || len(to.String(arl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arl.NextLink)))
}

// AlertRulesListPage contains a page of BasicAlertRule values.
type AlertRulesListPage struct {
	fn  func(context.Context, AlertRulesList) (AlertRulesList, error)
	arl AlertRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.arl)
	if err != nil {
		return err
	}
	page.arl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertRulesListPage) NotDone() bool {
	return !page.arl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertRulesListPage) Response() AlertRulesList {
	return page.arl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertRulesListPage) Values() []BasicAlertRule {
	if page.arl.IsEmpty() {
		return nil
	}
	return *page.arl.Value
}

// Creates a new instance of the AlertRulesListPage type.
func NewAlertRulesListPage(getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return AlertRulesListPage{fn: getNextPage}
}

// AlertsDataTypeOfDataConnector alerts data type for data connectors.
type AlertsDataTypeOfDataConnector struct {
	// Alerts - Alerts data type connection.
	Alerts *AlertsDataTypeOfDataConnectorAlerts `json:"alerts,omitempty"`
}

// AlertsDataTypeOfDataConnectorAlerts alerts data type connection.
type AlertsDataTypeOfDataConnectorAlerts struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// ASCDataConnector represents ASC (Azure Security Center) data connector.
type ASCDataConnector struct {
	// ASCDataConnectorProperties - ASC (Azure Security Center) data connector properties.
	*ASCDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ASCDataConnector.
func (adc ASCDataConnector) MarshalJSON() ([]byte, error) {
	adc.Kind = KindAzureSecurityCenter
	objectMap := make(map[string]interface{})
	if adc.ASCDataConnectorProperties != nil {
		objectMap["properties"] = adc.ASCDataConnectorProperties
	}
	if adc.Etag != nil {
		objectMap["etag"] = adc.Etag
	}
	if adc.Kind != "" {
		objectMap["kind"] = adc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsAADDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return &adc, true
}

// AsMCASDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for ASCDataConnector.
func (adc ASCDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &adc, true
}

// UnmarshalJSON is the custom unmarshaler for ASCDataConnector struct.
func (adc *ASCDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var aSCDataConnectorProperties ASCDataConnectorProperties
				err = json.Unmarshal(*v, &aSCDataConnectorProperties)
				if err != nil {
					return err
				}
				adc.ASCDataConnectorProperties = &aSCDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				adc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				adc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				adc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				adc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				adc.Kind = kind
			}
		}
	}

	return nil
}

// ASCDataConnectorProperties MCAS (Microsoft Cloud App Security) data connector properties.
type ASCDataConnectorProperties struct {
	// SubscriptionID - The subscription id to connect to, and get the data from.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// Bookmark represents a bookmark in Azure Security Insights.
type Bookmark struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the bookmark.
	Etag *string `json:"etag,omitempty"`
	// BookmarkProperties - Bookmark properties
	*BookmarkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Bookmark.
func (b Bookmark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if b.Etag != nil {
		objectMap["etag"] = b.Etag
	}
	if b.BookmarkProperties != nil {
		objectMap["properties"] = b.BookmarkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Bookmark struct.
func (b *Bookmark) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				b.Etag = &etag
			}
		case "properties":
			if v != nil {
				var bookmarkProperties BookmarkProperties
				err = json.Unmarshal(*v, &bookmarkProperties)
				if err != nil {
					return err
				}
				b.BookmarkProperties = &bookmarkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				b.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				b.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				b.Name = &name
			}
		}
	}

	return nil
}

// BookmarkList list all the bookmarks.
type BookmarkList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of bookmarks.
	Value *[]Bookmark `json:"value,omitempty"`
}

// BookmarkListIterator provides access to a complete listing of Bookmark values.
type BookmarkListIterator struct {
	i    int
	page BookmarkListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BookmarkListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BookmarkListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BookmarkListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BookmarkListIterator) Response() BookmarkList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BookmarkListIterator) Value() Bookmark {
	if !iter.page.NotDone() {
		return Bookmark{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BookmarkListIterator type.
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return BookmarkListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bl BookmarkList) IsEmpty() bool {
	return bl.Value == nil || len(*bl.Value) == 0
}

// bookmarkListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bl BookmarkList) bookmarkListPreparer(ctx context.Context) (*http.Request, error) {
	if bl.NextLink == nil || len(to.String(bl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bl.NextLink)))
}

// BookmarkListPage contains a page of Bookmark values.
type BookmarkListPage struct {
	fn func(context.Context, BookmarkList) (BookmarkList, error)
	bl BookmarkList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BookmarkListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BookmarkListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.bl)
	if err != nil {
		return err
	}
	page.bl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BookmarkListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BookmarkListPage) NotDone() bool {
	return !page.bl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BookmarkListPage) Response() BookmarkList {
	return page.bl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BookmarkListPage) Values() []Bookmark {
	if page.bl.IsEmpty() {
		return nil
	}
	return *page.bl.Value
}

// Creates a new instance of the BookmarkListPage type.
func NewBookmarkListPage(getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return BookmarkListPage{fn: getNextPage}
}

// BookmarkProperties describes bookmark properties
type BookmarkProperties struct {
	// DisplayName - The display name of the bookmark
	DisplayName *string `json:"displayName,omitempty"`
	// LastUpdatedTimeUtc - The last time the bookmark was updated
	LastUpdatedTimeUtc *date.Time `json:"lastUpdatedTimeUtc,omitempty"`
	// CreatedTimeUtc - The time the bookmark was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// CreatedBy - Describes a user that created the bookmark
	CreatedBy *UserInfo `json:"createdBy,omitempty"`
	// UpdatedBy - Describes a user that updated the bookmark
	UpdatedBy *UserInfo `json:"updatedBy,omitempty"`
	// Notes - The notes of the bookmark
	Notes *string `json:"notes,omitempty"`
	// Labels - List of labels relevant to this bookmark
	Labels *[]string `json:"labels,omitempty"`
	// Query - The query of the bookmark.
	Query *string `json:"query,omitempty"`
}

// Case represents a case in Azure Security Insights.
type Case struct {
	autorest.Response `json:"-"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// CaseProperties - Case properties
	*CaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Case.
func (c Case) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.CaseProperties != nil {
		objectMap["properties"] = c.CaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Case struct.
func (c *Case) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "properties":
			if v != nil {
				var caseProperties CaseProperties
				err = json.Unmarshal(*v, &caseProperties)
				if err != nil {
					return err
				}
				c.CaseProperties = &caseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		}
	}

	return nil
}

// CaseList list all the cases.
type CaseList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of cases.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of cases.
	Value *[]Case `json:"value,omitempty"`
}

// CaseListIterator provides access to a complete listing of Case values.
type CaseListIterator struct {
	i    int
	page CaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CaseListIterator) Response() CaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CaseListIterator) Value() Case {
	if !iter.page.NotDone() {
		return Case{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CaseListIterator type.
func NewCaseListIterator(page CaseListPage) CaseListIterator {
	return CaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl CaseList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// caseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl CaseList) caseListPreparer(ctx context.Context) (*http.Request, error) {
	if cl.NextLink == nil || len(to.String(cl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// CaseListPage contains a page of Case values.
type CaseListPage struct {
	fn func(context.Context, CaseList) (CaseList, error)
	cl CaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.cl)
	if err != nil {
		return err
	}
	page.cl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CaseListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CaseListPage) Response() CaseList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CaseListPage) Values() []Case {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the CaseListPage type.
func NewCaseListPage(getNextPage func(context.Context, CaseList) (CaseList, error)) CaseListPage {
	return CaseListPage{fn: getNextPage}
}

// CaseProperties describes case properties
type CaseProperties struct {
	// LastUpdatedTimeUtc - The last time the case was updated
	LastUpdatedTimeUtc *date.Time `json:"lastUpdatedTimeUtc,omitempty"`
	// CreatedTimeUtc - The time the case was created
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// EndTimeUtc - The end time of the case
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// StartTimeUtc - The start time of the case
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Labels - List of labels relevant to this case
	Labels *[]string `json:"labels,omitempty"`
	// Description - The description of the case
	Description *string `json:"description,omitempty"`
	// Title - The title of the case
	Title *string `json:"title,omitempty"`
	// AssignedTo - Describes a user that the case is assigned to
	AssignedTo *UserInfo `json:"assignedTo,omitempty"`
	// Severity - The severity of the case. Possible values include: 'CaseSeverityCritical', 'CaseSeverityHigh', 'CaseSeverityMedium', 'CaseSeverityLow', 'CaseSeverityInformational'
	Severity CaseSeverity `json:"severity,omitempty"`
	// Status - The status of the case. Possible values include: 'CaseStatusDraft', 'CaseStatusNew', 'CaseStatusInProgress', 'CaseStatusClosed'
	Status CaseStatus `json:"status,omitempty"`
	// CloseReason - The reason the case was closed. Possible values include: 'Resolved', 'Dismissed', 'Other'
	CloseReason CloseReason `json:"closeReason,omitempty"`
}

// CasesAggregation represents aggregations results for cases.
type CasesAggregation struct {
	// CasesAggregationProperties - Properties of aggregations results of cases.
	*CasesAggregationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindAggregations', 'KindCasesAggregation'
	Kind KindBasicAggregations `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CasesAggregation.
func (ca CasesAggregation) MarshalJSON() ([]byte, error) {
	ca.Kind = KindCasesAggregation
	objectMap := make(map[string]interface{})
	if ca.CasesAggregationProperties != nil {
		objectMap["properties"] = ca.CasesAggregationProperties
	}
	if ca.Kind != "" {
		objectMap["kind"] = ca.Kind
	}
	return json.Marshal(objectMap)
}

// AsCasesAggregation is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsCasesAggregation() (*CasesAggregation, bool) {
	return &ca, true
}

// AsAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsAggregations() (*Aggregations, bool) {
	return nil, false
}

// AsBasicAggregations is the BasicAggregations implementation for CasesAggregation.
func (ca CasesAggregation) AsBasicAggregations() (BasicAggregations, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CasesAggregation struct.
func (ca *CasesAggregation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var casesAggregationProperties CasesAggregationProperties
				err = json.Unmarshal(*v, &casesAggregationProperties)
				if err != nil {
					return err
				}
				ca.CasesAggregationProperties = &casesAggregationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ca.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "kind":
			if v != nil {
				var kind KindBasicAggregations
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ca.Kind = kind
			}
		}
	}

	return nil
}

// CasesAggregationBySeverityProperties aggregative results of cases by severity property bag.
type CasesAggregationBySeverityProperties struct {
	// TotalCriticalSeverity - READ-ONLY; Total amount of open cases with severity Critical
	TotalCriticalSeverity *int32 `json:"totalCriticalSeverity,omitempty"`
	// TotalHighSeverity - READ-ONLY; Total amount of open cases with severity High
	TotalHighSeverity *int32 `json:"totalHighSeverity,omitempty"`
	// TotalMediumSeverity - READ-ONLY; Total amount of open cases with severity medium
	TotalMediumSeverity *int32 `json:"totalMediumSeverity,omitempty"`
	// TotalLowSeverity - READ-ONLY; Total amount of open cases with severity Low
	TotalLowSeverity *int32 `json:"totalLowSeverity,omitempty"`
	// TotalInformationalSeverity - READ-ONLY; Total amount of open cases with severity Informational
	TotalInformationalSeverity *int32 `json:"totalInformationalSeverity,omitempty"`
}

// CasesAggregationByStatusProperties aggregative results of cases by status property bag.
type CasesAggregationByStatusProperties struct {
	// TotalNewStatus - READ-ONLY; Total amount of open cases with status New
	TotalNewStatus *int32 `json:"totalNewStatus,omitempty"`
	// TotalInProgressStatus - READ-ONLY; Total amount of open cases with status InProgress
	TotalInProgressStatus *int32 `json:"totalInProgressStatus,omitempty"`
	// TotalResolvedStatus - READ-ONLY; Total amount of open cases with status Resolved
	TotalResolvedStatus *int32 `json:"totalResolvedStatus,omitempty"`
	// TotalDismissedStatus - READ-ONLY; Total amount of open cases with status Dismissed
	TotalDismissedStatus *int32 `json:"totalDismissedStatus,omitempty"`
}

// CasesAggregationProperties aggregative results of cases property bag.
type CasesAggregationProperties struct {
	// AggregationBySeverity - Aggregations results by case severity.
	AggregationBySeverity *CasesAggregationBySeverityProperties `json:"aggregationBySeverity,omitempty"`
	// AggregationByStatus - Aggregations results by case status.
	AggregationByStatus *CasesAggregationByStatusProperties `json:"aggregationByStatus,omitempty"`
}

// CloudError error response structure.
type CloudError struct {
	// CloudErrorBody - Error data
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody error details.
type CloudErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// BasicDataConnector data connector.
type BasicDataConnector interface {
	AsOfficeDataConnector() (*OfficeDataConnector, bool)
	AsTIDataConnector() (*TIDataConnector, bool)
	AsAADDataConnector() (*AADDataConnector, bool)
	AsASCDataConnector() (*ASCDataConnector, bool)
	AsMCASDataConnector() (*MCASDataConnector, bool)
	AsDataConnector() (*DataConnector, bool)
}

// DataConnector data connector.
type DataConnector struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

func unmarshalBasicDataConnector(body []byte) (BasicDataConnector, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindOffice365):
		var odc OfficeDataConnector
		err := json.Unmarshal(body, &odc)
		return odc, err
	case string(KindThreatIntelligence):
		var tdc TIDataConnector
		err := json.Unmarshal(body, &tdc)
		return tdc, err
	case string(KindAzureActiveDirectory):
		var adc AADDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindAzureSecurityCenter):
		var adc ASCDataConnector
		err := json.Unmarshal(body, &adc)
		return adc, err
	case string(KindMicrosoftCloudAppSecurity):
		var mdc MCASDataConnector
		err := json.Unmarshal(body, &mdc)
		return mdc, err
	default:
		var dc DataConnector
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDataConnectorArray(body []byte) ([]BasicDataConnector, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDataConnector, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDataConnector(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DataConnector.
func (dc DataConnector) MarshalJSON() ([]byte, error) {
	dc.Kind = KindDataConnector
	objectMap := make(map[string]interface{})
	if dc.Etag != nil {
		objectMap["etag"] = dc.Etag
	}
	if dc.Kind != "" {
		objectMap["kind"] = dc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsAADDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsDataConnector() (*DataConnector, bool) {
	return &dc, true
}

// AsBasicDataConnector is the BasicDataConnector implementation for DataConnector.
func (dc DataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &dc, true
}

// DataConnectorDataTypeCommon common field for data type in data connectors.
type DataConnectorDataTypeCommon struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// DataConnectorKind1 describes an Azure resource with kind.
type DataConnectorKind1 struct {
	// Kind - The kind of the data connector. Possible values include: 'AzureActiveDirectory', 'AzureSecurityCenter', 'MicrosoftCloudAppSecurity', 'ThreatIntelligence', 'Office365'
	Kind DataConnectorKind `json:"kind,omitempty"`
}

// DataConnectorList list all the data connectors.
type DataConnectorList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of data connectors.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of data connectors.
	Value *[]BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorList struct.
func (dcl *DataConnectorList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				dcl.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicDataConnectorArray(*v)
				if err != nil {
					return err
				}
				dcl.Value = &value
			}
		}
	}

	return nil
}

// DataConnectorListIterator provides access to a complete listing of DataConnector values.
type DataConnectorListIterator struct {
	i    int
	page DataConnectorListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataConnectorListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataConnectorListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataConnectorListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataConnectorListIterator) Response() DataConnectorList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataConnectorListIterator) Value() BasicDataConnector {
	if !iter.page.NotDone() {
		return DataConnector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataConnectorListIterator type.
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return DataConnectorListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcl DataConnectorList) IsEmpty() bool {
	return dcl.Value == nil || len(*dcl.Value) == 0
}

// dataConnectorListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcl DataConnectorList) dataConnectorListPreparer(ctx context.Context) (*http.Request, error) {
	if dcl.NextLink == nil || len(to.String(dcl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcl.NextLink)))
}

// DataConnectorListPage contains a page of BasicDataConnector values.
type DataConnectorListPage struct {
	fn  func(context.Context, DataConnectorList) (DataConnectorList, error)
	dcl DataConnectorList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataConnectorListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataConnectorListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dcl)
	if err != nil {
		return err
	}
	page.dcl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataConnectorListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataConnectorListPage) NotDone() bool {
	return !page.dcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataConnectorListPage) Response() DataConnectorList {
	return page.dcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataConnectorListPage) Values() []BasicDataConnector {
	if page.dcl.IsEmpty() {
		return nil
	}
	return *page.dcl.Value
}

// Creates a new instance of the DataConnectorListPage type.
func NewDataConnectorListPage(getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return DataConnectorListPage{fn: getNextPage}
}

// DataConnectorModel ...
type DataConnectorModel struct {
	autorest.Response `json:"-"`
	Value             BasicDataConnector `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataConnectorModel struct.
func (dcm *DataConnectorModel) UnmarshalJSON(body []byte) error {
	dc, err := unmarshalBasicDataConnector(body)
	if err != nil {
		return err
	}
	dcm.Value = dc

	return nil
}

// DataConnectorTenantID properties data connector on tenant level.
type DataConnectorTenantID struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// DataConnectorWithAlertsProperties data connector properties.
type DataConnectorWithAlertsProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// BasicEntity specific entity.
type BasicEntity interface {
	AsAccountEntity() (*AccountEntity, bool)
	AsHostEntity() (*HostEntity, bool)
	AsFileEntity() (*FileEntity, bool)
	AsEntity() (*Entity, bool)
}

// Entity specific entity.
type Entity struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindHost', 'KindFile'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

func unmarshalBasicEntity(body []byte) (BasicEntity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindAccount):
		var ae AccountEntity
		err := json.Unmarshal(body, &ae)
		return ae, err
	case string(KindHost):
		var he HostEntity
		err := json.Unmarshal(body, &he)
		return he, err
	case string(KindFile):
		var fe FileEntity
		err := json.Unmarshal(body, &fe)
		return fe, err
	default:
		var e Entity
		err := json.Unmarshal(body, &e)
		return e, err
	}
}
func unmarshalBasicEntityArray(body []byte) ([]BasicEntity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eArray := make([]BasicEntity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		e, err := unmarshalBasicEntity(*rawMessage)
		if err != nil {
			return nil, err
		}
		eArray[index] = e
	}
	return eArray, nil
}

// MarshalJSON is the custom marshaler for Entity.
func (e Entity) MarshalJSON() ([]byte, error) {
	e.Kind = KindEntity
	objectMap := make(map[string]interface{})
	if e.Kind != "" {
		objectMap["kind"] = e.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for Entity.
func (e Entity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for Entity.
func (e Entity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for Entity.
func (e Entity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for Entity.
func (e Entity) AsEntity() (*Entity, bool) {
	return &e, true
}

// AsBasicEntity is the BasicEntity implementation for Entity.
func (e Entity) AsBasicEntity() (BasicEntity, bool) {
	return &e, true
}

// EntityKind1 describes an Azure resource with kind.
type EntityKind1 struct {
	// Kind - The kind of the entity. Possible values include: 'Account', 'Host', 'File'
	Kind EntityKind `json:"kind,omitempty"`
}

// EntityList list of all the entities.
type EntityList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entities.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entities.
	Value *[]BasicEntity `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityList struct.
func (el *EntityList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				el.NextLink = &nextLink
			}
		case "value":
			if v != nil {
				value, err := unmarshalBasicEntityArray(*v)
				if err != nil {
					return err
				}
				el.Value = &value
			}
		}
	}

	return nil
}

// EntityListIterator provides access to a complete listing of Entity values.
type EntityListIterator struct {
	i    int
	page EntityListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityListIterator) Response() EntityList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityListIterator) Value() BasicEntity {
	if !iter.page.NotDone() {
		return Entity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityListIterator type.
func NewEntityListIterator(page EntityListPage) EntityListIterator {
	return EntityListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el EntityList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// entityListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el EntityList) entityListPreparer(ctx context.Context) (*http.Request, error) {
	if el.NextLink == nil || len(to.String(el.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// EntityListPage contains a page of BasicEntity values.
type EntityListPage struct {
	fn func(context.Context, EntityList) (EntityList, error)
	el EntityList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.el)
	if err != nil {
		return err
	}
	page.el = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityListPage) Response() EntityList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityListPage) Values() []BasicEntity {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the EntityListPage type.
func NewEntityListPage(getNextPage func(context.Context, EntityList) (EntityList, error)) EntityListPage {
	return EntityListPage{fn: getNextPage}
}

// EntityModel ...
type EntityModel struct {
	autorest.Response `json:"-"`
	Value             BasicEntity `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EntityModel struct.
func (em *EntityModel) UnmarshalJSON(body []byte) error {
	e, err := unmarshalBasicEntity(body)
	if err != nil {
		return err
	}
	em.Value = e

	return nil
}

// EntityQuery specific entity query.
type EntityQuery struct {
	autorest.Response `json:"-"`
	// EntityQueryProperties - Entity query properties
	*EntityQueryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for EntityQuery.
func (eq EntityQuery) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eq.EntityQueryProperties != nil {
		objectMap["properties"] = eq.EntityQueryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EntityQuery struct.
func (eq *EntityQuery) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var entityQueryProperties EntityQueryProperties
				err = json.Unmarshal(*v, &entityQueryProperties)
				if err != nil {
					return err
				}
				eq.EntityQueryProperties = &entityQueryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				eq.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				eq.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				eq.Name = &name
			}
		}
	}

	return nil
}

// EntityQueryList list of all the entity queries.
type EntityQueryList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of entity queries.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of entity queries.
	Value *[]EntityQuery `json:"value,omitempty"`
}

// EntityQueryListIterator provides access to a complete listing of EntityQuery values.
type EntityQueryListIterator struct {
	i    int
	page EntityQueryListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EntityQueryListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EntityQueryListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EntityQueryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EntityQueryListIterator) Response() EntityQueryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EntityQueryListIterator) Value() EntityQuery {
	if !iter.page.NotDone() {
		return EntityQuery{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EntityQueryListIterator type.
func NewEntityQueryListIterator(page EntityQueryListPage) EntityQueryListIterator {
	return EntityQueryListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eql EntityQueryList) IsEmpty() bool {
	return eql.Value == nil || len(*eql.Value) == 0
}

// entityQueryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eql EntityQueryList) entityQueryListPreparer(ctx context.Context) (*http.Request, error) {
	if eql.NextLink == nil || len(to.String(eql.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eql.NextLink)))
}

// EntityQueryListPage contains a page of EntityQuery values.
type EntityQueryListPage struct {
	fn  func(context.Context, EntityQueryList) (EntityQueryList, error)
	eql EntityQueryList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EntityQueryListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EntityQueryListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.eql)
	if err != nil {
		return err
	}
	page.eql = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EntityQueryListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EntityQueryListPage) NotDone() bool {
	return !page.eql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EntityQueryListPage) Response() EntityQueryList {
	return page.eql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EntityQueryListPage) Values() []EntityQuery {
	if page.eql.IsEmpty() {
		return nil
	}
	return *page.eql.Value
}

// Creates a new instance of the EntityQueryListPage type.
func NewEntityQueryListPage(getNextPage func(context.Context, EntityQueryList) (EntityQueryList, error)) EntityQueryListPage {
	return EntityQueryListPage{fn: getNextPage}
}

// EntityQueryProperties describes entity query properties
type EntityQueryProperties struct {
	// QueryTemplate - The template query string to be parsed and formatted
	QueryTemplate *string `json:"queryTemplate,omitempty"`
	// InputEntityType - The type of the query's source entity
	InputEntityType *string `json:"inputEntityType,omitempty"`
	// InputFields - List of the fields of the source entity that are required to run the query
	InputFields *[]string `json:"inputFields,omitempty"`
	// OutputEntityTypes - List of the desired output types to be constructed from the result
	OutputEntityTypes *[]string `json:"outputEntityTypes,omitempty"`
	// DataSources - List of the data sources that are required to run the query
	DataSources *[]string `json:"dataSources,omitempty"`
	// DisplayName - The query display name
	DisplayName *string `json:"displayName,omitempty"`
}

// FileEntity represents a file entity.
type FileEntity struct {
	// FileEntityProperties - File entity properties
	*FileEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindHost', 'KindFile'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for FileEntity.
func (fe FileEntity) MarshalJSON() ([]byte, error) {
	fe.Kind = KindFile
	objectMap := make(map[string]interface{})
	if fe.FileEntityProperties != nil {
		objectMap["properties"] = fe.FileEntityProperties
	}
	if fe.Kind != "" {
		objectMap["kind"] = fe.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsHostEntity() (*HostEntity, bool) {
	return nil, false
}

// AsFileEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsFileEntity() (*FileEntity, bool) {
	return &fe, true
}

// AsEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for FileEntity.
func (fe FileEntity) AsBasicEntity() (BasicEntity, bool) {
	return &fe, true
}

// UnmarshalJSON is the custom unmarshaler for FileEntity struct.
func (fe *FileEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileEntityProperties FileEntityProperties
				err = json.Unmarshal(*v, &fileEntityProperties)
				if err != nil {
					return err
				}
				fe.FileEntityProperties = &fileEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fe.Kind = kind
			}
		}
	}

	return nil
}

// FileEntityProperties file entity property bag.
type FileEntityProperties struct {
	// Directory - READ-ONLY; The full path to the file.
	Directory *string `json:"directory,omitempty"`
	// FileName - READ-ONLY; The file name without path (some alerts might not include path).
	FileName *string `json:"fileName,omitempty"`
}

// HostEntity represents a host entity.
type HostEntity struct {
	// HostEntityProperties - Host entity properties
	*HostEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Kind - Possible values include: 'KindEntity', 'KindAccount', 'KindHost', 'KindFile'
	Kind KindBasicEntity `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for HostEntity.
func (he HostEntity) MarshalJSON() ([]byte, error) {
	he.Kind = KindHost
	objectMap := make(map[string]interface{})
	if he.HostEntityProperties != nil {
		objectMap["properties"] = he.HostEntityProperties
	}
	if he.Kind != "" {
		objectMap["kind"] = he.Kind
	}
	return json.Marshal(objectMap)
}

// AsAccountEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsAccountEntity() (*AccountEntity, bool) {
	return nil, false
}

// AsHostEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsHostEntity() (*HostEntity, bool) {
	return &he, true
}

// AsFileEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsFileEntity() (*FileEntity, bool) {
	return nil, false
}

// AsEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsEntity() (*Entity, bool) {
	return nil, false
}

// AsBasicEntity is the BasicEntity implementation for HostEntity.
func (he HostEntity) AsBasicEntity() (BasicEntity, bool) {
	return &he, true
}

// UnmarshalJSON is the custom unmarshaler for HostEntity struct.
func (he *HostEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostEntityProperties HostEntityProperties
				err = json.Unmarshal(*v, &hostEntityProperties)
				if err != nil {
					return err
				}
				he.HostEntityProperties = &hostEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				he.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				he.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				he.Name = &name
			}
		case "kind":
			if v != nil {
				var kind KindBasicEntity
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				he.Kind = kind
			}
		}
	}

	return nil
}

// HostEntityProperties host entity property bag.
type HostEntityProperties struct {
	// DNSDomain - READ-ONLY; The DNS domain that this host belongs to. Should contain the compete DNS suffix for the domain
	DNSDomain *string `json:"dnsDomain,omitempty"`
	// NtDomain - READ-ONLY; The NT domain that this host belongs to.
	NtDomain *string `json:"ntDomain,omitempty"`
	// HostName - READ-ONLY; The hostname without the domain suffix.
	HostName *string `json:"hostName,omitempty"`
	// NetBiosName - READ-ONLY; The host name (pre-windows2000).
	NetBiosName *string `json:"netBiosName,omitempty"`
	// AzureID - READ-ONLY; The azure resource id of the VM.
	AzureID *string `json:"azureID,omitempty"`
	// OmsAgentID - READ-ONLY; The OMS agent id, if the host has OMS agent installed.
	OmsAgentID *string `json:"omsAgentID,omitempty"`
	// OsFamily - The operating system type. Possible values include: 'Linux', 'Windows', 'Android', 'IOS'
	OsFamily OSFamily `json:"osFamily,omitempty"`
	// OsVersion - READ-ONLY; A free text representation of the operating system. This field is meant to hold specific versions the are more fine grained than OSFamily or future values not supported by OSFamily enumeration
	OsVersion *string `json:"osVersion,omitempty"`
	// IsDomainJoined - READ-ONLY; Determines whether this host belongs to a domain.
	IsDomainJoined *bool `json:"isDomainJoined,omitempty"`
}

// MCASDataConnector represents MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnector struct {
	// MCASDataConnectorProperties - MCAS (Microsoft Cloud App Security) data connector properties.
	*MCASDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for MCASDataConnector.
func (mdc MCASDataConnector) MarshalJSON() ([]byte, error) {
	mdc.Kind = KindMicrosoftCloudAppSecurity
	objectMap := make(map[string]interface{})
	if mdc.MCASDataConnectorProperties != nil {
		objectMap["properties"] = mdc.MCASDataConnectorProperties
	}
	if mdc.Etag != nil {
		objectMap["etag"] = mdc.Etag
	}
	if mdc.Kind != "" {
		objectMap["kind"] = mdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsAADDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return &mdc, true
}

// AsDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for MCASDataConnector.
func (mdc MCASDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &mdc, true
}

// UnmarshalJSON is the custom unmarshaler for MCASDataConnector struct.
func (mdc *MCASDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mCASDataConnectorProperties MCASDataConnectorProperties
				err = json.Unmarshal(*v, &mCASDataConnectorProperties)
				if err != nil {
					return err
				}
				mdc.MCASDataConnectorProperties = &mCASDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdc.Kind = kind
			}
		}
	}

	return nil
}

// MCASDataConnectorProperties MCAS (Microsoft Cloud App Security) data connector properties.
type MCASDataConnectorProperties struct {
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
	// DataTypes - The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector `json:"dataTypes,omitempty"`
}

// OfficeConsent consent for Office365 tenant that already made.
type OfficeConsent struct {
	autorest.Response `json:"-"`
	// OfficeConsentProperties - Office consent properties
	*OfficeConsentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeConsent.
func (oc OfficeConsent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oc.OfficeConsentProperties != nil {
		objectMap["properties"] = oc.OfficeConsentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OfficeConsent struct.
func (oc *OfficeConsent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeConsentProperties OfficeConsentProperties
				err = json.Unmarshal(*v, &officeConsentProperties)
				if err != nil {
					return err
				}
				oc.OfficeConsentProperties = &officeConsentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oc.Name = &name
			}
		}
	}

	return nil
}

// OfficeConsentList list of all the office365 consents.
type OfficeConsentList struct {
	autorest.Response `json:"-"`
	// NextLink - READ-ONLY; URL to fetch the next set of office consents.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of the consents.
	Value *[]OfficeConsent `json:"value,omitempty"`
}

// OfficeConsentListIterator provides access to a complete listing of OfficeConsent values.
type OfficeConsentListIterator struct {
	i    int
	page OfficeConsentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OfficeConsentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OfficeConsentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OfficeConsentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OfficeConsentListIterator) Response() OfficeConsentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OfficeConsentListIterator) Value() OfficeConsent {
	if !iter.page.NotDone() {
		return OfficeConsent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OfficeConsentListIterator type.
func NewOfficeConsentListIterator(page OfficeConsentListPage) OfficeConsentListIterator {
	return OfficeConsentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ocl OfficeConsentList) IsEmpty() bool {
	return ocl.Value == nil || len(*ocl.Value) == 0
}

// officeConsentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ocl OfficeConsentList) officeConsentListPreparer(ctx context.Context) (*http.Request, error) {
	if ocl.NextLink == nil || len(to.String(ocl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ocl.NextLink)))
}

// OfficeConsentListPage contains a page of OfficeConsent values.
type OfficeConsentListPage struct {
	fn  func(context.Context, OfficeConsentList) (OfficeConsentList, error)
	ocl OfficeConsentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OfficeConsentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OfficeConsentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ocl)
	if err != nil {
		return err
	}
	page.ocl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OfficeConsentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OfficeConsentListPage) NotDone() bool {
	return !page.ocl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OfficeConsentListPage) Response() OfficeConsentList {
	return page.ocl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OfficeConsentListPage) Values() []OfficeConsent {
	if page.ocl.IsEmpty() {
		return nil
	}
	return *page.ocl.Value
}

// Creates a new instance of the OfficeConsentListPage type.
func NewOfficeConsentListPage(getNextPage func(context.Context, OfficeConsentList) (OfficeConsentList, error)) OfficeConsentListPage {
	return OfficeConsentListPage{fn: getNextPage}
}

// OfficeConsentProperties consent property bag.
type OfficeConsentProperties struct {
	// TenantID - The tenantId of the Office365 with the consent.
	TenantID *string `json:"tenantId,omitempty"`
	// TenantName - READ-ONLY; The tenant name of the Office365 with the consent.
	TenantName *string `json:"tenantName,omitempty"`
}

// OfficeDataConnector represents office data connector.
type OfficeDataConnector struct {
	// OfficeDataConnectorProperties - Office data connector properties.
	*OfficeDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for OfficeDataConnector.
func (odc OfficeDataConnector) MarshalJSON() ([]byte, error) {
	odc.Kind = KindOffice365
	objectMap := make(map[string]interface{})
	if odc.OfficeDataConnectorProperties != nil {
		objectMap["properties"] = odc.OfficeDataConnectorProperties
	}
	if odc.Etag != nil {
		objectMap["etag"] = odc.Etag
	}
	if odc.Kind != "" {
		objectMap["kind"] = odc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return &odc, true
}

// AsTIDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return nil, false
}

// AsAADDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for OfficeDataConnector.
func (odc OfficeDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &odc, true
}

// UnmarshalJSON is the custom unmarshaler for OfficeDataConnector struct.
func (odc *OfficeDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var officeDataConnectorProperties OfficeDataConnectorProperties
				err = json.Unmarshal(*v, &officeDataConnectorProperties)
				if err != nil {
					return err
				}
				odc.OfficeDataConnectorProperties = &officeDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				odc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				odc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				odc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				odc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				odc.Kind = kind
			}
		}
	}

	return nil
}

// OfficeDataConnectorDataTypes the available data types for office data connector.
type OfficeDataConnectorDataTypes struct {
	// SharePoint - SharePoint data type connection.
	SharePoint *OfficeDataConnectorDataTypesSharePoint `json:"sharePoint,omitempty"`
	// Exchange - Exchange data type connection.
	Exchange *OfficeDataConnectorDataTypesExchange `json:"exchange,omitempty"`
}

// OfficeDataConnectorDataTypesExchange exchange data type connection.
type OfficeDataConnectorDataTypesExchange struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorDataTypesSharePoint sharePoint data type connection.
type OfficeDataConnectorDataTypesSharePoint struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// OfficeDataConnectorProperties office data connector properties.
type OfficeDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *OfficeDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// Operation operation provided by provider
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Display - Properties of the operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay properties of the operation
type OperationDisplay struct {
	// Provider - Provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation name
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationsList lists the operations available in the SecurityInsights RP.
type OperationsList struct {
	autorest.Response `json:"-"`
	// NextLink - URL to fetch the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - Array of operations
	Value *[]Operation `json:"value,omitempty"`
}

// OperationsListIterator provides access to a complete listing of Operation values.
type OperationsListIterator struct {
	i    int
	page OperationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListIterator) Response() OperationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationsListIterator type.
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return OperationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationsList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// operationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationsList) operationsListPreparer(ctx context.Context) (*http.Request, error) {
	if ol.NextLink == nil || len(to.String(ol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationsListPage contains a page of Operation values.
type OperationsListPage struct {
	fn func(context.Context, OperationsList) (OperationsList, error)
	ol OperationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ol)
	if err != nil {
		return err
	}
	page.ol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListPage) Response() OperationsList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationsListPage type.
func NewOperationsListPage(getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return OperationsListPage{fn: getNextPage}
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
}

// ScheduledAlertRule represents scheduled alert rule.
type ScheduledAlertRule struct {
	// ScheduledAlertRuleProperties - Scheduled alert rule properties
	*ScheduledAlertRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindAlertRule', 'KindScheduled'
	Kind Kind `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduledAlertRule.
func (sar ScheduledAlertRule) MarshalJSON() ([]byte, error) {
	sar.Kind = KindScheduled
	objectMap := make(map[string]interface{})
	if sar.ScheduledAlertRuleProperties != nil {
		objectMap["properties"] = sar.ScheduledAlertRuleProperties
	}
	if sar.Etag != nil {
		objectMap["etag"] = sar.Etag
	}
	if sar.Kind != "" {
		objectMap["kind"] = sar.Kind
	}
	return json.Marshal(objectMap)
}

// AsScheduledAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsScheduledAlertRule() (*ScheduledAlertRule, bool) {
	return &sar, true
}

// AsAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsAlertRule() (*AlertRule, bool) {
	return nil, false
}

// AsBasicAlertRule is the BasicAlertRule implementation for ScheduledAlertRule.
func (sar ScheduledAlertRule) AsBasicAlertRule() (BasicAlertRule, bool) {
	return &sar, true
}

// UnmarshalJSON is the custom unmarshaler for ScheduledAlertRule struct.
func (sar *ScheduledAlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scheduledAlertRuleProperties ScheduledAlertRuleProperties
				err = json.Unmarshal(*v, &scheduledAlertRuleProperties)
				if err != nil {
					return err
				}
				sar.ScheduledAlertRuleProperties = &scheduledAlertRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sar.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sar.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				sar.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sar.Kind = kind
			}
		}
	}

	return nil
}

// ScheduledAlertRuleProperties alert rule property bag.
type ScheduledAlertRuleProperties struct {
	// DisplayName - The display name for alerts created by this alert rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the alert rule.
	Description *string `json:"description,omitempty"`
	// Severity - The severity for alerts created by this alert rule. Possible values include: 'High', 'Medium', 'Low', 'Informational'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Enabled - Determines whether this alert rule is enabled or disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Query - The query that creates alerts for this rule.
	Query *string `json:"query,omitempty"`
	// QueryFrequency - The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string `json:"queryFrequency,omitempty"`
	// QueryPeriod - The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string `json:"queryPeriod,omitempty"`
	// TriggerOperator - The operation against the threshold that triggers alert rule. Possible values include: 'GreaterThan', 'LessThan', 'Equal', 'NotEqual'
	TriggerOperator TriggerOperator `json:"triggerOperator,omitempty"`
	// TriggerThreshold - The threshold triggers this alert rule.
	TriggerThreshold *int32 `json:"triggerThreshold,omitempty"`
	// SuppressionEnabled - Determines whether the suppression for this alert rule is enabled or disabled.
	SuppressionEnabled *bool `json:"suppressionEnabled,omitempty"`
	// SuppressionDuration - The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
	SuppressionDuration *string `json:"suppressionDuration,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time that this alert has been modified.
	LastModifiedUtc *string `json:"lastModifiedUtc,omitempty"`
}

// BasicSettings the Setting.
type BasicSettings interface {
	AsUebaSettings() (*UebaSettings, bool)
	AsToggleSettings() (*ToggleSettings, bool)
	AsSettings() (*Settings, bool)
}

// Settings the Setting.
type Settings struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindSettings', 'KindUebaSettings', 'KindToggleSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

func unmarshalBasicSettings(body []byte) (BasicSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindUebaSettings):
		var us UebaSettings
		err := json.Unmarshal(body, &us)
		return us, err
	case string(KindToggleSettings):
		var ts ToggleSettings
		err := json.Unmarshal(body, &ts)
		return ts, err
	default:
		var s Settings
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSettingsArray(body []byte) ([]BasicSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Settings.
func (s Settings) MarshalJSON() ([]byte, error) {
	s.Kind = KindSettings
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	return json.Marshal(objectMap)
}

// AsUebaSettings is the BasicSettings implementation for Settings.
func (s Settings) AsUebaSettings() (*UebaSettings, bool) {
	return nil, false
}

// AsToggleSettings is the BasicSettings implementation for Settings.
func (s Settings) AsToggleSettings() (*ToggleSettings, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for Settings.
func (s Settings) AsSettings() (*Settings, bool) {
	return &s, true
}

// AsBasicSettings is the BasicSettings implementation for Settings.
func (s Settings) AsBasicSettings() (BasicSettings, bool) {
	return &s, true
}

// SettingsKind describes an Azure resource with kind.
type SettingsKind struct {
	// Kind - The kind of the setting. Possible values include: 'SettingKindUebaSettings', 'SettingKindToggleSettings'
	Kind SettingKind `json:"kind,omitempty"`
}

// SettingsModel ...
type SettingsModel struct {
	autorest.Response `json:"-"`
	Value             BasicSettings `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingsModel struct.
func (sm *SettingsModel) UnmarshalJSON(body []byte) error {
	s, err := unmarshalBasicSettings(body)
	if err != nil {
		return err
	}
	sm.Value = s

	return nil
}

// TIDataConnector represents threat intelligence data connector.
type TIDataConnector struct {
	// TIDataConnectorProperties - TI (Threat Intelligence) data connector properties.
	*TIDataConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the data connector.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindDataConnector', 'KindOffice365', 'KindThreatIntelligence', 'KindAzureActiveDirectory', 'KindAzureSecurityCenter', 'KindMicrosoftCloudAppSecurity'
	Kind KindBasicDataConnector `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for TIDataConnector.
func (tdc TIDataConnector) MarshalJSON() ([]byte, error) {
	tdc.Kind = KindThreatIntelligence
	objectMap := make(map[string]interface{})
	if tdc.TIDataConnectorProperties != nil {
		objectMap["properties"] = tdc.TIDataConnectorProperties
	}
	if tdc.Etag != nil {
		objectMap["etag"] = tdc.Etag
	}
	if tdc.Kind != "" {
		objectMap["kind"] = tdc.Kind
	}
	return json.Marshal(objectMap)
}

// AsOfficeDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsOfficeDataConnector() (*OfficeDataConnector, bool) {
	return nil, false
}

// AsTIDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsTIDataConnector() (*TIDataConnector, bool) {
	return &tdc, true
}

// AsAADDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsAADDataConnector() (*AADDataConnector, bool) {
	return nil, false
}

// AsASCDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsASCDataConnector() (*ASCDataConnector, bool) {
	return nil, false
}

// AsMCASDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsMCASDataConnector() (*MCASDataConnector, bool) {
	return nil, false
}

// AsDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsDataConnector() (*DataConnector, bool) {
	return nil, false
}

// AsBasicDataConnector is the BasicDataConnector implementation for TIDataConnector.
func (tdc TIDataConnector) AsBasicDataConnector() (BasicDataConnector, bool) {
	return &tdc, true
}

// UnmarshalJSON is the custom unmarshaler for TIDataConnector struct.
func (tdc *TIDataConnector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tIDataConnectorProperties TIDataConnectorProperties
				err = json.Unmarshal(*v, &tIDataConnectorProperties)
				if err != nil {
					return err
				}
				tdc.TIDataConnectorProperties = &tIDataConnectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdc.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdc.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdc.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				tdc.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicDataConnector
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tdc.Kind = kind
			}
		}
	}

	return nil
}

// TIDataConnectorDataTypes the available data types for TI (Threat Intelligence) data connector.
type TIDataConnectorDataTypes struct {
	// Indicators - Data type for indicators connection.
	Indicators *TIDataConnectorDataTypesIndicators `json:"indicators,omitempty"`
}

// TIDataConnectorDataTypesIndicators data type for indicators connection.
type TIDataConnectorDataTypesIndicators struct {
	// State - Describe whether this data type connection is enabled or not. Possible values include: 'Enabled', 'Disabled'
	State DataTypeState `json:"state,omitempty"`
}

// TIDataConnectorProperties TI (Threat Intelligence) data connector properties.
type TIDataConnectorProperties struct {
	// DataTypes - The available data types for the connector.
	DataTypes *TIDataConnectorDataTypes `json:"dataTypes,omitempty"`
	// TenantID - The tenant id to connect to, and get the data from.
	TenantID *string `json:"tenantId,omitempty"`
}

// ToggleSettings settings with single toggle.
type ToggleSettings struct {
	// ToggleSettingsProperties - toggle properties
	*ToggleSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindSettings', 'KindUebaSettings', 'KindToggleSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for ToggleSettings.
func (ts ToggleSettings) MarshalJSON() ([]byte, error) {
	ts.Kind = KindToggleSettings
	objectMap := make(map[string]interface{})
	if ts.ToggleSettingsProperties != nil {
		objectMap["properties"] = ts.ToggleSettingsProperties
	}
	if ts.Etag != nil {
		objectMap["etag"] = ts.Etag
	}
	if ts.Kind != "" {
		objectMap["kind"] = ts.Kind
	}
	return json.Marshal(objectMap)
}

// AsUebaSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsUebaSettings() (*UebaSettings, bool) {
	return nil, false
}

// AsToggleSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsToggleSettings() (*ToggleSettings, bool) {
	return &ts, true
}

// AsSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for ToggleSettings.
func (ts ToggleSettings) AsBasicSettings() (BasicSettings, bool) {
	return &ts, true
}

// UnmarshalJSON is the custom unmarshaler for ToggleSettings struct.
func (ts *ToggleSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var toggleSettingsProperties ToggleSettingsProperties
				err = json.Unmarshal(*v, &toggleSettingsProperties)
				if err != nil {
					return err
				}
				ts.ToggleSettingsProperties = &toggleSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				ts.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ts.Kind = kind
			}
		}
	}

	return nil
}

// ToggleSettingsProperties toggle property bag.
type ToggleSettingsProperties struct {
	// IsEnabled - Determines whether the setting is enable or disabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// UebaSettings represents settings for User and Entity Behavior Analytics enablement.
type UebaSettings struct {
	// UebaSettingsProperties - User and Entity Behavior Analytics settings properties
	*UebaSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Etag - Etag of the alert rule.
	Etag *string `json:"etag,omitempty"`
	// Kind - Possible values include: 'KindSettings', 'KindUebaSettings', 'KindToggleSettings'
	Kind KindBasicSettings `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for UebaSettings.
func (us UebaSettings) MarshalJSON() ([]byte, error) {
	us.Kind = KindUebaSettings
	objectMap := make(map[string]interface{})
	if us.UebaSettingsProperties != nil {
		objectMap["properties"] = us.UebaSettingsProperties
	}
	if us.Etag != nil {
		objectMap["etag"] = us.Etag
	}
	if us.Kind != "" {
		objectMap["kind"] = us.Kind
	}
	return json.Marshal(objectMap)
}

// AsUebaSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsUebaSettings() (*UebaSettings, bool) {
	return &us, true
}

// AsToggleSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsToggleSettings() (*ToggleSettings, bool) {
	return nil, false
}

// AsSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsSettings() (*Settings, bool) {
	return nil, false
}

// AsBasicSettings is the BasicSettings implementation for UebaSettings.
func (us UebaSettings) AsBasicSettings() (BasicSettings, bool) {
	return &us, true
}

// UnmarshalJSON is the custom unmarshaler for UebaSettings struct.
func (us *UebaSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var uebaSettingsProperties UebaSettingsProperties
				err = json.Unmarshal(*v, &uebaSettingsProperties)
				if err != nil {
					return err
				}
				us.UebaSettingsProperties = &uebaSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				us.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind KindBasicSettings
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				us.Kind = kind
			}
		}
	}

	return nil
}

// UebaSettingsProperties user and Entity Behavior Analytics settings property bag.
type UebaSettingsProperties struct {
	// IsEnabled - Determines whether User and Entity Behavior Analytics is enabled for this workspace.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// StatusInMcas - READ-ONLY; Determines whether User and Entity Behavior Analytics is enabled from MCAS (Microsoft Cloud App Security). Possible values include: 'StatusInMcasEnabled', 'StatusInMcasDisabled'
	StatusInMcas StatusInMcas `json:"statusInMcas,omitempty"`
	// AtpLicenseStatus - READ-ONLY; Determines whether the tenant has ATP (Advanced Threat Protection) license. Possible values include: 'LicenseStatusEnabled', 'LicenseStatusDisabled'
	AtpLicenseStatus LicenseStatus `json:"atpLicenseStatus,omitempty"`
}

// UserInfo user information that made some action
type UserInfo struct {
	// ObjectID - The object id of the user.
	ObjectID *uuid.UUID `json:"objectId,omitempty"`
	// Email - The email of the user.
	Email *string `json:"email,omitempty"`
	// Name - The name of the user.
	Name *string `json:"name,omitempty"`
}
