package vmwarecloudsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SkusAvailabilityWithinRegionClient is the description of the new service
type SkusAvailabilityWithinRegionClient struct {
	BaseClient
}

// NewSkusAvailabilityWithinRegionClient creates an instance of the SkusAvailabilityWithinRegionClient client.
func NewSkusAvailabilityWithinRegionClient(referer string, regionID string, subscriptionID string) SkusAvailabilityWithinRegionClient {
	return NewSkusAvailabilityWithinRegionClientWithBaseURI(DefaultBaseURI, referer, regionID, subscriptionID)
}

// NewSkusAvailabilityWithinRegionClientWithBaseURI creates an instance of the SkusAvailabilityWithinRegionClient
// client.
func NewSkusAvailabilityWithinRegionClientWithBaseURI(baseURI string, referer string, regionID string, subscriptionID string) SkusAvailabilityWithinRegionClient {
	return SkusAvailabilityWithinRegionClient{NewWithBaseURI(baseURI, referer, regionID, subscriptionID)}
}

// List returns list of available resources in region
// Parameters:
// skuID - sku id, if no sku is passed availability for all skus will be returned
func (client SkusAvailabilityWithinRegionClient) List(ctx context.Context, skuID string) (result SkuAvailabilityListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkusAvailabilityWithinRegionClient.List")
		defer func() {
			sc := -1
			if result.salr.Response.Response != nil {
				sc = result.salr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, skuID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.salr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "List", resp, "Failure sending request")
		return
	}

	result.salr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client SkusAvailabilityWithinRegionClient) ListPreparer(ctx context.Context, skuID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"regionId":       autorest.Encode("path", client.RegionID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skuID) > 0 {
		queryParameters["skuId"] = autorest.Encode("query", skuID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.VMwareCloudSimple/locations/{regionId}/availabilities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SkusAvailabilityWithinRegionClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SkusAvailabilityWithinRegionClient) ListResponder(resp *http.Response) (result SkuAvailabilityListResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client SkusAvailabilityWithinRegionClient) listNextResults(ctx context.Context, lastResults SkuAvailabilityListResponse) (result SkuAvailabilityListResponse, err error) {
	req, err := lastResults.skuAvailabilityListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.SkusAvailabilityWithinRegionClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client SkusAvailabilityWithinRegionClient) ListComplete(ctx context.Context, skuID string) (result SkuAvailabilityListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkusAvailabilityWithinRegionClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, skuID)
	return
}
