package healthcareapisapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/healthcareapis/mgmt/2018-08-20-preview/healthcareapis"
	"github.com/Azure/go-autorest/autorest"
)

// ServicesClientAPI contains the set of methods on the ServicesClient type.
type ServicesClientAPI interface {
	CheckNameAvailability(ctx context.Context, checkNameAvailabilityInputs healthcareapis.CheckNameAvailabilityParameters) (result healthcareapis.ServicesNameAvailabilityInfo, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, resourceName string, serviceDescription healthcareapis.ServicesDescription) (result healthcareapis.ServicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, resourceName string) (result healthcareapis.ServicesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, resourceName string) (result healthcareapis.ServicesDescription, err error)
	List(ctx context.Context) (result healthcareapis.ServicesDescriptionListResultPage, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result healthcareapis.ServicesDescriptionListResultPage, err error)
	MoveResources(ctx context.Context, resourceGroupName string, moveResourcesInputs healthcareapis.MoveResourcesParameters) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, resourceName string, servicePatchDescription healthcareapis.ServicesPatchDescription) (result healthcareapis.ServicesUpdateFuture, err error)
}

var _ ServicesClientAPI = (*healthcareapis.ServicesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result healthcareapis.OperationListResultPage, err error)
}

var _ OperationsClientAPI = (*healthcareapis.OperationsClient)(nil)

// OperationResultsClientAPI contains the set of methods on the OperationResultsClient type.
type OperationResultsClientAPI interface {
	Get(ctx context.Context, locationName string, operationResultID string) (result healthcareapis.SetObject, err error)
}

var _ OperationResultsClientAPI = (*healthcareapis.OperationResultsClient)(nil)

// MoveResourcesStatusClientAPI contains the set of methods on the MoveResourcesStatusClient type.
type MoveResourcesStatusClientAPI interface {
	Get(ctx context.Context, locationName string, operationResultID string) (result healthcareapis.SetObject, err error)
}

var _ MoveResourcesStatusClientAPI = (*healthcareapis.MoveResourcesStatusClient)(nil)
