// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/users/{InstanceId}",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon Connect Service.
//
// Creates a new user account in your Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The allowed limit for the resource has been reached.
//
//   * ErrCodeDuplicateResourceException "DuplicateResourceException"
//   A resource with that name already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon Connect Service.
//
// Deletes a user account from Amazon Connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon Connect Service.
//
// Returns a User object that contains information about the user account specified
// by the UserId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyGroup = "DescribeUserHierarchyGroup"

// DescribeUserHierarchyGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyGroup for more information on using the DescribeUserHierarchyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserHierarchyGroupRequest method.
//    req, resp := client.DescribeUserHierarchyGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroupRequest(input *DescribeUserHierarchyGroupInput) (req *request.Request, output *DescribeUserHierarchyGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyGroupInput{}
	}

	output = &DescribeUserHierarchyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyGroup API operation for Amazon Connect Service.
//
// Returns a HierarchyGroup object that includes information about a hierarchy
// group in your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroup(input *DescribeUserHierarchyGroupInput) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyGroupWithContext is the same as DescribeUserHierarchyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyGroupWithContext(ctx aws.Context, input *DescribeUserHierarchyGroupInput, opts ...request.Option) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyStructure = "DescribeUserHierarchyStructure"

// DescribeUserHierarchyStructureRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyStructure operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyStructure for more information on using the DescribeUserHierarchyStructure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserHierarchyStructureRequest method.
//    req, resp := client.DescribeUserHierarchyStructureRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructureRequest(input *DescribeUserHierarchyStructureInput) (req *request.Request, output *DescribeUserHierarchyStructureOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyStructure,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-structure/{InstanceId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyStructureInput{}
	}

	output = &DescribeUserHierarchyStructureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyStructure API operation for Amazon Connect Service.
//
// Returns a HiearchyGroupStructure object, which contains data about the levels
// in the agent hierarchy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyStructure for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructure(input *DescribeUserHierarchyStructureInput) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyStructureWithContext is the same as DescribeUserHierarchyStructure with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyStructure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyStructureWithContext(ctx aws.Context, input *DescribeUserHierarchyStructureInput, opts ...request.Option) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCurrentMetricData = "GetCurrentMetricData"

// GetCurrentMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetCurrentMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCurrentMetricData for more information on using the GetCurrentMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCurrentMetricDataRequest method.
//    req, resp := client.GetCurrentMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricDataRequest(input *GetCurrentMetricDataInput) (req *request.Request, output *GetCurrentMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetCurrentMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/current/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCurrentMetricDataInput{}
	}

	output = &GetCurrentMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCurrentMetricData API operation for Amazon Connect Service.
//
// The GetCurrentMetricData operation retrieves current metric data from your
// Amazon Connect instance.
//
// If you are using an IAM account, it must have permission to the connect:GetCurrentMetricData
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetCurrentMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricData(input *GetCurrentMetricDataInput) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	return out, req.Send()
}

// GetCurrentMetricDataWithContext is the same as GetCurrentMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetCurrentMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, opts ...request.Option) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCurrentMetricDataPages iterates over the pages of a GetCurrentMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCurrentMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCurrentMetricData operation.
//    pageNum := 0
//    err := client.GetCurrentMetricDataPages(params,
//        func(page *GetCurrentMetricDataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) GetCurrentMetricDataPages(input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool) error {
	return c.GetCurrentMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCurrentMetricDataPagesWithContext same as GetCurrentMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataPagesWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCurrentMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCurrentMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetCurrentMetricDataOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetFederationToken = "GetFederationToken"

// GetFederationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetFederationToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFederationToken for more information on using the GetFederationToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFederationTokenRequest method.
//    req, resp := client.GetFederationTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationTokenRequest(input *GetFederationTokenInput) (req *request.Request, output *GetFederationTokenOutput) {
	op := &request.Operation{
		Name:       opGetFederationToken,
		HTTPMethod: "GET",
		HTTPPath:   "/user/federate/{InstanceId}",
	}

	if input == nil {
		input = &GetFederationTokenInput{}
	}

	output = &GetFederationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFederationToken API operation for Amazon Connect Service.
//
// Retrieves a token for federation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetFederationToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeUserNotFoundException "UserNotFoundException"
//   No user with the specified credentials was found in the Amazon Connect instance.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
//   * ErrCodeDuplicateResourceException "DuplicateResourceException"
//   A resource with that name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationToken(input *GetFederationTokenInput) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	return out, req.Send()
}

// GetFederationTokenWithContext is the same as GetFederationToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetFederationToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetFederationTokenWithContext(ctx aws.Context, input *GetFederationTokenInput, opts ...request.Option) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricData for more information on using the GetMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMetricDataRequest method.
//    req, resp := client.GetMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricDataRequest(input *GetMetricDataInput) (req *request.Request, output *GetMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/historical/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	output = &GetMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricData API operation for Amazon Connect Service.
//
// The GetMetricData operation retrieves historical metrics data from your Amazon
// Connect instance.
//
// If you are using an IAM account, it must have permission to the connect:GetMetricData
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricData(input *GetMetricDataInput) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	return out, req.Send()
}

// GetMetricDataWithContext is the same as GetMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataWithContext(ctx aws.Context, input *GetMetricDataInput, opts ...request.Option) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMetricDataPages iterates over the pages of a GetMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetMetricData operation.
//    pageNum := 0
//    err := client.GetMetricDataPages(params,
//        func(page *GetMetricDataOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Connect) GetMetricDataPages(input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool) error {
	return c.GetMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMetricDataPagesWithContext same as GetMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataPagesWithContext(ctx aws.Context, input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetMetricDataOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRoutingProfiles = "ListRoutingProfiles"

// ListRoutingProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingProfiles for more information on using the ListRoutingProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoutingProfilesRequest method.
//    req, resp := client.ListRoutingProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfilesRequest(input *ListRoutingProfilesInput) (req *request.Request, output *ListRoutingProfilesOutput) {
	op := &request.Operation{
		Name:       opListRoutingProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/routing-profiles-summary/{InstanceId}",
	}

	if input == nil {
		input = &ListRoutingProfilesInput{}
	}

	output = &ListRoutingProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingProfiles API operation for Amazon Connect Service.
//
// Returns an array of RoutingProfileSummary objects that includes information
// about the routing profiles in your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListRoutingProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfiles(input *ListRoutingProfilesInput) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	return out, req.Send()
}

// ListRoutingProfilesWithContext is the same as ListRoutingProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfilesWithContext(ctx aws.Context, input *ListRoutingProfilesInput, opts ...request.Option) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfiles for more information on using the ListSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSecurityProfilesRequest method.
//    req, resp := client.ListSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) (req *request.Request, output *ListSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-summary/{InstanceId}",
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	output = &ListSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfiles API operation for Amazon Connect Service.
//
// Returns an array of SecurityProfileSummary objects that contain information
// about the security profiles in your instance, including the ARN, Id, and
// Name of the security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListSecurityProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfiles(input *ListSecurityProfilesInput) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesWithContext is the same as ListSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, opts ...request.Option) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserHierarchyGroups = "ListUserHierarchyGroups"

// ListUserHierarchyGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserHierarchyGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserHierarchyGroups for more information on using the ListUserHierarchyGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUserHierarchyGroupsRequest method.
//    req, resp := client.ListUserHierarchyGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroupsRequest(input *ListUserHierarchyGroupsInput) (req *request.Request, output *ListUserHierarchyGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserHierarchyGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups-summary/{InstanceId}",
	}

	if input == nil {
		input = &ListUserHierarchyGroupsInput{}
	}

	output = &ListUserHierarchyGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserHierarchyGroups API operation for Amazon Connect Service.
//
// Returns a UserHierarchyGroupSummaryList, which is an array of HierarchyGroupSummary
// objects that contain information about the hierarchy groups in your instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUserHierarchyGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroups(input *ListUserHierarchyGroupsInput) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	return out, req.Send()
}

// ListUserHierarchyGroupsWithContext is the same as ListUserHierarchyGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserHierarchyGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUserHierarchyGroupsWithContext(ctx aws.Context, input *ListUserHierarchyGroupsInput, opts ...request.Option) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/users-summary/{InstanceId}",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Connect Service.
//
// Returns a UserSummaryList, which is an array of UserSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOutboundVoiceContact = "StartOutboundVoiceContact"

// StartOutboundVoiceContactRequest generates a "aws/request.Request" representing the
// client's request for the StartOutboundVoiceContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOutboundVoiceContact for more information on using the StartOutboundVoiceContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartOutboundVoiceContactRequest method.
//    req, resp := client.StartOutboundVoiceContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContactRequest(input *StartOutboundVoiceContactInput) (req *request.Request, output *StartOutboundVoiceContactOutput) {
	op := &request.Operation{
		Name:       opStartOutboundVoiceContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/outbound-voice",
	}

	if input == nil {
		input = &StartOutboundVoiceContactInput{}
	}

	output = &StartOutboundVoiceContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOutboundVoiceContact API operation for Amazon Connect Service.
//
// The StartOutboundVoiceContact operation initiates a contact flow to place
// an outbound call to a customer.
//
// If you are using an IAM account, it must have permission to the connect:StartOutboundVoiceContact
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartOutboundVoiceContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The allowed limit for the resource has been reached.
//
//   * ErrCodeDestinationNotAllowedException "DestinationNotAllowedException"
//   Outbound calls to the destination number are not allowed.
//
//   * ErrCodeOutboundContactNotPermittedException "OutboundContactNotPermittedException"
//   The contact is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContact(input *StartOutboundVoiceContactInput) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	return out, req.Send()
}

// StartOutboundVoiceContactWithContext is the same as StartOutboundVoiceContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartOutboundVoiceContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartOutboundVoiceContactWithContext(ctx aws.Context, input *StartOutboundVoiceContactInput, opts ...request.Option) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContact = "StopContact"

// StopContactRequest generates a "aws/request.Request" representing the
// client's request for the StopContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContact for more information on using the StopContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopContactRequest method.
//    req, resp := client.StopContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContactRequest(input *StopContactInput) (req *request.Request, output *StopContactOutput) {
	op := &request.Operation{
		Name:       opStopContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop",
	}

	if input == nil {
		input = &StopContactInput{}
	}

	output = &StopContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopContact API operation for Amazon Connect Service.
//
// Ends the contact initiated by the StartOutboundVoiceContact operation.
//
// If you are using an IAM account, it must have permission to the connect:StopContact
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StopContact for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeContactNotFoundException "ContactNotFoundException"
//   The contact with the specified ID is not active or does not exist.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContact(input *StopContactInput) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	return out, req.Send()
}

// StopContactWithContext is the same as StopContact with the addition of
// the ability to pass a context and additional request options.
//
// See StopContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StopContactWithContext(ctx aws.Context, input *StopContactInput, opts ...request.Option) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactAttributes = "UpdateContactAttributes"

// UpdateContactAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactAttributes for more information on using the UpdateContactAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContactAttributesRequest method.
//    req, resp := client.UpdateContactAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributesRequest(input *UpdateContactAttributesInput) (req *request.Request, output *UpdateContactAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateContactAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/attributes",
	}

	if input == nil {
		input = &UpdateContactAttributesInput{}
	}

	output = &UpdateContactAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContactAttributes API operation for Amazon Connect Service.
//
// The UpdateContactAttributes operation lets you programmatically create new,
// or update existing, contact attributes associated with a contact. You can
// use the operation to add or update attributes for both ongoing and completed
// contacts. For example, you can update the customer's name or the reason the
// customer called while the call is active, or add notes about steps that the
// agent took during the call that are displayed to the next agent that takes
// the call. You can also use the UpdateContactAttributes operation to update
// attributes for a contact using data from your CRM application and save the
// data with the contact in Amazon Connect. You could also flag calls for additional
// analysis, such as legal review or identifying abusive callers.
//
// Contact attributes are available in Amazon Connect for 24 months, and are
// then deleted.
//
// Important:
//
// You cannot use the operation to update attributes for contacts that occurred
// prior to the release of the API, September 12, 2018. You can update attributes
// only for contacts that started after the release of the API. If you attempt
// to update attributes for a contact that occurred prior to the release of
// the API, a 400 error is returned. This applies also to queued callbacks that
// were initiated prior to the release of the API but are still active in your
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributes(input *UpdateContactAttributesInput) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	return out, req.Send()
}

// UpdateContactAttributesWithContext is the same as UpdateContactAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactAttributesWithContext(ctx aws.Context, input *UpdateContactAttributesInput, opts ...request.Option) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserHierarchy = "UpdateUserHierarchy"

// UpdateUserHierarchyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserHierarchy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserHierarchy for more information on using the UpdateUserHierarchy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserHierarchyRequest method.
//    req, resp := client.UpdateUserHierarchyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchyRequest(input *UpdateUserHierarchyInput) (req *request.Request, output *UpdateUserHierarchyOutput) {
	op := &request.Operation{
		Name:       opUpdateUserHierarchy,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/hierarchy",
	}

	if input == nil {
		input = &UpdateUserHierarchyInput{}
	}

	output = &UpdateUserHierarchyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserHierarchy API operation for Amazon Connect Service.
//
// Assigns the specified hierarchy group to the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserHierarchy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchy(input *UpdateUserHierarchyInput) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	return out, req.Send()
}

// UpdateUserHierarchyWithContext is the same as UpdateUserHierarchy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserHierarchy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserHierarchyWithContext(ctx aws.Context, input *UpdateUserHierarchyInput, opts ...request.Option) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserIdentityInfo = "UpdateUserIdentityInfo"

// UpdateUserIdentityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserIdentityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserIdentityInfo for more information on using the UpdateUserIdentityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserIdentityInfoRequest method.
//    req, resp := client.UpdateUserIdentityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfoRequest(input *UpdateUserIdentityInfoInput) (req *request.Request, output *UpdateUserIdentityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateUserIdentityInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/identity-info",
	}

	if input == nil {
		input = &UpdateUserIdentityInfoInput{}
	}

	output = &UpdateUserIdentityInfoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserIdentityInfo API operation for Amazon Connect Service.
//
// Updates the identity information for the specified user in a UserIdentityInfo
// object, including email, first name, and last name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserIdentityInfo for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfo(input *UpdateUserIdentityInfoInput) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	return out, req.Send()
}

// UpdateUserIdentityInfoWithContext is the same as UpdateUserIdentityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserIdentityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserIdentityInfoWithContext(ctx aws.Context, input *UpdateUserIdentityInfoInput, opts ...request.Option) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPhoneConfig = "UpdateUserPhoneConfig"

// UpdateUserPhoneConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPhoneConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPhoneConfig for more information on using the UpdateUserPhoneConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserPhoneConfigRequest method.
//    req, resp := client.UpdateUserPhoneConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfigRequest(input *UpdateUserPhoneConfigInput) (req *request.Request, output *UpdateUserPhoneConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPhoneConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/phone-config",
	}

	if input == nil {
		input = &UpdateUserPhoneConfigInput{}
	}

	output = &UpdateUserPhoneConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserPhoneConfig API operation for Amazon Connect Service.
//
// Updates the phone configuration settings in the UserPhoneConfig object for
// the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserPhoneConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfig(input *UpdateUserPhoneConfigInput) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	return out, req.Send()
}

// UpdateUserPhoneConfigWithContext is the same as UpdateUserPhoneConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPhoneConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserPhoneConfigWithContext(ctx aws.Context, input *UpdateUserPhoneConfigInput, opts ...request.Option) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserRoutingProfile = "UpdateUserRoutingProfile"

// UpdateUserRoutingProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserRoutingProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserRoutingProfile for more information on using the UpdateUserRoutingProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRoutingProfileRequest method.
//    req, resp := client.UpdateUserRoutingProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfileRequest(input *UpdateUserRoutingProfileInput) (req *request.Request, output *UpdateUserRoutingProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserRoutingProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/routing-profile",
	}

	if input == nil {
		input = &UpdateUserRoutingProfileInput{}
	}

	output = &UpdateUserRoutingProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserRoutingProfile API operation for Amazon Connect Service.
//
// Assigns the specified routing profile to a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserRoutingProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfile(input *UpdateUserRoutingProfileInput) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	return out, req.Send()
}

// UpdateUserRoutingProfileWithContext is the same as UpdateUserRoutingProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserRoutingProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserRoutingProfileWithContext(ctx aws.Context, input *UpdateUserRoutingProfileInput, opts ...request.Option) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSecurityProfiles = "UpdateUserSecurityProfiles"

// UpdateUserSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSecurityProfiles for more information on using the UpdateUserSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserSecurityProfilesRequest method.
//    req, resp := client.UpdateUserSecurityProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfilesRequest(input *UpdateUserSecurityProfilesInput) (req *request.Request, output *UpdateUserSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSecurityProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/security-profiles",
	}

	if input == nil {
		input = &UpdateUserSecurityProfilesInput{}
	}

	output = &UpdateUserSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserSecurityProfiles API operation for Amazon Connect Service.
//
// Updates the security profiles assigned to the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserSecurityProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is not valid.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the parameters provided to the operation are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The specified resource was not found.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   The throttling limit has been exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Request processing failed due to an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfiles(input *UpdateUserSecurityProfilesInput) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	return out, req.Send()
}

// UpdateUserSecurityProfilesWithContext is the same as UpdateUserSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserSecurityProfilesWithContext(ctx aws.Context, input *UpdateUserSecurityProfilesInput, opts ...request.Option) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the user account in the directory service directory
	// used for identity management. If Amazon Connect is unable to access the existing
	// directory, you can use the DirectoryUserId to authenticate users. If you
	// include the parameter, it is assumed that Amazon Connect cannot access the
	// directory. If the parameter is not included, the UserIdentityInfo is used
	// to authenticate users from your existing directory.
	//
	// This parameter is required if you are using an existing directory for identity
	// management in Amazon Connect when Amazon Connect cannot access your directory
	// to authenticate users. If you are using SAML for identity management and
	// include this parameter, an InvalidRequestException is returned.
	DirectoryUserId *string `type:"string"`

	// The unique identifier for the hierarchy group to assign to the user created.
	HierarchyGroupId *string `type:"string"`

	// Information about the user, including email address, first name, and last
	// name.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The password for the user account to create. This is required if you are
	// using Amazon Connect for identity management. If you are using SAML for identity
	// management and include this parameter, an InvalidRequestException is returned.
	Password *string `type:"string"`

	// Specifies the phone settings for the user, including AfterContactWorkTimeLimit,
	// AutoAccept, DeskPhoneNumber, and PhoneType.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The unique identifier for the routing profile to assign to the user created.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The unique identifier of the security profile to assign to the user created.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []*string `min:"1" type:"list" required:"true"`

	// The user name in Amazon Connect for the account to create.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneConfig"))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.SecurityProfileIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryUserId sets the DirectoryUserId field's value.
func (s *CreateUserInput) SetDirectoryUserId(v string) *CreateUserInput {
	s.DirectoryUserId = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *CreateUserInput) SetHierarchyGroupId(v string) *CreateUserInput {
	s.HierarchyGroupId = &v
	return s
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *CreateUserInput) SetIdentityInfo(v *UserIdentityInfo) *CreateUserInput {
	s.IdentityInfo = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateUserInput) SetInstanceId(v string) *CreateUserInput {
	s.InstanceId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *CreateUserInput) SetPhoneConfig(v *UserPhoneConfig) *CreateUserInput {
	s.PhoneConfig = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *CreateUserInput) SetRoutingProfileId(v string) *CreateUserInput {
	s.RoutingProfileId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *CreateUserInput) SetSecurityProfileIds(v []*string) *CreateUserInput {
	s.SecurityProfileIds = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserInput) SetUsername(v string) *CreateUserInput {
	s.Username = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account created.
	UserArn *string `type:"string"`

	// The unique identifier for the user account in Amazon Connect
	UserId *string `type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserOutput) SetUserArn(v string) *CreateUserOutput {
	s.UserArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

// The credentials to use for federation.
type Credentials struct {
	_ struct{} `type:"structure"`

	// An access token generated for a federated user to access Amazon Connect
	AccessToken *string `type:"string"`

	// A token generated with an expiration time for the session a user is logged
	// in to Amazon Connect
	AccessTokenExpiration *time.Time `type:"timestamp"`

	// Renews a token generated for a user to access the Amazon Connect instance.
	RefreshToken *string `type:"string"`

	// Renews the expiration timer for a generated token.
	RefreshTokenExpiration *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credentials) GoString() string {
	return s.String()
}

// SetAccessToken sets the AccessToken field's value.
func (s *Credentials) SetAccessToken(v string) *Credentials {
	s.AccessToken = &v
	return s
}

// SetAccessTokenExpiration sets the AccessTokenExpiration field's value.
func (s *Credentials) SetAccessTokenExpiration(v time.Time) *Credentials {
	s.AccessTokenExpiration = &v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *Credentials) SetRefreshToken(v string) *Credentials {
	s.RefreshToken = &v
	return s
}

// SetRefreshTokenExpiration sets the RefreshTokenExpiration field's value.
func (s *Credentials) SetRefreshTokenExpiration(v time.Time) *Credentials {
	s.RefreshTokenExpiration = &v
	return s
}

// A CurrentMetric object that contains the Name and Unit for the metric.
type CurrentMetric struct {
	_ struct{} `type:"structure"`

	// The name of the metric.
	Name *string `type:"string" enum:"CurrentMetricName"`

	// The unit for the metric.
	Unit *string `type:"string" enum:"Unit"`
}

// String returns the string representation
func (s CurrentMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CurrentMetric) SetName(v string) *CurrentMetric {
	s.Name = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CurrentMetric) SetUnit(v string) *CurrentMetric {
	s.Unit = &v
	return s
}

// A CurrentMetricData object.
type CurrentMetricData struct {
	_ struct{} `type:"structure"`

	// The metric in a CurrentMetricData object.
	Metric *CurrentMetric `type:"structure"`

	// The value of the metric in the CurrentMetricData object.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s CurrentMetricData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetricData) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *CurrentMetricData) SetMetric(v *CurrentMetric) *CurrentMetricData {
	s.Metric = v
	return s
}

// SetValue sets the Value field's value.
func (s *CurrentMetricData) SetValue(v float64) *CurrentMetricData {
	s.Value = &v
	return s
}

// A CurrentMetricResult object.
type CurrentMetricResult struct {
	_ struct{} `type:"structure"`

	// The Collections for the CurrentMetricResult object.
	Collections []*CurrentMetricData `type:"list"`

	// The Dimensions for the CurrentMetricResult object.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s CurrentMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentMetricResult) GoString() string {
	return s.String()
}

// SetCollections sets the Collections field's value.
func (s *CurrentMetricResult) SetCollections(v []*CurrentMetricData) *CurrentMetricResult {
	s.Collections = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *CurrentMetricResult) SetDimensions(v *Dimensions) *CurrentMetricResult {
	s.Dimensions = v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The unique identifier of the user to delete.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteUserInput) SetInstanceId(v string) *DeleteUserInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeUserHierarchyGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the hierarchy group to return.
	//
	// HierarchyGroupId is a required field
	HierarchyGroupId *string `location:"uri" locationName:"HierarchyGroupId" type:"string" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserHierarchyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserHierarchyGroupInput"}
	if s.HierarchyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("HierarchyGroupId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *DescribeUserHierarchyGroupInput) SetHierarchyGroupId(v string) *DescribeUserHierarchyGroupInput {
	s.HierarchyGroupId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserHierarchyGroupInput) SetInstanceId(v string) *DescribeUserHierarchyGroupInput {
	s.InstanceId = &v
	return s
}

type DescribeUserHierarchyGroupOutput struct {
	_ struct{} `type:"structure"`

	// Returns a HierarchyGroup object.
	HierarchyGroup *HierarchyGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeUserHierarchyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyGroupOutput) GoString() string {
	return s.String()
}

// SetHierarchyGroup sets the HierarchyGroup field's value.
func (s *DescribeUserHierarchyGroupOutput) SetHierarchyGroup(v *HierarchyGroup) *DescribeUserHierarchyGroupOutput {
	s.HierarchyGroup = v
	return s
}

type DescribeUserHierarchyStructureInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserHierarchyStructureInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyStructureInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserHierarchyStructureInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserHierarchyStructureInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserHierarchyStructureInput) SetInstanceId(v string) *DescribeUserHierarchyStructureInput {
	s.InstanceId = &v
	return s
}

type DescribeUserHierarchyStructureOutput struct {
	_ struct{} `type:"structure"`

	// A HierarchyStructure object.
	HierarchyStructure *HierarchyStructure `type:"structure"`
}

// String returns the string representation
func (s DescribeUserHierarchyStructureOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserHierarchyStructureOutput) GoString() string {
	return s.String()
}

// SetHierarchyStructure sets the HierarchyStructure field's value.
func (s *DescribeUserHierarchyStructureOutput) SetHierarchyStructure(v *HierarchyStructure) *DescribeUserHierarchyStructureOutput {
	s.HierarchyStructure = v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Unique identifier for the user account to return.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeUserInput) SetInstanceId(v string) *DescribeUserInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserInput) SetUserId(v string) *DescribeUserInput {
	s.UserId = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// A User object that contains information about the user account and configuration
	// settings.
	User *User `type:"structure"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *User) *DescribeUserOutput {
	s.User = v
	return s
}

// A Dimensions object that includes the Channel and Queue for the metric.
type Dimensions struct {
	_ struct{} `type:"structure"`

	// The channel used for grouping and filters. Only VOICE is supported.
	Channel *string `type:"string" enum:"Channel"`

	// A QueueReference object used as one part of dimension for the metrics results.
	Queue *QueueReference `type:"structure"`
}

// String returns the string representation
func (s Dimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dimensions) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *Dimensions) SetChannel(v string) *Dimensions {
	s.Channel = &v
	return s
}

// SetQueue sets the Queue field's value.
func (s *Dimensions) SetQueue(v *QueueReference) *Dimensions {
	s.Queue = v
	return s
}

// The filter, either channel or queues, to apply to the metric results retrieved.
type Filters struct {
	_ struct{} `type:"structure"`

	// The Channel to use as a filter for the metrics returned. Only VOICE is supported.
	Channels []*string `type:"list"`

	// A list of up to 100 queue IDs or queue ARNs to use to filter the metrics
	// retrieved. You can include both IDs and ARNs in a request.
	Queues []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filters"}
	if s.Queues != nil && len(s.Queues) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Queues", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannels sets the Channels field's value.
func (s *Filters) SetChannels(v []*string) *Filters {
	s.Channels = v
	return s
}

// SetQueues sets the Queues field's value.
func (s *Filters) SetQueues(v []*string) *Filters {
	s.Queues = v
	return s
}

type GetCurrentMetricDataInput struct {
	_ struct{} `type:"structure"`

	// A list of CurrentMetric objects for the metrics to retrieve. Each CurrentMetric
	// includes a name of a metric to retrieve and the unit to use for it.
	//
	// The following metrics are available:
	//
	// AGENTS_AVAILABLEUnit: COUNT
	//
	// AGENTS_ONLINEUnit: COUNT
	//
	// AGENTS_ON_CALLUnit: COUNT
	//
	// AGENTS_STAFFEDUnit: COUNT
	//
	// AGENTS_AFTER_CONTACT_WORKUnit: COUNT
	//
	// AGENTS_NON_PRODUCTIVEUnit: COUNT
	//
	// AGENTS_ERRORUnit: COUNT
	//
	// CONTACTS_IN_QUEUEUnit: COUNT
	//
	// OLDEST_CONTACT_AGEUnit: SECONDS
	//
	// CONTACTS_SCHEDULEDUnit: COUNT
	//
	// CurrentMetrics is a required field
	CurrentMetrics []*CurrentMetric `type:"list" required:"true"`

	// A Filters object that contains a list of queue IDs or queue ARNs, up to 100,
	// or list of Channels to use to filter the metrics returned in the response.
	// Metric data is retrieved only for the resources associated with the queue
	// IDs, ARNs, or Channels included in the filter. You can include both IDs and
	// ARNs in the same request. To retrieve metrics for all queues, add the queue
	// ID or ARN for each queue in your instance. Only VOICE is supported for Channels.
	//
	// To find the ARN for a queue, open the queue you want to use in the Amazon
	// Connect Queue editor. The ARN for the queue is displayed in the address bar
	// as part of the URL. For example, the queue ARN is the set of characters at
	// the end of the URL, after 'id=' such as arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61.
	// The queue ID is also included in the URL, and is the string after 'queue/'.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when grouped by
	// QUEUE, the metrics returned apply to each queue rather than aggregated for
	// all queues. If you group by CHANNEL, you should include a Channels filter.
	// The only supported channel is VOICE.
	//
	// If no Grouping is included in the request, a summary of CurrentMetrics is
	// returned.
	Groupings []*string `type:"list"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// MaxResults indicates the maximum number of results to return per page in
	// the response, between 1 and 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the NextToken must use the same request parameters as the
	// request that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCurrentMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCurrentMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCurrentMetricDataInput"}
	if s.CurrentMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentMetrics"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentMetrics sets the CurrentMetrics field's value.
func (s *GetCurrentMetricDataInput) SetCurrentMetrics(v []*CurrentMetric) *GetCurrentMetricDataInput {
	s.CurrentMetrics = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetCurrentMetricDataInput) SetFilters(v *Filters) *GetCurrentMetricDataInput {
	s.Filters = v
	return s
}

// SetGroupings sets the Groupings field's value.
func (s *GetCurrentMetricDataInput) SetGroupings(v []*string) *GetCurrentMetricDataInput {
	s.Groupings = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetCurrentMetricDataInput) SetInstanceId(v string) *GetCurrentMetricDataInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCurrentMetricDataInput) SetMaxResults(v int64) *GetCurrentMetricDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCurrentMetricDataInput) SetNextToken(v string) *GetCurrentMetricDataInput {
	s.NextToken = &v
	return s
}

type GetCurrentMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// The time at which CurrentMetricData was retrieved and cached for pagination.
	DataSnapshotTime *time.Time `type:"timestamp"`

	// A list of CurrentMetricResult objects organized by Dimensions combining with
	// CurrentMetricDataCollections.
	//
	// Dimensions is the resourceId specified in the Filters of the request.
	//
	// Collections is a list of CurrentMetricData objects with corresponding values
	// to the CurrentMetrics specified in the request.
	//
	// If no Grouping is specified in the request, Collections is a summary for
	// the CurrentMetric returned.
	MetricResults []*CurrentMetricResult `type:"list"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the NextToken must use the same request parameters as the
	// request that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCurrentMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCurrentMetricDataOutput) GoString() string {
	return s.String()
}

// SetDataSnapshotTime sets the DataSnapshotTime field's value.
func (s *GetCurrentMetricDataOutput) SetDataSnapshotTime(v time.Time) *GetCurrentMetricDataOutput {
	s.DataSnapshotTime = &v
	return s
}

// SetMetricResults sets the MetricResults field's value.
func (s *GetCurrentMetricDataOutput) SetMetricResults(v []*CurrentMetricResult) *GetCurrentMetricDataOutput {
	s.MetricResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCurrentMetricDataOutput) SetNextToken(v string) *GetCurrentMetricDataOutput {
	s.NextToken = &v
	return s
}

type GetFederationTokenInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFederationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFederationTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFederationTokenInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetFederationTokenInput) SetInstanceId(v string) *GetFederationTokenInput {
	s.InstanceId = &v
	return s
}

type GetFederationTokenOutput struct {
	_ struct{} `type:"structure"`

	// The credentials to use for federation.
	Credentials *Credentials `type:"structure"`
}

// String returns the string representation
func (s GetFederationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *GetFederationTokenOutput) SetCredentials(v *Credentials) *GetFederationTokenOutput {
	s.Credentials = v
	return s
}

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The timestamp, in UNIX Epoch time format, at which to end the reporting interval
	// for the retrieval of historical metrics data. The time must be specified
	// using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
	// later than the StartTime timestamp.
	//
	// The time range between StartTime and EndTime must be less than 24 hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// A Filters object that contains a list of queue IDs or queue ARNs, up to 100,
	// or a list of Channels to use to filter the metrics returned in the response.
	// Metric data is retrieved only for the resources associated with the IDs,
	// ARNs, or Channels included in the filter. You can use both IDs and ARNs together
	// in a request. Only VOICE is supported for Channel.
	//
	// To find the ARN for a queue, open the queue you want to use in the Amazon
	// Connect Queue editor. The ARN for the queue is displayed in the address bar
	// as part of the URL. For example, the queue ARN is the set of characters at
	// the end of the URL, after 'id=' such as arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61.
	// The queue ID is also included in the URL, and is the string after 'queue/'.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when results are
	// grouped by queueId, the metrics returned are grouped by queue. The values
	// returned apply to the metrics for each queue rather than aggregated for all
	// queues.
	//
	// The current version supports grouping by Queue
	//
	// If no Grouping is included in the request, a summary of HistoricalMetrics
	// for all queues is returned.
	Groupings []*string `type:"list"`

	// A list of HistoricalMetric objects that contain the metrics to retrieve with
	// the request.
	//
	// A HistoricalMetric object contains: HistoricalMetricName, Statistic, Threshold,
	// and Unit.
	//
	// For each historical metric you include in the request, you must include a
	// Unit and a Statistic.
	//
	// The following historical metrics are available:
	//
	// CONTACTS_QUEUEDUnit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_ABANDONEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_CONSULTEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_AGENT_HUNG_UP_FIRSTUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HANDLED_INCOMINGUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HANDLED_OUTBOUNDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HOLD_ABANDONSUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_INUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_OUTUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_IN_FROM_QUEUEUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_OUT_FROM_QUEUEUnit: COUNT
	//
	// Statistics: SUM
	//
	// CALLBACK_CONTACTS_HANDLEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CALLBACK_CONTACTS_HANDLEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// API_CONTACTS_HANDLEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_MISSEDUnit: COUNT
	//
	// Statistics: SUM
	//
	// OCCUPANCYUnit: PERCENT
	//
	// Statistics: AVG
	//
	// HANDLE_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// AFTER_CONTACT_WORK_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// QUEUED_TIMEUnit: SECONDS
	//
	// Statistics: MAX
	//
	// ABANDON_TIMEUnit: COUNT
	//
	// Statistics: SUM
	//
	// QUEUE_ANSWER_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// HOLD_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// INTERACTION_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// INTERACTION_AND_HOLD_TIMEUnit: SECONDS
	//
	// Statistics: AVG
	//
	// SERVICE_LEVELUnit: PERCENT
	//
	// Statistics: AVG
	//
	// Threshold: Only "Less than" comparisons are supported, with the following
	// service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300,
	// 600
	//
	// HistoricalMetrics is a required field
	HistoricalMetrics []*HistoricalMetric `type:"list" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Indicates the maximum number of results to return per page in the response,
	// between 1-100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The timestamp, in UNIX Epoch time format, at which to start the reporting
	// interval for the retrieval of historical metrics data. The time must be specified
	// using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
	//
	// StartTime cannot be earlier than 24 hours before the time of the request.
	// Historical metrics are available in Amazon Connect only for 24 hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.HistoricalMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("HistoricalMetrics"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetMetricDataInput) SetEndTime(v time.Time) *GetMetricDataInput {
	s.EndTime = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetMetricDataInput) SetFilters(v *Filters) *GetMetricDataInput {
	s.Filters = v
	return s
}

// SetGroupings sets the Groupings field's value.
func (s *GetMetricDataInput) SetGroupings(v []*string) *GetMetricDataInput {
	s.Groupings = v
	return s
}

// SetHistoricalMetrics sets the HistoricalMetrics field's value.
func (s *GetMetricDataInput) SetHistoricalMetrics(v []*HistoricalMetric) *GetMetricDataInput {
	s.HistoricalMetrics = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetMetricDataInput) SetInstanceId(v string) *GetMetricDataInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetMetricDataInput) SetMaxResults(v int64) *GetMetricDataInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataInput) SetNextToken(v string) *GetMetricDataInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetMetricDataInput) SetStartTime(v time.Time) *GetMetricDataInput {
	s.StartTime = &v
	return s
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// A list of HistoricalMetricResult objects, organized by Dimensions, which
	// is the ID of the resource specified in the Filters used for the request.
	// The metrics are combined with the metrics included in Collections, which
	// is a list of HisotricalMetricData objects.
	//
	// If no Grouping is specified in the request, Collections includes summary
	// data for the HistoricalMetrics.
	MetricResults []*HistoricalMetricResult `type:"list"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the NextToken must use the same request parameters as the
	// request that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricResults sets the MetricResults field's value.
func (s *GetMetricDataOutput) SetMetricResults(v []*HistoricalMetricResult) *GetMetricDataOutput {
	s.MetricResults = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMetricDataOutput) SetNextToken(v string) *GetMetricDataOutput {
	s.NextToken = &v
	return s
}

// A HierarchyGroup object that contains information about a hierarchy group
// in your Amazon Connect instance.
type HierarchyGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the hierarchy group.
	Arn *string `type:"string"`

	// A HierarchyPath object that contains information about the levels in the
	// hierarchy group.
	HierarchyPath *HierarchyPath `type:"structure"`

	// The identifier for the hierarchy group.
	Id *string `type:"string"`

	// The identifier for the level in the hierarchy group.
	LevelId *string `type:"string"`

	// The name of the hierarchy group in your instance.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyGroup) SetArn(v string) *HierarchyGroup {
	s.Arn = &v
	return s
}

// SetHierarchyPath sets the HierarchyPath field's value.
func (s *HierarchyGroup) SetHierarchyPath(v *HierarchyPath) *HierarchyGroup {
	s.HierarchyPath = v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyGroup) SetId(v string) *HierarchyGroup {
	s.Id = &v
	return s
}

// SetLevelId sets the LevelId field's value.
func (s *HierarchyGroup) SetLevelId(v string) *HierarchyGroup {
	s.LevelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyGroup) SetName(v string) *HierarchyGroup {
	s.Name = &v
	return s
}

// A HierarchyGroupSummary object that contains information about the hierarchy
// group, including ARN, Id, and Name.
type HierarchyGroupSummary struct {
	_ struct{} `type:"structure"`

	// The ARN for the hierarchy group.
	Arn *string `type:"string"`

	// The identifier of the hierarchy group.
	Id *string `type:"string"`

	// The name of the hierarchy group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyGroupSummary) SetArn(v string) *HierarchyGroupSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyGroupSummary) SetId(v string) *HierarchyGroupSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyGroupSummary) SetName(v string) *HierarchyGroupSummary {
	s.Name = &v
	return s
}

// A HierarchyLevel object that contains information about the levels in a hierarchy
// group, including ARN, Id, and Name.
type HierarchyLevel struct {
	_ struct{} `type:"structure"`

	// The ARN for the hierarchy group level.
	Arn *string `type:"string"`

	// The identifier for the hierarchy group level.
	Id *string `type:"string"`

	// The name of the hierarchy group level.
	Name *string `type:"string"`
}

// String returns the string representation
func (s HierarchyLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyLevel) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *HierarchyLevel) SetArn(v string) *HierarchyLevel {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *HierarchyLevel) SetId(v string) *HierarchyLevel {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *HierarchyLevel) SetName(v string) *HierarchyLevel {
	s.Name = &v
	return s
}

// A HierarchyPath object that contains information about the levels of the
// hierarchy group.
type HierarchyPath struct {
	_ struct{} `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelFive *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelFour *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelOne *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelThree *HierarchyGroupSummary `type:"structure"`

	// A HierarchyGroupSummary object that contains information about the level
	// of the hierarchy group, including ARN, Id, and Name.
	LevelTwo *HierarchyGroupSummary `type:"structure"`
}

// String returns the string representation
func (s HierarchyPath) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyPath) GoString() string {
	return s.String()
}

// SetLevelFive sets the LevelFive field's value.
func (s *HierarchyPath) SetLevelFive(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelFive = v
	return s
}

// SetLevelFour sets the LevelFour field's value.
func (s *HierarchyPath) SetLevelFour(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelFour = v
	return s
}

// SetLevelOne sets the LevelOne field's value.
func (s *HierarchyPath) SetLevelOne(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelOne = v
	return s
}

// SetLevelThree sets the LevelThree field's value.
func (s *HierarchyPath) SetLevelThree(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelThree = v
	return s
}

// SetLevelTwo sets the LevelTwo field's value.
func (s *HierarchyPath) SetLevelTwo(v *HierarchyGroupSummary) *HierarchyPath {
	s.LevelTwo = v
	return s
}

// A HierarchyStructure object that contains information about the hierarchy
// group structure.
type HierarchyStructure struct {
	_ struct{} `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelFive *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelFour *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelOne *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelThree *HierarchyLevel `type:"structure"`

	// A HierarchyLevel object that contains information about the hierarchy group
	// level.
	LevelTwo *HierarchyLevel `type:"structure"`
}

// String returns the string representation
func (s HierarchyStructure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HierarchyStructure) GoString() string {
	return s.String()
}

// SetLevelFive sets the LevelFive field's value.
func (s *HierarchyStructure) SetLevelFive(v *HierarchyLevel) *HierarchyStructure {
	s.LevelFive = v
	return s
}

// SetLevelFour sets the LevelFour field's value.
func (s *HierarchyStructure) SetLevelFour(v *HierarchyLevel) *HierarchyStructure {
	s.LevelFour = v
	return s
}

// SetLevelOne sets the LevelOne field's value.
func (s *HierarchyStructure) SetLevelOne(v *HierarchyLevel) *HierarchyStructure {
	s.LevelOne = v
	return s
}

// SetLevelThree sets the LevelThree field's value.
func (s *HierarchyStructure) SetLevelThree(v *HierarchyLevel) *HierarchyStructure {
	s.LevelThree = v
	return s
}

// SetLevelTwo sets the LevelTwo field's value.
func (s *HierarchyStructure) SetLevelTwo(v *HierarchyLevel) *HierarchyStructure {
	s.LevelTwo = v
	return s
}

// A HistoricalMetric object that contains the Name, Unit, Statistic, and Threshold
// for the metric.
type HistoricalMetric struct {
	_ struct{} `type:"structure"`

	// The name of the historical metric.
	Name *string `type:"string" enum:"HistoricalMetricName"`

	// The statistic for the metric: SUM, MAX, or SUM.
	Statistic *string `type:"string" enum:"Statistic"`

	// The threshold for the metric, used with service level metrics.
	Threshold *Threshold `type:"structure"`

	// The unit for the metric: COUNT, PERCENT, or SECONDS.
	Unit *string `type:"string" enum:"Unit"`
}

// String returns the string representation
func (s HistoricalMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HistoricalMetric) SetName(v string) *HistoricalMetric {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *HistoricalMetric) SetStatistic(v string) *HistoricalMetric {
	s.Statistic = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *HistoricalMetric) SetThreshold(v *Threshold) *HistoricalMetric {
	s.Threshold = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *HistoricalMetric) SetUnit(v string) *HistoricalMetric {
	s.Unit = &v
	return s
}

// A HistoricalMetricData object than contains a Metric and a Value.
type HistoricalMetricData struct {
	_ struct{} `type:"structure"`

	// A HistoricalMetric object.
	Metric *HistoricalMetric `type:"structure"`

	// The Value of the metric.
	Value *float64 `type:"double"`
}

// String returns the string representation
func (s HistoricalMetricData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetricData) GoString() string {
	return s.String()
}

// SetMetric sets the Metric field's value.
func (s *HistoricalMetricData) SetMetric(v *HistoricalMetric) *HistoricalMetricData {
	s.Metric = v
	return s
}

// SetValue sets the Value field's value.
func (s *HistoricalMetricData) SetValue(v float64) *HistoricalMetricData {
	s.Value = &v
	return s
}

// The metrics data returned from a GetMetricData operation.
type HistoricalMetricResult struct {
	_ struct{} `type:"structure"`

	// A list of HistoricalMetricData objects.
	Collections []*HistoricalMetricData `type:"list"`

	// The Dimensions for the metrics.
	Dimensions *Dimensions `type:"structure"`
}

// String returns the string representation
func (s HistoricalMetricResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoricalMetricResult) GoString() string {
	return s.String()
}

// SetCollections sets the Collections field's value.
func (s *HistoricalMetricResult) SetCollections(v []*HistoricalMetricData) *HistoricalMetricResult {
	s.Collections = v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *HistoricalMetricResult) SetDimensions(v *Dimensions) *HistoricalMetricResult {
	s.Dimensions = v
	return s
}

type ListRoutingProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of routing profiles to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListRoutingProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutingProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoutingProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoutingProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListRoutingProfilesInput) SetInstanceId(v string) *ListRoutingProfilesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoutingProfilesInput) SetMaxResults(v int64) *ListRoutingProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingProfilesInput) SetNextToken(v string) *ListRoutingProfilesInput {
	s.NextToken = &v
	return s
}

type ListRoutingProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of RoutingProfileSummary objects that include the ARN, Id, and Name
	// of the routing profile.
	RoutingProfileSummaryList []*RoutingProfileSummary `type:"list"`
}

// String returns the string representation
func (s ListRoutingProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoutingProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoutingProfilesOutput) SetNextToken(v string) *ListRoutingProfilesOutput {
	s.NextToken = &v
	return s
}

// SetRoutingProfileSummaryList sets the RoutingProfileSummaryList field's value.
func (s *ListRoutingProfilesOutput) SetRoutingProfileSummaryList(v []*RoutingProfileSummary) *ListRoutingProfilesOutput {
	s.RoutingProfileSummaryList = v
	return s
}

type ListSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of security profiles to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListSecurityProfilesInput) SetInstanceId(v string) *ListSecurityProfilesInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityProfilesInput) SetMaxResults(v int64) *ListSecurityProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesInput) SetNextToken(v string) *ListSecurityProfilesInput {
	s.NextToken = &v
	return s
}

type ListSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of SecurityProfileSummary objects.
	SecurityProfileSummaryList []*SecurityProfileSummary `type:"list"`
}

// String returns the string representation
func (s ListSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSecurityProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityProfilesOutput) SetNextToken(v string) *ListSecurityProfilesOutput {
	s.NextToken = &v
	return s
}

// SetSecurityProfileSummaryList sets the SecurityProfileSummaryList field's value.
func (s *ListSecurityProfilesOutput) SetSecurityProfileSummaryList(v []*SecurityProfileSummary) *ListSecurityProfilesOutput {
	s.SecurityProfileSummaryList = v
	return s
}

type ListUserHierarchyGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of hierarchy groups to return.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListUserHierarchyGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserHierarchyGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserHierarchyGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserHierarchyGroupsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListUserHierarchyGroupsInput) SetInstanceId(v string) *ListUserHierarchyGroupsInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserHierarchyGroupsInput) SetMaxResults(v int64) *ListUserHierarchyGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserHierarchyGroupsInput) SetNextToken(v string) *ListUserHierarchyGroupsInput {
	s.NextToken = &v
	return s
}

type ListUserHierarchyGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of HierarchyGroupSummary objects.
	UserHierarchyGroupSummaryList []*HierarchyGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListUserHierarchyGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserHierarchyGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserHierarchyGroupsOutput) SetNextToken(v string) *ListUserHierarchyGroupsOutput {
	s.NextToken = &v
	return s
}

// SetUserHierarchyGroupSummaryList sets the UserHierarchyGroupSummaryList field's value.
func (s *ListUserHierarchyGroupsOutput) SetUserHierarchyGroupSummaryList(v []*HierarchyGroupSummary) *ListUserHierarchyGroupsOutput {
	s.UserHierarchyGroupSummaryList = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListUsersInput) SetInstanceId(v string) *ListUsersInput {
	s.InstanceId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of UserSummary objects that contain information about the users
	// in your instance.
	UserSummaryList []*UserSummary `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUserSummaryList sets the UserSummaryList field's value.
func (s *ListUsersOutput) SetUserSummaryList(v []*UserSummary) *ListUsersOutput {
	s.UserSummaryList = v
	return s
}

// A QueueReference object that contains the the QueueId and ARN for the queue
// resource for which metrics are returned.
type QueueReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of queue.
	Arn *string `type:"string"`

	// The ID of the queue associated with the metrics returned.
	Id *string `type:"string"`
}

// String returns the string representation
func (s QueueReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueReference) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *QueueReference) SetArn(v string) *QueueReference {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *QueueReference) SetId(v string) *QueueReference {
	s.Id = &v
	return s
}

// A RoutingProfileSummary object that contains information about a routing
// profile, including ARN, Id, and Name.
type RoutingProfileSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the routing profile.
	Arn *string `type:"string"`

	// The identifier of the routing profile.
	Id *string `type:"string"`

	// The name of the routing profile.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RoutingProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingProfileSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RoutingProfileSummary) SetArn(v string) *RoutingProfileSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *RoutingProfileSummary) SetId(v string) *RoutingProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *RoutingProfileSummary) SetName(v string) *RoutingProfileSummary {
	s.Name = &v
	return s
}

// A SecurityProfileSummary object that contains information about a security
// profile, including ARN, Id, Name.
type SecurityProfileSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the security profile.
	Arn *string `type:"string"`

	// The identifier of the security profile.
	Id *string `type:"string"`

	// The name of the security profile.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityProfileSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SecurityProfileSummary) SetArn(v string) *SecurityProfileSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *SecurityProfileSummary) SetId(v string) *SecurityProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecurityProfileSummary) SetName(v string) *SecurityProfileSummary {
	s.Name = &v
	return s
}

type StartOutboundVoiceContactInput struct {
	_ struct{} `type:"structure"`

	// Specify a custom key-value pair using an attribute map. The attributes are
	// standard Amazon Connect attributes, and can be accessed in contact flows
	// just like any other contact attributes.
	//
	// There can be up to 32,768 UTF-8 bytes across all key-value pairs. Attribute
	// keys can include only alphanumeric, dash, and underscore characters.
	//
	// For example, if you want play a greeting when the customer answers the call,
	// you can pass the customer name in attributes similar to the following:
	Attributes map[string]*string `type:"map"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. The token is valid for 7 days after creation. If a contact
	// is already started, the contact ID is returned. If the contact is disconnected,
	// a new contact is started.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier for the contact flow to connect the outbound call to.
	//
	// To find the ContactFlowId, open the contact flow you want to use in the Amazon
	// Connect contact flow editor. The ID for the contact flow is displayed in
	// the address bar as part of the URL. For example, the contact flow ID is the
	// set of characters at the end of the URL, after 'contact-flow/' such as 78ea8fd5-2659-4f2b-b528-699760ccfc1b.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The phone number of the customer in E.164 format.
	//
	// DestinationPhoneNumber is a required field
	DestinationPhoneNumber *string `type:"string" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The queue to add the call to. If you specify a queue, the phone displayed
	// for caller ID is the phone number specified in the queue. If you do not specify
	// a queue, the queue used will be the queue defined in the contact flow.
	//
	// To find the QueueId, open the queue you want to use in the Amazon Connect
	// Queue editor. The ID for the queue is displayed in the address bar as part
	// of the URL. For example, the queue ID is the set of characters at the end
	// of the URL, after 'queue/' such as queue/aeg40574-2d01-51c3-73d6-bf8624d2168c.
	QueueId *string `type:"string"`

	// The phone number, in E.164 format, associated with your Amazon Connect instance
	// to use for the outbound call.
	SourcePhoneNumber *string `type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOutboundVoiceContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartOutboundVoiceContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartOutboundVoiceContactInput"}
	if s.ContactFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactFlowId"))
	}
	if s.DestinationPhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationPhoneNumber"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *StartOutboundVoiceContactInput) SetAttributes(v map[string]*string) *StartOutboundVoiceContactInput {
	s.Attributes = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *StartOutboundVoiceContactInput) SetClientToken(v string) *StartOutboundVoiceContactInput {
	s.ClientToken = &v
	return s
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *StartOutboundVoiceContactInput) SetContactFlowId(v string) *StartOutboundVoiceContactInput {
	s.ContactFlowId = &v
	return s
}

// SetDestinationPhoneNumber sets the DestinationPhoneNumber field's value.
func (s *StartOutboundVoiceContactInput) SetDestinationPhoneNumber(v string) *StartOutboundVoiceContactInput {
	s.DestinationPhoneNumber = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StartOutboundVoiceContactInput) SetInstanceId(v string) *StartOutboundVoiceContactInput {
	s.InstanceId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *StartOutboundVoiceContactInput) SetQueueId(v string) *StartOutboundVoiceContactInput {
	s.QueueId = &v
	return s
}

// SetSourcePhoneNumber sets the SourcePhoneNumber field's value.
func (s *StartOutboundVoiceContactInput) SetSourcePhoneNumber(v string) *StartOutboundVoiceContactInput {
	s.SourcePhoneNumber = &v
	return s
}

type StartOutboundVoiceContactOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of this contact within your Amazon Connect instance.
	ContactId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartOutboundVoiceContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartOutboundVoiceContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *StartOutboundVoiceContactOutput) SetContactId(v string) *StartOutboundVoiceContactOutput {
	s.ContactId = &v
	return s
}

type StopContactInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the contact to end.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *StopContactInput) SetContactId(v string) *StopContactInput {
	s.ContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopContactInput) SetInstanceId(v string) *StopContactInput {
	s.InstanceId = &v
	return s
}

type StopContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopContactOutput) GoString() string {
	return s.String()
}

// A Threshold object that includes a comparison and ThresholdValue to compare
// to. Used with service level metrics.
type Threshold struct {
	_ struct{} `type:"structure"`

	// The Threshold to use to compare service level metrics to. Only "Less than"
	// (LT) comparisons are supported.
	Comparison *string `type:"string" enum:"Comparison"`

	// The value of the threshold to compare the metric to. Only "Less than" (LT)
	// comparisons are supported.
	ThresholdValue *float64 `type:"double"`
}

// String returns the string representation
func (s Threshold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Threshold) GoString() string {
	return s.String()
}

// SetComparison sets the Comparison field's value.
func (s *Threshold) SetComparison(v string) *Threshold {
	s.Comparison = &v
	return s
}

// SetThresholdValue sets the ThresholdValue field's value.
func (s *Threshold) SetThresholdValue(v float64) *Threshold {
	s.ThresholdValue = &v
	return s
}

type UpdateContactAttributesInput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs for the attribute to update.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// The unique identifier of the contact for which to update attributes. This
	// is the identifier for the contact associated with the first interaction with
	// the contact center.
	//
	// InitialContactId is a required field
	InitialContactId *string `min:"1" type:"string" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateContactAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContactAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContactAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.InitialContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("InitialContactId"))
	}
	if s.InitialContactId != nil && len(*s.InitialContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitialContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateContactAttributesInput) SetAttributes(v map[string]*string) *UpdateContactAttributesInput {
	s.Attributes = v
	return s
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *UpdateContactAttributesInput) SetInitialContactId(v string) *UpdateContactAttributesInput {
	s.InitialContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateContactAttributesInput) SetInstanceId(v string) *UpdateContactAttributesInput {
	s.InstanceId = &v
	return s
}

type UpdateContactAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateContactAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateContactAttributesOutput) GoString() string {
	return s.String()
}

type UpdateUserHierarchyInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the hierarchy group to assign to the user.
	HierarchyGroupId *string `type:"string"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the user account to assign the hierarchy group to.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserHierarchyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserHierarchyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserHierarchyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserHierarchyInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *UpdateUserHierarchyInput) SetHierarchyGroupId(v string) *UpdateUserHierarchyInput {
	s.HierarchyGroupId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserHierarchyInput) SetInstanceId(v string) *UpdateUserHierarchyInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserHierarchyInput) SetUserId(v string) *UpdateUserHierarchyInput {
	s.UserId = &v
	return s
}

type UpdateUserHierarchyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserHierarchyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserHierarchyOutput) GoString() string {
	return s.String()
}

type UpdateUserIdentityInfoInput struct {
	_ struct{} `type:"structure"`

	// A UserIdentityInfo object.
	//
	// IdentityInfo is a required field
	IdentityInfo *UserIdentityInfo `type:"structure" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier for the user account to update identity information for.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserIdentityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserIdentityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserIdentityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserIdentityInfoInput"}
	if s.IdentityInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityInfo"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *UpdateUserIdentityInfoInput) SetIdentityInfo(v *UserIdentityInfo) *UpdateUserIdentityInfoInput {
	s.IdentityInfo = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserIdentityInfoInput) SetInstanceId(v string) *UpdateUserIdentityInfoInput {
	s.InstanceId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserIdentityInfoInput) SetUserId(v string) *UpdateUserIdentityInfoInput {
	s.UserId = &v
	return s
}

type UpdateUserIdentityInfoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserIdentityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserIdentityInfoOutput) GoString() string {
	return s.String()
}

type UpdateUserPhoneConfigInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// A UserPhoneConfig object that contains settings for AfterContactWorkTimeLimit,
	// AutoAccept, DeskPhoneNumber, and PhoneType to assign to the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier for the user account to change phone settings for.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPhoneConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserPhoneConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserPhoneConfigInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneConfig"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserPhoneConfigInput) SetInstanceId(v string) *UpdateUserPhoneConfigInput {
	s.InstanceId = &v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *UpdateUserPhoneConfigInput) SetPhoneConfig(v *UserPhoneConfig) *UpdateUserPhoneConfigInput {
	s.PhoneConfig = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserPhoneConfigInput) SetUserId(v string) *UpdateUserPhoneConfigInput {
	s.UserId = &v
	return s
}

type UpdateUserPhoneConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserPhoneConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserPhoneConfigOutput) GoString() string {
	return s.String()
}

type UpdateUserRoutingProfileInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier of the routing profile to assign to the user.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The identifier for the user account to assign the routing profile to.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserRoutingProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRoutingProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRoutingProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserRoutingProfileInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserRoutingProfileInput) SetInstanceId(v string) *UpdateUserRoutingProfileInput {
	s.InstanceId = &v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *UpdateUserRoutingProfileInput) SetRoutingProfileId(v string) *UpdateUserRoutingProfileInput {
	s.RoutingProfileId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserRoutingProfileInput) SetUserId(v string) *UpdateUserRoutingProfileInput {
	s.UserId = &v
	return s
}

type UpdateUserRoutingProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserRoutingProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRoutingProfileOutput) GoString() string {
	return s.String()
}

type UpdateUserSecurityProfilesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifiers for the security profiles to assign to the user.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []*string `min:"1" type:"list" required:"true"`

	// The identifier of the user account to assign the security profiles.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"UserId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserSecurityProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSecurityProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserSecurityProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserSecurityProfilesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.SecurityProfileIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateUserSecurityProfilesInput) SetInstanceId(v string) *UpdateUserSecurityProfilesInput {
	s.InstanceId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *UpdateUserSecurityProfilesInput) SetSecurityProfileIds(v []*string) *UpdateUserSecurityProfilesInput {
	s.SecurityProfileIds = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserSecurityProfilesInput) SetUserId(v string) *UpdateUserSecurityProfilesInput {
	s.UserId = &v
	return s
}

type UpdateUserSecurityProfilesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserSecurityProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSecurityProfilesOutput) GoString() string {
	return s.String()
}

// A User object that contains information about a user account in your Amazon
// Connect instance, including configuration settings.
type User struct {
	_ struct{} `type:"structure"`

	// The ARN of the user account.
	Arn *string `type:"string"`

	// The directory Id for the user account in the existing directory used for
	// identity management.
	DirectoryUserId *string `type:"string"`

	// The identifier for the hierarchy group assigned to the user.
	HierarchyGroupId *string `type:"string"`

	// The identifier of the user account.
	Id *string `type:"string"`

	// A UserIdentityInfo object.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// A UserPhoneConfig object.
	PhoneConfig *UserPhoneConfig `type:"structure"`

	// The identifier of the routing profile assigned to the user.
	RoutingProfileId *string `type:"string"`

	// The identifier(s) for the security profile assigned to the user.
	SecurityProfileIds []*string `min:"1" type:"list"`

	// The user name assigned to the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetDirectoryUserId sets the DirectoryUserId field's value.
func (s *User) SetDirectoryUserId(v string) *User {
	s.DirectoryUserId = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *User) SetHierarchyGroupId(v string) *User {
	s.HierarchyGroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *User) SetIdentityInfo(v *UserIdentityInfo) *User {
	s.IdentityInfo = v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *User) SetPhoneConfig(v *UserPhoneConfig) *User {
	s.PhoneConfig = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *User) SetRoutingProfileId(v string) *User {
	s.RoutingProfileId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *User) SetSecurityProfileIds(v []*string) *User {
	s.SecurityProfileIds = v
	return s
}

// SetUsername sets the Username field's value.
func (s *User) SetUsername(v string) *User {
	s.Username = &v
	return s
}

// A UserIdentityInfo object that contains information about the user's identity,
// including email address, first name, and last name.
type UserIdentityInfo struct {
	_ struct{} `type:"structure"`

	// The email address added to the user account. If you are using SAML for identity
	// management and include this parameter, an InvalidRequestException is returned.
	Email *string `type:"string"`

	// The first name used in the user account. This is required if you are using
	// Amazon Connect or SAML for identity management.
	FirstName *string `min:"1" type:"string"`

	// The last name used in the user account. This is required if you are using
	// Amazon Connect or SAML for identity management.
	LastName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserIdentityInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserIdentityInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserIdentityInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserIdentityInfo"}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *UserIdentityInfo) SetEmail(v string) *UserIdentityInfo {
	s.Email = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UserIdentityInfo) SetFirstName(v string) *UserIdentityInfo {
	s.FirstName = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UserIdentityInfo) SetLastName(v string) *UserIdentityInfo {
	s.LastName = &v
	return s
}

// A UserPhoneConfig object that contains information about the user phone configuration
// settings.
type UserPhoneConfig struct {
	_ struct{} `type:"structure"`

	// The After Call Work (ACW) timeout setting, in seconds, for the user.
	AfterContactWorkTimeLimit *int64 `type:"integer"`

	// The Auto accept setting for the user, Yes or No.
	AutoAccept *bool `type:"boolean"`

	// The phone number for the user's desk phone.
	DeskPhoneNumber *string `type:"string"`

	// The phone type selected for the user, either Soft phone or Desk phone.
	//
	// PhoneType is a required field
	PhoneType *string `type:"string" required:"true" enum:"PhoneType"`
}

// String returns the string representation
func (s UserPhoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserPhoneConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserPhoneConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserPhoneConfig"}
	if s.PhoneType == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterContactWorkTimeLimit sets the AfterContactWorkTimeLimit field's value.
func (s *UserPhoneConfig) SetAfterContactWorkTimeLimit(v int64) *UserPhoneConfig {
	s.AfterContactWorkTimeLimit = &v
	return s
}

// SetAutoAccept sets the AutoAccept field's value.
func (s *UserPhoneConfig) SetAutoAccept(v bool) *UserPhoneConfig {
	s.AutoAccept = &v
	return s
}

// SetDeskPhoneNumber sets the DeskPhoneNumber field's value.
func (s *UserPhoneConfig) SetDeskPhoneNumber(v string) *UserPhoneConfig {
	s.DeskPhoneNumber = &v
	return s
}

// SetPhoneType sets the PhoneType field's value.
func (s *UserPhoneConfig) SetPhoneType(v string) *UserPhoneConfig {
	s.PhoneType = &v
	return s
}

// A UserSummary object that contains Information about a user, including ARN,
// Id, and user name.
type UserSummary struct {
	_ struct{} `type:"structure"`

	// The ARN for the user account.
	Arn *string `type:"string"`

	// The identifier for the user account.
	Id *string `type:"string"`

	// The Amazon Connect user name for the user account.
	Username *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UserSummary) SetArn(v string) *UserSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UserSummary) SetId(v string) *UserSummary {
	s.Id = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UserSummary) SetUsername(v string) *UserSummary {
	s.Username = &v
	return s
}

const (
	// ChannelVoice is a Channel enum value
	ChannelVoice = "VOICE"
)

const (
	// ComparisonLt is a Comparison enum value
	ComparisonLt = "LT"
)

// A list of current metric names.
const (
	// CurrentMetricNameAgentsOnline is a CurrentMetricName enum value
	CurrentMetricNameAgentsOnline = "AGENTS_ONLINE"

	// CurrentMetricNameAgentsAvailable is a CurrentMetricName enum value
	CurrentMetricNameAgentsAvailable = "AGENTS_AVAILABLE"

	// CurrentMetricNameAgentsOnCall is a CurrentMetricName enum value
	CurrentMetricNameAgentsOnCall = "AGENTS_ON_CALL"

	// CurrentMetricNameAgentsNonProductive is a CurrentMetricName enum value
	CurrentMetricNameAgentsNonProductive = "AGENTS_NON_PRODUCTIVE"

	// CurrentMetricNameAgentsAfterContactWork is a CurrentMetricName enum value
	CurrentMetricNameAgentsAfterContactWork = "AGENTS_AFTER_CONTACT_WORK"

	// CurrentMetricNameAgentsError is a CurrentMetricName enum value
	CurrentMetricNameAgentsError = "AGENTS_ERROR"

	// CurrentMetricNameAgentsStaffed is a CurrentMetricName enum value
	CurrentMetricNameAgentsStaffed = "AGENTS_STAFFED"

	// CurrentMetricNameContactsInQueue is a CurrentMetricName enum value
	CurrentMetricNameContactsInQueue = "CONTACTS_IN_QUEUE"

	// CurrentMetricNameOldestContactAge is a CurrentMetricName enum value
	CurrentMetricNameOldestContactAge = "OLDEST_CONTACT_AGE"

	// CurrentMetricNameContactsScheduled is a CurrentMetricName enum value
	CurrentMetricNameContactsScheduled = "CONTACTS_SCHEDULED"
)

const (
	// GroupingQueue is a Grouping enum value
	GroupingQueue = "QUEUE"

	// GroupingChannel is a Grouping enum value
	GroupingChannel = "CHANNEL"
)

// A list of historical metric names.
const (
	// HistoricalMetricNameContactsQueued is a HistoricalMetricName enum value
	HistoricalMetricNameContactsQueued = "CONTACTS_QUEUED"

	// HistoricalMetricNameContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandled = "CONTACTS_HANDLED"

	// HistoricalMetricNameContactsAbandoned is a HistoricalMetricName enum value
	HistoricalMetricNameContactsAbandoned = "CONTACTS_ABANDONED"

	// HistoricalMetricNameContactsConsulted is a HistoricalMetricName enum value
	HistoricalMetricNameContactsConsulted = "CONTACTS_CONSULTED"

	// HistoricalMetricNameContactsAgentHungUpFirst is a HistoricalMetricName enum value
	HistoricalMetricNameContactsAgentHungUpFirst = "CONTACTS_AGENT_HUNG_UP_FIRST"

	// HistoricalMetricNameContactsHandledIncoming is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandledIncoming = "CONTACTS_HANDLED_INCOMING"

	// HistoricalMetricNameContactsHandledOutbound is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHandledOutbound = "CONTACTS_HANDLED_OUTBOUND"

	// HistoricalMetricNameContactsHoldAbandons is a HistoricalMetricName enum value
	HistoricalMetricNameContactsHoldAbandons = "CONTACTS_HOLD_ABANDONS"

	// HistoricalMetricNameContactsTransferredIn is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredIn = "CONTACTS_TRANSFERRED_IN"

	// HistoricalMetricNameContactsTransferredOut is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredOut = "CONTACTS_TRANSFERRED_OUT"

	// HistoricalMetricNameContactsTransferredInFromQueue is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredInFromQueue = "CONTACTS_TRANSFERRED_IN_FROM_QUEUE"

	// HistoricalMetricNameContactsTransferredOutFromQueue is a HistoricalMetricName enum value
	HistoricalMetricNameContactsTransferredOutFromQueue = "CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"

	// HistoricalMetricNameContactsMissed is a HistoricalMetricName enum value
	HistoricalMetricNameContactsMissed = "CONTACTS_MISSED"

	// HistoricalMetricNameCallbackContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameCallbackContactsHandled = "CALLBACK_CONTACTS_HANDLED"

	// HistoricalMetricNameApiContactsHandled is a HistoricalMetricName enum value
	HistoricalMetricNameApiContactsHandled = "API_CONTACTS_HANDLED"

	// HistoricalMetricNameOccupancy is a HistoricalMetricName enum value
	HistoricalMetricNameOccupancy = "OCCUPANCY"

	// HistoricalMetricNameHandleTime is a HistoricalMetricName enum value
	HistoricalMetricNameHandleTime = "HANDLE_TIME"

	// HistoricalMetricNameAfterContactWorkTime is a HistoricalMetricName enum value
	HistoricalMetricNameAfterContactWorkTime = "AFTER_CONTACT_WORK_TIME"

	// HistoricalMetricNameQueuedTime is a HistoricalMetricName enum value
	HistoricalMetricNameQueuedTime = "QUEUED_TIME"

	// HistoricalMetricNameAbandonTime is a HistoricalMetricName enum value
	HistoricalMetricNameAbandonTime = "ABANDON_TIME"

	// HistoricalMetricNameQueueAnswerTime is a HistoricalMetricName enum value
	HistoricalMetricNameQueueAnswerTime = "QUEUE_ANSWER_TIME"

	// HistoricalMetricNameHoldTime is a HistoricalMetricName enum value
	HistoricalMetricNameHoldTime = "HOLD_TIME"

	// HistoricalMetricNameInteractionTime is a HistoricalMetricName enum value
	HistoricalMetricNameInteractionTime = "INTERACTION_TIME"

	// HistoricalMetricNameInteractionAndHoldTime is a HistoricalMetricName enum value
	HistoricalMetricNameInteractionAndHoldTime = "INTERACTION_AND_HOLD_TIME"

	// HistoricalMetricNameServiceLevel is a HistoricalMetricName enum value
	HistoricalMetricNameServiceLevel = "SERVICE_LEVEL"
)

const (
	// PhoneTypeSoftPhone is a PhoneType enum value
	PhoneTypeSoftPhone = "SOFT_PHONE"

	// PhoneTypeDeskPhone is a PhoneType enum value
	PhoneTypeDeskPhone = "DESK_PHONE"
)

const (
	// StatisticSum is a Statistic enum value
	StatisticSum = "SUM"

	// StatisticMax is a Statistic enum value
	StatisticMax = "MAX"

	// StatisticAvg is a Statistic enum value
	StatisticAvg = "AVG"
)

const (
	// UnitSeconds is a Unit enum value
	UnitSeconds = "SECONDS"

	// UnitCount is a Unit enum value
	UnitCount = "COUNT"

	// UnitPercent is a Unit enum value
	UnitPercent = "PERCENT"
)
