// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package engagementfabric

import original "github.com/Azure/azure-sdk-for-go/services/preview/engagementfabric/mgmt/2018-09-01/engagementfabric"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CheckNameUnavailableReason = original.CheckNameUnavailableReason

const (
	AlreadyExists CheckNameUnavailableReason = original.AlreadyExists
	Invalid       CheckNameUnavailableReason = original.Invalid
)

type KeyRank = original.KeyRank

const (
	PrimaryKey   KeyRank = original.PrimaryKey
	SecondaryKey KeyRank = original.SecondaryKey
)

type Account = original.Account
type AccountList = original.AccountList
type AccountPatch = original.AccountPatch
type AccountsClient = original.AccountsClient
type BaseClient = original.BaseClient
type Channel = original.Channel
type ChannelList = original.ChannelList
type ChannelProperties = original.ChannelProperties
type ChannelTypeDescription = original.ChannelTypeDescription
type ChannelTypeDescriptionList = original.ChannelTypeDescriptionList
type ChannelsClient = original.ChannelsClient
type CheckNameAvailabilityParameter = original.CheckNameAvailabilityParameter
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type KeyDescription = original.KeyDescription
type KeyDescriptionList = original.KeyDescriptionList
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationsClient = original.OperationsClient
type ProxyOnlyResource = original.ProxyOnlyResource
type RegenerateKeyParameter = original.RegenerateKeyParameter
type Resource = original.Resource
type SKU = original.SKU
type SKUsClient = original.SKUsClient
type SkuDescription = original.SkuDescription
type SkuDescriptionList = original.SkuDescriptionList
type SkuLocationInfoItem = original.SkuLocationInfoItem
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountsClient(subscriptionID string) AccountsClient {
	return original.NewAccountsClient(subscriptionID)
}
func NewAccountsClientWithBaseURI(baseURI string, subscriptionID string) AccountsClient {
	return original.NewAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewChannelsClient(subscriptionID string) ChannelsClient {
	return original.NewChannelsClient(subscriptionID)
}
func NewChannelsClientWithBaseURI(baseURI string, subscriptionID string) ChannelsClient {
	return original.NewChannelsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSKUsClient(subscriptionID string) SKUsClient {
	return original.NewSKUsClient(subscriptionID)
}
func NewSKUsClientWithBaseURI(baseURI string, subscriptionID string) SKUsClient {
	return original.NewSKUsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCheckNameUnavailableReasonValues() []CheckNameUnavailableReason {
	return original.PossibleCheckNameUnavailableReasonValues()
}
func PossibleKeyRankValues() []KeyRank {
	return original.PossibleKeyRankValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
