// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dlm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateLifecyclePolicy = "CreateLifecyclePolicy"

// CreateLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLifecyclePolicy for more information on using the CreateLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLifecyclePolicyRequest method.
//    req, resp := client.CreateLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/CreateLifecyclePolicy
func (c *DLM) CreateLifecyclePolicyRequest(input *CreateLifecyclePolicyInput) (req *request.Request, output *CreateLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opCreateLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &CreateLifecyclePolicyInput{}
	}

	output = &CreateLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Creates a policy to manage the lifecycle of the specified AWS resources.
// You can create up to 100 lifecycle policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation CreateLifecyclePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request failed because a limit was exceeded.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The service failed in an unexpected way.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/CreateLifecyclePolicy
func (c *DLM) CreateLifecyclePolicy(input *CreateLifecyclePolicyInput) (*CreateLifecyclePolicyOutput, error) {
	req, out := c.CreateLifecyclePolicyRequest(input)
	return out, req.Send()
}

// CreateLifecyclePolicyWithContext is the same as CreateLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) CreateLifecyclePolicyWithContext(ctx aws.Context, input *CreateLifecyclePolicyInput, opts ...request.Option) (*CreateLifecyclePolicyOutput, error) {
	req, out := c.CreateLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLifecyclePolicy = "DeleteLifecyclePolicy"

// DeleteLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLifecyclePolicy for more information on using the DeleteLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLifecyclePolicyRequest method.
//    req, resp := client.DeleteLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/DeleteLifecyclePolicy
func (c *DLM) DeleteLifecyclePolicyRequest(input *DeleteLifecyclePolicyInput) (req *request.Request, output *DeleteLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecyclePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/policies/{policyId}/",
	}

	if input == nil {
		input = &DeleteLifecyclePolicyInput{}
	}

	output = &DeleteLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Deletes the specified lifecycle policy and halts the automated operations
// that the policy specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation DeleteLifecyclePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A requested resource was not found.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The service failed in an unexpected way.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/DeleteLifecyclePolicy
func (c *DLM) DeleteLifecyclePolicy(input *DeleteLifecyclePolicyInput) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	return out, req.Send()
}

// DeleteLifecyclePolicyWithContext is the same as DeleteLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) DeleteLifecyclePolicyWithContext(ctx aws.Context, input *DeleteLifecyclePolicyInput, opts ...request.Option) (*DeleteLifecyclePolicyOutput, error) {
	req, out := c.DeleteLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLifecyclePolicies = "GetLifecyclePolicies"

// GetLifecyclePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetLifecyclePolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLifecyclePolicies for more information on using the GetLifecyclePolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLifecyclePoliciesRequest method.
//    req, resp := client.GetLifecyclePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicies
func (c *DLM) GetLifecyclePoliciesRequest(input *GetLifecyclePoliciesInput) (req *request.Request, output *GetLifecyclePoliciesOutput) {
	op := &request.Operation{
		Name:       opGetLifecyclePolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/policies",
	}

	if input == nil {
		input = &GetLifecyclePoliciesInput{}
	}

	output = &GetLifecyclePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLifecyclePolicies API operation for Amazon Data Lifecycle Manager.
//
// Gets summary information about all or the specified data lifecycle policies.
//
// To get complete information about a policy, use GetLifecyclePolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation GetLifecyclePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A requested resource was not found.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The service failed in an unexpected way.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicies
func (c *DLM) GetLifecyclePolicies(input *GetLifecyclePoliciesInput) (*GetLifecyclePoliciesOutput, error) {
	req, out := c.GetLifecyclePoliciesRequest(input)
	return out, req.Send()
}

// GetLifecyclePoliciesWithContext is the same as GetLifecyclePolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetLifecyclePolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) GetLifecyclePoliciesWithContext(ctx aws.Context, input *GetLifecyclePoliciesInput, opts ...request.Option) (*GetLifecyclePoliciesOutput, error) {
	req, out := c.GetLifecyclePoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLifecyclePolicy = "GetLifecyclePolicy"

// GetLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLifecyclePolicy for more information on using the GetLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLifecyclePolicyRequest method.
//    req, resp := client.GetLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicy
func (c *DLM) GetLifecyclePolicyRequest(input *GetLifecyclePolicyInput) (req *request.Request, output *GetLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opGetLifecyclePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/policies/{policyId}/",
	}

	if input == nil {
		input = &GetLifecyclePolicyInput{}
	}

	output = &GetLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Gets detailed information about the specified lifecycle policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation GetLifecyclePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A requested resource was not found.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The service failed in an unexpected way.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/GetLifecyclePolicy
func (c *DLM) GetLifecyclePolicy(input *GetLifecyclePolicyInput) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	return out, req.Send()
}

// GetLifecyclePolicyWithContext is the same as GetLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) GetLifecyclePolicyWithContext(ctx aws.Context, input *GetLifecyclePolicyInput, opts ...request.Option) (*GetLifecyclePolicyOutput, error) {
	req, out := c.GetLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLifecyclePolicy = "UpdateLifecyclePolicy"

// UpdateLifecyclePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLifecyclePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLifecyclePolicy for more information on using the UpdateLifecyclePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLifecyclePolicyRequest method.
//    req, resp := client.UpdateLifecyclePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicy
func (c *DLM) UpdateLifecyclePolicyRequest(input *UpdateLifecyclePolicyInput) (req *request.Request, output *UpdateLifecyclePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateLifecyclePolicy,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyId}",
	}

	if input == nil {
		input = &UpdateLifecyclePolicyInput{}
	}

	output = &UpdateLifecyclePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLifecyclePolicy API operation for Amazon Data Lifecycle Manager.
//
// Updates the specified lifecycle policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Data Lifecycle Manager's
// API operation UpdateLifecyclePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   A requested resource was not found.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   Bad request. The request is missing required parameters or has invalid parameters.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   The service failed in an unexpected way.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The request failed because a limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicy
func (c *DLM) UpdateLifecyclePolicy(input *UpdateLifecyclePolicyInput) (*UpdateLifecyclePolicyOutput, error) {
	req, out := c.UpdateLifecyclePolicyRequest(input)
	return out, req.Send()
}

// UpdateLifecyclePolicyWithContext is the same as UpdateLifecyclePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLifecyclePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DLM) UpdateLifecyclePolicyWithContext(ctx aws.Context, input *UpdateLifecyclePolicyInput, opts ...request.Option) (*UpdateLifecyclePolicyOutput, error) {
	req, out := c.UpdateLifecyclePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the lifecycle policy. The characters ^[0-9A-Za-z _-]+$ are
	// supported.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `type:"string" required:"true"`

	// The configuration details of the lifecycle policy.
	//
	// Target tags cannot be re-used across lifecycle policies.
	//
	// PolicyDetails is a required field
	PolicyDetails *PolicyDetails `type:"structure" required:"true"`

	// The desired activation state of the lifecycle policy after creation.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"SettablePolicyStateValues"`
}

// String returns the string representation
func (s CreateLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLifecyclePolicyInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.PolicyDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDetails"))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.PolicyDetails != nil {
		if err := s.PolicyDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateLifecyclePolicyInput) SetDescription(v string) *CreateLifecyclePolicyInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateLifecyclePolicyInput) SetExecutionRoleArn(v string) *CreateLifecyclePolicyInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *CreateLifecyclePolicyInput) SetPolicyDetails(v *PolicyDetails) *CreateLifecyclePolicyInput {
	s.PolicyDetails = v
	return s
}

// SetState sets the State field's value.
func (s *CreateLifecyclePolicyInput) SetState(v string) *CreateLifecyclePolicyInput {
	s.State = &v
	return s
}

type CreateLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`
}

// String returns the string representation
func (s CreateLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyId sets the PolicyId field's value.
func (s *CreateLifecyclePolicyOutput) SetPolicyId(v string) *CreateLifecyclePolicyOutput {
	s.PolicyId = &v
	return s
}

// Specifies when to create snapshots of EBS volumes.
type CreateRule struct {
	_ struct{} `type:"structure"`

	// The interval. The supported values are 12 and 24.
	//
	// Interval is a required field
	Interval *int64 `min:"1" type:"integer" required:"true"`

	// The interval unit.
	//
	// IntervalUnit is a required field
	IntervalUnit *string `type:"string" required:"true" enum:"IntervalUnitValues"`

	// The time, in UTC, to start the operation.
	//
	// The operation occurs within a one-hour window following the specified time.
	Times []*string `type:"list"`
}

// String returns the string representation
func (s CreateRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRule"}
	if s.Interval == nil {
		invalidParams.Add(request.NewErrParamRequired("Interval"))
	}
	if s.Interval != nil && *s.Interval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 1))
	}
	if s.IntervalUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalUnit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *CreateRule) SetInterval(v int64) *CreateRule {
	s.Interval = &v
	return s
}

// SetIntervalUnit sets the IntervalUnit field's value.
func (s *CreateRule) SetIntervalUnit(v string) *CreateRule {
	s.IntervalUnit = &v
	return s
}

// SetTimes sets the Times field's value.
func (s *CreateRule) SetTimes(v []*string) *CreateRule {
	s.Times = v
	return s
}

type DeleteLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *DeleteLifecyclePolicyInput) SetPolicyId(v string) *DeleteLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

type DeleteLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecyclePolicyOutput) GoString() string {
	return s.String()
}

type GetLifecyclePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the data lifecycle policies.
	PolicyIds []*string `location:"querystring" locationName:"policyIds" type:"list"`

	// The resource type.
	ResourceTypes []*string `location:"querystring" locationName:"resourceTypes" min:"1" type:"list"`

	// The activation state.
	State *string `location:"querystring" locationName:"state" type:"string" enum:"GettablePolicyStateValues"`

	// The tags to add to objects created by the policy.
	//
	// Tags are strings in the format key=value.
	//
	// These user-defined tags are added in addition to the AWS-added lifecycle
	// tags.
	TagsToAdd []*string `location:"querystring" locationName:"tagsToAdd" type:"list"`

	// The target tag for a policy.
	//
	// Tags are strings in the format key=value.
	TargetTags []*string `location:"querystring" locationName:"targetTags" min:"1" type:"list"`
}

// String returns the string representation
func (s GetLifecyclePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLifecyclePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLifecyclePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLifecyclePoliciesInput"}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.TargetTags != nil && len(s.TargetTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyIds sets the PolicyIds field's value.
func (s *GetLifecyclePoliciesInput) SetPolicyIds(v []*string) *GetLifecyclePoliciesInput {
	s.PolicyIds = v
	return s
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetLifecyclePoliciesInput) SetResourceTypes(v []*string) *GetLifecyclePoliciesInput {
	s.ResourceTypes = v
	return s
}

// SetState sets the State field's value.
func (s *GetLifecyclePoliciesInput) SetState(v string) *GetLifecyclePoliciesInput {
	s.State = &v
	return s
}

// SetTagsToAdd sets the TagsToAdd field's value.
func (s *GetLifecyclePoliciesInput) SetTagsToAdd(v []*string) *GetLifecyclePoliciesInput {
	s.TagsToAdd = v
	return s
}

// SetTargetTags sets the TargetTags field's value.
func (s *GetLifecyclePoliciesInput) SetTargetTags(v []*string) *GetLifecyclePoliciesInput {
	s.TargetTags = v
	return s
}

type GetLifecyclePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the lifecycle policies.
	Policies []*LifecyclePolicySummary `type:"list"`
}

// String returns the string representation
func (s GetLifecyclePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLifecyclePoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *GetLifecyclePoliciesOutput) SetPolicies(v []*LifecyclePolicySummary) *GetLifecyclePoliciesOutput {
	s.Policies = v
	return s
}

type GetLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyId sets the PolicyId field's value.
func (s *GetLifecyclePolicyInput) SetPolicyId(v string) *GetLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

type GetLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the lifecycle policy.
	Policy *LifecyclePolicy `type:"structure"`
}

// String returns the string representation
func (s GetLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLifecyclePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetLifecyclePolicyOutput) SetPolicy(v *LifecyclePolicy) *GetLifecyclePolicyOutput {
	s.Policy = v
	return s
}

// Detailed information about a lifecycle policy.
type LifecyclePolicy struct {
	_ struct{} `type:"structure"`

	// The local date and time when the lifecycle policy was created.
	DateCreated *time.Time `type:"timestamp"`

	// The local date and time when the lifecycle policy was last modified.
	DateModified *time.Time `type:"timestamp"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The configuration of the lifecycle policy
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The activation state of the lifecycle policy.
	State *string `type:"string" enum:"GettablePolicyStateValues"`
}

// String returns the string representation
func (s LifecyclePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecyclePolicy) GoString() string {
	return s.String()
}

// SetDateCreated sets the DateCreated field's value.
func (s *LifecyclePolicy) SetDateCreated(v time.Time) *LifecyclePolicy {
	s.DateCreated = &v
	return s
}

// SetDateModified sets the DateModified field's value.
func (s *LifecyclePolicy) SetDateModified(v time.Time) *LifecyclePolicy {
	s.DateModified = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LifecyclePolicy) SetDescription(v string) *LifecyclePolicy {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *LifecyclePolicy) SetExecutionRoleArn(v string) *LifecyclePolicy {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *LifecyclePolicy) SetPolicyDetails(v *PolicyDetails) *LifecyclePolicy {
	s.PolicyDetails = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *LifecyclePolicy) SetPolicyId(v string) *LifecyclePolicy {
	s.PolicyId = &v
	return s
}

// SetState sets the State field's value.
func (s *LifecyclePolicy) SetState(v string) *LifecyclePolicy {
	s.State = &v
	return s
}

// Summary information about a lifecycle policy.
type LifecyclePolicySummary struct {
	_ struct{} `type:"structure"`

	// The description of the lifecycle policy.
	Description *string `type:"string"`

	// The identifier of the lifecycle policy.
	PolicyId *string `type:"string"`

	// The activation state of the lifecycle policy.
	State *string `type:"string" enum:"GettablePolicyStateValues"`
}

// String returns the string representation
func (s LifecyclePolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecyclePolicySummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LifecyclePolicySummary) SetDescription(v string) *LifecyclePolicySummary {
	s.Description = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *LifecyclePolicySummary) SetPolicyId(v string) *LifecyclePolicySummary {
	s.PolicyId = &v
	return s
}

// SetState sets the State field's value.
func (s *LifecyclePolicySummary) SetState(v string) *LifecyclePolicySummary {
	s.State = &v
	return s
}

// Specifies the configuration of a lifecycle policy.
type PolicyDetails struct {
	_ struct{} `type:"structure"`

	// The resource type.
	ResourceTypes []*string `min:"1" type:"list"`

	// The schedule of policy-defined actions.
	Schedules []*Schedule `min:"1" type:"list"`

	// The single tag that identifies targeted resources for this policy.
	TargetTags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s PolicyDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyDetails"}
	if s.ResourceTypes != nil && len(s.ResourceTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceTypes", 1))
	}
	if s.Schedules != nil && len(s.Schedules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schedules", 1))
	}
	if s.TargetTags != nil && len(s.TargetTags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTags", 1))
	}
	if s.Schedules != nil {
		for i, v := range s.Schedules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schedules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetTags != nil {
		for i, v := range s.TargetTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *PolicyDetails) SetResourceTypes(v []*string) *PolicyDetails {
	s.ResourceTypes = v
	return s
}

// SetSchedules sets the Schedules field's value.
func (s *PolicyDetails) SetSchedules(v []*Schedule) *PolicyDetails {
	s.Schedules = v
	return s
}

// SetTargetTags sets the TargetTags field's value.
func (s *PolicyDetails) SetTargetTags(v []*Tag) *PolicyDetails {
	s.TargetTags = v
	return s
}

// Specifies the number of snapshots to keep for each EBS volume.
type RetainRule struct {
	_ struct{} `type:"structure"`

	// The number of snapshots to keep for each volume, up to a maximum of 1000.
	//
	// Count is a required field
	Count *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s RetainRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetainRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetainRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetainRule"}
	if s.Count == nil {
		invalidParams.Add(request.NewErrParamRequired("Count"))
	}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *RetainRule) SetCount(v int64) *RetainRule {
	s.Count = &v
	return s
}

// Specifies a schedule.
type Schedule struct {
	_ struct{} `type:"structure"`

	CopyTags *bool `type:"boolean"`

	// The create rule.
	CreateRule *CreateRule `type:"structure"`

	// The name of the schedule.
	Name *string `type:"string"`

	// The retain rule.
	RetainRule *RetainRule `type:"structure"`

	// The tags to apply to policy-created resources. These user-defined tags are
	// in addition to the AWS-added lifecycle tags.
	TagsToAdd []*Tag `type:"list"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Schedule"}
	if s.CreateRule != nil {
		if err := s.CreateRule.Validate(); err != nil {
			invalidParams.AddNested("CreateRule", err.(request.ErrInvalidParams))
		}
	}
	if s.RetainRule != nil {
		if err := s.RetainRule.Validate(); err != nil {
			invalidParams.AddNested("RetainRule", err.(request.ErrInvalidParams))
		}
	}
	if s.TagsToAdd != nil {
		for i, v := range s.TagsToAdd {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsToAdd", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyTags sets the CopyTags field's value.
func (s *Schedule) SetCopyTags(v bool) *Schedule {
	s.CopyTags = &v
	return s
}

// SetCreateRule sets the CreateRule field's value.
func (s *Schedule) SetCreateRule(v *CreateRule) *Schedule {
	s.CreateRule = v
	return s
}

// SetName sets the Name field's value.
func (s *Schedule) SetName(v string) *Schedule {
	s.Name = &v
	return s
}

// SetRetainRule sets the RetainRule field's value.
func (s *Schedule) SetRetainRule(v *RetainRule) *Schedule {
	s.RetainRule = v
	return s
}

// SetTagsToAdd sets the TagsToAdd field's value.
func (s *Schedule) SetTagsToAdd(v []*Tag) *Schedule {
	s.TagsToAdd = v
	return s
}

// Specifies a tag for a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type UpdateLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The configuration of the lifecycle policy.
	//
	// Target tags cannot be re-used across policies.
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`

	// The desired activation state of the lifecycle policy after creation.
	State *string `type:"string" enum:"SettablePolicyStateValues"`
}

// String returns the string representation
func (s UpdateLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLifecyclePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLifecyclePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLifecyclePolicyInput"}
	if s.PolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyDetails != nil {
		if err := s.PolicyDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateLifecyclePolicyInput) SetDescription(v string) *UpdateLifecyclePolicyInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateLifecyclePolicyInput) SetExecutionRoleArn(v string) *UpdateLifecyclePolicyInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetPolicyDetails sets the PolicyDetails field's value.
func (s *UpdateLifecyclePolicyInput) SetPolicyDetails(v *PolicyDetails) *UpdateLifecyclePolicyInput {
	s.PolicyDetails = v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *UpdateLifecyclePolicyInput) SetPolicyId(v string) *UpdateLifecyclePolicyInput {
	s.PolicyId = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateLifecyclePolicyInput) SetState(v string) *UpdateLifecyclePolicyInput {
	s.State = &v
	return s
}

type UpdateLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLifecyclePolicyOutput) GoString() string {
	return s.String()
}

const (
	// GettablePolicyStateValuesEnabled is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesEnabled = "ENABLED"

	// GettablePolicyStateValuesDisabled is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesDisabled = "DISABLED"

	// GettablePolicyStateValuesError is a GettablePolicyStateValues enum value
	GettablePolicyStateValuesError = "ERROR"
)

const (
	// IntervalUnitValuesHours is a IntervalUnitValues enum value
	IntervalUnitValuesHours = "HOURS"
)

const (
	// ResourceTypeValuesVolume is a ResourceTypeValues enum value
	ResourceTypeValuesVolume = "VOLUME"
)

const (
	// SettablePolicyStateValuesEnabled is a SettablePolicyStateValues enum value
	SettablePolicyStateValuesEnabled = "ENABLED"

	// SettablePolicyStateValuesDisabled is a SettablePolicyStateValues enum value
	SettablePolicyStateValuesDisabled = "DISABLED"
)
