// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchSuspendUser = "BatchSuspendUser"

// BatchSuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchSuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchSuspendUser for more information on using the BatchSuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchSuspendUserRequest method.
//    req, resp := client.BatchSuspendUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUserRequest(input *BatchSuspendUserInput) (req *request.Request, output *BatchSuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchSuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users?operation=suspend",
	}

	if input == nil {
		input = &BatchSuspendUserInput{}
	}

	output = &BatchSuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchSuspendUser API operation for Amazon Chime.
//
// Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime account.
// For more information about different account types, see Managing Your Amazon
// Chime Accounts (http://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Users suspended from a Team account are dissociated from the account, but
// they can continue to use Amazon Chime as free users. To remove the suspension
// from suspended Team account users, invite them to the Team account again.
// You can use the InviteUsers action to do so.
//
// Users suspended from an EnterpriseLWA account are immediately signed out
// of Amazon Chime and are no longer able to sign in. To remove the suspension
// from suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.
//
// To sign out users without suspending them, use the LogoutUser action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchSuspendUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUser(input *BatchSuspendUserInput) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	return out, req.Send()
}

// BatchSuspendUserWithContext is the same as BatchSuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchSuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchSuspendUserWithContext(ctx aws.Context, input *BatchSuspendUserInput, opts ...request.Option) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUnsuspendUser = "BatchUnsuspendUser"

// BatchUnsuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUnsuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUnsuspendUser for more information on using the BatchUnsuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUnsuspendUserRequest method.
//    req, resp := client.BatchUnsuspendUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUserRequest(input *BatchUnsuspendUserInput) (req *request.Request, output *BatchUnsuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchUnsuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users?operation=unsuspend",
	}

	if input == nil {
		input = &BatchUnsuspendUserInput{}
	}

	output = &BatchUnsuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUnsuspendUser API operation for Amazon Chime.
//
// Removes the suspension from up to 50 previously suspended users for the specified
// Amazon Chime EnterpriseLWA account. Only users on EnterpriseLWA accounts
// can be unsuspended using this action. For more information about different
// account types, see Managing Your Amazon Chime Accounts (http://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Previously suspended users who are unsuspended using this action are returned
// to Registered status. Users who are not previously suspended are ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUnsuspendUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUser(input *BatchUnsuspendUserInput) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	return out, req.Send()
}

// BatchUnsuspendUserWithContext is the same as BatchUnsuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUnsuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUnsuspendUserWithContext(ctx aws.Context, input *BatchUnsuspendUserInput, opts ...request.Option) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateUser = "BatchUpdateUser"

// BatchUpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateUser for more information on using the BatchUpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateUserRequest method.
//    req, resp := client.BatchUpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUserRequest(input *BatchUpdateUserInput) (req *request.Request, output *BatchUpdateUserOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users",
	}

	if input == nil {
		input = &BatchUpdateUserInput{}
	}

	output = &BatchUpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateUser API operation for Amazon Chime.
//
// Updates user details within the UpdateUserRequestItem object for up to 20
// users for the specified Amazon Chime account. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUser(input *BatchUpdateUserInput) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	return out, req.Send()
}

// BatchUpdateUserWithContext is the same as BatchUpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUpdateUserWithContext(ctx aws.Context, input *BatchUpdateUserInput, opts ...request.Option) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccount for more information on using the CreateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccountRequest method.
//    req, resp := client.CreateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccountRequest(input *CreateAccountInput) (req *request.Request, output *CreateAccountOutput) {
	op := &request.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	output = &CreateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccount API operation for Amazon Chime.
//
// Creates an Amazon Chime account under the administrator's AWS account. Only
// Team account types are currently supported for this action. For more information
// about different account types, see Managing Your Amazon Chime Accounts (http://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccount(input *CreateAccountInput) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	return out, req.Send()
}

// CreateAccountWithContext is the same as CreateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateAccountWithContext(ctx aws.Context, input *CreateAccountInput, opts ...request.Option) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccount = "DeleteAccount"

// DeleteAccountRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccount for more information on using the DeleteAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountRequest method.
//    req, resp := client.DeleteAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccountRequest(input *DeleteAccountInput) (req *request.Request, output *DeleteAccountOutput) {
	op := &request.Operation{
		Name:       opDeleteAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/console/accounts/{accountId}",
	}

	if input == nil {
		input = &DeleteAccountInput{}
	}

	output = &DeleteAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccount API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime account. You must suspend all users before
// deleting a Team account. You can use the BatchSuspendUser action to do so.
//
// For EnterpriseLWA and EnterpriseAD accounts, you must release the claimed
// domains for your Amazon Chime account before deletion. As soon as you release
// the domain, all users under that account are suspended.
//
// Deleted accounts appear in your Disabled accounts list for 90 days. To restore
// a deleted account from your Disabled accounts list, you must contact AWS
// Support.
//
// After 90 days, deleted accounts are permanently removed from your Disabled
// accounts list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeUnprocessableEntityException "UnprocessableEntityException"
//   The request was well-formed but was unable to be followed due to semantic
//   errors.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccount(input *DeleteAccountInput) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	return out, req.Send()
}

// DeleteAccountWithContext is the same as DeleteAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteAccountWithContext(ctx aws.Context, input *DeleteAccountInput, opts ...request.Option) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountRequest method.
//    req, resp := client.GetAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *GetAccountOutput) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/console/accounts/{accountId}",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &GetAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime account, such as account
// type and supported licenses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccount(input *GetAccountInput) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/console/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for Amazon Chime.
//
// Retrieves account settings for the specified Amazon Chime account ID, such
// as remote control and dial out settings. For more information about these
// settings, see Use the Policies Page (http://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "GET",
		HTTPPath:   "/console/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUser API operation for Amazon Chime.
//
// Retrieves details for the specified user ID, such as primary email address,
// license type, and personal meeting PIN.
//
// To retrieve user details with an email address instead of a user ID, use
// the ListUsers action, and then filter by email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteUsers = "InviteUsers"

// InviteUsersRequest generates a "aws/request.Request" representing the
// client's request for the InviteUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteUsers for more information on using the InviteUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteUsersRequest method.
//    req, resp := client.InviteUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsersRequest(input *InviteUsersInput) (req *request.Request, output *InviteUsersOutput) {
	op := &request.Operation{
		Name:       opInviteUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users?operation=add",
	}

	if input == nil {
		input = &InviteUsersInput{}
	}

	output = &InviteUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteUsers API operation for Amazon Chime.
//
// Sends email invites to as many as 50 users, inviting them to the specified
// Amazon Chime Team account. Only Team account types are currently supported
// for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation InviteUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsers(input *InviteUsersInput) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	return out, req.Send()
}

// InviteUsersWithContext is the same as InviteUsers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) InviteUsersWithContext(ctx aws.Context, input *InviteUsersInput, opts ...request.Option) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccounts for more information on using the ListAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountsRequest method.
//    req, resp := client.ListAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccountsRequest(input *ListAccountsInput) (req *request.Request, output *ListAccountsOutput) {
	op := &request.Operation{
		Name:       opListAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/console/accounts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	output = &ListAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccounts API operation for Amazon Chime.
//
// Lists the Amazon Chime accounts under the administrator's AWS account. You
// can filter accounts by account name prefix. To find out which Amazon Chime
// account a user belongs to, you can filter by the user's email address, which
// returns one account result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAccounts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccounts(input *ListAccountsInput) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	return out, req.Send()
}

// ListAccountsWithContext is the same as ListAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsWithContext(ctx aws.Context, input *ListAccountsInput, opts ...request.Option) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsPages iterates over the pages of a ListAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccounts operation.
//    pageNum := 0
//    err := client.ListAccountsPages(params,
//        func(page *ListAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListAccountsPages(input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool) error {
	return c.ListAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsPagesWithContext same as ListAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsPagesWithContext(ctx aws.Context, input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAccountsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/console/accounts/{accountId}/users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Chime.
//
// Lists the users that belong to the specified Amazon Chime account. You can
// specify an email address to list only the user that the email address belongs
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListUsersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opLogoutUser = "LogoutUser"

// LogoutUserRequest generates a "aws/request.Request" representing the
// client's request for the LogoutUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LogoutUser for more information on using the LogoutUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LogoutUserRequest method.
//    req, resp := client.LogoutUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUserRequest(input *LogoutUserInput) (req *request.Request, output *LogoutUserOutput) {
	op := &request.Operation{
		Name:       opLogoutUser,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users/{userId}?operation=logout",
	}

	if input == nil {
		input = &LogoutUserInput{}
	}

	output = &LogoutUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LogoutUser API operation for Amazon Chime.
//
// Logs out the specified user from all of the devices they are currently logged
// into.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation LogoutUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUser(input *LogoutUserInput) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	return out, req.Send()
}

// LogoutUserWithContext is the same as LogoutUser with the addition of
// the ability to pass a context and additional request options.
//
// See LogoutUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) LogoutUserWithContext(ctx aws.Context, input *LogoutUserInput, opts ...request.Option) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPersonalPIN = "ResetPersonalPIN"

// ResetPersonalPINRequest generates a "aws/request.Request" representing the
// client's request for the ResetPersonalPIN operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetPersonalPIN for more information on using the ResetPersonalPIN
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetPersonalPINRequest method.
//    req, resp := client.ResetPersonalPINRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPINRequest(input *ResetPersonalPINInput) (req *request.Request, output *ResetPersonalPINOutput) {
	op := &request.Operation{
		Name:       opResetPersonalPIN,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users/{userId}?operation=reset-personal-pin",
	}

	if input == nil {
		input = &ResetPersonalPINInput{}
	}

	output = &ResetPersonalPINOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetPersonalPIN API operation for Amazon Chime.
//
// Resets the personal meeting PIN for the specified user on an Amazon Chime
// account. Returns the User object with the updated personal meeting PIN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ResetPersonalPIN for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPIN(input *ResetPersonalPINInput) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	return out, req.Send()
}

// ResetPersonalPINWithContext is the same as ResetPersonalPIN with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPersonalPIN for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ResetPersonalPINWithContext(ctx aws.Context, input *ResetPersonalPINInput, opts ...request.Option) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccount = "UpdateAccount"

// UpdateAccountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccount for more information on using the UpdateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountRequest method.
//    req, resp := client.UpdateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccountRequest(input *UpdateAccountInput) (req *request.Request, output *UpdateAccountOutput) {
	op := &request.Operation{
		Name:       opUpdateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}",
	}

	if input == nil {
		input = &UpdateAccountInput{}
	}

	output = &UpdateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccount API operation for Amazon Chime.
//
// Updates account details for the specified Amazon Chime account. Currently,
// only account name updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccount(input *UpdateAccountInput) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	return out, req.Send()
}

// UpdateAccountWithContext is the same as UpdateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountWithContext(ctx aws.Context, input *UpdateAccountInput, opts ...request.Option) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountSettingsRequest method.
//    req, resp := client.UpdateAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/console/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for Amazon Chime.
//
// Updates the settings for the specified Amazon Chime account. You can update
// settings for remote control of shared screens, or for the dial-out option.
// For more information about these settings, see Use the Policies Page (http://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeConflictException "ConflictException"
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/console/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon Chime.
//
// Updates user details for a specified user ID. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedClientException "UnauthorizedClientException"
//   The client is not currently authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more of the resources in the request does not exist in the system.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported region.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The input parameters don't match the service's restrictions.
//
//   * ErrCodeThrottledClientException "ThrottledClientException"
//   The client exceeded its request rate limit.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The service is currently unavailable.
//
//   * ErrCodeServiceFailureException "ServiceFailureException"
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The Amazon Chime account details. An AWS account can have multiple Amazon
// Chime accounts.
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The Amazon Chime account type. For more information about different account
	// types, see Managing Your Amazon Chime Accounts (http://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
	// in the Amazon Chime Administration Guide.
	AccountType *string `type:"string" enum:"AccountType"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The default license for the Amazon Chime account.
	DefaultLicense *string `type:"string" enum:"License"`

	// The Amazon Chime account name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []*string `type:"list"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetAccountType sets the AccountType field's value.
func (s *Account) SetAccountType(v string) *Account {
	s.AccountType = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Account) SetAwsAccountId(v string) *Account {
	s.AwsAccountId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Account) SetCreatedTimestamp(v time.Time) *Account {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultLicense sets the DefaultLicense field's value.
func (s *Account) SetDefaultLicense(v string) *Account {
	s.DefaultLicense = &v
	return s
}

// SetName sets the Name field's value.
func (s *Account) SetName(v string) *Account {
	s.Name = &v
	return s
}

// SetSupportedLicenses sets the SupportedLicenses field's value.
func (s *Account) SetSupportedLicenses(v []*string) *Account {
	s.SupportedLicenses = v
	return s
}

// Settings related to the Amazon Chime account. This includes settings that
// start or stop remote control of shared screens, or start or stop the dial-out
// option in the Amazon Chime web application. For more information about these
// settings, see Use the Policies Page (http://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool `type:"boolean"`

	// Setting that allows meeting participants to choose the Call me at a phone
	// number option. For more information, see Join a Meeting without the Amazon
	// Chime App (http://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
	EnableDialOut *bool `type:"boolean"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetDisableRemoteControl sets the DisableRemoteControl field's value.
func (s *AccountSettings) SetDisableRemoteControl(v bool) *AccountSettings {
	s.DisableRemoteControl = &v
	return s
}

// SetEnableDialOut sets the EnableDialOut field's value.
func (s *AccountSettings) SetEnableDialOut(v bool) *AccountSettings {
	s.EnableDialOut = &v
	return s
}

type BatchSuspendUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs to suspend.
	//
	// UserIdList is a required field
	UserIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchSuspendUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSuspendUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchSuspendUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchSuspendUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchSuspendUserInput) SetAccountId(v string) *BatchSuspendUserInput {
	s.AccountId = &v
	return s
}

// SetUserIdList sets the UserIdList field's value.
func (s *BatchSuspendUserInput) SetUserIdList(v []*string) *BatchSuspendUserInput {
	s.UserIdList = v
	return s
}

type BatchSuspendUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchSuspendUser action fails for one or more of the user IDs in the
	// request, a list of the user IDs is returned, along with error codes and error
	// messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchSuspendUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSuspendUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchSuspendUserOutput) SetUserErrors(v []*UserError) *BatchSuspendUserOutput {
	s.UserErrors = v
	return s
}

type BatchUnsuspendUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs to unsuspend.
	//
	// UserIdList is a required field
	UserIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUnsuspendUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUnsuspendUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUnsuspendUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUnsuspendUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchUnsuspendUserInput) SetAccountId(v string) *BatchUnsuspendUserInput {
	s.AccountId = &v
	return s
}

// SetUserIdList sets the UserIdList field's value.
func (s *BatchUnsuspendUserInput) SetUserIdList(v []*string) *BatchUnsuspendUserInput {
	s.UserIdList = v
	return s
}

type BatchUnsuspendUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchUnsuspendUser action fails for one or more of the user IDs in
	// the request, a list of the user IDs is returned, along with error codes and
	// error messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchUnsuspendUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUnsuspendUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchUnsuspendUserOutput) SetUserErrors(v []*UserError) *BatchUnsuspendUserOutput {
	s.UserErrors = v
	return s
}

type BatchUpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs and details to update.
	//
	// UpdateUserRequestItems is a required field
	UpdateUserRequestItems []*UpdateUserRequestItem `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UpdateUserRequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateUserRequestItems"))
	}
	if s.UpdateUserRequestItems != nil {
		for i, v := range s.UpdateUserRequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateUserRequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchUpdateUserInput) SetAccountId(v string) *BatchUpdateUserInput {
	s.AccountId = &v
	return s
}

// SetUpdateUserRequestItems sets the UpdateUserRequestItems field's value.
func (s *BatchUpdateUserInput) SetUpdateUserRequestItems(v []*UpdateUserRequestItem) *BatchUpdateUserInput {
	s.UpdateUserRequestItems = v
	return s
}

type BatchUpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchUpdateUser action fails for one or more of the user IDs in the
	// request, a list of the user IDs is returned, along with error codes and error
	// messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchUpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchUpdateUserOutput) SetUserErrors(v []*UserError) *BatchUpdateUserOutput {
	s.UserErrors = v
	return s
}

type CreateAccountInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateAccountInput) SetName(v string) *CreateAccountInput {
	s.Name = &v
	return s
}

type CreateAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s CreateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *CreateAccountOutput) SetAccount(v *Account) *CreateAccountOutput {
	s.Account = v
	return s
}

type DeleteAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccountInput) SetAccountId(v string) *DeleteAccountInput {
	s.AccountId = &v
	return s
}

type DeleteAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountOutput) GoString() string {
	return s.String()
}

type GetAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccountInput) SetAccountId(v string) *GetAccountInput {
	s.AccountId = &v
	return s
}

type GetAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s GetAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *GetAccountOutput) SetAccount(v *Account) *GetAccountOutput {
	s.Account = v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccountSettingsInput) SetAccountId(v string) *GetAccountSettingsInput {
	s.AccountId = &v
	return s
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account settings.
	AccountSettings *AccountSettings `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetUserInput) SetAccountId(v string) *GetUserInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserInput) SetUserId(v string) *GetUserInput {
	s.UserId = &v
	return s
}

type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// The user details.
	User *User `type:"structure"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *GetUserOutput) SetUser(v *User) *GetUserOutput {
	s.User = v
	return s
}

// Invitation object returned after emailing users to invite them to join the
// Amazon Chime Team account.
type Invite struct {
	_ struct{} `type:"structure"`

	// The email address to which the invite is sent.
	EmailAddress *string `type:"string"`

	// The status of the invite email.
	EmailStatus *string `type:"string" enum:"EmailStatus"`

	// The invite ID.
	InviteId *string `type:"string"`

	// The status of the invite.
	Status *string `type:"string" enum:"InviteStatus"`
}

// String returns the string representation
func (s Invite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invite) GoString() string {
	return s.String()
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Invite) SetEmailAddress(v string) *Invite {
	s.EmailAddress = &v
	return s
}

// SetEmailStatus sets the EmailStatus field's value.
func (s *Invite) SetEmailStatus(v string) *Invite {
	s.EmailStatus = &v
	return s
}

// SetInviteId sets the InviteId field's value.
func (s *Invite) SetInviteId(v string) *Invite {
	s.InviteId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Invite) SetStatus(v string) *Invite {
	s.Status = &v
	return s
}

type InviteUsersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user email addresses to which to send the invite.
	//
	// UserEmailList is a required field
	UserEmailList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s InviteUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteUsersInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserEmailList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserEmailList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InviteUsersInput) SetAccountId(v string) *InviteUsersInput {
	s.AccountId = &v
	return s
}

// SetUserEmailList sets the UserEmailList field's value.
func (s *InviteUsersInput) SetUserEmailList(v []*string) *InviteUsersInput {
	s.UserEmailList = v
	return s
}

type InviteUsersOutput struct {
	_ struct{} `type:"structure"`

	// The invite details.
	Invites []*Invite `type:"list"`
}

// String returns the string representation
func (s InviteUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteUsersOutput) GoString() string {
	return s.String()
}

// SetInvites sets the Invites field's value.
func (s *InviteUsersOutput) SetInvites(v []*Invite) *InviteUsersOutput {
	s.Invites = v
	return s
}

type ListAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. Defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Amazon Chime account name prefix with which to filter results.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// User email address with which to filter results.
	UserEmail *string `location:"querystring" locationName:"user-email" type:"string"`
}

// String returns the string representation
func (s ListAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsInput) SetMaxResults(v int64) *ListAccountsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAccountsInput) SetName(v string) *ListAccountsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsInput) SetNextToken(v string) *ListAccountsInput {
	s.NextToken = &v
	return s
}

// SetUserEmail sets the UserEmail field's value.
func (s *ListAccountsInput) SetUserEmail(v string) *ListAccountsInput {
	s.UserEmail = &v
	return s
}

type ListAccountsOutput struct {
	_ struct{} `type:"structure"`

	// List of Amazon Chime accounts and account details.
	Accounts []*Account `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsOutput) SetAccounts(v []*Account) *ListAccountsOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsOutput) SetNextToken(v string) *ListAccountsOutput {
	s.NextToken = &v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call. Defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// Optional. The user email address used to filter results. Maximum 1.
	UserEmail *string `location:"querystring" locationName:"user-email" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListUsersInput) SetAccountId(v string) *ListUsersInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetUserEmail sets the UserEmail field's value.
func (s *ListUsersInput) SetUserEmail(v string) *ListUsersInput {
	s.UserEmail = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// List of users and user details.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

type LogoutUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s LogoutUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogoutUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogoutUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogoutUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *LogoutUserInput) SetAccountId(v string) *LogoutUserInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *LogoutUserInput) SetUserId(v string) *LogoutUserInput {
	s.UserId = &v
	return s
}

type LogoutUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LogoutUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogoutUserOutput) GoString() string {
	return s.String()
}

type ResetPersonalPINInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetPersonalPINInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPersonalPINInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPersonalPINInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetPersonalPINInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ResetPersonalPINInput) SetAccountId(v string) *ResetPersonalPINInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResetPersonalPINInput) SetUserId(v string) *ResetPersonalPINInput {
	s.UserId = &v
	return s
}

type ResetPersonalPINOutput struct {
	_ struct{} `type:"structure"`

	// The user details and new personal meeting PIN.
	User *User `type:"structure"`
}

// String returns the string representation
func (s ResetPersonalPINOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPersonalPINOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *ResetPersonalPINOutput) SetUser(v *User) *ResetPersonalPINOutput {
	s.User = v
	return s
}

type UpdateAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The new name for the specified Amazon Chime account.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateAccountInput) SetAccountId(v string) *UpdateAccountInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAccountInput) SetName(v string) *UpdateAccountInput {
	s.Name = &v
	return s
}

type UpdateAccountOutput struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *UpdateAccountOutput) SetAccount(v *Account) *UpdateAccountOutput {
	s.Account = v
	return s
}

type UpdateAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The Amazon Chime account settings to update.
	//
	// AccountSettings is a required field
	AccountSettings *AccountSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountSettings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateAccountSettingsInput) SetAccountId(v string) *UpdateAccountSettingsInput {
	s.AccountId = &v
	return s
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *UpdateAccountSettingsInput) SetAccountSettings(v *AccountSettings) *UpdateAccountSettingsInput {
	s.AccountSettings = v
	return s
}

type UpdateAccountSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountSettingsOutput) GoString() string {
	return s.String()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user license type to update. This must be a supported license type for
	// the Amazon Chime account that the user belongs to.
	LicenseType *string `type:"string" enum:"License"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateUserInput) SetAccountId(v string) *UpdateUserInput {
	s.AccountId = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateUserInput) SetLicenseType(v string) *UpdateUserInput {
	s.LicenseType = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The updated user details.
	User *User `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// The user ID and user fields to update, used with the BatchUpdateUser action.
type UpdateUserRequestItem struct {
	_ struct{} `type:"structure"`

	// The user license type.
	LicenseType *string `type:"string" enum:"License"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserRequestItem"}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateUserRequestItem) SetLicenseType(v string) *UpdateUserRequestItem {
	s.LicenseType = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserRequestItem) SetUserId(v string) *UpdateUserRequestItem {
	s.UserId = &v
	return s
}

// The user on the Amazon Chime account.
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The display name of the user.
	DisplayName *string `type:"string"`

	// Date and time when the user is invited to the Amazon Chime account, in ISO
	// 8601 format.
	InvitedOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The license type for the user.
	LicenseType *string `type:"string" enum:"License"`

	// The user's personal meeting PIN.
	PersonalPIN *string `type:"string"`

	// The primary email address of the user.
	PrimaryEmail *string `type:"string"`

	// Date and time when the user is registered, in ISO 8601 format.
	RegisteredOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`

	// The user invite status.
	UserInvitationStatus *string `type:"string" enum:"InviteStatus"`

	// The user registration status.
	UserRegistrationStatus *string `type:"string" enum:"RegistrationStatus"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *User) SetAccountId(v string) *User {
	s.AccountId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *User) SetDisplayName(v string) *User {
	s.DisplayName = &v
	return s
}

// SetInvitedOn sets the InvitedOn field's value.
func (s *User) SetInvitedOn(v time.Time) *User {
	s.InvitedOn = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *User) SetLicenseType(v string) *User {
	s.LicenseType = &v
	return s
}

// SetPersonalPIN sets the PersonalPIN field's value.
func (s *User) SetPersonalPIN(v string) *User {
	s.PersonalPIN = &v
	return s
}

// SetPrimaryEmail sets the PrimaryEmail field's value.
func (s *User) SetPrimaryEmail(v string) *User {
	s.PrimaryEmail = &v
	return s
}

// SetRegisteredOn sets the RegisteredOn field's value.
func (s *User) SetRegisteredOn(v time.Time) *User {
	s.RegisteredOn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *User) SetUserId(v string) *User {
	s.UserId = &v
	return s
}

// SetUserInvitationStatus sets the UserInvitationStatus field's value.
func (s *User) SetUserInvitationStatus(v string) *User {
	s.UserInvitationStatus = &v
	return s
}

// SetUserRegistrationStatus sets the UserRegistrationStatus field's value.
func (s *User) SetUserRegistrationStatus(v string) *User {
	s.UserRegistrationStatus = &v
	return s
}

// The list of errors returned when errors are encountered during the BatchSuspendUser,
// BatchUnsuspendUser, or BatchUpdateUser actions. This includes user IDs, error
// codes, and error messages.
type UserError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The user ID for which the action failed.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s UserError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UserError) SetErrorCode(v string) *UserError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UserError) SetErrorMessage(v string) *UserError {
	s.ErrorMessage = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserError) SetUserId(v string) *UserError {
	s.UserId = &v
	return s
}

const (
	// AccountTypeTeam is a AccountType enum value
	AccountTypeTeam = "Team"

	// AccountTypeEnterpriseDirectory is a AccountType enum value
	AccountTypeEnterpriseDirectory = "EnterpriseDirectory"

	// AccountTypeEnterpriseLwa is a AccountType enum value
	AccountTypeEnterpriseLwa = "EnterpriseLWA"

	// AccountTypeEnterpriseOidc is a AccountType enum value
	AccountTypeEnterpriseOidc = "EnterpriseOIDC"
)

const (
	// EmailStatusNotSent is a EmailStatus enum value
	EmailStatusNotSent = "NotSent"

	// EmailStatusSent is a EmailStatus enum value
	EmailStatusSent = "Sent"

	// EmailStatusFailed is a EmailStatus enum value
	EmailStatusFailed = "Failed"
)

const (
	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"
)

const (
	// InviteStatusPending is a InviteStatus enum value
	InviteStatusPending = "Pending"

	// InviteStatusAccepted is a InviteStatus enum value
	InviteStatusAccepted = "Accepted"

	// InviteStatusFailed is a InviteStatus enum value
	InviteStatusFailed = "Failed"
)

const (
	// LicenseBasic is a License enum value
	LicenseBasic = "Basic"

	// LicensePlus is a License enum value
	LicensePlus = "Plus"

	// LicensePro is a License enum value
	LicensePro = "Pro"

	// LicenseProTrial is a License enum value
	LicenseProTrial = "ProTrial"
)

const (
	// RegistrationStatusUnregistered is a RegistrationStatus enum value
	RegistrationStatusUnregistered = "Unregistered"

	// RegistrationStatusRegistered is a RegistrationStatus enum value
	RegistrationStatusRegistered = "Registered"

	// RegistrationStatusSuspended is a RegistrationStatus enum value
	RegistrationStatusSuspended = "Suspended"
)
