package softwareplan

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// HybridUseBenefitClient is the azure software plans let users create and manage licenses for various software used in
// Azure.
type HybridUseBenefitClient struct {
	BaseClient
}

// NewHybridUseBenefitClient creates an instance of the HybridUseBenefitClient client.
func NewHybridUseBenefitClient(subscriptionID string) HybridUseBenefitClient {
	return NewHybridUseBenefitClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewHybridUseBenefitClientWithBaseURI creates an instance of the HybridUseBenefitClient client.
func NewHybridUseBenefitClientWithBaseURI(baseURI string, subscriptionID string) HybridUseBenefitClient {
	return HybridUseBenefitClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create create a new hybrid use benefit under a given scope
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// planID - this is a unique identifier for a plan. Should be a guid.
// body - request body for creating a hybrid use benefit
func (client HybridUseBenefitClient) Create(ctx context.Context, scope string, planID string, body HybridUseBenefitModel) (result HybridUseBenefitModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.Sku", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("softwareplan.HybridUseBenefitClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, scope, planID, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client HybridUseBenefitClient) CreatePreparer(ctx context.Context, scope string, planID string, body HybridUseBenefitModel) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"planId": autorest.Encode("path", planID),
		"scope":  autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.Etag = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitClient) CreateResponder(resp *http.Response) (result HybridUseBenefitModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a given plan ID
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// planID - this is a unique identifier for a plan. Should be a guid.
func (client HybridUseBenefitClient) Delete(ctx context.Context, scope string, planID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, scope, planID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client HybridUseBenefitClient) DeletePreparer(ctx context.Context, scope string, planID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"planId": autorest.Encode("path", planID),
		"scope":  autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a given plan ID
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// planID - this is a unique identifier for a plan. Should be a guid.
func (client HybridUseBenefitClient) Get(ctx context.Context, scope string, planID string) (result HybridUseBenefitModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, planID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client HybridUseBenefitClient) GetPreparer(ctx context.Context, scope string, planID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"planId": autorest.Encode("path", planID),
		"scope":  autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitClient) GetResponder(resp *http.Response) (result HybridUseBenefitModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all hybrid use benefits associated with an ARM resource.
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// filter - supports applying filter on the type of SKU
func (client HybridUseBenefitClient) List(ctx context.Context, scope string, filter string) (result HybridUseBenefitListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.List")
		defer func() {
			sc := -1
			if result.hublr.Response.Response != nil {
				sc = result.hublr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.hublr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "List", resp, "Failure sending request")
		return
	}

	result.hublr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client HybridUseBenefitClient) ListPreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitClient) ListResponder(resp *http.Response) (result HybridUseBenefitListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client HybridUseBenefitClient) listNextResults(ctx context.Context, lastResults HybridUseBenefitListResult) (result HybridUseBenefitListResult, err error) {
	req, err := lastResults.hybridUseBenefitListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client HybridUseBenefitClient) ListComplete(ctx context.Context, scope string, filter string) (result HybridUseBenefitListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, scope, filter)
	return
}

// Update updates an existing hybrid use benefit
// Parameters:
// scope - the scope at which the operation is performed. This is limited to Microsoft.Compute/virtualMachines
// and Microsoft.Compute/hostGroups/hosts for now
// planID - this is a unique identifier for a plan. Should be a guid.
// body - request body for creating a hybrid use benefit
func (client HybridUseBenefitClient) Update(ctx context.Context, scope string, planID string, body HybridUseBenefitModel) (result HybridUseBenefitModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridUseBenefitClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, scope, planID, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "softwareplan.HybridUseBenefitClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client HybridUseBenefitClient) UpdatePreparer(ctx context.Context, scope string, planID string, body HybridUseBenefitModel) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"planId": autorest.Encode("path", planID),
		"scope":  autorest.Encode("path", scope),
	}

	const APIVersion = "2019-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.Etag = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.SoftwarePlan/hybridUseBenefits/{planId}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client HybridUseBenefitClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client HybridUseBenefitClient) UpdateResponder(resp *http.Response) (result HybridUseBenefitModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
