// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/instance.proto

package admin

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Possible states of an instance.
type Instance_State int32

const (
	// The state of the instance could not be determined.
	Instance_STATE_NOT_KNOWN Instance_State = 0
	// The instance has been successfully created and can serve requests
	// to its tables.
	Instance_READY Instance_State = 1
	// The instance is currently being created, and may be destroyed
	// if the creation process encounters an error.
	Instance_CREATING Instance_State = 2
)

var Instance_State_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "READY",
	2: "CREATING",
}
var Instance_State_value = map[string]int32{
	"STATE_NOT_KNOWN": 0,
	"READY":           1,
	"CREATING":        2,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

// The type of the instance.
type Instance_Type int32

const (
	// The type of the instance is unspecified. If set when creating an
	// instance, a `PRODUCTION` instance will be created. If set when updating
	// an instance, the type will be left unchanged.
	Instance_TYPE_UNSPECIFIED Instance_Type = 0
	// An instance meant for production use. `serve_nodes` must be set
	// on the cluster.
	Instance_PRODUCTION Instance_Type = 1
	// The instance is meant for development and testing purposes only; it has
	// no performance or uptime guarantees and is not covered by SLA.
	// After a development instance is created, it can be upgraded by
	// updating the instance to type `PRODUCTION`. An instance created
	// as a production instance cannot be changed to a development instance.
	// When creating a development instance, `serve_nodes` on the cluster must
	// not be set.
	Instance_DEVELOPMENT Instance_Type = 2
)

var Instance_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "PRODUCTION",
	2: "DEVELOPMENT",
}
var Instance_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"PRODUCTION":       1,
	"DEVELOPMENT":      2,
}

func (x Instance_Type) String() string {
	return proto.EnumName(Instance_Type_name, int32(x))
}
func (Instance_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 1} }

// Possible states of a cluster.
type Cluster_State int32

const (
	// The state of the cluster could not be determined.
	Cluster_STATE_NOT_KNOWN Cluster_State = 0
	// The cluster has been successfully created and is ready to serve requests.
	Cluster_READY Cluster_State = 1
	// The cluster is currently being created, and may be destroyed
	// if the creation process encounters an error.
	// A cluster may not be able to serve requests while being created.
	Cluster_CREATING Cluster_State = 2
	// The cluster is currently being resized, and may revert to its previous
	// node count if the process encounters an error.
	// A cluster is still capable of serving requests while being resized,
	// but may exhibit performance as if its number of allocated nodes is
	// between the starting and requested states.
	Cluster_RESIZING Cluster_State = 3
	// The cluster has no backing nodes. The data (tables) still
	// exist, but no operations can be performed on the cluster.
	Cluster_DISABLED Cluster_State = 4
)

var Cluster_State_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "READY",
	2: "CREATING",
	3: "RESIZING",
	4: "DISABLED",
}
var Cluster_State_value = map[string]int32{
	"STATE_NOT_KNOWN": 0,
	"READY":           1,
	"CREATING":        2,
	"RESIZING":        3,
	"DISABLED":        4,
}

func (x Cluster_State) String() string {
	return proto.EnumName(Cluster_State_name, int32(x))
}
func (Cluster_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{1, 0} }

// A collection of Bigtable [Tables][google.bigtable.admin.v2.Table] and
// the resources that serve them.
// All tables in an instance are served from a single
// [Cluster][google.bigtable.admin.v2.Cluster].
type Instance struct {
	// (`OutputOnly`)
	// The unique name of the instance. Values are of the form
	// `projects/<project>/instances/[a-z][a-z0-9\\-]+[a-z0-9]`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The descriptive name for this instance as it appears in UIs.
	// Can be changed at any time, but should be kept globally unique
	// to avoid confusion.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// (`OutputOnly`)
	// The current state of the instance.
	State Instance_State `protobuf:"varint,3,opt,name=state,enum=google.bigtable.admin.v2.Instance_State" json:"state,omitempty"`
	// The type of the instance. Defaults to `PRODUCTION`.
	Type Instance_Type `protobuf:"varint,4,opt,name=type,enum=google.bigtable.admin.v2.Instance_Type" json:"type,omitempty"`
}

func (m *Instance) Reset()                    { *m = Instance{} }
func (m *Instance) String() string            { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()               {}
func (*Instance) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_NOT_KNOWN
}

func (m *Instance) GetType() Instance_Type {
	if m != nil {
		return m.Type
	}
	return Instance_TYPE_UNSPECIFIED
}

// A resizable group of nodes in a particular cloud location, capable
// of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
// [Instance][google.bigtable.admin.v2.Instance].
type Cluster struct {
	// (`OutputOnly`)
	// The unique name of the cluster. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/[a-z][-a-z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// (`CreationOnly`)
	// The location where this cluster's nodes and storage reside. For best
	// performance, clients should be located as close as possible to this cluster.
	// Currently only zones are supported, so values should be of the form
	// `projects/<project>/locations/<zone>`.
	Location string `protobuf:"bytes,2,opt,name=location" json:"location,omitempty"`
	// (`OutputOnly`)
	// The current state of the cluster.
	State Cluster_State `protobuf:"varint,3,opt,name=state,enum=google.bigtable.admin.v2.Cluster_State" json:"state,omitempty"`
	// The number of nodes allocated to this cluster. More nodes enable higher
	// throughput and more consistent performance.
	ServeNodes int32 `protobuf:"varint,4,opt,name=serve_nodes,json=serveNodes" json:"serve_nodes,omitempty"`
	// (`CreationOnly`)
	// The type of storage used by this cluster to serve its
	// parent instance's tables, unless explicitly overridden.
	DefaultStorageType StorageType `protobuf:"varint,5,opt,name=default_storage_type,json=defaultStorageType,enum=google.bigtable.admin.v2.StorageType" json:"default_storage_type,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Cluster) GetState() Cluster_State {
	if m != nil {
		return m.State
	}
	return Cluster_STATE_NOT_KNOWN
}

func (m *Cluster) GetServeNodes() int32 {
	if m != nil {
		return m.ServeNodes
	}
	return 0
}

func (m *Cluster) GetDefaultStorageType() StorageType {
	if m != nil {
		return m.DefaultStorageType
	}
	return StorageType_STORAGE_TYPE_UNSPECIFIED
}

func init() {
	proto.RegisterType((*Instance)(nil), "google.bigtable.admin.v2.Instance")
	proto.RegisterType((*Cluster)(nil), "google.bigtable.admin.v2.Cluster")
	proto.RegisterEnum("google.bigtable.admin.v2.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Instance_Type", Instance_Type_name, Instance_Type_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Cluster_State", Cluster_State_name, Cluster_State_value)
}

func init() { proto.RegisterFile("google/bigtable/admin/v2/instance.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 477 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x92, 0x51, 0x6b, 0xdb, 0x30,
	0x10, 0xc7, 0xeb, 0xd4, 0xde, 0xd2, 0x4b, 0xd7, 0x1a, 0xad, 0x0f, 0x21, 0x14, 0xd6, 0x19, 0x4a,
	0xf3, 0x64, 0x43, 0xc6, 0x9e, 0x4a, 0x06, 0x49, 0xac, 0x0d, 0xb3, 0xce, 0xf6, 0x6c, 0x77, 0xa5,
	0x7d, 0x31, 0x4a, 0xa2, 0x19, 0x83, 0x2d, 0x19, 0x4b, 0x0d, 0xe4, 0x7b, 0xed, 0x2b, 0xec, 0x7b,
	0x0d, 0xcb, 0xce, 0x58, 0xd9, 0x32, 0xc6, 0xde, 0x74, 0x77, 0xbf, 0xbb, 0xbf, 0xf4, 0xd7, 0xc1,
	0x55, 0xc6, 0x79, 0x56, 0x50, 0x67, 0x99, 0x67, 0x92, 0x2c, 0x0b, 0xea, 0x90, 0x75, 0x99, 0x33,
	0x67, 0x33, 0x71, 0x72, 0x26, 0x24, 0x61, 0x2b, 0x6a, 0x57, 0x35, 0x97, 0x1c, 0x0d, 0x5b, 0xd0,
	0xde, 0x81, 0xb6, 0x02, 0xed, 0xcd, 0x64, 0x74, 0xde, 0x8d, 0x20, 0x55, 0xee, 0x10, 0xc6, 0xb8,
	0x24, 0x32, 0xe7, 0x4c, 0xb4, 0x7d, 0xa3, 0xcb, 0xbd, 0x02, 0x2b, 0x5e, 0x96, 0x9c, 0xb5, 0x98,
	0xf5, 0xad, 0x07, 0x7d, 0xaf, 0x53, 0x44, 0x08, 0x74, 0x46, 0x4a, 0x3a, 0xd4, 0x2e, 0xb4, 0xf1,
	0x51, 0xa4, 0xce, 0xe8, 0x35, 0x1c, 0xaf, 0x73, 0x51, 0x15, 0x64, 0x9b, 0xaa, 0x5a, 0x4f, 0xd5,
	0x06, 0x5d, 0xce, 0x6f, 0x90, 0x77, 0x60, 0x08, 0x49, 0x24, 0x1d, 0x1e, 0x5e, 0x68, 0xe3, 0x93,
	0xc9, 0xd8, 0xde, 0x77, 0x65, 0x7b, 0xa7, 0x64, 0xc7, 0x0d, 0x1f, 0xb5, 0x6d, 0xe8, 0x1a, 0x74,
	0xb9, 0xad, 0xe8, 0x50, 0x57, 0xed, 0x57, 0xff, 0xd0, 0x9e, 0x6c, 0x2b, 0x1a, 0xa9, 0x26, 0xeb,
	0x2d, 0x18, 0x6a, 0x18, 0x7a, 0x09, 0xa7, 0x71, 0x32, 0x4b, 0x70, 0xea, 0x07, 0x49, 0xfa, 0xd1,
	0x0f, 0xee, 0x7c, 0xf3, 0x00, 0x1d, 0x81, 0x11, 0xe1, 0x99, 0x7b, 0x6f, 0x6a, 0xe8, 0x18, 0xfa,
	0x8b, 0x08, 0xcf, 0x12, 0xcf, 0xff, 0x60, 0xf6, 0xac, 0x29, 0xe8, 0xcd, 0x10, 0x74, 0x06, 0x66,
	0x72, 0x1f, 0xe2, 0xf4, 0xd6, 0x8f, 0x43, 0xbc, 0xf0, 0xde, 0x7b, 0xd8, 0x35, 0x0f, 0xd0, 0x09,
	0x40, 0x18, 0x05, 0xee, 0xed, 0x22, 0xf1, 0x02, 0xdf, 0xd4, 0xd0, 0x29, 0x0c, 0x5c, 0xfc, 0x05,
	0xdf, 0x04, 0xe1, 0x27, 0xec, 0x27, 0x66, 0xcf, 0xfa, 0xde, 0x83, 0xe7, 0x8b, 0xe2, 0x51, 0x48,
	0x5a, 0xff, 0xd1, 0xb5, 0x11, 0xf4, 0x0b, 0xbe, 0x52, 0x1f, 0xd2, 0x39, 0xf6, 0x33, 0x46, 0xd3,
	0xa7, 0x76, 0xfd, 0xe5, 0xbd, 0x9d, 0xc2, 0x53, 0xb7, 0x5e, 0xc1, 0x40, 0xd0, 0x7a, 0x43, 0x53,
	0xc6, 0xd7, 0x54, 0x28, 0xd3, 0x8c, 0x08, 0x54, 0xca, 0x6f, 0x32, 0xe8, 0x0e, 0xce, 0xd6, 0xf4,
	0x2b, 0x79, 0x2c, 0x64, 0x2a, 0x24, 0xaf, 0x49, 0x46, 0x53, 0x65, 0xaf, 0xa1, 0xe4, 0x2e, 0xf7,
	0xcb, 0xc5, 0x2d, 0xad, 0xcc, 0x45, 0xdd, 0x88, 0x5f, 0x72, 0xd6, 0xe7, 0xff, 0xb2, 0xba, 0x89,
	0x22, 0x1c, 0x7b, 0x0f, 0x4d, 0x74, 0xd8, 0x44, 0xae, 0x17, 0xcf, 0xe6, 0x37, 0xd8, 0x35, 0xf5,
	0x39, 0x83, 0xf3, 0x15, 0x2f, 0xf7, 0x5e, 0x69, 0xfe, 0x62, 0xf7, 0xe5, 0x61, 0xb3, 0xad, 0xa1,
	0xf6, 0x30, 0xed, 0xd0, 0x8c, 0x17, 0x84, 0x65, 0x36, 0xaf, 0x33, 0x27, 0xa3, 0x4c, 0xed, 0xb2,
	0xd3, 0x96, 0x48, 0x95, 0x8b, 0xdf, 0xb7, 0xfe, 0x5a, 0x1d, 0x96, 0xcf, 0x14, 0xf9, 0xe6, 0x47,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xce, 0x3d, 0x06, 0xe4, 0x7f, 0x03, 0x00, 0x00,
}
