// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

/*
Package cloudbuild is a generated protocol buffer package.

It is generated from these files:
	google/devtools/cloudbuild/v1/cloudbuild.proto

It has these top-level messages:
	StorageSource
	RepoSource
	Source
	BuiltImage
	BuildStep
	Results
	Build
	BuildOperationMetadata
	SourceProvenance
	FileHashes
	Hash
	CreateBuildRequest
	GetBuildRequest
	ListBuildsRequest
	ListBuildsResponse
	CancelBuildRequest
	BuildTrigger
	CreateBuildTriggerRequest
	GetBuildTriggerRequest
	ListBuildTriggersRequest
	ListBuildTriggersResponse
	DeleteBuildTriggerRequest
	UpdateBuildTriggerRequest
	BuildOptions
*/
package cloudbuild

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf4 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible status of a build.
type Build_Status int32

const (
	// Status of the build is unknown.
	Build_STATUS_UNKNOWN Build_Status = 0
	// Build is queued; work has not yet begun.
	Build_QUEUED Build_Status = 1
	// Build is being executed.
	Build_WORKING Build_Status = 2
	// Build finished successfully.
	Build_SUCCESS Build_Status = 3
	// Build failed to complete successfully.
	Build_FAILURE Build_Status = 4
	// Build failed due to an internal cause.
	Build_INTERNAL_ERROR Build_Status = 5
	// Build took longer than was allowed.
	Build_TIMEOUT Build_Status = 6
	// Build was canceled by a user.
	Build_CANCELLED Build_Status = 7
)

var Build_Status_name = map[int32]string{
	0: "STATUS_UNKNOWN",
	1: "QUEUED",
	2: "WORKING",
	3: "SUCCESS",
	4: "FAILURE",
	5: "INTERNAL_ERROR",
	6: "TIMEOUT",
	7: "CANCELLED",
}
var Build_Status_value = map[string]int32{
	"STATUS_UNKNOWN": 0,
	"QUEUED":         1,
	"WORKING":        2,
	"SUCCESS":        3,
	"FAILURE":        4,
	"INTERNAL_ERROR": 5,
	"TIMEOUT":        6,
	"CANCELLED":      7,
}

func (x Build_Status) String() string {
	return proto.EnumName(Build_Status_name, int32(x))
}
func (Build_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

// Specifies the hash algorithm, if any.
type Hash_HashType int32

const (
	// No hash requested.
	Hash_NONE Hash_HashType = 0
	// Use a sha256 hash.
	Hash_SHA256 Hash_HashType = 1
)

var Hash_HashType_name = map[int32]string{
	0: "NONE",
	1: "SHA256",
}
var Hash_HashType_value = map[string]int32{
	"NONE":   0,
	"SHA256": 1,
}

func (x Hash_HashType) String() string {
	return proto.EnumName(Hash_HashType_name, int32(x))
}
func (Hash_HashType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 0} }

// Specifies the manner in which the build should be verified, if at all.
type BuildOptions_VerifyOption int32

const (
	// Not a verifiable build. (default)
	BuildOptions_NOT_VERIFIED BuildOptions_VerifyOption = 0
	// Verified build.
	BuildOptions_VERIFIED BuildOptions_VerifyOption = 1
)

var BuildOptions_VerifyOption_name = map[int32]string{
	0: "NOT_VERIFIED",
	1: "VERIFIED",
}
var BuildOptions_VerifyOption_value = map[string]int32{
	"NOT_VERIFIED": 0,
	"VERIFIED":     1,
}

func (x BuildOptions_VerifyOption) String() string {
	return proto.EnumName(BuildOptions_VerifyOption_name, int32(x))
}
func (BuildOptions_VerifyOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{23, 0}
}

// Specifies the behavior when there is an error in the substitution checks.
type BuildOptions_SubstitutionOption int32

const (
	// Fails the build if error in substitutions checks, like missing
	// a substitution in the template or in the map.
	BuildOptions_MUST_MATCH BuildOptions_SubstitutionOption = 0
	// Do not fail the build if error in substitutions checks.
	BuildOptions_ALLOW_LOOSE BuildOptions_SubstitutionOption = 1
)

var BuildOptions_SubstitutionOption_name = map[int32]string{
	0: "MUST_MATCH",
	1: "ALLOW_LOOSE",
}
var BuildOptions_SubstitutionOption_value = map[string]int32{
	"MUST_MATCH":  0,
	"ALLOW_LOOSE": 1,
}

func (x BuildOptions_SubstitutionOption) String() string {
	return proto.EnumName(BuildOptions_SubstitutionOption_name, int32(x))
}
func (BuildOptions_SubstitutionOption) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{23, 1}
}

// StorageSource describes the location of the source in an archive file in
// Google Cloud Storage.
type StorageSource struct {
	// Google Cloud Storage bucket containing source (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `protobuf:"bytes,1,opt,name=bucket" json:"bucket,omitempty"`
	// Google Cloud Storage object containing source.
	//
	// This object must be a gzipped archive file (.tar.gz) containing source to
	// build.
	Object string `protobuf:"bytes,2,opt,name=object" json:"object,omitempty"`
	// Google Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation int64 `protobuf:"varint,3,opt,name=generation" json:"generation,omitempty"`
}

func (m *StorageSource) Reset()                    { *m = StorageSource{} }
func (m *StorageSource) String() string            { return proto.CompactTextString(m) }
func (*StorageSource) ProtoMessage()               {}
func (*StorageSource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *StorageSource) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *StorageSource) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *StorageSource) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

// RepoSource describes the location of the source in a Google Cloud Source
// Repository.
type RepoSource struct {
	// ID of the project that owns the repo. If omitted, the project ID requesting
	// the build is assumed.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Name of the repo. If omitted, the name "default" is assumed.
	RepoName string `protobuf:"bytes,2,opt,name=repo_name,json=repoName" json:"repo_name,omitempty"`
	// A revision within the source repository must be specified in
	// one of these ways.
	//
	// Types that are valid to be assigned to Revision:
	//	*RepoSource_BranchName
	//	*RepoSource_TagName
	//	*RepoSource_CommitSha
	Revision isRepoSource_Revision `protobuf_oneof:"revision"`
}

func (m *RepoSource) Reset()                    { *m = RepoSource{} }
func (m *RepoSource) String() string            { return proto.CompactTextString(m) }
func (*RepoSource) ProtoMessage()               {}
func (*RepoSource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type isRepoSource_Revision interface {
	isRepoSource_Revision()
}

type RepoSource_BranchName struct {
	BranchName string `protobuf:"bytes,3,opt,name=branch_name,json=branchName,oneof"`
}
type RepoSource_TagName struct {
	TagName string `protobuf:"bytes,4,opt,name=tag_name,json=tagName,oneof"`
}
type RepoSource_CommitSha struct {
	CommitSha string `protobuf:"bytes,5,opt,name=commit_sha,json=commitSha,oneof"`
}

func (*RepoSource_BranchName) isRepoSource_Revision() {}
func (*RepoSource_TagName) isRepoSource_Revision()    {}
func (*RepoSource_CommitSha) isRepoSource_Revision()  {}

func (m *RepoSource) GetRevision() isRepoSource_Revision {
	if m != nil {
		return m.Revision
	}
	return nil
}

func (m *RepoSource) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RepoSource) GetRepoName() string {
	if m != nil {
		return m.RepoName
	}
	return ""
}

func (m *RepoSource) GetBranchName() string {
	if x, ok := m.GetRevision().(*RepoSource_BranchName); ok {
		return x.BranchName
	}
	return ""
}

func (m *RepoSource) GetTagName() string {
	if x, ok := m.GetRevision().(*RepoSource_TagName); ok {
		return x.TagName
	}
	return ""
}

func (m *RepoSource) GetCommitSha() string {
	if x, ok := m.GetRevision().(*RepoSource_CommitSha); ok {
		return x.CommitSha
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RepoSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RepoSource_OneofMarshaler, _RepoSource_OneofUnmarshaler, _RepoSource_OneofSizer, []interface{}{
		(*RepoSource_BranchName)(nil),
		(*RepoSource_TagName)(nil),
		(*RepoSource_CommitSha)(nil),
	}
}

func _RepoSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RepoSource)
	// revision
	switch x := m.Revision.(type) {
	case *RepoSource_BranchName:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.BranchName)
	case *RepoSource_TagName:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TagName)
	case *RepoSource_CommitSha:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.CommitSha)
	case nil:
	default:
		return fmt.Errorf("RepoSource.Revision has unexpected type %T", x)
	}
	return nil
}

func _RepoSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RepoSource)
	switch tag {
	case 3: // revision.branch_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_BranchName{x}
		return true, err
	case 4: // revision.tag_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_TagName{x}
		return true, err
	case 5: // revision.commit_sha
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Revision = &RepoSource_CommitSha{x}
		return true, err
	default:
		return false, nil
	}
}

func _RepoSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RepoSource)
	// revision
	switch x := m.Revision.(type) {
	case *RepoSource_BranchName:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BranchName)))
		n += len(x.BranchName)
	case *RepoSource_TagName:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.TagName)))
		n += len(x.TagName)
	case *RepoSource_CommitSha:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.CommitSha)))
		n += len(x.CommitSha)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Source describes the location of the source in a supported storage
// service.
type Source struct {
	// Describes location of source.
	//
	// Types that are valid to be assigned to Source:
	//	*Source_StorageSource
	//	*Source_RepoSource
	Source isSource_Source `protobuf_oneof:"source"`
}

func (m *Source) Reset()                    { *m = Source{} }
func (m *Source) String() string            { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()               {}
func (*Source) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isSource_Source interface {
	isSource_Source()
}

type Source_StorageSource struct {
	StorageSource *StorageSource `protobuf:"bytes,2,opt,name=storage_source,json=storageSource,oneof"`
}
type Source_RepoSource struct {
	RepoSource *RepoSource `protobuf:"bytes,3,opt,name=repo_source,json=repoSource,oneof"`
}

func (*Source_StorageSource) isSource_Source() {}
func (*Source_RepoSource) isSource_Source()    {}

func (m *Source) GetSource() isSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Source) GetStorageSource() *StorageSource {
	if x, ok := m.GetSource().(*Source_StorageSource); ok {
		return x.StorageSource
	}
	return nil
}

func (m *Source) GetRepoSource() *RepoSource {
	if x, ok := m.GetSource().(*Source_RepoSource); ok {
		return x.RepoSource
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Source) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Source_OneofMarshaler, _Source_OneofUnmarshaler, _Source_OneofSizer, []interface{}{
		(*Source_StorageSource)(nil),
		(*Source_RepoSource)(nil),
	}
}

func _Source_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Source)
	// source
	switch x := m.Source.(type) {
	case *Source_StorageSource:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StorageSource); err != nil {
			return err
		}
	case *Source_RepoSource:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RepoSource); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Source.Source has unexpected type %T", x)
	}
	return nil
}

func _Source_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Source)
	switch tag {
	case 2: // source.storage_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StorageSource)
		err := b.DecodeMessage(msg)
		m.Source = &Source_StorageSource{msg}
		return true, err
	case 3: // source.repo_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RepoSource)
		err := b.DecodeMessage(msg)
		m.Source = &Source_RepoSource{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Source_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Source)
	// source
	switch x := m.Source.(type) {
	case *Source_StorageSource:
		s := proto.Size(x.StorageSource)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Source_RepoSource:
		s := proto.Size(x.RepoSource)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// BuiltImage describes an image built by the pipeline.
type BuiltImage struct {
	// Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Docker Registry 2.0 digest.
	Digest string `protobuf:"bytes,3,opt,name=digest" json:"digest,omitempty"`
}

func (m *BuiltImage) Reset()                    { *m = BuiltImage{} }
func (m *BuiltImage) String() string            { return proto.CompactTextString(m) }
func (*BuiltImage) ProtoMessage()               {}
func (*BuiltImage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *BuiltImage) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuiltImage) GetDigest() string {
	if m != nil {
		return m.Digest
	}
	return ""
}

// BuildStep describes a step to perform in the build pipeline.
type BuildStep struct {
	// The name of the container image that will run this particular build step.
	//
	// If the image is already available in the host's Docker daemon's cache, it
	// will be run directly. If not, the host will attempt to pull the image
	// first, using the builder service account's credentials if necessary.
	//
	// The Docker daemon's cache will already have the latest versions of all of
	// the officially supported build steps
	// ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)).
	// The Docker daemon will also have cached many of the layers for some popular
	// images, like "ubuntu", "debian", but they will be refreshed at the time you
	// attempt to use them.
	//
	// If you built an image in a previous build step, it will be stored in the
	// host's Docker daemon's cache and is available to use as the name for a
	// later build step.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A list of environment variable definitions to be used when running a step.
	//
	// The elements are of the form "KEY=VALUE" for the environment variable "KEY"
	// being given the value "VALUE".
	Env []string `protobuf:"bytes,2,rep,name=env" json:"env,omitempty"`
	// A list of arguments that will be presented to the step when it is started.
	//
	// If the image used to run the step's container has an entrypoint, these args
	// will be used as arguments to that entrypoint. If the image does not define
	// an entrypoint, the first element in args will be used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `protobuf:"bytes,3,rep,name=args" json:"args,omitempty"`
	// Working directory (relative to project source root) to use when running
	// this operation's container.
	Dir string `protobuf:"bytes,4,opt,name=dir" json:"dir,omitempty"`
	// Optional unique identifier for this build step, used in wait_for to
	// reference this build step as a dependency.
	Id string `protobuf:"bytes,5,opt,name=id" json:"id,omitempty"`
	// The ID(s) of the step(s) that this build step depends on.
	// This build step will not start until all the build steps in wait_for
	// have completed successfully. If wait_for is empty, this build step will
	// start when all previous build steps in the Build.Steps list have completed
	// successfully.
	WaitFor []string `protobuf:"bytes,6,rep,name=wait_for,json=waitFor" json:"wait_for,omitempty"`
	// Optional entrypoint to be used instead of the build step image's default
	// If unset, the image's default will be used.
	Entrypoint string `protobuf:"bytes,7,opt,name=entrypoint" json:"entrypoint,omitempty"`
}

func (m *BuildStep) Reset()                    { *m = BuildStep{} }
func (m *BuildStep) String() string            { return proto.CompactTextString(m) }
func (*BuildStep) ProtoMessage()               {}
func (*BuildStep) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *BuildStep) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BuildStep) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *BuildStep) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *BuildStep) GetDir() string {
	if m != nil {
		return m.Dir
	}
	return ""
}

func (m *BuildStep) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildStep) GetWaitFor() []string {
	if m != nil {
		return m.WaitFor
	}
	return nil
}

func (m *BuildStep) GetEntrypoint() string {
	if m != nil {
		return m.Entrypoint
	}
	return ""
}

// Results describes the artifacts created by the build pipeline.
type Results struct {
	// Images that were built as a part of the build.
	Images []*BuiltImage `protobuf:"bytes,2,rep,name=images" json:"images,omitempty"`
	// List of build step digests, in order corresponding to build step indices.
	BuildStepImages []string `protobuf:"bytes,3,rep,name=build_step_images,json=buildStepImages" json:"build_step_images,omitempty"`
}

func (m *Results) Reset()                    { *m = Results{} }
func (m *Results) String() string            { return proto.CompactTextString(m) }
func (*Results) ProtoMessage()               {}
func (*Results) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Results) GetImages() []*BuiltImage {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Results) GetBuildStepImages() []string {
	if m != nil {
		return m.BuildStepImages
	}
	return nil
}

// A build resource in the Container Builder API.
//
// At a high level, a Build describes where to find source code, how to build
// it (for example, the builder image to run on the source), and what tag to
// apply to the built image when it is pushed to Google Container Registry.
//
// Fields can include the following variables which will be expanded when the
// build is created:
//
// - $PROJECT_ID: the project ID of the build.
// - $BUILD_ID: the autogenerated ID of the build.
// - $REPO_NAME: the source repository name specified by RepoSource.
// - $BRANCH_NAME: the branch name specified by RepoSource.
// - $TAG_NAME: the tag name specified by RepoSource.
// - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
//   resolved from the specified branch or tag.
type Build struct {
	// Unique identifier of the build.
	// @OutputOnly
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// ID of the project.
	// @OutputOnly.
	ProjectId string `protobuf:"bytes,16,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Status of the build.
	// @OutputOnly
	Status Build_Status `protobuf:"varint,2,opt,name=status,enum=google.devtools.cloudbuild.v1.Build_Status" json:"status,omitempty"`
	// Customer-readable message about the current status.
	// @OutputOnly
	StatusDetail string `protobuf:"bytes,24,opt,name=status_detail,json=statusDetail" json:"status_detail,omitempty"`
	// Describes where to find the source files to build.
	Source *Source `protobuf:"bytes,3,opt,name=source" json:"source,omitempty"`
	// Describes the operations to be performed on the workspace.
	Steps []*BuildStep `protobuf:"bytes,11,rep,name=steps" json:"steps,omitempty"`
	// Results of the build.
	// @OutputOnly
	Results *Results `protobuf:"bytes,10,opt,name=results" json:"results,omitempty"`
	// Time at which the request to create the build was received.
	// @OutputOnly
	CreateTime *google_protobuf4.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Time at which execution of the build was started.
	// @OutputOnly
	StartTime *google_protobuf4.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time at which execution of the build was finished.
	//
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	// @OutputOnly
	FinishTime *google_protobuf4.Timestamp `protobuf:"bytes,8,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
	// Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be TIMEOUT.
	//
	// Default time is ten minutes.
	Timeout *google_protobuf3.Duration `protobuf:"bytes,12,opt,name=timeout" json:"timeout,omitempty"`
	// A list of images to be pushed upon the successful completion of all build
	// steps.
	//
	// The images will be pushed using the builder service account's credentials.
	//
	// The digests of the pushed images will be stored in the Build resource's
	// results field.
	//
	// If any of the images fail to be pushed, the build is marked FAILURE.
	Images []string `protobuf:"bytes,13,rep,name=images" json:"images,omitempty"`
	// Google Cloud Storage bucket where logs should be written (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `protobuf:"bytes,19,opt,name=logs_bucket,json=logsBucket" json:"logs_bucket,omitempty"`
	// A permanent fixed identifier for source.
	// @OutputOnly
	SourceProvenance *SourceProvenance `protobuf:"bytes,21,opt,name=source_provenance,json=sourceProvenance" json:"source_provenance,omitempty"`
	// The ID of the BuildTrigger that triggered this build, if it was
	// triggered automatically.
	// @OutputOnly
	BuildTriggerId string `protobuf:"bytes,22,opt,name=build_trigger_id,json=buildTriggerId" json:"build_trigger_id,omitempty"`
	// Special options for this build.
	Options *BuildOptions `protobuf:"bytes,23,opt,name=options" json:"options,omitempty"`
	// URL to logs for this build in Google Cloud Logging.
	// @OutputOnly
	LogUrl string `protobuf:"bytes,25,opt,name=log_url,json=logUrl" json:"log_url,omitempty"`
	// Substitutions data for Build resource.
	Substitutions map[string]string `protobuf:"bytes,29,rep,name=substitutions" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Tags for annotation of a Build. These are not docker tags.
	Tags []string `protobuf:"bytes,31,rep,name=tags" json:"tags,omitempty"`
}

func (m *Build) Reset()                    { *m = Build{} }
func (m *Build) String() string            { return proto.CompactTextString(m) }
func (*Build) ProtoMessage()               {}
func (*Build) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Build) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Build) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Build) GetStatus() Build_Status {
	if m != nil {
		return m.Status
	}
	return Build_STATUS_UNKNOWN
}

func (m *Build) GetStatusDetail() string {
	if m != nil {
		return m.StatusDetail
	}
	return ""
}

func (m *Build) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Build) GetSteps() []*BuildStep {
	if m != nil {
		return m.Steps
	}
	return nil
}

func (m *Build) GetResults() *Results {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *Build) GetCreateTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Build) GetStartTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Build) GetFinishTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func (m *Build) GetTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Build) GetImages() []string {
	if m != nil {
		return m.Images
	}
	return nil
}

func (m *Build) GetLogsBucket() string {
	if m != nil {
		return m.LogsBucket
	}
	return ""
}

func (m *Build) GetSourceProvenance() *SourceProvenance {
	if m != nil {
		return m.SourceProvenance
	}
	return nil
}

func (m *Build) GetBuildTriggerId() string {
	if m != nil {
		return m.BuildTriggerId
	}
	return ""
}

func (m *Build) GetOptions() *BuildOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Build) GetLogUrl() string {
	if m != nil {
		return m.LogUrl
	}
	return ""
}

func (m *Build) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

func (m *Build) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

// Metadata for build operations.
type BuildOperationMetadata struct {
	// The build that the operation is tracking.
	Build *Build `protobuf:"bytes,1,opt,name=build" json:"build,omitempty"`
}

func (m *BuildOperationMetadata) Reset()                    { *m = BuildOperationMetadata{} }
func (m *BuildOperationMetadata) String() string            { return proto.CompactTextString(m) }
func (*BuildOperationMetadata) ProtoMessage()               {}
func (*BuildOperationMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *BuildOperationMetadata) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Provenance of the source. Ways to find the original source, or verify that
// some source was used for this build.
type SourceProvenance struct {
	// A copy of the build's source.storage_source, if exists, with any
	// generations resolved.
	ResolvedStorageSource *StorageSource `protobuf:"bytes,3,opt,name=resolved_storage_source,json=resolvedStorageSource" json:"resolved_storage_source,omitempty"`
	// A copy of the build's source.repo_source, if exists, with any
	// revisions resolved.
	ResolvedRepoSource *RepoSource `protobuf:"bytes,6,opt,name=resolved_repo_source,json=resolvedRepoSource" json:"resolved_repo_source,omitempty"`
	// Hash(es) of the build source, which can be used to verify that the original
	// source integrity was maintained in the build. Note that FileHashes will
	// only be populated if BuildOptions has requested a SourceProvenanceHash.
	//
	// The keys to this map are file paths used as build source and the values
	// contain the hash values for those files.
	//
	// If the build source came in a single package such as a gzipped tarfile
	// (.tar.gz), the FileHash will be for the single path to that file.
	// @OutputOnly
	FileHashes map[string]*FileHashes `protobuf:"bytes,4,rep,name=file_hashes,json=fileHashes" json:"file_hashes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SourceProvenance) Reset()                    { *m = SourceProvenance{} }
func (m *SourceProvenance) String() string            { return proto.CompactTextString(m) }
func (*SourceProvenance) ProtoMessage()               {}
func (*SourceProvenance) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SourceProvenance) GetResolvedStorageSource() *StorageSource {
	if m != nil {
		return m.ResolvedStorageSource
	}
	return nil
}

func (m *SourceProvenance) GetResolvedRepoSource() *RepoSource {
	if m != nil {
		return m.ResolvedRepoSource
	}
	return nil
}

func (m *SourceProvenance) GetFileHashes() map[string]*FileHashes {
	if m != nil {
		return m.FileHashes
	}
	return nil
}

// Container message for hashes of byte content of files, used in
// SourceProvenance messages to verify integrity of source input to the build.
type FileHashes struct {
	// Collection of file hashes.
	FileHash []*Hash `protobuf:"bytes,1,rep,name=file_hash,json=fileHash" json:"file_hash,omitempty"`
}

func (m *FileHashes) Reset()                    { *m = FileHashes{} }
func (m *FileHashes) String() string            { return proto.CompactTextString(m) }
func (*FileHashes) ProtoMessage()               {}
func (*FileHashes) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *FileHashes) GetFileHash() []*Hash {
	if m != nil {
		return m.FileHash
	}
	return nil
}

// Container message for hash values.
type Hash struct {
	// The type of hash that was performed.
	Type Hash_HashType `protobuf:"varint,1,opt,name=type,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"type,omitempty"`
	// The hash value.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Hash) Reset()                    { *m = Hash{} }
func (m *Hash) String() string            { return proto.CompactTextString(m) }
func (*Hash) ProtoMessage()               {}
func (*Hash) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Hash) GetType() Hash_HashType {
	if m != nil {
		return m.Type
	}
	return Hash_NONE
}

func (m *Hash) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Request to create a new build.
type CreateBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Build resource to create.
	Build *Build `protobuf:"bytes,2,opt,name=build" json:"build,omitempty"`
}

func (m *CreateBuildRequest) Reset()                    { *m = CreateBuildRequest{} }
func (m *CreateBuildRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateBuildRequest) ProtoMessage()               {}
func (*CreateBuildRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CreateBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildRequest) GetBuild() *Build {
	if m != nil {
		return m.Build
	}
	return nil
}

// Request to get a build.
type GetBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the build.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
}

func (m *GetBuildRequest) Reset()                    { *m = GetBuildRequest{} }
func (m *GetBuildRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBuildRequest) ProtoMessage()               {}
func (*GetBuildRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Request to list builds.
type ListBuildsRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Token to provide to skip to a particular spot in the list.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The raw filter text to constrain the results.
	Filter string `protobuf:"bytes,8,opt,name=filter" json:"filter,omitempty"`
}

func (m *ListBuildsRequest) Reset()                    { *m = ListBuildsRequest{} }
func (m *ListBuildsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBuildsRequest) ProtoMessage()               {}
func (*ListBuildsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ListBuildsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListBuildsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBuildsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response including listed builds.
type ListBuildsResponse struct {
	// Builds will be sorted by create_time, descending.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds" json:"builds,omitempty"`
	// Token to receive the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListBuildsResponse) Reset()                    { *m = ListBuildsResponse{} }
func (m *ListBuildsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBuildsResponse) ProtoMessage()               {}
func (*ListBuildsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListBuildsResponse) GetBuilds() []*Build {
	if m != nil {
		return m.Builds
	}
	return nil
}

func (m *ListBuildsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to cancel an ongoing build.
type CancelBuildRequest struct {
	// ID of the project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the build.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
}

func (m *CancelBuildRequest) Reset()                    { *m = CancelBuildRequest{} }
func (m *CancelBuildRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelBuildRequest) ProtoMessage()               {}
func (*CancelBuildRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *CancelBuildRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelBuildRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Configuration for an automated build in response to source repository
// changes.
type BuildTrigger struct {
	// Unique identifier of the trigger.
	//
	// @OutputOnly
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Human-readable description of this trigger.
	Description string `protobuf:"bytes,10,opt,name=description" json:"description,omitempty"`
	// Template describing the types of source changes to trigger a build.
	//
	// Branch and tag names in trigger templates are interpreted as regular
	// expressions. Any branch or tag change that matches that regular expression
	// will trigger a build.
	TriggerTemplate *RepoSource `protobuf:"bytes,7,opt,name=trigger_template,json=triggerTemplate" json:"trigger_template,omitempty"`
	// Template describing the Build request to make when the trigger is matched.
	//
	// Types that are valid to be assigned to BuildTemplate:
	//	*BuildTrigger_Build
	//	*BuildTrigger_Filename
	BuildTemplate isBuildTrigger_BuildTemplate `protobuf_oneof:"build_template"`
	// Time when the trigger was created.
	//
	// @OutputOnly
	CreateTime *google_protobuf4.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// If true, the trigger will never result in a build.
	Disabled bool `protobuf:"varint,9,opt,name=disabled" json:"disabled,omitempty"`
	// Substitutions data for Build resource.
	Substitutions map[string]string `protobuf:"bytes,11,rep,name=substitutions" json:"substitutions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *BuildTrigger) Reset()                    { *m = BuildTrigger{} }
func (m *BuildTrigger) String() string            { return proto.CompactTextString(m) }
func (*BuildTrigger) ProtoMessage()               {}
func (*BuildTrigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

type isBuildTrigger_BuildTemplate interface {
	isBuildTrigger_BuildTemplate()
}

type BuildTrigger_Build struct {
	Build *Build `protobuf:"bytes,4,opt,name=build,oneof"`
}
type BuildTrigger_Filename struct {
	Filename string `protobuf:"bytes,8,opt,name=filename,oneof"`
}

func (*BuildTrigger_Build) isBuildTrigger_BuildTemplate()    {}
func (*BuildTrigger_Filename) isBuildTrigger_BuildTemplate() {}

func (m *BuildTrigger) GetBuildTemplate() isBuildTrigger_BuildTemplate {
	if m != nil {
		return m.BuildTemplate
	}
	return nil
}

func (m *BuildTrigger) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *BuildTrigger) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *BuildTrigger) GetTriggerTemplate() *RepoSource {
	if m != nil {
		return m.TriggerTemplate
	}
	return nil
}

func (m *BuildTrigger) GetBuild() *Build {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Build); ok {
		return x.Build
	}
	return nil
}

func (m *BuildTrigger) GetFilename() string {
	if x, ok := m.GetBuildTemplate().(*BuildTrigger_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *BuildTrigger) GetCreateTime() *google_protobuf4.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *BuildTrigger) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *BuildTrigger) GetSubstitutions() map[string]string {
	if m != nil {
		return m.Substitutions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BuildTrigger) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BuildTrigger_OneofMarshaler, _BuildTrigger_OneofUnmarshaler, _BuildTrigger_OneofSizer, []interface{}{
		(*BuildTrigger_Build)(nil),
		(*BuildTrigger_Filename)(nil),
	}
}

func _BuildTrigger_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BuildTrigger)
	// build_template
	switch x := m.BuildTemplate.(type) {
	case *BuildTrigger_Build:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Build); err != nil {
			return err
		}
	case *BuildTrigger_Filename:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Filename)
	case nil:
	default:
		return fmt.Errorf("BuildTrigger.BuildTemplate has unexpected type %T", x)
	}
	return nil
}

func _BuildTrigger_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BuildTrigger)
	switch tag {
	case 4: // build_template.build
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Build)
		err := b.DecodeMessage(msg)
		m.BuildTemplate = &BuildTrigger_Build{msg}
		return true, err
	case 8: // build_template.filename
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.BuildTemplate = &BuildTrigger_Filename{x}
		return true, err
	default:
		return false, nil
	}
}

func _BuildTrigger_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BuildTrigger)
	// build_template
	switch x := m.BuildTemplate.(type) {
	case *BuildTrigger_Build:
		s := proto.Size(x.Build)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *BuildTrigger_Filename:
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Filename)))
		n += len(x.Filename)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request to create a new BuildTrigger.
type CreateBuildTriggerRequest struct {
	// ID of the project for which to configure automatic builds.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// BuildTrigger to create.
	Trigger *BuildTrigger `protobuf:"bytes,2,opt,name=trigger" json:"trigger,omitempty"`
}

func (m *CreateBuildTriggerRequest) Reset()                    { *m = CreateBuildTriggerRequest{} }
func (m *CreateBuildTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateBuildTriggerRequest) ProtoMessage()               {}
func (*CreateBuildTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CreateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Returns the BuildTrigger with the specified ID.
type GetBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the BuildTrigger to get.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId" json:"trigger_id,omitempty"`
}

func (m *GetBuildTriggerRequest) Reset()                    { *m = GetBuildTriggerRequest{} }
func (m *GetBuildTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*GetBuildTriggerRequest) ProtoMessage()               {}
func (*GetBuildTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GetBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to list existing BuildTriggers.
type ListBuildTriggersRequest struct {
	// ID of the project for which to list BuildTriggers.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *ListBuildTriggersRequest) Reset()                    { *m = ListBuildTriggersRequest{} }
func (m *ListBuildTriggersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListBuildTriggersRequest) ProtoMessage()               {}
func (*ListBuildTriggersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ListBuildTriggersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// Response containing existing BuildTriggers.
type ListBuildTriggersResponse struct {
	// BuildTriggers for the project, sorted by create_time descending.
	Triggers []*BuildTrigger `protobuf:"bytes,1,rep,name=triggers" json:"triggers,omitempty"`
}

func (m *ListBuildTriggersResponse) Reset()                    { *m = ListBuildTriggersResponse{} }
func (m *ListBuildTriggersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListBuildTriggersResponse) ProtoMessage()               {}
func (*ListBuildTriggersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ListBuildTriggersResponse) GetTriggers() []*BuildTrigger {
	if m != nil {
		return m.Triggers
	}
	return nil
}

// Request to delete a BuildTrigger.
type DeleteBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the BuildTrigger to delete.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId" json:"trigger_id,omitempty"`
}

func (m *DeleteBuildTriggerRequest) Reset()                    { *m = DeleteBuildTriggerRequest{} }
func (m *DeleteBuildTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteBuildTriggerRequest) ProtoMessage()               {}
func (*DeleteBuildTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *DeleteBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

// Request to update an existing BuildTrigger.
type UpdateBuildTriggerRequest struct {
	// ID of the project that owns the trigger.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// ID of the BuildTrigger to update.
	TriggerId string `protobuf:"bytes,2,opt,name=trigger_id,json=triggerId" json:"trigger_id,omitempty"`
	// BuildTrigger to update.
	Trigger *BuildTrigger `protobuf:"bytes,3,opt,name=trigger" json:"trigger,omitempty"`
}

func (m *UpdateBuildTriggerRequest) Reset()                    { *m = UpdateBuildTriggerRequest{} }
func (m *UpdateBuildTriggerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateBuildTriggerRequest) ProtoMessage()               {}
func (*UpdateBuildTriggerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *UpdateBuildTriggerRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTriggerId() string {
	if m != nil {
		return m.TriggerId
	}
	return ""
}

func (m *UpdateBuildTriggerRequest) GetTrigger() *BuildTrigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

// Optional arguments to enable specific features of builds.
type BuildOptions struct {
	// Requested hash for SourceProvenance.
	SourceProvenanceHash []Hash_HashType `protobuf:"varint,1,rep,packed,name=source_provenance_hash,json=sourceProvenanceHash,enum=google.devtools.cloudbuild.v1.Hash_HashType" json:"source_provenance_hash,omitempty"`
	// Requested verifiability options.
	RequestedVerifyOption BuildOptions_VerifyOption `protobuf:"varint,2,opt,name=requested_verify_option,json=requestedVerifyOption,enum=google.devtools.cloudbuild.v1.BuildOptions_VerifyOption" json:"requested_verify_option,omitempty"`
	// SubstitutionOption to allow unmatch substitutions.
	SubstitutionOption BuildOptions_SubstitutionOption `protobuf:"varint,4,opt,name=substitution_option,json=substitutionOption,enum=google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption" json:"substitution_option,omitempty"`
}

func (m *BuildOptions) Reset()                    { *m = BuildOptions{} }
func (m *BuildOptions) String() string            { return proto.CompactTextString(m) }
func (*BuildOptions) ProtoMessage()               {}
func (*BuildOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *BuildOptions) GetSourceProvenanceHash() []Hash_HashType {
	if m != nil {
		return m.SourceProvenanceHash
	}
	return nil
}

func (m *BuildOptions) GetRequestedVerifyOption() BuildOptions_VerifyOption {
	if m != nil {
		return m.RequestedVerifyOption
	}
	return BuildOptions_NOT_VERIFIED
}

func (m *BuildOptions) GetSubstitutionOption() BuildOptions_SubstitutionOption {
	if m != nil {
		return m.SubstitutionOption
	}
	return BuildOptions_MUST_MATCH
}

func init() {
	proto.RegisterType((*StorageSource)(nil), "google.devtools.cloudbuild.v1.StorageSource")
	proto.RegisterType((*RepoSource)(nil), "google.devtools.cloudbuild.v1.RepoSource")
	proto.RegisterType((*Source)(nil), "google.devtools.cloudbuild.v1.Source")
	proto.RegisterType((*BuiltImage)(nil), "google.devtools.cloudbuild.v1.BuiltImage")
	proto.RegisterType((*BuildStep)(nil), "google.devtools.cloudbuild.v1.BuildStep")
	proto.RegisterType((*Results)(nil), "google.devtools.cloudbuild.v1.Results")
	proto.RegisterType((*Build)(nil), "google.devtools.cloudbuild.v1.Build")
	proto.RegisterType((*BuildOperationMetadata)(nil), "google.devtools.cloudbuild.v1.BuildOperationMetadata")
	proto.RegisterType((*SourceProvenance)(nil), "google.devtools.cloudbuild.v1.SourceProvenance")
	proto.RegisterType((*FileHashes)(nil), "google.devtools.cloudbuild.v1.FileHashes")
	proto.RegisterType((*Hash)(nil), "google.devtools.cloudbuild.v1.Hash")
	proto.RegisterType((*CreateBuildRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildRequest")
	proto.RegisterType((*GetBuildRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildRequest")
	proto.RegisterType((*ListBuildsRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildsRequest")
	proto.RegisterType((*ListBuildsResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildsResponse")
	proto.RegisterType((*CancelBuildRequest)(nil), "google.devtools.cloudbuild.v1.CancelBuildRequest")
	proto.RegisterType((*BuildTrigger)(nil), "google.devtools.cloudbuild.v1.BuildTrigger")
	proto.RegisterType((*CreateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.CreateBuildTriggerRequest")
	proto.RegisterType((*GetBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.GetBuildTriggerRequest")
	proto.RegisterType((*ListBuildTriggersRequest)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersRequest")
	proto.RegisterType((*ListBuildTriggersResponse)(nil), "google.devtools.cloudbuild.v1.ListBuildTriggersResponse")
	proto.RegisterType((*DeleteBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.DeleteBuildTriggerRequest")
	proto.RegisterType((*UpdateBuildTriggerRequest)(nil), "google.devtools.cloudbuild.v1.UpdateBuildTriggerRequest")
	proto.RegisterType((*BuildOptions)(nil), "google.devtools.cloudbuild.v1.BuildOptions")
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Build_Status", Build_Status_name, Build_Status_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.Hash_HashType", Hash_HashType_name, Hash_HashType_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_VerifyOption", BuildOptions_VerifyOption_name, BuildOptions_VerifyOption_value)
	proto.RegisterEnum("google.devtools.cloudbuild.v1.BuildOptions_SubstitutionOption", BuildOptions_SubstitutionOption_name, BuildOptions_SubstitutionOption_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CloudBuild service

type CloudBuildClient interface {
	// Starts a build with the specified configuration.
	//
	// The long-running Operation returned by this method will include the ID of
	// the build, which can be passed to GetBuild to determine its status (e.g.,
	// success or failure).
	CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The Build that is returned includes its status (e.g., success or failure,
	// or in-progress), and timing information.
	GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Cancels a requested build in progress.
	CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error)
	// Creates a new BuildTrigger.
	//
	// This API is experimental.
	CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Gets information about a BuildTrigger.
	//
	// This API is experimental.
	GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
	// Lists existing BuildTrigger.
	//
	// This API is experimental.
	ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error)
	// Deletes an BuildTrigger by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Updates an BuildTrigger by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error)
}

type cloudBuildClient struct {
	cc *grpc.ClientConn
}

func NewCloudBuildClient(cc *grpc.ClientConn) CloudBuildClient {
	return &cloudBuildClient{cc}
}

func (c *cloudBuildClient) CreateBuild(ctx context.Context, in *CreateBuildRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuild(ctx context.Context, in *GetBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CancelBuild(ctx context.Context, in *CancelBuildRequest, opts ...grpc.CallOption) (*Build, error) {
	out := new(Build)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) CreateBuildTrigger(ctx context.Context, in *CreateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) GetBuildTrigger(ctx context.Context, in *GetBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) ListBuildTriggers(ctx context.Context, in *ListBuildTriggersRequest, opts ...grpc.CallOption) (*ListBuildTriggersResponse, error) {
	out := new(ListBuildTriggersResponse)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) DeleteBuildTrigger(ctx context.Context, in *DeleteBuildTriggerRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudBuildClient) UpdateBuildTrigger(ctx context.Context, in *UpdateBuildTriggerRequest, opts ...grpc.CallOption) (*BuildTrigger, error) {
	out := new(BuildTrigger)
	err := grpc.Invoke(ctx, "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CloudBuild service

type CloudBuildServer interface {
	// Starts a build with the specified configuration.
	//
	// The long-running Operation returned by this method will include the ID of
	// the build, which can be passed to GetBuild to determine its status (e.g.,
	// success or failure).
	CreateBuild(context.Context, *CreateBuildRequest) (*google_longrunning.Operation, error)
	// Returns information about a previously requested build.
	//
	// The Build that is returned includes its status (e.g., success or failure,
	// or in-progress), and timing information.
	GetBuild(context.Context, *GetBuildRequest) (*Build, error)
	// Lists previously requested builds.
	//
	// Previously requested builds may still be in-progress, or may have finished
	// successfully or unsuccessfully.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Cancels a requested build in progress.
	CancelBuild(context.Context, *CancelBuildRequest) (*Build, error)
	// Creates a new BuildTrigger.
	//
	// This API is experimental.
	CreateBuildTrigger(context.Context, *CreateBuildTriggerRequest) (*BuildTrigger, error)
	// Gets information about a BuildTrigger.
	//
	// This API is experimental.
	GetBuildTrigger(context.Context, *GetBuildTriggerRequest) (*BuildTrigger, error)
	// Lists existing BuildTrigger.
	//
	// This API is experimental.
	ListBuildTriggers(context.Context, *ListBuildTriggersRequest) (*ListBuildTriggersResponse, error)
	// Deletes an BuildTrigger by its project ID and trigger ID.
	//
	// This API is experimental.
	DeleteBuildTrigger(context.Context, *DeleteBuildTriggerRequest) (*google_protobuf2.Empty, error)
	// Updates an BuildTrigger by its project ID and trigger ID.
	//
	// This API is experimental.
	UpdateBuildTrigger(context.Context, *UpdateBuildTriggerRequest) (*BuildTrigger, error)
}

func RegisterCloudBuildServer(s *grpc.Server, srv CloudBuildServer) {
	s.RegisterService(&_CloudBuild_serviceDesc, srv)
}

func _CloudBuild_CreateBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuild(ctx, req.(*CreateBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuild(ctx, req.(*GetBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CancelBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CancelBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CancelBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CancelBuild(ctx, req.(*CancelBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_CreateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/CreateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).CreateBuildTrigger(ctx, req.(*CreateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_GetBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/GetBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).GetBuildTrigger(ctx, req.(*GetBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_ListBuildTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/ListBuildTriggers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).ListBuildTriggers(ctx, req.(*ListBuildTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_DeleteBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/DeleteBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).DeleteBuildTrigger(ctx, req.(*DeleteBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudBuild_UpdateBuildTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBuildTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v1.CloudBuild/UpdateBuildTrigger",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudBuildServer).UpdateBuildTrigger(ctx, req.(*UpdateBuildTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudBuild_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v1.CloudBuild",
	HandlerType: (*CloudBuildServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBuild",
			Handler:    _CloudBuild_CreateBuild_Handler,
		},
		{
			MethodName: "GetBuild",
			Handler:    _CloudBuild_GetBuild_Handler,
		},
		{
			MethodName: "ListBuilds",
			Handler:    _CloudBuild_ListBuilds_Handler,
		},
		{
			MethodName: "CancelBuild",
			Handler:    _CloudBuild_CancelBuild_Handler,
		},
		{
			MethodName: "CreateBuildTrigger",
			Handler:    _CloudBuild_CreateBuildTrigger_Handler,
		},
		{
			MethodName: "GetBuildTrigger",
			Handler:    _CloudBuild_GetBuildTrigger_Handler,
		},
		{
			MethodName: "ListBuildTriggers",
			Handler:    _CloudBuild_ListBuildTriggers_Handler,
		},
		{
			MethodName: "DeleteBuildTrigger",
			Handler:    _CloudBuild_DeleteBuildTrigger_Handler,
		},
		{
			MethodName: "UpdateBuildTrigger",
			Handler:    _CloudBuild_UpdateBuildTrigger_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v1/cloudbuild.proto",
}

func init() { proto.RegisterFile("google/devtools/cloudbuild/v1/cloudbuild.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2077 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0x5b, 0x6f, 0xdb, 0xd8,
	0x11, 0x36, 0x25, 0x59, 0x97, 0x91, 0x2f, 0xcc, 0xd9, 0xac, 0x43, 0x2b, 0xeb, 0x8d, 0xcb, 0xec,
	0x6e, 0xbd, 0xd9, 0x5d, 0xa9, 0x76, 0x90, 0xc6, 0xeb, 0x6c, 0xb3, 0xb6, 0x65, 0xc5, 0x36, 0xd6,
	0x91, 0x52, 0x4a, 0x4a, 0xd0, 0x1b, 0x58, 0x4a, 0x3c, 0xa6, 0xd9, 0x50, 0x24, 0x4b, 0x1e, 0xa9,
	0x71, 0x82, 0xa0, 0x17, 0xa0, 0x7d, 0x6d, 0x81, 0x3e, 0xf6, 0xa1, 0x6d, 0x7e, 0x40, 0x51, 0x14,
	0x28, 0xfa, 0xd2, 0xfe, 0x8a, 0xfe, 0x85, 0x3e, 0xf6, 0x47, 0x14, 0xe7, 0x42, 0x89, 0x92, 0x92,
	0x52, 0x6a, 0xd0, 0x97, 0x80, 0x67, 0xce, 0x7c, 0x33, 0x73, 0xe6, 0xcc, 0x99, 0xf9, 0x14, 0x43,
	0xd9, 0xf2, 0x3c, 0xcb, 0xc1, 0x15, 0x13, 0x0f, 0x88, 0xe7, 0x39, 0x61, 0xa5, 0xeb, 0x78, 0x7d,
	0xb3, 0xd3, 0xb7, 0x1d, 0xb3, 0x32, 0xd8, 0x8e, 0xad, 0xca, 0x7e, 0xe0, 0x11, 0x0f, 0x6d, 0x70,
	0xfd, 0x72, 0xa4, 0x5f, 0x8e, 0x69, 0x0c, 0xb6, 0x4b, 0xef, 0x09, 0x73, 0x86, 0x6f, 0x57, 0x0c,
	0xd7, 0xf5, 0x88, 0x41, 0x6c, 0xcf, 0x0d, 0x39, 0xb8, 0x74, 0x53, 0xec, 0x3a, 0x9e, 0x6b, 0x05,
	0x7d, 0xd7, 0xb5, 0x5d, 0xab, 0xe2, 0xf9, 0x38, 0x18, 0x53, 0x7a, 0x5f, 0x28, 0xb1, 0x55, 0xa7,
	0x7f, 0x5e, 0x31, 0xfb, 0x5c, 0x41, 0xec, 0x5f, 0x9f, 0xdc, 0xc7, 0x3d, 0x9f, 0x5c, 0x8a, 0xcd,
	0x1b, 0x93, 0x9b, 0xc4, 0xee, 0xe1, 0x90, 0x18, 0x3d, 0x9f, 0x2b, 0xa8, 0x3a, 0x2c, 0x37, 0x89,
	0x17, 0x18, 0x16, 0x6e, 0x7a, 0xfd, 0xa0, 0x8b, 0xd1, 0x1a, 0x64, 0x3b, 0xfd, 0xee, 0x53, 0x4c,
	0x14, 0x69, 0x53, 0xda, 0x2a, 0x68, 0x62, 0x45, 0xe5, 0x5e, 0xe7, 0x47, 0xb8, 0x4b, 0x94, 0x14,
	0x97, 0xf3, 0x15, 0x7a, 0x1f, 0xc0, 0xc2, 0xae, 0x88, 0x59, 0x49, 0x6f, 0x4a, 0x5b, 0x69, 0x2d,
	0x26, 0x51, 0xff, 0x2a, 0x01, 0x68, 0xd8, 0xf7, 0x84, 0xf9, 0x0d, 0x00, 0x3f, 0xf0, 0x28, 0x52,
	0xb7, 0x4d, 0xe1, 0xa2, 0x20, 0x24, 0xa7, 0x26, 0xba, 0x0e, 0x85, 0x00, 0xfb, 0x9e, 0xee, 0x1a,
	0x3d, 0x2c, 0x1c, 0xe5, 0xa9, 0xa0, 0x6e, 0xf4, 0x30, 0xfa, 0x1a, 0x14, 0x3b, 0x81, 0xe1, 0x76,
	0x2f, 0xf8, 0x36, 0xf5, 0x55, 0x38, 0x59, 0xd0, 0x80, 0x0b, 0x99, 0xca, 0x75, 0xc8, 0x13, 0xc3,
	0xe2, 0xfb, 0x19, 0xb1, 0x9f, 0x23, 0x86, 0xc5, 0x36, 0x6f, 0x00, 0x74, 0xbd, 0x5e, 0xcf, 0x26,
	0x7a, 0x78, 0x61, 0x28, 0x8b, 0x62, 0xbb, 0xc0, 0x65, 0xcd, 0x0b, 0xe3, 0x10, 0x20, 0x1f, 0xe0,
	0x81, 0x1d, 0xd2, 0xb8, 0xff, 0x26, 0x41, 0x56, 0xc4, 0xdc, 0x86, 0x95, 0x90, 0xe7, 0x48, 0x0f,
	0x99, 0x84, 0x45, 0x56, 0xdc, 0xf9, 0xb4, 0xfc, 0x5f, 0x2f, 0xbf, 0x3c, 0x96, 0xd8, 0x93, 0x05,
	0x6d, 0x39, 0x1c, 0xcb, 0xf4, 0x19, 0x14, 0xd9, 0x59, 0x85, 0xcd, 0x34, 0xb3, 0xf9, 0x71, 0x82,
	0xcd, 0x51, 0x2a, 0xe9, 0xc9, 0x83, 0xe1, 0xea, 0x30, 0x0f, 0x59, 0x6e, 0x48, 0xdd, 0x05, 0x38,
	0xec, 0xdb, 0x0e, 0x39, 0xed, 0x19, 0x16, 0x46, 0x08, 0x32, 0x2c, 0x1b, 0x3c, 0xd5, 0xec, 0x9b,
	0xde, 0xa5, 0x69, 0x5b, 0x38, 0x24, 0x3c, 0x87, 0x9a, 0x58, 0xa9, 0xaf, 0x24, 0x28, 0x50, 0xa8,
	0xd9, 0x24, 0xd8, 0x7f, 0x2d, 0x52, 0x86, 0x34, 0x76, 0x07, 0x4a, 0x6a, 0x33, 0xbd, 0x55, 0xd0,
	0xe8, 0x27, 0xd5, 0x32, 0x02, 0x2b, 0x54, 0xd2, 0x4c, 0xc4, 0xbe, 0xa9, 0x96, 0x69, 0x07, 0xfc,
	0x02, 0x34, 0xfa, 0x89, 0x56, 0x20, 0x65, 0x9b, 0x3c, 0xe5, 0x5a, 0xca, 0x36, 0xd1, 0x3a, 0xe4,
	0x7f, 0x62, 0xd8, 0x44, 0x3f, 0xf7, 0x02, 0x25, 0xcb, 0x90, 0x39, 0xba, 0x7e, 0xe0, 0x05, 0xb4,
	0xa0, 0xb0, 0x4b, 0x82, 0x4b, 0xdf, 0xb3, 0x5d, 0xa2, 0xe4, 0x18, 0x24, 0x26, 0x51, 0x9f, 0x41,
	0x4e, 0xc3, 0x61, 0xdf, 0x21, 0x21, 0x3a, 0x80, 0xac, 0x4d, 0x0f, 0x19, 0xb2, 0x80, 0x92, 0x93,
	0x37, 0x4a, 0x8b, 0x26, 0x80, 0xe8, 0x16, 0x5c, 0x61, 0xdb, 0x7a, 0x48, 0xb0, 0xaf, 0x0b, 0x6b,
	0xfc, 0x2c, 0xab, 0x9d, 0x28, 0x15, 0x0c, 0x12, 0xaa, 0xaf, 0x0a, 0xb0, 0xc8, 0xd2, 0x23, 0x8e,
	0x23, 0x0d, 0x8f, 0x33, 0x5e, 0xd5, 0xf2, 0x64, 0x55, 0x57, 0x21, 0x1b, 0x12, 0x83, 0xf4, 0x43,
	0x56, 0x38, 0x2b, 0x3b, 0x9f, 0xcc, 0x10, 0xa7, 0x59, 0x6e, 0x32, 0x88, 0x26, 0xa0, 0xe8, 0x26,
	0x2c, 0xf3, 0x2f, 0xdd, 0xc4, 0xc4, 0xb0, 0x1d, 0x45, 0x61, 0x6e, 0x96, 0xb8, 0xf0, 0x88, 0xc9,
	0xd0, 0xb7, 0xa2, 0x2a, 0x10, 0xe5, 0xf4, 0x61, 0x52, 0x89, 0x32, 0x65, 0x4d, 0x80, 0xd0, 0x7d,
	0x58, 0xa4, 0x79, 0x08, 0x95, 0x22, 0xcb, 0xe7, 0xd6, 0x2c, 0x71, 0xd2, 0x04, 0x69, 0x1c, 0x86,
	0xf6, 0x21, 0x17, 0xf0, 0xbb, 0x51, 0x80, 0xf9, 0xff, 0x28, 0xb1, 0x9c, 0x99, 0xb6, 0x16, 0xc1,
	0xd0, 0x3d, 0x28, 0x76, 0x03, 0x6c, 0x10, 0xac, 0xd3, 0x4e, 0xa5, 0x64, 0x99, 0x95, 0x52, 0x64,
	0x25, 0x6a, 0x63, 0xe5, 0x56, 0xd4, 0xc6, 0x34, 0xe0, 0xea, 0x54, 0x80, 0x3e, 0x07, 0x08, 0x89,
	0x11, 0x10, 0x8e, 0xcd, 0x25, 0x62, 0x0b, 0x4c, 0x9b, 0x41, 0xef, 0x41, 0xf1, 0xdc, 0x76, 0xed,
	0xf0, 0x82, 0x63, 0xf3, 0xc9, 0x7e, 0xb9, 0x3a, 0x03, 0xdf, 0x86, 0x1c, 0x45, 0x79, 0x7d, 0xa2,
	0x2c, 0x31, 0xe0, 0xfa, 0x14, 0xf0, 0x48, 0x34, 0x6d, 0x2d, 0xd2, 0xa4, 0x8f, 0x50, 0x94, 0xdb,
	0x32, 0x2b, 0xb7, 0xa8, 0x22, 0x6f, 0x40, 0xd1, 0xf1, 0xac, 0x50, 0x17, 0x5d, 0xf8, 0x1d, 0xfe,
	0x00, 0xa8, 0xe8, 0x90, 0x77, 0xe2, 0xef, 0xc3, 0x15, 0x7e, 0x5d, 0xba, 0x1f, 0x78, 0x03, 0xec,
	0x1a, 0x6e, 0x17, 0x2b, 0xef, 0x32, 0xbf, 0x95, 0x99, 0xae, 0xfb, 0xd1, 0x10, 0xa6, 0xc9, 0xe1,
	0x84, 0x04, 0x6d, 0x81, 0xcc, 0x1f, 0x04, 0x09, 0x6c, 0xcb, 0xc2, 0x01, 0x2d, 0xe8, 0x35, 0x16,
	0xc3, 0x0a, 0x93, 0xb7, 0xb8, 0xf8, 0xd4, 0x44, 0x35, 0xc8, 0x79, 0x3e, 0x9b, 0x54, 0xca, 0x35,
	0xe6, 0x7d, 0xa6, 0xb2, 0x6e, 0x70, 0x88, 0x16, 0x61, 0xd1, 0x35, 0xc8, 0x39, 0x9e, 0xa5, 0xf7,
	0x03, 0x47, 0x59, 0xe7, 0xdd, 0xc8, 0xf1, 0xac, 0x76, 0xe0, 0xa0, 0x1f, 0xc0, 0x72, 0xd8, 0xef,
	0x84, 0xc4, 0x26, 0x7d, 0xee, 0x65, 0x83, 0x15, 0xe5, 0xdd, 0xd9, 0x1e, 0x4f, 0x1c, 0x59, 0xa3,
	0xdd, 0x43, 0x1b, 0xb7, 0x46, 0x1b, 0x17, 0x31, 0xac, 0x50, 0xb9, 0xc1, 0x1b, 0x17, 0xfd, 0x2e,
	0xed, 0x03, 0x9a, 0x06, 0xd2, 0x76, 0xf6, 0x14, 0x5f, 0x8a, 0xe7, 0x4e, 0x3f, 0xd1, 0x55, 0x58,
	0x1c, 0x18, 0x4e, 0x3f, 0x1a, 0x51, 0x7c, 0xb1, 0x97, 0xda, 0x95, 0xd4, 0x9f, 0x42, 0x96, 0xbf,
	0x5b, 0x84, 0x60, 0xa5, 0xd9, 0x3a, 0x68, 0xb5, 0x9b, 0x7a, 0xbb, 0xfe, 0x55, 0xbd, 0xf1, 0xa4,
	0x2e, 0x2f, 0x20, 0x80, 0xec, 0xb7, 0xdb, 0xb5, 0x76, 0xed, 0x48, 0x96, 0x50, 0x11, 0x72, 0x4f,
	0x1a, 0xda, 0x57, 0xa7, 0xf5, 0x63, 0x39, 0x45, 0x17, 0xcd, 0x76, 0xb5, 0x5a, 0x6b, 0x36, 0xe5,
	0x34, 0x5d, 0x3c, 0x38, 0x38, 0x3d, 0x6b, 0x6b, 0x35, 0x39, 0x43, 0xcd, 0x9c, 0xd6, 0x5b, 0x35,
	0xad, 0x7e, 0x70, 0xa6, 0xd7, 0x34, 0xad, 0xa1, 0xc9, 0x8b, 0x54, 0xa1, 0x75, 0xfa, 0xb0, 0xd6,
	0x68, 0xb7, 0xe4, 0x2c, 0x5a, 0x86, 0x42, 0xf5, 0xa0, 0x5e, 0xad, 0x9d, 0x9d, 0xd5, 0x8e, 0xe4,
	0x9c, 0xda, 0x82, 0x35, 0x91, 0x67, 0x31, 0x81, 0x1f, 0x62, 0x62, 0x98, 0x06, 0x31, 0xd0, 0x1e,
	0x2c, 0xb2, 0x24, 0xb1, 0x83, 0x14, 0x77, 0x3e, 0x98, 0x25, 0x8f, 0x1a, 0x87, 0xa8, 0x7f, 0x4c,
	0x83, 0x3c, 0x59, 0x3c, 0xc8, 0x84, 0x6b, 0x01, 0x0e, 0x3d, 0x67, 0x80, 0x69, 0xfb, 0x1c, 0x1b,
	0x90, 0xe9, 0xf9, 0x07, 0xa4, 0xf6, 0x6e, 0x64, 0x6c, 0x9c, 0x90, 0x7c, 0x0f, 0xae, 0x0e, 0xbd,
	0xc4, 0xe7, 0x65, 0x76, 0xce, 0x79, 0xa9, 0xa1, 0xc8, 0x4c, 0x8c, 0x8e, 0xfc, 0x90, 0x3e, 0x7b,
	0x07, 0xeb, 0x17, 0x46, 0x78, 0x81, 0x43, 0x25, 0xc3, 0x2a, 0xec, 0xcb, 0x39, 0x5f, 0x51, 0xf9,
	0x81, 0xed, 0xe0, 0x13, 0x66, 0x81, 0x57, 0x1a, 0x9c, 0x0f, 0x05, 0xa5, 0x0b, 0x58, 0x9d, 0xd8,
	0x7e, 0x4d, 0x3d, 0x7d, 0x19, 0xaf, 0xa7, 0xe4, 0x43, 0x8d, 0x0c, 0xc6, 0x4b, 0xaf, 0x0e, 0x30,
	0xda, 0x40, 0xfb, 0x50, 0x18, 0x9e, 0x4c, 0x91, 0xd8, 0xb9, 0x6e, 0x26, 0x98, 0xa5, 0x48, 0x2d,
	0x1f, 0xc5, 0xae, 0xfe, 0x4c, 0x82, 0x0c, 0xfd, 0x40, 0xfb, 0x90, 0x21, 0x97, 0x3e, 0x27, 0x02,
	0x2b, 0x89, 0x97, 0x4a, 0x21, 0xec, 0x9f, 0xd6, 0xa5, 0x8f, 0x35, 0x86, 0x1c, 0x7f, 0x2f, 0x4b,
	0x22, 0x68, 0x75, 0x13, 0xf2, 0x91, 0x1e, 0xca, 0x43, 0xa6, 0xde, 0xa8, 0xd7, 0xf8, 0x1b, 0x69,
	0x9e, 0x1c, 0xec, 0xdc, 0xf9, 0xa6, 0x2c, 0xa9, 0x1e, 0xa0, 0x2a, 0x6b, 0xef, 0xbc, 0x18, 0xf1,
	0x8f, 0xfb, 0x38, 0x24, 0x49, 0x1c, 0x72, 0x58, 0xe7, 0xa9, 0xf9, 0xeb, 0x7c, 0x1f, 0x56, 0x8f,
	0x31, 0x99, 0xc7, 0x1b, 0xa7, 0x02, 0xa9, 0x88, 0x0a, 0xa8, 0xbf, 0x92, 0xe0, 0xca, 0x99, 0x1d,
	0x72, 0x1b, 0xe1, 0x8c, 0x46, 0xae, 0x43, 0xc1, 0x67, 0xaf, 0xc7, 0x7e, 0xce, 0x73, 0xb4, 0xa8,
	0xe5, 0xa9, 0xa0, 0x69, 0x3f, 0xe7, 0x94, 0x99, 0x6e, 0x12, 0xef, 0x29, 0x76, 0x05, 0x63, 0x63,
	0xea, 0x2d, 0x2a, 0xa0, 0x73, 0xe4, 0xdc, 0x76, 0x08, 0x0e, 0xd8, 0xd0, 0x2a, 0x68, 0x62, 0xa5,
	0x3e, 0x07, 0x14, 0x8f, 0x23, 0xf4, 0x3d, 0x37, 0xc4, 0xe8, 0x0b, 0x4a, 0xef, 0xa9, 0x44, 0xd4,
	0xc4, 0x6c, 0xd9, 0x11, 0x18, 0xf4, 0x11, 0xac, 0xba, 0xf8, 0x19, 0xd1, 0x63, 0xf1, 0xf0, 0x93,
	0x2f, 0x53, 0xf1, 0xa3, 0x28, 0x26, 0xb5, 0x0a, 0xa8, 0x4a, 0x5f, 0x86, 0xf3, 0x36, 0x99, 0xfc,
	0x65, 0x06, 0x96, 0x0e, 0x63, 0x23, 0x67, 0x8a, 0x75, 0x6d, 0x42, 0xd1, 0xc4, 0x61, 0x37, 0xb0,
	0xd9, 0x24, 0x61, 0x8c, 0xa3, 0xa0, 0xc5, 0x45, 0xa8, 0x05, 0x72, 0x34, 0xc6, 0x08, 0xee, 0xf9,
	0x8e, 0x41, 0x22, 0x5a, 0x30, 0x47, 0xdf, 0x58, 0x15, 0x26, 0x5a, 0xc2, 0x02, 0xfa, 0x22, 0x2a,
	0xb0, 0xcc, 0xec, 0x05, 0x76, 0xb2, 0x20, 0x4a, 0x0c, 0xbd, 0x07, 0xec, 0x89, 0x31, 0x6a, 0x9d,
	0x17, 0xbf, 0x41, 0x86, 0x92, 0x49, 0xfe, 0xb3, 0x38, 0x17, 0xff, 0x29, 0x41, 0xde, 0xb4, 0x43,
	0xa3, 0xe3, 0x60, 0x53, 0x29, 0x6c, 0x4a, 0x5b, 0x79, 0x6d, 0xb8, 0x46, 0xe6, 0xe4, 0x34, 0xe5,
	0x14, 0xef, 0xfe, 0x2c, 0xc1, 0x8b, 0x0b, 0x48, 0x1e, 0xaa, 0x6f, 0x3f, 0x40, 0x0f, 0x65, 0x58,
	0x11, 0xfc, 0x43, 0xa4, 0x5b, 0xfd, 0xb9, 0x04, 0xeb, 0xb1, 0x2e, 0x20, 0x82, 0x99, 0xb1, 0xa8,
	0x6a, 0x90, 0x13, 0xd7, 0x27, 0xda, 0xc1, 0x27, 0x73, 0x1c, 0x58, 0x8b, 0xb0, 0xea, 0x63, 0x58,
	0x8b, 0xfa, 0xc2, 0x7c, 0xfe, 0x37, 0x00, 0x62, 0x44, 0x8a, 0x9f, 0xb6, 0x40, 0x22, 0x0e, 0xa5,
	0x7e, 0x0e, 0xca, 0xf0, 0x91, 0x0a, 0xc3, 0x33, 0xf6, 0x0c, 0xd5, 0x84, 0xf5, 0xd7, 0x40, 0xc5,
	0x33, 0x3f, 0x86, 0xbc, 0x70, 0x12, 0x3d, 0xf4, 0xb9, 0xce, 0x3d, 0x04, 0xab, 0xdf, 0x81, 0xf5,
	0x23, 0xec, 0xe0, 0xff, 0x29, 0xf7, 0x09, 0x67, 0xff, 0x83, 0x04, 0xeb, 0x6d, 0xdf, 0x34, 0xfe,
	0x0f, 0xb6, 0xe3, 0xd7, 0x9e, 0x7e, 0x8b, 0x6b, 0xff, 0x7b, 0x5a, 0xb4, 0x20, 0xc1, 0x5a, 0x51,
	0x07, 0xd6, 0xa6, 0xb8, 0xf7, 0x68, 0xc4, 0xce, 0x3b, 0x1c, 0xaf, 0x4e, 0xb2, 0x6f, 0x36, 0x6e,
	0x7d, 0x4a, 0xab, 0x58, 0x12, 0xb0, 0xa9, 0x0f, 0x70, 0x60, 0x9f, 0x5f, 0xea, 0x9c, 0x2c, 0x8b,
	0x9f, 0x8f, 0xbb, 0x73, 0xf0, 0xec, 0xf2, 0x63, 0x66, 0x80, 0xaf, 0x28, 0xc5, 0x12, 0x86, 0xe3,
	0x62, 0xe4, 0xc1, 0x3b, 0xf1, 0x67, 0x1c, 0x79, 0xcb, 0x30, 0x6f, 0xf7, 0xe7, 0xf1, 0x16, 0x7f,
	0xfc, 0xc2, 0x27, 0x0a, 0xa7, 0x64, 0x6a, 0x19, 0x96, 0xc6, 0x02, 0x90, 0x61, 0xa9, 0xde, 0x68,
	0xe9, 0x8f, 0x6b, 0xda, 0xe9, 0x83, 0xd3, 0xda, 0x91, 0xbc, 0x80, 0x96, 0x20, 0x3f, 0x5c, 0x49,
	0xea, 0x9d, 0xf1, 0xb6, 0x22, 0x50, 0x2b, 0x00, 0x0f, 0xdb, 0xcd, 0x96, 0xfe, 0xf0, 0xa0, 0x55,
	0x3d, 0x91, 0x17, 0xd0, 0x2a, 0x14, 0x0f, 0xce, 0xce, 0x1a, 0x4f, 0xf4, 0xb3, 0x46, 0xa3, 0x59,
	0x93, 0xa5, 0x9d, 0x7f, 0x17, 0x01, 0xaa, 0x34, 0x58, 0xfe, 0xab, 0xfd, 0x37, 0x12, 0x14, 0x63,
	0x8d, 0x04, 0x6d, 0x27, 0x9c, 0x6c, 0x9a, 0x7a, 0x94, 0x36, 0x22, 0x48, 0xec, 0xbf, 0xec, 0xca,
	0x43, 0xaa, 0xad, 0x56, 0x7e, 0xf1, 0xcf, 0x7f, 0xfd, 0x36, 0xf5, 0xb1, 0xba, 0x59, 0x19, 0x6c,
	0x57, 0x44, 0xb1, 0x86, 0x95, 0x17, 0xa3, 0x42, 0x7e, 0x59, 0xe1, 0x93, 0x74, 0x4f, 0x0c, 0x83,
	0x5f, 0x4b, 0x90, 0x8f, 0x1a, 0x0b, 0x2a, 0x27, 0xc4, 0x33, 0xc1, 0x4c, 0x4a, 0x33, 0x0d, 0x1e,
	0xf5, 0x33, 0x16, 0xd3, 0xd7, 0xd1, 0x87, 0x49, 0x31, 0x55, 0x5e, 0xd8, 0xe6, 0x4b, 0xf4, 0x3b,
	0x09, 0x60, 0xc4, 0x1b, 0xd0, 0x37, 0x12, 0x7c, 0x4c, 0x51, 0x9d, 0xd2, 0xf6, 0x1c, 0x08, 0xde,
	0xad, 0xd4, 0x2d, 0x16, 0xa2, 0x8a, 0x12, 0xd3, 0x86, 0x7e, 0x4f, 0xaf, 0x70, 0xc4, 0x2c, 0x92,
	0xaf, 0x70, 0x8a, 0x85, 0xcc, 0x98, 0xb5, 0xbb, 0x2c, 0xa4, 0x6d, 0xf5, 0xd3, 0x99, 0xb2, 0xb6,
	0xd7, 0x65, 0x7e, 0xf6, 0xa4, 0x5b, 0xe8, 0xcf, 0xd2, 0x18, 0x67, 0x8d, 0xb8, 0xcb, 0xee, 0xec,
	0xb5, 0x36, 0xde, 0x08, 0x4b, 0xf3, 0x74, 0x2e, 0xf5, 0x36, 0x0b, 0xfb, 0x33, 0x55, 0x7d, 0x73,
	0xd8, 0x51, 0x6b, 0xdf, 0x8b, 0xba, 0x1c, 0xfa, 0x93, 0x34, 0x62, 0xbd, 0x51, 0xbc, 0x77, 0x66,
	0xac, 0xc5, 0xb7, 0x09, 0x56, 0xe4, 0x18, 0x55, 0x92, 0x83, 0xad, 0xbc, 0x18, 0x75, 0xfb, 0x97,
	0xe8, 0x2f, 0x71, 0x8e, 0x1d, 0xcd, 0x3e, 0x74, 0x77, 0xd6, 0xc2, 0x9b, 0x18, 0xb4, 0xa5, 0xdd,
	0xf9, 0x81, 0xa2, 0x70, 0x6f, 0xb1, 0x13, 0x7c, 0x80, 0x66, 0x48, 0x37, 0x2d, 0x5d, 0x34, 0x3d,
	0x4a, 0x13, 0x0b, 0xe3, 0x8d, 0xd3, 0xb7, 0xb4, 0x36, 0xc5, 0x0a, 0x6b, 0x3d, 0x9f, 0x5c, 0x46,
	0x69, 0xbd, 0x35, 0x77, 0x5a, 0xff, 0x21, 0x01, 0x9a, 0x1e, 0xc8, 0x89, 0x11, 0xbe, 0x71, 0x86,
	0xcf, 0x57, 0x0d, 0xfb, 0x2c, 0xec, 0xbd, 0x9d, 0x79, 0xc3, 0x1e, 0xd6, 0xf1, 0xe1, 0x53, 0x50,
	0xba, 0x5e, 0x2f, 0xf2, 0x39, 0xe6, 0xea, 0x91, 0xf4, 0xdd, 0x63, 0x21, 0xb7, 0x3c, 0xc7, 0x70,
	0xad, 0xb2, 0x17, 0x58, 0x15, 0x0b, 0xbb, 0x2c, 0x77, 0x15, 0xbe, 0x65, 0xf8, 0x76, 0xf8, 0x86,
	0x3f, 0xfc, 0xdc, 0x1b, 0xad, 0x5e, 0xa5, 0xd2, 0xc7, 0xd5, 0xc3, 0x4e, 0x96, 0x21, 0x6f, 0xff,
	0x27, 0x00, 0x00, 0xff, 0xff, 0x1b, 0x69, 0xcf, 0xc4, 0x31, 0x1a, 0x00, 0x00,
}
