// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

/*
Package admin is a generated protocol buffer package.

It is generated from these files:
	google/bigtable/admin/v2/bigtable_instance_admin.proto
	google/bigtable/admin/v2/bigtable_table_admin.proto
	google/bigtable/admin/v2/common.proto
	google/bigtable/admin/v2/instance.proto
	google/bigtable/admin/v2/table.proto

It has these top-level messages:
	CreateInstanceRequest
	GetInstanceRequest
	ListInstancesRequest
	ListInstancesResponse
	DeleteInstanceRequest
	CreateClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DeleteClusterRequest
	CreateInstanceMetadata
	UpdateClusterMetadata
	CreateTableRequest
	DropRowRangeRequest
	ListTablesRequest
	ListTablesResponse
	GetTableRequest
	DeleteTableRequest
	ModifyColumnFamiliesRequest
	Instance
	Cluster
	Table
	ColumnFamily
	GcRule
*/
package admin

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for BigtableInstanceAdmin.CreateInstance.
type CreateInstanceRequest struct {
	// The unique name of the project in which to create the new instance.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to be used when referring to the new instance within its project,
	// e.g., just `myinstance` rather than
	// `projects/myproject/instances/myinstance`.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId" json:"instance_id,omitempty"`
	// The instance to create.
	// Fields marked `OutputOnly` must be left blank.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance" json:"instance,omitempty"`
	// The clusters to be created within the instance, mapped by desired
	// cluster ID, e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	// Fields marked `OutputOnly` must be left blank.
	// Currently exactly one cluster must be specified.
	Clusters map[string]*Cluster `protobuf:"bytes,4,rep,name=clusters" json:"clusters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CreateInstanceRequest) Reset()                    { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()               {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *CreateInstanceRequest) GetClusters() map[string]*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetInstance.
type GetInstanceRequest struct {
	// The unique name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInstanceRequest) Reset()                    { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()               {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListInstances.
type ListInstancesRequest struct {
	// The unique name of the project for which a list of instances is requested.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListInstancesRequest) Reset()                    { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()               {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListInstances.
type ListInstancesResponse struct {
	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Locations from which Instance information could not be retrieved,
	// due to an outage or some other transient condition.
	// Instances whose Clusters are all in one of the failed locations
	// may be missing from `instances`, and Instances with at least one
	// Cluster in a failed location may only have partial information returned.
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations" json:"failed_locations,omitempty"`
	// Set if not all instances could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInstancesResponse) Reset()                    { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()               {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.DeleteInstance.
type DeleteInstanceRequest struct {
	// The unique name of the instance to be deleted.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteInstanceRequest) Reset()                    { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()               {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.CreateCluster.
type CreateClusterRequest struct {
	// The unique name of the instance in which to create the new cluster.
	// Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The ID to be used when referring to the new cluster within its instance,
	// e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The cluster to be created.
	// Fields marked `OutputOnly` must be left blank.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetCluster.
type GetClusterRequest struct {
	// The unique name of the requested cluster. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListClusters.
type ListClustersRequest struct {
	// The unique name of the instance for which a list of clusters is requested.
	// Values are of the form `projects/<project>/instances/<instance>`.
	// Use `<instance> = '-'` to list Clusters for all Instances in a project,
	// e.g., `projects/myproject/instances/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListClusters.
type ListClustersResponse struct {
	// The list of requested clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// Locations from which Cluster information could not be retrieved,
	// due to an outage or some other transient condition.
	// Clusters from these locations may be missing from `clusters`,
	// or may only have partial information returned.
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations" json:"failed_locations,omitempty"`
	// Set if not all clusters could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.DeleteCluster.
type DeleteClusterRequest struct {
	// The unique name of the cluster to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/<cluster>`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The metadata for the Operation returned by CreateInstance.
type CreateInstanceMetadata struct {
	// The request that prompted the initiation of this CreateInstance operation.
	OriginalRequest *CreateInstanceRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *CreateInstanceMetadata) Reset()                    { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string            { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()               {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateInstanceMetadata) GetOriginalRequest() *CreateInstanceRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateInstanceMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by UpdateCluster.
type UpdateClusterMetadata struct {
	// The request that prompted the initiation of this UpdateCluster operation.
	OriginalRequest *Cluster `protobuf:"bytes,1,opt,name=original_request,json=originalRequest" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *google_protobuf1.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime *google_protobuf1.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime" json:"finish_time,omitempty"`
}

func (m *UpdateClusterMetadata) Reset()                    { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()               {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *UpdateClusterMetadata) GetOriginalRequest() *Cluster {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *UpdateClusterMetadata) GetRequestTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *UpdateClusterMetadata) GetFinishTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.bigtable.admin.v2.CreateInstanceRequest")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.bigtable.admin.v2.GetInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.bigtable.admin.v2.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.bigtable.admin.v2.ListInstancesResponse")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.bigtable.admin.v2.DeleteInstanceRequest")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.bigtable.admin.v2.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.bigtable.admin.v2.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.bigtable.admin.v2.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.bigtable.admin.v2.ListClustersResponse")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.bigtable.admin.v2.DeleteClusterRequest")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "google.bigtable.admin.v2.CreateInstanceMetadata")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "google.bigtable.admin.v2.UpdateClusterMetadata")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for BigtableInstanceAdmin service

type BigtableInstanceAdminClient interface {
	// Create an instance within a project.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Updates an instance within a project.
	UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error)
	// Delete an instance from a project.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error)
}

type bigtableInstanceAdminClient struct {
	cc *grpc.ClientConn
}

func NewBigtableInstanceAdminClient(cc *grpc.ClientConn) BigtableInstanceAdminClient {
	return &bigtableInstanceAdminClient{cc}
}

func (c *bigtableInstanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_protobuf3.Empty, error) {
	out := new(google_protobuf3.Empty)
	err := grpc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for BigtableInstanceAdmin service

type BigtableInstanceAdminServer interface {
	// Create an instance within a project.
	CreateInstance(context.Context, *CreateInstanceRequest) (*google_longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Updates an instance within a project.
	UpdateInstance(context.Context, *Instance) (*Instance, error)
	// Delete an instance from a project.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*google_protobuf3.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(context.Context, *Cluster) (*google_longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_protobuf3.Empty, error)
}

func RegisterBigtableInstanceAdminServer(s *grpc.Server, srv BigtableInstanceAdminServer) {
	s.RegisterService(&_BigtableInstanceAdmin_serviceDesc, srv)
}

func _BigtableInstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Instance)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, req.(*Instance))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, req.(*Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableInstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableInstanceAdmin",
	HandlerType: (*BigtableInstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInstance",
			Handler:    _BigtableInstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BigtableInstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _BigtableInstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BigtableInstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _BigtableInstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _BigtableInstanceAdmin_CreateCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _BigtableInstanceAdmin_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _BigtableInstanceAdmin_ListClusters_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _BigtableInstanceAdmin_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _BigtableInstanceAdmin_DeleteCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_instance_admin.proto",
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/bigtable_instance_admin.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 985 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x41, 0x8f, 0xdb, 0x44,
	0x14, 0xd6, 0x24, 0xa5, 0x34, 0xcf, 0xcd, 0xee, 0x32, 0x6c, 0x56, 0x91, 0x69, 0xd5, 0xad, 0x2b,
	0xb5, 0x69, 0xba, 0xd8, 0x22, 0x20, 0x16, 0xed, 0x2a, 0x08, 0xb6, 0x54, 0xd5, 0x4a, 0x5b, 0xb1,
	0x8a, 0xca, 0x81, 0x1e, 0x88, 0x66, 0x93, 0x59, 0x63, 0xea, 0x8c, 0x8d, 0x3d, 0x59, 0xb1, 0xaa,
	0x7a, 0x41, 0x88, 0x43, 0x25, 0x38, 0xc0, 0x11, 0x71, 0xe2, 0xc2, 0x81, 0x7f, 0xc2, 0x91, 0x23,
	0x27, 0x24, 0x7e, 0x00, 0x3f, 0x01, 0x8d, 0x67, 0xc6, 0x89, 0xb3, 0x76, 0xec, 0x08, 0x21, 0xf5,
	0x66, 0xcf, 0xbc, 0xf7, 0xe6, 0x9b, 0xef, 0xfb, 0xfc, 0x5e, 0x02, 0xef, 0xba, 0x41, 0xe0, 0xfa,
	0xd4, 0x39, 0xf1, 0x5c, 0x4e, 0x4e, 0x7c, 0xea, 0x90, 0xf1, 0xc4, 0x63, 0xce, 0x59, 0x2f, 0x5d,
	0x19, 0x7a, 0x2c, 0xe6, 0x84, 0x8d, 0xe8, 0x30, 0xd9, 0xb2, 0xc3, 0x28, 0xe0, 0x01, 0x6e, 0xcb,
	0x3c, 0x5b, 0x47, 0xd9, 0x72, 0xf3, 0xac, 0x67, 0x5e, 0x53, 0x15, 0x49, 0xe8, 0x39, 0x84, 0xb1,
	0x80, 0x13, 0xee, 0x05, 0x2c, 0x96, 0x79, 0xe6, 0x9d, 0xc2, 0xf3, 0xf4, 0x31, 0x2a, 0xf0, 0x96,
	0x0a, 0xf4, 0x03, 0xe6, 0x46, 0x53, 0xc6, 0x3c, 0xe6, 0x3a, 0x41, 0x48, 0xa3, 0x4c, 0xb5, 0x37,
	0x54, 0x50, 0xf2, 0x76, 0x32, 0x3d, 0x75, 0xe8, 0x24, 0xe4, 0xe7, 0x6a, 0xf3, 0xc6, 0xe2, 0x26,
	0xf7, 0x26, 0x34, 0xe6, 0x64, 0x12, 0xca, 0x00, 0xeb, 0xf7, 0x1a, 0xb4, 0xee, 0x47, 0x94, 0x70,
	0x7a, 0xa8, 0xce, 0x1e, 0xd0, 0x2f, 0xa7, 0x34, 0xe6, 0x78, 0x0b, 0x2e, 0x87, 0x24, 0xa2, 0x8c,
	0xb7, 0xd1, 0x36, 0xea, 0x34, 0x06, 0xea, 0x0d, 0xdf, 0x00, 0x23, 0x65, 0xc3, 0x1b, 0xb7, 0x6b,
	0xc9, 0x26, 0xe8, 0xa5, 0xc3, 0x31, 0x7e, 0x1f, 0xae, 0xe8, 0xb7, 0x76, 0x7d, 0x1b, 0x75, 0x8c,
	0x9e, 0x65, 0x17, 0x31, 0x65, 0xa7, 0xa7, 0xa6, 0x39, 0xf8, 0x53, 0xb8, 0x32, 0xf2, 0xa7, 0x31,
	0xa7, 0x51, 0xdc, 0xbe, 0xb4, 0x5d, 0xef, 0x18, 0xbd, 0x7e, 0x71, 0x7e, 0x2e, 0x76, 0xfb, 0xbe,
	0xca, 0x7f, 0xc0, 0x78, 0x74, 0x3e, 0x48, 0xcb, 0x99, 0x9f, 0x41, 0x33, 0xb3, 0x85, 0x37, 0xa0,
	0xfe, 0x94, 0x9e, 0xab, 0x1b, 0x8a, 0x47, 0xbc, 0x0b, 0xaf, 0x9c, 0x11, 0x7f, 0x4a, 0x93, 0x8b,
	0x19, 0xbd, 0x9b, 0x4b, 0x8e, 0x96, 0x95, 0x06, 0x32, 0x7e, 0xaf, 0xf6, 0x1e, 0xb2, 0x3a, 0x80,
	0x1f, 0x52, 0xbe, 0xc8, 0x24, 0x86, 0x4b, 0x8c, 0x4c, 0xa8, 0x3a, 0x25, 0x79, 0xb6, 0x1e, 0xc1,
	0xe6, 0x91, 0x17, 0xa7, 0xa1, 0x71, 0x19, 0xeb, 0xd7, 0x01, 0x42, 0xe2, 0xd2, 0x21, 0x0f, 0x9e,
	0x52, 0xa6, 0x48, 0x6f, 0x88, 0x95, 0xc7, 0x62, 0xc1, 0xfa, 0x0d, 0x41, 0x6b, 0xa1, 0x5e, 0x1c,
	0x06, 0x2c, 0xa6, 0xf8, 0x03, 0x68, 0x68, 0x66, 0xe3, 0x36, 0x4a, 0xe8, 0xac, 0x22, 0xc7, 0x2c,
	0x09, 0xdf, 0x85, 0x8d, 0x53, 0xe2, 0xf9, 0x74, 0x3c, 0xf4, 0x83, 0x91, 0xb4, 0x5e, 0xbb, 0xb6,
	0x5d, 0xef, 0x34, 0x06, 0xeb, 0x72, 0xfd, 0x48, 0x2f, 0xe3, 0xdb, 0xb0, 0xce, 0xe8, 0x57, 0x7c,
	0x38, 0x07, 0xb5, 0x9e, 0x40, 0x6d, 0x8a, 0xe5, 0xe3, 0x14, 0xee, 0x3d, 0x68, 0x7d, 0x44, 0x7d,
	0x7a, 0xd1, 0x74, 0x79, 0x54, 0xbd, 0x40, 0xb0, 0x29, 0x65, 0xd6, 0x8c, 0x97, 0x73, 0xa5, 0x14,
	0x9f, 0x19, 0xb4, 0xa1, 0x56, 0x0e, 0xc7, 0x78, 0x1f, 0x5e, 0x55, 0x2f, 0xca, 0x9e, 0x15, 0x34,
	0xd6, 0x19, 0xd6, 0x1d, 0x78, 0xed, 0x21, 0xe5, 0x0b, 0x40, 0xf2, 0x50, 0x1f, 0xc1, 0xeb, 0x42,
	0x10, 0x6d, 0xb7, 0xff, 0xa8, 0xef, 0xaf, 0x48, 0xfa, 0x65, 0x56, 0x4e, 0xc9, 0xdb, 0x9f, 0xfb,
	0x58, 0xa4, 0xba, 0x15, 0x6e, 0x93, 0xa6, 0xfc, 0x1f, 0xda, 0x76, 0x61, 0x53, 0x6a, 0x5b, 0x81,
	0xa4, 0x7f, 0x10, 0x6c, 0x65, 0xbf, 0xe0, 0x47, 0x94, 0x93, 0x31, 0xe1, 0x04, 0x3f, 0x81, 0x8d,
	0x20, 0xf2, 0x5c, 0x8f, 0x11, 0x7f, 0x18, 0xc9, 0x12, 0x49, 0xaa, 0xd1, 0x73, 0x56, 0xec, 0x06,
	0x83, 0x75, 0x5d, 0x48, 0x43, 0xe9, 0xc3, 0x55, 0x55, 0x72, 0x28, 0xfa, 0xa1, 0xfa, 0xd4, 0x4d,
	0x5d, 0x57, 0x37, 0x4b, 0xfb, 0xb1, 0x6e, 0x96, 0x03, 0x43, 0xc5, 0x8b, 0x15, 0xbc, 0x0f, 0xc6,
	0xa9, 0xc7, 0xbc, 0xf8, 0x73, 0x99, 0x5d, 0x2f, 0xcd, 0x06, 0x19, 0x2e, 0x16, 0xac, 0xbf, 0x10,
	0xb4, 0x3e, 0x09, 0xc7, 0x33, 0x37, 0xa7, 0x37, 0x3e, 0x2a, 0xbc, 0x71, 0x05, 0x49, 0x5f, 0xa6,
	0x3b, 0xf6, 0xfe, 0x34, 0xa0, 0x75, 0xa0, 0xa0, 0x6a, 0x31, 0x3e, 0x14, 0x88, 0xf1, 0xf7, 0x08,
	0xd6, 0xb2, 0x22, 0xe1, 0x55, 0xe5, 0x34, 0xaf, 0xeb, 0x84, 0xb9, 0xb1, 0x68, 0x7f, 0xac, 0xc7,
	0xa2, 0xb5, 0xf3, 0xf5, 0x1f, 0x7f, 0xff, 0x58, 0xbb, 0x6d, 0xdd, 0x14, 0x03, 0xf5, 0x99, 0xfc,
	0xbc, 0xfa, 0x61, 0x14, 0x7c, 0x41, 0x47, 0x3c, 0x76, 0xba, 0xcf, 0xd3, 0x21, 0x1b, 0xef, 0xa1,
	0x2e, 0x7e, 0x81, 0xc0, 0x98, 0x6b, 0xd9, 0x78, 0xa7, 0x18, 0xcd, 0xc5, 0xce, 0x6e, 0x56, 0xe8,
	0xa4, 0xd6, 0xdd, 0x04, 0xcf, 0x2d, 0x2c, 0xf1, 0x08, 0xdb, 0xcf, 0xa1, 0x99, 0x81, 0x71, 0xba,
	0xcf, 0xf1, 0x4f, 0x08, 0x9a, 0x99, 0x2e, 0x8e, 0xed, 0xe2, 0x03, 0xf2, 0xc6, 0x87, 0xe9, 0x54,
	0x8e, 0x97, 0xfd, 0x63, 0x01, 0xdd, 0x32, 0xb6, 0xf0, 0xb7, 0x08, 0xd6, 0xa4, 0x73, 0x53, 0xb6,
	0x2a, 0xdc, 0xbf, 0x12, 0x47, 0x4a, 0x33, 0xb3, 0x9c, 0x23, 0xa1, 0xd9, 0x37, 0x08, 0xd6, 0xb2,
	0xe3, 0x63, 0x99, 0x89, 0x72, 0x07, 0x8d, 0xb9, 0x75, 0xc1, 0xca, 0x0f, 0xc4, 0xcf, 0x26, 0xcd,
	0x47, 0xb7, 0x82, 0x5a, 0x3f, 0x23, 0x68, 0x66, 0xe6, 0xd2, 0x32, 0xb5, 0xf2, 0x06, 0x58, 0x99,
	0x93, 0xfb, 0x09, 0x96, 0x5d, 0x6b, 0x27, 0x5f, 0x9b, 0x0c, 0x1a, 0x47, 0xb7, 0xf4, 0x3d, 0x3d,
	0xaa, 0xf0, 0x0f, 0x08, 0x60, 0x36, 0xab, 0xf0, 0xbd, 0xa5, 0xce, 0x5e, 0x40, 0x56, 0xde, 0x71,
	0xac, 0x77, 0x12, 0x74, 0x36, 0xde, 0x29, 0x63, 0x2a, 0x85, 0x26, 0x48, 0xfb, 0x05, 0xc1, 0xd5,
	0xf9, 0x41, 0x86, 0xdf, 0x5c, 0xee, 0xd8, 0x85, 0xf9, 0x69, 0xda, 0x55, 0xc3, 0x95, 0xbf, 0xb3,
	0x28, 0x2b, 0x72, 0x28, 0xba, 0x42, 0x33, 0xd3, 0xa4, 0x71, 0x39, 0x21, 0x65, 0x6a, 0xee, 0x26,
	0x48, 0xde, 0x32, 0x57, 0xe2, 0x4b, 0xd8, 0xfd, 0x3b, 0x04, 0xcd, 0xcc, 0x44, 0x5d, 0xe6, 0xb3,
	0xbc, 0xd1, 0x5b, 0x68, 0x76, 0x45, 0x4e, 0x77, 0x25, 0x48, 0x07, 0xcf, 0xe0, 0xda, 0x28, 0x98,
	0x14, 0x42, 0x38, 0x30, 0x73, 0x5b, 0xff, 0xb1, 0x38, 0xfa, 0x18, 0x3d, 0xe9, 0xab, 0x3c, 0x37,
	0xf0, 0x09, 0x73, 0xed, 0x20, 0x72, 0x1d, 0x97, 0xb2, 0x04, 0x98, 0x23, 0xb7, 0x48, 0xe8, 0xc5,
	0x17, 0xff, 0x1b, 0xed, 0x27, 0x0f, 0x27, 0x97, 0x93, 0xc8, 0xb7, 0xff, 0x0d, 0x00, 0x00, 0xff,
	0xff, 0xb8, 0x4b, 0x18, 0x4a, 0xb4, 0x0d, 0x00, 0x00,
}
