// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package datalabeling // import "google.golang.org/genproto/googleapis/cloud/datalabeling/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Image labeling task feature.
type LabelImageRequest_Feature int32

const (
	LabelImageRequest_FEATURE_UNSPECIFIED LabelImageRequest_Feature = 0
	// Label whole image with one or more of labels.
	LabelImageRequest_CLASSIFICATION LabelImageRequest_Feature = 1
	// Label image with bounding boxes for labels.
	LabelImageRequest_BOUNDING_BOX LabelImageRequest_Feature = 2
	// Label oriented bounding box. The box does not have to be parallel to
	// horizontal line.
	LabelImageRequest_ORIENTED_BOUNDING_BOX LabelImageRequest_Feature = 6
	// Label images with bounding poly. A bounding poly is a plane figure that
	// is bounded by a finite chain of straight line segments closing in a loop.
	LabelImageRequest_BOUNDING_POLY LabelImageRequest_Feature = 3
	// Label images with polyline. Polyline is formed by connected line segments
	// which are not in closed form.
	LabelImageRequest_POLYLINE LabelImageRequest_Feature = 4
	// Label images with segmentation. Segmentation is different from bounding
	// poly since it is more fine-grained, pixel level annotation.
	LabelImageRequest_SEGMENTATION LabelImageRequest_Feature = 5
)

var LabelImageRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "CLASSIFICATION",
	2: "BOUNDING_BOX",
	6: "ORIENTED_BOUNDING_BOX",
	3: "BOUNDING_POLY",
	4: "POLYLINE",
	5: "SEGMENTATION",
}
var LabelImageRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":   0,
	"CLASSIFICATION":        1,
	"BOUNDING_BOX":          2,
	"ORIENTED_BOUNDING_BOX": 6,
	"BOUNDING_POLY":         3,
	"POLYLINE":              4,
	"SEGMENTATION":          5,
}

func (x LabelImageRequest_Feature) String() string {
	return proto.EnumName(LabelImageRequest_Feature_name, int32(x))
}
func (LabelImageRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{14, 0}
}

// Video labeling task feature.
type LabelVideoRequest_Feature int32

const (
	LabelVideoRequest_FEATURE_UNSPECIFIED LabelVideoRequest_Feature = 0
	// Label whole video or video segment with one or more labels.
	LabelVideoRequest_CLASSIFICATION LabelVideoRequest_Feature = 1
	// Label objects with bounding box on image frames extracted from the video.
	LabelVideoRequest_OBJECT_DETECTION LabelVideoRequest_Feature = 2
	// Label and track objects in video.
	LabelVideoRequest_OBJECT_TRACKING LabelVideoRequest_Feature = 3
	// Label the range of video for the specified events.
	LabelVideoRequest_EVENT LabelVideoRequest_Feature = 4
)

var LabelVideoRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "CLASSIFICATION",
	2: "OBJECT_DETECTION",
	3: "OBJECT_TRACKING",
	4: "EVENT",
}
var LabelVideoRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED": 0,
	"CLASSIFICATION":      1,
	"OBJECT_DETECTION":    2,
	"OBJECT_TRACKING":     3,
	"EVENT":               4,
}

func (x LabelVideoRequest_Feature) String() string {
	return proto.EnumName(LabelVideoRequest_Feature_name, int32(x))
}
func (LabelVideoRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{15, 0}
}

// Text labeling task feature.
type LabelTextRequest_Feature int32

const (
	LabelTextRequest_FEATURE_UNSPECIFIED LabelTextRequest_Feature = 0
	// Label text content to one of more labels.
	LabelTextRequest_TEXT_CLASSIFICATION LabelTextRequest_Feature = 1
	// Label entities and their span in text.
	LabelTextRequest_TEXT_ENTITY_EXTRACTION LabelTextRequest_Feature = 2
)

var LabelTextRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "TEXT_CLASSIFICATION",
	2: "TEXT_ENTITY_EXTRACTION",
}
var LabelTextRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":    0,
	"TEXT_CLASSIFICATION":    1,
	"TEXT_ENTITY_EXTRACTION": 2,
}

func (x LabelTextRequest_Feature) String() string {
	return proto.EnumName(LabelTextRequest_Feature_name, int32(x))
}
func (LabelTextRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{16, 0}
}

// Audio labeling task feature.
type LabelAudioRequest_Feature int32

const (
	LabelAudioRequest_FEATURE_UNSPECIFIED LabelAudioRequest_Feature = 0
	// Transcribe the audios into text.
	LabelAudioRequest_AUDIO_TRANSCRIPTION LabelAudioRequest_Feature = 1
)

var LabelAudioRequest_Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "AUDIO_TRANSCRIPTION",
}
var LabelAudioRequest_Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED": 0,
	"AUDIO_TRANSCRIPTION": 1,
}

func (x LabelAudioRequest_Feature) String() string {
	return proto.EnumName(LabelAudioRequest_Feature_name, int32(x))
}
func (LabelAudioRequest_Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{17, 0}
}

// Request message for CreateDataset.
type CreateDatasetRequest struct {
	// Required. Dataset resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The dataset to be created.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{0}
}
func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(dst, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for GetDataSet.
type GetDatasetRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{1}
}
func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(dst, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDataset.
type ListDatasetsRequest struct {
	// Required. Dataset resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter on dataset is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListDatasetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListDatasetsResponse.next_page_token] of the previous
	// [DataLabelingService.ListDatasets] call.
	// Returns the first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{2}
}
func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(dst, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing datasets within a project.
type ListDatasetsResponse struct {
	// The list of datasets to return.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{3}
}
func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(dst, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteDataset.
type DeleteDatasetRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{4}
}
func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(dst, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ImportData API.
type ImportDataRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify the input source of the data.
	InputConfig          *InputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{5}
}
func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (dst *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(dst, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Request message for ExportData API.
type ExportDataRequest struct {
	// Required. Dataset resource name, format:
	// projects/{project_id}/datasets/{dataset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Annotated dataset resource name. DataItem in
	// Dataset and their annotations in specified annotated dataset will be
	// exported. It's in format of
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	AnnotatedDataset string `protobuf:"bytes,2,opt,name=annotated_dataset,json=annotatedDataset,proto3" json:"annotated_dataset,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. Specify the output destination.
	OutputConfig         *OutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{6}
}
func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (dst *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(dst, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetAnnotatedDataset() string {
	if m != nil {
		return m.AnnotatedDataset
	}
	return ""
}

func (m *ExportDataRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for GetDataItem.
type GetDataItemRequest struct {
	// Required. The name of the data item to get, format:
	// projects/{project_id}/datasets/{dataset_id}/dataItems/{data_item_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDataItemRequest) Reset()         { *m = GetDataItemRequest{} }
func (m *GetDataItemRequest) String() string { return proto.CompactTextString(m) }
func (*GetDataItemRequest) ProtoMessage()    {}
func (*GetDataItemRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{7}
}
func (m *GetDataItemRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDataItemRequest.Unmarshal(m, b)
}
func (m *GetDataItemRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDataItemRequest.Marshal(b, m, deterministic)
}
func (dst *GetDataItemRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDataItemRequest.Merge(dst, src)
}
func (m *GetDataItemRequest) XXX_Size() int {
	return xxx_messageInfo_GetDataItemRequest.Size(m)
}
func (m *GetDataItemRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDataItemRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDataItemRequest proto.InternalMessageInfo

func (m *GetDataItemRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListDataItems.
type ListDataItemsRequest struct {
	// Required. Name of the dataset to list data items, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListDataItemsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListDataItemsResponse.next_page_token] of the previous
	// [DataLabelingService.ListDataItems] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataItemsRequest) Reset()         { *m = ListDataItemsRequest{} }
func (m *ListDataItemsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDataItemsRequest) ProtoMessage()    {}
func (*ListDataItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{8}
}
func (m *ListDataItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataItemsRequest.Unmarshal(m, b)
}
func (m *ListDataItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataItemsRequest.Marshal(b, m, deterministic)
}
func (dst *ListDataItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataItemsRequest.Merge(dst, src)
}
func (m *ListDataItemsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDataItemsRequest.Size(m)
}
func (m *ListDataItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataItemsRequest proto.InternalMessageInfo

func (m *ListDataItemsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDataItemsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDataItemsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDataItemsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing data items in a dataset.
type ListDataItemsResponse struct {
	// The list of data items to return.
	DataItems []*DataItem `protobuf:"bytes,1,rep,name=data_items,json=dataItems,proto3" json:"data_items,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataItemsResponse) Reset()         { *m = ListDataItemsResponse{} }
func (m *ListDataItemsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDataItemsResponse) ProtoMessage()    {}
func (*ListDataItemsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{9}
}
func (m *ListDataItemsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataItemsResponse.Unmarshal(m, b)
}
func (m *ListDataItemsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataItemsResponse.Marshal(b, m, deterministic)
}
func (dst *ListDataItemsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataItemsResponse.Merge(dst, src)
}
func (m *ListDataItemsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDataItemsResponse.Size(m)
}
func (m *ListDataItemsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataItemsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataItemsResponse proto.InternalMessageInfo

func (m *ListDataItemsResponse) GetDataItems() []*DataItem {
	if m != nil {
		return m.DataItems
	}
	return nil
}

func (m *ListDataItemsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for GetAnnotatedDataset.
type GetAnnotatedDatasetRequest struct {
	// Required. Name of the annotated dataset to get, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotatedDatasetRequest) Reset()         { *m = GetAnnotatedDatasetRequest{} }
func (m *GetAnnotatedDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotatedDatasetRequest) ProtoMessage()    {}
func (*GetAnnotatedDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{10}
}
func (m *GetAnnotatedDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Unmarshal(m, b)
}
func (m *GetAnnotatedDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *GetAnnotatedDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotatedDatasetRequest.Merge(dst, src)
}
func (m *GetAnnotatedDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotatedDatasetRequest.Size(m)
}
func (m *GetAnnotatedDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotatedDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotatedDatasetRequest proto.InternalMessageInfo

func (m *GetAnnotatedDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListAnnotatedDatasets.
type ListAnnotatedDatasetsRequest struct {
	// Required. Name of the dataset to list annotated datasets, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListAnnotatedDatasetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsResponse.next_page_token] of the previous
	// [DataLabelingService.ListAnnotatedDatasets] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotatedDatasetsRequest) Reset()         { *m = ListAnnotatedDatasetsRequest{} }
func (m *ListAnnotatedDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAnnotatedDatasetsRequest) ProtoMessage()    {}
func (*ListAnnotatedDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{11}
}
func (m *ListAnnotatedDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Unmarshal(m, b)
}
func (m *ListAnnotatedDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListAnnotatedDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotatedDatasetsRequest.Merge(dst, src)
}
func (m *ListAnnotatedDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAnnotatedDatasetsRequest.Size(m)
}
func (m *ListAnnotatedDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotatedDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotatedDatasetsRequest proto.InternalMessageInfo

func (m *ListAnnotatedDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAnnotatedDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAnnotatedDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAnnotatedDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Request message for DeleteAnnotatedDataset.
type DeleteAnnotatedDatasetRequest struct {
	// Required. Name of the annotated dataset to delete, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAnnotatedDatasetRequest) Reset()         { *m = DeleteAnnotatedDatasetRequest{} }
func (m *DeleteAnnotatedDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAnnotatedDatasetRequest) ProtoMessage()    {}
func (*DeleteAnnotatedDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{12}
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteAnnotatedDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAnnotatedDatasetRequest.Merge(dst, src)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAnnotatedDatasetRequest.Size(m)
}
func (m *DeleteAnnotatedDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAnnotatedDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAnnotatedDatasetRequest proto.InternalMessageInfo

func (m *DeleteAnnotatedDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Results of listing annotated datasets for a dataset.
type ListAnnotatedDatasetsResponse struct {
	// The list of annotated datasets to return.
	AnnotatedDatasets []*AnnotatedDataset `protobuf:"bytes,1,rep,name=annotated_datasets,json=annotatedDatasets,proto3" json:"annotated_datasets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotatedDatasetsResponse) Reset()         { *m = ListAnnotatedDatasetsResponse{} }
func (m *ListAnnotatedDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAnnotatedDatasetsResponse) ProtoMessage()    {}
func (*ListAnnotatedDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{13}
}
func (m *ListAnnotatedDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Unmarshal(m, b)
}
func (m *ListAnnotatedDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListAnnotatedDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotatedDatasetsResponse.Merge(dst, src)
}
func (m *ListAnnotatedDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAnnotatedDatasetsResponse.Size(m)
}
func (m *ListAnnotatedDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotatedDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotatedDatasetsResponse proto.InternalMessageInfo

func (m *ListAnnotatedDatasetsResponse) GetAnnotatedDatasets() []*AnnotatedDataset {
	if m != nil {
		return m.AnnotatedDatasets
	}
	return nil
}

func (m *ListAnnotatedDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for starting an image labeling task.
type LabelImageRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelImageRequest_ImageClassificationConfig
	//	*LabelImageRequest_BoundingPolyConfig
	//	*LabelImageRequest_PolylineConfig
	//	*LabelImageRequest_SegmentationConfig
	RequestConfig isLabelImageRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the dataset to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of image labeling task.
	Feature              LabelImageRequest_Feature `protobuf:"varint,3,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelImageRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *LabelImageRequest) Reset()         { *m = LabelImageRequest{} }
func (m *LabelImageRequest) String() string { return proto.CompactTextString(m) }
func (*LabelImageRequest) ProtoMessage()    {}
func (*LabelImageRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{14}
}
func (m *LabelImageRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelImageRequest.Unmarshal(m, b)
}
func (m *LabelImageRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelImageRequest.Marshal(b, m, deterministic)
}
func (dst *LabelImageRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelImageRequest.Merge(dst, src)
}
func (m *LabelImageRequest) XXX_Size() int {
	return xxx_messageInfo_LabelImageRequest.Size(m)
}
func (m *LabelImageRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelImageRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelImageRequest proto.InternalMessageInfo

type isLabelImageRequest_RequestConfig interface {
	isLabelImageRequest_RequestConfig()
}

type LabelImageRequest_ImageClassificationConfig struct {
	ImageClassificationConfig *ImageClassificationConfig `protobuf:"bytes,4,opt,name=image_classification_config,json=imageClassificationConfig,proto3,oneof"`
}

type LabelImageRequest_BoundingPolyConfig struct {
	BoundingPolyConfig *BoundingPolyConfig `protobuf:"bytes,5,opt,name=bounding_poly_config,json=boundingPolyConfig,proto3,oneof"`
}

type LabelImageRequest_PolylineConfig struct {
	PolylineConfig *PolylineConfig `protobuf:"bytes,6,opt,name=polyline_config,json=polylineConfig,proto3,oneof"`
}

type LabelImageRequest_SegmentationConfig struct {
	SegmentationConfig *SegmentationConfig `protobuf:"bytes,7,opt,name=segmentation_config,json=segmentationConfig,proto3,oneof"`
}

func (*LabelImageRequest_ImageClassificationConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_BoundingPolyConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_PolylineConfig) isLabelImageRequest_RequestConfig() {}

func (*LabelImageRequest_SegmentationConfig) isLabelImageRequest_RequestConfig() {}

func (m *LabelImageRequest) GetRequestConfig() isLabelImageRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelImageRequest) GetImageClassificationConfig() *ImageClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_ImageClassificationConfig); ok {
		return x.ImageClassificationConfig
	}
	return nil
}

func (m *LabelImageRequest) GetBoundingPolyConfig() *BoundingPolyConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_BoundingPolyConfig); ok {
		return x.BoundingPolyConfig
	}
	return nil
}

func (m *LabelImageRequest) GetPolylineConfig() *PolylineConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_PolylineConfig); ok {
		return x.PolylineConfig
	}
	return nil
}

func (m *LabelImageRequest) GetSegmentationConfig() *SegmentationConfig {
	if x, ok := m.GetRequestConfig().(*LabelImageRequest_SegmentationConfig); ok {
		return x.SegmentationConfig
	}
	return nil
}

func (m *LabelImageRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelImageRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelImageRequest) GetFeature() LabelImageRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelImageRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LabelImageRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LabelImageRequest_OneofMarshaler, _LabelImageRequest_OneofUnmarshaler, _LabelImageRequest_OneofSizer, []interface{}{
		(*LabelImageRequest_ImageClassificationConfig)(nil),
		(*LabelImageRequest_BoundingPolyConfig)(nil),
		(*LabelImageRequest_PolylineConfig)(nil),
		(*LabelImageRequest_SegmentationConfig)(nil),
	}
}

func _LabelImageRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LabelImageRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelImageRequest_ImageClassificationConfig:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ImageClassificationConfig); err != nil {
			return err
		}
	case *LabelImageRequest_BoundingPolyConfig:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BoundingPolyConfig); err != nil {
			return err
		}
	case *LabelImageRequest_PolylineConfig:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PolylineConfig); err != nil {
			return err
		}
	case *LabelImageRequest_SegmentationConfig:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SegmentationConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LabelImageRequest.RequestConfig has unexpected type %T", x)
	}
	return nil
}

func _LabelImageRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LabelImageRequest)
	switch tag {
	case 4: // request_config.image_classification_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImageClassificationConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelImageRequest_ImageClassificationConfig{msg}
		return true, err
	case 5: // request_config.bounding_poly_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BoundingPolyConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelImageRequest_BoundingPolyConfig{msg}
		return true, err
	case 6: // request_config.polyline_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolylineConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelImageRequest_PolylineConfig{msg}
		return true, err
	case 7: // request_config.segmentation_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SegmentationConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelImageRequest_SegmentationConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LabelImageRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LabelImageRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelImageRequest_ImageClassificationConfig:
		s := proto.Size(x.ImageClassificationConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelImageRequest_BoundingPolyConfig:
		s := proto.Size(x.BoundingPolyConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelImageRequest_PolylineConfig:
		s := proto.Size(x.PolylineConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelImageRequest_SegmentationConfig:
		s := proto.Size(x.SegmentationConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for LabelVideo.
type LabelVideoRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelVideoRequest_VideoClassificationConfig
	//	*LabelVideoRequest_ObjectDetectionConfig
	//	*LabelVideoRequest_ObjectTrackingConfig
	//	*LabelVideoRequest_EventConfig
	RequestConfig isLabelVideoRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the dataset to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of video labeling task.
	Feature              LabelVideoRequest_Feature `protobuf:"varint,3,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelVideoRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *LabelVideoRequest) Reset()         { *m = LabelVideoRequest{} }
func (m *LabelVideoRequest) String() string { return proto.CompactTextString(m) }
func (*LabelVideoRequest) ProtoMessage()    {}
func (*LabelVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{15}
}
func (m *LabelVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelVideoRequest.Unmarshal(m, b)
}
func (m *LabelVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelVideoRequest.Marshal(b, m, deterministic)
}
func (dst *LabelVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelVideoRequest.Merge(dst, src)
}
func (m *LabelVideoRequest) XXX_Size() int {
	return xxx_messageInfo_LabelVideoRequest.Size(m)
}
func (m *LabelVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelVideoRequest proto.InternalMessageInfo

type isLabelVideoRequest_RequestConfig interface {
	isLabelVideoRequest_RequestConfig()
}

type LabelVideoRequest_VideoClassificationConfig struct {
	VideoClassificationConfig *VideoClassificationConfig `protobuf:"bytes,4,opt,name=video_classification_config,json=videoClassificationConfig,proto3,oneof"`
}

type LabelVideoRequest_ObjectDetectionConfig struct {
	ObjectDetectionConfig *ObjectDetectionConfig `protobuf:"bytes,5,opt,name=object_detection_config,json=objectDetectionConfig,proto3,oneof"`
}

type LabelVideoRequest_ObjectTrackingConfig struct {
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,6,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

type LabelVideoRequest_EventConfig struct {
	EventConfig *EventConfig `protobuf:"bytes,7,opt,name=event_config,json=eventConfig,proto3,oneof"`
}

func (*LabelVideoRequest_VideoClassificationConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_ObjectDetectionConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_ObjectTrackingConfig) isLabelVideoRequest_RequestConfig() {}

func (*LabelVideoRequest_EventConfig) isLabelVideoRequest_RequestConfig() {}

func (m *LabelVideoRequest) GetRequestConfig() isLabelVideoRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetVideoClassificationConfig() *VideoClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_VideoClassificationConfig); ok {
		return x.VideoClassificationConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetObjectDetectionConfig() *ObjectDetectionConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_ObjectDetectionConfig); ok {
		return x.ObjectDetectionConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetEventConfig() *EventConfig {
	if x, ok := m.GetRequestConfig().(*LabelVideoRequest_EventConfig); ok {
		return x.EventConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelVideoRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelVideoRequest) GetFeature() LabelVideoRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelVideoRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LabelVideoRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LabelVideoRequest_OneofMarshaler, _LabelVideoRequest_OneofUnmarshaler, _LabelVideoRequest_OneofSizer, []interface{}{
		(*LabelVideoRequest_VideoClassificationConfig)(nil),
		(*LabelVideoRequest_ObjectDetectionConfig)(nil),
		(*LabelVideoRequest_ObjectTrackingConfig)(nil),
		(*LabelVideoRequest_EventConfig)(nil),
	}
}

func _LabelVideoRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LabelVideoRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelVideoRequest_VideoClassificationConfig:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VideoClassificationConfig); err != nil {
			return err
		}
	case *LabelVideoRequest_ObjectDetectionConfig:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ObjectDetectionConfig); err != nil {
			return err
		}
	case *LabelVideoRequest_ObjectTrackingConfig:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ObjectTrackingConfig); err != nil {
			return err
		}
	case *LabelVideoRequest_EventConfig:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EventConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LabelVideoRequest.RequestConfig has unexpected type %T", x)
	}
	return nil
}

func _LabelVideoRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LabelVideoRequest)
	switch tag {
	case 4: // request_config.video_classification_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoClassificationConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelVideoRequest_VideoClassificationConfig{msg}
		return true, err
	case 5: // request_config.object_detection_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ObjectDetectionConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelVideoRequest_ObjectDetectionConfig{msg}
		return true, err
	case 6: // request_config.object_tracking_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ObjectTrackingConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelVideoRequest_ObjectTrackingConfig{msg}
		return true, err
	case 7: // request_config.event_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelVideoRequest_EventConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LabelVideoRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LabelVideoRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelVideoRequest_VideoClassificationConfig:
		s := proto.Size(x.VideoClassificationConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelVideoRequest_ObjectDetectionConfig:
		s := proto.Size(x.ObjectDetectionConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelVideoRequest_ObjectTrackingConfig:
		s := proto.Size(x.ObjectTrackingConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelVideoRequest_EventConfig:
		s := proto.Size(x.EventConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for LabelText.
type LabelTextRequest struct {
	// Required. Config for labeling tasks. The type of request config must
	// match the selected feature.
	//
	// Types that are valid to be assigned to RequestConfig:
	//	*LabelTextRequest_TextClassificationConfig
	//	*LabelTextRequest_TextEntityExtractionConfig
	RequestConfig isLabelTextRequest_RequestConfig `protobuf_oneof:"request_config"`
	// Required. Name of the data set to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of text labeling task.
	Feature              LabelTextRequest_Feature `protobuf:"varint,6,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelTextRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LabelTextRequest) Reset()         { *m = LabelTextRequest{} }
func (m *LabelTextRequest) String() string { return proto.CompactTextString(m) }
func (*LabelTextRequest) ProtoMessage()    {}
func (*LabelTextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{16}
}
func (m *LabelTextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelTextRequest.Unmarshal(m, b)
}
func (m *LabelTextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelTextRequest.Marshal(b, m, deterministic)
}
func (dst *LabelTextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelTextRequest.Merge(dst, src)
}
func (m *LabelTextRequest) XXX_Size() int {
	return xxx_messageInfo_LabelTextRequest.Size(m)
}
func (m *LabelTextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelTextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelTextRequest proto.InternalMessageInfo

type isLabelTextRequest_RequestConfig interface {
	isLabelTextRequest_RequestConfig()
}

type LabelTextRequest_TextClassificationConfig struct {
	TextClassificationConfig *TextClassificationConfig `protobuf:"bytes,4,opt,name=text_classification_config,json=textClassificationConfig,proto3,oneof"`
}

type LabelTextRequest_TextEntityExtractionConfig struct {
	TextEntityExtractionConfig *TextEntityExtractionConfig `protobuf:"bytes,5,opt,name=text_entity_extraction_config,json=textEntityExtractionConfig,proto3,oneof"`
}

func (*LabelTextRequest_TextClassificationConfig) isLabelTextRequest_RequestConfig() {}

func (*LabelTextRequest_TextEntityExtractionConfig) isLabelTextRequest_RequestConfig() {}

func (m *LabelTextRequest) GetRequestConfig() isLabelTextRequest_RequestConfig {
	if m != nil {
		return m.RequestConfig
	}
	return nil
}

func (m *LabelTextRequest) GetTextClassificationConfig() *TextClassificationConfig {
	if x, ok := m.GetRequestConfig().(*LabelTextRequest_TextClassificationConfig); ok {
		return x.TextClassificationConfig
	}
	return nil
}

func (m *LabelTextRequest) GetTextEntityExtractionConfig() *TextEntityExtractionConfig {
	if x, ok := m.GetRequestConfig().(*LabelTextRequest_TextEntityExtractionConfig); ok {
		return x.TextEntityExtractionConfig
	}
	return nil
}

func (m *LabelTextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelTextRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelTextRequest) GetFeature() LabelTextRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelTextRequest_FEATURE_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LabelTextRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LabelTextRequest_OneofMarshaler, _LabelTextRequest_OneofUnmarshaler, _LabelTextRequest_OneofSizer, []interface{}{
		(*LabelTextRequest_TextClassificationConfig)(nil),
		(*LabelTextRequest_TextEntityExtractionConfig)(nil),
	}
}

func _LabelTextRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LabelTextRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelTextRequest_TextClassificationConfig:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextClassificationConfig); err != nil {
			return err
		}
	case *LabelTextRequest_TextEntityExtractionConfig:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextEntityExtractionConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LabelTextRequest.RequestConfig has unexpected type %T", x)
	}
	return nil
}

func _LabelTextRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LabelTextRequest)
	switch tag {
	case 4: // request_config.text_classification_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TextClassificationConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelTextRequest_TextClassificationConfig{msg}
		return true, err
	case 5: // request_config.text_entity_extraction_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TextEntityExtractionConfig)
		err := b.DecodeMessage(msg)
		m.RequestConfig = &LabelTextRequest_TextEntityExtractionConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LabelTextRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LabelTextRequest)
	// request_config
	switch x := m.RequestConfig.(type) {
	case *LabelTextRequest_TextClassificationConfig:
		s := proto.Size(x.TextClassificationConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LabelTextRequest_TextEntityExtractionConfig:
		s := proto.Size(x.TextEntityExtractionConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for LabelAudio.
type LabelAudioRequest struct {
	// Required. Name of the dataset to request labeling task, format:
	// projects/{project_id}/datasets/{dataset_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Basic human annotation config.
	BasicConfig *HumanAnnotationConfig `protobuf:"bytes,2,opt,name=basic_config,json=basicConfig,proto3" json:"basic_config,omitempty"`
	// Required. The type of audio labeling task.
	Feature              LabelAudioRequest_Feature `protobuf:"varint,3,opt,name=feature,proto3,enum=google.cloud.datalabeling.v1beta1.LabelAudioRequest_Feature" json:"feature,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *LabelAudioRequest) Reset()         { *m = LabelAudioRequest{} }
func (m *LabelAudioRequest) String() string { return proto.CompactTextString(m) }
func (*LabelAudioRequest) ProtoMessage()    {}
func (*LabelAudioRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{17}
}
func (m *LabelAudioRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAudioRequest.Unmarshal(m, b)
}
func (m *LabelAudioRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAudioRequest.Marshal(b, m, deterministic)
}
func (dst *LabelAudioRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAudioRequest.Merge(dst, src)
}
func (m *LabelAudioRequest) XXX_Size() int {
	return xxx_messageInfo_LabelAudioRequest.Size(m)
}
func (m *LabelAudioRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAudioRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAudioRequest proto.InternalMessageInfo

func (m *LabelAudioRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *LabelAudioRequest) GetBasicConfig() *HumanAnnotationConfig {
	if m != nil {
		return m.BasicConfig
	}
	return nil
}

func (m *LabelAudioRequest) GetFeature() LabelAudioRequest_Feature {
	if m != nil {
		return m.Feature
	}
	return LabelAudioRequest_FEATURE_UNSPECIFIED
}

// Request message for GetExample
type GetExampleRequest struct {
	// Required. Name of example, format:
	// projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
	// {annotated_dataset_id}/examples/{example_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An expression for filtering Examples. Filter by
	// annotation_spec.display_name is supported. Format
	// "annotation_spec.display_name = {display_name}"
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetExampleRequest) Reset()         { *m = GetExampleRequest{} }
func (m *GetExampleRequest) String() string { return proto.CompactTextString(m) }
func (*GetExampleRequest) ProtoMessage()    {}
func (*GetExampleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{18}
}
func (m *GetExampleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetExampleRequest.Unmarshal(m, b)
}
func (m *GetExampleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetExampleRequest.Marshal(b, m, deterministic)
}
func (dst *GetExampleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetExampleRequest.Merge(dst, src)
}
func (m *GetExampleRequest) XXX_Size() int {
	return xxx_messageInfo_GetExampleRequest.Size(m)
}
func (m *GetExampleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetExampleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetExampleRequest proto.InternalMessageInfo

func (m *GetExampleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetExampleRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Request message for ListExamples.
type ListExamplesRequest struct {
	// Required. Example resource parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression for filtering Examples. For annotated datasets that
	// have annotation spec set, filter by
	// annotation_spec.display_name is supported. Format
	// "annotation_spec.display_name = {display_name}"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListExamplesResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListExamplesResponse.next_page_token] of the previous
	// [DataLabelingService.ListExamples] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExamplesRequest) Reset()         { *m = ListExamplesRequest{} }
func (m *ListExamplesRequest) String() string { return proto.CompactTextString(m) }
func (*ListExamplesRequest) ProtoMessage()    {}
func (*ListExamplesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{19}
}
func (m *ListExamplesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExamplesRequest.Unmarshal(m, b)
}
func (m *ListExamplesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExamplesRequest.Marshal(b, m, deterministic)
}
func (dst *ListExamplesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExamplesRequest.Merge(dst, src)
}
func (m *ListExamplesRequest) XXX_Size() int {
	return xxx_messageInfo_ListExamplesRequest.Size(m)
}
func (m *ListExamplesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExamplesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExamplesRequest proto.InternalMessageInfo

func (m *ListExamplesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListExamplesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListExamplesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListExamplesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing Examples in and annotated dataset.
type ListExamplesResponse struct {
	// The list of examples to return.
	Examples []*Example `protobuf:"bytes,1,rep,name=examples,proto3" json:"examples,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExamplesResponse) Reset()         { *m = ListExamplesResponse{} }
func (m *ListExamplesResponse) String() string { return proto.CompactTextString(m) }
func (*ListExamplesResponse) ProtoMessage()    {}
func (*ListExamplesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{20}
}
func (m *ListExamplesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListExamplesResponse.Unmarshal(m, b)
}
func (m *ListExamplesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListExamplesResponse.Marshal(b, m, deterministic)
}
func (dst *ListExamplesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExamplesResponse.Merge(dst, src)
}
func (m *ListExamplesResponse) XXX_Size() int {
	return xxx_messageInfo_ListExamplesResponse.Size(m)
}
func (m *ListExamplesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExamplesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListExamplesResponse proto.InternalMessageInfo

func (m *ListExamplesResponse) GetExamples() []*Example {
	if m != nil {
		return m.Examples
	}
	return nil
}

func (m *ListExamplesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for CreateAnnotationSpecSet.
type CreateAnnotationSpecSetRequest struct {
	// Required. AnnotationSpecSet resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Annotation spec set to create. Annotation specs must be included.
	// Only one annotation spec will be accepted for annotation specs with same
	// display_name.
	AnnotationSpecSet    *AnnotationSpecSet `protobuf:"bytes,2,opt,name=annotation_spec_set,json=annotationSpecSet,proto3" json:"annotation_spec_set,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateAnnotationSpecSetRequest) Reset()         { *m = CreateAnnotationSpecSetRequest{} }
func (m *CreateAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAnnotationSpecSetRequest) ProtoMessage()    {}
func (*CreateAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{21}
}
func (m *CreateAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *CreateAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (dst *CreateAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAnnotationSpecSetRequest.Merge(dst, src)
}
func (m *CreateAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAnnotationSpecSetRequest.Size(m)
}
func (m *CreateAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *CreateAnnotationSpecSetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAnnotationSpecSetRequest) GetAnnotationSpecSet() *AnnotationSpecSet {
	if m != nil {
		return m.AnnotationSpecSet
	}
	return nil
}

// Request message for GetAnnotationSpecSet.
type GetAnnotationSpecSetRequest struct {
	// Required. AnnotationSpecSet resource name, format:
	// projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAnnotationSpecSetRequest) Reset()         { *m = GetAnnotationSpecSetRequest{} }
func (m *GetAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*GetAnnotationSpecSetRequest) ProtoMessage()    {}
func (*GetAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{22}
}
func (m *GetAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *GetAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (dst *GetAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAnnotationSpecSetRequest.Merge(dst, src)
}
func (m *GetAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_GetAnnotationSpecSetRequest.Size(m)
}
func (m *GetAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *GetAnnotationSpecSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListAnnotationSpecSets.
type ListAnnotationSpecSetsRequest struct {
	// Required. Parent of AnnotationSpecSet resource, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListAnnotationSpecSetsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsResponse.next_page_token] of the previous
	// [DataLabelingService.ListAnnotationSpecSets] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationSpecSetsRequest) Reset()         { *m = ListAnnotationSpecSetsRequest{} }
func (m *ListAnnotationSpecSetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationSpecSetsRequest) ProtoMessage()    {}
func (*ListAnnotationSpecSetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{23}
}
func (m *ListAnnotationSpecSetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Unmarshal(m, b)
}
func (m *ListAnnotationSpecSetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListAnnotationSpecSetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationSpecSetsRequest.Merge(dst, src)
}
func (m *ListAnnotationSpecSetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationSpecSetsRequest.Size(m)
}
func (m *ListAnnotationSpecSetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationSpecSetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationSpecSetsRequest proto.InternalMessageInfo

func (m *ListAnnotationSpecSetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAnnotationSpecSetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAnnotationSpecSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAnnotationSpecSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing annotation spec set under a project.
type ListAnnotationSpecSetsResponse struct {
	// The list of annotation spec sets.
	AnnotationSpecSets []*AnnotationSpecSet `protobuf:"bytes,1,rep,name=annotation_spec_sets,json=annotationSpecSets,proto3" json:"annotation_spec_sets,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationSpecSetsResponse) Reset()         { *m = ListAnnotationSpecSetsResponse{} }
func (m *ListAnnotationSpecSetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationSpecSetsResponse) ProtoMessage()    {}
func (*ListAnnotationSpecSetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{24}
}
func (m *ListAnnotationSpecSetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Unmarshal(m, b)
}
func (m *ListAnnotationSpecSetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListAnnotationSpecSetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationSpecSetsResponse.Merge(dst, src)
}
func (m *ListAnnotationSpecSetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationSpecSetsResponse.Size(m)
}
func (m *ListAnnotationSpecSetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationSpecSetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationSpecSetsResponse proto.InternalMessageInfo

func (m *ListAnnotationSpecSetsResponse) GetAnnotationSpecSets() []*AnnotationSpecSet {
	if m != nil {
		return m.AnnotationSpecSets
	}
	return nil
}

func (m *ListAnnotationSpecSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for DeleteAnnotationSpecSet.
type DeleteAnnotationSpecSetRequest struct {
	// Required. AnnotationSpec resource name, format:
	// `projects/{project_id}/annotationSpecSets/{annotation_spec_set_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAnnotationSpecSetRequest) Reset()         { *m = DeleteAnnotationSpecSetRequest{} }
func (m *DeleteAnnotationSpecSetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAnnotationSpecSetRequest) ProtoMessage()    {}
func (*DeleteAnnotationSpecSetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{25}
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Unmarshal(m, b)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteAnnotationSpecSetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAnnotationSpecSetRequest.Merge(dst, src)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAnnotationSpecSetRequest.Size(m)
}
func (m *DeleteAnnotationSpecSetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAnnotationSpecSetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAnnotationSpecSetRequest proto.InternalMessageInfo

func (m *DeleteAnnotationSpecSetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for CreateInstruction.
type CreateInstructionRequest struct {
	// Required. Instruction resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Instruction of how to perform the labeling task.
	Instruction          *Instruction `protobuf:"bytes,2,opt,name=instruction,proto3" json:"instruction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateInstructionRequest) Reset()         { *m = CreateInstructionRequest{} }
func (m *CreateInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstructionRequest) ProtoMessage()    {}
func (*CreateInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{26}
}
func (m *CreateInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstructionRequest.Unmarshal(m, b)
}
func (m *CreateInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstructionRequest.Marshal(b, m, deterministic)
}
func (dst *CreateInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstructionRequest.Merge(dst, src)
}
func (m *CreateInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstructionRequest.Size(m)
}
func (m *CreateInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstructionRequest proto.InternalMessageInfo

func (m *CreateInstructionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstructionRequest) GetInstruction() *Instruction {
	if m != nil {
		return m.Instruction
	}
	return nil
}

// Request message for GetInstruction.
type GetInstructionRequest struct {
	// Required. Instruction resource name, format:
	// projects/{project_id}/instructions/{instruction_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstructionRequest) Reset()         { *m = GetInstructionRequest{} }
func (m *GetInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstructionRequest) ProtoMessage()    {}
func (*GetInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{27}
}
func (m *GetInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstructionRequest.Unmarshal(m, b)
}
func (m *GetInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstructionRequest.Marshal(b, m, deterministic)
}
func (dst *GetInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstructionRequest.Merge(dst, src)
}
func (m *GetInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstructionRequest.Size(m)
}
func (m *GetInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstructionRequest proto.InternalMessageInfo

func (m *GetInstructionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for DeleteInstruction.
type DeleteInstructionRequest struct {
	// Required. Instruction resource name, format:
	// projects/{project_id}/instructions/{instruction_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstructionRequest) Reset()         { *m = DeleteInstructionRequest{} }
func (m *DeleteInstructionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstructionRequest) ProtoMessage()    {}
func (*DeleteInstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{28}
}
func (m *DeleteInstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstructionRequest.Unmarshal(m, b)
}
func (m *DeleteInstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstructionRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteInstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstructionRequest.Merge(dst, src)
}
func (m *DeleteInstructionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstructionRequest.Size(m)
}
func (m *DeleteInstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstructionRequest proto.InternalMessageInfo

func (m *DeleteInstructionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for ListInstructions.
type ListInstructionsRequest struct {
	// Required. Instruction resource parent, format:
	// projects/{project_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filter is not supported at this moment.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. Server may return fewer results than
	// requested. Default value is 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results for the server to return.
	// Typically obtained by
	// [ListInstructionsResponse.next_page_token][google.cloud.datalabeling.v1beta1.ListInstructionsResponse.next_page_token] of the previous
	// [DataLabelingService.ListInstructions] call.
	// Return first page if empty.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstructionsRequest) Reset()         { *m = ListInstructionsRequest{} }
func (m *ListInstructionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstructionsRequest) ProtoMessage()    {}
func (*ListInstructionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{29}
}
func (m *ListInstructionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstructionsRequest.Unmarshal(m, b)
}
func (m *ListInstructionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstructionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListInstructionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstructionsRequest.Merge(dst, src)
}
func (m *ListInstructionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstructionsRequest.Size(m)
}
func (m *ListInstructionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstructionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstructionsRequest proto.InternalMessageInfo

func (m *ListInstructionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstructionsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListInstructionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstructionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Results of listing instructions under a project.
type ListInstructionsResponse struct {
	// The list of Instructions to return.
	Instructions []*Instruction `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"`
	// A token to retrieve next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstructionsResponse) Reset()         { *m = ListInstructionsResponse{} }
func (m *ListInstructionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstructionsResponse) ProtoMessage()    {}
func (*ListInstructionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_labeling_service_6732def77eda74d5, []int{30}
}
func (m *ListInstructionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstructionsResponse.Unmarshal(m, b)
}
func (m *ListInstructionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstructionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListInstructionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstructionsResponse.Merge(dst, src)
}
func (m *ListInstructionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstructionsResponse.Size(m)
}
func (m *ListInstructionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstructionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstructionsResponse proto.InternalMessageInfo

func (m *ListInstructionsResponse) GetInstructions() []*Instruction {
	if m != nil {
		return m.Instructions
	}
	return nil
}

func (m *ListInstructionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListDatasetsResponse")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.datalabeling.v1beta1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.datalabeling.v1beta1.ExportDataRequest")
	proto.RegisterType((*GetDataItemRequest)(nil), "google.cloud.datalabeling.v1beta1.GetDataItemRequest")
	proto.RegisterType((*ListDataItemsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListDataItemsRequest")
	proto.RegisterType((*ListDataItemsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListDataItemsResponse")
	proto.RegisterType((*GetAnnotatedDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetAnnotatedDatasetRequest")
	proto.RegisterType((*ListAnnotatedDatasetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsRequest")
	proto.RegisterType((*DeleteAnnotatedDatasetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteAnnotatedDatasetRequest")
	proto.RegisterType((*ListAnnotatedDatasetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsResponse")
	proto.RegisterType((*LabelImageRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelImageRequest")
	proto.RegisterType((*LabelVideoRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelVideoRequest")
	proto.RegisterType((*LabelTextRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelTextRequest")
	proto.RegisterType((*LabelAudioRequest)(nil), "google.cloud.datalabeling.v1beta1.LabelAudioRequest")
	proto.RegisterType((*GetExampleRequest)(nil), "google.cloud.datalabeling.v1beta1.GetExampleRequest")
	proto.RegisterType((*ListExamplesRequest)(nil), "google.cloud.datalabeling.v1beta1.ListExamplesRequest")
	proto.RegisterType((*ListExamplesResponse)(nil), "google.cloud.datalabeling.v1beta1.ListExamplesResponse")
	proto.RegisterType((*CreateAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateAnnotationSpecSetRequest")
	proto.RegisterType((*GetAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.GetAnnotationSpecSetRequest")
	proto.RegisterType((*ListAnnotationSpecSetsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsRequest")
	proto.RegisterType((*ListAnnotationSpecSetsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsResponse")
	proto.RegisterType((*DeleteAnnotationSpecSetRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteAnnotationSpecSetRequest")
	proto.RegisterType((*CreateInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.CreateInstructionRequest")
	proto.RegisterType((*GetInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.GetInstructionRequest")
	proto.RegisterType((*DeleteInstructionRequest)(nil), "google.cloud.datalabeling.v1beta1.DeleteInstructionRequest")
	proto.RegisterType((*ListInstructionsRequest)(nil), "google.cloud.datalabeling.v1beta1.ListInstructionsRequest")
	proto.RegisterType((*ListInstructionsResponse)(nil), "google.cloud.datalabeling.v1beta1.ListInstructionsResponse")
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelImageRequest_Feature", LabelImageRequest_Feature_name, LabelImageRequest_Feature_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelVideoRequest_Feature", LabelVideoRequest_Feature_name, LabelVideoRequest_Feature_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelTextRequest_Feature", LabelTextRequest_Feature_name, LabelTextRequest_Feature_value)
	proto.RegisterEnum("google.cloud.datalabeling.v1beta1.LabelAudioRequest_Feature", LabelAudioRequest_Feature_name, LabelAudioRequest_Feature_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataLabelingServiceClient is the client API for DataLabelingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataLabelingServiceClient interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Starts a labeling task for audio. The type of audio labeling task is
	// configured by feature in the request.
	LabelAudio(ctx context.Context, in *LabelAudioRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type dataLabelingServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataLabelingServiceClient(cc *grpc.ClientConn) DataLabelingServiceClient {
	return &dataLabelingServiceClient{cc}
}

func (c *dataLabelingServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetDataItem(ctx context.Context, in *GetDataItemRequest, opts ...grpc.CallOption) (*DataItem, error) {
	out := new(DataItem)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataItem", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error) {
	out := new(ListDataItemsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDataItems", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotatedDataset(ctx context.Context, in *GetAnnotatedDatasetRequest, opts ...grpc.CallOption) (*AnnotatedDataset, error) {
	out := new(AnnotatedDataset)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotatedDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotatedDatasets(ctx context.Context, in *ListAnnotatedDatasetsRequest, opts ...grpc.CallOption) (*ListAnnotatedDatasetsResponse, error) {
	out := new(ListAnnotatedDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotatedDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotatedDataset(ctx context.Context, in *DeleteAnnotatedDatasetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotatedDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelImage(ctx context.Context, in *LabelImageRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelImage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelVideo(ctx context.Context, in *LabelVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelText(ctx context.Context, in *LabelTextRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelText", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) LabelAudio(ctx context.Context, in *LabelAudioRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelAudio", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetExample(ctx context.Context, in *GetExampleRequest, opts ...grpc.CallOption) (*Example, error) {
	out := new(Example)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetExample", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListExamples(ctx context.Context, in *ListExamplesRequest, opts ...grpc.CallOption) (*ListExamplesResponse, error) {
	out := new(ListExamplesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListExamples", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateAnnotationSpecSet(ctx context.Context, in *CreateAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetAnnotationSpecSet(ctx context.Context, in *GetAnnotationSpecSetRequest, opts ...grpc.CallOption) (*AnnotationSpecSet, error) {
	out := new(AnnotationSpecSet)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListAnnotationSpecSets(ctx context.Context, in *ListAnnotationSpecSetsRequest, opts ...grpc.CallOption) (*ListAnnotationSpecSetsResponse, error) {
	out := new(ListAnnotationSpecSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotationSpecSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteAnnotationSpecSet(ctx context.Context, in *DeleteAnnotationSpecSetRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotationSpecSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) CreateInstruction(ctx context.Context, in *CreateInstructionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) GetInstruction(ctx context.Context, in *GetInstructionRequest, opts ...grpc.CallOption) (*Instruction, error) {
	out := new(Instruction)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) ListInstructions(ctx context.Context, in *ListInstructionsRequest, opts ...grpc.CallOption) (*ListInstructionsResponse, error) {
	out := new(ListInstructionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataLabelingServiceClient) DeleteInstruction(ctx context.Context, in *DeleteInstructionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteInstruction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataLabelingServiceServer is the server API for DataLabelingService service.
type DataLabelingServiceServer interface {
	// Creates dataset. If success return a Dataset resource.
	CreateDataset(context.Context, *CreateDatasetRequest) (*Dataset, error)
	// Gets dataset by resource name.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets under a project. Pagination is supported.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a dataset by resource name.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*empty.Empty, error)
	// Imports data into dataset based on source locations defined in request.
	// It can be called multiple times for the same dataset. Each dataset can
	// only have one long running operation running on it. For example, no
	// labeling task (also long running operation) can be started while
	// importing is still ongoing. Vice versa.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports data and annotations from dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Gets a data item in a dataset by resource name. This API can be
	// called after data are imported into dataset.
	GetDataItem(context.Context, *GetDataItemRequest) (*DataItem, error)
	// Lists data items in a dataset. This API can be called after data
	// are imported into dataset. Pagination is supported.
	ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error)
	// Gets an annotated dataset by resource name.
	GetAnnotatedDataset(context.Context, *GetAnnotatedDatasetRequest) (*AnnotatedDataset, error)
	// Lists annotated datasets for a dataset. Pagination is supported.
	ListAnnotatedDatasets(context.Context, *ListAnnotatedDatasetsRequest) (*ListAnnotatedDatasetsResponse, error)
	// Deletes an annotated dataset by resource name.
	DeleteAnnotatedDataset(context.Context, *DeleteAnnotatedDatasetRequest) (*empty.Empty, error)
	// Starts a labeling task for image. The type of image labeling task is
	// configured by feature in the request.
	LabelImage(context.Context, *LabelImageRequest) (*longrunning.Operation, error)
	// Starts a labeling task for video. The type of video labeling task is
	// configured by feature in the request.
	LabelVideo(context.Context, *LabelVideoRequest) (*longrunning.Operation, error)
	// Starts a labeling task for text. The type of text labeling task is
	// configured by feature in the request.
	LabelText(context.Context, *LabelTextRequest) (*longrunning.Operation, error)
	// Starts a labeling task for audio. The type of audio labeling task is
	// configured by feature in the request.
	LabelAudio(context.Context, *LabelAudioRequest) (*longrunning.Operation, error)
	// Gets an example by resource name, including both data and annotation.
	GetExample(context.Context, *GetExampleRequest) (*Example, error)
	// Lists examples in an annotated dataset. Pagination is supported.
	ListExamples(context.Context, *ListExamplesRequest) (*ListExamplesResponse, error)
	// Creates an annotation spec set by providing a set of labels.
	CreateAnnotationSpecSet(context.Context, *CreateAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Gets an annotation spec set by resource name.
	GetAnnotationSpecSet(context.Context, *GetAnnotationSpecSetRequest) (*AnnotationSpecSet, error)
	// Lists annotation spec sets for a project. Pagination is supported.
	ListAnnotationSpecSets(context.Context, *ListAnnotationSpecSetsRequest) (*ListAnnotationSpecSetsResponse, error)
	// Deletes an annotation spec set by resource name.
	DeleteAnnotationSpecSet(context.Context, *DeleteAnnotationSpecSetRequest) (*empty.Empty, error)
	// Creates an instruction for how data should be labeled.
	CreateInstruction(context.Context, *CreateInstructionRequest) (*longrunning.Operation, error)
	// Gets an instruction by resource name.
	GetInstruction(context.Context, *GetInstructionRequest) (*Instruction, error)
	// Lists instructions for a project. Pagination is supported.
	ListInstructions(context.Context, *ListInstructionsRequest) (*ListInstructionsResponse, error)
	// Deletes an instruction object by resource name.
	DeleteInstruction(context.Context, *DeleteInstructionRequest) (*empty.Empty, error)
}

func RegisterDataLabelingServiceServer(s *grpc.Server, srv DataLabelingServiceServer) {
	s.RegisterService(&_DataLabelingService_serviceDesc, srv)
}

func _DataLabelingService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetDataItem_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataItemRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetDataItem",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetDataItem(ctx, req.(*GetDataItemRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListDataItems",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListDataItems(ctx, req.(*ListDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotatedDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotatedDataset(ctx, req.(*GetAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotatedDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotatedDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotatedDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotatedDatasets(ctx, req.(*ListAnnotatedDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotatedDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotatedDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotatedDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotatedDataset(ctx, req.(*DeleteAnnotatedDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelImage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelImage(ctx, req.(*LabelImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelVideo(ctx, req.(*LabelVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelText",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelText(ctx, req.(*LabelTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_LabelAudio_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelAudioRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).LabelAudio(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/LabelAudio",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).LabelAudio(ctx, req.(*LabelAudioRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetExample_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExampleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetExample(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetExample",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetExample(ctx, req.(*GetExampleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListExamples_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExamplesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListExamples",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListExamples(ctx, req.(*ListExamplesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateAnnotationSpecSet(ctx, req.(*CreateAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetAnnotationSpecSet(ctx, req.(*GetAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListAnnotationSpecSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationSpecSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListAnnotationSpecSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListAnnotationSpecSets(ctx, req.(*ListAnnotationSpecSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteAnnotationSpecSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationSpecSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteAnnotationSpecSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteAnnotationSpecSet(ctx, req.(*DeleteAnnotationSpecSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_CreateInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/CreateInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).CreateInstruction(ctx, req.(*CreateInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_GetInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/GetInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).GetInstruction(ctx, req.(*GetInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_ListInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstructionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/ListInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).ListInstructions(ctx, req.(*ListInstructionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataLabelingService_DeleteInstruction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstructionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datalabeling.v1beta1.DataLabelingService/DeleteInstruction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataLabelingServiceServer).DeleteInstruction(ctx, req.(*DeleteInstructionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataLabelingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datalabeling.v1beta1.DataLabelingService",
	HandlerType: (*DataLabelingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DataLabelingService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DataLabelingService_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DataLabelingService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _DataLabelingService_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _DataLabelingService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _DataLabelingService_ExportData_Handler,
		},
		{
			MethodName: "GetDataItem",
			Handler:    _DataLabelingService_GetDataItem_Handler,
		},
		{
			MethodName: "ListDataItems",
			Handler:    _DataLabelingService_ListDataItems_Handler,
		},
		{
			MethodName: "GetAnnotatedDataset",
			Handler:    _DataLabelingService_GetAnnotatedDataset_Handler,
		},
		{
			MethodName: "ListAnnotatedDatasets",
			Handler:    _DataLabelingService_ListAnnotatedDatasets_Handler,
		},
		{
			MethodName: "DeleteAnnotatedDataset",
			Handler:    _DataLabelingService_DeleteAnnotatedDataset_Handler,
		},
		{
			MethodName: "LabelImage",
			Handler:    _DataLabelingService_LabelImage_Handler,
		},
		{
			MethodName: "LabelVideo",
			Handler:    _DataLabelingService_LabelVideo_Handler,
		},
		{
			MethodName: "LabelText",
			Handler:    _DataLabelingService_LabelText_Handler,
		},
		{
			MethodName: "LabelAudio",
			Handler:    _DataLabelingService_LabelAudio_Handler,
		},
		{
			MethodName: "GetExample",
			Handler:    _DataLabelingService_GetExample_Handler,
		},
		{
			MethodName: "ListExamples",
			Handler:    _DataLabelingService_ListExamples_Handler,
		},
		{
			MethodName: "CreateAnnotationSpecSet",
			Handler:    _DataLabelingService_CreateAnnotationSpecSet_Handler,
		},
		{
			MethodName: "GetAnnotationSpecSet",
			Handler:    _DataLabelingService_GetAnnotationSpecSet_Handler,
		},
		{
			MethodName: "ListAnnotationSpecSets",
			Handler:    _DataLabelingService_ListAnnotationSpecSets_Handler,
		},
		{
			MethodName: "DeleteAnnotationSpecSet",
			Handler:    _DataLabelingService_DeleteAnnotationSpecSet_Handler,
		},
		{
			MethodName: "CreateInstruction",
			Handler:    _DataLabelingService_CreateInstruction_Handler,
		},
		{
			MethodName: "GetInstruction",
			Handler:    _DataLabelingService_GetInstruction_Handler,
		},
		{
			MethodName: "ListInstructions",
			Handler:    _DataLabelingService_ListInstructions_Handler,
		},
		{
			MethodName: "DeleteInstruction",
			Handler:    _DataLabelingService_DeleteInstruction_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datalabeling/v1beta1/data_labeling_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/datalabeling/v1beta1/data_labeling_service.proto", fileDescriptor_data_labeling_service_6732def77eda74d5)
}

var fileDescriptor_data_labeling_service_6732def77eda74d5 = []byte{
	// 2191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xcf, 0xe8, 0xcb, 0xd6, 0xd3, 0x87, 0xc9, 0x91, 0x2c, 0x31, 0x74, 0x64, 0xa8, 0x1b, 0xa4,
	0x71, 0x68, 0x94, 0xb4, 0x2c, 0xbb, 0x76, 0xa4, 0x2a, 0x0e, 0x45, 0xae, 0x14, 0xa6, 0x0a, 0xa9,
	0x92, 0x94, 0xeb, 0xb4, 0x05, 0x88, 0x25, 0x39, 0x62, 0xb6, 0x26, 0x77, 0x59, 0xee, 0x52, 0x90,
	0x1c, 0xa4, 0x40, 0x8d, 0xb6, 0x87, 0xe6, 0xd0, 0x43, 0x81, 0x1c, 0x5a, 0xc4, 0x40, 0x0f, 0xed,
	0xa5, 0x4d, 0xd0, 0x4b, 0x6f, 0x6d, 0x0e, 0x05, 0x7a, 0xea, 0xc7, 0xa5, 0x40, 0x6f, 0xbd, 0xf5,
	0x0f, 0x29, 0x66, 0x76, 0xf6, 0x8b, 0xbb, 0x4b, 0x0e, 0x65, 0x03, 0x6a, 0x6e, 0xda, 0xd9, 0x7d,
	0xef, 0xfd, 0xde, 0x7b, 0xbf, 0xb7, 0x3b, 0xf3, 0x13, 0x61, 0xa7, 0xa5, 0xeb, 0xad, 0x36, 0xc9,
	0x34, 0xda, 0x7a, 0xbf, 0x99, 0x69, 0x2a, 0xa6, 0xd2, 0x56, 0xea, 0xa4, 0xad, 0x6a, 0xad, 0xcc,
	0xc9, 0x46, 0x9d, 0x98, 0xca, 0x06, 0x5b, 0xac, 0xd9, 0xab, 0x35, 0x83, 0xf4, 0x4e, 0xd4, 0x06,
	0x49, 0x77, 0x7b, 0xba, 0xa9, 0xe3, 0xaf, 0x58, 0xe6, 0x69, 0x66, 0x9e, 0xf6, 0x9a, 0xa7, 0xb9,
	0x79, 0xf2, 0x15, 0x1e, 0x41, 0xe9, 0xaa, 0x19, 0x45, 0xd3, 0x74, 0x53, 0x31, 0x55, 0x5d, 0x33,
	0x2c, 0x07, 0xc9, 0xed, 0xd1, 0xf1, 0x5d, 0xa3, 0x9a, 0xd1, 0x25, 0x8d, 0x9a, 0x41, 0x4c, 0x6e,
	0x9c, 0x11, 0x03, 0xef, 0x1a, 0x3c, 0x18, 0x6d, 0xf0, 0x41, 0xbf, 0xa3, 0x68, 0x35, 0x4f, 0xcc,
	0x86, 0xae, 0x1d, 0xab, 0x2d, 0xee, 0x60, 0x73, 0xb4, 0x03, 0x55, 0x33, 0xcc, 0x5e, 0xbf, 0x41,
	0x6d, 0xb9, 0xd1, 0xed, 0xd1, 0x46, 0x7a, 0x97, 0xf4, 0x7c, 0x75, 0x79, 0x95, 0xdb, 0xb4, 0x75,
	0xad, 0xd5, 0xeb, 0x6b, 0x1a, 0x7d, 0x38, 0xf0, 0xd0, 0x35, 0xfe, 0x10, 0xbb, 0xaa, 0xf7, 0x8f,
	0x33, 0xa4, 0xd3, 0x35, 0xcf, 0xf8, 0xcd, 0xf5, 0xc1, 0x9b, 0xc7, 0x2a, 0x69, 0x37, 0x6b, 0x1d,
	0xc5, 0x78, 0x6c, 0x3d, 0x21, 0x99, 0xb0, 0x9c, 0xeb, 0x11, 0xc5, 0x24, 0x79, 0xab, 0x48, 0x65,
	0xf2, 0x83, 0x3e, 0x31, 0x4c, 0xbc, 0x02, 0x33, 0x5d, 0xa5, 0x47, 0x34, 0x33, 0x81, 0xd6, 0xd1,
	0x8d, 0xd9, 0x32, 0xbf, 0xc2, 0x79, 0xb8, 0xc4, 0xcb, 0x99, 0x98, 0x58, 0x47, 0x37, 0xe6, 0x6e,
	0xa7, 0xd2, 0x23, 0xdb, 0x9f, 0xb6, 0x7d, 0xdb, 0xa6, 0xd2, 0xeb, 0x10, 0xdf, 0x27, 0xe6, 0x40,
	0x48, 0x0c, 0x53, 0x9a, 0xd2, 0x21, 0x3c, 0x20, 0xfb, 0x5b, 0xfa, 0x11, 0x82, 0xa5, 0x03, 0xd5,
	0xb0, 0x1f, 0x35, 0x46, 0xc1, 0x5b, 0x81, 0x99, 0x63, 0xb5, 0x6d, 0x92, 0x1e, 0x43, 0x37, 0x5b,
	0xe6, 0x57, 0xf8, 0x1a, 0xcc, 0x76, 0x95, 0x16, 0xa9, 0x19, 0xea, 0x13, 0x92, 0x98, 0x5c, 0x47,
	0x37, 0xa6, 0xcb, 0x97, 0xe9, 0x42, 0x45, 0x7d, 0x42, 0xf0, 0x1a, 0x00, 0xbb, 0x69, 0xea, 0x8f,
	0x89, 0x96, 0x98, 0x62, 0x86, 0xec, 0xf1, 0x2a, 0x5d, 0x90, 0x7e, 0x8a, 0x60, 0xd9, 0x8f, 0xc1,
	0xe8, 0xea, 0x9a, 0x41, 0xf0, 0x1e, 0x5c, 0xe6, 0x09, 0x19, 0x09, 0xb4, 0x3e, 0x39, 0x66, 0x31,
	0x1c, 0x5b, 0xfc, 0x55, 0xb8, 0xa2, 0x91, 0x53, 0xb3, 0xe6, 0x01, 0x61, 0xa1, 0x5f, 0xa0, 0xcb,
	0x87, 0x0e, 0x90, 0x14, 0x2c, 0xe7, 0x49, 0x9b, 0x04, 0x7a, 0x15, 0x56, 0xb8, 0x27, 0x10, 0x2f,
	0x74, 0xba, 0x7a, 0x8f, 0xa1, 0x1e, 0xf2, 0x20, 0xfe, 0x16, 0xcc, 0xab, 0x5a, 0xb7, 0x6f, 0x72,
	0x8e, 0xf3, 0xae, 0xa6, 0x05, 0x12, 0x29, 0x50, 0xb3, 0x1c, 0xb3, 0x2a, 0xcf, 0xa9, 0xee, 0x85,
	0xf4, 0x17, 0x04, 0x71, 0xf9, 0x54, 0x24, 0xf8, 0x4d, 0x88, 0xf3, 0x29, 0x23, 0xcd, 0x9a, 0x97,
	0x57, 0xb3, 0xe5, 0x98, 0x73, 0x83, 0x67, 0xeb, 0xe9, 0xed, 0xa4, 0xaf, 0xb7, 0x55, 0x58, 0xd0,
	0xfb, 0xa6, 0x27, 0x85, 0x29, 0x96, 0x42, 0x46, 0x20, 0x85, 0x12, 0xb3, 0xe3, 0x39, 0xcc, 0xeb,
	0x9e, 0x2b, 0xe9, 0x06, 0x60, 0x4e, 0xd1, 0x82, 0x49, 0x3a, 0xc3, 0x4a, 0xfd, 0xd4, 0xc3, 0x0f,
	0xfa, 0xec, 0x85, 0x90, 0xf4, 0x63, 0x04, 0x57, 0x07, 0x40, 0x70, 0x96, 0xbe, 0x0b, 0xc0, 0xde,
	0xde, 0x2a, 0x5d, 0xe5, 0x3c, 0xbd, 0x29, 0xc8, 0x53, 0x96, 0xfa, 0x6c, 0xd3, 0xf6, 0x29, 0xcc,
	0xd4, 0x5b, 0x90, 0xdc, 0x27, 0x66, 0x76, 0xa0, 0x83, 0xc3, 0x8a, 0xf8, 0x33, 0x04, 0xaf, 0x50,
	0xfc, 0x83, 0x36, 0x17, 0x52, 0xcc, 0x4d, 0x58, 0xb3, 0x06, 0x6d, 0x9c, 0x0c, 0x7e, 0x87, 0x60,
	0x2d, 0x22, 0x03, 0xde, 0x89, 0x3a, 0xe0, 0x00, 0xdb, 0xed, 0x8e, 0x6c, 0x0a, 0x74, 0x24, 0x80,
	0x26, 0x3e, 0x38, 0x23, 0xe2, 0x1d, 0xfa, 0x62, 0x06, 0xe2, 0x07, 0x34, 0x40, 0xa1, 0xa3, 0xb4,
	0x88, 0x9d, 0xd7, 0x0f, 0xe1, 0x9a, 0x4a, 0xaf, 0x6b, 0x8d, 0xb6, 0x62, 0x18, 0xea, 0xb1, 0xda,
	0xf0, 0x7e, 0xff, 0xf8, 0x60, 0x7d, 0x43, 0xe4, 0xdd, 0x40, 0xbd, 0xe4, 0x7c, 0x4e, 0xac, 0xb9,
	0x7a, 0xe7, 0xa5, 0xf2, 0xcb, 0x6a, 0xd4, 0x4d, 0xac, 0xc2, 0x72, 0x5d, 0xef, 0x6b, 0x4d, 0xba,
	0xc9, 0xe8, 0xea, 0xed, 0x33, 0x3b, 0xf0, 0x34, 0x0b, 0x7c, 0x57, 0x20, 0xf0, 0x2e, 0x37, 0x3f,
	0xd4, 0xdb, 0x67, 0x4e, 0x44, 0x5c, 0x0f, 0xac, 0xe2, 0xef, 0xc1, 0x15, 0x1a, 0xa1, 0xad, 0x6a,
	0xc4, 0x8e, 0x32, 0xc3, 0xa2, 0x6c, 0x08, 0x44, 0x39, 0xe4, 0x96, 0x4e, 0x84, 0xc5, 0xae, 0x6f,
	0x05, 0x7f, 0x00, 0x4b, 0x06, 0x69, 0x75, 0x88, 0xe6, 0xdb, 0x40, 0x24, 0x2e, 0x09, 0xe7, 0x51,
	0xf1, 0x58, 0xbb, 0x79, 0x18, 0x81, 0xd5, 0xc8, 0xb9, 0xf8, 0x2e, 0xcc, 0xd7, 0x15, 0x43, 0x6d,
	0xf8, 0xdf, 0xeb, 0xf7, 0x05, 0x42, 0xbf, 0x43, 0x77, 0x3f, 0x59, 0x67, 0xf3, 0x63, 0xbf, 0xe1,
	0x99, 0x37, 0x1e, 0xf4, 0x21, 0x5c, 0x3a, 0x26, 0x8a, 0xd9, 0xef, 0x59, 0xa3, 0xb5, 0x28, 0xc4,
	0x89, 0x00, 0xdd, 0xd2, 0x7b, 0x96, 0x8f, 0xb2, 0xed, 0x4c, 0xfa, 0x04, 0xc1, 0x25, 0xbe, 0x88,
	0x57, 0x61, 0x69, 0x4f, 0xce, 0x56, 0x8f, 0xca, 0x72, 0xed, 0xa8, 0x58, 0x39, 0x94, 0x73, 0x85,
	0xbd, 0x82, 0x9c, 0x8f, 0xbd, 0x84, 0x31, 0x2c, 0xe6, 0x0e, 0xb2, 0x95, 0x4a, 0x61, 0xaf, 0x90,
	0xcb, 0x56, 0x0b, 0xa5, 0x62, 0x0c, 0xe1, 0x18, 0xcc, 0xef, 0x96, 0x8e, 0x8a, 0xf9, 0x42, 0x71,
	0xbf, 0xb6, 0x5b, 0x7a, 0x14, 0x9b, 0xc0, 0x2f, 0xc3, 0xd5, 0x52, 0xb9, 0x20, 0x17, 0xab, 0x72,
	0xbe, 0xe6, 0xbb, 0x35, 0x83, 0xe3, 0xb0, 0xe0, 0xac, 0x1c, 0x96, 0x0e, 0xde, 0x8f, 0x4d, 0xe2,
	0x79, 0xb8, 0x4c, 0xff, 0x3a, 0x28, 0x14, 0xe5, 0xd8, 0x14, 0xf5, 0x56, 0x91, 0xf7, 0xdf, 0x93,
	0x8b, 0x55, 0xcb, 0xff, 0xf4, 0x6e, 0x0c, 0x16, 0x7b, 0x16, 0x68, 0x5e, 0x4f, 0xe9, 0x97, 0xf6,
	0x00, 0x3d, 0x54, 0x9b, 0x44, 0xf7, 0x0c, 0xd0, 0x09, 0xbd, 0x7e, 0xee, 0x01, 0x62, 0x5e, 0xa3,
	0x06, 0xe8, 0x24, 0xea, 0x26, 0xee, 0xc1, 0xaa, 0x5e, 0xff, 0x3e, 0x69, 0x98, 0xb5, 0x26, 0x31,
	0x49, 0xc3, 0x1b, 0x7b, 0x5a, 0x98, 0x00, 0x25, 0xe6, 0x21, 0x6f, 0x3b, 0x70, 0xe2, 0x5e, 0xd5,
	0xc3, 0x6e, 0x60, 0x1d, 0x56, 0x78, 0x4c, 0xb3, 0xa7, 0x34, 0x1e, 0xd3, 0xd9, 0xf5, 0x0d, 0xd4,
	0x3d, 0xe1, 0x90, 0x55, 0x6e, 0xef, 0x44, 0x5c, 0xd6, 0x43, 0xd6, 0x71, 0x05, 0xe6, 0xc9, 0x09,
	0xd1, 0x4c, 0xff, 0x54, 0x89, 0x6c, 0x59, 0x64, 0x6a, 0xe6, 0x78, 0x9f, 0x23, 0xee, 0xe5, 0x97,
	0x6d, 0x8e, 0xbc, 0xac, 0x0b, 0xce, 0x51, 0xfb, 0x9c, 0x63, 0xb4, 0x0c, 0xb1, 0xd2, 0xee, 0xbb,
	0x72, 0xae, 0x5a, 0xcb, 0xcb, 0x55, 0x39, 0xc7, 0x56, 0x27, 0xf0, 0x12, 0x5c, 0xe1, 0xab, 0xd5,
	0x72, 0x36, 0xf7, 0xcd, 0x42, 0x71, 0x3f, 0x36, 0x89, 0x67, 0x61, 0x5a, 0x7e, 0x28, 0x17, 0xab,
	0xb1, 0xa9, 0x90, 0xe1, 0xf8, 0xdb, 0x14, 0xc4, 0x18, 0xcc, 0x2a, 0x39, 0x75, 0x3e, 0x9a, 0x1f,
	0x42, 0xd2, 0xa4, 0x9f, 0xa6, 0x61, 0xa3, 0xb1, 0x2d, 0x90, 0x3f, 0xf5, 0x19, 0x31, 0x19, 0x09,
	0x33, 0xe2, 0x1e, 0x7e, 0x8a, 0x60, 0x8d, 0x45, 0x27, 0x9a, 0xa9, 0x9a, 0x67, 0x35, 0x72, 0x4a,
	0xc9, 0x1a, 0x9c, 0x8f, 0x1d, 0x41, 0x00, 0x32, 0x73, 0x23, 0x3b, 0x5e, 0x1c, 0x08, 0x2c, 0xc7,
	0xf0, 0xbb, 0x17, 0xc3, 0xb1, 0x23, 0x97, 0x63, 0x33, 0x8c, 0x63, 0xdb, 0xa2, 0x1c, 0xf3, 0x34,
	0x2f, 0x48, 0xb1, 0x6f, 0x0b, 0x50, 0x6c, 0x15, 0x96, 0xaa, 0xf2, 0xa3, 0x6a, 0x2d, 0xc0, 0xb3,
	0x24, 0xac, 0xb0, 0x1b, 0x72, 0xb1, 0x5a, 0xa8, 0xbe, 0x5f, 0x93, 0x1f, 0x51, 0x62, 0x59, 0x6c,
	0x0b, 0x61, 0xd3, 0xa7, 0x13, 0xfc, 0x55, 0x9b, 0xed, 0x37, 0x55, 0x7d, 0xd4, 0x86, 0xf0, 0xff,
	0x74, 0x60, 0xbd, 0xd8, 0x83, 0xd5, 0xdc, 0x16, 0xab, 0x66, 0xf6, 0x28, 0x5f, 0x28, 0xd1, 0x29,
	0x2c, 0x56, 0x72, 0xe5, 0xc2, 0xa1, 0x55, 0x4d, 0xe9, 0x01, 0x3b, 0x4d, 0xcb, 0xa7, 0x4a, 0xa7,
	0xdb, 0x26, 0xc3, 0x8e, 0x5b, 0x11, 0x7b, 0x65, 0xe7, 0x94, 0xcd, 0x5d, 0x5c, 0xe8, 0x29, 0xdb,
	0xc5, 0xe0, 0x9e, 0xb2, 0x09, 0x5f, 0x1b, 0xe3, 0x94, 0x6d, 0x57, 0xc3, 0xb1, 0x15, 0xde, 0x19,
	0x3f, 0x43, 0x70, 0xdd, 0x92, 0x44, 0x5c, 0x2a, 0x54, 0xba, 0xa4, 0x51, 0x19, 0x2d, 0x8e, 0x34,
	0x61, 0x29, 0x44, 0xa8, 0xe2, 0x0c, 0xbc, 0x23, 0xbe, 0xc3, 0xf7, 0x44, 0x8c, 0x2b, 0x83, 0x4b,
	0xd2, 0x06, 0x5c, 0x73, 0x0f, 0x57, 0x41, 0x70, 0x61, 0x67, 0x93, 0x8f, 0xfd, 0x67, 0x13, 0xd7,
	0xe8, 0x42, 0x5a, 0xfd, 0x07, 0x04, 0xd7, 0xa3, 0xd0, 0xf0, 0xa6, 0x1f, 0xc3, 0x72, 0x48, 0x25,
	0x6d, 0x02, 0x9c, 0xaf, 0x94, 0x38, 0x50, 0x4a, 0x71, 0x52, 0xdc, 0x81, 0xeb, 0xbe, 0x13, 0xa1,
	0x58, 0xd9, 0x7f, 0x8c, 0x20, 0x61, 0x51, 0xa9, 0xe0, 0x0a, 0x82, 0xa3, 0x2a, 0x7e, 0x08, 0x73,
	0x1e, 0xf9, 0x70, 0x2c, 0x3d, 0xc6, 0x8d, 0xe1, 0x75, 0x21, 0xdd, 0x84, 0xab, 0xfb, 0xc4, 0x0c,
	0x81, 0x10, 0x86, 0x39, 0x0d, 0x09, 0x2b, 0x53, 0xc1, 0xe7, 0x7f, 0x82, 0x60, 0x95, 0x36, 0xd3,
	0xf3, 0xf8, 0x85, 0x90, 0xea, 0x13, 0x04, 0x89, 0x20, 0x0e, 0x4e, 0xa7, 0x32, 0xcc, 0x7b, 0x0a,
	0x62, 0xd3, 0x68, 0xdc, 0xa2, 0xfa, 0x7c, 0x88, 0x52, 0xe7, 0xf6, 0xe7, 0xaf, 0xc2, 0x12, 0x3d,
	0x9e, 0x1f, 0x70, 0xd7, 0x15, 0x4b, 0x3c, 0xc7, 0xbf, 0x45, 0xb0, 0xe0, 0x93, 0x5e, 0xb1, 0xc8,
	0x46, 0x39, 0x4c, 0xac, 0x4d, 0x8e, 0x21, 0x3b, 0x4a, 0xb7, 0x9e, 0xfe, 0xeb, 0xbf, 0xbf, 0x98,
	0x48, 0x49, 0xaf, 0x39, 0xba, 0xf3, 0x87, 0x56, 0x57, 0x76, 0xba, 0x3d, 0x9d, 0x6e, 0xb6, 0x8d,
	0x4c, 0xea, 0x23, 0x5b, 0x32, 0x37, 0xb6, 0x50, 0x0a, 0x7f, 0x8a, 0x00, 0x5c, 0xb5, 0x16, 0x8b,
	0x0c, 0x5f, 0x40, 0xdc, 0x1d, 0x0b, 0xe2, 0xd7, 0x18, 0xc4, 0xd7, 0xb1, 0x07, 0x22, 0xa5, 0x9a,
	0x07, 0xa0, 0x83, 0x2f, 0x93, 0xfa, 0x08, 0x7f, 0x8e, 0x60, 0xde, 0xab, 0xcf, 0xe2, 0xaf, 0x8b,
	0x7c, 0x93, 0x83, 0xa2, 0x72, 0xf2, 0xde, 0xd8, 0x76, 0x16, 0xbd, 0xc2, 0x00, 0x0f, 0xa9, 0x29,
	0xfe, 0x39, 0x82, 0x05, 0x9f, 0x90, 0x2b, 0xd4, 0xf9, 0x30, 0xe9, 0x37, 0xb9, 0x62, 0x1b, 0xda,
	0x0a, 0x7f, 0x5a, 0xee, 0x74, 0xcd, 0x33, 0x1b, 0x51, 0x4a, 0xb0, 0x84, 0xcf, 0x10, 0x80, 0x2b,
	0x17, 0x0b, 0xb5, 0x38, 0xa0, 0x2e, 0x27, 0xd7, 0x6c, 0x2b, 0xcf, 0xff, 0x2b, 0xd2, 0x25, 0xfb,
	0xff, 0x15, 0xd2, 0x36, 0x83, 0x74, 0x57, 0xba, 0x25, 0x04, 0x69, 0x4b, 0x75, 0xfc, 0x53, 0x0e,
	0x52, 0x80, 0xae, 0xa4, 0x2c, 0x04, 0x30, 0xa0, 0x40, 0xbf, 0x60, 0x80, 0xe4, 0xd4, 0x0b, 0xf0,
	0xf7, 0x08, 0xe6, 0x3c, 0x7a, 0x31, 0xbe, 0x2b, 0x3e, 0x25, 0x1e, 0x7d, 0x39, 0x39, 0x8e, 0x30,
	0x2b, 0xbd, 0xc9, 0x00, 0x6f, 0xe2, 0x0d, 0x11, 0xc0, 0x19, 0x47, 0xc5, 0xa5, 0x0d, 0xff, 0x33,
	0x82, 0x05, 0x9f, 0x5c, 0x8c, 0xc7, 0x21, 0xbf, 0x57, 0xe5, 0x4e, 0xde, 0x1f, 0xdf, 0x90, 0x8f,
	0x4d, 0x08, 0xfe, 0xc0, 0xd8, 0x78, 0x4b, 0xee, 0xa6, 0x80, 0xff, 0x8e, 0x60, 0x29, 0x44, 0x61,
	0xc6, 0x3b, 0x62, 0x65, 0x8f, 0xd0, 0x75, 0x93, 0xe7, 0x51, 0x61, 0xa5, 0x2c, 0x4b, 0x63, 0x1b,
	0xbf, 0x29, 0xd4, 0x86, 0x80, 0x64, 0x4b, 0xdb, 0xf1, 0x1f, 0xae, 0xde, 0x07, 0xb4, 0x63, 0xfc,
	0x40, 0xb0, 0xba, 0x51, 0xba, 0x79, 0xf2, 0xed, 0xf3, 0x3b, 0xe0, 0x6d, 0x0a, 0xc9, 0x6f, 0x78,
	0x9b, 0x82, 0xaa, 0xf4, 0x1f, 0x11, 0xac, 0x84, 0x2b, 0xea, 0xf8, 0x6d, 0xe1, 0x57, 0x5f, 0x54,
	0xd3, 0xa2, 0xde, 0x81, 0x1c, 0x77, 0xea, 0x39, 0xfa, 0xf2, 0x6b, 0x04, 0xe0, 0xca, 0x96, 0x42,
	0xaf, 0x9d, 0x80, 0xca, 0x39, 0xea, 0xb5, 0xf3, 0x16, 0x83, 0x79, 0x5f, 0xda, 0x14, 0x2d, 0x2f,
	0x93, 0xcf, 0xb7, 0x58, 0x60, 0xfa, 0xe6, 0x71, 0x30, 0x32, 0x49, 0x48, 0x1c, 0xa3, 0x57, 0x41,
	0x7a, 0xe1, 0x18, 0x99, 0x42, 0xe9, 0x62, 0x7c, 0x86, 0x60, 0xd6, 0x91, 0x14, 0xf0, 0xe6, 0x39,
	0x04, 0x88, 0x51, 0x08, 0x77, 0x18, 0xc2, 0x7b, 0xd2, 0x6d, 0x51, 0x84, 0x26, 0x39, 0x35, 0x43,
	0x8a, 0xc8, 0x8e, 0xe9, 0xe2, 0x45, 0xf4, 0x9e, 0xea, 0x5f, 0x78, 0x11, 0x15, 0xea, 0xdc, 0xc5,
	0xf8, 0x27, 0x6b, 0x1f, 0xc6, 0x4f, 0xb6, 0xa2, 0xfb, 0x30, 0xbf, 0x2c, 0x90, 0x1c, 0xe3, 0xec,
	0x2c, 0x1d, 0x30, 0xc0, 0x7b, 0x38, 0x7f, 0xde, 0x01, 0xca, 0xd8, 0x87, 0x6f, 0x3a, 0x4b, 0xff,
	0xe0, 0xdb, 0x34, 0xfb, 0x80, 0x2f, 0xbc, 0x4d, 0x1b, 0x50, 0x25, 0x84, 0xb7, 0x69, 0x83, 0x4a,
	0x42, 0x58, 0x3e, 0xc3, 0x1a, 0x10, 0xfa, 0x4a, 0x70, 0x52, 0xc2, 0xff, 0x44, 0xb0, 0x1a, 0xa1,
	0x13, 0xe0, 0xac, 0xf0, 0x4e, 0x3e, 0xea, 0x3c, 0x99, 0x3c, 0xd7, 0x19, 0x57, 0xda, 0x62, 0x29,
	0xde, 0x91, 0x32, 0x43, 0x77, 0xa2, 0xc1, 0x83, 0x30, 0xe5, 0xd7, 0x5f, 0x11, 0x2c, 0x87, 0x09,
	0x0b, 0xf8, 0xad, 0xb1, 0x3e, 0xaa, 0x2f, 0x2a, 0x95, 0x7b, 0x2c, 0x95, 0x0d, 0x9c, 0x89, 0x66,
	0x5f, 0x30, 0x0f, 0x4a, 0xb4, 0x7f, 0x23, 0x58, 0x09, 0x97, 0x17, 0xf0, 0x98, 0x1f, 0xc3, 0xa0,
	0x4e, 0x92, 0xcc, 0x3e, 0x87, 0x07, 0x4e, 0xc3, 0x90, 0xc4, 0x84, 0x7a, 0x84, 0x3f, 0x43, 0xb0,
	0x1a, 0xa1, 0x42, 0x08, 0x31, 0x6e, 0xb8, 0x82, 0x11, 0xf9, 0x1d, 0xe5, 0x78, 0x53, 0x63, 0x37,
	0xe2, 0x37, 0x08, 0xe2, 0x01, 0xf9, 0x03, 0x6f, 0x0b, 0xcf, 0x46, 0x50, 0x81, 0x18, 0xf5, 0x8a,
	0xbd, 0xc3, 0xa0, 0xa6, 0xa5, 0x37, 0x86, 0x96, 0xd6, 0x7b, 0x8c, 0xa7, 0xc4, 0xff, 0x0c, 0xc1,
	0xa2, 0x5f, 0x20, 0xc1, 0xf7, 0xc5, 0x28, 0x1f, 0x82, 0x70, 0x4c, 0x51, 0x41, 0xda, 0x60, 0x90,
	0x6f, 0xe2, 0x37, 0xa2, 0xab, 0xeb, 0xc5, 0x4b, 0xeb, 0xfa, 0x05, 0x82, 0xd8, 0xa0, 0xd4, 0x81,
	0xb7, 0x04, 0x89, 0x19, 0xa2, 0xd3, 0x24, 0xb7, 0xcf, 0x65, 0xcb, 0xe9, 0x1c, 0x92, 0xc0, 0x88,
	0x9a, 0xe3, 0x5f, 0x21, 0x88, 0x07, 0x44, 0x26, 0x21, 0x62, 0x44, 0x49, 0x53, 0x91, 0xe4, 0xe5,
	0xe8, 0x52, 0xe2, 0xe5, 0xdd, 0x3d, 0x85, 0xd7, 0x1a, 0x7a, 0x67, 0x34, 0x98, 0x43, 0xf4, 0x9d,
	0xf7, 0xf8, 0x43, 0x2d, 0xbd, 0xad, 0x68, 0xad, 0xb4, 0xde, 0x6b, 0x65, 0x5a, 0x44, 0x63, 0x10,
	0xf8, 0xef, 0x12, 0x95, 0xae, 0x6a, 0x0c, 0xf9, 0xd1, 0xdf, 0xb6, 0x77, 0xb1, 0x3e, 0xc3, 0x2c,
	0x37, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x26, 0x81, 0x0d, 0xe1, 0x91, 0x29, 0x00, 0x00,
}
