// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (210B)
// assets/dns/configmap.yaml (434B)
// assets/dns/daemonset.yaml (4.679kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (381B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8d\xbd\x6e\xc5\x30\x08\x46\x77\x3f\x05\xba\x7b\x52\x75\xab\xbc\x76\xe8\xde\xa1\x3b\xd7\xa6\x0a\x8a\x03\x16\xe0\x54\xea\xd3\x5f\xe5\x67\x3b\xe7\x08\xf4\xad\x2c\x35\xc3\x67\x1b\x1e\x64\xdf\xda\x28\x61\xe7\x1f\x32\x67\x95\x0c\xf6\xc4\x32\xe3\x88\x45\x8d\xff\x31\x58\x65\x5e\x3f\x7c\x66\x7d\xdb\xdf\xd3\x46\x81\x15\x03\x73\x02\x10\xdc\x28\x83\x76\x12\x5f\xf8\x37\xa6\x2a\x9e\x6c\x34\xf2\x9c\x26\xc0\xce\x5f\xa6\xa3\xfb\x71\x39\xc1\xe3\x91\x00\x8c\x5c\x87\x15\xba\x1b\x49\xed\xca\x12\x7e\x9a\x93\xed\x5c\xe8\x92\xae\xf5\x82\x63\xc3\x3b\x5e\x7d\x27\x7b\xde\xbf\x8d\x3d\x4e\xf8\xc3\x28\x4b\x7a\x05\x00\x00\xff\xff\xcb\xdd\xd7\x2a\xd2\x00\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 210, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x37, 0xb2, 0x0, 0x7d, 0x4a, 0xd9, 0xf, 0x8, 0x44, 0xe7, 0xab, 0x82, 0xe4, 0x50, 0x94, 0xaa, 0x4e, 0xfd, 0xa0, 0x63, 0xba, 0x18, 0xcf, 0xeb, 0xa6, 0xe4, 0x2d, 0x4, 0x35, 0xd5, 0xc7, 0xd}}
	return a, nil
}

var _assetsDnsConfigmapYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x4e\xcd\x4e\xf3\x30\x10\xbc\xe7\x29\x46\xfa\xce\x5f\x4a\x15\x15\x89\x5c\x7b\xe6\xca\x7d\xb1\x27\x8d\x55\xc7\x36\xeb\x75\x11\x02\xde\x1d\xb5\x95\x82\x2a\x3a\xa7\xf9\xd3\xec\x1e\x43\xf2\x23\xf6\x39\x4d\xe1\xf0\x2c\xa5\x93\x12\x5e\xa8\x35\xe4\x34\xe2\xb4\xed\xfe\x21\xc9\x42\x48\xf2\x17\x52\x8b\x38\x42\x94\xa8\x34\x88\x41\x5b\xb2\xb0\xb0\xf3\x62\x32\x76\xc0\x3e\x2b\xa7\x10\x39\xe2\xab\x03\x80\x7e\xdc\x0d\xbb\x01\x9f\x17\x71\x06\x55\xb3\xd6\x55\xce\x94\x68\xf3\x2a\x8f\xed\x95\x9a\x68\xac\x70\xb1\x55\xa3\xf6\x31\x3b\x89\x08\xe9\xbf\x78\xaf\xbd\x68\x11\x84\xf2\x78\x25\xbf\xb3\x67\x94\xec\x2b\x42\xaa\x74\x4d\x79\x93\xb4\x52\x4d\x29\xcb\x8d\x39\x49\x8c\x36\x6b\x6e\x87\xf9\xfe\xfc\xda\xfe\x5e\x59\xd1\xbc\xd0\x66\xb6\x8a\xf1\x69\xbb\x1b\xd6\x60\xca\xfa\x2e\xea\xd1\x63\x43\x73\x1b\x65\xcd\xf1\xd4\xbb\x9c\xa6\x3f\x4f\xc6\xe0\x3e\x50\xf9\xd6\x98\x2c\x48\xbc\x73\xc5\x89\x9b\x89\xe1\x61\x35\x94\x31\x8b\xef\xae\xad\x9f\x00\x00\x00\xff\xff\x08\x52\xc6\xab\xb2\x01\x00\x00")

func assetsDnsConfigmapYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsConfigmapYaml,
		"assets/dns/configmap.yaml",
	)
}

func assetsDnsConfigmapYaml() (*asset, error) {
	bytes, err := assetsDnsConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/configmap.yaml", size: 434, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0x76, 0xcf, 0x25, 0x4e, 0xbd, 0x12, 0xda, 0x28, 0x18, 0x55, 0x70, 0xc2, 0x65, 0xe, 0x94, 0x40, 0x52, 0x25, 0x71, 0x45, 0xb8, 0xdf, 0xfe, 0x66, 0x8a, 0xa6, 0x6c, 0xa6, 0x90, 0xc7, 0x29}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x58\x5f\x73\xdb\xb8\x11\x7f\xd7\xa7\xd8\xa3\x3c\x71\x32\x35\xfd\xa7\x37\xbe\x5e\x99\xf8\x7a\xae\x2d\x37\x9e\x46\xb6\xc6\x52\xae\x0f\x1e\x4f\x06\x02\x97\xe2\xd6\x20\x80\x03\x40\x3a\x1a\xc7\xdf\xbd\x03\xd2\x94\x40\x4a\x55\xa7\x73\x2f\xc9\x43\x62\x63\x77\x7f\xd8\x5d\xec\x6f\x77\x99\x47\x92\x69\x02\x97\x0c\x0b\x25\xa7\xe8\x06\x4c\xd3\x6f\x68\x2c\x29\x99\x00\xd3\xda\x1e\x55\x27\x83\x21\x48\x56\xe0\x41\xfd\xb7\xd5\x8c\x23\x30\x99\x82\x60\x73\x14\x16\x98\x41\xb0\xe8\x80\x39\x30\xa5\x74\x54\xe0\xc0\x6a\xe4\xc9\x00\xc0\x61\xa1\x05\x73\xe8\x7f\x06\x68\x4f\xeb\x9f\xd1\x54\xc4\xf1\x9c\x73\x55\x4a\x77\xc3\x0a\x4c\x20\x95\xf6\x55\xaa\x0d\x29\x43\x6e\x79\x21\x98\xb5\x8d\xd0\x2e\xad\xc3\x22\x96\x2a\xc5\x98\x1b\x72\xc4\x99\x78\xd5\xe6\x4a\x3a\x46\x12\x8d\x6d\xd1\xe3\xda\xd3\x10\x11\x60\x08\x54\xb0\x05\x02\xd9\xbe\xb7\xad\x46\x2d\x9f\x94\x42\x4c\x94\x20\xbe\x4c\xe0\x3a\xbb\x51\x6e\x62\xd0\xa2\x74\x2b\x2d\x87\xa6\x20\xc9\x1c\x29\x39\x46\x6b\xbd\xc9\xab\xfa\x15\x13\x62\xce\xf8\xe3\x4c\x7d\x52\x0b\x7b\x2b\x47\xc6\x28\xb3\xb2\xe3\xaa\x28\x98\x4f\xf5\x3d\x44\x5c\x19\x4c\xa5\x8d\xe0\x61\x25\x66\x66\x61\x6b\x59\xcc\x95\xcc\xa2\x03\x88\x8e\xd0\xf1\xa3\x57\xcd\xa3\x0b\x65\x30\x23\x81\xa1\x49\xa5\x44\x59\xe0\xd8\x27\x70\x15\xf9\x3a\x76\x0f\x43\x8b\xb8\x51\x5a\x49\x01\x0a\xaf\x3f\x61\x2e\x4f\x20\xbc\x21\xd0\x30\xc8\xd2\x5b\x29\x96\x09\x38\x53\xae\x4d\xb5\x32\xdd\x7b\x56\x79\x9f\x28\xe3\x12\x38\xfd\xf1\xf4\xc7\x00\x65\xf3\x05\xfc\xbb\x2a\xa7\xb8\x12\x09\x7c\xbe\x9c\xfc\xff\x48\xb1\xe3\x7a\x2b\xda\xec\x62\x07\xda\x5f\x4f\xb6\xa0\x15\xe8\x0c\xf1\xed\xbe\x85\x68\x3e\x17\x24\xd1\xda\x89\x51\x73\x4c\x02\xfd\xdc\x39\xfd\x0f\x74\xe1\x11\x80\x6e\xf2\x9a\x23\x13\x2e\xef\x4a\x6a\x5f\x7e\x3e\xfe\xf9\xb8\x73\x6c\x79\x8e\xde\x9f\x8f\xb3\xd9\x24\x10\x90\x24\x47\x4c\x5c\xa2\x60\xcb\x29\x72\x25\x53\x9b\xc0\x49\x68\xaa\xd1\x90\x4a\xb7\xcb\x6c\xc9\x39\x5a\x3b\xcb\x0d\xda\x5c\x89\x34\x81\x93\x40\x9a\x31\x12\xa5\xc1\x40\x1a\xa6\xc7\x33\x42\x95\x6e\x1b\xb0\xa0\x0a\xbf\x93\x54\xfc\x74\xbc\xc3\xe5\xd3\x3f\x90\x8a\xd3\xe0\xe5\xad\x2a\x0d\x47\x1b\x86\x25\xa8\x20\x67\xbb\x81\x16\x58\x28\xb3\x4c\xe0\xf4\xe4\xcf\x63\xea\xd0\xe8\xf7\x12\x6d\x5f\x9b\xeb\xd2\x27\xf5\xb8\xd8\x8a\xf1\x97\xe3\x15\x44\xd0\xc3\x9a\xae\xe7\x1d\x12\x15\x9a\xef\xa6\xa3\x59\xe4\x65\xdd\xa5\x95\x74\xf8\xb5\xf3\xfc\xda\x50\x45\x02\x17\x98\xf6\x9a\xc8\xee\x9e\x95\x2b\xeb\x6c\xec\xfb\xdc\x8e\x86\x55\x2b\x05\x49\x40\x59\xc1\xcd\xf9\x78\x34\x1d\xdd\xfd\x36\xba\xab\x27\xd3\xc5\xa7\xcf\xd3\xd9\xe8\xee\xcb\xe5\xed\xf8\xfc\xfa\x66\xdb\x84\x6a\xcd\x51\x56\x9b\x6e\x78\xa4\xeb\x8b\xd1\x34\x70\x62\x08\x17\xbe\x7f\x83\x32\xd0\x0c\x40\x8b\x9a\x19\xe6\x30\x05\x41\xd6\x81\xca\xda\x91\x66\x3b\x56\x37\xb7\xb3\x51\x02\x57\xca\x80\x54\x4f\x07\x80\xd2\x96\x06\xc1\xe5\x68\xb1\x76\xcb\xa0\x60\x8e\x2a\x6c\x46\xeb\x7b\xc8\x94\x01\x64\x3c\xef\x0a\x0e\x3a\x98\x4c\x02\x13\xc4\x2c\x3c\x91\xcb\x3d\x56\x3f\x5e\x5b\x66\x19\x7d\x85\x27\x12\x02\x98\xb0\x0a\xe6\x08\x2c\x4d\x31\x3d\x0c\x70\x2a\x26\x4a\x4c\x20\xaa\x6b\x24\x36\xb8\x20\xeb\xcc\xf2\x50\x69\x94\x36\xa7\xcc\xc5\x3d\x81\xad\x78\xb4\x31\xcc\x82\xd4\x1d\xcd\x49\x1e\xcd\x99\xcd\x83\xb3\x98\x07\xbf\x7c\x0b\x83\xf8\x61\x53\x1d\xea\x37\x8a\x4b\x05\x9a\x34\x7a\x6a\x0e\x42\x92\x1b\xa6\x61\xff\xd1\x87\xb4\xf7\xf6\xdf\x6a\x6e\x21\xd6\xef\xde\x03\x7e\x25\x07\xc7\xfb\x30\x1b\xdd\x8d\x43\xf5\xdb\xc9\xe8\x66\xfa\xf1\xfa\x6a\xf6\x65\x7c\x7e\xf7\xcf\xd1\xdd\x59\xb4\x0e\x6c\x81\x12\xeb\xa7\xeb\xf2\x2a\x0a\xcc\x3f\xde\x4e\x67\xd3\x2f\x57\xd7\x9f\x46\x67\xd1\xba\xe8\x42\x8d\xd9\x68\x3c\xd9\x50\x38\x74\x85\x8e\x42\x37\xae\xaf\xa6\x67\xfb\x07\xb0\x5f\xcf\x11\x88\x0d\xc4\x6c\x55\x27\xf0\xe1\xc3\x07\x88\xf6\x9e\xdb\x6a\x7b\xe9\x58\x0e\x61\xcc\x1e\x11\x58\xbd\x43\x29\xc3\xcc\x12\x3c\x2f\xd6\x6f\xae\x44\xda\xf0\xa5\x3e\xdf\xb7\xc0\x9c\x33\x34\x2f\x1d\xda\xf0\x99\xb9\x86\x38\x83\x38\x5e\x4b\x63\x25\xc5\xd2\x5f\xbc\x0e\xf2\x25\xf2\xbf\xaf\x42\xea\x7a\xf2\x94\xfb\x7b\x3d\x8b\xdf\x43\xaa\x3a\x6d\x2b\x45\x2e\x7c\x15\xc7\xe7\x60\x2b\xfe\x85\xb4\xed\x88\x7d\x31\xdb\x8a\x03\x49\x0f\xdf\xc6\x7d\xff\xeb\xc3\x4b\xb4\x01\xe5\x23\xbe\x42\xc7\xf3\x36\x3f\x70\x3d\x81\xcc\xa8\x02\xb8\x28\xad\x43\xe3\x1b\x21\x50\x06\xba\xd7\xbd\x9a\x3f\xa4\xed\xd9\xdb\xbd\xb7\x29\x2d\xe0\xd7\x68\xef\x79\xdd\x0f\x5e\x22\xf8\x93\xcd\x95\x71\xb5\x0b\x15\x7f\x39\xdc\x7b\xee\xd2\xe5\x25\x7a\xf7\x6e\xd0\x87\xcb\xe0\xfe\x1e\xa2\xbd\xbf\x45\x10\xe3\xef\x70\x0c\x6f\xde\x78\xfb\x21\xe9\xc6\x7d\x88\x25\xc2\x31\x3c\x3c\xbc\xf7\x6f\x21\x7b\xd6\xd0\x66\xe3\xfe\xf5\xce\xe8\xe1\x2c\xda\x7b\x6e\x8d\x7b\xda\x19\x75\x73\xaa\x24\x76\xdd\x19\xc2\x67\x9d\x32\x87\x41\xfb\x83\xfa\x0d\x29\x83\x27\x84\x05\x3a\x4f\x66\x4a\x83\xcc\xd9\x1e\xc0\xbf\xb0\xe9\x06\x52\x39\x28\x37\xc0\x9e\x72\x94\x3e\x0e\x53\xcf\x92\xd7\x85\x70\x85\xa6\x4a\xe7\xa7\x8c\x32\xc0\x34\x41\x29\x59\xc5\x48\xb0\x39\x09\x72\xcb\xde\x35\x53\xc7\x04\x02\x4a\x67\x08\x3d\x50\x29\x52\xcf\x50\xeb\x7c\x09\x04\x17\x52\x56\x97\x70\x7b\x03\x59\x48\x51\xa0\xc3\x74\xb0\xed\x11\x9e\x87\x6d\x3a\xff\x77\xea\x87\xf0\xf7\x92\x44\x0a\x0c\x24\x3e\x05\xfc\x68\x4a\x29\x8c\xd9\xf3\x48\x95\x06\x78\x69\x9d\x2a\x56\x4e\x67\x24\x1c\x1a\x4c\x7d\xd8\x3d\xec\x85\x41\x0d\x71\x05\xd1\x10\xf6\x9e\xfb\x0d\xa6\xa1\x50\x87\x52\xbf\xec\x20\x55\xe3\xeb\xb9\xd6\x28\x53\x68\x3b\xd0\xda\x09\x4f\x9c\xcd\x71\x02\x1b\x9c\xfa\x21\xcc\xcc\x16\x4e\x35\xfa\xa4\xbd\x7a\x5d\x8a\xb5\x72\x53\x94\x0f\x2f\x5b\x0d\x00\x90\xe7\x0a\xea\x7a\x7d\x69\x8c\xda\x7f\x36\xa9\x03\xff\x25\x15\xbf\x6c\xc4\xde\xbf\xa4\x2e\xf3\x2d\x47\x1b\x39\x9a\xdd\x5e\xde\x26\x5b\x18\xc0\x9c\x2a\xfc\x47\xa0\x58\x82\x53\xc0\x2a\x45\x29\x30\xb9\x04\x92\x5c\x49\x4b\xd6\xa1\x74\x30\xc7\x9c\x55\x14\xec\x2c\x2d\xea\x1d\x6a\xe1\xc7\xf8\xb6\x8a\x28\x54\x4a\x19\x61\x0a\x55\xf3\x1d\xec\x0b\x51\x22\xa6\xbd\xf2\x04\xe0\x85\xee\x85\xb9\x51\x03\xdf\xbe\xbd\x76\xe0\xdd\x7a\x9b\x51\xb7\xba\x9e\x1c\x9e\xb5\x06\x0b\x55\x61\xba\x8e\xb5\xae\x6a\x6e\x90\x39\x3c\x6a\xd8\x53\xaf\x3e\xeb\x3e\x0f\x5c\xe9\x25\xf0\xbc\x34\x5d\x92\xf4\xfa\x8d\x15\x88\x1a\x7e\x3a\x86\x37\xf0\xc4\xa8\x5b\xf3\xa5\xf4\x23\x79\xb3\xb5\x77\x1e\x6f\xeb\xa2\xbc\x73\xf9\x6d\x77\xdf\x54\xda\x76\xd3\xbc\xc4\x8c\x95\xa2\xbd\xdd\xcf\xe5\x29\x0a\xe4\x4e\x99\x35\xc2\x63\x39\x47\x23\xd1\x0f\x38\x52\x47\xca\x26\x20\x48\x96\x5f\x1b\xe1\xab\x56\xb3\x5f\x6e\xfc\x47\xc0\xf6\x8f\xe1\xe6\x74\xcc\x74\x12\xac\x93\x37\xac\xd8\xb5\x52\x03\x90\xc3\xa2\x13\x57\x0c\x8f\xb8\x4c\xa0\xfd\x44\xdf\xf2\x15\xd4\x13\xed\x58\x77\xfd\x51\xbd\xeb\x0e\xfa\x18\x5b\x76\x5f\x00\xb7\xd4\x98\xc0\xd5\x1a\xc1\x29\xe1\x77\x1b\x52\x72\xe5\xe2\x10\x2e\x6f\xa6\x75\x01\x5b\x5f\x3d\xa6\x94\x80\x15\x9a\xe5\x93\x6f\xf8\x87\x83\x4e\x0c\x51\xb3\x11\x29\x81\x87\xdd\x6c\x17\xcc\xcf\xe0\x75\x9d\x2a\xed\xaf\x51\x26\x81\x91\xef\xef\x76\xf0\x9f\x00\x00\x00\xff\xff\x3e\x73\xf8\xde\x47\x12\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 4679, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x3f, 0xb5, 0xb4, 0x51, 0x74, 0x92, 0xa9, 0x86, 0xd1, 0x6c, 0x26, 0xf, 0x2c, 0x2e, 0x59, 0xab, 0x85, 0x78, 0xd7, 0x15, 0x2c, 0x46, 0x3b, 0xcc, 0x31, 0x65, 0x8a, 0x42, 0x67, 0x77, 0x33, 0x15}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\xce\x3d\x4b\x04\x31\x10\xc6\xf1\x3e\x9f\xe2\x81\x6b\x3d\xe1\x10\x0b\xd3\x6a\x63\xb7\xe0\x4b\x3f\x97\x1d\x8e\xe0\xe4\x85\x99\xd9\x13\xbf\xbd\x18\xe1\xdc\x15\xc1\x26\x90\xe4\xcf\x8f\xe7\x2d\xd7\x39\xe2\x89\xf5\x9c\x13\x07\xea\xf9\x95\xd5\x72\xab\x11\xe7\x43\xd8\xa1\x52\xe1\xab\x71\x5a\xa7\xc4\xa0\x3a\x43\xe8\xc8\x62\x20\x65\x18\x3b\xc8\xa1\x4b\xf5\x5c\x38\x58\xe7\x14\x03\xb0\x43\x92\xc5\x9c\xf5\x71\xc2\x7b\x16\xc1\x91\x41\x8b\xb7\x42\x9e\x13\x89\x7c\xa0\x50\xa5\x13\xcf\xd7\x23\x36\x16\x4e\xde\x14\xd9\x7e\x8b\x40\x6f\xea\xf6\x85\xee\xc7\x8c\x88\xb9\x5a\x00\xbe\x3f\x22\x6e\x6f\xc6\xc5\x49\x4f\xec\xd3\x78\xba\x04\xda\xbc\xa5\x26\x11\x2f\x0f\xd3\x16\xd8\x7b\xea\xff\x22\x3f\xd1\x05\x7a\xbe\x5f\x43\x85\x5d\x73\x5a\xaf\xb9\x3b\xfc\x41\x6d\xb2\x0d\xf5\x19\x00\x00\xff\xff\xc5\xcb\x88\xa8\x7d\x01\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 381, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa9, 0x6d, 0x77, 0x15, 0x61, 0x5f, 0x22, 0x3d, 0xd7, 0x33, 0xf2, 0xcf, 0xe0, 0xbd, 0x5d, 0xc6, 0xf1, 0x17, 0x84, 0xff, 0x81, 0xdb, 0x33, 0xd0, 0x30, 0x3b, 0xe3, 0x8e, 0x8e, 0x39, 0x8d, 0x48}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/configmap.yaml": assetsDnsConfigmapYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"configmap.yaml":            {assetsDnsConfigmapYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
