// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (210B)
// assets/dns/configmap.yaml (434B)
// assets/dns/daemonset.yaml (5.363kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (381B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8d\xbd\x6e\xc5\x30\x08\x46\x77\x3f\x05\xba\x7b\x52\x75\xab\xbc\x76\xe8\xde\xa1\x3b\xd7\xa6\x0a\x8a\x03\x16\xe0\x54\xea\xd3\x5f\xe5\x67\x3b\xe7\x08\xf4\xad\x2c\x35\xc3\x67\x1b\x1e\x64\xdf\xda\x28\x61\xe7\x1f\x32\x67\x95\x0c\xf6\xc4\x32\xe3\x88\x45\x8d\xff\x31\x58\x65\x5e\x3f\x7c\x66\x7d\xdb\xdf\xd3\x46\x81\x15\x03\x73\x02\x10\xdc\x28\x83\x76\x12\x5f\xf8\x37\xa6\x2a\x9e\x6c\x34\xf2\x9c\x26\xc0\xce\x5f\xa6\xa3\xfb\x71\x39\xc1\xe3\x91\x00\x8c\x5c\x87\x15\xba\x1b\x49\xed\xca\x12\x7e\x9a\x93\xed\x5c\xe8\x92\xae\xf5\x82\x63\xc3\x3b\x5e\x7d\x27\x7b\xde\xbf\x8d\x3d\x4e\xf8\xc3\x28\x4b\x7a\x05\x00\x00\xff\xff\xcb\xdd\xd7\x2a\xd2\x00\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 210, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x37, 0xb2, 0x0, 0x7d, 0x4a, 0xd9, 0xf, 0x8, 0x44, 0xe7, 0xab, 0x82, 0xe4, 0x50, 0x94, 0xaa, 0x4e, 0xfd, 0xa0, 0x63, 0xba, 0x18, 0xcf, 0xeb, 0xa6, 0xe4, 0x2d, 0x4, 0x35, 0xd5, 0xc7, 0xd}}
	return a, nil
}

var _assetsDnsConfigmapYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x4e\xcd\x4e\xf3\x30\x10\xbc\xe7\x29\x46\xfa\xce\x5f\x4a\x15\x15\x89\x5c\x7b\xe6\xca\x7d\xb1\x27\x8d\x55\xc7\x36\xeb\x75\x11\x02\xde\x1d\xb5\x95\x82\x2a\x3a\xa7\xf9\xd3\xec\x1e\x43\xf2\x23\xf6\x39\x4d\xe1\xf0\x2c\xa5\x93\x12\x5e\xa8\x35\xe4\x34\xe2\xb4\xed\xfe\x21\xc9\x42\x48\xf2\x17\x52\x8b\x38\x42\x94\xa8\x34\x88\x41\x5b\xb2\xb0\xb0\xf3\x62\x32\x76\xc0\x3e\x2b\xa7\x10\x39\xe2\xab\x03\x80\x7e\xdc\x0d\xbb\x01\x9f\x17\x71\x06\x55\xb3\xd6\x55\xce\x94\x68\xf3\x2a\x8f\xed\x95\x9a\x68\xac\x70\xb1\x55\xa3\xf6\x31\x3b\x89\x08\xe9\xbf\x78\xaf\xbd\x68\x11\x84\xf2\x78\x25\xbf\xb3\x67\x94\xec\x2b\x42\xaa\x74\x4d\x79\x93\xb4\x52\x4d\x29\xcb\x8d\x39\x49\x8c\x36\x6b\x6e\x87\xf9\xfe\xfc\xda\xfe\x5e\x59\xd1\xbc\xd0\x66\xb6\x8a\xf1\x69\xbb\x1b\xd6\x60\xca\xfa\x2e\xea\xd1\x63\x43\x73\x1b\x65\xcd\xf1\xd4\xbb\x9c\xa6\x3f\x4f\xc6\xe0\x3e\x50\xf9\xd6\x98\x2c\x48\xbc\x73\xc5\x89\x9b\x89\xe1\x61\x35\x94\x31\x8b\xef\xae\xad\x9f\x00\x00\x00\xff\xff\x08\x52\xc6\xab\xb2\x01\x00\x00")

func assetsDnsConfigmapYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsConfigmapYaml,
		"assets/dns/configmap.yaml",
	)
}

func assetsDnsConfigmapYaml() (*asset, error) {
	bytes, err := assetsDnsConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/configmap.yaml", size: 434, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0x76, 0xcf, 0x25, 0x4e, 0xbd, 0x12, 0xda, 0x28, 0x18, 0x55, 0x70, 0xc2, 0x65, 0xe, 0x94, 0x40, 0x52, 0x25, 0x71, 0x45, 0xb8, 0xdf, 0xfe, 0x66, 0x8a, 0xa6, 0x6c, 0xa6, 0x90, 0xc7, 0x29}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x58\x6d\x73\xdb\xb8\x11\xfe\xee\x5f\xf1\x84\xf6\xc4\x49\xcf\xf4\x4b\x73\x49\xaf\x4c\x7c\x3d\xd7\x96\x1b\xcf\xc5\xb6\xc6\x52\xee\x3e\x78\x3c\x19\x08\x5c\x89\xa8\x41\x00\x07\x80\xb4\x35\xb6\xfe\x7b\x07\xa4\x5e\x48\x51\x75\xa7\xed\xdc\xcc\xe5\x83\x62\x61\x17\x0f\x76\x17\xbb\xcf\x2e\x74\x2f\x54\x9a\xe0\x8c\x51\xae\xd5\x80\xfc\x16\x33\xe2\x17\xb2\x4e\x68\x95\x80\x19\xe3\x0e\xca\xa3\xad\x6d\x28\x96\xd3\x5e\xf5\xe9\x0c\xe3\x04\xa6\x52\x48\x36\x22\xe9\xc0\x2c\xc1\x91\x07\xf3\xb0\x85\xf2\x22\xa7\x2d\x67\x88\x27\x5b\x80\xa7\xdc\x48\xe6\x29\xfc\x0d\x2c\x56\xab\xbf\xc9\x96\x82\xd3\x09\xe7\xba\x50\xfe\x8a\xe5\x94\x20\x55\x6e\x2e\x35\x56\x68\x2b\xfc\xf4\x54\x32\xe7\x6a\xa1\x9b\x3a\x4f\x79\xac\x74\x4a\x31\xb7\xc2\x0b\xce\xe4\x5c\x9b\x6b\xe5\x99\x50\x64\xdd\x02\x3d\xae\x2c\x6d\x22\x02\xdb\x10\x39\x9b\x10\x84\x5b\xb7\x76\xa1\x51\xc9\xfb\x85\x94\x7d\x2d\x05\x9f\x26\xb8\x18\x5f\x69\xdf\xb7\xe4\x48\xf9\xa5\x96\x27\x9b\x0b\xc5\xbc\xd0\xea\x92\x9c\x0b\x5b\xe6\xea\xe7\x4c\xca\x11\xe3\xf7\x43\xfd\x45\x4f\xdc\xb5\xea\x59\xab\xed\x72\x1f\xd7\x79\xce\x42\xa8\x6f\x11\x71\x6d\x29\x55\x2e\xc2\xdd\x52\xcc\xec\xc4\x55\xb2\x98\x6b\x35\x8e\xf6\x10\x1d\x90\xe7\x07\x73\xcd\x83\x53\x6d\x69\x2c\x24\x35\xb7\x94\x5a\x16\x39\x5d\x86\x00\x2e\x3d\x5f\xf9\x1e\x60\xc4\x24\xae\x95\x96\x52\x20\x0f\xfa\x7d\xe6\xb3\x04\xcd\x13\x1a\x1a\x96\x58\x7a\xad\xe4\x34\x81\xb7\xc5\x6a\xab\xd1\xb6\x7d\xce\x32\xee\x7d\x6d\x7d\x82\xf7\xef\xde\xbf\x6b\xa0\x74\x6f\x20\xdc\xab\xf6\x9a\x6b\x99\xe0\xeb\x59\xff\xbf\x47\x8a\x3d\x37\x1b\xd1\x86\xa7\x2f\xa0\xfd\xf5\x68\x03\x5a\x4e\xde\x0a\xbe\xd9\xb6\x26\x5a\x88\x85\x50\xe4\x5c\xdf\xea\x11\x25\x0d\xfd\xcc\x7b\xf3\x0f\xf2\xcd\x25\xc0\xd4\x71\xcd\x88\x49\x9f\xb5\x25\x95\x2d\x3f\x1c\xfe\x70\xd8\x5a\x76\x3c\xa3\x60\xcf\xe7\xe1\xb0\xdf\x10\x08\x25\xbc\x60\xf2\x8c\x24\x9b\x0e\x88\x6b\x95\xba\x04\x47\xcd\xad\x86\xac\xd0\xe9\x66\x99\x2b\x38\x27\xe7\x86\x99\x25\x97\x69\x99\x26\x38\x6a\x48\xc7\x4c\xc8\xc2\x52\x43\xda\x0c\x4f\xa8\x08\x5d\xf8\x4d\xc0\x52\x94\xf4\x07\x09\xc5\x87\xc3\x17\x4c\x7e\xff\x7f\x84\xe2\x7d\xe3\xe6\x9d\x2e\x2c\x27\xd7\x74\x4b\x8a\x5c\x78\xd7\x76\x34\xa7\x5c\xdb\x69\x82\xf7\x47\x7f\xbe\x14\xad\x32\xfa\xad\x20\xb7\xae\xcd\x4d\x11\x82\x7a\x98\x6f\xc4\xf8\xcb\xe1\x12\xa2\xc1\x61\x35\xeb\x05\x83\x64\x49\xf6\x0f\xc3\x68\x8e\x78\x51\xb1\xb4\x56\x9e\x1e\x5b\xd7\x6f\xac\x28\x85\xa4\x09\xa5\x6b\x24\xf2\x32\x67\x65\xda\x79\x17\x07\x9e\x7b\x81\xb0\x2a\xa5\x46\x10\x48\x95\xb8\x3a\xb9\xec\x0d\x7a\x37\xbf\xf4\x6e\xaa\xce\x74\xfa\xe5\xeb\x60\xd8\xbb\xf9\x76\x76\x7d\x79\x72\x71\xb5\xa9\x43\x2d\xb6\x93\x2a\xbb\x66\x04\xa4\x8b\xd3\xde\xa0\x61\xc4\x36\x4e\x03\x7f\x43\x5b\xd4\x0d\xd0\x91\x61\x96\x79\x4a\x21\x85\xf3\xd0\xe3\x45\x4b\x73\xad\x5d\x57\xd7\xc3\x5e\x82\x73\x6d\xa1\xf4\xc3\x1e\x48\xb9\xc2\x12\x7c\x46\x8e\x2a\xb3\x2c\x49\xe6\x45\x49\x75\x6b\xfd\x88\xb1\xb6\x20\xc6\xb3\xb6\x60\xaf\x85\xc9\x14\x98\x14\xcc\xe1\x41\xf8\x2c\x60\xad\xfb\xeb\x8a\xf1\x58\x3c\xe2\x41\x48\x09\x26\x9d\xc6\x88\xc0\xd2\x94\xd2\xfd\x06\x4e\xc9\x64\x41\x09\xa2\x2a\x47\x62\x4b\x13\xe1\xbc\x9d\xee\x6b\x43\xca\x65\x62\xec\xe3\x35\x81\x2b\x79\xd4\x69\x66\x8d\xd0\x1d\x8c\x84\x3a\x18\x31\x97\x35\xd6\x62\xde\xf8\xf2\xdc\x74\xe2\x55\x57\x1d\xd5\x1d\xc5\x85\x86\x11\x86\x42\x69\x6e\x35\x8b\xdc\x32\x83\xdd\x7f\xea\x91\x43\x6c\xf0\x8c\xc7\xd0\x30\x71\x1f\x5c\x7c\x7e\xae\x72\xec\x23\x1e\x98\xf0\x1f\x41\x8f\xc2\xe3\x70\x17\xc3\xde\xcd\x65\x13\xe1\xba\xdf\xbb\x1a\x7c\xbe\x38\x1f\x7e\xbb\x3c\xb9\xf9\xb9\x77\x73\x1c\xad\x7c\x9d\x90\xa2\xea\x36\xdb\xa5\x16\x35\xb6\x7f\xbe\x1e\x0c\x07\xdf\xce\x2f\xbe\xf4\x8e\xa3\x55\x1e\x36\x35\x86\xbd\xcb\x7e\x47\x61\xdf\xe7\x26\x6a\x9a\x71\x71\x3e\x38\xde\xdd\xc3\x6e\xd5\x5a\x10\x5b\xc4\x6c\x99\x3a\xf8\xf4\xe9\x13\xa2\x9d\xa7\x45\x02\xce\x5a\x3b\xb7\x71\xc9\xee\x09\xac\x1a\xab\xb4\x65\x76\x8a\x50\x2a\xab\x34\xd0\x32\xad\x4b\xa8\x5a\xdf\x75\x60\xde\x5b\x31\x2a\x3c\xb9\xe6\xcd\x73\x83\x78\x8c\x38\x5e\x49\x63\xad\xe4\x34\x1c\xbc\x72\x72\x16\x85\xef\x4b\x97\xda\x96\x3c\x64\xe1\xdc\x3a\xe8\xa9\x6e\x31\x59\x4a\x5c\x86\xc4\x8e\x4f\xe0\x4a\xfe\x4d\x18\xd7\x12\x87\xfc\x76\x25\x87\x50\x01\x7e\xe1\xf7\xed\x4f\x77\xb3\xa8\x03\x15\x3c\x3e\x27\xcf\xb3\x45\x7c\x70\xd1\xc7\xd8\xea\x1c\x5c\x16\xce\x93\x0d\xdc\x08\x31\x86\xa9\x09\x6d\x1f\xbf\x12\xf2\x10\x22\x47\x25\x59\x26\xe1\xad\x20\xd7\xc1\xf4\x1a\xa9\x86\xf0\x09\x2e\xfa\xe5\xf7\x7b\xe1\xf3\x43\xf5\xf9\x3d\x74\x49\x36\xf4\xff\x8a\x45\xc2\xfa\x72\x65\x1f\xc3\x8c\xe0\x1f\x34\x24\x0b\xf5\xae\x36\x00\x07\xbf\x83\x83\x29\x19\xa9\xa7\x39\x29\x3f\xaf\xd1\x9f\x0b\x3b\xb5\xd0\x2a\xdc\x10\x59\x5c\x1b\x52\x03\xcf\xf8\x3d\xde\x5c\x0f\xfa\x47\xef\xde\x22\x86\xcf\xb4\xa3\x60\x97\xd2\xbe\x03\xec\x0a\x13\x9a\x66\x98\x9a\x20\x35\x4b\x47\x4c\x32\xc5\xc9\xba\xca\xce\xd0\x68\x44\xc5\x25\x8c\x67\x42\x4d\x70\x76\x35\x80\xcf\xac\x2e\x26\x59\x65\xfa\x1a\x1e\xcf\x53\x77\xfc\x66\x37\x15\x13\xc4\x1e\x27\xf8\x29\xda\x79\x5a\x11\xe8\x2c\xc2\x77\x2e\x0b\xa7\x85\x0b\x2a\xf9\x6c\x7f\xe7\xa9\xcd\x2f\xb3\x68\x77\x0d\xb1\xfe\xb7\x44\x3c\x39\xf9\x1d\x40\xf1\x9d\xe7\xe6\xf7\xb1\xf5\x7f\x45\x7e\xbb\x06\x1d\xee\x5e\x84\xd4\xde\x79\x7a\x15\x82\x7c\xfb\xa7\xbb\xd9\x9a\x4a\x27\xc5\x01\x61\xdc\xf1\x9b\x9d\x37\x54\x32\x19\x0e\xab\x36\x8a\xbb\x59\xf4\x76\x1d\x1e\x21\xd7\x6f\x6f\x11\xed\xfc\x2d\x42\x4c\xbf\xe1\x10\xaf\x5f\x87\x2d\xdb\xc2\xd4\x25\x84\x58\x11\x0e\x71\x77\xf7\x31\xf0\x81\xda\xe0\xf9\xbc\x26\x6f\xe7\x5e\x45\x77\xc7\xd1\xce\xd3\x62\xfb\x06\xfd\x91\x25\x76\xdf\x59\x1f\x8b\x8e\x5b\x8a\xb6\x3a\x0b\xad\x95\x6d\x7c\x35\x29\xf3\xd4\x68\xe2\xa8\x68\x47\x8c\xf1\x40\x98\x90\x0f\x2d\x49\xa4\x8d\x62\x77\x6b\x00\xbf\x52\xdd\xd3\x94\xf6\x28\x3a\x60\x0f\x19\xa9\xe0\xb6\xad\x26\xa2\xf9\xb3\x66\x89\xa6\x0b\x1f\x66\x25\x6d\xc1\x8c\x40\xa1\x58\xc9\x84\x64\x23\x21\x85\x9f\xae\x1d\x33\xf0\x4c\x12\x48\x55\xec\x01\xae\x0b\x99\x86\xa6\xe2\x7c\xb8\xda\xc6\x81\x62\x5c\xb1\xee\xe2\x04\xe1\x90\x92\x24\x4f\xe9\xd6\xa6\x3b\x7b\xda\x5e\xc4\xfe\x3f\xdf\xd4\x36\xfe\x5e\x08\x99\x82\x41\xd1\x43\x83\xd2\x6b\xf6\x6b\xfa\x1c\xd8\x45\x17\x16\xbc\x70\x5e\xe7\x4b\xa3\xc7\x42\x7a\xb2\x94\x06\xb7\xd7\xb0\x27\x96\x0c\xe2\x12\xd1\x36\x76\x9e\xd6\x7b\x62\xcd\xfa\xad\x2e\xf0\xe3\x0b\x7d\xa0\xb6\xf5\xc4\x18\xaa\x68\xa8\x6e\x9a\x2b\x23\x02\xd7\x77\x87\x22\x74\xda\xc0\xab\x66\x64\x36\xb4\x81\x79\x65\x99\xba\xb4\x16\xca\x75\x06\xdf\xcd\x36\x6e\x00\x88\x67\x1a\x55\x72\xcf\xea\x4d\x8b\xff\xba\x95\x8c\x7f\x13\x8a\x1f\x3b\xbe\xaf\x1f\xd2\xc9\xfb\x4d\x99\x1f\x62\x34\xbc\x3e\xbb\x4e\x36\x54\x00\xf3\x3a\x17\x9c\x49\x39\x0d\x6d\x89\x95\x5a\xa4\x60\x6a\x0a\xa1\xb8\x56\x4e\x38\x4f\xca\x63\x44\x19\x2b\x45\x63\xf2\x5e\xa0\xde\x90\x91\x61\x18\xdd\x94\x11\xb9\x4e\xc5\x58\x50\x8a\xb2\xfe\x35\x27\x24\xa2\x22\x4a\xd7\xd2\x33\xb4\x03\xb3\xe6\x66\x27\x07\x9e\x9f\xe7\x43\xc3\xcb\x7a\x5d\xaf\x17\xba\xa1\x38\x42\xd5\x5a\xca\x75\x49\xe9\xca\xd7\x2a\xab\xb9\x25\xe6\xe9\xa0\xae\x9e\xaa\xa5\xad\x46\x13\x70\x6d\xa6\xe0\x59\x61\xdb\x45\xb2\x46\x41\x4e\x12\x19\x7c\x38\xc4\xeb\x6a\x0a\x6c\xc9\x0a\x15\x06\xcb\xee\x34\xd2\xba\xbc\x8d\xcf\xbd\x17\x9f\x70\x8b\x17\x5c\xaa\xdc\xe2\xbd\x74\x46\x63\x56\xc8\xc5\xe9\x61\x94\x1c\x90\x24\xee\xb5\x5d\x21\xdc\x17\x23\xb2\x8a\xc2\x4c\x26\xf4\x81\x76\x09\xa4\x50\xc5\x63\x2d\x9c\x6b\xd5\xaf\xa4\xce\xcf\x59\x9b\x7f\xd2\xa9\x57\x2f\x99\x49\x1a\x8f\xa2\x2b\x96\xbf\xf4\x30\x04\x84\xa7\xbc\xe5\x57\x8c\x7b\x9a\x26\x58\xfc\xd0\xb4\xe1\x2d\xbf\x26\x7a\xe1\xd1\x16\x96\xaa\x17\xdb\xd6\x3a\xc6\x86\x17\x1c\xe0\xa7\x86\x12\x9c\xaf\x10\xbc\x96\x61\x1c\x17\x5a\x2d\x4d\xdc\xae\xa6\x9a\x90\xc0\x2e\x64\x8f\x2d\x14\xc2\x90\x37\x7d\x08\x84\xbf\x8f\x61\xbd\x83\xc0\xa4\x84\x67\x42\x2d\x0f\x88\xa1\x4d\x10\x69\x9b\xa0\x17\x58\xdc\x6d\xfd\x2b\x00\x00\xff\xff\x79\xe9\x02\xb6\xf3\x14\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 5363, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xab, 0x32, 0x70, 0x11, 0x33, 0xc3, 0xf1, 0x7a, 0x29, 0x4b, 0x42, 0x8d, 0x52, 0x10, 0xa, 0xa0, 0xf2, 0x1a, 0x42, 0x17, 0x5a, 0xfd, 0xfb, 0xa9, 0x98, 0x75, 0x38, 0xd3, 0xdb, 0xfe, 0x39, 0x53}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\xce\x3d\x4b\x04\x31\x10\xc6\xf1\x3e\x9f\xe2\x81\x6b\x3d\xe1\x10\x0b\xd3\x6a\x63\xb7\xe0\x4b\x3f\x97\x1d\x8e\xe0\xe4\x85\x99\xd9\x13\xbf\xbd\x18\xe1\xdc\x15\xc1\x26\x90\xe4\xcf\x8f\xe7\x2d\xd7\x39\xe2\x89\xf5\x9c\x13\x07\xea\xf9\x95\xd5\x72\xab\x11\xe7\x43\xd8\xa1\x52\xe1\xab\x71\x5a\xa7\xc4\xa0\x3a\x43\xe8\xc8\x62\x20\x65\x18\x3b\xc8\xa1\x4b\xf5\x5c\x38\x58\xe7\x14\x03\xb0\x43\x92\xc5\x9c\xf5\x71\xc2\x7b\x16\xc1\x91\x41\x8b\xb7\x42\x9e\x13\x89\x7c\xa0\x50\xa5\x13\xcf\xd7\x23\x36\x16\x4e\xde\x14\xd9\x7e\x8b\x40\x6f\xea\xf6\x85\xee\xc7\x8c\x88\xb9\x5a\x00\xbe\x3f\x22\x6e\x6f\xc6\xc5\x49\x4f\xec\xd3\x78\xba\x04\xda\xbc\xa5\x26\x11\x2f\x0f\xd3\x16\xd8\x7b\xea\xff\x22\x3f\xd1\x05\x7a\xbe\x5f\x43\x85\x5d\x73\x5a\xaf\xb9\x3b\xfc\x41\x6d\xb2\x0d\xf5\x19\x00\x00\xff\xff\xc5\xcb\x88\xa8\x7d\x01\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 381, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa9, 0x6d, 0x77, 0x15, 0x61, 0x5f, 0x22, 0x3d, 0xd7, 0x33, 0xf2, 0xcf, 0xe0, 0xbd, 0x5d, 0xc6, 0xf1, 0x17, 0x84, 0xff, 0x81, 0xdb, 0x33, 0xd0, 0x30, 0x3b, 0xe3, 0x8e, 0x8e, 0x39, 0x8d, 0x48}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/configmap.yaml": assetsDnsConfigmapYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"configmap.yaml":            {assetsDnsConfigmapYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
